/*
 * ForeignKeyPanel.java
 *
 * Created on 20 de agosto de 2002, 17:34
 */

package components.table;
import java.util.*;
import components.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.awt.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class ForeignKeyPanel extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    
    /** Creates a new instance of ForeignKeyPanel */
    public ForeignKeyPanel() {
        data_table = new SQLTable();
        initPanel();
    }
    
    private void initPanel(){
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        SQLTableModel sql_tm = new SQLTableModel(data_table);
        data_table.setModel(sql_tm);
        
        add(new JScrollPane(data_table), BorderLayout.CENTER);
    }
    public void refresh(){
        ((SQLTableModel) data_table.getModel()).setDataSource(getForeignKeyTable());
        repaint();
    }
    public void refresh(Table table_object){
        table = table_object;
        refresh();
    }
    
    public Table getTable(){
        return table;
    }
    
    public void newColumn(){
    }
    public void editColumn(){
    }
    public void deleteColumn(){
    }
    
    public dataSource getForeignKeyTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Name");
        dsve.addColumnName("Ref. Table");
        dsve.addColumnName("Enabled");
        dsve.addColumnName("S.Columns");
        dsve.addColumnName("Ref.Columns");
        dsve.addColumnName("On Update");
        dsve.addColumnName("On Delete");
        dsve.addColumnName("Deferrable");
        dsve.addColumnSize(20);
        dsve.addColumnSize(20);
        dsve.addColumnSize(10);
        dsve.addColumnSize(25);
        dsve.addColumnSize(25);
        dsve.addColumnSize(10);
        dsve.addColumnSize(10);
        dsve.addColumnSize(10);
        
        if(table != null){
            Vector temp = table.getForeignKeys();
            for(int i=0; i<temp.size(); i++){
                TableForeignKey tfk = (TableForeignKey) temp.get(i);
                Vector elem = new Vector();
                elem.add(tfk.getName());
                elem.add(table.getName() + " --> " + tfk.getTableName());
                elem.add(Utilities.formatBoolean(tfk.isEnabled()));
                elem.add(tfk.getSourceColumns());
                elem.add(tfk.getDestColumns());
                elem.add(tfk.getOnUpdate());
                elem.add(tfk.getOnDelete());
                elem.add(Utilities.formatBoolean(tfk.isDeferrable()));
                dsve.addElement(elem);
            }
        }
        return dsve;
    }
}

