<?php // $Revision: 1.2 $

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/




function phpAds_SendMaintenanceReport ($clientid, $first_unixtimestamp, $last_unixtimestamp, $update=true)
{
	global $phpAds_path, $phpAds_language, $date_format, $phpAds_compact_stats;
	global $phpAds_tbl_clients, $phpAds_tbl_banners, $phpAds_tbl_adstats;
	global $phpAds_tbl_adviews, $phpAds_tbl_adclicks;
	
	global $phpAds_admin_fullname, $phpAds_admin_email_headers, $strMailReportPeriodAll;
	global $strMailSubject, $strMailHeader, $strMailBannerStats, $strMailFooter, $strMailReportPeriod;
	global $strLogErrorClients, $strLogErrorBanners, $strLogErrorViews, $strNoStatsForCampaign;
	global $strLogErrorClicks, $strNoClickLoggedInInterval, $strNoViewLoggedInInterval;
	global $strCampaign, $strBanner, $strLinkedTo, $strViews, $strClicks;
	
	global $phpAds_db_link;
	
	// Convert timestamps to SQL format
	$last_sqltimestamp    = "'".date ("Y-m-d H:I:s", $last_unixtimestamp)."'::timestamp";
	$first_sqltimestamp   = "'".date ("Y-m-d H:I:s", $first_unixtimestamp)."'::timestamp";
	
	// Get Client information
	$res_client = db_query("
		SELECT
			clientid,
			clientname,
			contact,
			email,
			language,
			report,
			reportinterval,
			reportlastdate,
			UNIX_TIMESTAMP(reportlastdate) AS reportlastdate_t
		FROM
			$phpAds_tbl_clients
		WHERE
			clientid=".$clientid."
		");
	
	if (@pg_numrows($res_client) > 0)
	{
		$client = @pg_fetch_array($res_client, 0);
		
		// Load client language strings
		if (isset($client["language"]) && $client["language"] != "")
			include ("$phpAds_path/language/".$client["language"].".inc.php");
		else
			include ("$phpAds_path/language/$phpAds_language.inc.php");
		
		// Change date/time formats to match Postgres Syntax
		$date_format = strtr($date_format, array("%d" => "DD", "%m" => "MM", "%Y" => "YYYY"));
		
		$active_campaigns = false;
		$log = "";
		
		// Fetch all campaings belonging to client
		
		$res_campaigns = @db_query("
			SELECT
				clientid,
				clientname,
				views,
				clicks,
				expire,
				UNIX_TIMESTAMP(expire) as expire_st,
				activate,
				UNIX_TIMESTAMP(activate) as activate_st,
				active
			FROM
				$phpAds_tbl_clients
			WHERE
				parent = ".$client['clientid']."
		
		") or die($strLogErrorClients);
		
		for ($pgc = 0; $campaign = @pg_fetch_array($res_campaigns, $pgc); $pgc++)
		{
			// Fetch all banners belonging to campaign
			$res_banners = @db_query("
				SELECT
					bannerid,
					clientid,
					URL,
					active,
					description,
					alt
				FROM
					$phpAds_tbl_banners
				WHERE
					clientid = ".$campaign['clientid']."
				") or die($strLogErrorBanners);
			
			
			$active_banners = false;
		    
			$log .= "\n".$strCampaign."  ".phpAds_buildClientName ($campaign['clientid'], $campaign['clientname'])."\n";
			$log .= "=======================================================\n\n";
			
			for ($pgx = 0; $row_banners = @pg_fetch_array($res_banners, $pgx); $pgx++)
			{
				$adviews = db_total_views($row_banners["bannerid"]);
		        $client["views_used"] = $adviews;
				$adclicks = db_total_clicks($row_banners["bannerid"]);
				$campaign["clicks_used"] = $adclicks;
				
				if ($adviews > 0 || $adclicks > 0)
				{
					$log .= $strBanner."  ".phpAds_buildBannerName ($row_banners['bannerid'], $row_banners['description'], $row_banners['alt'])."\n";
					$log .= $strLinkedTo.": ".$row_banners['url']."\n";
					$log .= "-------------------------------------------------------\n";
					
					$active_banner_stats = false;
					
					if ($adviews > 0)
					{
						$log .= "$strViews (total):   $adviews\n";
						
						// Fetch all adviews belonging to banner belonging to client, grouped by day
						if ($phpAds_compact_stats)

				            $res_adviews = @db_query("
				    			SELECT
				    				SUM(views) as qnt,
				    				DATE_FORMAT(day, '$date_format') as t_stamp_f
								FROM
				    				$phpAds_tbl_adstats
				    			WHERE
				    				bannerid = ".$row_banners['bannerid']." AND
				                    views > 0 AND
									day >= $first_sqltimestamp AND
									day < $last_sqltimestamp
				    			GROUP BY
				    				day
				    			ORDER BY
				    				day DESC
				    			") or die($strLogErrorViews.pg_errormessage($phpAds_db_link));
				        else
				    		$res_adviews = @db_query("
				    			SELECT
				    				count(*) as qnt,
				    				DATE_FORMAT(t_stamp::date, '$date_format') as t_stamp_f,
				    				t_stamp::date AS day
				    			FROM
				    				$phpAds_tbl_adviews
				    			WHERE
				    				bannerid = ".$row_banners['bannerid']." AND
									t_stamp >= $first_sqltimestamp AND
									t_stamp < $last_sqltimestamp
				    			GROUP BY
				    				day
				    			ORDER BY
				    				day DESC
				    			") or die($strLogErrorViews.pg_errormessage($phpAds_db_link));
				        
						if (@pg_numrows($res_adviews))
						{
							for ($pgy = 0; $row_adviews = @pg_fetch_array($res_adviews, $pgy); $pgy++)
								$log .= "      $row_adviews[t_stamp_f]:   $row_adviews[qnt]\n";
							
							$active_banner_stats = true;
						}
						else
						{
							$log .= "      ".$strNoViewLoggedInInterval."\n";
						}
			        }
					
					if ($adclicks > 0)
					{
						// Total adclicks
				        $log .= "\n$strClicks (total):   $adclicks\n";
						
						// Fetch all adclicks belonging to banner belonging to client, grouped by day
						if ($phpAds_compact_stats)
				            $res_adclicks = @db_query("
				    			SELECT
				    				SUM(clicks) as qnt,
				    				DATE_FORMAT(day, '$date_format') as t_stamp_f
				    			FROM
				    				$phpAds_tbl_adstats
				    			WHERE
				    				bannerid = ".$row_banners['bannerid']." AND
				                    clicks > 0 AND
									day >= $first_sqltimestamp AND
									day < $last_sqltimestamp
				    			GROUP BY
				    				day
				    			ORDER BY
				    				day DESC
				    			LIMIT 7
				    			") or die("$strLogErrorClicks ".pg_errormessage($phpAds_db_link));
				        else
				            $res_adclicks = @db_query("
				    			SELECT
				    				count(*) as qnt,
				    				DATE_FORMAT(t_stamp::date, '$date_format') as t_stamp_f,
				    				t_stamp::date AS day
				    			FROM
				    				$phpAds_tbl_adclicks
				    			WHERE
				    				bannerid = ".$row_banners['bannerid']." AND
									t_stamp >= $first_sqltimestamp AND
									t_stamp < $last_sqltimestamp
				    			GROUP BY
				    				day
				    			ORDER BY
				    				day DESC
				    			") or die("$strLogErrorClicks ".pg_errormessage($phpAds_db_link));
						
						if (@pg_numrows($res_adviews))
						{
							for ($pgy = 0; $row_adclicks = @pg_fetch_array($res_adviews, $pgy); $pgy++)
								$log .= "      $row_adclicks[t_stamp_f]:   $row_adclicks[qnt]\n";
							
							$active_banner_stats = true;
						}
						else
						{
							$log .= "      ".$strNoClickLoggedInInterval."\n";
						}
					}
					
					$log .= "\n\n";
					
					if ($active_banner_stats == true || ($active_banner_stats == false && $campaign['active'] == 't'))
						$active_banners = true;
				}
			}
			
			if ($active_banners == true)
			{
				$active_campaigns = true;
			}
			else
			{
				$log .= $strNoStatsForCampaign."\n\n\n";
			}
		}
				
		// E-mail Stats to active clients
		if ($client["email"] != '' && $active_campaigns == true)
		{
			$Subject  = $strMailSubject.": ".$client["clientname"];
			$To		  = $client['email'];
			$Headers  = "To: ".$client['contact']." <".$client['email'].">\n";
			$Headers .= $phpAds_admin_email_headers;
			
			$Body    = "$strMailHeader\n";
			$Body   .= "$strMailBannerStats\n";
			
			if ($first_unixtimestamp == 0)
				$Body   .= "$strMailReportPeriodAll\n\n";
			else
				$Body   .= "$strMailReportPeriod\n\n";
				
			$Body   .= "$log\n";
			$Body   .= "$strMailFooter";
			
			$Body    = str_replace ("{clientname}", 	$client['clientname'], $Body);
			$Body	 = str_replace ("{contact}", 		$client['contact'], $Body);
			$Body    = str_replace ("{adminfullname}", 	$phpAds_admin_fullname, $Body);
			$Body	 = str_replace ("{startdate}", 		date(strtr($date_format, array("YYYY" => "Y", "MM" => "m", "DD" => "d")), $first_unixtimestamp), $Body);
			$Body	 = str_replace ("{enddate}", 		date(strtr($date_format, array("YYYY" => "Y", "MM" => "m", "DD" => "d")), $last_unixtimestamp), $Body);
			
			if (@mail ($To, $Subject, $Body, $Headers))
			{
				// Update last run
				if ($update == true)
					$res_update = db_query("UPDATE $phpAds_tbl_clients SET reportlastdate=NOW() WHERE clientid=".$client['clientid']);
				
				return (true);
			}
		}
	}
	
	return (false);
}