/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.pljava.jdbc.Invocation;
import org.postgresql.pljava.jdbc.SPIAnonymousSavepoint;
import org.postgresql.pljava.jdbc.SPINamedSavepoint;
import org.postgresql.pljava.jdbc.SPIPreparedStatement;
import org.postgresql.pljava.jdbc.SPISavepoint;
import org.postgresql.pljava.jdbc.SPIStatement;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIConnection
implements Connection {
    private static final HashMap s_sqlType2Class = new HashMap(30);

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final void addType(Class clazz, int n) {
        s_sqlType2Class.put(clazz, new Integer(n));
    }

    public static Connection getDefault() throws SQLException {
        return new SPIConnection();
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public int getTransactionIsolation() throws SQLException {
        return 2;
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedFeatureException("Connection.clearWarnings");
    }

    public void close() throws SQLException {
    }

    public void commit() throws SQLException {
        throw new UnsupportedFeatureException("Connection.commit");
    }

    public void rollback() throws SQLException {
        throw new UnsupportedFeatureException("Connection.rollback");
    }

    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    public boolean isClosed() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setHoldability(int n) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setHoldability");
    }

    public void setTransactionIsolation(int n) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setTransactionIsolation");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setAutoCommit");
    }

    public void setReadOnly(boolean bl) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setReadOnly");
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setCatalog(String string) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setCatalog");
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("Connection.getMetaData");
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedFeatureException("Connection.getWarnings");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof SPISavepoint)) {
            throw new IllegalArgumentException("Not an SPISavepoint");
        }
        SPISavepoint sPISavepoint = (SPISavepoint)savepoint;
        sPISavepoint.release();
        SPIConnection.forgetSavepoint(sPISavepoint);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof SPISavepoint)) {
            throw new IllegalArgumentException("Not an SPISavepoint");
        }
        SPISavepoint sPISavepoint = (SPISavepoint)savepoint;
        Invocation.clearErrorCondition();
        sPISavepoint.rollback();
        SPIConnection.forgetSavepoint(sPISavepoint);
    }

    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return new SPIStatement(this);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (n != 1003) {
            throw new UnsupportedOperationException("TYPE_FORWARD_ONLY supported ResultSet type");
        }
        if (n2 != 1007) {
            throw new UnsupportedOperationException("CONCUR_READ_ONLY is the supported ResultSet concurrency");
        }
        return this.createStatement();
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 != 2) {
            throw new UnsupportedOperationException("CLOSE_CURSORS_AT_COMMIT is the only supported ResultSet holdability");
        }
        return this.createStatement(n, n2);
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException("Type map is not yet implemented");
    }

    public String nativeSQL(String string) throws SQLException {
        return this.nativeSQL(string, null);
    }

    public String nativeSQL(String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        int n3 = 1;
        block5: for (int i = 0; i < n; ++i) {
            int n4 = string.charAt(i);
            switch (n4) {
                case 92: {
                    stringBuffer.append((char)n4);
                    if (++i == n) break;
                    n4 = string.charAt(i);
                    break;
                }
                case 34: 
                case 39: {
                    if (n2 == n4) {
                        n2 = 0;
                        break;
                    }
                    n2 = n4;
                    break;
                }
                case 63: {
                    if (n2 != 0) break;
                    stringBuffer.append('$');
                    stringBuffer.append(n3++);
                    continue block5;
                }
                default: {
                    if (n2 != 0 || !Character.isWhitespace((char)n4)) break;
                    ++i;
                    while (i < n && Character.isWhitespace(string.charAt(i))) {
                        ++i;
                    }
                    --i;
                    n4 = 32;
                }
            }
            stringBuffer.append((char)n4);
        }
        if (nArray != null) {
            nArray[0] = n3 - 1;
        }
        return stringBuffer.toString();
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        int[] nArray = new int[]{0};
        string = this.nativeSQL(string, nArray);
        SPIPreparedStatement sPIPreparedStatement = new SPIPreparedStatement(this, string, nArray[0]);
        Invocation.current().manageStatement(sPIPreparedStatement);
        return sPIPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (n != 1003) {
            throw new UnsupportedOperationException("TYPE_FORWARD_ONLY supported ResultSet type");
        }
        if (n2 != 1007) {
            throw new UnsupportedOperationException("CONCUR_READ_ONLY is the supported ResultSet concurrency");
        }
        return this.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 != 2) {
            throw new UnsupportedOperationException("CLOSE_CURSORS_AT_COMMIT is the only supported ResultSet holdability");
        }
        return this.prepareStatement(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.rememberSavepoint(new SPIAnonymousSavepoint());
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return this.rememberSavepoint(new SPINamedSavepoint(string));
    }

    static int getTypeForClass(Class clazz) {
        if (clazz.isArray() && !clazz.equals(SPIConnection.class$("[B"))) {
            return 2003;
        }
        Integer n = (Integer)s_sqlType2Class.get(clazz);
        if (n != null) {
            return n;
        }
        return 1111;
    }

    private Savepoint rememberSavepoint(SPISavepoint sPISavepoint) throws SQLException {
        Invocation invocation = Invocation.current();
        SPISavepoint sPISavepoint2 = invocation.getSavepoint();
        if (sPISavepoint2 == null) {
            invocation.setSavepoint(sPISavepoint);
        }
        return sPISavepoint;
    }

    private static void forgetSavepoint(SPISavepoint sPISavepoint) throws SQLException {
        Invocation invocation = Invocation.current();
        if (invocation.getSavepoint() == sPISavepoint) {
            invocation.setSavepoint(null);
        }
    }

    static {
        SPIConnection.addType(SPIConnection.class$("java.lang.String"), 12);
        SPIConnection.addType(SPIConnection.class$("java.lang.Byte"), -6);
        SPIConnection.addType(SPIConnection.class$("java.lang.Short"), 5);
        SPIConnection.addType(SPIConnection.class$("java.lang.Integer"), 4);
        SPIConnection.addType(SPIConnection.class$("java.lang.Long"), -5);
        SPIConnection.addType(SPIConnection.class$("java.lang.Float"), 6);
        SPIConnection.addType(SPIConnection.class$("java.lang.Double"), 8);
        SPIConnection.addType(SPIConnection.class$("java.math.BigDecimal"), 3);
        SPIConnection.addType(SPIConnection.class$("java.math.BigInteger"), 2);
        SPIConnection.addType(SPIConnection.class$("java.lang.Boolean"), 16);
        SPIConnection.addType(SPIConnection.class$("java.sql.Blob"), 2004);
        SPIConnection.addType(SPIConnection.class$("java.sql.Clob"), 2005);
        SPIConnection.addType(SPIConnection.class$("java.sql.Date"), 91);
        SPIConnection.addType(SPIConnection.class$("java.sql.Time"), 92);
        SPIConnection.addType(SPIConnection.class$("java.sql.Timestamp"), 93);
        SPIConnection.addType(SPIConnection.class$("java.util.Date"), 93);
        SPIConnection.addType(SPIConnection.class$("[B"), -3);
        SPIConnection.addType(SPIConnection.class$("java.util.BitSet"), -7);
        SPIConnection.addType(SPIConnection.class$("java.net.URL"), 70);
    }
}

