/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.postgresql.pljava.internal.Backend;

public class LoggerConfigurator {
    public LoggerConfigurator() {
        Properties properties = new Properties();
        properties.setProperty("handlers", LoggerConfigurator.class$("org.postgresql.pljava.internal.ELogHandler").getName());
        properties.setProperty(".level", LoggerConfigurator.getPgLevel().toString());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, null);
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Level getPgLevel() {
        String string = Backend.getConfigOption("log_min_messages");
        Level level = Level.ALL;
        if (string != null) {
            if ((string = string.toLowerCase().trim()).equals("panic") || string.equals("fatal")) {
                level = Level.OFF;
            } else if (string.equals("error")) {
                level = Level.SEVERE;
            } else if (string.equals("warning")) {
                level = Level.WARNING;
            } else if (string.equals("notice")) {
                level = Level.CONFIG;
            } else if (string.equals("info")) {
                level = Level.INFO;
            } else if (string.equals("debug1")) {
                level = Level.FINE;
            } else if (string.equals("debug2")) {
                level = Level.FINER;
            } else if (string.equals("debug3") || string.equals("debug4") || string.equals("debug5")) {
                level = Level.FINEST;
            }
        }
        return level;
    }
}

