/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.HashMap;
import org.postgresql.pljava.internal.Backend;

public class Oid {
    private static final HashMap s_class2typeId;
    private static final HashMap s_typeId2class;
    private final int m_native;

    public Oid(int n) {
        this.m_native = n;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Oid && ((Oid)object).m_native == this.m_native;
    }

    private static String getCanonicalClassName(String string, int n) {
        if (string.endsWith("[]")) {
            return Oid.getCanonicalClassName(string.substring(0, string.length() - 2), n + 1);
        }
        boolean bl = true;
        if (string.equals("boolean")) {
            string = "Z";
        } else if (string.equals("byte")) {
            string = "B";
        } else if (string.equals("char")) {
            string = "C";
        } else if (string.equals("double")) {
            string = "D";
        } else if (string.equals("float")) {
            string = "F";
        } else if (string.equals("int")) {
            string = "I";
        } else if (string.equals("long")) {
            string = "J";
        } else if (string.equals("short")) {
            string = "S";
        } else {
            bl = false;
        }
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            while (--n >= 0) {
                stringBuffer.append('[');
            }
            if (bl) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append('L');
                stringBuffer.append(string);
                stringBuffer.append(';');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getJavaClass() throws SQLException {
        Class<?> clazz = (Class<?>)s_typeId2class.get(this);
        if (clazz == null) {
            String string;
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                string = this._getJavaClassName();
            }
            try {
                clazz = Class.forName(Oid.getCanonicalClassName(string, 0));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException.getMessage());
            }
            s_typeId2class.put(this, clazz);
            s_class2typeId.put(clazz, this);
        }
        return clazz;
    }

    public int hashCode() {
        return this.m_native;
    }

    public static void registerType(Class clazz, Oid oid) {
        s_class2typeId.put(clazz, oid);
        if (!s_typeId2class.containsKey(oid)) {
            s_typeId2class.put(oid, clazz);
        }
    }

    public static Oid forJavaClass(Class clazz) {
        return (Oid)s_class2typeId.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Oid forSqlType(int n) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Oid._forSqlType(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Oid getTypeId() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Oid._getTypeId();
        }
    }

    public String toString() {
        return "OID(" + this.m_native + ')';
    }

    private static native Oid _forSqlType(int var0);

    private static native Oid _getTypeId();

    private native String _getJavaClassName() throws SQLException;

    static {
        try {
            Class.forName("org.postgresql.pljava.jdbc.SPIDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
        s_class2typeId = new HashMap();
        s_typeId2class = new HashMap();
    }
}

