/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobValue
extends InputStream
implements Blob {
    private final InputStream m_stream;
    private final long m_nBytes;
    private long m_streamPos;
    private long m_markPos;

    public BlobValue(byte[] bytes) {
        this(new ByteArrayInputStream(bytes), bytes.length);
    }

    public BlobValue(InputStream stream, long nBytes) {
        this.m_stream = stream;
        this.m_nBytes = nBytes;
        this.m_streamPos = 0L;
        this.m_markPos = 0L;
    }

    public long length() {
        return this.m_nBytes;
    }

    public InputStream getBinaryStream() {
        return this;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 0L || length < 0) {
            throw new IllegalArgumentException();
        }
        if (length == 0) {
            return new byte[0];
        }
        if (pos + (long)length > this.m_nBytes) {
            throw new SQLException("Attempt to read beyond end of Blob data");
        }
        long skip = pos - this.m_streamPos;
        if (skip < 0L) {
            throw new SQLException("Cannot position Blob stream backwards");
        }
        try {
            if (skip > 0L) {
                this.skip(skip);
            }
            byte[] buf = new byte[length];
            this.read(buf);
            return buf;
        }
        catch (IOException e) {
            throw new SQLException("Error reading Blob data: " + e.getMessage());
        }
    }

    public long position(byte[] pattern, long start) {
        throw new UnsupportedOperationException();
    }

    public long position(Blob pattern, long start) {
        throw new UnsupportedOperationException();
    }

    public OutputStream setBinaryStream(long pos) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public void truncate(long len) {
        throw new UnsupportedOperationException();
    }

    public int available() throws IOException {
        return this.m_stream.available();
    }

    public synchronized void mark(int readLimit) {
        this.m_stream.mark(readLimit);
        this.m_markPos = this.m_streamPos;
    }

    public boolean markSupported() {
        return this.m_stream.markSupported();
    }

    public synchronized int read() throws IOException {
        int rs = this.m_stream.read();
        ++this.m_streamPos;
        return rs;
    }

    public synchronized int read(byte[] b) throws IOException {
        int rs = this.m_stream.read(b);
        this.m_streamPos += (long)rs;
        return rs;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int rs = this.m_stream.read(b, off, len);
        this.m_streamPos += (long)rs;
        return rs;
    }

    public synchronized long skip(long nBytes) throws IOException {
        long skipped = this.m_stream.skip(nBytes);
        this.m_streamPos += skipped;
        return skipped;
    }

    public synchronized void reset() throws IOException {
        this.m_stream.reset();
        this.m_streamPos = this.m_markPos;
    }
}

