/*
 * Decompiled with CFR 0.152.
 */
package org.openbabel;

import org.openbabel.OBAtom;
import org.openbabel.OBBase;
import org.openbabel.OBBitVec;
import org.openbabel.OBBond;
import org.openbabel.OBInternalCoord;
import org.openbabel.OBMolAtomDFSIter;
import org.openbabel.OBResidue;
import org.openbabel.SWIGTYPE_p_a_3__double;
import org.openbabel.SWIGTYPE_p_double;
import org.openbabel.SWIGTYPE_p_std__string;
import org.openbabel.SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t;
import org.openbabel.SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator;
import org.openbabel.SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator;
import org.openbabel.SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t;
import org.openbabel.SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator;
import org.openbabel.SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator;
import org.openbabel.SWIGTYPE_p_std__vectorT_double_p_t;
import org.openbabel.SWIGTYPE_p_std__vectorT_double_p_t__iterator;
import org.openbabel.openbabel_javaJNI;
import org.openbabel.vector3;
import org.openbabel.vectorDouble;
import org.openbabel.vectorInt;
import org.openbabel.vectorMol;
import org.openbabel.vectorUnsignedInt;
import org.openbabel.vectorpRing;
import org.openbabel.vvInt;

public class OBMol
extends OBBase {
    private long swigCPtr;

    protected OBMol(long l, boolean bl) {
        super(openbabel_javaJNI.SWIGOBMolUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(OBMol oBMol) {
        return oBMol == null ? 0L : oBMol.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            openbabel_javaJNI.delete_OBMol(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public OBMol() {
        this(openbabel_javaJNI.new_OBMol__SWIG_0(), true);
    }

    public OBMol(OBMol oBMol) {
        this(openbabel_javaJNI.new_OBMol__SWIG_1(OBMol.getCPtr(oBMol), oBMol), true);
    }

    public void ReserveAtoms(int n) {
        openbabel_javaJNI.OBMol_ReserveAtoms(this.swigCPtr, this, n);
    }

    public OBAtom CreateAtom() {
        long l = openbabel_javaJNI.OBMol_CreateAtom(this.swigCPtr, this);
        return l == 0L ? null : new OBAtom(l, false);
    }

    public OBBond CreateBond() {
        long l = openbabel_javaJNI.OBMol_CreateBond(this.swigCPtr, this);
        return l == 0L ? null : new OBBond(l, false);
    }

    public OBResidue CreateResidue() {
        long l = openbabel_javaJNI.OBMol_CreateResidue(this.swigCPtr, this);
        return l == 0L ? null : new OBResidue(l, false);
    }

    public void DestroyAtom(OBAtom oBAtom) {
        openbabel_javaJNI.OBMol_DestroyAtom(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom);
    }

    public void DestroyBond(OBBond oBBond) {
        openbabel_javaJNI.OBMol_DestroyBond(this.swigCPtr, this, OBBond.getCPtr(oBBond), oBBond);
    }

    public void DestroyResidue(OBResidue oBResidue) {
        openbabel_javaJNI.OBMol_DestroyResidue(this.swigCPtr, this, OBResidue.getCPtr(oBResidue), oBResidue);
    }

    public boolean AddAtom(OBAtom oBAtom) {
        return openbabel_javaJNI.OBMol_AddAtom(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom);
    }

    public boolean InsertAtom(OBAtom oBAtom) {
        return openbabel_javaJNI.OBMol_InsertAtom(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom);
    }

    public boolean AddBond(int n, int n2, int n3, int n4, int n5) {
        return openbabel_javaJNI.OBMol_AddBond__SWIG_0(this.swigCPtr, this, n, n2, n3, n4, n5);
    }

    public boolean AddBond(int n, int n2, int n3, int n4) {
        return openbabel_javaJNI.OBMol_AddBond__SWIG_1(this.swigCPtr, this, n, n2, n3, n4);
    }

    public boolean AddBond(int n, int n2, int n3) {
        return openbabel_javaJNI.OBMol_AddBond__SWIG_2(this.swigCPtr, this, n, n2, n3);
    }

    public boolean AddBond(OBBond oBBond) {
        return openbabel_javaJNI.OBMol_AddBond__SWIG_3(this.swigCPtr, this, OBBond.getCPtr(oBBond), oBBond);
    }

    public boolean AddResidue(OBResidue oBResidue) {
        return openbabel_javaJNI.OBMol_AddResidue(this.swigCPtr, this, OBResidue.getCPtr(oBResidue), oBResidue);
    }

    public OBAtom NewAtom() {
        long l = openbabel_javaJNI.OBMol_NewAtom(this.swigCPtr, this);
        return l == 0L ? null : new OBAtom(l, false);
    }

    public OBBond NewBond() {
        long l = openbabel_javaJNI.OBMol_NewBond(this.swigCPtr, this);
        return l == 0L ? null : new OBBond(l, false);
    }

    public OBResidue NewResidue() {
        long l = openbabel_javaJNI.OBMol_NewResidue(this.swigCPtr, this);
        return l == 0L ? null : new OBResidue(l, false);
    }

    public boolean DeleteAtom(OBAtom oBAtom, boolean bl) {
        return openbabel_javaJNI.OBMol_DeleteAtom__SWIG_0(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom, bl);
    }

    public boolean DeleteAtom(OBAtom oBAtom) {
        return openbabel_javaJNI.OBMol_DeleteAtom__SWIG_1(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom);
    }

    public boolean DeleteBond(OBBond oBBond, boolean bl) {
        return openbabel_javaJNI.OBMol_DeleteBond__SWIG_0(this.swigCPtr, this, OBBond.getCPtr(oBBond), oBBond, bl);
    }

    public boolean DeleteBond(OBBond oBBond) {
        return openbabel_javaJNI.OBMol_DeleteBond__SWIG_1(this.swigCPtr, this, OBBond.getCPtr(oBBond), oBBond);
    }

    public boolean DeleteResidue(OBResidue oBResidue, boolean bl) {
        return openbabel_javaJNI.OBMol_DeleteResidue__SWIG_0(this.swigCPtr, this, OBResidue.getCPtr(oBResidue), oBResidue, bl);
    }

    public boolean DeleteResidue(OBResidue oBResidue) {
        return openbabel_javaJNI.OBMol_DeleteResidue__SWIG_1(this.swigCPtr, this, OBResidue.getCPtr(oBResidue), oBResidue);
    }

    public void BeginModify() {
        openbabel_javaJNI.OBMol_BeginModify(this.swigCPtr, this);
    }

    public void EndModify(boolean bl) {
        openbabel_javaJNI.OBMol_EndModify__SWIG_0(this.swigCPtr, this, bl);
    }

    public void EndModify() {
        openbabel_javaJNI.OBMol_EndModify__SWIG_1(this.swigCPtr, this);
    }

    public int GetMod() {
        return openbabel_javaJNI.OBMol_GetMod(this.swigCPtr, this);
    }

    public void IncrementMod() {
        openbabel_javaJNI.OBMol_IncrementMod(this.swigCPtr, this);
    }

    public void DecrementMod() {
        openbabel_javaJNI.OBMol_DecrementMod(this.swigCPtr, this);
    }

    public int GetFlags() {
        return openbabel_javaJNI.OBMol_GetFlags(this.swigCPtr, this);
    }

    public String GetTitle(boolean bl) {
        return openbabel_javaJNI.OBMol_GetTitle__SWIG_0(this.swigCPtr, this, bl);
    }

    public String GetTitle() {
        return openbabel_javaJNI.OBMol_GetTitle__SWIG_1(this.swigCPtr, this);
    }

    public long NumAtoms() {
        return openbabel_javaJNI.OBMol_NumAtoms(this.swigCPtr, this);
    }

    public long NumBonds() {
        return openbabel_javaJNI.OBMol_NumBonds(this.swigCPtr, this);
    }

    public long NumHvyAtoms() {
        return openbabel_javaJNI.OBMol_NumHvyAtoms(this.swigCPtr, this);
    }

    public long NumResidues() {
        return openbabel_javaJNI.OBMol_NumResidues(this.swigCPtr, this);
    }

    public long NumRotors() {
        return openbabel_javaJNI.OBMol_NumRotors(this.swigCPtr, this);
    }

    public OBAtom GetAtom(int n) {
        long l = openbabel_javaJNI.OBMol_GetAtom(this.swigCPtr, this, n);
        return l == 0L ? null : new OBAtom(l, false);
    }

    public OBAtom GetFirstAtom() {
        long l = openbabel_javaJNI.OBMol_GetFirstAtom(this.swigCPtr, this);
        return l == 0L ? null : new OBAtom(l, false);
    }

    public OBBond GetBond(int n) {
        long l = openbabel_javaJNI.OBMol_GetBond__SWIG_0(this.swigCPtr, this, n);
        return l == 0L ? null : new OBBond(l, false);
    }

    public OBBond GetBond(int n, int n2) {
        long l = openbabel_javaJNI.OBMol_GetBond__SWIG_1(this.swigCPtr, this, n, n2);
        return l == 0L ? null : new OBBond(l, false);
    }

    public OBBond GetBond(OBAtom oBAtom, OBAtom oBAtom2) {
        long l = openbabel_javaJNI.OBMol_GetBond__SWIG_2(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom, OBAtom.getCPtr(oBAtom2), oBAtom2);
        return l == 0L ? null : new OBBond(l, false);
    }

    public OBResidue GetResidue(int n) {
        long l = openbabel_javaJNI.OBMol_GetResidue(this.swigCPtr, this, n);
        return l == 0L ? null : new OBResidue(l, false);
    }

    public SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t GetInternalCoord() {
        return new SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t(openbabel_javaJNI.OBMol_GetInternalCoord(this.swigCPtr, this), true);
    }

    public double GetTorsion(int n, int n2, int n3, int n4) {
        return openbabel_javaJNI.OBMol_GetTorsion__SWIG_0(this.swigCPtr, this, n, n2, n3, n4);
    }

    public double GetTorsion(OBAtom oBAtom, OBAtom oBAtom2, OBAtom oBAtom3, OBAtom oBAtom4) {
        return openbabel_javaJNI.OBMol_GetTorsion__SWIG_1(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom, OBAtom.getCPtr(oBAtom2), oBAtom2, OBAtom.getCPtr(oBAtom3), oBAtom3, OBAtom.getCPtr(oBAtom4), oBAtom4);
    }

    public double GetAngle(OBAtom oBAtom, OBAtom oBAtom2, OBAtom oBAtom3) {
        return openbabel_javaJNI.OBMol_GetAngle(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom, OBAtom.getCPtr(oBAtom2), oBAtom2, OBAtom.getCPtr(oBAtom3), oBAtom3);
    }

    public String GetFormula() {
        return openbabel_javaJNI.OBMol_GetFormula(this.swigCPtr, this);
    }

    public String GetSpacedFormula(int n, String string, boolean bl) {
        return openbabel_javaJNI.OBMol_GetSpacedFormula__SWIG_0(this.swigCPtr, this, n, string, bl);
    }

    public String GetSpacedFormula(int n, String string) {
        return openbabel_javaJNI.OBMol_GetSpacedFormula__SWIG_1(this.swigCPtr, this, n, string);
    }

    public String GetSpacedFormula(int n) {
        return openbabel_javaJNI.OBMol_GetSpacedFormula__SWIG_2(this.swigCPtr, this, n);
    }

    public String GetSpacedFormula() {
        return openbabel_javaJNI.OBMol_GetSpacedFormula__SWIG_3(this.swigCPtr, this);
    }

    public double GetEnergy() {
        return openbabel_javaJNI.OBMol_GetEnergy__SWIG_0(this.swigCPtr, this);
    }

    public double GetMolWt(boolean bl) {
        return openbabel_javaJNI.OBMol_GetMolWt__SWIG_0(this.swigCPtr, this, bl);
    }

    public double GetMolWt() {
        return openbabel_javaJNI.OBMol_GetMolWt__SWIG_1(this.swigCPtr, this);
    }

    public double GetExactMass(boolean bl) {
        return openbabel_javaJNI.OBMol_GetExactMass__SWIG_0(this.swigCPtr, this, bl);
    }

    public double GetExactMass() {
        return openbabel_javaJNI.OBMol_GetExactMass__SWIG_1(this.swigCPtr, this);
    }

    public int GetTotalCharge() {
        return openbabel_javaJNI.OBMol_GetTotalCharge(this.swigCPtr, this);
    }

    public long GetTotalSpinMultiplicity() {
        return openbabel_javaJNI.OBMol_GetTotalSpinMultiplicity(this.swigCPtr, this);
    }

    public int GetDimension() {
        return openbabel_javaJNI.OBMol_GetDimension(this.swigCPtr, this);
    }

    public SWIGTYPE_p_double GetCoordinates() {
        long l = openbabel_javaJNI.OBMol_GetCoordinates(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_double(l, false);
    }

    public vectorpRing GetSSSR() {
        return new vectorpRing(openbabel_javaJNI.OBMol_GetSSSR(this.swigCPtr, this), false);
    }

    public boolean AutomaticFormalCharge() {
        return openbabel_javaJNI.OBMol_AutomaticFormalCharge(this.swigCPtr, this);
    }

    public boolean AutomaticPartialCharge() {
        return openbabel_javaJNI.OBMol_AutomaticPartialCharge(this.swigCPtr, this);
    }

    public void SetTitle(String string) {
        openbabel_javaJNI.OBMol_SetTitle__SWIG_0(this.swigCPtr, this, string);
    }

    public void SetTitle(SWIGTYPE_p_std__string sWIGTYPE_p_std__string) {
        openbabel_javaJNI.OBMol_SetTitle__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_std__string.getCPtr(sWIGTYPE_p_std__string));
    }

    public void SetFormula(String string) {
        openbabel_javaJNI.OBMol_SetFormula(this.swigCPtr, this, string);
    }

    public void SetEnergy(double d) {
        openbabel_javaJNI.OBMol_SetEnergy(this.swigCPtr, this, d);
    }

    public void SetDimension(int n) {
        openbabel_javaJNI.OBMol_SetDimension(this.swigCPtr, this, n);
    }

    public void SetTotalCharge(int n) {
        openbabel_javaJNI.OBMol_SetTotalCharge(this.swigCPtr, this, n);
    }

    public void SetTotalSpinMultiplicity(long l) {
        openbabel_javaJNI.OBMol_SetTotalSpinMultiplicity(this.swigCPtr, this, l);
    }

    public void SetInternalCoord(SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t sWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t) {
        openbabel_javaJNI.OBMol_SetInternalCoord(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t));
    }

    public void SetAutomaticFormalCharge(boolean bl) {
        openbabel_javaJNI.OBMol_SetAutomaticFormalCharge(this.swigCPtr, this, bl);
    }

    public void SetAutomaticPartialCharge(boolean bl) {
        openbabel_javaJNI.OBMol_SetAutomaticPartialCharge(this.swigCPtr, this, bl);
    }

    public void SetAromaticPerceived() {
        openbabel_javaJNI.OBMol_SetAromaticPerceived(this.swigCPtr, this);
    }

    public void SetSSSRPerceived() {
        openbabel_javaJNI.OBMol_SetSSSRPerceived(this.swigCPtr, this);
    }

    public void SetRingAtomsAndBondsPerceived() {
        openbabel_javaJNI.OBMol_SetRingAtomsAndBondsPerceived(this.swigCPtr, this);
    }

    public void SetAtomTypesPerceived() {
        openbabel_javaJNI.OBMol_SetAtomTypesPerceived(this.swigCPtr, this);
    }

    public void SetRingTypesPerceived() {
        openbabel_javaJNI.OBMol_SetRingTypesPerceived(this.swigCPtr, this);
    }

    public void SetChainsPerceived() {
        openbabel_javaJNI.OBMol_SetChainsPerceived(this.swigCPtr, this);
    }

    public void SetChiralityPerceived() {
        openbabel_javaJNI.OBMol_SetChiralityPerceived(this.swigCPtr, this);
    }

    public void SetPartialChargesPerceived() {
        openbabel_javaJNI.OBMol_SetPartialChargesPerceived(this.swigCPtr, this);
    }

    public void SetHybridizationPerceived() {
        openbabel_javaJNI.OBMol_SetHybridizationPerceived(this.swigCPtr, this);
    }

    public void SetImplicitValencePerceived() {
        openbabel_javaJNI.OBMol_SetImplicitValencePerceived(this.swigCPtr, this);
    }

    public void SetKekulePerceived() {
        openbabel_javaJNI.OBMol_SetKekulePerceived(this.swigCPtr, this);
    }

    public void SetClosureBondsPerceived() {
        openbabel_javaJNI.OBMol_SetClosureBondsPerceived(this.swigCPtr, this);
    }

    public void SetHydrogensAdded() {
        openbabel_javaJNI.OBMol_SetHydrogensAdded(this.swigCPtr, this);
    }

    public void SetCorrectedForPH() {
        openbabel_javaJNI.OBMol_SetCorrectedForPH(this.swigCPtr, this);
    }

    public void SetAromaticCorrected() {
        openbabel_javaJNI.OBMol_SetAromaticCorrected(this.swigCPtr, this);
    }

    public void SetSpinMultiplicityAssigned() {
        openbabel_javaJNI.OBMol_SetSpinMultiplicityAssigned(this.swigCPtr, this);
    }

    public void SetFlags(int n) {
        openbabel_javaJNI.OBMol_SetFlags(this.swigCPtr, this, n);
    }

    public void UnsetAromaticPerceived() {
        openbabel_javaJNI.OBMol_UnsetAromaticPerceived(this.swigCPtr, this);
    }

    public void UnsetSSSRPerceived() {
        openbabel_javaJNI.OBMol_UnsetSSSRPerceived(this.swigCPtr, this);
    }

    public void UnsetRingTypesPerceived() {
        openbabel_javaJNI.OBMol_UnsetRingTypesPerceived(this.swigCPtr, this);
    }

    public void UnsetPartialChargesPerceived() {
        openbabel_javaJNI.OBMol_UnsetPartialChargesPerceived(this.swigCPtr, this);
    }

    public void UnsetImplicitValencePerceived() {
        openbabel_javaJNI.OBMol_UnsetImplicitValencePerceived(this.swigCPtr, this);
    }

    public void UnsetHydrogensAdded() {
        openbabel_javaJNI.OBMol_UnsetHydrogensAdded(this.swigCPtr, this);
    }

    public void UnsetFlag(int n) {
        openbabel_javaJNI.OBMol_UnsetFlag(this.swigCPtr, this, n);
    }

    public static String ClassDescription() {
        return openbabel_javaJNI.OBMol_ClassDescription();
    }

    public void RenumberAtoms(SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t sWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t) {
        openbabel_javaJNI.OBMol_RenumberAtoms(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t));
    }

    public void SetCoordinates(SWIGTYPE_p_double sWIGTYPE_p_double) {
        openbabel_javaJNI.OBMol_SetCoordinates(this.swigCPtr, this, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double));
    }

    public void ToInertialFrame(int n, SWIGTYPE_p_double sWIGTYPE_p_double) {
        openbabel_javaJNI.OBMol_ToInertialFrame__SWIG_0(this.swigCPtr, this, n, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double));
    }

    public void ToInertialFrame() {
        openbabel_javaJNI.OBMol_ToInertialFrame__SWIG_1(this.swigCPtr, this);
    }

    public void Translate(vector3 vector32) {
        openbabel_javaJNI.OBMol_Translate__SWIG_0(this.swigCPtr, this, vector3.getCPtr(vector32), vector32);
    }

    public void Translate(vector3 vector32, int n) {
        openbabel_javaJNI.OBMol_Translate__SWIG_1(this.swigCPtr, this, vector3.getCPtr(vector32), vector32, n);
    }

    public void Rotate(SWIGTYPE_p_a_3__double sWIGTYPE_p_a_3__double) {
        openbabel_javaJNI.OBMol_Rotate__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_a_3__double.getCPtr(sWIGTYPE_p_a_3__double));
    }

    public void Rotate(SWIGTYPE_p_double sWIGTYPE_p_double) {
        openbabel_javaJNI.OBMol_Rotate__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double));
    }

    public void Rotate(SWIGTYPE_p_double sWIGTYPE_p_double, int n) {
        openbabel_javaJNI.OBMol_Rotate__SWIG_2(this.swigCPtr, this, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double), n);
    }

    public void Center() {
        openbabel_javaJNI.OBMol_Center__SWIG_0(this.swigCPtr, this);
    }

    public boolean Kekulize() {
        return openbabel_javaJNI.OBMol_Kekulize(this.swigCPtr, this);
    }

    public boolean PerceiveKekuleBonds() {
        return openbabel_javaJNI.OBMol_PerceiveKekuleBonds(this.swigCPtr, this);
    }

    public void NewPerceiveKekuleBonds() {
        openbabel_javaJNI.OBMol_NewPerceiveKekuleBonds(this.swigCPtr, this);
    }

    public boolean DeleteHydrogens() {
        return openbabel_javaJNI.OBMol_DeleteHydrogens__SWIG_0(this.swigCPtr, this);
    }

    public boolean DeleteHydrogens(OBAtom oBAtom) {
        return openbabel_javaJNI.OBMol_DeleteHydrogens__SWIG_1(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom);
    }

    public boolean DeleteNonPolarHydrogens() {
        return openbabel_javaJNI.OBMol_DeleteNonPolarHydrogens(this.swigCPtr, this);
    }

    public boolean DeleteHydrogen(OBAtom oBAtom) {
        return openbabel_javaJNI.OBMol_DeleteHydrogen(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom);
    }

    public boolean AddHydrogens(boolean bl, boolean bl2, double d) {
        return openbabel_javaJNI.OBMol_AddHydrogens__SWIG_0(this.swigCPtr, this, bl, bl2, d);
    }

    public boolean AddHydrogens(boolean bl, boolean bl2) {
        return openbabel_javaJNI.OBMol_AddHydrogens__SWIG_1(this.swigCPtr, this, bl, bl2);
    }

    public boolean AddHydrogens(boolean bl) {
        return openbabel_javaJNI.OBMol_AddHydrogens__SWIG_2(this.swigCPtr, this, bl);
    }

    public boolean AddHydrogens() {
        return openbabel_javaJNI.OBMol_AddHydrogens__SWIG_3(this.swigCPtr, this);
    }

    public boolean AddHydrogens(OBAtom oBAtom) {
        return openbabel_javaJNI.OBMol_AddHydrogens__SWIG_4(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom);
    }

    public boolean AddPolarHydrogens() {
        return openbabel_javaJNI.OBMol_AddPolarHydrogens(this.swigCPtr, this);
    }

    public boolean StripSalts(int n) {
        return openbabel_javaJNI.OBMol_StripSalts(this.swigCPtr, this, n);
    }

    public vectorMol Separate(int n) {
        return new vectorMol(openbabel_javaJNI.OBMol_Separate__SWIG_0(this.swigCPtr, this, n), true);
    }

    public vectorMol Separate() {
        return new vectorMol(openbabel_javaJNI.OBMol_Separate__SWIG_1(this.swigCPtr, this), true);
    }

    public boolean GetNextFragment(OBMolAtomDFSIter oBMolAtomDFSIter, OBMol oBMol) {
        return openbabel_javaJNI.OBMol_GetNextFragment(this.swigCPtr, this, OBMolAtomDFSIter.getCPtr(oBMolAtomDFSIter), oBMolAtomDFSIter, OBMol.getCPtr(oBMol), oBMol);
    }

    public boolean ConvertDativeBonds() {
        return openbabel_javaJNI.OBMol_ConvertDativeBonds(this.swigCPtr, this);
    }

    public boolean CorrectForPH(double d) {
        return openbabel_javaJNI.OBMol_CorrectForPH__SWIG_0(this.swigCPtr, this, d);
    }

    public boolean CorrectForPH() {
        return openbabel_javaJNI.OBMol_CorrectForPH__SWIG_1(this.swigCPtr, this);
    }

    public boolean AssignSpinMultiplicity(boolean bl) {
        return openbabel_javaJNI.OBMol_AssignSpinMultiplicity__SWIG_0(this.swigCPtr, this, bl);
    }

    public boolean AssignSpinMultiplicity() {
        return openbabel_javaJNI.OBMol_AssignSpinMultiplicity__SWIG_1(this.swigCPtr, this);
    }

    public vector3 Center(int n) {
        return new vector3(openbabel_javaJNI.OBMol_Center__SWIG_1(this.swigCPtr, this, n), true);
    }

    public void SetTorsion(OBAtom oBAtom, OBAtom oBAtom2, OBAtom oBAtom3, OBAtom oBAtom4, double d) {
        openbabel_javaJNI.OBMol_SetTorsion(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom, OBAtom.getCPtr(oBAtom2), oBAtom2, OBAtom.getCPtr(oBAtom3), oBAtom3, OBAtom.getCPtr(oBAtom4), oBAtom4, d);
    }

    public void FindSSSR() {
        openbabel_javaJNI.OBMol_FindSSSR(this.swigCPtr, this);
    }

    public void FindRingAtomsAndBonds() {
        openbabel_javaJNI.OBMol_FindRingAtomsAndBonds(this.swigCPtr, this);
    }

    public void FindChiralCenters() {
        openbabel_javaJNI.OBMol_FindChiralCenters(this.swigCPtr, this);
    }

    public void FindChildren(vectorInt vectorInt2, int n, int n2) {
        openbabel_javaJNI.OBMol_FindChildren__SWIG_0(this.swigCPtr, this, vectorInt.getCPtr(vectorInt2), vectorInt2, n, n2);
    }

    public void FindChildren(SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t sWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t, OBAtom oBAtom, OBAtom oBAtom2) {
        openbabel_javaJNI.OBMol_FindChildren__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t), OBAtom.getCPtr(oBAtom), oBAtom, OBAtom.getCPtr(oBAtom2), oBAtom2);
    }

    public void FindLargestFragment(OBBitVec oBBitVec) {
        openbabel_javaJNI.OBMol_FindLargestFragment(this.swigCPtr, this, OBBitVec.getCPtr(oBBitVec), oBBitVec);
    }

    public void ContigFragList(vvInt vvInt2) {
        openbabel_javaJNI.OBMol_ContigFragList(this.swigCPtr, this, vvInt.getCPtr(vvInt2), vvInt2);
    }

    public void Align(OBAtom oBAtom, OBAtom oBAtom2, vector3 vector32, vector3 vector33) {
        openbabel_javaJNI.OBMol_Align(this.swigCPtr, this, OBAtom.getCPtr(oBAtom), oBAtom, OBAtom.getCPtr(oBAtom2), oBAtom2, vector3.getCPtr(vector32), vector32, vector3.getCPtr(vector33), vector33);
    }

    public void ConnectTheDots() {
        openbabel_javaJNI.OBMol_ConnectTheDots(this.swigCPtr, this);
    }

    public void PerceiveBondOrders() {
        openbabel_javaJNI.OBMol_PerceiveBondOrders(this.swigCPtr, this);
    }

    public void FindAngles() {
        openbabel_javaJNI.OBMol_FindAngles(this.swigCPtr, this);
    }

    public void FindTorsions() {
        openbabel_javaJNI.OBMol_FindTorsions(this.swigCPtr, this);
    }

    public boolean GetGTDVector(vectorInt vectorInt2) {
        return openbabel_javaJNI.OBMol_GetGTDVector(this.swigCPtr, this, vectorInt.getCPtr(vectorInt2), vectorInt2);
    }

    public void GetGIVector(vectorUnsignedInt vectorUnsignedInt2) {
        openbabel_javaJNI.OBMol_GetGIVector(this.swigCPtr, this, vectorUnsignedInt.getCPtr(vectorUnsignedInt2), vectorUnsignedInt2);
    }

    public void GetGIDVector(vectorUnsignedInt vectorUnsignedInt2) {
        openbabel_javaJNI.OBMol_GetGIDVector(this.swigCPtr, this, vectorUnsignedInt.getCPtr(vectorUnsignedInt2), vectorUnsignedInt2);
    }

    public boolean Has2D() {
        return openbabel_javaJNI.OBMol_Has2D(this.swigCPtr, this);
    }

    public boolean Has3D() {
        return openbabel_javaJNI.OBMol_Has3D(this.swigCPtr, this);
    }

    public boolean HasNonZeroCoords() {
        return openbabel_javaJNI.OBMol_HasNonZeroCoords(this.swigCPtr, this);
    }

    public boolean HasAromaticPerceived() {
        return openbabel_javaJNI.OBMol_HasAromaticPerceived(this.swigCPtr, this);
    }

    public boolean HasSSSRPerceived() {
        return openbabel_javaJNI.OBMol_HasSSSRPerceived(this.swigCPtr, this);
    }

    public boolean HasRingAtomsAndBondsPerceived() {
        return openbabel_javaJNI.OBMol_HasRingAtomsAndBondsPerceived(this.swigCPtr, this);
    }

    public boolean HasAtomTypesPerceived() {
        return openbabel_javaJNI.OBMol_HasAtomTypesPerceived(this.swigCPtr, this);
    }

    public boolean HasRingTypesPerceived() {
        return openbabel_javaJNI.OBMol_HasRingTypesPerceived(this.swigCPtr, this);
    }

    public boolean HasChiralityPerceived() {
        return openbabel_javaJNI.OBMol_HasChiralityPerceived(this.swigCPtr, this);
    }

    public boolean HasPartialChargesPerceived() {
        return openbabel_javaJNI.OBMol_HasPartialChargesPerceived(this.swigCPtr, this);
    }

    public boolean HasHybridizationPerceived() {
        return openbabel_javaJNI.OBMol_HasHybridizationPerceived(this.swigCPtr, this);
    }

    public boolean HasImplicitValencePerceived() {
        return openbabel_javaJNI.OBMol_HasImplicitValencePerceived(this.swigCPtr, this);
    }

    public boolean HasKekulePerceived() {
        return openbabel_javaJNI.OBMol_HasKekulePerceived(this.swigCPtr, this);
    }

    public boolean HasClosureBondsPerceived() {
        return openbabel_javaJNI.OBMol_HasClosureBondsPerceived(this.swigCPtr, this);
    }

    public boolean HasChainsPerceived() {
        return openbabel_javaJNI.OBMol_HasChainsPerceived(this.swigCPtr, this);
    }

    public boolean HasHydrogensAdded() {
        return openbabel_javaJNI.OBMol_HasHydrogensAdded(this.swigCPtr, this);
    }

    public boolean HasAromaticCorrected() {
        return openbabel_javaJNI.OBMol_HasAromaticCorrected(this.swigCPtr, this);
    }

    public boolean IsCorrectedForPH() {
        return openbabel_javaJNI.OBMol_IsCorrectedForPH(this.swigCPtr, this);
    }

    public boolean HasSpinMultiplicityAssigned() {
        return openbabel_javaJNI.OBMol_HasSpinMultiplicityAssigned(this.swigCPtr, this);
    }

    public boolean IsChiral() {
        return openbabel_javaJNI.OBMol_IsChiral(this.swigCPtr, this);
    }

    public boolean Empty() {
        return openbabel_javaJNI.OBMol_Empty(this.swigCPtr, this);
    }

    public int NumConformers() {
        return openbabel_javaJNI.OBMol_NumConformers(this.swigCPtr, this);
    }

    public void SetConformers(SWIGTYPE_p_std__vectorT_double_p_t sWIGTYPE_p_std__vectorT_double_p_t) {
        openbabel_javaJNI.OBMol_SetConformers(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_double_p_t.getCPtr(sWIGTYPE_p_std__vectorT_double_p_t));
    }

    public void AddConformer(SWIGTYPE_p_double sWIGTYPE_p_double) {
        openbabel_javaJNI.OBMol_AddConformer(this.swigCPtr, this, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double));
    }

    public void SetConformer(int n) {
        openbabel_javaJNI.OBMol_SetConformer(this.swigCPtr, this, n);
    }

    public void CopyConformer(SWIGTYPE_p_double sWIGTYPE_p_double, int n) {
        openbabel_javaJNI.OBMol_CopyConformer(this.swigCPtr, this, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double), n);
    }

    public void DeleteConformer(int n) {
        openbabel_javaJNI.OBMol_DeleteConformer(this.swigCPtr, this, n);
    }

    public SWIGTYPE_p_double GetConformer(int n) {
        long l = openbabel_javaJNI.OBMol_GetConformer(this.swigCPtr, this, n);
        return l == 0L ? null : new SWIGTYPE_p_double(l, false);
    }

    public void SetEnergies(vectorDouble vectorDouble2) {
        openbabel_javaJNI.OBMol_SetEnergies(this.swigCPtr, this, vectorDouble.getCPtr(vectorDouble2), vectorDouble2);
    }

    public vectorDouble GetEnergies() {
        return new vectorDouble(openbabel_javaJNI.OBMol_GetEnergies(this.swigCPtr, this), true);
    }

    public double GetEnergy(int n) {
        return openbabel_javaJNI.OBMol_GetEnergy__SWIG_1(this.swigCPtr, this, n);
    }

    public SWIGTYPE_p_double BeginConformer(SWIGTYPE_p_std__vectorT_double_p_t__iterator sWIGTYPE_p_std__vectorT_double_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_BeginConformer(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_double_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_double_p_t__iterator));
        return l == 0L ? null : new SWIGTYPE_p_double(l, false);
    }

    public SWIGTYPE_p_double NextConformer(SWIGTYPE_p_std__vectorT_double_p_t__iterator sWIGTYPE_p_std__vectorT_double_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_NextConformer(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_double_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_double_p_t__iterator));
        return l == 0L ? null : new SWIGTYPE_p_double(l, false);
    }

    public SWIGTYPE_p_std__vectorT_double_p_t GetConformers() {
        return new SWIGTYPE_p_std__vectorT_double_p_t(openbabel_javaJNI.OBMol_GetConformers(this.swigCPtr, this), false);
    }

    public SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator BeginAtoms() {
        return new SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator(openbabel_javaJNI.OBMol_BeginAtoms(this.swigCPtr, this), true);
    }

    public SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator EndAtoms() {
        return new SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator(openbabel_javaJNI.OBMol_EndAtoms(this.swigCPtr, this), true);
    }

    public SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator BeginBonds() {
        return new SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator(openbabel_javaJNI.OBMol_BeginBonds(this.swigCPtr, this), true);
    }

    public SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator EndBonds() {
        return new SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator(openbabel_javaJNI.OBMol_EndBonds(this.swigCPtr, this), true);
    }

    public SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator BeginResidues() {
        return new SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator(openbabel_javaJNI.OBMol_BeginResidues(this.swigCPtr, this), true);
    }

    public SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator EndResidues() {
        return new SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator(openbabel_javaJNI.OBMol_EndResidues(this.swigCPtr, this), true);
    }

    public OBAtom BeginAtom(SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator sWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_BeginAtom(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator));
        return l == 0L ? null : new OBAtom(l, false);
    }

    public OBAtom NextAtom(SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator sWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_NextAtom(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBAtom_p_t__iterator));
        return l == 0L ? null : new OBAtom(l, false);
    }

    public OBBond BeginBond(SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator sWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_BeginBond(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator));
        return l == 0L ? null : new OBBond(l, false);
    }

    public OBBond NextBond(SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator sWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_NextBond(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBBond_p_t__iterator));
        return l == 0L ? null : new OBBond(l, false);
    }

    public OBResidue BeginResidue(SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator sWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_BeginResidue(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator));
        return l == 0L ? null : new OBResidue(l, false);
    }

    public OBResidue NextResidue(SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator sWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_NextResidue(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBResidue_p_t__iterator));
        return l == 0L ? null : new OBResidue(l, false);
    }

    public OBInternalCoord BeginInternalCoord(SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator sWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_BeginInternalCoord(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator));
        return l == 0L ? null : new OBInternalCoord(l, false);
    }

    public OBInternalCoord NextInternalCoord(SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator sWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator) {
        long l = openbabel_javaJNI.OBMol_NextInternalCoord(this.swigCPtr, this, SWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator.getCPtr(sWIGTYPE_p_std__vectorT_OpenBabel__OBInternalCoord_p_t__iterator));
        return l == 0L ? null : new OBInternalCoord(l, false);
    }
}

