/*--------------------------------------------------------------------
 * FILE:
 *     probe_set_status.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Probe_Set_Status(SSL_Info * ssl_tbl, Probe_Header * header, char * packet);

int
PGC_Probe_Set_Status(SSL_Info * ssl_tbl, Probe_Header * header, char * packet)
{
	/*char * func = "PGC_Probe_Set_Status()"; */
	int status = STATUS_OK;
	Probe_Header r_header;
	Probe_Header h_data;

	switch (ntohs(header->serverType))
	{
		case SERVER_TYPE_PGLB:
			status = PGC_Set_Pglb_Status(header, packet);
			break;
		case SERVER_TYPE_CLUSTER:
			status = PGC_Set_Cluster_Status(header, packet);
			break;
		case SERVER_TYPE_PGRP:
			status = PGC_Set_Pgrp_Status(header, packet);
			break;
		default :
			break;
	}
	/* return response packet */
	h_data.packet_no = SET_STS_ANS_PKT;
	h_data.serverType = ntohs(header->serverType);
	h_data.body_length = 0;
	h_data.rec_num = 0;
	h_data.status = status;
	PGC_Set_Packet_Header(&r_header, &h_data);
	status = PGC_Send_Status_Packet(ssl_tbl, &r_header,NULL);

	return status;
}
