--
-- reorg_swap()
--
BEGIN;

-- none toast
CREATE TABLE tbl_pattern_01 (col int primary key);
CREATE INDEX idx_pattern_01 ON tbl_pattern_01 (col);

-- exists toast
CREATE TABLE tbl_pattern_02 (col text primary key);
CREATE INDEX idx_pattern_02_01 ON tbl_pattern_02 (col);

-- several indexes (none toast)
CREATE TABLE tbl_pattern_03 (col int primary key);
CREATE INDEX idx_pattern_03_01 ON tbl_pattern_03 (col);

CREATE TABLE tbl_pattern_04 (col int primary key);
CREATE INDEX idx_pattern_04_01 ON tbl_pattern_04 (col);
CREATE INDEX idx_pattern_04_02 ON tbl_pattern_04 (col);
CREATE INDEX idx_pattern_04_03 ON tbl_pattern_04 (col);
CREATE INDEX idx_pattern_04_04 ON tbl_pattern_04 (col);
CREATE INDEX idx_pattern_04_05 ON tbl_pattern_04 (col);

-- several indexes (exists toast)
CREATE TABLE tbl_pattern_05 (col text primary key);
CREATE INDEX idx_pattern_05_01 ON tbl_pattern_05 (col);

CREATE TABLE tbl_pattern_06 (col text primary key);
CREATE INDEX idx_pattern_06_01 ON tbl_pattern_06 (col);
CREATE INDEX idx_pattern_06_02 ON tbl_pattern_06 (col);
CREATE INDEX idx_pattern_06_03 ON tbl_pattern_06 (col);
CREATE INDEX idx_pattern_06_04 ON tbl_pattern_06 (col);
CREATE INDEX idx_pattern_06_05 ON tbl_pattern_06 (col);

COMMIT;

-- create temp objects
\! ./sql/create_objects.sh 'tbl_pattern_01'
\! ./sql/create_objects.sh 'tbl_pattern_02'
\! ./sql/create_objects.sh 'tbl_pattern_03'
\! ./sql/create_objects.sh 'tbl_pattern_04'
\! ./sql/create_objects.sh 'tbl_pattern_05'
\! ./sql/create_objects.sh 'tbl_pattern_06'

-- target table info
PREPARE target_table AS
SELECT
	R.oid AS table_oid,
	R.oid::regclass AS table_name,
	R.relfilenode AS table_filenode,
	R.reltoastrelid AS toast_oid,
	CASE WHEN R.reltoastrelid = 0 THEN 0 ELSE (SELECT relfilenode FROM pg_class WHERE oid = R.reltoastrelid) END AS toast_filenode,
	CASE WHEN R.reltoastrelid = 0 THEN 0 ELSE (SELECT reltoastidxid FROM pg_class WHERE oid = R.reltoastrelid) END AS tidx_oid,
	CASE WHEN R.reltoastrelid = 0 THEN 0 ELSE (SELECT relfilenode FROM pg_class WHERE oid = (SELECT reltoastidxid FROM pg_class WHERE oid = R.reltoastrelid)) END AS tidx_filenode
FROM pg_class R
WHERE R.oid IN(
	'tbl_pattern_01'::regclass,
	'tbl_pattern_02'::regclass,
	'tbl_pattern_03'::regclass,
	'tbl_pattern_04'::regclass,
	'tbl_pattern_05'::regclass,
	'tbl_pattern_06'::regclass
) ORDER BY relname;

-- temp table info
PREPARE temp_table AS
SELECT
	R.oid AS table_oid,
	R.oid::regclass AS table_name,
	R.relfilenode AS table_filenode,
	R.reltoastrelid AS toast_oid,
	CASE WHEN R.reltoastrelid = 0 THEN 0 ELSE (SELECT relfilenode FROM pg_class WHERE oid = R.reltoastrelid) END AS toast_filenode,
	CASE WHEN R.reltoastrelid = 0 THEN 0 ELSE (SELECT reltoastidxid FROM pg_class WHERE oid = R.reltoastrelid) END AS tidx_oid,
	CASE WHEN R.reltoastrelid = 0 THEN 0 ELSE (SELECT relfilenode FROM pg_class WHERE oid = (SELECT reltoastidxid FROM pg_class WHERE oid = R.reltoastrelid)) END AS tidx_filenode
FROM pg_class R
WHERE R.oid IN(
	SELECT ('reorg.table_' || oid)::regclass
	FROM pg_class WHERE oid IN(
		'tbl_pattern_01'::regclass,
		'tbl_pattern_02'::regclass,
		'tbl_pattern_03'::regclass,
		'tbl_pattern_04'::regclass,
		'tbl_pattern_05'::regclass,
		'tbl_pattern_06'::regclass
	)
) ORDER BY relname;

-- target index info
PREPARE target_index AS
SELECT
	(SELECT oid::regclass FROM pg_class WHERE oid = I.indrelid) AS tablename,
	I.indexrelid::regclass AS idxname,
	I.indexrelid AS indexrelid,
	(SELECT relfilenode FROM pg_class WHERE oid = I.indexrelid) AS relfilenode
FROM
	pg_index I
WHERE indrelid IN(
	'tbl_pattern_01'::regclass,
	'tbl_pattern_02'::regclass,
	'tbl_pattern_03'::regclass,
	'tbl_pattern_04'::regclass,
	'tbl_pattern_05'::regclass,
	'tbl_pattern_06'::regclass
) ORDER BY tablename, idxname;

-- temp index info
PREPARE temp_index AS
SELECT
	(SELECT oid::regclass FROM pg_class WHERE oid = I.indrelid) AS tablename,
	I.indexrelid::regclass AS idxname,
	I.indexrelid AS indexrelid,
	(SELECT relfilenode FROM pg_class WHERE oid = I.indexrelid) AS relfilenode
FROM
	pg_index I
WHERE I.indrelid IN(
	SELECT ('reorg.table_' || oid)::regclass
	FROM pg_class WHERE oid IN(
		'tbl_pattern_01'::regclass,
		'tbl_pattern_02'::regclass,
		'tbl_pattern_03'::regclass,
		'tbl_pattern_04'::regclass,
		'tbl_pattern_05'::regclass,
		'tbl_pattern_06'::regclass
	)
);

-- before
EXECUTE target_table;
EXECUTE temp_table;
EXECUTE target_index;
EXECUTE temp_index;

-- execute reorg_swap()
SELECT reorg.reorg_swap((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_01'::regclass));
SELECT reorg.reorg_swap((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_02'::regclass));
SELECT reorg.reorg_swap((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_03'::regclass));
SELECT reorg.reorg_swap((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_04'::regclass));
SELECT reorg.reorg_swap((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_05'::regclass));
SELECT reorg.reorg_swap((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_06'::regclass));

-- after
EXECUTE target_table;
EXECUTE temp_table;
EXECUTE target_index;
EXECUTE temp_index;

-- clean up
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_01'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_02'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_03'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_04'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_05'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'tbl_pattern_06'::regclass));
DROP TABLE IF EXISTS tbl_pattern_01;
DROP TABLE IF EXISTS tbl_pattern_02;
DROP TABLE IF EXISTS tbl_pattern_03;
DROP TABLE IF EXISTS tbl_pattern_04;
DROP TABLE IF EXISTS tbl_pattern_05;
DROP TABLE IF EXISTS tbl_pattern_06;
