/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.listener;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.ArtifactRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryEvent
implements RepositoryEvent {
    private RepositorySystemSession session;
    private Artifact artifact;
    private Metadata metadata;
    private ArtifactRepository repository;
    private File file;
    private List<Exception> exceptions = Collections.emptyList();

    public DefaultRepositoryEvent(RepositorySystemSession session, Artifact artifact) {
        this.session = session;
        this.artifact = artifact;
    }

    public DefaultRepositoryEvent(RepositorySystemSession session, Metadata metadata) {
        this.session = session;
        this.metadata = metadata;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public DefaultRepositoryEvent setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public DefaultRepositoryEvent setFile(File file) {
        this.file = file;
        return this;
    }

    public Exception getException() {
        return this.exceptions.isEmpty() ? null : this.exceptions.get(0);
    }

    public DefaultRepositoryEvent setException(Exception exception) {
        this.exceptions = exception != null ? Collections.singletonList(exception) : Collections.emptyList();
        return this;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public DefaultRepositoryEvent setExceptions(List<Exception> exceptions) {
        this.exceptions = exceptions != null ? exceptions : Collections.emptyList();
        return this;
    }
}

