/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;

public class Range {
    public static final Range NULL = new Range(0, 0);
    private final int myStart;
    private final int myEnd;

    public static Range of(int start, int end) {
        return new Range(start, end);
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public int component1() {
        return this.myStart;
    }

    public int component2() {
        return this.myEnd;
    }

    public Range(int start, int end) {
        this.myStart = start;
        this.myEnd = end;
    }

    public Range(Range other) {
        this.myStart = other.myStart;
        this.myEnd = other.myEnd;
    }

    public Range withStart(int start) {
        return start == this.myStart ? this : new Range(start, this.myEnd);
    }

    public Range withEnd(int end) {
        return end == this.myEnd ? this : new Range(this.myStart, end);
    }

    public Range withRange(int start, int end) {
        return start == this.myStart && end == this.myEnd ? this : new Range(start, end);
    }

    public BasedSequence subSequence(CharSequence charSequence) {
        return BasedSequenceImpl.of(charSequence, this.myStart, this.myEnd);
    }

    public BasedSequence safeSubSequence(CharSequence charSequence) {
        return BasedSequenceImpl.of(charSequence, Math.max(0, this.myStart), Math.min(charSequence.length(), this.myEnd));
    }

    public boolean contains(int index) {
        return this.myStart <= index && index < this.myEnd;
    }

    public boolean contains(int start, int end) {
        return this.myStart <= start && end <= this.myEnd;
    }

    public boolean leads(int index) {
        return this.myEnd <= index;
    }

    public boolean trails(int index) {
        return this.myStart > index;
    }

    public boolean leadBy(int index) {
        return this.myStart <= index && index < this.myEnd;
    }

    public boolean trailedBy(int index) {
        return this.myStart <= index && index < this.myEnd;
    }

    public boolean doesNotOverlap(Range other) {
        return other.myEnd <= this.myStart || other.myStart >= this.myEnd;
    }

    public boolean doesOverlap(Range other) {
        return other.myEnd > this.myStart && other.myStart < this.myEnd;
    }

    public boolean isEqual(Range other) {
        return this.myEnd == other.myEnd && this.myStart == other.myStart;
    }

    public boolean doesContain(Range other) {
        return this.myEnd >= other.myEnd && this.myStart <= other.myStart;
    }

    public boolean doesProperlyContain(Range other) {
        return this.myEnd > other.myEnd && this.myStart < other.myStart;
    }

    public boolean isEmpty() {
        return this.myStart >= this.myEnd;
    }

    public boolean isContainedBy(int start, int end) {
        return end >= this.myEnd && start <= this.myStart;
    }

    public boolean isProperlyContainedBy(int start, int end) {
        return end > this.myEnd && start < this.myStart;
    }

    public boolean isContainedBy(Range other) {
        return other.myEnd >= this.myEnd && other.myStart <= this.myStart;
    }

    public boolean isProperlyContainedBy(Range other) {
        return other.myEnd > this.myEnd && other.myStart < this.myStart;
    }

    public boolean doesContain(int index) {
        return index >= this.myStart && index < this.myEnd;
    }

    public boolean isAdjacent(int index) {
        return index == this.myStart - 1 || index == this.myEnd;
    }

    public boolean isStart(int index) {
        return index == this.myStart;
    }

    public boolean isEnd(int index) {
        return index == this.myEnd;
    }

    public boolean isLast(int index) {
        return index >= this.myStart && index == this.myEnd - 1;
    }

    public boolean isAdjacentBefore(int index) {
        return this.myEnd == index;
    }

    public boolean isAdjacentAfter(int index) {
        return this.myStart - 1 == index;
    }

    public Range intersect(Range other) {
        int thisEnd;
        int thisStart = this.myStart;
        if (thisStart < other.myStart) {
            thisStart = other.myStart;
        }
        if ((thisEnd = this.myEnd) > other.myEnd) {
            thisEnd = other.myEnd;
        }
        if (thisStart >= thisEnd) {
            thisEnd = 0;
            thisStart = 0;
        }
        return this.withRange(thisStart, thisEnd);
    }

    public Range exclude(Range other) {
        int thisEnd;
        int thisStart = this.myStart;
        if (thisStart >= other.myStart && thisStart < other.myEnd) {
            thisStart = other.myEnd;
        }
        if ((thisEnd = this.myEnd) <= other.myEnd && thisEnd > other.myStart) {
            thisEnd = other.myStart;
        }
        if (thisStart >= thisEnd) {
            thisEnd = 0;
            thisStart = 0;
        }
        return this.withRange(thisStart, thisEnd);
    }

    public int compare(Range other) {
        if (this.myStart < other.myStart) {
            return -1;
        }
        if (this.myStart > other.myStart) {
            return 1;
        }
        if (this.myEnd > other.myEnd) {
            return -1;
        }
        if (this.myEnd < other.myEnd) {
            return 1;
        }
        return 0;
    }

    public int getSpan() {
        return this.myEnd - this.myStart;
    }

    public int length() {
        return this.myEnd - this.myStart;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isNotNull() {
        return this != NULL;
    }

    public String toString() {
        return "[" + this.myStart + ", " + this.myEnd + ")";
    }

    public boolean isAdjacent(Range other) {
        return this.myStart == other.myEnd || this.myEnd == other.myStart;
    }

    public boolean isAdjacentBefore(Range other) {
        return this.myEnd == other.myStart;
    }

    public boolean isAdjacentAfter(Range other) {
        return this.myStart == other.myEnd;
    }

    public Range include(Range other) {
        return other.isNull() ? (this.isNull() ? NULL : this) : this.expandToInclude(other);
    }

    public Range include(int pos) {
        return this.include(pos, pos);
    }

    public Range include(int start, int end) {
        return this.isNull() ? new Range(start, end) : this.expandToInclude(start, end);
    }

    public Range expandToInclude(Range other) {
        return this.expandToInclude(other.myStart, other.myEnd);
    }

    public Range expandToInclude(int start, int end) {
        return this.withRange(this.myStart > start ? start : this.myStart, this.myEnd < end ? end : this.myEnd);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return this.myStart == range.myStart && this.myEnd == range.myEnd;
    }

    public int hashCode() {
        int result = this.myStart;
        result = 31 * result + this.myEnd;
        return result;
    }
}

