/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class AbstractJSObjectArray
extends AbstractWritableArray {
    protected AbstractJSObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(DynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        return HolesJSObjectArray.makeHolesJSObjectArray(object, length, (DynamicObject[])array, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
    }

    public abstract void setInBoundsFast(DynamicObject var1, int var2, DynamicObject var3, boolean var4);

    @Override
    public final ScriptArray setElementImpl(DynamicObject object, long index, Object value, boolean strict, boolean condition) {
        assert (index >= 0L);
        if (CompilerDirectives.injectBranchProbability((double)0.9999, (JSObject.isDynamicObject(value) && this.isSupported(object, index, condition) ? 1 : 0) != 0)) {
            this.setSupported(object, (int)index, (DynamicObject)value, condition, ScriptArray.ProfileHolder.empty());
            return this;
        }
        return this.rewrite(object, index, value, condition).setElementImpl(object, index, value, strict, condition);
    }

    private ScriptArray rewrite(DynamicObject object, long index, Object value, boolean condition) {
        if (this.isSupportedContiguous(object, index, condition)) {
            return this.toContiguous(object, index, value, condition);
        }
        if (this.isSupportedHoles(object, index, condition)) {
            return this.toHoles(object, index, value, condition);
        }
        return this.toObject(object, index, value, condition);
    }

    @Override
    public Object getInBoundsFast(DynamicObject object, int index, boolean condition) {
        return this.getInBoundsFastJSObject(object, index, condition);
    }

    @Override
    int getArrayLength(Object array) {
        return ((DynamicObject[])array).length;
    }

    protected static DynamicObject[] getArray(DynamicObject object) {
        return AbstractJSObjectArray.getArray(object, AbstractJSObjectArray.arrayCondition());
    }

    protected static DynamicObject[] getArray(DynamicObject object, boolean condition) {
        return AbstractJSObjectArray.arrayCast(JSAbstractArray.arrayGetArray(object, condition), DynamicObject[].class, condition);
    }

    public abstract DynamicObject getInBoundsFastJSObject(DynamicObject var1, int var2, boolean var3);

    public final void setInBounds(DynamicObject object, int index, DynamicObject value, boolean condition, ScriptArray.ProfileHolder profile) {
        AbstractJSObjectArray.getArray((DynamicObject)object, (boolean)condition)[this.prepareInBounds((DynamicObject)object, (int)index, (boolean)condition, (ScriptArray.ProfileHolder)profile)] = AbstractJSObjectArray.checkNonNull(value);
    }

    public final void setSupported(DynamicObject object, int index, DynamicObject value, boolean condition, ScriptArray.ProfileHolder profile) {
        int preparedIndex = this.prepareSupported(object, index, condition, profile);
        AbstractJSObjectArray.getArray((DynamicObject)object, (boolean)condition)[preparedIndex] = AbstractJSObjectArray.checkNonNull(value);
    }

    @Override
    void fillWithHoles(Object array, int fromIndex, int toIndex) {
        DynamicObject[] objectArray = (DynamicObject[])array;
        for (int i = fromIndex; i < toIndex; ++i) {
            objectArray[i] = null;
        }
    }

    @Override
    protected final void setHoleValue(DynamicObject object, int preparedIndex) {
        AbstractJSObjectArray.getArray((DynamicObject)object)[preparedIndex] = null;
    }

    @Override
    protected final void fillHoles(DynamicObject object, int internalIndex, int grown, ScriptArray.ProfileHolder profile) {
        if (grown != 0) {
            this.incrementHolesCount(object, Math.abs(grown) - 1);
        }
    }

    @Override
    protected final boolean isHolePrepared(DynamicObject object, int preparedIndex, boolean condition) {
        return HolesObjectArray.isHoleValue(AbstractJSObjectArray.getArray(object, condition)[preparedIndex]);
    }

    @Override
    protected final int getArrayCapacity(DynamicObject object, boolean condition) {
        return AbstractJSObjectArray.getArray(object, condition).length;
    }

    @Override
    protected final void resizeArray(DynamicObject object, int newCapacity, int oldCapacity, int offset, boolean condition) {
        DynamicObject[] newArray = new DynamicObject[newCapacity];
        System.arraycopy(AbstractJSObjectArray.getArray(object, condition), 0, newArray, offset, oldCapacity);
        JSAbstractArray.arraySetArray(object, newArray);
    }

    @Override
    public abstract AbstractJSObjectArray toHoles(DynamicObject var1, long var2, Object var4, boolean var5);

    @Override
    public abstract AbstractWritableArray toObject(DynamicObject var1, long var2, Object var4, boolean var5);

    @Override
    public final AbstractWritableArray toDouble(DynamicObject object, long index, double value, boolean condition) {
        return this;
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.toHoles(object, index, null, condition).deleteElementImpl(object, index, strict, condition);
    }

    @Override
    protected final void moveRangePrepared(DynamicObject object, int src, int dst, int len) {
        DynamicObject[] array = AbstractJSObjectArray.getArray(object);
        System.arraycopy(array, src, array, dst, len);
    }

    @Override
    public final Object allocateArray(int length) {
        return new DynamicObject[length];
    }

    @Override
    protected abstract AbstractJSObjectArray withIntegrityLevel(int var1);

    protected static DynamicObject checkNonNull(DynamicObject value) {
        assert (value != null);
        return value;
    }

    protected DynamicObject castNonNull(DynamicObject value) {
        if (value == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw Errors.shouldNotReachHere();
        }
        return value;
    }
}

