/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

public class FilterArtifacts {
    private List<ArtifactsFilter> filters = new ArrayList<ArtifactsFilter>();

    public void clearFilters() {
        this.filters.clear();
    }

    public void addFilter(ArtifactsFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public void addFilter(int index, ArtifactsFilter filter) {
        if (filter != null) {
            this.filters.add(index, filter);
        }
    }

    public Set<Artifact> filter(Set<Artifact> artifacts) throws ArtifactFilterException {
        for (ArtifactsFilter filter : this.filters) {
            try {
                artifacts = filter.filter(artifacts);
            }
            catch (NullPointerException e) {}
        }
        return artifacts;
    }

    public List<ArtifactsFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ArtifactsFilter> filters) {
        this.filters = filters;
    }
}

