/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.util.internal.ClassMethod;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

final class TestResolverFilter
extends Filter {
    private final TestListResolver methodFilter;

    TestResolverFilter(TestListResolver methodFilter) {
        this.methodFilter = methodFilter;
    }

    public boolean shouldRun(Description description) {
        ClassMethod cm = JUnit4ProviderUtil.toClassMethod((Description)description);
        boolean isSuite = description.isSuite();
        boolean isValidTest = description.isTest() && cm.isValidTest();
        String clazz = cm.getClazz();
        String method = cm.getMethod();
        return isSuite || isValidTest && this.methodFilter.shouldRun(TestListResolver.toClassFileName((String)clazz), method);
    }

    public String describe() {
        return this.methodFilter.toString();
    }
}

