/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenXpp3Reader {
    private boolean addDefaultEntities = true;

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    public boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    public byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, null);
                }
            }
        }
        return 0;
    }

    public char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    public Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            if (dateFormat == null) {
                return new Date(Long.valueOf(s));
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(dateFormat, Locale.US);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        return null;
    }

    public double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, null);
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, null);
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, null);
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, null);
                }
            }
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    public short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, null);
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private Activation parseActivation(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Activation activation = new Activation();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("activeByDefault")) {
                if (parsed.contains("activeByDefault")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("activeByDefault");
                activation.setActiveByDefault(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "activeByDefault", parser, "false"));
                continue;
            }
            if (parser.getName().equals("jdk")) {
                if (parsed.contains("jdk")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("jdk");
                activation.setJdk(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("os")) {
                if (parsed.contains("os")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("os");
                activation.setOs(this.parseActivationOS("os", parser, strict));
                continue;
            }
            if (parser.getName().equals("property")) {
                if (parsed.contains("property")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("property");
                activation.setProperty(this.parseActivationProperty("property", parser, strict));
                continue;
            }
            if (parser.getName().equals("file")) {
                if (parsed.contains("file")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("file");
                activation.setFile(this.parseActivationFile("file", parser, strict));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return activation;
    }

    private ActivationFile parseActivationFile(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ActivationFile activationFile = new ActivationFile();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("missing")) {
                if (parsed.contains("missing")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("missing");
                activationFile.setMissing(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("exists")) {
                if (parsed.contains("exists")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("exists");
                activationFile.setExists(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return activationFile;
    }

    private ActivationOS parseActivationOS(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ActivationOS activationOS = new ActivationOS();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                activationOS.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("family")) {
                if (parsed.contains("family")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("family");
                activationOS.setFamily(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("arch")) {
                if (parsed.contains("arch")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("arch");
                activationOS.setArch(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("version");
                activationOS.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return activationOS;
    }

    private ActivationProperty parseActivationProperty(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ActivationProperty activationProperty = new ActivationProperty();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                activationProperty.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("value")) {
                if (parsed.contains("value")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("value");
                activationProperty.setValue(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return activationProperty;
    }

    private Build parseBuild(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Build build = new Build();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("sourceDirectory")) {
                if (parsed.contains("sourceDirectory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("sourceDirectory");
                build.setSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("scriptSourceDirectory")) {
                if (parsed.contains("scriptSourceDirectory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("scriptSourceDirectory");
                build.setScriptSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("testSourceDirectory")) {
                if (parsed.contains("testSourceDirectory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("testSourceDirectory");
                build.setTestSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("outputDirectory")) {
                if (parsed.contains("outputDirectory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("outputDirectory");
                build.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("testOutputDirectory")) {
                if (parsed.contains("testOutputDirectory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("testOutputDirectory");
                build.setTestOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("extensions")) {
                if (parsed.contains("extensions")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("extensions");
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                build.setExtensions(extensions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("extension")) {
                        extensions.add(this.parseExtension("extension", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("defaultGoal")) {
                if (parsed.contains("defaultGoal")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("defaultGoal");
                build.setDefaultGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("resources");
                ArrayList<Resource> resources = new ArrayList<Resource>();
                build.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("testResources")) {
                if (parsed.contains("testResources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("testResources");
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                build.setTestResources(testResources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("testResource")) {
                        testResources.add(this.parseResource("testResource", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("directory");
                build.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("finalName")) {
                if (parsed.contains("finalName")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("finalName");
                build.setFinalName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("filters")) {
                if (parsed.contains("filters")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("filters");
                ArrayList<String> filters = new ArrayList<String>();
                build.setFilters(filters);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("filter")) {
                        filters.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("pluginManagement")) {
                if (parsed.contains("pluginManagement")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("pluginManagement");
                build.setPluginManagement(this.parsePluginManagement("pluginManagement", parser, strict));
                continue;
            }
            if (parser.getName().equals("plugins")) {
                if (parsed.contains("plugins")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("plugins");
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                build.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return build;
    }

    private BuildBase parseBuildBase(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        BuildBase buildBase = new BuildBase();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("defaultGoal")) {
                if (parsed.contains("defaultGoal")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("defaultGoal");
                buildBase.setDefaultGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("resources");
                ArrayList<Resource> resources = new ArrayList<Resource>();
                buildBase.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("testResources")) {
                if (parsed.contains("testResources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("testResources");
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                buildBase.setTestResources(testResources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("testResource")) {
                        testResources.add(this.parseResource("testResource", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("directory");
                buildBase.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("finalName")) {
                if (parsed.contains("finalName")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("finalName");
                buildBase.setFinalName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("filters")) {
                if (parsed.contains("filters")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("filters");
                ArrayList<String> filters = new ArrayList<String>();
                buildBase.setFilters(filters);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("filter")) {
                        filters.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("pluginManagement")) {
                if (parsed.contains("pluginManagement")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("pluginManagement");
                buildBase.setPluginManagement(this.parsePluginManagement("pluginManagement", parser, strict));
                continue;
            }
            if (parser.getName().equals("plugins")) {
                if (parsed.contains("plugins")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("plugins");
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                buildBase.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return buildBase;
    }

    private CiManagement parseCiManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        CiManagement ciManagement = new CiManagement();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("system")) {
                if (parsed.contains("system")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("system");
                ciManagement.setSystem(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                ciManagement.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("notifiers")) {
                if (parsed.contains("notifiers")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("notifiers");
                ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                ciManagement.setNotifiers(notifiers);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("notifier")) {
                        notifiers.add(this.parseNotifier("notifier", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return ciManagement;
    }

    private ConfigurationContainer parseConfigurationContainer(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ConfigurationContainer configurationContainer = new ConfigurationContainer();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("inherited")) {
                if (parsed.contains("inherited")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("inherited");
                configurationContainer.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("configuration");
                configurationContainer.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return configurationContainer;
    }

    private Contributor parseContributor(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Contributor contributor = new Contributor();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                contributor.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("email")) {
                if (parsed.contains("email")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("email");
                contributor.setEmail(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                contributor.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("organization") || parser.getName().equals("organisation")) {
                if (parsed.contains("organization")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("organization");
                contributor.setOrganization(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("organizationUrl") || parser.getName().equals("organisationUrl")) {
                if (parsed.contains("organizationUrl")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("organizationUrl");
                contributor.setOrganizationUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("roles")) {
                if (parsed.contains("roles")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("roles");
                ArrayList<String> roles = new ArrayList<String>();
                contributor.setRoles(roles);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("role")) {
                        roles.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("timezone")) {
                if (parsed.contains("timezone")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("timezone");
                contributor.setTimezone(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("properties");
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    contributor.addProperty(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return contributor;
    }

    private Dependency parseDependency(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Dependency dependency = new Dependency();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("groupId");
                dependency.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("artifactId");
                dependency.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("version");
                dependency.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("type");
                dependency.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("classifier")) {
                if (parsed.contains("classifier")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("classifier");
                dependency.setClassifier(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("scope")) {
                if (parsed.contains("scope")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("scope");
                dependency.setScope(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("systemPath")) {
                if (parsed.contains("systemPath")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("systemPath");
                dependency.setSystemPath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("exclusions")) {
                if (parsed.contains("exclusions")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("exclusions");
                ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                dependency.setExclusions(exclusions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclusion")) {
                        exclusions.add(this.parseExclusion("exclusion", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("optional")) {
                if (parsed.contains("optional")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("optional");
                dependency.setOptional(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "optional", parser, "false"));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return dependency;
    }

    private DependencyManagement parseDependencyManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DependencyManagement dependencyManagement = new DependencyManagement();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("dependencies");
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                dependencyManagement.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return dependencyManagement;
    }

    private DeploymentRepository parseDeploymentRepository(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DeploymentRepository deploymentRepository = new DeploymentRepository();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("uniqueVersion")) {
                if (parsed.contains("uniqueVersion")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("uniqueVersion");
                deploymentRepository.setUniqueVersion(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "uniqueVersion", parser, "true"));
                continue;
            }
            if (parser.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("id");
                deploymentRepository.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                deploymentRepository.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                deploymentRepository.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("layout")) {
                if (parsed.contains("layout")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("layout");
                deploymentRepository.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return deploymentRepository;
    }

    private Developer parseDeveloper(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Developer developer = new Developer();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("id");
                developer.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                developer.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("email")) {
                if (parsed.contains("email")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("email");
                developer.setEmail(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                developer.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("organization") || parser.getName().equals("organisation")) {
                if (parsed.contains("organization")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("organization");
                developer.setOrganization(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("organizationUrl") || parser.getName().equals("organisationUrl")) {
                if (parsed.contains("organizationUrl")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("organizationUrl");
                developer.setOrganizationUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("roles")) {
                if (parsed.contains("roles")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("roles");
                ArrayList<String> roles = new ArrayList<String>();
                developer.setRoles(roles);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("role")) {
                        roles.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("timezone")) {
                if (parsed.contains("timezone")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("timezone");
                developer.setTimezone(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("properties");
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    developer.addProperty(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return developer;
    }

    private DistributionManagement parseDistributionManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DistributionManagement distributionManagement = new DistributionManagement();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("repository")) {
                if (parsed.contains("repository")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("repository");
                distributionManagement.setRepository(this.parseDeploymentRepository("repository", parser, strict));
                continue;
            }
            if (parser.getName().equals("snapshotRepository")) {
                if (parsed.contains("snapshotRepository")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("snapshotRepository");
                distributionManagement.setSnapshotRepository(this.parseDeploymentRepository("snapshotRepository", parser, strict));
                continue;
            }
            if (parser.getName().equals("site")) {
                if (parsed.contains("site")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("site");
                distributionManagement.setSite(this.parseSite("site", parser, strict));
                continue;
            }
            if (parser.getName().equals("downloadUrl")) {
                if (parsed.contains("downloadUrl")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("downloadUrl");
                distributionManagement.setDownloadUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("relocation")) {
                if (parsed.contains("relocation")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("relocation");
                distributionManagement.setRelocation(this.parseRelocation("relocation", parser, strict));
                continue;
            }
            if (parser.getName().equals("status")) {
                if (parsed.contains("status")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("status");
                distributionManagement.setStatus(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return distributionManagement;
    }

    private Exclusion parseExclusion(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Exclusion exclusion = new Exclusion();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("artifactId");
                exclusion.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("groupId");
                exclusion.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return exclusion;
    }

    private Extension parseExtension(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Extension extension = new Extension();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("groupId");
                extension.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("artifactId");
                extension.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("version");
                extension.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return extension;
    }

    private FileSet parseFileSet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        FileSet fileSet = new FileSet();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("directory");
                fileSet.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return fileSet;
    }

    private IssueManagement parseIssueManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        IssueManagement issueManagement = new IssueManagement();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("system")) {
                if (parsed.contains("system")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("system");
                issueManagement.setSystem(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                issueManagement.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return issueManagement;
    }

    private License parseLicense(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        License license = new License();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                license.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                license.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("distribution")) {
                if (parsed.contains("distribution")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("distribution");
                license.setDistribution(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("comments")) {
                if (parsed.contains("comments")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("comments");
                license.setComments(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return license;
    }

    private MailingList parseMailingList(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        MailingList mailingList = new MailingList();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                mailingList.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("subscribe")) {
                if (parsed.contains("subscribe")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("subscribe");
                mailingList.setSubscribe(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("unsubscribe")) {
                if (parsed.contains("unsubscribe")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("unsubscribe");
                mailingList.setUnsubscribe(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("post")) {
                if (parsed.contains("post")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("post");
                mailingList.setPost(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("archive")) {
                if (parsed.contains("archive")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("archive");
                mailingList.setArchive(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("otherArchives")) {
                if (parsed.contains("otherArchives")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("otherArchives");
                ArrayList<String> otherArchives = new ArrayList<String>();
                mailingList.setOtherArchives(otherArchives);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("otherArchive")) {
                        otherArchives.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return mailingList;
    }

    private Model parseModel(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Model model = new Model();
        HashSet<String> parsed = new HashSet<String>();
        int eventType = parser.getEventType();
        boolean foundRoot = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals(tagName)) {
                    foundRoot = true;
                } else if (parser.getName().equals("modelVersion")) {
                    if (parsed.contains("modelVersion")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("modelVersion");
                    model.setModelVersion(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("parent")) {
                    if (parsed.contains("parent")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("parent");
                    model.setParent(this.parseParent("parent", parser, strict));
                } else if (parser.getName().equals("groupId")) {
                    if (parsed.contains("groupId")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("groupId");
                    model.setGroupId(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("artifactId")) {
                    if (parsed.contains("artifactId")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("artifactId");
                    model.setArtifactId(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("version")) {
                    if (parsed.contains("version")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("version");
                    model.setVersion(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("packaging")) {
                    if (parsed.contains("packaging")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("packaging");
                    model.setPackaging(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("name")) {
                    if (parsed.contains("name")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("name");
                    model.setName(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("description")) {
                    if (parsed.contains("description")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("description");
                    model.setDescription(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("url")) {
                    if (parsed.contains("url")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("url");
                    model.setUrl(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("inceptionYear")) {
                    if (parsed.contains("inceptionYear")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("inceptionYear");
                    model.setInceptionYear(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("organization") || parser.getName().equals("organisation")) {
                    if (parsed.contains("organization")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("organization");
                    model.setOrganization(this.parseOrganization("organization", parser, strict));
                } else if (parser.getName().equals("licenses")) {
                    if (parsed.contains("licenses")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("licenses");
                    ArrayList<License> licenses = new ArrayList<License>();
                    model.setLicenses(licenses);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("license")) {
                            licenses.add(this.parseLicense("license", parser, strict));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("mailingLists")) {
                    if (parsed.contains("mailingLists")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("mailingLists");
                    ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                    model.setMailingLists(mailingLists);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("mailingList")) {
                            mailingLists.add(this.parseMailingList("mailingList", parser, strict));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("developers")) {
                    if (parsed.contains("developers")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("developers");
                    ArrayList<Developer> developers = new ArrayList<Developer>();
                    model.setDevelopers(developers);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("developer")) {
                            developers.add(this.parseDeveloper("developer", parser, strict));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("contributors")) {
                    if (parsed.contains("contributors")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("contributors");
                    ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                    model.setContributors(contributors);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("contributor")) {
                            contributors.add(this.parseContributor("contributor", parser, strict));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("issueManagement")) {
                    if (parsed.contains("issueManagement")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("issueManagement");
                    model.setIssueManagement(this.parseIssueManagement("issueManagement", parser, strict));
                } else if (parser.getName().equals("scm")) {
                    if (parsed.contains("scm")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("scm");
                    model.setScm(this.parseScm("scm", parser, strict));
                } else if (parser.getName().equals("ciManagement")) {
                    if (parsed.contains("ciManagement")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("ciManagement");
                    model.setCiManagement(this.parseCiManagement("ciManagement", parser, strict));
                } else if (parser.getName().equals("prerequisites")) {
                    if (parsed.contains("prerequisites")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("prerequisites");
                    model.setPrerequisites(this.parsePrerequisites("prerequisites", parser, strict));
                } else if (parser.getName().equals("build")) {
                    if (parsed.contains("build")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("build");
                    model.setBuild(this.parseBuild("build", parser, strict));
                } else if (parser.getName().equals("profiles")) {
                    if (parsed.contains("profiles")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("profiles");
                    ArrayList<Profile> profiles = new ArrayList<Profile>();
                    model.setProfiles(profiles);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("profile")) {
                            profiles.add(this.parseProfile("profile", parser, strict));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("distributionManagement")) {
                    if (parsed.contains("distributionManagement")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("distributionManagement");
                    model.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser, strict));
                } else if (parser.getName().equals("modules")) {
                    if (parsed.contains("modules")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("modules");
                    ArrayList<String> modules = new ArrayList<String>();
                    model.setModules(modules);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("module")) {
                            modules.add(this.getTrimmedValue(parser.nextText()));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("repositories")) {
                    if (parsed.contains("repositories")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("repositories");
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    model.setRepositories(repositories);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("repository")) {
                            repositories.add(this.parseRepository("repository", parser, strict));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("pluginRepositories")) {
                    if (parsed.contains("pluginRepositories")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("pluginRepositories");
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    model.setPluginRepositories(pluginRepositories);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("pluginRepository")) {
                            pluginRepositories.add(this.parseRepository("pluginRepository", parser, strict));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("dependencies")) {
                    if (parsed.contains("dependencies")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("dependencies");
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    model.setDependencies(dependencies);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("dependency")) {
                            dependencies.add(this.parseDependency("dependency", parser, strict));
                            continue;
                        }
                        if (strict) {
                            throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                        }
                        while (parser.next() != 3) {
                        }
                    }
                } else if (parser.getName().equals("reports")) {
                    if (parsed.contains("reports")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("reports");
                    model.setReports(Xpp3DomBuilder.build((XmlPullParser)parser));
                } else if (parser.getName().equals("reporting")) {
                    if (parsed.contains("reporting")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("reporting");
                    model.setReporting(this.parseReporting("reporting", parser, strict));
                } else if (parser.getName().equals("dependencyManagement")) {
                    if (parsed.contains("dependencyManagement")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("dependencyManagement");
                    model.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser, strict));
                } else if (parser.getName().equals("properties")) {
                    if (parsed.contains("properties")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("properties");
                    while (parser.nextTag() == 2) {
                        String key = parser.getName();
                        String value = parser.nextText().trim();
                        model.addProperty(key, value);
                    }
                } else if (strict) {
                    throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
                }
            }
            eventType = parser.next();
        }
        return model;
    }

    private ModelBase parseModelBase(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ModelBase modelBase = new ModelBase();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("distributionManagement")) {
                if (parsed.contains("distributionManagement")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("distributionManagement");
                modelBase.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser, strict));
                continue;
            }
            if (parser.getName().equals("modules")) {
                if (parsed.contains("modules")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("modules");
                ArrayList<String> modules = new ArrayList<String>();
                modelBase.setModules(modules);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("module")) {
                        modules.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("repositories")) {
                if (parsed.contains("repositories")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("repositories");
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                modelBase.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("repository")) {
                        repositories.add(this.parseRepository("repository", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("pluginRepositories")) {
                if (parsed.contains("pluginRepositories")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("pluginRepositories");
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                modelBase.setPluginRepositories(pluginRepositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("pluginRepository")) {
                        pluginRepositories.add(this.parseRepository("pluginRepository", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("dependencies");
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                modelBase.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("reports")) {
                if (parsed.contains("reports")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("reports");
                modelBase.setReports(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("reporting")) {
                if (parsed.contains("reporting")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("reporting");
                modelBase.setReporting(this.parseReporting("reporting", parser, strict));
                continue;
            }
            if (parser.getName().equals("dependencyManagement")) {
                if (parsed.contains("dependencyManagement")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("dependencyManagement");
                modelBase.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser, strict));
                continue;
            }
            if (parser.getName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("properties");
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    modelBase.addProperty(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return modelBase;
    }

    private Notifier parseNotifier(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Notifier notifier = new Notifier();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("type");
                notifier.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("sendOnError")) {
                if (parsed.contains("sendOnError")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("sendOnError");
                notifier.setSendOnError(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sendOnError", parser, "true"));
                continue;
            }
            if (parser.getName().equals("sendOnFailure")) {
                if (parsed.contains("sendOnFailure")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("sendOnFailure");
                notifier.setSendOnFailure(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sendOnFailure", parser, "true"));
                continue;
            }
            if (parser.getName().equals("sendOnSuccess")) {
                if (parsed.contains("sendOnSuccess")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("sendOnSuccess");
                notifier.setSendOnSuccess(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sendOnSuccess", parser, "true"));
                continue;
            }
            if (parser.getName().equals("sendOnWarning")) {
                if (parsed.contains("sendOnWarning")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("sendOnWarning");
                notifier.setSendOnWarning(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sendOnWarning", parser, "true"));
                continue;
            }
            if (parser.getName().equals("address")) {
                if (parsed.contains("address")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("address");
                notifier.setAddress(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("configuration");
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    notifier.addConfiguration(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return notifier;
    }

    private Organization parseOrganization(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Organization organization = new Organization();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                organization.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                organization.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return organization;
    }

    private Parent parseParent(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Parent parent = new Parent();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("artifactId");
                parent.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("groupId");
                parent.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("version");
                parent.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("relativePath")) {
                if (parsed.contains("relativePath")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("relativePath");
                parent.setRelativePath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return parent;
    }

    private PatternSet parsePatternSet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PatternSet patternSet = new PatternSet();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                patternSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                patternSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return patternSet;
    }

    private Plugin parsePlugin(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Plugin plugin = new Plugin();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("groupId");
                plugin.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("artifactId");
                plugin.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("version");
                plugin.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("extensions")) {
                if (parsed.contains("extensions")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("extensions");
                plugin.setExtensions(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "extensions", parser, "false"));
                continue;
            }
            if (parser.getName().equals("executions")) {
                if (parsed.contains("executions")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("executions");
                ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
                plugin.setExecutions(executions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("execution")) {
                        executions.add(this.parsePluginExecution("execution", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("dependencies");
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                plugin.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("goals")) {
                if (parsed.contains("goals")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("goals");
                plugin.setGoals(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("inherited")) {
                if (parsed.contains("inherited")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("inherited");
                plugin.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("configuration");
                plugin.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return plugin;
    }

    private PluginConfiguration parsePluginConfiguration(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("pluginManagement")) {
                if (parsed.contains("pluginManagement")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("pluginManagement");
                pluginConfiguration.setPluginManagement(this.parsePluginManagement("pluginManagement", parser, strict));
                continue;
            }
            if (parser.getName().equals("plugins")) {
                if (parsed.contains("plugins")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("plugins");
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginConfiguration.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginContainer pluginContainer = new PluginContainer();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("plugins")) {
                if (parsed.contains("plugins")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("plugins");
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginContainer.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return pluginContainer;
    }

    private PluginExecution parsePluginExecution(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginExecution pluginExecution = new PluginExecution();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("id");
                pluginExecution.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("phase")) {
                if (parsed.contains("phase")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("phase");
                pluginExecution.setPhase(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("goals")) {
                if (parsed.contains("goals")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("goals");
                ArrayList<String> goals = new ArrayList<String>();
                pluginExecution.setGoals(goals);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("goal")) {
                        goals.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("inherited")) {
                if (parsed.contains("inherited")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("inherited");
                pluginExecution.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("configuration");
                pluginExecution.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return pluginExecution;
    }

    private PluginManagement parsePluginManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginManagement pluginManagement = new PluginManagement();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("plugins")) {
                if (parsed.contains("plugins")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("plugins");
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginManagement.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return pluginManagement;
    }

    private Prerequisites parsePrerequisites(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Prerequisites prerequisites = new Prerequisites();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("maven")) {
                if (parsed.contains("maven")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("maven");
                prerequisites.setMaven(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return prerequisites;
    }

    private Profile parseProfile(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Profile profile = new Profile();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("id");
                profile.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("activation")) {
                if (parsed.contains("activation")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("activation");
                profile.setActivation(this.parseActivation("activation", parser, strict));
                continue;
            }
            if (parser.getName().equals("build")) {
                if (parsed.contains("build")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("build");
                profile.setBuild(this.parseBuildBase("build", parser, strict));
                continue;
            }
            if (parser.getName().equals("distributionManagement")) {
                if (parsed.contains("distributionManagement")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("distributionManagement");
                profile.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser, strict));
                continue;
            }
            if (parser.getName().equals("modules")) {
                if (parsed.contains("modules")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("modules");
                ArrayList<String> modules = new ArrayList<String>();
                profile.setModules(modules);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("module")) {
                        modules.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("repositories")) {
                if (parsed.contains("repositories")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("repositories");
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                profile.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("repository")) {
                        repositories.add(this.parseRepository("repository", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("pluginRepositories")) {
                if (parsed.contains("pluginRepositories")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("pluginRepositories");
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                profile.setPluginRepositories(pluginRepositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("pluginRepository")) {
                        pluginRepositories.add(this.parseRepository("pluginRepository", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("dependencies");
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                profile.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("reports")) {
                if (parsed.contains("reports")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("reports");
                profile.setReports(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("reporting")) {
                if (parsed.contains("reporting")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("reporting");
                profile.setReporting(this.parseReporting("reporting", parser, strict));
                continue;
            }
            if (parser.getName().equals("dependencyManagement")) {
                if (parsed.contains("dependencyManagement")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("dependencyManagement");
                profile.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser, strict));
                continue;
            }
            if (parser.getName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("properties");
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    profile.addProperty(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return profile;
    }

    private Relocation parseRelocation(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Relocation relocation = new Relocation();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("groupId");
                relocation.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("artifactId");
                relocation.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("version");
                relocation.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("message")) {
                if (parsed.contains("message")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("message");
                relocation.setMessage(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return relocation;
    }

    private ReportPlugin parseReportPlugin(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ReportPlugin reportPlugin = new ReportPlugin();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("groupId");
                reportPlugin.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("artifactId");
                reportPlugin.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("version");
                reportPlugin.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("inherited")) {
                if (parsed.contains("inherited")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("inherited");
                reportPlugin.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("configuration");
                reportPlugin.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("reportSets")) {
                if (parsed.contains("reportSets")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("reportSets");
                ArrayList<ReportSet> reportSets = new ArrayList<ReportSet>();
                reportPlugin.setReportSets(reportSets);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("reportSet")) {
                        reportSets.add(this.parseReportSet("reportSet", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return reportPlugin;
    }

    private ReportSet parseReportSet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ReportSet reportSet = new ReportSet();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("id");
                reportSet.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("configuration");
                reportSet.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("inherited")) {
                if (parsed.contains("inherited")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("inherited");
                reportSet.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("reports")) {
                if (parsed.contains("reports")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("reports");
                ArrayList<String> reports = new ArrayList<String>();
                reportSet.setReports(reports);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("report")) {
                        reports.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return reportSet;
    }

    private Reporting parseReporting(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Reporting reporting = new Reporting();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("excludeDefaults")) {
                if (parsed.contains("excludeDefaults")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("excludeDefaults");
                reporting.setExcludeDefaultsValue(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("outputDirectory")) {
                if (parsed.contains("outputDirectory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("outputDirectory");
                reporting.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("plugins")) {
                if (parsed.contains("plugins")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("plugins");
                ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
                reporting.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parseReportPlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return reporting;
    }

    private Repository parseRepository(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Repository repository = new Repository();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("releases")) {
                if (parsed.contains("releases")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("releases");
                repository.setReleases(this.parseRepositoryPolicy("releases", parser, strict));
                continue;
            }
            if (parser.getName().equals("snapshots")) {
                if (parsed.contains("snapshots")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("snapshots");
                repository.setSnapshots(this.parseRepositoryPolicy("snapshots", parser, strict));
                continue;
            }
            if (parser.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("id");
                repository.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                repository.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                repository.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("layout")) {
                if (parsed.contains("layout")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("layout");
                repository.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return repository;
    }

    private RepositoryBase parseRepositoryBase(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        RepositoryBase repositoryBase = new RepositoryBase();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("id");
                repositoryBase.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                repositoryBase.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                repositoryBase.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("layout")) {
                if (parsed.contains("layout")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("layout");
                repositoryBase.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return repositoryBase;
    }

    private RepositoryPolicy parseRepositoryPolicy(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("enabled")) {
                if (parsed.contains("enabled")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("enabled");
                repositoryPolicy.setEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "enabled", parser, "true"));
                continue;
            }
            if (parser.getName().equals("updatePolicy")) {
                if (parsed.contains("updatePolicy")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("updatePolicy");
                repositoryPolicy.setUpdatePolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("checksumPolicy")) {
                if (parsed.contains("checksumPolicy")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("checksumPolicy");
                repositoryPolicy.setChecksumPolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return repositoryPolicy;
    }

    private Resource parseResource(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Resource resource = new Resource();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("targetPath")) {
                if (parsed.contains("targetPath")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("targetPath");
                resource.setTargetPath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("filtering")) {
                if (parsed.contains("filtering")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("filtering");
                resource.setFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "filtering", parser, "false"));
                continue;
            }
            if (parser.getName().equals("mergeId")) {
                if (parsed.contains("mergeId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("mergeId");
                resource.setMergeId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("directory");
                resource.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                resource.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                resource.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return resource;
    }

    private Scm parseScm(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Scm scm = new Scm();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("connection")) {
                if (parsed.contains("connection")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("connection");
                scm.setConnection(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("developerConnection")) {
                if (parsed.contains("developerConnection")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("developerConnection");
                scm.setDeveloperConnection(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("tag")) {
                if (parsed.contains("tag")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("tag");
                scm.setTag(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                scm.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return scm;
    }

    private Site parseSite(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Site site = new Site();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("id");
                site.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("name");
                site.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("url");
                site.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return site;
    }

    public Model read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
        parser.next();
        return this.parseModel("project", (XmlPullParser)parser, strict);
    }

    public Model read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Model read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)in);
        return this.read((Reader)reader, strict);
    }

    public Model read(InputStream in) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)in);
        return this.read((Reader)reader);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

