/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.NotifiableTestStream;
import org.apache.maven.plugin.surefire.booterclient.output.DeserializedStacktraceWriter;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedChannelDecoder;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedChannelDecoderErrorHandler;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessPropertyEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessReportEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStackTraceEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStandardOutErrEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStringEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunMode;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.surefire.util.internal.StringUtils;

public class ForkClient
implements StreamConsumer {
    private static final String PRINTABLE_JVM_NATIVE_STREAM = "Listening for transport dt_socket at address:";
    private static final long START_TIME_ZERO = 0L;
    private static final long START_TIME_NEGATIVE_TIMEOUT = -1L;
    private final DefaultReporterFactory defaultReporterFactory;
    private final Map<String, String> testVmSystemProperties = new ConcurrentHashMap<String, String>();
    private final NotifiableTestStream notifiableTestStream;
    private final Queue<String> testsInProgress = new ConcurrentLinkedQueue<String>();
    private final AtomicLong testSetStartedAt = new AtomicLong(0L);
    private final ForkedChannelDecoder decoder = new ForkedChannelDecoder();
    private final ConsoleLogger log;
    private final AtomicBoolean printedErrorStream;
    private final int forkNumber;
    private final ForkedChannelDecoderErrorHandler errorHandler;
    private RunListener testSetReporter;
    private volatile boolean saidGoodBye;
    private volatile StackTraceWriter errorInFork;

    public ForkClient(DefaultReporterFactory defaultReporterFactory, NotifiableTestStream notifiableTestStream, ConsoleLogger log, AtomicBoolean printedErrorStream, int forkNumber) {
        this.defaultReporterFactory = defaultReporterFactory;
        this.notifiableTestStream = notifiableTestStream;
        this.log = log;
        this.printedErrorStream = printedErrorStream;
        this.forkNumber = forkNumber;
        this.decoder.setTestSetStartingListener(new TestSetStartingListener());
        this.decoder.setTestSetCompletedListener(new TestSetCompletedListener());
        this.decoder.setTestStartingListener(new TestStartingListener());
        this.decoder.setTestSucceededListener(new TestSucceededListener());
        this.decoder.setTestFailedListener(new TestFailedListener());
        this.decoder.setTestSkippedListener(new TestSkippedListener());
        this.decoder.setTestErrorListener(new TestErrorListener());
        this.decoder.setTestAssumptionFailureListener(new TestAssumptionFailureListener());
        this.decoder.setSystemPropertiesListener(new SystemPropertiesListener());
        this.decoder.setStdOutListener(new StdOutListener());
        this.decoder.setStdErrListener(new StdErrListener());
        this.decoder.setConsoleInfoListener(new ConsoleListener());
        this.decoder.setAcquireNextTestListener(new AcquireNextTestListener());
        this.decoder.setConsoleErrorListener(new ErrorListener());
        this.decoder.setByeListener(new ByeListener());
        this.decoder.setStopOnNextTestListener(new StopOnNextTestListener());
        this.decoder.setConsoleDebugListener(new DebugListener());
        this.decoder.setConsoleWarningListener(new WarningListener());
        this.errorHandler = new ErrorHandler();
    }

    protected void stopOnNextTest() {
    }

    public void kill() {
        if (!this.saidGoodBye) {
            this.notifiableTestStream.shutdown(Shutdown.KILL);
        }
    }

    public final void tryToTimeout(long currentTimeMillis, int forkedProcessTimeoutInSeconds) {
        if (forkedProcessTimeoutInSeconds > 0) {
            long forkedProcessTimeoutInMillis = 1000 * forkedProcessTimeoutInSeconds;
            long startedAt = this.testSetStartedAt.get();
            if (startedAt > 0L && currentTimeMillis - startedAt >= forkedProcessTimeoutInMillis) {
                this.testSetStartedAt.set(-1L);
                this.notifiableTestStream.shutdown(Shutdown.KILL);
            }
        }
    }

    public final DefaultReporterFactory getDefaultReporterFactory() {
        return this.defaultReporterFactory;
    }

    @Override
    public final void consumeLine(String s) {
        if (StringUtils.isNotBlank((String)s)) {
            this.processLine(s);
        }
    }

    private void setCurrentStartTime() {
        if (this.testSetStartedAt.get() == 0L) {
            this.testSetStartedAt.compareAndSet(0L, System.currentTimeMillis());
        }
    }

    public final boolean hadTimeout() {
        return this.testSetStartedAt.get() == -1L;
    }

    private RunListener getTestSetReporter() {
        if (this.testSetReporter == null) {
            this.testSetReporter = this.defaultReporterFactory.createReporter();
        }
        return this.testSetReporter;
    }

    private void processLine(String event) {
        this.decoder.handleEvent(event, this.errorHandler);
    }

    private File dumpToLoFile(String msg, Throwable e) {
        File reportsDir = this.defaultReporterFactory.getReportsDirectory();
        InPluginProcessDumpSingleton util = InPluginProcessDumpSingleton.getSingleton();
        return e == null ? util.dumpStreamText(msg, reportsDir, this.forkNumber) : util.dumpStreamException(e, msg, reportsDir, this.forkNumber);
    }

    private void logStreamWarning(String event, Throwable e) {
        if (event == null || !event.contains(PRINTABLE_JVM_NATIVE_STREAM)) {
            String msg = "Corrupted STDOUT by directly writing to native stream in forked JVM " + this.forkNumber + ".";
            File dump = this.dumpToLoFile(msg + " Stream '" + event + "'.", e);
            if (this.printedErrorStream.compareAndSet(false, true)) {
                this.log.warning(msg + " See FAQ web page and the dump file " + dump.getAbsolutePath());
            }
            if (this.log.isDebugEnabled() && event != null) {
                this.log.debug(event);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug(event);
        } else if (this.log.isInfoEnabled()) {
            this.log.info(event);
        } else {
            System.out.println(event);
        }
    }

    private void writeTestOutput(String output, boolean newLine, boolean isStdout) {
        this.getOrCreateConsoleOutputReceiver().writeTestOutput(output, newLine, isStdout);
    }

    public final void consumeMultiLineContent(String s) throws IOException {
        if (StringUtils.isBlank((String)s)) {
            this.logStreamWarning(s, null);
        } else {
            BufferedReader stringReader = new BufferedReader(new StringReader(s));
            String s1 = stringReader.readLine();
            while (s1 != null) {
                this.consumeLine(s1);
                s1 = stringReader.readLine();
            }
        }
    }

    public final Map<String, String> getTestVmSystemProperties() {
        return Collections.unmodifiableMap(this.testVmSystemProperties);
    }

    public final RunListener getReporter() {
        return this.getTestSetReporter();
    }

    private ConsoleOutputReceiver getOrCreateConsoleOutputReceiver() {
        return (ConsoleOutputReceiver)this.getTestSetReporter();
    }

    private ConsoleLogger getOrCreateConsoleLogger() {
        return (ConsoleLogger)this.getTestSetReporter();
    }

    public void close(boolean hadTimeout) {
    }

    public final boolean isSaidGoodBye() {
        return this.saidGoodBye;
    }

    public final StackTraceWriter getErrorInFork() {
        return this.errorInFork;
    }

    public final boolean isErrorInFork() {
        return this.errorInFork != null;
    }

    public Set<String> testsInProgress() {
        return new TreeSet<String>(this.testsInProgress);
    }

    public boolean hasTestsInProgress() {
        return !this.testsInProgress.isEmpty();
    }

    private StackTraceWriter deserializeStackTraceWriter(String stackTraceMessage, String smartStackTrace, String stackTrace) {
        boolean hasTrace = stackTrace != null;
        return hasTrace ? new DeserializedStacktraceWriter(stackTraceMessage, smartStackTrace, stackTrace) : null;
    }

    private final class WarningListener
    implements ForkedProcessStringEventListener {
        private WarningListener() {
        }

        @Override
        public void handle(String msg) {
            ForkClient.this.getOrCreateConsoleLogger().warning(msg);
        }
    }

    private final class DebugListener
    implements ForkedProcessStringEventListener {
        private DebugListener() {
        }

        @Override
        public void handle(String msg) {
            ForkClient.this.getOrCreateConsoleLogger().debug(msg);
        }
    }

    private final class StopOnNextTestListener
    implements ForkedProcessEventListener {
        private StopOnNextTestListener() {
        }

        @Override
        public void handle() {
            ForkClient.this.stopOnNextTest();
        }
    }

    private final class ByeListener
    implements ForkedProcessEventListener {
        private ByeListener() {
        }

        @Override
        public void handle() {
            ForkClient.this.saidGoodBye = true;
            ForkClient.this.notifiableTestStream.acknowledgeByeEventReceived();
        }
    }

    private class ErrorListener
    implements ForkedProcessStackTraceEventListener {
        private ErrorListener() {
        }

        @Override
        public void handle(String msg, String smartStackTrace, String stackTrace) {
            if (ForkClient.this.errorInFork == null) {
                ForkClient.this.errorInFork = ForkClient.this.deserializeStackTraceWriter(msg, smartStackTrace, stackTrace);
                if (msg != null) {
                    ForkClient.this.getOrCreateConsoleLogger().error(msg);
                }
            }
            ForkClient.this.dumpToLoFile(msg, null);
        }
    }

    private final class AcquireNextTestListener
    implements ForkedProcessEventListener {
        private AcquireNextTestListener() {
        }

        @Override
        public void handle() {
            ForkClient.this.notifiableTestStream.provideNewTest();
        }
    }

    private final class ConsoleListener
    implements ForkedProcessStringEventListener {
        private ConsoleListener() {
        }

        @Override
        public void handle(String msg) {
            ForkClient.this.getOrCreateConsoleLogger().info(msg);
        }
    }

    private final class StdErrListener
    implements ForkedProcessStandardOutErrEventListener {
        private StdErrListener() {
        }

        @Override
        public void handle(RunMode runMode, String output, boolean newLine) {
            ForkClient.this.writeTestOutput(output, newLine, false);
        }
    }

    private final class StdOutListener
    implements ForkedProcessStandardOutErrEventListener {
        private StdOutListener() {
        }

        @Override
        public void handle(RunMode runMode, String output, boolean newLine) {
            ForkClient.this.writeTestOutput(output, newLine, true);
        }
    }

    private final class SystemPropertiesListener
    implements ForkedProcessPropertyEventListener {
        private SystemPropertiesListener() {
        }

        @Override
        public void handle(RunMode runMode, String key, String value) {
            ForkClient.this.testVmSystemProperties.put(key, value);
        }
    }

    private final class TestAssumptionFailureListener
    implements ForkedProcessReportEventListener {
        private TestAssumptionFailureListener() {
        }

        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testAssumptionFailure(reportEntry);
        }
    }

    private final class TestErrorListener
    implements ForkedProcessReportEventListener {
        private TestErrorListener() {
        }

        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testError(reportEntry);
        }
    }

    private final class TestSkippedListener
    implements ForkedProcessReportEventListener {
        private TestSkippedListener() {
        }

        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testSkipped(reportEntry);
        }
    }

    private final class TestFailedListener
    implements ForkedProcessReportEventListener {
        private TestFailedListener() {
        }

        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testFailed(reportEntry);
        }
    }

    private final class TestSucceededListener
    implements ForkedProcessReportEventListener {
        private TestSucceededListener() {
        }

        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testSucceeded(reportEntry);
        }
    }

    private final class TestStartingListener
    implements ForkedProcessReportEventListener {
        private TestStartingListener() {
        }

        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.offer(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testStarting(reportEntry);
        }
    }

    private final class TestSetCompletedListener
    implements ForkedProcessReportEventListener<TestSetReportEntry> {
        private TestSetCompletedListener() {
        }

        @Override
        public void handle(RunMode runMode, TestSetReportEntry reportEntry) {
            ForkClient.this.testsInProgress.clear();
            TestSetReportEntry entry = CategorizedReportEntry.reportEntry((String)reportEntry.getSourceName(), (String)reportEntry.getSourceText(), (String)reportEntry.getName(), (String)reportEntry.getNameText(), (String)reportEntry.getGroup(), (StackTraceWriter)reportEntry.getStackTraceWriter(), (Integer)reportEntry.getElapsed(), (String)reportEntry.getMessage(), ForkClient.this.getTestVmSystemProperties());
            ForkClient.this.getTestSetReporter().testSetCompleted(entry);
        }
    }

    private final class TestSetStartingListener
    implements ForkedProcessReportEventListener<TestSetReportEntry> {
        private TestSetStartingListener() {
        }

        @Override
        public void handle(RunMode runMode, TestSetReportEntry reportEntry) {
            ForkClient.this.getTestSetReporter().testSetStarting(reportEntry);
            ForkClient.this.setCurrentStartTime();
        }
    }

    private final class ErrorHandler
    implements ForkedChannelDecoderErrorHandler {
        private ErrorHandler() {
        }

        @Override
        public void handledError(String line, Throwable e) {
            ForkClient.this.logStreamWarning(line, e);
        }
    }
}

