/****************************************************************************
*
*  EditForm.h
*
*  This file is part of the CodeMax editor support code.
*
*  Copyright  POV-Team(tm) 1996-1998. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-1998 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  NOTE : As this is Windows code, it was edited using a wide Windows-hosted
*         editor. Accordingly, expect text to exceed 80 columns regularly.
*
*  from Persistence of Vision Raytracer(tm)
*  Copyright 1996-1998 Persistence of Vision Team
*
* The terms POV-Ray, POV, and Persistence of Vision Raytracer are trademarks
* of the Persistence of Vision Team.
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray(tm) and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray(tm)
*  Team Coordinator by leaving a message in CompuServe's POVRAY forum. The
*  The latest version of POV-Ray may be found there as well. POVRAY files can
*  also be found on the world wide web at http://www.povray.org/.
*
*  In the case of this particular program, POVLEGAL.DOC is also embedded
*  in the source code. See the file ../PVLEGAL.H.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* Thanks to the makers of PERFORCE (http://www.perforce.com/) for donating the
* copy of their Perforce revision control system that is now used to maintain
* the POVWIN source. Thanks also to WinMain Software (http://www.winmain.com/)
* for providing the CodeMax edit control which the POVWIN 3.1 editor is based
* upon.
*
* $Id: //depot/POVRAY/povwin/source/windows/codemax/EditForm.h#7$
*
*****************************************************************************/

#ifndef EditFormH
#define EditFormH
//---------------------------------------------------------------------------
#include <registry.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include "TCodeMax.h"
#include <Menus.hpp>
#include <Dialogs.hpp>
#include "cdiroutl.h"
#include <Grids.hpp>
#include <Outline.hpp>
#include "CTabControl.h"
#include "Htmlview.hpp"

//---------------------------------------------------------------------------
typedef struct
{
  FILETIME              TimeSaved ;
  AnsiString            ShortName ;
  AnsiString            LongName ;
} EditTagStruct ;

//---------------------------------------------------------------------------
class TRegDef : public TRegistry
{
  public:
    TRegDef (AnsiString Path) ;
    int ReadInt (AnsiString Name, int defval) ;
    bool ReadBool (AnsiString Name, bool defval) ;
    int ReadBin (AnsiString Name, char *data, int len, char *defval) ;
    int ReadBin (AnsiString Name, char **data, int len, char *defval) ;
    AnsiString ReadString (AnsiString Name, AnsiString defval) ;
} ;

//---------------------------------------------------------------------------
class TParentForm : public TForm
{
  __published:
    TPopupMenu *PopupMenu;
    TMenuItem *pmiContextHelp;
    TMenuItem *pmiOpenFile;
    TMenuItem *pmiCloseFile;
    TMenuItem *pmiShowMessages;
    TPopupMenu *Menus;
    TMenuItem *miFileMenu;
    TMenuItem *miNewFile;
    TMenuItem *miOpenFile;
    TMenuItem *N13;
    TMenuItem *miCloseFile;
    TMenuItem *miCloseAllFiles;
    TMenuItem *N14;
    TMenuItem *miSave;
    TMenuItem *miSaveAs;
    TMenuItem *miSaveAll;
    TMenuItem *N2;
    TMenuItem *miPrint;
    TMenuItem *miPrintSetup;
    TMenuItem *miExit;
    TMenuItem *FileBreak;
    TMenuItem *miEditMenu;
    TMenuItem *miUndo;
    TMenuItem *N6;
    TMenuItem *miCut;
    TMenuItem *miCopy;
    TMenuItem *miPaste;
    TMenuItem *miSearchMenu;
    TMenuItem *miFind;
    TMenuItem *miReplace;
    TMenuItem *miFindNext;
    TMenuItem *N3;
    TMenuItem *miGoToLine;
    TMenuItem *miEditorMenu;
    TMenuItem *miCreateBackups;
    TPrintDialog *PrintDialog;
    TOpenDialog *OpenDialog;
    TSaveDialog *SaveDialog;
    TMenuItem *pmiCut;
    TMenuItem *pmiCopy;
    TMenuItem *pmiPaste;
    TMenuItem *pmiUndo;
    TMenuItem *pmiRedo;
    TMenuItem *N01;
    TMenuItem *N11;
    TMenuItem *miRedo;
    TMenuItem *N5;
    TMenuItem *miProperties;
    TMenuItem *pmiProperties;
    TTimer *EditDragPanelTimer;
    TMenuItem *miUndoAfterSave;
    TMenuItem *miInsertMenu;
    TMenuItem *miEditInsertMenu;
    TMenuItem *miAutoReload;
    TMenuItem *miAutoReloadNever;
    TMenuItem *miAutoReloadAsk;
    TMenuItem *miAutoReloadAlways;
    TMenuItem *N1;
    TMenuItem *N7;
    TPanel *EditDragPanel;
    TPanel *HiddenPanel;
    TMenuItem *N8;
    TMenuItem *miOlderFiles;
    TMenuItem *miShowParseMessages;
    TMenuItem *miAutoLoadErrorFile;
    TMenuItem *N9;
    TMenuItem *miSelectAll;
    TMenuItem *miTextMenu;
    TMenuItem *miBookmarks;
    TMenuItem *miClearAllBookmarks;
    TMenuItem *miFirstBookmark;
    TMenuItem *miLastBookmark;
    TMenuItem *miNextBookmark;
    TMenuItem *miPreviousBookmark;
    TMenuItem *miToggleBookmark;
    TMenuItem *miDelete;
    TMenuItem *miMatchBrace;
    TMenuItem *miPlayMacro;
    TMenuItem *miPlayMacro1;
    TMenuItem *miPlayMacro2;
    TMenuItem *miPlayMacro9;
    TMenuItem *miPlayMacro8;
    TMenuItem *miPlayMacro7;
    TMenuItem *miPlayMacro6;
    TMenuItem *miPlayMacro5;
    TMenuItem *miPlayMacro4;
    TMenuItem *miPlayMacro3;
    TMenuItem *miPlayMacro10;
    TMenuItem *miRecordMacro;
    TMenuItem *miSetRepeatCount;
    TMenuItem *N10;
    TMenuItem *miShowWhiteSpace;
    TMenuItem *N12;
    TMenuItem *miIndentStyle;
    TMenuItem *miIndentStyleCopy;
    TMenuItem *miIndentStyleLanguage;
    TMenuItem *miIndentStyleNone;
    TMenuItem *miSelection;
    TMenuItem *miTabsToSpaces;
    TMenuItem *miSpacesToTabs;
    TMenuItem *miLowercaseSelection;
    TMenuItem *miUppercaseSelection;
    TMenuItem *miUndentSelection;
    TMenuItem *miIndentSelectionPrevious;
    TMenuItem *miIndentSelection;
    TMenuItem *N16;
    TMenuItem *miSetTabSize;
    TMenuItem *miScrollBars;
    TMenuItem *miScrollNone;
    TMenuItem *miScrollHorizontal;
    TMenuItem *miScrollVertical;
    TMenuItem *miScrollBoth;
    TTimer *AutoSaveTimer;
    TMenuItem *miAutoSave;
    TMenuItem *miShowMessages;
    TMenuItem *miColourScheme;
    TMenuItem *miCustomColours;
    TMenuItem *miBlackOnWhite;
    TMenuItem *miWhiteOnBlack;
    TMenuItem *pmiOpenFileUnderCursor;
    TPanel *MessagePanel;
    TTabControl *Tab;
    TMenuItem *miExtraIndent;
    TMenuItem *miExtraIndentSelection;
    TMenuItem *miExtraUndentSelection;
    TMenuItem *miExtraIndentSelectionPrevious;
    TMenuItem *pmiSelection;
    TMenuItem *pmiTabsToSpaces;
    TMenuItem *pmiSpacesToTabs;
    TMenuItem *pmiLowercaseSelection;
    TMenuItem *pmiUppercaseSelection;
    TMenuItem *pmiUndentSelection;
    TMenuItem *pmiIndentSelectionPrevious;
    TMenuItem *pmiIndentSelection;
    TMenuItem *N17;
    TMenuItem *pmiSearch;
    TMenuItem *pmiGoToLine;
    TMenuItem *pmiMatchBrace;
    TMenuItem *N18;
    TMenuItem *pmiFindNext;
    TMenuItem *pmiReplace;
    TMenuItem *pmiFile;
    TMenuItem *pmiSave;
    TMenuItem *pmiSaveAs;
    TMenuItem *pmiSaveAll;
    TMenuItem *pmiBookmark;
    TMenuItem *pmiToggleBookmark;
    TMenuItem *pmiPreviousBookmark;
    TMenuItem *pmiNextBookmark;
    TMenuItem *pmiLastBookmark;
    TMenuItem *pmiFirstBookmark;
    TMenuItem *pmiClearAllBookmarks;
    TMenuItem *pmiFind;
    TMenuItem *pmiPrint;
    TMenuItem *pmiCloseCurrentFile;
    TMenuItem *miCursorBeyondEOL;
    void __fastcall MessagePanelResize(TObject *Sender);
    void __fastcall TabChange(TObject *Sender);
    
    
    
    void __fastcall miNewFileClick(TObject *Sender);
    void __fastcall miOpenFileClick(TObject *Sender);
    void __fastcall miCloseFileClick(TObject *Sender);
    void __fastcall miCloseAllFilesClick(TObject *Sender);
    void __fastcall miPrintClick(TObject *Sender);
    
    void __fastcall miExitClick(TObject *Sender);
    void __fastcall miPrintSetupClick(TObject *Sender);
    
    void __fastcall miSaveAllClick(TObject *Sender);
    void __fastcall miSaveClick(TObject *Sender);
    void __fastcall miSaveAsClick(TObject *Sender);
    void __fastcall miUndoAfterSaveClick(TObject *Sender);
    void __fastcall miPropertiesClick(TObject *Sender);

    
    void __fastcall miUndoClick(TObject *Sender);
    void __fastcall miRedoClick(TObject *Sender);
    void __fastcall miCutClick(TObject *Sender);
    void __fastcall miCopyClick(TObject *Sender);
    void __fastcall miPasteClick(TObject *Sender);
    void __fastcall MenusPopup(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall miFindClick(TObject *Sender);
    void __fastcall miReplaceClick(TObject *Sender);
    void __fastcall miFindNextClick(TObject *Sender);
    void __fastcall miGoToLineClick(TObject *Sender);
    
    void __fastcall pmiContextHelpClick(TObject *Sender);
    
    void __fastcall miEditInsertMenuClick(TObject *Sender);
    
    void __fastcall EditDragPanelMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
    void __fastcall FormResize(TObject *Sender);
    void __fastcall EditDragPanelMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
    void __fastcall EditDragPanelMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
    void __fastcall pmiShowMessagesClick(TObject *Sender);
    void __fastcall EditDragPanelTimerTimer(TObject *Sender);
    void __fastcall miShowParseMessagesClick(TObject *Sender);
    void __fastcall miAutoLoadErrorFileClick(TObject *Sender);
    
    void __fastcall miSelectAllClick(TObject *Sender);
    void __fastcall miDeleteClick(TObject *Sender);
    void __fastcall miIndentSelectionClick(TObject *Sender);
    void __fastcall miUndentSelectionClick(TObject *Sender);
    void __fastcall miIndentSelectionPreviousClick(TObject *Sender);
    void __fastcall miUppercaseSelectionClick(TObject *Sender);
    void __fastcall miLowercaseSelectionClick(TObject *Sender);
    void __fastcall miSpacesToTabsClick(TObject *Sender);
    void __fastcall miTabsToSpacesClick(TObject *Sender);
    void __fastcall miMatchBraceClick(TObject *Sender);
    void __fastcall miSetRepeatCountClick(TObject *Sender);
    void __fastcall miRecordMacroClick(TObject *Sender);
    void __fastcall miPlayMacroClick(TObject *Sender);
    void __fastcall miClearAllBookmarksClick(TObject *Sender);
    void __fastcall miFirstBookmarkClick(TObject *Sender);
    void __fastcall miLastBookmarkClick(TObject *Sender);
    void __fastcall miNextBookmarkClick(TObject *Sender);
    void __fastcall miPreviousBookmarkClick(TObject *Sender);
    void __fastcall miToggleBookmarkClick(TObject *Sender);
    void __fastcall miShowWhiteSpaceClick(TObject *Sender);
    void __fastcall miIndentStyleClick(TObject *Sender);
    void __fastcall miSetTabSizeClick(TObject *Sender);
    void __fastcall miScrollBarsClick(TObject *Sender);
    void __fastcall miCreateBackupsClick(TObject *Sender);
    void __fastcall miAutoSaveClick(TObject *Sender);
    void __fastcall AutoSaveTimerTimer(TObject *Sender);
    
    void __fastcall miBlackOnWhiteClick(TObject *Sender);
    void __fastcall miWhiteOnBlackClick(TObject *Sender);
    void __fastcall pmiOpenFileUnderCursorClick(TObject *Sender);
    void __fastcall PopupMenuPopup(TObject *Sender);
    
    void __fastcall miAutoReloadAlwaysClick(TObject *Sender);
    
    
    void __fastcall miCursorBeyondEOLClick(TObject *Sender);
    
  private:
    virtual void __fastcall CreateParams (TCreateParams &Params) ;

  public:
    __fastcall TParentForm(TComponent* Owner);
    TCodeMax *CreateNewEditor (char *FileName, bool ReadOnly = false, bool ShowIt = true) ;
    bool CanClose (bool AllFiles) ;
    void __fastcall EditParentWndProc (Messages::TMessage& Message) ;
    void __fastcall CodeMaxKeyUp(TObject *Sender, WORD &Key, TShiftState Shift) ;
    void SetMenuState (void) ;
    void __fastcall RecentMenuClick (TObject *Sender) ;
    void __fastcall TabWndProc (Messages::TMessage& Message) ;
    void __fastcall InsertMenuClick (TObject *Sender) ;
    void ShowEditDragPanel (bool Showing) ;
    void GetSettings (TRegDef *t, bool RestoreFiles) ;
    void PutSettings (TRegDef *t) ;
    void __fastcall OlderMenuClick (TObject *Sender) ;
    void __fastcall CodeMaxKeyDown(TObject *Sender, WORD &Key, TShiftState Shift) ;
    void SetMenuShortcut (TMenuItem *m, WORD Command) ;
    void SetMenuShortcut (TMenuItem *m1, TMenuItem *m2, WORD Command) ;
    HWND Initialise (void) ;
    void SetMenuShortcuts (void) ;
    void __fastcall OnHint (TObject* Sender) ;
    AnsiString LocateIncludeFilename (int line, int col, TCodeMax *e) ;
//---------------------------------------------------------------------------
};
//---------------------------------------------------------------------------
extern PACKAGE TParentForm *ParentForm;
//---------------------------------------------------------------------------
#endif
