diff -c3 -o -r ./change31.doc \povray3/change31.doc
*** ./change31.doc	Sat Jan 30 14:38:54 1999
--- \povray3/change31.doc	Fri Mar  5 14:21:30 1999
***************
*** 1,5 ****
--- 1,9 ----
  This file is a historical record of changes to POV-Ray 3.1 as we develop it.
  
+ 3.1e               03/05/99 Chris Young
+ Fixed bump_map bug introduced in 3.1a
+ Misc unix/linux fixes and cleanups
+ 
  3.1d               1/30/99 Chris Young
  Fixed crash in #write of vector or float
  Added #write and #read now support 2d, 4d, & 5d vectors.
diff -c3 -o -r ./source/express.c \povray3/source/express.c
*** ./source/express.c	Thu Jan 14 14:48:42 1999
--- \povray3/source/express.c	Fri Mar  5 13:49:58 1999
***************
*** 20,25 ****
--- 20,27 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Thomas Willhalm, March 1999, used with permission
+ *
  *****************************************************************************/
  
  #include <ctype.h>
***************
*** 2545,2551 ****
  DBL Parse_Signed_Float(void)
  {
     DBL Sign=1.0;
!    DBL Val;
    
     EXPECT
       CASE (PLUS_TOKEN)
--- 2547,2553 ----
  DBL Parse_Signed_Float(void)
  {
     DBL Sign=1.0;
!    DBL Val=0.0; /* tw */
    
     EXPECT
       CASE (PLUS_TOKEN)
diff -c3 -o -r ./source/gif.c \povray3/source/gif.c
*** ./source/gif.c	Fri May 15 23:22:08 1998
--- \povray3/source/gif.c	Fri Mar  5 13:49:58 1999
***************
*** 22,27 ****
--- 22,29 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modification by Hans-Deltev Fink, January 1999, used with permission
+ *
  *****************************************************************************/
  
  /*
***************
*** 379,383 ****
      }
    }
  
!   fclose(Bit_File);
  }
--- 381,390 ----
      }
    }
  
!   if (Bit_File != NULL)		/* -hdf99- */
!   {
!     fclose(Bit_File);
!   }
! 
  }
+ 
diff -c3 -o -r ./source/iff.c \povray3/source/iff.c
*** ./source/iff.c	Fri May 22 16:47:46 1998
--- \povray3/source/iff.c	Fri Mar  5 13:49:58 1999
***************
*** 19,24 ****
--- 19,25 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Hans-Detlev Fink, January 1999, used with permission
  *****************************************************************************/
  
  #include "frame.h"
***************
*** 288,293 ****
--- 289,295 ----
    if ((f = Locate_File(filename, READ_BINFILE_STRING, ".iff", ".IFF",NULL,TRUE)) == NULL)
    {
      Error("Error opening IFF image.\n");
+     return;	/* -hdf99- */
    }
  
    Previous_Red = Previous_Green = Previous_Blue = 0;
***************
*** 572,580 ****
  
            POV_FREE(row_bytes);
          }
! 
!         fclose(f);
! 
          return;
  
        default:
--- 574,583 ----
  
            POV_FREE(row_bytes);
          }
!         if (f != NULL)		/* -hdf99- */
!         {
!           fclose(f);
!         }
          return;
  
        default:
diff -c3 -o -r ./source/image.c \povray3/source/image.c
*** ./source/image.c	Fri Jan 15 16:31:56 1999
--- \povray3/source/image.c	Fri Mar  5 13:50:32 1999
***************
*** 359,365 ****
    VCross(zprime, xprime, yprime);
    VNormalizeEq(zprime);
    VScaleEq(xprime, bump_normal[X]);
!   VScaleEq(yprime, bump_normal[Y]);
    VScaleEq(zprime, bump_normal[Z]);
    VAdd(Temp, xprime, yprime);
    VAdd(normal, Temp, zprime);
--- 359,365 ----
    VCross(zprime, xprime, yprime);
    VNormalizeEq(zprime);
    VScaleEq(xprime, bump_normal[X]);
!   VScaleEq(yprime, (-bump_normal[Y]));
    VScaleEq(zprime, bump_normal[Z]);
    VAdd(Temp, xprime, yprime);
    VAdd(normal, Temp, zprime);
diff -c3 -o -r ./source/lathe.c \povray3/source/lathe.c
*** ./source/lathe.c	Mon Jun  1 18:10:50 1998
--- \povray3/source/lathe.c	Fri Mar  5 13:49:58 1999
***************
*** 21,26 ****
--- 21,28 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modification from Thomas Willhalm, March 1999, used with permission
+ *
  *****************************************************************************/
  
  /****************************************************************************
***************
*** 1141,1146 ****
--- 1143,1153 ----
        number_of_segments = Lathe->Number / 4;
  
        break;
+ 
+   default: /* tw */
+ 
+     number_of_segments = 0; /* tw */
+ 
    }
  
    /* Allocate segments. */
diff -c3 -o -r ./source/lighting.c \povray3/source/lighting.c
*** ./source/lighting.c	Mon Jan 18 16:04:44 1999
--- \povray3/source/lighting.c	Fri Mar  5 13:49:58 1999
***************
*** 19,24 ****
--- 19,27 ----
  * This program is based on the popular DKB raytracer version 2.12.
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
+ * 
+ * Modifications by Robert G. Smith & Andreas Dilger, March 1999, used with
+ * permission
  *
  *****************************************************************************/
  
***************
*** 1553,1559 ****
  
    if (Cos_Angle_Of_Incidence > 0.0)
    {
!     Intensity = Finish->Phong * pow(Cos_Angle_Of_Incidence, Finish->Phong_Size);
  
      if (Finish->Metallic > 0.0)
      {
--- 1556,1565 ----
  
    if (Cos_Angle_Of_Incidence > 0.0)
    {
!     if ((Finish->Phong_Size < 60) || (Cos_Angle_Of_Incidence > .0008)) /* rgs */
!       Intensity = Finish->Phong * pow(Cos_Angle_Of_Incidence, Finish->Phong_Size);
!     else
!       Intensity = 0.0; /* ad */
  
      if (Finish->Metallic > 0.0)
      {
diff -c3 -o -r ./source/octree.c \povray3/source/octree.c
*** ./source/octree.c	Fri May 22 12:55:14 1998
--- \povray3/source/octree.c	Fri Mar  5 13:49:58 1999
***************
*** 21,26 ****
--- 21,28 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Thomas Willhalm, March 1999, used with permission
+ *
  *****************************************************************************/
  
  /************************************************************************
***************
*** 885,891 ****
  
    if ( bl->Bounce_Depth == 1 )
    {
!     fprintf((FILE *)fd, "C%ld\t%g\t%g\t%g\t%02x%02x%02x\t%.4f\t%.4f\t%.4f\t%g\t%g\t%02x%02x%02x\n",
        (long)bl->Bounce_Depth,
  
        bl->Point[X], bl->Point[Y], bl->Point[Z],
--- 887,893 ----
  
    if ( bl->Bounce_Depth == 1 )
    {
!     fprintf((FILE *)fd, "C%ld\t%g\t%g\t%g\t%02lx%02lx%02lx\t%.4f\t%.4f\t%.4f\t%g\t%g\t%02lx%02lx%02lx\n", /* tw */
        (long)bl->Bounce_Depth,
  
        bl->Point[X], bl->Point[Y], bl->Point[Z],
***************
*** 1089,1096 ****
          }    
          case 'C':
          {
!           count = sscanf(line, "C%d %lf %lf %lf %s %f %f %f %f %f %s\n",
!                      &tempdepth,      /* since you can't scan a short */
                       &bl.Point[X], &bl.Point[Y], &bl.Point[Z],
                       normal_string,
                       &bl.Illuminance[X], &bl.Illuminance[Y], &bl.Illuminance[Z],
--- 1091,1098 ----
          }    
          case 'C':
          {
!           count = sscanf(line, "C%ld %lf %lf %lf %s %f %f %f %f %f %s\n", /* tw */
! 		     &tempdepth,      /* since you can't scan a short */
                       &bl.Point[X], &bl.Point[Y], &bl.Point[Z],
                       normal_string,
                       &bl.Illuminance[X], &bl.Illuminance[Y], &bl.Illuminance[Z],
diff -c3 -o -r ./source/optin.c \povray3/source/optin.c
*** ./source/optin.c	Sat Jul 11 18:40:52 1998
--- \povray3/source/optin.c	Fri Mar  5 13:49:58 1999
***************
*** 32,37 ****
--- 32,39 ----
  *
  *  ---
  *
+ * Modification by Thomas Willhalm, March 1999, used with permission.
+ *
  *****************************************************************************/
  
  #include <ctype.h>
***************
*** 745,751 ****
  
          case 'f':
          case 'F':
!           if(isdigit(Option_String[2]))
              process_variable(SUBSET_END_FRAME_OP, &Option_String[2]);
            break;
  
--- 747,753 ----
  
          case 'f':
          case 'F':
!           if(isdigit((int)Option_String[2])) /* tw */
              process_variable(SUBSET_END_FRAME_OP, &Option_String[2]);
            break;
  
***************
*** 874,880 ****
        }
        else
        {
!         if (!isdigit (Option_String [1]))
          {
            switch (Option_String [1])
            {
--- 876,882 ----
        }
        else
        {
!         if (!isdigit ((int)Option_String [1])) /* tw */
          {
            switch (Option_String [1])
            {
***************
*** 1412,1417 ****
--- 1414,1420 ----
  
      case START_COLUMN_OP:
        if (sscanf (value, DBL_FORMAT_STRING, &floatval) != SCANF_EOF)
+       { /* tw */
          if(floatval > 0.0 && floatval < 1.0)
          {
            opts.First_Column = -1;
***************
*** 1422,1431 ****
--- 1425,1436 ----
            /* The above used to have -1 but it messed up Write_INI_File.
             * Moved -1 fudge to fix_up_rendering_window 
             */
+       } /* tw */
        return;
  
      case START_ROW_OP:
        if (sscanf (value, DBL_FORMAT_STRING, &floatval) != SCANF_EOF)
+       { /* tw */
          if(floatval > 0.0 && floatval < 1.0)
          {
            opts.First_Line = -1;
***************
*** 1436,1444 ****
--- 1441,1451 ----
            /* The above used to have -1 but it messed up Write_INI_File
            * Moved -1 fudge to fix_up_rendering_window 
            */
+       } /* tw */
        return;
  
      case END_COLUMN_OP:
+       { /* tw */
        if (sscanf (value, DBL_FORMAT_STRING, &floatval) != SCANF_EOF)
          if(floatval > 0.0 && floatval <= 1.0)
          {
***************
*** 1447,1455 ****
--- 1454,1464 ----
          }
          else
            opts.Last_Column = (int) floatval;
+       } /* tw */
        return;
  
      case END_ROW_OP:
+       { /* tw */ 
        if (sscanf (value, DBL_FORMAT_STRING, &floatval) != SCANF_EOF)
          if(floatval > 0.0 && floatval <= 1.0)
          {
***************
*** 1458,1463 ****
--- 1467,1473 ----
          }
          else
            opts.Last_Line = (int) floatval;
+       } /* tw */
        return;
  
      case VERSION_OP:
diff -c3 -o -r ./source/optout.h \povray3/source/optout.h
*** ./source/optout.h	Sat Jan 30 14:19:00 1999
--- \povray3/source/optout.h	Fri Mar  5 15:09:48 1999
***************
*** 33,39 ****
  
  /* These are used by OPTOUT.C and the machine specific modules */
  
! #define POV_RAY_VERSION "3.1d"
  
  #define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
  #define DISTRIBUTION_MESSAGE_2 "FILL IN NAME HERE........................."
--- 33,39 ----
  
  /* These are used by OPTOUT.C and the machine specific modules */
  
! #define POV_RAY_VERSION "3.1e"
  
  #define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
  #define DISTRIBUTION_MESSAGE_2 "FILL IN NAME HERE........................."
diff -c3 -o -r ./source/parse.c \povray3/source/parse.c
*** ./source/parse.c	Sat Jan 30 13:53:00 1999
--- \povray3/source/parse.c	Fri Mar  5 13:49:58 1999
***************
*** 19,24 ****
--- 19,26 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Thomas Willhalm, March 1999, used with permission.
+ *
  *****************************************************************************/
  
  #include "frame.h"
***************
*** 4793,4803 ****
  
  void Parse_Declare ()
  {
!   int Previous;
    int Local_Index,Local_Flag;
    SYM_ENTRY *Temp_Entry;
!   
!   if (Local_Flag=(Token.Token_Id==LOCAL_TOKEN))
    {
       Local_Index=Table_Index;
    }
--- 4795,4805 ----
  
  void Parse_Declare ()
  {
!   int Previous=-1; /* tw */
    int Local_Index,Local_Flag;
    SYM_ENTRY *Temp_Entry;
! 
!   if ((Local_Flag=(Token.Token_Id==LOCAL_TOKEN))) /* tw */
    {
       Local_Index=Table_Index;
    }
***************
*** 6245,6250 ****
--- 6247,6253 ----
         break;
       default:
         Error("Cannot copy identifier");
+        New = NULL; /* tw */
     }
     return(New);
  }
diff -c3 -o -r ./source/parstxtr.c \povray3/source/parstxtr.c
*** ./source/parstxtr.c	Wed Jan  6 21:53:54 1999
--- \povray3/source/parstxtr.c	Fri Mar  5 13:49:58 1999
***************
*** 19,24 ****
--- 19,26 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Thomas Willhalm, March 1999, used with permission.
+ *
  *****************************************************************************/
  
  #include "frame.h"
***************
*** 1048,1057 ****
--- 1050,1061 ----
     END_EXPECT    /* End [tnormal_id] */
  
     if (*Tnormal_Ptr == NULL)
+    { /* tw */
       if ((Default_Texture->Tnormal) != NULL)
         *Tnormal_Ptr = Copy_Tnormal ((Default_Texture->Tnormal));
       else
         *Tnormal_Ptr = Create_Tnormal ();
+    } /* tw */
  
     Parse_Pattern((TPATTERN *)*Tnormal_Ptr,NORMAL_TYPE);
    }
***************
*** 3074,3088 ****
--- 3078,3096 ----
        if (Local_Vector[X]!=0.0) 
          Repeat->Axis=X;
        if (Local_Vector[Y]!=0.0)
+       { /* tw */
          if (Repeat->Axis < X)
            Repeat->Axis=Y;
          else 
            Error("Can only repeat along 1 axis.");
+       } /* tw */
        if (Local_Vector[Z]!=0.0)
+       { /* tw */
          if (Repeat->Axis < X)
            Repeat->Axis=Z;
          else
            Error("Can only repeat along 1 axis.");
+       } /* tw */
        if (Repeat->Axis < X)
          Error("No axis specified in repeat.");
        Repeat->Width=Local_Vector[Repeat->Axis];
diff -c3 -o -r ./source/pattern.c \povray3/source/pattern.c
*** ./source/pattern.c	Mon Sep 28 15:10:28 1998
--- \povray3/source/pattern.c	Fri Mar  5 13:50:00 1999
***************
*** 20,25 ****
--- 20,28 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Hans-Detlev Fink, January 1999, used with permission
+ * Modifications by Thomas Willhalm, March 1999, used with permission
+ *
  *****************************************************************************/
  
  /*
***************
*** 2452,2459 ****
      *New = *Old;
  
      New->Data->References++;
!  }
! 
    return(New);
  }
  
--- 2455,2464 ----
      *New = *Old;
  
      New->Data->References++;
!   }
!   else          /* tw */
!     New = NULL; /* tw */
!     
    return(New);
  }
  
***************
*** 2553,2559 ****
  
      df->Data->Density = map;
  
!     fclose(file);
    }
  }
  
--- 2558,2568 ----
  
      df->Data->Density = map;
  
!     if (file != NULL)		/* -hdf99- */
!     {
!       fclose(file);
!     }
! 
    }
  }
  
diff -c3 -o -r ./source/pgm.c \povray3/source/pgm.c
*** ./source/pgm.c	Fri May 15 23:22:56 1998
--- \povray3/source/pgm.c	Fri Mar  5 13:50:00 1999
***************
*** 22,27 ****
--- 22,29 ----
  * Original patch copyright 1994 Tim Rowley
  * Updated for POV 3.0 by Chris Cason, Jan '95.
  *
+ * Modifications by Hans-Detlev Fink, January 1999, used with permission
+ *
  *****************************************************************************/
  
  /****************************************************************************
***************
*** 82,92 ****
--- 84,96 ----
    if ((infile = Locate_File(name,READ_BINFILE_STRING,".pgm",".PGM",NULL,TRUE)) == NULL)
    {
      Error ("Cannot open PGM image %s.\n", name);
+     return;	/* -hdf99- */
    }
  
    if (fscanf(infile,"P%c\n",&type) != 1 || (type != '2' && type != '5'))
    {
      Error ("File is not in PGM format.\n");
+     return;	/* -hdf99- */
    }
  
    /* Ignore any comments */
diff -c3 -o -r ./source/png_pov.c \povray3/source/png_pov.c
*** ./source/png_pov.c	Mon Nov  9 18:10:32 1998
--- \povray3/source/png_pov.c	Fri Mar  5 13:50:00 1999
***************
*** 27,32 ****
--- 27,34 ----
  * Updated to use the libpng 0.87 messaging functions, Dec 1995
  * Updated to use the libpng 0.89 structure interface, Jun 1996
  *
+ * Modifications by Hans-Detlev Fink, January 1999, used with permission
+ *
  *****************************************************************************/
  
  /*****************************************************************************
***************
*** 1378,1383 ****
--- 1380,1386 ----
    if ((filep = Locate_File(name, READ_BINFILE_STRING, ".png", ".PNG",NULL,TRUE)) == NULL)
    {
      Error("Error opening PNG file.\n");
+     return;	/* -hdf99- */
    }
  
    if ((r_png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING,
***************
*** 1385,1390 ****
--- 1388,1394 ----
        (r_info_ptr = png_create_info_struct(r_png_ptr)) == NULL)
    {
      Error("Error allocating PNG data structures");
+     return;	/* -hdf99- */
    }
  
    if (setjmp(r_png_ptr->jmpbuf))
***************
*** 1393,1398 ****
--- 1397,1403 ----
  
      png_destroy_read_struct(&r_png_ptr, &r_info_ptr, (png_infopp)NULL);
      Error("Error reading PNG image.");
+     return;	/* -hdf99- */
    }
  
    /* set up the input control */
diff -c3 -o -r ./source/ppm.c \povray3/source/ppm.c
*** ./source/ppm.c	Mon Jun  1 18:12:46 1998
--- \povray3/source/ppm.c	Fri Mar  5 13:50:00 1999
***************
*** 22,27 ****
--- 22,29 ----
  * Original patch copyright 1994 Tim Rowley
  * Updated for POV 3.0 by Chris Cason, Jan '95.
  *
+ * Modifications by Hans-Detlev Fink, January 1999, used with permission.
+ *
  *****************************************************************************/
  
  /****************************************************************************
***************
*** 460,470 ****
--- 462,474 ----
    if ((infile = Locate_File(name, READ_BINFILE_STRING, ".ppm", ".PPM",NULL,TRUE)) == NULL)
    {
      Error("Error opening PPM image %s.\n", name);
+     return;	/* -hdf99- */
    }
  
    if (fscanf(infile, "P%c\n", &type) != 1 || (type != '3' && type != '6'))
    {
      Error ("File is not in PPM format.\n", name);
+     return;	/* -hdf99- */
    }
  
    /* Ignore any comments */
diff -c3 -o -r ./source/sor.c \povray3/source/sor.c
*** ./source/sor.c	Mon Jun  1 18:13:08 1998
--- \povray3/source/sor.c	Fri Mar  5 13:50:00 1999
***************
*** 21,26 ****
--- 21,28 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Thomas Willhalm, March 1999, used with permission
+ *
  *****************************************************************************/
  
  /****************************************************************************
***************
*** 465,471 ****
    DBL r0, r;
    VECTOR P;
    SOR *Sor = (SOR *)Object;
!   SOR_SPLINE_ENTRY *Entry;
  
    /* Transform the point into the surface of revolution space. */
  
--- 467,473 ----
    DBL r0, r;
    VECTOR P;
    SOR *Sor = (SOR *)Object;
!   SOR_SPLINE_ENTRY *Entry = NULL; /* tw */
  
    /* Transform the point into the surface of revolution space. */
  
diff -c3 -o -r ./source/targa.c \povray3/source/targa.c
*** ./source/targa.c	Mon Jun  1 18:13:34 1998
--- \povray3/source/targa.c	Fri Mar  5 13:50:00 1999
***************
*** 20,25 ****
--- 20,27 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Hans-Detlev Fink, January 1999, used with permission.
+ *
  *****************************************************************************/
  
  /****************************************************************************
***************
*** 985,995 ****
--- 987,999 ----
    if ((filep = Locate_File(name, READ_BINFILE_STRING,".tga",".TGA",NULL,TRUE)) == NULL)
    {
      Error ("Error opening TGA image.\n");
+     return;	/* -hdf99- */
    }
  
    if (fread(tgaheader, 18, 1, filep) != 1)
    {
      Error ("Error reading header of TGA image.\n");
+     return;	/* -hdf99- */
    }
  
    /* Decipher the header information */
diff -c3 -o -r ./source/tokenize.c \povray3/source/tokenize.c
*** ./source/tokenize.c	Sat Jan 30 14:17:44 1999
--- \povray3/source/tokenize.c	Fri Mar  5 13:50:00 1999
***************
*** 25,30 ****
--- 25,33 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Hans-Deltev Fink, January 1999, used with permission
+ * Modifications by Thomas Willhalm, March 1999, used with permission
+ *
  *****************************************************************************/
  
  #include <ctype.h>
***************
*** 3134,3139 ****
--- 3137,3143 ----
      
      OTHERWISE
        Parse_Error(IDENTIFIER_TOKEN);
+       Table_Entry = NULL; /* tw */
      END_CASE
    END_EXPECT
    
***************
*** 3209,3215 ****
  static void Invoke_Macro()
  {
    POV_MACRO *PMac=(POV_MACRO *)Token.Data;
!   SYM_ENTRY **Table_Entries;
    int i;
    char *f;
    
--- 3213,3219 ----
  static void Invoke_Macro()
  {
    POV_MACRO *PMac=(POV_MACRO *)Token.Data;
!   SYM_ENTRY **Table_Entries = NULL; /* tw */
    int i;
    char *f;
    
***************
*** 3413,3421 ****
               
    Ok_To_Declare = TRUE;
    return(New);
-   
- };
  
  static void Parse_Initalizer (int Sub, int Base, POV_ARRAY *a)
  {
    int i;
--- 3417,3425 ----
               
    Ok_To_Declare = TRUE;
    return(New);
  
+ } /* tw */
+ 
  static void Parse_Initalizer (int Sub, int Base, POV_ARRAY *a)
  {
    int i;
***************
*** 3441,3447 ****
    }
    Parse_End();
    Parse_Comma();
! };
  
  static void Parse_Fopen(void)
  {
--- 3445,3451 ----
    }
    Parse_End();
    Parse_Comma();
! } /* tw */
  
  static void Parse_Fopen(void)
  {
diff -c3 -o -r ./source/truetype.c \povray3/source/truetype.c
*** ./source/truetype.c	Mon Jun  1 18:14:06 1998
--- \povray3/source/truetype.c	Fri Mar  5 13:50:00 1999
***************
*** 37,42 ****
--- 37,46 ----
  * Cache Format 4 glyph table index to speed up parsing, Mar 1996 [AED]
  * Fixed TTF rendering bug that leaves horizontal streaks, Nov. 1996  Kochin Chang (KochinC@aol.com)
  * Allowed Macintosh-charmap TTF files to be processed, Nov. 1996 Bob Spence/Eduard Schwan
+ *
+ * Modifications by Hans-Detlev Fink, January 1999, used with permission
+ * Modifications by Thomas Willhalm, March 1999, used with permission
+ *
  *****************************************************************************/
  
  #include "frame.h"
***************
*** 368,374 ****
  static int Inside_Glyph (double x, double y, GlyphPtr glyph);
  static int solve_quad (double *x, double *y, double mindist, DBL maxdist);
  static void GetZeroOneHits (GlyphPtr glyph, VECTOR P, VECTOR D, DBL glyph_depth, double *t0, double *t1);
! static int GlyphIntersect (OBJECT *Object, VECTOR P, VECTOR D, DBL len, GlyphPtr glyph, DBL glyph_depth, RAY *Ray, ISTACK *Depth_Stack);
  
  /* POV-Ray object intersection/creation routines */
  static TTF *Create_TTF (void);
--- 372,378 ----
  static int Inside_Glyph (double x, double y, GlyphPtr glyph);
  static int solve_quad (double *x, double *y, double mindist, DBL maxdist);
  static void GetZeroOneHits (GlyphPtr glyph, VECTOR P, VECTOR D, DBL glyph_depth, double *t0, double *t1);
! static int GlyphIntersect (OBJECT *Object, VECTOR P, VECTOR D, GlyphPtr glyph, DBL glyph_depth, RAY *Ray, ISTACK *Depth_Stack); /* tw */
  
  /* POV-Ray object intersection/creation routines */
  static TTF *Create_TTF (void);
***************
*** 707,715 ****
  #endif
  
    /* Close the font file descriptor */
!   fclose(ffile->fp);
!   
!   ffile->fp = NULL;
  }
  
  /*****************************************************************************
--- 711,723 ----
  #endif
  
    /* Close the font file descriptor */
! 
!   if (ffile->fp != NULL)	/* just to be sure it exists -hdf99- */
!   {
!     fclose(ffile->fp);
!     ffile->fp = NULL;
!   }
! 
  }
  
  /*****************************************************************************
***************
*** 893,899 ****
  ******************************************************************************/
  static FontFileInfo *OpenFontFile(char *filename)
  {
!   int i;
    FontFileInfo *fontlist;
    char b[FILE_NAME_LENGTH];
  
--- 901,907 ----
  ******************************************************************************/
  static FontFileInfo *OpenFontFile(char *filename)
  {
!   /* int i; */ /* tw, mtg */
    FontFileInfo *fontlist;
    char b[FILE_NAME_LENGTH];
  
***************
*** 2655,2662 ****
   * This is then solved using the quadratic formula.  Any solutions of s that are
   * between 0 and 1 (inclusive) are valid solutions.
   */
! static int GlyphIntersect(OBJECT *Object, VECTOR P, VECTOR D, DBL len, GlyphPtr glyph, DBL glyph_depth,
!                           RAY *Ray, ISTACK *Depth_Stack)
  {
    Contour *contour;
    int i, j, k, l, n, m, Flag = 0;
--- 2663,2670 ----
   * This is then solved using the quadratic formula.  Any solutions of s that are
   * between 0 and 1 (inclusive) are valid solutions.
   */
! static int GlyphIntersect(OBJECT *Object, VECTOR P, VECTOR D, GlyphPtr glyph, DBL glyph_depth,
!                           RAY *Ray, ISTACK *Depth_Stack) /* tw */
  {
    Contour *contour;
    int i, j, k, l, n, m, Flag = 0;
***************
*** 2886,2892 ****
  static int All_TTF_Intersections(OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack)
  {
    TTF *ttf = (TTF *) Object;
!   DBL len;
    VECTOR P, D;
    GlyphPtr glyph;
  
--- 2894,2900 ----
  static int All_TTF_Intersections(OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack)
  {
    TTF *ttf = (TTF *) Object;
!   /* DBL len; */ /* tw, mtg */
    VECTOR P, D;
    GlyphPtr glyph;
  
***************
*** 2908,2914 ****
   */
    glyph = (GlyphPtr)ttf->glyph;
  
!   if (GlyphIntersect(Object, P, D, len, glyph,ttf->depth,Ray,Depth_Stack))
    {
      Increase_Counter(stats[Ray_TTF_Tests_Succeeded]);
      return TRUE;
--- 2916,2922 ----
   */
    glyph = (GlyphPtr)ttf->glyph;
  
!   if (GlyphIntersect(Object, P, D, glyph,ttf->depth,Ray,Depth_Stack)) /* tw */
    {
      Increase_Counter(stats[Ray_TTF_Tests_Succeeded]);
      return TRUE;
diff -c3 -o -r ./source/vbuffer.c \povray3/source/vbuffer.c
*** ./source/vbuffer.c	Thu Jul 23 11:45:02 1998
--- \povray3/source/vbuffer.c	Fri Mar  5 13:50:00 1999
***************
*** 21,26 ****
--- 21,28 ----
  * DKBTrace was originally written by David K. Buck.
  * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
  *
+ * Modifications by Thomas Willhalm, March 1999, used with permission
+ *
  *****************************************************************************/
  
  /****************************************************************************
***************
*** 391,397 ****
  {
    INTERSECTION New_Intersection;
    unsigned short i;
!   unsigned size;
    int Found;
    RAYINFO rayinfo;
    DBL key;
--- 393,399 ----
  {
    INTERSECTION New_Intersection;
    unsigned short i;
!   /* unsigned size; */ /* tw, mtg */
    int Found;
    RAYINFO rayinfo;
    DBL key;
