/***************************************************************************
*                pvmenu.c
*
*  This module implements menu-related routines for the Windows build of POV.
*
*  Copyright  POV-Team 1996-1999. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-1999 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  NOTE : As this is Windows code, it was edited using a wide Windows-hosted
*         editor. Accordingly, expect text to exceed 80 columns regularly.
*
*  from Persistence of Vision Raytracer
*  Copyright 1996-1999 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by leaving a message in CompuServe's POVRAY forum. The
*  The latest version of POV-Ray may be found there as well. POVRAY files can
*  also be found on the world wide web at http://www.povray.org/.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* $Id: //depot/windows/pvmenu.c#2 $
*
*****************************************************************************/

// REMOVAL OF NON-EXPERT MENUS (August 1998) ... the 'non-expert menus' option
// was removed. This leaves some of this code redundant, but here it is anyhow ...

#define POVWIN_FILE
#define _WIN32_IE COMMONCTRL_VERSION

#include <math.h>
#include <setjmp.h>
#include <string.h>
#include <windows.h>
#include "frame.h"
#include "colour.h"
#include "povray.h"
#include "povproto.h"
#include "optout.h"
#pragma hdrstop

#include <commctrl.h>
#include "pvengine.h"
#include "pvengine.rh"
#include "pvedit.h"

BOOL                    MenuBarDraw = FALSE ;
HMENU                   hMainMenu ;
HMENU                   hMenuBar ;
HMENU                   hPopupMenus ;
HMENU                   hFileMenu ;
HMENU                   hEditMenu ;
HMENU                   hRenderMenu ;
HMENU                   hRerunMenu ;
HMENU                   hOptionsMenu ;
HMENU                   hToolsMenu ;
HMENU                   hPluginsMenu ;
HMENU                   hHelpMenu ;

extern HWND             main_window ;
extern HWND             toolbar_window ;
extern HINSTANCE        hInstance ;

BOOL PVEnableMenuItem (UINT idItem, UINT state)
{
  EnableMenuItem (hPopupMenus, idItem, state) ;
  EnableMenuItem (hMenuBar, idItem, state) ;
  SendMessage (toolbar_window, TB_ENABLEBUTTON, idItem, MAKELONG (state == MF_ENABLED, 0)) ;
  if (idItem == CM_RENDERCLOSE)
  {
    SendMessage (toolbar_window, TB_HIDEBUTTON, CM_RENDERSHOW, MAKELONG (state == MF_ENABLED, 0)) ;
    SendMessage (toolbar_window, TB_HIDEBUTTON, CM_RENDERCLOSE, MAKELONG (state != MF_ENABLED, 0)) ;
  }
  return (TRUE) ;
}

BOOL PVCheckMenuItem (UINT idItem, UINT state)
{
  CheckMenuItem (hPopupMenus, idItem, state) ;
  CheckMenuItem (hMenuBar, idItem, state) ;
  return (TRUE) ;
}

BOOL PVModifyMenu (UINT idItem, UINT flags, UINT idNewItem, LPCSTR lpNewItem)
{
  ModifyMenu (hPopupMenus, idItem, flags, idNewItem, lpNewItem) ;
  ModifyMenu (hMenuBar, idItem, flags, idNewItem, lpNewItem) ;
  MenuBarDraw++ ;
  return (TRUE) ;
}

BOOL PVDeleteMenuItem (UINT idItem)
{
  DeleteMenu (hPopupMenus, idItem, MF_BYCOMMAND) ;
  DeleteMenu (hMenuBar, idItem, MF_BYCOMMAND) ;
  return (TRUE) ;
}

void init_menus (void)
{
  hMenuBar = LoadMenu (hInstance, MAKEINTRESOURCE (PVENGINE_MENU32)) ;
  hFileMenu = GetSubMenu (hMenuBar, 0) ;
  hEditMenu = GetSubMenu (hMenuBar, 1) ;
  hRenderMenu = GetSubMenu (hMenuBar, 2) ;
  hRerunMenu = GetSubMenu (hMenuBar, 3) ;
  hOptionsMenu = GetSubMenu (hMenuBar, 4) ;
  hToolsMenu = GetSubMenu (hMenuBar, 5) ;
  hPluginsMenu = GetSubMenu (hMenuBar, 6) ;
  hHelpMenu = GetSubMenu (hMenuBar, 7) ;
  AppendMenu (hRenderMenu, MF_POPUP, (UINT) hRerunMenu, "&Rerun") ;
}

void clear_menu (HMENU hMenu)
{
  while (RemoveMenu (hMenu, 0, MF_BYPOSITION)) ;
}

void setup_menus (BOOL have_editor)
{
//if (have_editor)
//  AppendMenu (hOptionsMenu, MF_POPUP, (UINT) EditGetMenu (GetOptionsMenu), "&Editor Window") ;
  DrawMenuBar (main_window) ;
}

// build the menu displayed when the message window is selected
void build_main_menu (HMENU hMenu, BOOL have_editor)
{
  clear_menu (hMenu) ;
  AppendMenu (hMenu, MF_POPUP, (UINT) (have_editor ? EditGetMenu (GetFileMenu) : hFileMenu), "&File") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hEditMenu, "&Edit") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hRenderMenu, "&Render") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hOptionsMenu, "&Options") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hToolsMenu, "&Tools") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hPluginsMenu, "G&UI-Extensions") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hHelpMenu, "&Help") ;
  DrawMenuBar (main_window) ;
}

// build the menu displayed when an editor window is selected
void build_editor_menu (HMENU hMenu)
{
  clear_menu (hMenu) ;
  AppendMenu (hMenu, MF_POPUP, (UINT) EditGetMenu (GetFileMenu), "&File") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) EditGetMenu (GetEditMenu), "&Edit") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) EditGetMenu (GetSearchMenu), "Se&arch") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) EditGetMenu (GetTextMenu), "&Text") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) EditGetMenu (GetOptionsMenu), "E&ditor") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) EditGetMenu (GetInsertMenu), "&Insert") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hRenderMenu, "&Render") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hOptionsMenu, "&Options") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hToolsMenu, "Too&ls") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hPluginsMenu, "G&UI-Extensions") ;
  AppendMenu (hMenu, MF_POPUP, (UINT) hHelpMenu, "&Help") ;
  DrawMenuBar (main_window) ;
}


