// Persistence Of Vision raytracer version 3.1e isosurface patch
// sample file. By R.Suzuki.
// This image contains an example of 'isosurface'.
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

camera {  
	location <30, 10, -45>
 	  direction <0, 0,  4.5>
	look_at <0,0,0>
}

light_source { <120, 300, -120> color Gray70 }
light_source { <300, 200, -120> color Gray60 }
light_source { <200, 200, -300> color Gray60 }

isosurface {  
	function { "func_2", <16, 0.01, 6.0, 3., 0.> }
	contained_by { box { <-5.5, -5.5, -5.5>, <5.5, 5.5, 5.5> } }
	max_gradient 5.0
	max_trace 2
	eval
	texture {
		pigment { color red 0.8 green 0.8 blue 0.95 filter 1.0}
		finish { phong 1.0}
	}
	interior { ior 1.5 }
	rotate <0,-10,0>
}

object {
	plane {<0, 1, 0>, 0}
	texture { pigment { White_Wood } }
	scale 1.5
	translate <0, -5.5, 0>
	no_shadow
}

object {
	plane {<1, 0, 0>,0} 
	texture { pigment { White_Marble } }
	scale 1.5
	translate <-12, 0, 0>
	no_shadow
}

object {
	plane {<0, 0, -1>, 0}   
	texture { pigment { Brown_Agate } }
	scale 3
	translate <0, 0, 20>
	no_shadow
}

background { color Gray30 }

