// Persistence Of Vision raytracer version 2.2 (equi-potential surface)
// sample file.
// By R.Suzuki
// This image contains an example of 'equpotsurface'.
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

camera {  
	location <0, 12, -60>
	angle 40
	look_at <0, 0, 0>
}

light_source { <10, 80, -40> color White}
light_source { <-20, 30, -120> color White}
light_source { <80, 50, -20> color White}

background { color DarkSlateGray }

//-----------------------------------------------------------
//  library i_dat3d 
//    parameters
//      P0: x-dim
//      P1: y-dim
//      P2: z-dim
//      P3: 	0:  text file
//				1:  1-byte binary
//				2:  2-byte int binary
//				3:  4-byte long int binrary
//				4:  4-byte float binary
//-----------------------------------------------------------
//		function	data_3D_1 : 3D data 1st order interpolation
//						data_3D_3 : 3D data 3rd order interpolation
//						data_2D_1 : 2D data 1st order interpolation
//						data_2D_3 : 2D data 3rd order interpolation
//		parameter
//			P0 :  scaling parameter
//-----------------------------------------------------------
isosurface {
	function { "data_3D_3", <1.0>, library   "i_dat3d", "test1.dat", <10, 12, 10, 0> } // 3rd order intp.
	contained_by { sphere { <0, 0, 0>, 12 } }
	open
	eval
	max_gradient 1.5
	threshold -1.4
	accuracy 0.01
	method 2
	pigment { color red 0.65 green 0.6 blue 0.45}
	finish { phong 0.6 }
	scale 1
	rotate x*-10
}
