//	Persistence of Vision Ray Tracer Scene Description File
// Demo showing bugfix in noise function (used by bumps, bozo, noise3d in isosurface, turbulence ...)

#declare Plateau_fix = on;  // on uses version 0.5 with the bugfix
                            // off uses version 0.4 showing plateau-forming on the surfaces

#if (Plateau_fix = on)
	#version unofficial MegaPov 0.5;
#else
	#version unofficial MegaPov 0.4;
#end

camera {
	location <0.0, 0.0, -7>
	up y*image_height right x*image_width
	angle 40
	look_at <0.0, 0.0, 0.0>
	rotate x*15
}

light_source { <4000, 4000, -10000> rgb 1.0 }
light_source { <0.0, 0.0, -7> rgb 0.3 shadowless rotate x*15 }

isosurface {
	function {( x^4+y^4+z^4) +noise3d(x*6.5, y*7, z*4.5) }
	contained_by { box { -1, 1 } }
	threshold 1.1
	method 2  max_gradient 13
	texture {
		pigment { rgb 1 }
		finish { phong 0.8 phong_size 200 }
	}
	translate y*1.1
}

box {
	<-10, -4, -10>, <10, -3, 8>
	texture {
		pigment { rgb <1.0, 0.74, 0.74> }
		normal {
			bozo 10
			slope_map {
				[ 0.05,  < 1.00000,  0.00000 > ]
				[ 0.5,  < -0.00000,  0.00000 > ]
				[ 0.5,  < 0.00267,  0.00000 > ]
				[ 1.0,  < 0.99733,  -0.00609 > ]
			}
			scale <0.7, 1.2, 0.7>
		}
		finish { ambient 0.1 phong 0.8 phong_size 200 }
	}
}

sky_sphere {
	pigment {
		bumps
		color_map {
			[ 0.0 rgb <1.0, 1.0, 1.0> ]
			[ 1.0 rgb <0.235584, 0.683375, 0.924407> ]
		}
		scale 0.05
	}
}
