//	Persistence of Vision Ray Tracer Scene Description File
//	File: smooth_color_triangle.pov
//	Date: 15/11/99
//	Demo showing a triangle with different colors at each vertex.
	
#version unofficial MegaPov 0.4;

camera {
	location <0.0, 0.5, -4>
	angle 30
	look_at <0.0, 0.0, 0.0>
}

light_source {
	<30, 30, -100>
	color rgb <1.0, 1.0, 1.0> 
}
light_source { <0.0, 0.0, -50> rgb 0.3 }

#declare Tex1=
texture {
	pigment { rgb <1, 1, 0>*1.2}
	normal {
		granite 0.3
		scallop_wave
		scale 0.05
	}
}
#declare Tex2=
texture {
	pigment { rgb <1, 0, 0>}
	normal {
		crackle 0.6 //amount
		metric 2.5
		sine_wave
		scale 0.2
	}
 }
#declare Tex3=
texture {
	pigment { rgb <0, 0, 1>*1.5}
	normal {
		onion 3
		scale <0.07, 0.07, 2>
		triangle_wave
//		no_bump_scale
		accuracy 0.002
	}
}

mesh {
	smooth_triangle {
		<-0.8, -0.5, 0.0>, <0.0, 0.0, -1>,
		<0.0, 0.5, 0.0>, <0.0, 0.0, -1>,
		<0.8, -0.5, 0.0>, <0.0, 0.0, -1>
		texture_list {Tex1 Tex2 Tex3 }
//		texture { Tex1 }
	}
}
