//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

#macro create_spectrum(nelems,bright)

#local elem=1;

color_map{

#while(elem<=nelems)

  /* h goes from 0 at red end to 1.0 at blue end */
  #local h = (elem-1)/(nelems-1);

  /* co-h goes from 1.0 at red end to 0.0 at blue end */
  #local coh = 1.0 - h; 
  
  #local Huered = 0.9 - (h/0.5);
  #local Hueblue = 1.0 - (coh/0.6);
  
  #if (Huered < 0.0) #local Huered = 0.0; #end
  #if (Hueblue < 0.0)  #local Hueblue = 0.0; #end

  #local Huered=1.0 - (1.0-Huered)*(1.0-Huered);  
  #local Hueblue=1.0 - (1.0-Hueblue)*(1.0-Hueblue);

  #local Huegreen = 1.0 - Huered - Hueblue;

/*
  #if (h>0.85)
    #local Huered = 4*(h-0.85);
  #end
*/
  
  #local ybulge =  -4.0*(h-0.1)*(h-0.6);
  #if (ybulge<0) #local ybulge=0; #end
  
  #local Huered = Huered+ybulge;// * 0.5; // added * 0.5
  #local Huegreen = Huegreen+ybulge;
  
  [bright, color rgb<Huered,Huegreen,Hueblue>]
  //#debug concat("<",str(Huered,0,3),",",str(Huegreen,0,3),",",str(Hueblue,0,3),">\n")
  
  
  #local elem=elem+1;
#end // while
}
#end // macro


#declare phot=yes;

#if(phot)
global_settings {
    
  photons {
	spacing 0.02
    gather 60, 100
    media 6, 1.5
    autostop 0
    jitter 1
    max_trace_level 4
    #if(clock=0)
    save_file "mediaph.ph"
    #else
    load_file "mediaph.ph"
    #end
	media on
  }
}
#end


light_source{
  <-2,2,0>
  color <1,1,1>*4
  fade_distance 2
  fade_power 2
  spotlight
  point_at <0,0,0>
  radius 22
  falloff 28
  create_spectrum(8,4)
}

sphere{
  <0,0,0>,1
  material{
    texture{
      pigment{rgbf<1,1,1,.9>}
      finish{
            ambient 0.0
            diffuse 0.5
            specular 1.0
            roughness 0.001
            reflection 0.1*0
      }
      
    }
    interior{
      ior 1.5
      dispersion 1.05  // dispersion looks cool
    }
  }
  photons{
	target 1.0
    reflection off
    refraction on
    ignore_photons
  }
}

$cloc=clock;

$start_loc=<0,0,-7>;
$mid_loc=<3,-4.5,0>;
$end_loc=<0,0,7>;

#if(cloc<.5)
  $loc=(mid_loc-start_loc)*(cloc*2)+start_loc;
#else
  $loc=(end_loc-mid_loc)*((cloc-.5)*2)+mid_loc;
#end
       
camera{
  location loc
  look_at <0,0,0>
}

box{
  <-4,-4,-4>,<4,4,4>
  texture{pigment{rgbt<1,1,1,1>}}
  interior{
    media{
    intervals 1
    scattering { 4, rgb 0.04 extinction 1} // for some reason more extinction is needed for adaptive?
    samples 50, 50  //use 1,4 or so for "quick" tests
    method 3
    aa_threshold .1
    aa_level 2
    jitter .2
    }
  }
  hollow
  photons { ignore_photons}
} 


