//	Persistence of Vision Ray Tracer Scene Description File
//	File: new_crackle.pov
//	Date: 15/11/99
//	Demo showing the new crackle types
	
#version unofficial MegaPov 0.4;


//Change type to see different crackle types
#declare Type = 1;		//1=solid;	2=metric;		3=form;	4=offset;	5=facets

camera {
	location < 0.0, 0.0, -6 >
	angle 60
	look_at < 0.0, 0.0, 0.0 >
}

light_source { <0.0, 100, -100> rgb <1.0, 1.0, 1.0> }

#if (Type = 1)	//solid
sphere  {
	<0.0, 0.0, 0.0>, 2
	texture {
		pigment  {
			crackle solid
			color_map {
				[0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
		}
		normal { crackle solid }
		scale 0.5
	}
}
#end

#if (Type = 2)	//metric
sphere  {
	<0.0, 0.0, 0.0>, 2
	texture {
		pigment  {
			crackle metric 3
			color_map {
				[0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
		}
		normal { crackle metric 3 }
		scale 0.5
	}
}
#end

#if (Type = 3)	//form
sphere  {
	<0.0, 0.0, 0.0>, 2
	texture {
		pigment  {
			crackle form <-1, 1.0, 0.4>
			color_map {
				[0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
		}
		normal { crackle form <-1, 1.0, 0.4> }
		scale 0.5
	}
}
#end

#if (Type = 4)	//offset
sphere  {
	<0.0, 0.0, 0.0>, 2
	texture {
		pigment  {
			crackle offset 0.6
			color_map {
				[0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
		}
		normal { crackle offset 0.6 }
		scale 0.5
	}
}
#end

#if (Type = 5)	//facets
sphere {
	-1.5*x,1.5
	texture {
		pigment { rgb <0.941711, 0.893446, 0.838285> }
		normal { facets size 0.15 }
		finish { phong 1.0 phong_size 200 }
	}
}
sphere {
	1.5*x,1.5
	texture {
		pigment { rgb <0.821790, 0.958206, 0.851347> }
		normal { facets coords 0.15 }
		finish { phong 1.0 phong_size 200 }
	}
}
#end
