
/****************************************************************************/

#define STRICT

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "..\common\plugin.h"		// Breeze Designer Plug-In interface
#include "..\common\pitools.h"  	// Breeze Designer Plug-In tools
#include "..\common\piutils.h"  	// Breeze Designer Misc utilities
#include "pisample.h"
#include "resource.h"


/****************************************************************************
*
* This module contains a collection of routines to demonstrate some of
* the features of the piTools library.
*/

/****************************************************************************
*
*/
static BOOL AddOctaFac( HCADOBJECT hObject, LPXYZ pOct, int n1, int n2, int n3 )
{
	POINTXYZ pPoint[3];

	CopyPoint( &pOct[n1], &pPoint[0] );
	CopyPoint( &pOct[n2], &pPoint[1] );
	CopyPoint( &pOct[n3], &pPoint[2] );

	if (piPutGeometry( hObject, 3, pPoint ) == FALSE) 
		{
		return FALSE;
		}
	return TRUE;
}

/****************************************************************************
*
*/
BOOL CreateTetrahedron()
{
	static POINTXYZ pTet[] = 
		{
		0.0f,		0.0f,		0.0f,
		-0.5f,	0.5f,		0.5f,		// front
		0.5f,		0.5f,		0.5f,
		0.5f,		-0.5f,	0.5f,
		-0.5f,	-0.5f,	0.5f,
		-0.5f,	0.5f,		-0.5f,	// back
		0.5f,		0.5f,		-0.5f,
		0.5f,		-0.5f,	-0.5f,
		-0.5f,	-0.5f,	-0.5f,
		};
	char szTetName[ MAX_STRING_LENGTH ];
	static int nObject = 0;
	HCADOBJECT hObject;

	/*
	 * Generate a simple tetrahedron.
	 *
	 * Build the object name..
	 */
	sprintf( szTetName, "_Test%d", nObject );

	/*
	 * Create an empty polygon object
	 */
	hObject = piCreateObject( szTetName, OBJECT_POLYGON );

	if (hObject == PI_ERROR)
		{
		return FALSE;
		}

	AddOctaFac( hObject, pTet, 1, 3, 6 );
	AddOctaFac( hObject, pTet, 3, 8, 6 );
	AddOctaFac( hObject, pTet, 1, 6, 8 );
	AddOctaFac( hObject, pTet, 1, 8, 3 );

	piFreeObject( hObject );

	piRedraw();

	return TRUE;
}

/****************************************************************************
*
*/
static LPCSTR g_szPreviwTitle = { "Breeze Designer test preview plugin" };

static LPCSTR g_szObjectTypeNames[] = 
{
	"*NULL",
	"GROUP",
	"*RESERVED0",
	"*RESERVED1",
	"*RESERVED2",
	"*RESERVED3",
	"*RESERVED4",
	"*RESERVED5",
	"POINTS",
	"LINESEG",
	"POLYGON",
	"LIGHT",
	"CAMERA",
	"SPHERE",
	"PLANE",
	"DISC",
	"CYLINDER",
	"CONE",
	"ELLIPSOID",
	"TORUS",
	"BOX",
	"HEIGHTFIELD",
	"BLOB",
	"PATCH",
	"TEXT",
	"USERDEFINED"
};

/****************************************************************************
*
*/
BOOL ParseScene( LPPLUGINDATA lpCall )
{
	UINT nObjectCount[MAX_OBJECT_TYPES];
	UINT nObjectType, nObjectGroup, i, j;
	HCADOBJECT hObject;
	LPPLUGINVIEWPORT vp;
	char szMsg[ MAX_STRING_LENGTH ];

	vp = (LPPLUGINVIEWPORT)lpCall->lpData;

	//
	// Clear object count
	//
	memset( &nObjectCount, 0, sizeof(nObjectCount));

	//
	// Enumerate all the objects in the current scene
	//
	hObject = piGetObject( (HCADOBJECT)NULL, PI_GET_FIRST );

	//
	// Check for something wrong (or no objects)
	//
	if (hObject == PI_ERROR)
		{
		return TRUE;
		}

	do
		{
		nObjectType  = piGetObjectType( hObject );
		nObjectGroup = piGetObjectGroup( hObject );

		++nObjectCount[nObjectType];

		TRACE("Processing object: %d\n", nObjectType );

		//
		// Get the next object
		//
		hObject = piGetObject( hObject, PI_GET_NEXT );

		} while(  hObject != PI_ERROR );

	//
	// Redundant free object...
	//
	piFreeObject( hObject );

	//
	// Print a list of object counts
	//
	for (i=OBJECT_GROUP, j=30; i<OBJECT_USERDEFINED; i++)
		{
		if (g_szObjectTypeNames[i][0] != '*')
			{
			wsprintf( szMsg, "%s %d", g_szObjectTypeNames[i], nObjectCount[i] );

			TextOut( vp->hdc, 10, j, szMsg, lstrlen(szMsg)); 

			j += 12;
			}
		}

	return TRUE;
}

/****************************************************************************
*
*/
BOOL RenderPreviewScene( LPPLUGINDATA lpCall )
{
	LPPLUGINVIEWPORT vp;
	RECT r;

	/*
	 * This funtion is called each time Breeze Designer updates
	 * active preview window. Passed is the window view details
	 *
    */
	vp = (LPPLUGINVIEWPORT)lpCall->lpData;

	/* Obtain the window's client rectangle */
	GetClientRect( vp->hwnd, &r); 

	/* Fill the region with grayness */
	FillRect( vp->hdc, &r, GetStockObject(GRAY_BRUSH)); 

	/* Prepare to write over the background */
	SetBkMode( vp->hdc, TRANSPARENT); 

	/* Send some text out into the world */
	TextOut( vp->hdc, r.left, r.top, g_szPreviwTitle, lstrlen(g_szPreviwTitle)); 

	return ParseScene( lpCall );
}


