`async fn`/`impl trait` return type cannot contain a projection
or `Self` that references lifetimes from a parent scope.

Erroneous code example:

```compile_fail,E0760,edition2018
struct S<'a>(&'a i32);

impl<'a> S<'a> {
    async fn new(i: &'a i32) -> Self {
        S(&22)
    }
}
```

To fix this error we need to spell out `Self` to `S<'a>`:

```edition2018
struct S<'a>(&'a i32);

impl<'a> S<'a> {
    async fn new(i: &'a i32) -> S<'a> {
        S(&22)
    }
}
```

This will be allowed at some point in the future,
but the implementation is not yet complete.
See the [issue-61949] for this limitation.

[issue-61949]: https://github.com/rust-lang/rust/issues/61949
