/* Tables for conversion to and from IBM937.
   Copyright (C) 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Masahide Washizawa <washi@yamato.ibm.co.jp>, 2000.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef _IBM937_H
#define _IBM937_H 1

#include <gconv.h>
#include <stdint.h>

static const uint16_t __ibm937sb_to_ucs4[] =
{
  [0x00] = 0x0000, [0x01] = 0x0001, [0x02] = 0x0002, [0x03] = 0x0003,
  [0x04] = 0x009c, [0x05] = 0x0009, [0x06] = 0x0086, [0x07] = 0x007f,
  [0x08] = 0x0097, [0x09] = 0x008d, [0x0a] = 0x008e, [0x0b] = 0x000b,
  [0x0c] = 0x000c, [0x0d] = 0x000d, [0x0e] = 0x000e, [0x0f] = 0x000f,
  [0x10] = 0x0010, [0x11] = 0x0011, [0x12] = 0x0012, [0x13] = 0x0013,
  [0x14] = 0x009d, [0x15] = 0x0085, [0x16] = 0x0008, [0x17] = 0x0087,
  [0x18] = 0x0018, [0x19] = 0x0019, [0x1a] = 0x0092, [0x1b] = 0x008f,
  [0x1c] = 0x001c, [0x1d] = 0x001d, [0x1e] = 0x001e, [0x1f] = 0x001f,
  [0x20] = 0x0080, [0x21] = 0x0081, [0x22] = 0x0082, [0x23] = 0x0083,
  [0x24] = 0x0084, [0x25] = 0x000a, [0x26] = 0x0017, [0x27] = 0x001b,
  [0x28] = 0x0088, [0x29] = 0x0089, [0x2a] = 0x008a, [0x2b] = 0x008b,
  [0x2c] = 0x008c, [0x2d] = 0x0005, [0x2e] = 0x0006, [0x2f] = 0x0007,
  [0x30] = 0x0090, [0x31] = 0x0091, [0x32] = 0x0016, [0x33] = 0x0093,
  [0x34] = 0x0094, [0x35] = 0x0095, [0x36] = 0x0096, [0x37] = 0x0004,
  [0x38] = 0x0098, [0x39] = 0x0099, [0x3a] = 0x009a, [0x3b] = 0x009b,
  [0x3c] = 0x0014, [0x3d] = 0x0015, [0x3e] = 0x009e, [0x3f] = 0x001a,
  [0x40] = 0x0020, [0x4a] = 0x00a2, [0x4b] = 0x002e, [0x4c] = 0x003c,
  [0x4d] = 0x0028, [0x4e] = 0x002b, [0x4f] = 0x007c, [0x50] = 0x0026,
  [0x5a] = 0x0021, [0x5b] = 0x0024, [0x5c] = 0x002a, [0x5d] = 0x0029,
  [0x5e] = 0x003b, [0x5f] = 0x00ac, [0x60] = 0x002d, [0x61] = 0x002f,
  [0x6a] = 0x00a6, [0x6b] = 0x002c, [0x6c] = 0x0025, [0x6d] = 0x005f,
  [0x6e] = 0x003e, [0x6f] = 0x003f, [0x79] = 0x0060, [0x7a] = 0x003a,
  [0x7b] = 0x0023, [0x7c] = 0x0040, [0x7d] = 0x0027, [0x7e] = 0x003d,
  [0x7f] = 0x0022, [0x81] = 0x0061, [0x82] = 0x0062, [0x83] = 0x0063,
  [0x84] = 0x0064, [0x85] = 0x0065, [0x86] = 0x0066, [0x87] = 0x0067,
  [0x88] = 0x0068, [0x89] = 0x0069, [0x91] = 0x006a, [0x92] = 0x006b,
  [0x93] = 0x006c, [0x94] = 0x006d, [0x95] = 0x006e, [0x96] = 0x006f,
  [0x97] = 0x0070, [0x98] = 0x0071, [0x99] = 0x0072, [0xa1] = 0x007e,
  [0xa2] = 0x0073, [0xa3] = 0x0074, [0xa4] = 0x0075, [0xa5] = 0x0076,
  [0xa6] = 0x0077, [0xa7] = 0x0078, [0xa8] = 0x0079, [0xa9] = 0x007a,
  [0xb0] = 0x005e, [0xba] = 0x005b, [0xbb] = 0x005d, [0xc0] = 0x007b,
  [0xc1] = 0x0041, [0xc2] = 0x0042, [0xc3] = 0x0043, [0xc4] = 0x0044,
  [0xc5] = 0x0045, [0xc6] = 0x0046, [0xc7] = 0x0047, [0xc8] = 0x0048,
  [0xc9] = 0x0049, [0xd0] = 0x007d, [0xd1] = 0x004a, [0xd2] = 0x004b,
  [0xd3] = 0x004c, [0xd4] = 0x004d, [0xd5] = 0x004e, [0xd6] = 0x004f,
  [0xd7] = 0x0050, [0xd8] = 0x0051, [0xd9] = 0x0052, [0xe0] = 0x005c,
  [0xe2] = 0x0053, [0xe3] = 0x0054, [0xe4] = 0x0055, [0xe5] = 0x0056,
  [0xe6] = 0x0057, [0xe7] = 0x0058, [0xe8] = 0x0059, [0xe9] = 0x005a,
  [0xf0] = 0x0030, [0xf1] = 0x0031, [0xf2] = 0x0032, [0xf3] = 0x0033,
  [0xf4] = 0x0034, [0xf5] = 0x0035, [0xf6] = 0x0036, [0xf7] = 0x0037,
  [0xf8] = 0x0038, [0xf9] = 0x0039, [0xff] = 0x009f
};

static const uint16_t __ibm937db_to_ucs4[] =
{
  [0x4040] = 0x3000, [0x4141] = 0x03b1, [0x4142] = 0x03b2, [0x4143] = 0x03b3,
  [0x4144] = 0x03b4, [0x4145] = 0x03b5, [0x4146] = 0x03b6, [0x4147] = 0x03b7,
  [0x4148] = 0x03b8, [0x4149] = 0x03b9, [0x414a] = 0x03ba, [0x414b] = 0x03bb,
  [0x414c] = 0x03bc, [0x414d] = 0x03bd, [0x414e] = 0x03be, [0x414f] = 0x03bf,
  [0x4150] = 0x03c0, [0x4151] = 0x03c1, [0x4152] = 0x03c3, [0x4153] = 0x03c4,
  [0x4154] = 0x03c5, [0x4155] = 0x03c6, [0x4156] = 0x03c7, [0x4157] = 0x03c8,
  [0x4158] = 0x03c9, [0x4161] = 0x0391, [0x4162] = 0x0392, [0x4163] = 0x0393,
  [0x4164] = 0x0394, [0x4165] = 0x0395, [0x4166] = 0x0396, [0x4167] = 0x0397,
  [0x4168] = 0x0398, [0x4169] = 0x0399, [0x416a] = 0x039a, [0x416b] = 0x039b,
  [0x416c] = 0x039c, [0x416d] = 0x039d, [0x416e] = 0x039e, [0x416f] = 0x039f,
  [0x4170] = 0x03a0, [0x4171] = 0x03a1, [0x4172] = 0x03a3, [0x4173] = 0x03a4,
  [0x4174] = 0x03a5, [0x4175] = 0x03a6, [0x4176] = 0x03a7, [0x4177] = 0x03a8,
  [0x4178] = 0x03a9, [0x4180] = 0x0430, [0x4181] = 0x0431, [0x4182] = 0x0432,
  [0x4183] = 0x0433, [0x4184] = 0x0434, [0x4185] = 0x0435, [0x4186] = 0x0451,
  [0x4187] = 0x0436, [0x4188] = 0x0437, [0x4189] = 0x0438, [0x418a] = 0x0439,
  [0x418b] = 0x043a, [0x418c] = 0x043b, [0x418d] = 0x043c, [0x418e] = 0x043d,
  [0x418f] = 0x043e, [0x4190] = 0x043f, [0x4191] = 0x0440, [0x4192] = 0x0441,
  [0x4193] = 0x0442, [0x4194] = 0x0443, [0x4195] = 0x0444, [0x4196] = 0x0445,
  [0x4197] = 0x0446, [0x4198] = 0x0447, [0x4199] = 0x0448, [0x419a] = 0x0449,
  [0x419b] = 0x044a, [0x419c] = 0x044b, [0x419d] = 0x044c, [0x419e] = 0x044d,
  [0x419f] = 0x044e, [0x41a0] = 0x044f, [0x41b1] = 0x2170, [0x41b2] = 0x2171,
  [0x41b3] = 0x2172, [0x41b4] = 0x2173, [0x41b5] = 0x2174, [0x41b6] = 0x2175,
  [0x41b7] = 0x2176, [0x41b8] = 0x2177, [0x41b9] = 0x2178, [0x41ba] = 0x2179,
  [0x41c0] = 0x0410, [0x41c1] = 0x0411, [0x41c2] = 0x0412, [0x41c3] = 0x0413,
  [0x41c4] = 0x0414, [0x41c5] = 0x0415, [0x41c6] = 0x0401, [0x41c7] = 0x0416,
  [0x41c8] = 0x0417, [0x41c9] = 0x0418, [0x41ca] = 0x0419, [0x41cb] = 0x041a,
  [0x41cc] = 0x041b, [0x41cd] = 0x041c, [0x41ce] = 0x041d, [0x41cf] = 0x041e,
  [0x41d0] = 0x041f, [0x41d1] = 0x0420, [0x41d2] = 0x0421, [0x41d3] = 0x0422,
  [0x41d4] = 0x0423, [0x41d5] = 0x0424, [0x41d6] = 0x0425, [0x41d7] = 0x0426,
  [0x41d8] = 0x0427, [0x41d9] = 0x0428, [0x41da] = 0x0429, [0x41db] = 0x042a,
  [0x41dc] = 0x042b, [0x41dd] = 0x042c, [0x41de] = 0x042d, [0x41df] = 0x042e,
  [0x41e0] = 0x042f, [0x41f1] = 0x2160, [0x41f2] = 0x2161, [0x41f3] = 0x2162,
  [0x41f4] = 0x2163, [0x41f5] = 0x2164, [0x41f6] = 0x2165, [0x41f7] = 0x2166,
  [0x41f8] = 0x2167, [0x41f9] = 0x2168, [0x41fa] = 0x2169, [0x424a] = 0xffe1,
  [0x424b] = 0xff0e, [0x424c] = 0xff1c, [0x424d] = 0xff08, [0x424e] = 0xff0b,
  [0x424f] = 0xff5c, [0x4250] = 0xff06, [0x425a] = 0xff01, [0x425b] = 0xffe5,
  [0x425c] = 0x273d, [0x425d] = 0xff09, [0x425e] = 0xff1b, [0x425f] = 0xffe2,
  [0x4260] = 0xff0d, [0x4261] = 0xff0f, [0x426a] = 0xffe4, [0x426b] = 0xff0c,
  [0x426c] = 0xff05, [0x426d] = 0xff3f, [0x426e] = 0xff1e, [0x426f] = 0xff1f,
  [0x4279] = 0x2035, [0x427a] = 0xff1a, [0x427b] = 0xff03, [0x427c] = 0xff20,
  [0x427d] = 0xff07, [0x427e] = 0xff1d, [0x427f] = 0xff02, [0x4281] = 0xff41,
  [0x4282] = 0xff42, [0x4283] = 0xff43, [0x4284] = 0xff44, [0x4285] = 0xff45,
  [0x4286] = 0xff46, [0x4287] = 0xff47, [0x4288] = 0xff48, [0x4289] = 0xff49,
  [0x4291] = 0xff4a, [0x4292] = 0xff4b, [0x4293] = 0xff4c, [0x4294] = 0xff4d,
  [0x4295] = 0xff4e, [0x4296] = 0xff4f, [0x4297] = 0xff50, [0x4298] = 0xff51,
  [0x4299] = 0xff52, [0x42a1] = 0x203e, [0x42a2] = 0xff53, [0x42a3] = 0xff54,
  [0x42a4] = 0xff55, [0x42a5] = 0xff56, [0x42a6] = 0xff57, [0x42a7] = 0xff58,
  [0x42a8] = 0xff59, [0x42a9] = 0xff5a, [0x42c0] = 0xff5b, [0x42c1] = 0xff21,
  [0x42c2] = 0xff22, [0x42c3] = 0xff23, [0x42c4] = 0xff24, [0x42c5] = 0xff25,
  [0x42c6] = 0xff26, [0x42c7] = 0xff27, [0x42c8] = 0xff28, [0x42c9] = 0xff29,
  [0x42d0] = 0xff5d, [0x42d1] = 0xff2a, [0x42d2] = 0xff2b, [0x42d3] = 0xff2c,
  [0x42d4] = 0xff2d, [0x42d5] = 0xff2e, [0x42d6] = 0xff2f, [0x42d7] = 0xff30,
  [0x42d8] = 0xff31, [0x42d9] = 0xff32, [0x42e0] = 0xff04, [0x42e2] = 0xff33,
  [0x42e3] = 0xff34, [0x42e4] = 0xff35, [0x42e5] = 0xff36, [0x42e6] = 0xff37,
  [0x42e7] = 0xff38, [0x42e8] = 0xff39, [0x42e9] = 0xff3a, [0x42f0] = 0xff10,
  [0x42f1] = 0xff11, [0x42f2] = 0xff12, [0x42f3] = 0xff13, [0x42f4] = 0xff14,
  [0x42f5] = 0xff15, [0x42f6] = 0xff16, [0x42f7] = 0xff17, [0x42f8] = 0xff18,
  [0x42f9] = 0xff19, [0x4341] = 0x3002, [0x4342] = 0x300c, [0x4343] = 0x300d,
  [0x4344] = 0x3001, [0x4345] = 0x2027, [0x4346] = 0x30f2, [0x4347] = 0x30a1,
  [0x4348] = 0x30a3, [0x4349] = 0x30a5, [0x434a] = 0xffe0, [0x434d] = 0x2312,
  [0x434e] = 0x2202, [0x434f] = 0x2207, [0x4351] = 0x30a7, [0x4352] = 0x30a9,
  [0x4353] = 0x30e3, [0x4354] = 0x30e5, [0x4355] = 0x30e7, [0x4356] = 0x30c3,
  [0x4357] = 0x30ee, [0x4358] = 0x30fc, [0x4359] = 0x30f5, [0x435a] = 0x30f6,
  [0x435d] = 0x226a, [0x435e] = 0x226b, [0x4360] = 0x223d, [0x4361] = 0x221d,
  [0x4363] = 0x222c, [0x4364] = 0x2208, [0x4365] = 0x220b, [0x4366] = 0x2286,
  [0x4367] = 0x2287, [0x4368] = 0x2282, [0x4369] = 0x2283, [0x436c] = 0x2227,
  [0x436d] = 0x2228, [0x436e] = 0x21d2, [0x436f] = 0x21d4, [0x4370] = 0x2200,
  [0x4371] = 0x2203, [0x4372] = 0x212b, [0x4373] = 0x2030, [0x4374] = 0x266f,
  [0x4375] = 0x266d, [0x4376] = 0x266a, [0x4377] = 0x2020, [0x4378] = 0x2021,
  [0x4379] = 0x00b6, [0x437a] = 0x25ef, [0x4381] = 0x30a2, [0x4382] = 0x30a4,
  [0x4383] = 0x30a6, [0x4384] = 0x30a8, [0x4385] = 0x30aa, [0x4386] = 0x30ab,
  [0x4387] = 0x30ad, [0x4388] = 0x30af, [0x4389] = 0x30b1, [0x438a] = 0x30b3,
  [0x438c] = 0x30b5, [0x438d] = 0x30b7, [0x438e] = 0x30b9, [0x438f] = 0x30bb,
  [0x4390] = 0x30bd, [0x4391] = 0x30bf, [0x4392] = 0x30c1, [0x4393] = 0x30c4,
  [0x4394] = 0x30c6, [0x4395] = 0x30c8, [0x4396] = 0x30ca, [0x4397] = 0x30cb,
  [0x4398] = 0x30cc, [0x4399] = 0x30cd, [0x439a] = 0x30ce, [0x439d] = 0x30cf,
  [0x439e] = 0x30d2, [0x439f] = 0x30d5, [0x43a1] = 0x223c, [0x43a2] = 0x30d8,
  [0x43a3] = 0x30db, [0x43a4] = 0x30de, [0x43a5] = 0x30df, [0x43a6] = 0x30e0,
  [0x43a7] = 0x30e1, [0x43a8] = 0x30e2, [0x43a9] = 0x30e4, [0x43aa] = 0x30e6,
  [0x43ac] = 0x30e8, [0x43ad] = 0x30e9, [0x43ae] = 0x30ea, [0x43af] = 0x30eb,
  [0x43b7] = 0x2501, [0x43b8] = 0x2503, [0x43b9] = 0x250f, [0x43ba] = 0x30ec,
  [0x43bb] = 0x30ed, [0x43bc] = 0x30ef, [0x43bd] = 0x30f3, [0x43be] = 0x309b,
  [0x43bf] = 0x309c, [0x43c0] = 0x30ac, [0x43c1] = 0x30ae, [0x43c2] = 0x30b0,
  [0x43c3] = 0x30b2, [0x43c4] = 0x30b4, [0x43c5] = 0x30b6, [0x43c6] = 0x30b8,
  [0x43c7] = 0x30ba, [0x43c8] = 0x30bc, [0x43c9] = 0x30be, [0x43ca] = 0x30c0,
  [0x43cb] = 0x30c2, [0x43cc] = 0x30c5, [0x43cd] = 0x30c7, [0x43ce] = 0x30c9,
  [0x43cf] = 0x30d0, [0x43d0] = 0x30d3, [0x43d1] = 0x30d6, [0x43d2] = 0x30d9,
  [0x43d3] = 0x30dc, [0x43d4] = 0x30f4, [0x43d5] = 0x30d1, [0x43d6] = 0x30d4,
  [0x43d7] = 0x30d7, [0x43d8] = 0x30da, [0x43d9] = 0x30dd, [0x43da] = 0x30f0,
  [0x43db] = 0x30f1, [0x43dc] = 0x30fd, [0x43dd] = 0x30fe, [0x43e0] = 0xff3c,
  [0x43e1] = 0x2513, [0x43e2] = 0x251b, [0x43e3] = 0x2517, [0x43e4] = 0x2523,
  [0x43e5] = 0x2533, [0x43e6] = 0x252b, [0x43e7] = 0x253b, [0x43e8] = 0x254b,
  [0x43e9] = 0x2520, [0x43ea] = 0x252f, [0x43eb] = 0x2528, [0x43ec] = 0x2537,
  [0x43ed] = 0x253f, [0x43ee] = 0x251d, [0x43ef] = 0x2530, [0x43f0] = 0x2525,
  [0x43f1] = 0x2538, [0x43f2] = 0x2542, [0x4442] = 0x300e, [0x4443] = 0x300f,
  [0x4444] = 0xff3b, [0x4445] = 0xff3d, [0x4446] = 0x3092, [0x4447] = 0x3041,
  [0x4448] = 0x3043, [0x4449] = 0x3045, [0x444a] = 0x2014, [0x444b] = 0x00b1,
  [0x444c] = 0x2260, [0x444d] = 0x221e, [0x444e] = 0x2103, [0x4450] = 0x2032,
  [0x4451] = 0x3047, [0x4452] = 0x3049, [0x4453] = 0x3083, [0x4454] = 0x3085,
  [0x4455] = 0x3087, [0x4456] = 0x3063, [0x4457] = 0x308e, [0x445a] = 0x2010,
  [0x445b] = 0x02ba, [0x445c] = 0xf83e, [0x445d] = 0x3005, [0x445e] = 0x3006,
  [0x445f] = 0x3007, [0x4460] = 0x00a8, [0x4461] = 0x2018, [0x4462] = 0x201c,
  [0x4463] = 0x3014, [0x4464] = 0x3008, [0x4465] = 0x300a, [0x4466] = 0x3010,
  [0x4467] = 0x2266, [0x4468] = 0x2234, [0x4469] = 0x2642, [0x446a] = 0x00a7,
  [0x446b] = 0x203b, [0x446c] = 0x3012, [0x446d] = 0x3231, [0x446e] = 0x2116,
  [0x446f] = 0x2121, [0x4470] = 0xff3e, [0x4471] = 0x2019, [0x4472] = 0x201d,
  [0x4473] = 0x3015, [0x4474] = 0x3009, [0x4475] = 0x300b, [0x4476] = 0x3011,
  [0x4477] = 0x2267, [0x4478] = 0x2235, [0x4479] = 0x2640, [0x447a] = 0x00d7,
  [0x447b] = 0x00f7, [0x447c] = 0x2225, [0x447d] = 0x3013, [0x447e] = 0x2025,
  [0x447f] = 0x2026, [0x4481] = 0x3042, [0x4482] = 0x3044, [0x4483] = 0x3046,
  [0x4484] = 0x3048, [0x4485] = 0x304a, [0x4486] = 0x304b, [0x4487] = 0x304d,
  [0x4488] = 0x304f, [0x4489] = 0x3051, [0x448a] = 0x3053, [0x448c] = 0x3055,
  [0x448d] = 0x3057, [0x448e] = 0x3059, [0x448f] = 0x305b, [0x4490] = 0x305d,
  [0x4491] = 0x305f, [0x4492] = 0x3061, [0x4493] = 0x3064, [0x4494] = 0x3066,
  [0x4495] = 0x3068, [0x4496] = 0x306a, [0x4497] = 0x306b, [0x4498] = 0x306c,
  [0x4499] = 0x306d, [0x449a] = 0x306e, [0x449d] = 0x306f, [0x449e] = 0x3072,
  [0x449f] = 0x3075, [0x44a2] = 0x3078, [0x44a3] = 0x307b, [0x44a4] = 0x307e,
  [0x44a5] = 0x307f, [0x44a6] = 0x3080, [0x44a7] = 0x3081, [0x44a8] = 0x3082,
  [0x44a9] = 0x3084, [0x44aa] = 0x3086, [0x44ac] = 0x3088, [0x44ad] = 0x3089,
  [0x44ae] = 0x308a, [0x44af] = 0x308b, [0x44ba] = 0x308c, [0x44bb] = 0x308d,
  [0x44bc] = 0x308f, [0x44bd] = 0x3093, [0x44c0] = 0x304c, [0x44c1] = 0x304e,
  [0x44c2] = 0x3050, [0x44c3] = 0x3052, [0x44c4] = 0x3054, [0x44c5] = 0x3056,
  [0x44c6] = 0x3058, [0x44c7] = 0x305a, [0x44c8] = 0x305c, [0x44c9] = 0x305e,
  [0x44ca] = 0x3060, [0x44cb] = 0x3062, [0x44cc] = 0x3065, [0x44cd] = 0x3067,
  [0x44ce] = 0x3069, [0x44cf] = 0x3070, [0x44d0] = 0x3073, [0x44d1] = 0x3076,
  [0x44d2] = 0x3079, [0x44d3] = 0x307c, [0x44d5] = 0x3071, [0x44d6] = 0x3074,
  [0x44d7] = 0x3077, [0x44d8] = 0x307a, [0x44d9] = 0x307d, [0x44da] = 0x3090,
  [0x44db] = 0x3091, [0x44dc] = 0x309d, [0x44dd] = 0x309e, [0x44e0] = 0x25cb,
  [0x44e1] = 0x25cf, [0x44e2] = 0x25b3, [0x44e3] = 0x25b2, [0x44e4] = 0x25ce,
  [0x44e5] = 0x2606, [0x44e6] = 0x2605, [0x44e7] = 0x25c7, [0x44e8] = 0x25c6,
  [0x44e9] = 0x25a1, [0x44ea] = 0x25a0, [0x44eb] = 0x25bd, [0x44ec] = 0x25bc,
  [0x44ed] = 0x00b0, [0x44ee] = 0x00b4, [0x44ef] = 0x2033, [0x44f0] = 0x2192,
  [0x44f1] = 0x2190, [0x44f2] = 0x2191, [0x44f3] = 0x2193, [0x4541] = 0x3021,
  [0x4542] = 0x3022, [0x4543] = 0x3023, [0x4544] = 0x3024, [0x4545] = 0x3025,
  [0x4546] = 0x3026, [0x4547] = 0x3027, [0x4548] = 0x3028, [0x4549] = 0x3029,
  [0x454a] = 0x5341, [0x454b] = 0x5344, [0x454c] = 0x5345, [0x4551] = 0x02c9,
  [0x4552] = 0x02ca, [0x4553] = 0x02c7, [0x4554] = 0x02cb, [0x4555] = 0x02d9,
  [0x4556] = 0x3105, [0x4557] = 0x3106, [0x4558] = 0x3107, [0x4559] = 0x3108,
  [0x455a] = 0x3109, [0x455b] = 0x310a, [0x455c] = 0x310b, [0x455d] = 0x310c,
  [0x455e] = 0x310d, [0x455f] = 0x310e, [0x4560] = 0x310f, [0x4561] = 0x3110,
  [0x4562] = 0x3111, [0x4563] = 0x3112, [0x4564] = 0x3113, [0x4565] = 0x3114,
  [0x4566] = 0x3115, [0x4567] = 0x3116, [0x4568] = 0x3117, [0x4569] = 0x3118,
  [0x456a] = 0x3119, [0x456b] = 0x311a, [0x456c] = 0x311b, [0x456d] = 0x311c,
  [0x456e] = 0x311d, [0x456f] = 0x311e, [0x4570] = 0x311f, [0x4571] = 0x3120,
  [0x4572] = 0x3121, [0x4573] = 0x3122, [0x4574] = 0x3123, [0x4575] = 0x3124,
  [0x4576] = 0x3125, [0x4577] = 0x3126, [0x4578] = 0x3127, [0x4579] = 0x3128,
  [0x457a] = 0x3129, [0x4641] = 0x2460, [0x4642] = 0x2461, [0x4643] = 0x2462,
  [0x4644] = 0x2463, [0x4645] = 0x2464, [0x4646] = 0x2465, [0x4647] = 0x2466,
  [0x4648] = 0x2467, [0x4649] = 0x2468, [0x464a] = 0x2469, [0x4651] = 0x2474,
  [0x4652] = 0x2475, [0x4653] = 0x2476, [0x4654] = 0x2477, [0x4655] = 0x2478,
  [0x4656] = 0x2479, [0x4657] = 0x247a, [0x4658] = 0x247b, [0x4659] = 0x247c,
  [0x465a] = 0x247d, [0x4660] = 0x2581, [0x4661] = 0x2582, [0x4662] = 0x2583,
  [0x4663] = 0x2584, [0x4664] = 0x2585, [0x4665] = 0x2586, [0x4666] = 0x2587,
  [0x4667] = 0x2588, [0x4668] = 0x258f, [0x4669] = 0x258e, [0x466a] = 0x258d,
  [0x466b] = 0x258c, [0x466c] = 0x258b, [0x466d] = 0x258a, [0x466e] = 0x2589,
  [0x466f] = 0x253c, [0x4670] = 0x2534, [0x4671] = 0x252c, [0x4672] = 0x2524,
  [0x4673] = 0x251c, [0x4674] = 0x2594, [0x4675] = 0x2500, [0x4676] = 0x2502,
  [0x4677] = 0x2595, [0x4678] = 0x250c, [0x4679] = 0x2510, [0x467a] = 0x2514,
  [0x467b] = 0x2518, [0x467c] = 0x256d, [0x467d] = 0x256e, [0x467e] = 0x2570,
  [0x467f] = 0x256f, [0x4681] = 0x2550, [0x4682] = 0x255e, [0x4683] = 0x256a,
  [0x4684] = 0x2561, [0x4685] = 0x25e2, [0x4686] = 0x25e3, [0x4687] = 0x25e5,
  [0x4688] = 0x25e4, [0x4689] = 0x2571, [0x468a] = 0x2572, [0x468b] = 0x2573,
  [0x46a0] = 0xfe41, [0x46a1] = 0xfe42, [0x46a2] = 0xfe43, [0x46a3] = 0xfe44,
  [0x46a4] = 0xfe3b, [0x46a5] = 0xfe3c, [0x46a7] = 0xfe31, [0x46a8] = 0xf83f,
  [0x46a9] = 0xf840, [0x46aa] = 0xf841, [0x46ab] = 0xf842, [0x46ac] = 0xfe35,
  [0x46ad] = 0xfe36, [0x46ae] = 0xfe37, [0x46af] = 0xfe38, [0x46b0] = 0xfe39,
  [0x46b1] = 0xfe3a, [0x46b2] = 0xfe3d, [0x46b3] = 0xfe3e, [0x46b4] = 0xfe3f,
  [0x46b5] = 0xfe40, [0x46b6] = 0xfe33, [0x46b7] = 0x2574, [0x46b8] = 0xff0a,
  [0x46b9] = 0x3003, [0x46ba] = 0x32a3, [0x46bb] = 0x2105, [0x46bc] = 0xfe34,
  [0x46bd] = 0xfe4f, [0x46be] = 0xfe49, [0x46bf] = 0xfe4a, [0x46c0] = 0xfe4d,
  [0x46c1] = 0xfe4e, [0x46c2] = 0xfe4b, [0x46c3] = 0xfe4c, [0x46c4] = 0xfe61,
  [0x46c5] = 0x221a, [0x46c6] = 0x2252, [0x46c7] = 0x2261, [0x46c8] = 0x2229,
  [0x46c9] = 0x222a, [0x46ca] = 0x22a5, [0x46cb] = 0x2220, [0x46cc] = 0x221f,
  [0x46cd] = 0x22bf, [0x46ce] = 0x33d2, [0x46cf] = 0x33d1, [0x46d0] = 0x222b,
  [0x46d1] = 0x222e, [0x46d2] = 0x2295, [0x46d3] = 0x2299, [0x46d4] = 0x2196,
  [0x46d5] = 0x2197, [0x46d6] = 0x2199, [0x46d7] = 0x2198, [0x46da] = 0x2215,
  [0x46db] = 0x2109, [0x46dc] = 0x33d5, [0x46dd] = 0x339c, [0x46de] = 0x339d,
  [0x46df] = 0x339e, [0x46e0] = 0x33ce, [0x46e1] = 0x33a1, [0x46e2] = 0x338e,
  [0x46e3] = 0x338f, [0x46e4] = 0x33c4, [0x46e5] = 0x00b7, [0x46e9] = 0x301d,
  [0x46ea] = 0x301e, [0x46ee] = 0x21e7, [0x46ef] = 0x21b8, [0x46f0] = 0x21b9,
  [0x46f1] = 0x5159, [0x46f2] = 0x515b, [0x46f3] = 0x515e, [0x46f4] = 0x515d,
  [0x46f5] = 0x5161, [0x46f6] = 0x5163, [0x46f7] = 0x55e7, [0x46f8] = 0x74e9,
  [0x46f9] = 0x7cce, [0x4741] = 0xfe30, [0x4742] = 0xfe50, [0x4743] = 0xfe51,
  [0x4744] = 0xfe52, [0x4745] = 0xfe54, [0x4746] = 0xfe55, [0x4747] = 0xfe56,
  [0x4748] = 0xfe57, [0x4749] = 0xfe32, [0x474a] = 0xfe58, [0x474b] = 0xfe59,
  [0x474c] = 0xfe5a, [0x474d] = 0xfe5b, [0x474e] = 0xfe5c, [0x474f] = 0xfe5d,
  [0x4750] = 0xfe5e, [0x4751] = 0xffe3, [0x4752] = 0x02cd, [0x4753] = 0xfe5f,
  [0x4754] = 0xfe60, [0x4755] = 0xfe62, [0x4756] = 0xfe63, [0x4757] = 0xfe64,
  [0x4758] = 0xfe65, [0x4759] = 0xfe66, [0x475a] = 0xfe68, [0x475b] = 0xfe69,
  [0x475c] = 0xfe6a, [0x475d] = 0xfe6b, [0x4781] = 0x2400, [0x4782] = 0x2401,
  [0x4783] = 0x2402, [0x4784] = 0x2403, [0x4785] = 0x2404, [0x4786] = 0x2405,
  [0x4787] = 0x2406, [0x4788] = 0x2407, [0x4789] = 0x2408, [0x478a] = 0x2409,
  [0x478b] = 0x240a, [0x478c] = 0x240b, [0x478d] = 0x240c, [0x478e] = 0x240d,
  [0x478f] = 0x240e, [0x4790] = 0x240f, [0x4791] = 0x2410, [0x4792] = 0x2411,
  [0x4793] = 0x2412, [0x4794] = 0x2413, [0x4795] = 0x2414, [0x4796] = 0x2415,
  [0x4797] = 0x2416, [0x4798] = 0x2417, [0x4799] = 0x2418, [0x479a] = 0x2419,
  [0x479b] = 0x241a, [0x479c] = 0x241b, [0x479d] = 0x241c, [0x479e] = 0x241d,
  [0x479f] = 0x241e, [0x47a0] = 0x241f, [0x47a1] = 0x2421, [0x4841] = 0x4e00,
  [0x4842] = 0x4e28, [0x4843] = 0x4e36, [0x4844] = 0x4e3f, [0x4845] = 0x4e59,
  [0x4846] = 0x4e85, [0x4847] = 0x4e8c, [0x4848] = 0x4ea0, [0x4849] = 0x4eba,
  [0x484a] = 0x513f, [0x484b] = 0x5165, [0x484c] = 0x516b, [0x484d] = 0x5182,
  [0x484e] = 0x5196, [0x484f] = 0x51ab, [0x4850] = 0x51e0, [0x4851] = 0x51f5,
  [0x4852] = 0x5200, [0x4853] = 0x529b, [0x4854] = 0x52f9, [0x4855] = 0x5315,
  [0x4856] = 0x531a, [0x4857] = 0x5338, [0x4858] = 0x5341, [0x4859] = 0x535c,
  [0x485a] = 0x5369, [0x485b] = 0x5382, [0x485c] = 0x53b6, [0x485d] = 0x53c8,
  [0x485e] = 0x53e3, [0x485f] = 0x56d7, [0x4860] = 0x571f, [0x4861] = 0x58eb,
  [0x4862] = 0x590a, [0x4863] = 0x5915, [0x4864] = 0x5927, [0x4865] = 0x5973,
  [0x4866] = 0x5b50, [0x4867] = 0x5b80, [0x4868] = 0x5bf8, [0x4869] = 0x5c0f,
  [0x486a] = 0x5c22, [0x486b] = 0x5c38, [0x486c] = 0x5c6e, [0x486d] = 0x5c71,
  [0x486e] = 0x5ddb, [0x486f] = 0x5de5, [0x4870] = 0x5df1, [0x4871] = 0x5dfe,
  [0x4872] = 0x5e72, [0x4873] = 0x5e7a, [0x4874] = 0x5e7f, [0x4875] = 0x5ef4,
  [0x4876] = 0x5efe, [0x4877] = 0x5f0b, [0x4878] = 0x5f13, [0x4879] = 0x5f50,
  [0x487a] = 0x5f61, [0x487b] = 0x5f73, [0x487c] = 0x5fc3, [0x487d] = 0x6208,
  [0x487e] = 0x6236, [0x487f] = 0x624b, [0x4881] = 0x652f, [0x4882] = 0x6534,
  [0x4883] = 0x6587, [0x4884] = 0x6597, [0x4885] = 0x65a4, [0x4886] = 0x65b9,
  [0x4887] = 0x65e0, [0x4888] = 0x65e5, [0x4889] = 0x66f0, [0x488a] = 0x6708,
  [0x488b] = 0x6728, [0x488c] = 0x6b20, [0x488d] = 0x6b62, [0x488e] = 0x6b79,
  [0x488f] = 0x6bb3, [0x4890] = 0x6bcb, [0x4891] = 0x6bd4, [0x4892] = 0x6bdb,
  [0x4893] = 0x6c0f, [0x4894] = 0x6c14, [0x4895] = 0x6c34, [0x4896] = 0x706b,
  [0x4897] = 0x722a, [0x4898] = 0x7236, [0x4899] = 0x723b, [0x489a] = 0x723f,
  [0x489b] = 0x7247, [0x489c] = 0x7259, [0x489d] = 0x725b, [0x489e] = 0x72ac,
  [0x489f] = 0x7384, [0x48a0] = 0x7389, [0x48a1] = 0x74dc, [0x48a2] = 0x74e6,
  [0x48a3] = 0x7518, [0x48a4] = 0x751f, [0x48a5] = 0x7528, [0x48a6] = 0x7530,
  [0x48a7] = 0x758b, [0x48a8] = 0x7592, [0x48a9] = 0x7676, [0x48aa] = 0x767d,
  [0x48ab] = 0x76ae, [0x48ac] = 0x76bf, [0x48ad] = 0x76ee, [0x48ae] = 0x77db,
  [0x48af] = 0x77e2, [0x48b0] = 0x77f3, [0x48b1] = 0x793a, [0x48b2] = 0x79b8,
  [0x48b3] = 0x79be, [0x48b4] = 0x7a74, [0x48b5] = 0x7acb, [0x48b6] = 0x7af9,
  [0x48b7] = 0x7c73, [0x48b8] = 0x7cf8, [0x48b9] = 0x7f36, [0x48ba] = 0x7f51,
  [0x48bb] = 0x7f8a, [0x48bc] = 0x7fbd, [0x48bd] = 0x8001, [0x48be] = 0x800c,
  [0x48bf] = 0x8012, [0x48c0] = 0x8033, [0x48c1] = 0x807f, [0x48c2] = 0x8089,
  [0x48c3] = 0x81e3, [0x48c4] = 0x81ea, [0x48c5] = 0x81f3, [0x48c6] = 0x81fc,
  [0x48c7] = 0x820c, [0x48c8] = 0x821b, [0x48c9] = 0x821f, [0x48ca] = 0x826e,
  [0x48cb] = 0x8272, [0x48cc] = 0x8278, [0x48cd] = 0x864d, [0x48ce] = 0x866b,
  [0x48cf] = 0x8840, [0x48d0] = 0x884c, [0x48d1] = 0x8863, [0x48d2] = 0x897e,
  [0x48d3] = 0x898b, [0x48d4] = 0x89d2, [0x48d5] = 0x8a00, [0x48d6] = 0x8c37,
  [0x48d7] = 0x8c46, [0x48d8] = 0x8c55, [0x48d9] = 0x8c78, [0x48da] = 0x8c9d,
  [0x48db] = 0x8d64, [0x48dc] = 0x8d70, [0x48dd] = 0x8db3, [0x48de] = 0x8eab,
  [0x48df] = 0x8eca, [0x48e0] = 0x8f9b, [0x48e1] = 0x8fb0, [0x48e2] = 0x8fb5,
  [0x48e3] = 0x9091, [0x48e4] = 0x9149, [0x48e5] = 0x91c6, [0x48e6] = 0x91cc,
  [0x48e7] = 0x91d1, [0x48e8] = 0x9577, [0x48e9] = 0x9580, [0x48ea] = 0x961c,
  [0x48eb] = 0x96b6, [0x48ec] = 0x96b9, [0x48ed] = 0x96e8, [0x48ee] = 0x9752,
  [0x48ef] = 0x975e, [0x48f0] = 0x9762, [0x48f1] = 0x9769, [0x48f2] = 0x97cb,
  [0x48f3] = 0x97ed, [0x48f4] = 0x97f3, [0x48f5] = 0x9801, [0x48f6] = 0x98a8,
  [0x48f7] = 0x98db, [0x48f8] = 0x98df, [0x48f9] = 0x9996, [0x48fa] = 0x9999,
  [0x48fb] = 0x99ac, [0x48fc] = 0x9aa8, [0x48fd] = 0x9ad8, [0x4941] = 0x9adf,
  [0x4942] = 0x9b25, [0x4943] = 0x9b2f, [0x4944] = 0x9b32, [0x4945] = 0x9b3c,
  [0x4946] = 0x9b5a, [0x4947] = 0x9ce5, [0x4948] = 0x9e75, [0x4949] = 0x9e7f,
  [0x494a] = 0x9ea5, [0x494b] = 0x9ebb, [0x494c] = 0x9ec3, [0x494d] = 0x9ecd,
  [0x494e] = 0x9ed1, [0x494f] = 0x9ef9, [0x4950] = 0x9efd, [0x4951] = 0x9f0e,
  [0x4952] = 0x9f13, [0x4953] = 0x9f20, [0x4954] = 0x9f3b, [0x4955] = 0x9f4a,
  [0x4956] = 0x9f52, [0x4957] = 0x9f8d, [0x4958] = 0x9f9c, [0x4959] = 0x9fa0,
  [0x4c41] = 0x4e00, [0x4c42] = 0x4e59, [0x4c43] = 0x4e01, [0x4c44] = 0x4e03,
  [0x4c45] = 0x4e43, [0x4c46] = 0x4e5d, [0x4c47] = 0x4e86, [0x4c48] = 0x4e8c,
  [0x4c49] = 0x4eba, [0x4c4a] = 0x513f, [0x4c4b] = 0x5165, [0x4c4c] = 0x516b,
  [0x4c4d] = 0x51e0, [0x4c4e] = 0x5200, [0x4c4f] = 0x5201, [0x4c50] = 0x529b,
  [0x4c51] = 0x5315, [0x4c52] = 0x5341, [0x4c53] = 0x535c, [0x4c54] = 0x53c8,
  [0x4c55] = 0x4e09, [0x4c56] = 0x4e0b, [0x4c57] = 0x4e08, [0x4c58] = 0x4e0a,
  [0x4c59] = 0x4e2b, [0x4c5a] = 0x4e38, [0x4c5b] = 0x51e1, [0x4c5c] = 0x4e45,
  [0x4c5d] = 0x4e48, [0x4c5e] = 0x4e5f, [0x4c5f] = 0x4e5e, [0x4c60] = 0x4e8e,
  [0x4c61] = 0x4ea1, [0x4c62] = 0x5140, [0x4c63] = 0x5203, [0x4c64] = 0x52fa,
  [0x4c65] = 0x5343, [0x4c66] = 0x53c9, [0x4c67] = 0x53e3, [0x4c68] = 0x571f,
  [0x4c69] = 0x58eb, [0x4c6a] = 0x5915, [0x4c6b] = 0x5927, [0x4c6c] = 0x5973,
  [0x4c6d] = 0x5b50, [0x4c6e] = 0x5b51, [0x4c6f] = 0x5b53, [0x4c70] = 0x5bf8,
  [0x4c71] = 0x5c0f, [0x4c72] = 0x5c22, [0x4c73] = 0x5c38, [0x4c74] = 0x5c71,
  [0x4c75] = 0x5ddd, [0x4c76] = 0x5de5, [0x4c77] = 0x5df1, [0x4c78] = 0x5df2,
  [0x4c79] = 0x5df3, [0x4c7a] = 0x5dfe, [0x4c7b] = 0x5e72, [0x4c7c] = 0x5efe,
  [0x4c7d] = 0x5f0b, [0x4c7e] = 0x5f13, [0x4c7f] = 0x624d, [0x4c81] = 0x4e11,
  [0x4c82] = 0x4e10, [0x4c83] = 0x4e0d, [0x4c84] = 0x4e2d, [0x4c85] = 0x4e30,
  [0x4c86] = 0x4e39, [0x4c87] = 0x4e4b, [0x4c88] = 0x5c39, [0x4c89] = 0x4e88,
  [0x4c8a] = 0x4e91, [0x4c8b] = 0x4e95, [0x4c8c] = 0x4e92, [0x4c8d] = 0x4e94,
  [0x4c8e] = 0x4ea2, [0x4c8f] = 0x4ec1, [0x4c90] = 0x4ec0, [0x4c91] = 0x4ec3,
  [0x4c92] = 0x4ec6, [0x4c93] = 0x4ec7, [0x4c94] = 0x4ecd, [0x4c95] = 0x4eca,
  [0x4c96] = 0x4ecb, [0x4c97] = 0x4ec4, [0x4c98] = 0x5143, [0x4c99] = 0x5141,
  [0x4c9a] = 0x5167, [0x4c9b] = 0x516d, [0x4c9c] = 0x516e, [0x4c9d] = 0x516c,
  [0x4c9e] = 0x5197, [0x4c9f] = 0x51f6, [0x4ca0] = 0x5206, [0x4ca1] = 0x5207,
  [0x4ca2] = 0x5208, [0x4ca3] = 0x52fb, [0x4ca4] = 0x52fe, [0x4ca5] = 0x52ff,
  [0x4ca6] = 0x5316, [0x4ca7] = 0x5339, [0x4ca8] = 0x5348, [0x4ca9] = 0x5347,
  [0x4caa] = 0x5345, [0x4cab] = 0x535e, [0x4cac] = 0x5384, [0x4cad] = 0x53cb,
  [0x4cae] = 0x53ca, [0x4caf] = 0x53cd, [0x4cb0] = 0x58ec, [0x4cb1] = 0x5929,
  [0x4cb2] = 0x592b, [0x4cb3] = 0x592a, [0x4cb4] = 0x592d, [0x4cb5] = 0x5b54,
  [0x4cb6] = 0x5c11, [0x4cb7] = 0x5c24, [0x4cb8] = 0x5c3a, [0x4cb9] = 0x5c6f,
  [0x4cba] = 0x5df4, [0x4cbb] = 0x5e7b, [0x4cbc] = 0x5eff, [0x4cbd] = 0x5f14,
  [0x4cbe] = 0x5f15, [0x4cbf] = 0x5fc3, [0x4cc0] = 0x6208, [0x4cc1] = 0x6236,
  [0x4cc2] = 0x624b, [0x4cc3] = 0x624e, [0x4cc4] = 0x652f, [0x4cc5] = 0x6587,
  [0x4cc6] = 0x6597, [0x4cc7] = 0x65a4, [0x4cc8] = 0x65b9, [0x4cc9] = 0x65e5,
  [0x4cca] = 0x66f0, [0x4ccb] = 0x6708, [0x4ccc] = 0x6728, [0x4ccd] = 0x6b20,
  [0x4cce] = 0x6b62, [0x4ccf] = 0x6b79, [0x4cd0] = 0x6bcb, [0x4cd1] = 0x6bd4,
  [0x4cd2] = 0x6bdb, [0x4cd3] = 0x6c0f, [0x4cd4] = 0x6c34, [0x4cd5] = 0x706b,
  [0x4cd6] = 0x722a, [0x4cd7] = 0x7236, [0x4cd8] = 0x723b, [0x4cd9] = 0x7247,
  [0x4cda] = 0x7259, [0x4cdb] = 0x725b, [0x4cdc] = 0x72ac, [0x4cdd] = 0x738b,
  [0x4cde] = 0x4e19, [0x4cdf] = 0x4e16, [0x4ce0] = 0x4e15, [0x4ce1] = 0x4e14,
  [0x4ce2] = 0x4e18, [0x4ce3] = 0x4e3b, [0x4ce4] = 0x4e4d, [0x4ce5] = 0x4e4f,
  [0x4ce6] = 0x4e4e, [0x4ce7] = 0x4ee5, [0x4ce8] = 0x4ed8, [0x4ce9] = 0x4ed4,
  [0x4cea] = 0x4ed5, [0x4ceb] = 0x4ed6, [0x4cec] = 0x4ed7, [0x4ced] = 0x4ee3,
  [0x4cee] = 0x4ee4, [0x4cef] = 0x4ed9, [0x4cf0] = 0x4ede, [0x4cf1] = 0x5145,
  [0x4cf2] = 0x5144, [0x4cf3] = 0x5189, [0x4cf4] = 0x518a, [0x4cf5] = 0x51ac,
  [0x4cf6] = 0x51f9, [0x4cf7] = 0x51fa, [0x4cf8] = 0x51f8, [0x4cf9] = 0x520a,
  [0x4cfa] = 0x52a0, [0x4cfb] = 0x529f, [0x4cfc] = 0x5305, [0x4cfd] = 0x5306,
  [0x4d41] = 0x5317, [0x4d42] = 0x531d, [0x4d43] = 0x4edf, [0x4d44] = 0x534a,
  [0x4d45] = 0x5349, [0x4d46] = 0x5361, [0x4d47] = 0x5360, [0x4d48] = 0x536f,
  [0x4d49] = 0x536e, [0x4d4a] = 0x53bb, [0x4d4b] = 0x53ef, [0x4d4c] = 0x53e4,
  [0x4d4d] = 0x53f3, [0x4d4e] = 0x53ec, [0x4d4f] = 0x53ee, [0x4d50] = 0x53e9,
  [0x4d51] = 0x53e8, [0x4d52] = 0x53fc, [0x4d53] = 0x53f8, [0x4d54] = 0x53f5,
  [0x4d55] = 0x53eb, [0x4d56] = 0x53e6, [0x4d57] = 0x53ea, [0x4d58] = 0x53f2,
  [0x4d59] = 0x53f1, [0x4d5a] = 0x53f0, [0x4d5b] = 0x53e5, [0x4d5c] = 0x53ed,
  [0x4d5d] = 0x53fb, [0x4d5e] = 0x56db, [0x4d5f] = 0x56da, [0x4d60] = 0x5916,
  [0x4d61] = 0x592e, [0x4d62] = 0x5931, [0x4d63] = 0x5974, [0x4d64] = 0x5976,
  [0x4d65] = 0x5b55, [0x4d66] = 0x5b83, [0x4d67] = 0x5c3c, [0x4d68] = 0x5de8,
  [0x4d69] = 0x5de7, [0x4d6a] = 0x5de6, [0x4d6b] = 0x5e02, [0x4d6c] = 0x5e03,
  [0x4d6d] = 0x5e73, [0x4d6e] = 0x5e7c, [0x4d6f] = 0x5f01, [0x4d70] = 0x5f18,
  [0x4d71] = 0x5f17, [0x4d72] = 0x5fc5, [0x4d73] = 0x620a, [0x4d74] = 0x6253,
  [0x4d75] = 0x6254, [0x4d76] = 0x6252, [0x4d77] = 0x6251, [0x4d78] = 0x65a5,
  [0x4d79] = 0x65e6, [0x4d7a] = 0x672e, [0x4d7b] = 0x672c, [0x4d7c] = 0x672a,
  [0x4d7d] = 0x672b, [0x4d7e] = 0x672d, [0x4d7f] = 0x6b63, [0x4d81] = 0x6bcd,
  [0x4d82] = 0x6c11, [0x4d83] = 0x6c10, [0x4d84] = 0x6c38, [0x4d85] = 0x6c41,
  [0x4d86] = 0x6c40, [0x4d87] = 0x6c3e, [0x4d88] = 0x72af, [0x4d89] = 0x7384,
  [0x4d8a] = 0x7389, [0x4d8b] = 0x74dc, [0x4d8c] = 0x74e6, [0x4d8d] = 0x7518,
  [0x4d8e] = 0x751f, [0x4d8f] = 0x7528, [0x4d90] = 0x7529, [0x4d91] = 0x7530,
  [0x4d92] = 0x7531, [0x4d93] = 0x7532, [0x4d94] = 0x7533, [0x4d95] = 0x758b,
  [0x4d96] = 0x767d, [0x4d97] = 0x76ae, [0x4d98] = 0x76bf, [0x4d99] = 0x76ee,
  [0x4d9a] = 0x77db, [0x4d9b] = 0x77e2, [0x4d9c] = 0x77f3, [0x4d9d] = 0x793a,
  [0x4d9e] = 0x79be, [0x4d9f] = 0x7a74, [0x4da0] = 0x7acb, [0x4da1] = 0x4e1e,
  [0x4da2] = 0x4e1f, [0x4da3] = 0x4e52, [0x4da4] = 0x4e53, [0x4da5] = 0x4e69,
  [0x4da6] = 0x4e99, [0x4da7] = 0x4ea4, [0x4da8] = 0x4ea6, [0x4da9] = 0x4ea5,
  [0x4daa] = 0x4eff, [0x4dab] = 0x4f09, [0x4dac] = 0x4f19, [0x4dad] = 0x4f0a,
  [0x4dae] = 0x4f15, [0x4daf] = 0x4f0d, [0x4db0] = 0x4f10, [0x4db1] = 0x4f11,
  [0x4db2] = 0x4f0f, [0x4db3] = 0x4ef2, [0x4db4] = 0x4ef6, [0x4db5] = 0x4efb,
  [0x4db6] = 0x4ef0, [0x4db7] = 0x4ef3, [0x4db8] = 0x4efd, [0x4db9] = 0x4f01,
  [0x4dba] = 0x4f0b, [0x4dbb] = 0x5149, [0x4dbc] = 0x5147, [0x4dbd] = 0x5146,
  [0x4dbe] = 0x5148, [0x4dbf] = 0x5168, [0x4dc0] = 0x5171, [0x4dc1] = 0x518d,
  [0x4dc2] = 0x51b0, [0x4dc3] = 0x5217, [0x4dc4] = 0x5211, [0x4dc5] = 0x5212,
  [0x4dc6] = 0x520e, [0x4dc7] = 0x5216, [0x4dc8] = 0x52a3, [0x4dc9] = 0x5308,
  [0x4dca] = 0x5321, [0x4dcb] = 0x5320, [0x4dcc] = 0x5370, [0x4dcd] = 0x5371,
  [0x4dce] = 0x5409, [0x4dcf] = 0x540f, [0x4dd0] = 0x540c, [0x4dd1] = 0x540a,
  [0x4dd2] = 0x5410, [0x4dd3] = 0x5401, [0x4dd4] = 0x540b, [0x4dd5] = 0x5404,
  [0x4dd6] = 0x5411, [0x4dd7] = 0x540d, [0x4dd8] = 0x5408, [0x4dd9] = 0x5403,
  [0x4dda] = 0x540e, [0x4ddb] = 0x5406, [0x4ddc] = 0x5412, [0x4ddd] = 0x56e0,
  [0x4dde] = 0x56de, [0x4ddf] = 0x56dd, [0x4de0] = 0x5733, [0x4de1] = 0x5730,
  [0x4de2] = 0x5728, [0x4de3] = 0x572d, [0x4de4] = 0x572c, [0x4de5] = 0x572f,
  [0x4de6] = 0x5729, [0x4de7] = 0x5919, [0x4de8] = 0x591a, [0x4de9] = 0x5937,
  [0x4dea] = 0x5938, [0x4deb] = 0x5984, [0x4dec] = 0x5978, [0x4ded] = 0x5983,
  [0x4dee] = 0x597d, [0x4def] = 0x5979, [0x4df0] = 0x5982, [0x4df1] = 0x5981,
  [0x4df2] = 0x5b57, [0x4df3] = 0x5b58, [0x4df4] = 0x5b87, [0x4df5] = 0x5b88,
  [0x4df6] = 0x5b85, [0x4df7] = 0x5b89, [0x4df8] = 0x5bfa, [0x4df9] = 0x5c16,
  [0x4dfa] = 0x5c79, [0x4dfb] = 0x5dde, [0x4dfc] = 0x5e06, [0x4dfd] = 0x5e76,
  [0x4e41] = 0x5e74, [0x4e42] = 0x5f0f, [0x4e43] = 0x5f1b, [0x4e44] = 0x5fd9,
  [0x4e45] = 0x5fd6, [0x4e46] = 0x620e, [0x4e47] = 0x620c, [0x4e48] = 0x620d,
  [0x4e49] = 0x6210, [0x4e4a] = 0x6263, [0x4e4b] = 0x625b, [0x4e4c] = 0x6258,
  [0x4e4d] = 0x6536, [0x4e4e] = 0x65e9, [0x4e4f] = 0x65e8, [0x4e50] = 0x65ec,
  [0x4e51] = 0x65ed, [0x4e52] = 0x66f2, [0x4e53] = 0x66f3, [0x4e54] = 0x6709,
  [0x4e55] = 0x673d, [0x4e56] = 0x6734, [0x4e57] = 0x6731, [0x4e58] = 0x6735,
  [0x4e59] = 0x6b21, [0x4e5a] = 0x6b64, [0x4e5b] = 0x6b7b, [0x4e5c] = 0x6c16,
  [0x4e5d] = 0x6c5d, [0x4e5e] = 0x6c57, [0x4e5f] = 0x6c59, [0x4e60] = 0x6c5f,
  [0x4e61] = 0x6c60, [0x4e62] = 0x6c50, [0x4e63] = 0x6c55, [0x4e64] = 0x6c61,
  [0x4e65] = 0x6c5b, [0x4e66] = 0x6c4d, [0x4e67] = 0x6c4e, [0x4e68] = 0x7070,
  [0x4e69] = 0x725f, [0x4e6a] = 0x725d, [0x4e6b] = 0x767e, [0x4e6c] = 0x7af9,
  [0x4e6d] = 0x7c73, [0x4e6e] = 0x7cf8, [0x4e6f] = 0x7f36, [0x4e70] = 0x7f8a,
  [0x4e71] = 0x7fbd, [0x4e72] = 0x8001, [0x4e73] = 0x8003, [0x4e74] = 0x800c,
  [0x4e75] = 0x8012, [0x4e76] = 0x8033, [0x4e77] = 0x807f, [0x4e78] = 0x8089,
  [0x4e79] = 0x808b, [0x4e7a] = 0x808c, [0x4e7b] = 0x81e3, [0x4e7c] = 0x81ea,
  [0x4e7d] = 0x81f3, [0x4e7e] = 0x81fc, [0x4e7f] = 0x820c, [0x4e81] = 0x821b,
  [0x4e82] = 0x821f, [0x4e83] = 0x826e, [0x4e84] = 0x8272, [0x4e85] = 0x827e,
  [0x4e86] = 0x866b, [0x4e87] = 0x8840, [0x4e88] = 0x884c, [0x4e89] = 0x8863,
  [0x4e8a] = 0x897f, [0x4e8b] = 0x9621, [0x4e8c] = 0x4e32, [0x4e8d] = 0x4ea8,
  [0x4e8e] = 0x4f4d, [0x4e8f] = 0x4f4f, [0x4e90] = 0x4f47, [0x4e91] = 0x4f57,
  [0x4e92] = 0x4f5e, [0x4e93] = 0x4f34, [0x4e94] = 0x4f5b, [0x4e95] = 0x4f55,
  [0x4e96] = 0x4f30, [0x4e97] = 0x4f50, [0x4e98] = 0x4f51, [0x4e99] = 0x4f3d,
  [0x4e9a] = 0x4f3a, [0x4e9b] = 0x4f38, [0x4e9c] = 0x4f43, [0x4e9d] = 0x4f54,
  [0x4e9e] = 0x4f3c, [0x4e9f] = 0x4f46, [0x4ea0] = 0x4f63, [0x4ea1] = 0x4f5c,
  [0x4ea2] = 0x4f60, [0x4ea3] = 0x4f2f, [0x4ea4] = 0x4f4e, [0x4ea5] = 0x4f36,
  [0x4ea6] = 0x4f59, [0x4ea7] = 0x4f5d, [0x4ea8] = 0x4f48, [0x4ea9] = 0x4f5a,
  [0x4eaa] = 0x514c, [0x4eab] = 0x514b, [0x4eac] = 0x514d, [0x4ead] = 0x5175,
  [0x4eae] = 0x51b6, [0x4eaf] = 0x51b7, [0x4eb0] = 0x5225, [0x4eb1] = 0x5224,
  [0x4eb2] = 0x5229, [0x4eb3] = 0x522a, [0x4eb4] = 0x5228, [0x4eb5] = 0x52ab,
  [0x4eb6] = 0x52a9, [0x4eb7] = 0x52aa, [0x4eb8] = 0x52ac, [0x4eb9] = 0x5323,
  [0x4eba] = 0x5373, [0x4ebb] = 0x5375, [0x4ebc] = 0x541d, [0x4ebd] = 0x542d,
  [0x4ebe] = 0x541e, [0x4ebf] = 0x543e, [0x4ec0] = 0x5426, [0x4ec1] = 0x544e,
  [0x4ec2] = 0x5427, [0x4ec3] = 0x5446, [0x4ec4] = 0x5443, [0x4ec5] = 0x5433,
  [0x4ec6] = 0x5448, [0x4ec7] = 0x5442, [0x4ec8] = 0x541b, [0x4ec9] = 0x5429,
  [0x4eca] = 0x544a, [0x4ecb] = 0x5439, [0x4ecc] = 0x543b, [0x4ecd] = 0x5438,
  [0x4ece] = 0x542e, [0x4ecf] = 0x5435, [0x4ed0] = 0x5436, [0x4ed1] = 0x5420,
  [0x4ed2] = 0x543c, [0x4ed3] = 0x5440, [0x4ed4] = 0x5431, [0x4ed5] = 0x542b,
  [0x4ed6] = 0x541f, [0x4ed7] = 0x542c, [0x4ed8] = 0x56ea, [0x4ed9] = 0x56f0,
  [0x4eda] = 0x56e4, [0x4edb] = 0x56eb, [0x4edc] = 0x574a, [0x4edd] = 0x5751,
  [0x4ede] = 0x5740, [0x4edf] = 0x574d, [0x4ee0] = 0x5747, [0x4ee1] = 0x574e,
  [0x4ee2] = 0x573e, [0x4ee3] = 0x5750, [0x4ee4] = 0x574f, [0x4ee5] = 0x573b,
  [0x4ee6] = 0x58ef, [0x4ee7] = 0x593e, [0x4ee8] = 0x599d, [0x4ee9] = 0x5992,
  [0x4eea] = 0x59a8, [0x4eeb] = 0x599e, [0x4eec] = 0x59a3, [0x4eed] = 0x5999,
  [0x4eee] = 0x5996, [0x4eef] = 0x598d, [0x4ef0] = 0x59a4, [0x4ef1] = 0x5993,
  [0x4ef2] = 0x598a, [0x4ef3] = 0x59a5, [0x4ef4] = 0x5b5d, [0x4ef5] = 0x5b5c,
  [0x4ef6] = 0x5b5a, [0x4ef7] = 0x5b5b, [0x4ef8] = 0x5b8c, [0x4ef9] = 0x5b8b,
  [0x4efa] = 0x5b8f, [0x4efb] = 0x5c2c, [0x4efc] = 0x5c40, [0x4efd] = 0x5c41,
  [0x4f41] = 0x5c3f, [0x4f42] = 0x5c3e, [0x4f43] = 0x5c90, [0x4f44] = 0x5c91,
  [0x4f45] = 0x5c94, [0x4f46] = 0x5c8c, [0x4f47] = 0x5deb, [0x4f48] = 0x5e0c,
  [0x4f49] = 0x5e8f, [0x4f4a] = 0x5e87, [0x4f4b] = 0x5e8a, [0x4f4c] = 0x5ef7,
  [0x4f4d] = 0x5f04, [0x4f4e] = 0x5f1f, [0x4f4f] = 0x5f64, [0x4f50] = 0x5f62,
  [0x4f51] = 0x5f77, [0x4f52] = 0x5f79, [0x4f53] = 0x5fd8, [0x4f54] = 0x5fcc,
  [0x4f55] = 0x5fd7, [0x4f56] = 0x5fcd, [0x4f57] = 0x5ff1, [0x4f58] = 0x5feb,
  [0x4f59] = 0x5ff8, [0x4f5a] = 0x5fea, [0x4f5b] = 0x6212, [0x4f5c] = 0x6211,
  [0x4f5d] = 0x6284, [0x4f5e] = 0x6297, [0x4f5f] = 0x6296, [0x4f60] = 0x6280,
  [0x4f61] = 0x6276, [0x4f62] = 0x6289, [0x4f63] = 0x626d, [0x4f64] = 0x628a,
  [0x4f65] = 0x627c, [0x4f66] = 0x627e, [0x4f67] = 0x6279, [0x4f68] = 0x6273,
  [0x4f69] = 0x6292, [0x4f6a] = 0x626f, [0x4f6b] = 0x6298, [0x4f6c] = 0x626e,
  [0x4f6d] = 0x6295, [0x4f6e] = 0x6293, [0x4f6f] = 0x6291, [0x4f70] = 0x6286,
  [0x4f71] = 0x6539, [0x4f72] = 0x653b, [0x4f73] = 0x6538, [0x4f74] = 0x65f1,
  [0x4f75] = 0x66f4, [0x4f76] = 0x675f, [0x4f77] = 0x674e, [0x4f78] = 0x674f,
  [0x4f79] = 0x6750, [0x4f7a] = 0x6751, [0x4f7b] = 0x675c, [0x4f7c] = 0x6756,
  [0x4f7d] = 0x675e, [0x4f7e] = 0x6749, [0x4f7f] = 0x6746, [0x4f81] = 0x6760,
  [0x4f82] = 0x6753, [0x4f83] = 0x6757, [0x4f84] = 0x6b65, [0x4f85] = 0x6bcf,
  [0x4f86] = 0x6c42, [0x4f87] = 0x6c5e, [0x4f88] = 0x6c99, [0x4f89] = 0x6c81,
  [0x4f8a] = 0x6c88, [0x4f8b] = 0x6c89, [0x4f8c] = 0x6c85, [0x4f8d] = 0x6c9b,
  [0x4f8e] = 0x6c6a, [0x4f8f] = 0x6c7a, [0x4f90] = 0x6c90, [0x4f91] = 0x6c70,
  [0x4f92] = 0x6c8c, [0x4f93] = 0x6c68, [0x4f94] = 0x6c96, [0x4f95] = 0x6c92,
  [0x4f96] = 0x6c7d, [0x4f97] = 0x6c83, [0x4f98] = 0x6c72, [0x4f99] = 0x6c7e,
  [0x4f9a] = 0x6c74, [0x4f9b] = 0x6c86, [0x4f9c] = 0x6c76, [0x4f9d] = 0x6c8d,
  [0x4f9e] = 0x6c94, [0x4f9f] = 0x6c98, [0x4fa0] = 0x6c82, [0x4fa1] = 0x7076,
  [0x4fa2] = 0x707c, [0x4fa3] = 0x707d, [0x4fa4] = 0x7078, [0x4fa5] = 0x7262,
  [0x4fa6] = 0x7261, [0x4fa7] = 0x7260, [0x4fa8] = 0x72c4, [0x4fa9] = 0x72c2,
  [0x4faa] = 0x7396, [0x4fab] = 0x752c, [0x4fac] = 0x752b, [0x4fad] = 0x7537,
  [0x4fae] = 0x7538, [0x4faf] = 0x7682, [0x4fb0] = 0x76ef, [0x4fb1] = 0x77e3,
  [0x4fb2] = 0x79c1, [0x4fb3] = 0x79c0, [0x4fb4] = 0x79bf, [0x4fb5] = 0x7a76,
  [0x4fb6] = 0x7cfb, [0x4fb7] = 0x7f55, [0x4fb8] = 0x8096, [0x4fb9] = 0x8093,
  [0x4fba] = 0x809d, [0x4fbb] = 0x8098, [0x4fbc] = 0x809b, [0x4fbd] = 0x809a,
  [0x4fbe] = 0x80b2, [0x4fbf] = 0x826f, [0x4fc0] = 0x8292, [0x4fc1] = 0x828b,
  [0x4fc2] = 0x828d, [0x4fc3] = 0x898b, [0x4fc4] = 0x89d2, [0x4fc5] = 0x8a00,
  [0x4fc6] = 0x8c37, [0x4fc7] = 0x8c46, [0x4fc8] = 0x8c55, [0x4fc9] = 0x8c9d,
  [0x4fca] = 0x8d64, [0x4fcb] = 0x8d70, [0x4fcc] = 0x8db3, [0x4fcd] = 0x8eab,
  [0x4fce] = 0x8eca, [0x4fcf] = 0x8f9b, [0x4fd0] = 0x8fb0, [0x4fd1] = 0x8fc2,
  [0x4fd2] = 0x8fc6, [0x4fd3] = 0x8fc5, [0x4fd4] = 0x8fc4, [0x4fd5] = 0x5de1,
  [0x4fd6] = 0x9091, [0x4fd7] = 0x90a2, [0x4fd8] = 0x90aa, [0x4fd9] = 0x90a6,
  [0x4fda] = 0x90a3, [0x4fdb] = 0x9149, [0x4fdc] = 0x91c6, [0x4fdd] = 0x91cc,
  [0x4fde] = 0x9632, [0x4fdf] = 0x962e, [0x4fe0] = 0x9631, [0x4fe1] = 0x962a,
  [0x4fe2] = 0x962c, [0x4fe3] = 0x4e26, [0x4fe4] = 0x4e56, [0x4fe5] = 0x4e73,
  [0x4fe6] = 0x4e8b, [0x4fe7] = 0x4e9b, [0x4fe8] = 0x4e9e, [0x4fe9] = 0x4eab,
  [0x4fea] = 0x4eac, [0x4feb] = 0x4f6f, [0x4fec] = 0x4f9d, [0x4fed] = 0x4f8d,
  [0x4fee] = 0x4f73, [0x4fef] = 0x4f7f, [0x4ff0] = 0x4f6c, [0x4ff1] = 0x4f9b,
  [0x4ff2] = 0x4f8b, [0x4ff3] = 0x4f86, [0x4ff4] = 0x4f83, [0x4ff5] = 0x4f70,
  [0x4ff6] = 0x4f75, [0x4ff7] = 0x4f88, [0x4ff8] = 0x4f69, [0x4ff9] = 0x4f7b,
  [0x4ffa] = 0x4f96, [0x4ffb] = 0x4f7e, [0x4ffc] = 0x4f8f, [0x4ffd] = 0x4f91,
  [0x5041] = 0x4f7a, [0x5042] = 0x5154, [0x5043] = 0x5152, [0x5044] = 0x5155,
  [0x5045] = 0x5169, [0x5046] = 0x5177, [0x5047] = 0x5176, [0x5048] = 0x5178,
  [0x5049] = 0x51bd, [0x504a] = 0x51fd, [0x504b] = 0x523b, [0x504c] = 0x5238,
  [0x504d] = 0x5237, [0x504e] = 0x523a, [0x504f] = 0x5230, [0x5050] = 0x522e,
  [0x5051] = 0x5236, [0x5052] = 0x5241, [0x5053] = 0x52be, [0x5054] = 0x52bb,
  [0x5055] = 0x5352, [0x5056] = 0x5354, [0x5057] = 0x5353, [0x5058] = 0x5351,
  [0x5059] = 0x5366, [0x505a] = 0x5377, [0x505b] = 0x5378, [0x505c] = 0x5379,
  [0x505d] = 0x53d6, [0x505e] = 0x53d4, [0x505f] = 0x53d7, [0x5060] = 0x5473,
  [0x5061] = 0x5475, [0x5062] = 0x5496, [0x5063] = 0x5478, [0x5064] = 0x5495,
  [0x5065] = 0x5480, [0x5066] = 0x547b, [0x5067] = 0x5477, [0x5068] = 0x5484,
  [0x5069] = 0x5492, [0x506a] = 0x5486, [0x506b] = 0x547c, [0x506c] = 0x5490,
  [0x506d] = 0x5471, [0x506e] = 0x5476, [0x506f] = 0x548c, [0x5070] = 0x549a,
  [0x5071] = 0x5462, [0x5072] = 0x5468, [0x5073] = 0x548b, [0x5074] = 0x547d,
  [0x5075] = 0x548e, [0x5076] = 0x56fa, [0x5077] = 0x5783, [0x5078] = 0x5777,
  [0x5079] = 0x576a, [0x507a] = 0x5769, [0x507b] = 0x5761, [0x507c] = 0x5766,
  [0x507d] = 0x5764, [0x507e] = 0x577c, [0x507f] = 0x591c, [0x5081] = 0x5949,
  [0x5082] = 0x5947, [0x5083] = 0x5948, [0x5084] = 0x5944, [0x5085] = 0x5954,
  [0x5086] = 0x59be, [0x5087] = 0x59bb, [0x5088] = 0x59d4, [0x5089] = 0x59b9,
  [0x508a] = 0x59ae, [0x508b] = 0x59d1, [0x508c] = 0x59c6, [0x508d] = 0x59d0,
  [0x508e] = 0x59cd, [0x508f] = 0x59cb, [0x5090] = 0x59d3, [0x5091] = 0x59ca,
  [0x5092] = 0x59af, [0x5093] = 0x59b3, [0x5094] = 0x59d2, [0x5095] = 0x59c5,
  [0x5096] = 0x5b5f, [0x5097] = 0x5b64, [0x5098] = 0x5b63, [0x5099] = 0x5b97,
  [0x509a] = 0x5b9a, [0x509b] = 0x5b98, [0x509c] = 0x5b9c, [0x509d] = 0x5b99,
  [0x509e] = 0x5b9b, [0x509f] = 0x5c1a, [0x50a0] = 0x5c48, [0x50a1] = 0x5c45,
  [0x50a2] = 0x5c46, [0x50a3] = 0x5cb7, [0x50a4] = 0x5ca1, [0x50a5] = 0x5cb8,
  [0x50a6] = 0x5ca9, [0x50a7] = 0x5cab, [0x50a8] = 0x5cb1, [0x50a9] = 0x5cb3,
  [0x50aa] = 0x5e18, [0x50ab] = 0x5e1a, [0x50ac] = 0x5e16, [0x50ad] = 0x5e15,
  [0x50ae] = 0x5e1b, [0x50af] = 0x5e11, [0x50b0] = 0x5e78, [0x50b1] = 0x5e9a,
  [0x50b2] = 0x5e97, [0x50b3] = 0x5e9c, [0x50b4] = 0x5e95, [0x50b5] = 0x5e96,
  [0x50b6] = 0x5ef6, [0x50b7] = 0x5f26, [0x50b8] = 0x5f27, [0x50b9] = 0x5f29,
  [0x50ba] = 0x5f80, [0x50bb] = 0x5f81, [0x50bc] = 0x5f7f, [0x50bd] = 0x5f7c,
  [0x50be] = 0x5fdd, [0x50bf] = 0x5fe0, [0x50c0] = 0x5ffd, [0x50c1] = 0x5ff5,
  [0x50c2] = 0x5fff, [0x50c3] = 0x600f, [0x50c4] = 0x6014, [0x50c5] = 0x602f,
  [0x50c6] = 0x6035, [0x50c7] = 0x6016, [0x50c8] = 0x602a, [0x50c9] = 0x6015,
  [0x50ca] = 0x6021, [0x50cb] = 0x6027, [0x50cc] = 0x6029, [0x50cd] = 0x602b,
  [0x50ce] = 0x601b, [0x50cf] = 0x6216, [0x50d0] = 0x6215, [0x50d1] = 0x623f,
  [0x50d2] = 0x623e, [0x50d3] = 0x6240, [0x50d4] = 0x627f, [0x50d5] = 0x62c9,
  [0x50d6] = 0x62cc, [0x50d7] = 0x62c4, [0x50d8] = 0x62bf, [0x50d9] = 0x62c2,
  [0x50da] = 0x62b9, [0x50db] = 0x62d2, [0x50dc] = 0x62db, [0x50dd] = 0x62ab,
  [0x50de] = 0x62d3, [0x50df] = 0x62d4, [0x50e0] = 0x62cb, [0x50e1] = 0x62c8,
  [0x50e2] = 0x62a8, [0x50e3] = 0x62bd, [0x50e4] = 0x62bc, [0x50e5] = 0x62d0,
  [0x50e6] = 0x62d9, [0x50e7] = 0x62c7, [0x50e8] = 0x62cd, [0x50e9] = 0x62b5,
  [0x50ea] = 0x62da, [0x50eb] = 0x62b1, [0x50ec] = 0x62d8, [0x50ed] = 0x62d6,
  [0x50ee] = 0x62d7, [0x50ef] = 0x62c6, [0x50f0] = 0x62ac, [0x50f1] = 0x62ce,
  [0x50f2] = 0x653e, [0x50f3] = 0x65a7, [0x50f4] = 0x65bc, [0x50f5] = 0x65fa,
  [0x50f6] = 0x6614, [0x50f7] = 0x6613, [0x50f8] = 0x660c, [0x50f9] = 0x6606,
  [0x50fa] = 0x6602, [0x50fb] = 0x660e, [0x50fc] = 0x6600, [0x50fd] = 0x660f,
  [0x5141] = 0x6615, [0x5142] = 0x660a, [0x5143] = 0x6607, [0x5144] = 0x670d,
  [0x5145] = 0x670b, [0x5146] = 0x676d, [0x5147] = 0x678b, [0x5148] = 0x6795,
  [0x5149] = 0x6771, [0x514a] = 0x679c, [0x514b] = 0x6773, [0x514c] = 0x6777,
  [0x514d] = 0x6787, [0x514e] = 0x679d, [0x514f] = 0x6797, [0x5150] = 0x676f,
  [0x5151] = 0x6770, [0x5152] = 0x677f, [0x5153] = 0x6789, [0x5154] = 0x677e,
  [0x5155] = 0x6790, [0x5156] = 0x6775, [0x5157] = 0x679a, [0x5158] = 0x6793,
  [0x5159] = 0x677c, [0x515a] = 0x676a, [0x515b] = 0x6772, [0x515c] = 0x6b23,
  [0x515d] = 0x6b66, [0x515e] = 0x6b67, [0x515f] = 0x6b7f, [0x5160] = 0x6c13,
  [0x5161] = 0x6c1b, [0x5162] = 0x6ce3, [0x5163] = 0x6ce8, [0x5164] = 0x6cf3,
  [0x5165] = 0x6cb1, [0x5166] = 0x6ccc, [0x5167] = 0x6ce5, [0x5168] = 0x6cb3,
  [0x5169] = 0x6cbd, [0x516a] = 0x6cbe, [0x516b] = 0x6cbc, [0x516c] = 0x6ce2,
  [0x516d] = 0x6cab, [0x516e] = 0x6cd5, [0x516f] = 0x6cd3, [0x5170] = 0x6cb8,
  [0x5171] = 0x6cc4, [0x5172] = 0x6cb9, [0x5173] = 0x6cc1, [0x5174] = 0x6cae,
  [0x5175] = 0x6cd7, [0x5176] = 0x6cc5, [0x5177] = 0x6cf1, [0x5178] = 0x6cbf,
  [0x5179] = 0x6cbb, [0x517a] = 0x6ce1, [0x517b] = 0x6cdb, [0x517c] = 0x6cca,
  [0x517d] = 0x6cac, [0x517e] = 0x6cef, [0x517f] = 0x6cdc, [0x5181] = 0x6cd6,
  [0x5182] = 0x6ce0, [0x5183] = 0x7095, [0x5184] = 0x708e, [0x5185] = 0x7092,
  [0x5186] = 0x708a, [0x5187] = 0x7099, [0x5188] = 0x722c, [0x5189] = 0x722d,
  [0x518a] = 0x7238, [0x518b] = 0x7248, [0x518c] = 0x7267, [0x518d] = 0x7269,
  [0x518e] = 0x72c0, [0x518f] = 0x72ce, [0x5190] = 0x72d9, [0x5191] = 0x72d7,
  [0x5192] = 0x72d0, [0x5193] = 0x73a9, [0x5194] = 0x73a8, [0x5195] = 0x739f,
  [0x5196] = 0x73ab, [0x5197] = 0x73a5, [0x5198] = 0x753d, [0x5199] = 0x759d,
  [0x519a] = 0x7599, [0x519b] = 0x759a, [0x519c] = 0x7684, [0x519d] = 0x76c2,
  [0x519e] = 0x76f2, [0x519f] = 0x76f4, [0x51a0] = 0x77e5, [0x51a1] = 0x77fd,
  [0x51a2] = 0x793e, [0x51a3] = 0x7940, [0x51a4] = 0x7941, [0x51a5] = 0x79c9,
  [0x51a6] = 0x79c8, [0x51a7] = 0x7a7a, [0x51a8] = 0x7a79, [0x51a9] = 0x7afa,
  [0x51aa] = 0x7cfe, [0x51ab] = 0x7f54, [0x51ac] = 0x7f8c, [0x51ad] = 0x7f8b,
  [0x51ae] = 0x8005, [0x51af] = 0x80ba, [0x51b0] = 0x80a5, [0x51b1] = 0x80a2,
  [0x51b2] = 0x80b1, [0x51b3] = 0x80a1, [0x51b4] = 0x80ab, [0x51b5] = 0x80a9,
  [0x51b6] = 0x80b4, [0x51b7] = 0x80aa, [0x51b8] = 0x80af, [0x51b9] = 0x81e5,
  [0x51ba] = 0x81fe, [0x51bb] = 0x820d, [0x51bc] = 0x82b3, [0x51bd] = 0x829d,
  [0x51be] = 0x8299, [0x51bf] = 0x82ad, [0x51c0] = 0x82bd, [0x51c1] = 0x829f,
  [0x51c2] = 0x82b9, [0x51c3] = 0x82b1, [0x51c4] = 0x82ac, [0x51c5] = 0x82a5,
  [0x51c6] = 0x82af, [0x51c7] = 0x82b8, [0x51c8] = 0x82a3, [0x51c9] = 0x82b0,
  [0x51ca] = 0x82be, [0x51cb] = 0x82b7, [0x51cc] = 0x864e, [0x51cd] = 0x8671,
  [0x51ce] = 0x521d, [0x51cf] = 0x8868, [0x51d0] = 0x8ecb, [0x51d1] = 0x8fce,
  [0x51d2] = 0x8fd4, [0x51d3] = 0x8fd1, [0x51d4] = 0x90b5, [0x51d5] = 0x90b8,
  [0x51d6] = 0x90b1, [0x51d7] = 0x90b6, [0x51d8] = 0x91c7, [0x51d9] = 0x91d1,
  [0x51da] = 0x9577, [0x51db] = 0x9580, [0x51dc] = 0x961c, [0x51dd] = 0x9640,
  [0x51de] = 0x963f, [0x51df] = 0x963b, [0x51e0] = 0x9644, [0x51e1] = 0x9642,
  [0x51e2] = 0x96b9, [0x51e3] = 0x96e8, [0x51e4] = 0x9752, [0x51e5] = 0x975e,
  [0x51e6] = 0x4e9f, [0x51e7] = 0x4ead, [0x51e8] = 0x4eae, [0x51e9] = 0x4fe1,
  [0x51ea] = 0x4fb5, [0x51eb] = 0x4faf, [0x51ec] = 0x4fbf, [0x51ed] = 0x4fe0,
  [0x51ee] = 0x4fd1, [0x51ef] = 0x4fcf, [0x51f0] = 0x4fdd, [0x51f1] = 0x4fc3,
  [0x51f2] = 0x4fb6, [0x51f3] = 0x4fd8, [0x51f4] = 0x4fdf, [0x51f5] = 0x4fca,
  [0x51f6] = 0x4fd7, [0x51f7] = 0x4fae, [0x51f8] = 0x4fd0, [0x51f9] = 0x4fc4,
  [0x51fa] = 0x4fc2, [0x51fb] = 0x4fda, [0x51fc] = 0x4fce, [0x51fd] = 0x4fde,
  [0x5241] = 0x4fb7, [0x5242] = 0x5157, [0x5243] = 0x5192, [0x5244] = 0x5191,
  [0x5245] = 0x51a0, [0x5246] = 0x524e, [0x5247] = 0x5243, [0x5248] = 0x524a,
  [0x5249] = 0x524d, [0x524a] = 0x524c, [0x524b] = 0x524b, [0x524c] = 0x5247,
  [0x524d] = 0x52c7, [0x524e] = 0x52c9, [0x524f] = 0x52c3, [0x5250] = 0x52c1,
  [0x5251] = 0x530d, [0x5252] = 0x5357, [0x5253] = 0x537b, [0x5254] = 0x539a,
  [0x5255] = 0x53db, [0x5256] = 0x54ac, [0x5257] = 0x54c0, [0x5258] = 0x54a8,
  [0x5259] = 0x54ce, [0x525a] = 0x54c9, [0x525b] = 0x54b8, [0x525c] = 0x54a6,
  [0x525d] = 0x54b3, [0x525e] = 0x54c7, [0x525f] = 0x54c2, [0x5260] = 0x54bd,
  [0x5261] = 0x54aa, [0x5262] = 0x54c1, [0x5263] = 0x54c4, [0x5264] = 0x54c8,
  [0x5265] = 0x54af, [0x5266] = 0x54ab, [0x5267] = 0x54b1, [0x5268] = 0x54bb,
  [0x5269] = 0x54a9, [0x526a] = 0x54a7, [0x526b] = 0x54bf, [0x526c] = 0x56ff,
  [0x526d] = 0x5782, [0x526e] = 0x578b, [0x526f] = 0x57a0, [0x5270] = 0x57a3,
  [0x5271] = 0x57a2, [0x5272] = 0x57ce, [0x5273] = 0x57ae, [0x5274] = 0x5793,
  [0x5275] = 0x5955, [0x5276] = 0x5951, [0x5277] = 0x594f, [0x5278] = 0x594e,
  [0x5279] = 0x5950, [0x527a] = 0x59dc, [0x527b] = 0x59d8, [0x527c] = 0x59ff,
  [0x527d] = 0x59e3, [0x527e] = 0x59e8, [0x527f] = 0x5a03, [0x5281] = 0x59e5,
  [0x5282] = 0x59ea, [0x5283] = 0x59da, [0x5284] = 0x59e6, [0x5285] = 0x5a01,
  [0x5286] = 0x59fb, [0x5287] = 0x5b69, [0x5288] = 0x5ba3, [0x5289] = 0x5ba6,
  [0x528a] = 0x5ba4, [0x528b] = 0x5ba2, [0x528c] = 0x5ba5, [0x528d] = 0x5c01,
  [0x528e] = 0x5c4e, [0x528f] = 0x5c4f, [0x5290] = 0x5c4d, [0x5291] = 0x5c4b,
  [0x5292] = 0x5cd9, [0x5293] = 0x5cd2, [0x5294] = 0x5df7, [0x5295] = 0x5e1d,
  [0x5296] = 0x5e25, [0x5297] = 0x5e1f, [0x5298] = 0x5e7d, [0x5299] = 0x5ea0,
  [0x529a] = 0x5ea6, [0x529b] = 0x5efa, [0x529c] = 0x5f08, [0x529d] = 0x5f2d,
  [0x529e] = 0x5f65, [0x529f] = 0x5f88, [0x52a0] = 0x5f85, [0x52a1] = 0x5f8a,
  [0x52a2] = 0x5f8b, [0x52a3] = 0x5f87, [0x52a4] = 0x5f8c, [0x52a5] = 0x5f89,
  [0x52a6] = 0x6012, [0x52a7] = 0x601d, [0x52a8] = 0x6020, [0x52a9] = 0x6025,
  [0x52aa] = 0x600e, [0x52ab] = 0x6028, [0x52ac] = 0x604d, [0x52ad] = 0x6070,
  [0x52ae] = 0x6068, [0x52af] = 0x6062, [0x52b0] = 0x6046, [0x52b1] = 0x6043,
  [0x52b2] = 0x606c, [0x52b3] = 0x606b, [0x52b4] = 0x606a, [0x52b5] = 0x6064,
  [0x52b6] = 0x6241, [0x52b7] = 0x62dc, [0x52b8] = 0x6316, [0x52b9] = 0x6309,
  [0x52ba] = 0x62fc, [0x52bb] = 0x62ed, [0x52bc] = 0x6301, [0x52bd] = 0x62ee,
  [0x52be] = 0x62fd, [0x52bf] = 0x6307, [0x52c0] = 0x62f1, [0x52c1] = 0x62f7,
  [0x52c2] = 0x62ef, [0x52c3] = 0x62ec, [0x52c4] = 0x62fe, [0x52c5] = 0x62f4,
  [0x52c6] = 0x6311, [0x52c7] = 0x6302, [0x52c8] = 0x653f, [0x52c9] = 0x6545,
  [0x52ca] = 0x65ab, [0x52cb] = 0x65bd, [0x52cc] = 0x65e2, [0x52cd] = 0x6625,
  [0x52ce] = 0x662d, [0x52cf] = 0x6620, [0x52d0] = 0x6627, [0x52d1] = 0x662f,
  [0x52d2] = 0x661f, [0x52d3] = 0x6628, [0x52d4] = 0x6631, [0x52d5] = 0x6624,
  [0x52d6] = 0x66f7, [0x52d7] = 0x67ff, [0x52d8] = 0x67d3, [0x52d9] = 0x67f1,
  [0x52da] = 0x67d4, [0x52db] = 0x67d0, [0x52dc] = 0x67ec, [0x52dd] = 0x67b6,
  [0x52de] = 0x67af, [0x52df] = 0x67f5, [0x52e0] = 0x67e9, [0x52e1] = 0x67ef,
  [0x52e2] = 0x67c4, [0x52e3] = 0x67d1, [0x52e4] = 0x67b4, [0x52e5] = 0x67da,
  [0x52e6] = 0x67e5, [0x52e7] = 0x67b8, [0x52e8] = 0x67cf, [0x52e9] = 0x67de,
  [0x52ea] = 0x67f3, [0x52eb] = 0x67b0, [0x52ec] = 0x67d9, [0x52ed] = 0x67e2,
  [0x52ee] = 0x67dd, [0x52ef] = 0x67d2, [0x52f0] = 0x6b6a, [0x52f1] = 0x6b83,
  [0x52f2] = 0x6b86, [0x52f3] = 0x6bb5, [0x52f4] = 0x6bd2, [0x52f5] = 0x6bd7,
  [0x52f6] = 0x6c1f, [0x52f7] = 0x6cc9, [0x52f8] = 0x6d0b, [0x52f9] = 0x6d32,
  [0x52fa] = 0x6d2a, [0x52fb] = 0x6d41, [0x52fc] = 0x6d25, [0x52fd] = 0x6d0c,
  [0x5341] = 0x6d31, [0x5342] = 0x6d1e, [0x5343] = 0x6d17, [0x5344] = 0x6d3b,
  [0x5345] = 0x6d3d, [0x5346] = 0x6d3e, [0x5347] = 0x6d36, [0x5348] = 0x6d1b,
  [0x5349] = 0x6cf5, [0x534a] = 0x6d39, [0x534b] = 0x6d27, [0x534c] = 0x6d38,
  [0x534d] = 0x6d29, [0x534e] = 0x6d2e, [0x534f] = 0x6d35, [0x5350] = 0x6d0e,
  [0x5351] = 0x6d2b, [0x5352] = 0x70ab, [0x5353] = 0x70ba, [0x5354] = 0x70b3,
  [0x5355] = 0x70ac, [0x5356] = 0x70af, [0x5357] = 0x70ad, [0x5358] = 0x70b8,
  [0x5359] = 0x70ae, [0x535a] = 0x70a4, [0x535b] = 0x7230, [0x535c] = 0x7272,
  [0x535d] = 0x726f, [0x535e] = 0x7274, [0x535f] = 0x72e9, [0x5360] = 0x72e0,
  [0x5361] = 0x72e1, [0x5362] = 0x73b7, [0x5363] = 0x73ca, [0x5364] = 0x73bb,
  [0x5365] = 0x73b2, [0x5366] = 0x73cd, [0x5367] = 0x73c0, [0x5368] = 0x73b3,
  [0x5369] = 0x751a, [0x536a] = 0x752d, [0x536b] = 0x754f, [0x536c] = 0x754c,
  [0x536d] = 0x754e, [0x536e] = 0x754b, [0x536f] = 0x75ab, [0x5370] = 0x75a4,
  [0x5371] = 0x75a5, [0x5372] = 0x75a2, [0x5373] = 0x75a3, [0x5374] = 0x7678,
  [0x5375] = 0x7686, [0x5376] = 0x7687, [0x5377] = 0x7688, [0x5378] = 0x76c8,
  [0x5379] = 0x76c6, [0x537a] = 0x76c3, [0x537b] = 0x76c5, [0x537c] = 0x7701,
  [0x537d] = 0x76f9, [0x537e] = 0x76f8, [0x537f] = 0x7709, [0x5381] = 0x770b,
  [0x5382] = 0x76fe, [0x5383] = 0x76fc, [0x5384] = 0x7707, [0x5385] = 0x77dc,
  [0x5386] = 0x7802, [0x5387] = 0x7814, [0x5388] = 0x780c, [0x5389] = 0x780d,
  [0x538a] = 0x7946, [0x538b] = 0x7949, [0x538c] = 0x7948, [0x538d] = 0x7947,
  [0x538e] = 0x79b9, [0x538f] = 0x79ba, [0x5390] = 0x79d1, [0x5391] = 0x79d2,
  [0x5392] = 0x79cb, [0x5393] = 0x7a7f, [0x5394] = 0x7a81, [0x5395] = 0x7aff,
  [0x5396] = 0x7afd, [0x5397] = 0x7c7d, [0x5398] = 0x7d02, [0x5399] = 0x7d05,
  [0x539a] = 0x7d00, [0x539b] = 0x7d09, [0x539c] = 0x7d07, [0x539d] = 0x7d04,
  [0x539e] = 0x7d06, [0x539f] = 0x7f38, [0x53a0] = 0x7f8e, [0x53a1] = 0x7fbf,
  [0x53a2] = 0x8004, [0x53a3] = 0x8010, [0x53a4] = 0x800d, [0x53a5] = 0x8011,
  [0x53a6] = 0x8036, [0x53a7] = 0x80d6, [0x53a8] = 0x80e5, [0x53a9] = 0x80da,
  [0x53aa] = 0x80c3, [0x53ab] = 0x80c4, [0x53ac] = 0x80cc, [0x53ad] = 0x80e1,
  [0x53ae] = 0x80db, [0x53af] = 0x80ce, [0x53b0] = 0x80de, [0x53b1] = 0x80e4,
  [0x53b2] = 0x80dd, [0x53b3] = 0x81f4, [0x53b4] = 0x8222, [0x53b5] = 0x82e7,
  [0x53b6] = 0x8303, [0x53b7] = 0x8305, [0x53b8] = 0x82e3, [0x53b9] = 0x82db,
  [0x53ba] = 0x82e6, [0x53bb] = 0x8304, [0x53bc] = 0x82e5, [0x53bd] = 0x8302,
  [0x53be] = 0x8309, [0x53bf] = 0x82d2, [0x53c0] = 0x82d7, [0x53c1] = 0x82f1,
  [0x53c2] = 0x8301, [0x53c3] = 0x82dc, [0x53c4] = 0x82d4, [0x53c5] = 0x82d1,
  [0x53c6] = 0x82de, [0x53c7] = 0x82d3, [0x53c8] = 0x82df, [0x53c9] = 0x82ef,
  [0x53ca] = 0x8306, [0x53cb] = 0x8650, [0x53cc] = 0x8679, [0x53cd] = 0x867b,
  [0x53ce] = 0x867a, [0x53cf] = 0x884d, [0x53d0] = 0x886b, [0x53d1] = 0x8981,
  [0x53d2] = 0x89d4, [0x53d3] = 0x8a08, [0x53d4] = 0x8a02, [0x53d5] = 0x8a03,
  [0x53d6] = 0x8c9e, [0x53d7] = 0x8ca0, [0x53d8] = 0x8d74, [0x53d9] = 0x8d73,
  [0x53da] = 0x8db4, [0x53db] = 0x8ecd, [0x53dc] = 0x8ecc, [0x53dd] = 0x8ff0,
  [0x53de] = 0x8fe6, [0x53df] = 0x8fe2, [0x53e0] = 0x8fea, [0x53e1] = 0x8fe5,
  [0x53e2] = 0x8fed, [0x53e3] = 0x8feb, [0x53e4] = 0x8fe4, [0x53e5] = 0x8fe8,
  [0x53e6] = 0x90ca, [0x53e7] = 0x90ce, [0x53e8] = 0x90c1, [0x53e9] = 0x90c3,
  [0x53ea] = 0x914b, [0x53eb] = 0x914a, [0x53ec] = 0x91cd, [0x53ed] = 0x9582,
  [0x53ee] = 0x9650, [0x53ef] = 0x964b, [0x53f0] = 0x964c, [0x53f1] = 0x964d,
  [0x53f2] = 0x9762, [0x53f3] = 0x9769, [0x53f4] = 0x97cb, [0x53f5] = 0x97ed,
  [0x53f6] = 0x97f3, [0x53f7] = 0x9801, [0x53f8] = 0x98a8, [0x53f9] = 0x98db,
  [0x53fa] = 0x98df, [0x53fb] = 0x9996, [0x53fc] = 0x9999, [0x53fd] = 0x4e58,
  [0x5441] = 0x4eb3, [0x5442] = 0x500c, [0x5443] = 0x500d, [0x5444] = 0x5023,
  [0x5445] = 0x4fef, [0x5446] = 0x5026, [0x5447] = 0x5025, [0x5448] = 0x4ff8,
  [0x5449] = 0x5029, [0x544a] = 0x5016, [0x544b] = 0x5006, [0x544c] = 0x503c,
  [0x544d] = 0x501f, [0x544e] = 0x501a, [0x544f] = 0x5012, [0x5450] = 0x5011,
  [0x5451] = 0x4ffa, [0x5452] = 0x5000, [0x5453] = 0x5014, [0x5454] = 0x5028,
  [0x5455] = 0x4ff1, [0x5456] = 0x5021, [0x5457] = 0x500b, [0x5458] = 0x5019,
  [0x5459] = 0x5018, [0x545a] = 0x4ff3, [0x545b] = 0x4fee, [0x545c] = 0x502d,
  [0x545d] = 0x502a, [0x545e] = 0x4ffe, [0x545f] = 0x502b, [0x5460] = 0x5009,
  [0x5461] = 0x517c, [0x5462] = 0x51a4, [0x5463] = 0x51a5, [0x5464] = 0x51a2,
  [0x5465] = 0x51cd, [0x5466] = 0x51cc, [0x5467] = 0x51c6, [0x5468] = 0x51cb,
  [0x5469] = 0x5256, [0x546a] = 0x525c, [0x546b] = 0x5254, [0x546c] = 0x525b,
  [0x546d] = 0x525d, [0x546e] = 0x532a, [0x546f] = 0x537f, [0x5470] = 0x539f,
  [0x5471] = 0x539d, [0x5472] = 0x53df, [0x5473] = 0x54e8, [0x5474] = 0x5510,
  [0x5475] = 0x5501, [0x5476] = 0x5537, [0x5477] = 0x54fc, [0x5478] = 0x54e5,
  [0x5479] = 0x54f2, [0x547a] = 0x5506, [0x547b] = 0x54fa, [0x547c] = 0x5514,
  [0x547d] = 0x54e9, [0x547e] = 0x54ed, [0x547f] = 0x54e1, [0x5481] = 0x5509,
  [0x5482] = 0x54ee, [0x5483] = 0x54ea, [0x5484] = 0x54e6, [0x5485] = 0x5527,
  [0x5486] = 0x5507, [0x5487] = 0x54fd, [0x5488] = 0x550f, [0x5489] = 0x5703,
  [0x548a] = 0x5704, [0x548b] = 0x57c2, [0x548c] = 0x57d4, [0x548d] = 0x57cb,
  [0x548e] = 0x57c3, [0x548f] = 0x5809, [0x5490] = 0x590f, [0x5491] = 0x5957,
  [0x5492] = 0x5958, [0x5493] = 0x595a, [0x5494] = 0x5a11, [0x5495] = 0x5a18,
  [0x5496] = 0x5a1c, [0x5497] = 0x5a1f, [0x5498] = 0x5a1b, [0x5499] = 0x5a13,
  [0x549a] = 0x59ec, [0x549b] = 0x5a20, [0x549c] = 0x5a23, [0x549d] = 0x5a29,
  [0x549e] = 0x5a25, [0x549f] = 0x5a0c, [0x54a0] = 0x5a09, [0x54a1] = 0x5b6b,
  [0x54a2] = 0x5c58, [0x54a3] = 0x5bb0, [0x54a4] = 0x5bb3, [0x54a5] = 0x5bb6,
  [0x54a6] = 0x5bb4, [0x54a7] = 0x5bae, [0x54a8] = 0x5bb5, [0x54a9] = 0x5bb9,
  [0x54aa] = 0x5bb8, [0x54ab] = 0x5c04, [0x54ac] = 0x5c51, [0x54ad] = 0x5c55,
  [0x54ae] = 0x5c50, [0x54af] = 0x5ced, [0x54b0] = 0x5cfd, [0x54b1] = 0x5cfb,
  [0x54b2] = 0x5cea, [0x54b3] = 0x5ce8, [0x54b4] = 0x5cf0, [0x54b5] = 0x5cf6,
  [0x54b6] = 0x5d01, [0x54b7] = 0x5cf4, [0x54b8] = 0x5dee, [0x54b9] = 0x5e2d,
  [0x54ba] = 0x5e2b, [0x54bb] = 0x5eab, [0x54bc] = 0x5ead, [0x54bd] = 0x5ea7,
  [0x54be] = 0x5f31, [0x54bf] = 0x5f92, [0x54c0] = 0x5f91, [0x54c1] = 0x5f90,
  [0x54c2] = 0x6059, [0x54c3] = 0x6063, [0x54c4] = 0x6065, [0x54c5] = 0x6050,
  [0x54c6] = 0x6055, [0x54c7] = 0x606d, [0x54c8] = 0x6069, [0x54c9] = 0x606f,
  [0x54ca] = 0x6084, [0x54cb] = 0x609f, [0x54cc] = 0x609a, [0x54cd] = 0x608d,
  [0x54ce] = 0x6094, [0x54cf] = 0x608c, [0x54d0] = 0x6085, [0x54d1] = 0x6096,
  [0x54d2] = 0x6247, [0x54d3] = 0x62f3, [0x54d4] = 0x6308, [0x54d5] = 0x62ff,
  [0x54d6] = 0x634e, [0x54d7] = 0x633e, [0x54d8] = 0x632f, [0x54d9] = 0x6355,
  [0x54da] = 0x6342, [0x54db] = 0x6346, [0x54dc] = 0x634f, [0x54dd] = 0x6349,
  [0x54de] = 0x633a, [0x54df] = 0x6350, [0x54e0] = 0x633d, [0x54e1] = 0x632a,
  [0x54e2] = 0x632b, [0x54e3] = 0x6328, [0x54e4] = 0x634d, [0x54e5] = 0x634c,
  [0x54e6] = 0x6548, [0x54e7] = 0x6549, [0x54e8] = 0x6599, [0x54e9] = 0x65c1,
  [0x54ea] = 0x65c5, [0x54eb] = 0x6642, [0x54ec] = 0x6649, [0x54ed] = 0x664f,
  [0x54ee] = 0x6643, [0x54ef] = 0x6652, [0x54f0] = 0x664c, [0x54f1] = 0x6645,
  [0x54f2] = 0x6641, [0x54f3] = 0x66f8, [0x54f4] = 0x6714, [0x54f5] = 0x6715,
  [0x54f6] = 0x6717, [0x54f7] = 0x6821, [0x54f8] = 0x6838, [0x54f9] = 0x6848,
  [0x54fa] = 0x6846, [0x54fb] = 0x6853, [0x54fc] = 0x6839, [0x54fd] = 0x6842,
  [0x5541] = 0x6854, [0x5542] = 0x6829, [0x5543] = 0x68b3, [0x5544] = 0x6817,
  [0x5545] = 0x684c, [0x5546] = 0x6851, [0x5547] = 0x683d, [0x5548] = 0x67f4,
  [0x5549] = 0x6850, [0x554a] = 0x6840, [0x554b] = 0x683c, [0x554c] = 0x6843,
  [0x554d] = 0x682a, [0x554e] = 0x6845, [0x554f] = 0x6813, [0x5550] = 0x6818,
  [0x5551] = 0x6841, [0x5552] = 0x6b8a, [0x5553] = 0x6b89, [0x5554] = 0x6bb7,
  [0x5555] = 0x6c23, [0x5556] = 0x6c27, [0x5557] = 0x6c28, [0x5558] = 0x6c26,
  [0x5559] = 0x6c24, [0x555a] = 0x6cf0, [0x555b] = 0x6d6a, [0x555c] = 0x6d95,
  [0x555d] = 0x6d88, [0x555e] = 0x6d87, [0x555f] = 0x6d66, [0x5560] = 0x6d78,
  [0x5561] = 0x6d77, [0x5562] = 0x6d59, [0x5563] = 0x6d93, [0x5564] = 0x6d6c,
  [0x5565] = 0x6d89, [0x5566] = 0x6d6e, [0x5567] = 0x6d5a, [0x5568] = 0x6d74,
  [0x5569] = 0x6d69, [0x556a] = 0x6d8c, [0x556b] = 0x6d8a, [0x556c] = 0x6d79,
  [0x556d] = 0x6d85, [0x556e] = 0x6d65, [0x556f] = 0x6d94, [0x5570] = 0x70ca,
  [0x5571] = 0x70d8, [0x5572] = 0x70e4, [0x5573] = 0x70d9, [0x5574] = 0x70c8,
  [0x5575] = 0x70cf, [0x5576] = 0x7239, [0x5577] = 0x7279, [0x5578] = 0x72fc,
  [0x5579] = 0x72f9, [0x557a] = 0x72fd, [0x557b] = 0x72f8, [0x557c] = 0x72f7,
  [0x557d] = 0x7386, [0x557e] = 0x73ed, [0x557f] = 0x7409, [0x5581] = 0x73ee,
  [0x5582] = 0x73e0, [0x5583] = 0x73ea, [0x5584] = 0x73de, [0x5585] = 0x7554,
  [0x5586] = 0x755d, [0x5587] = 0x755c, [0x5588] = 0x755a, [0x5589] = 0x7559,
  [0x558a] = 0x75be, [0x558b] = 0x75c5, [0x558c] = 0x75c7, [0x558d] = 0x75b2,
  [0x558e] = 0x75b3, [0x558f] = 0x75bd, [0x5590] = 0x75bc, [0x5591] = 0x75b9,
  [0x5592] = 0x75c2, [0x5593] = 0x75b8, [0x5594] = 0x768b, [0x5595] = 0x76b0,
  [0x5596] = 0x76ca, [0x5597] = 0x76cd, [0x5598] = 0x76ce, [0x5599] = 0x7729,
  [0x559a] = 0x771f, [0x559b] = 0x7720, [0x559c] = 0x7728, [0x559d] = 0x77e9,
  [0x559e] = 0x7830, [0x559f] = 0x7827, [0x55a0] = 0x7838, [0x55a1] = 0x781d,
  [0x55a2] = 0x7834, [0x55a3] = 0x7837, [0x55a4] = 0x7825, [0x55a5] = 0x782d,
  [0x55a6] = 0x7820, [0x55a7] = 0x781f, [0x55a8] = 0x7832, [0x55a9] = 0x7955,
  [0x55aa] = 0x7950, [0x55ab] = 0x7960, [0x55ac] = 0x795f, [0x55ad] = 0x7956,
  [0x55ae] = 0x795e, [0x55af] = 0x795d, [0x55b0] = 0x7957, [0x55b1] = 0x795a,
  [0x55b2] = 0x79e4, [0x55b3] = 0x79e3, [0x55b4] = 0x79e7, [0x55b5] = 0x79df,
  [0x55b6] = 0x79e6, [0x55b7] = 0x79e9, [0x55b8] = 0x79d8, [0x55b9] = 0x7a84,
  [0x55ba] = 0x7a88, [0x55bb] = 0x7ad9, [0x55bc] = 0x7b06, [0x55bd] = 0x7b11,
  [0x55be] = 0x7c89, [0x55bf] = 0x7d21, [0x55c0] = 0x7d17, [0x55c1] = 0x7d0b,
  [0x55c2] = 0x7d0a, [0x55c3] = 0x7d20, [0x55c4] = 0x7d22, [0x55c5] = 0x7d14,
  [0x55c6] = 0x7d10, [0x55c7] = 0x7d15, [0x55c8] = 0x7d1a, [0x55c9] = 0x7d1c,
  [0x55ca] = 0x7d0d, [0x55cb] = 0x7d19, [0x55cc] = 0x7d1b, [0x55cd] = 0x7f3a,
  [0x55ce] = 0x7f5f, [0x55cf] = 0x7f94, [0x55d0] = 0x7fc5, [0x55d1] = 0x7fc1,
  [0x55d2] = 0x8006, [0x55d3] = 0x8018, [0x55d4] = 0x8015, [0x55d5] = 0x8019,
  [0x55d6] = 0x8017, [0x55d7] = 0x803d, [0x55d8] = 0x803f, [0x55d9] = 0x80f1,
  [0x55da] = 0x8102, [0x55db] = 0x80f0, [0x55dc] = 0x8105, [0x55dd] = 0x80ed,
  [0x55de] = 0x80f4, [0x55df] = 0x8106, [0x55e0] = 0x80f8, [0x55e1] = 0x80f3,
  [0x55e2] = 0x8108, [0x55e3] = 0x80fd, [0x55e4] = 0x810a, [0x55e5] = 0x80fc,
  [0x55e6] = 0x80ef, [0x55e7] = 0x81ed, [0x55e8] = 0x81ec, [0x55e9] = 0x8200,
  [0x55ea] = 0x8210, [0x55eb] = 0x822a, [0x55ec] = 0x822b, [0x55ed] = 0x8228,
  [0x55ee] = 0x822c, [0x55ef] = 0x82bb, [0x55f0] = 0x832b, [0x55f1] = 0x8352,
  [0x55f2] = 0x8354, [0x55f3] = 0x834a, [0x55f4] = 0x8338, [0x55f5] = 0x8350,
  [0x55f6] = 0x8349, [0x55f7] = 0x8335, [0x55f8] = 0x8334, [0x55f9] = 0x834f,
  [0x55fa] = 0x8332, [0x55fb] = 0x8339, [0x55fc] = 0x8336, [0x55fd] = 0x8317,
  [0x5641] = 0x8340, [0x5642] = 0x8331, [0x5643] = 0x8328, [0x5644] = 0x8343,
  [0x5645] = 0x8654, [0x5646] = 0x868a, [0x5647] = 0x86aa, [0x5648] = 0x8693,
  [0x5649] = 0x86a4, [0x564a] = 0x86a9, [0x564b] = 0x868c, [0x564c] = 0x86a3,
  [0x564d] = 0x869c, [0x564e] = 0x8870, [0x564f] = 0x8877, [0x5650] = 0x8881,
  [0x5651] = 0x8882, [0x5652] = 0x887d, [0x5653] = 0x8879, [0x5654] = 0x8a18,
  [0x5655] = 0x8a10, [0x5656] = 0x8a0e, [0x5657] = 0x8a0c, [0x5658] = 0x8a15,
  [0x5659] = 0x8a0a, [0x565a] = 0x8a17, [0x565b] = 0x8a13, [0x565c] = 0x8a16,
  [0x565d] = 0x8a0f, [0x565e] = 0x8a11, [0x565f] = 0x8c48, [0x5660] = 0x8c7a,
  [0x5661] = 0x8c79, [0x5662] = 0x8ca1, [0x5663] = 0x8ca2, [0x5664] = 0x8d77,
  [0x5665] = 0x8eac, [0x5666] = 0x8ed2, [0x5667] = 0x8ed4, [0x5668] = 0x8ecf,
  [0x5669] = 0x8fb1, [0x566a] = 0x9001, [0x566b] = 0x9006, [0x566c] = 0x8ff7,
  [0x566d] = 0x9000, [0x566e] = 0x8ffa, [0x566f] = 0x8ff4, [0x5670] = 0x9003,
  [0x5671] = 0x8ffd, [0x5672] = 0x9005, [0x5673] = 0x8ff8, [0x5674] = 0x9095,
  [0x5675] = 0x90e1, [0x5676] = 0x90dd, [0x5677] = 0x90e2, [0x5678] = 0x9152,
  [0x5679] = 0x914d, [0x567a] = 0x914c, [0x567b] = 0x91d8, [0x567c] = 0x91dd,
  [0x567d] = 0x91d7, [0x567e] = 0x91dc, [0x567f] = 0x91d9, [0x5681] = 0x9583,
  [0x5682] = 0x9662, [0x5683] = 0x9663, [0x5684] = 0x9661, [0x5685] = 0x965b,
  [0x5686] = 0x965d, [0x5687] = 0x9664, [0x5688] = 0x9658, [0x5689] = 0x965e,
  [0x568a] = 0x96bb, [0x568b] = 0x98e2, [0x568c] = 0x99ac, [0x568d] = 0x9aa8,
  [0x568e] = 0x9ad8, [0x568f] = 0x9b25, [0x5690] = 0x9b32, [0x5691] = 0x9b3c,
  [0x5692] = 0x4e7e, [0x5693] = 0x507a, [0x5694] = 0x507d, [0x5695] = 0x505c,
  [0x5696] = 0x5047, [0x5697] = 0x5043, [0x5698] = 0x504c, [0x5699] = 0x505a,
  [0x569a] = 0x5049, [0x569b] = 0x5065, [0x569c] = 0x5076, [0x569d] = 0x504e,
  [0x569e] = 0x5055, [0x569f] = 0x5075, [0x56a0] = 0x5074, [0x56a1] = 0x5077,
  [0x56a2] = 0x504f, [0x56a3] = 0x500f, [0x56a4] = 0x506f, [0x56a5] = 0x506d,
  [0x56a6] = 0x515c, [0x56a7] = 0x5195, [0x56a8] = 0x51f0, [0x56a9] = 0x526a,
  [0x56aa] = 0x526f, [0x56ab] = 0x52d2, [0x56ac] = 0x52d9, [0x56ad] = 0x52d8,
  [0x56ae] = 0x52d5, [0x56af] = 0x5310, [0x56b0] = 0x530f, [0x56b1] = 0x5319,
  [0x56b2] = 0x533f, [0x56b3] = 0x5340, [0x56b4] = 0x533e, [0x56b5] = 0x53c3,
  [0x56b6] = 0x66fc, [0x56b7] = 0x5546, [0x56b8] = 0x556a, [0x56b9] = 0x5566,
  [0x56ba] = 0x5544, [0x56bb] = 0x555e, [0x56bc] = 0x5561, [0x56bd] = 0x5543,
  [0x56be] = 0x554a, [0x56bf] = 0x5531, [0x56c0] = 0x5556, [0x56c1] = 0x554f,
  [0x56c2] = 0x5555, [0x56c3] = 0x552f, [0x56c4] = 0x5564, [0x56c5] = 0x5538,
  [0x56c6] = 0x552e, [0x56c7] = 0x555c, [0x56c8] = 0x552c, [0x56c9] = 0x5563,
  [0x56ca] = 0x5533, [0x56cb] = 0x5541, [0x56cc] = 0x5557, [0x56cd] = 0x5708,
  [0x56ce] = 0x570b, [0x56cf] = 0x5709, [0x56d0] = 0x57df, [0x56d1] = 0x5805,
  [0x56d2] = 0x580a, [0x56d3] = 0x5806, [0x56d4] = 0x57e0, [0x56d5] = 0x57e4,
  [0x56d6] = 0x57fa, [0x56d7] = 0x5802, [0x56d8] = 0x5835, [0x56d9] = 0x57f7,
  [0x56da] = 0x57f9, [0x56db] = 0x5920, [0x56dc] = 0x5962, [0x56dd] = 0x5a36,
  [0x56de] = 0x5a41, [0x56df] = 0x5a49, [0x56e0] = 0x5a66, [0x56e1] = 0x5a6a,
  [0x56e2] = 0x5a40, [0x56e3] = 0x5a3c, [0x56e4] = 0x5a62, [0x56e5] = 0x5a5a,
  [0x56e6] = 0x5a46, [0x56e7] = 0x5a4a, [0x56e8] = 0x5b70, [0x56e9] = 0x5bc7,
  [0x56ea] = 0x5bc5, [0x56eb] = 0x5bc4, [0x56ec] = 0x5bc2, [0x56ed] = 0x5bbf,
  [0x56ee] = 0x5bc6, [0x56ef] = 0x5c09, [0x56f0] = 0x5c08, [0x56f1] = 0x5c07,
  [0x56f2] = 0x5c60, [0x56f3] = 0x5c5c, [0x56f4] = 0x5c5d, [0x56f5] = 0x5d07,
  [0x56f6] = 0x5d06, [0x56f7] = 0x5d0e, [0x56f8] = 0x5d1b, [0x56f9] = 0x5d16,
  [0x56fa] = 0x5d22, [0x56fb] = 0x5d11, [0x56fc] = 0x5d29, [0x56fd] = 0x5d14,
  [0x5741] = 0x5d19, [0x5742] = 0x5d24, [0x5743] = 0x5d27, [0x5744] = 0x5d17,
  [0x5745] = 0x5de2, [0x5746] = 0x5e38, [0x5747] = 0x5e36, [0x5748] = 0x5e33,
  [0x5749] = 0x5e37, [0x574a] = 0x5eb7, [0x574b] = 0x5eb8, [0x574c] = 0x5eb6,
  [0x574d] = 0x5eb5, [0x574e] = 0x5ebe, [0x574f] = 0x5f35, [0x5750] = 0x5f37,
  [0x5751] = 0x5f57, [0x5752] = 0x5f6c, [0x5753] = 0x5f69, [0x5754] = 0x5f6b,
  [0x5755] = 0x5f97, [0x5756] = 0x5f99, [0x5757] = 0x5f9e, [0x5758] = 0x5f98,
  [0x5759] = 0x5fa1, [0x575a] = 0x5fa0, [0x575b] = 0x5f9c, [0x575c] = 0x607f,
  [0x575d] = 0x60a3, [0x575e] = 0x6089, [0x575f] = 0x60a0, [0x5760] = 0x60a8,
  [0x5761] = 0x60cb, [0x5762] = 0x60b4, [0x5763] = 0x60e6, [0x5764] = 0x60bd,
  [0x5765] = 0x60c5, [0x5766] = 0x60bb, [0x5767] = 0x60b5, [0x5768] = 0x60dc,
  [0x5769] = 0x60bc, [0x576a] = 0x60d8, [0x576b] = 0x60d5, [0x576c] = 0x60c6,
  [0x576d] = 0x60df, [0x576e] = 0x60b8, [0x576f] = 0x60da, [0x5770] = 0x60c7,
  [0x5771] = 0x621a, [0x5772] = 0x621b, [0x5773] = 0x6248, [0x5774] = 0x63a0,
  [0x5775] = 0x63a7, [0x5776] = 0x6372, [0x5777] = 0x6396, [0x5778] = 0x63a2,
  [0x5779] = 0x63a5, [0x577a] = 0x6377, [0x577b] = 0x6367, [0x577c] = 0x6398,
  [0x577d] = 0x63aa, [0x577e] = 0x6371, [0x577f] = 0x63a9, [0x5781] = 0x6389,
  [0x5782] = 0x6383, [0x5783] = 0x639b, [0x5784] = 0x636b, [0x5785] = 0x63a8,
  [0x5786] = 0x6384, [0x5787] = 0x6388, [0x5788] = 0x6399, [0x5789] = 0x63a1,
  [0x578a] = 0x63ac, [0x578b] = 0x6392, [0x578c] = 0x638f, [0x578d] = 0x6380,
  [0x578e] = 0x637b, [0x578f] = 0x6369, [0x5790] = 0x6368, [0x5791] = 0x637a,
  [0x5792] = 0x655d, [0x5793] = 0x6556, [0x5794] = 0x6551, [0x5795] = 0x6559,
  [0x5796] = 0x6557, [0x5797] = 0x555f, [0x5798] = 0x654f, [0x5799] = 0x6558,
  [0x579a] = 0x6555, [0x579b] = 0x6554, [0x579c] = 0x659c, [0x579d] = 0x659b,
  [0x579e] = 0x65ac, [0x579f] = 0x65cf, [0x57a0] = 0x65cb, [0x57a1] = 0x65cc,
  [0x57a2] = 0x65ce, [0x57a3] = 0x665d, [0x57a4] = 0x665a, [0x57a5] = 0x6664,
  [0x57a6] = 0x6668, [0x57a7] = 0x6666, [0x57a8] = 0x665e, [0x57a9] = 0x66f9,
  [0x57aa] = 0x52d7, [0x57ab] = 0x671b, [0x57ac] = 0x6881, [0x57ad] = 0x68af,
  [0x57ae] = 0x68a2, [0x57af] = 0x6893, [0x57b0] = 0x68b5, [0x57b1] = 0x687f,
  [0x57b2] = 0x6876, [0x57b3] = 0x68b1, [0x57b4] = 0x68a7, [0x57b5] = 0x6897,
  [0x57b6] = 0x68b0, [0x57b7] = 0x6883, [0x57b8] = 0x68c4, [0x57b9] = 0x68ad,
  [0x57ba] = 0x6886, [0x57bb] = 0x6885, [0x57bc] = 0x6894, [0x57bd] = 0x689d,
  [0x57be] = 0x68a8, [0x57bf] = 0x689f, [0x57c0] = 0x68a1, [0x57c1] = 0x6882,
  [0x57c2] = 0x6b32, [0x57c3] = 0x6bba, [0x57c4] = 0x6beb, [0x57c5] = 0x6bec,
  [0x57c6] = 0x6c2b, [0x57c7] = 0x6d8e, [0x57c8] = 0x6dbc, [0x57c9] = 0x6df3,
  [0x57ca] = 0x6dd9, [0x57cb] = 0x6db2, [0x57cc] = 0x6de1, [0x57cd] = 0x6dcc,
  [0x57ce] = 0x6de4, [0x57cf] = 0x6dfb, [0x57d0] = 0x6dfa, [0x57d1] = 0x6e05,
  [0x57d2] = 0x6dc7, [0x57d3] = 0x6dcb, [0x57d4] = 0x6daf, [0x57d5] = 0x6dd1,
  [0x57d6] = 0x6dae, [0x57d7] = 0x6dde, [0x57d8] = 0x6df9, [0x57d9] = 0x6db8,
  [0x57da] = 0x6df7, [0x57db] = 0x6df5, [0x57dc] = 0x6dc5, [0x57dd] = 0x6dd2,
  [0x57de] = 0x6e1a, [0x57df] = 0x6db5, [0x57e0] = 0x6dda, [0x57e1] = 0x6deb,
  [0x57e2] = 0x6dd8, [0x57e3] = 0x6dea, [0x57e4] = 0x6df1, [0x57e5] = 0x6dee,
  [0x57e6] = 0x6de8, [0x57e7] = 0x6dc6, [0x57e8] = 0x6dc4, [0x57e9] = 0x6daa,
  [0x57ea] = 0x6dec, [0x57eb] = 0x6dbf, [0x57ec] = 0x6de6, [0x57ed] = 0x70f9,
  [0x57ee] = 0x7109, [0x57ef] = 0x710a, [0x57f0] = 0x70fd, [0x57f1] = 0x70ef,
  [0x57f2] = 0x723d, [0x57f3] = 0x727d, [0x57f4] = 0x7281, [0x57f5] = 0x731c,
  [0x57f6] = 0x731b, [0x57f7] = 0x7316, [0x57f8] = 0x7313, [0x57f9] = 0x7319,
  [0x57fa] = 0x7387, [0x57fb] = 0x7405, [0x57fc] = 0x740a, [0x57fd] = 0x7403,
  [0x5841] = 0x7406, [0x5842] = 0x73fe, [0x5843] = 0x740d, [0x5844] = 0x74e0,
  [0x5845] = 0x74f6, [0x5846] = 0x74f7, [0x5847] = 0x751c, [0x5848] = 0x7522,
  [0x5849] = 0x7565, [0x584a] = 0x7566, [0x584b] = 0x7562, [0x584c] = 0x7570,
  [0x584d] = 0x758f, [0x584e] = 0x75d4, [0x584f] = 0x75d5, [0x5850] = 0x75b5,
  [0x5851] = 0x75ca, [0x5852] = 0x75cd, [0x5853] = 0x768e, [0x5854] = 0x76d4,
  [0x5855] = 0x76d2, [0x5856] = 0x76db, [0x5857] = 0x7737, [0x5858] = 0x773e,
  [0x5859] = 0x773c, [0x585a] = 0x7736, [0x585b] = 0x7738, [0x585c] = 0x773a,
  [0x585d] = 0x786b, [0x585e] = 0x7843, [0x585f] = 0x784e, [0x5860] = 0x7965,
  [0x5861] = 0x7968, [0x5862] = 0x796d, [0x5863] = 0x79fb, [0x5864] = 0x7a92,
  [0x5865] = 0x7a95, [0x5866] = 0x7b20, [0x5867] = 0x7b28, [0x5868] = 0x7b1b,
  [0x5869] = 0x7b2c, [0x586a] = 0x7b26, [0x586b] = 0x7b19, [0x586c] = 0x7b1e,
  [0x586d] = 0x7b2e, [0x586e] = 0x7c92, [0x586f] = 0x7c97, [0x5870] = 0x7c95,
  [0x5871] = 0x7d46, [0x5872] = 0x7d43, [0x5873] = 0x7d71, [0x5874] = 0x7d2e,
  [0x5875] = 0x7d39, [0x5876] = 0x7d3c, [0x5877] = 0x7d40, [0x5878] = 0x7d30,
  [0x5879] = 0x7d33, [0x587a] = 0x7d44, [0x587b] = 0x7d2f, [0x587c] = 0x7d42,
  [0x587d] = 0x7d32, [0x587e] = 0x7d31, [0x587f] = 0x7f3d, [0x5881] = 0x7f9e,
  [0x5882] = 0x7f9a, [0x5883] = 0x7fcc, [0x5884] = 0x7fce, [0x5885] = 0x7fd2,
  [0x5886] = 0x801c, [0x5887] = 0x804a, [0x5888] = 0x8046, [0x5889] = 0x812f,
  [0x588a] = 0x8116, [0x588b] = 0x8123, [0x588c] = 0x812b, [0x588d] = 0x8129,
  [0x588e] = 0x8130, [0x588f] = 0x8124, [0x5890] = 0x8202, [0x5891] = 0x8235,
  [0x5892] = 0x8237, [0x5893] = 0x8236, [0x5894] = 0x8239, [0x5895] = 0x838e,
  [0x5896] = 0x839e, [0x5897] = 0x8398, [0x5898] = 0x8378, [0x5899] = 0x83a2,
  [0x589a] = 0x8396, [0x589b] = 0x83bd, [0x589c] = 0x83ab, [0x589d] = 0x8392,
  [0x589e] = 0x838a, [0x589f] = 0x8393, [0x58a0] = 0x8389, [0x58a1] = 0x83a0,
  [0x58a2] = 0x8377, [0x58a3] = 0x837b, [0x58a4] = 0x837c, [0x58a5] = 0x8386,
  [0x58a6] = 0x83a7, [0x58a7] = 0x8655, [0x58a8] = 0x5f6a, [0x58a9] = 0x86c7,
  [0x58aa] = 0x86c0, [0x58ab] = 0x86b6, [0x58ac] = 0x86c4, [0x58ad] = 0x86b5,
  [0x58ae] = 0x86c6, [0x58af] = 0x86cb, [0x58b0] = 0x86b1, [0x58b1] = 0x86af,
  [0x58b2] = 0x86c9, [0x58b3] = 0x8853, [0x58b4] = 0x889e, [0x58b5] = 0x8888,
  [0x58b6] = 0x88ab, [0x58b7] = 0x8892, [0x58b8] = 0x8896, [0x58b9] = 0x888d,
  [0x58ba] = 0x888b, [0x58bb] = 0x8993, [0x58bc] = 0x898f, [0x58bd] = 0x8a2a,
  [0x58be] = 0x8a1d, [0x58bf] = 0x8a23, [0x58c0] = 0x8a25, [0x58c1] = 0x8a31,
  [0x58c2] = 0x8a2d, [0x58c3] = 0x8a1f, [0x58c4] = 0x8a1b, [0x58c5] = 0x8a22,
  [0x58c6] = 0x8c49, [0x58c7] = 0x8c5a, [0x58c8] = 0x8ca9, [0x58c9] = 0x8cac,
  [0x58ca] = 0x8cab, [0x58cb] = 0x8ca8, [0x58cc] = 0x8caa, [0x58cd] = 0x8ca7,
  [0x58ce] = 0x8d67, [0x58cf] = 0x8d66, [0x58d0] = 0x8dbe, [0x58d1] = 0x8dba,
  [0x58d2] = 0x8edb, [0x58d3] = 0x8edf, [0x58d4] = 0x9019, [0x58d5] = 0x900d,
  [0x58d6] = 0x901a, [0x58d7] = 0x9017, [0x58d8] = 0x9023, [0x58d9] = 0x901f,
  [0x58da] = 0x901d, [0x58db] = 0x9010, [0x58dc] = 0x9015, [0x58dd] = 0x901e,
  [0x58de] = 0x9020, [0x58df] = 0x900f, [0x58e0] = 0x9022, [0x58e1] = 0x9016,
  [0x58e2] = 0x901b, [0x58e3] = 0x9014, [0x58e4] = 0x90e8, [0x58e5] = 0x90ed,
  [0x58e6] = 0x90fd, [0x58e7] = 0x9157, [0x58e8] = 0x91ce, [0x58e9] = 0x91f5,
  [0x58ea] = 0x91e6, [0x58eb] = 0x91e3, [0x58ec] = 0x91e7, [0x58ed] = 0x91ed,
  [0x58ee] = 0x91e9, [0x58ef] = 0x9589, [0x58f0] = 0x966a, [0x58f1] = 0x9675,
  [0x58f2] = 0x9673, [0x58f3] = 0x9678, [0x58f4] = 0x9670, [0x58f5] = 0x9674,
  [0x58f6] = 0x9676, [0x58f7] = 0x9677, [0x58f8] = 0x966c, [0x58f9] = 0x96c0,
  [0x58fa] = 0x96ea, [0x58fb] = 0x96e9, [0x58fc] = 0x7ae0, [0x58fd] = 0x7adf,
  [0x5941] = 0x9802, [0x5942] = 0x9803, [0x5943] = 0x9b5a, [0x5944] = 0x9ce5,
  [0x5945] = 0x9e75, [0x5946] = 0x9e7f, [0x5947] = 0x9ea5, [0x5948] = 0x9ebb,
  [0x5949] = 0x50a2, [0x594a] = 0x508d, [0x594b] = 0x5085, [0x594c] = 0x5099,
  [0x594d] = 0x5091, [0x594e] = 0x5080, [0x594f] = 0x5096, [0x5950] = 0x5098,
  [0x5951] = 0x509a, [0x5952] = 0x6700, [0x5953] = 0x51f1, [0x5954] = 0x5272,
  [0x5955] = 0x5274, [0x5956] = 0x5275, [0x5957] = 0x5269, [0x5958] = 0x52de,
  [0x5959] = 0x52dd, [0x595a] = 0x52db, [0x595b] = 0x535a, [0x595c] = 0x53a5,
  [0x595d] = 0x557b, [0x595e] = 0x5580, [0x595f] = 0x55a7, [0x5960] = 0x557c,
  [0x5961] = 0x558a, [0x5962] = 0x559d, [0x5963] = 0x5598, [0x5964] = 0x5582,
  [0x5965] = 0x559c, [0x5966] = 0x55aa, [0x5967] = 0x5594, [0x5968] = 0x5587,
  [0x5969] = 0x558b, [0x596a] = 0x5583, [0x596b] = 0x55b3, [0x596c] = 0x55ae,
  [0x596d] = 0x559f, [0x596e] = 0x553e, [0x596f] = 0x55b2, [0x5970] = 0x559a,
  [0x5971] = 0x55bb, [0x5972] = 0x55ac, [0x5973] = 0x55b1, [0x5974] = 0x557e,
  [0x5975] = 0x5589, [0x5976] = 0x55ab, [0x5977] = 0x5599, [0x5978] = 0x570d,
  [0x5979] = 0x582f, [0x597a] = 0x582a, [0x597b] = 0x5834, [0x597c] = 0x5824,
  [0x597d] = 0x5830, [0x597e] = 0x5831, [0x597f] = 0x5821, [0x5981] = 0x581d,
  [0x5982] = 0x5820, [0x5983] = 0x58f9, [0x5984] = 0x58fa, [0x5985] = 0x5960,
  [0x5986] = 0x5a77, [0x5987] = 0x5a9a, [0x5988] = 0x5a7f, [0x5989] = 0x5a92,
  [0x598a] = 0x5a9b, [0x598b] = 0x5aa7, [0x598c] = 0x5b73, [0x598d] = 0x5b71,
  [0x598e] = 0x5bd2, [0x598f] = 0x5bcc, [0x5990] = 0x5bd3, [0x5991] = 0x5bd0,
  [0x5992] = 0x5c0a, [0x5993] = 0x5c0b, [0x5994] = 0x5c31, [0x5995] = 0x5d4c,
  [0x5996] = 0x5d50, [0x5997] = 0x5d34, [0x5998] = 0x5d47, [0x5999] = 0x5dfd,
  [0x599a] = 0x5e45, [0x599b] = 0x5e3d, [0x599c] = 0x5e40, [0x599d] = 0x5e43,
  [0x599e] = 0x5e7e, [0x599f] = 0x5eca, [0x59a0] = 0x5ec1, [0x59a1] = 0x5ec2,
  [0x59a2] = 0x5ec4, [0x59a3] = 0x5f3c, [0x59a4] = 0x5f6d, [0x59a5] = 0x5fa9,
  [0x59a6] = 0x5faa, [0x59a7] = 0x5fa8, [0x59a8] = 0x60d1, [0x59a9] = 0x60e1,
  [0x59aa] = 0x60b2, [0x59ab] = 0x60b6, [0x59ac] = 0x60e0, [0x59ad] = 0x611c,
  [0x59ae] = 0x6123, [0x59af] = 0x60fa, [0x59b0] = 0x6115, [0x59b1] = 0x60f0,
  [0x59b2] = 0x60fb, [0x59b3] = 0x60f4, [0x59b4] = 0x6168, [0x59b5] = 0x60f1,
  [0x59b6] = 0x610e, [0x59b7] = 0x60f6, [0x59b8] = 0x6109, [0x59b9] = 0x6100,
  [0x59ba] = 0x6112, [0x59bb] = 0x621f, [0x59bc] = 0x6249, [0x59bd] = 0x63a3,
  [0x59be] = 0x638c, [0x59bf] = 0x63cf, [0x59c0] = 0x63c0, [0x59c1] = 0x63e9,
  [0x59c2] = 0x63c9, [0x59c3] = 0x63c6, [0x59c4] = 0x63cd, [0x59c5] = 0x63d2,
  [0x59c6] = 0x63e3, [0x59c7] = 0x63d0, [0x59c8] = 0x63e1, [0x59c9] = 0x63d6,
  [0x59ca] = 0x63ed, [0x59cb] = 0x63ee, [0x59cc] = 0x6376, [0x59cd] = 0x63f4,
  [0x59ce] = 0x63ea, [0x59cf] = 0x63db, [0x59d0] = 0x6452, [0x59d1] = 0x63da,
  [0x59d2] = 0x63f9, [0x59d3] = 0x655e, [0x59d4] = 0x6566, [0x59d5] = 0x6562,
  [0x59d6] = 0x6563, [0x59d7] = 0x6591, [0x59d8] = 0x6590, [0x59d9] = 0x65af,
  [0x59da] = 0x666e, [0x59db] = 0x6670, [0x59dc] = 0x6674, [0x59dd] = 0x6676,
  [0x59de] = 0x666f, [0x59df] = 0x6691, [0x59e0] = 0x667a, [0x59e1] = 0x667e,
  [0x59e2] = 0x6677, [0x59e3] = 0x66fe, [0x59e4] = 0x66ff, [0x59e5] = 0x671f,
  [0x59e6] = 0x671d, [0x59e7] = 0x68fa, [0x59e8] = 0x68d5, [0x59e9] = 0x68e0,
  [0x59ea] = 0x68d8, [0x59eb] = 0x68d7, [0x59ec] = 0x6905, [0x59ed] = 0x68df,
  [0x59ee] = 0x68f5, [0x59ef] = 0x68ee, [0x59f0] = 0x68e7, [0x59f1] = 0x68f9,
  [0x59f2] = 0x68d2, [0x59f3] = 0x68f2, [0x59f4] = 0x68e3, [0x59f5] = 0x68cb,
  [0x59f6] = 0x68cd, [0x59f7] = 0x690d, [0x59f8] = 0x6912, [0x59f9] = 0x690e,
  [0x59fa] = 0x68c9, [0x59fb] = 0x68da, [0x59fc] = 0x696e, [0x59fd] = 0x68fb,
  [0x5a41] = 0x6b3e, [0x5a42] = 0x6b3a, [0x5a43] = 0x6b3d, [0x5a44] = 0x6b98,
  [0x5a45] = 0x6b96, [0x5a46] = 0x6bbc, [0x5a47] = 0x6bef, [0x5a48] = 0x6c2e,
  [0x5a49] = 0x6c2f, [0x5a4a] = 0x6c2c, [0x5a4b] = 0x6e2f, [0x5a4c] = 0x6e38,
  [0x5a4d] = 0x6e54, [0x5a4e] = 0x6e21, [0x5a4f] = 0x6e32, [0x5a50] = 0x6e67,
  [0x5a51] = 0x6e4a, [0x5a52] = 0x6e20, [0x5a53] = 0x6e25, [0x5a54] = 0x6e23,
  [0x5a55] = 0x6e1b, [0x5a56] = 0x6e5b, [0x5a57] = 0x6e58, [0x5a58] = 0x6e24,
  [0x5a59] = 0x6e56, [0x5a5a] = 0x6e6e, [0x5a5b] = 0x6e2d, [0x5a5c] = 0x6e26,
  [0x5a5d] = 0x6e6f, [0x5a5e] = 0x6e34, [0x5a5f] = 0x6e4d, [0x5a60] = 0x6e3a,
  [0x5a61] = 0x6e2c, [0x5a62] = 0x6e43, [0x5a63] = 0x6e1d, [0x5a64] = 0x6e3e,
  [0x5a65] = 0x6ecb, [0x5a66] = 0x6e89, [0x5a67] = 0x6e19, [0x5a68] = 0x6e4e,
  [0x5a69] = 0x6e63, [0x5a6a] = 0x6e44, [0x5a6b] = 0x6e72, [0x5a6c] = 0x6e69,
  [0x5a6d] = 0x6e5f, [0x5a6e] = 0x7119, [0x5a6f] = 0x711a, [0x5a70] = 0x7126,
  [0x5a71] = 0x7130, [0x5a72] = 0x7121, [0x5a73] = 0x7136, [0x5a74] = 0x716e,
  [0x5a75] = 0x711c, [0x5a76] = 0x724c, [0x5a77] = 0x7284, [0x5a78] = 0x7280,
  [0x5a79] = 0x7336, [0x5a7a] = 0x7325, [0x5a7b] = 0x7334, [0x5a7c] = 0x7329,
  [0x5a7d] = 0x743a, [0x5a7e] = 0x742a, [0x5a7f] = 0x7433, [0x5a81] = 0x7422,
  [0x5a82] = 0x7425, [0x5a83] = 0x7435, [0x5a84] = 0x7436, [0x5a85] = 0x7434,
  [0x5a86] = 0x742f, [0x5a87] = 0x741b, [0x5a88] = 0x7426, [0x5a89] = 0x7428,
  [0x5a8a] = 0x7525, [0x5a8b] = 0x7526, [0x5a8c] = 0x756b, [0x5a8d] = 0x756a,
  [0x5a8e] = 0x75e2, [0x5a8f] = 0x75db, [0x5a90] = 0x75e3, [0x5a91] = 0x75d9,
  [0x5a92] = 0x75d8, [0x5a93] = 0x75de, [0x5a94] = 0x75e0, [0x5a95] = 0x767b,
  [0x5a96] = 0x767c, [0x5a97] = 0x7696, [0x5a98] = 0x7693, [0x5a99] = 0x76b4,
  [0x5a9a] = 0x76dc, [0x5a9b] = 0x774f, [0x5a9c] = 0x77ed, [0x5a9d] = 0x785d,
  [0x5a9e] = 0x786c, [0x5a9f] = 0x786f, [0x5aa0] = 0x7a0d, [0x5aa1] = 0x7a08,
  [0x5aa2] = 0x7a0b, [0x5aa3] = 0x7a05, [0x5aa4] = 0x7a00, [0x5aa5] = 0x7a98,
  [0x5aa6] = 0x7a97, [0x5aa7] = 0x7a96, [0x5aa8] = 0x7ae5, [0x5aa9] = 0x7ae3,
  [0x5aaa] = 0x7b49, [0x5aab] = 0x7b56, [0x5aac] = 0x7b46, [0x5aad] = 0x7b50,
  [0x5aae] = 0x7b52, [0x5aaf] = 0x7b54, [0x5ab0] = 0x7b4d, [0x5ab1] = 0x7b4b,
  [0x5ab2] = 0x7b4f, [0x5ab3] = 0x7b51, [0x5ab4] = 0x7c9f, [0x5ab5] = 0x7ca5,
  [0x5ab6] = 0x7d5e, [0x5ab7] = 0x7d50, [0x5ab8] = 0x7d68, [0x5ab9] = 0x7d55,
  [0x5aba] = 0x7d2b, [0x5abb] = 0x7d6e, [0x5abc] = 0x7d72, [0x5abd] = 0x7d61,
  [0x5abe] = 0x7d66, [0x5abf] = 0x7d62, [0x5ac0] = 0x7d70, [0x5ac1] = 0x7d73,
  [0x5ac2] = 0x5584, [0x5ac3] = 0x7fd4, [0x5ac4] = 0x7fd5, [0x5ac5] = 0x800b,
  [0x5ac6] = 0x8052, [0x5ac7] = 0x8085, [0x5ac8] = 0x8155, [0x5ac9] = 0x8154,
  [0x5aca] = 0x814b, [0x5acb] = 0x8151, [0x5acc] = 0x814e, [0x5acd] = 0x8139,
  [0x5ace] = 0x8146, [0x5acf] = 0x813e, [0x5ad0] = 0x814c, [0x5ad1] = 0x8153,
  [0x5ad2] = 0x8174, [0x5ad3] = 0x8212, [0x5ad4] = 0x821c, [0x5ad5] = 0x83e9,
  [0x5ad6] = 0x8403, [0x5ad7] = 0x83f8, [0x5ad8] = 0x840d, [0x5ad9] = 0x83e0,
  [0x5ada] = 0x83c5, [0x5adb] = 0x840b, [0x5adc] = 0x83c1, [0x5add] = 0x83ef,
  [0x5ade] = 0x83f1, [0x5adf] = 0x83f4, [0x5ae0] = 0x8457, [0x5ae1] = 0x840a,
  [0x5ae2] = 0x83f0, [0x5ae3] = 0x840c, [0x5ae4] = 0x83cc, [0x5ae5] = 0x83fd,
  [0x5ae6] = 0x83f2, [0x5ae7] = 0x83ca, [0x5ae8] = 0x8438, [0x5ae9] = 0x840e,
  [0x5aea] = 0x8404, [0x5aeb] = 0x83dc, [0x5aec] = 0x8407, [0x5aed] = 0x83d4,
  [0x5aee] = 0x83df, [0x5aef] = 0x865b, [0x5af0] = 0x86df, [0x5af1] = 0x86d9,
  [0x5af2] = 0x86ed, [0x5af3] = 0x86d4, [0x5af4] = 0x86db, [0x5af5] = 0x86e4,
  [0x5af6] = 0x86d0, [0x5af7] = 0x86de, [0x5af8] = 0x8857, [0x5af9] = 0x88c1,
  [0x5afa] = 0x88c2, [0x5afb] = 0x88b1, [0x5afc] = 0x8983, [0x5afd] = 0x8996,
  [0x5b41] = 0x8a3b, [0x5b42] = 0x8a60, [0x5b43] = 0x8a55, [0x5b44] = 0x8a5e,
  [0x5b45] = 0x8a3c, [0x5b46] = 0x8a41, [0x5b47] = 0x8a54, [0x5b48] = 0x8a5b,
  [0x5b49] = 0x8a50, [0x5b4a] = 0x8a46, [0x5b4b] = 0x8a34, [0x5b4c] = 0x8a3a,
  [0x5b4d] = 0x8a36, [0x5b4e] = 0x8a56, [0x5b4f] = 0x8c61, [0x5b50] = 0x8c82,
  [0x5b51] = 0x8caf, [0x5b52] = 0x8cbc, [0x5b53] = 0x8cb3, [0x5b54] = 0x8cbd,
  [0x5b55] = 0x8cc1, [0x5b56] = 0x8cbb, [0x5b57] = 0x8cc0, [0x5b58] = 0x8cb4,
  [0x5b59] = 0x8cb7, [0x5b5a] = 0x8cb6, [0x5b5b] = 0x8cbf, [0x5b5c] = 0x8cb8,
  [0x5b5d] = 0x8d8a, [0x5b5e] = 0x8d85, [0x5b5f] = 0x8d81, [0x5b60] = 0x8dce,
  [0x5b61] = 0x8ddd, [0x5b62] = 0x8dcb, [0x5b63] = 0x8dda, [0x5b64] = 0x8dd1,
  [0x5b65] = 0x8dcc, [0x5b66] = 0x8ddb, [0x5b67] = 0x8dc6, [0x5b68] = 0x8efb,
  [0x5b69] = 0x8ef8, [0x5b6a] = 0x8efc, [0x5b6b] = 0x8f9c, [0x5b6c] = 0x902e,
  [0x5b6d] = 0x9035, [0x5b6e] = 0x9031, [0x5b6f] = 0x9038, [0x5b70] = 0x9032,
  [0x5b71] = 0x9036, [0x5b72] = 0x9102, [0x5b73] = 0x90f5, [0x5b74] = 0x9109,
  [0x5b75] = 0x90fe, [0x5b76] = 0x9163, [0x5b77] = 0x9165, [0x5b78] = 0x91cf,
  [0x5b79] = 0x9214, [0x5b7a] = 0x9215, [0x5b7b] = 0x9223, [0x5b7c] = 0x9209,
  [0x5b7d] = 0x921e, [0x5b7e] = 0x920d, [0x5b7f] = 0x9210, [0x5b81] = 0x9207,
  [0x5b82] = 0x9211, [0x5b83] = 0x9594, [0x5b84] = 0x958f, [0x5b85] = 0x958b,
  [0x5b86] = 0x9591, [0x5b87] = 0x9593, [0x5b88] = 0x9592, [0x5b89] = 0x958e,
  [0x5b8a] = 0x968a, [0x5b8b] = 0x968e, [0x5b8c] = 0x968b, [0x5b8d] = 0x967d,
  [0x5b8e] = 0x9685, [0x5b8f] = 0x9686, [0x5b90] = 0x968d, [0x5b91] = 0x9672,
  [0x5b92] = 0x9684, [0x5b93] = 0x96c1, [0x5b94] = 0x96c5, [0x5b95] = 0x96c4,
  [0x5b96] = 0x96c6, [0x5b97] = 0x96c7, [0x5b98] = 0x96ef, [0x5b99] = 0x96f2,
  [0x5b9a] = 0x97cc, [0x5b9b] = 0x9805, [0x5b9c] = 0x9806, [0x5b9d] = 0x9808,
  [0x5b9e] = 0x98e7, [0x5b9f] = 0x98ea, [0x5ba0] = 0x98ef, [0x5ba1] = 0x98e9,
  [0x5ba2] = 0x98f2, [0x5ba3] = 0x98ed, [0x5ba4] = 0x99ae, [0x5ba5] = 0x99ad,
  [0x5ba6] = 0x9ec3, [0x5ba7] = 0x9ecd, [0x5ba8] = 0x9ed1, [0x5ba9] = 0x4e82,
  [0x5baa] = 0x50ad, [0x5bab] = 0x50b5, [0x5bac] = 0x50b2, [0x5bad] = 0x50b3,
  [0x5bae] = 0x50c5, [0x5baf] = 0x50be, [0x5bb0] = 0x50ac, [0x5bb1] = 0x50b7,
  [0x5bb2] = 0x50bb, [0x5bb3] = 0x50af, [0x5bb4] = 0x50c7, [0x5bb5] = 0x527f,
  [0x5bb6] = 0x5277, [0x5bb7] = 0x527d, [0x5bb8] = 0x52df, [0x5bb9] = 0x52e6,
  [0x5bba] = 0x52e4, [0x5bbb] = 0x52e2, [0x5bbc] = 0x52e3, [0x5bbd] = 0x532f,
  [0x5bbe] = 0x55df, [0x5bbf] = 0x55e8, [0x5bc0] = 0x55d3, [0x5bc1] = 0x55e6,
  [0x5bc2] = 0x55ce, [0x5bc3] = 0x55dc, [0x5bc4] = 0x55c7, [0x5bc5] = 0x55d1,
  [0x5bc6] = 0x55e3, [0x5bc7] = 0x55e4, [0x5bc8] = 0x55ef, [0x5bc9] = 0x55da,
  [0x5bca] = 0x55e1, [0x5bcb] = 0x55c5, [0x5bcc] = 0x55c6, [0x5bcd] = 0x55e5,
  [0x5bce] = 0x55c9, [0x5bcf] = 0x5712, [0x5bd0] = 0x5713, [0x5bd1] = 0x585e,
  [0x5bd2] = 0x5851, [0x5bd3] = 0x5858, [0x5bd4] = 0x5857, [0x5bd5] = 0x585a,
  [0x5bd6] = 0x5854, [0x5bd7] = 0x586b, [0x5bd8] = 0x584c, [0x5bd9] = 0x586d,
  [0x5bda] = 0x584a, [0x5bdb] = 0x5862, [0x5bdc] = 0x5852, [0x5bdd] = 0x584b,
  [0x5bde] = 0x5967, [0x5bdf] = 0x5ac1, [0x5be0] = 0x5ac9, [0x5be1] = 0x5acc,
  [0x5be2] = 0x5abe, [0x5be3] = 0x5abd, [0x5be4] = 0x5abc, [0x5be5] = 0x5ab3,
  [0x5be6] = 0x5ac2, [0x5be7] = 0x5ab2, [0x5be8] = 0x5d69, [0x5be9] = 0x5d6f,
  [0x5bea] = 0x5e4c, [0x5beb] = 0x5e79, [0x5bec] = 0x5ec9, [0x5bed] = 0x5ec8,
  [0x5bee] = 0x5f12, [0x5bef] = 0x5f59, [0x5bf0] = 0x5fac, [0x5bf1] = 0x5fae,
  [0x5bf2] = 0x611a, [0x5bf3] = 0x610f, [0x5bf4] = 0x6148, [0x5bf5] = 0x611f,
  [0x5bf6] = 0x60f3, [0x5bf7] = 0x611b, [0x5bf8] = 0x60f9, [0x5bf9] = 0x6101,
  [0x5bfa] = 0x6108, [0x5bfb] = 0x614e, [0x5bfc] = 0x614c, [0x5bfd] = 0x6144,
  [0x5c41] = 0x614d, [0x5c42] = 0x613e, [0x5c43] = 0x6134, [0x5c44] = 0x6127,
  [0x5c45] = 0x610d, [0x5c46] = 0x6106, [0x5c47] = 0x6137, [0x5c48] = 0x6221,
  [0x5c49] = 0x6222, [0x5c4a] = 0x6413, [0x5c4b] = 0x643e, [0x5c4c] = 0x641e,
  [0x5c4d] = 0x642a, [0x5c4e] = 0x642d, [0x5c4f] = 0x643d, [0x5c50] = 0x642c,
  [0x5c51] = 0x640f, [0x5c52] = 0x641c, [0x5c53] = 0x6414, [0x5c54] = 0x640d,
  [0x5c55] = 0x6436, [0x5c56] = 0x6416, [0x5c57] = 0x6417, [0x5c58] = 0x6406,
  [0x5c59] = 0x656c, [0x5c5a] = 0x659f, [0x5c5b] = 0x65b0, [0x5c5c] = 0x6697,
  [0x5c5d] = 0x6689, [0x5c5e] = 0x6687, [0x5c5f] = 0x6688, [0x5c60] = 0x6696,
  [0x5c61] = 0x6684, [0x5c62] = 0x6698, [0x5c63] = 0x668d, [0x5c64] = 0x6703,
  [0x5c65] = 0x6994, [0x5c66] = 0x696d, [0x5c67] = 0x695a, [0x5c68] = 0x6977,
  [0x5c69] = 0x6960, [0x5c6a] = 0x6954, [0x5c6b] = 0x6975, [0x5c6c] = 0x6930,
  [0x5c6d] = 0x6982, [0x5c6e] = 0x694a, [0x5c6f] = 0x6968, [0x5c70] = 0x696b,
  [0x5c71] = 0x695e, [0x5c72] = 0x6953, [0x5c73] = 0x6979, [0x5c74] = 0x6986,
  [0x5c75] = 0x695d, [0x5c76] = 0x6963, [0x5c77] = 0x695b, [0x5c78] = 0x6b47,
  [0x5c79] = 0x6b72, [0x5c7a] = 0x6bc0, [0x5c7b] = 0x6bbf, [0x5c7c] = 0x6bd3,
  [0x5c7d] = 0x6bfd, [0x5c7e] = 0x6ea2, [0x5c7f] = 0x6eaf, [0x5c81] = 0x6ed3,
  [0x5c82] = 0x6eb6, [0x5c83] = 0x6ec2, [0x5c84] = 0x6e90, [0x5c85] = 0x6e9d,
  [0x5c86] = 0x6ec7, [0x5c87] = 0x6ec5, [0x5c88] = 0x6ea5, [0x5c89] = 0x6e98,
  [0x5c8a] = 0x6ebc, [0x5c8b] = 0x6eba, [0x5c8c] = 0x6eab, [0x5c8d] = 0x6ed1,
  [0x5c8e] = 0x6e96, [0x5c8f] = 0x6e9c, [0x5c90] = 0x6ec4, [0x5c91] = 0x6ed4,
  [0x5c92] = 0x6eaa, [0x5c93] = 0x6ea7, [0x5c94] = 0x6eb4, [0x5c95] = 0x714e,
  [0x5c96] = 0x7159, [0x5c97] = 0x7169, [0x5c98] = 0x7164, [0x5c99] = 0x7149,
  [0x5c9a] = 0x7167, [0x5c9b] = 0x715c, [0x5c9c] = 0x716c, [0x5c9d] = 0x7166,
  [0x5c9e] = 0x714c, [0x5c9f] = 0x7165, [0x5ca0] = 0x715e, [0x5ca1] = 0x7146,
  [0x5ca2] = 0x7168, [0x5ca3] = 0x7156, [0x5ca4] = 0x723a, [0x5ca5] = 0x7252,
  [0x5ca6] = 0x7337, [0x5ca7] = 0x7345, [0x5ca8] = 0x733f, [0x5ca9] = 0x733e,
  [0x5caa] = 0x746f, [0x5cab] = 0x745a, [0x5cac] = 0x7455, [0x5cad] = 0x745f,
  [0x5cae] = 0x745e, [0x5caf] = 0x7441, [0x5cb0] = 0x743f, [0x5cb1] = 0x7459,
  [0x5cb2] = 0x745b, [0x5cb3] = 0x745c, [0x5cb4] = 0x7576, [0x5cb5] = 0x7578,
  [0x5cb6] = 0x7600, [0x5cb7] = 0x75f0, [0x5cb8] = 0x7601, [0x5cb9] = 0x75f2,
  [0x5cba] = 0x75f1, [0x5cbb] = 0x75fa, [0x5cbc] = 0x75ff, [0x5cbd] = 0x75f4,
  [0x5cbe] = 0x75f3, [0x5cbf] = 0x76de, [0x5cc0] = 0x76df, [0x5cc1] = 0x775b,
  [0x5cc2] = 0x776b, [0x5cc3] = 0x7766, [0x5cc4] = 0x775e, [0x5cc5] = 0x7763,
  [0x5cc6] = 0x7779, [0x5cc7] = 0x776a, [0x5cc8] = 0x776c, [0x5cc9] = 0x775c,
  [0x5cca] = 0x7765, [0x5ccb] = 0x7768, [0x5ccc] = 0x7762, [0x5ccd] = 0x77ee,
  [0x5cce] = 0x788e, [0x5ccf] = 0x78b0, [0x5cd0] = 0x7897, [0x5cd1] = 0x7898,
  [0x5cd2] = 0x788c, [0x5cd3] = 0x7889, [0x5cd4] = 0x787c, [0x5cd5] = 0x7891,
  [0x5cd6] = 0x7893, [0x5cd7] = 0x787f, [0x5cd8] = 0x797a, [0x5cd9] = 0x797f,
  [0x5cda] = 0x7981, [0x5cdb] = 0x842c, [0x5cdc] = 0x79bd, [0x5cdd] = 0x7a1c,
  [0x5cde] = 0x7a1a, [0x5cdf] = 0x7a20, [0x5ce0] = 0x7a14, [0x5ce1] = 0x7a1f,
  [0x5ce2] = 0x7a1e, [0x5ce3] = 0x7a9f, [0x5ce4] = 0x7aa0, [0x5ce5] = 0x7b77,
  [0x5ce6] = 0x7bc0, [0x5ce7] = 0x7b60, [0x5ce8] = 0x7b6e, [0x5ce9] = 0x7b67,
  [0x5cea] = 0x7cb1, [0x5ceb] = 0x7cb3, [0x5cec] = 0x7cb5, [0x5ced] = 0x7d93,
  [0x5cee] = 0x7d79, [0x5cef] = 0x7d91, [0x5cf0] = 0x7d81, [0x5cf1] = 0x7d8f,
  [0x5cf2] = 0x7d5b, [0x5cf3] = 0x7f6e, [0x5cf4] = 0x7f69, [0x5cf5] = 0x7f6a,
  [0x5cf6] = 0x7f72, [0x5cf7] = 0x7fa9, [0x5cf8] = 0x7fa8, [0x5cf9] = 0x7fa4,
  [0x5cfa] = 0x8056, [0x5cfb] = 0x8058, [0x5cfc] = 0x8086, [0x5cfd] = 0x8084,
  [0x5d41] = 0x8171, [0x5d42] = 0x8170, [0x5d43] = 0x8178, [0x5d44] = 0x8165,
  [0x5d45] = 0x816e, [0x5d46] = 0x8173, [0x5d47] = 0x816b, [0x5d48] = 0x8179,
  [0x5d49] = 0x817a, [0x5d4a] = 0x8166, [0x5d4b] = 0x8205, [0x5d4c] = 0x8247,
  [0x5d4d] = 0x8482, [0x5d4e] = 0x8477, [0x5d4f] = 0x843d, [0x5d50] = 0x8431,
  [0x5d51] = 0x8475, [0x5d52] = 0x8466, [0x5d53] = 0x846b, [0x5d54] = 0x8449,
  [0x5d55] = 0x846c, [0x5d56] = 0x845b, [0x5d57] = 0x843c, [0x5d58] = 0x8435,
  [0x5d59] = 0x8461, [0x5d5a] = 0x8463, [0x5d5b] = 0x8469, [0x5d5c] = 0x846d,
  [0x5d5d] = 0x8446, [0x5d5e] = 0x865e, [0x5d5f] = 0x865c, [0x5d60] = 0x865f,
  [0x5d61] = 0x86f9, [0x5d62] = 0x8713, [0x5d63] = 0x8708, [0x5d64] = 0x8707,
  [0x5d65] = 0x8700, [0x5d66] = 0x86fe, [0x5d67] = 0x86fb, [0x5d68] = 0x8702,
  [0x5d69] = 0x8703, [0x5d6a] = 0x8706, [0x5d6b] = 0x870a, [0x5d6c] = 0x8859,
  [0x5d6d] = 0x88df, [0x5d6e] = 0x88d4, [0x5d6f] = 0x88d9, [0x5d70] = 0x88dc,
  [0x5d71] = 0x88d8, [0x5d72] = 0x88dd, [0x5d73] = 0x88e1, [0x5d74] = 0x88ca,
  [0x5d75] = 0x88d5, [0x5d76] = 0x88d2, [0x5d77] = 0x899c, [0x5d78] = 0x89e3,
  [0x5d79] = 0x8a6b, [0x5d7a] = 0x8a72, [0x5d7b] = 0x8a73, [0x5d7c] = 0x8a66,
  [0x5d7d] = 0x8a69, [0x5d7e] = 0x8a70, [0x5d7f] = 0x8a87, [0x5d81] = 0x8a7c,
  [0x5d82] = 0x8a63, [0x5d83] = 0x8aa0, [0x5d84] = 0x8a71, [0x5d85] = 0x8a85,
  [0x5d86] = 0x8a6d, [0x5d87] = 0x8a62, [0x5d88] = 0x8a6e, [0x5d89] = 0x8a6c,
  [0x5d8a] = 0x8a79, [0x5d8b] = 0x8a7b, [0x5d8c] = 0x8a3e, [0x5d8d] = 0x8a68,
  [0x5d8e] = 0x8c62, [0x5d8f] = 0x8c8a, [0x5d90] = 0x8c89, [0x5d91] = 0x8cca,
  [0x5d92] = 0x8cc7, [0x5d93] = 0x8cc8, [0x5d94] = 0x8cc4, [0x5d95] = 0x8cb2,
  [0x5d96] = 0x8cc3, [0x5d97] = 0x8cc2, [0x5d98] = 0x8cc5, [0x5d99] = 0x8de1,
  [0x5d9a] = 0x8ddf, [0x5d9b] = 0x8de8, [0x5d9c] = 0x8def, [0x5d9d] = 0x8df3,
  [0x5d9e] = 0x8dfa, [0x5d9f] = 0x8dea, [0x5da0] = 0x8de4, [0x5da1] = 0x8de6,
  [0x5da2] = 0x8eb2, [0x5da3] = 0x8f03, [0x5da4] = 0x8f09, [0x5da5] = 0x8efe,
  [0x5da6] = 0x8f0a, [0x5da7] = 0x8f9f, [0x5da8] = 0x8fb2, [0x5da9] = 0x904b,
  [0x5daa] = 0x904a, [0x5dab] = 0x9053, [0x5dac] = 0x9042, [0x5dad] = 0x9054,
  [0x5dae] = 0x903c, [0x5daf] = 0x9055, [0x5db0] = 0x9050, [0x5db1] = 0x9047,
  [0x5db2] = 0x904f, [0x5db3] = 0x904e, [0x5db4] = 0x904d, [0x5db5] = 0x9051,
  [0x5db6] = 0x903e, [0x5db7] = 0x9041, [0x5db8] = 0x9112, [0x5db9] = 0x9117,
  [0x5dba] = 0x916c, [0x5dbb] = 0x916a, [0x5dbc] = 0x9169, [0x5dbd] = 0x91c9,
  [0x5dbe] = 0x9237, [0x5dbf] = 0x9257, [0x5dc0] = 0x9238, [0x5dc1] = 0x923d,
  [0x5dc2] = 0x9240, [0x5dc3] = 0x923e, [0x5dc4] = 0x925b, [0x5dc5] = 0x924b,
  [0x5dc6] = 0x9264, [0x5dc7] = 0x9251, [0x5dc8] = 0x9234, [0x5dc9] = 0x9249,
  [0x5dca] = 0x924d, [0x5dcb] = 0x9245, [0x5dcc] = 0x9239, [0x5dcd] = 0x923f,
  [0x5dce] = 0x925a, [0x5dcf] = 0x9598, [0x5dd0] = 0x9698, [0x5dd1] = 0x9694,
  [0x5dd2] = 0x9695, [0x5dd3] = 0x96cd, [0x5dd4] = 0x96cb, [0x5dd5] = 0x96c9,
  [0x5dd6] = 0x96ca, [0x5dd7] = 0x96f7, [0x5dd8] = 0x96fb, [0x5dd9] = 0x96f9,
  [0x5dda] = 0x96f6, [0x5ddb] = 0x9756, [0x5ddc] = 0x9774, [0x5ddd] = 0x9776,
  [0x5dde] = 0x9810, [0x5ddf] = 0x9811, [0x5de0] = 0x9813, [0x5de1] = 0x980a,
  [0x5de2] = 0x9812, [0x5de3] = 0x980c, [0x5de4] = 0x98fc, [0x5de5] = 0x98f4,
  [0x5de6] = 0x98fd, [0x5de7] = 0x98fe, [0x5de8] = 0x99b3, [0x5de9] = 0x99b1,
  [0x5dea] = 0x99b4, [0x5deb] = 0x9ae1, [0x5dec] = 0x9ce9, [0x5ded] = 0x9e82,
  [0x5dee] = 0x9f0e, [0x5def] = 0x9f13, [0x5df0] = 0x9f20, [0x5df1] = 0x50e7,
  [0x5df2] = 0x50ee, [0x5df3] = 0x50e5, [0x5df4] = 0x50d6, [0x5df5] = 0x50ed,
  [0x5df6] = 0x50da, [0x5df7] = 0x50d5, [0x5df8] = 0x50cf, [0x5df9] = 0x50d1,
  [0x5dfa] = 0x50f1, [0x5dfb] = 0x50ce, [0x5dfc] = 0x50e9, [0x5dfd] = 0x5162,
  [0x5e41] = 0x51f3, [0x5e42] = 0x5283, [0x5e43] = 0x5282, [0x5e44] = 0x5331,
  [0x5e45] = 0x53ad, [0x5e46] = 0x55fe, [0x5e47] = 0x5600, [0x5e48] = 0x561b,
  [0x5e49] = 0x5617, [0x5e4a] = 0x55fd, [0x5e4b] = 0x5614, [0x5e4c] = 0x5606,
  [0x5e4d] = 0x5609, [0x5e4e] = 0x560d, [0x5e4f] = 0x560e, [0x5e50] = 0x55f7,
  [0x5e51] = 0x5616, [0x5e52] = 0x561f, [0x5e53] = 0x5608, [0x5e54] = 0x5610,
  [0x5e55] = 0x55f6, [0x5e56] = 0x5718, [0x5e57] = 0x5716, [0x5e58] = 0x5875,
  [0x5e59] = 0x587e, [0x5e5a] = 0x5883, [0x5e5b] = 0x5893, [0x5e5c] = 0x588a,
  [0x5e5d] = 0x5879, [0x5e5e] = 0x5885, [0x5e5f] = 0x587d, [0x5e60] = 0x58fd,
  [0x5e61] = 0x5925, [0x5e62] = 0x5922, [0x5e63] = 0x5924, [0x5e64] = 0x596a,
  [0x5e65] = 0x5969, [0x5e66] = 0x5ae1, [0x5e67] = 0x5ae6, [0x5e68] = 0x5ae9,
  [0x5e69] = 0x5ad7, [0x5e6a] = 0x5ad6, [0x5e6b] = 0x5ad8, [0x5e6c] = 0x5ae3,
  [0x5e6d] = 0x5b75, [0x5e6e] = 0x5bde, [0x5e6f] = 0x5be7, [0x5e70] = 0x5be1,
  [0x5e71] = 0x5be5, [0x5e72] = 0x5be6, [0x5e73] = 0x5be8, [0x5e74] = 0x5be2,
  [0x5e75] = 0x5be4, [0x5e76] = 0x5bdf, [0x5e77] = 0x5c0d, [0x5e78] = 0x5c62,
  [0x5e79] = 0x5d84, [0x5e7a] = 0x5d87, [0x5e7b] = 0x5e5b, [0x5e7c] = 0x5e63,
  [0x5e7d] = 0x5e55, [0x5e7e] = 0x5e57, [0x5e7f] = 0x5e54, [0x5e81] = 0x5ed3,
  [0x5e82] = 0x5ed6, [0x5e83] = 0x5f0a, [0x5e84] = 0x5f46, [0x5e85] = 0x5f70,
  [0x5e86] = 0x5fb9, [0x5e87] = 0x6147, [0x5e88] = 0x613f, [0x5e89] = 0x614b,
  [0x5e8a] = 0x6177, [0x5e8b] = 0x6162, [0x5e8c] = 0x6163, [0x5e8d] = 0x615f,
  [0x5e8e] = 0x615a, [0x5e8f] = 0x6158, [0x5e90] = 0x6175, [0x5e91] = 0x622a,
  [0x5e92] = 0x6487, [0x5e93] = 0x6458, [0x5e94] = 0x6454, [0x5e95] = 0x64a4,
  [0x5e96] = 0x6478, [0x5e97] = 0x645f, [0x5e98] = 0x647a, [0x5e99] = 0x6451,
  [0x5e9a] = 0x6467, [0x5e9b] = 0x6434, [0x5e9c] = 0x646d, [0x5e9d] = 0x647b,
  [0x5e9e] = 0x6572, [0x5e9f] = 0x65a1, [0x5ea0] = 0x65d7, [0x5ea1] = 0x65d6,
  [0x5ea2] = 0x66a2, [0x5ea3] = 0x66a8, [0x5ea4] = 0x669d, [0x5ea5] = 0x699c,
  [0x5ea6] = 0x69a8, [0x5ea7] = 0x6995, [0x5ea8] = 0x69c1, [0x5ea9] = 0x69ae,
  [0x5eaa] = 0x69d3, [0x5eab] = 0x69cb, [0x5eac] = 0x699b, [0x5ead] = 0x69b7,
  [0x5eae] = 0x69bb, [0x5eaf] = 0x69ab, [0x5eb0] = 0x69b4, [0x5eb1] = 0x69d0,
  [0x5eb2] = 0x69cd, [0x5eb3] = 0x69ad, [0x5eb4] = 0x69cc, [0x5eb5] = 0x69a6,
  [0x5eb6] = 0x69c3, [0x5eb7] = 0x69a3, [0x5eb8] = 0x6b49, [0x5eb9] = 0x6b4c,
  [0x5eba] = 0x6c33, [0x5ebb] = 0x6f33, [0x5ebc] = 0x6f14, [0x5ebd] = 0x6efe,
  [0x5ebe] = 0x6f13, [0x5ebf] = 0x6ef4, [0x5ec0] = 0x6f29, [0x5ec1] = 0x6f3e,
  [0x5ec2] = 0x6f20, [0x5ec3] = 0x6f2c, [0x5ec4] = 0x6f0f, [0x5ec5] = 0x6f02,
  [0x5ec6] = 0x6f22, [0x5ec7] = 0x6eff, [0x5ec8] = 0x6eef, [0x5ec9] = 0x6f06,
  [0x5eca] = 0x6f31, [0x5ecb] = 0x6f38, [0x5ecc] = 0x6f32, [0x5ecd] = 0x6f23,
  [0x5ece] = 0x6f15, [0x5ecf] = 0x6f2b, [0x5ed0] = 0x6f2f, [0x5ed1] = 0x6f88,
  [0x5ed2] = 0x6f2a, [0x5ed3] = 0x6eec, [0x5ed4] = 0x6f01, [0x5ed5] = 0x6ef2,
  [0x5ed6] = 0x6ecc, [0x5ed7] = 0x6ef7, [0x5ed8] = 0x7194, [0x5ed9] = 0x7199,
  [0x5eda] = 0x717d, [0x5edb] = 0x718a, [0x5edc] = 0x7184, [0x5edd] = 0x7192,
  [0x5ede] = 0x723e, [0x5edf] = 0x7292, [0x5ee0] = 0x7296, [0x5ee1] = 0x7344,
  [0x5ee2] = 0x7350, [0x5ee3] = 0x7464, [0x5ee4] = 0x7463, [0x5ee5] = 0x746a,
  [0x5ee6] = 0x7470, [0x5ee7] = 0x746d, [0x5ee8] = 0x7504, [0x5ee9] = 0x7591,
  [0x5eea] = 0x7627, [0x5eeb] = 0x760d, [0x5eec] = 0x760b, [0x5eed] = 0x7609,
  [0x5eee] = 0x7613, [0x5eef] = 0x76e1, [0x5ef0] = 0x76e3, [0x5ef1] = 0x7784,
  [0x5ef2] = 0x777d, [0x5ef3] = 0x777f, [0x5ef4] = 0x7761, [0x5ef5] = 0x78c1,
  [0x5ef6] = 0x789f, [0x5ef7] = 0x78a7, [0x5ef8] = 0x78b3, [0x5ef9] = 0x78a9,
  [0x5efa] = 0x78a3, [0x5efb] = 0x798e, [0x5efc] = 0x798f, [0x5efd] = 0x798d,
  [0x5f41] = 0x7a2e, [0x5f42] = 0x7a31, [0x5f43] = 0x7aaa, [0x5f44] = 0x7aa9,
  [0x5f45] = 0x7aed, [0x5f46] = 0x7aef, [0x5f47] = 0x7ba1, [0x5f48] = 0x7b95,
  [0x5f49] = 0x7b8b, [0x5f4a] = 0x7b75, [0x5f4b] = 0x7b97, [0x5f4c] = 0x7b9d,
  [0x5f4d] = 0x7b94, [0x5f4e] = 0x7b8f, [0x5f4f] = 0x7bb8, [0x5f50] = 0x7b87,
  [0x5f51] = 0x7b84, [0x5f52] = 0x7cb9, [0x5f53] = 0x7cbd, [0x5f54] = 0x7cbe,
  [0x5f55] = 0x7dbb, [0x5f56] = 0x7db0, [0x5f57] = 0x7d9c, [0x5f58] = 0x7dbd,
  [0x5f59] = 0x7dbe, [0x5f5a] = 0x7da0, [0x5f5b] = 0x7dca, [0x5f5c] = 0x7db4,
  [0x5f5d] = 0x7db2, [0x5f5e] = 0x7db1, [0x5f5f] = 0x7dba, [0x5f60] = 0x7da2,
  [0x5f61] = 0x7dbf, [0x5f62] = 0x7db5, [0x5f63] = 0x7db8, [0x5f64] = 0x7dad,
  [0x5f65] = 0x7dd2, [0x5f66] = 0x7dc7, [0x5f67] = 0x7dac, [0x5f68] = 0x7f70,
  [0x5f69] = 0x7fe0, [0x5f6a] = 0x7fe1, [0x5f6b] = 0x7fdf, [0x5f6c] = 0x805e,
  [0x5f6d] = 0x805a, [0x5f6e] = 0x8087, [0x5f6f] = 0x8150, [0x5f70] = 0x8180,
  [0x5f71] = 0x818f, [0x5f72] = 0x8188, [0x5f73] = 0x818a, [0x5f74] = 0x817f,
  [0x5f75] = 0x8182, [0x5f76] = 0x81e7, [0x5f77] = 0x81fa, [0x5f78] = 0x8207,
  [0x5f79] = 0x8214, [0x5f7a] = 0x821e, [0x5f7b] = 0x824b, [0x5f7c] = 0x84c9,
  [0x5f7d] = 0x84bf, [0x5f7e] = 0x84c6, [0x5f7f] = 0x84c4, [0x5f81] = 0x8499,
  [0x5f82] = 0x849e, [0x5f83] = 0x84b2, [0x5f84] = 0x849c, [0x5f85] = 0x84cb,
  [0x5f86] = 0x84b8, [0x5f87] = 0x84c0, [0x5f88] = 0x84d3, [0x5f89] = 0x8490,
  [0x5f8a] = 0x84bc, [0x5f8b] = 0x84d1, [0x5f8c] = 0x84ca, [0x5f8d] = 0x873f,
  [0x5f8e] = 0x871c, [0x5f8f] = 0x873b, [0x5f90] = 0x8722, [0x5f91] = 0x8725,
  [0x5f92] = 0x8734, [0x5f93] = 0x8718, [0x5f94] = 0x8755, [0x5f95] = 0x8737,
  [0x5f96] = 0x8729, [0x5f97] = 0x88f3, [0x5f98] = 0x8902, [0x5f99] = 0x88f4,
  [0x5f9a] = 0x88f9, [0x5f9b] = 0x88f8, [0x5f9c] = 0x88fd, [0x5f9d] = 0x88e8,
  [0x5f9e] = 0x891a, [0x5f9f] = 0x88ef, [0x5fa0] = 0x8aa6, [0x5fa1] = 0x8a8c,
  [0x5fa2] = 0x8a9e, [0x5fa3] = 0x8aa3, [0x5fa4] = 0x8a8d, [0x5fa5] = 0x8aa1,
  [0x5fa6] = 0x8a93, [0x5fa7] = 0x8aa4, [0x5fa8] = 0x8aaa, [0x5fa9] = 0x8aa5,
  [0x5faa] = 0x8aa8, [0x5fab] = 0x8a98, [0x5fac] = 0x8a91, [0x5fad] = 0x8a9a,
  [0x5fae] = 0x8aa7, [0x5faf] = 0x8c6a, [0x5fb0] = 0x8c8d, [0x5fb1] = 0x8c8c,
  [0x5fb2] = 0x8cd3, [0x5fb3] = 0x8cd1, [0x5fb4] = 0x8cd2, [0x5fb5] = 0x8d6b,
  [0x5fb6] = 0x8d99, [0x5fb7] = 0x8d95, [0x5fb8] = 0x8dfc, [0x5fb9] = 0x8f14,
  [0x5fba] = 0x8f12, [0x5fbb] = 0x8f15, [0x5fbc] = 0x8f13, [0x5fbd] = 0x8fa3,
  [0x5fbe] = 0x9060, [0x5fbf] = 0x9058, [0x5fc0] = 0x905c, [0x5fc1] = 0x9063,
  [0x5fc2] = 0x9059, [0x5fc3] = 0x905e, [0x5fc4] = 0x9062, [0x5fc5] = 0x905d,
  [0x5fc6] = 0x905b, [0x5fc7] = 0x9119, [0x5fc8] = 0x9118, [0x5fc9] = 0x911e,
  [0x5fca] = 0x9175, [0x5fcb] = 0x9178, [0x5fcc] = 0x9177, [0x5fcd] = 0x9174,
  [0x5fce] = 0x9278, [0x5fcf] = 0x9280, [0x5fd0] = 0x9285, [0x5fd1] = 0x9298,
  [0x5fd2] = 0x9296, [0x5fd3] = 0x927b, [0x5fd4] = 0x9293, [0x5fd5] = 0x929c,
  [0x5fd6] = 0x92a8, [0x5fd7] = 0x927c, [0x5fd8] = 0x9291, [0x5fd9] = 0x95a1,
  [0x5fda] = 0x95a8, [0x5fdb] = 0x95a9, [0x5fdc] = 0x95a3, [0x5fdd] = 0x95a5,
  [0x5fde] = 0x95a4, [0x5fdf] = 0x9699, [0x5fe0] = 0x969c, [0x5fe1] = 0x969b,
  [0x5fe2] = 0x96cc, [0x5fe3] = 0x96d2, [0x5fe4] = 0x9700, [0x5fe5] = 0x977c,
  [0x5fe6] = 0x9785, [0x5fe7] = 0x97f6, [0x5fe8] = 0x9817, [0x5fe9] = 0x9818,
  [0x5fea] = 0x98af, [0x5feb] = 0x98b1, [0x5fec] = 0x9903, [0x5fed] = 0x9905,
  [0x5fee] = 0x990c, [0x5fef] = 0x9909, [0x5ff0] = 0x99c1, [0x5ff1] = 0x9aaf,
  [0x5ff2] = 0x9ab0, [0x5ff3] = 0x9ae6, [0x5ff4] = 0x9b41, [0x5ff5] = 0x9b42,
  [0x5ff6] = 0x9cf4, [0x5ff7] = 0x9cf6, [0x5ff8] = 0x9cf3, [0x5ff9] = 0x9ebc,
  [0x5ffa] = 0x9f3b, [0x5ffb] = 0x9f4a, [0x5ffc] = 0x5104, [0x5ffd] = 0x5100,
  [0x6041] = 0x50fb, [0x6042] = 0x50f5, [0x6043] = 0x50f9, [0x6044] = 0x5102,
  [0x6045] = 0x5108, [0x6046] = 0x5109, [0x6047] = 0x5105, [0x6048] = 0x51dc,
  [0x6049] = 0x5287, [0x604a] = 0x5288, [0x604b] = 0x5289, [0x604c] = 0x528d,
  [0x604d] = 0x528a, [0x604e] = 0x52f0, [0x604f] = 0x53b2, [0x6050] = 0x562e,
  [0x6051] = 0x563b, [0x6052] = 0x5639, [0x6053] = 0x5632, [0x6054] = 0x563f,
  [0x6055] = 0x5634, [0x6056] = 0x5629, [0x6057] = 0x5653, [0x6058] = 0x564e,
  [0x6059] = 0x5657, [0x605a] = 0x5674, [0x605b] = 0x5636, [0x605c] = 0x562f,
  [0x605d] = 0x5630, [0x605e] = 0x5880, [0x605f] = 0x589f, [0x6060] = 0x589e,
  [0x6061] = 0x58b3, [0x6062] = 0x589c, [0x6063] = 0x58ae, [0x6064] = 0x58a9,
  [0x6065] = 0x58a6, [0x6066] = 0x596d, [0x6067] = 0x5b09, [0x6068] = 0x5afb,
  [0x6069] = 0x5b0b, [0x606a] = 0x5af5, [0x606b] = 0x5b0c, [0x606c] = 0x5b08,
  [0x606d] = 0x5bee, [0x606e] = 0x5bec, [0x606f] = 0x5be9, [0x6070] = 0x5beb,
  [0x6071] = 0x5c64, [0x6072] = 0x5c65, [0x6073] = 0x5d9d, [0x6074] = 0x5d94,
  [0x6075] = 0x5e62, [0x6076] = 0x5e5f, [0x6077] = 0x5e61, [0x6078] = 0x5ee2,
  [0x6079] = 0x5eda, [0x607a] = 0x5edf, [0x607b] = 0x5edd, [0x607c] = 0x5ee3,
  [0x607d] = 0x5ee0, [0x607e] = 0x5f48, [0x607f] = 0x5f71, [0x6081] = 0x5fb7,
  [0x6082] = 0x5fb5, [0x6083] = 0x6176, [0x6084] = 0x6167, [0x6085] = 0x616e,
  [0x6086] = 0x615d, [0x6087] = 0x6155, [0x6088] = 0x6182, [0x6089] = 0x617c,
  [0x608a] = 0x6170, [0x608b] = 0x616b, [0x608c] = 0x617e, [0x608d] = 0x61a7,
  [0x608e] = 0x6190, [0x608f] = 0x61ab, [0x6090] = 0x618e, [0x6091] = 0x61ac,
  [0x6092] = 0x619a, [0x6093] = 0x61a4, [0x6094] = 0x6194, [0x6095] = 0x61ae,
  [0x6096] = 0x622e, [0x6097] = 0x6469, [0x6098] = 0x646f, [0x6099] = 0x6479,
  [0x609a] = 0x649e, [0x609b] = 0x64b2, [0x609c] = 0x6488, [0x609d] = 0x6490,
  [0x609e] = 0x64b0, [0x609f] = 0x64a5, [0x60a0] = 0x6493, [0x60a1] = 0x6495,
  [0x60a2] = 0x64a9, [0x60a3] = 0x6492, [0x60a4] = 0x64ae, [0x60a5] = 0x64ad,
  [0x60a6] = 0x64ab, [0x60a7] = 0x649a, [0x60a8] = 0x64ac, [0x60a9] = 0x6499,
  [0x60aa] = 0x64a2, [0x60ab] = 0x64b3, [0x60ac] = 0x6575, [0x60ad] = 0x6577,
  [0x60ae] = 0x6578, [0x60af] = 0x66ae, [0x60b0] = 0x66ab, [0x60b1] = 0x66b4,
  [0x60b2] = 0x66b1, [0x60b3] = 0x6a23, [0x60b4] = 0x6a1f, [0x60b5] = 0x69e8,
  [0x60b6] = 0x6a01, [0x60b7] = 0x6a1e, [0x60b8] = 0x6a19, [0x60b9] = 0x69fd,
  [0x60ba] = 0x6a21, [0x60bb] = 0x6a13, [0x60bc] = 0x6a0a, [0x60bd] = 0x69f3,
  [0x60be] = 0x6a02, [0x60bf] = 0x6a05, [0x60c0] = 0x69ed, [0x60c1] = 0x6a11,
  [0x60c2] = 0x6b50, [0x60c3] = 0x6b4e, [0x60c4] = 0x6ba4, [0x60c5] = 0x6bc5,
  [0x60c6] = 0x6bc6, [0x60c7] = 0x6f3f, [0x60c8] = 0x6f7c, [0x60c9] = 0x6f84,
  [0x60ca] = 0x6f51, [0x60cb] = 0x6f66, [0x60cc] = 0x6f54, [0x60cd] = 0x6f86,
  [0x60ce] = 0x6f6d, [0x60cf] = 0x6f5b, [0x60d0] = 0x6f78, [0x60d1] = 0x6f6e,
  [0x60d2] = 0x6f8e, [0x60d3] = 0x6f7a, [0x60d4] = 0x6f70, [0x60d5] = 0x6f64,
  [0x60d6] = 0x6f97, [0x60d7] = 0x6f58, [0x60d8] = 0x6ed5, [0x60d9] = 0x6f6f,
  [0x60da] = 0x6f60, [0x60db] = 0x6f5f, [0x60dc] = 0x719f, [0x60dd] = 0x71ac,
  [0x60de] = 0x71b1, [0x60df] = 0x71a8, [0x60e0] = 0x7256, [0x60e1] = 0x729b,
  [0x60e2] = 0x734e, [0x60e3] = 0x7357, [0x60e4] = 0x7469, [0x60e5] = 0x748b,
  [0x60e6] = 0x7483, [0x60e7] = 0x747e, [0x60e8] = 0x7480, [0x60e9] = 0x757f,
  [0x60ea] = 0x7620, [0x60eb] = 0x7629, [0x60ec] = 0x761f, [0x60ed] = 0x7624,
  [0x60ee] = 0x7626, [0x60ef] = 0x7621, [0x60f0] = 0x7622, [0x60f1] = 0x769a,
  [0x60f2] = 0x76ba, [0x60f3] = 0x76e4, [0x60f4] = 0x778e, [0x60f5] = 0x7787,
  [0x60f6] = 0x778c, [0x60f7] = 0x7791, [0x60f8] = 0x778b, [0x60f9] = 0x78cb,
  [0x60fa] = 0x78c5, [0x60fb] = 0x78ba, [0x60fc] = 0x78ca, [0x60fd] = 0x78be,
  [0x6141] = 0x78d5, [0x6142] = 0x78bc, [0x6143] = 0x78d0, [0x6144] = 0x7a3f,
  [0x6145] = 0x7a3c, [0x6146] = 0x7a40, [0x6147] = 0x7a3d, [0x6148] = 0x7a37,
  [0x6149] = 0x7a3b, [0x614a] = 0x7aaf, [0x614b] = 0x7aae, [0x614c] = 0x7bad,
  [0x614d] = 0x7bb1, [0x614e] = 0x7bc4, [0x614f] = 0x7bb4, [0x6150] = 0x7bc6,
  [0x6151] = 0x7bc7, [0x6152] = 0x7bc1, [0x6153] = 0x7ba0, [0x6154] = 0x7bcc,
  [0x6155] = 0x7cca, [0x6156] = 0x7de0, [0x6157] = 0x7df4, [0x6158] = 0x7def,
  [0x6159] = 0x7dfb, [0x615a] = 0x7dd8, [0x615b] = 0x7dec, [0x615c] = 0x7ddd,
  [0x615d] = 0x7de8, [0x615e] = 0x7de3, [0x615f] = 0x7dda, [0x6160] = 0x7dde,
  [0x6161] = 0x7de9, [0x6162] = 0x7d9e, [0x6163] = 0x7dd9, [0x6164] = 0x7df2,
  [0x6165] = 0x7df9, [0x6166] = 0x7f75, [0x6167] = 0x7f77, [0x6168] = 0x7faf,
  [0x6169] = 0x7fe9, [0x616a] = 0x8026, [0x616b] = 0x819b, [0x616c] = 0x819c,
  [0x616d] = 0x819d, [0x616e] = 0x81a0, [0x616f] = 0x819a, [0x6170] = 0x8198,
  [0x6171] = 0x8517, [0x6172] = 0x853d, [0x6173] = 0x851a, [0x6174] = 0x84ee,
  [0x6175] = 0x852c, [0x6176] = 0x852d, [0x6177] = 0x8513, [0x6178] = 0x8511,
  [0x6179] = 0x8523, [0x617a] = 0x8521, [0x617b] = 0x8514, [0x617c] = 0x84ec,
  [0x617d] = 0x8525, [0x617e] = 0x84ff, [0x617f] = 0x8506, [0x6181] = 0x8782,
  [0x6182] = 0x8774, [0x6183] = 0x8776, [0x6184] = 0x8760, [0x6185] = 0x8766,
  [0x6186] = 0x8778, [0x6187] = 0x8768, [0x6188] = 0x8759, [0x6189] = 0x8757,
  [0x618a] = 0x874c, [0x618b] = 0x8753, [0x618c] = 0x885b, [0x618d] = 0x885d,
  [0x618e] = 0x8910, [0x618f] = 0x8907, [0x6190] = 0x8912, [0x6191] = 0x8913,
  [0x6192] = 0x8915, [0x6193] = 0x890a, [0x6194] = 0x8abc, [0x6195] = 0x8ad2,
  [0x6196] = 0x8ac7, [0x6197] = 0x8ac4, [0x6198] = 0x8a95, [0x6199] = 0x8acb,
  [0x619a] = 0x8af8, [0x619b] = 0x8ab2, [0x619c] = 0x8ac9, [0x619d] = 0x8ac2,
  [0x619e] = 0x8abf, [0x619f] = 0x8ab0, [0x61a0] = 0x8ad6, [0x61a1] = 0x8acd,
  [0x61a2] = 0x8ab6, [0x61a3] = 0x8ab9, [0x61a4] = 0x8adb, [0x61a5] = 0x8c4c,
  [0x61a6] = 0x8c4e, [0x61a7] = 0x8c6c, [0x61a8] = 0x8ce0, [0x61a9] = 0x8cde,
  [0x61aa] = 0x8ce6, [0x61ab] = 0x8ce4, [0x61ac] = 0x8cec, [0x61ad] = 0x8ced,
  [0x61ae] = 0x8ce2, [0x61af] = 0x8ce3, [0x61b0] = 0x8cdc, [0x61b1] = 0x8cea,
  [0x61b2] = 0x8ce1, [0x61b3] = 0x8d6d, [0x61b4] = 0x8d9f, [0x61b5] = 0x8da3,
  [0x61b6] = 0x8e2b, [0x61b7] = 0x8e10, [0x61b8] = 0x8e1d, [0x61b9] = 0x8e22,
  [0x61ba] = 0x8e0f, [0x61bb] = 0x8e29, [0x61bc] = 0x8e1f, [0x61bd] = 0x8e21,
  [0x61be] = 0x8e1e, [0x61bf] = 0x8eba, [0x61c0] = 0x8f1d, [0x61c1] = 0x8f1b,
  [0x61c2] = 0x8f1f, [0x61c3] = 0x8f29, [0x61c4] = 0x8f26, [0x61c5] = 0x8f2a,
  [0x61c6] = 0x8f1c, [0x61c7] = 0x8f1e, [0x61c8] = 0x8f25, [0x61c9] = 0x9069,
  [0x61ca] = 0x906e, [0x61cb] = 0x9068, [0x61cc] = 0x906d, [0x61cd] = 0x9077,
  [0x61ce] = 0x9130, [0x61cf] = 0x912d, [0x61d0] = 0x9127, [0x61d1] = 0x9131,
  [0x61d2] = 0x9187, [0x61d3] = 0x9189, [0x61d4] = 0x918b, [0x61d5] = 0x9183,
  [0x61d6] = 0x92c5, [0x61d7] = 0x92bb, [0x61d8] = 0x92b7, [0x61d9] = 0x92ea,
  [0x61da] = 0x92ac, [0x61db] = 0x92e4, [0x61dc] = 0x92c1, [0x61dd] = 0x92b3,
  [0x61de] = 0x92bc, [0x61df] = 0x92d2, [0x61e0] = 0x92c7, [0x61e1] = 0x92f0,
  [0x61e2] = 0x92b2, [0x61e3] = 0x95ad, [0x61e4] = 0x95b1, [0x61e5] = 0x9704,
  [0x61e6] = 0x9706, [0x61e7] = 0x9707, [0x61e8] = 0x9709, [0x61e9] = 0x9760,
  [0x61ea] = 0x978d, [0x61eb] = 0x978b, [0x61ec] = 0x978f, [0x61ed] = 0x9821,
  [0x61ee] = 0x982b, [0x61ef] = 0x981c, [0x61f0] = 0x98b3, [0x61f1] = 0x990a,
  [0x61f2] = 0x9913, [0x61f3] = 0x9912, [0x61f4] = 0x9918, [0x61f5] = 0x99dd,
  [0x61f6] = 0x99d0, [0x61f7] = 0x99df, [0x61f8] = 0x99db, [0x61f9] = 0x99d1,
  [0x61fa] = 0x99d5, [0x61fb] = 0x99d2, [0x61fc] = 0x99d9, [0x61fd] = 0x9ab7,
  [0x6241] = 0x9aee, [0x6242] = 0x9aef, [0x6243] = 0x9b27, [0x6244] = 0x9b45,
  [0x6245] = 0x9b44, [0x6246] = 0x9b77, [0x6247] = 0x9b6f, [0x6248] = 0x9d06,
  [0x6249] = 0x9d09, [0x624a] = 0x9d03, [0x624b] = 0x9ea9, [0x624c] = 0x9ebe,
  [0x624d] = 0x9ece, [0x624e] = 0x58a8, [0x624f] = 0x9f52, [0x6250] = 0x5112,
  [0x6251] = 0x5118, [0x6252] = 0x5114, [0x6253] = 0x5110, [0x6254] = 0x5115,
  [0x6255] = 0x5180, [0x6256] = 0x51aa, [0x6257] = 0x51dd, [0x6258] = 0x5291,
  [0x6259] = 0x5293, [0x625a] = 0x52f3, [0x625b] = 0x5659, [0x625c] = 0x566b,
  [0x625d] = 0x5679, [0x625e] = 0x5669, [0x625f] = 0x5664, [0x6260] = 0x5678,
  [0x6261] = 0x566a, [0x6262] = 0x5668, [0x6263] = 0x5665, [0x6264] = 0x5671,
  [0x6265] = 0x566f, [0x6266] = 0x566c, [0x6267] = 0x5662, [0x6268] = 0x5676,
  [0x6269] = 0x58c1, [0x626a] = 0x58be, [0x626b] = 0x58c7, [0x626c] = 0x58c5,
  [0x626d] = 0x596e, [0x626e] = 0x5b1d, [0x626f] = 0x5b34, [0x6270] = 0x5b78,
  [0x6271] = 0x5bf0, [0x6272] = 0x5c0e, [0x6273] = 0x5f4a, [0x6274] = 0x61b2,
  [0x6275] = 0x6191, [0x6276] = 0x61a9, [0x6277] = 0x618a, [0x6278] = 0x61cd,
  [0x6279] = 0x61b6, [0x627a] = 0x61be, [0x627b] = 0x61ca, [0x627c] = 0x61c8,
  [0x627d] = 0x6230, [0x627e] = 0x64c5, [0x627f] = 0x64c1, [0x6281] = 0x64cb,
  [0x6282] = 0x64bb, [0x6283] = 0x64bc, [0x6284] = 0x64da, [0x6285] = 0x64c4,
  [0x6286] = 0x64c7, [0x6287] = 0x64c2, [0x6288] = 0x64cd, [0x6289] = 0x64bf,
  [0x628a] = 0x64d2, [0x628b] = 0x64d4, [0x628c] = 0x64be, [0x628d] = 0x6574,
  [0x628e] = 0x66c6, [0x628f] = 0x66c9, [0x6290] = 0x66b9, [0x6291] = 0x66c4,
  [0x6292] = 0x66c7, [0x6293] = 0x66b8, [0x6294] = 0x6a3d, [0x6295] = 0x6a38,
  [0x6296] = 0x6a3a, [0x6297] = 0x6a59, [0x6298] = 0x6a6b, [0x6299] = 0x6a58,
  [0x629a] = 0x6a39, [0x629b] = 0x6a44, [0x629c] = 0x6a62, [0x629d] = 0x6a61,
  [0x629e] = 0x6a4b, [0x629f] = 0x6a47, [0x62a0] = 0x6a35, [0x62a1] = 0x6a5f,
  [0x62a2] = 0x6a48, [0x62a3] = 0x6b59, [0x62a4] = 0x6b77, [0x62a5] = 0x6c05,
  [0x62a6] = 0x6fc2, [0x62a7] = 0x6fb1, [0x62a8] = 0x6fa1, [0x62a9] = 0x6fc3,
  [0x62aa] = 0x6fa4, [0x62ab] = 0x6fc1, [0x62ac] = 0x6fa7, [0x62ad] = 0x6fb3,
  [0x62ae] = 0x6fc0, [0x62af] = 0x6fb9, [0x62b0] = 0x6fb6, [0x62b1] = 0x6fa6,
  [0x62b2] = 0x6fa0, [0x62b3] = 0x6fb4, [0x62b4] = 0x71be, [0x62b5] = 0x71c9,
  [0x62b6] = 0x71d0, [0x62b7] = 0x71d2, [0x62b8] = 0x71c8, [0x62b9] = 0x71d5,
  [0x62ba] = 0x71b9, [0x62bb] = 0x71ce, [0x62bc] = 0x71d9, [0x62bd] = 0x71dc,
  [0x62be] = 0x71c3, [0x62bf] = 0x71c4, [0x62c0] = 0x7368, [0x62c1] = 0x749c,
  [0x62c2] = 0x74a3, [0x62c3] = 0x7498, [0x62c4] = 0x749f, [0x62c5] = 0x749e,
  [0x62c6] = 0x74e2, [0x62c7] = 0x750c, [0x62c8] = 0x750d, [0x62c9] = 0x7634,
  [0x62ca] = 0x7638, [0x62cb] = 0x763a, [0x62cc] = 0x76e7, [0x62cd] = 0x76e5,
  [0x62ce] = 0x77a0, [0x62cf] = 0x779e, [0x62d0] = 0x779f, [0x62d1] = 0x77a5,
  [0x62d2] = 0x78e8, [0x62d3] = 0x78da, [0x62d4] = 0x78ec, [0x62d5] = 0x78e7,
  [0x62d6] = 0x79a6, [0x62d7] = 0x7a4d, [0x62d8] = 0x7a4e, [0x62d9] = 0x7a46,
  [0x62da] = 0x7a4c, [0x62db] = 0x7a4b, [0x62dc] = 0x7aba, [0x62dd] = 0x7bd9,
  [0x62de] = 0x7c11, [0x62df] = 0x7bc9, [0x62e0] = 0x7be4, [0x62e1] = 0x7bdb,
  [0x62e2] = 0x7be1, [0x62e3] = 0x7be9, [0x62e4] = 0x7be6, [0x62e5] = 0x7cd5,
  [0x62e6] = 0x7cd6, [0x62e7] = 0x7e0a, [0x62e8] = 0x7e11, [0x62e9] = 0x7e08,
  [0x62ea] = 0x7e1b, [0x62eb] = 0x7e23, [0x62ec] = 0x7e1e, [0x62ed] = 0x7e1d,
  [0x62ee] = 0x7e09, [0x62ef] = 0x7e10, [0x62f0] = 0x7f79, [0x62f1] = 0x7fb2,
  [0x62f2] = 0x7ff0, [0x62f3] = 0x7ff1, [0x62f4] = 0x7fee, [0x62f5] = 0x8028,
  [0x62f6] = 0x81b3, [0x62f7] = 0x81a9, [0x62f8] = 0x81a8, [0x62f9] = 0x81fb,
  [0x62fa] = 0x8208, [0x62fb] = 0x8258, [0x62fc] = 0x8259, [0x62fd] = 0x854a,
  [0x6341] = 0x8559, [0x6342] = 0x8548, [0x6343] = 0x8568, [0x6344] = 0x8569,
  [0x6345] = 0x8543, [0x6346] = 0x8549, [0x6347] = 0x856d, [0x6348] = 0x856a,
  [0x6349] = 0x855e, [0x634a] = 0x8783, [0x634b] = 0x879f, [0x634c] = 0x879e,
  [0x634d] = 0x87a2, [0x634e] = 0x878d, [0x634f] = 0x8861, [0x6350] = 0x892a,
  [0x6351] = 0x8932, [0x6352] = 0x8925, [0x6353] = 0x892b, [0x6354] = 0x8921,
  [0x6355] = 0x89aa, [0x6356] = 0x89a6, [0x6357] = 0x8ae6, [0x6358] = 0x8afa,
  [0x6359] = 0x8aeb, [0x635a] = 0x8af1, [0x635b] = 0x8b00, [0x635c] = 0x8adc,
  [0x635d] = 0x8ae7, [0x635e] = 0x8aee, [0x635f] = 0x8afe, [0x6360] = 0x8b01,
  [0x6361] = 0x8b02, [0x6362] = 0x8af7, [0x6363] = 0x8aed, [0x6364] = 0x8af3,
  [0x6365] = 0x8af6, [0x6366] = 0x8afc, [0x6367] = 0x8c6b, [0x6368] = 0x8c6d,
  [0x6369] = 0x8c93, [0x636a] = 0x8cf4, [0x636b] = 0x8e44, [0x636c] = 0x8e31,
  [0x636d] = 0x8e34, [0x636e] = 0x8e42, [0x636f] = 0x8e39, [0x6370] = 0x8e35,
  [0x6371] = 0x8f3b, [0x6372] = 0x8f2f, [0x6373] = 0x8f38, [0x6374] = 0x8f33,
  [0x6375] = 0x8fa8, [0x6376] = 0x8fa6, [0x6377] = 0x9075, [0x6378] = 0x9074,
  [0x6379] = 0x9078, [0x637a] = 0x9072, [0x637b] = 0x907c, [0x637c] = 0x907a,
  [0x637d] = 0x9134, [0x637e] = 0x9192, [0x637f] = 0x9320, [0x6381] = 0x9336,
  [0x6382] = 0x92f8, [0x6383] = 0x9333, [0x6384] = 0x932f, [0x6385] = 0x9322,
  [0x6386] = 0x92fc, [0x6387] = 0x932b, [0x6388] = 0x9304, [0x6389] = 0x931a,
  [0x638a] = 0x9310, [0x638b] = 0x9326, [0x638c] = 0x9321, [0x638d] = 0x9315,
  [0x638e] = 0x932e, [0x638f] = 0x9319, [0x6390] = 0x95bb, [0x6391] = 0x96a7,
  [0x6392] = 0x96a8, [0x6393] = 0x96aa, [0x6394] = 0x96d5, [0x6395] = 0x970e,
  [0x6396] = 0x9711, [0x6397] = 0x9716, [0x6398] = 0x970d, [0x6399] = 0x9713,
  [0x639a] = 0x970f, [0x639b] = 0x975b, [0x639c] = 0x975c, [0x639d] = 0x9766,
  [0x639e] = 0x9798, [0x639f] = 0x9830, [0x63a0] = 0x9838, [0x63a1] = 0x983b,
  [0x63a2] = 0x9837, [0x63a3] = 0x982d, [0x63a4] = 0x9839, [0x63a5] = 0x9824,
  [0x63a6] = 0x9910, [0x63a7] = 0x9928, [0x63a8] = 0x991e, [0x63a9] = 0x991b,
  [0x63aa] = 0x9921, [0x63ab] = 0x991a, [0x63ac] = 0x99ed, [0x63ad] = 0x99e2,
  [0x63ae] = 0x99f1, [0x63af] = 0x9ab8, [0x63b0] = 0x9abc, [0x63b1] = 0x9afb,
  [0x63b2] = 0x9aed, [0x63b3] = 0x9b28, [0x63b4] = 0x9b91, [0x63b5] = 0x9d15,
  [0x63b6] = 0x9d23, [0x63b7] = 0x9d26, [0x63b8] = 0x9d28, [0x63b9] = 0x9d12,
  [0x63ba] = 0x9d1b, [0x63bb] = 0x9ed8, [0x63bc] = 0x9ed4, [0x63bd] = 0x9f8d,
  [0x63be] = 0x9f9c, [0x63bf] = 0x512a, [0x63c0] = 0x511f, [0x63c1] = 0x5121,
  [0x63c2] = 0x5132, [0x63c3] = 0x52f5, [0x63c4] = 0x568e, [0x63c5] = 0x5680,
  [0x63c6] = 0x5690, [0x63c7] = 0x5685, [0x63c8] = 0x5687, [0x63c9] = 0x568f,
  [0x63ca] = 0x58d5, [0x63cb] = 0x58d3, [0x63cc] = 0x58d1, [0x63cd] = 0x58ce,
  [0x63ce] = 0x5b30, [0x63cf] = 0x5b2a, [0x63d0] = 0x5b24, [0x63d1] = 0x5b7a,
  [0x63d2] = 0x5c37, [0x63d3] = 0x5c68, [0x63d4] = 0x5dbc, [0x63d5] = 0x5dba,
  [0x63d6] = 0x5dbd, [0x63d7] = 0x5db8, [0x63d8] = 0x5e6b, [0x63d9] = 0x5f4c,
  [0x63da] = 0x5fbd, [0x63db] = 0x61c9, [0x63dc] = 0x61c2, [0x63dd] = 0x61c7,
  [0x63de] = 0x61e6, [0x63df] = 0x61cb, [0x63e0] = 0x6232, [0x63e1] = 0x6234,
  [0x63e2] = 0x64ce, [0x63e3] = 0x64ca, [0x63e4] = 0x64d8, [0x63e5] = 0x64e0,
  [0x63e6] = 0x64f0, [0x63e7] = 0x64e6, [0x63e8] = 0x64ec, [0x63e9] = 0x64f1,
  [0x63ea] = 0x64e2, [0x63eb] = 0x64ed, [0x63ec] = 0x6582, [0x63ed] = 0x6583,
  [0x63ee] = 0x66d9, [0x63ef] = 0x66d6, [0x63f0] = 0x6a80, [0x63f1] = 0x6a94,
  [0x63f2] = 0x6a84, [0x63f3] = 0x6aa2, [0x63f4] = 0x6a9c, [0x63f5] = 0x6adb,
  [0x63f6] = 0x6aa3, [0x63f7] = 0x6a7e, [0x63f8] = 0x6a97, [0x63f9] = 0x6a90,
  [0x63fa] = 0x6aa0, [0x63fb] = 0x6b5c, [0x63fc] = 0x6bae, [0x63fd] = 0x6bda,
  [0x6441] = 0x6c08, [0x6442] = 0x6fd8, [0x6443] = 0x6ff1, [0x6444] = 0x6fdf,
  [0x6445] = 0x6fe0, [0x6446] = 0x6fdb, [0x6447] = 0x6fe4, [0x6448] = 0x6feb,
  [0x6449] = 0x6fef, [0x644a] = 0x6f80, [0x644b] = 0x6fec, [0x644c] = 0x6fe1,
  [0x644d] = 0x6fe9, [0x644e] = 0x6fd5, [0x644f] = 0x6fee, [0x6450] = 0x6ff0,
  [0x6451] = 0x71e7, [0x6452] = 0x71df, [0x6453] = 0x71ee, [0x6454] = 0x71e6,
  [0x6455] = 0x71e5, [0x6456] = 0x71ed, [0x6457] = 0x71ec, [0x6458] = 0x71f4,
  [0x6459] = 0x71e0, [0x645a] = 0x7235, [0x645b] = 0x7246, [0x645c] = 0x7370,
  [0x645d] = 0x7372, [0x645e] = 0x74a9, [0x645f] = 0x74b0, [0x6460] = 0x74a6,
  [0x6461] = 0x74a8, [0x6462] = 0x7646, [0x6463] = 0x7642, [0x6464] = 0x764c,
  [0x6465] = 0x76ea, [0x6466] = 0x77b3, [0x6467] = 0x77aa, [0x6468] = 0x77b0,
  [0x6469] = 0x77ac, [0x646a] = 0x77a7, [0x646b] = 0x77ad, [0x646c] = 0x77ef,
  [0x646d] = 0x78f7, [0x646e] = 0x78fa, [0x646f] = 0x78f4, [0x6470] = 0x78ef,
  [0x6471] = 0x7901, [0x6472] = 0x79a7, [0x6473] = 0x79aa, [0x6474] = 0x7a57,
  [0x6475] = 0x7abf, [0x6476] = 0x7c07, [0x6477] = 0x7c0d, [0x6478] = 0x7bfe,
  [0x6479] = 0x7bf7, [0x647a] = 0x7c0c, [0x647b] = 0x7be0, [0x647c] = 0x7ce0,
  [0x647d] = 0x7cdc, [0x647e] = 0x7cde, [0x647f] = 0x7ce2, [0x6481] = 0x7cdf,
  [0x6482] = 0x7cd9, [0x6483] = 0x7cdd, [0x6484] = 0x7e2e, [0x6485] = 0x7e3e,
  [0x6486] = 0x7e46, [0x6487] = 0x7e37, [0x6488] = 0x7e32, [0x6489] = 0x7e43,
  [0x648a] = 0x7e2b, [0x648b] = 0x7e3d, [0x648c] = 0x7e31, [0x648d] = 0x7e45,
  [0x648e] = 0x7e41, [0x648f] = 0x7e34, [0x6490] = 0x7e39, [0x6491] = 0x7e48,
  [0x6492] = 0x7e35, [0x6493] = 0x7e3f, [0x6494] = 0x7e2f, [0x6495] = 0x7f44,
  [0x6496] = 0x7ff3, [0x6497] = 0x7ffc, [0x6498] = 0x8071, [0x6499] = 0x8072,
  [0x649a] = 0x8070, [0x649b] = 0x806f, [0x649c] = 0x8073, [0x649d] = 0x81c6,
  [0x649e] = 0x81c3, [0x649f] = 0x81ba, [0x64a0] = 0x81c2, [0x64a1] = 0x81c0,
  [0x64a2] = 0x81bf, [0x64a3] = 0x81bd, [0x64a4] = 0x81c9, [0x64a5] = 0x81be,
  [0x64a6] = 0x81e8, [0x64a7] = 0x8209, [0x64a8] = 0x8271, [0x64a9] = 0x85aa,
  [0x64aa] = 0x8584, [0x64ab] = 0x857e, [0x64ac] = 0x859c, [0x64ad] = 0x8591,
  [0x64ae] = 0x8594, [0x64af] = 0x85af, [0x64b0] = 0x859b, [0x64b1] = 0x8587,
  [0x64b2] = 0x85a8, [0x64b3] = 0x858a, [0x64b4] = 0x8667, [0x64b5] = 0x87c0,
  [0x64b6] = 0x87d1, [0x64b7] = 0x87b3, [0x64b8] = 0x87d2, [0x64b9] = 0x87c6,
  [0x64ba] = 0x87ab, [0x64bb] = 0x87bb, [0x64bc] = 0x87ba, [0x64bd] = 0x87c8,
  [0x64be] = 0x87cb, [0x64bf] = 0x893b, [0x64c0] = 0x8936, [0x64c1] = 0x8944,
  [0x64c2] = 0x8938, [0x64c3] = 0x893d, [0x64c4] = 0x89ac, [0x64c5] = 0x8b0e,
  [0x64c6] = 0x8b17, [0x64c7] = 0x8b19, [0x64c8] = 0x8b1b, [0x64c9] = 0x8b0a,
  [0x64ca] = 0x8b20, [0x64cb] = 0x8b1d, [0x64cc] = 0x8b04, [0x64cd] = 0x8b10,
  [0x64ce] = 0x8c41, [0x64cf] = 0x8c3f, [0x64d0] = 0x8c73, [0x64d1] = 0x8cfa,
  [0x64d2] = 0x8cfd, [0x64d3] = 0x8cfc, [0x64d4] = 0x8cf8, [0x64d5] = 0x8cfb,
  [0x64d6] = 0x8da8, [0x64d7] = 0x8e49, [0x64d8] = 0x8e4b, [0x64d9] = 0x8e48,
  [0x64da] = 0x8e4a, [0x64db] = 0x8f44, [0x64dc] = 0x8f3e, [0x64dd] = 0x8f42,
  [0x64de] = 0x8f45, [0x64df] = 0x8f3f, [0x64e0] = 0x907f, [0x64e1] = 0x907d,
  [0x64e2] = 0x9084, [0x64e3] = 0x9081, [0x64e4] = 0x9082, [0x64e5] = 0x9080,
  [0x64e6] = 0x9139, [0x64e7] = 0x91a3, [0x64e8] = 0x919e, [0x64e9] = 0x919c,
  [0x64ea] = 0x934d, [0x64eb] = 0x9382, [0x64ec] = 0x9328, [0x64ed] = 0x9375,
  [0x64ee] = 0x934a, [0x64ef] = 0x9365, [0x64f0] = 0x934b, [0x64f1] = 0x9318,
  [0x64f2] = 0x937e, [0x64f3] = 0x936c, [0x64f4] = 0x935b, [0x64f5] = 0x9370,
  [0x64f6] = 0x935a, [0x64f7] = 0x9354, [0x64f8] = 0x95ca, [0x64f9] = 0x95cb,
  [0x64fa] = 0x95cc, [0x64fb] = 0x95c8, [0x64fc] = 0x95c6, [0x64fd] = 0x96b1,
  [0x6541] = 0x96b8, [0x6542] = 0x96d6, [0x6543] = 0x971c, [0x6544] = 0x971e,
  [0x6545] = 0x97a0, [0x6546] = 0x97d3, [0x6547] = 0x9846, [0x6548] = 0x98b6,
  [0x6549] = 0x9935, [0x654a] = 0x9a01, [0x654b] = 0x99ff, [0x654c] = 0x9bae,
  [0x654d] = 0x9bab, [0x654e] = 0x9baa, [0x654f] = 0x9bad, [0x6550] = 0x9d3b,
  [0x6551] = 0x9d3f, [0x6552] = 0x9e8b, [0x6553] = 0x9ecf, [0x6554] = 0x9ede,
  [0x6555] = 0x9edc, [0x6556] = 0x9edd, [0x6557] = 0x9edb, [0x6558] = 0x9f3e,
  [0x6559] = 0x9f4b, [0x655a] = 0x53e2, [0x655b] = 0x5695, [0x655c] = 0x56ae,
  [0x655d] = 0x58d9, [0x655e] = 0x58d8, [0x655f] = 0x5b38, [0x6560] = 0x5f5e,
  [0x6561] = 0x61e3, [0x6562] = 0x6233, [0x6563] = 0x64f4, [0x6564] = 0x64f2,
  [0x6565] = 0x64fe, [0x6566] = 0x6506, [0x6567] = 0x64fa, [0x6568] = 0x64fb,
  [0x6569] = 0x64f7, [0x656a] = 0x65b7, [0x656b] = 0x66dc, [0x656c] = 0x6726,
  [0x656d] = 0x6ab3, [0x656e] = 0x6aac, [0x656f] = 0x6ac3, [0x6570] = 0x6abb,
  [0x6571] = 0x6ab8, [0x6572] = 0x6ac2, [0x6573] = 0x6aae, [0x6574] = 0x6aaf,
  [0x6575] = 0x6b5f, [0x6576] = 0x6b78, [0x6577] = 0x6baf, [0x6578] = 0x7009,
  [0x6579] = 0x700b, [0x657a] = 0x6ffe, [0x657b] = 0x7006, [0x657c] = 0x6ffa,
  [0x657d] = 0x7011, [0x657e] = 0x700f, [0x657f] = 0x71fb, [0x6581] = 0x71fc,
  [0x6582] = 0x71fe, [0x6583] = 0x71f8, [0x6584] = 0x7377, [0x6585] = 0x7375,
  [0x6586] = 0x74a7, [0x6587] = 0x74bf, [0x6588] = 0x7515, [0x6589] = 0x7656,
  [0x658a] = 0x7658, [0x658b] = 0x7652, [0x658c] = 0x77bd, [0x658d] = 0x77bf,
  [0x658e] = 0x77bb, [0x658f] = 0x77bc, [0x6590] = 0x790e, [0x6591] = 0x79ae,
  [0x6592] = 0x7a61, [0x6593] = 0x7a62, [0x6594] = 0x7a60, [0x6595] = 0x7ac4,
  [0x6596] = 0x7ac5, [0x6597] = 0x7c2b, [0x6598] = 0x7c27, [0x6599] = 0x7c2a,
  [0x659a] = 0x7c1e, [0x659b] = 0x7c23, [0x659c] = 0x7c21, [0x659d] = 0x7ce7,
  [0x659e] = 0x7e54, [0x659f] = 0x7e55, [0x65a0] = 0x7e5e, [0x65a1] = 0x7e5a,
  [0x65a2] = 0x7e61, [0x65a3] = 0x7e52, [0x65a4] = 0x7e59, [0x65a5] = 0x7f48,
  [0x65a6] = 0x7ff9, [0x65a7] = 0x7ffb, [0x65a8] = 0x8077, [0x65a9] = 0x8076,
  [0x65aa] = 0x81cd, [0x65ab] = 0x81cf, [0x65ac] = 0x820a, [0x65ad] = 0x85cf,
  [0x65ae] = 0x85a9, [0x65af] = 0x85cd, [0x65b0] = 0x85d0, [0x65b1] = 0x85c9,
  [0x65b2] = 0x85b0, [0x65b3] = 0x85ba, [0x65b4] = 0x85b9, [0x65b5] = 0x85a6,
  [0x65b6] = 0x87ef, [0x65b7] = 0x87ec, [0x65b8] = 0x87f2, [0x65b9] = 0x87e0,
  [0x65ba] = 0x8986, [0x65bb] = 0x89b2, [0x65bc] = 0x89f4, [0x65bd] = 0x8b28,
  [0x65be] = 0x8b39, [0x65bf] = 0x8b2c, [0x65c0] = 0x8b2b, [0x65c1] = 0x8c50,
  [0x65c2] = 0x8d05, [0x65c3] = 0x8e59, [0x65c4] = 0x8e63, [0x65c5] = 0x8e66,
  [0x65c6] = 0x8e64, [0x65c7] = 0x8e5f, [0x65c8] = 0x8e55, [0x65c9] = 0x8ec0,
  [0x65ca] = 0x8f49, [0x65cb] = 0x8f4d, [0x65cc] = 0x9087, [0x65cd] = 0x9083,
  [0x65ce] = 0x9088, [0x65cf] = 0x91ab, [0x65d0] = 0x91ac, [0x65d1] = 0x91d0,
  [0x65d2] = 0x9394, [0x65d3] = 0x938a, [0x65d4] = 0x9396, [0x65d5] = 0x93a2,
  [0x65d6] = 0x93b3, [0x65d7] = 0x93ae, [0x65d8] = 0x93ac, [0x65d9] = 0x93b0,
  [0x65da] = 0x9398, [0x65db] = 0x939a, [0x65dc] = 0x9397, [0x65dd] = 0x95d4,
  [0x65de] = 0x95d6, [0x65df] = 0x95d0, [0x65e0] = 0x95d5, [0x65e1] = 0x96e2,
  [0x65e2] = 0x96dc, [0x65e3] = 0x96d9, [0x65e4] = 0x96db, [0x65e5] = 0x96de,
  [0x65e6] = 0x9724, [0x65e7] = 0x97a3, [0x65e8] = 0x97a6, [0x65e9] = 0x97ad,
  [0x65ea] = 0x97f9, [0x65eb] = 0x984d, [0x65ec] = 0x984f, [0x65ed] = 0x984c,
  [0x65ee] = 0x984e, [0x65ef] = 0x9853, [0x65f0] = 0x98ba, [0x65f1] = 0x993e,
  [0x65f2] = 0x993f, [0x65f3] = 0x993d, [0x65f4] = 0x992e, [0x65f5] = 0x99a5,
  [0x65f6] = 0x9a0e, [0x65f7] = 0x9ac1, [0x65f8] = 0x9b03, [0x65f9] = 0x9b06,
  [0x65fa] = 0x9b4f, [0x65fb] = 0x9b4e, [0x65fc] = 0x9b4d, [0x65fd] = 0x9bca,
  [0x6641] = 0x9bc9, [0x6642] = 0x9bfd, [0x6643] = 0x9bc8, [0x6644] = 0x9bc0,
  [0x6645] = 0x9d51, [0x6646] = 0x9d5d, [0x6647] = 0x9d60, [0x6648] = 0x9ee0,
  [0x6649] = 0x9f15, [0x664a] = 0x9f2c, [0x664b] = 0x5133, [0x664c] = 0x56a5,
  [0x664d] = 0x58de, [0x664e] = 0x58df, [0x664f] = 0x58e2, [0x6650] = 0x5bf5,
  [0x6651] = 0x9f90, [0x6652] = 0x5eec, [0x6653] = 0x61f2, [0x6654] = 0x61f7,
  [0x6655] = 0x61f6, [0x6656] = 0x61f5, [0x6657] = 0x6500, [0x6658] = 0x650f,
  [0x6659] = 0x66e0, [0x665a] = 0x66dd, [0x665b] = 0x6ae5, [0x665c] = 0x6add,
  [0x665d] = 0x6ada, [0x665e] = 0x6ad3, [0x665f] = 0x701b, [0x6660] = 0x701f,
  [0x6661] = 0x7028, [0x6662] = 0x701a, [0x6663] = 0x701d, [0x6664] = 0x7015,
  [0x6665] = 0x7018, [0x6666] = 0x7206, [0x6667] = 0x720d, [0x6668] = 0x7258,
  [0x6669] = 0x72a2, [0x666a] = 0x7378, [0x666b] = 0x737a, [0x666c] = 0x74bd,
  [0x666d] = 0x74ca, [0x666e] = 0x74e3, [0x666f] = 0x7587, [0x6670] = 0x7586,
  [0x6671] = 0x765f, [0x6672] = 0x7661, [0x6673] = 0x77c7, [0x6674] = 0x7919,
  [0x6675] = 0x79b1, [0x6676] = 0x7a6b, [0x6677] = 0x7a69, [0x6678] = 0x7c3e,
  [0x6679] = 0x7c3f, [0x667a] = 0x7c38, [0x667b] = 0x7c3d, [0x667c] = 0x7c37,
  [0x667d] = 0x7c40, [0x667e] = 0x7e6b, [0x667f] = 0x7e6d, [0x6681] = 0x7e79,
  [0x6682] = 0x7e69, [0x6683] = 0x7e6a, [0x6684] = 0x7f85, [0x6685] = 0x7e73,
  [0x6686] = 0x7fb6, [0x6687] = 0x7fb9, [0x6688] = 0x7fb8, [0x6689] = 0x81d8,
  [0x668a] = 0x85e9, [0x668b] = 0x85dd, [0x668c] = 0x85ea, [0x668d] = 0x85d5,
  [0x668e] = 0x85e4, [0x668f] = 0x85e5, [0x6690] = 0x85f7, [0x6691] = 0x87fb,
  [0x6692] = 0x8805, [0x6693] = 0x880d, [0x6694] = 0x87f9, [0x6695] = 0x87fe,
  [0x6696] = 0x8960, [0x6697] = 0x895f, [0x6698] = 0x8956, [0x6699] = 0x895e,
  [0x669a] = 0x8b41, [0x669b] = 0x8b5c, [0x669c] = 0x8b58, [0x669d] = 0x8b49,
  [0x669e] = 0x8b5a, [0x669f] = 0x8b4e, [0x66a0] = 0x8b4f, [0x66a1] = 0x8b46,
  [0x66a2] = 0x8b59, [0x66a3] = 0x8d08, [0x66a4] = 0x8d0a, [0x66a5] = 0x8e7c,
  [0x66a6] = 0x8e72, [0x66a7] = 0x8e87, [0x66a8] = 0x8e76, [0x66a9] = 0x8e6c,
  [0x66aa] = 0x8e7a, [0x66ab] = 0x8e74, [0x66ac] = 0x8f54, [0x66ad] = 0x8f4e,
  [0x66ae] = 0x8fad, [0x66af] = 0x908a, [0x66b0] = 0x908b, [0x66b1] = 0x91b1,
  [0x66b2] = 0x91ae, [0x66b3] = 0x93e1, [0x66b4] = 0x93d1, [0x66b5] = 0x93df,
  [0x66b6] = 0x93c3, [0x66b7] = 0x93c8, [0x66b8] = 0x93dc, [0x66b9] = 0x93dd,
  [0x66ba] = 0x93d6, [0x66bb] = 0x93e2, [0x66bc] = 0x93cd, [0x66bd] = 0x93d8,
  [0x66be] = 0x93e4, [0x66bf] = 0x93d7, [0x66c0] = 0x93e8, [0x66c1] = 0x95dc,
  [0x66c2] = 0x96b4, [0x66c3] = 0x96e3, [0x66c4] = 0x972a, [0x66c5] = 0x9727,
  [0x66c6] = 0x9761, [0x66c7] = 0x97dc, [0x66c8] = 0x97fb, [0x66c9] = 0x985e,
  [0x66ca] = 0x9858, [0x66cb] = 0x985b, [0x66cc] = 0x98bc, [0x66cd] = 0x9945,
  [0x66ce] = 0x9949, [0x66cf] = 0x9a16, [0x66d0] = 0x9a19, [0x66d1] = 0x9b0d,
  [0x66d2] = 0x9be8, [0x66d3] = 0x9be7, [0x66d4] = 0x9bd6, [0x66d5] = 0x9bdb,
  [0x66d6] = 0x9d89, [0x66d7] = 0x9d61, [0x66d8] = 0x9d72, [0x66d9] = 0x9d6a,
  [0x66da] = 0x9d6c, [0x66db] = 0x9e92, [0x66dc] = 0x9e97, [0x66dd] = 0x9e93,
  [0x66de] = 0x9eb4, [0x66df] = 0x52f8, [0x66e0] = 0x56a8, [0x66e1] = 0x56b7,
  [0x66e2] = 0x56b6, [0x66e3] = 0x56b4, [0x66e4] = 0x56bc, [0x66e5] = 0x58e4,
  [0x66e6] = 0x5b40, [0x66e7] = 0x5b43, [0x66e8] = 0x5b7d, [0x66e9] = 0x5bf6,
  [0x66ea] = 0x5dc9, [0x66eb] = 0x61f8, [0x66ec] = 0x61fa, [0x66ed] = 0x6518,
  [0x66ee] = 0x6514, [0x66ef] = 0x6519, [0x66f0] = 0x66e6, [0x66f1] = 0x6727,
  [0x66f2] = 0x6aec, [0x66f3] = 0x703e, [0x66f4] = 0x7030, [0x66f5] = 0x7032,
  [0x66f6] = 0x7210, [0x66f7] = 0x737b, [0x66f8] = 0x74cf, [0x66f9] = 0x7662,
  [0x66fa] = 0x7665, [0x66fb] = 0x7926, [0x66fc] = 0x792a, [0x66fd] = 0x792c,
  [0x6741] = 0x792b, [0x6742] = 0x7ac7, [0x6743] = 0x7af6, [0x6744] = 0x7c4c,
  [0x6745] = 0x7c43, [0x6746] = 0x7c4d, [0x6747] = 0x7cef, [0x6748] = 0x7cf0,
  [0x6749] = 0x8fae, [0x674a] = 0x7e7d, [0x674b] = 0x7e7c, [0x674c] = 0x7e82,
  [0x674d] = 0x7f4c, [0x674e] = 0x8000, [0x674f] = 0x81da, [0x6750] = 0x8266,
  [0x6751] = 0x85fb, [0x6752] = 0x85f9, [0x6753] = 0x8611, [0x6754] = 0x85fa,
  [0x6755] = 0x8606, [0x6756] = 0x860b, [0x6757] = 0x8607, [0x6758] = 0x860a,
  [0x6759] = 0x8814, [0x675a] = 0x8815, [0x675b] = 0x8964, [0x675c] = 0x89ba,
  [0x675d] = 0x89f8, [0x675e] = 0x8b70, [0x675f] = 0x8b6c, [0x6760] = 0x8b66,
  [0x6761] = 0x8b6f, [0x6762] = 0x8b5f, [0x6763] = 0x8b6b, [0x6764] = 0x8d0f,
  [0x6765] = 0x8d0d, [0x6766] = 0x8e89, [0x6767] = 0x8e81, [0x6768] = 0x8e85,
  [0x6769] = 0x8e82, [0x676a] = 0x91b4, [0x676b] = 0x91cb, [0x676c] = 0x9418,
  [0x676d] = 0x9403, [0x676e] = 0x93fd, [0x676f] = 0x95e1, [0x6770] = 0x9730,
  [0x6771] = 0x98c4, [0x6772] = 0x9952, [0x6773] = 0x9951, [0x6774] = 0x99a8,
  [0x6775] = 0x9a2b, [0x6776] = 0x9a30, [0x6777] = 0x9a37, [0x6778] = 0x9a35,
  [0x6779] = 0x9c13, [0x677a] = 0x9c0d, [0x677b] = 0x9e79, [0x677c] = 0x9eb5,
  [0x677d] = 0x9ee8, [0x677e] = 0x9f2f, [0x677f] = 0x9f5f, [0x6781] = 0x9f63,
  [0x6782] = 0x9f61, [0x6783] = 0x5137, [0x6784] = 0x5138, [0x6785] = 0x56c1,
  [0x6786] = 0x56c0, [0x6787] = 0x56c2, [0x6788] = 0x5914, [0x6789] = 0x5c6c,
  [0x678a] = 0x5dcd, [0x678b] = 0x61fc, [0x678c] = 0x61fe, [0x678d] = 0x651d,
  [0x678e] = 0x651c, [0x678f] = 0x6595, [0x6790] = 0x66e9, [0x6791] = 0x6afb,
  [0x6792] = 0x6b04, [0x6793] = 0x6afa, [0x6794] = 0x6bb2, [0x6795] = 0x704c,
  [0x6796] = 0x721b, [0x6797] = 0x72a7, [0x6798] = 0x74d6, [0x6799] = 0x74d4,
  [0x679a] = 0x7669, [0x679b] = 0x77d3, [0x679c] = 0x7c50, [0x679d] = 0x7e8f,
  [0x679e] = 0x7e8c, [0x679f] = 0x7fbc, [0x67a0] = 0x8617, [0x67a1] = 0x862d,
  [0x67a2] = 0x861a, [0x67a3] = 0x8823, [0x67a4] = 0x8822, [0x67a5] = 0x8821,
  [0x67a6] = 0x881f, [0x67a7] = 0x896a, [0x67a8] = 0x896c, [0x67a9] = 0x89bd,
  [0x67aa] = 0x8b74, [0x67ab] = 0x8b77, [0x67ac] = 0x8b7d, [0x67ad] = 0x8d13,
  [0x67ae] = 0x8e8a, [0x67af] = 0x8e8d, [0x67b0] = 0x8e8b, [0x67b1] = 0x8f5f,
  [0x67b2] = 0x8faf, [0x67b3] = 0x91ba, [0x67b4] = 0x942e, [0x67b5] = 0x9433,
  [0x67b6] = 0x9435, [0x67b7] = 0x943a, [0x67b8] = 0x9438, [0x67b9] = 0x9432,
  [0x67ba] = 0x942b, [0x67bb] = 0x95e2, [0x67bc] = 0x9738, [0x67bd] = 0x9739,
  [0x67be] = 0x9732, [0x67bf] = 0x97ff, [0x67c0] = 0x9867, [0x67c1] = 0x9865,
  [0x67c2] = 0x9957, [0x67c3] = 0x9a45, [0x67c4] = 0x9a43, [0x67c5] = 0x9a40,
  [0x67c6] = 0x9a3e, [0x67c7] = 0x9acf, [0x67c8] = 0x9b54, [0x67c9] = 0x9b51,
  [0x67ca] = 0x9c2d, [0x67cb] = 0x9c25, [0x67cc] = 0x9daf, [0x67cd] = 0x9db4,
  [0x67ce] = 0x9dc2, [0x67cf] = 0x9db8, [0x67d0] = 0x9e9d, [0x67d1] = 0x9eef,
  [0x67d2] = 0x9f19, [0x67d3] = 0x9f5c, [0x67d4] = 0x9f66, [0x67d5] = 0x9f67,
  [0x67d6] = 0x513c, [0x67d7] = 0x513b, [0x67d8] = 0x56c8, [0x67d9] = 0x56ca,
  [0x67da] = 0x56c9, [0x67db] = 0x5b7f, [0x67dc] = 0x5dd4, [0x67dd] = 0x5dd2,
  [0x67de] = 0x5f4e, [0x67df] = 0x61ff, [0x67e0] = 0x6524, [0x67e1] = 0x6b0a,
  [0x67e2] = 0x6b61, [0x67e3] = 0x7051, [0x67e4] = 0x7058, [0x67e5] = 0x7380,
  [0x67e6] = 0x74e4, [0x67e7] = 0x758a, [0x67e8] = 0x766e, [0x67e9] = 0x766c,
  [0x67ea] = 0x79b3, [0x67eb] = 0x7c60, [0x67ec] = 0x7c5f, [0x67ed] = 0x807e,
  [0x67ee] = 0x807d, [0x67ef] = 0x81df, [0x67f0] = 0x8972, [0x67f1] = 0x896f,
  [0x67f2] = 0x89fc, [0x67f3] = 0x8b80, [0x67f4] = 0x8d16, [0x67f5] = 0x8d17,
  [0x67f6] = 0x8e91, [0x67f7] = 0x8e93, [0x67f8] = 0x8f61, [0x67f9] = 0x9148,
  [0x67fa] = 0x9444, [0x67fb] = 0x9451, [0x67fc] = 0x9452, [0x67fd] = 0x973d,
  [0x6841] = 0x973e, [0x6842] = 0x97c3, [0x6843] = 0x97c1, [0x6844] = 0x986b,
  [0x6845] = 0x9955, [0x6846] = 0x9a55, [0x6847] = 0x9a4d, [0x6848] = 0x9ad2,
  [0x6849] = 0x9b1a, [0x684a] = 0x9c49, [0x684b] = 0x9c31, [0x684c] = 0x9c3e,
  [0x684d] = 0x9c3b, [0x684e] = 0x9dd3, [0x684f] = 0x9dd7, [0x6850] = 0x9f34,
  [0x6851] = 0x9f6c, [0x6852] = 0x9f6a, [0x6853] = 0x9f94, [0x6854] = 0x56cc,
  [0x6855] = 0x5dd6, [0x6856] = 0x6200, [0x6857] = 0x6523, [0x6858] = 0x652b,
  [0x6859] = 0x652a, [0x685a] = 0x66ec, [0x685b] = 0x6b10, [0x685c] = 0x74da,
  [0x685d] = 0x7aca, [0x685e] = 0x7c64, [0x685f] = 0x7c63, [0x6860] = 0x7c65,
  [0x6861] = 0x7e93, [0x6862] = 0x7e96, [0x6863] = 0x7e94, [0x6864] = 0x81e2,
  [0x6865] = 0x8638, [0x6866] = 0x863f, [0x6867] = 0x8831, [0x6868] = 0x8b8a,
  [0x6869] = 0x9090, [0x686a] = 0x908f, [0x686b] = 0x9463, [0x686c] = 0x9460,
  [0x686d] = 0x9464, [0x686e] = 0x9768, [0x686f] = 0x986f, [0x6870] = 0x995c,
  [0x6871] = 0x9a5a, [0x6872] = 0x9a5b, [0x6873] = 0x9a57, [0x6874] = 0x9ad3,
  [0x6875] = 0x9ad4, [0x6876] = 0x9ad1, [0x6877] = 0x9c54, [0x6878] = 0x9c57,
  [0x6879] = 0x9c56, [0x687a] = 0x9de5, [0x687b] = 0x9e9f, [0x687c] = 0x9ef4,
  [0x687d] = 0x56d1, [0x687e] = 0x58e9, [0x687f] = 0x652c, [0x6881] = 0x705e,
  [0x6882] = 0x7671, [0x6883] = 0x7672, [0x6884] = 0x77d7, [0x6885] = 0x7f50,
  [0x6886] = 0x7f88, [0x6887] = 0x8836, [0x6888] = 0x8839, [0x6889] = 0x8862,
  [0x688a] = 0x8b93, [0x688b] = 0x8b92, [0x688c] = 0x8b96, [0x688d] = 0x8277,
  [0x688e] = 0x8d1b, [0x688f] = 0x91c0, [0x6890] = 0x946a, [0x6891] = 0x9742,
  [0x6892] = 0x9748, [0x6893] = 0x9744, [0x6894] = 0x97c6, [0x6895] = 0x9870,
  [0x6896] = 0x9a5f, [0x6897] = 0x9b22, [0x6898] = 0x9b58, [0x6899] = 0x9c5f,
  [0x689a] = 0x9df9, [0x689b] = 0x9dfa, [0x689c] = 0x9e7c, [0x689d] = 0x9e7d,
  [0x689e] = 0x9f07, [0x689f] = 0x9f77, [0x68a0] = 0x9f72, [0x68a1] = 0x5ef3,
  [0x68a2] = 0x6b16, [0x68a3] = 0x7063, [0x68a4] = 0x7c6c, [0x68a5] = 0x7c6e,
  [0x68a6] = 0x883b, [0x68a7] = 0x89c0, [0x68a8] = 0x8ea1, [0x68a9] = 0x91c1,
  [0x68aa] = 0x9472, [0x68ab] = 0x9470, [0x68ac] = 0x9871, [0x68ad] = 0x995e,
  [0x68ae] = 0x9ad6, [0x68af] = 0x9b23, [0x68b0] = 0x9ecc, [0x68b1] = 0x7064,
  [0x68b2] = 0x77da, [0x68b3] = 0x8b9a, [0x68b4] = 0x9477, [0x68b5] = 0x97c9,
  [0x68b6] = 0x9a62, [0x68b7] = 0x9a65, [0x68b8] = 0x7e9c, [0x68b9] = 0x8b9c,
  [0x68ba] = 0x8eaa, [0x68bb] = 0x91c5, [0x68bc] = 0x947d, [0x68bd] = 0x947e,
  [0x68be] = 0x947c, [0x68bf] = 0x9c77, [0x68c0] = 0x9c78, [0x68c1] = 0x9ef7,
  [0x68c2] = 0x8c54, [0x68c3] = 0x947f, [0x68c4] = 0x9e1a, [0x68c5] = 0x7228,
  [0x68c6] = 0x9a6a, [0x68c7] = 0x9b31, [0x68c8] = 0x9e1b, [0x68c9] = 0x9e1e,
  [0x68ca] = 0x7c72, [0x68cb] = 0x6491, [0x6941] = 0x4e42, [0x6942] = 0x4e5c,
  [0x6943] = 0x51f5, [0x6944] = 0x531a, [0x6945] = 0x5382, [0x6946] = 0x4e07,
  [0x6947] = 0x4e0c, [0x6948] = 0x4e47, [0x6949] = 0x4e8d, [0x694a] = 0x56d7,
  [0x694b] = 0xfa0c, [0x694c] = 0x5c6e, [0x694d] = 0x5f73, [0x694e] = 0x4e0f,
  [0x694f] = 0x5187, [0x6950] = 0x4e0e, [0x6951] = 0x4e2e, [0x6952] = 0x4e93,
  [0x6953] = 0x4ec2, [0x6954] = 0x4ec9, [0x6955] = 0x4ec8, [0x6956] = 0x5198,
  [0x6957] = 0x52fc, [0x6958] = 0x536c, [0x6959] = 0x53b9, [0x695a] = 0x5720,
  [0x695b] = 0x5903, [0x695c] = 0x592c, [0x695d] = 0x5c10, [0x695e] = 0x5dff,
  [0x695f] = 0x65e1, [0x6960] = 0x6bb3, [0x6961] = 0x6bcc, [0x6962] = 0x6c14,
  [0x6963] = 0x723f, [0x6964] = 0x4e31, [0x6965] = 0x4e3c, [0x6966] = 0x4ee8,
  [0x6967] = 0x4edc, [0x6968] = 0x4ee9, [0x6969] = 0x4ee1, [0x696a] = 0x4edd,
  [0x696b] = 0x4eda, [0x696c] = 0x520c, [0x696d] = 0x531c, [0x696e] = 0x534c,
  [0x696f] = 0x5722, [0x6970] = 0x5723, [0x6971] = 0x5917, [0x6972] = 0x592f,
  [0x6973] = 0x5b81, [0x6974] = 0x5b84, [0x6975] = 0x5c12, [0x6976] = 0x5c3b,
  [0x6977] = 0x5c74, [0x6978] = 0x5c73, [0x6979] = 0x5e04, [0x697a] = 0x5e80,
  [0x697b] = 0x5e82, [0x697c] = 0x5fc9, [0x697d] = 0x6209, [0x697e] = 0x6250,
  [0x697f] = 0x6c15, [0x6981] = 0x6c36, [0x6982] = 0x6c43, [0x6983] = 0x6c3f,
  [0x6984] = 0x6c3b, [0x6985] = 0x72ae, [0x6986] = 0x72b0, [0x6987] = 0x738a,
  [0x6988] = 0x79b8, [0x6989] = 0x808a, [0x698a] = 0x961e, [0x698b] = 0x4f0e,
  [0x698c] = 0x4f18, [0x698d] = 0x4f2c, [0x698e] = 0x4ef5, [0x698f] = 0x4f14,
  [0x6990] = 0x4ef1, [0x6991] = 0x4f00, [0x6992] = 0x4ef7, [0x6993] = 0x4f08,
  [0x6994] = 0x4f1d, [0x6995] = 0x4f02, [0x6996] = 0x4f05, [0x6997] = 0x4f22,
  [0x6998] = 0x4f13, [0x6999] = 0x4f04, [0x699a] = 0x4ef4, [0x699b] = 0x4f12,
  [0x699c] = 0x51b1, [0x699d] = 0x5213, [0x699e] = 0x5209, [0x699f] = 0x5210,
  [0x69a0] = 0x52a6, [0x69a1] = 0x5322, [0x69a2] = 0x531f, [0x69a3] = 0x534d,
  [0x69a4] = 0x538a, [0x69a5] = 0x5407, [0x69a6] = 0x56e1, [0x69a7] = 0x56df,
  [0x69a8] = 0x572e, [0x69a9] = 0x572a, [0x69aa] = 0x5734, [0x69ab] = 0x593c,
  [0x69ac] = 0x5980, [0x69ad] = 0x597c, [0x69ae] = 0x5985, [0x69af] = 0x597b,
  [0x69b0] = 0x597e, [0x69b1] = 0x5977, [0x69b2] = 0x597f, [0x69b3] = 0x5b56,
  [0x69b4] = 0x5c15, [0x69b5] = 0x5c25, [0x69b6] = 0x5c7c, [0x69b7] = 0x5c7a,
  [0x69b8] = 0x5c7b, [0x69b9] = 0x5c7e, [0x69ba] = 0x5ddf, [0x69bb] = 0x5e75,
  [0x69bc] = 0x5e84, [0x69bd] = 0x5f02, [0x69be] = 0x5f1a, [0x69bf] = 0x5f74,
  [0x69c0] = 0x5fd5, [0x69c1] = 0x5fd4, [0x69c2] = 0x5fcf, [0x69c3] = 0x6265,
  [0x69c4] = 0x625c, [0x69c5] = 0x625e, [0x69c6] = 0x6264, [0x69c7] = 0x6261,
  [0x69c8] = 0x6266, [0x69c9] = 0x6262, [0x69ca] = 0x6259, [0x69cb] = 0x6260,
  [0x69cc] = 0x625a, [0x69cd] = 0x65ef, [0x69ce] = 0x65ee, [0x69cf] = 0x673e,
  [0x69d0] = 0x6739, [0x69d1] = 0x6738, [0x69d2] = 0x673b, [0x69d3] = 0x673a,
  [0x69d4] = 0x673f, [0x69d5] = 0x673c, [0x69d6] = 0x6733, [0x69d7] = 0x6c18,
  [0x69d8] = 0x6c46, [0x69d9] = 0x6c52, [0x69da] = 0x6c5c, [0x69db] = 0x6c4f,
  [0x69dc] = 0x6c4a, [0x69dd] = 0x6c54, [0x69de] = 0x6c4b, [0x69df] = 0x6c4c,
  [0x69e0] = 0x7071, [0x69e1] = 0x725e, [0x69e2] = 0x72b4, [0x69e3] = 0x72b5,
  [0x69e4] = 0x738e, [0x69e5] = 0x752a, [0x69e6] = 0x767f, [0x69e7] = 0x7a75,
  [0x69e8] = 0x7f51, [0x69e9] = 0x8278, [0x69ea] = 0x827c, [0x69eb] = 0x8280,
  [0x69ec] = 0x827d, [0x69ed] = 0x827f, [0x69ee] = 0x864d, [0x69ef] = 0x897e,
  [0x69f0] = 0x9099, [0x69f1] = 0x9097, [0x69f2] = 0x9098, [0x69f3] = 0x909b,
  [0x69f4] = 0x9094, [0x69f5] = 0x9622, [0x69f6] = 0x9624, [0x69f7] = 0x9620,
  [0x69f8] = 0x9623, [0x69f9] = 0x4f56, [0x69fa] = 0x4f3b, [0x69fb] = 0x4f62,
  [0x69fc] = 0x4f49, [0x69fd] = 0x4f53, [0x6a41] = 0x4f64, [0x6a42] = 0x4f3e,
  [0x6a43] = 0x4f67, [0x6a44] = 0x4f52, [0x6a45] = 0x4f5f, [0x6a46] = 0x4f41,
  [0x6a47] = 0x4f58, [0x6a48] = 0x4f2d, [0x6a49] = 0x4f33, [0x6a4a] = 0x4f3f,
  [0x6a4b] = 0x4f61, [0x6a4c] = 0x518f, [0x6a4d] = 0x51b9, [0x6a4e] = 0x521c,
  [0x6a4f] = 0x521e, [0x6a50] = 0x5221, [0x6a51] = 0x52ad, [0x6a52] = 0x52ae,
  [0x6a53] = 0x5309, [0x6a54] = 0x5363, [0x6a55] = 0x5372, [0x6a56] = 0x538e,
  [0x6a57] = 0x538f, [0x6a58] = 0x5430, [0x6a59] = 0x5437, [0x6a5a] = 0x542a,
  [0x6a5b] = 0x5454, [0x6a5c] = 0x5445, [0x6a5d] = 0x5419, [0x6a5e] = 0x541c,
  [0x6a5f] = 0x5425, [0x6a60] = 0x5418, [0x6a61] = 0x543d, [0x6a62] = 0x544f,
  [0x6a63] = 0x5441, [0x6a64] = 0x5428, [0x6a65] = 0x5424, [0x6a66] = 0x5447,
  [0x6a67] = 0x56ee, [0x6a68] = 0x56e7, [0x6a69] = 0x56e5, [0x6a6a] = 0x5741,
  [0x6a6b] = 0x5745, [0x6a6c] = 0x574c, [0x6a6d] = 0x5749, [0x6a6e] = 0x574b,
  [0x6a6f] = 0x5752, [0x6a70] = 0x5906, [0x6a71] = 0x5940, [0x6a72] = 0x59a6,
  [0x6a73] = 0x5998, [0x6a74] = 0x59a0, [0x6a75] = 0x5997, [0x6a76] = 0x598e,
  [0x6a77] = 0x59a2, [0x6a78] = 0x5990, [0x6a79] = 0x598f, [0x6a7a] = 0x59a7,
  [0x6a7b] = 0x59a1, [0x6a7c] = 0x5b8e, [0x6a7d] = 0x5b92, [0x6a7e] = 0x5c28,
  [0x6a7f] = 0x5c2a, [0x6a81] = 0x5c8d, [0x6a82] = 0x5c8f, [0x6a83] = 0x5c88,
  [0x6a84] = 0x5c8b, [0x6a85] = 0x5c89, [0x6a86] = 0x5c92, [0x6a87] = 0x5c8a,
  [0x6a88] = 0x5c86, [0x6a89] = 0x5c93, [0x6a8a] = 0x5c95, [0x6a8b] = 0x5de0,
  [0x6a8c] = 0x5e0a, [0x6a8d] = 0x5e0e, [0x6a8e] = 0x5e8b, [0x6a8f] = 0x5e89,
  [0x6a90] = 0x5e8c, [0x6a91] = 0x5e88, [0x6a92] = 0x5e8d, [0x6a93] = 0x5f05,
  [0x6a94] = 0x5f1d, [0x6a95] = 0x5f78, [0x6a96] = 0x5f76, [0x6a97] = 0x5fd2,
  [0x6a98] = 0x5fd1, [0x6a99] = 0x5fd0, [0x6a9a] = 0x5fed, [0x6a9b] = 0x5fe8,
  [0x6a9c] = 0x5fee, [0x6a9d] = 0x5ff3, [0x6a9e] = 0x5fe1, [0x6a9f] = 0x5fe4,
  [0x6aa0] = 0x5fe3, [0x6aa1] = 0x5ffa, [0x6aa2] = 0x5fef, [0x6aa3] = 0x5ff7,
  [0x6aa4] = 0x5ffb, [0x6aa5] = 0x6000, [0x6aa6] = 0x5ff4, [0x6aa7] = 0x623a,
  [0x6aa8] = 0x6283, [0x6aa9] = 0x628c, [0x6aaa] = 0x628e, [0x6aab] = 0x628f,
  [0x6aac] = 0x6294, [0x6aad] = 0x6287, [0x6aae] = 0x6271, [0x6aaf] = 0x627b,
  [0x6ab0] = 0x627a, [0x6ab1] = 0x6270, [0x6ab2] = 0x6281, [0x6ab3] = 0x6288,
  [0x6ab4] = 0x6277, [0x6ab5] = 0x627d, [0x6ab6] = 0x6272, [0x6ab7] = 0x6274,
  [0x6ab8] = 0x6537, [0x6ab9] = 0x65f0, [0x6aba] = 0x65f4, [0x6abb] = 0x65f3,
  [0x6abc] = 0x65f2, [0x6abd] = 0x65f5, [0x6abe] = 0x6745, [0x6abf] = 0x6747,
  [0x6ac0] = 0x6759, [0x6ac1] = 0x6755, [0x6ac2] = 0x674c, [0x6ac3] = 0x6748,
  [0x6ac4] = 0x675d, [0x6ac5] = 0x674d, [0x6ac6] = 0x675a, [0x6ac7] = 0x674b,
  [0x6ac8] = 0x6bd0, [0x6ac9] = 0x6c19, [0x6aca] = 0x6c1a, [0x6acb] = 0x6c78,
  [0x6acc] = 0x6c67, [0x6acd] = 0x6c6b, [0x6ace] = 0x6c84, [0x6acf] = 0x6c8b,
  [0x6ad0] = 0x6c8f, [0x6ad1] = 0x6c71, [0x6ad2] = 0x6c6f, [0x6ad3] = 0x6c69,
  [0x6ad4] = 0x6c9a, [0x6ad5] = 0x6c6d, [0x6ad6] = 0x6c87, [0x6ad7] = 0x6c95,
  [0x6ad8] = 0x6c9c, [0x6ad9] = 0x6c66, [0x6ada] = 0x6c73, [0x6adb] = 0x6c65,
  [0x6adc] = 0x6c7b, [0x6add] = 0x6c8e, [0x6ade] = 0x7074, [0x6adf] = 0x707a,
  [0x6ae0] = 0x7263, [0x6ae1] = 0x72bf, [0x6ae2] = 0x72bd, [0x6ae3] = 0x72c3,
  [0x6ae4] = 0x72c6, [0x6ae5] = 0x72c1, [0x6ae6] = 0x72ba, [0x6ae7] = 0x72c5,
  [0x6ae8] = 0x7395, [0x6ae9] = 0x7397, [0x6aea] = 0x7393, [0x6aeb] = 0x7394,
  [0x6aec] = 0x7392, [0x6aed] = 0x753a, [0x6aee] = 0x7539, [0x6aef] = 0x7594,
  [0x6af0] = 0x7595, [0x6af1] = 0x7681, [0x6af2] = 0x793d, [0x6af3] = 0x8034,
  [0x6af4] = 0x8095, [0x6af5] = 0x8099, [0x6af6] = 0x8090, [0x6af7] = 0x8092,
  [0x6af8] = 0x809c, [0x6af9] = 0x8290, [0x6afa] = 0x828f, [0x6afb] = 0x8285,
  [0x6afc] = 0x828e, [0x6afd] = 0x8291, [0x6b41] = 0x8293, [0x6b42] = 0x828a,
  [0x6b43] = 0x8283, [0x6b44] = 0x8284, [0x6b45] = 0x8c78, [0x6b46] = 0x8fc9,
  [0x6b47] = 0x8fbf, [0x6b48] = 0x909f, [0x6b49] = 0x90a1, [0x6b4a] = 0x90a5,
  [0x6b4b] = 0x909e, [0x6b4c] = 0x90a7, [0x6b4d] = 0x90a0, [0x6b4e] = 0x9630,
  [0x6b4f] = 0x9628, [0x6b50] = 0x962f, [0x6b51] = 0x962d, [0x6b52] = 0x4e33,
  [0x6b53] = 0x4f98, [0x6b54] = 0x4f7c, [0x6b55] = 0x4f85, [0x6b56] = 0x4f7d,
  [0x6b57] = 0x4f80, [0x6b58] = 0x4f87, [0x6b59] = 0x4f76, [0x6b5a] = 0x4f74,
  [0x6b5b] = 0x4f89, [0x6b5c] = 0x4f84, [0x6b5d] = 0x4f77, [0x6b5e] = 0x4f4c,
  [0x6b5f] = 0x4f97, [0x6b60] = 0x4f6a, [0x6b61] = 0x4f9a, [0x6b62] = 0x4f79,
  [0x6b63] = 0x4f81, [0x6b64] = 0x4f78, [0x6b65] = 0x4f90, [0x6b66] = 0x4f9c,
  [0x6b67] = 0x4f94, [0x6b68] = 0x4f9e, [0x6b69] = 0x4f92, [0x6b6a] = 0x4f82,
  [0x6b6b] = 0x4f95, [0x6b6c] = 0x4f6b, [0x6b6d] = 0x4f6e, [0x6b6e] = 0x519e,
  [0x6b6f] = 0x51bc, [0x6b70] = 0x51be, [0x6b71] = 0x5235, [0x6b72] = 0x5232,
  [0x6b73] = 0x5233, [0x6b74] = 0x5246, [0x6b75] = 0x5231, [0x6b76] = 0x52bc,
  [0x6b77] = 0x530a, [0x6b78] = 0x530b, [0x6b79] = 0x533c, [0x6b7a] = 0x5392,
  [0x6b7b] = 0x5394, [0x6b7c] = 0x5487, [0x6b7d] = 0x547f, [0x6b7e] = 0x5481,
  [0x6b7f] = 0x5491, [0x6b81] = 0x5482, [0x6b82] = 0x5488, [0x6b83] = 0x546b,
  [0x6b84] = 0x547a, [0x6b85] = 0x547e, [0x6b86] = 0x5465, [0x6b87] = 0x546c,
  [0x6b88] = 0x5474, [0x6b89] = 0x5466, [0x6b8a] = 0x548d, [0x6b8b] = 0x546f,
  [0x6b8c] = 0x5461, [0x6b8d] = 0x5460, [0x6b8e] = 0x5498, [0x6b8f] = 0x5463,
  [0x6b90] = 0x5467, [0x6b91] = 0x5464, [0x6b92] = 0x56f7, [0x6b93] = 0x56f9,
  [0x6b94] = 0x576f, [0x6b95] = 0x5772, [0x6b96] = 0x576d, [0x6b97] = 0x576b,
  [0x6b98] = 0x5771, [0x6b99] = 0x5770, [0x6b9a] = 0x5776, [0x6b9b] = 0x5780,
  [0x6b9c] = 0x5775, [0x6b9d] = 0x577b, [0x6b9e] = 0x5773, [0x6b9f] = 0x5774,
  [0x6ba0] = 0x5762, [0x6ba1] = 0x5768, [0x6ba2] = 0x577d, [0x6ba3] = 0x590c,
  [0x6ba4] = 0x5945, [0x6ba5] = 0x59b5, [0x6ba6] = 0x59ba, [0x6ba7] = 0x59cf,
  [0x6ba8] = 0x59ce, [0x6ba9] = 0x59b2, [0x6baa] = 0x59cc, [0x6bab] = 0x59c1,
  [0x6bac] = 0x59b6, [0x6bad] = 0x59bc, [0x6bae] = 0x59c3, [0x6baf] = 0x59d6,
  [0x6bb0] = 0x59b1, [0x6bb1] = 0x59bd, [0x6bb2] = 0x59c0, [0x6bb3] = 0x59c8,
  [0x6bb4] = 0x59b4, [0x6bb5] = 0x59c7, [0x6bb6] = 0x5b62, [0x6bb7] = 0x5b65,
  [0x6bb8] = 0x5b93, [0x6bb9] = 0x5b95, [0x6bba] = 0x5c44, [0x6bbb] = 0x5c47,
  [0x6bbc] = 0x5cae, [0x6bbd] = 0x5ca4, [0x6bbe] = 0x5ca0, [0x6bbf] = 0x5cb5,
  [0x6bc0] = 0x5caf, [0x6bc1] = 0x5ca8, [0x6bc2] = 0x5cac, [0x6bc3] = 0x5c9f,
  [0x6bc4] = 0x5ca3, [0x6bc5] = 0x5cad, [0x6bc6] = 0x5ca2, [0x6bc7] = 0x5caa,
  [0x6bc8] = 0x5ca7, [0x6bc9] = 0x5c9d, [0x6bca] = 0x5ca5, [0x6bcb] = 0x5cb6,
  [0x6bcc] = 0x5cb0, [0x6bcd] = 0x5ca6, [0x6bce] = 0x5e17, [0x6bcf] = 0x5e14,
  [0x6bd0] = 0x5e19, [0x6bd1] = 0x5f28, [0x6bd2] = 0x5f22, [0x6bd3] = 0x5f23,
  [0x6bd4] = 0x5f24, [0x6bd5] = 0x5f54, [0x6bd6] = 0x5f82, [0x6bd7] = 0x5f7e,
  [0x6bd8] = 0x5f7d, [0x6bd9] = 0x5fde, [0x6bda] = 0x5fe5, [0x6bdb] = 0x602d,
  [0x6bdc] = 0x6026, [0x6bdd] = 0x6019, [0x6bde] = 0x6032, [0x6bdf] = 0x600b,
  [0x6be0] = 0x6034, [0x6be1] = 0x600a, [0x6be2] = 0x6017, [0x6be3] = 0x6033,
  [0x6be4] = 0x601a, [0x6be5] = 0x601e, [0x6be6] = 0x602c, [0x6be7] = 0x6022,
  [0x6be8] = 0x600d, [0x6be9] = 0x6010, [0x6bea] = 0x602e, [0x6beb] = 0x6013,
  [0x6bec] = 0x6011, [0x6bed] = 0x600c, [0x6bee] = 0x6009, [0x6bef] = 0x601c,
  [0x6bf0] = 0x6214, [0x6bf1] = 0x623d, [0x6bf2] = 0x62ad, [0x6bf3] = 0x62b4,
  [0x6bf4] = 0x62d1, [0x6bf5] = 0x62be, [0x6bf6] = 0x62aa, [0x6bf7] = 0x62b6,
  [0x6bf8] = 0x62ca, [0x6bf9] = 0x62ae, [0x6bfa] = 0x62b3, [0x6bfb] = 0x62af,
  [0x6bfc] = 0x62bb, [0x6bfd] = 0x62a9, [0x6c41] = 0x62b0, [0x6c42] = 0x62b8,
  [0x6c43] = 0x653d, [0x6c44] = 0x65a8, [0x6c45] = 0x65bb, [0x6c46] = 0x6609,
  [0x6c47] = 0x65fc, [0x6c48] = 0x6604, [0x6c49] = 0x6612, [0x6c4a] = 0x6608,
  [0x6c4b] = 0x65fb, [0x6c4c] = 0x6603, [0x6c4d] = 0x660b, [0x6c4e] = 0x660d,
  [0x6c4f] = 0x6605, [0x6c50] = 0x65fd, [0x6c51] = 0x6611, [0x6c52] = 0x6610,
  [0x6c53] = 0x66f6, [0x6c54] = 0x670a, [0x6c55] = 0x6785, [0x6c56] = 0x676c,
  [0x6c57] = 0x678e, [0x6c58] = 0x6792, [0x6c59] = 0x6776, [0x6c5a] = 0x677b,
  [0x6c5b] = 0x6798, [0x6c5c] = 0x6786, [0x6c5d] = 0x6784, [0x6c5e] = 0x6774,
  [0x6c5f] = 0x678d, [0x6c60] = 0x678c, [0x6c61] = 0x677a, [0x6c62] = 0x679f,
  [0x6c63] = 0x6791, [0x6c64] = 0x6799, [0x6c65] = 0x6783, [0x6c66] = 0x677d,
  [0x6c67] = 0x6781, [0x6c68] = 0x6778, [0x6c69] = 0x6779, [0x6c6a] = 0x6794,
  [0x6c6b] = 0x6b25, [0x6c6c] = 0x6b80, [0x6c6d] = 0x6b7e, [0x6c6e] = 0x6bde,
  [0x6c6f] = 0x6c1d, [0x6c70] = 0x6c93, [0x6c71] = 0x6cec, [0x6c72] = 0x6ceb,
  [0x6c73] = 0x6cee, [0x6c74] = 0x6cd9, [0x6c75] = 0x6cb6, [0x6c76] = 0x6cd4,
  [0x6c77] = 0x6cad, [0x6c78] = 0x6ce7, [0x6c79] = 0x6cb7, [0x6c7a] = 0x6cd0,
  [0x6c7b] = 0x6cc2, [0x6c7c] = 0x6cba, [0x6c7d] = 0x6cc3, [0x6c7e] = 0x6cc6,
  [0x6c7f] = 0x6ced, [0x6c81] = 0x6cf2, [0x6c82] = 0x6cd2, [0x6c83] = 0x6cdd,
  [0x6c84] = 0x6cb4, [0x6c85] = 0x6c8a, [0x6c86] = 0x6c9d, [0x6c87] = 0x6c80,
  [0x6c88] = 0x6cde, [0x6c89] = 0x6cc0, [0x6c8a] = 0x6d30, [0x6c8b] = 0x6ccd,
  [0x6c8c] = 0x6cc7, [0x6c8d] = 0x6cb0, [0x6c8e] = 0x6cf9, [0x6c8f] = 0x6ccf,
  [0x6c90] = 0x6ce9, [0x6c91] = 0x6cd1, [0x6c92] = 0x7094, [0x6c93] = 0x7098,
  [0x6c94] = 0x7085, [0x6c95] = 0x7093, [0x6c96] = 0x7086, [0x6c97] = 0x7084,
  [0x6c98] = 0x7091, [0x6c99] = 0x7096, [0x6c9a] = 0x7082, [0x6c9b] = 0x709a,
  [0x6c9c] = 0x7083, [0x6c9d] = 0x726a, [0x6c9e] = 0x72d6, [0x6c9f] = 0x72cb,
  [0x6ca0] = 0x72d8, [0x6ca1] = 0x72c9, [0x6ca2] = 0x72dc, [0x6ca3] = 0x72d2,
  [0x6ca4] = 0x72d4, [0x6ca5] = 0x72da, [0x6ca6] = 0x72cc, [0x6ca7] = 0x72d1,
  [0x6ca8] = 0x73a4, [0x6ca9] = 0x73a1, [0x6caa] = 0x73ad, [0x6cab] = 0x73a6,
  [0x6cac] = 0x73a2, [0x6cad] = 0x73a0, [0x6cae] = 0x73ac, [0x6caf] = 0x739d,
  [0x6cb0] = 0x74dd, [0x6cb1] = 0x74e8, [0x6cb2] = 0x753f, [0x6cb3] = 0x7540,
  [0x6cb4] = 0x753e, [0x6cb5] = 0x758c, [0x6cb6] = 0x7598, [0x6cb7] = 0x76af,
  [0x6cb8] = 0x76f3, [0x6cb9] = 0x76f1, [0x6cba] = 0x76f0, [0x6cbb] = 0x76f5,
  [0x6cbc] = 0x77f8, [0x6cbd] = 0x77fc, [0x6cbe] = 0x77f9, [0x6cbf] = 0x77fb,
  [0x6cc0] = 0x77fa, [0x6cc1] = 0x77f7, [0x6cc2] = 0x7942, [0x6cc3] = 0x793f,
  [0x6cc4] = 0x79c5, [0x6cc5] = 0x7a78, [0x6cc6] = 0x7a7b, [0x6cc7] = 0x7afb,
  [0x6cc8] = 0x7c75, [0x6cc9] = 0x7cfd, [0x6cca] = 0x8035, [0x6ccb] = 0x808f,
  [0x6ccc] = 0x80ae, [0x6ccd] = 0x80a3, [0x6cce] = 0x80b8, [0x6ccf] = 0x80b5,
  [0x6cd0] = 0x80ad, [0x6cd1] = 0x8220, [0x6cd2] = 0x82a0, [0x6cd3] = 0x82c0,
  [0x6cd4] = 0x82ab, [0x6cd5] = 0x829a, [0x6cd6] = 0x8298, [0x6cd7] = 0x829b,
  [0x6cd8] = 0x82b5, [0x6cd9] = 0x82a7, [0x6cda] = 0x82ae, [0x6cdb] = 0x82bc,
  [0x6cdc] = 0x829e, [0x6cdd] = 0x82ba, [0x6cde] = 0x82b4, [0x6cdf] = 0x82a8,
  [0x6ce0] = 0x82a1, [0x6ce1] = 0x82a9, [0x6ce2] = 0x82c2, [0x6ce3] = 0x82a4,
  [0x6ce4] = 0x82c3, [0x6ce5] = 0x82b6, [0x6ce6] = 0x82a2, [0x6ce7] = 0x8670,
  [0x6ce8] = 0x866f, [0x6ce9] = 0x866d, [0x6cea] = 0x866e, [0x6ceb] = 0x8c56,
  [0x6cec] = 0x8fd2, [0x6ced] = 0x8fcb, [0x6cee] = 0x8fd3, [0x6cef] = 0x8fcd,
  [0x6cf0] = 0x8fd6, [0x6cf1] = 0x8fd5, [0x6cf2] = 0x8fd7, [0x6cf3] = 0x90b2,
  [0x6cf4] = 0x90b4, [0x6cf5] = 0x90af, [0x6cf6] = 0x90b3, [0x6cf7] = 0x90b0,
  [0x6cf8] = 0x9639, [0x6cf9] = 0x963d, [0x6cfa] = 0x963c, [0x6cfb] = 0x963a,
  [0x6cfc] = 0x9643, [0x6cfd] = 0x4fcd, [0x6d41] = 0x4fc5, [0x6d42] = 0x4fd3,
  [0x6d43] = 0x4fb2, [0x6d44] = 0x4fc9, [0x6d45] = 0x4fcb, [0x6d46] = 0x4fc1,
  [0x6d47] = 0x4fd4, [0x6d48] = 0x4fdc, [0x6d49] = 0x4fd9, [0x6d4a] = 0x4fbb,
  [0x6d4b] = 0x4fb3, [0x6d4c] = 0x4fdb, [0x6d4d] = 0x4fc7, [0x6d4e] = 0x4fd6,
  [0x6d4f] = 0x4fba, [0x6d50] = 0x4fc0, [0x6d51] = 0x4fb9, [0x6d52] = 0x4fec,
  [0x6d53] = 0x5244, [0x6d54] = 0x5249, [0x6d55] = 0x52c0, [0x6d56] = 0x52c2,
  [0x6d57] = 0x533d, [0x6d58] = 0x537c, [0x6d59] = 0x5397, [0x6d5a] = 0x5396,
  [0x6d5b] = 0x5399, [0x6d5c] = 0x5398, [0x6d5d] = 0x54ba, [0x6d5e] = 0x54a1,
  [0x6d5f] = 0x54ad, [0x6d60] = 0x54a5, [0x6d61] = 0x54cf, [0x6d62] = 0x54c3,
  [0x6d63] = 0x830d, [0x6d64] = 0x54b7, [0x6d65] = 0x54ae, [0x6d66] = 0x54d6,
  [0x6d67] = 0x54b6, [0x6d68] = 0x54c5, [0x6d69] = 0x54c6, [0x6d6a] = 0x54a0,
  [0x6d6b] = 0x5470, [0x6d6c] = 0x54bc, [0x6d6d] = 0x54a2, [0x6d6e] = 0x54be,
  [0x6d6f] = 0x5472, [0x6d70] = 0x54de, [0x6d71] = 0x54b0, [0x6d72] = 0x57b5,
  [0x6d73] = 0x579e, [0x6d74] = 0x579f, [0x6d75] = 0x57a4, [0x6d76] = 0x578c,
  [0x6d77] = 0x5797, [0x6d78] = 0x579d, [0x6d79] = 0x579b, [0x6d7a] = 0x5794,
  [0x6d7b] = 0x5798, [0x6d7c] = 0x578f, [0x6d7d] = 0x5799, [0x6d7e] = 0x57a5,
  [0x6d7f] = 0x579a, [0x6d81] = 0x5795, [0x6d82] = 0x58f4, [0x6d83] = 0x590d,
  [0x6d84] = 0x5953, [0x6d85] = 0x59e1, [0x6d86] = 0x59de, [0x6d87] = 0x59ee,
  [0x6d88] = 0x5a00, [0x6d89] = 0x59f1, [0x6d8a] = 0x59dd, [0x6d8b] = 0x59fa,
  [0x6d8c] = 0x59fd, [0x6d8d] = 0x59fc, [0x6d8e] = 0x59f6, [0x6d8f] = 0x59e4,
  [0x6d90] = 0x59f2, [0x6d91] = 0x59f7, [0x6d92] = 0x59db, [0x6d93] = 0x59e9,
  [0x6d94] = 0x59f3, [0x6d95] = 0x59f5, [0x6d96] = 0x59e0, [0x6d97] = 0x59fe,
  [0x6d98] = 0x59f4, [0x6d99] = 0x59ed, [0x6d9a] = 0x5ba8, [0x6d9b] = 0x5c4c,
  [0x6d9c] = 0x5cd0, [0x6d9d] = 0x5cd8, [0x6d9e] = 0x5ccc, [0x6d9f] = 0x5cd7,
  [0x6da0] = 0x5ccb, [0x6da1] = 0x5cdb, [0x6da2] = 0x5cde, [0x6da3] = 0x5cda,
  [0x6da4] = 0x5cc9, [0x6da5] = 0x5cc7, [0x6da6] = 0x5cca, [0x6da7] = 0x5cd6,
  [0x6da8] = 0x5cd3, [0x6da9] = 0x5cd4, [0x6daa] = 0x5ccf, [0x6dab] = 0x5cc8,
  [0x6dac] = 0x5cc6, [0x6dad] = 0x5cce, [0x6dae] = 0x5cdf, [0x6daf] = 0x5cf8,
  [0x6db0] = 0x5df9, [0x6db1] = 0x5e21, [0x6db2] = 0x5e22, [0x6db3] = 0x5e23,
  [0x6db4] = 0x5e20, [0x6db5] = 0x5e24, [0x6db6] = 0x5eb0, [0x6db7] = 0x5ea4,
  [0x6db8] = 0x5ea2, [0x6db9] = 0x5e9b, [0x6dba] = 0x5ea3, [0x6dbb] = 0x5ea5,
  [0x6dbc] = 0x5f07, [0x6dbd] = 0x5f2e, [0x6dbe] = 0x5f56, [0x6dbf] = 0x5f86,
  [0x6dc0] = 0x6037, [0x6dc1] = 0x6039, [0x6dc2] = 0x6054, [0x6dc3] = 0x6072,
  [0x6dc4] = 0x605e, [0x6dc5] = 0x6045, [0x6dc6] = 0x6053, [0x6dc7] = 0x6047,
  [0x6dc8] = 0x6049, [0x6dc9] = 0x605b, [0x6dca] = 0x604c, [0x6dcb] = 0x6040,
  [0x6dcc] = 0x6042, [0x6dcd] = 0x605f, [0x6dce] = 0x6024, [0x6dcf] = 0x6044,
  [0x6dd0] = 0x6058, [0x6dd1] = 0x6066, [0x6dd2] = 0x606e, [0x6dd3] = 0x6242,
  [0x6dd4] = 0x6243, [0x6dd5] = 0x62cf, [0x6dd6] = 0x630d, [0x6dd7] = 0x630b,
  [0x6dd8] = 0x62f5, [0x6dd9] = 0x630e, [0x6dda] = 0x6303, [0x6ddb] = 0x62eb,
  [0x6ddc] = 0x62f9, [0x6ddd] = 0x630f, [0x6dde] = 0x630c, [0x6ddf] = 0x62f8,
  [0x6de0] = 0x62f6, [0x6de1] = 0x6300, [0x6de2] = 0x6313, [0x6de3] = 0x6314,
  [0x6de4] = 0x62fa, [0x6de5] = 0x6315, [0x6de6] = 0x62fb, [0x6de7] = 0x62f0,
  [0x6de8] = 0x6541, [0x6de9] = 0x6543, [0x6dea] = 0x65aa, [0x6deb] = 0x65bf,
  [0x6dec] = 0x6636, [0x6ded] = 0x6621, [0x6dee] = 0x6632, [0x6def] = 0x6635,
  [0x6df0] = 0x661c, [0x6df1] = 0x6626, [0x6df2] = 0x6622, [0x6df3] = 0x6633,
  [0x6df4] = 0x662b, [0x6df5] = 0x663a, [0x6df6] = 0x661d, [0x6df7] = 0x6634,
  [0x6df8] = 0x6639, [0x6df9] = 0x662e, [0x6dfa] = 0x670f, [0x6dfb] = 0x6710,
  [0x6dfc] = 0x67c1, [0x6dfd] = 0x67f2, [0x6e41] = 0x67c8, [0x6e42] = 0x67ba,
  [0x6e43] = 0x67dc, [0x6e44] = 0x67bb, [0x6e45] = 0x67f8, [0x6e46] = 0x67d8,
  [0x6e47] = 0x67c0, [0x6e48] = 0x67b7, [0x6e49] = 0x67c5, [0x6e4a] = 0x67eb,
  [0x6e4b] = 0x67e4, [0x6e4c] = 0x67df, [0x6e4d] = 0x67b5, [0x6e4e] = 0x67cd,
  [0x6e4f] = 0x67b3, [0x6e50] = 0x67f7, [0x6e51] = 0x67f6, [0x6e52] = 0x67ee,
  [0x6e53] = 0x67e3, [0x6e54] = 0x67c2, [0x6e55] = 0x67b9, [0x6e56] = 0x67ce,
  [0x6e57] = 0x67e7, [0x6e58] = 0x67f0, [0x6e59] = 0x67b2, [0x6e5a] = 0x67fc,
  [0x6e5b] = 0x67c6, [0x6e5c] = 0x67ed, [0x6e5d] = 0x67cc, [0x6e5e] = 0x67ae,
  [0x6e5f] = 0x67e6, [0x6e60] = 0x67db, [0x6e61] = 0x67fa, [0x6e62] = 0x67c9,
  [0x6e63] = 0x67ca, [0x6e64] = 0x67c3, [0x6e65] = 0x67ea, [0x6e66] = 0x67cb,
  [0x6e67] = 0x6b28, [0x6e68] = 0x6b82, [0x6e69] = 0x6b84, [0x6e6a] = 0x6bb6,
  [0x6e6b] = 0x6bd6, [0x6e6c] = 0x6bd8, [0x6e6d] = 0x6be0, [0x6e6e] = 0x6c20,
  [0x6e6f] = 0x6c21, [0x6e70] = 0x6d28, [0x6e71] = 0x6d34, [0x6e72] = 0x6d2d,
  [0x6e73] = 0x6d1f, [0x6e74] = 0x6d3c, [0x6e75] = 0x6d3f, [0x6e76] = 0x6d12,
  [0x6e77] = 0x6d0a, [0x6e78] = 0x6cda, [0x6e79] = 0x6d33, [0x6e7a] = 0x6d04,
  [0x6e7b] = 0x6d19, [0x6e7c] = 0x6d3a, [0x6e7d] = 0x6d1a, [0x6e7e] = 0x6d11,
  [0x6e7f] = 0x6d00, [0x6e81] = 0x6d1d, [0x6e82] = 0x6d42, [0x6e83] = 0x6d01,
  [0x6e84] = 0x6d18, [0x6e85] = 0x6d37, [0x6e86] = 0x6d03, [0x6e87] = 0x6d0f,
  [0x6e88] = 0x6d40, [0x6e89] = 0x6d07, [0x6e8a] = 0x6d20, [0x6e8b] = 0x6d2c,
  [0x6e8c] = 0x6d08, [0x6e8d] = 0x6d22, [0x6e8e] = 0x6d09, [0x6e8f] = 0x6d10,
  [0x6e90] = 0x70b7, [0x6e91] = 0x709f, [0x6e92] = 0x70be, [0x6e93] = 0x70b1,
  [0x6e94] = 0x70b0, [0x6e95] = 0x70a1, [0x6e96] = 0x70b4, [0x6e97] = 0x70b5,
  [0x6e98] = 0x70a9, [0x6e99] = 0x7241, [0x6e9a] = 0x7249, [0x6e9b] = 0x724a,
  [0x6e9c] = 0x726c, [0x6e9d] = 0x7270, [0x6e9e] = 0x7273, [0x6e9f] = 0x726e,
  [0x6ea0] = 0x72ca, [0x6ea1] = 0x72e4, [0x6ea2] = 0x72e8, [0x6ea3] = 0x72eb,
  [0x6ea4] = 0x72df, [0x6ea5] = 0x72ea, [0x6ea6] = 0x72e6, [0x6ea7] = 0x72e3,
  [0x6ea8] = 0x7385, [0x6ea9] = 0x73cc, [0x6eaa] = 0x73c2, [0x6eab] = 0x73c8,
  [0x6eac] = 0x73c5, [0x6ead] = 0x73b9, [0x6eae] = 0x73b6, [0x6eaf] = 0x73b5,
  [0x6eb0] = 0x73b4, [0x6eb1] = 0x73eb, [0x6eb2] = 0x73bf, [0x6eb3] = 0x73c7,
  [0x6eb4] = 0x73be, [0x6eb5] = 0x73c3, [0x6eb6] = 0x73c6, [0x6eb7] = 0x73b8,
  [0x6eb8] = 0x73cb, [0x6eb9] = 0x74ec, [0x6eba] = 0x74ee, [0x6ebb] = 0x752e,
  [0x6ebc] = 0x7547, [0x6ebd] = 0x7548, [0x6ebe] = 0x75a7, [0x6ebf] = 0x75aa,
  [0x6ec0] = 0x7679, [0x6ec1] = 0x76c4, [0x6ec2] = 0x7708, [0x6ec3] = 0x7703,
  [0x6ec4] = 0x7704, [0x6ec5] = 0x7705, [0x6ec6] = 0x770a, [0x6ec7] = 0x76f7,
  [0x6ec8] = 0x76fb, [0x6ec9] = 0x76fa, [0x6eca] = 0x77e7, [0x6ecb] = 0x77e8,
  [0x6ecc] = 0x7806, [0x6ecd] = 0x7811, [0x6ece] = 0x7812, [0x6ecf] = 0x7805,
  [0x6ed0] = 0x7810, [0x6ed1] = 0x780f, [0x6ed2] = 0x780e, [0x6ed3] = 0x7809,
  [0x6ed4] = 0x7803, [0x6ed5] = 0x7813, [0x6ed6] = 0x794a, [0x6ed7] = 0x794c,
  [0x6ed8] = 0x794b, [0x6ed9] = 0x7945, [0x6eda] = 0x7944, [0x6edb] = 0x79d5,
  [0x6edc] = 0x79cd, [0x6edd] = 0x79cf, [0x6ede] = 0x79d6, [0x6edf] = 0x79ce,
  [0x6ee0] = 0x7a80, [0x6ee1] = 0x7a7e, [0x6ee2] = 0x7ad1, [0x6ee3] = 0x7b00,
  [0x6ee4] = 0x7b01, [0x6ee5] = 0x7c7a, [0x6ee6] = 0x7c78, [0x6ee7] = 0x7c79,
  [0x6ee8] = 0x7c7f, [0x6ee9] = 0x7c80, [0x6eea] = 0x7c81, [0x6eeb] = 0x7d03,
  [0x6eec] = 0x7d08, [0x6eed] = 0x7d01, [0x6eee] = 0x7f58, [0x6eef] = 0x7f91,
  [0x6ef0] = 0x7f8d, [0x6ef1] = 0x7fbe, [0x6ef2] = 0x8007, [0x6ef3] = 0x800e,
  [0x6ef4] = 0x800f, [0x6ef5] = 0x8014, [0x6ef6] = 0x8037, [0x6ef7] = 0x80d8,
  [0x6ef8] = 0x80c7, [0x6ef9] = 0x80e0, [0x6efa] = 0x80d1, [0x6efb] = 0x80c8,
  [0x6efc] = 0x80c2, [0x6efd] = 0x80d0, [0x6f41] = 0x80c5, [0x6f42] = 0x80e3,
  [0x6f43] = 0x80d9, [0x6f44] = 0x80dc, [0x6f45] = 0x80ca, [0x6f46] = 0x80d5,
  [0x6f47] = 0x80c9, [0x6f48] = 0x80cf, [0x6f49] = 0x80d7, [0x6f4a] = 0x80e6,
  [0x6f4b] = 0x80cd, [0x6f4c] = 0x81ff, [0x6f4d] = 0x8221, [0x6f4e] = 0x8294,
  [0x6f4f] = 0x82d9, [0x6f50] = 0x82fe, [0x6f51] = 0x82f9, [0x6f52] = 0x8307,
  [0x6f53] = 0x82e8, [0x6f54] = 0x8300, [0x6f55] = 0x82d5, [0x6f56] = 0x833a,
  [0x6f57] = 0x82eb, [0x6f58] = 0x82d6, [0x6f59] = 0x82f4, [0x6f5a] = 0x82ec,
  [0x6f5b] = 0x82e1, [0x6f5c] = 0x82f2, [0x6f5d] = 0x82f5, [0x6f5e] = 0x830c,
  [0x6f5f] = 0x82fb, [0x6f60] = 0x82f6, [0x6f61] = 0x82f0, [0x6f62] = 0x82ea,
  [0x6f63] = 0x82e4, [0x6f64] = 0x82e0, [0x6f65] = 0x82fa, [0x6f66] = 0x82f3,
  [0x6f67] = 0x82ed, [0x6f68] = 0x8677, [0x6f69] = 0x8674, [0x6f6a] = 0x867c,
  [0x6f6b] = 0x8673, [0x6f6c] = 0x8841, [0x6f6d] = 0x884e, [0x6f6e] = 0x8867,
  [0x6f6f] = 0x886a, [0x6f70] = 0x8869, [0x6f71] = 0x89d3, [0x6f72] = 0x8a04,
  [0x6f73] = 0x8a07, [0x6f74] = 0x8d72, [0x6f75] = 0x8fe3, [0x6f76] = 0x8fe1,
  [0x6f77] = 0x8fee, [0x6f78] = 0x8fe0, [0x6f79] = 0x90f1, [0x6f7a] = 0x90bd,
  [0x6f7b] = 0x90bf, [0x6f7c] = 0x90d5, [0x6f7d] = 0x90c5, [0x6f7e] = 0x90be,
  [0x6f7f] = 0x90c7, [0x6f81] = 0x90cb, [0x6f82] = 0x90c8, [0x6f83] = 0x91d4,
  [0x6f84] = 0x91d3, [0x6f85] = 0x9654, [0x6f86] = 0x964f, [0x6f87] = 0x9651,
  [0x6f88] = 0x9653, [0x6f89] = 0x964a, [0x6f8a] = 0x964e, [0x6f8b] = 0x501e,
  [0x6f8c] = 0x5005, [0x6f8d] = 0x5007, [0x6f8e] = 0x5013, [0x6f8f] = 0x5022,
  [0x6f90] = 0x5030, [0x6f91] = 0x501b, [0x6f92] = 0x4ff5, [0x6f93] = 0x4ff4,
  [0x6f94] = 0x5033, [0x6f95] = 0x5037, [0x6f96] = 0x502c, [0x6f97] = 0x4ff6,
  [0x6f98] = 0x4ff7, [0x6f99] = 0x5017, [0x6f9a] = 0x501c, [0x6f9b] = 0x5020,
  [0x6f9c] = 0x5027, [0x6f9d] = 0x5035, [0x6f9e] = 0x502f, [0x6f9f] = 0x5031,
  [0x6fa0] = 0x500e, [0x6fa1] = 0x515a, [0x6fa2] = 0x5194, [0x6fa3] = 0x5193,
  [0x6fa4] = 0x51ca, [0x6fa5] = 0x51c4, [0x6fa6] = 0x51c5, [0x6fa7] = 0x51c8,
  [0x6fa8] = 0x51ce, [0x6fa9] = 0x5261, [0x6faa] = 0x525a, [0x6fab] = 0x5252,
  [0x6fac] = 0x525e, [0x6fad] = 0x525f, [0x6fae] = 0x5255, [0x6faf] = 0x5262,
  [0x6fb0] = 0x52cd, [0x6fb1] = 0x530e, [0x6fb2] = 0x539e, [0x6fb3] = 0x5526,
  [0x6fb4] = 0x54e2, [0x6fb5] = 0x5517, [0x6fb6] = 0x5512, [0x6fb7] = 0x54e7,
  [0x6fb8] = 0x54f3, [0x6fb9] = 0x54e4, [0x6fba] = 0x551a, [0x6fbb] = 0x54ff,
  [0x6fbc] = 0x5504, [0x6fbd] = 0x5508, [0x6fbe] = 0x54eb, [0x6fbf] = 0x5511,
  [0x6fc0] = 0x5505, [0x6fc1] = 0x54f1, [0x6fc2] = 0x550a, [0x6fc3] = 0x54fb,
  [0x6fc4] = 0x54f7, [0x6fc5] = 0x54f8, [0x6fc6] = 0x54e0, [0x6fc7] = 0x550e,
  [0x6fc8] = 0x5503, [0x6fc9] = 0x550b, [0x6fca] = 0x5701, [0x6fcb] = 0x5702,
  [0x6fcc] = 0x57cc, [0x6fcd] = 0x5832, [0x6fce] = 0x57d5, [0x6fcf] = 0x57d2,
  [0x6fd0] = 0x57ba, [0x6fd1] = 0x57c6, [0x6fd2] = 0x57bd, [0x6fd3] = 0x57bc,
  [0x6fd4] = 0x57b8, [0x6fd5] = 0x57b6, [0x6fd6] = 0x57bf, [0x6fd7] = 0x57c7,
  [0x6fd8] = 0x57d0, [0x6fd9] = 0x57b9, [0x6fda] = 0x57c1, [0x6fdb] = 0x590e,
  [0x6fdc] = 0x594a, [0x6fdd] = 0x5a19, [0x6fde] = 0x5a16, [0x6fdf] = 0x5a2d,
  [0x6fe0] = 0x5a2e, [0x6fe1] = 0x5a15, [0x6fe2] = 0x5a0f, [0x6fe3] = 0x5a17,
  [0x6fe4] = 0x5a0a, [0x6fe5] = 0x5a1e, [0x6fe6] = 0x5a33, [0x6fe7] = 0x5b6c,
  [0x6fe8] = 0x5ba7, [0x6fe9] = 0x5bad, [0x6fea] = 0x5bac, [0x6feb] = 0x5c03,
  [0x6fec] = 0x5c56, [0x6fed] = 0x5c54, [0x6fee] = 0x5cec, [0x6fef] = 0x5cff,
  [0x6ff0] = 0x5cee, [0x6ff1] = 0x5cf1, [0x6ff2] = 0x5cf7, [0x6ff3] = 0x5d00,
  [0x6ff4] = 0x5cf9, [0x6ff5] = 0x5e29, [0x6ff6] = 0x5e28, [0x6ff7] = 0x5ea8,
  [0x6ff8] = 0x5eae, [0x6ff9] = 0x5eaa, [0x6ffa] = 0x5eac, [0x6ffb] = 0x5f33,
  [0x6ffc] = 0x5f30, [0x6ffd] = 0x5f67, [0x7041] = 0x605d, [0x7042] = 0x605a,
  [0x7043] = 0x6067, [0x7044] = 0x6041, [0x7045] = 0x60a2, [0x7046] = 0x6088,
  [0x7047] = 0x6080, [0x7048] = 0x6092, [0x7049] = 0x6081, [0x704a] = 0x609d,
  [0x704b] = 0x6083, [0x704c] = 0x6095, [0x704d] = 0x609b, [0x704e] = 0x6097,
  [0x704f] = 0x6087, [0x7050] = 0x609c, [0x7051] = 0x608e, [0x7052] = 0x6219,
  [0x7053] = 0x6246, [0x7054] = 0x62f2, [0x7055] = 0x6310, [0x7056] = 0x6356,
  [0x7057] = 0x632c, [0x7058] = 0x6344, [0x7059] = 0x6345, [0x705a] = 0x6336,
  [0x705b] = 0x6343, [0x705c] = 0x63e4, [0x705d] = 0x6339, [0x705e] = 0x634b,
  [0x705f] = 0x634a, [0x7060] = 0x633c, [0x7061] = 0x6329, [0x7062] = 0x6341,
  [0x7063] = 0x6334, [0x7064] = 0x6358, [0x7065] = 0x6354, [0x7066] = 0x6359,
  [0x7067] = 0x632d, [0x7068] = 0x6347, [0x7069] = 0x6333, [0x706a] = 0x635a,
  [0x706b] = 0x6351, [0x706c] = 0x6338, [0x706d] = 0x6357, [0x706e] = 0x6340,
  [0x706f] = 0x6348, [0x7070] = 0x654a, [0x7071] = 0x6546, [0x7072] = 0x65c6,
  [0x7073] = 0x65c3, [0x7074] = 0x65c4, [0x7075] = 0x65c2, [0x7076] = 0x664a,
  [0x7077] = 0x665f, [0x7078] = 0x6647, [0x7079] = 0x6651, [0x707a] = 0x6712,
  [0x707b] = 0x6713, [0x707c] = 0x681f, [0x707d] = 0x681a, [0x707e] = 0x6849,
  [0x707f] = 0x6832, [0x7081] = 0x6833, [0x7082] = 0x683b, [0x7083] = 0x684b,
  [0x7084] = 0x684f, [0x7085] = 0x6816, [0x7086] = 0x6831, [0x7087] = 0x681c,
  [0x7088] = 0x6835, [0x7089] = 0x682b, [0x708a] = 0x682d, [0x708b] = 0x682f,
  [0x708c] = 0x684e, [0x708d] = 0x6844, [0x708e] = 0x6834, [0x708f] = 0x681d,
  [0x7090] = 0x6812, [0x7091] = 0x6814, [0x7092] = 0x6826, [0x7093] = 0x6828,
  [0x7094] = 0x682e, [0x7095] = 0x684d, [0x7096] = 0x683a, [0x7097] = 0x6825,
  [0x7098] = 0x6820, [0x7099] = 0x6b2c, [0x709a] = 0x6b2f, [0x709b] = 0x6b2d,
  [0x709c] = 0x6b31, [0x709d] = 0x6b34, [0x709e] = 0x6b6d, [0x709f] = 0x8082,
  [0x70a0] = 0x6b88, [0x70a1] = 0x6be6, [0x70a2] = 0x6be4, [0x70a3] = 0x6be8,
  [0x70a4] = 0x6be3, [0x70a5] = 0x6be2, [0x70a6] = 0x6be7, [0x70a7] = 0x6c25,
  [0x70a8] = 0x6d7a, [0x70a9] = 0x6d63, [0x70aa] = 0x6d64, [0x70ab] = 0x6d76,
  [0x70ac] = 0x6d0d, [0x70ad] = 0x6d61, [0x70ae] = 0x6d92, [0x70af] = 0x6d58,
  [0x70b0] = 0x6d62, [0x70b1] = 0x6d6d, [0x70b2] = 0x6d6f, [0x70b3] = 0x6d91,
  [0x70b4] = 0x6d8d, [0x70b5] = 0x6def, [0x70b6] = 0x6d7f, [0x70b7] = 0x6d86,
  [0x70b8] = 0x6d5e, [0x70b9] = 0x6d67, [0x70ba] = 0x6d60, [0x70bb] = 0x6d97,
  [0x70bc] = 0x6d70, [0x70bd] = 0x6d7c, [0x70be] = 0x6d5f, [0x70bf] = 0x6d82,
  [0x70c0] = 0x6d98, [0x70c1] = 0x6d2f, [0x70c2] = 0x6d68, [0x70c3] = 0x6d8b,
  [0x70c4] = 0x6d7e, [0x70c5] = 0x6d80, [0x70c6] = 0x6d84, [0x70c7] = 0x6d16,
  [0x70c8] = 0x6d83, [0x70c9] = 0x6d7b, [0x70ca] = 0x6d7d, [0x70cb] = 0x6d75,
  [0x70cc] = 0x6d90, [0x70cd] = 0x70dc, [0x70ce] = 0x70d3, [0x70cf] = 0x70d1,
  [0x70d0] = 0x70dd, [0x70d1] = 0x70cb, [0x70d2] = 0x7f39, [0x70d3] = 0x70e2,
  [0x70d4] = 0x70d7, [0x70d5] = 0x70d2, [0x70d6] = 0x70de, [0x70d7] = 0x70e0,
  [0x70d8] = 0x70d4, [0x70d9] = 0x70cd, [0x70da] = 0x70c5, [0x70db] = 0x70c6,
  [0x70dc] = 0x70c7, [0x70dd] = 0x70da, [0x70de] = 0x70ce, [0x70df] = 0x70e1,
  [0x70e0] = 0x7242, [0x70e1] = 0x7278, [0x70e2] = 0x7277, [0x70e3] = 0x7276,
  [0x70e4] = 0x7300, [0x70e5] = 0x72fa, [0x70e6] = 0x72f4, [0x70e7] = 0x72fe,
  [0x70e8] = 0x72f6, [0x70e9] = 0x72f3, [0x70ea] = 0x72fb, [0x70eb] = 0x7301,
  [0x70ec] = 0x73d3, [0x70ed] = 0x73d9, [0x70ee] = 0x73e5, [0x70ef] = 0x73d6,
  [0x70f0] = 0x73bc, [0x70f1] = 0x73e7, [0x70f2] = 0x73e3, [0x70f3] = 0x73e9,
  [0x70f4] = 0x73dc, [0x70f5] = 0x73d2, [0x70f6] = 0x73db, [0x70f7] = 0x73d4,
  [0x70f8] = 0x73dd, [0x70f9] = 0x73da, [0x70fa] = 0x73d7, [0x70fb] = 0x73d8,
  [0x70fc] = 0x73e8, [0x70fd] = 0x74de, [0x7141] = 0x74df, [0x7142] = 0x74f4,
  [0x7143] = 0x74f5, [0x7144] = 0x7521, [0x7145] = 0x755b, [0x7146] = 0x755f,
  [0x7147] = 0x75b0, [0x7148] = 0x75c1, [0x7149] = 0x75bb, [0x714a] = 0x75c4,
  [0x714b] = 0x75c0, [0x714c] = 0x75bf, [0x714d] = 0x75b6, [0x714e] = 0x75ba,
  [0x714f] = 0x768a, [0x7150] = 0x76c9, [0x7151] = 0x771d, [0x7152] = 0x771b,
  [0x7153] = 0x7710, [0x7154] = 0x7713, [0x7155] = 0x7712, [0x7156] = 0x7723,
  [0x7157] = 0x7711, [0x7158] = 0x7715, [0x7159] = 0x7719, [0x715a] = 0x771a,
  [0x715b] = 0x7722, [0x715c] = 0x7727, [0x715d] = 0x7823, [0x715e] = 0x782c,
  [0x715f] = 0x7822, [0x7160] = 0x7835, [0x7161] = 0x782f, [0x7162] = 0x7828,
  [0x7163] = 0x782e, [0x7164] = 0x782b, [0x7165] = 0x7821, [0x7166] = 0x7829,
  [0x7167] = 0x7833, [0x7168] = 0x782a, [0x7169] = 0x7831, [0x716a] = 0x7954,
  [0x716b] = 0x795b, [0x716c] = 0x794f, [0x716d] = 0x795c, [0x716e] = 0x7953,
  [0x716f] = 0x7952, [0x7170] = 0x7951, [0x7171] = 0x79eb, [0x7172] = 0x79ec,
  [0x7173] = 0x79e0, [0x7174] = 0x79ee, [0x7175] = 0x79ed, [0x7176] = 0x79ea,
  [0x7177] = 0x79dc, [0x7178] = 0x79de, [0x7179] = 0x79dd, [0x717a] = 0x7a86,
  [0x717b] = 0x7a89, [0x717c] = 0x7a85, [0x717d] = 0x7a8b, [0x717e] = 0x7a8c,
  [0x717f] = 0x7a8a, [0x7181] = 0x7a87, [0x7182] = 0x7ad8, [0x7183] = 0x7b10,
  [0x7184] = 0x7b04, [0x7185] = 0x7b13, [0x7186] = 0x7b05, [0x7187] = 0x7b0f,
  [0x7188] = 0x7b08, [0x7189] = 0x7b0a, [0x718a] = 0x7b0e, [0x718b] = 0x7b09,
  [0x718c] = 0x7b12, [0x718d] = 0x7c84, [0x718e] = 0x7c91, [0x718f] = 0x7c8a,
  [0x7190] = 0x7c8c, [0x7191] = 0x7c88, [0x7192] = 0x7c8d, [0x7193] = 0x7c85,
  [0x7194] = 0x7d1e, [0x7195] = 0x7d1d, [0x7196] = 0x7d11, [0x7197] = 0x7d0e,
  [0x7198] = 0x7d18, [0x7199] = 0x7d16, [0x719a] = 0x7d13, [0x719b] = 0x7d1f,
  [0x719c] = 0x7d12, [0x719d] = 0x7d0f, [0x719e] = 0x7d0c, [0x719f] = 0x7f5c,
  [0x71a0] = 0x7f61, [0x71a1] = 0x7f5e, [0x71a2] = 0x7f60, [0x71a3] = 0x7f5d,
  [0x71a4] = 0x7f5b, [0x71a5] = 0x7f96, [0x71a6] = 0x7f92, [0x71a7] = 0x7fc3,
  [0x71a8] = 0x7fc2, [0x71a9] = 0x7fc0, [0x71aa] = 0x8016, [0x71ab] = 0x803e,
  [0x71ac] = 0x8039, [0x71ad] = 0x80fa, [0x71ae] = 0x80f2, [0x71af] = 0x80f9,
  [0x71b0] = 0x80f5, [0x71b1] = 0x8101, [0x71b2] = 0x80fb, [0x71b3] = 0x8100,
  [0x71b4] = 0x8201, [0x71b5] = 0x822f, [0x71b6] = 0x8225, [0x71b7] = 0x8333,
  [0x71b8] = 0x832d, [0x71b9] = 0x8344, [0x71ba] = 0x8319, [0x71bb] = 0x8351,
  [0x71bc] = 0x8325, [0x71bd] = 0x8356, [0x71be] = 0x833f, [0x71bf] = 0x8341,
  [0x71c0] = 0x8326, [0x71c1] = 0x831c, [0x71c2] = 0x8322, [0x71c3] = 0x8342,
  [0x71c4] = 0x834e, [0x71c5] = 0x831b, [0x71c6] = 0x832a, [0x71c7] = 0x8308,
  [0x71c8] = 0x833c, [0x71c9] = 0x834d, [0x71ca] = 0x8316, [0x71cb] = 0x8324,
  [0x71cc] = 0x8320, [0x71cd] = 0x8337, [0x71ce] = 0x832f, [0x71cf] = 0x8329,
  [0x71d0] = 0x8347, [0x71d1] = 0x8345, [0x71d2] = 0x834c, [0x71d3] = 0x8353,
  [0x71d4] = 0x831e, [0x71d5] = 0x832c, [0x71d6] = 0x834b, [0x71d7] = 0x8327,
  [0x71d8] = 0x8348, [0x71d9] = 0x8653, [0x71da] = 0x8652, [0x71db] = 0x86a2,
  [0x71dc] = 0x86a8, [0x71dd] = 0x8696, [0x71de] = 0x868d, [0x71df] = 0x8691,
  [0x71e0] = 0x869e, [0x71e1] = 0x8687, [0x71e2] = 0x8697, [0x71e3] = 0x8686,
  [0x71e4] = 0x868b, [0x71e5] = 0x869a, [0x71e6] = 0x8685, [0x71e7] = 0x86a5,
  [0x71e8] = 0x8699, [0x71e9] = 0x86a1, [0x71ea] = 0x86a7, [0x71eb] = 0x8695,
  [0x71ec] = 0x8698, [0x71ed] = 0x868e, [0x71ee] = 0x869d, [0x71ef] = 0x8690,
  [0x71f0] = 0x8694, [0x71f1] = 0x8843, [0x71f2] = 0x8844, [0x71f3] = 0x886d,
  [0x71f4] = 0x8875, [0x71f5] = 0x8876, [0x71f6] = 0x8872, [0x71f7] = 0x8880,
  [0x71f8] = 0x8871, [0x71f9] = 0x887f, [0x71fa] = 0x886f, [0x71fb] = 0x8883,
  [0x71fc] = 0x887e, [0x71fd] = 0x8874, [0x7241] = 0x887c, [0x7242] = 0x8a12,
  [0x7243] = 0x8c47, [0x7244] = 0x8c57, [0x7245] = 0x8c7b, [0x7246] = 0x8ca4,
  [0x7247] = 0x8ca3, [0x7248] = 0x8d76, [0x7249] = 0x8d78, [0x724a] = 0x8db5,
  [0x724b] = 0x8db7, [0x724c] = 0x8db6, [0x724d] = 0x8ed1, [0x724e] = 0x8ed3,
  [0x724f] = 0x8ffe, [0x7250] = 0x8ff5, [0x7251] = 0x9002, [0x7252] = 0x8fff,
  [0x7253] = 0x8ffb, [0x7254] = 0x9004, [0x7255] = 0x8ffc, [0x7256] = 0x8ff6,
  [0x7257] = 0x90d6, [0x7258] = 0x90e0, [0x7259] = 0x90d9, [0x725a] = 0x90da,
  [0x725b] = 0x90e3, [0x725c] = 0x90df, [0x725d] = 0x90e5, [0x725e] = 0x90d8,
  [0x725f] = 0x90db, [0x7260] = 0x90d7, [0x7261] = 0x90dc, [0x7262] = 0x90e4,
  [0x7263] = 0x9150, [0x7264] = 0x914e, [0x7265] = 0x914f, [0x7266] = 0x91d5,
  [0x7267] = 0x91e2, [0x7268] = 0x91da, [0x7269] = 0x965c, [0x726a] = 0x965f,
  [0x726b] = 0x96bc, [0x726c] = 0x98e3, [0x726d] = 0x9adf, [0x726e] = 0x9b2f,
  [0x726f] = 0x4e7f, [0x7270] = 0x5070, [0x7271] = 0x506a, [0x7272] = 0x5061,
  [0x7273] = 0x505e, [0x7274] = 0x5060, [0x7275] = 0x5053, [0x7276] = 0x504b,
  [0x7277] = 0x505d, [0x7278] = 0x5072, [0x7279] = 0x5048, [0x727a] = 0x504d,
  [0x727b] = 0x5041, [0x727c] = 0x505b, [0x727d] = 0x504a, [0x727e] = 0x5062,
  [0x727f] = 0x5015, [0x7281] = 0x5045, [0x7282] = 0x505f, [0x7283] = 0x5069,
  [0x7284] = 0x506b, [0x7285] = 0x5063, [0x7286] = 0x5064, [0x7287] = 0x5046,
  [0x7288] = 0x5040, [0x7289] = 0x506e, [0x728a] = 0x5073, [0x728b] = 0x5057,
  [0x728c] = 0x5051, [0x728d] = 0x51d0, [0x728e] = 0x526b, [0x728f] = 0x526d,
  [0x7290] = 0x526c, [0x7291] = 0x526e, [0x7292] = 0x52d6, [0x7293] = 0x52d3,
  [0x7294] = 0x532d, [0x7295] = 0x539c, [0x7296] = 0x5575, [0x7297] = 0x5576,
  [0x7298] = 0x553c, [0x7299] = 0x554d, [0x729a] = 0x5550, [0x729b] = 0x5534,
  [0x729c] = 0x552a, [0x729d] = 0x5551, [0x729e] = 0x5562, [0x729f] = 0x5536,
  [0x72a0] = 0x5535, [0x72a1] = 0x5530, [0x72a2] = 0x5552, [0x72a3] = 0x5545,
  [0x72a4] = 0x550c, [0x72a5] = 0x5532, [0x72a6] = 0x5565, [0x72a7] = 0x554e,
  [0x72a8] = 0x5539, [0x72a9] = 0x5548, [0x72aa] = 0x552d, [0x72ab] = 0x553b,
  [0x72ac] = 0x5540, [0x72ad] = 0x554b, [0x72ae] = 0x570a, [0x72af] = 0x5707,
  [0x72b0] = 0x57fb, [0x72b1] = 0x5814, [0x72b2] = 0x57e2, [0x72b3] = 0x57f6,
  [0x72b4] = 0x57dc, [0x72b5] = 0x57f4, [0x72b6] = 0x5800, [0x72b7] = 0x57ed,
  [0x72b8] = 0x57fd, [0x72b9] = 0x5808, [0x72ba] = 0x57f8, [0x72bb] = 0x580b,
  [0x72bc] = 0x57f3, [0x72bd] = 0x57cf, [0x72be] = 0x5807, [0x72bf] = 0x57ee,
  [0x72c0] = 0x57e3, [0x72c1] = 0x57f2, [0x72c2] = 0x57e5, [0x72c3] = 0x57ec,
  [0x72c4] = 0x57e1, [0x72c5] = 0x580e, [0x72c6] = 0x57fc, [0x72c7] = 0x5810,
  [0x72c8] = 0x57e7, [0x72c9] = 0x5801, [0x72ca] = 0x580c, [0x72cb] = 0x57f1,
  [0x72cc] = 0x57e9, [0x72cd] = 0x57f0, [0x72ce] = 0x580d, [0x72cf] = 0x5804,
  [0x72d0] = 0x595c, [0x72d1] = 0x5a60, [0x72d2] = 0x5a58, [0x72d3] = 0x5a55,
  [0x72d4] = 0x5a67, [0x72d5] = 0x5a5e, [0x72d6] = 0x5a38, [0x72d7] = 0x5a35,
  [0x72d8] = 0x5a6d, [0x72d9] = 0x5a50, [0x72da] = 0x5a5f, [0x72db] = 0x5a65,
  [0x72dc] = 0x5a6c, [0x72dd] = 0x5a53, [0x72de] = 0x5a64, [0x72df] = 0x5a57,
  [0x72e0] = 0x5a43, [0x72e1] = 0x5a5d, [0x72e2] = 0x5a52, [0x72e3] = 0x5a44,
  [0x72e4] = 0x5a5b, [0x72e5] = 0x5a48, [0x72e6] = 0x5a8e, [0x72e7] = 0x5a3e,
  [0x72e8] = 0x5a4d, [0x72e9] = 0x5a39, [0x72ea] = 0x5a4c, [0x72eb] = 0x5a70,
  [0x72ec] = 0x5a69, [0x72ed] = 0x5a47, [0x72ee] = 0x5a51, [0x72ef] = 0x5a56,
  [0x72f0] = 0x5a42, [0x72f1] = 0x5a5c, [0x72f2] = 0x5b72, [0x72f3] = 0x5b6e,
  [0x72f4] = 0x5bc1, [0x72f5] = 0x5bc0, [0x72f6] = 0x5c59, [0x72f7] = 0x5d1e,
  [0x72f8] = 0x5d0b, [0x72f9] = 0x5d1d, [0x72fa] = 0x5d1a, [0x72fb] = 0x5d20,
  [0x72fc] = 0x5d0c, [0x72fd] = 0x5d28, [0x7341] = 0x5d0d, [0x7342] = 0x5d26,
  [0x7343] = 0x5d25, [0x7344] = 0x5d0f, [0x7345] = 0x5d30, [0x7346] = 0x5d12,
  [0x7347] = 0x5d23, [0x7348] = 0x5d1f, [0x7349] = 0x5d2e, [0x734a] = 0x5e3e,
  [0x734b] = 0x5e34, [0x734c] = 0x5eb1, [0x734d] = 0x5eb4, [0x734e] = 0x5eb9,
  [0x734f] = 0x5eb2, [0x7350] = 0x5eb3, [0x7351] = 0x5f36, [0x7352] = 0x5f38,
  [0x7353] = 0x5f9b, [0x7354] = 0x5f96, [0x7355] = 0x5f9f, [0x7356] = 0x608a,
  [0x7357] = 0x6090, [0x7358] = 0x6086, [0x7359] = 0x60be, [0x735a] = 0x60b0,
  [0x735b] = 0x60ba, [0x735c] = 0x60d3, [0x735d] = 0x60d4, [0x735e] = 0x60cf,
  [0x735f] = 0x60e4, [0x7360] = 0x60d9, [0x7361] = 0x60dd, [0x7362] = 0x60c8,
  [0x7363] = 0x60b1, [0x7364] = 0x60db, [0x7365] = 0x60b7, [0x7366] = 0x60ca,
  [0x7367] = 0x60bf, [0x7368] = 0x60c3, [0x7369] = 0x60cd, [0x736a] = 0x60c0,
  [0x736b] = 0x6332, [0x736c] = 0x6365, [0x736d] = 0x638a, [0x736e] = 0x6382,
  [0x736f] = 0x637d, [0x7370] = 0x63bd, [0x7371] = 0x639e, [0x7372] = 0x63ad,
  [0x7373] = 0x639d, [0x7374] = 0x6397, [0x7375] = 0x63ab, [0x7376] = 0x638e,
  [0x7377] = 0x636f, [0x7378] = 0x6387, [0x7379] = 0x6390, [0x737a] = 0x636e,
  [0x737b] = 0x63af, [0x737c] = 0x6375, [0x737d] = 0x639c, [0x737e] = 0x636d,
  [0x737f] = 0x63ae, [0x7381] = 0x637c, [0x7382] = 0x63a4, [0x7383] = 0x633b,
  [0x7384] = 0x639f, [0x7385] = 0x6378, [0x7386] = 0x6385, [0x7387] = 0x6381,
  [0x7388] = 0x6391, [0x7389] = 0x638d, [0x738a] = 0x6370, [0x738b] = 0x6553,
  [0x738c] = 0x65cd, [0x738d] = 0x6665, [0x738e] = 0x6661, [0x738f] = 0x665b,
  [0x7390] = 0x6659, [0x7391] = 0x665c, [0x7392] = 0x6662, [0x7393] = 0x6718,
  [0x7394] = 0x6879, [0x7395] = 0x6887, [0x7396] = 0x6890, [0x7397] = 0x689c,
  [0x7398] = 0x686d, [0x7399] = 0x686e, [0x739a] = 0x68ae, [0x739b] = 0x68ab,
  [0x739c] = 0x6956, [0x739d] = 0x686f, [0x739e] = 0x68a3, [0x739f] = 0x68ac,
  [0x73a0] = 0x68a9, [0x73a1] = 0x6875, [0x73a2] = 0x6874, [0x73a3] = 0x68b2,
  [0x73a4] = 0x688f, [0x73a5] = 0x6877, [0x73a6] = 0x6892, [0x73a7] = 0x687c,
  [0x73a8] = 0x686b, [0x73a9] = 0x6872, [0x73aa] = 0x68aa, [0x73ab] = 0x6880,
  [0x73ac] = 0x6871, [0x73ad] = 0x687e, [0x73ae] = 0x689b, [0x73af] = 0x6896,
  [0x73b0] = 0x688b, [0x73b1] = 0x68a0, [0x73b2] = 0x6889, [0x73b3] = 0x68a4,
  [0x73b4] = 0x6878, [0x73b5] = 0x687b, [0x73b6] = 0x6891, [0x73b7] = 0x688c,
  [0x73b8] = 0x688a, [0x73b9] = 0x687d, [0x73ba] = 0x6b36, [0x73bb] = 0x6b33,
  [0x73bc] = 0x6b37, [0x73bd] = 0x6b38, [0x73be] = 0x6b91, [0x73bf] = 0x6b8f,
  [0x73c0] = 0x6b8d, [0x73c1] = 0x6b8e, [0x73c2] = 0x6b8c, [0x73c3] = 0x6c2a,
  [0x73c4] = 0x6dc0, [0x73c5] = 0x6dab, [0x73c6] = 0x6db4, [0x73c7] = 0x6db3,
  [0x73c8] = 0x6e74, [0x73c9] = 0x6dac, [0x73ca] = 0x6de9, [0x73cb] = 0x6de2,
  [0x73cc] = 0x6db7, [0x73cd] = 0x6df6, [0x73ce] = 0x6dd4, [0x73cf] = 0x6e00,
  [0x73d0] = 0x6dc8, [0x73d1] = 0x6de0, [0x73d2] = 0x6ddf, [0x73d3] = 0x6dd6,
  [0x73d4] = 0x6dbe, [0x73d5] = 0x6de5, [0x73d6] = 0x6ddc, [0x73d7] = 0x6ddd,
  [0x73d8] = 0x6ddb, [0x73d9] = 0x6df4, [0x73da] = 0x6dca, [0x73db] = 0x6dbd,
  [0x73dc] = 0x6ded, [0x73dd] = 0x6df0, [0x73de] = 0x6dba, [0x73df] = 0x6dd5,
  [0x73e0] = 0x6dc2, [0x73e1] = 0x6dcf, [0x73e2] = 0x6dc9, [0x73e3] = 0x6dd0,
  [0x73e4] = 0x6df2, [0x73e5] = 0x6dd3, [0x73e6] = 0x6dfd, [0x73e7] = 0x6dd7,
  [0x73e8] = 0x6dcd, [0x73e9] = 0x6de3, [0x73ea] = 0x6dbb, [0x73eb] = 0x70fa,
  [0x73ec] = 0x710d, [0x73ed] = 0x70f7, [0x73ee] = 0x7117, [0x73ef] = 0x70f4,
  [0x73f0] = 0x710c, [0x73f1] = 0x70f0, [0x73f2] = 0x7104, [0x73f3] = 0x70f3,
  [0x73f4] = 0x7110, [0x73f5] = 0x70fc, [0x73f6] = 0x70ff, [0x73f7] = 0x7106,
  [0x73f8] = 0x7113, [0x73f9] = 0x7100, [0x73fa] = 0x70f8, [0x73fb] = 0x70f6,
  [0x73fc] = 0x710b, [0x73fd] = 0x7102, [0x7441] = 0x710e, [0x7442] = 0x727e,
  [0x7443] = 0x727b, [0x7444] = 0x727c, [0x7445] = 0x727f, [0x7446] = 0x731d,
  [0x7447] = 0x7317, [0x7448] = 0x7307, [0x7449] = 0x7311, [0x744a] = 0x7318,
  [0x744b] = 0x730a, [0x744c] = 0x7308, [0x744d] = 0x72ff, [0x744e] = 0x730f,
  [0x744f] = 0x731e, [0x7450] = 0x7388, [0x7451] = 0x73f6, [0x7452] = 0x73f8,
  [0x7453] = 0x73f5, [0x7454] = 0x7404, [0x7455] = 0x7401, [0x7456] = 0x73fd,
  [0x7457] = 0x7407, [0x7458] = 0x7400, [0x7459] = 0x73fa, [0x745a] = 0x73fc,
  [0x745b] = 0x73ff, [0x745c] = 0x740c, [0x745d] = 0x740b, [0x745e] = 0x73f4,
  [0x745f] = 0x7408, [0x7460] = 0x7564, [0x7461] = 0x7563, [0x7462] = 0x75ce,
  [0x7463] = 0x75d2, [0x7464] = 0x75cf, [0x7465] = 0x75cb, [0x7466] = 0x75cc,
  [0x7467] = 0x75d1, [0x7468] = 0x75d0, [0x7469] = 0x768f, [0x746a] = 0x7689,
  [0x746b] = 0x76d3, [0x746c] = 0x7739, [0x746d] = 0x772f, [0x746e] = 0x772d,
  [0x746f] = 0x7731, [0x7470] = 0x7732, [0x7471] = 0x7734, [0x7472] = 0x7733,
  [0x7473] = 0x773d, [0x7474] = 0x7725, [0x7475] = 0x773b, [0x7476] = 0x7735,
  [0x7477] = 0x7848, [0x7478] = 0x7852, [0x7479] = 0x7849, [0x747a] = 0x784d,
  [0x747b] = 0x784a, [0x747c] = 0x784c, [0x747d] = 0x7826, [0x747e] = 0x7845,
  [0x747f] = 0x7850, [0x7481] = 0x7964, [0x7482] = 0x7967, [0x7483] = 0x7969,
  [0x7484] = 0x796a, [0x7485] = 0x7963, [0x7486] = 0x796b, [0x7487] = 0x7961,
  [0x7488] = 0x79bb, [0x7489] = 0x79fa, [0x748a] = 0x79f8, [0x748b] = 0x79f6,
  [0x748c] = 0x79f7, [0x748d] = 0x7a8f, [0x748e] = 0x7a94, [0x748f] = 0x7a90,
  [0x7490] = 0x7b35, [0x7491] = 0x7b47, [0x7492] = 0x7b34, [0x7493] = 0x7b25,
  [0x7494] = 0x7b30, [0x7495] = 0x7b22, [0x7496] = 0x7b24, [0x7497] = 0x7b33,
  [0x7498] = 0x7b18, [0x7499] = 0x7b2a, [0x749a] = 0x7b1d, [0x749b] = 0x7b31,
  [0x749c] = 0x7b2b, [0x749d] = 0x7b2d, [0x749e] = 0x7b2f, [0x749f] = 0x7b32,
  [0x74a0] = 0x7b38, [0x74a1] = 0x7b1a, [0x74a2] = 0x7b23, [0x74a3] = 0x7c94,
  [0x74a4] = 0x7c98, [0x74a5] = 0x7c96, [0x74a6] = 0x7ca3, [0x74a7] = 0x7d35,
  [0x74a8] = 0x7d3d, [0x74a9] = 0x7d38, [0x74aa] = 0x7d36, [0x74ab] = 0x7d3a,
  [0x74ac] = 0x7d45, [0x74ad] = 0x7d2c, [0x74ae] = 0x7d29, [0x74af] = 0x7d41,
  [0x74b0] = 0x7d47, [0x74b1] = 0x7d3e, [0x74b2] = 0x7d3f, [0x74b3] = 0x7d4a,
  [0x74b4] = 0x7d3b, [0x74b5] = 0x7d28, [0x74b6] = 0x7f63, [0x74b7] = 0x7f95,
  [0x74b8] = 0x7f9c, [0x74b9] = 0x7f9d, [0x74ba] = 0x7f9b, [0x74bb] = 0x7fca,
  [0x74bc] = 0x7fcb, [0x74bd] = 0x7fcd, [0x74be] = 0x7fd0, [0x74bf] = 0x7fd1,
  [0x74c0] = 0x7fc7, [0x74c1] = 0x7fcf, [0x74c2] = 0x7fc9, [0x74c3] = 0x801f,
  [0x74c4] = 0x801e, [0x74c5] = 0x801b, [0x74c6] = 0x8047, [0x74c7] = 0x8043,
  [0x74c8] = 0x8048, [0x74c9] = 0x8118, [0x74ca] = 0x8125, [0x74cb] = 0x8119,
  [0x74cc] = 0x811b, [0x74cd] = 0x812d, [0x74ce] = 0x811f, [0x74cf] = 0x812c,
  [0x74d0] = 0x811e, [0x74d1] = 0x8121, [0x74d2] = 0x8115, [0x74d3] = 0x8127,
  [0x74d4] = 0x811d, [0x74d5] = 0x8122, [0x74d6] = 0x8211, [0x74d7] = 0x8238,
  [0x74d8] = 0x8233, [0x74d9] = 0x823a, [0x74da] = 0x8234, [0x74db] = 0x8232,
  [0x74dc] = 0x8274, [0x74dd] = 0x8390, [0x74de] = 0x83a3, [0x74df] = 0x83a8,
  [0x74e0] = 0x838d, [0x74e1] = 0x837a, [0x74e2] = 0x8373, [0x74e3] = 0x83a4,
  [0x74e4] = 0x8374, [0x74e5] = 0x838f, [0x74e6] = 0x8381, [0x74e7] = 0x8395,
  [0x74e8] = 0x8399, [0x74e9] = 0x8375, [0x74ea] = 0x8394, [0x74eb] = 0x83a9,
  [0x74ec] = 0x837d, [0x74ed] = 0x8383, [0x74ee] = 0x838c, [0x74ef] = 0x839d,
  [0x74f0] = 0x839b, [0x74f1] = 0x83aa, [0x74f2] = 0x838b, [0x74f3] = 0x837e,
  [0x74f4] = 0x83a5, [0x74f5] = 0x83af, [0x74f6] = 0x8388, [0x74f7] = 0x8397,
  [0x74f8] = 0x83b0, [0x74f9] = 0x837f, [0x74fa] = 0x83a6, [0x74fb] = 0x8387,
  [0x74fc] = 0x83ae, [0x74fd] = 0x8376, [0x7541] = 0x839a, [0x7542] = 0x8659,
  [0x7543] = 0x8656, [0x7544] = 0x86bf, [0x7545] = 0x86b7, [0x7546] = 0x86c2,
  [0x7547] = 0x86c1, [0x7548] = 0x86c5, [0x7549] = 0x86ba, [0x754a] = 0x86b0,
  [0x754b] = 0x86c8, [0x754c] = 0x86b9, [0x754d] = 0x86b3, [0x754e] = 0x86b8,
  [0x754f] = 0x86cc, [0x7550] = 0x86b4, [0x7551] = 0x86bb, [0x7552] = 0x86bc,
  [0x7553] = 0x86c3, [0x7554] = 0x86bd, [0x7555] = 0x86be, [0x7556] = 0x8852,
  [0x7557] = 0x8889, [0x7558] = 0x8895, [0x7559] = 0x88a8, [0x755a] = 0x88a2,
  [0x755b] = 0x88aa, [0x755c] = 0x889a, [0x755d] = 0x8891, [0x755e] = 0x88a1,
  [0x755f] = 0x889f, [0x7560] = 0x8898, [0x7561] = 0x88a7, [0x7562] = 0x8899,
  [0x7563] = 0x889b, [0x7564] = 0x8897, [0x7565] = 0x88a4, [0x7566] = 0x88ac,
  [0x7567] = 0x888c, [0x7568] = 0x8893, [0x7569] = 0x888e, [0x756a] = 0x8982,
  [0x756b] = 0x89d6, [0x756c] = 0x89d9, [0x756d] = 0x89d5, [0x756e] = 0x8a30,
  [0x756f] = 0x8a27, [0x7570] = 0x8a2c, [0x7571] = 0x8a1e, [0x7572] = 0x8c39,
  [0x7573] = 0x8c3b, [0x7574] = 0x8c5c, [0x7575] = 0x8c5d, [0x7576] = 0x8c7d,
  [0x7577] = 0x8ca5, [0x7578] = 0x8d7d, [0x7579] = 0x8d7b, [0x757a] = 0x8d79,
  [0x757b] = 0x8dbc, [0x757c] = 0x8dc2, [0x757d] = 0x8db9, [0x757e] = 0x8dbf,
  [0x757f] = 0x8dc1, [0x7581] = 0x8ed8, [0x7582] = 0x8ede, [0x7583] = 0x8edd,
  [0x7584] = 0x8edc, [0x7585] = 0x8ed7, [0x7586] = 0x8ee0, [0x7587] = 0x8ee1,
  [0x7588] = 0x9024, [0x7589] = 0x900b, [0x758a] = 0x9011, [0x758b] = 0x901c,
  [0x758c] = 0x900c, [0x758d] = 0x9021, [0x758e] = 0x90ef, [0x758f] = 0x90ea,
  [0x7590] = 0x90f0, [0x7591] = 0x90f4, [0x7592] = 0x90f2, [0x7593] = 0x90f3,
  [0x7594] = 0x90d4, [0x7595] = 0x90eb, [0x7596] = 0x90ec, [0x7597] = 0x90e9,
  [0x7598] = 0x9156, [0x7599] = 0x9158, [0x759a] = 0x915a, [0x759b] = 0x9153,
  [0x759c] = 0x9155, [0x759d] = 0x91ec, [0x759e] = 0x91f4, [0x759f] = 0x91f1,
  [0x75a0] = 0x91f3, [0x75a1] = 0x91f8, [0x75a2] = 0x91e4, [0x75a3] = 0x91f9,
  [0x75a4] = 0x91ea, [0x75a5] = 0x91eb, [0x75a6] = 0x91f7, [0x75a7] = 0x91e8,
  [0x75a8] = 0x91ee, [0x75a9] = 0x957a, [0x75aa] = 0x9586, [0x75ab] = 0x9588,
  [0x75ac] = 0x967c, [0x75ad] = 0x966d, [0x75ae] = 0x966b, [0x75af] = 0x9671,
  [0x75b0] = 0x966f, [0x75b1] = 0x96bf, [0x75b2] = 0x976a, [0x75b3] = 0x9804,
  [0x75b4] = 0x98e5, [0x75b5] = 0x9997, [0x75b6] = 0x509b, [0x75b7] = 0x5095,
  [0x75b8] = 0x5094, [0x75b9] = 0x509e, [0x75ba] = 0x508b, [0x75bb] = 0x50a3,
  [0x75bc] = 0x5083, [0x75bd] = 0x508c, [0x75be] = 0x508e, [0x75bf] = 0x509d,
  [0x75c0] = 0x5068, [0x75c1] = 0x509c, [0x75c2] = 0x5092, [0x75c3] = 0x5082,
  [0x75c4] = 0x5087, [0x75c5] = 0x515f, [0x75c6] = 0x51d4, [0x75c7] = 0x5312,
  [0x75c8] = 0x5311, [0x75c9] = 0x53a4, [0x75ca] = 0x53a7, [0x75cb] = 0x5591,
  [0x75cc] = 0x55a8, [0x75cd] = 0x55a5, [0x75ce] = 0x55ad, [0x75cf] = 0x5577,
  [0x75d0] = 0x5645, [0x75d1] = 0x55a2, [0x75d2] = 0x5593, [0x75d3] = 0x5588,
  [0x75d4] = 0x558f, [0x75d5] = 0x55b5, [0x75d6] = 0x5581, [0x75d7] = 0x55a3,
  [0x75d8] = 0x5592, [0x75d9] = 0x55a4, [0x75da] = 0x557d, [0x75db] = 0x558c,
  [0x75dc] = 0x55a6, [0x75dd] = 0x557f, [0x75de] = 0x5595, [0x75df] = 0x55a1,
  [0x75e0] = 0x558e, [0x75e1] = 0x570c, [0x75e2] = 0x5829, [0x75e3] = 0x5837,
  [0x75e4] = 0x5819, [0x75e5] = 0x581e, [0x75e6] = 0x5827, [0x75e7] = 0x5823,
  [0x75e8] = 0x5828, [0x75e9] = 0x57f5, [0x75ea] = 0x5848, [0x75eb] = 0x5825,
  [0x75ec] = 0x581c, [0x75ed] = 0x581b, [0x75ee] = 0x5833, [0x75ef] = 0x583f,
  [0x75f0] = 0x5836, [0x75f1] = 0x582e, [0x75f2] = 0x5839, [0x75f3] = 0x5838,
  [0x75f4] = 0x582d, [0x75f5] = 0x582c, [0x75f6] = 0x583b, [0x75f7] = 0x5961,
  [0x75f8] = 0x5aaf, [0x75f9] = 0x5a94, [0x75fa] = 0x5a9f, [0x75fb] = 0x5a7a,
  [0x75fc] = 0x5aa2, [0x75fd] = 0x5a9e, [0x7641] = 0x5a78, [0x7642] = 0x5aa6,
  [0x7643] = 0x5a7c, [0x7644] = 0x5aa5, [0x7645] = 0x5aac, [0x7646] = 0x5a95,
  [0x7647] = 0x5aae, [0x7648] = 0x5a37, [0x7649] = 0x5a84, [0x764a] = 0x5a8a,
  [0x764b] = 0x5a97, [0x764c] = 0x5a83, [0x764d] = 0x5a8b, [0x764e] = 0x5aa9,
  [0x764f] = 0x5a7b, [0x7650] = 0x5a7d, [0x7651] = 0x5a8c, [0x7652] = 0x5a9c,
  [0x7653] = 0x5a8f, [0x7654] = 0x5a93, [0x7655] = 0x5a9d, [0x7656] = 0x5bea,
  [0x7657] = 0x5bcd, [0x7658] = 0x5bcb, [0x7659] = 0x5bd4, [0x765a] = 0x5bd1,
  [0x765b] = 0x5bca, [0x765c] = 0x5bce, [0x765d] = 0x5c0c, [0x765e] = 0x5c30,
  [0x765f] = 0x5d37, [0x7660] = 0x5d43, [0x7661] = 0x5d6b, [0x7662] = 0x5d41,
  [0x7663] = 0x5d4b, [0x7664] = 0x5d3f, [0x7665] = 0x5d35, [0x7666] = 0x5d51,
  [0x7667] = 0x5d4e, [0x7668] = 0x5d55, [0x7669] = 0x5d33, [0x766a] = 0x5d3a,
  [0x766b] = 0x5d52, [0x766c] = 0x5d3d, [0x766d] = 0x5d31, [0x766e] = 0x5d59,
  [0x766f] = 0x5d42, [0x7670] = 0x5d39, [0x7671] = 0x5d49, [0x7672] = 0x5d38,
  [0x7673] = 0x5d3c, [0x7674] = 0x5d32, [0x7675] = 0x5d36, [0x7676] = 0x5d40,
  [0x7677] = 0x5d45, [0x7678] = 0x5e44, [0x7679] = 0x5e41, [0x767a] = 0x5f58,
  [0x767b] = 0x5fa6, [0x767c] = 0x5fa5, [0x767d] = 0x5fab, [0x767e] = 0x60c9,
  [0x767f] = 0x60b9, [0x7681] = 0x60cc, [0x7682] = 0x60e2, [0x7683] = 0x60ce,
  [0x7684] = 0x60c4, [0x7685] = 0x6114, [0x7686] = 0x60f2, [0x7687] = 0x610a,
  [0x7688] = 0x6116, [0x7689] = 0x6105, [0x768a] = 0x60f5, [0x768b] = 0x6113,
  [0x768c] = 0x60f8, [0x768d] = 0x60fc, [0x768e] = 0x60fe, [0x768f] = 0x60c1,
  [0x7690] = 0x6103, [0x7691] = 0x6118, [0x7692] = 0x611d, [0x7693] = 0x6110,
  [0x7694] = 0x60ff, [0x7695] = 0x6104, [0x7696] = 0x610b, [0x7697] = 0x624a,
  [0x7698] = 0x6394, [0x7699] = 0x63b1, [0x769a] = 0x63b0, [0x769b] = 0x63ce,
  [0x769c] = 0x63e5, [0x769d] = 0x63e8, [0x769e] = 0x63ef, [0x769f] = 0x63c3,
  [0x76a0] = 0x649d, [0x76a1] = 0x63f3, [0x76a2] = 0x63ca, [0x76a3] = 0x63e0,
  [0x76a4] = 0x63f6, [0x76a5] = 0x63d5, [0x76a6] = 0x63f2, [0x76a7] = 0x63f5,
  [0x76a8] = 0x6461, [0x76a9] = 0x63df, [0x76aa] = 0x63be, [0x76ab] = 0x63dd,
  [0x76ac] = 0x63dc, [0x76ad] = 0x63c4, [0x76ae] = 0x63d8, [0x76af] = 0x63d3,
  [0x76b0] = 0x63c2, [0x76b1] = 0x63c7, [0x76b2] = 0x63cc, [0x76b3] = 0x63cb,
  [0x76b4] = 0x63c8, [0x76b5] = 0x63f0, [0x76b6] = 0x63d7, [0x76b7] = 0x63d9,
  [0x76b8] = 0x6532, [0x76b9] = 0x6567, [0x76ba] = 0x656a, [0x76bb] = 0x6564,
  [0x76bc] = 0x655c, [0x76bd] = 0x6568, [0x76be] = 0x6565, [0x76bf] = 0x658c,
  [0x76c0] = 0x659d, [0x76c1] = 0x659e, [0x76c2] = 0x65ae, [0x76c3] = 0x65d0,
  [0x76c4] = 0x65d2, [0x76c5] = 0x667c, [0x76c6] = 0x666c, [0x76c7] = 0x667b,
  [0x76c8] = 0x6680, [0x76c9] = 0x6671, [0x76ca] = 0x6679, [0x76cb] = 0x666a,
  [0x76cc] = 0x6672, [0x76cd] = 0x6701, [0x76ce] = 0x690c, [0x76cf] = 0x68d3,
  [0x76d0] = 0x6904, [0x76d1] = 0x68dc, [0x76d2] = 0x692a, [0x76d3] = 0x68ec,
  [0x76d4] = 0x68ea, [0x76d5] = 0x68f1, [0x76d6] = 0x690f, [0x76d7] = 0x68d6,
  [0x76d8] = 0x68f7, [0x76d9] = 0x68eb, [0x76da] = 0x68e4, [0x76db] = 0x68f6,
  [0x76dc] = 0x6913, [0x76dd] = 0x6910, [0x76de] = 0x68f3, [0x76df] = 0x68e1,
  [0x76e0] = 0x6907, [0x76e1] = 0x68cc, [0x76e2] = 0x6908, [0x76e3] = 0x6970,
  [0x76e4] = 0x68b4, [0x76e5] = 0x6911, [0x76e6] = 0x68ef, [0x76e7] = 0x68c6,
  [0x76e8] = 0x6914, [0x76e9] = 0x68f8, [0x76ea] = 0x68d0, [0x76eb] = 0x68fd,
  [0x76ec] = 0x68fc, [0x76ed] = 0x68e8, [0x76ee] = 0x690b, [0x76ef] = 0x690a,
  [0x76f0] = 0x6917, [0x76f1] = 0x68ce, [0x76f2] = 0x68c8, [0x76f3] = 0x68dd,
  [0x76f4] = 0x68de, [0x76f5] = 0x68e6, [0x76f6] = 0x68f4, [0x76f7] = 0x68d1,
  [0x76f8] = 0x6906, [0x76f9] = 0x68d4, [0x76fa] = 0x68e9, [0x76fb] = 0x6915,
  [0x76fc] = 0x6925, [0x76fd] = 0x68c7, [0x7741] = 0x6b39, [0x7742] = 0x6b3b,
  [0x7743] = 0x6b3f, [0x7744] = 0x6b3c, [0x7745] = 0x6b94, [0x7746] = 0x6b97,
  [0x7747] = 0x6b99, [0x7748] = 0x6b95, [0x7749] = 0x6bbd, [0x774a] = 0x6bf0,
  [0x774b] = 0x6bf2, [0x774c] = 0x6bf3, [0x774d] = 0x6c30, [0x774e] = 0x6dfc,
  [0x774f] = 0x6e46, [0x7750] = 0x6e47, [0x7751] = 0x6e1f, [0x7752] = 0x6e49,
  [0x7753] = 0x6e88, [0x7754] = 0x6e3c, [0x7755] = 0x6e3d, [0x7756] = 0x6e45,
  [0x7757] = 0x6e62, [0x7758] = 0x6e2b, [0x7759] = 0x6e3f, [0x775a] = 0x6e41,
  [0x775b] = 0x6e5d, [0x775c] = 0x6e73, [0x775d] = 0x6e1c, [0x775e] = 0x6e33,
  [0x775f] = 0x6e4b, [0x7760] = 0x6e40, [0x7761] = 0x6e51, [0x7762] = 0x6e3b,
  [0x7763] = 0x6e03, [0x7764] = 0x6e2e, [0x7765] = 0x6e5e, [0x7766] = 0x6e68,
  [0x7767] = 0x6e5c, [0x7768] = 0x6e61, [0x7769] = 0x6e31, [0x776a] = 0x6e28,
  [0x776b] = 0x6e60, [0x776c] = 0x6e71, [0x776d] = 0x6e6b, [0x776e] = 0x6e39,
  [0x776f] = 0x6e22, [0x7770] = 0x6e30, [0x7771] = 0x6e53, [0x7772] = 0x6e65,
  [0x7773] = 0x6e27, [0x7774] = 0x6e78, [0x7775] = 0x6e64, [0x7776] = 0x6e77,
  [0x7777] = 0x6e55, [0x7778] = 0x6e79, [0x7779] = 0x6e52, [0x777a] = 0x6e66,
  [0x777b] = 0x6e35, [0x777c] = 0x6e36, [0x777d] = 0x6e5a, [0x777e] = 0x7120,
  [0x777f] = 0x711e, [0x7781] = 0x712f, [0x7782] = 0x70fb, [0x7783] = 0x712e,
  [0x7784] = 0x7131, [0x7785] = 0x7123, [0x7786] = 0x7125, [0x7787] = 0x7122,
  [0x7788] = 0x7132, [0x7789] = 0x711f, [0x778a] = 0x7128, [0x778b] = 0x713a,
  [0x778c] = 0x711b, [0x778d] = 0x724b, [0x778e] = 0x725a, [0x778f] = 0x7288,
  [0x7790] = 0x7289, [0x7791] = 0x7286, [0x7792] = 0x7285, [0x7793] = 0x728b,
  [0x7794] = 0x7312, [0x7795] = 0x730b, [0x7796] = 0x7330, [0x7797] = 0x7322,
  [0x7798] = 0x7331, [0x7799] = 0x7333, [0x779a] = 0x7327, [0x779b] = 0x7332,
  [0x779c] = 0x732d, [0x779d] = 0x7326, [0x779e] = 0x7323, [0x779f] = 0x7335,
  [0x77a0] = 0x730c, [0x77a1] = 0x742e, [0x77a2] = 0x742c, [0x77a3] = 0x7430,
  [0x77a4] = 0x742b, [0x77a5] = 0x7416, [0x77a6] = 0x741a, [0x77a7] = 0x7421,
  [0x77a8] = 0x742d, [0x77a9] = 0x7431, [0x77aa] = 0x7424, [0x77ab] = 0x7423,
  [0x77ac] = 0x741d, [0x77ad] = 0x7429, [0x77ae] = 0x7420, [0x77af] = 0x7432,
  [0x77b0] = 0x74fb, [0x77b1] = 0x752f, [0x77b2] = 0x756f, [0x77b3] = 0x756c,
  [0x77b4] = 0x75e7, [0x77b5] = 0x75da, [0x77b6] = 0x75e1, [0x77b7] = 0x75e6,
  [0x77b8] = 0x75dd, [0x77b9] = 0x75df, [0x77ba] = 0x75e4, [0x77bb] = 0x75d7,
  [0x77bc] = 0x7695, [0x77bd] = 0x7692, [0x77be] = 0x76da, [0x77bf] = 0x7746,
  [0x77c0] = 0x7747, [0x77c1] = 0x7744, [0x77c2] = 0x774d, [0x77c3] = 0x7745,
  [0x77c4] = 0x774a, [0x77c5] = 0x774e, [0x77c6] = 0x774b, [0x77c7] = 0x774c,
  [0x77c8] = 0x77de, [0x77c9] = 0x77ec, [0x77ca] = 0x7860, [0x77cb] = 0x7864,
  [0x77cc] = 0x7865, [0x77cd] = 0x785c, [0x77ce] = 0x786d, [0x77cf] = 0x7871,
  [0x77d0] = 0x786a, [0x77d1] = 0x786e, [0x77d2] = 0x7870, [0x77d3] = 0x7869,
  [0x77d4] = 0x7868, [0x77d5] = 0x785e, [0x77d6] = 0x7862, [0x77d7] = 0x7974,
  [0x77d8] = 0x7973, [0x77d9] = 0x7972, [0x77da] = 0x7970, [0x77db] = 0x7a02,
  [0x77dc] = 0x7a0a, [0x77dd] = 0x7a03, [0x77de] = 0x7a0c, [0x77df] = 0x7a04,
  [0x77e0] = 0x7a99, [0x77e1] = 0x7ae6, [0x77e2] = 0x7ae4, [0x77e3] = 0x7b4a,
  [0x77e4] = 0x7b3b, [0x77e5] = 0x7b44, [0x77e6] = 0x7b48, [0x77e7] = 0x7b4c,
  [0x77e8] = 0x7b4e, [0x77e9] = 0x7b40, [0x77ea] = 0x7b58, [0x77eb] = 0x7b45,
  [0x77ec] = 0x7ca2, [0x77ed] = 0x7c9e, [0x77ee] = 0x7ca8, [0x77ef] = 0x7ca1,
  [0x77f0] = 0x7d58, [0x77f1] = 0x7d6f, [0x77f2] = 0x7d63, [0x77f3] = 0x7d53,
  [0x77f4] = 0x7d56, [0x77f5] = 0x7d67, [0x77f6] = 0x7d6a, [0x77f7] = 0x7d4f,
  [0x77f8] = 0x7d6d, [0x77f9] = 0x7d5c, [0x77fa] = 0x7d6b, [0x77fb] = 0x7d52,
  [0x77fc] = 0x7d54, [0x77fd] = 0x7d69, [0x7841] = 0x7d51, [0x7842] = 0x7d5f,
  [0x7843] = 0x7d4e, [0x7844] = 0x7f3e, [0x7845] = 0x7f3f, [0x7846] = 0x7f65,
  [0x7847] = 0x7f66, [0x7848] = 0x7fa2, [0x7849] = 0x7fa0, [0x784a] = 0x7fa1,
  [0x784b] = 0x7fd7, [0x784c] = 0x8051, [0x784d] = 0x804f, [0x784e] = 0x8050,
  [0x784f] = 0x80fe, [0x7850] = 0x80d4, [0x7851] = 0x8143, [0x7852] = 0x814a,
  [0x7853] = 0x8152, [0x7854] = 0x814f, [0x7855] = 0x8147, [0x7856] = 0x813d,
  [0x7857] = 0x814d, [0x7858] = 0x813a, [0x7859] = 0x81e6, [0x785a] = 0x81ee,
  [0x785b] = 0x81f7, [0x785c] = 0x81f8, [0x785d] = 0x81f9, [0x785e] = 0x8204,
  [0x785f] = 0x823c, [0x7860] = 0x823d, [0x7861] = 0x823f, [0x7862] = 0x8275,
  [0x7863] = 0x833b, [0x7864] = 0x83cf, [0x7865] = 0x83f9, [0x7866] = 0x8423,
  [0x7867] = 0x83c0, [0x7868] = 0x83e8, [0x7869] = 0x8412, [0x786a] = 0x83e7,
  [0x786b] = 0x83e4, [0x786c] = 0x83fc, [0x786d] = 0x83f6, [0x786e] = 0x8410,
  [0x786f] = 0x83c6, [0x7870] = 0x83c8, [0x7871] = 0x83eb, [0x7872] = 0x83e3,
  [0x7873] = 0x83bf, [0x7874] = 0x8401, [0x7875] = 0x83dd, [0x7876] = 0x83e5,
  [0x7877] = 0x83d8, [0x7878] = 0x83ff, [0x7879] = 0x83e1, [0x787a] = 0x83cb,
  [0x787b] = 0x83ce, [0x787c] = 0x83d6, [0x787d] = 0x83f5, [0x787e] = 0x83c9,
  [0x787f] = 0x8409, [0x7881] = 0x840f, [0x7882] = 0x83de, [0x7883] = 0x8411,
  [0x7884] = 0x8406, [0x7885] = 0x83c2, [0x7886] = 0x83f3, [0x7887] = 0x83d5,
  [0x7888] = 0x83fa, [0x7889] = 0x83c7, [0x788a] = 0x83d1, [0x788b] = 0x83ea,
  [0x788c] = 0x8413, [0x788d] = 0x83c3, [0x788e] = 0x83ec, [0x788f] = 0x83ee,
  [0x7890] = 0x83c4, [0x7891] = 0x83fb, [0x7892] = 0x83d7, [0x7893] = 0x83e2,
  [0x7894] = 0x841b, [0x7895] = 0x83db, [0x7896] = 0x83fe, [0x7897] = 0x86d8,
  [0x7898] = 0x86e2, [0x7899] = 0x86e6, [0x789a] = 0x86d3, [0x789b] = 0x86e3,
  [0x789c] = 0x86da, [0x789d] = 0x86ea, [0x789e] = 0x86dd, [0x789f] = 0x86eb,
  [0x78a0] = 0x86dc, [0x78a1] = 0x86ec, [0x78a2] = 0x86e9, [0x78a3] = 0x86d7,
  [0x78a4] = 0x86e8, [0x78a5] = 0x86d1, [0x78a6] = 0x8848, [0x78a7] = 0x8856,
  [0x78a8] = 0x8855, [0x78a9] = 0x88ba, [0x78aa] = 0x88d7, [0x78ab] = 0x88b9,
  [0x78ac] = 0x88b8, [0x78ad] = 0x88c0, [0x78ae] = 0x88be, [0x78af] = 0x88b6,
  [0x78b0] = 0x88bc, [0x78b1] = 0x88b7, [0x78b2] = 0x88bd, [0x78b3] = 0x88b2,
  [0x78b4] = 0x8901, [0x78b5] = 0x88c9, [0x78b6] = 0x8995, [0x78b7] = 0x8998,
  [0x78b8] = 0x8997, [0x78b9] = 0x89dd, [0x78ba] = 0x89da, [0x78bb] = 0x89db,
  [0x78bc] = 0x8a4e, [0x78bd] = 0x8a4d, [0x78be] = 0x8a39, [0x78bf] = 0x8a59,
  [0x78c0] = 0x8a40, [0x78c1] = 0x8a57, [0x78c2] = 0x8a58, [0x78c3] = 0x8a44,
  [0x78c4] = 0x8a45, [0x78c5] = 0x8a52, [0x78c6] = 0x8a48, [0x78c7] = 0x8a51,
  [0x78c8] = 0x8a4a, [0x78c9] = 0x8a4c, [0x78ca] = 0x8a4f, [0x78cb] = 0x8c5f,
  [0x78cc] = 0x8c81, [0x78cd] = 0x8c80, [0x78ce] = 0x8cba, [0x78cf] = 0x8cbe,
  [0x78d0] = 0x8cb0, [0x78d1] = 0x8cb9, [0x78d2] = 0x8cb5, [0x78d3] = 0x8d84,
  [0x78d4] = 0x8d80, [0x78d5] = 0x8d89, [0x78d6] = 0x8dd8, [0x78d7] = 0x8dd3,
  [0x78d8] = 0x8dcd, [0x78d9] = 0x8dc7, [0x78da] = 0x8dd6, [0x78db] = 0x8ddc,
  [0x78dc] = 0x8dcf, [0x78dd] = 0x8dd5, [0x78de] = 0x8dd9, [0x78df] = 0x8dc8,
  [0x78e0] = 0x8dd7, [0x78e1] = 0x8dc5, [0x78e2] = 0x8eef, [0x78e3] = 0x8ef7,
  [0x78e4] = 0x8efa, [0x78e5] = 0x8ef9, [0x78e6] = 0x8ee6, [0x78e7] = 0x8eee,
  [0x78e8] = 0x8ee5, [0x78e9] = 0x8ef5, [0x78ea] = 0x8ee7, [0x78eb] = 0x8ee8,
  [0x78ec] = 0x8ef6, [0x78ed] = 0x8eeb, [0x78ee] = 0x8ef1, [0x78ef] = 0x8eec,
  [0x78f0] = 0x8ef4, [0x78f1] = 0x8ee9, [0x78f2] = 0x902d, [0x78f3] = 0x9034,
  [0x78f4] = 0x902f, [0x78f5] = 0x9106, [0x78f6] = 0x912c, [0x78f7] = 0x9104,
  [0x78f8] = 0x90ff, [0x78f9] = 0x90fc, [0x78fa] = 0x9108, [0x78fb] = 0x90f9,
  [0x78fc] = 0x90fb, [0x78fd] = 0x9101, [0x7941] = 0x9100, [0x7942] = 0x9107,
  [0x7943] = 0x9105, [0x7944] = 0x9103, [0x7945] = 0x9161, [0x7946] = 0x9164,
  [0x7947] = 0x915f, [0x7948] = 0x9162, [0x7949] = 0x9160, [0x794a] = 0x9201,
  [0x794b] = 0x920a, [0x794c] = 0x9225, [0x794d] = 0x9203, [0x794e] = 0x921a,
  [0x794f] = 0x9226, [0x7950] = 0x920f, [0x7951] = 0x920c, [0x7952] = 0x9200,
  [0x7953] = 0x9212, [0x7954] = 0x91ff, [0x7955] = 0x91fd, [0x7956] = 0x9206,
  [0x7957] = 0x9204, [0x7958] = 0x9227, [0x7959] = 0x9202, [0x795a] = 0x921c,
  [0x795b] = 0x9224, [0x795c] = 0x9219, [0x795d] = 0x9217, [0x795e] = 0x9205,
  [0x795f] = 0x9216, [0x7960] = 0x957b, [0x7961] = 0x958d, [0x7962] = 0x958c,
  [0x7963] = 0x9590, [0x7964] = 0x9687, [0x7965] = 0x967e, [0x7966] = 0x9688,
  [0x7967] = 0x9689, [0x7968] = 0x9683, [0x7969] = 0x9680, [0x796a] = 0x96c2,
  [0x796b] = 0x96c8, [0x796c] = 0x96c3, [0x796d] = 0x96f1, [0x796e] = 0x96f0,
  [0x796f] = 0x976c, [0x7970] = 0x9770, [0x7971] = 0x976e, [0x7972] = 0x9807,
  [0x7973] = 0x98a9, [0x7974] = 0x98eb, [0x7975] = 0x9ce6, [0x7976] = 0x9ef9,
  [0x7977] = 0x4e83, [0x7978] = 0x4e84, [0x7979] = 0x4eb6, [0x797a] = 0x50bd,
  [0x797b] = 0x50bf, [0x797c] = 0x50c6, [0x797d] = 0x50ae, [0x797e] = 0x50c4,
  [0x797f] = 0x50ca, [0x7981] = 0x50b4, [0x7982] = 0x50c8, [0x7983] = 0x50c2,
  [0x7984] = 0x50b0, [0x7985] = 0x50c1, [0x7986] = 0x50ba, [0x7987] = 0x50b1,
  [0x7988] = 0x50cb, [0x7989] = 0x50c9, [0x798a] = 0x50b6, [0x798b] = 0x50b8,
  [0x798c] = 0x51d7, [0x798d] = 0x527a, [0x798e] = 0x5278, [0x798f] = 0x527b,
  [0x7990] = 0x527c, [0x7991] = 0x55c3, [0x7992] = 0x55db, [0x7993] = 0x55cc,
  [0x7994] = 0x55d0, [0x7995] = 0x55cb, [0x7996] = 0x55ca, [0x7997] = 0x55dd,
  [0x7998] = 0x55c0, [0x7999] = 0x55d4, [0x799a] = 0x55c4, [0x799b] = 0x55e9,
  [0x799c] = 0x55bf, [0x799d] = 0x55d2, [0x799e] = 0x558d, [0x799f] = 0x55cf,
  [0x79a0] = 0x55d5, [0x79a1] = 0x55e2, [0x79a2] = 0x55d6, [0x79a3] = 0x55c8,
  [0x79a4] = 0x55f2, [0x79a5] = 0x55cd, [0x79a6] = 0x55d9, [0x79a7] = 0x55c2,
  [0x79a8] = 0x5714, [0x79a9] = 0x5853, [0x79aa] = 0x5868, [0x79ab] = 0x5864,
  [0x79ac] = 0x584f, [0x79ad] = 0x584d, [0x79ae] = 0x5849, [0x79af] = 0x586f,
  [0x79b0] = 0x5855, [0x79b1] = 0x584e, [0x79b2] = 0x585d, [0x79b3] = 0x5859,
  [0x79b4] = 0x5865, [0x79b5] = 0x585b, [0x79b6] = 0x583d, [0x79b7] = 0x5863,
  [0x79b8] = 0x5871, [0x79b9] = 0x58fc, [0x79ba] = 0x5ac7, [0x79bb] = 0x5ac4,
  [0x79bc] = 0x5acb, [0x79bd] = 0x5aba, [0x79be] = 0x5ab8, [0x79bf] = 0x5ab1,
  [0x79c0] = 0x5ab5, [0x79c1] = 0x5ab0, [0x79c2] = 0x5abf, [0x79c3] = 0x5ac8,
  [0x79c4] = 0x5abb, [0x79c5] = 0x5ac6, [0x79c6] = 0x5ab7, [0x79c7] = 0x5ac0,
  [0x79c8] = 0x5aca, [0x79c9] = 0x5ab4, [0x79ca] = 0x5ab6, [0x79cb] = 0x5acd,
  [0x79cc] = 0x5ab9, [0x79cd] = 0x5a90, [0x79ce] = 0x5bd6, [0x79cf] = 0x5bd8,
  [0x79d0] = 0x5bd9, [0x79d1] = 0x5c1f, [0x79d2] = 0x5c33, [0x79d3] = 0x5d71,
  [0x79d4] = 0x5d63, [0x79d5] = 0x5d4a, [0x79d6] = 0x5d65, [0x79d7] = 0x5d72,
  [0x79d8] = 0x5d6c, [0x79d9] = 0x5d5e, [0x79da] = 0x5d68, [0x79db] = 0x5d67,
  [0x79dc] = 0x5d62, [0x79dd] = 0x5df0, [0x79de] = 0x5e4f, [0x79df] = 0x5e4e,
  [0x79e0] = 0x5e4a, [0x79e1] = 0x5e4d, [0x79e2] = 0x5e4b, [0x79e3] = 0x5ec5,
  [0x79e4] = 0x5ecc, [0x79e5] = 0x5ec6, [0x79e6] = 0x5ecb, [0x79e7] = 0x5ec7,
  [0x79e8] = 0x5f40, [0x79e9] = 0x5faf, [0x79ea] = 0x5fad, [0x79eb] = 0x60f7,
  [0x79ec] = 0x6149, [0x79ed] = 0x614a, [0x79ee] = 0x612b, [0x79ef] = 0x6145,
  [0x79f0] = 0x6136, [0x79f1] = 0x6132, [0x79f2] = 0x612e, [0x79f3] = 0x6146,
  [0x79f4] = 0x612f, [0x79f5] = 0x614f, [0x79f6] = 0x6129, [0x79f7] = 0x6140,
  [0x79f8] = 0x6220, [0x79f9] = 0x9168, [0x79fa] = 0x6223, [0x79fb] = 0x6225,
  [0x79fc] = 0x6224, [0x79fd] = 0x63c5, [0x7a41] = 0x63f1, [0x7a42] = 0x63eb,
  [0x7a43] = 0x6410, [0x7a44] = 0x6412, [0x7a45] = 0x6409, [0x7a46] = 0x6420,
  [0x7a47] = 0x6424, [0x7a48] = 0x6433, [0x7a49] = 0x6443, [0x7a4a] = 0x641f,
  [0x7a4b] = 0x6415, [0x7a4c] = 0x6418, [0x7a4d] = 0x6439, [0x7a4e] = 0x6437,
  [0x7a4f] = 0x6422, [0x7a50] = 0x6423, [0x7a51] = 0x640c, [0x7a52] = 0x6426,
  [0x7a53] = 0x6430, [0x7a54] = 0x6428, [0x7a55] = 0x6441, [0x7a56] = 0x6435,
  [0x7a57] = 0x642f, [0x7a58] = 0x640a, [0x7a59] = 0x641a, [0x7a5a] = 0x6440,
  [0x7a5b] = 0x6425, [0x7a5c] = 0x6427, [0x7a5d] = 0x640b, [0x7a5e] = 0x63e7,
  [0x7a5f] = 0x641b, [0x7a60] = 0x642e, [0x7a61] = 0x6421, [0x7a62] = 0x640e,
  [0x7a63] = 0x656f, [0x7a64] = 0x6592, [0x7a65] = 0x65d3, [0x7a66] = 0x6686,
  [0x7a67] = 0x668c, [0x7a68] = 0x6695, [0x7a69] = 0x6690, [0x7a6a] = 0x668b,
  [0x7a6b] = 0x668a, [0x7a6c] = 0x6699, [0x7a6d] = 0x6694, [0x7a6e] = 0x6678,
  [0x7a6f] = 0x6720, [0x7a70] = 0x6966, [0x7a71] = 0x695f, [0x7a72] = 0x6938,
  [0x7a73] = 0x694e, [0x7a74] = 0x6962, [0x7a75] = 0x6971, [0x7a76] = 0x693f,
  [0x7a77] = 0x6945, [0x7a78] = 0x696a, [0x7a79] = 0x6939, [0x7a7a] = 0x6942,
  [0x7a7b] = 0x6957, [0x7a7c] = 0x6959, [0x7a7d] = 0x697a, [0x7a7e] = 0x6948,
  [0x7a7f] = 0x6949, [0x7a81] = 0x6935, [0x7a82] = 0x696c, [0x7a83] = 0x6933,
  [0x7a84] = 0x693d, [0x7a85] = 0x6965, [0x7a86] = 0x68f0, [0x7a87] = 0x6978,
  [0x7a88] = 0x6934, [0x7a89] = 0x6969, [0x7a8a] = 0x6940, [0x7a8b] = 0x696f,
  [0x7a8c] = 0x6944, [0x7a8d] = 0x6976, [0x7a8e] = 0x6958, [0x7a8f] = 0x6941,
  [0x7a90] = 0x6974, [0x7a91] = 0x694c, [0x7a92] = 0x693b, [0x7a93] = 0x694b,
  [0x7a94] = 0x6937, [0x7a95] = 0x695c, [0x7a96] = 0x694f, [0x7a97] = 0x6951,
  [0x7a98] = 0x6932, [0x7a99] = 0x6952, [0x7a9a] = 0x692f, [0x7a9b] = 0x697b,
  [0x7a9c] = 0x693c, [0x7a9d] = 0x6b46, [0x7a9e] = 0x6b45, [0x7a9f] = 0x6b43,
  [0x7aa0] = 0x6b42, [0x7aa1] = 0x6b48, [0x7aa2] = 0x6b41, [0x7aa3] = 0x6b9b,
  [0x7aa4] = 0xfa0d, [0x7aa5] = 0x6bfb, [0x7aa6] = 0x6bfc, [0x7aa7] = 0x6bf9,
  [0x7aa8] = 0x6bf7, [0x7aa9] = 0x6bf8, [0x7aaa] = 0x6e9b, [0x7aab] = 0x6ed6,
  [0x7aac] = 0x6ec8, [0x7aad] = 0x6e8f, [0x7aae] = 0x6ec0, [0x7aaf] = 0x6e9f,
  [0x7ab0] = 0x6e93, [0x7ab1] = 0x6e94, [0x7ab2] = 0x6ea0, [0x7ab3] = 0x6eb1,
  [0x7ab4] = 0x6eb9, [0x7ab5] = 0x6ec6, [0x7ab6] = 0x6ed2, [0x7ab7] = 0x6ebd,
  [0x7ab8] = 0x6ec1, [0x7ab9] = 0x6e9e, [0x7aba] = 0x6ec9, [0x7abb] = 0x6eb7,
  [0x7abc] = 0x6eb0, [0x7abd] = 0x6ecd, [0x7abe] = 0x6ea6, [0x7abf] = 0x6ecf,
  [0x7ac0] = 0x6eb2, [0x7ac1] = 0x6ebe, [0x7ac2] = 0x6ec3, [0x7ac3] = 0x6edc,
  [0x7ac4] = 0x6ed8, [0x7ac5] = 0x6e99, [0x7ac6] = 0x6e92, [0x7ac7] = 0x6e8e,
  [0x7ac8] = 0x6e8d, [0x7ac9] = 0x6ea4, [0x7aca] = 0x6ea1, [0x7acb] = 0x6ebf,
  [0x7acc] = 0x6eb3, [0x7acd] = 0x6ed0, [0x7ace] = 0x6eca, [0x7acf] = 0x6e97,
  [0x7ad0] = 0x6eae, [0x7ad1] = 0x6ea3, [0x7ad2] = 0x7147, [0x7ad3] = 0x7154,
  [0x7ad4] = 0x7152, [0x7ad5] = 0x7163, [0x7ad6] = 0x7160, [0x7ad7] = 0x7141,
  [0x7ad8] = 0x715d, [0x7ad9] = 0x7162, [0x7ada] = 0x7172, [0x7adb] = 0x7178,
  [0x7adc] = 0x716a, [0x7add] = 0x7161, [0x7ade] = 0x7142, [0x7adf] = 0x7158,
  [0x7ae0] = 0x7143, [0x7ae1] = 0x714b, [0x7ae2] = 0x7170, [0x7ae3] = 0x715f,
  [0x7ae4] = 0x7150, [0x7ae5] = 0x7153, [0x7ae6] = 0x7144, [0x7ae7] = 0x714d,
  [0x7ae8] = 0x715a, [0x7ae9] = 0x724f, [0x7aea] = 0x728d, [0x7aeb] = 0x728c,
  [0x7aec] = 0x7291, [0x7aed] = 0x7290, [0x7aee] = 0x728e, [0x7aef] = 0x733c,
  [0x7af0] = 0x7342, [0x7af1] = 0x733b, [0x7af2] = 0x733a, [0x7af3] = 0x7340,
  [0x7af4] = 0x734a, [0x7af5] = 0x7349, [0x7af6] = 0x7444, [0x7af7] = 0x744a,
  [0x7af8] = 0x744b, [0x7af9] = 0x7452, [0x7afa] = 0x7451, [0x7afb] = 0x7457,
  [0x7afc] = 0x7440, [0x7afd] = 0x744f, [0x7b41] = 0x7450, [0x7b42] = 0x744e,
  [0x7b43] = 0x7442, [0x7b44] = 0x7446, [0x7b45] = 0x744d, [0x7b46] = 0x7454,
  [0x7b47] = 0x74e1, [0x7b48] = 0x74ff, [0x7b49] = 0x74fe, [0x7b4a] = 0x74fd,
  [0x7b4b] = 0x751d, [0x7b4c] = 0x7579, [0x7b4d] = 0x7577, [0x7b4e] = 0x6983,
  [0x7b4f] = 0x75ef, [0x7b50] = 0x760f, [0x7b51] = 0x7603, [0x7b52] = 0x75f7,
  [0x7b53] = 0x75fe, [0x7b54] = 0x75fc, [0x7b55] = 0x75f9, [0x7b56] = 0x75f8,
  [0x7b57] = 0x7610, [0x7b58] = 0x75fb, [0x7b59] = 0x75f6, [0x7b5a] = 0x75ed,
  [0x7b5b] = 0x75f5, [0x7b5c] = 0x75fd, [0x7b5d] = 0x7699, [0x7b5e] = 0x76b5,
  [0x7b5f] = 0x76dd, [0x7b60] = 0x7755, [0x7b61] = 0x775f, [0x7b62] = 0x7760,
  [0x7b63] = 0x7752, [0x7b64] = 0x7756, [0x7b65] = 0x775a, [0x7b66] = 0x7769,
  [0x7b67] = 0x7767, [0x7b68] = 0x7754, [0x7b69] = 0x7759, [0x7b6a] = 0x776d,
  [0x7b6b] = 0x77e0, [0x7b6c] = 0x7887, [0x7b6d] = 0x789a, [0x7b6e] = 0x7894,
  [0x7b6f] = 0x788f, [0x7b70] = 0x7884, [0x7b71] = 0x7895, [0x7b72] = 0x7885,
  [0x7b73] = 0x7886, [0x7b74] = 0x78a1, [0x7b75] = 0x7883, [0x7b76] = 0x7879,
  [0x7b77] = 0x7899, [0x7b78] = 0x7880, [0x7b79] = 0x7896, [0x7b7a] = 0x787b,
  [0x7b7b] = 0x797c, [0x7b7c] = 0x7982, [0x7b7d] = 0x797d, [0x7b7e] = 0x7979,
  [0x7b7f] = 0x7a11, [0x7b81] = 0x7a18, [0x7b82] = 0x7a19, [0x7b83] = 0x7a12,
  [0x7b84] = 0x7a17, [0x7b85] = 0x7a15, [0x7b86] = 0x7a22, [0x7b87] = 0x7a13,
  [0x7b88] = 0x7a1b, [0x7b89] = 0x7a10, [0x7b8a] = 0x7aa3, [0x7b8b] = 0x7aa2,
  [0x7b8c] = 0x7a9e, [0x7b8d] = 0x7aeb, [0x7b8e] = 0x7b66, [0x7b8f] = 0x7b64,
  [0x7b90] = 0x7b6d, [0x7b91] = 0x7b74, [0x7b92] = 0x7b69, [0x7b93] = 0x7b72,
  [0x7b94] = 0x7b65, [0x7b95] = 0x7b73, [0x7b96] = 0x7b71, [0x7b97] = 0x7b70,
  [0x7b98] = 0x7b61, [0x7b99] = 0x7b78, [0x7b9a] = 0x7b76, [0x7b9b] = 0x7b63,
  [0x7b9c] = 0x7cb2, [0x7b9d] = 0x7cb4, [0x7b9e] = 0x7caf, [0x7b9f] = 0x7d88,
  [0x7ba0] = 0x7d86, [0x7ba1] = 0x7d80, [0x7ba2] = 0x7d8d, [0x7ba3] = 0x7d7f,
  [0x7ba4] = 0x7d85, [0x7ba5] = 0x7d7a, [0x7ba6] = 0x7d8e, [0x7ba7] = 0x7d7b,
  [0x7ba8] = 0x7d83, [0x7ba9] = 0x7d7c, [0x7baa] = 0x7d8c, [0x7bab] = 0x7d94,
  [0x7bac] = 0x7d84, [0x7bad] = 0x7d7d, [0x7bae] = 0x7d92, [0x7baf] = 0x7f6d,
  [0x7bb0] = 0x7f6b, [0x7bb1] = 0x7f67, [0x7bb2] = 0x7f68, [0x7bb3] = 0x7f6c,
  [0x7bb4] = 0x7fa6, [0x7bb5] = 0x7fa5, [0x7bb6] = 0x7fa7, [0x7bb7] = 0x7fdb,
  [0x7bb8] = 0x7fdc, [0x7bb9] = 0x8021, [0x7bba] = 0x8164, [0x7bbb] = 0x8160,
  [0x7bbc] = 0x8177, [0x7bbd] = 0x815c, [0x7bbe] = 0x8169, [0x7bbf] = 0x815b,
  [0x7bc0] = 0x8162, [0x7bc1] = 0x8172, [0x7bc2] = 0x6721, [0x7bc3] = 0x815e,
  [0x7bc4] = 0x8176, [0x7bc5] = 0x8167, [0x7bc6] = 0x816f, [0x7bc7] = 0x8144,
  [0x7bc8] = 0x8161, [0x7bc9] = 0x821d, [0x7bca] = 0x8249, [0x7bcb] = 0x8244,
  [0x7bcc] = 0x8240, [0x7bcd] = 0x8242, [0x7bce] = 0x8245, [0x7bcf] = 0x84f1,
  [0x7bd0] = 0x843f, [0x7bd1] = 0x8456, [0x7bd2] = 0x8476, [0x7bd3] = 0x8479,
  [0x7bd4] = 0x848f, [0x7bd5] = 0x848d, [0x7bd6] = 0x8465, [0x7bd7] = 0x8451,
  [0x7bd8] = 0x8440, [0x7bd9] = 0x8486, [0x7bda] = 0x8467, [0x7bdb] = 0x8430,
  [0x7bdc] = 0x844d, [0x7bdd] = 0x847d, [0x7bde] = 0x845a, [0x7bdf] = 0x8459,
  [0x7be0] = 0x8474, [0x7be1] = 0x8473, [0x7be2] = 0x845d, [0x7be3] = 0x8507,
  [0x7be4] = 0x845e, [0x7be5] = 0x8437, [0x7be6] = 0x843a, [0x7be7] = 0x8434,
  [0x7be8] = 0x847a, [0x7be9] = 0x8443, [0x7bea] = 0x8478, [0x7beb] = 0x8432,
  [0x7bec] = 0x8445, [0x7bed] = 0x8429, [0x7bee] = 0x83d9, [0x7bef] = 0x844b,
  [0x7bf0] = 0x842f, [0x7bf1] = 0x8442, [0x7bf2] = 0x842d, [0x7bf3] = 0x845f,
  [0x7bf4] = 0x8470, [0x7bf5] = 0x8439, [0x7bf6] = 0x844e, [0x7bf7] = 0x844c,
  [0x7bf8] = 0x8452, [0x7bf9] = 0x846f, [0x7bfa] = 0x84c5, [0x7bfb] = 0x848e,
  [0x7bfc] = 0x843b, [0x7bfd] = 0x8447, [0x7c41] = 0x8436, [0x7c42] = 0x8433,
  [0x7c43] = 0x8468, [0x7c44] = 0x847e, [0x7c45] = 0x8444, [0x7c46] = 0x842b,
  [0x7c47] = 0x8460, [0x7c48] = 0x8454, [0x7c49] = 0x846e, [0x7c4a] = 0x8450,
  [0x7c4b] = 0x870b, [0x7c4c] = 0x8704, [0x7c4d] = 0x86f7, [0x7c4e] = 0x870c,
  [0x7c4f] = 0x86fa, [0x7c50] = 0x86d6, [0x7c51] = 0x86f5, [0x7c52] = 0x874d,
  [0x7c53] = 0x86f8, [0x7c54] = 0x870e, [0x7c55] = 0x8709, [0x7c56] = 0x8701,
  [0x7c57] = 0x86f6, [0x7c58] = 0x870d, [0x7c59] = 0x8705, [0x7c5a] = 0x88d6,
  [0x7c5b] = 0x88cb, [0x7c5c] = 0x88cd, [0x7c5d] = 0x88ce, [0x7c5e] = 0x88de,
  [0x7c5f] = 0x88db, [0x7c60] = 0x88da, [0x7c61] = 0x88cc, [0x7c62] = 0x88d0,
  [0x7c63] = 0x8985, [0x7c64] = 0x899b, [0x7c65] = 0x89df, [0x7c66] = 0x89e5,
  [0x7c67] = 0x89e4, [0x7c68] = 0x89e1, [0x7c69] = 0x89e0, [0x7c6a] = 0x89e2,
  [0x7c6b] = 0x89dc, [0x7c6c] = 0x89e6, [0x7c6d] = 0x8a76, [0x7c6e] = 0x8a86,
  [0x7c6f] = 0x8a7f, [0x7c70] = 0x8a61, [0x7c71] = 0x8a3f, [0x7c72] = 0x8a77,
  [0x7c73] = 0x8a82, [0x7c74] = 0x8a84, [0x7c75] = 0x8a75, [0x7c76] = 0x8a83,
  [0x7c77] = 0x8a81, [0x7c78] = 0x8a74, [0x7c79] = 0x8a7a, [0x7c7a] = 0x8c3c,
  [0x7c7b] = 0x8c4b, [0x7c7c] = 0x8c4a, [0x7c7d] = 0x8c65, [0x7c7e] = 0x8c64,
  [0x7c7f] = 0x8c66, [0x7c81] = 0x8c86, [0x7c82] = 0x8c84, [0x7c83] = 0x8c85,
  [0x7c84] = 0x8ccc, [0x7c85] = 0x8d68, [0x7c86] = 0x8d69, [0x7c87] = 0x8d91,
  [0x7c88] = 0x8d8c, [0x7c89] = 0x8d8e, [0x7c8a] = 0x8d8f, [0x7c8b] = 0x8d8d,
  [0x7c8c] = 0x8d93, [0x7c8d] = 0x8d94, [0x7c8e] = 0x8d90, [0x7c8f] = 0x8d92,
  [0x7c90] = 0x8df0, [0x7c91] = 0x8de0, [0x7c92] = 0x8dec, [0x7c93] = 0x8df1,
  [0x7c94] = 0x8dee, [0x7c95] = 0x8dd0, [0x7c96] = 0x8de9, [0x7c97] = 0x8de3,
  [0x7c98] = 0x8de2, [0x7c99] = 0x8de7, [0x7c9a] = 0x8df2, [0x7c9b] = 0x8deb,
  [0x7c9c] = 0x8df4, [0x7c9d] = 0x8f06, [0x7c9e] = 0x8eff, [0x7c9f] = 0x8f01,
  [0x7ca0] = 0x8f00, [0x7ca1] = 0x8f05, [0x7ca2] = 0x8f07, [0x7ca3] = 0x8f08,
  [0x7ca4] = 0x8f02, [0x7ca5] = 0x8f0b, [0x7ca6] = 0x9052, [0x7ca7] = 0x903f,
  [0x7ca8] = 0x9044, [0x7ca9] = 0x9049, [0x7caa] = 0x903d, [0x7cab] = 0x9110,
  [0x7cac] = 0x910d, [0x7cad] = 0x910f, [0x7cae] = 0x9111, [0x7caf] = 0x9116,
  [0x7cb0] = 0x9114, [0x7cb1] = 0x910b, [0x7cb2] = 0x910e, [0x7cb3] = 0x916e,
  [0x7cb4] = 0x916f, [0x7cb5] = 0x9248, [0x7cb6] = 0x9252, [0x7cb7] = 0x9230,
  [0x7cb8] = 0x923a, [0x7cb9] = 0x9266, [0x7cba] = 0x9233, [0x7cbb] = 0x9265,
  [0x7cbc] = 0x925e, [0x7cbd] = 0x9283, [0x7cbe] = 0x922e, [0x7cbf] = 0x924a,
  [0x7cc0] = 0x9246, [0x7cc1] = 0x926d, [0x7cc2] = 0x926c, [0x7cc3] = 0x924f,
  [0x7cc4] = 0x9260, [0x7cc5] = 0x9267, [0x7cc6] = 0x926f, [0x7cc7] = 0x9236,
  [0x7cc8] = 0x9261, [0x7cc9] = 0x9270, [0x7cca] = 0x9231, [0x7ccb] = 0x9254,
  [0x7ccc] = 0x9263, [0x7ccd] = 0x9250, [0x7cce] = 0x9272, [0x7ccf] = 0x924e,
  [0x7cd0] = 0x9253, [0x7cd1] = 0x924c, [0x7cd2] = 0x9256, [0x7cd3] = 0x9232,
  [0x7cd4] = 0x959f, [0x7cd5] = 0x959c, [0x7cd6] = 0x959e, [0x7cd7] = 0x959b,
  [0x7cd8] = 0x9692, [0x7cd9] = 0x9693, [0x7cda] = 0x9691, [0x7cdb] = 0x9697,
  [0x7cdc] = 0x96ce, [0x7cdd] = 0x96fa, [0x7cde] = 0x96fd, [0x7cdf] = 0x96f8,
  [0x7ce0] = 0x96f5, [0x7ce1] = 0x9773, [0x7ce2] = 0x9777, [0x7ce3] = 0x9778,
  [0x7ce4] = 0x9772, [0x7ce5] = 0x980f, [0x7ce6] = 0x980d, [0x7ce7] = 0x980e,
  [0x7ce8] = 0x98ac, [0x7ce9] = 0x98f6, [0x7cea] = 0x98f9, [0x7ceb] = 0x99af,
  [0x7cec] = 0x99b2, [0x7ced] = 0x99b0, [0x7cee] = 0x99b5, [0x7cef] = 0x9aad,
  [0x7cf0] = 0x9aab, [0x7cf1] = 0x9b5b, [0x7cf2] = 0x9cea, [0x7cf3] = 0x9ced,
  [0x7cf4] = 0x9ce7, [0x7cf5] = 0x9e80, [0x7cf6] = 0x9efd, [0x7cf7] = 0x50e6,
  [0x7cf8] = 0x50d4, [0x7cf9] = 0x50d7, [0x7cfa] = 0x50e8, [0x7cfb] = 0x50f3,
  [0x7cfc] = 0x50db, [0x7cfd] = 0x50ea, [0x7d41] = 0x50dd, [0x7d42] = 0x50e4,
  [0x7d43] = 0x50d3, [0x7d44] = 0x50ec, [0x7d45] = 0x50f0, [0x7d46] = 0x50ef,
  [0x7d47] = 0x50e3, [0x7d48] = 0x50e0, [0x7d49] = 0x51d8, [0x7d4a] = 0x5280,
  [0x7d4b] = 0x5281, [0x7d4c] = 0x52e9, [0x7d4d] = 0x52eb, [0x7d4e] = 0x5330,
  [0x7d4f] = 0x53ac, [0x7d50] = 0x5627, [0x7d51] = 0x5615, [0x7d52] = 0x560c,
  [0x7d53] = 0x5612, [0x7d54] = 0x55fc, [0x7d55] = 0x560f, [0x7d56] = 0x561c,
  [0x7d57] = 0x5601, [0x7d58] = 0x5613, [0x7d59] = 0x5602, [0x7d5a] = 0x55fa,
  [0x7d5b] = 0x561d, [0x7d5c] = 0x5604, [0x7d5d] = 0x55ff, [0x7d5e] = 0x55f9,
  [0x7d5f] = 0x5889, [0x7d60] = 0x587c, [0x7d61] = 0x5890, [0x7d62] = 0x5898,
  [0x7d63] = 0x5886, [0x7d64] = 0x5881, [0x7d65] = 0x587f, [0x7d66] = 0x5874,
  [0x7d67] = 0x588b, [0x7d68] = 0x587a, [0x7d69] = 0x5887, [0x7d6a] = 0x5891,
  [0x7d6b] = 0x588e, [0x7d6c] = 0x5876, [0x7d6d] = 0x5882, [0x7d6e] = 0x5888,
  [0x7d6f] = 0x587b, [0x7d70] = 0x5894, [0x7d71] = 0x588f, [0x7d72] = 0x58fe,
  [0x7d73] = 0x596b, [0x7d74] = 0x5adc, [0x7d75] = 0x5aee, [0x7d76] = 0x5ae5,
  [0x7d77] = 0x5ad5, [0x7d78] = 0x5aea, [0x7d79] = 0x5ada, [0x7d7a] = 0x5aed,
  [0x7d7b] = 0x5aeb, [0x7d7c] = 0x5af3, [0x7d7d] = 0x5ae2, [0x7d7e] = 0x5ae0,
  [0x7d7f] = 0x5adb, [0x7d81] = 0x5aec, [0x7d82] = 0x5ade, [0x7d83] = 0x5add,
  [0x7d84] = 0x5ad9, [0x7d85] = 0x5ae8, [0x7d86] = 0x5adf, [0x7d87] = 0x5b77,
  [0x7d88] = 0x5be0, [0x7d89] = 0x5be3, [0x7d8a] = 0x5c63, [0x7d8b] = 0x5d82,
  [0x7d8c] = 0x5d80, [0x7d8d] = 0x5d7d, [0x7d8e] = 0x5d86, [0x7d8f] = 0x5d7a,
  [0x7d90] = 0x5d81, [0x7d91] = 0x5d77, [0x7d92] = 0x5d8a, [0x7d93] = 0x5d89,
  [0x7d94] = 0x5d88, [0x7d95] = 0x5d7e, [0x7d96] = 0x5d7c, [0x7d97] = 0x5d8d,
  [0x7d98] = 0x5d79, [0x7d99] = 0x5d7f, [0x7d9a] = 0x5e58, [0x7d9b] = 0x5e59,
  [0x7d9c] = 0x5e53, [0x7d9d] = 0x5ed8, [0x7d9e] = 0x5ed1, [0x7d9f] = 0x5ed7,
  [0x7da0] = 0x5ece, [0x7da1] = 0x5edc, [0x7da2] = 0x5ed5, [0x7da3] = 0x5ed9,
  [0x7da4] = 0x5ed2, [0x7da5] = 0x5ed4, [0x7da6] = 0x5f44, [0x7da7] = 0x5f43,
  [0x7da8] = 0x5f6f, [0x7da9] = 0x5fb6, [0x7daa] = 0x612c, [0x7dab] = 0x6128,
  [0x7dac] = 0x6141, [0x7dad] = 0x615e, [0x7dae] = 0x6171, [0x7daf] = 0x6173,
  [0x7db0] = 0x6152, [0x7db1] = 0x6153, [0x7db2] = 0x6172, [0x7db3] = 0x616c,
  [0x7db4] = 0x6180, [0x7db5] = 0x6174, [0x7db6] = 0x6154, [0x7db7] = 0x617a,
  [0x7db8] = 0x615b, [0x7db9] = 0x6165, [0x7dba] = 0x613b, [0x7dbb] = 0x616a,
  [0x7dbc] = 0x6161, [0x7dbd] = 0x6156, [0x7dbe] = 0x6229, [0x7dbf] = 0x6227,
  [0x7dc0] = 0x622b, [0x7dc1] = 0x642b, [0x7dc2] = 0x644d, [0x7dc3] = 0x645b,
  [0x7dc4] = 0x645d, [0x7dc5] = 0x6474, [0x7dc6] = 0x6476, [0x7dc7] = 0x6472,
  [0x7dc8] = 0x6473, [0x7dc9] = 0x647d, [0x7dca] = 0x6475, [0x7dcb] = 0x6466,
  [0x7dcc] = 0x64a6, [0x7dcd] = 0x644e, [0x7dce] = 0x6482, [0x7dcf] = 0x645e,
  [0x7dd0] = 0x645c, [0x7dd1] = 0x644b, [0x7dd2] = 0x6453, [0x7dd3] = 0x6460,
  [0x7dd4] = 0x6450, [0x7dd5] = 0x647f, [0x7dd6] = 0x643f, [0x7dd7] = 0x646c,
  [0x7dd8] = 0x646b, [0x7dd9] = 0x6459, [0x7dda] = 0x6465, [0x7ddb] = 0x6477,
  [0x7ddc] = 0x6573, [0x7ddd] = 0x65a0, [0x7dde] = 0x66a1, [0x7ddf] = 0x66a0,
  [0x7de0] = 0x669f, [0x7de1] = 0x6705, [0x7de2] = 0x6704, [0x7de3] = 0x6722,
  [0x7de4] = 0x69b1, [0x7de5] = 0x69b6, [0x7de6] = 0x69c9, [0x7de7] = 0x69a0,
  [0x7de8] = 0x69ce, [0x7de9] = 0x6996, [0x7dea] = 0x69b0, [0x7deb] = 0x69ac,
  [0x7dec] = 0x69bc, [0x7ded] = 0x6991, [0x7dee] = 0x6999, [0x7def] = 0x698e,
  [0x7df0] = 0x69a7, [0x7df1] = 0x698d, [0x7df2] = 0x69a9, [0x7df3] = 0x69be,
  [0x7df4] = 0x69af, [0x7df5] = 0x69bf, [0x7df6] = 0x69c4, [0x7df7] = 0x69bd,
  [0x7df8] = 0x69a4, [0x7df9] = 0x69d4, [0x7dfa] = 0x69b9, [0x7dfb] = 0x69ca,
  [0x7dfc] = 0x699a, [0x7dfd] = 0x69cf, [0x7e41] = 0x69b3, [0x7e42] = 0x6993,
  [0x7e43] = 0x69aa, [0x7e44] = 0x69a1, [0x7e45] = 0x699e, [0x7e46] = 0x69d9,
  [0x7e47] = 0x6997, [0x7e48] = 0x6990, [0x7e49] = 0x69c2, [0x7e4a] = 0x69b5,
  [0x7e4b] = 0x69a5, [0x7e4c] = 0x69c6, [0x7e4d] = 0x6b4a, [0x7e4e] = 0x6b4d,
  [0x7e4f] = 0x6b4b, [0x7e50] = 0x6b9e, [0x7e51] = 0x6b9f, [0x7e52] = 0x6ba0,
  [0x7e53] = 0x6bc3, [0x7e54] = 0x6bc4, [0x7e55] = 0x6bfe, [0x7e56] = 0x6ece,
  [0x7e57] = 0x6ef5, [0x7e58] = 0x6ef1, [0x7e59] = 0x6f03, [0x7e5a] = 0x6f25,
  [0x7e5b] = 0x6ef8, [0x7e5c] = 0x6f37, [0x7e5d] = 0x6efb, [0x7e5e] = 0x6f2e,
  [0x7e5f] = 0x6f09, [0x7e60] = 0x6f4e, [0x7e61] = 0x6f19, [0x7e62] = 0x6f1a,
  [0x7e63] = 0x6f27, [0x7e64] = 0x6f18, [0x7e65] = 0x6f3b, [0x7e66] = 0x6f12,
  [0x7e67] = 0x6eed, [0x7e68] = 0x6f0a, [0x7e69] = 0x6f36, [0x7e6a] = 0x6f73,
  [0x7e6b] = 0x6ef9, [0x7e6c] = 0x6eee, [0x7e6d] = 0x6f2d, [0x7e6e] = 0x6f40,
  [0x7e6f] = 0x6f30, [0x7e70] = 0x6f3c, [0x7e71] = 0x6f35, [0x7e72] = 0x6eeb,
  [0x7e73] = 0x6f07, [0x7e74] = 0x6f0e, [0x7e75] = 0x6f43, [0x7e76] = 0x6f05,
  [0x7e77] = 0x6efd, [0x7e78] = 0x6ef6, [0x7e79] = 0x6f39, [0x7e7a] = 0x6f1c,
  [0x7e7b] = 0x6efc, [0x7e7c] = 0x6f3a, [0x7e7d] = 0x6f1f, [0x7e7e] = 0x6f0d,
  [0x7e7f] = 0x6f1e, [0x7e81] = 0x6f08, [0x7e82] = 0x6f21, [0x7e83] = 0x7187,
  [0x7e84] = 0x7190, [0x7e85] = 0x7189, [0x7e86] = 0x7180, [0x7e87] = 0x7185,
  [0x7e88] = 0x7182, [0x7e89] = 0x718f, [0x7e8a] = 0x717b, [0x7e8b] = 0x7186,
  [0x7e8c] = 0x7181, [0x7e8d] = 0x7197, [0x7e8e] = 0x7244, [0x7e8f] = 0x7253,
  [0x7e90] = 0x7297, [0x7e91] = 0x7295, [0x7e92] = 0x7293, [0x7e93] = 0x7343,
  [0x7e94] = 0x734d, [0x7e95] = 0x7351, [0x7e96] = 0x734c, [0x7e97] = 0x7462,
  [0x7e98] = 0x7473, [0x7e99] = 0x7471, [0x7e9a] = 0x7475, [0x7e9b] = 0x7472,
  [0x7e9c] = 0x7467, [0x7e9d] = 0x746e, [0x7e9e] = 0x7500, [0x7e9f] = 0x7502,
  [0x7ea0] = 0x7503, [0x7ea1] = 0x757d, [0x7ea2] = 0x7590, [0x7ea3] = 0x7616,
  [0x7ea4] = 0x7608, [0x7ea5] = 0x760c, [0x7ea6] = 0x7615, [0x7ea7] = 0x7611,
  [0x7ea8] = 0x760a, [0x7ea9] = 0x7614, [0x7eaa] = 0x76b8, [0x7eab] = 0x7781,
  [0x7eac] = 0x777c, [0x7ead] = 0x7785, [0x7eae] = 0x7782, [0x7eaf] = 0x776e,
  [0x7eb0] = 0x7780, [0x7eb1] = 0x776f, [0x7eb2] = 0x777e, [0x7eb3] = 0x7783,
  [0x7eb4] = 0x78b2, [0x7eb5] = 0x78aa, [0x7eb6] = 0x78b4, [0x7eb7] = 0x78ad,
  [0x7eb8] = 0x78a8, [0x7eb9] = 0x787e, [0x7eba] = 0x78ab, [0x7ebb] = 0x789e,
  [0x7ebc] = 0x78a5, [0x7ebd] = 0x78a0, [0x7ebe] = 0x78ac, [0x7ebf] = 0x78a2,
  [0x7ec0] = 0x78a4, [0x7ec1] = 0x7998, [0x7ec2] = 0x798a, [0x7ec3] = 0x798b,
  [0x7ec4] = 0x7996, [0x7ec5] = 0x7995, [0x7ec6] = 0x7994, [0x7ec7] = 0x7993,
  [0x7ec8] = 0x7997, [0x7ec9] = 0x7988, [0x7eca] = 0x7992, [0x7ecb] = 0x7990,
  [0x7ecc] = 0x7a2b, [0x7ecd] = 0x7a4a, [0x7ece] = 0x7a30, [0x7ecf] = 0x7a2f,
  [0x7ed0] = 0x7a28, [0x7ed1] = 0x7a26, [0x7ed2] = 0x7aa8, [0x7ed3] = 0x7aab,
  [0x7ed4] = 0x7aac, [0x7ed5] = 0x7aee, [0x7ed6] = 0x7b88, [0x7ed7] = 0x7b9c,
  [0x7ed8] = 0x7b8a, [0x7ed9] = 0x7b91, [0x7eda] = 0x7b90, [0x7edb] = 0x7b96,
  [0x7edc] = 0x7b8d, [0x7edd] = 0x7b8c, [0x7ede] = 0x7b9b, [0x7edf] = 0x7b8e,
  [0x7ee0] = 0x7b85, [0x7ee1] = 0x7b98, [0x7ee2] = 0x5284, [0x7ee3] = 0x7b99,
  [0x7ee4] = 0x7ba4, [0x7ee5] = 0x7b82, [0x7ee6] = 0x7cbb, [0x7ee7] = 0x7cbf,
  [0x7ee8] = 0x7cbc, [0x7ee9] = 0x7cba, [0x7eea] = 0x7da7, [0x7eeb] = 0x7db7,
  [0x7eec] = 0x7dc2, [0x7eed] = 0x7da3, [0x7eee] = 0x7daa, [0x7eef] = 0x7dc1,
  [0x7ef0] = 0x7dc0, [0x7ef1] = 0x7dc5, [0x7ef2] = 0x7d9d, [0x7ef3] = 0x7dce,
  [0x7ef4] = 0x7dc4, [0x7ef5] = 0x7dc6, [0x7ef6] = 0x7dcb, [0x7ef7] = 0x7dcc,
  [0x7ef8] = 0x7daf, [0x7ef9] = 0x7db9, [0x7efa] = 0x7d96, [0x7efb] = 0x7dbc,
  [0x7efc] = 0x7d9f, [0x7efd] = 0x7da6, [0x7f41] = 0x7dae, [0x7f42] = 0x7da9,
  [0x7f43] = 0x7da1, [0x7f44] = 0x7dc9, [0x7f45] = 0x7f73, [0x7f46] = 0x7fe2,
  [0x7f47] = 0x7fe3, [0x7f48] = 0x7fe5, [0x7f49] = 0x7fde, [0x7f4a] = 0x8024,
  [0x7f4b] = 0x805d, [0x7f4c] = 0x805c, [0x7f4d] = 0x8189, [0x7f4e] = 0x8186,
  [0x7f4f] = 0x8183, [0x7f50] = 0x8187, [0x7f51] = 0x818d, [0x7f52] = 0x818c,
  [0x7f53] = 0x818b, [0x7f54] = 0x8215, [0x7f55] = 0x8497, [0x7f56] = 0x84a4,
  [0x7f57] = 0x84a1, [0x7f58] = 0x849f, [0x7f59] = 0x84ba, [0x7f5a] = 0x84ce,
  [0x7f5b] = 0x84c2, [0x7f5c] = 0x84ac, [0x7f5d] = 0x84ae, [0x7f5e] = 0x84ab,
  [0x7f5f] = 0x84b9, [0x7f60] = 0x84b4, [0x7f61] = 0x84c1, [0x7f62] = 0x84cd,
  [0x7f63] = 0x84aa, [0x7f64] = 0x849a, [0x7f65] = 0x84b1, [0x7f66] = 0x84d0,
  [0x7f67] = 0x849d, [0x7f68] = 0x84a7, [0x7f69] = 0x84bb, [0x7f6a] = 0x84a2,
  [0x7f6b] = 0x8494, [0x7f6c] = 0x84c7, [0x7f6d] = 0x84cc, [0x7f6e] = 0x849b,
  [0x7f6f] = 0x84a9, [0x7f70] = 0x84af, [0x7f71] = 0x84a8, [0x7f72] = 0x84d6,
  [0x7f73] = 0x8498, [0x7f74] = 0x84b6, [0x7f75] = 0x84cf, [0x7f76] = 0x84a0,
  [0x7f77] = 0x84d7, [0x7f78] = 0x84d4, [0x7f79] = 0x84d2, [0x7f7a] = 0x84db,
  [0x7f7b] = 0x84b0, [0x7f7c] = 0x8491, [0x7f7d] = 0x8661, [0x7f7e] = 0x8733,
  [0x7f7f] = 0x8723, [0x7f81] = 0x8728, [0x7f82] = 0x876b, [0x7f83] = 0x8740,
  [0x7f84] = 0x872e, [0x7f85] = 0x871e, [0x7f86] = 0x8721, [0x7f87] = 0x8719,
  [0x7f88] = 0x871b, [0x7f89] = 0x8743, [0x7f8a] = 0x872c, [0x7f8b] = 0x8741,
  [0x7f8c] = 0x873e, [0x7f8d] = 0x8746, [0x7f8e] = 0x8720, [0x7f8f] = 0x8732,
  [0x7f90] = 0x872a, [0x7f91] = 0x872d, [0x7f92] = 0x873c, [0x7f93] = 0x8712,
  [0x7f94] = 0x873a, [0x7f95] = 0x8731, [0x7f96] = 0x8735, [0x7f97] = 0x8742,
  [0x7f98] = 0x8726, [0x7f99] = 0x8727, [0x7f9a] = 0x8738, [0x7f9b] = 0x8724,
  [0x7f9c] = 0x871a, [0x7f9d] = 0x8730, [0x7f9e] = 0x8711, [0x7f9f] = 0x88f7,
  [0x7fa0] = 0x88e7, [0x7fa1] = 0x88f1, [0x7fa2] = 0x88f2, [0x7fa3] = 0x88fa,
  [0x7fa4] = 0x88fe, [0x7fa5] = 0x88ee, [0x7fa6] = 0x88fc, [0x7fa7] = 0x88f6,
  [0x7fa8] = 0x88fb, [0x7fa9] = 0x88f0, [0x7faa] = 0x88ec, [0x7fab] = 0x88eb,
  [0x7fac] = 0x899d, [0x7fad] = 0x89a1, [0x7fae] = 0x899f, [0x7faf] = 0x899e,
  [0x7fb0] = 0x89e9, [0x7fb1] = 0x89eb, [0x7fb2] = 0x89e8, [0x7fb3] = 0x8aab,
  [0x7fb4] = 0x8a99, [0x7fb5] = 0x8a8b, [0x7fb6] = 0x8a92, [0x7fb7] = 0x8a8f,
  [0x7fb8] = 0x8a96, [0x7fb9] = 0x8c3d, [0x7fba] = 0x8c68, [0x7fbb] = 0x8c69,
  [0x7fbc] = 0x8cd5, [0x7fbd] = 0x8ccf, [0x7fbe] = 0x8cd7, [0x7fbf] = 0x8d96,
  [0x7fc0] = 0x8e09, [0x7fc1] = 0x8e02, [0x7fc2] = 0x8dff, [0x7fc3] = 0x8e0d,
  [0x7fc4] = 0x8dfd, [0x7fc5] = 0x8e0a, [0x7fc6] = 0x8e03, [0x7fc7] = 0x8e07,
  [0x7fc8] = 0x8e06, [0x7fc9] = 0x8e05, [0x7fca] = 0x8dfe, [0x7fcb] = 0x8e00,
  [0x7fcc] = 0x8e04, [0x7fcd] = 0x8f10, [0x7fce] = 0x8f11, [0x7fcf] = 0x8f0e,
  [0x7fd0] = 0x8f0d, [0x7fd1] = 0x9123, [0x7fd2] = 0x911c, [0x7fd3] = 0x9120,
  [0x7fd4] = 0x9122, [0x7fd5] = 0x911f, [0x7fd6] = 0x911d, [0x7fd7] = 0x911a,
  [0x7fd8] = 0x9124, [0x7fd9] = 0x9121, [0x7fda] = 0x911b, [0x7fdb] = 0x917a,
  [0x7fdc] = 0x9172, [0x7fdd] = 0x9179, [0x7fde] = 0x9173, [0x7fdf] = 0x92a5,
  [0x7fe0] = 0x92a4, [0x7fe1] = 0x9276, [0x7fe2] = 0x929b, [0x7fe3] = 0x927a,
  [0x7fe4] = 0x92a0, [0x7fe5] = 0x9294, [0x7fe6] = 0x92aa, [0x7fe7] = 0x928d,
  [0x7fe8] = 0x92a6, [0x7fe9] = 0x929a, [0x7fea] = 0x92ab, [0x7feb] = 0x9279,
  [0x7fec] = 0x9297, [0x7fed] = 0x927f, [0x7fee] = 0x92a3, [0x7fef] = 0x92ee,
  [0x7ff0] = 0x928e, [0x7ff1] = 0x9282, [0x7ff2] = 0x9295, [0x7ff3] = 0x92a2,
  [0x7ff4] = 0x927d, [0x7ff5] = 0x9288, [0x7ff6] = 0x92a1, [0x7ff7] = 0x928a,
  [0x7ff8] = 0x9286, [0x7ff9] = 0x928c, [0x7ffa] = 0x9299, [0x7ffb] = 0x92a7,
  [0x7ffc] = 0x927e, [0x7ffd] = 0x9287, [0x8041] = 0x92a9, [0x8042] = 0x929d,
  [0x8043] = 0x928b, [0x8044] = 0x922d, [0x8045] = 0x969e, [0x8046] = 0x96a1,
  [0x8047] = 0x96ff, [0x8048] = 0x9758, [0x8049] = 0x977d, [0x804a] = 0x977a,
  [0x804b] = 0x977e, [0x804c] = 0x9783, [0x804d] = 0x9780, [0x804e] = 0x9782,
  [0x804f] = 0x977b, [0x8050] = 0x9784, [0x8051] = 0x9781, [0x8052] = 0x977f,
  [0x8053] = 0x97ce, [0x8054] = 0x97cd, [0x8055] = 0x9816, [0x8056] = 0x98ad,
  [0x8057] = 0x98ae, [0x8058] = 0x9902, [0x8059] = 0x9900, [0x805a] = 0x9907,
  [0x805b] = 0x999d, [0x805c] = 0x999c, [0x805d] = 0x99c3, [0x805e] = 0x99b9,
  [0x805f] = 0x99bb, [0x8060] = 0x99ba, [0x8061] = 0x99c2, [0x8062] = 0x99bd,
  [0x8063] = 0x99c7, [0x8064] = 0x9ab1, [0x8065] = 0x9ae3, [0x8066] = 0x9ae7,
  [0x8067] = 0x9b3e, [0x8068] = 0x9b3f, [0x8069] = 0x9b60, [0x806a] = 0x9b61,
  [0x806b] = 0x9b5f, [0x806c] = 0x9cf1, [0x806d] = 0x9cf2, [0x806e] = 0x9cf5,
  [0x806f] = 0x9ea7, [0x8070] = 0x50ff, [0x8071] = 0x5103, [0x8072] = 0x5130,
  [0x8073] = 0x50f8, [0x8074] = 0x5106, [0x8075] = 0x5107, [0x8076] = 0x50f6,
  [0x8077] = 0x50fe, [0x8078] = 0x510b, [0x8079] = 0x510c, [0x807a] = 0x50fd,
  [0x807b] = 0x510a, [0x807c] = 0x528b, [0x807d] = 0x528c, [0x807e] = 0x52f1,
  [0x807f] = 0x52ef, [0x8081] = 0x5648, [0x8082] = 0x5642, [0x8083] = 0x564c,
  [0x8084] = 0x5635, [0x8085] = 0x5641, [0x8086] = 0x564a, [0x8087] = 0x5649,
  [0x8088] = 0x5646, [0x8089] = 0x5658, [0x808a] = 0x565a, [0x808b] = 0x5640,
  [0x808c] = 0x5633, [0x808d] = 0x563d, [0x808e] = 0x562c, [0x808f] = 0x563e,
  [0x8090] = 0x5638, [0x8091] = 0x562a, [0x8092] = 0x563a, [0x8093] = 0x571a,
  [0x8094] = 0x58ab, [0x8095] = 0x589d, [0x8096] = 0x58b1, [0x8097] = 0x58a0,
  [0x8098] = 0x58a3, [0x8099] = 0x58af, [0x809a] = 0x58ac, [0x809b] = 0x58a5,
  [0x809c] = 0x58a1, [0x809d] = 0x58ff, [0x809e] = 0x5aff, [0x809f] = 0x5af4,
  [0x80a0] = 0x5afd, [0x80a1] = 0x5af7, [0x80a2] = 0x5af6, [0x80a3] = 0x5b03,
  [0x80a4] = 0x5af8, [0x80a5] = 0x5b02, [0x80a6] = 0x5af9, [0x80a7] = 0x5b01,
  [0x80a8] = 0x5b07, [0x80a9] = 0x5b05, [0x80aa] = 0x5b0f, [0x80ab] = 0x5c67,
  [0x80ac] = 0x5d99, [0x80ad] = 0x5d97, [0x80ae] = 0x5d9f, [0x80af] = 0x5d92,
  [0x80b0] = 0x5da2, [0x80b1] = 0x5d93, [0x80b2] = 0x5d95, [0x80b3] = 0x5da0,
  [0x80b4] = 0x5d9c, [0x80b5] = 0x5da1, [0x80b6] = 0x5d9a, [0x80b7] = 0x5d9e,
  [0x80b8] = 0x5e69, [0x80b9] = 0x5e5d, [0x80ba] = 0x5e60, [0x80bb] = 0x5e5c,
  [0x80bc] = 0x7df3, [0x80bd] = 0x5edb, [0x80be] = 0x5ede, [0x80bf] = 0x5ee1,
  [0x80c0] = 0x5f49, [0x80c1] = 0x5fb2, [0x80c2] = 0x618b, [0x80c3] = 0x6183,
  [0x80c4] = 0x6179, [0x80c5] = 0x61b1, [0x80c6] = 0x61b0, [0x80c7] = 0x61a2,
  [0x80c8] = 0x6189, [0x80c9] = 0x619b, [0x80ca] = 0x6193, [0x80cb] = 0x61af,
  [0x80cc] = 0x61ad, [0x80cd] = 0x619f, [0x80ce] = 0x6192, [0x80cf] = 0x61aa,
  [0x80d0] = 0x61a1, [0x80d1] = 0x618d, [0x80d2] = 0x6166, [0x80d3] = 0x61b3,
  [0x80d4] = 0x622d, [0x80d5] = 0x646e, [0x80d6] = 0x6470, [0x80d7] = 0x6496,
  [0x80d8] = 0x64a0, [0x80d9] = 0x6485, [0x80da] = 0x6497, [0x80db] = 0x649c,
  [0x80dc] = 0x648f, [0x80dd] = 0x648b, [0x80de] = 0x648a, [0x80df] = 0x648c,
  [0x80e0] = 0x64a3, [0x80e1] = 0x649f, [0x80e2] = 0x6468, [0x80e3] = 0x64b1,
  [0x80e4] = 0x6498, [0x80e5] = 0x6576, [0x80e6] = 0x657a, [0x80e7] = 0x6579,
  [0x80e8] = 0x657b, [0x80e9] = 0x65b2, [0x80ea] = 0x65b3, [0x80eb] = 0x66b5,
  [0x80ec] = 0x66b0, [0x80ed] = 0x66a9, [0x80ee] = 0x66b2, [0x80ef] = 0x66b7,
  [0x80f0] = 0x66aa, [0x80f1] = 0x66af, [0x80f2] = 0x6a00, [0x80f3] = 0x6a06,
  [0x80f4] = 0x6a17, [0x80f5] = 0x69e5, [0x80f6] = 0x69f8, [0x80f7] = 0x6a15,
  [0x80f8] = 0x69f1, [0x80f9] = 0x69e4, [0x80fa] = 0x6a20, [0x80fb] = 0x69ff,
  [0x80fc] = 0x69ec, [0x80fd] = 0x69e2, [0x8141] = 0x6a1b, [0x8142] = 0x6a1d,
  [0x8143] = 0x69fe, [0x8144] = 0x6a27, [0x8145] = 0x69f2, [0x8146] = 0x69ee,
  [0x8147] = 0x6a14, [0x8148] = 0x69f7, [0x8149] = 0x69e7, [0x814a] = 0x6a40,
  [0x814b] = 0x6a08, [0x814c] = 0x69e6, [0x814d] = 0x69fb, [0x814e] = 0x6a0d,
  [0x814f] = 0x69fc, [0x8150] = 0x69eb, [0x8151] = 0x6a09, [0x8152] = 0x6a04,
  [0x8153] = 0x6a18, [0x8154] = 0x6a25, [0x8155] = 0x6a0f, [0x8156] = 0x69f6,
  [0x8157] = 0x6a26, [0x8158] = 0x6a07, [0x8159] = 0x69f4, [0x815a] = 0x6a16,
  [0x815b] = 0x6b51, [0x815c] = 0x6ba5, [0x815d] = 0x6ba3, [0x815e] = 0x6ba2,
  [0x815f] = 0x6ba6, [0x8160] = 0x6c01, [0x8161] = 0x6c00, [0x8162] = 0x6bff,
  [0x8163] = 0x6c02, [0x8164] = 0x6f41, [0x8165] = 0x6f26, [0x8166] = 0x6f7e,
  [0x8167] = 0x6f87, [0x8168] = 0x6fc6, [0x8169] = 0x6f92, [0x816a] = 0x6f8d,
  [0x816b] = 0x6f89, [0x816c] = 0x6f8c, [0x816d] = 0x6f62, [0x816e] = 0x6f4f,
  [0x816f] = 0x6f85, [0x8170] = 0x6f5a, [0x8171] = 0x6f96, [0x8172] = 0x6f76,
  [0x8173] = 0x6f6c, [0x8174] = 0x6f82, [0x8175] = 0x6f55, [0x8176] = 0x6f72,
  [0x8177] = 0x6f52, [0x8178] = 0x6f50, [0x8179] = 0x6f57, [0x817a] = 0x6f94,
  [0x817b] = 0x6f93, [0x817c] = 0x6f5d, [0x817d] = 0x6f00, [0x817e] = 0x6f61,
  [0x817f] = 0x6f6b, [0x8181] = 0x6f7d, [0x8182] = 0x6f67, [0x8183] = 0x6f90,
  [0x8184] = 0x6f53, [0x8185] = 0x6f8b, [0x8186] = 0x6f69, [0x8187] = 0x6f7f,
  [0x8188] = 0x6f95, [0x8189] = 0x6f63, [0x818a] = 0x6f77, [0x818b] = 0x6f6a,
  [0x818c] = 0x6f7b, [0x818d] = 0x71b2, [0x818e] = 0x71af, [0x818f] = 0x719b,
  [0x8190] = 0x71b0, [0x8191] = 0x71a0, [0x8192] = 0x719a, [0x8193] = 0x71a9,
  [0x8194] = 0x71b5, [0x8195] = 0x719d, [0x8196] = 0x71a5, [0x8197] = 0x719e,
  [0x8198] = 0x71a4, [0x8199] = 0x71a1, [0x819a] = 0x71aa, [0x819b] = 0x719c,
  [0x819c] = 0x71a7, [0x819d] = 0x71b3, [0x819e] = 0x7298, [0x819f] = 0x729a,
  [0x81a0] = 0x7358, [0x81a1] = 0x7352, [0x81a2] = 0x735e, [0x81a3] = 0x735f,
  [0x81a4] = 0x7360, [0x81a5] = 0x735d, [0x81a6] = 0x735b, [0x81a7] = 0x7361,
  [0x81a8] = 0x735a, [0x81a9] = 0x7359, [0x81aa] = 0x7362, [0x81ab] = 0x7487,
  [0x81ac] = 0x7489, [0x81ad] = 0x748a, [0x81ae] = 0x7486, [0x81af] = 0x7481,
  [0x81b0] = 0x747d, [0x81b1] = 0x7485, [0x81b2] = 0x7488, [0x81b3] = 0x747c,
  [0x81b4] = 0x7479, [0x81b5] = 0x7508, [0x81b6] = 0x7507, [0x81b7] = 0x757e,
  [0x81b8] = 0x7625, [0x81b9] = 0x761e, [0x81ba] = 0x7619, [0x81bb] = 0x761d,
  [0x81bc] = 0x761c, [0x81bd] = 0x7623, [0x81be] = 0x761a, [0x81bf] = 0x7628,
  [0x81c0] = 0x761b, [0x81c1] = 0x769c, [0x81c2] = 0x769d, [0x81c3] = 0x769e,
  [0x81c4] = 0x769b, [0x81c5] = 0x778d, [0x81c6] = 0x778f, [0x81c7] = 0x7789,
  [0x81c8] = 0x7788, [0x81c9] = 0x78cd, [0x81ca] = 0x78bb, [0x81cb] = 0x78cf,
  [0x81cc] = 0x78cc, [0x81cd] = 0x78d1, [0x81ce] = 0x78ce, [0x81cf] = 0x78d4,
  [0x81d0] = 0x78c8, [0x81d1] = 0x78c3, [0x81d2] = 0x78c4, [0x81d3] = 0x78c9,
  [0x81d4] = 0x799a, [0x81d5] = 0x79a1, [0x81d6] = 0x79a0, [0x81d7] = 0x799c,
  [0x81d8] = 0x79a2, [0x81d9] = 0x799b, [0x81da] = 0x6b76, [0x81db] = 0x7a39,
  [0x81dc] = 0x7ab2, [0x81dd] = 0x7ab4, [0x81de] = 0x7ab3, [0x81df] = 0x7bb7,
  [0x81e0] = 0x7bcb, [0x81e1] = 0x7bbe, [0x81e2] = 0x7bac, [0x81e3] = 0x7bce,
  [0x81e4] = 0x7baf, [0x81e5] = 0x7bb9, [0x81e6] = 0x7bca, [0x81e7] = 0x7bb5,
  [0x81e8] = 0x7cc5, [0x81e9] = 0x7cc8, [0x81ea] = 0x7ccc, [0x81eb] = 0x7ccb,
  [0x81ec] = 0x7df7, [0x81ed] = 0x7ddb, [0x81ee] = 0x7dea, [0x81ef] = 0x7de7,
  [0x81f0] = 0x7dd7, [0x81f1] = 0x7de1, [0x81f2] = 0x7e03, [0x81f3] = 0x7dfa,
  [0x81f4] = 0x7de6, [0x81f5] = 0x7df6, [0x81f6] = 0x7df1, [0x81f7] = 0x7df0,
  [0x81f8] = 0x7dee, [0x81f9] = 0x7ddf, [0x81fa] = 0x7f76, [0x81fb] = 0x7fac,
  [0x81fc] = 0x7fb0, [0x81fd] = 0x7fad, [0x8241] = 0x7fed, [0x8242] = 0x7feb,
  [0x8243] = 0x7fea, [0x8244] = 0x7fec, [0x8245] = 0x7fe6, [0x8246] = 0x7fe8,
  [0x8247] = 0x8064, [0x8248] = 0x8067, [0x8249] = 0x81a3, [0x824a] = 0x819f,
  [0x824b] = 0x819e, [0x824c] = 0x8195, [0x824d] = 0x81a2, [0x824e] = 0x8199,
  [0x824f] = 0x8197, [0x8250] = 0x8216, [0x8251] = 0x824f, [0x8252] = 0x8253,
  [0x8253] = 0x8252, [0x8254] = 0x8250, [0x8255] = 0x824e, [0x8256] = 0x8251,
  [0x8257] = 0x8524, [0x8258] = 0x853b, [0x8259] = 0x850f, [0x825a] = 0x8500,
  [0x825b] = 0x8529, [0x825c] = 0x850e, [0x825d] = 0x8509, [0x825e] = 0x850d,
  [0x825f] = 0x851f, [0x8260] = 0x850a, [0x8261] = 0x8527, [0x8262] = 0x851c,
  [0x8263] = 0x84fb, [0x8264] = 0x852b, [0x8265] = 0x84fa, [0x8266] = 0x8508,
  [0x8267] = 0x850c, [0x8268] = 0x84f4, [0x8269] = 0x852a, [0x826a] = 0x84f2,
  [0x826b] = 0x8515, [0x826c] = 0x84f7, [0x826d] = 0x84eb, [0x826e] = 0x84f3,
  [0x826f] = 0x84fc, [0x8270] = 0x8512, [0x8271] = 0x84ea, [0x8272] = 0x84e9,
  [0x8273] = 0x8516, [0x8274] = 0x84fe, [0x8275] = 0x8528, [0x8276] = 0x851d,
  [0x8277] = 0x852e, [0x8278] = 0x8502, [0x8279] = 0x84fd, [0x827a] = 0x851e,
  [0x827b] = 0x84f6, [0x827c] = 0x8531, [0x827d] = 0x8526, [0x827e] = 0x84e7,
  [0x827f] = 0x84e8, [0x8281] = 0x84f0, [0x8282] = 0x84ef, [0x8283] = 0x84f9,
  [0x8284] = 0x8518, [0x8285] = 0x8520, [0x8286] = 0x8530, [0x8287] = 0x850b,
  [0x8288] = 0x8519, [0x8289] = 0x852f, [0x828a] = 0x8662, [0x828b] = 0x8756,
  [0x828c] = 0x8763, [0x828d] = 0x8764, [0x828e] = 0x8777, [0x828f] = 0x87e1,
  [0x8290] = 0x8773, [0x8291] = 0x8758, [0x8292] = 0x8754, [0x8293] = 0x875b,
  [0x8294] = 0x8752, [0x8295] = 0x8761, [0x8296] = 0x875a, [0x8297] = 0x8751,
  [0x8298] = 0x875e, [0x8299] = 0x876d, [0x829a] = 0x876a, [0x829b] = 0x8750,
  [0x829c] = 0x874e, [0x829d] = 0x875f, [0x829e] = 0x875d, [0x829f] = 0x876f,
  [0x82a0] = 0x876c, [0x82a1] = 0x877a, [0x82a2] = 0x876e, [0x82a3] = 0x875c,
  [0x82a4] = 0x8765, [0x82a5] = 0x874f, [0x82a6] = 0x877b, [0x82a7] = 0x8775,
  [0x82a8] = 0x8762, [0x82a9] = 0x8767, [0x82aa] = 0x8769, [0x82ab] = 0x885a,
  [0x82ac] = 0x8905, [0x82ad] = 0x890c, [0x82ae] = 0x8914, [0x82af] = 0x890b,
  [0x82b0] = 0x8917, [0x82b1] = 0x8918, [0x82b2] = 0x8919, [0x82b3] = 0x8906,
  [0x82b4] = 0x8916, [0x82b5] = 0x8911, [0x82b6] = 0x890e, [0x82b7] = 0x8909,
  [0x82b8] = 0x89a2, [0x82b9] = 0x89a4, [0x82ba] = 0x89a3, [0x82bb] = 0x89ed,
  [0x82bc] = 0x89f0, [0x82bd] = 0x89ec, [0x82be] = 0x8acf, [0x82bf] = 0x8ac6,
  [0x82c0] = 0x8ab8, [0x82c1] = 0x8ad3, [0x82c2] = 0x8ad1, [0x82c3] = 0x8ad4,
  [0x82c4] = 0x8ad5, [0x82c5] = 0x8abb, [0x82c6] = 0x8ad7, [0x82c7] = 0x8abe,
  [0x82c8] = 0x8ac0, [0x82c9] = 0x8ac5, [0x82ca] = 0x8ad8, [0x82cb] = 0x8ac3,
  [0x82cc] = 0x8aba, [0x82cd] = 0x8abd, [0x82ce] = 0x8ad9, [0x82cf] = 0x8c3e,
  [0x82d0] = 0x8c4d, [0x82d1] = 0x8c8f, [0x82d2] = 0x8ce5, [0x82d3] = 0x8cdf,
  [0x82d4] = 0x8cd9, [0x82d5] = 0x8ce8, [0x82d6] = 0x8cda, [0x82d7] = 0x8cdd,
  [0x82d8] = 0x8ce7, [0x82d9] = 0x8da0, [0x82da] = 0x8d9c, [0x82db] = 0x8da1,
  [0x82dc] = 0x8d9b, [0x82dd] = 0x8e20, [0x82de] = 0x8e23, [0x82df] = 0x8e25,
  [0x82e0] = 0x8e24, [0x82e1] = 0x8e2e, [0x82e2] = 0x8e15, [0x82e3] = 0x8e1b,
  [0x82e4] = 0x8e16, [0x82e5] = 0x8e11, [0x82e6] = 0x8e19, [0x82e7] = 0x8e26,
  [0x82e8] = 0x8e27, [0x82e9] = 0x8e14, [0x82ea] = 0x8e12, [0x82eb] = 0x8e18,
  [0x82ec] = 0x8e13, [0x82ed] = 0x8e1c, [0x82ee] = 0x8e17, [0x82ef] = 0x8e1a,
  [0x82f0] = 0x8f2c, [0x82f1] = 0x8f24, [0x82f2] = 0x8f18, [0x82f3] = 0x8f1a,
  [0x82f4] = 0x8f20, [0x82f5] = 0x8f23, [0x82f6] = 0x8f16, [0x82f7] = 0x8f17,
  [0x82f8] = 0x9073, [0x82f9] = 0x9070, [0x82fa] = 0x906f, [0x82fb] = 0x9067,
  [0x82fc] = 0x906b, [0x82fd] = 0x912f, [0x8341] = 0x912b, [0x8342] = 0x9129,
  [0x8343] = 0x912a, [0x8344] = 0x9132, [0x8345] = 0x9126, [0x8346] = 0x912e,
  [0x8347] = 0x9185, [0x8348] = 0x9186, [0x8349] = 0x918a, [0x834a] = 0x9181,
  [0x834b] = 0x9182, [0x834c] = 0x9184, [0x834d] = 0x9180, [0x834e] = 0x92d0,
  [0x834f] = 0x92c3, [0x8350] = 0x92c4, [0x8351] = 0x92c0, [0x8352] = 0x92d9,
  [0x8353] = 0x92b6, [0x8354] = 0x92cf, [0x8355] = 0x92f1, [0x8356] = 0x92df,
  [0x8357] = 0x92d8, [0x8358] = 0x92e9, [0x8359] = 0x92d7, [0x835a] = 0x92dd,
  [0x835b] = 0x92cc, [0x835c] = 0x92ef, [0x835d] = 0x92c2, [0x835e] = 0x92e8,
  [0x835f] = 0x92ca, [0x8360] = 0x92c8, [0x8361] = 0x92ce, [0x8362] = 0x92e6,
  [0x8363] = 0x92cd, [0x8364] = 0x92d5, [0x8365] = 0x92c9, [0x8366] = 0x92e0,
  [0x8367] = 0x92de, [0x8368] = 0x92e7, [0x8369] = 0x92d1, [0x836a] = 0x92d3,
  [0x836b] = 0x92b5, [0x836c] = 0x92e1, [0x836d] = 0x92c6, [0x836e] = 0x92b4,
  [0x836f] = 0x957c, [0x8370] = 0x95ac, [0x8371] = 0x95ab, [0x8372] = 0x95ae,
  [0x8373] = 0x95b0, [0x8374] = 0x96a4, [0x8375] = 0x96a2, [0x8376] = 0x96d3,
  [0x8377] = 0x9705, [0x8378] = 0x9708, [0x8379] = 0x9702, [0x837a] = 0x975a,
  [0x837b] = 0x978a, [0x837c] = 0x978e, [0x837d] = 0x9788, [0x837e] = 0x97d0,
  [0x837f] = 0x97cf, [0x8381] = 0x981e, [0x8382] = 0x981d, [0x8383] = 0x9826,
  [0x8384] = 0x9829, [0x8385] = 0x9828, [0x8386] = 0x9820, [0x8387] = 0x981b,
  [0x8388] = 0x9827, [0x8389] = 0x98b2, [0x838a] = 0x9908, [0x838b] = 0x98fa,
  [0x838c] = 0x9911, [0x838d] = 0x9914, [0x838e] = 0x9916, [0x838f] = 0x9917,
  [0x8390] = 0x9915, [0x8391] = 0x99dc, [0x8392] = 0x99cd, [0x8393] = 0x99cf,
  [0x8394] = 0x99d3, [0x8395] = 0x99d4, [0x8396] = 0x99ce, [0x8397] = 0x99c9,
  [0x8398] = 0x99d6, [0x8399] = 0x99d8, [0x839a] = 0x99cb, [0x839b] = 0x99d7,
  [0x839c] = 0x99cc, [0x839d] = 0x9ab3, [0x839e] = 0x9aec, [0x839f] = 0x9aeb,
  [0x83a0] = 0x9af3, [0x83a1] = 0x9af2, [0x83a2] = 0x9af1, [0x83a3] = 0x9b46,
  [0x83a4] = 0x9b43, [0x83a5] = 0x9b67, [0x83a6] = 0x9b74, [0x83a7] = 0x9b71,
  [0x83a8] = 0x9b66, [0x83a9] = 0x9b76, [0x83aa] = 0x9b75, [0x83ab] = 0x9b70,
  [0x83ac] = 0x9b68, [0x83ad] = 0x9b64, [0x83ae] = 0x9b6c, [0x83af] = 0x9cfc,
  [0x83b0] = 0x9cfa, [0x83b1] = 0x9cfd, [0x83b2] = 0x9cff, [0x83b3] = 0x9cf7,
  [0x83b4] = 0x9d07, [0x83b5] = 0x9d00, [0x83b6] = 0x9cf9, [0x83b7] = 0x9cfb,
  [0x83b8] = 0x9d08, [0x83b9] = 0x9d05, [0x83ba] = 0x9d04, [0x83bb] = 0x9e83,
  [0x83bc] = 0x9ed3, [0x83bd] = 0x9f0f, [0x83be] = 0x9f10, [0x83bf] = 0x511c,
  [0x83c0] = 0x5113, [0x83c1] = 0x5117, [0x83c2] = 0x511a, [0x83c3] = 0x5111,
  [0x83c4] = 0x51de, [0x83c5] = 0x5334, [0x83c6] = 0x53e1, [0x83c7] = 0x5670,
  [0x83c8] = 0x5660, [0x83c9] = 0x566e, [0x83ca] = 0x5673, [0x83cb] = 0x5666,
  [0x83cc] = 0x5663, [0x83cd] = 0x566d, [0x83ce] = 0x5672, [0x83cf] = 0x565e,
  [0x83d0] = 0x5677, [0x83d1] = 0x571c, [0x83d2] = 0x571b, [0x83d3] = 0x58c8,
  [0x83d4] = 0x58bd, [0x83d5] = 0x58c9, [0x83d6] = 0x58bf, [0x83d7] = 0x58ba,
  [0x83d8] = 0x58c2, [0x83d9] = 0x58bc, [0x83da] = 0x58c6, [0x83db] = 0x5b17,
  [0x83dc] = 0x5b19, [0x83dd] = 0x5b1b, [0x83de] = 0x5b21, [0x83df] = 0x5b14,
  [0x83e0] = 0x5b13, [0x83e1] = 0x5b10, [0x83e2] = 0x5b16, [0x83e3] = 0x5b28,
  [0x83e4] = 0x5b1a, [0x83e5] = 0x5b20, [0x83e6] = 0x5b1e, [0x83e7] = 0x5bef,
  [0x83e8] = 0x5dac, [0x83e9] = 0x5db1, [0x83ea] = 0x5da9, [0x83eb] = 0x5da7,
  [0x83ec] = 0x5db5, [0x83ed] = 0x5db0, [0x83ee] = 0x5dae, [0x83ef] = 0x5daa,
  [0x83f0] = 0x5da8, [0x83f1] = 0x5db2, [0x83f2] = 0x5dad, [0x83f3] = 0x5daf,
  [0x83f4] = 0x5db4, [0x83f5] = 0x5e67, [0x83f6] = 0x5e68, [0x83f7] = 0x5e66,
  [0x83f8] = 0x5e6f, [0x83f9] = 0x5ee9, [0x83fa] = 0x5ee7, [0x83fb] = 0x5ee6,
  [0x83fc] = 0x5ee8, [0x83fd] = 0x5ee5, [0x8441] = 0x5f4b, [0x8442] = 0x5fbc,
  [0x8443] = 0x619d, [0x8444] = 0x61a8, [0x8445] = 0x6196, [0x8446] = 0x61c5,
  [0x8447] = 0x61b4, [0x8448] = 0x61c6, [0x8449] = 0x61c1, [0x844a] = 0x61cc,
  [0x844b] = 0x61ba, [0x844c] = 0x61bf, [0x844d] = 0x61b8, [0x844e] = 0x618c,
  [0x844f] = 0x64d7, [0x8450] = 0x64d6, [0x8451] = 0x64d0, [0x8452] = 0x64cf,
  [0x8453] = 0x64c9, [0x8454] = 0x64bd, [0x8455] = 0x6489, [0x8456] = 0x64c3,
  [0x8457] = 0x64db, [0x8458] = 0x64f3, [0x8459] = 0x64d9, [0x845a] = 0x6533,
  [0x845b] = 0x657f, [0x845c] = 0x657c, [0x845d] = 0x65a2, [0x845e] = 0x66c8,
  [0x845f] = 0x66be, [0x8460] = 0x66c0, [0x8461] = 0x66ca, [0x8462] = 0x66cb,
  [0x8463] = 0x66cf, [0x8464] = 0x66bd, [0x8465] = 0x66bb, [0x8466] = 0x66ba,
  [0x8467] = 0x66cc, [0x8468] = 0x6723, [0x8469] = 0x6a34, [0x846a] = 0x6a66,
  [0x846b] = 0x6a49, [0x846c] = 0x6a67, [0x846d] = 0x6a32, [0x846e] = 0x6a68,
  [0x846f] = 0x6a3e, [0x8470] = 0x6a5d, [0x8471] = 0x6a6d, [0x8472] = 0x6a76,
  [0x8473] = 0x6a5b, [0x8474] = 0x6a51, [0x8475] = 0x6a28, [0x8476] = 0x6a5a,
  [0x8477] = 0x6a3b, [0x8478] = 0x6a3f, [0x8479] = 0x6a41, [0x847a] = 0x6a6a,
  [0x847b] = 0x6a64, [0x847c] = 0x6a50, [0x847d] = 0x6a4f, [0x847e] = 0x6a54,
  [0x847f] = 0x6a6f, [0x8481] = 0x6a69, [0x8482] = 0x6a60, [0x8483] = 0x6a3c,
  [0x8484] = 0x6a5e, [0x8485] = 0x6a56, [0x8486] = 0x6a55, [0x8487] = 0x6a4d,
  [0x8488] = 0x6a4e, [0x8489] = 0x6a46, [0x848a] = 0x6b55, [0x848b] = 0x6b54,
  [0x848c] = 0x6b56, [0x848d] = 0x6ba7, [0x848e] = 0x6baa, [0x848f] = 0x6bab,
  [0x8490] = 0x6bc8, [0x8491] = 0x6bc7, [0x8492] = 0x6c04, [0x8493] = 0x6c03,
  [0x8494] = 0x6c06, [0x8495] = 0x6fad, [0x8496] = 0x6fcb, [0x8497] = 0x6fa3,
  [0x8498] = 0x6fc7, [0x8499] = 0x6fbc, [0x849a] = 0x6fce, [0x849b] = 0x6fc8,
  [0x849c] = 0x6f5e, [0x849d] = 0x6fc4, [0x849e] = 0x6fbd, [0x849f] = 0x6f9e,
  [0x84a0] = 0x6fca, [0x84a1] = 0x6fa8, [0x84a2] = 0x7004, [0x84a3] = 0x6fa5,
  [0x84a4] = 0x6fae, [0x84a5] = 0x6fba, [0x84a6] = 0x6fac, [0x84a7] = 0x6faa,
  [0x84a8] = 0x6fcf, [0x84a9] = 0x6fbf, [0x84aa] = 0x6fb8, [0x84ab] = 0x6fa2,
  [0x84ac] = 0x6fc9, [0x84ad] = 0x6fab, [0x84ae] = 0x6fcd, [0x84af] = 0x6faf,
  [0x84b0] = 0x6fb2, [0x84b1] = 0x6fb0, [0x84b2] = 0x71c5, [0x84b3] = 0x71c2,
  [0x84b4] = 0x71bf, [0x84b5] = 0x71b8, [0x84b6] = 0x71d6, [0x84b7] = 0x71c0,
  [0x84b8] = 0x71c1, [0x84b9] = 0x71cb, [0x84ba] = 0x71d4, [0x84bb] = 0x71ca,
  [0x84bc] = 0x71c7, [0x84bd] = 0x71cf, [0x84be] = 0x71bd, [0x84bf] = 0x71d8,
  [0x84c0] = 0x71bc, [0x84c1] = 0x71c6, [0x84c2] = 0x71da, [0x84c3] = 0x71db,
  [0x84c4] = 0x729d, [0x84c5] = 0x729e, [0x84c6] = 0x7369, [0x84c7] = 0x7366,
  [0x84c8] = 0x7367, [0x84c9] = 0x736c, [0x84ca] = 0x7365, [0x84cb] = 0x736b,
  [0x84cc] = 0x736a, [0x84cd] = 0x747f, [0x84ce] = 0x749a, [0x84cf] = 0x74a0,
  [0x84d0] = 0x7494, [0x84d1] = 0x7492, [0x84d2] = 0x7495, [0x84d3] = 0x74a1,
  [0x84d4] = 0x750b, [0x84d5] = 0x7580, [0x84d6] = 0x762f, [0x84d7] = 0x762d,
  [0x84d8] = 0x7631, [0x84d9] = 0x763d, [0x84da] = 0x7633, [0x84db] = 0x763c,
  [0x84dc] = 0x7635, [0x84dd] = 0x7632, [0x84de] = 0x7630, [0x84df] = 0x76bb,
  [0x84e0] = 0x76e6, [0x84e1] = 0x779a, [0x84e2] = 0x779d, [0x84e3] = 0x77a1,
  [0x84e4] = 0x779c, [0x84e5] = 0x779b, [0x84e6] = 0x77a2, [0x84e7] = 0x77a3,
  [0x84e8] = 0x7795, [0x84e9] = 0x7799, [0x84ea] = 0x7797, [0x84eb] = 0x78dd,
  [0x84ec] = 0x78e9, [0x84ed] = 0x78e5, [0x84ee] = 0x78ea, [0x84ef] = 0x78de,
  [0x84f0] = 0x78e3, [0x84f1] = 0x78db, [0x84f2] = 0x78e1, [0x84f3] = 0x78e2,
  [0x84f4] = 0x78ed, [0x84f5] = 0x78df, [0x84f6] = 0x78e0, [0x84f7] = 0x79a4,
  [0x84f8] = 0x7a44, [0x84f9] = 0x7a48, [0x84fa] = 0x7a47, [0x84fb] = 0x7ab6,
  [0x84fc] = 0x7ab8, [0x84fd] = 0x7ab5, [0x8541] = 0x7ab1, [0x8542] = 0x7ab7,
  [0x8543] = 0x7bde, [0x8544] = 0x7be3, [0x8545] = 0x7be7, [0x8546] = 0x7bdd,
  [0x8547] = 0x7bd5, [0x8548] = 0x7be5, [0x8549] = 0x7bda, [0x854a] = 0x7be8,
  [0x854b] = 0x7bf9, [0x854c] = 0x7bd4, [0x854d] = 0x7bea, [0x854e] = 0x7be2,
  [0x854f] = 0x7bdc, [0x8550] = 0x7beb, [0x8551] = 0x7bd8, [0x8552] = 0x7bdf,
  [0x8553] = 0x7cd2, [0x8554] = 0x7cd4, [0x8555] = 0x7cd7, [0x8556] = 0x7cd0,
  [0x8557] = 0x7cd1, [0x8558] = 0x7e12, [0x8559] = 0x7e21, [0x855a] = 0x7e17,
  [0x855b] = 0x7e0c, [0x855c] = 0x7e1f, [0x855d] = 0x7e20, [0x855e] = 0x7e13,
  [0x855f] = 0x7e0e, [0x8560] = 0x7e1c, [0x8561] = 0x7e15, [0x8562] = 0x7e1a,
  [0x8563] = 0x7e22, [0x8564] = 0x7e0b, [0x8565] = 0x7e0f, [0x8566] = 0x7e16,
  [0x8567] = 0x7e0d, [0x8568] = 0x7e14, [0x8569] = 0x7e25, [0x856a] = 0x7e24,
  [0x856b] = 0x7f43, [0x856c] = 0x7f7b, [0x856d] = 0x7f7c, [0x856e] = 0x7f7a,
  [0x856f] = 0x7fb1, [0x8570] = 0x7fef, [0x8571] = 0x802a, [0x8572] = 0x8029,
  [0x8573] = 0x806c, [0x8574] = 0x81b1, [0x8575] = 0x81a6, [0x8576] = 0x81ae,
  [0x8577] = 0x81b9, [0x8578] = 0x81b5, [0x8579] = 0x81ab, [0x857a] = 0x81b0,
  [0x857b] = 0x81ac, [0x857c] = 0x81b4, [0x857d] = 0x81b2, [0x857e] = 0x81b7,
  [0x857f] = 0x81a7, [0x8581] = 0x81f2, [0x8582] = 0x8255, [0x8583] = 0x8256,
  [0x8584] = 0x8257, [0x8585] = 0x8556, [0x8586] = 0x8545, [0x8587] = 0x856b,
  [0x8588] = 0x854d, [0x8589] = 0x8553, [0x858a] = 0x8561, [0x858b] = 0x8558,
  [0x858c] = 0x8540, [0x858d] = 0x8546, [0x858e] = 0x8564, [0x858f] = 0x8541,
  [0x8590] = 0x8562, [0x8591] = 0x8544, [0x8592] = 0x8551, [0x8593] = 0x8547,
  [0x8594] = 0x8563, [0x8595] = 0x853e, [0x8596] = 0x855b, [0x8597] = 0x8571,
  [0x8598] = 0x854e, [0x8599] = 0x856e, [0x859a] = 0x8575, [0x859b] = 0x8555,
  [0x859c] = 0x8567, [0x859d] = 0x8560, [0x859e] = 0x858c, [0x859f] = 0x8566,
  [0x85a0] = 0x855d, [0x85a1] = 0x8554, [0x85a2] = 0x8565, [0x85a3] = 0x856c,
  [0x85a4] = 0x8663, [0x85a5] = 0x8665, [0x85a6] = 0x8664, [0x85a7] = 0x879b,
  [0x85a8] = 0x878f, [0x85a9] = 0x8797, [0x85aa] = 0x8793, [0x85ab] = 0x8792,
  [0x85ac] = 0x8788, [0x85ad] = 0x8781, [0x85ae] = 0x8796, [0x85af] = 0x8798,
  [0x85b0] = 0x8779, [0x85b1] = 0x8787, [0x85b2] = 0x87a3, [0x85b3] = 0x8785,
  [0x85b4] = 0x8790, [0x85b5] = 0x8791, [0x85b6] = 0x879d, [0x85b7] = 0x8784,
  [0x85b8] = 0x8794, [0x85b9] = 0x879c, [0x85ba] = 0x879a, [0x85bb] = 0x8789,
  [0x85bc] = 0x891e, [0x85bd] = 0x8926, [0x85be] = 0x8930, [0x85bf] = 0x892d,
  [0x85c0] = 0x892e, [0x85c1] = 0x8927, [0x85c2] = 0x8931, [0x85c3] = 0x8922,
  [0x85c4] = 0x8929, [0x85c5] = 0x8923, [0x85c6] = 0x892f, [0x85c7] = 0x892c,
  [0x85c8] = 0x891f, [0x85c9] = 0x89f1, [0x85ca] = 0x8ae0, [0x85cb] = 0x8ae2,
  [0x85cc] = 0x8af2, [0x85cd] = 0x8af4, [0x85ce] = 0x8af5, [0x85cf] = 0x8add,
  [0x85d0] = 0x8b14, [0x85d1] = 0x8ae4, [0x85d2] = 0x8adf, [0x85d3] = 0x8af0,
  [0x85d4] = 0x8ac8, [0x85d5] = 0x8ade, [0x85d6] = 0x8ae1, [0x85d7] = 0x8ae8,
  [0x85d8] = 0x8aff, [0x85d9] = 0x8aef, [0x85da] = 0x8afb, [0x85db] = 0x8c91,
  [0x85dc] = 0x8c92, [0x85dd] = 0x8c90, [0x85de] = 0x8cf5, [0x85df] = 0x8cee,
  [0x85e0] = 0x8cf1, [0x85e1] = 0x8cf0, [0x85e2] = 0x8cf3, [0x85e3] = 0x8d6c,
  [0x85e4] = 0x8d6e, [0x85e5] = 0x8da5, [0x85e6] = 0x8da7, [0x85e7] = 0x8e33,
  [0x85e8] = 0x8e3e, [0x85e9] = 0x8e38, [0x85ea] = 0x8e40, [0x85eb] = 0x8e45,
  [0x85ec] = 0x8e36, [0x85ed] = 0x8e3c, [0x85ee] = 0x8e3d, [0x85ef] = 0x8e41,
  [0x85f0] = 0x8e30, [0x85f1] = 0x8e3f, [0x85f2] = 0x8ebd, [0x85f3] = 0x8f36,
  [0x85f4] = 0x8f2e, [0x85f5] = 0x8f35, [0x85f6] = 0x8f32, [0x85f7] = 0x8f39,
  [0x85f8] = 0x8f37, [0x85f9] = 0x8f34, [0x85fa] = 0x9076, [0x85fb] = 0x9079,
  [0x85fc] = 0x907b, [0x85fd] = 0x9086, [0x8641] = 0x90fa, [0x8642] = 0x9133,
  [0x8643] = 0x9135, [0x8644] = 0x9136, [0x8645] = 0x9193, [0x8646] = 0x9190,
  [0x8647] = 0x9191, [0x8648] = 0x918d, [0x8649] = 0x918f, [0x864a] = 0x9327,
  [0x864b] = 0x931e, [0x864c] = 0x9308, [0x864d] = 0x931f, [0x864e] = 0x9306,
  [0x864f] = 0x930f, [0x8650] = 0x937a, [0x8651] = 0x9338, [0x8652] = 0x933c,
  [0x8653] = 0x931b, [0x8654] = 0x9323, [0x8655] = 0x9312, [0x8656] = 0x9301,
  [0x8657] = 0x9346, [0x8658] = 0x932d, [0x8659] = 0x930e, [0x865a] = 0x930d,
  [0x865b] = 0x92cb, [0x865c] = 0x931d, [0x865d] = 0x92fa, [0x865e] = 0x9325,
  [0x865f] = 0x9313, [0x8660] = 0x92f9, [0x8661] = 0x92f7, [0x8662] = 0x9334,
  [0x8663] = 0x9302, [0x8664] = 0x9324, [0x8665] = 0x92ff, [0x8666] = 0x9329,
  [0x8667] = 0x9339, [0x8668] = 0x9335, [0x8669] = 0x932a, [0x866a] = 0x9314,
  [0x866b] = 0x930c, [0x866c] = 0x930b, [0x866d] = 0x92fe, [0x866e] = 0x9309,
  [0x866f] = 0x9300, [0x8670] = 0x92fb, [0x8671] = 0x9316, [0x8672] = 0x95bc,
  [0x8673] = 0x95cd, [0x8674] = 0x95be, [0x8675] = 0x95b9, [0x8676] = 0x95ba,
  [0x8677] = 0x95b6, [0x8678] = 0x95bf, [0x8679] = 0x95b5, [0x867a] = 0x95bd,
  [0x867b] = 0x96a9, [0x867c] = 0x96d4, [0x867d] = 0x970b, [0x867e] = 0x9712,
  [0x867f] = 0x9710, [0x8681] = 0x9799, [0x8682] = 0x9797, [0x8683] = 0x9794,
  [0x8684] = 0x97f0, [0x8685] = 0x97f8, [0x8686] = 0x9835, [0x8687] = 0x982f,
  [0x8688] = 0x9832, [0x8689] = 0x9924, [0x868a] = 0x991f, [0x868b] = 0x9927,
  [0x868c] = 0x9929, [0x868d] = 0x999e, [0x868e] = 0x99ee, [0x868f] = 0x99ec,
  [0x8690] = 0x99e5, [0x8691] = 0x99e4, [0x8692] = 0x99f0, [0x8693] = 0x99e3,
  [0x8694] = 0x99ea, [0x8695] = 0x99e9, [0x8696] = 0x99e7, [0x8697] = 0x9ab9,
  [0x8698] = 0x9abf, [0x8699] = 0x9ab4, [0x869a] = 0x9abb, [0x869b] = 0x9af6,
  [0x869c] = 0x9afa, [0x869d] = 0x9af9, [0x869e] = 0x9af7, [0x869f] = 0x9b33,
  [0x86a0] = 0x9b80, [0x86a1] = 0x9b85, [0x86a2] = 0x9b87, [0x86a3] = 0x9b7c,
  [0x86a4] = 0x9b7e, [0x86a5] = 0x9b7b, [0x86a6] = 0x9b82, [0x86a7] = 0x9b93,
  [0x86a8] = 0x9b92, [0x86a9] = 0x9b90, [0x86aa] = 0x9b7a, [0x86ab] = 0x9b95,
  [0x86ac] = 0x9b7d, [0x86ad] = 0x9b88, [0x86ae] = 0x9d25, [0x86af] = 0x9d17,
  [0x86b0] = 0x9d20, [0x86b1] = 0x9d1e, [0x86b2] = 0x9d14, [0x86b3] = 0x9d29,
  [0x86b4] = 0x9d1d, [0x86b5] = 0x9d18, [0x86b6] = 0x9d22, [0x86b7] = 0x9d10,
  [0x86b8] = 0x9d19, [0x86b9] = 0x9d1f, [0x86ba] = 0x9e88, [0x86bb] = 0x9e86,
  [0x86bc] = 0x9e87, [0x86bd] = 0x9eae, [0x86be] = 0x9ead, [0x86bf] = 0x9ed5,
  [0x86c0] = 0x9ed6, [0x86c1] = 0x9efa, [0x86c2] = 0x9f12, [0x86c3] = 0x9f3d,
  [0x86c4] = 0x5126, [0x86c5] = 0x5125, [0x86c6] = 0x5122, [0x86c7] = 0x5124,
  [0x86c8] = 0x5120, [0x86c9] = 0x5129, [0x86ca] = 0x52f4, [0x86cb] = 0x5693,
  [0x86cc] = 0x568c, [0x86cd] = 0x568d, [0x86ce] = 0x5686, [0x86cf] = 0x5684,
  [0x86d0] = 0x5683, [0x86d1] = 0x567e, [0x86d2] = 0x5682, [0x86d3] = 0x567f,
  [0x86d4] = 0x5681, [0x86d5] = 0x58d6, [0x86d6] = 0x58d4, [0x86d7] = 0x58cf,
  [0x86d8] = 0x58d2, [0x86d9] = 0x5b2d, [0x86da] = 0x5b25, [0x86db] = 0x5b32,
  [0x86dc] = 0x5b23, [0x86dd] = 0x5b2c, [0x86de] = 0x5b27, [0x86df] = 0x5b26,
  [0x86e0] = 0x5b2f, [0x86e1] = 0x5b2e, [0x86e2] = 0x5b7b, [0x86e3] = 0x5bf1,
  [0x86e4] = 0x5bf2, [0x86e5] = 0x5db7, [0x86e6] = 0x5e6c, [0x86e7] = 0x5e6a,
  [0x86e8] = 0x5fbe, [0x86e9] = 0x5fbb, [0x86ea] = 0x61c3, [0x86eb] = 0x61b5,
  [0x86ec] = 0x61bc, [0x86ed] = 0x61e7, [0x86ee] = 0x61e0, [0x86ef] = 0x61e5,
  [0x86f0] = 0x61e4, [0x86f1] = 0x61e8, [0x86f2] = 0x61de, [0x86f3] = 0x64ef,
  [0x86f4] = 0x64e9, [0x86f5] = 0x64e3, [0x86f6] = 0x64eb, [0x86f7] = 0x64e4,
  [0x86f8] = 0x64e8, [0x86f9] = 0x6581, [0x86fa] = 0x6580, [0x86fb] = 0x65b6,
  [0x86fc] = 0x65da, [0x86fd] = 0x66d2, [0x8741] = 0x6a8d, [0x8742] = 0x6a96,
  [0x8743] = 0x6a81, [0x8744] = 0x6aa5, [0x8745] = 0x6a89, [0x8746] = 0x6a9f,
  [0x8747] = 0x6a9b, [0x8748] = 0x6aa1, [0x8749] = 0x6a9e, [0x874a] = 0x6a87,
  [0x874b] = 0x6a93, [0x874c] = 0x6a8e, [0x874d] = 0x6a95, [0x874e] = 0x6a83,
  [0x874f] = 0x6aa8, [0x8750] = 0x6aa4, [0x8751] = 0x6a91, [0x8752] = 0x6a7f,
  [0x8753] = 0x6aa6, [0x8754] = 0x6a9a, [0x8755] = 0x6a85, [0x8756] = 0x6a8c,
  [0x8757] = 0x6a92, [0x8758] = 0x6b5b, [0x8759] = 0x6bad, [0x875a] = 0x6c09,
  [0x875b] = 0x6fcc, [0x875c] = 0x6fa9, [0x875d] = 0x6ff4, [0x875e] = 0x6fd4,
  [0x875f] = 0x6fe3, [0x8760] = 0x6fdc, [0x8761] = 0x6fed, [0x8762] = 0x6fe7,
  [0x8763] = 0x6fe6, [0x8764] = 0x6fde, [0x8765] = 0x6ff2, [0x8766] = 0x6fdd,
  [0x8767] = 0x6fe2, [0x8768] = 0x6fe8, [0x8769] = 0x71e1, [0x876a] = 0x71f1,
  [0x876b] = 0x71e8, [0x876c] = 0x71f2, [0x876d] = 0x71e4, [0x876e] = 0x71f0,
  [0x876f] = 0x71e2, [0x8770] = 0x7373, [0x8771] = 0x736e, [0x8772] = 0x736f,
  [0x8773] = 0x7497, [0x8774] = 0x74b2, [0x8775] = 0x74ab, [0x8776] = 0x7490,
  [0x8777] = 0x74aa, [0x8778] = 0x74ad, [0x8779] = 0x74b1, [0x877a] = 0x74a5,
  [0x877b] = 0x74af, [0x877c] = 0x7510, [0x877d] = 0x7511, [0x877e] = 0x7512,
  [0x877f] = 0x750f, [0x8781] = 0x7584, [0x8782] = 0x7643, [0x8783] = 0x7648,
  [0x8784] = 0x7649, [0x8785] = 0x7647, [0x8786] = 0x76a4, [0x8787] = 0x76e9,
  [0x8788] = 0x77b5, [0x8789] = 0x77ab, [0x878a] = 0x77b2, [0x878b] = 0x77b7,
  [0x878c] = 0x77b6, [0x878d] = 0x77b4, [0x878e] = 0x77b1, [0x878f] = 0x77a8,
  [0x8790] = 0x77f0, [0x8791] = 0x78f3, [0x8792] = 0x78fd, [0x8793] = 0x7902,
  [0x8794] = 0x78fb, [0x8795] = 0x78fc, [0x8796] = 0x78f2, [0x8797] = 0x7905,
  [0x8798] = 0x78f9, [0x8799] = 0x78fe, [0x879a] = 0x7904, [0x879b] = 0x79ab,
  [0x879c] = 0x79a8, [0x879d] = 0x7a5c, [0x879e] = 0x7a5b, [0x879f] = 0x7a56,
  [0x87a0] = 0x7a58, [0x87a1] = 0x7a54, [0x87a2] = 0x7a5a, [0x87a3] = 0x7abe,
  [0x87a4] = 0x7ac0, [0x87a5] = 0x7ac1, [0x87a6] = 0x7c05, [0x87a7] = 0x7c0f,
  [0x87a8] = 0x7bf2, [0x87a9] = 0x7c00, [0x87aa] = 0x7bff, [0x87ab] = 0x7bfb,
  [0x87ac] = 0x7c0e, [0x87ad] = 0x7bf4, [0x87ae] = 0x7c0b, [0x87af] = 0x7bf3,
  [0x87b0] = 0x7c02, [0x87b1] = 0x7c09, [0x87b2] = 0x7c03, [0x87b3] = 0x7c01,
  [0x87b4] = 0x7bf8, [0x87b5] = 0x7bfd, [0x87b6] = 0x7c06, [0x87b7] = 0x7bf0,
  [0x87b8] = 0x7bf1, [0x87b9] = 0x7c10, [0x87ba] = 0x7c0a, [0x87bb] = 0x7ce8,
  [0x87bc] = 0x7e2d, [0x87bd] = 0x7e3c, [0x87be] = 0x7e42, [0x87bf] = 0x7e33,
  [0x87c0] = 0x9848, [0x87c1] = 0x7e38, [0x87c2] = 0x7e2a, [0x87c3] = 0x7e49,
  [0x87c4] = 0x7e40, [0x87c5] = 0x7e47, [0x87c6] = 0x7e29, [0x87c7] = 0x7e4c,
  [0x87c8] = 0x7e30, [0x87c9] = 0x7e3b, [0x87ca] = 0x7e36, [0x87cb] = 0x7e44,
  [0x87cc] = 0x7e3a, [0x87cd] = 0x7f45, [0x87ce] = 0x7f7f, [0x87cf] = 0x7f7e,
  [0x87d0] = 0x7f7d, [0x87d1] = 0x7ff4, [0x87d2] = 0x7ff2, [0x87d3] = 0x802c,
  [0x87d4] = 0x81bb, [0x87d5] = 0x81c4, [0x87d6] = 0x81cc, [0x87d7] = 0x81ca,
  [0x87d8] = 0x81c5, [0x87d9] = 0x81c7, [0x87da] = 0x81bc, [0x87db] = 0x81e9,
  [0x87dc] = 0x825b, [0x87dd] = 0x825a, [0x87de] = 0x825c, [0x87df] = 0x8583,
  [0x87e0] = 0x8580, [0x87e1] = 0x858f, [0x87e2] = 0x85a7, [0x87e3] = 0x8595,
  [0x87e4] = 0x85a0, [0x87e5] = 0x858b, [0x87e6] = 0x85a3, [0x87e7] = 0x857b,
  [0x87e8] = 0x85a4, [0x87e9] = 0x859a, [0x87ea] = 0x859e, [0x87eb] = 0x8577,
  [0x87ec] = 0x857c, [0x87ed] = 0x8589, [0x87ee] = 0x85a1, [0x87ef] = 0x857a,
  [0x87f0] = 0x8578, [0x87f1] = 0x8557, [0x87f2] = 0x858e, [0x87f3] = 0x8596,
  [0x87f4] = 0x8586, [0x87f5] = 0x858d, [0x87f6] = 0x8599, [0x87f7] = 0x859d,
  [0x87f8] = 0x8581, [0x87f9] = 0x85a2, [0x87fa] = 0x8582, [0x87fb] = 0x8588,
  [0x87fc] = 0x8585, [0x87fd] = 0x8579, [0x8841] = 0x8576, [0x8842] = 0x8598,
  [0x8843] = 0x8590, [0x8844] = 0x859f, [0x8845] = 0x8668, [0x8846] = 0x87be,
  [0x8847] = 0x87aa, [0x8848] = 0x87ad, [0x8849] = 0x87c5, [0x884a] = 0x87b0,
  [0x884b] = 0x87ac, [0x884c] = 0x87b9, [0x884d] = 0x87b5, [0x884e] = 0x87bc,
  [0x884f] = 0x87ae, [0x8850] = 0x87c9, [0x8851] = 0x87c3, [0x8852] = 0x87c2,
  [0x8853] = 0x87cc, [0x8854] = 0x87b7, [0x8855] = 0x87af, [0x8856] = 0x87c4,
  [0x8857] = 0x87ca, [0x8858] = 0x87b4, [0x8859] = 0x87b6, [0x885a] = 0x87bf,
  [0x885b] = 0x87b8, [0x885c] = 0x87bd, [0x885d] = 0x87de, [0x885e] = 0x87b2,
  [0x885f] = 0x8935, [0x8860] = 0x8933, [0x8861] = 0x893c, [0x8862] = 0x893e,
  [0x8863] = 0x8941, [0x8864] = 0x8952, [0x8865] = 0x8937, [0x8866] = 0x8942,
  [0x8867] = 0x89ad, [0x8868] = 0x89af, [0x8869] = 0x89ae, [0x886a] = 0x89f2,
  [0x886b] = 0x89f3, [0x886c] = 0x8b1e, [0x886d] = 0x8b18, [0x886e] = 0x8b16,
  [0x886f] = 0x8b11, [0x8870] = 0x8b05, [0x8871] = 0x8b0b, [0x8872] = 0x8b22,
  [0x8873] = 0x8b0f, [0x8874] = 0x8b12, [0x8875] = 0x8b15, [0x8876] = 0x8b07,
  [0x8877] = 0x8b0d, [0x8878] = 0x8b08, [0x8879] = 0x8b06, [0x887a] = 0x8b1c,
  [0x887b] = 0x8b13, [0x887c] = 0x8b1a, [0x887d] = 0x8c4f, [0x887e] = 0x8c70,
  [0x887f] = 0x8c72, [0x8881] = 0x8c71, [0x8882] = 0x8c6f, [0x8883] = 0x8c95,
  [0x8884] = 0x8c94, [0x8885] = 0x8cf9, [0x8886] = 0x8d6f, [0x8887] = 0x8e4e,
  [0x8888] = 0x8e4d, [0x8889] = 0x8e53, [0x888a] = 0x8e50, [0x888b] = 0x8e4c,
  [0x888c] = 0x8e47, [0x888d] = 0x8f43, [0x888e] = 0x8f40, [0x888f] = 0x9085,
  [0x8890] = 0x907e, [0x8891] = 0x9138, [0x8892] = 0x919a, [0x8893] = 0x91a2,
  [0x8894] = 0x919b, [0x8895] = 0x9199, [0x8896] = 0x919f, [0x8897] = 0x91a1,
  [0x8898] = 0x919d, [0x8899] = 0x91a0, [0x889a] = 0x93a1, [0x889b] = 0x9383,
  [0x889c] = 0x93af, [0x889d] = 0x9364, [0x889e] = 0x9356, [0x889f] = 0x9347,
  [0x88a0] = 0x937c, [0x88a1] = 0x9358, [0x88a2] = 0x935c, [0x88a3] = 0x9376,
  [0x88a4] = 0x9349, [0x88a5] = 0x9350, [0x88a6] = 0x9351, [0x88a7] = 0x9360,
  [0x88a8] = 0x936d, [0x88a9] = 0x938f, [0x88aa] = 0x934c, [0x88ab] = 0x936a,
  [0x88ac] = 0x9379, [0x88ad] = 0x9357, [0x88ae] = 0x9355, [0x88af] = 0x9352,
  [0x88b0] = 0x934f, [0x88b1] = 0x9371, [0x88b2] = 0x9377, [0x88b3] = 0x937b,
  [0x88b4] = 0x9361, [0x88b5] = 0x935e, [0x88b6] = 0x9363, [0x88b7] = 0x9367,
  [0x88b8] = 0x9380, [0x88b9] = 0x934e, [0x88ba] = 0x9359, [0x88bb] = 0x95c7,
  [0x88bc] = 0x95c0, [0x88bd] = 0x95c9, [0x88be] = 0x95c3, [0x88bf] = 0x95c5,
  [0x88c0] = 0x95b7, [0x88c1] = 0x96ae, [0x88c2] = 0x96b0, [0x88c3] = 0x96ac,
  [0x88c4] = 0x9720, [0x88c5] = 0x971f, [0x88c6] = 0x9718, [0x88c7] = 0x971d,
  [0x88c8] = 0x9719, [0x88c9] = 0x979a, [0x88ca] = 0x97a1, [0x88cb] = 0x979c,
  [0x88cc] = 0x979e, [0x88cd] = 0x979d, [0x88ce] = 0x97d5, [0x88cf] = 0x97d4,
  [0x88d0] = 0x97f1, [0x88d1] = 0x9841, [0x88d2] = 0x9844, [0x88d3] = 0x984a,
  [0x88d4] = 0x9849, [0x88d5] = 0x9845, [0x88d6] = 0x9843, [0x88d7] = 0x9925,
  [0x88d8] = 0x992b, [0x88d9] = 0x992c, [0x88da] = 0x992a, [0x88db] = 0x9933,
  [0x88dc] = 0x9932, [0x88dd] = 0x992f, [0x88de] = 0x992d, [0x88df] = 0x9931,
  [0x88e0] = 0x9930, [0x88e1] = 0x9998, [0x88e2] = 0x99a3, [0x88e3] = 0x99a1,
  [0x88e4] = 0x9a02, [0x88e5] = 0x99fa, [0x88e6] = 0x99f4, [0x88e7] = 0x99f7,
  [0x88e8] = 0x99f9, [0x88e9] = 0x99f8, [0x88ea] = 0x99f6, [0x88eb] = 0x99fb,
  [0x88ec] = 0x99fd, [0x88ed] = 0x99fe, [0x88ee] = 0x99fc, [0x88ef] = 0x9a03,
  [0x88f0] = 0x9abe, [0x88f1] = 0x9afe, [0x88f2] = 0x9afd, [0x88f3] = 0x9b01,
  [0x88f4] = 0x9afc, [0x88f5] = 0x9b48, [0x88f6] = 0x9b9a, [0x88f7] = 0x9ba8,
  [0x88f8] = 0x9b9e, [0x88f9] = 0x9b9b, [0x88fa] = 0x9ba6, [0x88fb] = 0x9ba1,
  [0x88fc] = 0x9ba5, [0x88fd] = 0x9ba4, [0x8941] = 0x9b86, [0x8942] = 0x9ba2,
  [0x8943] = 0x9ba0, [0x8944] = 0x9baf, [0x8945] = 0x9d33, [0x8946] = 0x9d41,
  [0x8947] = 0x9d67, [0x8948] = 0x9d36, [0x8949] = 0x9d2e, [0x894a] = 0x9d2f,
  [0x894b] = 0x9d31, [0x894c] = 0x9d38, [0x894d] = 0x9d30, [0x894e] = 0x9d45,
  [0x894f] = 0x9d42, [0x8950] = 0x9d43, [0x8951] = 0x9d3e, [0x8952] = 0x9d37,
  [0x8953] = 0x9d40, [0x8954] = 0x9d3d, [0x8955] = 0x7ff5, [0x8956] = 0x9d2d,
  [0x8957] = 0x9e8a, [0x8958] = 0x9e89, [0x8959] = 0x9e8d, [0x895a] = 0x9eb0,
  [0x895b] = 0x9ec8, [0x895c] = 0x9eda, [0x895d] = 0x9efb, [0x895e] = 0x9eff,
  [0x895f] = 0x9f24, [0x8960] = 0x9f23, [0x8961] = 0x9f22, [0x8962] = 0x9f54,
  [0x8963] = 0x9fa0, [0x8964] = 0x5131, [0x8965] = 0x512d, [0x8966] = 0x512e,
  [0x8967] = 0x5698, [0x8968] = 0x569c, [0x8969] = 0x5697, [0x896a] = 0x569a,
  [0x896b] = 0x569d, [0x896c] = 0x5699, [0x896d] = 0x5970, [0x896e] = 0x5b3c,
  [0x896f] = 0x5c69, [0x8970] = 0x5c6a, [0x8971] = 0x5dc0, [0x8972] = 0x5e6d,
  [0x8973] = 0x5e6e, [0x8974] = 0x61d8, [0x8975] = 0x61df, [0x8976] = 0x61ed,
  [0x8977] = 0x61ee, [0x8978] = 0x61f1, [0x8979] = 0x61ea, [0x897a] = 0x61f0,
  [0x897b] = 0x61eb, [0x897c] = 0x61d6, [0x897d] = 0x61e9, [0x897e] = 0x64ff,
  [0x897f] = 0x6504, [0x8981] = 0x64fd, [0x8982] = 0x64f8, [0x8983] = 0x6501,
  [0x8984] = 0x6503, [0x8985] = 0x64fc, [0x8986] = 0x6594, [0x8987] = 0x65db,
  [0x8988] = 0x66da, [0x8989] = 0x66db, [0x898a] = 0x66d8, [0x898b] = 0x6ac5,
  [0x898c] = 0x6ab9, [0x898d] = 0x6abd, [0x898e] = 0x6ae1, [0x898f] = 0x6ac6,
  [0x8990] = 0x6aba, [0x8991] = 0x6ab6, [0x8992] = 0x6ab7, [0x8993] = 0x6ac7,
  [0x8994] = 0x6ab4, [0x8995] = 0x6aad, [0x8996] = 0x6b5e, [0x8997] = 0x6bc9,
  [0x8998] = 0x6c0b, [0x8999] = 0x7007, [0x899a] = 0x700c, [0x899b] = 0x700d,
  [0x899c] = 0x7001, [0x899d] = 0x7005, [0x899e] = 0x7014, [0x899f] = 0x700e,
  [0x89a0] = 0x6fff, [0x89a1] = 0x7000, [0x89a2] = 0x6ffb, [0x89a3] = 0x7026,
  [0x89a4] = 0x6ffc, [0x89a5] = 0x6ff7, [0x89a6] = 0x700a, [0x89a7] = 0x7201,
  [0x89a8] = 0x71ff, [0x89a9] = 0x71f9, [0x89aa] = 0x7203, [0x89ab] = 0x71fd,
  [0x89ac] = 0x7376, [0x89ad] = 0x74b8, [0x89ae] = 0x74c0, [0x89af] = 0x74b5,
  [0x89b0] = 0x74c1, [0x89b1] = 0x74be, [0x89b2] = 0x74b6, [0x89b3] = 0x74bb,
  [0x89b4] = 0x74c2, [0x89b5] = 0x7514, [0x89b6] = 0x7513, [0x89b7] = 0x765c,
  [0x89b8] = 0x7664, [0x89b9] = 0x7659, [0x89ba] = 0x7650, [0x89bb] = 0x7653,
  [0x89bc] = 0x7657, [0x89bd] = 0x765a, [0x89be] = 0x76a6, [0x89bf] = 0x76bd,
  [0x89c0] = 0x76ec, [0x89c1] = 0x77c2, [0x89c2] = 0x77ba, [0x89c3] = 0x78ff,
  [0x89c4] = 0x790c, [0x89c5] = 0x7913, [0x89c6] = 0x7914, [0x89c7] = 0x7909,
  [0x89c8] = 0x7910, [0x89c9] = 0x7912, [0x89ca] = 0x7911, [0x89cb] = 0x79ad,
  [0x89cc] = 0x79ac, [0x89cd] = 0x7a5f, [0x89ce] = 0x7c1c, [0x89cf] = 0x7c29,
  [0x89d0] = 0x7c19, [0x89d1] = 0x7c20, [0x89d2] = 0x7c1f, [0x89d3] = 0x7c2d,
  [0x89d4] = 0x7c1d, [0x89d5] = 0x7c26, [0x89d6] = 0x7c28, [0x89d7] = 0x7c22,
  [0x89d8] = 0x7c25, [0x89d9] = 0x7c30, [0x89da] = 0x7e5c, [0x89db] = 0x7e50,
  [0x89dc] = 0x7e56, [0x89dd] = 0x7e63, [0x89de] = 0x7e58, [0x89df] = 0x7e62,
  [0x89e0] = 0x7e5f, [0x89e1] = 0x7e51, [0x89e2] = 0x7e60, [0x89e3] = 0x7e57,
  [0x89e4] = 0x7e53, [0x89e5] = 0x7fb5, [0x89e6] = 0x7fb3, [0x89e7] = 0x7ff7,
  [0x89e8] = 0x7ff8, [0x89e9] = 0x8075, [0x89ea] = 0x81d1, [0x89eb] = 0x81d2,
  [0x89ec] = 0x81d0, [0x89ed] = 0x825f, [0x89ee] = 0x825e, [0x89ef] = 0x85b4,
  [0x89f0] = 0x85c6, [0x89f1] = 0x85c0, [0x89f2] = 0x85c3, [0x89f3] = 0x85c2,
  [0x89f4] = 0x85b3, [0x89f5] = 0x85b5, [0x89f6] = 0x85bd, [0x89f7] = 0x85c7,
  [0x89f8] = 0x85c4, [0x89f9] = 0x85bf, [0x89fa] = 0x85cb, [0x89fb] = 0x85ce,
  [0x89fc] = 0x85c8, [0x89fd] = 0x85c5, [0x8a41] = 0x85b1, [0x8a42] = 0x85b6,
  [0x8a43] = 0x85d2, [0x8a44] = 0x8624, [0x8a45] = 0x85b8, [0x8a46] = 0x85b7,
  [0x8a47] = 0x85be, [0x8a48] = 0x8669, [0x8a49] = 0x87e7, [0x8a4a] = 0x87e6,
  [0x8a4b] = 0x87e2, [0x8a4c] = 0x87db, [0x8a4d] = 0x87eb, [0x8a4e] = 0x87ea,
  [0x8a4f] = 0x87e5, [0x8a50] = 0x87df, [0x8a51] = 0x87f3, [0x8a52] = 0x87e4,
  [0x8a53] = 0x87d4, [0x8a54] = 0x87dc, [0x8a55] = 0x87d3, [0x8a56] = 0x87ed,
  [0x8a57] = 0x87d8, [0x8a58] = 0x87e3, [0x8a59] = 0x87a4, [0x8a5a] = 0x87d7,
  [0x8a5b] = 0x87d9, [0x8a5c] = 0x8801, [0x8a5d] = 0x87f4, [0x8a5e] = 0x87e8,
  [0x8a5f] = 0x87dd, [0x8a60] = 0x8953, [0x8a61] = 0x894b, [0x8a62] = 0x894f,
  [0x8a63] = 0x894c, [0x8a64] = 0x8946, [0x8a65] = 0x8950, [0x8a66] = 0x8951,
  [0x8a67] = 0x8949, [0x8a68] = 0x8b2a, [0x8a69] = 0x8b27, [0x8a6a] = 0x8b23,
  [0x8a6b] = 0x8b33, [0x8a6c] = 0x8b30, [0x8a6d] = 0x8b35, [0x8a6e] = 0x8b47,
  [0x8a6f] = 0x8b2f, [0x8a70] = 0x8b3c, [0x8a71] = 0x8b3e, [0x8a72] = 0x8b31,
  [0x8a73] = 0x8b25, [0x8a74] = 0x8b37, [0x8a75] = 0x8b26, [0x8a76] = 0x8b36,
  [0x8a77] = 0x8b2e, [0x8a78] = 0x8b24, [0x8a79] = 0x8b3b, [0x8a7a] = 0x8b3d,
  [0x8a7b] = 0x8b3a, [0x8a7c] = 0x8c42, [0x8a7d] = 0x8c75, [0x8a7e] = 0x8c99,
  [0x8a7f] = 0x8c98, [0x8a81] = 0x8c97, [0x8a82] = 0x8cfe, [0x8a83] = 0x8d04,
  [0x8a84] = 0x8d02, [0x8a85] = 0x8d00, [0x8a86] = 0x8e5c, [0x8a87] = 0x8e62,
  [0x8a88] = 0x8e60, [0x8a89] = 0x8e57, [0x8a8a] = 0x8e56, [0x8a8b] = 0x8e5e,
  [0x8a8c] = 0x8e65, [0x8a8d] = 0x8e67, [0x8a8e] = 0x8e5b, [0x8a8f] = 0x8e5a,
  [0x8a90] = 0x8e61, [0x8a91] = 0x8e5d, [0x8a92] = 0x8e69, [0x8a93] = 0x8e54,
  [0x8a94] = 0x8f46, [0x8a95] = 0x8f47, [0x8a96] = 0x8f48, [0x8a97] = 0x8f4b,
  [0x8a98] = 0x9128, [0x8a99] = 0x913a, [0x8a9a] = 0x913b, [0x8a9b] = 0x913e,
  [0x8a9c] = 0x91a8, [0x8a9d] = 0x91a5, [0x8a9e] = 0x91a7, [0x8a9f] = 0x91af,
  [0x8aa0] = 0x91aa, [0x8aa1] = 0x93b5, [0x8aa2] = 0x938c, [0x8aa3] = 0x9392,
  [0x8aa4] = 0x93b7, [0x8aa5] = 0x939b, [0x8aa6] = 0x939d, [0x8aa7] = 0x9389,
  [0x8aa8] = 0x93a7, [0x8aa9] = 0x938e, [0x8aaa] = 0x93aa, [0x8aab] = 0x939e,
  [0x8aac] = 0x93a6, [0x8aad] = 0x9395, [0x8aae] = 0x9388, [0x8aaf] = 0x9399,
  [0x8ab0] = 0x939f, [0x8ab1] = 0x938d, [0x8ab2] = 0x93b1, [0x8ab3] = 0x9391,
  [0x8ab4] = 0x93b2, [0x8ab5] = 0x93a4, [0x8ab6] = 0x93a8, [0x8ab7] = 0x93b4,
  [0x8ab8] = 0x93a3, [0x8ab9] = 0x93a5, [0x8aba] = 0x95d2, [0x8abb] = 0x95d3,
  [0x8abc] = 0x95d1, [0x8abd] = 0x96b3, [0x8abe] = 0x96d7, [0x8abf] = 0x96da,
  [0x8ac0] = 0x5dc2, [0x8ac1] = 0x96df, [0x8ac2] = 0x96d8, [0x8ac3] = 0x96dd,
  [0x8ac4] = 0x9723, [0x8ac5] = 0x9722, [0x8ac6] = 0x9725, [0x8ac7] = 0x97ac,
  [0x8ac8] = 0x97ae, [0x8ac9] = 0x97a8, [0x8aca] = 0x97ab, [0x8acb] = 0x97a4,
  [0x8acc] = 0x97aa, [0x8acd] = 0x97a2, [0x8ace] = 0x97a5, [0x8acf] = 0x97d7,
  [0x8ad0] = 0x97d9, [0x8ad1] = 0x97d6, [0x8ad2] = 0x97d8, [0x8ad3] = 0x97fa,
  [0x8ad4] = 0x9850, [0x8ad5] = 0x9851, [0x8ad6] = 0x9852, [0x8ad7] = 0x98b8,
  [0x8ad8] = 0x9941, [0x8ad9] = 0x993c, [0x8ada] = 0x993a, [0x8adb] = 0x9a0f,
  [0x8adc] = 0x9a0b, [0x8add] = 0x9a09, [0x8ade] = 0x9a0d, [0x8adf] = 0x9a04,
  [0x8ae0] = 0x9a11, [0x8ae1] = 0x9a0a, [0x8ae2] = 0x9a05, [0x8ae3] = 0x9a07,
  [0x8ae4] = 0x9a06, [0x8ae5] = 0x9ac0, [0x8ae6] = 0x9adc, [0x8ae7] = 0x9b08,
  [0x8ae8] = 0x9b04, [0x8ae9] = 0x9b05, [0x8aea] = 0x9b29, [0x8aeb] = 0x9b35,
  [0x8aec] = 0x9b4a, [0x8aed] = 0x9b4c, [0x8aee] = 0x9b4b, [0x8aef] = 0x9bc7,
  [0x8af0] = 0x9bc6, [0x8af1] = 0x9bc3, [0x8af2] = 0x9bbf, [0x8af3] = 0x9bc1,
  [0x8af4] = 0x9bb5, [0x8af5] = 0x9bb8, [0x8af6] = 0x9bd3, [0x8af7] = 0x9bb6,
  [0x8af8] = 0x9bc4, [0x8af9] = 0x9bb9, [0x8afa] = 0x9bbd, [0x8afb] = 0x9d5c,
  [0x8afc] = 0x9d53, [0x8afd] = 0x9d4f, [0x8b41] = 0x9d4a, [0x8b42] = 0x9d5b,
  [0x8b43] = 0x9d4b, [0x8b44] = 0x9d59, [0x8b45] = 0x9d56, [0x8b46] = 0x9d4c,
  [0x8b47] = 0x9d57, [0x8b48] = 0x9d52, [0x8b49] = 0x9d54, [0x8b4a] = 0x9d5f,
  [0x8b4b] = 0x9d58, [0x8b4c] = 0x9d5a, [0x8b4d] = 0x9e8e, [0x8b4e] = 0x9e8c,
  [0x8b4f] = 0x9edf, [0x8b50] = 0x9f01, [0x8b51] = 0x9f00, [0x8b52] = 0x9f16,
  [0x8b53] = 0x9f25, [0x8b54] = 0x9f2b, [0x8b55] = 0x9f2a, [0x8b56] = 0x9f29,
  [0x8b57] = 0x9f28, [0x8b58] = 0x9f4c, [0x8b59] = 0x9f55, [0x8b5a] = 0x5134,
  [0x8b5b] = 0x5135, [0x8b5c] = 0x5296, [0x8b5d] = 0x52f7, [0x8b5e] = 0x53b4,
  [0x8b5f] = 0x56ab, [0x8b60] = 0x56ad, [0x8b61] = 0x56a6, [0x8b62] = 0x56a7,
  [0x8b63] = 0x56aa, [0x8b64] = 0x56ac, [0x8b65] = 0x58da, [0x8b66] = 0x58dd,
  [0x8b67] = 0x58db, [0x8b68] = 0x5912, [0x8b69] = 0x5b3d, [0x8b6a] = 0x5b3e,
  [0x8b6b] = 0x5b3f, [0x8b6c] = 0x5dc3, [0x8b6d] = 0x5e70, [0x8b6e] = 0x5fbf,
  [0x8b6f] = 0x61fb, [0x8b70] = 0x6507, [0x8b71] = 0x6510, [0x8b72] = 0x650d,
  [0x8b73] = 0x6509, [0x8b74] = 0x650c, [0x8b75] = 0x650e, [0x8b76] = 0x6584,
  [0x8b77] = 0x65de, [0x8b78] = 0x65dd, [0x8b79] = 0x66de, [0x8b7a] = 0x6ae7,
  [0x8b7b] = 0x6ae0, [0x8b7c] = 0x6acc, [0x8b7d] = 0x6ad1, [0x8b7e] = 0x6ad9,
  [0x8b7f] = 0x6acb, [0x8b81] = 0x6adf, [0x8b82] = 0x6adc, [0x8b83] = 0x6ad0,
  [0x8b84] = 0x6aeb, [0x8b85] = 0x6acf, [0x8b86] = 0x6acd, [0x8b87] = 0x6ade,
  [0x8b88] = 0x6b60, [0x8b89] = 0x6bb0, [0x8b8a] = 0x6c0c, [0x8b8b] = 0x7019,
  [0x8b8c] = 0x7027, [0x8b8d] = 0x7020, [0x8b8e] = 0x7016, [0x8b8f] = 0x702b,
  [0x8b90] = 0x7021, [0x8b91] = 0x7022, [0x8b92] = 0x7023, [0x8b93] = 0x7029,
  [0x8b94] = 0x7017, [0x8b95] = 0x7024, [0x8b96] = 0x701c, [0x8b97] = 0x702a,
  [0x8b98] = 0x720c, [0x8b99] = 0x720a, [0x8b9a] = 0x7207, [0x8b9b] = 0x7202,
  [0x8b9c] = 0x7205, [0x8b9d] = 0x72a5, [0x8b9e] = 0x72a6, [0x8b9f] = 0x72a4,
  [0x8ba0] = 0x72a3, [0x8ba1] = 0x72a1, [0x8ba2] = 0x74cb, [0x8ba3] = 0x74c5,
  [0x8ba4] = 0x74b7, [0x8ba5] = 0x74c3, [0x8ba6] = 0x7516, [0x8ba7] = 0x7660,
  [0x8ba8] = 0x77c9, [0x8ba9] = 0x77ca, [0x8baa] = 0x77c4, [0x8bab] = 0x77f1,
  [0x8bac] = 0x791d, [0x8bad] = 0x791b, [0x8bae] = 0x7921, [0x8baf] = 0x791c,
  [0x8bb0] = 0x7917, [0x8bb1] = 0x791e, [0x8bb2] = 0x79b0, [0x8bb3] = 0x7a67,
  [0x8bb4] = 0x7a68, [0x8bb5] = 0x7c33, [0x8bb6] = 0x7c3c, [0x8bb7] = 0x7c39,
  [0x8bb8] = 0x7c2c, [0x8bb9] = 0x7c3b, [0x8bba] = 0x7cec, [0x8bbb] = 0x7cea,
  [0x8bbc] = 0x7e76, [0x8bbd] = 0x7e75, [0x8bbe] = 0x7e78, [0x8bbf] = 0x7e70,
  [0x8bc0] = 0x7e77, [0x8bc1] = 0x7e6f, [0x8bc2] = 0x7e7a, [0x8bc3] = 0x7e72,
  [0x8bc4] = 0x7e74, [0x8bc5] = 0x7e68, [0x8bc6] = 0x7f4b, [0x8bc7] = 0x7f4a,
  [0x8bc8] = 0x7f83, [0x8bc9] = 0x7f86, [0x8bca] = 0x7fb7, [0x8bcb] = 0x7ffd,
  [0x8bcc] = 0x7ffe, [0x8bcd] = 0x8078, [0x8bce] = 0x81d7, [0x8bcf] = 0x81d5,
  [0x8bd0] = 0x8264, [0x8bd1] = 0x8261, [0x8bd2] = 0x8263, [0x8bd3] = 0x85eb,
  [0x8bd4] = 0x85f1, [0x8bd5] = 0x85ed, [0x8bd6] = 0x85d9, [0x8bd7] = 0x85e1,
  [0x8bd8] = 0x85e8, [0x8bd9] = 0x85da, [0x8bda] = 0x85d7, [0x8bdb] = 0x85ec,
  [0x8bdc] = 0x85f2, [0x8bdd] = 0x85f8, [0x8bde] = 0x85d8, [0x8bdf] = 0x85df,
  [0x8be0] = 0x85e3, [0x8be1] = 0x85dc, [0x8be2] = 0x85d1, [0x8be3] = 0x85f0,
  [0x8be4] = 0x85e6, [0x8be5] = 0x85ef, [0x8be6] = 0x85de, [0x8be7] = 0x85e2,
  [0x8be8] = 0x8800, [0x8be9] = 0x87fa, [0x8bea] = 0x8803, [0x8beb] = 0x87f6,
  [0x8bec] = 0x87f7, [0x8bed] = 0x8809, [0x8bee] = 0x880c, [0x8bef] = 0x880b,
  [0x8bf0] = 0x8806, [0x8bf1] = 0x87fc, [0x8bf2] = 0x8808, [0x8bf3] = 0x87ff,
  [0x8bf4] = 0x880a, [0x8bf5] = 0x8802, [0x8bf6] = 0x8962, [0x8bf7] = 0x895a,
  [0x8bf8] = 0x895b, [0x8bf9] = 0x8957, [0x8bfa] = 0x8961, [0x8bfb] = 0x895c,
  [0x8bfc] = 0x8958, [0x8bfd] = 0x895d, [0x8c41] = 0x8959, [0x8c42] = 0x8988,
  [0x8c43] = 0x89b7, [0x8c44] = 0x89b6, [0x8c45] = 0x89f6, [0x8c46] = 0x8b50,
  [0x8c47] = 0x8b48, [0x8c48] = 0x8b4a, [0x8c49] = 0x8b40, [0x8c4a] = 0x8b53,
  [0x8c4b] = 0x8b56, [0x8c4c] = 0x8b54, [0x8c4d] = 0x8b4b, [0x8c4e] = 0x8b55,
  [0x8c4f] = 0x8b51, [0x8c50] = 0x8b42, [0x8c51] = 0x8b52, [0x8c52] = 0x8b57,
  [0x8c53] = 0x8c43, [0x8c54] = 0x8c77, [0x8c55] = 0x8c76, [0x8c56] = 0x8c9a,
  [0x8c57] = 0x8d06, [0x8c58] = 0x8d07, [0x8c59] = 0x8d09, [0x8c5a] = 0x8dac,
  [0x8c5b] = 0x8daa, [0x8c5c] = 0x8dad, [0x8c5d] = 0x8dab, [0x8c5e] = 0x8e6d,
  [0x8c5f] = 0x8e78, [0x8c60] = 0x8e73, [0x8c61] = 0x8e6a, [0x8c62] = 0x8e6f,
  [0x8c63] = 0x8e7b, [0x8c64] = 0x8ec2, [0x8c65] = 0x8f52, [0x8c66] = 0x8f51,
  [0x8c67] = 0x8f4f, [0x8c68] = 0x8f50, [0x8c69] = 0x8f53, [0x8c6a] = 0x8fb4,
  [0x8c6b] = 0x9140, [0x8c6c] = 0x913f, [0x8c6d] = 0x91b0, [0x8c6e] = 0x91ad,
  [0x8c6f] = 0x93de, [0x8c70] = 0x93c7, [0x8c71] = 0x93cf, [0x8c72] = 0x93c2,
  [0x8c73] = 0x93da, [0x8c74] = 0x93d0, [0x8c75] = 0x93f9, [0x8c76] = 0x93ec,
  [0x8c77] = 0x93cc, [0x8c78] = 0x93d9, [0x8c79] = 0x93a9, [0x8c7a] = 0x93e6,
  [0x8c7b] = 0x93ca, [0x8c7c] = 0x93d4, [0x8c7d] = 0x93ee, [0x8c7e] = 0x93e3,
  [0x8c7f] = 0x93d5, [0x8c81] = 0x93c4, [0x8c82] = 0x93ce, [0x8c83] = 0x93c0,
  [0x8c84] = 0x93d2, [0x8c85] = 0x93e7, [0x8c86] = 0x957d, [0x8c87] = 0x95da,
  [0x8c88] = 0x95db, [0x8c89] = 0x96e1, [0x8c8a] = 0x9729, [0x8c8b] = 0x972b,
  [0x8c8c] = 0x972c, [0x8c8d] = 0x9728, [0x8c8e] = 0x9726, [0x8c8f] = 0x97b3,
  [0x8c90] = 0x97b7, [0x8c91] = 0x97b6, [0x8c92] = 0x97dd, [0x8c93] = 0x97de,
  [0x8c94] = 0x97df, [0x8c95] = 0x985c, [0x8c96] = 0x9859, [0x8c97] = 0x985d,
  [0x8c98] = 0x9857, [0x8c99] = 0x98bf, [0x8c9a] = 0x98bd, [0x8c9b] = 0x98bb,
  [0x8c9c] = 0x98be, [0x8c9d] = 0x9948, [0x8c9e] = 0x9947, [0x8c9f] = 0x9943,
  [0x8ca0] = 0x99a6, [0x8ca1] = 0x99a7, [0x8ca2] = 0x9a1a, [0x8ca3] = 0x9a15,
  [0x8ca4] = 0x9a25, [0x8ca5] = 0x9a1d, [0x8ca6] = 0x9a24, [0x8ca7] = 0x9a1b,
  [0x8ca8] = 0x9a22, [0x8ca9] = 0x9a20, [0x8caa] = 0x9a27, [0x8cab] = 0x9a23,
  [0x8cac] = 0x9a1e, [0x8cad] = 0x9a1c, [0x8cae] = 0x9a14, [0x8caf] = 0x9ac2,
  [0x8cb0] = 0x9b0b, [0x8cb1] = 0x9b0a, [0x8cb2] = 0x9b0e, [0x8cb3] = 0x9b0c,
  [0x8cb4] = 0x9b37, [0x8cb5] = 0x9bea, [0x8cb6] = 0x9beb, [0x8cb7] = 0x9be0,
  [0x8cb8] = 0x9bde, [0x8cb9] = 0x9be4, [0x8cba] = 0x9be6, [0x8cbb] = 0x9be2,
  [0x8cbc] = 0x9bf0, [0x8cbd] = 0x9bd4, [0x8cbe] = 0x9bd7, [0x8cbf] = 0x9bec,
  [0x8cc0] = 0x9bdc, [0x8cc1] = 0x9bd9, [0x8cc2] = 0x9be5, [0x8cc3] = 0x9bd5,
  [0x8cc4] = 0x9be1, [0x8cc5] = 0x9bda, [0x8cc6] = 0x9d77, [0x8cc7] = 0x9d81,
  [0x8cc8] = 0x9d8a, [0x8cc9] = 0x9d84, [0x8cca] = 0x9d88, [0x8ccb] = 0x9d71,
  [0x8ccc] = 0x9d80, [0x8ccd] = 0x9d78, [0x8cce] = 0x9d86, [0x8ccf] = 0x9d8b,
  [0x8cd0] = 0x9d8c, [0x8cd1] = 0x9d7d, [0x8cd2] = 0x9d6b, [0x8cd3] = 0x9d74,
  [0x8cd4] = 0x9d75, [0x8cd5] = 0x9d70, [0x8cd6] = 0x9d69, [0x8cd7] = 0x9d85,
  [0x8cd8] = 0x9d73, [0x8cd9] = 0x9d7b, [0x8cda] = 0x9d82, [0x8cdb] = 0x9d6f,
  [0x8cdc] = 0x9d79, [0x8cdd] = 0x9d7f, [0x8cde] = 0x9d87, [0x8cdf] = 0x9d68,
  [0x8ce0] = 0x9e94, [0x8ce1] = 0x9e91, [0x8ce2] = 0x9ec0, [0x8ce3] = 0x9efc,
  [0x8ce4] = 0x9f2d, [0x8ce5] = 0x9f40, [0x8ce6] = 0x9f41, [0x8ce7] = 0x9f4d,
  [0x8ce8] = 0x9f56, [0x8ce9] = 0x9f57, [0x8cea] = 0x9f58, [0x8ceb] = 0x5337,
  [0x8cec] = 0x56b2, [0x8ced] = 0x56b5, [0x8cee] = 0x56b3, [0x8cef] = 0x58e3,
  [0x8cf0] = 0x5b45, [0x8cf1] = 0x5dc6, [0x8cf2] = 0x5dc7, [0x8cf3] = 0x5eee,
  [0x8cf4] = 0x5eef, [0x8cf5] = 0x5fc0, [0x8cf6] = 0x5fc1, [0x8cf7] = 0x61f9,
  [0x8cf8] = 0x6517, [0x8cf9] = 0x6516, [0x8cfa] = 0x6515, [0x8cfb] = 0x6513,
  [0x8cfc] = 0x65df, [0x8cfd] = 0x66e8, [0x8d41] = 0x66e3, [0x8d42] = 0x66e4,
  [0x8d43] = 0x6af3, [0x8d44] = 0x6af0, [0x8d45] = 0x6aea, [0x8d46] = 0x6ae8,
  [0x8d47] = 0x6af9, [0x8d48] = 0x6af1, [0x8d49] = 0x6aee, [0x8d4a] = 0x6aef,
  [0x8d4b] = 0x703c, [0x8d4c] = 0x7035, [0x8d4d] = 0x702f, [0x8d4e] = 0x7037,
  [0x8d4f] = 0x7034, [0x8d50] = 0x7031, [0x8d51] = 0x7042, [0x8d52] = 0x7038,
  [0x8d53] = 0x703f, [0x8d54] = 0x703a, [0x8d55] = 0x7039, [0x8d56] = 0x7040,
  [0x8d57] = 0x703b, [0x8d58] = 0x7033, [0x8d59] = 0x7041, [0x8d5a] = 0x7213,
  [0x8d5b] = 0x7214, [0x8d5c] = 0x72a8, [0x8d5d] = 0x737d, [0x8d5e] = 0x737c,
  [0x8d5f] = 0x74ba, [0x8d60] = 0x76ab, [0x8d61] = 0x76aa, [0x8d62] = 0x76be,
  [0x8d63] = 0x76ed, [0x8d64] = 0x77cc, [0x8d65] = 0x77ce, [0x8d66] = 0x77cf,
  [0x8d67] = 0x77cd, [0x8d68] = 0x77f2, [0x8d69] = 0x7925, [0x8d6a] = 0x7923,
  [0x8d6b] = 0x7927, [0x8d6c] = 0x7928, [0x8d6d] = 0x7924, [0x8d6e] = 0x7929,
  [0x8d6f] = 0x79b2, [0x8d70] = 0x7a6e, [0x8d71] = 0x7a6c, [0x8d72] = 0x7a6d,
  [0x8d73] = 0x7af7, [0x8d74] = 0x7c49, [0x8d75] = 0x7c48, [0x8d76] = 0x7c4a,
  [0x8d77] = 0x7c47, [0x8d78] = 0x7c45, [0x8d79] = 0x7cee, [0x8d7a] = 0x7e7b,
  [0x8d7b] = 0x7e7e, [0x8d7c] = 0x7e81, [0x8d7d] = 0x7e80, [0x8d7e] = 0x7fba,
  [0x8d7f] = 0x7fff, [0x8d81] = 0x8079, [0x8d82] = 0x81db, [0x8d83] = 0x81d9,
  [0x8d84] = 0x820b, [0x8d85] = 0x8268, [0x8d86] = 0x8269, [0x8d87] = 0x8622,
  [0x8d88] = 0x85ff, [0x8d89] = 0x8601, [0x8d8a] = 0x85fe, [0x8d8b] = 0x861b,
  [0x8d8c] = 0x8600, [0x8d8d] = 0x85f6, [0x8d8e] = 0x8604, [0x8d8f] = 0x8609,
  [0x8d90] = 0x8605, [0x8d91] = 0x860c, [0x8d92] = 0x85fd, [0x8d93] = 0x8819,
  [0x8d94] = 0x8810, [0x8d95] = 0x8811, [0x8d96] = 0x8817, [0x8d97] = 0x8813,
  [0x8d98] = 0x8816, [0x8d99] = 0x8963, [0x8d9a] = 0x8966, [0x8d9b] = 0x89b9,
  [0x8d9c] = 0x89f7, [0x8d9d] = 0x8b60, [0x8d9e] = 0x8b6a, [0x8d9f] = 0x8b5d,
  [0x8da0] = 0x8b68, [0x8da1] = 0x8b63, [0x8da2] = 0x8b65, [0x8da3] = 0x8b67,
  [0x8da4] = 0x8b6d, [0x8da5] = 0x8dae, [0x8da6] = 0x8e86, [0x8da7] = 0x8e88,
  [0x8da8] = 0x8e84, [0x8da9] = 0x8f59, [0x8daa] = 0x8f56, [0x8dab] = 0x8f57,
  [0x8dac] = 0x8f55, [0x8dad] = 0x8f58, [0x8dae] = 0x8f5a, [0x8daf] = 0x908d,
  [0x8db0] = 0x9143, [0x8db1] = 0x9141, [0x8db2] = 0x91b7, [0x8db3] = 0x91b5,
  [0x8db4] = 0x91b2, [0x8db5] = 0x91b3, [0x8db6] = 0x940b, [0x8db7] = 0x9413,
  [0x8db8] = 0x93fb, [0x8db9] = 0x9420, [0x8dba] = 0x940f, [0x8dbb] = 0x9414,
  [0x8dbc] = 0x93fe, [0x8dbd] = 0x9415, [0x8dbe] = 0x9410, [0x8dbf] = 0x9428,
  [0x8dc0] = 0x9419, [0x8dc1] = 0x940d, [0x8dc2] = 0x93f5, [0x8dc3] = 0x9400,
  [0x8dc4] = 0x93f7, [0x8dc5] = 0x9407, [0x8dc6] = 0x940e, [0x8dc7] = 0x9416,
  [0x8dc8] = 0x9412, [0x8dc9] = 0x93fa, [0x8dca] = 0x9409, [0x8dcb] = 0x93f8,
  [0x8dcc] = 0x940a, [0x8dcd] = 0x93ff, [0x8dce] = 0x93fc, [0x8dcf] = 0x940c,
  [0x8dd0] = 0x93f6, [0x8dd1] = 0x9411, [0x8dd2] = 0x9406, [0x8dd3] = 0x95de,
  [0x8dd4] = 0x95e0, [0x8dd5] = 0x95df, [0x8dd6] = 0x972e, [0x8dd7] = 0x972f,
  [0x8dd8] = 0x97b9, [0x8dd9] = 0x97bb, [0x8dda] = 0x97fd, [0x8ddb] = 0x97fe,
  [0x8ddc] = 0x9860, [0x8ddd] = 0x9862, [0x8dde] = 0x9863, [0x8ddf] = 0x985f,
  [0x8de0] = 0x98c1, [0x8de1] = 0x98c2, [0x8de2] = 0x9950, [0x8de3] = 0x994e,
  [0x8de4] = 0x9959, [0x8de5] = 0x994c, [0x8de6] = 0x994b, [0x8de7] = 0x9953,
  [0x8de8] = 0x9a32, [0x8de9] = 0x9a34, [0x8dea] = 0x9a31, [0x8deb] = 0x9a2c,
  [0x8dec] = 0x9a2a, [0x8ded] = 0x9a36, [0x8dee] = 0x9a29, [0x8def] = 0x9a2e,
  [0x8df0] = 0x9a38, [0x8df1] = 0x9a2d, [0x8df2] = 0x9ac7, [0x8df3] = 0x9aca,
  [0x8df4] = 0x9ac6, [0x8df5] = 0x9b10, [0x8df6] = 0x9b12, [0x8df7] = 0x9b11,
  [0x8df8] = 0x9c0b, [0x8df9] = 0x9c08, [0x8dfa] = 0x9bf7, [0x8dfb] = 0x9c05,
  [0x8dfc] = 0x9c12, [0x8dfd] = 0x9bf8, [0x8e41] = 0x9c40, [0x8e42] = 0x9c07,
  [0x8e43] = 0x9c0e, [0x8e44] = 0x9c06, [0x8e45] = 0x9c17, [0x8e46] = 0x9c14,
  [0x8e47] = 0x9c09, [0x8e48] = 0x9d9f, [0x8e49] = 0x9d99, [0x8e4a] = 0x9da4,
  [0x8e4b] = 0x9d9d, [0x8e4c] = 0x9d92, [0x8e4d] = 0x9d98, [0x8e4e] = 0x9d90,
  [0x8e4f] = 0x9d9b, [0x8e50] = 0x9da0, [0x8e51] = 0x9d94, [0x8e52] = 0x9d9c,
  [0x8e53] = 0x9daa, [0x8e54] = 0x9d97, [0x8e55] = 0x9da1, [0x8e56] = 0x9d9a,
  [0x8e57] = 0x9da2, [0x8e58] = 0x9da8, [0x8e59] = 0x9d9e, [0x8e5a] = 0x9da3,
  [0x8e5b] = 0x9dbf, [0x8e5c] = 0x9da9, [0x8e5d] = 0x9d96, [0x8e5e] = 0x9da6,
  [0x8e5f] = 0x9da7, [0x8e60] = 0x9e99, [0x8e61] = 0x9e9b, [0x8e62] = 0x9e9a,
  [0x8e63] = 0x9ee5, [0x8e64] = 0x9ee4, [0x8e65] = 0x9ee7, [0x8e66] = 0x9ee6,
  [0x8e67] = 0x9f30, [0x8e68] = 0x9f2e, [0x8e69] = 0x9f5b, [0x8e6a] = 0x9f60,
  [0x8e6b] = 0x9f5e, [0x8e6c] = 0x9f5d, [0x8e6d] = 0x9f59, [0x8e6e] = 0x9f91,
  [0x8e6f] = 0x513a, [0x8e70] = 0x5139, [0x8e71] = 0x5298, [0x8e72] = 0x5297,
  [0x8e73] = 0x56c3, [0x8e74] = 0x56bd, [0x8e75] = 0x56be, [0x8e76] = 0x5b48,
  [0x8e77] = 0x5b47, [0x8e78] = 0x5dcb, [0x8e79] = 0x5dcf, [0x8e7a] = 0x5ef1,
  [0x8e7b] = 0x61fd, [0x8e7c] = 0x651b, [0x8e7d] = 0x6b02, [0x8e7e] = 0x6afc,
  [0x8e7f] = 0x6b03, [0x8e81] = 0x6af8, [0x8e82] = 0x6b00, [0x8e83] = 0x7043,
  [0x8e84] = 0x7044, [0x8e85] = 0x704a, [0x8e86] = 0x7048, [0x8e87] = 0x7049,
  [0x8e88] = 0x7045, [0x8e89] = 0x7046, [0x8e8a] = 0x721d, [0x8e8b] = 0x721a,
  [0x8e8c] = 0x7219, [0x8e8d] = 0x737e, [0x8e8e] = 0x7517, [0x8e8f] = 0x766a,
  [0x8e90] = 0x77d0, [0x8e91] = 0x792d, [0x8e92] = 0x7931, [0x8e93] = 0x792f,
  [0x8e94] = 0x7c54, [0x8e95] = 0x7c53, [0x8e96] = 0x7cf2, [0x8e97] = 0x7e8a,
  [0x8e98] = 0x7e87, [0x8e99] = 0x7e88, [0x8e9a] = 0x7e8b, [0x8e9b] = 0x7e86,
  [0x8e9c] = 0x7e8d, [0x8e9d] = 0x7f4d, [0x8e9e] = 0x7fbb, [0x8e9f] = 0x8030,
  [0x8ea0] = 0x81dd, [0x8ea1] = 0x8618, [0x8ea2] = 0x862a, [0x8ea3] = 0x8626,
  [0x8ea4] = 0x861f, [0x8ea5] = 0x8623, [0x8ea6] = 0x861c, [0x8ea7] = 0x8619,
  [0x8ea8] = 0x8627, [0x8ea9] = 0x862e, [0x8eaa] = 0x8621, [0x8eab] = 0x8620,
  [0x8eac] = 0x8629, [0x8ead] = 0x861e, [0x8eae] = 0x8625, [0x8eaf] = 0x8829,
  [0x8eb0] = 0x881d, [0x8eb1] = 0x881b, [0x8eb2] = 0x8820, [0x8eb3] = 0x8824,
  [0x8eb4] = 0x881c, [0x8eb5] = 0x882b, [0x8eb6] = 0x884a, [0x8eb7] = 0x896d,
  [0x8eb8] = 0x8969, [0x8eb9] = 0x896e, [0x8eba] = 0x896b, [0x8ebb] = 0x89fa,
  [0x8ebc] = 0x8b79, [0x8ebd] = 0x8b78, [0x8ebe] = 0x8b45, [0x8ebf] = 0x8b7a,
  [0x8ec0] = 0x8b7b, [0x8ec1] = 0x8d10, [0x8ec2] = 0x8d14, [0x8ec3] = 0x8daf,
  [0x8ec4] = 0x8e8e, [0x8ec5] = 0x8e8c, [0x8ec6] = 0x8f5e, [0x8ec7] = 0x8f5b,
  [0x8ec8] = 0x8f5d, [0x8ec9] = 0x9146, [0x8eca] = 0x9144, [0x8ecb] = 0x9145,
  [0x8ecc] = 0x91b9, [0x8ecd] = 0x943f, [0x8ece] = 0x943b, [0x8ecf] = 0x9436,
  [0x8ed0] = 0x9429, [0x8ed1] = 0x943d, [0x8ed2] = 0x943c, [0x8ed3] = 0x9430,
  [0x8ed4] = 0x9439, [0x8ed5] = 0x942a, [0x8ed6] = 0x9437, [0x8ed7] = 0x942c,
  [0x8ed8] = 0x9440, [0x8ed9] = 0x9431, [0x8eda] = 0x95e5, [0x8edb] = 0x95e4,
  [0x8edc] = 0x95e3, [0x8edd] = 0x9735, [0x8ede] = 0x973a, [0x8edf] = 0x97bf,
  [0x8ee0] = 0x97e1, [0x8ee1] = 0x9864, [0x8ee2] = 0x98c9, [0x8ee3] = 0x98c6,
  [0x8ee4] = 0x98c0, [0x8ee5] = 0x9958, [0x8ee6] = 0x9956, [0x8ee7] = 0x9a39,
  [0x8ee8] = 0x9a3d, [0x8ee9] = 0x9a46, [0x8eea] = 0x9a44, [0x8eeb] = 0x9a42,
  [0x8eec] = 0x9a41, [0x8eed] = 0x9a3a, [0x8eee] = 0x9a3f, [0x8eef] = 0x9acd,
  [0x8ef0] = 0x9b15, [0x8ef1] = 0x9b17, [0x8ef2] = 0x9b18, [0x8ef3] = 0x9b16,
  [0x8ef4] = 0x9b3a, [0x8ef5] = 0x9b52, [0x8ef6] = 0x9c2b, [0x8ef7] = 0x9c1d,
  [0x8ef8] = 0x9c1c, [0x8ef9] = 0x9c2c, [0x8efa] = 0x9c23, [0x8efb] = 0x9c28,
  [0x8efc] = 0x9c29, [0x8efd] = 0x9c24, [0x8f41] = 0x9c21, [0x8f42] = 0x9db7,
  [0x8f43] = 0x9db6, [0x8f44] = 0x9dbc, [0x8f45] = 0x9dc1, [0x8f46] = 0x9dc7,
  [0x8f47] = 0x9dca, [0x8f48] = 0x9dcf, [0x8f49] = 0x9dbe, [0x8f4a] = 0x9dc5,
  [0x8f4b] = 0x9dc3, [0x8f4c] = 0x9dbb, [0x8f4d] = 0x9db5, [0x8f4e] = 0x9dce,
  [0x8f4f] = 0x9db9, [0x8f50] = 0x9dba, [0x8f51] = 0x9dac, [0x8f52] = 0x9dc8,
  [0x8f53] = 0x9db1, [0x8f54] = 0x9dad, [0x8f55] = 0x9dcc, [0x8f56] = 0x9db3,
  [0x8f57] = 0x9dcd, [0x8f58] = 0x9db2, [0x8f59] = 0x9e7a, [0x8f5a] = 0x9e9c,
  [0x8f5b] = 0x9eeb, [0x8f5c] = 0x9eee, [0x8f5d] = 0x9eed, [0x8f5e] = 0x9f1b,
  [0x8f5f] = 0x9f18, [0x8f60] = 0x9f1a, [0x8f61] = 0x9f31, [0x8f62] = 0x9f4e,
  [0x8f63] = 0x9f65, [0x8f64] = 0x9f64, [0x8f65] = 0x9f92, [0x8f66] = 0x4eb9,
  [0x8f67] = 0x56c6, [0x8f68] = 0x56c5, [0x8f69] = 0x56cb, [0x8f6a] = 0x5971,
  [0x8f6b] = 0x5b4b, [0x8f6c] = 0x5b4c, [0x8f6d] = 0x5dd5, [0x8f6e] = 0x5dd1,
  [0x8f6f] = 0x5ef2, [0x8f70] = 0x6521, [0x8f71] = 0x6520, [0x8f72] = 0x6526,
  [0x8f73] = 0x6522, [0x8f74] = 0x6b0b, [0x8f75] = 0x6b08, [0x8f76] = 0x6b09,
  [0x8f77] = 0x6c0d, [0x8f78] = 0x7055, [0x8f79] = 0x7056, [0x8f7a] = 0x7057,
  [0x8f7b] = 0x7052, [0x8f7c] = 0x721e, [0x8f7d] = 0x721f, [0x8f7e] = 0x72a9,
  [0x8f7f] = 0x737f, [0x8f81] = 0x74d8, [0x8f82] = 0x74d5, [0x8f83] = 0x74d9,
  [0x8f84] = 0x74d7, [0x8f85] = 0x766d, [0x8f86] = 0x76ad, [0x8f87] = 0x7935,
  [0x8f88] = 0x79b4, [0x8f89] = 0x7a70, [0x8f8a] = 0x7a71, [0x8f8b] = 0x7c57,
  [0x8f8c] = 0x7c5c, [0x8f8d] = 0x7c59, [0x8f8e] = 0x7c5b, [0x8f8f] = 0x7c5a,
  [0x8f90] = 0x7cf4, [0x8f91] = 0x7cf1, [0x8f92] = 0x7e91, [0x8f93] = 0x7f4f,
  [0x8f94] = 0x7f87, [0x8f95] = 0x81de, [0x8f96] = 0x826b, [0x8f97] = 0x8634,
  [0x8f98] = 0x8635, [0x8f99] = 0x8633, [0x8f9a] = 0x862c, [0x8f9b] = 0x8632,
  [0x8f9c] = 0x8636, [0x8f9d] = 0x882c, [0x8f9e] = 0x8828, [0x8f9f] = 0x8826,
  [0x8fa0] = 0x882a, [0x8fa1] = 0x8825, [0x8fa2] = 0x8971, [0x8fa3] = 0x89bf,
  [0x8fa4] = 0x89be, [0x8fa5] = 0x89fb, [0x8fa6] = 0x8b7e, [0x8fa7] = 0x8b84,
  [0x8fa8] = 0x8b82, [0x8fa9] = 0x8b86, [0x8faa] = 0x8b85, [0x8fab] = 0x8b7f,
  [0x8fac] = 0x8d15, [0x8fad] = 0x8e95, [0x8fae] = 0x8e94, [0x8faf] = 0x8e9a,
  [0x8fb0] = 0x8e92, [0x8fb1] = 0x8e90, [0x8fb2] = 0x8e96, [0x8fb3] = 0x8e97,
  [0x8fb4] = 0x8f60, [0x8fb5] = 0x8f62, [0x8fb6] = 0x9147, [0x8fb7] = 0x944c,
  [0x8fb8] = 0x9450, [0x8fb9] = 0x944a, [0x8fba] = 0x944b, [0x8fbb] = 0x944f,
  [0x8fbc] = 0x9447, [0x8fbd] = 0x9445, [0x8fbe] = 0x9448, [0x8fbf] = 0x9449,
  [0x8fc0] = 0x9446, [0x8fc1] = 0x973f, [0x8fc2] = 0x97e3, [0x8fc3] = 0x986a,
  [0x8fc4] = 0x9869, [0x8fc5] = 0x98cb, [0x8fc6] = 0x9954, [0x8fc7] = 0x995b,
  [0x8fc8] = 0x9a4e, [0x8fc9] = 0x9a53, [0x8fca] = 0x9a54, [0x8fcb] = 0x9a4c,
  [0x8fcc] = 0x9a4f, [0x8fcd] = 0x9a48, [0x8fce] = 0x9a4a, [0x8fcf] = 0x9a49,
  [0x8fd0] = 0x9a52, [0x8fd1] = 0x9a50, [0x8fd2] = 0x9ad0, [0x8fd3] = 0x9b19,
  [0x8fd4] = 0x9b2b, [0x8fd5] = 0x9b3b, [0x8fd6] = 0x9b56, [0x8fd7] = 0x9b55,
  [0x8fd8] = 0x9c46, [0x8fd9] = 0x9c48, [0x8fda] = 0x9c3f, [0x8fdb] = 0x9c44,
  [0x8fdc] = 0x9c39, [0x8fdd] = 0x9c33, [0x8fde] = 0x9c41, [0x8fdf] = 0x9c3c,
  [0x8fe0] = 0x9c37, [0x8fe1] = 0x9c34, [0x8fe2] = 0x9c32, [0x8fe3] = 0x9c3d,
  [0x8fe4] = 0x9c36, [0x8fe5] = 0x9ddb, [0x8fe6] = 0x9dd2, [0x8fe7] = 0x9dde,
  [0x8fe8] = 0x9dda, [0x8fe9] = 0x9dcb, [0x8fea] = 0x9dd0, [0x8feb] = 0x9ddc,
  [0x8fec] = 0x9dd1, [0x8fed] = 0x9ddf, [0x8fee] = 0x9de9, [0x8fef] = 0x9dd9,
  [0x8ff0] = 0x9dd8, [0x8ff1] = 0x9dd6, [0x8ff2] = 0x9df5, [0x8ff3] = 0x9dd5,
  [0x8ff4] = 0x9ddd, [0x8ff5] = 0x9eb6, [0x8ff6] = 0x9ef0, [0x8ff7] = 0x9f35,
  [0x8ff8] = 0x9f33, [0x8ff9] = 0x9f32, [0x8ffa] = 0x9f42, [0x8ffb] = 0x9f6b,
  [0x8ffc] = 0x9f95, [0x8ffd] = 0x9fa2, [0x9041] = 0x513d, [0x9042] = 0x5299,
  [0x9043] = 0x58e8, [0x9044] = 0x58e7, [0x9045] = 0x5972, [0x9046] = 0x5b4d,
  [0x9047] = 0x5dd8, [0x9048] = 0x882f, [0x9049] = 0x5f4f, [0x904a] = 0x6201,
  [0x904b] = 0x6203, [0x904c] = 0x6204, [0x904d] = 0x6529, [0x904e] = 0x6525,
  [0x904f] = 0x6596, [0x9050] = 0x66eb, [0x9051] = 0x6b11, [0x9052] = 0x6b12,
  [0x9053] = 0x6b0f, [0x9054] = 0x6bca, [0x9055] = 0x705b, [0x9056] = 0x705a,
  [0x9057] = 0x7222, [0x9058] = 0x7382, [0x9059] = 0x7381, [0x905a] = 0x7383,
  [0x905b] = 0x7670, [0x905c] = 0x77d4, [0x905d] = 0x7c67, [0x905e] = 0x7c66,
  [0x905f] = 0x7e95, [0x9060] = 0x826c, [0x9061] = 0x863a, [0x9062] = 0x8640,
  [0x9063] = 0x8639, [0x9064] = 0x863c, [0x9065] = 0x8631, [0x9066] = 0x863b,
  [0x9067] = 0x863e, [0x9068] = 0x8830, [0x9069] = 0x8832, [0x906a] = 0x882e,
  [0x906b] = 0x8833, [0x906c] = 0x8976, [0x906d] = 0x8974, [0x906e] = 0x8973,
  [0x906f] = 0x89fe, [0x9070] = 0x8b8c, [0x9071] = 0x8b8e, [0x9072] = 0x8b8b,
  [0x9073] = 0x8b88, [0x9074] = 0x8c45, [0x9075] = 0x8d19, [0x9076] = 0x8e98,
  [0x9077] = 0x8f64, [0x9078] = 0x8f63, [0x9079] = 0x91bc, [0x907a] = 0x9462,
  [0x907b] = 0x9455, [0x907c] = 0x945d, [0x907d] = 0x9457, [0x907e] = 0x945e,
  [0x907f] = 0x97c4, [0x9081] = 0x97c5, [0x9082] = 0x9800, [0x9083] = 0x9a56,
  [0x9084] = 0x9a59, [0x9085] = 0x9b1e, [0x9086] = 0x9b1f, [0x9087] = 0x9b20,
  [0x9088] = 0x9c52, [0x9089] = 0x9c58, [0x908a] = 0x9c50, [0x908b] = 0x9c4a,
  [0x908c] = 0x9c4d, [0x908d] = 0x9c4b, [0x908e] = 0x9c55, [0x908f] = 0x9c59,
  [0x9090] = 0x9c4c, [0x9091] = 0x9c4e, [0x9092] = 0x9dfb, [0x9093] = 0x9df7,
  [0x9094] = 0x9def, [0x9095] = 0x9de3, [0x9096] = 0x9deb, [0x9097] = 0x9df8,
  [0x9098] = 0x9de4, [0x9099] = 0x9df6, [0x909a] = 0x9de1, [0x909b] = 0x9dee,
  [0x909c] = 0x9de6, [0x909d] = 0x9df2, [0x909e] = 0x9df0, [0x909f] = 0x9de2,
  [0x90a0] = 0x9dec, [0x90a1] = 0x9df4, [0x90a2] = 0x9df3, [0x90a3] = 0x9de8,
  [0x90a4] = 0x9ded, [0x90a5] = 0x9ec2, [0x90a6] = 0x9ed0, [0x90a7] = 0x9ef2,
  [0x90a8] = 0x9ef3, [0x90a9] = 0x9f06, [0x90aa] = 0x9f1c, [0x90ab] = 0x9f38,
  [0x90ac] = 0x9f37, [0x90ad] = 0x9f36, [0x90ae] = 0x9f43, [0x90af] = 0x9f4f,
  [0x90b0] = 0x9f71, [0x90b1] = 0x9f70, [0x90b2] = 0x9f6e, [0x90b3] = 0x9f6f,
  [0x90b4] = 0x56d3, [0x90b5] = 0x56cd, [0x90b6] = 0x5b4e, [0x90b7] = 0x5c6d,
  [0x90b8] = 0x652d, [0x90b9] = 0x66ed, [0x90ba] = 0x66ee, [0x90bb] = 0x6b13,
  [0x90bc] = 0x705f, [0x90bd] = 0x7061, [0x90be] = 0x705d, [0x90bf] = 0x7060,
  [0x90c0] = 0x7223, [0x90c1] = 0x74db, [0x90c2] = 0x74e5, [0x90c3] = 0x77d5,
  [0x90c4] = 0x7938, [0x90c5] = 0x79b7, [0x90c6] = 0x79b6, [0x90c7] = 0x7c6a,
  [0x90c8] = 0x7e97, [0x90c9] = 0x7f89, [0x90ca] = 0x826d, [0x90cb] = 0x8643,
  [0x90cc] = 0x8838, [0x90cd] = 0x8837, [0x90ce] = 0x8835, [0x90cf] = 0x884b,
  [0x90d0] = 0x8b94, [0x90d1] = 0x8b95, [0x90d2] = 0x8e9e, [0x90d3] = 0x8e9f,
  [0x90d4] = 0x8ea0, [0x90d5] = 0x8e9d, [0x90d6] = 0x91be, [0x90d7] = 0x91bd,
  [0x90d8] = 0x91c2, [0x90d9] = 0x946b, [0x90da] = 0x9468, [0x90db] = 0x9469,
  [0x90dc] = 0x96e5, [0x90dd] = 0x9746, [0x90de] = 0x9743, [0x90df] = 0x9747,
  [0x90e0] = 0x97c7, [0x90e1] = 0x97e5, [0x90e2] = 0x9a5e, [0x90e3] = 0x9ad5,
  [0x90e4] = 0x9b59, [0x90e5] = 0x9c63, [0x90e6] = 0x9c67, [0x90e7] = 0x9c66,
  [0x90e8] = 0x9c62, [0x90e9] = 0x9c5e, [0x90ea] = 0x9c60, [0x90eb] = 0x9e02,
  [0x90ec] = 0x9dfe, [0x90ed] = 0x9e07, [0x90ee] = 0x9e03, [0x90ef] = 0x9e06,
  [0x90f0] = 0x9e05, [0x90f1] = 0x9e00, [0x90f2] = 0x9e01, [0x90f3] = 0x9e09,
  [0x90f4] = 0x9dff, [0x90f5] = 0x9dfd, [0x90f6] = 0x9e04, [0x90f7] = 0x9ea0,
  [0x90f8] = 0x9f1e, [0x90f9] = 0x9f46, [0x90fa] = 0x9f74, [0x90fb] = 0x9f75,
  [0x90fc] = 0x9f76, [0x90fd] = 0x56d4, [0x9141] = 0x652e, [0x9142] = 0x65b8,
  [0x9143] = 0x6b18, [0x9144] = 0x6b19, [0x9145] = 0x6b17, [0x9146] = 0x6b1a,
  [0x9147] = 0x7062, [0x9148] = 0x7226, [0x9149] = 0x72aa, [0x914a] = 0x77d8,
  [0x914b] = 0x77d9, [0x914c] = 0x7939, [0x914d] = 0x7c69, [0x914e] = 0x7c6b,
  [0x914f] = 0x7cf6, [0x9150] = 0x7e9a, [0x9151] = 0x7e98, [0x9152] = 0x7e9b,
  [0x9153] = 0x7e99, [0x9154] = 0x81e0, [0x9155] = 0x81e1, [0x9156] = 0x8646,
  [0x9157] = 0x8647, [0x9158] = 0x8648, [0x9159] = 0x8979, [0x915a] = 0x897a,
  [0x915b] = 0x897c, [0x915c] = 0x897b, [0x915d] = 0x89ff, [0x915e] = 0x8b98,
  [0x915f] = 0x8b99, [0x9160] = 0x8ea5, [0x9161] = 0x8ea4, [0x9162] = 0x8ea3,
  [0x9163] = 0x946e, [0x9164] = 0x946d, [0x9165] = 0x946f, [0x9166] = 0x9471,
  [0x9167] = 0x9473, [0x9168] = 0x9749, [0x9169] = 0x9872, [0x916a] = 0x995f,
  [0x916b] = 0x9c68, [0x916c] = 0x9c6e, [0x916d] = 0x9c6d, [0x916e] = 0x9e0b,
  [0x916f] = 0x9e0d, [0x9170] = 0x9e10, [0x9171] = 0x9e0f, [0x9172] = 0x9e12,
  [0x9173] = 0x9e11, [0x9174] = 0x9ea1, [0x9175] = 0x9ef5, [0x9176] = 0x9f09,
  [0x9177] = 0x9f47, [0x9178] = 0x9f78, [0x9179] = 0x9f7b, [0x917a] = 0x9f7a,
  [0x917b] = 0x9f79, [0x917c] = 0x571e, [0x917d] = 0x7066, [0x917e] = 0x7c6f,
  [0x917f] = 0x883c, [0x9181] = 0x8db2, [0x9182] = 0x8ea6, [0x9183] = 0x91c3,
  [0x9184] = 0x9474, [0x9185] = 0x9478, [0x9186] = 0x9476, [0x9187] = 0x9475,
  [0x9188] = 0x9a60, [0x9189] = 0x9c74, [0x918a] = 0x9c73, [0x918b] = 0x9c71,
  [0x918c] = 0x9c75, [0x918d] = 0x9e14, [0x918e] = 0x9e13, [0x918f] = 0x9ef6,
  [0x9190] = 0x9f0a, [0x9191] = 0x9fa4, [0x9192] = 0x7068, [0x9193] = 0x7065,
  [0x9194] = 0x7cf7, [0x9195] = 0x866a, [0x9196] = 0x883e, [0x9197] = 0x883d,
  [0x9198] = 0x883f, [0x9199] = 0x8b9e, [0x919a] = 0x8c9c, [0x919b] = 0x8ea9,
  [0x919c] = 0x8ec9, [0x919d] = 0x974b, [0x919e] = 0x9873, [0x919f] = 0x9874,
  [0x91a0] = 0x98cc, [0x91a1] = 0x9961, [0x91a2] = 0x99ab, [0x91a3] = 0x9a64,
  [0x91a4] = 0x9a66, [0x91a5] = 0x9a67, [0x91a6] = 0x9b24, [0x91a7] = 0x9e15,
  [0x91a8] = 0x9e17, [0x91a9] = 0x9f48, [0x91aa] = 0x6207, [0x91ab] = 0x6b1e,
  [0x91ac] = 0x7227, [0x91ad] = 0x864c, [0x91ae] = 0x8ea8, [0x91af] = 0x9482,
  [0x91b0] = 0x9480, [0x91b1] = 0x9481, [0x91b2] = 0x9a69, [0x91b3] = 0x9a68,
  [0x91b4] = 0x9b2e, [0x91b5] = 0x9e19, [0x91b6] = 0x7229, [0x91b7] = 0x864b,
  [0x91b8] = 0x8b9f, [0x91b9] = 0x9483, [0x91ba] = 0x9c79, [0x91bb] = 0x9eb7,
  [0x91bc] = 0x7675, [0x91bd] = 0x9a6b, [0x91be] = 0x9c7a, [0x91bf] = 0x9e1d,
  [0x91c0] = 0x7069, [0x91c1] = 0x706a, [0x91c2] = 0x9ea4, [0x91c3] = 0x9f7e,
  [0x91c4] = 0x9f49, [0x91c5] = 0x9f98, [0x91c6] = 0x691e, [0x91c7] = 0x6eb8,
  [0xc241] = 0xe000, [0xc242] = 0xe001, [0xc243] = 0xe002, [0xc244] = 0xe003,
  [0xc245] = 0xe004, [0xc246] = 0xe005, [0xc247] = 0xe006, [0xc248] = 0xe007,
  [0xc249] = 0xe008, [0xc24a] = 0xe009, [0xc24b] = 0xe00a, [0xc24c] = 0xe00b,
  [0xc24d] = 0xe00c, [0xc24e] = 0xe00d, [0xc24f] = 0xe00e, [0xc250] = 0xe00f,
  [0xc251] = 0xe010, [0xc252] = 0xe011, [0xc253] = 0xe012, [0xc254] = 0xe013,
  [0xc255] = 0xe014, [0xc256] = 0xe015, [0xc257] = 0xe016, [0xc258] = 0xe017,
  [0xc259] = 0xe018, [0xc25a] = 0xe019, [0xc25b] = 0xe01a, [0xc25c] = 0xe01b,
  [0xc25d] = 0xe01c, [0xc25e] = 0xe01d, [0xc25f] = 0xe01e, [0xc260] = 0xe01f,
  [0xc261] = 0xe020, [0xc262] = 0xe021, [0xc263] = 0xe022, [0xc264] = 0xe023,
  [0xc265] = 0xe024, [0xc266] = 0xe025, [0xc267] = 0xe026, [0xc268] = 0xe027,
  [0xc269] = 0xe028, [0xc26a] = 0xe029, [0xc26b] = 0xe02a, [0xc26c] = 0xe02b,
  [0xc26d] = 0xe02c, [0xc26e] = 0xe02d, [0xc26f] = 0xe02e, [0xc270] = 0xe02f,
  [0xc271] = 0xe030, [0xc272] = 0xe031, [0xc273] = 0xe032, [0xc274] = 0xe033,
  [0xc275] = 0xe034, [0xc276] = 0xe035, [0xc277] = 0xe036, [0xc278] = 0xe037,
  [0xc279] = 0xe038, [0xc27a] = 0xe039, [0xc27b] = 0xe03a, [0xc27c] = 0xe03b,
  [0xc27d] = 0xe03c, [0xc27e] = 0xe03d, [0xc27f] = 0xe03e, [0xc281] = 0xe03f,
  [0xc282] = 0xe040, [0xc283] = 0xe041, [0xc284] = 0xe042, [0xc285] = 0xe043,
  [0xc286] = 0xe044, [0xc287] = 0xe045, [0xc288] = 0xe046, [0xc289] = 0xe047,
  [0xc28a] = 0xe048, [0xc28b] = 0xe049, [0xc28c] = 0xe04a, [0xc28d] = 0xe04b,
  [0xc28e] = 0xe04c, [0xc28f] = 0xe04d, [0xc290] = 0xe04e, [0xc291] = 0xe04f,
  [0xc292] = 0xe050, [0xc293] = 0xe051, [0xc294] = 0xe052, [0xc295] = 0xe053,
  [0xc296] = 0xe054, [0xc297] = 0xe055, [0xc298] = 0xe056, [0xc299] = 0xe057,
  [0xc29a] = 0xe058, [0xc29b] = 0xe059, [0xc29c] = 0xe05a, [0xc29d] = 0xe05b,
  [0xc29e] = 0xe05c, [0xc29f] = 0xe05d, [0xc2a0] = 0xe05e, [0xc2a1] = 0xe05f,
  [0xc2a2] = 0xe060, [0xc2a3] = 0xe061, [0xc2a4] = 0xe062, [0xc2a5] = 0xe063,
  [0xc2a6] = 0xe064, [0xc2a7] = 0xe065, [0xc2a8] = 0xe066, [0xc2a9] = 0xe067,
  [0xc2aa] = 0xe068, [0xc2ab] = 0xe069, [0xc2ac] = 0xe06a, [0xc2ad] = 0xe06b,
  [0xc2ae] = 0xe06c, [0xc2af] = 0xe06d, [0xc2b0] = 0xe06e, [0xc2b1] = 0xe06f,
  [0xc2b2] = 0xe070, [0xc2b3] = 0xe071, [0xc2b4] = 0xe072, [0xc2b5] = 0xe073,
  [0xc2b6] = 0xe074, [0xc2b7] = 0xe075, [0xc2b8] = 0xe076, [0xc2b9] = 0xe077,
  [0xc2ba] = 0xe078, [0xc2bb] = 0xe079, [0xc2bc] = 0xe07a, [0xc2bd] = 0xe07b,
  [0xc2be] = 0xe07c, [0xc2bf] = 0xe07d, [0xc2c0] = 0xe07e, [0xc2c1] = 0xe07f,
  [0xc2c2] = 0xe080, [0xc2c3] = 0xe081, [0xc2c4] = 0xe082, [0xc2c5] = 0xe083,
  [0xc2c6] = 0xe084, [0xc2c7] = 0xe085, [0xc2c8] = 0xe086, [0xc2c9] = 0xe087,
  [0xc2ca] = 0xe088, [0xc2cb] = 0xe089, [0xc2cc] = 0xe08a, [0xc2cd] = 0xe08b,
  [0xc2ce] = 0xe08c, [0xc2cf] = 0xe08d, [0xc2d0] = 0xe08e, [0xc2d1] = 0xe08f,
  [0xc2d2] = 0xe090, [0xc2d3] = 0xe091, [0xc2d4] = 0xe092, [0xc2d5] = 0xe093,
  [0xc2d6] = 0xe094, [0xc2d7] = 0xe095, [0xc2d8] = 0xe096, [0xc2d9] = 0xe097,
  [0xc2da] = 0xe098, [0xc2db] = 0xe099, [0xc2dc] = 0xe09a, [0xc2dd] = 0xe09b,
  [0xc2de] = 0xe09c, [0xc2df] = 0xe09d, [0xc2e0] = 0xe09e, [0xc2e1] = 0xe09f,
  [0xc2e2] = 0xe0a0, [0xc2e3] = 0xe0a1, [0xc2e4] = 0xe0a2, [0xc2e5] = 0xe0a3,
  [0xc2e6] = 0xe0a4, [0xc2e7] = 0xe0a5, [0xc2e8] = 0xe0a6, [0xc2e9] = 0xe0a7,
  [0xc2ea] = 0xe0a8, [0xc2eb] = 0xe0a9, [0xc2ec] = 0xe0aa, [0xc2ed] = 0xe0ab,
  [0xc2ee] = 0xe0ac, [0xc2ef] = 0xe0ad, [0xc2f0] = 0xe0ae, [0xc2f1] = 0xe0af,
  [0xc2f2] = 0xe0b0, [0xc2f3] = 0xe0b1, [0xc2f4] = 0xe0b2, [0xc2f5] = 0xe0b3,
  [0xc2f6] = 0xe0b4, [0xc2f7] = 0xe0b5, [0xc2f8] = 0xe0b6, [0xc2f9] = 0xe0b7,
  [0xc2fa] = 0xe0b8, [0xc2fb] = 0xe0b9, [0xc2fc] = 0xe0ba, [0xc2fd] = 0xe0bb,
  [0xc341] = 0xe0bc, [0xc342] = 0xe0bd, [0xc343] = 0xe0be, [0xc344] = 0xe0bf,
  [0xc345] = 0xe0c0, [0xc346] = 0xe0c1, [0xc347] = 0xe0c2, [0xc348] = 0xe0c3,
  [0xc349] = 0xe0c4, [0xc34a] = 0xe0c5, [0xc34b] = 0xe0c6, [0xc34c] = 0xe0c7,
  [0xc34d] = 0xe0c8, [0xc34e] = 0xe0c9, [0xc34f] = 0xe0ca, [0xc350] = 0xe0cb,
  [0xc351] = 0xe0cc, [0xc352] = 0xe0cd, [0xc353] = 0xe0ce, [0xc354] = 0xe0cf,
  [0xc355] = 0xe0d0, [0xc356] = 0xe0d1, [0xc357] = 0xe0d2, [0xc358] = 0xe0d3,
  [0xc359] = 0xe0d4, [0xc35a] = 0xe0d5, [0xc35b] = 0xe0d6, [0xc35c] = 0xe0d7,
  [0xc35d] = 0xe0d8, [0xc35e] = 0xe0d9, [0xc35f] = 0xe0da, [0xc360] = 0xe0db,
  [0xc361] = 0xe0dc, [0xc362] = 0xe0dd, [0xc363] = 0xe0de, [0xc364] = 0xe0df,
  [0xc365] = 0xe0e0, [0xc366] = 0xe0e1, [0xc367] = 0xe0e2, [0xc368] = 0xe0e3,
  [0xc369] = 0xe0e4, [0xc36a] = 0xe0e5, [0xc36b] = 0xe0e6, [0xc36c] = 0xe0e7,
  [0xc36d] = 0xe0e8, [0xc36e] = 0xe0e9, [0xc36f] = 0xe0ea, [0xc370] = 0xe0eb,
  [0xc371] = 0xe0ec, [0xc372] = 0xe0ed, [0xc373] = 0xe0ee, [0xc374] = 0xe0ef,
  [0xc375] = 0xe0f0, [0xc376] = 0xe0f1, [0xc377] = 0xe0f2, [0xc378] = 0xe0f3,
  [0xc379] = 0xe0f4, [0xc37a] = 0xe0f5, [0xc37b] = 0xe0f6, [0xc37c] = 0xe0f7,
  [0xc37d] = 0xe0f8, [0xc37e] = 0xe0f9, [0xc37f] = 0xe0fa, [0xc381] = 0xe0fb,
  [0xc382] = 0xe0fc, [0xc383] = 0xe0fd, [0xc384] = 0xe0fe, [0xc385] = 0xe0ff,
  [0xc386] = 0xe100, [0xc387] = 0xe101, [0xc388] = 0xe102, [0xc389] = 0xe103,
  [0xc38a] = 0xe104, [0xc38b] = 0xe105, [0xc38c] = 0xe106, [0xc38d] = 0xe107,
  [0xc38e] = 0xe108, [0xc38f] = 0xe109, [0xc390] = 0xe10a, [0xc391] = 0xe10b,
  [0xc392] = 0xe10c, [0xc393] = 0xe10d, [0xc394] = 0xe10e, [0xc395] = 0xe10f,
  [0xc396] = 0xe110, [0xc397] = 0xe111, [0xc398] = 0xe112, [0xc399] = 0xe113,
  [0xc39a] = 0xe114, [0xc39b] = 0xe115, [0xc39c] = 0xe116, [0xc39d] = 0xe117,
  [0xc39e] = 0xe118, [0xc39f] = 0xe119, [0xc3a0] = 0xe11a, [0xc3a1] = 0xe11b,
  [0xc3a2] = 0xe11c, [0xc3a3] = 0xe11d, [0xc3a4] = 0xe11e, [0xc3a5] = 0xe11f,
  [0xc3a6] = 0xe120, [0xc3a7] = 0xe121, [0xc3a8] = 0xe122, [0xc3a9] = 0xe123,
  [0xc3aa] = 0xe124, [0xc3ab] = 0xe125, [0xc3ac] = 0xe126, [0xc3ad] = 0xe127,
  [0xc3ae] = 0xe128, [0xc3af] = 0xe129, [0xc3b0] = 0xe12a, [0xc3b1] = 0xe12b,
  [0xc3b2] = 0xe12c, [0xc3b3] = 0xe12d, [0xc3b4] = 0xe12e, [0xc3b5] = 0xe12f,
  [0xc3b6] = 0xe130, [0xc3b7] = 0xe131, [0xc3b8] = 0xe132, [0xc3b9] = 0xe133,
  [0xc3ba] = 0xe134, [0xc3bb] = 0xe135, [0xc3bc] = 0xe136, [0xc3bd] = 0xe137,
  [0xc3be] = 0xe138, [0xc3bf] = 0xe139, [0xc3c0] = 0xe13a, [0xc3c1] = 0xe13b,
  [0xc3c2] = 0xe13c, [0xc3c3] = 0xe13d, [0xc3c4] = 0xe13e, [0xc3c5] = 0xe13f,
  [0xc3c6] = 0xe140, [0xc3c7] = 0xe141, [0xc3c8] = 0xe142, [0xc3c9] = 0xe143,
  [0xc3ca] = 0xe144, [0xc3cb] = 0xe145, [0xc3cc] = 0xe146, [0xc3cd] = 0xe147,
  [0xc3ce] = 0xe148, [0xc3cf] = 0xe149, [0xc3d0] = 0xe14a, [0xc3d1] = 0xe14b,
  [0xc3d2] = 0xe14c, [0xc3d3] = 0xe14d, [0xc3d4] = 0xe14e, [0xc3d5] = 0xe14f,
  [0xc3d6] = 0xe150, [0xc3d7] = 0xe151, [0xc3d8] = 0xe152, [0xc3d9] = 0xe153,
  [0xc3da] = 0xe154, [0xc3db] = 0xe155, [0xc3dc] = 0xe156, [0xc3dd] = 0xe157,
  [0xc3de] = 0xe158, [0xc3df] = 0xe159, [0xc3e0] = 0xe15a, [0xc3e1] = 0xe15b,
  [0xc3e2] = 0xe15c, [0xc3e3] = 0xe15d, [0xc3e4] = 0xe15e, [0xc3e5] = 0xe15f,
  [0xc3e6] = 0xe160, [0xc3e7] = 0xe161, [0xc3e8] = 0xe162, [0xc3e9] = 0xe163,
  [0xc3ea] = 0xe164, [0xc3eb] = 0xe165, [0xc3ec] = 0xe166, [0xc3ed] = 0xe167,
  [0xc3ee] = 0xe168, [0xc3ef] = 0xe169, [0xc3f0] = 0xe16a, [0xc3f1] = 0xe16b,
  [0xc3f2] = 0xe16c, [0xc3f3] = 0xe16d, [0xc3f4] = 0xe16e, [0xc3f5] = 0xe16f,
  [0xc3f6] = 0xe170, [0xc3f7] = 0xe171, [0xc3f8] = 0xe172, [0xc3f9] = 0xe173,
  [0xc3fa] = 0xe174, [0xc3fb] = 0xe175, [0xc3fc] = 0xe176, [0xc3fd] = 0xe177,
  [0xc441] = 0xe178, [0xc442] = 0xe179, [0xc443] = 0xe17a, [0xc444] = 0xe17b,
  [0xc445] = 0xe17c, [0xc446] = 0xe17d, [0xc447] = 0xe17e, [0xc448] = 0xe17f,
  [0xc449] = 0xe180, [0xc44a] = 0xe181, [0xc44b] = 0xe182, [0xc44c] = 0xe183,
  [0xc44d] = 0xe184, [0xc44e] = 0xe185, [0xc44f] = 0xe186, [0xc450] = 0xe187,
  [0xc451] = 0xe188, [0xc452] = 0xe189, [0xc453] = 0xe18a, [0xc454] = 0xe18b,
  [0xc455] = 0xe18c, [0xc456] = 0xe18d, [0xc457] = 0xe18e, [0xc458] = 0xe18f,
  [0xc459] = 0xe190, [0xc45a] = 0xe191, [0xc45b] = 0xe192, [0xc45c] = 0xe193,
  [0xc45d] = 0xe194, [0xc45e] = 0xe195, [0xc45f] = 0xe196, [0xc460] = 0xe197,
  [0xc461] = 0xe198, [0xc462] = 0xe199, [0xc463] = 0xe19a, [0xc464] = 0xe19b,
  [0xc465] = 0xe19c, [0xc466] = 0xe19d, [0xc467] = 0xe19e, [0xc468] = 0xe19f,
  [0xc469] = 0xe1a0, [0xc46a] = 0xe1a1, [0xc46b] = 0xe1a2, [0xc46c] = 0xe1a3,
  [0xc46d] = 0xe1a4, [0xc46e] = 0xe1a5, [0xc46f] = 0xe1a6, [0xc470] = 0xe1a7,
  [0xc471] = 0xe1a8, [0xc472] = 0xe1a9, [0xc473] = 0xe1aa, [0xc474] = 0xe1ab,
  [0xc475] = 0xe1ac, [0xc476] = 0xe1ad, [0xc477] = 0xe1ae, [0xc478] = 0xe1af,
  [0xc479] = 0xe1b0, [0xc47a] = 0xe1b1, [0xc47b] = 0xe1b2, [0xc47c] = 0xe1b3,
  [0xc47d] = 0xe1b4, [0xc47e] = 0xe1b5, [0xc47f] = 0xe1b6, [0xc481] = 0xe1b7,
  [0xc482] = 0xe1b8, [0xc483] = 0xe1b9, [0xc484] = 0xe1ba, [0xc485] = 0xe1bb,
  [0xc486] = 0xe1bc, [0xc487] = 0xe1bd, [0xc488] = 0xe1be, [0xc489] = 0xe1bf,
  [0xc48a] = 0xe1c0, [0xc48b] = 0xe1c1, [0xc48c] = 0xe1c2, [0xc48d] = 0xe1c3,
  [0xc48e] = 0xe1c4, [0xc48f] = 0xe1c5, [0xc490] = 0xe1c6, [0xc491] = 0xe1c7,
  [0xc492] = 0xe1c8, [0xc493] = 0xe1c9, [0xc494] = 0xe1ca, [0xc495] = 0xe1cb,
  [0xc496] = 0xe1cc, [0xc497] = 0xe1cd, [0xc498] = 0xe1ce, [0xc499] = 0xe1cf,
  [0xc49a] = 0xe1d0, [0xc49b] = 0xe1d1, [0xc49c] = 0xe1d2, [0xc49d] = 0xe1d3,
  [0xc49e] = 0xe1d4, [0xc49f] = 0xe1d5, [0xc4a0] = 0xe1d6, [0xc4a1] = 0xe1d7,
  [0xc4a2] = 0xe1d8, [0xc4a3] = 0xe1d9, [0xc4a4] = 0xe1da, [0xc4a5] = 0xe1db,
  [0xc4a6] = 0xe1dc, [0xc4a7] = 0xe1dd, [0xc4a8] = 0xe1de, [0xc4a9] = 0xe1df,
  [0xc4aa] = 0xe1e0, [0xc4ab] = 0xe1e1, [0xc4ac] = 0xe1e2, [0xc4ad] = 0xe1e3,
  [0xc4ae] = 0xe1e4, [0xc4af] = 0xe1e5, [0xc4b0] = 0xe1e6, [0xc4b1] = 0xe1e7,
  [0xc4b2] = 0xe1e8, [0xc4b3] = 0xe1e9, [0xc4b4] = 0xe1ea, [0xc4b5] = 0xe1eb,
  [0xc4b6] = 0xe1ec, [0xc4b7] = 0xe1ed, [0xc4b8] = 0xe1ee, [0xc4b9] = 0xe1ef,
  [0xc4ba] = 0xe1f0, [0xc4bb] = 0xe1f1, [0xc4bc] = 0xe1f2, [0xc4bd] = 0xe1f3,
  [0xc4be] = 0xe1f4, [0xc4bf] = 0xe1f5, [0xc4c0] = 0xe1f6, [0xc4c1] = 0xe1f7,
  [0xc4c2] = 0xe1f8, [0xc4c3] = 0xe1f9, [0xc4c4] = 0xe1fa, [0xc4c5] = 0xe1fb,
  [0xc4c6] = 0xe1fc, [0xc4c7] = 0xe1fd, [0xc4c8] = 0xe1fe, [0xc4c9] = 0xe1ff,
  [0xc4ca] = 0xe200, [0xc4cb] = 0xe201, [0xc4cc] = 0xe202, [0xc4cd] = 0xe203,
  [0xc4ce] = 0xe204, [0xc4cf] = 0xe205, [0xc4d0] = 0xe206, [0xc4d1] = 0xe207,
  [0xc4d2] = 0xe208, [0xc4d3] = 0xe209, [0xc4d4] = 0xe20a, [0xc4d5] = 0xe20b,
  [0xc4d6] = 0xe20c, [0xc4d7] = 0xe20d, [0xc4d8] = 0xe20e, [0xc4d9] = 0xe20f,
  [0xc4da] = 0xe210, [0xc4db] = 0xe211, [0xc4dc] = 0xe212, [0xc4dd] = 0xe213,
  [0xc4de] = 0xe214, [0xc4df] = 0xe215, [0xc4e0] = 0xe216, [0xc4e1] = 0xe217,
  [0xc4e2] = 0xe218, [0xc4e3] = 0xe219, [0xc4e4] = 0xe21a, [0xc4e5] = 0xe21b,
  [0xc4e6] = 0xe21c, [0xc4e7] = 0xe21d, [0xc4e8] = 0xe21e, [0xc4e9] = 0xe21f,
  [0xc4ea] = 0xe220, [0xc4eb] = 0xe221, [0xc4ec] = 0xe222, [0xc4ed] = 0xe223,
  [0xc4ee] = 0xe224, [0xc4ef] = 0xe225, [0xc4f0] = 0xe226, [0xc4f1] = 0xe227,
  [0xc4f2] = 0xe228, [0xc4f3] = 0xe229, [0xc4f4] = 0xe22a, [0xc4f5] = 0xe22b,
  [0xc4f6] = 0xe22c, [0xc4f7] = 0xe22d, [0xc4f8] = 0xe22e, [0xc4f9] = 0xe22f,
  [0xc4fa] = 0xe230, [0xc4fb] = 0xe231, [0xc4fc] = 0xe232, [0xc4fd] = 0xe233,
  [0xc541] = 0xe234, [0xc542] = 0xe235, [0xc543] = 0xe236, [0xc544] = 0xe237,
  [0xc545] = 0xe238, [0xc546] = 0xe239, [0xc547] = 0xe23a, [0xc548] = 0xe23b,
  [0xc549] = 0xe23c, [0xc54a] = 0xe23d, [0xc54b] = 0xe23e, [0xc54c] = 0xe23f,
  [0xc54d] = 0xe240, [0xc54e] = 0xe241, [0xc54f] = 0xe242, [0xc550] = 0xe243,
  [0xc551] = 0xe244, [0xc552] = 0xe245, [0xc553] = 0xe246, [0xc554] = 0xe247,
  [0xc555] = 0xe248, [0xc556] = 0xe249, [0xc557] = 0xe24a, [0xc558] = 0xe24b,
  [0xc559] = 0xe24c, [0xc55a] = 0xe24d, [0xc55b] = 0xe24e, [0xc55c] = 0xe24f,
  [0xc55d] = 0xe250, [0xc55e] = 0xe251, [0xc55f] = 0xe252, [0xc560] = 0xe253,
  [0xc561] = 0xe254, [0xc562] = 0xe255, [0xc563] = 0xe256, [0xc564] = 0xe257,
  [0xc565] = 0xe258, [0xc566] = 0xe259, [0xc567] = 0xe25a, [0xc568] = 0xe25b,
  [0xc569] = 0xe25c, [0xc56a] = 0xe25d, [0xc56b] = 0xe25e, [0xc56c] = 0xe25f,
  [0xc56d] = 0xe260, [0xc56e] = 0xe261, [0xc56f] = 0xe262, [0xc570] = 0xe263,
  [0xc571] = 0xe264, [0xc572] = 0xe265, [0xc573] = 0xe266, [0xc574] = 0xe267,
  [0xc575] = 0xe268, [0xc576] = 0xe269, [0xc577] = 0xe26a, [0xc578] = 0xe26b,
  [0xc579] = 0xe26c, [0xc57a] = 0xe26d, [0xc57b] = 0xe26e, [0xc57c] = 0xe26f,
  [0xc57d] = 0xe270, [0xc57e] = 0xe271, [0xc57f] = 0xe272, [0xc581] = 0xe273,
  [0xc582] = 0xe274, [0xc583] = 0xe275, [0xc584] = 0xe276, [0xc585] = 0xe277,
  [0xc586] = 0xe278, [0xc587] = 0xe279, [0xc588] = 0xe27a, [0xc589] = 0xe27b,
  [0xc58a] = 0xe27c, [0xc58b] = 0xe27d, [0xc58c] = 0xe27e, [0xc58d] = 0xe27f,
  [0xc58e] = 0xe280, [0xc58f] = 0xe281, [0xc590] = 0xe282, [0xc591] = 0xe283,
  [0xc592] = 0xe284, [0xc593] = 0xe285, [0xc594] = 0xe286, [0xc595] = 0xe287,
  [0xc596] = 0xe288, [0xc597] = 0xe289, [0xc598] = 0xe28a, [0xc599] = 0xe28b,
  [0xc59a] = 0xe28c, [0xc59b] = 0xe28d, [0xc59c] = 0xe28e, [0xc59d] = 0xe28f,
  [0xc59e] = 0xe290, [0xc59f] = 0xe291, [0xc5a0] = 0xe292, [0xc5a1] = 0xe293,
  [0xc5a2] = 0xe294, [0xc5a3] = 0xe295, [0xc5a4] = 0xe296, [0xc5a5] = 0xe297,
  [0xc5a6] = 0xe298, [0xc5a7] = 0xe299, [0xc5a8] = 0xe29a, [0xc5a9] = 0xe29b,
  [0xc5aa] = 0xe29c, [0xc5ab] = 0xe29d, [0xc5ac] = 0xe29e, [0xc5ad] = 0xe29f,
  [0xc5ae] = 0xe2a0, [0xc5af] = 0xe2a1, [0xc5b0] = 0xe2a2, [0xc5b1] = 0xe2a3,
  [0xc5b2] = 0xe2a4, [0xc5b3] = 0xe2a5, [0xc5b4] = 0xe2a6, [0xc5b5] = 0xe2a7,
  [0xc5b6] = 0xe2a8, [0xc5b7] = 0xe2a9, [0xc5b8] = 0xe2aa, [0xc5b9] = 0xe2ab,
  [0xc5ba] = 0xe2ac, [0xc5bb] = 0xe2ad, [0xc5bc] = 0xe2ae, [0xc5bd] = 0xe2af,
  [0xc5be] = 0xe2b0, [0xc5bf] = 0xe2b1, [0xc5c0] = 0xe2b2, [0xc5c1] = 0xe2b3,
  [0xc5c2] = 0xe2b4, [0xc5c3] = 0xe2b5, [0xc5c4] = 0xe2b6, [0xc5c5] = 0xe2b7,
  [0xc5c6] = 0xe2b8, [0xc5c7] = 0xe2b9, [0xc5c8] = 0xe2ba, [0xc5c9] = 0xe2bb,
  [0xc5ca] = 0xe2bc, [0xc5cb] = 0xe2bd, [0xc5cc] = 0xe2be, [0xc5cd] = 0xe2bf,
  [0xc5ce] = 0xe2c0, [0xc5cf] = 0xe2c1, [0xc5d0] = 0xe2c2, [0xc5d1] = 0xe2c3,
  [0xc5d2] = 0xe2c4, [0xc5d3] = 0xe2c5, [0xc5d4] = 0xe2c6, [0xc5d5] = 0xe2c7,
  [0xc5d6] = 0xe2c8, [0xc5d7] = 0xe2c9, [0xc5d8] = 0xe2ca, [0xc5d9] = 0xe2cb,
  [0xc5da] = 0xe2cc, [0xc5db] = 0xe2cd, [0xc5dc] = 0xe2ce, [0xc5dd] = 0xe2cf,
  [0xc5de] = 0xe2d0, [0xc5df] = 0xe2d1, [0xc5e0] = 0xe2d2, [0xc5e1] = 0xe2d3,
  [0xc5e2] = 0xe2d4, [0xc5e3] = 0xe2d5, [0xc5e4] = 0xe2d6, [0xc5e5] = 0xe2d7,
  [0xc5e6] = 0xe2d8, [0xc5e7] = 0xe2d9, [0xc5e8] = 0xe2da, [0xc5e9] = 0xe2db,
  [0xc5ea] = 0xe2dc, [0xc5eb] = 0xe2dd, [0xc5ec] = 0xe2de, [0xc5ed] = 0xe2df,
  [0xc5ee] = 0xe2e0, [0xc5ef] = 0xe2e1, [0xc5f0] = 0xe2e2, [0xc5f1] = 0xe2e3,
  [0xc5f2] = 0xe2e4, [0xc5f3] = 0xe2e5, [0xc5f4] = 0xe2e6, [0xc5f5] = 0xe2e7,
  [0xc5f6] = 0xe2e8, [0xc5f7] = 0xe2e9, [0xc5f8] = 0xe2ea, [0xc5f9] = 0xe2eb,
  [0xc5fa] = 0xe2ec, [0xc5fb] = 0xe2ed, [0xc5fc] = 0xe2ee, [0xc5fd] = 0xe2ef,
  [0xc641] = 0xe2f0, [0xc642] = 0xe2f1, [0xc643] = 0xe2f2, [0xc644] = 0xe2f3,
  [0xc645] = 0xe2f4, [0xc646] = 0xe2f5, [0xc647] = 0xe2f6, [0xc648] = 0xe2f7,
  [0xc649] = 0xe2f8, [0xc64a] = 0xe2f9, [0xc64b] = 0xe2fa, [0xc64c] = 0xe2fb,
  [0xc64d] = 0xe2fc, [0xc64e] = 0xe2fd, [0xc64f] = 0xe2fe, [0xc650] = 0xe2ff,
  [0xc651] = 0xe300, [0xc652] = 0xe301, [0xc653] = 0xe302, [0xc654] = 0xe303,
  [0xc655] = 0xe304, [0xc656] = 0xe305, [0xc657] = 0xe306, [0xc658] = 0xe307,
  [0xc659] = 0xe308, [0xc65a] = 0xe309, [0xc65b] = 0xe30a, [0xc65c] = 0xe30b,
  [0xc65d] = 0xe30c, [0xc65e] = 0xe30d, [0xc65f] = 0xe30e, [0xc660] = 0xe30f,
  [0xc661] = 0xe310, [0xc662] = 0xe311, [0xc663] = 0xe312, [0xc664] = 0xe313,
  [0xc665] = 0xe314, [0xc666] = 0xe315, [0xc667] = 0xe316, [0xc668] = 0xe317,
  [0xc669] = 0xe318, [0xc66a] = 0xe319, [0xc66b] = 0xe31a, [0xc66c] = 0xe31b,
  [0xc66d] = 0xe31c, [0xc66e] = 0xe31d, [0xc66f] = 0xe31e, [0xc670] = 0xe31f,
  [0xc671] = 0xe320, [0xc672] = 0xe321, [0xc673] = 0xe322, [0xc674] = 0xe323,
  [0xc675] = 0xe324, [0xc676] = 0xe325, [0xc677] = 0xe326, [0xc678] = 0xe327,
  [0xc679] = 0xe328, [0xc67a] = 0xe329, [0xc67b] = 0xe32a, [0xc67c] = 0xe32b,
  [0xc67d] = 0xe32c, [0xc67e] = 0xe32d, [0xc67f] = 0xe32e, [0xc681] = 0xe32f,
  [0xc682] = 0xe330, [0xc683] = 0xe331, [0xc684] = 0xe332, [0xc685] = 0xe333,
  [0xc686] = 0xe334, [0xc687] = 0xe335, [0xc688] = 0xe336, [0xc689] = 0xe337,
  [0xc68a] = 0xe338, [0xc68b] = 0xe339, [0xc68c] = 0xe33a, [0xc68d] = 0xe33b,
  [0xc68e] = 0xe33c, [0xc68f] = 0xe33d, [0xc690] = 0xe33e, [0xc691] = 0xe33f,
  [0xc692] = 0xe340, [0xc693] = 0xe341, [0xc694] = 0xe342, [0xc695] = 0xe343,
  [0xc696] = 0xe344, [0xc697] = 0xe345, [0xc698] = 0xe346, [0xc699] = 0xe347,
  [0xc69a] = 0xe348, [0xc69b] = 0xe349, [0xc69c] = 0xe34a, [0xc69d] = 0xe34b,
  [0xc69e] = 0xe34c, [0xc69f] = 0xe34d, [0xc6a0] = 0xe34e, [0xc6a1] = 0xe34f,
  [0xc6a2] = 0xe350, [0xc6a3] = 0xe351, [0xc6a4] = 0xe352, [0xc6a5] = 0xe353,
  [0xc6a6] = 0xe354, [0xc6a7] = 0xe355, [0xc6a8] = 0xe356, [0xc6a9] = 0xe357,
  [0xc6aa] = 0xe358, [0xc6ab] = 0xe359, [0xc6ac] = 0xe35a, [0xc6ad] = 0xe35b,
  [0xc6ae] = 0xe35c, [0xc6af] = 0xe35d, [0xc6b0] = 0xe35e, [0xc6b1] = 0xe35f,
  [0xc6b2] = 0xe360, [0xc6b3] = 0xe361, [0xc6b4] = 0xe362, [0xc6b5] = 0xe363,
  [0xc6b6] = 0xe364, [0xc6b7] = 0xe365, [0xc6b8] = 0xe366, [0xc6b9] = 0xe367,
  [0xc6ba] = 0xe368, [0xc6bb] = 0xe369, [0xc6bc] = 0xe36a, [0xc6bd] = 0xe36b,
  [0xc6be] = 0xe36c, [0xc6bf] = 0xe36d, [0xc6c0] = 0xe36e, [0xc6c1] = 0xe36f,
  [0xc6c2] = 0xe370, [0xc6c3] = 0xe371, [0xc6c4] = 0xe372, [0xc6c5] = 0xe373,
  [0xc6c6] = 0xe374, [0xc6c7] = 0xe375, [0xc6c8] = 0xe376, [0xc6c9] = 0xe377,
  [0xc6ca] = 0xe378, [0xc6cb] = 0xe379, [0xc6cc] = 0xe37a, [0xc6cd] = 0xe37b,
  [0xc6ce] = 0xe37c, [0xc6cf] = 0xe37d, [0xc6d0] = 0xe37e, [0xc6d1] = 0xe37f,
  [0xc6d2] = 0xe380, [0xc6d3] = 0xe381, [0xc6d4] = 0xe382, [0xc6d5] = 0xe383,
  [0xc6d6] = 0xe384, [0xc6d7] = 0xe385, [0xc6d8] = 0xe386, [0xc6d9] = 0xe387,
  [0xc6da] = 0xe388, [0xc6db] = 0xe389, [0xc6dc] = 0xe38a, [0xc6dd] = 0xe38b,
  [0xc6de] = 0xe38c, [0xc6df] = 0xe38d, [0xc6e0] = 0xe38e, [0xc6e1] = 0xe38f,
  [0xc6e2] = 0xe390, [0xc6e3] = 0xe391, [0xc6e4] = 0xe392, [0xc6e5] = 0xe393,
  [0xc6e6] = 0xe394, [0xc6e7] = 0xe395, [0xc6e8] = 0xe396, [0xc6e9] = 0xe397,
  [0xc6ea] = 0xe398, [0xc6eb] = 0xe399, [0xc6ec] = 0xe39a, [0xc6ed] = 0xe39b,
  [0xc6ee] = 0xe39c, [0xc6ef] = 0xe39d, [0xc6f0] = 0xe39e, [0xc6f1] = 0xe39f,
  [0xc6f2] = 0xe3a0, [0xc6f3] = 0xe3a1, [0xc6f4] = 0xe3a2, [0xc6f5] = 0xe3a3,
  [0xc6f6] = 0xe3a4, [0xc6f7] = 0xe3a5, [0xc6f8] = 0xe3a6, [0xc6f9] = 0xe3a7,
  [0xc6fa] = 0xe3a8, [0xc6fb] = 0xe3a9, [0xc6fc] = 0xe3aa, [0xc6fd] = 0xe3ab,
  [0xc741] = 0xe3ac, [0xc742] = 0xe3ad, [0xc743] = 0xe3ae, [0xc744] = 0xe3af,
  [0xc745] = 0xe3b0, [0xc746] = 0xe3b1, [0xc747] = 0xe3b2, [0xc748] = 0xe3b3,
  [0xc749] = 0xe3b4, [0xc74a] = 0xe3b5, [0xc74b] = 0xe3b6, [0xc74c] = 0xe3b7,
  [0xc74d] = 0xe3b8, [0xc74e] = 0xe3b9, [0xc74f] = 0xe3ba, [0xc750] = 0xe3bb,
  [0xc751] = 0xe3bc, [0xc752] = 0xe3bd, [0xc753] = 0xe3be, [0xc754] = 0xe3bf,
  [0xc755] = 0xe3c0, [0xc756] = 0xe3c1, [0xc757] = 0xe3c2, [0xc758] = 0xe3c3,
  [0xc759] = 0xe3c4, [0xc75a] = 0xe3c5, [0xc75b] = 0xe3c6, [0xc75c] = 0xe3c7,
  [0xc75d] = 0xe3c8, [0xc75e] = 0xe3c9, [0xc75f] = 0xe3ca, [0xc760] = 0xe3cb,
  [0xc761] = 0xe3cc, [0xc762] = 0xe3cd, [0xc763] = 0xe3ce, [0xc764] = 0xe3cf,
  [0xc765] = 0xe3d0, [0xc766] = 0xe3d1, [0xc767] = 0xe3d2, [0xc768] = 0xe3d3,
  [0xc769] = 0xe3d4, [0xc76a] = 0xe3d5, [0xc76b] = 0xe3d6, [0xc76c] = 0xe3d7,
  [0xc76d] = 0xe3d8, [0xc76e] = 0xe3d9, [0xc76f] = 0xe3da, [0xc770] = 0xe3db,
  [0xc771] = 0xe3dc, [0xc772] = 0xe3dd, [0xc773] = 0xe3de, [0xc774] = 0xe3df,
  [0xc775] = 0xe3e0, [0xc776] = 0xe3e1, [0xc777] = 0xe3e2, [0xc778] = 0xe3e3,
  [0xc779] = 0xe3e4, [0xc77a] = 0xe3e5, [0xc77b] = 0xe3e6, [0xc77c] = 0xe3e7,
  [0xc77d] = 0xe3e8, [0xc77e] = 0xe3e9, [0xc77f] = 0xe3ea, [0xc781] = 0xe3eb,
  [0xc782] = 0xe3ec, [0xc783] = 0xe3ed, [0xc784] = 0xe3ee, [0xc785] = 0xe3ef,
  [0xc786] = 0xe3f0, [0xc787] = 0xe3f1, [0xc788] = 0xe3f2, [0xc789] = 0xe3f3,
  [0xc78a] = 0xe3f4, [0xc78b] = 0xe3f5, [0xc78c] = 0xe3f6, [0xc78d] = 0xe3f7,
  [0xc78e] = 0xe3f8, [0xc78f] = 0xe3f9, [0xc790] = 0xe3fa, [0xc791] = 0xe3fb,
  [0xc792] = 0xe3fc, [0xc793] = 0xe3fd, [0xc794] = 0xe3fe, [0xc795] = 0xe3ff,
  [0xc796] = 0xe400, [0xc797] = 0xe401, [0xc798] = 0xe402, [0xc799] = 0xe403,
  [0xc79a] = 0xe404, [0xc79b] = 0xe405, [0xc79c] = 0xe406, [0xc79d] = 0xe407,
  [0xc79e] = 0xe408, [0xc79f] = 0xe409, [0xc7a0] = 0xe40a, [0xc7a1] = 0xe40b,
  [0xc7a2] = 0xe40c, [0xc7a3] = 0xe40d, [0xc7a4] = 0xe40e, [0xc7a5] = 0xe40f,
  [0xc7a6] = 0xe410, [0xc7a7] = 0xe411, [0xc7a8] = 0xe412, [0xc7a9] = 0xe413,
  [0xc7aa] = 0xe414, [0xc7ab] = 0xe415, [0xc7ac] = 0xe416, [0xc7ad] = 0xe417,
  [0xc7ae] = 0xe418, [0xc7af] = 0xe419, [0xc7b0] = 0xe41a, [0xc7b1] = 0xe41b,
  [0xc7b2] = 0xe41c, [0xc7b3] = 0xe41d, [0xc7b4] = 0xe41e, [0xc7b5] = 0xe41f,
  [0xc7b6] = 0xe420, [0xc7b7] = 0xe421, [0xc7b8] = 0xe422, [0xc7b9] = 0xe423,
  [0xc7ba] = 0xe424, [0xc7bb] = 0xe425, [0xc7bc] = 0xe426, [0xc7bd] = 0xe427,
  [0xc7be] = 0xe428, [0xc7bf] = 0xe429, [0xc7c0] = 0xe42a, [0xc7c1] = 0xe42b,
  [0xc7c2] = 0xe42c, [0xc7c3] = 0xe42d, [0xc7c4] = 0xe42e, [0xc7c5] = 0xe42f,
  [0xc7c6] = 0xe430, [0xc7c7] = 0xe431, [0xc7c8] = 0xe432, [0xc7c9] = 0xe433,
  [0xc7ca] = 0xe434, [0xc7cb] = 0xe435, [0xc7cc] = 0xe436, [0xc7cd] = 0xe437,
  [0xc7ce] = 0xe438, [0xc7cf] = 0xe439, [0xc7d0] = 0xe43a, [0xc7d1] = 0xe43b,
  [0xc7d2] = 0xe43c, [0xc7d3] = 0xe43d, [0xc7d4] = 0xe43e, [0xc7d5] = 0xe43f,
  [0xc7d6] = 0xe440, [0xc7d7] = 0xe441, [0xc7d8] = 0xe442, [0xc7d9] = 0xe443,
  [0xc7da] = 0xe444, [0xc7db] = 0xe445, [0xc7dc] = 0xe446, [0xc7dd] = 0xe447,
  [0xc7de] = 0xe448, [0xc7df] = 0xe449, [0xc7e0] = 0xe44a, [0xc7e1] = 0xe44b,
  [0xc7e2] = 0xe44c, [0xc7e3] = 0xe44d, [0xc7e4] = 0xe44e, [0xc7e5] = 0xe44f,
  [0xc7e6] = 0xe450, [0xc7e7] = 0xe451, [0xc7e8] = 0xe452, [0xc7e9] = 0xe453,
  [0xc7ea] = 0xe454, [0xc7eb] = 0xe455, [0xc7ec] = 0xe456, [0xc7ed] = 0xe457,
  [0xc7ee] = 0xe458, [0xc7ef] = 0xe459, [0xc7f0] = 0xe45a, [0xc7f1] = 0xe45b,
  [0xc7f2] = 0xe45c, [0xc7f3] = 0xe45d, [0xc7f4] = 0xe45e, [0xc7f5] = 0xe45f,
  [0xc7f6] = 0xe460, [0xc7f7] = 0xe461, [0xc7f8] = 0xe462, [0xc7f9] = 0xe463,
  [0xc7fa] = 0xe464, [0xc7fb] = 0xe465, [0xc7fc] = 0xe466, [0xc7fd] = 0xe467,
  [0xc841] = 0xe468, [0xc842] = 0xe469, [0xc843] = 0xe46a, [0xc844] = 0xe46b,
  [0xc845] = 0xe46c, [0xc846] = 0xe46d, [0xc847] = 0xe46e, [0xc848] = 0xe46f,
  [0xc849] = 0xe470, [0xc84a] = 0xe471, [0xc84b] = 0xe472, [0xc84c] = 0xe473,
  [0xc84d] = 0xe474, [0xc84e] = 0xe475, [0xc84f] = 0xe476, [0xc850] = 0xe477,
  [0xc851] = 0xe478, [0xc852] = 0xe479, [0xc853] = 0xe47a, [0xc854] = 0xe47b,
  [0xc855] = 0xe47c, [0xc856] = 0xe47d, [0xc857] = 0xe47e, [0xc858] = 0xe47f,
  [0xc859] = 0xe480, [0xc85a] = 0xe481, [0xc85b] = 0xe482, [0xc85c] = 0xe483,
  [0xc85d] = 0xe484, [0xc85e] = 0xe485, [0xc85f] = 0xe486, [0xc860] = 0xe487,
  [0xc861] = 0xe488, [0xc862] = 0xe489, [0xc863] = 0xe48a, [0xc864] = 0xe48b,
  [0xc865] = 0xe48c, [0xc866] = 0xe48d, [0xc867] = 0xe48e, [0xc868] = 0xe48f,
  [0xc869] = 0xe490, [0xc86a] = 0xe491, [0xc86b] = 0xe492, [0xc86c] = 0xe493,
  [0xc86d] = 0xe494, [0xc86e] = 0xe495, [0xc86f] = 0xe496, [0xc870] = 0xe497,
  [0xc871] = 0xe498, [0xc872] = 0xe499, [0xc873] = 0xe49a, [0xc874] = 0xe49b,
  [0xc875] = 0xe49c, [0xc876] = 0xe49d, [0xc877] = 0xe49e, [0xc878] = 0xe49f,
  [0xc879] = 0xe4a0, [0xc87a] = 0xe4a1, [0xc87b] = 0xe4a2, [0xc87c] = 0xe4a3,
  [0xc87d] = 0xe4a4, [0xc87e] = 0xe4a5, [0xc87f] = 0xe4a6, [0xc881] = 0xe4a7,
  [0xc882] = 0xe4a8, [0xc883] = 0xe4a9, [0xc884] = 0xe4aa, [0xc885] = 0xe4ab,
  [0xc886] = 0xe4ac, [0xc887] = 0xe4ad, [0xc888] = 0xe4ae, [0xc889] = 0xe4af,
  [0xc88a] = 0xe4b0, [0xc88b] = 0xe4b1, [0xc88c] = 0xe4b2, [0xc88d] = 0xe4b3,
  [0xc88e] = 0xe4b4, [0xc88f] = 0xe4b5, [0xc890] = 0xe4b6, [0xc891] = 0xe4b7,
  [0xc892] = 0xe4b8, [0xc893] = 0xe4b9, [0xc894] = 0xe4ba, [0xc895] = 0xe4bb,
  [0xc896] = 0xe4bc, [0xc897] = 0xe4bd, [0xc898] = 0xe4be, [0xc899] = 0xe4bf,
  [0xc89a] = 0xe4c0, [0xc89b] = 0xe4c1, [0xc89c] = 0xe4c2, [0xc89d] = 0xe4c3,
  [0xc89e] = 0xe4c4, [0xc89f] = 0xe4c5, [0xc8a0] = 0xe4c6, [0xc8a1] = 0xe4c7,
  [0xc8a2] = 0xe4c8, [0xc8a3] = 0xe4c9, [0xc8a4] = 0xe4ca, [0xc8a5] = 0xe4cb,
  [0xc8a6] = 0xe4cc, [0xc8a7] = 0xe4cd, [0xc8a8] = 0xe4ce, [0xc8a9] = 0xe4cf,
  [0xc8aa] = 0xe4d0, [0xc8ab] = 0xe4d1, [0xc8ac] = 0xe4d2, [0xc8ad] = 0xe4d3,
  [0xc8ae] = 0xe4d4, [0xc8af] = 0xe4d5, [0xc8b0] = 0xe4d6, [0xc8b1] = 0xe4d7,
  [0xc8b2] = 0xe4d8, [0xc8b3] = 0xe4d9, [0xc8b4] = 0xe4da, [0xc8b5] = 0xe4db,
  [0xc8b6] = 0xe4dc, [0xc8b7] = 0xe4dd, [0xc8b8] = 0xe4de, [0xc8b9] = 0xe4df,
  [0xc8ba] = 0xe4e0, [0xc8bb] = 0xe4e1, [0xc8bc] = 0xe4e2, [0xc8bd] = 0xe4e3,
  [0xc8be] = 0xe4e4, [0xc8bf] = 0xe4e5, [0xc8c0] = 0xe4e6, [0xc8c1] = 0xe4e7,
  [0xc8c2] = 0xe4e8, [0xc8c3] = 0xe4e9, [0xc8c4] = 0xe4ea, [0xc8c5] = 0xe4eb,
  [0xc8c6] = 0xe4ec, [0xc8c7] = 0xe4ed, [0xc8c8] = 0xe4ee, [0xc8c9] = 0xe4ef,
  [0xc8ca] = 0xe4f0, [0xc8cb] = 0xe4f1, [0xc8cc] = 0xe4f2, [0xc8cd] = 0xe4f3,
  [0xc8ce] = 0xe4f4, [0xc8cf] = 0xe4f5, [0xc8d0] = 0xe4f6, [0xc8d1] = 0xe4f7,
  [0xc8d2] = 0xe4f8, [0xc8d3] = 0xe4f9, [0xc8d4] = 0xe4fa, [0xc8d5] = 0xe4fb,
  [0xc8d6] = 0xe4fc, [0xc8d7] = 0xe4fd, [0xc8d8] = 0xe4fe, [0xc8d9] = 0xe4ff,
  [0xc8da] = 0xe500, [0xc8db] = 0xe501, [0xc8dc] = 0xe502, [0xc8dd] = 0xe503,
  [0xc8de] = 0xe504, [0xc8df] = 0xe505, [0xc8e0] = 0xe506, [0xc8e1] = 0xe507,
  [0xc8e2] = 0xe508, [0xc8e3] = 0xe509, [0xc8e4] = 0xe50a, [0xc8e5] = 0xe50b,
  [0xc8e6] = 0xe50c, [0xc8e7] = 0xe50d, [0xc8e8] = 0xe50e, [0xc8e9] = 0xe50f,
  [0xc8ea] = 0xe510, [0xc8eb] = 0xe511, [0xc8ec] = 0xe512, [0xc8ed] = 0xe513,
  [0xc8ee] = 0xe514, [0xc8ef] = 0xe515, [0xc8f0] = 0xe516, [0xc8f1] = 0xe517,
  [0xc8f2] = 0xe518, [0xc8f3] = 0xe519, [0xc8f4] = 0xe51a, [0xc8f5] = 0xe51b,
  [0xc8f6] = 0xe51c, [0xc8f7] = 0xe51d, [0xc8f8] = 0xe51e, [0xc8f9] = 0xe51f,
  [0xc8fa] = 0xe520, [0xc8fb] = 0xe521, [0xc8fc] = 0xe522, [0xc8fd] = 0xe523,
  [0xc941] = 0xe524, [0xc942] = 0xe525, [0xc943] = 0xe526, [0xc944] = 0xe527,
  [0xc945] = 0xe528, [0xc946] = 0xe529, [0xc947] = 0xe52a, [0xc948] = 0xe52b,
  [0xc949] = 0xe52c, [0xc94a] = 0xe52d, [0xc94b] = 0xe52e, [0xc94c] = 0xe52f,
  [0xc94d] = 0xe530, [0xc94e] = 0xe531, [0xc94f] = 0xe532, [0xc950] = 0xe533,
  [0xc951] = 0xe534, [0xc952] = 0xe535, [0xc953] = 0xe536, [0xc954] = 0xe537,
  [0xc955] = 0xe538, [0xc956] = 0xe539, [0xc957] = 0xe53a, [0xc958] = 0xe53b,
  [0xc959] = 0xe53c, [0xc95a] = 0xe53d, [0xc95b] = 0xe53e, [0xc95c] = 0xe53f,
  [0xc95d] = 0xe540, [0xc95e] = 0xe541, [0xc95f] = 0xe542, [0xc960] = 0xe543,
  [0xc961] = 0xe544, [0xc962] = 0xe545, [0xc963] = 0xe546, [0xc964] = 0xe547,
  [0xc965] = 0xe548, [0xc966] = 0xe549, [0xc967] = 0xe54a, [0xc968] = 0xe54b,
  [0xc969] = 0xe54c, [0xc96a] = 0xe54d, [0xc96b] = 0xe54e, [0xc96c] = 0xe54f,
  [0xc96d] = 0xe550, [0xc96e] = 0xe551, [0xc96f] = 0xe552, [0xc970] = 0xe553,
  [0xc971] = 0xe554, [0xc972] = 0xe555, [0xc973] = 0xe556, [0xc974] = 0xe557,
  [0xc975] = 0xe558, [0xc976] = 0xe559, [0xc977] = 0xe55a, [0xc978] = 0xe55b,
  [0xc979] = 0xe55c, [0xc97a] = 0xe55d, [0xc97b] = 0xe55e, [0xc97c] = 0xe55f,
  [0xc97d] = 0xe560, [0xc97e] = 0xe561, [0xc97f] = 0xe562, [0xc981] = 0xe563,
  [0xc982] = 0xe564, [0xc983] = 0xe565, [0xc984] = 0xe566, [0xc985] = 0xe567,
  [0xc986] = 0xe568, [0xc987] = 0xe569, [0xc988] = 0xe56a, [0xc989] = 0xe56b,
  [0xc98a] = 0xe56c, [0xc98b] = 0xe56d, [0xc98c] = 0xe56e, [0xc98d] = 0xe56f,
  [0xc98e] = 0xe570, [0xc98f] = 0xe571, [0xc990] = 0xe572, [0xc991] = 0xe573,
  [0xc992] = 0xe574, [0xc993] = 0xe575, [0xc994] = 0xe576, [0xc995] = 0xe577,
  [0xc996] = 0xe578, [0xc997] = 0xe579, [0xc998] = 0xe57a, [0xc999] = 0xe57b,
  [0xc99a] = 0xe57c, [0xc99b] = 0xe57d, [0xc99c] = 0xe57e, [0xc99d] = 0xe57f,
  [0xc99e] = 0xe580, [0xc99f] = 0xe581, [0xc9a0] = 0xe582, [0xc9a1] = 0xe583,
  [0xc9a2] = 0xe584, [0xc9a3] = 0xe585, [0xc9a4] = 0xe586, [0xc9a5] = 0xe587,
  [0xc9a6] = 0xe588, [0xc9a7] = 0xe589, [0xc9a8] = 0xe58a, [0xc9a9] = 0xe58b,
  [0xc9aa] = 0xe58c, [0xc9ab] = 0xe58d, [0xc9ac] = 0xe58e, [0xc9ad] = 0xe58f,
  [0xc9ae] = 0xe590, [0xc9af] = 0xe591, [0xc9b0] = 0xe592, [0xc9b1] = 0xe593,
  [0xc9b2] = 0xe594, [0xc9b3] = 0xe595, [0xc9b4] = 0xe596, [0xc9b5] = 0xe597,
  [0xc9b6] = 0xe598, [0xc9b7] = 0xe599, [0xc9b8] = 0xe59a, [0xc9b9] = 0xe59b,
  [0xc9ba] = 0xe59c, [0xc9bb] = 0xe59d, [0xc9bc] = 0xe59e, [0xc9bd] = 0xe59f,
  [0xc9be] = 0xe5a0, [0xc9bf] = 0xe5a1, [0xc9c0] = 0xe5a2, [0xc9c1] = 0xe5a3,
  [0xc9c2] = 0xe5a4, [0xc9c3] = 0xe5a5, [0xc9c4] = 0xe5a6, [0xc9c5] = 0xe5a7,
  [0xc9c6] = 0xe5a8, [0xc9c7] = 0xe5a9, [0xc9c8] = 0xe5aa, [0xc9c9] = 0xe5ab,
  [0xc9ca] = 0xe5ac, [0xc9cb] = 0xe5ad, [0xc9cc] = 0xe5ae, [0xc9cd] = 0xe5af,
  [0xc9ce] = 0xe5b0, [0xc9cf] = 0xe5b1, [0xc9d0] = 0xe5b2, [0xc9d1] = 0xe5b3,
  [0xc9d2] = 0xe5b4, [0xc9d3] = 0xe5b5, [0xc9d4] = 0xe5b6, [0xc9d5] = 0xe5b7,
  [0xc9d6] = 0xe5b8, [0xc9d7] = 0xe5b9, [0xc9d8] = 0xe5ba, [0xc9d9] = 0xe5bb,
  [0xc9da] = 0xe5bc, [0xc9db] = 0xe5bd, [0xc9dc] = 0xe5be, [0xc9dd] = 0xe5bf,
  [0xc9de] = 0xe5c0, [0xc9df] = 0xe5c1, [0xc9e0] = 0xe5c2, [0xc9e1] = 0xe5c3,
  [0xc9e2] = 0xe5c4, [0xc9e3] = 0xe5c5, [0xc9e4] = 0xe5c6, [0xc9e5] = 0xe5c7,
  [0xc9e6] = 0xe5c8, [0xc9e7] = 0xe5c9, [0xc9e8] = 0xe5ca, [0xc9e9] = 0xe5cb,
  [0xc9ea] = 0xe5cc, [0xc9eb] = 0xe5cd, [0xc9ec] = 0xe5ce, [0xc9ed] = 0xe5cf,
  [0xc9ee] = 0xe5d0, [0xc9ef] = 0xe5d1, [0xc9f0] = 0xe5d2, [0xc9f1] = 0xe5d3,
  [0xc9f2] = 0xe5d4, [0xc9f3] = 0xe5d5, [0xc9f4] = 0xe5d6, [0xc9f5] = 0xe5d7,
  [0xc9f6] = 0xe5d8, [0xc9f7] = 0xe5d9, [0xc9f8] = 0xe5da, [0xc9f9] = 0xe5db,
  [0xc9fa] = 0xe5dc, [0xc9fb] = 0xe5dd, [0xc9fc] = 0xe5de, [0xc9fd] = 0xe5df,
  [0xca41] = 0xe5e0, [0xca42] = 0xe5e1, [0xca43] = 0xe5e2, [0xca44] = 0xe5e3,
  [0xca45] = 0xe5e4, [0xca46] = 0xe5e5, [0xca47] = 0xe5e6, [0xca48] = 0xe5e7,
  [0xca49] = 0xe5e8, [0xca4a] = 0xe5e9, [0xca4b] = 0xe5ea, [0xca4c] = 0xe5eb,
  [0xca4d] = 0xe5ec, [0xca4e] = 0xe5ed, [0xca4f] = 0xe5ee, [0xca50] = 0xe5ef,
  [0xca51] = 0xe5f0, [0xca52] = 0xe5f1, [0xca53] = 0xe5f2, [0xca54] = 0xe5f3,
  [0xca55] = 0xe5f4, [0xca56] = 0xe5f5, [0xca57] = 0xe5f6, [0xca58] = 0xe5f7,
  [0xca59] = 0xe5f8, [0xca5a] = 0xe5f9, [0xca5b] = 0xe5fa, [0xca5c] = 0xe5fb,
  [0xca5d] = 0xe5fc, [0xca5e] = 0xe5fd, [0xca5f] = 0xe5fe, [0xca60] = 0xe5ff,
  [0xca61] = 0xe600, [0xca62] = 0xe601, [0xca63] = 0xe602, [0xca64] = 0xe603,
  [0xca65] = 0xe604, [0xca66] = 0xe605, [0xca67] = 0xe606, [0xca68] = 0xe607,
  [0xca69] = 0xe608, [0xca6a] = 0xe609, [0xca6b] = 0xe60a, [0xca6c] = 0xe60b,
  [0xca6d] = 0xe60c, [0xca6e] = 0xe60d, [0xca6f] = 0xe60e, [0xca70] = 0xe60f,
  [0xca71] = 0xe610, [0xca72] = 0xe611, [0xca73] = 0xe612, [0xca74] = 0xe613,
  [0xca75] = 0xe614, [0xca76] = 0xe615, [0xca77] = 0xe616, [0xca78] = 0xe617,
  [0xca79] = 0xe618, [0xca7a] = 0xe619, [0xca7b] = 0xe61a, [0xca7c] = 0xe61b,
  [0xca7d] = 0xe61c, [0xca7e] = 0xe61d, [0xca7f] = 0xe61e, [0xca81] = 0xe61f,
  [0xca82] = 0xe620, [0xca83] = 0xe621, [0xca84] = 0xe622, [0xca85] = 0xe623,
  [0xca86] = 0xe624, [0xca87] = 0xe625, [0xca88] = 0xe626, [0xca89] = 0xe627,
  [0xca8a] = 0xe628, [0xca8b] = 0xe629, [0xca8c] = 0xe62a, [0xca8d] = 0xe62b,
  [0xca8e] = 0xe62c, [0xca8f] = 0xe62d, [0xca90] = 0xe62e, [0xca91] = 0xe62f,
  [0xca92] = 0xe630, [0xca93] = 0xe631, [0xca94] = 0xe632, [0xca95] = 0xe633,
  [0xca96] = 0xe634, [0xca97] = 0xe635, [0xca98] = 0xe636, [0xca99] = 0xe637,
  [0xca9a] = 0xe638, [0xca9b] = 0xe639, [0xca9c] = 0xe63a, [0xca9d] = 0xe63b,
  [0xca9e] = 0xe63c, [0xca9f] = 0xe63d, [0xcaa0] = 0xe63e, [0xcaa1] = 0xe63f,
  [0xcaa2] = 0xe640, [0xcaa3] = 0xe641, [0xcaa4] = 0xe642, [0xcaa5] = 0xe643,
  [0xcaa6] = 0xe644, [0xcaa7] = 0xe645, [0xcaa8] = 0xe646, [0xcaa9] = 0xe647,
  [0xcaaa] = 0xe648, [0xcaab] = 0xe649, [0xcaac] = 0xe64a, [0xcaad] = 0xe64b,
  [0xcaae] = 0xe64c, [0xcaaf] = 0xe64d, [0xcab0] = 0xe64e, [0xcab1] = 0xe64f,
  [0xcab2] = 0xe650, [0xcab3] = 0xe651, [0xcab4] = 0xe652, [0xcab5] = 0xe653,
  [0xcab6] = 0xe654, [0xcab7] = 0xe655, [0xcab8] = 0xe656, [0xcab9] = 0xe657,
  [0xcaba] = 0xe658, [0xcabb] = 0xe659, [0xcabc] = 0xe65a, [0xcabd] = 0xe65b,
  [0xcabe] = 0xe65c, [0xcabf] = 0xe65d, [0xcac0] = 0xe65e, [0xcac1] = 0xe65f,
  [0xcac2] = 0xe660, [0xcac3] = 0xe661, [0xcac4] = 0xe662, [0xcac5] = 0xe663,
  [0xcac6] = 0xe664, [0xcac7] = 0xe665, [0xcac8] = 0xe666, [0xcac9] = 0xe667,
  [0xcaca] = 0xe668, [0xcacb] = 0xe669, [0xcacc] = 0xe66a, [0xcacd] = 0xe66b,
  [0xcace] = 0xe66c, [0xcacf] = 0xe66d, [0xcad0] = 0xe66e, [0xcad1] = 0xe66f,
  [0xcad2] = 0xe670, [0xcad3] = 0xe671, [0xcad4] = 0xe672, [0xcad5] = 0xe673,
  [0xcad6] = 0xe674, [0xcad7] = 0xe675, [0xcad8] = 0xe676, [0xcad9] = 0xe677,
  [0xcada] = 0xe678, [0xcadb] = 0xe679, [0xcadc] = 0xe67a, [0xcadd] = 0xe67b,
  [0xcade] = 0xe67c, [0xcadf] = 0xe67d, [0xcae0] = 0xe67e, [0xcae1] = 0xe67f,
  [0xcae2] = 0xe680, [0xcae3] = 0xe681, [0xcae4] = 0xe682, [0xcae5] = 0xe683,
  [0xcae6] = 0xe684, [0xcae7] = 0xe685, [0xcae8] = 0xe686, [0xcae9] = 0xe687,
  [0xcaea] = 0xe688, [0xcaeb] = 0xe689, [0xcaec] = 0xe68a, [0xcaed] = 0xe68b,
  [0xcaee] = 0xe68c, [0xcaef] = 0xe68d, [0xcaf0] = 0xe68e, [0xcaf1] = 0xe68f,
  [0xcaf2] = 0xe690, [0xcaf3] = 0xe691, [0xcaf4] = 0xe692, [0xcaf5] = 0xe693,
  [0xcaf6] = 0xe694, [0xcaf7] = 0xe695, [0xcaf8] = 0xe696, [0xcaf9] = 0xe697,
  [0xcafa] = 0xe698, [0xcafb] = 0xe699, [0xcafc] = 0xe69a, [0xcafd] = 0xe69b,
  [0xcb41] = 0xe69c, [0xcb42] = 0xe69d, [0xcb43] = 0xe69e, [0xcb44] = 0xe69f,
  [0xcb45] = 0xe6a0, [0xcb46] = 0xe6a1, [0xcb47] = 0xe6a2, [0xcb48] = 0xe6a3,
  [0xcb49] = 0xe6a4, [0xcb4a] = 0xe6a5, [0xcb4b] = 0xe6a6, [0xcb4c] = 0xe6a7,
  [0xcb4d] = 0xe6a8, [0xcb4e] = 0xe6a9, [0xcb4f] = 0xe6aa, [0xcb50] = 0xe6ab,
  [0xcb51] = 0xe6ac, [0xcb52] = 0xe6ad, [0xcb53] = 0xe6ae, [0xcb54] = 0xe6af,
  [0xcb55] = 0xe6b0, [0xcb56] = 0xe6b1, [0xcb57] = 0xe6b2, [0xcb58] = 0xe6b3,
  [0xcb59] = 0xe6b4, [0xcb5a] = 0xe6b5, [0xcb5b] = 0xe6b6, [0xcb5c] = 0xe6b7,
  [0xcb5d] = 0xe6b8, [0xcb5e] = 0xe6b9, [0xcb5f] = 0xe6ba, [0xcb60] = 0xe6bb,
  [0xcb61] = 0xe6bc, [0xcb62] = 0xe6bd, [0xcb63] = 0xe6be, [0xcb64] = 0xe6bf,
  [0xcb65] = 0xe6c0, [0xcb66] = 0xe6c1, [0xcb67] = 0xe6c2, [0xcb68] = 0xe6c3,
  [0xcb69] = 0xe6c4, [0xcb6a] = 0xe6c5, [0xcb6b] = 0xe6c6, [0xcb6c] = 0xe6c7,
  [0xcb6d] = 0xe6c8, [0xcb6e] = 0xe6c9, [0xcb6f] = 0xe6ca, [0xcb70] = 0xe6cb,
  [0xcb71] = 0xe6cc, [0xcb72] = 0xe6cd, [0xcb73] = 0xe6ce, [0xcb74] = 0xe6cf,
  [0xcb75] = 0xe6d0, [0xcb76] = 0xe6d1, [0xcb77] = 0xe6d2, [0xcb78] = 0xe6d3,
  [0xcb79] = 0xe6d4, [0xcb7a] = 0xe6d5, [0xcb7b] = 0xe6d6, [0xcb7c] = 0xe6d7,
  [0xcb7d] = 0xe6d8, [0xcb7e] = 0xe6d9, [0xcb7f] = 0xe6da, [0xcb81] = 0xe6db,
  [0xcb82] = 0xe6dc, [0xcb83] = 0xe6dd, [0xcb84] = 0xe6de, [0xcb85] = 0xe6df,
  [0xcb86] = 0xe6e0, [0xcb87] = 0xe6e1, [0xcb88] = 0xe6e2, [0xcb89] = 0xe6e3,
  [0xcb8a] = 0xe6e4, [0xcb8b] = 0xe6e5, [0xcb8c] = 0xe6e6, [0xcb8d] = 0xe6e7,
  [0xcb8e] = 0xe6e8, [0xcb8f] = 0xe6e9, [0xcb90] = 0xe6ea, [0xcb91] = 0xe6eb,
  [0xcb92] = 0xe6ec, [0xcb93] = 0xe6ed, [0xcb94] = 0xe6ee, [0xcb95] = 0xe6ef,
  [0xcb96] = 0xe6f0, [0xcb97] = 0xe6f1, [0xcb98] = 0xe6f2, [0xcb99] = 0xe6f3,
  [0xcb9a] = 0xe6f4, [0xcb9b] = 0xe6f5, [0xcb9c] = 0xe6f6, [0xcb9d] = 0xe6f7,
  [0xcb9e] = 0xe6f8, [0xcb9f] = 0xe6f9, [0xcba0] = 0xe6fa, [0xcba1] = 0xe6fb,
  [0xcba2] = 0xe6fc, [0xcba3] = 0xe6fd, [0xcba4] = 0xe6fe, [0xcba5] = 0xe6ff,
  [0xcba6] = 0xe700, [0xcba7] = 0xe701, [0xcba8] = 0xe702, [0xcba9] = 0xe703,
  [0xcbaa] = 0xe704, [0xcbab] = 0xe705, [0xcbac] = 0xe706, [0xcbad] = 0xe707,
  [0xcbae] = 0xe708, [0xcbaf] = 0xe709, [0xcbb0] = 0xe70a, [0xcbb1] = 0xe70b,
  [0xcbb2] = 0xe70c, [0xcbb3] = 0xe70d, [0xcbb4] = 0xe70e, [0xcbb5] = 0xe70f,
  [0xcbb6] = 0xe710, [0xcbb7] = 0xe711, [0xcbb8] = 0xe712, [0xcbb9] = 0xe713,
  [0xcbba] = 0xe714, [0xcbbb] = 0xe715, [0xcbbc] = 0xe716, [0xcbbd] = 0xe717,
  [0xcbbe] = 0xe718, [0xcbbf] = 0xe719, [0xcbc0] = 0xe71a, [0xcbc1] = 0xe71b,
  [0xcbc2] = 0xe71c, [0xcbc3] = 0xe71d, [0xcbc4] = 0xe71e, [0xcbc5] = 0xe71f,
  [0xcbc6] = 0xe720, [0xcbc7] = 0xe721, [0xcbc8] = 0xe722, [0xcbc9] = 0xe723,
  [0xcbca] = 0xe724, [0xcbcb] = 0xe725, [0xcbcc] = 0xe726, [0xcbcd] = 0xe727,
  [0xcbce] = 0xe728, [0xcbcf] = 0xe729, [0xcbd0] = 0xe72a, [0xcbd1] = 0xe72b,
  [0xcbd2] = 0xe72c, [0xcbd3] = 0xe72d, [0xcbd4] = 0xe72e, [0xcbd5] = 0xe72f,
  [0xcbd6] = 0xe730, [0xcbd7] = 0xe731, [0xcbd8] = 0xe732, [0xcbd9] = 0xe733,
  [0xcbda] = 0xe734, [0xcbdb] = 0xe735, [0xcbdc] = 0xe736, [0xcbdd] = 0xe737,
  [0xcbde] = 0xe738, [0xcbdf] = 0xe739, [0xcbe0] = 0xe73a, [0xcbe1] = 0xe73b,
  [0xcbe2] = 0xe73c, [0xcbe3] = 0xe73d, [0xcbe4] = 0xe73e, [0xcbe5] = 0xe73f,
  [0xcbe6] = 0xe740, [0xcbe7] = 0xe741, [0xcbe8] = 0xe742, [0xcbe9] = 0xe743,
  [0xcbea] = 0xe744, [0xcbeb] = 0xe745, [0xcbec] = 0xe746, [0xcbed] = 0xe747,
  [0xcbee] = 0xe748, [0xcbef] = 0xe749, [0xcbf0] = 0xe74a, [0xcbf1] = 0xe74b,
  [0xcbf2] = 0xe74c, [0xcbf3] = 0xe74d, [0xcbf4] = 0xe74e, [0xcbf5] = 0xe74f,
  [0xcbf6] = 0xe750, [0xcbf7] = 0xe751, [0xcbf8] = 0xe752, [0xcbf9] = 0xe753,
  [0xcbfa] = 0xe754, [0xcbfb] = 0xe755, [0xcbfc] = 0xe756, [0xcbfd] = 0xe757,
  [0xcc41] = 0xe758, [0xcc42] = 0xe759, [0xcc43] = 0xe75a, [0xcc44] = 0xe75b,
  [0xcc45] = 0xe75c, [0xcc46] = 0xe75d, [0xcc47] = 0xe75e, [0xcc48] = 0xe75f,
  [0xcc49] = 0xe760, [0xcc4a] = 0xe761, [0xcc4b] = 0xe762, [0xcc4c] = 0xe763,
  [0xcc4d] = 0xe764, [0xcc4e] = 0xe765, [0xcc4f] = 0xe766, [0xcc50] = 0xe767,
  [0xcc51] = 0xe768, [0xcc52] = 0xe769, [0xcc53] = 0xe76a, [0xcc54] = 0xe76b,
  [0xcc55] = 0xe76c, [0xcc56] = 0xe76d, [0xcc57] = 0xe76e, [0xcc58] = 0xe76f,
  [0xcc59] = 0xe770, [0xcc5a] = 0xe771, [0xcc5b] = 0xe772, [0xcc5c] = 0xe773,
  [0xcc5d] = 0xe774, [0xcc5e] = 0xe775, [0xcc5f] = 0xe776, [0xcc60] = 0xe777,
  [0xcc61] = 0xe778, [0xcc62] = 0xe779, [0xcc63] = 0xe77a, [0xcc64] = 0xe77b,
  [0xcc65] = 0xe77c, [0xcc66] = 0xe77d, [0xcc67] = 0xe77e, [0xcc68] = 0xe77f,
  [0xcc69] = 0xe780, [0xcc6a] = 0xe781, [0xcc6b] = 0xe782, [0xcc6c] = 0xe783,
  [0xcc6d] = 0xe784, [0xcc6e] = 0xe785, [0xcc6f] = 0xe786, [0xcc70] = 0xe787,
  [0xcc71] = 0xe788, [0xcc72] = 0xe789, [0xcc73] = 0xe78a, [0xcc74] = 0xe78b,
  [0xcc75] = 0xe78c, [0xcc76] = 0xe78d, [0xcc77] = 0xe78e, [0xcc78] = 0xe78f,
  [0xcc79] = 0xe790, [0xcc7a] = 0xe791, [0xcc7b] = 0xe792, [0xcc7c] = 0xe793,
  [0xcc7d] = 0xe794, [0xcc7e] = 0xe795, [0xcc7f] = 0xe796, [0xcc81] = 0xe797,
  [0xcc82] = 0xe798, [0xcc83] = 0xe799, [0xcc84] = 0xe79a, [0xcc85] = 0xe79b,
  [0xcc86] = 0xe79c, [0xcc87] = 0xe79d, [0xcc88] = 0xe79e, [0xcc89] = 0xe79f,
  [0xcc8a] = 0xe7a0, [0xcc8b] = 0xe7a1, [0xcc8c] = 0xe7a2, [0xcc8d] = 0xe7a3,
  [0xcc8e] = 0xe7a4, [0xcc8f] = 0xe7a5, [0xcc90] = 0xe7a6, [0xcc91] = 0xe7a7,
  [0xcc92] = 0xe7a8, [0xcc93] = 0xe7a9, [0xcc94] = 0xe7aa, [0xcc95] = 0xe7ab,
  [0xcc96] = 0xe7ac, [0xcc97] = 0xe7ad, [0xcc98] = 0xe7ae, [0xcc99] = 0xe7af,
  [0xcc9a] = 0xe7b0, [0xcc9b] = 0xe7b1, [0xcc9c] = 0xe7b2, [0xcc9d] = 0xe7b3,
  [0xcc9e] = 0xe7b4, [0xcc9f] = 0xe7b5, [0xcca0] = 0xe7b6, [0xcca1] = 0xe7b7,
  [0xcca2] = 0xe7b8, [0xcca3] = 0xe7b9, [0xcca4] = 0xe7ba, [0xcca5] = 0xe7bb,
  [0xcca6] = 0xe7bc, [0xcca7] = 0xe7bd, [0xcca8] = 0xe7be, [0xcca9] = 0xe7bf,
  [0xccaa] = 0xe7c0, [0xccab] = 0xe7c1, [0xccac] = 0xe7c2, [0xccad] = 0xe7c3,
  [0xccae] = 0xe7c4, [0xccaf] = 0xe7c5, [0xccb0] = 0xe7c6, [0xccb1] = 0xe7c7,
  [0xccb2] = 0xe7c8, [0xccb3] = 0xe7c9, [0xccb4] = 0xe7ca, [0xccb5] = 0xe7cb,
  [0xccb6] = 0xe7cc, [0xccb7] = 0xe7cd, [0xccb8] = 0xe7ce, [0xccb9] = 0xe7cf,
  [0xccba] = 0xe7d0, [0xccbb] = 0xe7d1, [0xccbc] = 0xe7d2, [0xccbd] = 0xe7d3,
  [0xccbe] = 0xe7d4, [0xccbf] = 0xe7d5, [0xccc0] = 0xe7d6, [0xccc1] = 0xe7d7,
  [0xccc2] = 0xe7d8, [0xccc3] = 0xe7d9, [0xccc4] = 0xe7da, [0xccc5] = 0xe7db,
  [0xccc6] = 0xe7dc, [0xccc7] = 0xe7dd, [0xccc8] = 0xe7de, [0xccc9] = 0xe7df,
  [0xccca] = 0xe7e0, [0xcccb] = 0xe7e1, [0xcccc] = 0xe7e2, [0xcccd] = 0xe7e3,
  [0xccce] = 0xe7e4, [0xcccf] = 0xe7e5, [0xccd0] = 0xe7e6, [0xccd1] = 0xe7e7,
  [0xccd2] = 0xe7e8, [0xccd3] = 0xe7e9, [0xccd4] = 0xe7ea, [0xccd5] = 0xe7eb,
  [0xccd6] = 0xe7ec, [0xccd7] = 0xe7ed, [0xccd8] = 0xe7ee, [0xccd9] = 0xe7ef,
  [0xccda] = 0xe7f0, [0xccdb] = 0xe7f1, [0xccdc] = 0xe7f2, [0xccdd] = 0xe7f3,
  [0xccde] = 0xe7f4, [0xccdf] = 0xe7f5, [0xcce0] = 0xe7f6, [0xcce1] = 0xe7f7,
  [0xcce2] = 0xe7f8, [0xcce3] = 0xe7f9, [0xcce4] = 0xe7fa, [0xcce5] = 0xe7fb,
  [0xcce6] = 0xe7fc, [0xcce7] = 0xe7fd, [0xcce8] = 0xe7fe, [0xcce9] = 0xe7ff,
  [0xccea] = 0xe800, [0xcceb] = 0xe801, [0xccec] = 0xe802, [0xcced] = 0xe803,
  [0xccee] = 0xe804, [0xccef] = 0xe805, [0xccf0] = 0xe806, [0xccf1] = 0xe807,
  [0xccf2] = 0xe808, [0xccf3] = 0xe809, [0xccf4] = 0xe80a, [0xccf5] = 0xe80b,
  [0xccf6] = 0xe80c, [0xccf7] = 0xe80d, [0xccf8] = 0xe80e, [0xccf9] = 0xe80f,
  [0xccfa] = 0xe810, [0xccfb] = 0xe811, [0xccfc] = 0xe812, [0xccfd] = 0xe813,
  [0xcd41] = 0xe814, [0xcd42] = 0xe815, [0xcd43] = 0xe816, [0xcd44] = 0xe817,
  [0xcd45] = 0xe818, [0xcd46] = 0xe819, [0xcd47] = 0xe81a, [0xcd48] = 0xe81b,
  [0xcd49] = 0xe81c, [0xcd4a] = 0xe81d, [0xcd4b] = 0xe81e, [0xcd4c] = 0xe81f,
  [0xcd4d] = 0xe820, [0xcd4e] = 0xe821, [0xcd4f] = 0xe822, [0xcd50] = 0xe823,
  [0xcd51] = 0xe824, [0xcd52] = 0xe825, [0xcd53] = 0xe826, [0xcd54] = 0xe827,
  [0xcd55] = 0xe828, [0xcd56] = 0xe829, [0xcd57] = 0xe82a, [0xcd58] = 0xe82b,
  [0xcd59] = 0xe82c, [0xcd5a] = 0xe82d, [0xcd5b] = 0xe82e, [0xcd5c] = 0xe82f,
  [0xcd5d] = 0xe830, [0xcd5e] = 0xe831, [0xcd5f] = 0xe832, [0xcd60] = 0xe833,
  [0xcd61] = 0xe834, [0xcd62] = 0xe835, [0xcd63] = 0xe836, [0xcd64] = 0xe837,
  [0xcd65] = 0xe838, [0xcd66] = 0xe839, [0xcd67] = 0xe83a, [0xcd68] = 0xe83b,
  [0xcd69] = 0xe83c, [0xcd6a] = 0xe83d, [0xcd6b] = 0xe83e, [0xcd6c] = 0xe83f,
  [0xcd6d] = 0xe840, [0xcd6e] = 0xe841, [0xcd6f] = 0xe842, [0xcd70] = 0xe843,
  [0xcd71] = 0xe844, [0xcd72] = 0xe845, [0xcd73] = 0xe846, [0xcd74] = 0xe847,
  [0xcd75] = 0xe848, [0xcd76] = 0xe849, [0xcd77] = 0xe84a, [0xcd78] = 0xe84b,
  [0xcd79] = 0xe84c, [0xcd7a] = 0xe84d, [0xcd7b] = 0xe84e, [0xcd7c] = 0xe84f,
  [0xcd7d] = 0xe850, [0xcd7e] = 0xe851, [0xcd7f] = 0xe852, [0xcd81] = 0xe853,
  [0xcd82] = 0xe854, [0xcd83] = 0xe855, [0xcd84] = 0xe856, [0xcd85] = 0xe857,
  [0xcd86] = 0xe858, [0xcd87] = 0xe859, [0xcd88] = 0xe85a, [0xcd89] = 0xe85b,
  [0xcd8a] = 0xe85c, [0xcd8b] = 0xe85d, [0xcd8c] = 0xe85e, [0xcd8d] = 0xe85f,
  [0xcd8e] = 0xe860, [0xcd8f] = 0xe861, [0xcd90] = 0xe862, [0xcd91] = 0xe863,
  [0xcd92] = 0xe864, [0xcd93] = 0xe865, [0xcd94] = 0xe866, [0xcd95] = 0xe867,
  [0xcd96] = 0xe868, [0xcd97] = 0xe869, [0xcd98] = 0xe86a, [0xcd99] = 0xe86b,
  [0xcd9a] = 0xe86c, [0xcd9b] = 0xe86d, [0xcd9c] = 0xe86e, [0xcd9d] = 0xe86f,
  [0xcd9e] = 0xe870, [0xcd9f] = 0xe871, [0xcda0] = 0xe872, [0xcda1] = 0xe873,
  [0xcda2] = 0xe874, [0xcda3] = 0xe875, [0xcda4] = 0xe876, [0xcda5] = 0xe877,
  [0xcda6] = 0xe878, [0xcda7] = 0xe879, [0xcda8] = 0xe87a, [0xcda9] = 0xe87b,
  [0xcdaa] = 0xe87c, [0xcdab] = 0xe87d, [0xcdac] = 0xe87e, [0xcdad] = 0xe87f,
  [0xcdae] = 0xe880, [0xcdaf] = 0xe881, [0xcdb0] = 0xe882, [0xcdb1] = 0xe883,
  [0xcdb2] = 0xe884, [0xcdb3] = 0xe885, [0xcdb4] = 0xe886, [0xcdb5] = 0xe887,
  [0xcdb6] = 0xe888, [0xcdb7] = 0xe889, [0xcdb8] = 0xe88a, [0xcdb9] = 0xe88b,
  [0xcdba] = 0xe88c, [0xcdbb] = 0xe88d, [0xcdbc] = 0xe88e, [0xcdbd] = 0xe88f,
  [0xcdbe] = 0xe890, [0xcdbf] = 0xe891, [0xcdc0] = 0xe892, [0xcdc1] = 0xe893,
  [0xcdc2] = 0xe894, [0xcdc3] = 0xe895, [0xcdc4] = 0xe896, [0xcdc5] = 0xe897,
  [0xcdc6] = 0xe898, [0xcdc7] = 0xe899, [0xcdc8] = 0xe89a, [0xcdc9] = 0xe89b,
  [0xcdca] = 0xe89c, [0xcdcb] = 0xe89d, [0xcdcc] = 0xe89e, [0xcdcd] = 0xe89f,
  [0xcdce] = 0xe8a0, [0xcdcf] = 0xe8a1, [0xcdd0] = 0xe8a2, [0xcdd1] = 0xe8a3,
  [0xcdd2] = 0xe8a4, [0xcdd3] = 0xe8a5, [0xcdd4] = 0xe8a6, [0xcdd5] = 0xe8a7,
  [0xcdd6] = 0xe8a8, [0xcdd7] = 0xe8a9, [0xcdd8] = 0xe8aa, [0xcdd9] = 0xe8ab,
  [0xcdda] = 0xe8ac, [0xcddb] = 0xe8ad, [0xcddc] = 0xe8ae, [0xcddd] = 0xe8af,
  [0xcdde] = 0xe8b0, [0xcddf] = 0xe8b1, [0xcde0] = 0xe8b2, [0xcde1] = 0xe8b3,
  [0xcde2] = 0xe8b4, [0xcde3] = 0xe8b5, [0xcde4] = 0xe8b6, [0xcde5] = 0xe8b7,
  [0xcde6] = 0xe8b8, [0xcde7] = 0xe8b9, [0xcde8] = 0xe8ba, [0xcde9] = 0xe8bb,
  [0xcdea] = 0xe8bc, [0xcdeb] = 0xe8bd, [0xcdec] = 0xe8be, [0xcded] = 0xe8bf,
  [0xcdee] = 0xe8c0, [0xcdef] = 0xe8c1, [0xcdf0] = 0xe8c2, [0xcdf1] = 0xe8c3,
  [0xcdf2] = 0xe8c4, [0xcdf3] = 0xe8c5, [0xcdf4] = 0xe8c6, [0xcdf5] = 0xe8c7,
  [0xcdf6] = 0xe8c8, [0xcdf7] = 0xe8c9, [0xcdf8] = 0xe8ca, [0xcdf9] = 0xe8cb,
  [0xcdfa] = 0xe8cc, [0xcdfb] = 0xe8cd, [0xcdfc] = 0xe8ce, [0xcdfd] = 0xe8cf,
  [0xce41] = 0xe8d0, [0xce42] = 0xe8d1, [0xce43] = 0xe8d2, [0xce44] = 0xe8d3,
  [0xce45] = 0xe8d4, [0xce46] = 0xe8d5, [0xce47] = 0xe8d6, [0xce48] = 0xe8d7,
  [0xce49] = 0xe8d8, [0xce4a] = 0xe8d9, [0xce4b] = 0xe8da, [0xce4c] = 0xe8db,
  [0xce4d] = 0xe8dc, [0xce4e] = 0xe8dd, [0xce4f] = 0xe8de, [0xce50] = 0xe8df,
  [0xce51] = 0xe8e0, [0xce52] = 0xe8e1, [0xce53] = 0xe8e2, [0xce54] = 0xe8e3,
  [0xce55] = 0xe8e4, [0xce56] = 0xe8e5, [0xce57] = 0xe8e6, [0xce58] = 0xe8e7,
  [0xce59] = 0xe8e8, [0xce5a] = 0xe8e9, [0xce5b] = 0xe8ea, [0xce5c] = 0xe8eb,
  [0xce5d] = 0xe8ec, [0xce5e] = 0xe8ed, [0xce5f] = 0xe8ee, [0xce60] = 0xe8ef,
  [0xce61] = 0xe8f0, [0xce62] = 0xe8f1, [0xce63] = 0xe8f2, [0xce64] = 0xe8f3,
  [0xce65] = 0xe8f4, [0xce66] = 0xe8f5, [0xce67] = 0xe8f6, [0xce68] = 0xe8f7,
  [0xce69] = 0xe8f8, [0xce6a] = 0xe8f9, [0xce6b] = 0xe8fa, [0xce6c] = 0xe8fb,
  [0xce6d] = 0xe8fc, [0xce6e] = 0xe8fd, [0xce6f] = 0xe8fe, [0xce70] = 0xe8ff,
  [0xce71] = 0xe900, [0xce72] = 0xe901, [0xce73] = 0xe902, [0xce74] = 0xe903,
  [0xce75] = 0xe904, [0xce76] = 0xe905, [0xce77] = 0xe906, [0xce78] = 0xe907,
  [0xce79] = 0xe908, [0xce7a] = 0xe909, [0xce7b] = 0xe90a, [0xce7c] = 0xe90b,
  [0xce7d] = 0xe90c, [0xce7e] = 0xe90d, [0xce7f] = 0xe90e, [0xce81] = 0xe90f,
  [0xce82] = 0xe910, [0xce83] = 0xe911, [0xce84] = 0xe912, [0xce85] = 0xe913,
  [0xce86] = 0xe914, [0xce87] = 0xe915, [0xce88] = 0xe916, [0xce89] = 0xe917,
  [0xce8a] = 0xe918, [0xce8b] = 0xe919, [0xce8c] = 0xe91a, [0xce8d] = 0xe91b,
  [0xce8e] = 0xe91c, [0xce8f] = 0xe91d, [0xce90] = 0xe91e, [0xce91] = 0xe91f,
  [0xce92] = 0xe920, [0xce93] = 0xe921, [0xce94] = 0xe922, [0xce95] = 0xe923,
  [0xce96] = 0xe924, [0xce97] = 0xe925, [0xce98] = 0xe926, [0xce99] = 0xe927,
  [0xce9a] = 0xe928, [0xce9b] = 0xe929, [0xce9c] = 0xe92a, [0xce9d] = 0xe92b,
  [0xce9e] = 0xe92c, [0xce9f] = 0xe92d, [0xcea0] = 0xe92e, [0xcea1] = 0xe92f,
  [0xcea2] = 0xe930, [0xcea3] = 0xe931, [0xcea4] = 0xe932, [0xcea5] = 0xe933,
  [0xcea6] = 0xe934, [0xcea7] = 0xe935, [0xcea8] = 0xe936, [0xcea9] = 0xe937,
  [0xceaa] = 0xe938, [0xceab] = 0xe939, [0xceac] = 0xe93a, [0xcead] = 0xe93b,
  [0xceae] = 0xe93c, [0xceaf] = 0xe93d, [0xceb0] = 0xe93e, [0xceb1] = 0xe93f,
  [0xceb2] = 0xe940, [0xceb3] = 0xe941, [0xceb4] = 0xe942, [0xceb5] = 0xe943,
  [0xceb6] = 0xe944, [0xceb7] = 0xe945, [0xceb8] = 0xe946, [0xceb9] = 0xe947,
  [0xceba] = 0xe948, [0xcebb] = 0xe949, [0xcebc] = 0xe94a, [0xcebd] = 0xe94b,
  [0xcebe] = 0xe94c, [0xcebf] = 0xe94d, [0xcec0] = 0xe94e, [0xcec1] = 0xe94f,
  [0xcec2] = 0xe950, [0xcec3] = 0xe951, [0xcec4] = 0xe952, [0xcec5] = 0xe953,
  [0xcec6] = 0xe954, [0xcec7] = 0xe955, [0xcec8] = 0xe956, [0xcec9] = 0xe957,
  [0xceca] = 0xe958, [0xcecb] = 0xe959, [0xcecc] = 0xe95a, [0xcecd] = 0xe95b,
  [0xcece] = 0xe95c, [0xcecf] = 0xe95d, [0xced0] = 0xe95e, [0xced1] = 0xe95f,
  [0xced2] = 0xe960, [0xced3] = 0xe961, [0xced4] = 0xe962, [0xced5] = 0xe963,
  [0xced6] = 0xe964, [0xced7] = 0xe965, [0xced8] = 0xe966, [0xced9] = 0xe967,
  [0xceda] = 0xe968, [0xcedb] = 0xe969, [0xcedc] = 0xe96a, [0xcedd] = 0xe96b,
  [0xcede] = 0xe96c, [0xcedf] = 0xe96d, [0xcee0] = 0xe96e, [0xcee1] = 0xe96f,
  [0xcee2] = 0xe970, [0xcee3] = 0xe971, [0xcee4] = 0xe972, [0xcee5] = 0xe973,
  [0xcee6] = 0xe974, [0xcee7] = 0xe975, [0xcee8] = 0xe976, [0xcee9] = 0xe977,
  [0xceea] = 0xe978, [0xceeb] = 0xe979, [0xceec] = 0xe97a, [0xceed] = 0xe97b,
  [0xceee] = 0xe97c, [0xceef] = 0xe97d, [0xcef0] = 0xe97e, [0xcef1] = 0xe97f,
  [0xcef2] = 0xe980, [0xcef3] = 0xe981, [0xcef4] = 0xe982, [0xcef5] = 0xe983,
  [0xcef6] = 0xe984, [0xcef7] = 0xe985, [0xcef8] = 0xe986, [0xcef9] = 0xe987,
  [0xcefa] = 0xe988, [0xcefb] = 0xe989, [0xcefc] = 0xe98a, [0xcefd] = 0xe98b,
  [0xcf41] = 0xe98c, [0xcf42] = 0xe98d, [0xcf43] = 0xe98e, [0xcf44] = 0xe98f,
  [0xcf45] = 0xe990, [0xcf46] = 0xe991, [0xcf47] = 0xe992, [0xcf48] = 0xe993,
  [0xcf49] = 0xe994, [0xcf4a] = 0xe995, [0xcf4b] = 0xe996, [0xcf4c] = 0xe997,
  [0xcf4d] = 0xe998, [0xcf4e] = 0xe999, [0xcf4f] = 0xe99a, [0xcf50] = 0xe99b,
  [0xcf51] = 0xe99c, [0xcf52] = 0xe99d, [0xcf53] = 0xe99e, [0xcf54] = 0xe99f,
  [0xcf55] = 0xe9a0, [0xcf56] = 0xe9a1, [0xcf57] = 0xe9a2, [0xcf58] = 0xe9a3,
  [0xcf59] = 0xe9a4, [0xcf5a] = 0xe9a5, [0xcf5b] = 0xe9a6, [0xcf5c] = 0xe9a7,
  [0xcf5d] = 0xe9a8, [0xcf5e] = 0xe9a9, [0xcf5f] = 0xe9aa, [0xcf60] = 0xe9ab,
  [0xcf61] = 0xe9ac, [0xcf62] = 0xe9ad, [0xcf63] = 0xe9ae, [0xcf64] = 0xe9af,
  [0xcf65] = 0xe9b0, [0xcf66] = 0xe9b1, [0xcf67] = 0xe9b2, [0xcf68] = 0xe9b3,
  [0xcf69] = 0xe9b4, [0xcf6a] = 0xe9b5, [0xcf6b] = 0xe9b6, [0xcf6c] = 0xe9b7,
  [0xcf6d] = 0xe9b8, [0xcf6e] = 0xe9b9, [0xcf6f] = 0xe9ba, [0xcf70] = 0xe9bb,
  [0xcf71] = 0xe9bc, [0xcf72] = 0xe9bd, [0xcf73] = 0xe9be, [0xcf74] = 0xe9bf,
  [0xcf75] = 0xe9c0, [0xcf76] = 0xe9c1, [0xcf77] = 0xe9c2, [0xcf78] = 0xe9c3,
  [0xcf79] = 0xe9c4, [0xcf7a] = 0xe9c5, [0xcf7b] = 0xe9c6, [0xcf7c] = 0xe9c7,
  [0xcf7d] = 0xe9c8, [0xcf7e] = 0xe9c9, [0xcf7f] = 0xe9ca, [0xcf81] = 0xe9cb,
  [0xcf82] = 0xe9cc, [0xcf83] = 0xe9cd, [0xcf84] = 0xe9ce, [0xcf85] = 0xe9cf,
  [0xcf86] = 0xe9d0, [0xcf87] = 0xe9d1, [0xcf88] = 0xe9d2, [0xcf89] = 0xe9d3,
  [0xcf8a] = 0xe9d4, [0xcf8b] = 0xe9d5, [0xcf8c] = 0xe9d6, [0xcf8d] = 0xe9d7,
  [0xcf8e] = 0xe9d8, [0xcf8f] = 0xe9d9, [0xcf90] = 0xe9da, [0xcf91] = 0xe9db,
  [0xcf92] = 0xe9dc, [0xcf93] = 0xe9dd, [0xcf94] = 0xe9de, [0xcf95] = 0xe9df,
  [0xcf96] = 0xe9e0, [0xcf97] = 0xe9e1, [0xcf98] = 0xe9e2, [0xcf99] = 0xe9e3,
  [0xcf9a] = 0xe9e4, [0xcf9b] = 0xe9e5, [0xcf9c] = 0xe9e6, [0xcf9d] = 0xe9e7,
  [0xcf9e] = 0xe9e8, [0xcf9f] = 0xe9e9, [0xcfa0] = 0xe9ea, [0xcfa1] = 0xe9eb,
  [0xcfa2] = 0xe9ec, [0xcfa3] = 0xe9ed, [0xcfa4] = 0xe9ee, [0xcfa5] = 0xe9ef,
  [0xcfa6] = 0xe9f0, [0xcfa7] = 0xe9f1, [0xcfa8] = 0xe9f2, [0xcfa9] = 0xe9f3,
  [0xcfaa] = 0xe9f4, [0xcfab] = 0xe9f5, [0xcfac] = 0xe9f6, [0xcfad] = 0xe9f7,
  [0xcfae] = 0xe9f8, [0xcfaf] = 0xe9f9, [0xcfb0] = 0xe9fa, [0xcfb1] = 0xe9fb,
  [0xcfb2] = 0xe9fc, [0xcfb3] = 0xe9fd, [0xcfb4] = 0xe9fe, [0xcfb5] = 0xe9ff,
  [0xcfb6] = 0xea00, [0xcfb7] = 0xea01, [0xcfb8] = 0xea02, [0xcfb9] = 0xea03,
  [0xcfba] = 0xea04, [0xcfbb] = 0xea05, [0xcfbc] = 0xea06, [0xcfbd] = 0xea07,
  [0xcfbe] = 0xea08, [0xcfbf] = 0xea09, [0xcfc0] = 0xea0a, [0xcfc1] = 0xea0b,
  [0xcfc2] = 0xea0c, [0xcfc3] = 0xea0d, [0xcfc4] = 0xea0e, [0xcfc5] = 0xea0f,
  [0xcfc6] = 0xea10, [0xcfc7] = 0xea11, [0xcfc8] = 0xea12, [0xcfc9] = 0xea13,
  [0xcfca] = 0xea14, [0xcfcb] = 0xea15, [0xcfcc] = 0xea16, [0xcfcd] = 0xea17,
  [0xcfce] = 0xea18, [0xcfcf] = 0xea19, [0xcfd0] = 0xea1a, [0xcfd1] = 0xea1b,
  [0xcfd2] = 0xea1c, [0xcfd3] = 0xea1d, [0xcfd4] = 0xea1e, [0xcfd5] = 0xea1f,
  [0xcfd6] = 0xea20, [0xcfd7] = 0xea21, [0xcfd8] = 0xea22, [0xcfd9] = 0xea23,
  [0xcfda] = 0xea24, [0xcfdb] = 0xea25, [0xcfdc] = 0xea26, [0xcfdd] = 0xea27,
  [0xcfde] = 0xea28, [0xcfdf] = 0xea29, [0xcfe0] = 0xea2a, [0xcfe1] = 0xea2b,
  [0xcfe2] = 0xea2c, [0xcfe3] = 0xea2d, [0xcfe4] = 0xea2e, [0xcfe5] = 0xea2f,
  [0xcfe6] = 0xea30, [0xcfe7] = 0xea31, [0xcfe8] = 0xea32, [0xcfe9] = 0xea33,
  [0xcfea] = 0xea34, [0xcfeb] = 0xea35, [0xcfec] = 0xea36, [0xcfed] = 0xea37,
  [0xcfee] = 0xea38, [0xcfef] = 0xea39, [0xcff0] = 0xea3a, [0xcff1] = 0xea3b,
  [0xcff2] = 0xea3c, [0xcff3] = 0xea3d, [0xcff4] = 0xea3e, [0xcff5] = 0xea3f,
  [0xcff6] = 0xea40, [0xcff7] = 0xea41, [0xcff8] = 0xea42, [0xcff9] = 0xea43,
  [0xcffa] = 0xea44, [0xcffb] = 0xea45, [0xcffc] = 0xea46, [0xcffd] = 0xea47,
  [0xd041] = 0xea48, [0xd042] = 0xea49, [0xd043] = 0xea4a, [0xd044] = 0xea4b,
  [0xd045] = 0xea4c, [0xd046] = 0xea4d, [0xd047] = 0xea4e, [0xd048] = 0xea4f,
  [0xd049] = 0xea50, [0xd04a] = 0xea51, [0xd04b] = 0xea52, [0xd04c] = 0xea53,
  [0xd04d] = 0xea54, [0xd04e] = 0xea55, [0xd04f] = 0xea56, [0xd050] = 0xea57,
  [0xd051] = 0xea58, [0xd052] = 0xea59, [0xd053] = 0xea5a, [0xd054] = 0xea5b,
  [0xd055] = 0xea5c, [0xd056] = 0xea5d, [0xd057] = 0xea5e, [0xd058] = 0xea5f,
  [0xd059] = 0xea60, [0xd05a] = 0xea61, [0xd05b] = 0xea62, [0xd05c] = 0xea63,
  [0xd05d] = 0xea64, [0xd05e] = 0xea65, [0xd05f] = 0xea66, [0xd060] = 0xea67,
  [0xd061] = 0xea68, [0xd062] = 0xea69, [0xd063] = 0xea6a, [0xd064] = 0xea6b,
  [0xd065] = 0xea6c, [0xd066] = 0xea6d, [0xd067] = 0xea6e, [0xd068] = 0xea6f,
  [0xd069] = 0xea70, [0xd06a] = 0xea71, [0xd06b] = 0xea72, [0xd06c] = 0xea73,
  [0xd06d] = 0xea74, [0xd06e] = 0xea75, [0xd06f] = 0xea76, [0xd070] = 0xea77,
  [0xd071] = 0xea78, [0xd072] = 0xea79, [0xd073] = 0xea7a, [0xd074] = 0xea7b,
  [0xd075] = 0xea7c, [0xd076] = 0xea7d, [0xd077] = 0xea7e, [0xd078] = 0xea7f,
  [0xd079] = 0xea80, [0xd07a] = 0xea81, [0xd07b] = 0xea82, [0xd07c] = 0xea83,
  [0xd07d] = 0xea84, [0xd07e] = 0xea85, [0xd07f] = 0xea86, [0xd081] = 0xea87,
  [0xd082] = 0xea88, [0xd083] = 0xea89, [0xd084] = 0xea8a, [0xd085] = 0xea8b,
  [0xd086] = 0xea8c, [0xd087] = 0xea8d, [0xd088] = 0xea8e, [0xd089] = 0xea8f,
  [0xd08a] = 0xea90, [0xd08b] = 0xea91, [0xd08c] = 0xea92, [0xd08d] = 0xea93,
  [0xd08e] = 0xea94, [0xd08f] = 0xea95, [0xd090] = 0xea96, [0xd091] = 0xea97,
  [0xd092] = 0xea98, [0xd093] = 0xea99, [0xd094] = 0xea9a, [0xd095] = 0xea9b,
  [0xd096] = 0xea9c, [0xd097] = 0xea9d, [0xd098] = 0xea9e, [0xd099] = 0xea9f,
  [0xd09a] = 0xeaa0, [0xd09b] = 0xeaa1, [0xd09c] = 0xeaa2, [0xd09d] = 0xeaa3,
  [0xd09e] = 0xeaa4, [0xd09f] = 0xeaa5, [0xd0a0] = 0xeaa6, [0xd0a1] = 0xeaa7,
  [0xd0a2] = 0xeaa8, [0xd0a3] = 0xeaa9, [0xd0a4] = 0xeaaa, [0xd0a5] = 0xeaab,
  [0xd0a6] = 0xeaac, [0xd0a7] = 0xeaad, [0xd0a8] = 0xeaae, [0xd0a9] = 0xeaaf,
  [0xd0aa] = 0xeab0, [0xd0ab] = 0xeab1, [0xd0ac] = 0xeab2, [0xd0ad] = 0xeab3,
  [0xd0ae] = 0xeab4, [0xd0af] = 0xeab5, [0xd0b0] = 0xeab6, [0xd0b1] = 0xeab7,
  [0xd0b2] = 0xeab8, [0xd0b3] = 0xeab9, [0xd0b4] = 0xeaba, [0xd0b5] = 0xeabb,
  [0xd0b6] = 0xeabc, [0xd0b7] = 0xeabd, [0xd0b8] = 0xeabe, [0xd0b9] = 0xeabf,
  [0xd0ba] = 0xeac0, [0xd0bb] = 0xeac1, [0xd0bc] = 0xeac2, [0xd0bd] = 0xeac3,
  [0xd0be] = 0xeac4, [0xd0bf] = 0xeac5, [0xd0c0] = 0xeac6, [0xd0c1] = 0xeac7,
  [0xd0c2] = 0xeac8, [0xd0c3] = 0xeac9, [0xd0c4] = 0xeaca, [0xd0c5] = 0xeacb,
  [0xd0c6] = 0xeacc, [0xd0c7] = 0xeacd, [0xd0c8] = 0xeace, [0xd0c9] = 0xeacf,
  [0xd0ca] = 0xead0, [0xd0cb] = 0xead1, [0xd0cc] = 0xead2, [0xd0cd] = 0xead3,
  [0xd0ce] = 0xead4, [0xd0cf] = 0xead5, [0xd0d0] = 0xead6, [0xd0d1] = 0xead7,
  [0xd0d2] = 0xead8, [0xd0d3] = 0xead9, [0xd0d4] = 0xeada, [0xd0d5] = 0xeadb,
  [0xd0d6] = 0xeadc, [0xd0d7] = 0xeadd, [0xd0d8] = 0xeade, [0xd0d9] = 0xeadf,
  [0xd0da] = 0xeae0, [0xd0db] = 0xeae1, [0xd0dc] = 0xeae2, [0xd0dd] = 0xeae3,
  [0xd0de] = 0xeae4, [0xd0df] = 0xeae5, [0xd0e0] = 0xeae6, [0xd0e1] = 0xeae7,
  [0xd0e2] = 0xeae8, [0xd0e3] = 0xeae9, [0xd0e4] = 0xeaea, [0xd0e5] = 0xeaeb,
  [0xd0e6] = 0xeaec, [0xd0e7] = 0xeaed, [0xd0e8] = 0xeaee, [0xd0e9] = 0xeaef,
  [0xd0ea] = 0xeaf0, [0xd0eb] = 0xeaf1, [0xd0ec] = 0xeaf2, [0xd0ed] = 0xeaf3,
  [0xd0ee] = 0xeaf4, [0xd0ef] = 0xeaf5, [0xd0f0] = 0xeaf6, [0xd0f1] = 0xeaf7,
  [0xd0f2] = 0xeaf8, [0xd0f3] = 0xeaf9, [0xd0f4] = 0xeafa, [0xd0f5] = 0xeafb,
  [0xd0f6] = 0xeafc, [0xd0f7] = 0xeafd, [0xd0f8] = 0xeafe, [0xd0f9] = 0xeaff,
  [0xd0fa] = 0xeb00, [0xd0fb] = 0xeb01, [0xd0fc] = 0xeb02, [0xd0fd] = 0xeb03,
  [0xd141] = 0xeb04, [0xd142] = 0xeb05, [0xd143] = 0xeb06, [0xd144] = 0xeb07,
  [0xd145] = 0xeb08, [0xd146] = 0xeb09, [0xd147] = 0xeb0a, [0xd148] = 0xeb0b,
  [0xd149] = 0xeb0c, [0xd14a] = 0xeb0d, [0xd14b] = 0xeb0e, [0xd14c] = 0xeb0f,
  [0xd14d] = 0xeb10, [0xd14e] = 0xeb11, [0xd14f] = 0xeb12, [0xd150] = 0xeb13,
  [0xd151] = 0xeb14, [0xd152] = 0xeb15, [0xd153] = 0xeb16, [0xd154] = 0xeb17,
  [0xd155] = 0xeb18, [0xd156] = 0xeb19, [0xd157] = 0xeb1a, [0xd158] = 0xeb1b,
  [0xd159] = 0xeb1c, [0xd15a] = 0xeb1d, [0xd15b] = 0xeb1e, [0xd15c] = 0xeb1f,
  [0xd15d] = 0xeb20, [0xd15e] = 0xeb21, [0xd15f] = 0xeb22, [0xd160] = 0xeb23,
  [0xd161] = 0xeb24, [0xd162] = 0xeb25, [0xd163] = 0xeb26, [0xd164] = 0xeb27,
  [0xd165] = 0xeb28, [0xd166] = 0xeb29, [0xd167] = 0xeb2a, [0xd168] = 0xeb2b,
  [0xd169] = 0xeb2c, [0xd16a] = 0xeb2d, [0xd16b] = 0xeb2e, [0xd16c] = 0xeb2f,
  [0xd16d] = 0xeb30, [0xd16e] = 0xeb31, [0xd16f] = 0xeb32, [0xd170] = 0xeb33,
  [0xd171] = 0xeb34, [0xd172] = 0xeb35, [0xd173] = 0xeb36, [0xd174] = 0xeb37,
  [0xd175] = 0xeb38, [0xd176] = 0xeb39, [0xd177] = 0xeb3a, [0xd178] = 0xeb3b,
  [0xd179] = 0xeb3c, [0xd17a] = 0xeb3d, [0xd17b] = 0xeb3e, [0xd17c] = 0xeb3f,
  [0xd17d] = 0xeb40, [0xd17e] = 0xeb41, [0xd17f] = 0xeb42, [0xd181] = 0xeb43,
  [0xd182] = 0xeb44, [0xd183] = 0xeb45, [0xd184] = 0xeb46, [0xd185] = 0xeb47,
  [0xd186] = 0xeb48, [0xd187] = 0xeb49, [0xd188] = 0xeb4a, [0xd189] = 0xeb4b,
  [0xd18a] = 0xeb4c, [0xd18b] = 0xeb4d, [0xd18c] = 0xeb4e, [0xd18d] = 0xeb4f,
  [0xd18e] = 0xeb50, [0xd18f] = 0xeb51, [0xd190] = 0xeb52, [0xd191] = 0xeb53,
  [0xd192] = 0xeb54, [0xd193] = 0xeb55, [0xd194] = 0xeb56, [0xd195] = 0xeb57,
  [0xd196] = 0xeb58, [0xd197] = 0xeb59, [0xd198] = 0xeb5a, [0xd199] = 0xeb5b,
  [0xd19a] = 0xeb5c, [0xd19b] = 0xeb5d, [0xd19c] = 0xeb5e, [0xd19d] = 0xeb5f,
  [0xd19e] = 0xeb60, [0xd19f] = 0xeb61, [0xd1a0] = 0xeb62, [0xd1a1] = 0xeb63,
  [0xd1a2] = 0xeb64, [0xd1a3] = 0xeb65, [0xd1a4] = 0xeb66, [0xd1a5] = 0xeb67,
  [0xd1a6] = 0xeb68, [0xd1a7] = 0xeb69, [0xd1a8] = 0xeb6a, [0xd1a9] = 0xeb6b,
  [0xd1aa] = 0xeb6c, [0xd1ab] = 0xeb6d, [0xd1ac] = 0xeb6e, [0xd1ad] = 0xeb6f,
  [0xd1ae] = 0xeb70, [0xd1af] = 0xeb71, [0xd1b0] = 0xeb72, [0xd1b1] = 0xeb73,
  [0xd1b2] = 0xeb74, [0xd1b3] = 0xeb75, [0xd1b4] = 0xeb76, [0xd1b5] = 0xeb77,
  [0xd1b6] = 0xeb78, [0xd1b7] = 0xeb79, [0xd1b8] = 0xeb7a, [0xd1b9] = 0xeb7b,
  [0xd1ba] = 0xeb7c, [0xd1bb] = 0xeb7d, [0xd1bc] = 0xeb7e, [0xd1bd] = 0xeb7f,
  [0xd1be] = 0xeb80, [0xd1bf] = 0xeb81, [0xd1c0] = 0xeb82, [0xd1c1] = 0xeb83,
  [0xd1c2] = 0xeb84, [0xd1c3] = 0xeb85, [0xd1c4] = 0xeb86, [0xd1c5] = 0xeb87,
  [0xd1c6] = 0xeb88, [0xd1c7] = 0xeb89, [0xd1c8] = 0xeb8a, [0xd1c9] = 0xeb8b,
  [0xd1ca] = 0xeb8c, [0xd1cb] = 0xeb8d, [0xd1cc] = 0xeb8e, [0xd1cd] = 0xeb8f,
  [0xd1ce] = 0xeb90, [0xd1cf] = 0xeb91, [0xd1d0] = 0xeb92, [0xd1d1] = 0xeb93,
  [0xd1d2] = 0xeb94, [0xd1d3] = 0xeb95, [0xd1d4] = 0xeb96, [0xd1d5] = 0xeb97,
  [0xd1d6] = 0xeb98, [0xd1d7] = 0xeb99, [0xd1d8] = 0xeb9a, [0xd1d9] = 0xeb9b,
  [0xd1da] = 0xeb9c, [0xd1db] = 0xeb9d, [0xd1dc] = 0xeb9e, [0xd1dd] = 0xeb9f,
  [0xd1de] = 0xeba0, [0xd1df] = 0xeba1, [0xd1e0] = 0xeba2, [0xd1e1] = 0xeba3,
  [0xd1e2] = 0xeba4, [0xd1e3] = 0xeba5, [0xd1e4] = 0xeba6, [0xd1e5] = 0xeba7,
  [0xd1e6] = 0xeba8, [0xd1e7] = 0xeba9, [0xd1e8] = 0xebaa, [0xd1e9] = 0xebab,
  [0xd1ea] = 0xebac, [0xd1eb] = 0xebad, [0xd1ec] = 0xebae, [0xd1ed] = 0xebaf,
  [0xd1ee] = 0xebb0, [0xd1ef] = 0xebb1, [0xd1f0] = 0xebb2, [0xd1f1] = 0xebb3,
  [0xd1f2] = 0xebb4, [0xd1f3] = 0xebb5, [0xd1f4] = 0xebb6, [0xd1f5] = 0xebb7,
  [0xd1f6] = 0xebb8, [0xd1f7] = 0xebb9, [0xd1f8] = 0xebba, [0xd1f9] = 0xebbb,
  [0xd1fa] = 0xebbc, [0xd1fb] = 0xebbd, [0xd1fc] = 0xebbe, [0xd1fd] = 0xebbf,
  [0xd241] = 0xebc0, [0xd242] = 0xebc1, [0xd243] = 0xebc2, [0xd244] = 0xebc3,
  [0xd245] = 0xebc4, [0xd246] = 0xebc5, [0xd247] = 0xebc6, [0xd248] = 0xebc7,
  [0xd249] = 0xebc8, [0xd24a] = 0xebc9, [0xd24b] = 0xebca, [0xd24c] = 0xebcb,
  [0xd24d] = 0xebcc, [0xd24e] = 0xebcd, [0xd24f] = 0xebce, [0xd250] = 0xebcf,
  [0xd251] = 0xebd0, [0xd252] = 0xebd1, [0xd253] = 0xebd2, [0xd254] = 0xebd3,
  [0xd255] = 0xebd4, [0xd256] = 0xebd5, [0xd257] = 0xebd6, [0xd258] = 0xebd7,
  [0xd259] = 0xebd8, [0xd25a] = 0xebd9, [0xd25b] = 0xebda, [0xd25c] = 0xebdb,
  [0xd25d] = 0xebdc, [0xd25e] = 0xebdd, [0xd25f] = 0xebde, [0xd260] = 0xebdf,
  [0xd261] = 0xebe0, [0xd262] = 0xebe1, [0xd263] = 0xebe2, [0xd264] = 0xebe3,
  [0xd265] = 0xebe4, [0xd266] = 0xebe5, [0xd267] = 0xebe6, [0xd268] = 0xebe7,
  [0xd269] = 0xebe8, [0xd26a] = 0xebe9, [0xd26b] = 0xebea, [0xd26c] = 0xebeb,
  [0xd26d] = 0xebec, [0xd26e] = 0xebed, [0xd26f] = 0xebee, [0xd270] = 0xebef,
  [0xd271] = 0xebf0, [0xd272] = 0xebf1, [0xd273] = 0xebf2, [0xd274] = 0xebf3,
  [0xd275] = 0xebf4, [0xd276] = 0xebf5, [0xd277] = 0xebf6, [0xd278] = 0xebf7,
  [0xd279] = 0xebf8, [0xd27a] = 0xebf9, [0xd27b] = 0xebfa, [0xd27c] = 0xebfb,
  [0xd27d] = 0xebfc, [0xd27e] = 0xebfd, [0xd27f] = 0xebfe, [0xd281] = 0xebff,
  [0xd282] = 0xec00, [0xd283] = 0xec01, [0xd284] = 0xec02, [0xd285] = 0xec03,
  [0xd286] = 0xec04, [0xd287] = 0xec05, [0xd288] = 0xec06, [0xd289] = 0xec07,
  [0xd28a] = 0xec08, [0xd28b] = 0xec09, [0xd28c] = 0xec0a, [0xd28d] = 0xec0b,
  [0xd28e] = 0xec0c, [0xd28f] = 0xec0d, [0xd290] = 0xec0e, [0xd291] = 0xec0f,
  [0xd292] = 0xec10, [0xd293] = 0xec11, [0xd294] = 0xec12, [0xd295] = 0xec13,
  [0xd296] = 0xec14, [0xd297] = 0xec15, [0xd298] = 0xec16, [0xd299] = 0xec17,
  [0xd29a] = 0xec18, [0xd29b] = 0xec19, [0xd29c] = 0xec1a, [0xd29d] = 0xec1b,
  [0xd29e] = 0xec1c, [0xd29f] = 0xec1d, [0xd2a0] = 0xec1e, [0xd2a1] = 0xec1f,
  [0xd2a2] = 0xec20, [0xd2a3] = 0xec21, [0xd2a4] = 0xec22, [0xd2a5] = 0xec23,
  [0xd2a6] = 0xec24, [0xd2a7] = 0xec25, [0xd2a8] = 0xec26, [0xd2a9] = 0xec27,
  [0xd2aa] = 0xec28, [0xd2ab] = 0xec29, [0xd2ac] = 0xec2a, [0xd2ad] = 0xec2b,
  [0xd2ae] = 0xec2c, [0xd2af] = 0xec2d, [0xd2b0] = 0xec2e, [0xd2b1] = 0xec2f,
  [0xd2b2] = 0xec30, [0xd2b3] = 0xec31, [0xd2b4] = 0xec32, [0xd2b5] = 0xec33,
  [0xd2b6] = 0xec34, [0xd2b7] = 0xec35, [0xd2b8] = 0xec36, [0xd2b9] = 0xec37,
  [0xd2ba] = 0xec38, [0xd2bb] = 0xec39, [0xd2bc] = 0xec3a, [0xd2bd] = 0xec3b,
  [0xd2be] = 0xec3c, [0xd2bf] = 0xec3d, [0xd2c0] = 0xec3e, [0xd2c1] = 0xec3f,
  [0xd2c2] = 0xec40, [0xd2c3] = 0xec41, [0xd2c4] = 0xec42, [0xd2c5] = 0xec43,
  [0xd2c6] = 0xec44, [0xd2c7] = 0xec45, [0xd2c8] = 0xec46, [0xd2c9] = 0xec47,
  [0xd2ca] = 0xec48, [0xd2cb] = 0xec49, [0xd2cc] = 0xec4a, [0xd2cd] = 0xec4b,
  [0xd2ce] = 0xec4c, [0xd2cf] = 0xec4d, [0xd2d0] = 0xec4e, [0xd2d1] = 0xec4f,
  [0xd2d2] = 0xec50, [0xd2d3] = 0xec51, [0xd2d4] = 0xec52, [0xd2d5] = 0xec53,
  [0xd2d6] = 0xec54, [0xd2d7] = 0xec55, [0xd2d8] = 0xec56, [0xd2d9] = 0xec57,
  [0xd2da] = 0xec58, [0xd2db] = 0xec59, [0xd2dc] = 0xec5a, [0xd2dd] = 0xec5b,
  [0xd2de] = 0xec5c, [0xd2df] = 0xec5d, [0xd2e0] = 0xec5e, [0xd2e1] = 0xec5f,
  [0xd2e2] = 0xec60, [0xd2e3] = 0xec61, [0xd2e4] = 0xec62, [0xd2e5] = 0xec63,
  [0xd2e6] = 0xec64, [0xd2e7] = 0xec65, [0xd2e8] = 0xec66, [0xd2e9] = 0xec67,
  [0xd2ea] = 0xec68, [0xd2eb] = 0xec69, [0xd2ec] = 0xec6a, [0xd2ed] = 0xec6b,
  [0xd2ee] = 0xec6c, [0xd2ef] = 0xec6d, [0xd2f0] = 0xec6e, [0xd2f1] = 0xec6f,
  [0xd2f2] = 0xec70, [0xd2f3] = 0xec71, [0xd2f4] = 0xec72, [0xd2f5] = 0xec73,
  [0xd2f6] = 0xec74, [0xd2f7] = 0xec75, [0xd2f8] = 0xec76, [0xd2f9] = 0xec77,
  [0xd2fa] = 0xec78, [0xd2fb] = 0xec79, [0xd2fc] = 0xec7a, [0xd2fd] = 0xec7b,
  [0xd341] = 0xec7c, [0xd342] = 0xec7d, [0xd343] = 0xec7e, [0xd344] = 0xec7f,
  [0xd345] = 0xec80, [0xd346] = 0xec81, [0xd347] = 0xec82, [0xd348] = 0xec83,
  [0xd349] = 0xec84, [0xd34a] = 0xec85, [0xd34b] = 0xec86, [0xd34c] = 0xec87,
  [0xd34d] = 0xec88, [0xd34e] = 0xec89, [0xd34f] = 0xec8a, [0xd350] = 0xec8b,
  [0xd351] = 0xec8c, [0xd352] = 0xec8d, [0xd353] = 0xec8e, [0xd354] = 0xec8f,
  [0xd355] = 0xec90, [0xd356] = 0xec91, [0xd357] = 0xec92, [0xd358] = 0xec93,
  [0xd359] = 0xec94, [0xd35a] = 0xec95, [0xd35b] = 0xec96, [0xd35c] = 0xec97,
  [0xd35d] = 0xec98, [0xd35e] = 0xec99, [0xd35f] = 0xec9a, [0xd360] = 0xec9b,
  [0xd361] = 0xec9c, [0xd362] = 0xec9d, [0xd363] = 0xec9e, [0xd364] = 0xec9f,
  [0xd365] = 0xeca0, [0xd366] = 0xeca1, [0xd367] = 0xeca2, [0xd368] = 0xeca3,
  [0xd369] = 0xeca4, [0xd36a] = 0xeca5, [0xd36b] = 0xeca6, [0xd36c] = 0xeca7,
  [0xd36d] = 0xeca8, [0xd36e] = 0xeca9, [0xd36f] = 0xecaa, [0xd370] = 0xecab,
  [0xd371] = 0xecac, [0xd372] = 0xecad, [0xd373] = 0xecae, [0xd374] = 0xecaf,
  [0xd375] = 0xecb0, [0xd376] = 0xecb1, [0xd377] = 0xecb2, [0xd378] = 0xecb3,
  [0xd379] = 0xecb4, [0xd37a] = 0xecb5, [0xd37b] = 0xecb6, [0xd37c] = 0xecb7,
  [0xd37d] = 0xecb8, [0xd37e] = 0xecb9, [0xd37f] = 0xecba, [0xd381] = 0xecbb,
  [0xd382] = 0xecbc, [0xd383] = 0xecbd, [0xd384] = 0xecbe, [0xd385] = 0xecbf,
  [0xd386] = 0xecc0, [0xd387] = 0xecc1, [0xd388] = 0xecc2, [0xd389] = 0xecc3,
  [0xd38a] = 0xecc4, [0xd38b] = 0xecc5, [0xd38c] = 0xecc6, [0xd38d] = 0xecc7,
  [0xd38e] = 0xecc8, [0xd38f] = 0xecc9, [0xd390] = 0xecca, [0xd391] = 0xeccb,
  [0xd392] = 0xeccc, [0xd393] = 0xeccd, [0xd394] = 0xecce, [0xd395] = 0xeccf,
  [0xd396] = 0xecd0, [0xd397] = 0xecd1, [0xd398] = 0xecd2, [0xd399] = 0xecd3,
  [0xd39a] = 0xecd4, [0xd39b] = 0xecd5, [0xd39c] = 0xecd6, [0xd39d] = 0xecd7,
  [0xd39e] = 0xecd8, [0xd39f] = 0xecd9, [0xd3a0] = 0xecda, [0xd3a1] = 0xecdb,
  [0xd3a2] = 0xecdc, [0xd3a3] = 0xecdd, [0xd3a4] = 0xecde, [0xd3a5] = 0xecdf,
  [0xd3a6] = 0xece0, [0xd3a7] = 0xece1, [0xd3a8] = 0xece2, [0xd3a9] = 0xece3,
  [0xd3aa] = 0xece4, [0xd3ab] = 0xece5, [0xd3ac] = 0xece6, [0xd3ad] = 0xece7,
  [0xd3ae] = 0xece8, [0xd3af] = 0xece9, [0xd3b0] = 0xecea, [0xd3b1] = 0xeceb,
  [0xd3b2] = 0xecec, [0xd3b3] = 0xeced, [0xd3b4] = 0xecee, [0xd3b5] = 0xecef,
  [0xd3b6] = 0xecf0, [0xd3b7] = 0xecf1, [0xd3b8] = 0xecf2, [0xd3b9] = 0xecf3,
  [0xd3ba] = 0xecf4, [0xd3bb] = 0xecf5, [0xd3bc] = 0xecf6, [0xd3bd] = 0xecf7,
  [0xd3be] = 0xecf8, [0xd3bf] = 0xecf9, [0xd3c0] = 0xecfa, [0xd3c1] = 0xecfb,
  [0xd3c2] = 0xecfc, [0xd3c3] = 0xecfd, [0xd3c4] = 0xecfe, [0xd3c5] = 0xecff,
  [0xd3c6] = 0xed00, [0xd3c7] = 0xed01, [0xd3c8] = 0xed02, [0xd3c9] = 0xed03,
  [0xd3ca] = 0xed04, [0xd3cb] = 0xed05, [0xd3cc] = 0xed06, [0xd3cd] = 0xed07,
  [0xd3ce] = 0xed08, [0xd3cf] = 0xed09, [0xd3d0] = 0xed0a, [0xd3d1] = 0xed0b,
  [0xd3d2] = 0xed0c, [0xd3d3] = 0xed0d, [0xd3d4] = 0xed0e, [0xd3d5] = 0xed0f,
  [0xd3d6] = 0xed10, [0xd3d7] = 0xed11, [0xd3d8] = 0xed12, [0xd3d9] = 0xed13,
  [0xd3da] = 0xed14, [0xd3db] = 0xed15, [0xd3dc] = 0xed16, [0xd3dd] = 0xed17,
  [0xd3de] = 0xed18, [0xd3df] = 0xed19, [0xd3e0] = 0xed1a, [0xd3e1] = 0xed1b,
  [0xd3e2] = 0xed1c, [0xd3e3] = 0xed1d, [0xd3e4] = 0xed1e, [0xd3e5] = 0xed1f,
  [0xd3e6] = 0xed20, [0xd3e7] = 0xed21, [0xd3e8] = 0xed22, [0xd3e9] = 0xed23,
  [0xd3ea] = 0xed24, [0xd3eb] = 0xed25, [0xd3ec] = 0xed26, [0xd3ed] = 0xed27,
  [0xd3ee] = 0xed28, [0xd3ef] = 0xed29, [0xd3f0] = 0xed2a, [0xd3f1] = 0xed2b,
  [0xd3f2] = 0xed2c, [0xd3f3] = 0xed2d, [0xd3f4] = 0xed2e, [0xd3f5] = 0xed2f,
  [0xd3f6] = 0xed30, [0xd3f7] = 0xed31, [0xd3f8] = 0xed32, [0xd3f9] = 0xed33,
  [0xd3fa] = 0xed34, [0xd3fb] = 0xed35, [0xd3fc] = 0xed36, [0xd3fd] = 0xed37,
  [0xd441] = 0xed38, [0xd442] = 0xed39, [0xd443] = 0xed3a, [0xd444] = 0xed3b,
  [0xd445] = 0xed3c, [0xd446] = 0xed3d, [0xd447] = 0xed3e, [0xd448] = 0xed3f,
  [0xd449] = 0xed40, [0xd44a] = 0xed41, [0xd44b] = 0xed42, [0xd44c] = 0xed43,
  [0xd44d] = 0xed44, [0xd44e] = 0xed45, [0xd44f] = 0xed46, [0xd450] = 0xed47,
  [0xd451] = 0xed48, [0xd452] = 0xed49, [0xd453] = 0xed4a, [0xd454] = 0xed4b,
  [0xd455] = 0xed4c, [0xd456] = 0xed4d, [0xd457] = 0xed4e, [0xd458] = 0xed4f,
  [0xd459] = 0xed50, [0xd45a] = 0xed51, [0xd45b] = 0xed52, [0xd45c] = 0xed53,
  [0xd45d] = 0xed54, [0xd45e] = 0xed55, [0xd45f] = 0xed56, [0xd460] = 0xed57,
  [0xd461] = 0xed58, [0xd462] = 0xed59, [0xd463] = 0xed5a, [0xd464] = 0xed5b,
  [0xd465] = 0xed5c, [0xd466] = 0xed5d, [0xd467] = 0xed5e, [0xd468] = 0xed5f,
  [0xd469] = 0xed60, [0xd46a] = 0xed61, [0xd46b] = 0xed62, [0xd46c] = 0xed63,
  [0xd46d] = 0xed64, [0xd46e] = 0xed65, [0xd46f] = 0xed66, [0xd470] = 0xed67,
  [0xd471] = 0xed68, [0xd472] = 0xed69, [0xd473] = 0xed6a, [0xd474] = 0xed6b,
  [0xd475] = 0xed6c, [0xd476] = 0xed6d, [0xd477] = 0xed6e, [0xd478] = 0xed6f,
  [0xd479] = 0xed70, [0xd47a] = 0xed71, [0xd47b] = 0xed72, [0xd47c] = 0xed73,
  [0xd47d] = 0xed74, [0xd47e] = 0xed75, [0xd47f] = 0xed76, [0xd481] = 0xed77,
  [0xd482] = 0xed78, [0xd483] = 0xed79, [0xd484] = 0xed7a, [0xd485] = 0xed7b,
  [0xd486] = 0xed7c, [0xd487] = 0xed7d, [0xd488] = 0xed7e, [0xd489] = 0xed7f,
  [0xd48a] = 0xed80, [0xd48b] = 0xed81, [0xd48c] = 0xed82, [0xd48d] = 0xed83,
  [0xd48e] = 0xed84, [0xd48f] = 0xed85, [0xd490] = 0xed86, [0xd491] = 0xed87,
  [0xd492] = 0xed88, [0xd493] = 0xed89, [0xd494] = 0xed8a, [0xd495] = 0xed8b,
  [0xd496] = 0xed8c, [0xd497] = 0xed8d, [0xd498] = 0xed8e, [0xd499] = 0xed8f,
  [0xd49a] = 0xed90, [0xd49b] = 0xed91, [0xd49c] = 0xed92, [0xd49d] = 0xed93,
  [0xd49e] = 0xed94, [0xd49f] = 0xed95, [0xd4a0] = 0xed96, [0xd4a1] = 0xed97,
  [0xd4a2] = 0xed98, [0xd4a3] = 0xed99, [0xd4a4] = 0xed9a, [0xd4a5] = 0xed9b,
  [0xd4a6] = 0xed9c, [0xd4a7] = 0xed9d, [0xd4a8] = 0xed9e, [0xd4a9] = 0xed9f,
  [0xd4aa] = 0xeda0, [0xd4ab] = 0xeda1, [0xd4ac] = 0xeda2, [0xd4ad] = 0xeda3,
  [0xd4ae] = 0xeda4, [0xd4af] = 0xeda5, [0xd4b0] = 0xeda6, [0xd4b1] = 0xeda7,
  [0xd4b2] = 0xeda8, [0xd4b3] = 0xeda9, [0xd4b4] = 0xedaa, [0xd4b5] = 0xedab,
  [0xd4b6] = 0xedac, [0xd4b7] = 0xedad, [0xd4b8] = 0xedae, [0xd4b9] = 0xedaf,
  [0xd4ba] = 0xedb0, [0xd4bb] = 0xedb1, [0xd4bc] = 0xedb2, [0xd4bd] = 0xedb3,
  [0xd4be] = 0xedb4, [0xd4bf] = 0xedb5, [0xd4c0] = 0xedb6, [0xd4c1] = 0xedb7,
  [0xd4c2] = 0xedb8, [0xd4c3] = 0xedb9, [0xd4c4] = 0xedba, [0xd4c5] = 0xedbb,
  [0xd4c6] = 0xedbc, [0xd4c7] = 0xedbd, [0xd4c8] = 0xedbe, [0xd4c9] = 0xedbf,
  [0xd4ca] = 0xedc0, [0xd4cb] = 0xedc1, [0xd4cc] = 0xedc2, [0xd4cd] = 0xedc3,
  [0xd4ce] = 0xedc4, [0xd4cf] = 0xedc5, [0xd4d0] = 0xedc6, [0xd4d1] = 0xedc7,
  [0xd4d2] = 0xedc8, [0xd4d3] = 0xedc9, [0xd4d4] = 0xedca, [0xd4d5] = 0xedcb,
  [0xd4d6] = 0xedcc, [0xd4d7] = 0xedcd, [0xd4d8] = 0xedce, [0xd4d9] = 0xedcf,
  [0xd4da] = 0xedd0, [0xd4db] = 0xedd1, [0xd4dc] = 0xedd2, [0xd4dd] = 0xedd3,
  [0xd4de] = 0xedd4, [0xd4df] = 0xedd5, [0xd4e0] = 0xedd6, [0xd4e1] = 0xedd7,
  [0xd4e2] = 0xedd8, [0xd4e3] = 0xedd9, [0xd4e4] = 0xedda, [0xd4e5] = 0xeddb,
  [0xd4e6] = 0xeddc, [0xd4e7] = 0xeddd, [0xd4e8] = 0xedde, [0xd4e9] = 0xeddf,
  [0xd4ea] = 0xede0, [0xd4eb] = 0xede1, [0xd4ec] = 0xede2, [0xd4ed] = 0xede3,
  [0xd4ee] = 0xede4, [0xd4ef] = 0xede5, [0xd4f0] = 0xede6, [0xd4f1] = 0xede7,
  [0xd4f2] = 0xede8, [0xd4f3] = 0xede9, [0xd4f4] = 0xedea, [0xd4f5] = 0xedeb,
  [0xd4f6] = 0xedec, [0xd4f7] = 0xeded, [0xd4f8] = 0xedee, [0xd4f9] = 0xedef,
  [0xd4fa] = 0xedf0, [0xd4fb] = 0xedf1, [0xd4fc] = 0xedf2, [0xd4fd] = 0xedf3,
  [0xd541] = 0xedf4, [0xd542] = 0xedf5, [0xd543] = 0xedf6, [0xd544] = 0xedf7,
  [0xd545] = 0xedf8, [0xd546] = 0xedf9, [0xd547] = 0xedfa, [0xd548] = 0xedfb,
  [0xd549] = 0xedfc, [0xd54a] = 0xedfd, [0xd54b] = 0xedfe, [0xd54c] = 0xedff,
  [0xd54d] = 0xee00, [0xd54e] = 0xee01, [0xd54f] = 0xee02, [0xd550] = 0xee03,
  [0xd551] = 0xee04, [0xd552] = 0xee05, [0xd553] = 0xee06, [0xd554] = 0xee07,
  [0xd555] = 0xee08, [0xd556] = 0xee09, [0xd557] = 0xee0a, [0xd558] = 0xee0b,
  [0xd559] = 0xee0c, [0xd55a] = 0xee0d, [0xd55b] = 0xee0e, [0xd55c] = 0xee0f,
  [0xd55d] = 0xee10, [0xd55e] = 0xee11, [0xd55f] = 0xee12, [0xd560] = 0xee13,
  [0xd561] = 0xee14, [0xd562] = 0xee15, [0xd563] = 0xee16, [0xd564] = 0xee17,
  [0xd565] = 0xee18, [0xd566] = 0xee19, [0xd567] = 0xee1a, [0xd568] = 0xee1b,
  [0xd569] = 0xee1c, [0xd56a] = 0xee1d, [0xd56b] = 0xee1e, [0xd56c] = 0xee1f,
  [0xd56d] = 0xee20, [0xd56e] = 0xee21, [0xd56f] = 0xee22, [0xd570] = 0xee23,
  [0xd571] = 0xee24, [0xd572] = 0xee25, [0xd573] = 0xee26, [0xd574] = 0xee27,
  [0xd575] = 0xee28, [0xd576] = 0xee29, [0xd577] = 0xee2a, [0xd578] = 0xee2b,
  [0xd579] = 0xee2c, [0xd57a] = 0xee2d, [0xd57b] = 0xee2e, [0xd57c] = 0xee2f,
  [0xd57d] = 0xee30, [0xd57e] = 0xee31, [0xd57f] = 0xee32, [0xd581] = 0xee33,
  [0xd582] = 0xee34, [0xd583] = 0xee35, [0xd584] = 0xee36, [0xd585] = 0xee37,
  [0xd586] = 0xee38, [0xd587] = 0xee39, [0xd588] = 0xee3a, [0xd589] = 0xee3b,
  [0xd58a] = 0xee3c, [0xd58b] = 0xee3d, [0xd58c] = 0xee3e, [0xd58d] = 0xee3f,
  [0xd58e] = 0xee40, [0xd58f] = 0xee41, [0xd590] = 0xee42, [0xd591] = 0xee43,
  [0xd592] = 0xee44, [0xd593] = 0xee45, [0xd594] = 0xee46, [0xd595] = 0xee47,
  [0xd596] = 0xee48, [0xd597] = 0xee49, [0xd598] = 0xee4a, [0xd599] = 0xee4b,
  [0xd59a] = 0xee4c, [0xd59b] = 0xee4d, [0xd59c] = 0xee4e, [0xd59d] = 0xee4f,
  [0xd59e] = 0xee50, [0xd59f] = 0xee51, [0xd5a0] = 0xee52, [0xd5a1] = 0xee53,
  [0xd5a2] = 0xee54, [0xd5a3] = 0xee55, [0xd5a4] = 0xee56, [0xd5a5] = 0xee57,
  [0xd5a6] = 0xee58, [0xd5a7] = 0xee59, [0xd5a8] = 0xee5a, [0xd5a9] = 0xee5b,
  [0xd5aa] = 0xee5c, [0xd5ab] = 0xee5d, [0xd5ac] = 0xee5e, [0xd5ad] = 0xee5f,
  [0xd5ae] = 0xee60, [0xd5af] = 0xee61, [0xd5b0] = 0xee62, [0xd5b1] = 0xee63,
  [0xd5b2] = 0xee64, [0xd5b3] = 0xee65, [0xd5b4] = 0xee66, [0xd5b5] = 0xee67,
  [0xd5b6] = 0xee68, [0xd5b7] = 0xee69, [0xd5b8] = 0xee6a, [0xd5b9] = 0xee6b,
  [0xd5ba] = 0xee6c, [0xd5bb] = 0xee6d, [0xd5bc] = 0xee6e, [0xd5bd] = 0xee6f,
  [0xd5be] = 0xee70, [0xd5bf] = 0xee71, [0xd5c0] = 0xee72, [0xd5c1] = 0xee73,
  [0xd5c2] = 0xee74, [0xd5c3] = 0xee75, [0xd5c4] = 0xee76, [0xd5c5] = 0xee77,
  [0xd5c6] = 0xee78, [0xd5c7] = 0xee79, [0xd5c8] = 0xee7a, [0xd5c9] = 0xee7b,
  [0xd5ca] = 0xee7c, [0xd5cb] = 0xee7d, [0xd5cc] = 0xee7e, [0xd5cd] = 0xee7f,
  [0xd5ce] = 0xee80, [0xd5cf] = 0xee81, [0xd5d0] = 0xee82, [0xd5d1] = 0xee83,
  [0xd5d2] = 0xee84, [0xd5d3] = 0xee85, [0xd5d4] = 0xee86, [0xd5d5] = 0xee87,
  [0xd5d6] = 0xee88, [0xd5d7] = 0xee89, [0xd5d8] = 0xee8a, [0xd5d9] = 0xee8b,
  [0xd5da] = 0xee8c, [0xd5db] = 0xee8d, [0xd5dc] = 0xee8e, [0xd5dd] = 0xee8f,
  [0xd5de] = 0xee90, [0xd5df] = 0xee91, [0xd5e0] = 0xee92, [0xd5e1] = 0xee93,
  [0xd5e2] = 0xee94, [0xd5e3] = 0xee95, [0xd5e4] = 0xee96, [0xd5e5] = 0xee97,
  [0xd5e6] = 0xee98, [0xd5e7] = 0xee99, [0xd5e8] = 0xee9a, [0xd5e9] = 0xee9b,
  [0xd5ea] = 0xee9c, [0xd5eb] = 0xee9d, [0xd5ec] = 0xee9e, [0xd5ed] = 0xee9f,
  [0xd5ee] = 0xeea0, [0xd5ef] = 0xeea1, [0xd5f0] = 0xeea2, [0xd5f1] = 0xeea3,
  [0xd5f2] = 0xeea4, [0xd5f3] = 0xeea5, [0xd5f4] = 0xeea6, [0xd5f5] = 0xeea7,
  [0xd5f6] = 0xeea8, [0xd5f7] = 0xeea9, [0xd5f8] = 0xeeaa, [0xd5f9] = 0xeeab,
  [0xd5fa] = 0xeeac, [0xd5fb] = 0xeead, [0xd5fc] = 0xeeae, [0xd5fd] = 0xeeaf,
  [0xd641] = 0xeeb0, [0xd642] = 0xeeb1, [0xd643] = 0xeeb2, [0xd644] = 0xeeb3,
  [0xd645] = 0xeeb4, [0xd646] = 0xeeb5, [0xd647] = 0xeeb6, [0xd648] = 0xeeb7,
  [0xd649] = 0xeeb8, [0xd64a] = 0xeeb9, [0xd64b] = 0xeeba, [0xd64c] = 0xeebb,
  [0xd64d] = 0xeebc, [0xd64e] = 0xeebd, [0xd64f] = 0xeebe, [0xd650] = 0xeebf,
  [0xd651] = 0xeec0, [0xd652] = 0xeec1, [0xd653] = 0xeec2, [0xd654] = 0xeec3,
  [0xd655] = 0xeec4, [0xd656] = 0xeec5, [0xd657] = 0xeec6, [0xd658] = 0xeec7,
  [0xd659] = 0xeec8, [0xd65a] = 0xeec9, [0xd65b] = 0xeeca, [0xd65c] = 0xeecb,
  [0xd65d] = 0xeecc, [0xd65e] = 0xeecd, [0xd65f] = 0xeece, [0xd660] = 0xeecf,
  [0xd661] = 0xeed0, [0xd662] = 0xeed1, [0xd663] = 0xeed2, [0xd664] = 0xeed3,
  [0xd665] = 0xeed4, [0xd666] = 0xeed5, [0xd667] = 0xeed6, [0xd668] = 0xeed7,
  [0xd669] = 0xeed8, [0xd66a] = 0xeed9, [0xd66b] = 0xeeda, [0xd66c] = 0xeedb,
  [0xd66d] = 0xeedc, [0xd66e] = 0xeedd, [0xd66f] = 0xeede, [0xd670] = 0xeedf,
  [0xd671] = 0xeee0, [0xd672] = 0xeee1, [0xd673] = 0xeee2, [0xd674] = 0xeee3,
  [0xd675] = 0xeee4, [0xd676] = 0xeee5, [0xd677] = 0xeee6, [0xd678] = 0xeee7,
  [0xd679] = 0xeee8, [0xd67a] = 0xeee9, [0xd67b] = 0xeeea, [0xd67c] = 0xeeeb,
  [0xd67d] = 0xeeec, [0xd67e] = 0xeeed, [0xd67f] = 0xeeee, [0xd681] = 0xeeef,
  [0xd682] = 0xeef0, [0xd683] = 0xeef1, [0xd684] = 0xeef2, [0xd685] = 0xeef3,
  [0xd686] = 0xeef4, [0xd687] = 0xeef5, [0xd688] = 0xeef6, [0xd689] = 0xeef7,
  [0xd68a] = 0xeef8, [0xd68b] = 0xeef9, [0xd68c] = 0xeefa, [0xd68d] = 0xeefb,
  [0xd68e] = 0xeefc, [0xd68f] = 0xeefd, [0xd690] = 0xeefe, [0xd691] = 0xeeff,
  [0xd692] = 0xef00, [0xd693] = 0xef01, [0xd694] = 0xef02, [0xd695] = 0xef03,
  [0xd696] = 0xef04, [0xd697] = 0xef05, [0xd698] = 0xef06, [0xd699] = 0xef07,
  [0xd69a] = 0xef08, [0xd69b] = 0xef09, [0xd69c] = 0xef0a, [0xd69d] = 0xef0b,
  [0xd69e] = 0xef0c, [0xd69f] = 0xef0d, [0xd6a0] = 0xef0e, [0xd6a1] = 0xef0f,
  [0xd6a2] = 0xef10, [0xd6a3] = 0xef11, [0xd6a4] = 0xef12, [0xd6a5] = 0xef13,
  [0xd6a6] = 0xef14, [0xd6a7] = 0xef15, [0xd6a8] = 0xef16, [0xd6a9] = 0xef17,
  [0xd6aa] = 0xef18, [0xd6ab] = 0xef19, [0xd6ac] = 0xef1a, [0xd6ad] = 0xef1b,
  [0xd6ae] = 0xef1c, [0xd6af] = 0xef1d, [0xd6b0] = 0xef1e, [0xd6b1] = 0xef1f,
  [0xd6b2] = 0xef20, [0xd6b3] = 0xef21, [0xd6b4] = 0xef22, [0xd6b5] = 0xef23,
  [0xd6b6] = 0xef24, [0xd6b7] = 0xef25, [0xd6b8] = 0xef26, [0xd6b9] = 0xef27,
  [0xd6ba] = 0xef28, [0xd6bb] = 0xef29, [0xd6bc] = 0xef2a, [0xd6bd] = 0xef2b,
  [0xd6be] = 0xef2c, [0xd6bf] = 0xef2d, [0xd6c0] = 0xef2e, [0xd6c1] = 0xef2f,
  [0xd6c2] = 0xef30, [0xd6c3] = 0xef31, [0xd6c4] = 0xef32, [0xd6c5] = 0xef33,
  [0xd6c6] = 0xef34, [0xd6c7] = 0xef35, [0xd6c8] = 0xef36, [0xd6c9] = 0xef37,
  [0xd6ca] = 0xef38, [0xd6cb] = 0xef39, [0xd6cc] = 0xef3a, [0xd6cd] = 0xef3b,
  [0xd6ce] = 0xef3c, [0xd6cf] = 0xef3d, [0xd6d0] = 0xef3e, [0xd6d1] = 0xef3f,
  [0xd6d2] = 0xef40, [0xd6d3] = 0xef41, [0xd6d4] = 0xef42, [0xd6d5] = 0xef43,
  [0xd6d6] = 0xef44, [0xd6d7] = 0xef45, [0xd6d8] = 0xef46, [0xd6d9] = 0xef47,
  [0xd6da] = 0xef48, [0xd6db] = 0xef49, [0xd6dc] = 0xef4a, [0xd6dd] = 0xef4b,
  [0xd6de] = 0xef4c, [0xd6df] = 0xef4d, [0xd6e0] = 0xef4e, [0xd6e1] = 0xef4f,
  [0xd6e2] = 0xef50, [0xd6e3] = 0xef51, [0xd6e4] = 0xef52, [0xd6e5] = 0xef53,
  [0xd6e6] = 0xef54, [0xd6e7] = 0xef55, [0xd6e8] = 0xef56, [0xd6e9] = 0xef57,
  [0xd6ea] = 0xef58, [0xd6eb] = 0xef59, [0xd6ec] = 0xef5a, [0xd6ed] = 0xef5b,
  [0xd6ee] = 0xef5c, [0xd6ef] = 0xef5d, [0xd6f0] = 0xef5e, [0xd6f1] = 0xef5f,
  [0xd6f2] = 0xef60, [0xd6f3] = 0xef61, [0xd6f4] = 0xef62, [0xd6f5] = 0xef63,
  [0xd6f6] = 0xef64, [0xd6f7] = 0xef65, [0xd6f8] = 0xef66, [0xd6f9] = 0xef67,
  [0xd6fa] = 0xef68, [0xd6fb] = 0xef69, [0xd6fc] = 0xef6a, [0xd6fd] = 0xef6b,
  [0xd741] = 0xef6c, [0xd742] = 0xef6d, [0xd743] = 0xef6e, [0xd744] = 0xef6f,
  [0xd745] = 0xef70, [0xd746] = 0xef71, [0xd747] = 0xef72, [0xd748] = 0xef73,
  [0xd749] = 0xef74, [0xd74a] = 0xef75, [0xd74b] = 0xef76, [0xd74c] = 0xef77,
  [0xd74d] = 0xef78, [0xd74e] = 0xef79, [0xd74f] = 0xef7a, [0xd750] = 0xef7b,
  [0xd751] = 0xef7c, [0xd752] = 0xef7d, [0xd753] = 0xef7e, [0xd754] = 0xef7f,
  [0xd755] = 0xef80, [0xd756] = 0xef81, [0xd757] = 0xef82, [0xd758] = 0xef83,
  [0xd759] = 0xef84, [0xd75a] = 0xef85, [0xd75b] = 0xef86, [0xd75c] = 0xef87,
  [0xd75d] = 0xef88, [0xd75e] = 0xef89, [0xd75f] = 0xef8a, [0xd760] = 0xef8b,
  [0xd761] = 0xef8c, [0xd762] = 0xef8d, [0xd763] = 0xef8e, [0xd764] = 0xef8f,
  [0xd765] = 0xef90, [0xd766] = 0xef91, [0xd767] = 0xef92, [0xd768] = 0xef93,
  [0xd769] = 0xef94, [0xd76a] = 0xef95, [0xd76b] = 0xef96, [0xd76c] = 0xef97,
  [0xd76d] = 0xef98, [0xd76e] = 0xef99, [0xd76f] = 0xef9a, [0xd770] = 0xef9b,
  [0xd771] = 0xef9c, [0xd772] = 0xef9d, [0xd773] = 0xef9e, [0xd774] = 0xef9f,
  [0xd775] = 0xefa0, [0xd776] = 0xefa1, [0xd777] = 0xefa2, [0xd778] = 0xefa3,
  [0xd779] = 0xefa4, [0xd77a] = 0xefa5, [0xd77b] = 0xefa6, [0xd77c] = 0xefa7,
  [0xd77d] = 0xefa8, [0xd77e] = 0xefa9, [0xd77f] = 0xefaa, [0xd781] = 0xefab,
  [0xd782] = 0xefac, [0xd783] = 0xefad, [0xd784] = 0xefae, [0xd785] = 0xefaf,
  [0xd786] = 0xefb0, [0xd787] = 0xefb1, [0xd788] = 0xefb2, [0xd789] = 0xefb3,
  [0xd78a] = 0xefb4, [0xd78b] = 0xefb5, [0xd78c] = 0xefb6, [0xd78d] = 0xefb7,
  [0xd78e] = 0xefb8, [0xd78f] = 0xefb9, [0xd790] = 0xefba, [0xd791] = 0xefbb,
  [0xd792] = 0xefbc, [0xd793] = 0xefbd, [0xd794] = 0xefbe, [0xd795] = 0xefbf,
  [0xd796] = 0xefc0, [0xd797] = 0xefc1, [0xd798] = 0xefc2, [0xd799] = 0xefc3,
  [0xd79a] = 0xefc4, [0xd79b] = 0xefc5, [0xd79c] = 0xefc6, [0xd79d] = 0xefc7,
  [0xd79e] = 0xefc8, [0xd79f] = 0xefc9, [0xd7a0] = 0xefca, [0xd7a1] = 0xefcb,
  [0xd7a2] = 0xefcc, [0xd7a3] = 0xefcd, [0xd7a4] = 0xefce, [0xd7a5] = 0xefcf,
  [0xd7a6] = 0xefd0, [0xd7a7] = 0xefd1, [0xd7a8] = 0xefd2, [0xd7a9] = 0xefd3,
  [0xd7aa] = 0xefd4, [0xd7ab] = 0xefd5, [0xd7ac] = 0xefd6, [0xd7ad] = 0xefd7,
  [0xd7ae] = 0xefd8, [0xd7af] = 0xefd9, [0xd7b0] = 0xefda, [0xd7b1] = 0xefdb,
  [0xd7b2] = 0xefdc, [0xd7b3] = 0xefdd, [0xd7b4] = 0xefde, [0xd7b5] = 0xefdf,
  [0xd7b6] = 0xefe0, [0xd7b7] = 0xefe1, [0xd7b8] = 0xefe2, [0xd7b9] = 0xefe3,
  [0xd7ba] = 0xefe4, [0xd7bb] = 0xefe5, [0xd7bc] = 0xefe6, [0xd7bd] = 0xefe7,
  [0xd7be] = 0xefe8, [0xd7bf] = 0xefe9, [0xd7c0] = 0xefea, [0xd7c1] = 0xefeb,
  [0xd7c2] = 0xefec, [0xd7c3] = 0xefed, [0xd7c4] = 0xefee, [0xd7c5] = 0xefef,
  [0xd7c6] = 0xeff0, [0xd7c7] = 0xeff1, [0xd7c8] = 0xeff2, [0xd7c9] = 0xeff3,
  [0xd7ca] = 0xeff4, [0xd7cb] = 0xeff5, [0xd7cc] = 0xeff6, [0xd7cd] = 0xeff7,
  [0xd7ce] = 0xeff8, [0xd7cf] = 0xeff9, [0xd7d0] = 0xeffa, [0xd7d1] = 0xeffb,
  [0xd7d2] = 0xeffc, [0xd7d3] = 0xeffd, [0xd7d4] = 0xeffe, [0xd7d5] = 0xefff,
  [0xd7d6] = 0xf000, [0xd7d7] = 0xf001, [0xd7d8] = 0xf002, [0xd7d9] = 0xf003,
  [0xd7da] = 0xf004, [0xd7db] = 0xf005, [0xd7dc] = 0xf006, [0xd7dd] = 0xf007,
  [0xd7de] = 0xf008, [0xd7df] = 0xf009, [0xd7e0] = 0xf00a, [0xd7e1] = 0xf00b,
  [0xd7e2] = 0xf00c, [0xd7e3] = 0xf00d, [0xd7e4] = 0xf00e, [0xd7e5] = 0xf00f,
  [0xd7e6] = 0xf010, [0xd7e7] = 0xf011, [0xd7e8] = 0xf012, [0xd7e9] = 0xf013,
  [0xd7ea] = 0xf014, [0xd7eb] = 0xf015, [0xd7ec] = 0xf016, [0xd7ed] = 0xf017,
  [0xd7ee] = 0xf018, [0xd7ef] = 0xf019, [0xd7f0] = 0xf01a, [0xd7f1] = 0xf01b,
  [0xd7f2] = 0xf01c, [0xd7f3] = 0xf01d, [0xd7f4] = 0xf01e, [0xd7f5] = 0xf01f,
  [0xd7f6] = 0xf020, [0xd7f7] = 0xf021, [0xd7f8] = 0xf022, [0xd7f9] = 0xf023,
  [0xd7fa] = 0xf024, [0xd7fb] = 0xf025, [0xd7fc] = 0xf026, [0xd7fd] = 0xf027,
  [0xd841] = 0xf028, [0xd842] = 0xf029, [0xd843] = 0xf02a, [0xd844] = 0xf02b,
  [0xd845] = 0xf02c, [0xd846] = 0xf02d, [0xd847] = 0xf02e, [0xd848] = 0xf02f,
  [0xd849] = 0xf030, [0xd84a] = 0xf031, [0xd84b] = 0xf032, [0xd84c] = 0xf033,
  [0xd84d] = 0xf034, [0xd84e] = 0xf035, [0xd84f] = 0xf036, [0xd850] = 0xf037,
  [0xd851] = 0xf038, [0xd852] = 0xf039, [0xd853] = 0xf03a, [0xd854] = 0xf03b,
  [0xd855] = 0xf03c, [0xd856] = 0xf03d, [0xd857] = 0xf03e, [0xd858] = 0xf03f,
  [0xd859] = 0xf040, [0xd85a] = 0xf041, [0xd85b] = 0xf042, [0xd85c] = 0xf043,
  [0xd85d] = 0xf044, [0xd85e] = 0xf045, [0xd85f] = 0xf046, [0xd860] = 0xf047,
  [0xd861] = 0xf048, [0xd862] = 0xf049, [0xd863] = 0xf04a, [0xd864] = 0xf04b,
  [0xd865] = 0xf04c, [0xd866] = 0xf04d, [0xd867] = 0xf04e, [0xd868] = 0xf04f,
  [0xd869] = 0xf050, [0xd86a] = 0xf051, [0xd86b] = 0xf052, [0xd86c] = 0xf053,
  [0xd86d] = 0xf054, [0xd86e] = 0xf055, [0xd86f] = 0xf056, [0xd870] = 0xf057,
  [0xd871] = 0xf058, [0xd872] = 0xf059, [0xd873] = 0xf05a, [0xd874] = 0xf05b,
  [0xd875] = 0xf05c, [0xd876] = 0xf05d, [0xd877] = 0xf05e, [0xd878] = 0xf05f,
  [0xd879] = 0xf060, [0xd87a] = 0xf061, [0xd87b] = 0xf062, [0xd87c] = 0xf063,
  [0xd87d] = 0xf064, [0xd87e] = 0xf065, [0xd87f] = 0xf066, [0xd881] = 0xf067,
  [0xd882] = 0xf068, [0xd883] = 0xf069, [0xd884] = 0xf06a, [0xd885] = 0xf06b,
  [0xd886] = 0xf06c, [0xd887] = 0xf06d, [0xd888] = 0xf06e, [0xd889] = 0xf06f,
  [0xd88a] = 0xf070, [0xd88b] = 0xf071, [0xd88c] = 0xf072, [0xd88d] = 0xf073,
  [0xd88e] = 0xf074, [0xd88f] = 0xf075, [0xd890] = 0xf076, [0xd891] = 0xf077,
  [0xd892] = 0xf078, [0xd893] = 0xf079, [0xd894] = 0xf07a, [0xd895] = 0xf07b,
  [0xd896] = 0xf07c, [0xd897] = 0xf07d, [0xd898] = 0xf07e, [0xd899] = 0xf07f,
  [0xd89a] = 0xf080, [0xd89b] = 0xf081, [0xd89c] = 0xf082, [0xd89d] = 0xf083,
  [0xd89e] = 0xf084, [0xd89f] = 0xf085, [0xd8a0] = 0xf086, [0xd8a1] = 0xf087,
  [0xd8a2] = 0xf088, [0xd8a3] = 0xf089, [0xd8a4] = 0xf08a, [0xd8a5] = 0xf08b,
  [0xd8a6] = 0xf08c, [0xd8a7] = 0xf08d, [0xd8a8] = 0xf08e, [0xd8a9] = 0xf08f,
  [0xd8aa] = 0xf090, [0xd8ab] = 0xf091, [0xd8ac] = 0xf092, [0xd8ad] = 0xf093,
  [0xd8ae] = 0xf094, [0xd8af] = 0xf095, [0xd8b0] = 0xf096, [0xd8b1] = 0xf097,
  [0xd8b2] = 0xf098, [0xd8b3] = 0xf099, [0xd8b4] = 0xf09a, [0xd8b5] = 0xf09b,
  [0xd8b6] = 0xf09c, [0xd8b7] = 0xf09d, [0xd8b8] = 0xf09e, [0xd8b9] = 0xf09f,
  [0xd8ba] = 0xf0a0, [0xd8bb] = 0xf0a1, [0xd8bc] = 0xf0a2, [0xd8bd] = 0xf0a3,
  [0xd8be] = 0xf0a4, [0xd8bf] = 0xf0a5, [0xd8c0] = 0xf0a6, [0xd8c1] = 0xf0a7,
  [0xd8c2] = 0xf0a8, [0xd8c3] = 0xf0a9, [0xd8c4] = 0xf0aa, [0xd8c5] = 0xf0ab,
  [0xd8c6] = 0xf0ac, [0xd8c7] = 0xf0ad, [0xd8c8] = 0xf0ae, [0xd8c9] = 0xf0af,
  [0xd8ca] = 0xf0b0, [0xd8cb] = 0xf0b1, [0xd8cc] = 0xf0b2, [0xd8cd] = 0xf0b3,
  [0xd8ce] = 0xf0b4, [0xd8cf] = 0xf0b5, [0xd8d0] = 0xf0b6, [0xd8d1] = 0xf0b7,
  [0xd8d2] = 0xf0b8, [0xd8d3] = 0xf0b9, [0xd8d4] = 0xf0ba, [0xd8d5] = 0xf0bb,
  [0xd8d6] = 0xf0bc, [0xd8d7] = 0xf0bd, [0xd8d8] = 0xf0be, [0xd8d9] = 0xf0bf,
  [0xd8da] = 0xf0c0, [0xd8db] = 0xf0c1, [0xd8dc] = 0xf0c2, [0xd8dd] = 0xf0c3,
  [0xd8de] = 0xf0c4, [0xd8df] = 0xf0c5, [0xd8e0] = 0xf0c6, [0xd8e1] = 0xf0c7,
  [0xd8e2] = 0xf0c8, [0xd8e3] = 0xf0c9, [0xd8e4] = 0xf0ca, [0xd8e5] = 0xf0cb,
  [0xd8e6] = 0xf0cc, [0xd8e7] = 0xf0cd, [0xd8e8] = 0xf0ce, [0xd8e9] = 0xf0cf,
  [0xd8ea] = 0xf0d0, [0xd8eb] = 0xf0d1, [0xd8ec] = 0xf0d2, [0xd8ed] = 0xf0d3,
  [0xd8ee] = 0xf0d4, [0xd8ef] = 0xf0d5, [0xd8f0] = 0xf0d6, [0xd8f1] = 0xf0d7,
  [0xd8f2] = 0xf0d8, [0xd8f3] = 0xf0d9, [0xd8f4] = 0xf0da, [0xd8f5] = 0xf0db,
  [0xd8f6] = 0xf0dc, [0xd8f7] = 0xf0dd, [0xd8f8] = 0xf0de, [0xd8f9] = 0xf0df,
  [0xd8fa] = 0xf0e0, [0xd8fb] = 0xf0e1, [0xd8fc] = 0xf0e2, [0xd8fd] = 0xf0e3,
  [0xd941] = 0xf0e4, [0xd942] = 0xf0e5, [0xd943] = 0xf0e6, [0xd944] = 0xf0e7,
  [0xd945] = 0xf0e8, [0xd946] = 0xf0e9, [0xd947] = 0xf0ea, [0xd948] = 0xf0eb,
  [0xd949] = 0xf0ec, [0xd94a] = 0xf0ed, [0xd94b] = 0xf0ee, [0xd94c] = 0xf0ef,
  [0xd94d] = 0xf0f0, [0xd94e] = 0xf0f1, [0xd94f] = 0xf0f2, [0xd950] = 0xf0f3,
  [0xd951] = 0xf0f4, [0xd952] = 0xf0f5, [0xd953] = 0xf0f6, [0xd954] = 0xf0f7,
  [0xd955] = 0xf0f8, [0xd956] = 0xf0f9, [0xd957] = 0xf0fa, [0xd958] = 0xf0fb,
  [0xd959] = 0xf0fc, [0xd95a] = 0xf0fd, [0xd95b] = 0xf0fe, [0xd95c] = 0xf0ff,
  [0xd95d] = 0xf100, [0xd95e] = 0xf101, [0xd95f] = 0xf102, [0xd960] = 0xf103,
  [0xd961] = 0xf104, [0xd962] = 0xf105, [0xd963] = 0xf106, [0xd964] = 0xf107,
  [0xd965] = 0xf108, [0xd966] = 0xf109, [0xd967] = 0xf10a, [0xd968] = 0xf10b,
  [0xd969] = 0xf10c, [0xd96a] = 0xf10d, [0xd96b] = 0xf10e, [0xd96c] = 0xf10f,
  [0xd96d] = 0xf110, [0xd96e] = 0xf111, [0xd96f] = 0xf112, [0xd970] = 0xf113,
  [0xd971] = 0xf114, [0xd972] = 0xf115, [0xd973] = 0xf116, [0xd974] = 0xf117,
  [0xd975] = 0xf118, [0xd976] = 0xf119, [0xd977] = 0xf11a, [0xd978] = 0xf11b,
  [0xd979] = 0xf11c, [0xd97a] = 0xf11d, [0xd97b] = 0xf11e, [0xd97c] = 0xf11f,
  [0xd97d] = 0xf120, [0xd97e] = 0xf121, [0xd97f] = 0xf122, [0xd981] = 0xf123,
  [0xd982] = 0xf124, [0xd983] = 0xf125, [0xd984] = 0xf126, [0xd985] = 0xf127,
  [0xd986] = 0xf128, [0xd987] = 0xf129, [0xd988] = 0xf12a, [0xd989] = 0xf12b,
  [0xd98a] = 0xf12c, [0xd98b] = 0xf12d, [0xd98c] = 0xf12e, [0xd98d] = 0xf12f,
  [0xd98e] = 0xf130, [0xd98f] = 0xf131, [0xd990] = 0xf132, [0xd991] = 0xf133,
  [0xd992] = 0xf134, [0xd993] = 0xf135, [0xd994] = 0xf136, [0xd995] = 0xf137,
  [0xd996] = 0xf138, [0xd997] = 0xf139, [0xd998] = 0xf13a, [0xd999] = 0xf13b,
  [0xd99a] = 0xf13c, [0xd99b] = 0xf13d, [0xd99c] = 0xf13e, [0xd99d] = 0xf13f,
  [0xd99e] = 0xf140, [0xd99f] = 0xf141, [0xd9a0] = 0xf142, [0xd9a1] = 0xf143,
  [0xd9a2] = 0xf144, [0xd9a3] = 0xf145, [0xd9a4] = 0xf146, [0xd9a5] = 0xf147,
  [0xd9a6] = 0xf148, [0xd9a7] = 0xf149, [0xd9a8] = 0xf14a, [0xd9a9] = 0xf14b,
  [0xd9aa] = 0xf14c, [0xd9ab] = 0xf14d, [0xd9ac] = 0xf14e, [0xd9ad] = 0xf14f,
  [0xd9ae] = 0xf150, [0xd9af] = 0xf151, [0xd9b0] = 0xf152, [0xd9b1] = 0xf153,
  [0xd9b2] = 0xf154, [0xd9b3] = 0xf155, [0xd9b4] = 0xf156, [0xd9b5] = 0xf157,
  [0xd9b6] = 0xf158, [0xd9b7] = 0xf159, [0xd9b8] = 0xf15a, [0xd9b9] = 0xf15b,
  [0xd9ba] = 0xf15c, [0xd9bb] = 0xf15d, [0xd9bc] = 0xf15e, [0xd9bd] = 0xf15f,
  [0xd9be] = 0xf160, [0xd9bf] = 0xf161, [0xd9c0] = 0xf162, [0xd9c1] = 0xf163,
  [0xd9c2] = 0xf164, [0xd9c3] = 0xf165, [0xd9c4] = 0xf166, [0xd9c5] = 0xf167,
  [0xd9c6] = 0xf168, [0xd9c7] = 0xf169, [0xd9c8] = 0xf16a, [0xd9c9] = 0xf16b,
  [0xd9ca] = 0xf16c, [0xd9cb] = 0xf16d, [0xd9cc] = 0xf16e, [0xd9cd] = 0xf16f,
  [0xd9ce] = 0xf170, [0xd9cf] = 0xf171, [0xd9d0] = 0xf172, [0xd9d1] = 0xf173,
  [0xd9d2] = 0xf174, [0xd9d3] = 0xf175, [0xd9d4] = 0xf176, [0xd9d5] = 0xf177,
  [0xd9d6] = 0xf178, [0xd9d7] = 0xf179, [0xd9d8] = 0xf17a, [0xd9d9] = 0xf17b,
  [0xd9da] = 0xf17c, [0xd9db] = 0xf17d, [0xd9dc] = 0xf17e, [0xd9dd] = 0xf17f,
  [0xd9de] = 0xf180, [0xd9df] = 0xf181, [0xd9e0] = 0xf182, [0xd9e1] = 0xf183,
  [0xd9e2] = 0xf184, [0xd9e3] = 0xf185, [0xd9e4] = 0xf186, [0xd9e5] = 0xf187,
  [0xd9e6] = 0xf188, [0xd9e7] = 0xf189, [0xd9e8] = 0xf18a, [0xd9e9] = 0xf18b,
  [0xd9ea] = 0xf18c, [0xd9eb] = 0xf18d, [0xd9ec] = 0xf18e, [0xd9ed] = 0xf18f,
  [0xd9ee] = 0xf190, [0xd9ef] = 0xf191, [0xd9f0] = 0xf192, [0xd9f1] = 0xf193,
  [0xd9f2] = 0xf194, [0xd9f3] = 0xf195, [0xd9f4] = 0xf196, [0xd9f5] = 0xf197,
  [0xd9f6] = 0xf198, [0xd9f7] = 0xf199, [0xd9f8] = 0xf19a, [0xd9f9] = 0xf19b,
  [0xd9fa] = 0xf19c, [0xd9fb] = 0xf19d, [0xd9fc] = 0xf19e, [0xd9fd] = 0xf19f,
  [0xda41] = 0xf1a0, [0xda42] = 0xf1a1, [0xda43] = 0xf1a2, [0xda44] = 0xf1a3,
  [0xda45] = 0xf1a4, [0xda46] = 0xf1a5, [0xda47] = 0xf1a6, [0xda48] = 0xf1a7,
  [0xda49] = 0xf1a8, [0xda4a] = 0xf1a9, [0xda4b] = 0xf1aa, [0xda4c] = 0xf1ab,
  [0xda4d] = 0xf1ac, [0xda4e] = 0xf1ad, [0xda4f] = 0xf1ae, [0xda50] = 0xf1af,
  [0xda51] = 0xf1b0, [0xda52] = 0xf1b1, [0xda53] = 0xf1b2, [0xda54] = 0xf1b3,
  [0xda55] = 0xf1b4, [0xda56] = 0xf1b5, [0xda57] = 0xf1b6, [0xda58] = 0xf1b7,
  [0xda59] = 0xf1b8, [0xda5a] = 0xf1b9, [0xda5b] = 0xf1ba, [0xda5c] = 0xf1bb,
  [0xda5d] = 0xf1bc, [0xda5e] = 0xf1bd, [0xda5f] = 0xf1be, [0xda60] = 0xf1bf,
  [0xda61] = 0xf1c0, [0xda62] = 0xf1c1, [0xda63] = 0xf1c2, [0xda64] = 0xf1c3,
  [0xda65] = 0xf1c4, [0xda66] = 0xf1c5, [0xda67] = 0xf1c6, [0xda68] = 0xf1c7,
  [0xda69] = 0xf1c8, [0xda6a] = 0xf1c9, [0xda6b] = 0xf1ca, [0xda6c] = 0xf1cb,
  [0xda6d] = 0xf1cc, [0xda6e] = 0xf1cd, [0xda6f] = 0xf1ce, [0xda70] = 0xf1cf,
  [0xda71] = 0xf1d0, [0xda72] = 0xf1d1, [0xda73] = 0xf1d2, [0xda74] = 0xf1d3,
  [0xda75] = 0xf1d4, [0xda76] = 0xf1d5, [0xda77] = 0xf1d6, [0xda78] = 0xf1d7,
  [0xda79] = 0xf1d8, [0xda7a] = 0xf1d9, [0xda7b] = 0xf1da, [0xda7c] = 0xf1db,
  [0xda7d] = 0xf1dc, [0xda7e] = 0xf1dd, [0xda7f] = 0xf1de, [0xda81] = 0xf1df,
  [0xda82] = 0xf1e0, [0xda83] = 0xf1e1, [0xda84] = 0xf1e2, [0xda85] = 0xf1e3,
  [0xda86] = 0xf1e4, [0xda87] = 0xf1e5, [0xda88] = 0xf1e6, [0xda89] = 0xf1e7,
  [0xda8a] = 0xf1e8, [0xda8b] = 0xf1e9, [0xda8c] = 0xf1ea, [0xda8d] = 0xf1eb,
  [0xda8e] = 0xf1ec, [0xda8f] = 0xf1ed, [0xda90] = 0xf1ee, [0xda91] = 0xf1ef,
  [0xda92] = 0xf1f0, [0xda93] = 0xf1f1, [0xda94] = 0xf1f2, [0xda95] = 0xf1f3,
  [0xda96] = 0xf1f4, [0xda97] = 0xf1f5, [0xda98] = 0xf1f6, [0xda99] = 0xf1f7,
  [0xda9a] = 0xf1f8, [0xda9b] = 0xf1f9, [0xda9c] = 0xf1fa, [0xda9d] = 0xf1fb,
  [0xda9e] = 0xf1fc, [0xda9f] = 0xf1fd, [0xdaa0] = 0xf1fe, [0xdaa1] = 0xf1ff,
  [0xdaa2] = 0xf200, [0xdaa3] = 0xf201, [0xdaa4] = 0xf202, [0xdaa5] = 0xf203,
  [0xdaa6] = 0xf204, [0xdaa7] = 0xf205, [0xdaa8] = 0xf206, [0xdaa9] = 0xf207,
  [0xdaaa] = 0xf208, [0xdaab] = 0xf209, [0xdaac] = 0xf20a, [0xdaad] = 0xf20b,
  [0xdaae] = 0xf20c, [0xdaaf] = 0xf20d, [0xdab0] = 0xf20e, [0xdab1] = 0xf20f,
  [0xdab2] = 0xf210, [0xdab3] = 0xf211, [0xdab4] = 0xf212, [0xdab5] = 0xf213,
  [0xdab6] = 0xf214, [0xdab7] = 0xf215, [0xdab8] = 0xf216, [0xdab9] = 0xf217,
  [0xdaba] = 0xf218, [0xdabb] = 0xf219, [0xdabc] = 0xf21a, [0xdabd] = 0xf21b,
  [0xdabe] = 0xf21c, [0xdabf] = 0xf21d, [0xdac0] = 0xf21e, [0xdac1] = 0xf21f,
  [0xdac2] = 0xf220, [0xdac3] = 0xf221, [0xdac4] = 0xf222, [0xdac5] = 0xf223,
  [0xdac6] = 0xf224, [0xdac7] = 0xf225, [0xdac8] = 0xf226, [0xdac9] = 0xf227,
  [0xdaca] = 0xf228, [0xdacb] = 0xf229, [0xdacc] = 0xf22a, [0xdacd] = 0xf22b,
  [0xdace] = 0xf22c, [0xdacf] = 0xf22d, [0xdad0] = 0xf22e, [0xdad1] = 0xf22f,
  [0xdad2] = 0xf230, [0xdad3] = 0xf231, [0xdad4] = 0xf232, [0xdad5] = 0xf233,
  [0xdad6] = 0xf234, [0xdad7] = 0xf235, [0xdad8] = 0xf236, [0xdad9] = 0xf237,
  [0xdada] = 0xf238, [0xdadb] = 0xf239, [0xdadc] = 0xf23a, [0xdadd] = 0xf23b,
  [0xdade] = 0xf23c, [0xdadf] = 0xf23d, [0xdae0] = 0xf23e, [0xdae1] = 0xf23f,
  [0xdae2] = 0xf240, [0xdae3] = 0xf241, [0xdae4] = 0xf242, [0xdae5] = 0xf243,
  [0xdae6] = 0xf244, [0xdae7] = 0xf245, [0xdae8] = 0xf246, [0xdae9] = 0xf247,
  [0xdaea] = 0xf248, [0xdaeb] = 0xf249, [0xdaec] = 0xf24a, [0xdaed] = 0xf24b,
  [0xdaee] = 0xf24c, [0xdaef] = 0xf24d, [0xdaf0] = 0xf24e, [0xdaf1] = 0xf24f,
  [0xdaf2] = 0xf250, [0xdaf3] = 0xf251, [0xdaf4] = 0xf252, [0xdaf5] = 0xf253,
  [0xdaf6] = 0xf254, [0xdaf7] = 0xf255, [0xdaf8] = 0xf256, [0xdaf9] = 0xf257,
  [0xdafa] = 0xf258, [0xdafb] = 0xf259, [0xdafc] = 0xf25a, [0xdafd] = 0xf25b,
  [0xdb41] = 0xf25c, [0xdb42] = 0xf25d, [0xdb43] = 0xf25e, [0xdb44] = 0xf25f,
  [0xdb45] = 0xf260, [0xdb46] = 0xf261, [0xdb47] = 0xf262, [0xdb48] = 0xf263,
  [0xdb49] = 0xf264, [0xdb4a] = 0xf265, [0xdb4b] = 0xf266, [0xdb4c] = 0xf267,
  [0xdb4d] = 0xf268, [0xdb4e] = 0xf269, [0xdb4f] = 0xf26a, [0xdb50] = 0xf26b,
  [0xdb51] = 0xf26c, [0xdb52] = 0xf26d, [0xdb53] = 0xf26e, [0xdb54] = 0xf26f,
  [0xdb55] = 0xf270, [0xdb56] = 0xf271, [0xdb57] = 0xf272, [0xdb58] = 0xf273,
  [0xdb59] = 0xf274, [0xdb5a] = 0xf275, [0xdb5b] = 0xf276, [0xdb5c] = 0xf277,
  [0xdb5d] = 0xf278, [0xdb5e] = 0xf279, [0xdb5f] = 0xf27a, [0xdb60] = 0xf27b,
  [0xdb61] = 0xf27c, [0xdb62] = 0xf27d, [0xdb63] = 0xf27e, [0xdb64] = 0xf27f,
  [0xdb65] = 0xf280, [0xdb66] = 0xf281, [0xdb67] = 0xf282, [0xdb68] = 0xf283,
  [0xdb69] = 0xf284, [0xdb6a] = 0xf285, [0xdb6b] = 0xf286, [0xdb6c] = 0xf287,
  [0xdb6d] = 0xf288, [0xdb6e] = 0xf289, [0xdb6f] = 0xf28a, [0xdb70] = 0xf28b,
  [0xdb71] = 0xf28c, [0xdb72] = 0xf28d, [0xdb73] = 0xf28e, [0xdb74] = 0xf28f,
  [0xdb75] = 0xf290, [0xdb76] = 0xf291, [0xdb77] = 0xf292, [0xdb78] = 0xf293,
  [0xdb79] = 0xf294, [0xdb7a] = 0xf295, [0xdb7b] = 0xf296, [0xdb7c] = 0xf297,
  [0xdb7d] = 0xf298, [0xdb7e] = 0xf299, [0xdb7f] = 0xf29a, [0xdb81] = 0xf29b,
  [0xdb82] = 0xf29c, [0xdb83] = 0xf29d, [0xdb84] = 0xf29e, [0xdb85] = 0xf29f,
  [0xdb86] = 0xf2a0, [0xdb87] = 0xf2a1, [0xdb88] = 0xf2a2, [0xdb89] = 0xf2a3,
  [0xdb8a] = 0xf2a4, [0xdb8b] = 0xf2a5, [0xdb8c] = 0xf2a6, [0xdb8d] = 0xf2a7,
  [0xdb8e] = 0xf2a8, [0xdb8f] = 0xf2a9, [0xdb90] = 0xf2aa, [0xdb91] = 0xf2ab,
  [0xdb92] = 0xf2ac, [0xdb93] = 0xf2ad, [0xdb94] = 0xf2ae, [0xdb95] = 0xf2af,
  [0xdb96] = 0xf2b0, [0xdb97] = 0xf2b1, [0xdb98] = 0xf2b2, [0xdb99] = 0xf2b3,
  [0xdb9a] = 0xf2b4, [0xdb9b] = 0xf2b5, [0xdb9c] = 0xf2b6, [0xdb9d] = 0xf2b7,
  [0xdb9e] = 0xf2b8, [0xdb9f] = 0xf2b9, [0xdba0] = 0xf2ba, [0xdba1] = 0xf2bb,
  [0xdba2] = 0xf2bc, [0xdba3] = 0xf2bd, [0xdba4] = 0xf2be, [0xdba5] = 0xf2bf,
  [0xdba6] = 0xf2c0, [0xdba7] = 0xf2c1, [0xdba8] = 0xf2c2, [0xdba9] = 0xf2c3,
  [0xdbaa] = 0xf2c4, [0xdbab] = 0xf2c5, [0xdbac] = 0xf2c6, [0xdbad] = 0xf2c7,
  [0xdbae] = 0xf2c8, [0xdbaf] = 0xf2c9, [0xdbb0] = 0xf2ca, [0xdbb1] = 0xf2cb,
  [0xdbb2] = 0xf2cc, [0xdbb3] = 0xf2cd, [0xdbb4] = 0xf2ce, [0xdbb5] = 0xf2cf,
  [0xdbb6] = 0xf2d0, [0xdbb7] = 0xf2d1, [0xdbb8] = 0xf2d2, [0xdbb9] = 0xf2d3,
  [0xdbba] = 0xf2d4, [0xdbbb] = 0xf2d5, [0xdbbc] = 0xf2d6, [0xdbbd] = 0xf2d7,
  [0xdbbe] = 0xf2d8, [0xdbbf] = 0xf2d9, [0xdbc0] = 0xf2da, [0xdbc1] = 0xf2db,
  [0xdbc2] = 0xf2dc, [0xdbc3] = 0xf2dd, [0xdbc4] = 0xf2de, [0xdbc5] = 0xf2df,
  [0xdbc6] = 0xf2e0, [0xdbc7] = 0xf2e1, [0xdbc8] = 0xf2e2, [0xdbc9] = 0xf2e3,
  [0xdbca] = 0xf2e4, [0xdbcb] = 0xf2e5, [0xdbcc] = 0xf2e6, [0xdbcd] = 0xf2e7,
  [0xdbce] = 0xf2e8, [0xdbcf] = 0xf2e9, [0xdbd0] = 0xf2ea, [0xdbd1] = 0xf2eb,
  [0xdbd2] = 0xf2ec, [0xdbd3] = 0xf2ed, [0xdbd4] = 0xf2ee, [0xdbd5] = 0xf2ef,
  [0xdbd6] = 0xf2f0, [0xdbd7] = 0xf2f1, [0xdbd8] = 0xf2f2, [0xdbd9] = 0xf2f3,
  [0xdbda] = 0xf2f4, [0xdbdb] = 0xf2f5, [0xdbdc] = 0xf2f6, [0xdbdd] = 0xf2f7,
  [0xdbde] = 0xf2f8, [0xdbdf] = 0xf2f9, [0xdbe0] = 0xf2fa, [0xdbe1] = 0xf2fb,
  [0xdbe2] = 0xf2fc, [0xdbe3] = 0xf2fd, [0xdbe4] = 0xf2fe, [0xdbe5] = 0xf2ff,
  [0xdbe6] = 0xf300, [0xdbe7] = 0xf301, [0xdbe8] = 0xf302, [0xdbe9] = 0xf303,
  [0xdbea] = 0xf304, [0xdbeb] = 0xf305, [0xdbec] = 0xf306, [0xdbed] = 0xf307,
  [0xdbee] = 0xf308, [0xdbef] = 0xf309, [0xdbf0] = 0xf30a, [0xdbf1] = 0xf30b,
  [0xdbf2] = 0xf30c, [0xdbf3] = 0xf30d, [0xdbf4] = 0xf30e, [0xdbf5] = 0xf30f,
  [0xdbf6] = 0xf310, [0xdbf7] = 0xf311, [0xdbf8] = 0xf312, [0xdbf9] = 0xf313,
  [0xdbfa] = 0xf314, [0xdbfb] = 0xf315, [0xdbfc] = 0xf316, [0xdbfd] = 0xf317,
  [0xdc41] = 0xf318, [0xdc42] = 0xf319, [0xdc43] = 0xf31a, [0xdc44] = 0xf31b,
  [0xdc45] = 0xf31c, [0xdc46] = 0xf31d, [0xdc47] = 0xf31e, [0xdc48] = 0xf31f,
  [0xdc49] = 0xf320, [0xdc4a] = 0xf321, [0xdc4b] = 0xf322, [0xdc4c] = 0xf323,
  [0xdc4d] = 0xf324, [0xdc4e] = 0xf325, [0xdc4f] = 0xf326, [0xdc50] = 0xf327,
  [0xdc51] = 0xf328, [0xdc52] = 0xf329, [0xdc53] = 0xf32a, [0xdc54] = 0xf32b,
  [0xdc55] = 0xf32c, [0xdc56] = 0xf32d, [0xdc57] = 0xf32e, [0xdc58] = 0xf32f,
  [0xdc59] = 0xf330, [0xdc5a] = 0xf331, [0xdc5b] = 0xf332, [0xdc5c] = 0xf333,
  [0xdc5d] = 0xf334, [0xdc5e] = 0xf335, [0xdc5f] = 0xf336, [0xdc60] = 0xf337,
  [0xdc61] = 0xf338, [0xdc62] = 0xf339, [0xdc63] = 0xf33a, [0xdc64] = 0xf33b,
  [0xdc65] = 0xf33c, [0xdc66] = 0xf33d, [0xdc67] = 0xf33e, [0xdc68] = 0xf33f,
  [0xdc69] = 0xf340, [0xdc6a] = 0xf341, [0xdc6b] = 0xf342, [0xdc6c] = 0xf343,
  [0xdc6d] = 0xf344, [0xdc6e] = 0xf345, [0xdc6f] = 0xf346, [0xdc70] = 0xf347,
  [0xdc71] = 0xf348, [0xdc72] = 0xf349, [0xdc73] = 0xf34a, [0xdc74] = 0xf34b,
  [0xdc75] = 0xf34c, [0xdc76] = 0xf34d, [0xdc77] = 0xf34e, [0xdc78] = 0xf34f,
  [0xdc79] = 0xf350, [0xdc7a] = 0xf351, [0xdc7b] = 0xf352, [0xdc7c] = 0xf353,
  [0xdc7d] = 0xf354, [0xdc7e] = 0xf355, [0xdc7f] = 0xf356, [0xdc81] = 0xf357,
  [0xdc82] = 0xf358, [0xdc83] = 0xf359, [0xdc84] = 0xf35a, [0xdc85] = 0xf35b,
  [0xdc86] = 0xf35c, [0xdc87] = 0xf35d, [0xdc88] = 0xf35e, [0xdc89] = 0xf35f,
  [0xdc8a] = 0xf360, [0xdc8b] = 0xf361, [0xdc8c] = 0xf362, [0xdc8d] = 0xf363,
  [0xdc8e] = 0xf364, [0xdc8f] = 0xf365, [0xdc90] = 0xf366, [0xdc91] = 0xf367,
  [0xdc92] = 0xf368, [0xdc93] = 0xf369, [0xdc94] = 0xf36a, [0xdc95] = 0xf36b,
  [0xdc96] = 0xf36c, [0xdc97] = 0xf36d, [0xdc98] = 0xf36e, [0xdc99] = 0xf36f,
  [0xdc9a] = 0xf370, [0xdc9b] = 0xf371, [0xdc9c] = 0xf372, [0xdc9d] = 0xf373,
  [0xdc9e] = 0xf374, [0xdc9f] = 0xf375, [0xdca0] = 0xf376, [0xdca1] = 0xf377,
  [0xdca2] = 0xf378, [0xdca3] = 0xf379, [0xdca4] = 0xf37a, [0xdca5] = 0xf37b,
  [0xdca6] = 0xf37c, [0xdca7] = 0xf37d, [0xdca8] = 0xf37e, [0xdca9] = 0xf37f,
  [0xdcaa] = 0xf380, [0xdcab] = 0xf381, [0xdcac] = 0xf382, [0xdcad] = 0xf383,
  [0xdcae] = 0xf384, [0xdcaf] = 0xf385, [0xdcb0] = 0xf386, [0xdcb1] = 0xf387,
  [0xdcb2] = 0xf388, [0xdcb3] = 0xf389, [0xdcb4] = 0xf38a, [0xdcb5] = 0xf38b,
  [0xdcb6] = 0xf38c, [0xdcb7] = 0xf38d, [0xdcb8] = 0xf38e, [0xdcb9] = 0xf38f,
  [0xdcba] = 0xf390, [0xdcbb] = 0xf391, [0xdcbc] = 0xf392, [0xdcbd] = 0xf393,
  [0xdcbe] = 0xf394, [0xdcbf] = 0xf395, [0xdcc0] = 0xf396, [0xdcc1] = 0xf397,
  [0xdcc2] = 0xf398, [0xdcc3] = 0xf399, [0xdcc4] = 0xf39a, [0xdcc5] = 0xf39b,
  [0xdcc6] = 0xf39c, [0xdcc7] = 0xf39d, [0xdcc8] = 0xf39e, [0xdcc9] = 0xf39f,
  [0xdcca] = 0xf3a0, [0xdccb] = 0xf3a1, [0xdccc] = 0xf3a2, [0xdccd] = 0xf3a3,
  [0xdcce] = 0xf3a4, [0xdccf] = 0xf3a5, [0xdcd0] = 0xf3a6, [0xdcd1] = 0xf3a7,
  [0xdcd2] = 0xf3a8, [0xdcd3] = 0xf3a9, [0xdcd4] = 0xf3aa, [0xdcd5] = 0xf3ab,
  [0xdcd6] = 0xf3ac, [0xdcd7] = 0xf3ad, [0xdcd8] = 0xf3ae, [0xdcd9] = 0xf3af,
  [0xdcda] = 0xf3b0, [0xdcdb] = 0xf3b1, [0xdcdc] = 0xf3b2, [0xdcdd] = 0xf3b3,
  [0xdcde] = 0xf3b4, [0xdcdf] = 0xf3b5, [0xdce0] = 0xf3b6, [0xdce1] = 0xf3b7,
  [0xdce2] = 0xf3b8, [0xdce3] = 0xf3b9, [0xdce4] = 0xf3ba, [0xdce5] = 0xf3bb,
  [0xdce6] = 0xf3bc, [0xdce7] = 0xf3bd, [0xdce8] = 0xf3be, [0xdce9] = 0xf3bf,
  [0xdcea] = 0xf3c0, [0xdceb] = 0xf3c1, [0xdcec] = 0xf3c2, [0xdced] = 0xf3c3,
  [0xdcee] = 0xf3c4, [0xdcef] = 0xf3c5, [0xdcf0] = 0xf3c6, [0xdcf1] = 0xf3c7,
  [0xdcf2] = 0xf3c8, [0xdcf3] = 0xf3c9, [0xdcf4] = 0xf3ca, [0xdcf5] = 0xf3cb,
  [0xdcf6] = 0xf3cc, [0xdcf7] = 0xf3cd, [0xdcf8] = 0xf3ce, [0xdcf9] = 0xf3cf,
  [0xdcfa] = 0xf3d0, [0xdcfb] = 0xf3d1, [0xdcfc] = 0xf3d2, [0xdcfd] = 0xf3d3,
  [0xdd41] = 0xf3d4, [0xdd42] = 0xf3d5, [0xdd43] = 0xf3d6, [0xdd44] = 0xf3d7,
  [0xdd45] = 0xf3d8, [0xdd46] = 0xf3d9, [0xdd47] = 0xf3da, [0xdd48] = 0xf3db,
  [0xdd49] = 0xf3dc, [0xdd4a] = 0xf3dd, [0xdd4b] = 0xf3de, [0xdd4c] = 0xf3df,
  [0xdd4d] = 0xf3e0, [0xdd4e] = 0xf3e1, [0xdd4f] = 0xf3e2, [0xdd50] = 0xf3e3,
  [0xdd51] = 0xf3e4, [0xdd52] = 0xf3e5, [0xdd53] = 0xf3e6, [0xdd54] = 0xf3e7,
  [0xdd55] = 0xf3e8, [0xdd56] = 0xf3e9, [0xdd57] = 0xf3ea, [0xdd58] = 0xf3eb,
  [0xdd59] = 0xf3ec, [0xdd5a] = 0xf3ed, [0xdd5b] = 0xf3ee, [0xdd5c] = 0xf3ef,
  [0xdd5d] = 0xf3f0, [0xdd5e] = 0xf3f1, [0xdd5f] = 0xf3f2, [0xdd60] = 0xf3f3,
  [0xdd61] = 0xf3f4, [0xdd62] = 0xf3f5, [0xdd63] = 0xf3f6, [0xdd64] = 0xf3f7,
  [0xdd65] = 0xf3f8, [0xdd66] = 0xf3f9, [0xdd67] = 0xf3fa, [0xdd68] = 0xf3fb,
  [0xdd69] = 0xf3fc, [0xdd6a] = 0xf3fd, [0xdd6b] = 0xf3fe, [0xdd6c] = 0xf3ff,
  [0xdd6d] = 0xf400, [0xdd6e] = 0xf401, [0xdd6f] = 0xf402, [0xdd70] = 0xf403,
  [0xdd71] = 0xf404, [0xdd72] = 0xf405, [0xdd73] = 0xf406, [0xdd74] = 0xf407,
  [0xdd75] = 0xf408, [0xdd76] = 0xf409, [0xdd77] = 0xf40a, [0xdd78] = 0xf40b,
  [0xdd79] = 0xf40c, [0xdd7a] = 0xf40d, [0xdd7b] = 0xf40e, [0xdd7c] = 0xf40f,
  [0xdd7d] = 0xf410, [0xdd7e] = 0xf411, [0xdd7f] = 0xf412, [0xdd81] = 0xf413,
  [0xdd82] = 0xf414, [0xdd83] = 0xf415, [0xdd84] = 0xf416, [0xdd85] = 0xf417,
  [0xdd86] = 0xf418, [0xdd87] = 0xf419, [0xdd88] = 0xf41a, [0xdd89] = 0xf41b,
  [0xdd8a] = 0xf41c, [0xdd8b] = 0xf41d, [0xdd8c] = 0xf41e, [0xdd8d] = 0xf41f,
  [0xdd8e] = 0xf420, [0xdd8f] = 0xf421, [0xdd90] = 0xf422, [0xdd91] = 0xf423,
  [0xdd92] = 0xf424, [0xdd93] = 0xf425, [0xdd94] = 0xf426, [0xdd95] = 0xf427,
  [0xdd96] = 0xf428, [0xdd97] = 0xf429, [0xdd98] = 0xf42a, [0xdd99] = 0xf42b,
  [0xdd9a] = 0xf42c, [0xdd9b] = 0xf42d, [0xdd9c] = 0xf42e, [0xdd9d] = 0xf42f,
  [0xdd9e] = 0xf430, [0xdd9f] = 0xf431, [0xdda0] = 0xf432, [0xdda1] = 0xf433,
  [0xdda2] = 0xf434, [0xdda3] = 0xf435, [0xdda4] = 0xf436, [0xdda5] = 0xf437,
  [0xdda6] = 0xf438, [0xdda7] = 0xf439, [0xdda8] = 0xf43a, [0xdda9] = 0xf43b,
  [0xddaa] = 0xf43c, [0xddab] = 0xf43d, [0xddac] = 0xf43e, [0xddad] = 0xf43f,
  [0xddae] = 0xf440, [0xddaf] = 0xf441, [0xddb0] = 0xf442, [0xddb1] = 0xf443,
  [0xddb2] = 0xf444, [0xddb3] = 0xf445, [0xddb4] = 0xf446, [0xddb5] = 0xf447,
  [0xddb6] = 0xf448, [0xddb7] = 0xf449, [0xddb8] = 0xf44a, [0xddb9] = 0xf44b,
  [0xddba] = 0xf44c, [0xddbb] = 0xf44d, [0xddbc] = 0xf44e, [0xddbd] = 0xf44f,
  [0xddbe] = 0xf450, [0xddbf] = 0xf451, [0xddc0] = 0xf452, [0xddc1] = 0xf453,
  [0xddc2] = 0xf454, [0xddc3] = 0xf455, [0xddc4] = 0xf456, [0xddc5] = 0xf457,
  [0xddc6] = 0xf458, [0xddc7] = 0xf459, [0xddc8] = 0xf45a, [0xddc9] = 0xf45b,
  [0xddca] = 0xf45c, [0xddcb] = 0xf45d, [0xddcc] = 0xf45e, [0xddcd] = 0xf45f,
  [0xddce] = 0xf460, [0xddcf] = 0xf461, [0xddd0] = 0xf462, [0xddd1] = 0xf463,
  [0xddd2] = 0xf464, [0xddd3] = 0xf465, [0xddd4] = 0xf466, [0xddd5] = 0xf467,
  [0xddd6] = 0xf468, [0xddd7] = 0xf469, [0xddd8] = 0xf46a, [0xddd9] = 0xf46b,
  [0xddda] = 0xf46c, [0xdddb] = 0xf46d, [0xdddc] = 0xf46e, [0xdddd] = 0xf46f,
  [0xddde] = 0xf470, [0xdddf] = 0xf471, [0xdde0] = 0xf472, [0xdde1] = 0xf473,
  [0xdde2] = 0xf474, [0xdde3] = 0xf475, [0xdde4] = 0xf476, [0xdde5] = 0xf477,
  [0xdde6] = 0xf478, [0xdde7] = 0xf479, [0xdde8] = 0xf47a, [0xdde9] = 0xf47b,
  [0xddea] = 0xf47c, [0xddeb] = 0xf47d, [0xddec] = 0xf47e, [0xdded] = 0xf47f,
  [0xddee] = 0xf480, [0xddef] = 0xf481, [0xddf0] = 0xf482, [0xddf1] = 0xf483,
  [0xddf2] = 0xf484, [0xddf3] = 0xf485, [0xddf4] = 0xf486, [0xddf5] = 0xf487,
  [0xddf6] = 0xf488, [0xddf7] = 0xf489, [0xddf8] = 0xf48a, [0xddf9] = 0xf48b,
  [0xddfa] = 0xf48c, [0xddfb] = 0xf48d, [0xddfc] = 0xf48e, [0xddfd] = 0xf48f,
  [0xde41] = 0xf490, [0xde42] = 0xf491, [0xde43] = 0xf492, [0xde44] = 0xf493,
  [0xde45] = 0xf494, [0xde46] = 0xf495, [0xde47] = 0xf496, [0xde48] = 0xf497,
  [0xde49] = 0xf498, [0xde4a] = 0xf499, [0xde4b] = 0xf49a, [0xde4c] = 0xf49b,
  [0xde4d] = 0xf49c, [0xde4e] = 0xf49d, [0xde4f] = 0xf49e, [0xde50] = 0xf49f,
  [0xde51] = 0xf4a0, [0xde52] = 0xf4a1, [0xde53] = 0xf4a2, [0xde54] = 0xf4a3,
  [0xde55] = 0xf4a4, [0xde56] = 0xf4a5, [0xde57] = 0xf4a6, [0xde58] = 0xf4a7,
  [0xde59] = 0xf4a8, [0xde5a] = 0xf4a9, [0xde5b] = 0xf4aa, [0xde5c] = 0xf4ab,
  [0xde5d] = 0xf4ac, [0xde5e] = 0xf4ad, [0xde5f] = 0xf4ae, [0xde60] = 0xf4af,
  [0xde61] = 0xf4b0, [0xde62] = 0xf4b1, [0xde63] = 0xf4b2, [0xde64] = 0xf4b3,
  [0xde65] = 0xf4b4, [0xde66] = 0xf4b5, [0xde67] = 0xf4b6, [0xde68] = 0xf4b7,
  [0xde69] = 0xf4b8, [0xde6a] = 0xf4b9, [0xde6b] = 0xf4ba, [0xde6c] = 0xf4bb,
  [0xde6d] = 0xf4bc, [0xde6e] = 0xf4bd, [0xde6f] = 0xf4be, [0xde70] = 0xf4bf,
  [0xde71] = 0xf4c0, [0xde72] = 0xf4c1, [0xde73] = 0xf4c2, [0xde74] = 0xf4c3,
  [0xde75] = 0xf4c4, [0xde76] = 0xf4c5, [0xde77] = 0xf4c6, [0xde78] = 0xf4c7,
  [0xde79] = 0xf4c8, [0xde7a] = 0xf4c9, [0xde7b] = 0xf4ca, [0xde7c] = 0xf4cb,
  [0xde7d] = 0xf4cc, [0xde7e] = 0xf4cd, [0xde7f] = 0xf4ce, [0xde81] = 0xf4cf,
  [0xde82] = 0xf4d0, [0xde83] = 0xf4d1, [0xde84] = 0xf4d2, [0xde85] = 0xf4d3,
  [0xde86] = 0xf4d4, [0xde87] = 0xf4d5, [0xde88] = 0xf4d6, [0xde89] = 0xf4d7,
  [0xde8a] = 0xf4d8, [0xde8b] = 0xf4d9, [0xde8c] = 0xf4da, [0xde8d] = 0xf4db,
  [0xde8e] = 0xf4dc, [0xde8f] = 0xf4dd, [0xde90] = 0xf4de, [0xde91] = 0xf4df,
  [0xde92] = 0xf4e0, [0xde93] = 0xf4e1, [0xde94] = 0xf4e2, [0xde95] = 0xf4e3,
  [0xde96] = 0xf4e4, [0xde97] = 0xf4e5, [0xde98] = 0xf4e6, [0xde99] = 0xf4e7,
  [0xde9a] = 0xf4e8, [0xde9b] = 0xf4e9, [0xde9c] = 0xf4ea, [0xde9d] = 0xf4eb,
  [0xde9e] = 0xf4ec, [0xde9f] = 0xf4ed, [0xdea0] = 0xf4ee, [0xdea1] = 0xf4ef,
  [0xdea2] = 0xf4f0, [0xdea3] = 0xf4f1, [0xdea4] = 0xf4f2, [0xdea5] = 0xf4f3,
  [0xdea6] = 0xf4f4, [0xdea7] = 0xf4f5, [0xdea8] = 0xf4f6, [0xdea9] = 0xf4f7,
  [0xdeaa] = 0xf4f8, [0xdeab] = 0xf4f9, [0xdeac] = 0xf4fa, [0xdead] = 0xf4fb,
  [0xdeae] = 0xf4fc, [0xdeaf] = 0xf4fd, [0xdeb0] = 0xf4fe, [0xdeb1] = 0xf4ff,
  [0xdeb2] = 0xf500, [0xdeb3] = 0xf501, [0xdeb4] = 0xf502, [0xdeb5] = 0xf503,
  [0xdeb6] = 0xf504, [0xdeb7] = 0xf505, [0xdeb8] = 0xf506, [0xdeb9] = 0xf507,
  [0xdeba] = 0xf508, [0xdebb] = 0xf509, [0xdebc] = 0xf50a, [0xdebd] = 0xf50b,
  [0xdebe] = 0xf50c, [0xdebf] = 0xf50d, [0xdec0] = 0xf50e, [0xdec1] = 0xf50f,
  [0xdec2] = 0xf510, [0xdec3] = 0xf511, [0xdec4] = 0xf512, [0xdec5] = 0xf513,
  [0xdec6] = 0xf514, [0xdec7] = 0xf515, [0xdec8] = 0xf516, [0xdec9] = 0xf517,
  [0xdeca] = 0xf518, [0xdecb] = 0xf519, [0xdecc] = 0xf51a, [0xdecd] = 0xf51b,
  [0xdece] = 0xf51c, [0xdecf] = 0xf51d, [0xded0] = 0xf51e, [0xded1] = 0xf51f,
  [0xded2] = 0xf520, [0xded3] = 0xf521, [0xded4] = 0xf522, [0xded5] = 0xf523,
  [0xded6] = 0xf524, [0xded7] = 0xf525, [0xded8] = 0xf526, [0xded9] = 0xf527,
  [0xdeda] = 0xf528, [0xdedb] = 0xf529, [0xdedc] = 0xf52a, [0xdedd] = 0xf52b,
  [0xdede] = 0xf52c, [0xdedf] = 0xf52d, [0xdee0] = 0xf52e, [0xdee1] = 0xf52f,
  [0xdee2] = 0xf530, [0xdee3] = 0xf531, [0xdee4] = 0xf532, [0xdee5] = 0xf533,
  [0xdee6] = 0xf534, [0xdee7] = 0xf535, [0xdee8] = 0xf536, [0xdee9] = 0xf537,
  [0xdeea] = 0xf538, [0xdeeb] = 0xf539, [0xdeec] = 0xf53a, [0xdeed] = 0xf53b,
  [0xdeee] = 0xf53c, [0xdeef] = 0xf53d, [0xdef0] = 0xf53e, [0xdef1] = 0xf53f,
  [0xdef2] = 0xf540, [0xdef3] = 0xf541, [0xdef4] = 0xf542, [0xdef5] = 0xf543,
  [0xdef6] = 0xf544, [0xdef7] = 0xf545, [0xdef8] = 0xf546, [0xdef9] = 0xf547,
  [0xdefa] = 0xf548, [0xdefb] = 0xf549, [0xdefc] = 0xf54a, [0xdefd] = 0xf54b,
  [0xdf41] = 0xf54c, [0xdf42] = 0xf54d, [0xdf43] = 0xf54e, [0xdf44] = 0xf54f,
  [0xdf45] = 0xf550, [0xdf46] = 0xf551, [0xdf47] = 0xf552, [0xdf48] = 0xf553,
  [0xdf49] = 0xf554, [0xdf4a] = 0xf555, [0xdf4b] = 0xf556, [0xdf4c] = 0xf557,
  [0xdf4d] = 0xf558, [0xdf4e] = 0xf559, [0xdf4f] = 0xf55a, [0xdf50] = 0xf55b,
  [0xdf51] = 0xf55c, [0xdf52] = 0xf55d, [0xdf53] = 0xf55e, [0xdf54] = 0xf55f,
  [0xdf55] = 0xf560, [0xdf56] = 0xf561, [0xdf57] = 0xf562, [0xdf58] = 0xf563,
  [0xdf59] = 0xf564, [0xdf5a] = 0xf565, [0xdf5b] = 0xf566, [0xdf5c] = 0xf567,
  [0xdf5d] = 0xf568, [0xdf5e] = 0xf569, [0xdf5f] = 0xf56a, [0xdf60] = 0xf56b,
  [0xdf61] = 0xf56c, [0xdf62] = 0xf56d, [0xdf63] = 0xf56e, [0xdf64] = 0xf56f,
  [0xdf65] = 0xf570, [0xdf66] = 0xf571, [0xdf67] = 0xf572, [0xdf68] = 0xf573,
  [0xdf69] = 0xf574, [0xdf6a] = 0xf575, [0xdf6b] = 0xf576, [0xdf6c] = 0xf577,
  [0xdf6d] = 0xf578, [0xdf6e] = 0xf579, [0xdf6f] = 0xf57a, [0xdf70] = 0xf57b,
  [0xdf71] = 0xf57c, [0xdf72] = 0xf57d, [0xdf73] = 0xf57e, [0xdf74] = 0xf57f,
  [0xdf75] = 0xf580, [0xdf76] = 0xf581, [0xdf77] = 0xf582, [0xdf78] = 0xf583,
  [0xdf79] = 0xf584, [0xdf7a] = 0xf585, [0xdf7b] = 0xf586, [0xdf7c] = 0xf587,
  [0xdf7d] = 0xf588, [0xdf7e] = 0xf589, [0xdf7f] = 0xf58a, [0xdf81] = 0xf58b,
  [0xdf82] = 0xf58c, [0xdf83] = 0xf58d, [0xdf84] = 0xf58e, [0xdf85] = 0xf58f,
  [0xdf86] = 0xf590, [0xdf87] = 0xf591, [0xdf88] = 0xf592, [0xdf89] = 0xf593,
  [0xdf8a] = 0xf594, [0xdf8b] = 0xf595, [0xdf8c] = 0xf596, [0xdf8d] = 0xf597,
  [0xdf8e] = 0xf598, [0xdf8f] = 0xf599, [0xdf90] = 0xf59a, [0xdf91] = 0xf59b,
  [0xdf92] = 0xf59c, [0xdf93] = 0xf59d, [0xdf94] = 0xf59e, [0xdf95] = 0xf59f,
  [0xdf96] = 0xf5a0, [0xdf97] = 0xf5a1, [0xdf98] = 0xf5a2, [0xdf99] = 0xf5a3,
  [0xdf9a] = 0xf5a4, [0xdf9b] = 0xf5a5, [0xdf9c] = 0xf5a6, [0xdf9d] = 0xf5a7,
  [0xdf9e] = 0xf5a8, [0xdf9f] = 0xf5a9, [0xdfa0] = 0xf5aa, [0xdfa1] = 0xf5ab,
  [0xdfa2] = 0xf5ac, [0xdfa3] = 0xf5ad, [0xdfa4] = 0xf5ae, [0xdfa5] = 0xf5af,
  [0xdfa6] = 0xf5b0, [0xdfa7] = 0xf5b1, [0xdfa8] = 0xf5b2, [0xdfa9] = 0xf5b3,
  [0xdfaa] = 0xf5b4, [0xdfab] = 0xf5b5, [0xdfac] = 0xf5b6, [0xdfad] = 0xf5b7,
  [0xdfae] = 0xf5b8, [0xdfaf] = 0xf5b9, [0xdfb0] = 0xf5ba, [0xdfb1] = 0xf5bb,
  [0xdfb2] = 0xf5bc, [0xdfb3] = 0xf5bd, [0xdfb4] = 0xf5be, [0xdfb5] = 0xf5bf,
  [0xdfb6] = 0xf5c0, [0xdfb7] = 0xf5c1, [0xdfb8] = 0xf5c2, [0xdfb9] = 0xf5c3,
  [0xdfba] = 0xf5c4, [0xdfbb] = 0xf5c5, [0xdfbc] = 0xf5c6, [0xdfbd] = 0xf5c7,
  [0xdfbe] = 0xf5c8, [0xdfbf] = 0xf5c9, [0xdfc0] = 0xf5ca, [0xdfc1] = 0xf5cb,
  [0xdfc2] = 0xf5cc, [0xdfc3] = 0xf5cd, [0xdfc4] = 0xf5ce, [0xdfc5] = 0xf5cf,
  [0xdfc6] = 0xf5d0, [0xdfc7] = 0xf5d1, [0xdfc8] = 0xf5d2, [0xdfc9] = 0xf5d3,
  [0xdfca] = 0xf5d4, [0xdfcb] = 0xf5d5, [0xdfcc] = 0xf5d6, [0xdfcd] = 0xf5d7,
  [0xdfce] = 0xf5d8, [0xdfcf] = 0xf5d9, [0xdfd0] = 0xf5da, [0xdfd1] = 0xf5db,
  [0xdfd2] = 0xf5dc, [0xdfd3] = 0xf5dd, [0xdfd4] = 0xf5de, [0xdfd5] = 0xf5df,
  [0xdfd6] = 0xf5e0, [0xdfd7] = 0xf5e1, [0xdfd8] = 0xf5e2, [0xdfd9] = 0xf5e3,
  [0xdfda] = 0xf5e4, [0xdfdb] = 0xf5e5, [0xdfdc] = 0xf5e6, [0xdfdd] = 0xf5e7,
  [0xdfde] = 0xf5e8, [0xdfdf] = 0xf5e9, [0xdfe0] = 0xf5ea, [0xdfe1] = 0xf5eb,
  [0xdfe2] = 0xf5ec, [0xdfe3] = 0xf5ed, [0xdfe4] = 0xf5ee, [0xdfe5] = 0xf5ef,
  [0xdfe6] = 0xf5f0, [0xdfe7] = 0xf5f1, [0xdfe8] = 0xf5f2, [0xdfe9] = 0xf5f3,
  [0xdfea] = 0xf5f4, [0xdfeb] = 0xf5f5, [0xdfec] = 0xf5f6, [0xdfed] = 0xf5f7,
  [0xdfee] = 0xf5f8, [0xdfef] = 0xf5f9, [0xdff0] = 0xf5fa, [0xdff1] = 0xf5fb,
  [0xdff2] = 0xf5fc, [0xdff3] = 0xf5fd, [0xdff4] = 0xf5fe, [0xdff5] = 0xf5ff,
  [0xdff6] = 0xf600, [0xdff7] = 0xf601, [0xdff8] = 0xf602, [0xdff9] = 0xf603,
  [0xdffa] = 0xf604, [0xdffb] = 0xf605, [0xdffc] = 0xf606, [0xdffd] = 0xf607,
  [0xe041] = 0xf608, [0xe042] = 0xf609, [0xe043] = 0xf60a, [0xe044] = 0xf60b,
  [0xe045] = 0xf60c, [0xe046] = 0xf60d, [0xe047] = 0xf60e, [0xe048] = 0xf60f,
  [0xe049] = 0xf610, [0xe04a] = 0xf611, [0xe04b] = 0xf612, [0xe04c] = 0xf613,
  [0xe04d] = 0xf614, [0xe04e] = 0xf615, [0xe04f] = 0xf616, [0xe050] = 0xf617,
  [0xe051] = 0xf618, [0xe052] = 0xf619, [0xe053] = 0xf61a, [0xe054] = 0xf61b,
  [0xe055] = 0xf61c, [0xe056] = 0xf61d, [0xe057] = 0xf61e, [0xe058] = 0xf61f,
  [0xe059] = 0xf620, [0xe05a] = 0xf621, [0xe05b] = 0xf622, [0xe05c] = 0xf623,
  [0xe05d] = 0xf624, [0xe05e] = 0xf625, [0xe05f] = 0xf626, [0xe060] = 0xf627,
  [0xe061] = 0xf628, [0xe062] = 0xf629, [0xe063] = 0xf62a, [0xe064] = 0xf62b,
  [0xe065] = 0xf62c, [0xe066] = 0xf62d, [0xe067] = 0xf62e, [0xe068] = 0xf62f,
  [0xe069] = 0xf630, [0xe06a] = 0xf631, [0xe06b] = 0xf632, [0xe06c] = 0xf633,
  [0xe06d] = 0xf634, [0xe06e] = 0xf635, [0xe06f] = 0xf636, [0xe070] = 0xf637,
  [0xe071] = 0xf638, [0xe072] = 0xf639, [0xe073] = 0xf63a, [0xe074] = 0xf63b,
  [0xe075] = 0xf63c, [0xe076] = 0xf63d, [0xe077] = 0xf63e, [0xe078] = 0xf63f,
  [0xe079] = 0xf640, [0xe07a] = 0xf641, [0xe07b] = 0xf642, [0xe07c] = 0xf643,
  [0xe07d] = 0xf644, [0xe07e] = 0xf645, [0xe07f] = 0xf646, [0xe081] = 0xf647,
  [0xe082] = 0xf648, [0xe083] = 0xf649, [0xe084] = 0xf64a, [0xe085] = 0xf64b,
  [0xe086] = 0xf64c, [0xe087] = 0xf64d, [0xe088] = 0xf64e, [0xe089] = 0xf64f,
  [0xe08a] = 0xf650, [0xe08b] = 0xf651, [0xe08c] = 0xf652, [0xe08d] = 0xf653,
  [0xe08e] = 0xf654, [0xe08f] = 0xf655, [0xe090] = 0xf656, [0xe091] = 0xf657,
  [0xe092] = 0xf658, [0xe093] = 0xf659, [0xe094] = 0xf65a, [0xe095] = 0xf65b,
  [0xe096] = 0xf65c, [0xe097] = 0xf65d, [0xe098] = 0xf65e, [0xe099] = 0xf65f,
  [0xe09a] = 0xf660, [0xe09b] = 0xf661, [0xe09c] = 0xf662, [0xe09d] = 0xf663,
  [0xe09e] = 0xf664, [0xe09f] = 0xf665, [0xe0a0] = 0xf666, [0xe0a1] = 0xf667,
  [0xe0a2] = 0xf668, [0xe0a3] = 0xf669, [0xe0a4] = 0xf66a, [0xe0a5] = 0xf66b,
  [0xe0a6] = 0xf66c, [0xe0a7] = 0xf66d, [0xe0a8] = 0xf66e, [0xe0a9] = 0xf66f,
  [0xe0aa] = 0xf670, [0xe0ab] = 0xf671, [0xe0ac] = 0xf672, [0xe0ad] = 0xf673,
  [0xe0ae] = 0xf674, [0xe0af] = 0xf675, [0xe0b0] = 0xf676, [0xe0b1] = 0xf677,
  [0xe0b2] = 0xf678, [0xe0b3] = 0xf679, [0xe0b4] = 0xf67a, [0xe0b5] = 0xf67b,
  [0xe0b6] = 0xf67c, [0xe0b7] = 0xf67d, [0xe0b8] = 0xf67e, [0xe0b9] = 0xf67f,
  [0xe0ba] = 0xf680, [0xe0bb] = 0xf681, [0xe0bc] = 0xf682, [0xe0bd] = 0xf683,
  [0xe0be] = 0xf684, [0xe0bf] = 0xf685, [0xe0c0] = 0xf686, [0xe0c1] = 0xf687,
  [0xe0c2] = 0xf688, [0xe0c3] = 0xf689, [0xe0c4] = 0xf68a, [0xe0c5] = 0xf68b,
  [0xe0c6] = 0xf68c, [0xe0c7] = 0xf68d, [0xe0c8] = 0xf68e, [0xe0c9] = 0xf68f,
  [0xe0ca] = 0xf690, [0xe0cb] = 0xf691, [0xe0cc] = 0xf692, [0xe0cd] = 0xf693,
  [0xe0ce] = 0xf694, [0xe0cf] = 0xf695, [0xe0d0] = 0xf696, [0xe0d1] = 0xf697,
  [0xe0d2] = 0xf698, [0xe0d3] = 0xf699, [0xe0d4] = 0xf69a, [0xe0d5] = 0xf69b,
  [0xe0d6] = 0xf69c, [0xe0d7] = 0xf69d, [0xe0d8] = 0xf69e, [0xe0d9] = 0xf69f,
  [0xe0da] = 0xf6a0, [0xe0db] = 0xf6a1, [0xe0dc] = 0xf6a2, [0xe0dd] = 0xf6a3,
  [0xe0de] = 0xf6a4, [0xe0df] = 0xf6a5, [0xe0e0] = 0xf6a6, [0xe0e1] = 0xf6a7,
  [0xe0e2] = 0xf6a8, [0xe0e3] = 0xf6a9, [0xe0e4] = 0xf6aa, [0xe0e5] = 0xf6ab,
  [0xe0e6] = 0xf6ac, [0xe0e7] = 0xf6ad, [0xe0e8] = 0xf6ae, [0xe0e9] = 0xf6af,
  [0xe0ea] = 0xf6b0, [0xe0eb] = 0xf6b1, [0xe0ec] = 0xf6b2, [0xe0ed] = 0xf6b3,
  [0xe0ee] = 0xf6b4, [0xe0ef] = 0xf6b5, [0xe0f0] = 0xf6b6, [0xe0f1] = 0xf6b7,
  [0xe0f2] = 0xf6b8, [0xe0f3] = 0xf6b9, [0xe0f4] = 0xf6ba, [0xe0f5] = 0xf6bb,
  [0xe0f6] = 0xf6bc, [0xe0f7] = 0xf6bd, [0xe0f8] = 0xf6be, [0xe0f9] = 0xf6bf,
  [0xe0fa] = 0xf6c0, [0xe0fb] = 0xf6c1, [0xe0fc] = 0xf6c2, [0xe0fd] = 0xf6c3,
  [0xe141] = 0xf6c4, [0xe142] = 0xf6c5, [0xe143] = 0xf6c6, [0xe144] = 0xf6c7,
  [0xe145] = 0xf6c8, [0xe146] = 0xf6c9, [0xe147] = 0xf6ca, [0xe148] = 0xf6cb,
  [0xe149] = 0xf6cc, [0xe14a] = 0xf6cd, [0xe14b] = 0xf6ce, [0xe14c] = 0xf6cf,
  [0xe14d] = 0xf6d0, [0xe14e] = 0xf6d1, [0xe14f] = 0xf6d2, [0xe150] = 0xf6d3,
  [0xe151] = 0xf6d4, [0xe152] = 0xf6d5, [0xe153] = 0xf6d6, [0xe154] = 0xf6d7,
  [0xe155] = 0xf6d8, [0xe156] = 0xf6d9, [0xe157] = 0xf6da, [0xe158] = 0xf6db,
  [0xe159] = 0xf6dc, [0xe15a] = 0xf6dd, [0xe15b] = 0xf6de, [0xe15c] = 0xf6df,
  [0xe15d] = 0xf6e0, [0xe15e] = 0xf6e1, [0xe15f] = 0xf6e2, [0xe160] = 0xf6e3,
  [0xe161] = 0xf6e4, [0xe162] = 0xf6e5, [0xe163] = 0xf6e6, [0xe164] = 0xf6e7,
  [0xe165] = 0xf6e8, [0xe166] = 0xf6e9, [0xe167] = 0xf6ea, [0xe168] = 0xf6eb,
  [0xe169] = 0xf6ec, [0xe16a] = 0xf6ed, [0xe16b] = 0xf6ee, [0xe16c] = 0xf6ef,
  [0xe16d] = 0xf6f0, [0xe16e] = 0xf6f1, [0xe16f] = 0xf6f2, [0xe170] = 0xf6f3,
  [0xe171] = 0xf6f4, [0xe172] = 0xf6f5, [0xe173] = 0xf6f6, [0xe174] = 0xf6f7,
  [0xe175] = 0xf6f8, [0xe176] = 0xf6f9, [0xe177] = 0xf6fa, [0xe178] = 0xf6fb,
  [0xe179] = 0xf6fc, [0xe17a] = 0xf6fd, [0xe17b] = 0xf6fe, [0xe17c] = 0xf6ff,
  [0xe17d] = 0xf700, [0xe17e] = 0xf701, [0xe17f] = 0xf702, [0xe181] = 0xf703,
  [0xe182] = 0xf704, [0xe183] = 0xf705, [0xe184] = 0xf706, [0xe185] = 0xf707,
  [0xe186] = 0xf708, [0xe187] = 0xf709, [0xe188] = 0xf70a, [0xe189] = 0xf70b,
  [0xe18a] = 0xf70c, [0xe18b] = 0xf70d, [0xe18c] = 0xf70e, [0xe18d] = 0xf70f,
  [0xe18e] = 0xf710, [0xe18f] = 0xf711, [0xe190] = 0xf712, [0xe191] = 0xf713,
  [0xe192] = 0xf714, [0xe193] = 0xf715, [0xe194] = 0xf716, [0xe195] = 0xf717,
  [0xe196] = 0xf718, [0xe197] = 0xf719, [0xe198] = 0xf71a, [0xe199] = 0xf71b,
  [0xe19a] = 0xf71c, [0xe19b] = 0xf71d, [0xe19c] = 0xf71e, [0xe19d] = 0xf71f,
  [0xe19e] = 0xf720, [0xe19f] = 0xf721, [0xe1a0] = 0xf722, [0xe1a1] = 0xf723,
  [0xe1a2] = 0xf724, [0xe1a3] = 0xf725, [0xe1a4] = 0xf726, [0xe1a5] = 0xf727,
  [0xe1a6] = 0xf728, [0xe1a7] = 0xf729, [0xe1a8] = 0xf72a, [0xe1a9] = 0xf72b,
  [0xe1aa] = 0xf72c, [0xe1ab] = 0xf72d, [0xe1ac] = 0xf72e, [0xe1ad] = 0xf72f,
  [0xe1ae] = 0xf730, [0xe1af] = 0xf731, [0xe1b0] = 0xf732, [0xe1b1] = 0xf733,
  [0xe1b2] = 0xf734, [0xe1b3] = 0xf735, [0xe1b4] = 0xf736, [0xe1b5] = 0xf737,
  [0xe1b6] = 0xf738, [0xe1b7] = 0xf739, [0xe1b8] = 0xf73a, [0xe1b9] = 0xf73b,
  [0xe1ba] = 0xf73c, [0xe1bb] = 0xf73d, [0xe1bc] = 0xf73e, [0xe1bd] = 0xf73f,
  [0xe1be] = 0xf740, [0xe1bf] = 0xf741, [0xe1c0] = 0xf742, [0xe1c1] = 0xf743,
  [0xe1c2] = 0xf744, [0xe1c3] = 0xf745, [0xe1c4] = 0xf746, [0xe1c5] = 0xf747,
  [0xe1c6] = 0xf748, [0xe1c7] = 0xf749, [0xe1c8] = 0xf74a, [0xe1c9] = 0xf74b,
  [0xe1ca] = 0xf74c, [0xe1cb] = 0xf74d, [0xe1cc] = 0xf74e, [0xe1cd] = 0xf74f,
  [0xe1ce] = 0xf750, [0xe1cf] = 0xf751, [0xe1d0] = 0xf752, [0xe1d1] = 0xf753,
  [0xe1d2] = 0xf754, [0xe1d3] = 0xf755, [0xe1d4] = 0xf756, [0xe1d5] = 0xf757,
  [0xe1d6] = 0xf758, [0xe1d7] = 0xf759, [0xe1d8] = 0xf75a, [0xe1d9] = 0xf75b,
  [0xe1da] = 0xf75c, [0xe1db] = 0xf75d, [0xe1dc] = 0xf75e, [0xe1dd] = 0xf75f,
  [0xe1de] = 0xf760, [0xe1df] = 0xf761, [0xe1e0] = 0xf762, [0xe1e1] = 0xf763,
  [0xe1e2] = 0xf764, [0xe1e3] = 0xf765, [0xe1e4] = 0xf766, [0xe1e5] = 0xf767,
  [0xe1e6] = 0xf768, [0xe1e7] = 0xf769, [0xe1e8] = 0xf76a, [0xe1e9] = 0xf76b,
  [0xe1ea] = 0xf76c, [0xe1eb] = 0xf76d, [0xe1ec] = 0xf76e, [0xe1ed] = 0xf76f,
  [0xe1ee] = 0xf770, [0xe1ef] = 0xf771, [0xe1f0] = 0xf772, [0xe1f1] = 0xf773,
  [0xe1f2] = 0xf774, [0xe1f3] = 0xf775, [0xe1f4] = 0xf776, [0xe1f5] = 0xf777,
  [0xe1f6] = 0xf778, [0xe1f7] = 0xf779, [0xe1f8] = 0xf77a, [0xe1f9] = 0xf77b,
  [0xe1fa] = 0xf77c, [0xe1fb] = 0xf77d, [0xe1fc] = 0xf77e, [0xe1fd] = 0xf77f,
  [0xe241] = 0xf780, [0xe242] = 0xf781, [0xe243] = 0xf782, [0xe244] = 0xf783,
  [0xe245] = 0xf784, [0xe246] = 0xf785, [0xe247] = 0xf786, [0xe248] = 0xf787,
  [0xe249] = 0xf788, [0xe24a] = 0xf789, [0xe24b] = 0xf78a, [0xe24c] = 0xf78b,
  [0xe24d] = 0xf78c, [0xe24e] = 0xf78d, [0xe24f] = 0xf78e, [0xe250] = 0xf78f,
  [0xe251] = 0xf790, [0xe252] = 0xf791, [0xe253] = 0xf792, [0xe254] = 0xf793,
  [0xe255] = 0xf794, [0xe256] = 0xf795, [0xe257] = 0xf796, [0xe258] = 0xf797,
  [0xe259] = 0xf798, [0xe25a] = 0xf799, [0xe25b] = 0xf79a, [0xe25c] = 0xf79b,
  [0xe25d] = 0xf79c, [0xe25e] = 0xf79d, [0xe25f] = 0xf79e, [0xe260] = 0xf79f,
  [0xe261] = 0xf7a0, [0xe262] = 0xf7a1, [0xe263] = 0xf7a2, [0xe264] = 0xf7a3,
  [0xe265] = 0xf7a4, [0xe266] = 0xf7a5, [0xe267] = 0xf7a6, [0xe268] = 0xf7a7,
  [0xe269] = 0xf7a8, [0xe26a] = 0xf7a9, [0xe26b] = 0xf7aa, [0xe26c] = 0xf7ab,
  [0xe26d] = 0xf7ac, [0xe26e] = 0xf7ad, [0xe26f] = 0xf7ae, [0xe270] = 0xf7af,
  [0xe271] = 0xf7b0, [0xe272] = 0xf7b1, [0xe273] = 0xf7b2, [0xe274] = 0xf7b3,
  [0xe275] = 0xf7b4, [0xe276] = 0xf7b5, [0xe277] = 0xf7b6, [0xe278] = 0xf7b7,
  [0xe279] = 0xf7b8, [0xe27a] = 0xf7b9, [0xe27b] = 0xf7ba, [0xe27c] = 0xf7bb,
  [0xe27d] = 0xf7bc, [0xe27e] = 0xf7bd, [0xe27f] = 0xf7be, [0xe281] = 0xf7bf,
  [0xe282] = 0xf7c0, [0xe283] = 0xf7c1, [0xe284] = 0xf7c2, [0xe285] = 0xf7c3,
  [0xe286] = 0xf7c4, [0xe287] = 0xf7c5, [0xe288] = 0xf7c6, [0xe289] = 0xf7c7,
  [0xe28a] = 0xf7c8, [0xe28b] = 0xf7c9, [0xe28c] = 0xf7ca, [0xe28d] = 0xf7cb,
  [0xe28e] = 0xf7cc, [0xe28f] = 0xf7cd, [0xe290] = 0xf7ce, [0xe291] = 0xf7cf,
  [0xe292] = 0xf7d0, [0xe293] = 0xf7d1, [0xe294] = 0xf7d2, [0xe295] = 0xf7d3,
  [0xe296] = 0xf7d4, [0xe297] = 0xf7d5, [0xe298] = 0xf7d6, [0xe299] = 0xf7d7,
  [0xe29a] = 0xf7d8, [0xe29b] = 0xf7d9, [0xe29c] = 0xf7da, [0xe29d] = 0xf7db,
  [0xe29e] = 0xf7dc, [0xe29f] = 0xf7dd, [0xe2a0] = 0xf7de, [0xe2a1] = 0xf7df,
  [0xe2a2] = 0xf7e0, [0xe2a3] = 0xf7e1, [0xe2a4] = 0xf7e2, [0xe2a5] = 0xf7e3,
  [0xe2a6] = 0xf7e4, [0xe2a7] = 0xf7e5, [0xe2a8] = 0xf7e6, [0xe2a9] = 0xf7e7,
  [0xe2aa] = 0xf7e8, [0xe2ab] = 0xf7e9, [0xe2ac] = 0xf7ea, [0xe2ad] = 0xf7eb,
  [0xe2ae] = 0xf7ec, [0xe2af] = 0xf7ed, [0xe2b0] = 0xf7ee, [0xe2b1] = 0xf7ef,
  [0xe2b2] = 0xf7f0, [0xe2b3] = 0xf7f1, [0xe2b4] = 0xf7f2, [0xe2b5] = 0xf7f3,
  [0xe2b6] = 0xf7f4, [0xe2b7] = 0xf7f5, [0xe2b8] = 0xf7f6, [0xe2b9] = 0xf7f7,
  [0xe2ba] = 0xf7f8, [0xe2bb] = 0xf7f9, [0xe2bc] = 0xf7fa, [0xe2bd] = 0xf7fb,
  [0xe2be] = 0xf7fc, [0xe2bf] = 0xf7fd, [0xe2c0] = 0xf7fe, [0xe2c1] = 0xf7ff,
  [0xe2c2] = 0xf800, [0xe2c3] = 0xf801, [0xe2c4] = 0xf802, [0xe2c5] = 0xf803,
  [0xe2c6] = 0xf804, [0xe2c7] = 0xf805, [0xe2c8] = 0xf806, [0xe2c9] = 0xf807,
  [0xe2ca] = 0xf808, [0xe2cb] = 0xf809, [0xe2cc] = 0xf80a, [0xe2cd] = 0xf80b,
  [0xe2ce] = 0xf80c, [0xe2cf] = 0xf80d, [0xe2d0] = 0xf80e, [0xe2d1] = 0xf80f,
  [0xe2d2] = 0xf810, [0xe2d3] = 0xf811, [0xe2d4] = 0xf812, [0xe2d5] = 0xf813,
  [0xe2d6] = 0xf814, [0xe2d7] = 0xf815, [0xe2d8] = 0xf816, [0xe2d9] = 0xf817,
  [0xe2da] = 0xf818, [0xe2db] = 0xf819, [0xe2dc] = 0xf81a, [0xe2dd] = 0xf81b,
  [0xe2de] = 0xf81c, [0xe2df] = 0xf81d, [0xe2e0] = 0xf81e, [0xe2e1] = 0xf81f,
  [0xe2e2] = 0xf820, [0xe2e3] = 0xf821, [0xe2e4] = 0xf822, [0xe2e5] = 0xf823,
  [0xe2e6] = 0xf824, [0xe2e7] = 0xf825, [0xe2e8] = 0xf826, [0xe2e9] = 0xf827,
  [0xe2ea] = 0xf828, [0xe2eb] = 0xf829, [0xe2ec] = 0xf82a, [0xe2ed] = 0xf82b,
  [0xe2ee] = 0xf82c, [0xe2ef] = 0xf82d, [0xe2f0] = 0xf82e, [0xe2f1] = 0xf82f,
  [0xe2f2] = 0xf830, [0xe2f3] = 0xf831, [0xe2f4] = 0xf832, [0xe2f5] = 0xf833,
  [0xe2f6] = 0xf834, [0xe2f7] = 0xf835, [0xe2f8] = 0xf836, [0xe2f9] = 0xf837,
  [0xe2fa] = 0xf838, [0xe2fb] = 0xf839, [0xe2fc] = 0xf83a, [0xe2fd] = 0xf83b
};

static const char __ucs4_to_ibm937sb[][1] =
{
  [0x0000] = "\x00", [0x0001] = "\x01", [0x0002] = "\x02", [0x0003] = "\x03",
  [0x0004] = "\x37", [0x0005] = "\x2d", [0x0006] = "\x2e", [0x0007] = "\x2f",
  [0x0008] = "\x16", [0x0009] = "\x05", [0x000a] = "\x25", [0x000b] = "\x0b",
  [0x000c] = "\x0c", [0x000d] = "\x0d", [0x000e] = "\x3f", [0x000f] = "\x3f",
  [0x0010] = "\x10", [0x0011] = "\x11", [0x0012] = "\x12", [0x0013] = "\x13",
  [0x0014] = "\x3c", [0x0015] = "\x3d", [0x0016] = "\x32", [0x0017] = "\x26",
  [0x0018] = "\x18", [0x0019] = "\x19", [0x001a] = "\x3f", [0x001b] = "\x27",
  [0x001c] = "\x1c", [0x001d] = "\x1d", [0x001e] = "\x1e", [0x001f] = "\x1f",
  [0x0020] = "\x40", [0x0021] = "\x5a", [0x0022] = "\x7f", [0x0023] = "\x7b",
  [0x0024] = "\x5b", [0x0025] = "\x6c", [0x0026] = "\x50", [0x0027] = "\x7d",
  [0x0028] = "\x4d", [0x0029] = "\x5d", [0x002a] = "\x5c", [0x002b] = "\x4e",
  [0x002c] = "\x6b", [0x002d] = "\x60", [0x002e] = "\x4b", [0x002f] = "\x61",
  [0x0030] = "\xf0", [0x0031] = "\xf1", [0x0032] = "\xf2", [0x0033] = "\xf3",
  [0x0034] = "\xf4", [0x0035] = "\xf5", [0x0036] = "\xf6", [0x0037] = "\xf7",
  [0x0038] = "\xf8", [0x0039] = "\xf9", [0x003a] = "\x7a", [0x003b] = "\x5e",
  [0x003c] = "\x4c", [0x003d] = "\x7e", [0x003e] = "\x6e", [0x003f] = "\x6f",
  [0x0040] = "\x7c", [0x0041] = "\xc1", [0x0042] = "\xc2", [0x0043] = "\xc3",
  [0x0044] = "\xc4", [0x0045] = "\xc5", [0x0046] = "\xc6", [0x0047] = "\xc7",
  [0x0048] = "\xc8", [0x0049] = "\xc9", [0x004a] = "\xd1", [0x004b] = "\xd2",
  [0x004c] = "\xd3", [0x004d] = "\xd4", [0x004e] = "\xd5", [0x004f] = "\xd6",
  [0x0050] = "\xd7", [0x0051] = "\xd8", [0x0052] = "\xd9", [0x0053] = "\xe2",
  [0x0054] = "\xe3", [0x0055] = "\xe4", [0x0056] = "\xe5", [0x0057] = "\xe6",
  [0x0058] = "\xe7", [0x0059] = "\xe8", [0x005a] = "\xe9", [0x005b] = "\xba",
  [0x005c] = "\xe0", [0x005d] = "\xbb", [0x005e] = "\xb0", [0x005f] = "\x6d",
  [0x0060] = "\x79", [0x0061] = "\x81", [0x0062] = "\x82", [0x0063] = "\x83",
  [0x0064] = "\x84", [0x0065] = "\x85", [0x0066] = "\x86", [0x0067] = "\x87",
  [0x0068] = "\x88", [0x0069] = "\x89", [0x006a] = "\x91", [0x006b] = "\x92",
  [0x006c] = "\x93", [0x006d] = "\x94", [0x006e] = "\x95", [0x006f] = "\x96",
  [0x0070] = "\x97", [0x0071] = "\x98", [0x0072] = "\x99", [0x0073] = "\xa2",
  [0x0074] = "\xa3", [0x0075] = "\xa4", [0x0076] = "\xa5", [0x0077] = "\xa6",
  [0x0078] = "\xa7", [0x0079] = "\xa8", [0x007a] = "\xa9", [0x007b] = "\xc0",
  [0x007c] = "\x4f", [0x007d] = "\xd0", [0x007e] = "\xa1", [0x007f] = "\x07",
  [0x0080] = "\x20", [0x0081] = "\x21", [0x0082] = "\x22", [0x0083] = "\x23",
  [0x0084] = "\x24", [0x0085] = "\x15", [0x0086] = "\x06", [0x0087] = "\x17",
  [0x0088] = "\x28", [0x0089] = "\x29", [0x008a] = "\x2a", [0x008b] = "\x2b",
  [0x008c] = "\x2c", [0x008d] = "\x09", [0x008e] = "\x0a", [0x008f] = "\x1b",
  [0x0090] = "\x30", [0x0091] = "\x31", [0x0092] = "\x1a", [0x0093] = "\x33",
  [0x0094] = "\x34", [0x0095] = "\x35", [0x0096] = "\x36", [0x0097] = "\x08",
  [0x0098] = "\x38", [0x0099] = "\x39", [0x009a] = "\x3a", [0x009b] = "\x3b",
  [0x009c] = "\x04", [0x009d] = "\x14", [0x009e] = "\x3e", [0x009f] = "\xff",
  [0x00a0] = "\x3f", [0x00a1] = "\x3f", [0x00a2] = "\x4a", [0x00a3] = "\x3f",
  [0x00a4] = "\x3f", [0x00a5] = "\x3f", [0x00a6] = "\x6a", [0x00a9] = "\x3f",
  [0x00aa] = "\x3f", [0x00ab] = "\x3f", [0x00ac] = "\x5f", [0x00ad] = "\x3f",
  [0x00ae] = "\x3f", [0x00b2] = "\x3f", [0x00b3] = "\x3f", [0x00b5] = "\x3f",
  [0x00b8] = "\x3f", [0x00b9] = "\x3f", [0x00ba] = "\x3f", [0x00bb] = "\x3f",
  [0x00bc] = "\x3f", [0x00bd] = "\x3f", [0x00be] = "\x3f", [0x00bf] = "\x3f",
  [0x00c0] = "\x3f", [0x00c1] = "\x3f", [0x00c2] = "\x3f", [0x00c3] = "\x3f",
  [0x00c4] = "\x3f", [0x00c5] = "\x3f", [0x00c6] = "\x3f", [0x00c7] = "\x3f",
  [0x00c8] = "\x3f", [0x00c9] = "\x3f", [0x00ca] = "\x3f", [0x00cb] = "\x3f",
  [0x00cc] = "\x3f", [0x00cd] = "\x3f", [0x00ce] = "\x3f", [0x00cf] = "\x3f",
  [0x00d0] = "\x3f", [0x00d1] = "\x3f", [0x00d2] = "\x3f", [0x00d3] = "\x3f",
  [0x00d4] = "\x3f", [0x00d5] = "\x3f", [0x00d6] = "\x3f", [0x00d8] = "\x3f",
  [0x00d9] = "\x3f", [0x00da] = "\x3f", [0x00db] = "\x3f", [0x00dc] = "\x3f",
  [0x00dd] = "\x3f", [0x00de] = "\x3f", [0x00df] = "\x3f", [0x00e0] = "\x3f",
  [0x00e1] = "\x3f", [0x00e2] = "\x3f", [0x00e3] = "\x3f", [0x00e4] = "\x3f",
  [0x00e5] = "\x3f", [0x00e6] = "\x3f", [0x00e7] = "\x3f", [0x00e8] = "\x3f",
  [0x00e9] = "\x3f", [0x00ea] = "\x3f", [0x00eb] = "\x3f", [0x00ec] = "\x3f",
  [0x00ed] = "\x3f", [0x00ee] = "\x3f", [0x00ef] = "\x3f", [0x00f0] = "\x3f",
  [0x00f1] = "\x3f", [0x00f2] = "\x3f", [0x00f3] = "\x3f", [0x00f4] = "\x3f",
  [0x00f5] = "\x3f", [0x00f6] = "\x3f", [0x00f8] = "\x3f", [0x00f9] = "\x3f",
  [0x00fa] = "\x3f", [0x00fb] = "\x3f", [0x00fc] = "\x3f", [0x00fd] = "\x3f",
  [0x00fe] = "\x3f", [0x00ff] = "\x3f"
};

static const char __ucs4_to_ibm937db[][2] =
{
  [0x00a7] = "\x44\x6a", [0x00a8] = "\x44\x60", [0x00af] = "\x42\xa1",
  [0x00b0] = "\x44\xed", [0x00b1] = "\x44\x4b", [0x00b4] = "\x44\xee",
  [0x00b6] = "\x43\x79", [0x00b7] = "\x46\xe5", [0x00d7] = "\x44\x7a",
  [0x00f7] = "\x44\x7b", [0x02ba] = "\x44\x5b", [0x02c7] = "\x45\x53",
  [0x02c9] = "\x45\x51", [0x02ca] = "\x45\x52", [0x02cb] = "\x45\x54",
  [0x02cd] = "\x47\x52", [0x02d9] = "\x45\x55", [0x0391] = "\x41\x61",
  [0x0392] = "\x41\x62", [0x0393] = "\x41\x63", [0x0394] = "\x41\x64",
  [0x0395] = "\x41\x65", [0x0396] = "\x41\x66", [0x0397] = "\x41\x67",
  [0x0398] = "\x41\x68", [0x0399] = "\x41\x69", [0x039a] = "\x41\x6a",
  [0x039b] = "\x41\x6b", [0x039c] = "\x41\x6c", [0x039d] = "\x41\x6d",
  [0x039e] = "\x41\x6e", [0x039f] = "\x41\x6f", [0x03a0] = "\x41\x70",
  [0x03a1] = "\x41\x71", [0x03a3] = "\x41\x72", [0x03a4] = "\x41\x73",
  [0x03a5] = "\x41\x74", [0x03a6] = "\x41\x75", [0x03a7] = "\x41\x76",
  [0x03a8] = "\x41\x77", [0x03a9] = "\x41\x78", [0x03b1] = "\x41\x41",
  [0x03b2] = "\x41\x42", [0x03b3] = "\x41\x43", [0x03b4] = "\x41\x44",
  [0x03b5] = "\x41\x45", [0x03b6] = "\x41\x46", [0x03b7] = "\x41\x47",
  [0x03b8] = "\x41\x48", [0x03b9] = "\x41\x49", [0x03ba] = "\x41\x4a",
  [0x03bb] = "\x41\x4b", [0x03bc] = "\x41\x4c", [0x03bd] = "\x41\x4d",
  [0x03be] = "\x41\x4e", [0x03bf] = "\x41\x4f", [0x03c0] = "\x41\x50",
  [0x03c1] = "\x41\x51", [0x03c3] = "\x41\x52", [0x03c4] = "\x41\x53",
  [0x03c5] = "\x41\x54", [0x03c6] = "\x41\x55", [0x03c7] = "\x41\x56",
  [0x03c8] = "\x41\x57", [0x03c9] = "\x41\x58", [0x0401] = "\x41\xc6",
  [0x0410] = "\x41\xc0", [0x0411] = "\x41\xc1", [0x0412] = "\x41\xc2",
  [0x0413] = "\x41\xc3", [0x0414] = "\x41\xc4", [0x0415] = "\x41\xc5",
  [0x0416] = "\x41\xc7", [0x0417] = "\x41\xc8", [0x0418] = "\x41\xc9",
  [0x0419] = "\x41\xca", [0x041a] = "\x41\xcb", [0x041b] = "\x41\xcc",
  [0x041c] = "\x41\xcd", [0x041d] = "\x41\xce", [0x041e] = "\x41\xcf",
  [0x041f] = "\x41\xd0", [0x0420] = "\x41\xd1", [0x0421] = "\x41\xd2",
  [0x0422] = "\x41\xd3", [0x0423] = "\x41\xd4", [0x0424] = "\x41\xd5",
  [0x0425] = "\x41\xd6", [0x0426] = "\x41\xd7", [0x0427] = "\x41\xd8",
  [0x0428] = "\x41\xd9", [0x0429] = "\x41\xda", [0x042a] = "\x41\xdb",
  [0x042b] = "\x41\xdc", [0x042c] = "\x41\xdd", [0x042d] = "\x41\xde",
  [0x042e] = "\x41\xdf", [0x042f] = "\x41\xe0", [0x0430] = "\x41\x80",
  [0x0431] = "\x41\x81", [0x0432] = "\x41\x82", [0x0433] = "\x41\x83",
  [0x0434] = "\x41\x84", [0x0435] = "\x41\x85", [0x0436] = "\x41\x87",
  [0x0437] = "\x41\x88", [0x0438] = "\x41\x89", [0x0439] = "\x41\x8a",
  [0x043a] = "\x41\x8b", [0x043b] = "\x41\x8c", [0x043c] = "\x41\x8d",
  [0x043d] = "\x41\x8e", [0x043e] = "\x41\x8f", [0x043f] = "\x41\x90",
  [0x0440] = "\x41\x91", [0x0441] = "\x41\x92", [0x0442] = "\x41\x93",
  [0x0443] = "\x41\x94", [0x0444] = "\x41\x95", [0x0445] = "\x41\x96",
  [0x0446] = "\x41\x97", [0x0447] = "\x41\x98", [0x0448] = "\x41\x99",
  [0x0449] = "\x41\x9a", [0x044a] = "\x41\x9b", [0x044b] = "\x41\x9c",
  [0x044c] = "\x41\x9d", [0x044d] = "\x41\x9e", [0x044e] = "\x41\x9f",
  [0x044f] = "\x41\xa0", [0x0451] = "\x41\x86", [0x2010] = "\x44\x5a",
  [0x2013] = "\x44\x4a", [0x2014] = "\x44\x4a", [0x2018] = "\x44\x61",
  [0x2019] = "\x44\x71", [0x201c] = "\x44\x62", [0x201d] = "\x44\x72",
  [0x2020] = "\x43\x77", [0x2021] = "\x43\x78", [0x2025] = "\x44\x7e",
  [0x2026] = "\x44\x7f", [0x2027] = "\x43\x45", [0x2030] = "\x43\x73",
  [0x2032] = "\x44\x50", [0x2033] = "\x44\xef", [0x2035] = "\x42\x79",
  [0x203b] = "\x44\x6b", [0x203e] = "\x42\xa1", [0x2103] = "\x44\x4e",
  [0x2105] = "\x46\xbb", [0x2109] = "\x46\xdb", [0x2116] = "\x44\x6e",
  [0x2121] = "\x44\x6f", [0x212b] = "\x43\x72", [0x2160] = "\x41\xf1",
  [0x2161] = "\x41\xf2", [0x2162] = "\x41\xf3", [0x2163] = "\x41\xf4",
  [0x2164] = "\x41\xf5", [0x2165] = "\x41\xf6", [0x2166] = "\x41\xf7",
  [0x2167] = "\x41\xf8", [0x2168] = "\x41\xf9", [0x2169] = "\x41\xfa",
  [0x2170] = "\x41\xb1", [0x2171] = "\x41\xb2", [0x2172] = "\x41\xb3",
  [0x2173] = "\x41\xb4", [0x2174] = "\x41\xb5", [0x2175] = "\x41\xb6",
  [0x2176] = "\x41\xb7", [0x2177] = "\x41\xb8", [0x2178] = "\x41\xb9",
  [0x2179] = "\x41\xba", [0x2190] = "\x44\xf1", [0x2191] = "\x44\xf2",
  [0x2192] = "\x44\xf0", [0x2193] = "\x44\xf3", [0x2196] = "\x46\xd4",
  [0x2197] = "\x46\xd5", [0x2198] = "\x46\xd7", [0x2199] = "\x46\xd6",
  [0x21b8] = "\x46\xef", [0x21b9] = "\x46\xf0", [0x21d2] = "\x43\x6e",
  [0x21d4] = "\x43\x6f", [0x21e7] = "\x46\xee", [0x2200] = "\x43\x70",
  [0x2202] = "\x43\x4e", [0x2203] = "\x43\x71", [0x2207] = "\x43\x4f",
  [0x2208] = "\x43\x64", [0x220b] = "\x43\x65", [0x2215] = "\x46\xda",
  [0x221a] = "\x46\xc5", [0x221d] = "\x43\x61", [0x221e] = "\x44\x4d",
  [0x221f] = "\x46\xcc", [0x2220] = "\x46\xcb", [0x2223] = "\x42\x4f",
  [0x2225] = "\x44\x7c", [0x2227] = "\x43\x6c", [0x2228] = "\x43\x6d",
  [0x2229] = "\x46\xc8", [0x222a] = "\x46\xc9", [0x222b] = "\x46\xd0",
  [0x222c] = "\x43\x63", [0x222e] = "\x46\xd1", [0x2234] = "\x44\x68",
  [0x2235] = "\x44\x78", [0x223c] = "\x43\xa1", [0x223d] = "\x43\x60",
  [0x2252] = "\x46\xc6", [0x2260] = "\x44\x4c", [0x2261] = "\x46\xc7",
  [0x2266] = "\x44\x67", [0x2267] = "\x44\x77", [0x226a] = "\x43\x5d",
  [0x226b] = "\x43\x5e", [0x2282] = "\x43\x68", [0x2283] = "\x43\x69",
  [0x2286] = "\x43\x66", [0x2287] = "\x43\x67", [0x2295] = "\x46\xd2",
  [0x2299] = "\x46\xd3", [0x22a5] = "\x46\xca", [0x22bf] = "\x46\xcd",
  [0x2312] = "\x43\x4d", [0x2400] = "\x47\x81", [0x2401] = "\x47\x82",
  [0x2402] = "\x47\x83", [0x2403] = "\x47\x84", [0x2404] = "\x47\x85",
  [0x2405] = "\x47\x86", [0x2406] = "\x47\x87", [0x2407] = "\x47\x88",
  [0x2408] = "\x47\x89", [0x2409] = "\x47\x8a", [0x240a] = "\x47\x8b",
  [0x240b] = "\x47\x8c", [0x240c] = "\x47\x8d", [0x240d] = "\x47\x8e",
  [0x240e] = "\x47\x8f", [0x240f] = "\x47\x90", [0x2410] = "\x47\x91",
  [0x2411] = "\x47\x92", [0x2412] = "\x47\x93", [0x2413] = "\x47\x94",
  [0x2414] = "\x47\x95", [0x2415] = "\x47\x96", [0x2416] = "\x47\x97",
  [0x2417] = "\x47\x98", [0x2418] = "\x47\x99", [0x2419] = "\x47\x9a",
  [0x241a] = "\x47\x9b", [0x241b] = "\x47\x9c", [0x241c] = "\x47\x9d",
  [0x241d] = "\x47\x9e", [0x241e] = "\x47\x9f", [0x241f] = "\x47\xa0",
  [0x2421] = "\x47\xa1", [0x2460] = "\x46\x41", [0x2461] = "\x46\x42",
  [0x2462] = "\x46\x43", [0x2463] = "\x46\x44", [0x2464] = "\x46\x45",
  [0x2465] = "\x46\x46", [0x2466] = "\x46\x47", [0x2467] = "\x46\x48",
  [0x2468] = "\x46\x49", [0x2469] = "\x46\x4a", [0x2474] = "\x46\x51",
  [0x2475] = "\x46\x52", [0x2476] = "\x46\x53", [0x2477] = "\x46\x54",
  [0x2478] = "\x46\x55", [0x2479] = "\x46\x56", [0x247a] = "\x46\x57",
  [0x247b] = "\x46\x58", [0x247c] = "\x46\x59", [0x247d] = "\x46\x5a",
  [0x2500] = "\x46\x75", [0x2501] = "\x43\xb7", [0x2502] = "\x46\x76",
  [0x2503] = "\x43\xb8", [0x250c] = "\x46\x78", [0x250f] = "\x43\xb9",
  [0x2510] = "\x46\x79", [0x2513] = "\x43\xe1", [0x2514] = "\x46\x7a",
  [0x2517] = "\x43\xe3", [0x2518] = "\x46\x7b", [0x251b] = "\x43\xe2",
  [0x251c] = "\x46\x73", [0x251d] = "\x43\xee", [0x2520] = "\x43\xe9",
  [0x2523] = "\x43\xe4", [0x2524] = "\x46\x72", [0x2525] = "\x43\xf0",
  [0x2528] = "\x43\xeb", [0x252b] = "\x43\xe6", [0x252c] = "\x46\x71",
  [0x252f] = "\x43\xea", [0x2530] = "\x43\xef", [0x2533] = "\x43\xe5",
  [0x2534] = "\x46\x70", [0x2537] = "\x43\xec", [0x2538] = "\x43\xf1",
  [0x253b] = "\x43\xe7", [0x253c] = "\x46\x6f", [0x253f] = "\x43\xed",
  [0x2542] = "\x43\xf2", [0x254b] = "\x43\xe8", [0x2550] = "\x46\x81",
  [0x255e] = "\x46\x82", [0x2561] = "\x46\x84", [0x256a] = "\x46\x83",
  [0x256d] = "\x46\x7c", [0x256e] = "\x46\x7d", [0x256f] = "\x46\x7f",
  [0x2570] = "\x46\x7e", [0x2571] = "\x46\x89", [0x2572] = "\x46\x8a",
  [0x2573] = "\x46\x8b", [0x2574] = "\x46\xb7", [0x2581] = "\x46\x60",
  [0x2582] = "\x46\x61", [0x2583] = "\x46\x62", [0x2584] = "\x46\x63",
  [0x2585] = "\x46\x64", [0x2586] = "\x46\x65", [0x2587] = "\x46\x66",
  [0x2588] = "\x46\x67", [0x2589] = "\x46\x6e", [0x258a] = "\x46\x6d",
  [0x258b] = "\x46\x6c", [0x258c] = "\x46\x6b", [0x258d] = "\x46\x6a",
  [0x258e] = "\x46\x69", [0x258f] = "\x46\x68", [0x2594] = "\x46\x74",
  [0x2595] = "\x46\x77", [0x25a0] = "\x44\xea", [0x25a1] = "\x44\xe9",
  [0x25b2] = "\x44\xe3", [0x25b3] = "\x44\xe2", [0x25bc] = "\x44\xec",
  [0x25bd] = "\x44\xeb", [0x25c6] = "\x44\xe8", [0x25c7] = "\x44\xe7",
  [0x25cb] = "\x44\xe0", [0x25ce] = "\x44\xe4", [0x25cf] = "\x44\xe1",
  [0x25e2] = "\x46\x85", [0x25e3] = "\x46\x86", [0x25e4] = "\x46\x88",
  [0x25e5] = "\x46\x87", [0x25ef] = "\x43\x7a", [0x2605] = "\x44\xe6",
  [0x2606] = "\x44\xe5", [0x2640] = "\x44\x79", [0x2642] = "\x44\x69",
  [0x266a] = "\x43\x76", [0x266d] = "\x43\x75", [0x266f] = "\x43\x74",
  [0x273d] = "\x42\x5c", [0x3000] = "\x40\x40", [0x3001] = "\x43\x44",
  [0x3002] = "\x43\x41", [0x3003] = "\x46\xb9", [0x3005] = "\x44\x5d",
  [0x3006] = "\x44\x5e", [0x3007] = "\x44\x5f", [0x3008] = "\x44\x64",
  [0x3009] = "\x44\x74", [0x300a] = "\x44\x65", [0x300b] = "\x44\x75",
  [0x300c] = "\x43\x42", [0x300d] = "\x43\x43", [0x300e] = "\x44\x42",
  [0x300f] = "\x44\x43", [0x3010] = "\x44\x66", [0x3011] = "\x44\x76",
  [0x3012] = "\x44\x6c", [0x3013] = "\x44\x7d", [0x3014] = "\x44\x63",
  [0x3015] = "\x44\x73", [0x301d] = "\x46\xe9", [0x301e] = "\x46\xea",
  [0x3021] = "\x45\x41", [0x3022] = "\x45\x42", [0x3023] = "\x45\x43",
  [0x3024] = "\x45\x44", [0x3025] = "\x45\x45", [0x3026] = "\x45\x46",
  [0x3027] = "\x45\x47", [0x3028] = "\x45\x48", [0x3029] = "\x45\x49",
  [0x3041] = "\x44\x47", [0x3042] = "\x44\x81", [0x3043] = "\x44\x48",
  [0x3044] = "\x44\x82", [0x3045] = "\x44\x49", [0x3046] = "\x44\x83",
  [0x3047] = "\x44\x51", [0x3048] = "\x44\x84", [0x3049] = "\x44\x52",
  [0x304a] = "\x44\x85", [0x304b] = "\x44\x86", [0x304c] = "\x44\xc0",
  [0x304d] = "\x44\x87", [0x304e] = "\x44\xc1", [0x304f] = "\x44\x88",
  [0x3050] = "\x44\xc2", [0x3051] = "\x44\x89", [0x3052] = "\x44\xc3",
  [0x3053] = "\x44\x8a", [0x3054] = "\x44\xc4", [0x3055] = "\x44\x8c",
  [0x3056] = "\x44\xc5", [0x3057] = "\x44\x8d", [0x3058] = "\x44\xc6",
  [0x3059] = "\x44\x8e", [0x305a] = "\x44\xc7", [0x305b] = "\x44\x8f",
  [0x305c] = "\x44\xc8", [0x305d] = "\x44\x90", [0x305e] = "\x44\xc9",
  [0x305f] = "\x44\x91", [0x3060] = "\x44\xca", [0x3061] = "\x44\x92",
  [0x3062] = "\x44\xcb", [0x3063] = "\x44\x56", [0x3064] = "\x44\x93",
  [0x3065] = "\x44\xcc", [0x3066] = "\x44\x94", [0x3067] = "\x44\xcd",
  [0x3068] = "\x44\x95", [0x3069] = "\x44\xce", [0x306a] = "\x44\x96",
  [0x306b] = "\x44\x97", [0x306c] = "\x44\x98", [0x306d] = "\x44\x99",
  [0x306e] = "\x44\x9a", [0x306f] = "\x44\x9d", [0x3070] = "\x44\xcf",
  [0x3071] = "\x44\xd5", [0x3072] = "\x44\x9e", [0x3073] = "\x44\xd0",
  [0x3074] = "\x44\xd6", [0x3075] = "\x44\x9f", [0x3076] = "\x44\xd1",
  [0x3077] = "\x44\xd7", [0x3078] = "\x44\xa2", [0x3079] = "\x44\xd2",
  [0x307a] = "\x44\xd8", [0x307b] = "\x44\xa3", [0x307c] = "\x44\xd3",
  [0x307d] = "\x44\xd9", [0x307e] = "\x44\xa4", [0x307f] = "\x44\xa5",
  [0x3080] = "\x44\xa6", [0x3081] = "\x44\xa7", [0x3082] = "\x44\xa8",
  [0x3083] = "\x44\x53", [0x3084] = "\x44\xa9", [0x3085] = "\x44\x54",
  [0x3086] = "\x44\xaa", [0x3087] = "\x44\x55", [0x3088] = "\x44\xac",
  [0x3089] = "\x44\xad", [0x308a] = "\x44\xae", [0x308b] = "\x44\xaf",
  [0x308c] = "\x44\xba", [0x308d] = "\x44\xbb", [0x308e] = "\x44\x57",
  [0x308f] = "\x44\xbc", [0x3090] = "\x44\xda", [0x3091] = "\x44\xdb",
  [0x3092] = "\x44\x46", [0x3093] = "\x44\xbd", [0x309b] = "\x43\xbe",
  [0x309c] = "\x43\xbf", [0x309d] = "\x44\xdc", [0x309e] = "\x44\xdd",
  [0x30a1] = "\x43\x47", [0x30a2] = "\x43\x81", [0x30a3] = "\x43\x48",
  [0x30a4] = "\x43\x82", [0x30a5] = "\x43\x49", [0x30a6] = "\x43\x83",
  [0x30a7] = "\x43\x51", [0x30a8] = "\x43\x84", [0x30a9] = "\x43\x52",
  [0x30aa] = "\x43\x85", [0x30ab] = "\x43\x86", [0x30ac] = "\x43\xc0",
  [0x30ad] = "\x43\x87", [0x30ae] = "\x43\xc1", [0x30af] = "\x43\x88",
  [0x30b0] = "\x43\xc2", [0x30b1] = "\x43\x89", [0x30b2] = "\x43\xc3",
  [0x30b3] = "\x43\x8a", [0x30b4] = "\x43\xc4", [0x30b5] = "\x43\x8c",
  [0x30b6] = "\x43\xc5", [0x30b7] = "\x43\x8d", [0x30b8] = "\x43\xc6",
  [0x30b9] = "\x43\x8e", [0x30ba] = "\x43\xc7", [0x30bb] = "\x43\x8f",
  [0x30bc] = "\x43\xc8", [0x30bd] = "\x43\x90", [0x30be] = "\x43\xc9",
  [0x30bf] = "\x43\x91", [0x30c0] = "\x43\xca", [0x30c1] = "\x43\x92",
  [0x30c2] = "\x43\xcb", [0x30c3] = "\x43\x56", [0x30c4] = "\x43\x93",
  [0x30c5] = "\x43\xcc", [0x30c6] = "\x43\x94", [0x30c7] = "\x43\xcd",
  [0x30c8] = "\x43\x95", [0x30c9] = "\x43\xce", [0x30ca] = "\x43\x96",
  [0x30cb] = "\x43\x97", [0x30cc] = "\x43\x98", [0x30cd] = "\x43\x99",
  [0x30ce] = "\x43\x9a", [0x30cf] = "\x43\x9d", [0x30d0] = "\x43\xcf",
  [0x30d1] = "\x43\xd5", [0x30d2] = "\x43\x9e", [0x30d3] = "\x43\xd0",
  [0x30d4] = "\x43\xd6", [0x30d5] = "\x43\x9f", [0x30d6] = "\x43\xd1",
  [0x30d7] = "\x43\xd7", [0x30d8] = "\x43\xa2", [0x30d9] = "\x43\xd2",
  [0x30da] = "\x43\xd8", [0x30db] = "\x43\xa3", [0x30dc] = "\x43\xd3",
  [0x30dd] = "\x43\xd9", [0x30de] = "\x43\xa4", [0x30df] = "\x43\xa5",
  [0x30e0] = "\x43\xa6", [0x30e1] = "\x43\xa7", [0x30e2] = "\x43\xa8",
  [0x30e3] = "\x43\x53", [0x30e4] = "\x43\xa9", [0x30e5] = "\x43\x54",
  [0x30e6] = "\x43\xaa", [0x30e7] = "\x43\x55", [0x30e8] = "\x43\xac",
  [0x30e9] = "\x43\xad", [0x30ea] = "\x43\xae", [0x30eb] = "\x43\xaf",
  [0x30ec] = "\x43\xba", [0x30ed] = "\x43\xbb", [0x30ee] = "\x43\x57",
  [0x30ef] = "\x43\xbc", [0x30f0] = "\x43\xda", [0x30f1] = "\x43\xdb",
  [0x30f2] = "\x43\x46", [0x30f3] = "\x43\xbd", [0x30f4] = "\x43\xd4",
  [0x30f5] = "\x43\x59", [0x30f6] = "\x43\x5a", [0x30fc] = "\x43\x58",
  [0x30fd] = "\x43\xdc", [0x30fe] = "\x43\xdd", [0x3105] = "\x45\x56",
  [0x3106] = "\x45\x57", [0x3107] = "\x45\x58", [0x3108] = "\x45\x59",
  [0x3109] = "\x45\x5a", [0x310a] = "\x45\x5b", [0x310b] = "\x45\x5c",
  [0x310c] = "\x45\x5d", [0x310d] = "\x45\x5e", [0x310e] = "\x45\x5f",
  [0x310f] = "\x45\x60", [0x3110] = "\x45\x61", [0x3111] = "\x45\x62",
  [0x3112] = "\x45\x63", [0x3113] = "\x45\x64", [0x3114] = "\x45\x65",
  [0x3115] = "\x45\x66", [0x3116] = "\x45\x67", [0x3117] = "\x45\x68",
  [0x3118] = "\x45\x69", [0x3119] = "\x45\x6a", [0x311a] = "\x45\x6b",
  [0x311b] = "\x45\x6c", [0x311c] = "\x45\x6d", [0x311d] = "\x45\x6e",
  [0x311e] = "\x45\x6f", [0x311f] = "\x45\x70", [0x3120] = "\x45\x71",
  [0x3121] = "\x45\x72", [0x3122] = "\x45\x73", [0x3123] = "\x45\x74",
  [0x3124] = "\x45\x75", [0x3125] = "\x45\x76", [0x3126] = "\x45\x77",
  [0x3127] = "\x45\x78", [0x3128] = "\x45\x79", [0x3129] = "\x45\x7a",
  [0x3231] = "\x44\x6d", [0x32a3] = "\x46\xba", [0x338e] = "\x46\xe2",
  [0x338f] = "\x46\xe3", [0x339c] = "\x46\xdd", [0x339d] = "\x46\xde",
  [0x339e] = "\x46\xdf", [0x33a1] = "\x46\xe1", [0x33c4] = "\x46\xe4",
  [0x33ce] = "\x46\xe0", [0x33d1] = "\x46\xcf", [0x33d2] = "\x46\xce",
  [0x33d5] = "\x46\xdc", [0x4e00] = "\x4c\x41", [0x4e01] = "\x4c\x43",
  [0x4e03] = "\x4c\x44", [0x4e07] = "\x69\x46", [0x4e08] = "\x4c\x57",
  [0x4e09] = "\x4c\x55", [0x4e0a] = "\x4c\x58", [0x4e0b] = "\x4c\x56",
  [0x4e0c] = "\x69\x47", [0x4e0d] = "\x4c\x83", [0x4e0e] = "\x69\x50",
  [0x4e0f] = "\x69\x4e", [0x4e10] = "\x4c\x82", [0x4e11] = "\x4c\x81",
  [0x4e14] = "\x4c\xe1", [0x4e15] = "\x4c\xe0", [0x4e16] = "\x4c\xdf",
  [0x4e18] = "\x4c\xe2", [0x4e19] = "\x4c\xde", [0x4e1e] = "\x4d\xa1",
  [0x4e1f] = "\x4d\xa2", [0x4e26] = "\x4f\xe3", [0x4e28] = "\x48\x42",
  [0x4e2b] = "\x4c\x59", [0x4e2d] = "\x4c\x84", [0x4e2e] = "\x69\x51",
  [0x4e30] = "\x4c\x85", [0x4e31] = "\x69\x64", [0x4e32] = "\x4e\x8c",
  [0x4e33] = "\x6b\x52", [0x4e36] = "\x48\x43", [0x4e38] = "\x4c\x5a",
  [0x4e39] = "\x4c\x86", [0x4e3b] = "\x4c\xe3", [0x4e3c] = "\x69\x65",
  [0x4e3f] = "\x48\x44", [0x4e42] = "\x69\x41", [0x4e43] = "\x4c\x45",
  [0x4e45] = "\x4c\x5c", [0x4e47] = "\x69\x48", [0x4e48] = "\x4c\x5d",
  [0x4e4b] = "\x4c\x87", [0x4e4d] = "\x4c\xe4", [0x4e4e] = "\x4c\xe6",
  [0x4e4f] = "\x4c\xe5", [0x4e52] = "\x4d\xa3", [0x4e53] = "\x4d\xa4",
  [0x4e56] = "\x4f\xe4", [0x4e58] = "\x53\xfd", [0x4e59] = "\x4c\x42",
  [0x4e5c] = "\x69\x42", [0x4e5d] = "\x4c\x46", [0x4e5e] = "\x4c\x5f",
  [0x4e5f] = "\x4c\x5e", [0x4e69] = "\x4d\xa5", [0x4e73] = "\x4f\xe5",
  [0x4e7e] = "\x56\x92", [0x4e7f] = "\x72\x6f", [0x4e82] = "\x5b\xa9",
  [0x4e83] = "\x79\x77", [0x4e84] = "\x79\x78", [0x4e85] = "\x48\x46",
  [0x4e86] = "\x4c\x47", [0x4e88] = "\x4c\x89", [0x4e8b] = "\x4f\xe6",
  [0x4e8c] = "\x4c\x48", [0x4e8d] = "\x69\x49", [0x4e8e] = "\x4c\x60",
  [0x4e91] = "\x4c\x8a", [0x4e92] = "\x4c\x8c", [0x4e93] = "\x69\x52",
  [0x4e94] = "\x4c\x8d", [0x4e95] = "\x4c\x8b", [0x4e99] = "\x4d\xa6",
  [0x4e9b] = "\x4f\xe7", [0x4e9e] = "\x4f\xe8", [0x4e9f] = "\x51\xe6",
  [0x4ea0] = "\x48\x48", [0x4ea1] = "\x4c\x61", [0x4ea2] = "\x4c\x8e",
  [0x4ea4] = "\x4d\xa7", [0x4ea5] = "\x4d\xa9", [0x4ea6] = "\x4d\xa8",
  [0x4ea8] = "\x4e\x8d", [0x4eab] = "\x4f\xe9", [0x4eac] = "\x4f\xea",
  [0x4ead] = "\x51\xe7", [0x4eae] = "\x51\xe8", [0x4eb3] = "\x54\x41",
  [0x4eb6] = "\x79\x79", [0x4eb9] = "\x8f\x66", [0x4eba] = "\x4c\x49",
  [0x4ec0] = "\x4c\x90", [0x4ec1] = "\x4c\x8f", [0x4ec2] = "\x69\x53",
  [0x4ec3] = "\x4c\x91", [0x4ec4] = "\x4c\x97", [0x4ec6] = "\x4c\x92",
  [0x4ec7] = "\x4c\x93", [0x4ec8] = "\x69\x55", [0x4ec9] = "\x69\x54",
  [0x4eca] = "\x4c\x95", [0x4ecb] = "\x4c\x96", [0x4ecd] = "\x4c\x94",
  [0x4ed4] = "\x4c\xe9", [0x4ed5] = "\x4c\xea", [0x4ed6] = "\x4c\xeb",
  [0x4ed7] = "\x4c\xec", [0x4ed8] = "\x4c\xe8", [0x4ed9] = "\x4c\xef",
  [0x4eda] = "\x69\x6b", [0x4edc] = "\x69\x67", [0x4edd] = "\x69\x6a",
  [0x4ede] = "\x4c\xf0", [0x4edf] = "\x4d\x43", [0x4ee1] = "\x69\x69",
  [0x4ee3] = "\x4c\xed", [0x4ee4] = "\x4c\xee", [0x4ee5] = "\x4c\xe7",
  [0x4ee8] = "\x69\x66", [0x4ee9] = "\x69\x68", [0x4ef0] = "\x4d\xb6",
  [0x4ef1] = "\x69\x90", [0x4ef2] = "\x4d\xb3", [0x4ef3] = "\x4d\xb7",
  [0x4ef4] = "\x69\x9a", [0x4ef5] = "\x69\x8e", [0x4ef6] = "\x4d\xb4",
  [0x4ef7] = "\x69\x92", [0x4efb] = "\x4d\xb5", [0x4efd] = "\x4d\xb8",
  [0x4eff] = "\x4d\xaa", [0x4f00] = "\x69\x91", [0x4f01] = "\x4d\xb9",
  [0x4f02] = "\x69\x95", [0x4f04] = "\x69\x99", [0x4f05] = "\x69\x96",
  [0x4f08] = "\x69\x93", [0x4f09] = "\x4d\xab", [0x4f0a] = "\x4d\xad",
  [0x4f0b] = "\x4d\xba", [0x4f0d] = "\x4d\xaf", [0x4f0e] = "\x69\x8b",
  [0x4f0f] = "\x4d\xb2", [0x4f10] = "\x4d\xb0", [0x4f11] = "\x4d\xb1",
  [0x4f12] = "\x69\x9b", [0x4f13] = "\x69\x98", [0x4f14] = "\x69\x8f",
  [0x4f15] = "\x4d\xae", [0x4f18] = "\x69\x8c", [0x4f19] = "\x4d\xac",
  [0x4f1d] = "\x69\x94", [0x4f22] = "\x69\x97", [0x4f2c] = "\x69\x8d",
  [0x4f2d] = "\x6a\x48", [0x4f2f] = "\x4e\xa3", [0x4f30] = "\x4e\x96",
  [0x4f33] = "\x6a\x49", [0x4f34] = "\x4e\x93", [0x4f36] = "\x4e\xa5",
  [0x4f38] = "\x4e\x9b", [0x4f3a] = "\x4e\x9a", [0x4f3b] = "\x69\xfa",
  [0x4f3c] = "\x4e\x9e", [0x4f3d] = "\x4e\x99", [0x4f3e] = "\x6a\x42",
  [0x4f3f] = "\x6a\x4a", [0x4f41] = "\x6a\x46", [0x4f43] = "\x4e\x9c",
  [0x4f46] = "\x4e\x9f", [0x4f47] = "\x4e\x90", [0x4f48] = "\x4e\xa8",
  [0x4f49] = "\x69\xfc", [0x4f4c] = "\x6b\x5e", [0x4f4d] = "\x4e\x8e",
  [0x4f4e] = "\x4e\xa4", [0x4f4f] = "\x4e\x8f", [0x4f50] = "\x4e\x97",
  [0x4f51] = "\x4e\x98", [0x4f52] = "\x6a\x44", [0x4f53] = "\x69\xfd",
  [0x4f54] = "\x4e\x9d", [0x4f55] = "\x4e\x95", [0x4f56] = "\x69\xf9",
  [0x4f57] = "\x4e\x91", [0x4f58] = "\x6a\x47", [0x4f59] = "\x4e\xa6",
  [0x4f5a] = "\x4e\xa9", [0x4f5b] = "\x4e\x94", [0x4f5c] = "\x4e\xa1",
  [0x4f5d] = "\x4e\xa7", [0x4f5e] = "\x4e\x92", [0x4f5f] = "\x6a\x45",
  [0x4f60] = "\x4e\xa2", [0x4f61] = "\x6a\x4b", [0x4f62] = "\x69\xfb",
  [0x4f63] = "\x4e\xa0", [0x4f64] = "\x6a\x41", [0x4f67] = "\x6a\x43",
  [0x4f69] = "\x4f\xf8", [0x4f6a] = "\x6b\x60", [0x4f6b] = "\x6b\x6c",
  [0x4f6c] = "\x4f\xf0", [0x4f6e] = "\x6b\x6d", [0x4f6f] = "\x4f\xeb",
  [0x4f70] = "\x4f\xf5", [0x4f73] = "\x4f\xee", [0x4f74] = "\x6b\x5a",
  [0x4f75] = "\x4f\xf6", [0x4f76] = "\x6b\x59", [0x4f77] = "\x6b\x5d",
  [0x4f78] = "\x6b\x64", [0x4f79] = "\x6b\x62", [0x4f7a] = "\x50\x41",
  [0x4f7b] = "\x4f\xf9", [0x4f7c] = "\x6b\x54", [0x4f7d] = "\x6b\x56",
  [0x4f7e] = "\x4f\xfb", [0x4f7f] = "\x4f\xef", [0x4f80] = "\x6b\x57",
  [0x4f81] = "\x6b\x63", [0x4f82] = "\x6b\x6a", [0x4f83] = "\x4f\xf4",
  [0x4f84] = "\x6b\x5c", [0x4f85] = "\x6b\x55", [0x4f86] = "\x4f\xf3",
  [0x4f87] = "\x6b\x58", [0x4f88] = "\x4f\xf7", [0x4f89] = "\x6b\x5b",
  [0x4f8b] = "\x4f\xf2", [0x4f8d] = "\x4f\xed", [0x4f8f] = "\x4f\xfc",
  [0x4f90] = "\x6b\x65", [0x4f91] = "\x4f\xfd", [0x4f92] = "\x6b\x69",
  [0x4f94] = "\x6b\x67", [0x4f95] = "\x6b\x6b", [0x4f96] = "\x4f\xfa",
  [0x4f97] = "\x6b\x5f", [0x4f98] = "\x6b\x53", [0x4f9a] = "\x6b\x61",
  [0x4f9b] = "\x4f\xf1", [0x4f9c] = "\x6b\x66", [0x4f9d] = "\x4f\xec",
  [0x4f9e] = "\x6b\x68", [0x4fae] = "\x51\xf7", [0x4faf] = "\x51\xeb",
  [0x4fb2] = "\x6d\x43", [0x4fb3] = "\x6d\x4b", [0x4fb5] = "\x51\xea",
  [0x4fb6] = "\x51\xf2", [0x4fb7] = "\x52\x41", [0x4fb9] = "\x6d\x51",
  [0x4fba] = "\x6d\x4f", [0x4fbb] = "\x6d\x4a", [0x4fbf] = "\x51\xec",
  [0x4fc0] = "\x6d\x50", [0x4fc1] = "\x6d\x46", [0x4fc2] = "\x51\xfa",
  [0x4fc3] = "\x51\xf1", [0x4fc4] = "\x51\xf9", [0x4fc5] = "\x6d\x41",
  [0x4fc7] = "\x6d\x4d", [0x4fc9] = "\x6d\x44", [0x4fca] = "\x51\xf5",
  [0x4fcb] = "\x6d\x45", [0x4fcd] = "\x6c\xfd", [0x4fce] = "\x51\xfc",
  [0x4fcf] = "\x51\xef", [0x4fd0] = "\x51\xf8", [0x4fd1] = "\x51\xee",
  [0x4fd3] = "\x6d\x42", [0x4fd4] = "\x6d\x47", [0x4fd6] = "\x6d\x4e",
  [0x4fd7] = "\x51\xf6", [0x4fd8] = "\x51\xf3", [0x4fd9] = "\x6d\x49",
  [0x4fda] = "\x51\xfb", [0x4fdb] = "\x6d\x4c", [0x4fdc] = "\x6d\x48",
  [0x4fdd] = "\x51\xf0", [0x4fde] = "\x51\xfd", [0x4fdf] = "\x51\xf4",
  [0x4fe0] = "\x51\xed", [0x4fe1] = "\x51\xe9", [0x4fec] = "\x6d\x52",
  [0x4fee] = "\x54\x5b", [0x4fef] = "\x54\x45", [0x4ff1] = "\x54\x55",
  [0x4ff3] = "\x54\x5a", [0x4ff4] = "\x6f\x93", [0x4ff5] = "\x6f\x92",
  [0x4ff6] = "\x6f\x97", [0x4ff7] = "\x6f\x98", [0x4ff8] = "\x54\x48",
  [0x4ffa] = "\x54\x51", [0x4ffe] = "\x54\x5e", [0x5000] = "\x54\x52",
  [0x5005] = "\x6f\x8c", [0x5006] = "\x54\x4b", [0x5007] = "\x6f\x8d",
  [0x5009] = "\x54\x60", [0x500b] = "\x54\x57", [0x500c] = "\x54\x42",
  [0x500d] = "\x54\x43", [0x500e] = "\x6f\xa0", [0x500f] = "\x56\xa3",
  [0x5011] = "\x54\x50", [0x5012] = "\x54\x4f", [0x5013] = "\x6f\x8e",
  [0x5014] = "\x54\x53", [0x5015] = "\x72\x7f", [0x5016] = "\x54\x4a",
  [0x5017] = "\x6f\x99", [0x5018] = "\x54\x59", [0x5019] = "\x54\x58",
  [0x501a] = "\x54\x4e", [0x501b] = "\x6f\x91", [0x501c] = "\x6f\x9a",
  [0x501e] = "\x6f\x8b", [0x501f] = "\x54\x4d", [0x5020] = "\x6f\x9b",
  [0x5021] = "\x54\x56", [0x5022] = "\x6f\x8f", [0x5023] = "\x54\x44",
  [0x5025] = "\x54\x47", [0x5026] = "\x54\x46", [0x5027] = "\x6f\x9c",
  [0x5028] = "\x54\x54", [0x5029] = "\x54\x49", [0x502a] = "\x54\x5d",
  [0x502b] = "\x54\x5f", [0x502c] = "\x6f\x96", [0x502d] = "\x54\x5c",
  [0x502f] = "\x6f\x9e", [0x5030] = "\x6f\x90", [0x5031] = "\x6f\x9f",
  [0x5033] = "\x6f\x94", [0x5035] = "\x6f\x9d", [0x5037] = "\x6f\x95",
  [0x503c] = "\x54\x4c", [0x5040] = "\x72\x88", [0x5041] = "\x72\x7b",
  [0x5043] = "\x56\x97", [0x5045] = "\x72\x81", [0x5046] = "\x72\x87",
  [0x5047] = "\x56\x96", [0x5048] = "\x72\x79", [0x5049] = "\x56\x9a",
  [0x504a] = "\x72\x7d", [0x504b] = "\x72\x76", [0x504c] = "\x56\x98",
  [0x504d] = "\x72\x7a", [0x504e] = "\x56\x9d", [0x504f] = "\x56\xa2",
  [0x5051] = "\x72\x8c", [0x5053] = "\x72\x75", [0x5055] = "\x56\x9e",
  [0x5057] = "\x72\x8b", [0x505a] = "\x56\x99", [0x505b] = "\x72\x7c",
  [0x505c] = "\x56\x95", [0x505d] = "\x72\x77", [0x505e] = "\x72\x73",
  [0x505f] = "\x72\x82", [0x5060] = "\x72\x74", [0x5061] = "\x72\x72",
  [0x5062] = "\x72\x7e", [0x5063] = "\x72\x85", [0x5064] = "\x72\x86",
  [0x5065] = "\x56\x9b", [0x5068] = "\x75\xc0", [0x5069] = "\x72\x83",
  [0x506a] = "\x72\x71", [0x506b] = "\x72\x84", [0x506d] = "\x56\xa5",
  [0x506e] = "\x72\x89", [0x506f] = "\x56\xa4", [0x5070] = "\x72\x70",
  [0x5072] = "\x72\x78", [0x5073] = "\x72\x8a", [0x5074] = "\x56\xa0",
  [0x5075] = "\x56\x9f", [0x5076] = "\x56\x9c", [0x5077] = "\x56\xa1",
  [0x507a] = "\x56\x93", [0x507d] = "\x56\x94", [0x5080] = "\x59\x4e",
  [0x5082] = "\x75\xc3", [0x5083] = "\x75\xbc", [0x5085] = "\x59\x4b",
  [0x5087] = "\x75\xc4", [0x508b] = "\x75\xba", [0x508c] = "\x75\xbd",
  [0x508d] = "\x59\x4a", [0x508e] = "\x75\xbe", [0x5091] = "\x59\x4d",
  [0x5092] = "\x75\xc2", [0x5094] = "\x75\xb8", [0x5095] = "\x75\xb7",
  [0x5096] = "\x59\x4f", [0x5098] = "\x59\x50", [0x5099] = "\x59\x4c",
  [0x509a] = "\x59\x51", [0x509b] = "\x75\xb6", [0x509c] = "\x75\xc1",
  [0x509d] = "\x75\xbf", [0x509e] = "\x75\xb9", [0x50a2] = "\x59\x49",
  [0x50a3] = "\x75\xbb", [0x50ac] = "\x5b\xb0", [0x50ad] = "\x5b\xaa",
  [0x50ae] = "\x79\x7d", [0x50af] = "\x5b\xb3", [0x50b0] = "\x79\x84",
  [0x50b1] = "\x79\x87", [0x50b2] = "\x5b\xac", [0x50b3] = "\x5b\xad",
  [0x50b4] = "\x79\x81", [0x50b5] = "\x5b\xab", [0x50b6] = "\x79\x8a",
  [0x50b7] = "\x5b\xb1", [0x50b8] = "\x79\x8b", [0x50ba] = "\x79\x86",
  [0x50bb] = "\x5b\xb2", [0x50bd] = "\x79\x7a", [0x50be] = "\x5b\xaf",
  [0x50bf] = "\x79\x7b", [0x50c1] = "\x79\x85", [0x50c2] = "\x79\x83",
  [0x50c4] = "\x79\x7e", [0x50c5] = "\x5b\xae", [0x50c6] = "\x79\x7c",
  [0x50c7] = "\x5b\xb4", [0x50c8] = "\x79\x82", [0x50c9] = "\x79\x89",
  [0x50ca] = "\x79\x7f", [0x50cb] = "\x79\x88", [0x50ce] = "\x5d\xfb",
  [0x50cf] = "\x5d\xf8", [0x50d1] = "\x5d\xf9", [0x50d3] = "\x7d\x43",
  [0x50d4] = "\x7c\xf8", [0x50d5] = "\x5d\xf7", [0x50d6] = "\x5d\xf4",
  [0x50d7] = "\x7c\xf9", [0x50da] = "\x5d\xf6", [0x50db] = "\x7c\xfc",
  [0x50dd] = "\x7d\x41", [0x50e0] = "\x7d\x48", [0x50e3] = "\x7d\x47",
  [0x50e4] = "\x7d\x42", [0x50e5] = "\x5d\xf3", [0x50e6] = "\x7c\xf7",
  [0x50e7] = "\x5d\xf1", [0x50e8] = "\x7c\xfa", [0x50e9] = "\x5d\xfc",
  [0x50ea] = "\x7c\xfd", [0x50ec] = "\x7d\x44", [0x50ed] = "\x5d\xf5",
  [0x50ee] = "\x5d\xf2", [0x50ef] = "\x7d\x46", [0x50f0] = "\x7d\x45",
  [0x50f1] = "\x5d\xfa", [0x50f3] = "\x7c\xfb", [0x50f5] = "\x60\x42",
  [0x50f6] = "\x80\x76", [0x50f8] = "\x80\x73", [0x50f9] = "\x60\x43",
  [0x50fb] = "\x60\x41", [0x50fd] = "\x80\x7a", [0x50fe] = "\x80\x77",
  [0x50ff] = "\x80\x70", [0x5100] = "\x5f\xfd", [0x5102] = "\x60\x44",
  [0x5103] = "\x80\x71", [0x5104] = "\x5f\xfc", [0x5105] = "\x60\x47",
  [0x5106] = "\x80\x74", [0x5107] = "\x80\x75", [0x5108] = "\x60\x45",
  [0x5109] = "\x60\x46", [0x510a] = "\x80\x7b", [0x510b] = "\x80\x78",
  [0x510c] = "\x80\x79", [0x5110] = "\x62\x53", [0x5111] = "\x83\xc3",
  [0x5112] = "\x62\x50", [0x5113] = "\x83\xc0", [0x5114] = "\x62\x52",
  [0x5115] = "\x62\x54", [0x5117] = "\x83\xc1", [0x5118] = "\x62\x51",
  [0x511a] = "\x83\xc2", [0x511c] = "\x83\xbf", [0x511f] = "\x63\xc0",
  [0x5120] = "\x86\xc8", [0x5121] = "\x63\xc1", [0x5122] = "\x86\xc6",
  [0x5124] = "\x86\xc7", [0x5125] = "\x86\xc5", [0x5126] = "\x86\xc4",
  [0x5129] = "\x86\xc9", [0x512a] = "\x63\xbf", [0x512d] = "\x89\x65",
  [0x512e] = "\x89\x66", [0x5130] = "\x80\x72", [0x5131] = "\x89\x64",
  [0x5132] = "\x63\xc2", [0x5133] = "\x66\x4b", [0x5134] = "\x8b\x5a",
  [0x5135] = "\x8b\x5b", [0x5137] = "\x67\x83", [0x5138] = "\x67\x84",
  [0x5139] = "\x8e\x70", [0x513a] = "\x8e\x6f", [0x513b] = "\x67\xd7",
  [0x513c] = "\x67\xd6", [0x513d] = "\x90\x41", [0x513f] = "\x4c\x4a",
  [0x5140] = "\x4c\x62", [0x5141] = "\x4c\x99", [0x5143] = "\x4c\x98",
  [0x5144] = "\x4c\xf2", [0x5145] = "\x4c\xf1", [0x5146] = "\x4d\xbd",
  [0x5147] = "\x4d\xbc", [0x5148] = "\x4d\xbe", [0x5149] = "\x4d\xbb",
  [0x514b] = "\x4e\xab", [0x514c] = "\x4e\xaa", [0x514d] = "\x4e\xac",
  [0x5152] = "\x50\x43", [0x5154] = "\x50\x42", [0x5155] = "\x50\x44",
  [0x5157] = "\x52\x42", [0x5159] = "\x46\xf1", [0x515a] = "\x6f\xa1",
  [0x515b] = "\x46\xf2", [0x515c] = "\x56\xa6", [0x515d] = "\x46\xf4",
  [0x515e] = "\x46\xf3", [0x515f] = "\x75\xc5", [0x5161] = "\x46\xf5",
  [0x5162] = "\x5d\xfd", [0x5163] = "\x46\xf6", [0x5165] = "\x4c\x4b",
  [0x5167] = "\x4c\x9a", [0x5168] = "\x4d\xbf", [0x5169] = "\x50\x45",
  [0x516b] = "\x4c\x4c", [0x516c] = "\x4c\x9d", [0x516d] = "\x4c\x9b",
  [0x516e] = "\x4c\x9c", [0x5171] = "\x4d\xc0", [0x5175] = "\x4e\xad",
  [0x5176] = "\x50\x47", [0x5177] = "\x50\x46", [0x5178] = "\x50\x48",
  [0x517c] = "\x54\x61", [0x5180] = "\x62\x55", [0x5182] = "\x48\x4d",
  [0x5187] = "\x69\x4f", [0x5189] = "\x4c\xf3", [0x518a] = "\x4c\xf4",
  [0x518d] = "\x4d\xc1", [0x518f] = "\x6a\x4c", [0x5191] = "\x52\x44",
  [0x5192] = "\x52\x43", [0x5193] = "\x6f\xa3", [0x5194] = "\x6f\xa2",
  [0x5195] = "\x56\xa7", [0x5196] = "\x48\x4e", [0x5197] = "\x4c\x9e",
  [0x5198] = "\x69\x56", [0x519e] = "\x6b\x6e", [0x51a0] = "\x52\x45",
  [0x51a2] = "\x54\x64", [0x51a4] = "\x54\x62", [0x51a5] = "\x54\x63",
  [0x51aa] = "\x62\x56", [0x51ab] = "\x48\x4f", [0x51ac] = "\x4c\xf5",
  [0x51b0] = "\x4d\xc2", [0x51b1] = "\x69\x9c", [0x51b6] = "\x4e\xae",
  [0x51b7] = "\x4e\xaf", [0x51b9] = "\x6a\x4d", [0x51bc] = "\x6b\x6f",
  [0x51bd] = "\x50\x49", [0x51be] = "\x6b\x70", [0x51c4] = "\x6f\xa5",
  [0x51c5] = "\x6f\xa6", [0x51c6] = "\x54\x67", [0x51c8] = "\x6f\xa7",
  [0x51ca] = "\x6f\xa4", [0x51cb] = "\x54\x68", [0x51cc] = "\x54\x66",
  [0x51cd] = "\x54\x65", [0x51ce] = "\x6f\xa8", [0x51d0] = "\x72\x8d",
  [0x51d4] = "\x75\xc6", [0x51d7] = "\x79\x8c", [0x51d8] = "\x7d\x49",
  [0x51dc] = "\x60\x48", [0x51dd] = "\x62\x57", [0x51de] = "\x83\xc4",
  [0x51e0] = "\x4c\x4d", [0x51e1] = "\x4c\x5b", [0x51f0] = "\x56\xa8",
  [0x51f1] = "\x59\x53", [0x51f3] = "\x5e\x41", [0x51f5] = "\x69\x43",
  [0x51f6] = "\x4c\x9f", [0x51f8] = "\x4c\xf8", [0x51f9] = "\x4c\xf6",
  [0x51fa] = "\x4c\xf7", [0x51fd] = "\x50\x4a", [0x5200] = "\x4c\x4e",
  [0x5201] = "\x4c\x4f", [0x5203] = "\x4c\x63", [0x5206] = "\x4c\xa0",
  [0x5207] = "\x4c\xa1", [0x5208] = "\x4c\xa2", [0x5209] = "\x69\x9e",
  [0x520a] = "\x4c\xf9", [0x520c] = "\x69\x6c", [0x520e] = "\x4d\xc6",
  [0x5210] = "\x69\x9f", [0x5211] = "\x4d\xc4", [0x5212] = "\x4d\xc5",
  [0x5213] = "\x69\x9d", [0x5216] = "\x4d\xc7", [0x5217] = "\x4d\xc3",
  [0x521c] = "\x6a\x4e", [0x521d] = "\x51\xce", [0x521e] = "\x6a\x4f",
  [0x5221] = "\x6a\x50", [0x5224] = "\x4e\xb1", [0x5225] = "\x4e\xb0",
  [0x5228] = "\x4e\xb4", [0x5229] = "\x4e\xb2", [0x522a] = "\x4e\xb3",
  [0x522e] = "\x50\x50", [0x5230] = "\x50\x4f", [0x5231] = "\x6b\x75",
  [0x5232] = "\x6b\x72", [0x5233] = "\x6b\x73", [0x5235] = "\x6b\x71",
  [0x5236] = "\x50\x51", [0x5237] = "\x50\x4d", [0x5238] = "\x50\x4c",
  [0x523a] = "\x50\x4e", [0x523b] = "\x50\x4b", [0x5241] = "\x50\x52",
  [0x5243] = "\x52\x47", [0x5244] = "\x6d\x53", [0x5246] = "\x6b\x74",
  [0x5247] = "\x52\x4c", [0x5249] = "\x6d\x54", [0x524a] = "\x52\x48",
  [0x524b] = "\x52\x4b", [0x524c] = "\x52\x4a", [0x524d] = "\x52\x49",
  [0x524e] = "\x52\x46", [0x5252] = "\x6f\xab", [0x5254] = "\x54\x6b",
  [0x5255] = "\x6f\xae", [0x5256] = "\x54\x69", [0x525a] = "\x6f\xaa",
  [0x525b] = "\x54\x6c", [0x525c] = "\x54\x6a", [0x525d] = "\x54\x6d",
  [0x525e] = "\x6f\xac", [0x525f] = "\x6f\xad", [0x5261] = "\x6f\xa9",
  [0x5262] = "\x6f\xaf", [0x5269] = "\x59\x57", [0x526a] = "\x56\xa9",
  [0x526b] = "\x72\x8e", [0x526c] = "\x72\x90", [0x526d] = "\x72\x8f",
  [0x526e] = "\x72\x91", [0x526f] = "\x56\xaa", [0x5272] = "\x59\x54",
  [0x5274] = "\x59\x55", [0x5275] = "\x59\x56", [0x5277] = "\x5b\xb6",
  [0x5278] = "\x79\x8e", [0x527a] = "\x79\x8d", [0x527b] = "\x79\x8f",
  [0x527c] = "\x79\x90", [0x527d] = "\x5b\xb7", [0x527f] = "\x5b\xb5",
  [0x5280] = "\x7d\x4a", [0x5281] = "\x7d\x4b", [0x5282] = "\x5e\x43",
  [0x5283] = "\x5e\x42", [0x5284] = "\x7e\xe2", [0x5287] = "\x60\x49",
  [0x5288] = "\x60\x4a", [0x5289] = "\x60\x4b", [0x528a] = "\x60\x4d",
  [0x528b] = "\x80\x7c", [0x528c] = "\x80\x7d", [0x528d] = "\x60\x4c",
  [0x5291] = "\x62\x58", [0x5293] = "\x62\x59", [0x5296] = "\x8b\x5c",
  [0x5297] = "\x8e\x72", [0x5298] = "\x8e\x71", [0x5299] = "\x90\x42",
  [0x529b] = "\x4c\x50", [0x529f] = "\x4c\xfb", [0x52a0] = "\x4c\xfa",
  [0x52a3] = "\x4d\xc8", [0x52a6] = "\x69\xa0", [0x52a9] = "\x4e\xb6",
  [0x52aa] = "\x4e\xb7", [0x52ab] = "\x4e\xb5", [0x52ac] = "\x4e\xb8",
  [0x52ad] = "\x6a\x51", [0x52ae] = "\x6a\x52", [0x52bb] = "\x50\x54",
  [0x52bc] = "\x6b\x76", [0x52be] = "\x50\x53", [0x52c0] = "\x6d\x55",
  [0x52c1] = "\x52\x50", [0x52c2] = "\x6d\x56", [0x52c3] = "\x52\x4f",
  [0x52c7] = "\x52\x4d", [0x52c9] = "\x52\x4e", [0x52cd] = "\x6f\xb0",
  [0x52d2] = "\x56\xab", [0x52d3] = "\x72\x93", [0x52d5] = "\x56\xae",
  [0x52d6] = "\x72\x92", [0x52d7] = "\x57\xaa", [0x52d8] = "\x56\xad",
  [0x52d9] = "\x56\xac", [0x52db] = "\x59\x5a", [0x52dd] = "\x59\x59",
  [0x52de] = "\x59\x58", [0x52df] = "\x5b\xb8", [0x52e2] = "\x5b\xbb",
  [0x52e3] = "\x5b\xbc", [0x52e4] = "\x5b\xba", [0x52e6] = "\x5b\xb9",
  [0x52e9] = "\x7d\x4c", [0x52eb] = "\x7d\x4d", [0x52ef] = "\x80\x7f",
  [0x52f0] = "\x60\x4e", [0x52f1] = "\x80\x7e", [0x52f3] = "\x62\x5a",
  [0x52f4] = "\x86\xca", [0x52f5] = "\x63\xc3", [0x52f7] = "\x8b\x5d",
  [0x52f8] = "\x66\xdf", [0x52f9] = "\x48\x54", [0x52fa] = "\x4c\x64",
  [0x52fb] = "\x4c\xa3", [0x52fc] = "\x69\x57", [0x52fe] = "\x4c\xa4",
  [0x52ff] = "\x4c\xa5", [0x5305] = "\x4c\xfc", [0x5306] = "\x4c\xfd",
  [0x5308] = "\x4d\xc9", [0x5309] = "\x6a\x53", [0x530a] = "\x6b\x77",
  [0x530b] = "\x6b\x78", [0x530d] = "\x52\x51", [0x530e] = "\x6f\xb1",
  [0x530f] = "\x56\xb0", [0x5310] = "\x56\xaf", [0x5311] = "\x75\xc8",
  [0x5312] = "\x75\xc7", [0x5315] = "\x4c\x51", [0x5316] = "\x4c\xa6",
  [0x5317] = "\x4d\x41", [0x5319] = "\x56\xb1", [0x531a] = "\x69\x44",
  [0x531c] = "\x69\x6d", [0x531d] = "\x4d\x42", [0x531f] = "\x69\xa2",
  [0x5320] = "\x4d\xcb", [0x5321] = "\x4d\xca", [0x5322] = "\x69\xa1",
  [0x5323] = "\x4e\xb9", [0x532a] = "\x54\x6e", [0x532d] = "\x72\x94",
  [0x532f] = "\x5b\xbd", [0x5330] = "\x7d\x4e", [0x5331] = "\x5e\x44",
  [0x5334] = "\x83\xc5", [0x5337] = "\x8c\xeb", [0x5338] = "\x48\x57",
  [0x5339] = "\x4c\xa7", [0x533c] = "\x6b\x79", [0x533d] = "\x6d\x57",
  [0x533e] = "\x56\xb4", [0x533f] = "\x56\xb2", [0x5340] = "\x56\xb3",
  [0x5341] = "\x4c\x52", [0x5343] = "\x4c\x65", [0x5344] = "\x45\x4b",
  [0x5345] = "\x4c\xaa", [0x5347] = "\x4c\xa9", [0x5348] = "\x4c\xa8",
  [0x5349] = "\x4d\x45", [0x534a] = "\x4d\x44", [0x534c] = "\x69\x6e",
  [0x534d] = "\x69\xa3", [0x5351] = "\x50\x58", [0x5352] = "\x50\x55",
  [0x5353] = "\x50\x57", [0x5354] = "\x50\x56", [0x5357] = "\x52\x52",
  [0x535a] = "\x59\x5b", [0x535c] = "\x4c\x53", [0x535e] = "\x4c\xab",
  [0x5360] = "\x4d\x47", [0x5361] = "\x4d\x46", [0x5363] = "\x6a\x54",
  [0x5366] = "\x50\x59", [0x5369] = "\x48\x5a", [0x536c] = "\x69\x58",
  [0x536e] = "\x4d\x49", [0x536f] = "\x4d\x48", [0x5370] = "\x4d\xcc",
  [0x5371] = "\x4d\xcd", [0x5372] = "\x6a\x55", [0x5373] = "\x4e\xba",
  [0x5375] = "\x4e\xbb", [0x5377] = "\x50\x5a", [0x5378] = "\x50\x5b",
  [0x5379] = "\x50\x5c", [0x537b] = "\x52\x53", [0x537c] = "\x6d\x58",
  [0x537f] = "\x54\x6f", [0x5382] = "\x69\x45", [0x5384] = "\x4c\xac",
  [0x538a] = "\x69\xa4", [0x538e] = "\x6a\x56", [0x538f] = "\x6a\x57",
  [0x5392] = "\x6b\x7a", [0x5394] = "\x6b\x7b", [0x5396] = "\x6d\x5a",
  [0x5397] = "\x6d\x59", [0x5398] = "\x6d\x5c", [0x5399] = "\x6d\x5b",
  [0x539a] = "\x52\x54", [0x539c] = "\x72\x95", [0x539d] = "\x54\x71",
  [0x539e] = "\x6f\xb2", [0x539f] = "\x54\x70", [0x53a4] = "\x75\xc9",
  [0x53a5] = "\x59\x5c", [0x53a7] = "\x75\xca", [0x53ac] = "\x7d\x4f",
  [0x53ad] = "\x5e\x45", [0x53b2] = "\x60\x4f", [0x53b4] = "\x8b\x5e",
  [0x53b6] = "\x48\x5c", [0x53b9] = "\x69\x59", [0x53bb] = "\x4d\x4a",
  [0x53c3] = "\x56\xb5", [0x53c8] = "\x4c\x54", [0x53c9] = "\x4c\x66",
  [0x53ca] = "\x4c\xae", [0x53cb] = "\x4c\xad", [0x53cd] = "\x4c\xaf",
  [0x53d4] = "\x50\x5e", [0x53d6] = "\x50\x5d", [0x53d7] = "\x50\x5f",
  [0x53db] = "\x52\x55", [0x53df] = "\x54\x72", [0x53e1] = "\x83\xc6",
  [0x53e2] = "\x65\x5a", [0x53e3] = "\x4c\x67", [0x53e4] = "\x4d\x4c",
  [0x53e5] = "\x4d\x5b", [0x53e6] = "\x4d\x56", [0x53e8] = "\x4d\x51",
  [0x53e9] = "\x4d\x50", [0x53ea] = "\x4d\x57", [0x53eb] = "\x4d\x55",
  [0x53ec] = "\x4d\x4e", [0x53ed] = "\x4d\x5c", [0x53ee] = "\x4d\x4f",
  [0x53ef] = "\x4d\x4b", [0x53f0] = "\x4d\x5a", [0x53f1] = "\x4d\x59",
  [0x53f2] = "\x4d\x58", [0x53f3] = "\x4d\x4d", [0x53f5] = "\x4d\x54",
  [0x53f8] = "\x4d\x53", [0x53fb] = "\x4d\x5d", [0x53fc] = "\x4d\x52",
  [0x5401] = "\x4d\xd3", [0x5403] = "\x4d\xd9", [0x5404] = "\x4d\xd5",
  [0x5406] = "\x4d\xdb", [0x5407] = "\x69\xa5", [0x5408] = "\x4d\xd8",
  [0x5409] = "\x4d\xce", [0x540a] = "\x4d\xd1", [0x540b] = "\x4d\xd4",
  [0x540c] = "\x4d\xd0", [0x540d] = "\x4d\xd7", [0x540e] = "\x4d\xda",
  [0x540f] = "\x4d\xcf", [0x5410] = "\x4d\xd2", [0x5411] = "\x4d\xd6",
  [0x5412] = "\x4d\xdc", [0x5418] = "\x6a\x60", [0x5419] = "\x6a\x5d",
  [0x541b] = "\x4e\xc8", [0x541c] = "\x6a\x5e", [0x541d] = "\x4e\xbc",
  [0x541e] = "\x4e\xbe", [0x541f] = "\x4e\xd6", [0x5420] = "\x4e\xd1",
  [0x5424] = "\x6a\x65", [0x5425] = "\x6a\x5f", [0x5426] = "\x4e\xc0",
  [0x5427] = "\x4e\xc2", [0x5428] = "\x6a\x64", [0x5429] = "\x4e\xc9",
  [0x542a] = "\x6a\x5a", [0x542b] = "\x4e\xd5", [0x542c] = "\x4e\xd7",
  [0x542d] = "\x4e\xbd", [0x542e] = "\x4e\xce", [0x5430] = "\x6a\x58",
  [0x5431] = "\x4e\xd4", [0x5433] = "\x4e\xc5", [0x5435] = "\x4e\xcf",
  [0x5436] = "\x4e\xd0", [0x5437] = "\x6a\x59", [0x5438] = "\x4e\xcd",
  [0x5439] = "\x4e\xcb", [0x543b] = "\x4e\xcc", [0x543c] = "\x4e\xd2",
  [0x543d] = "\x6a\x61", [0x543e] = "\x4e\xbf", [0x5440] = "\x4e\xd3",
  [0x5441] = "\x6a\x63", [0x5442] = "\x4e\xc7", [0x5443] = "\x4e\xc4",
  [0x5445] = "\x6a\x5c", [0x5446] = "\x4e\xc3", [0x5447] = "\x6a\x66",
  [0x5448] = "\x4e\xc6", [0x544a] = "\x4e\xca", [0x544e] = "\x4e\xc1",
  [0x544f] = "\x6a\x62", [0x5454] = "\x6a\x5b", [0x5460] = "\x6b\x8d",
  [0x5461] = "\x6b\x8c", [0x5462] = "\x50\x71", [0x5463] = "\x6b\x8f",
  [0x5464] = "\x6b\x91", [0x5465] = "\x6b\x86", [0x5466] = "\x6b\x89",
  [0x5467] = "\x6b\x90", [0x5468] = "\x50\x72", [0x546b] = "\x6b\x83",
  [0x546c] = "\x6b\x87", [0x546f] = "\x6b\x8b", [0x5470] = "\x6d\x6b",
  [0x5471] = "\x50\x6d", [0x5472] = "\x6d\x6f", [0x5473] = "\x50\x60",
  [0x5474] = "\x6b\x88", [0x5475] = "\x50\x61", [0x5476] = "\x50\x6e",
  [0x5477] = "\x50\x67", [0x5478] = "\x50\x63", [0x547a] = "\x6b\x84",
  [0x547b] = "\x50\x66", [0x547c] = "\x50\x6b", [0x547d] = "\x50\x74",
  [0x547e] = "\x6b\x85", [0x547f] = "\x6b\x7d", [0x5480] = "\x50\x65",
  [0x5481] = "\x6b\x7e", [0x5482] = "\x6b\x81", [0x5484] = "\x50\x68",
  [0x5486] = "\x50\x6a", [0x5487] = "\x6b\x7c", [0x5488] = "\x6b\x82",
  [0x548b] = "\x50\x73", [0x548c] = "\x50\x6f", [0x548d] = "\x6b\x8a",
  [0x548e] = "\x50\x75", [0x5490] = "\x50\x6c", [0x5491] = "\x6b\x7f",
  [0x5492] = "\x50\x69", [0x5495] = "\x50\x64", [0x5496] = "\x50\x62",
  [0x5498] = "\x6b\x8e", [0x549a] = "\x50\x70", [0x54a0] = "\x6d\x6a",
  [0x54a1] = "\x6d\x5e", [0x54a2] = "\x6d\x6d", [0x54a5] = "\x6d\x60",
  [0x54a6] = "\x52\x5c", [0x54a7] = "\x52\x6a", [0x54a8] = "\x52\x58",
  [0x54a9] = "\x52\x69", [0x54aa] = "\x52\x61", [0x54ab] = "\x52\x66",
  [0x54ac] = "\x52\x56", [0x54ad] = "\x6d\x5f", [0x54ae] = "\x6d\x65",
  [0x54af] = "\x52\x65", [0x54b0] = "\x6d\x71", [0x54b1] = "\x52\x67",
  [0x54b3] = "\x52\x5d", [0x54b6] = "\x6d\x67", [0x54b7] = "\x6d\x64",
  [0x54b8] = "\x52\x5b", [0x54ba] = "\x6d\x5d", [0x54bb] = "\x52\x68",
  [0x54bc] = "\x6d\x6c", [0x54bd] = "\x52\x60", [0x54be] = "\x6d\x6e",
  [0x54bf] = "\x52\x6b", [0x54c0] = "\x52\x57", [0x54c1] = "\x52\x62",
  [0x54c2] = "\x52\x5f", [0x54c3] = "\x6d\x62", [0x54c4] = "\x52\x63",
  [0x54c5] = "\x6d\x68", [0x54c6] = "\x6d\x69", [0x54c7] = "\x52\x5e",
  [0x54c8] = "\x52\x64", [0x54c9] = "\x52\x5a", [0x54ce] = "\x52\x59",
  [0x54cf] = "\x6d\x61", [0x54d6] = "\x6d\x66", [0x54de] = "\x6d\x70",
  [0x54e0] = "\x6f\xc6", [0x54e1] = "\x54\x7f", [0x54e2] = "\x6f\xb4",
  [0x54e4] = "\x6f\xb9", [0x54e5] = "\x54\x78", [0x54e6] = "\x54\x84",
  [0x54e7] = "\x6f\xb7", [0x54e8] = "\x54\x73", [0x54e9] = "\x54\x7d",
  [0x54ea] = "\x54\x83", [0x54eb] = "\x6f\xbe", [0x54ed] = "\x54\x7e",
  [0x54ee] = "\x54\x82", [0x54f1] = "\x6f\xc1", [0x54f2] = "\x54\x79",
  [0x54f3] = "\x6f\xb8", [0x54f7] = "\x6f\xc4", [0x54f8] = "\x6f\xc5",
  [0x54fa] = "\x54\x7b", [0x54fb] = "\x6f\xc3", [0x54fc] = "\x54\x77",
  [0x54fd] = "\x54\x87", [0x54ff] = "\x6f\xbb", [0x5501] = "\x54\x75",
  [0x5503] = "\x6f\xc8", [0x5504] = "\x6f\xbc", [0x5505] = "\x6f\xc0",
  [0x5506] = "\x54\x7a", [0x5507] = "\x54\x86", [0x5508] = "\x6f\xbd",
  [0x5509] = "\x54\x81", [0x550a] = "\x6f\xc2", [0x550b] = "\x6f\xc9",
  [0x550c] = "\x72\xa4", [0x550e] = "\x6f\xc7", [0x550f] = "\x54\x88",
  [0x5510] = "\x54\x74", [0x5511] = "\x6f\xbf", [0x5512] = "\x6f\xb6",
  [0x5514] = "\x54\x7c", [0x5517] = "\x6f\xb5", [0x551a] = "\x6f\xba",
  [0x5526] = "\x6f\xb3", [0x5527] = "\x54\x85", [0x552a] = "\x72\x9c",
  [0x552c] = "\x56\xc8", [0x552d] = "\x72\xaa", [0x552e] = "\x56\xc6",
  [0x552f] = "\x56\xc3", [0x5530] = "\x72\xa1", [0x5531] = "\x56\xbf",
  [0x5532] = "\x72\xa5", [0x5533] = "\x56\xca", [0x5534] = "\x72\x9b",
  [0x5535] = "\x72\xa0", [0x5536] = "\x72\x9f", [0x5537] = "\x54\x76",
  [0x5538] = "\x56\xc5", [0x5539] = "\x72\xa8", [0x553b] = "\x72\xab",
  [0x553c] = "\x72\x98", [0x553e] = "\x59\x6e", [0x5540] = "\x72\xac",
  [0x5541] = "\x56\xcb", [0x5543] = "\x56\xbd", [0x5544] = "\x56\xba",
  [0x5545] = "\x72\xa3", [0x5546] = "\x56\xb7", [0x5548] = "\x72\xa9",
  [0x554a] = "\x56\xbe", [0x554b] = "\x72\xad", [0x554d] = "\x72\x99",
  [0x554e] = "\x72\xa7", [0x554f] = "\x56\xc1", [0x5550] = "\x72\x9a",
  [0x5551] = "\x72\x9d", [0x5552] = "\x72\xa2", [0x5555] = "\x56\xc2",
  [0x5556] = "\x56\xc0", [0x5557] = "\x56\xcc", [0x555c] = "\x56\xc7",
  [0x555e] = "\x56\xbb", [0x555f] = "\x57\x97", [0x5561] = "\x56\xbc",
  [0x5562] = "\x72\x9e", [0x5563] = "\x56\xc9", [0x5564] = "\x56\xc4",
  [0x5565] = "\x72\xa6", [0x5566] = "\x56\xb9", [0x556a] = "\x56\xb8",
  [0x5575] = "\x72\x96", [0x5576] = "\x72\x97", [0x5577] = "\x75\xcf",
  [0x557b] = "\x59\x5d", [0x557c] = "\x59\x60", [0x557d] = "\x75\xda",
  [0x557e] = "\x59\x74", [0x557f] = "\x75\xdd", [0x5580] = "\x59\x5e",
  [0x5581] = "\x75\xd6", [0x5582] = "\x59\x64", [0x5583] = "\x59\x6a",
  [0x5584] = "\x5a\xc2", [0x5587] = "\x59\x68", [0x5588] = "\x75\xd3",
  [0x5589] = "\x59\x75", [0x558a] = "\x59\x61", [0x558b] = "\x59\x69",
  [0x558c] = "\x75\xdb", [0x558d] = "\x79\x9e", [0x558e] = "\x75\xe0",
  [0x558f] = "\x75\xd4", [0x5591] = "\x75\xcb", [0x5592] = "\x75\xd8",
  [0x5593] = "\x75\xd2", [0x5594] = "\x59\x67", [0x5595] = "\x75\xde",
  [0x5598] = "\x59\x63", [0x5599] = "\x59\x77", [0x559a] = "\x59\x70",
  [0x559c] = "\x59\x65", [0x559d] = "\x59\x62", [0x559f] = "\x59\x6d",
  [0x55a1] = "\x75\xdf", [0x55a2] = "\x75\xd1", [0x55a3] = "\x75\xd7",
  [0x55a4] = "\x75\xd9", [0x55a5] = "\x75\xcd", [0x55a6] = "\x75\xdc",
  [0x55a7] = "\x59\x5f", [0x55a8] = "\x75\xcc", [0x55aa] = "\x59\x66",
  [0x55ab] = "\x59\x76", [0x55ac] = "\x59\x72", [0x55ad] = "\x75\xce",
  [0x55ae] = "\x59\x6c", [0x55b1] = "\x59\x73", [0x55b2] = "\x59\x6f",
  [0x55b3] = "\x59\x6b", [0x55b5] = "\x75\xd5", [0x55bb] = "\x59\x71",
  [0x55bf] = "\x79\x9c", [0x55c0] = "\x79\x98", [0x55c2] = "\x79\xa7",
  [0x55c3] = "\x79\x91", [0x55c4] = "\x79\x9a", [0x55c5] = "\x5b\xcb",
  [0x55c6] = "\x5b\xcc", [0x55c7] = "\x5b\xc4", [0x55c8] = "\x79\xa3",
  [0x55c9] = "\x5b\xce", [0x55ca] = "\x79\x96", [0x55cb] = "\x79\x95",
  [0x55cc] = "\x79\x93", [0x55cd] = "\x79\xa5", [0x55ce] = "\x5b\xc2",
  [0x55cf] = "\x79\x9f", [0x55d0] = "\x79\x94", [0x55d1] = "\x5b\xc5",
  [0x55d2] = "\x79\x9d", [0x55d3] = "\x5b\xc0", [0x55d4] = "\x79\x99",
  [0x55d5] = "\x79\xa0", [0x55d6] = "\x79\xa2", [0x55d9] = "\x79\xa6",
  [0x55da] = "\x5b\xc9", [0x55db] = "\x79\x92", [0x55dc] = "\x5b\xc3",
  [0x55dd] = "\x79\x97", [0x55df] = "\x5b\xbe", [0x55e1] = "\x5b\xca",
  [0x55e2] = "\x79\xa1", [0x55e3] = "\x5b\xc6", [0x55e4] = "\x5b\xc7",
  [0x55e5] = "\x5b\xcd", [0x55e6] = "\x5b\xc1", [0x55e7] = "\x46\xf7",
  [0x55e8] = "\x5b\xbf", [0x55e9] = "\x79\x9b", [0x55ef] = "\x5b\xc8",
  [0x55f2] = "\x79\xa4", [0x55f6] = "\x5e\x55", [0x55f7] = "\x5e\x50",
  [0x55f9] = "\x7d\x5e", [0x55fa] = "\x7d\x5a", [0x55fc] = "\x7d\x54",
  [0x55fd] = "\x5e\x4a", [0x55fe] = "\x5e\x46", [0x55ff] = "\x7d\x5d",
  [0x5600] = "\x5e\x47", [0x5601] = "\x7d\x57", [0x5602] = "\x7d\x59",
  [0x5604] = "\x7d\x5c", [0x5606] = "\x5e\x4c", [0x5608] = "\x5e\x53",
  [0x5609] = "\x5e\x4d", [0x560c] = "\x7d\x52", [0x560d] = "\x5e\x4e",
  [0x560e] = "\x5e\x4f", [0x560f] = "\x7d\x55", [0x5610] = "\x5e\x54",
  [0x5612] = "\x7d\x53", [0x5613] = "\x7d\x58", [0x5614] = "\x5e\x4b",
  [0x5615] = "\x7d\x51", [0x5616] = "\x5e\x51", [0x5617] = "\x5e\x49",
  [0x561b] = "\x5e\x48", [0x561c] = "\x7d\x56", [0x561d] = "\x7d\x5b",
  [0x561f] = "\x5e\x52", [0x5627] = "\x7d\x50", [0x5629] = "\x60\x56",
  [0x562a] = "\x80\x91", [0x562c] = "\x80\x8e", [0x562e] = "\x60\x50",
  [0x562f] = "\x60\x5c", [0x5630] = "\x60\x5d", [0x5632] = "\x60\x53",
  [0x5633] = "\x80\x8c", [0x5634] = "\x60\x55", [0x5635] = "\x80\x84",
  [0x5636] = "\x60\x5b", [0x5638] = "\x80\x90", [0x5639] = "\x60\x52",
  [0x563a] = "\x80\x92", [0x563b] = "\x60\x51", [0x563d] = "\x80\x8d",
  [0x563e] = "\x80\x8f", [0x563f] = "\x60\x54", [0x5640] = "\x80\x8b",
  [0x5641] = "\x80\x85", [0x5642] = "\x80\x82", [0x5645] = "\x75\xd0",
  [0x5646] = "\x80\x88", [0x5648] = "\x80\x81", [0x5649] = "\x80\x87",
  [0x564a] = "\x80\x86", [0x564c] = "\x80\x83", [0x564e] = "\x60\x58",
  [0x5653] = "\x60\x57", [0x5657] = "\x60\x59", [0x5658] = "\x80\x89",
  [0x5659] = "\x62\x5b", [0x565a] = "\x80\x8a", [0x565e] = "\x83\xcf",
  [0x5660] = "\x83\xc8", [0x5662] = "\x62\x67", [0x5663] = "\x83\xcc",
  [0x5664] = "\x62\x5f", [0x5665] = "\x62\x63", [0x5666] = "\x83\xcb",
  [0x5668] = "\x62\x62", [0x5669] = "\x62\x5e", [0x566a] = "\x62\x61",
  [0x566b] = "\x62\x5c", [0x566c] = "\x62\x66", [0x566d] = "\x83\xcd",
  [0x566e] = "\x83\xc9", [0x566f] = "\x62\x65", [0x5670] = "\x83\xc7",
  [0x5671] = "\x62\x64", [0x5672] = "\x83\xce", [0x5673] = "\x83\xca",
  [0x5674] = "\x60\x5a", [0x5676] = "\x62\x68", [0x5677] = "\x83\xd0",
  [0x5678] = "\x62\x60", [0x5679] = "\x62\x5d", [0x567e] = "\x86\xd1",
  [0x567f] = "\x86\xd3", [0x5680] = "\x63\xc5", [0x5681] = "\x86\xd4",
  [0x5682] = "\x86\xd2", [0x5683] = "\x86\xd0", [0x5684] = "\x86\xcf",
  [0x5685] = "\x63\xc7", [0x5686] = "\x86\xce", [0x5687] = "\x63\xc8",
  [0x568c] = "\x86\xcc", [0x568d] = "\x86\xcd", [0x568e] = "\x63\xc4",
  [0x568f] = "\x63\xc9", [0x5690] = "\x63\xc6", [0x5693] = "\x86\xcb",
  [0x5695] = "\x65\x5b", [0x5697] = "\x89\x69", [0x5698] = "\x89\x67",
  [0x5699] = "\x89\x6c", [0x569a] = "\x89\x6a", [0x569c] = "\x89\x68",
  [0x569d] = "\x89\x6b", [0x56a5] = "\x66\x4c", [0x56a6] = "\x8b\x61",
  [0x56a7] = "\x8b\x62", [0x56a8] = "\x66\xe0", [0x56aa] = "\x8b\x63",
  [0x56ab] = "\x8b\x5f", [0x56ac] = "\x8b\x64", [0x56ad] = "\x8b\x60",
  [0x56ae] = "\x65\x5c", [0x56b2] = "\x8c\xec", [0x56b3] = "\x8c\xee",
  [0x56b4] = "\x66\xe3", [0x56b5] = "\x8c\xed", [0x56b6] = "\x66\xe2",
  [0x56b7] = "\x66\xe1", [0x56bc] = "\x66\xe4", [0x56bd] = "\x8e\x74",
  [0x56be] = "\x8e\x75", [0x56c0] = "\x67\x86", [0x56c1] = "\x67\x85",
  [0x56c2] = "\x67\x87", [0x56c3] = "\x8e\x73", [0x56c5] = "\x8f\x68",
  [0x56c6] = "\x8f\x67", [0x56c8] = "\x67\xd8", [0x56c9] = "\x67\xda",
  [0x56ca] = "\x67\xd9", [0x56cb] = "\x8f\x69", [0x56cc] = "\x68\x54",
  [0x56cd] = "\x90\xb5", [0x56d1] = "\x68\x7d", [0x56d3] = "\x90\xb4",
  [0x56d4] = "\x90\xfd", [0x56d7] = "\x69\x4a", [0x56da] = "\x4d\x5f",
  [0x56db] = "\x4d\x5e", [0x56dd] = "\x4d\xdf", [0x56de] = "\x4d\xde",
  [0x56df] = "\x69\xa7", [0x56e0] = "\x4d\xdd", [0x56e1] = "\x69\xa6",
  [0x56e4] = "\x4e\xda", [0x56e5] = "\x6a\x69", [0x56e7] = "\x6a\x68",
  [0x56ea] = "\x4e\xd8", [0x56eb] = "\x4e\xdb", [0x56ee] = "\x6a\x67",
  [0x56f0] = "\x4e\xd9", [0x56f7] = "\x6b\x92", [0x56f9] = "\x6b\x93",
  [0x56fa] = "\x50\x76", [0x56ff] = "\x52\x6c", [0x5701] = "\x6f\xca",
  [0x5702] = "\x6f\xcb", [0x5703] = "\x54\x89", [0x5704] = "\x54\x8a",
  [0x5707] = "\x72\xaf", [0x5708] = "\x56\xcd", [0x5709] = "\x56\xcf",
  [0x570a] = "\x72\xae", [0x570b] = "\x56\xce", [0x570c] = "\x75\xe1",
  [0x570d] = "\x59\x78", [0x5712] = "\x5b\xcf", [0x5713] = "\x5b\xd0",
  [0x5714] = "\x79\xa8", [0x5716] = "\x5e\x57", [0x5718] = "\x5e\x56",
  [0x571a] = "\x80\x93", [0x571b] = "\x83\xd2", [0x571c] = "\x83\xd1",
  [0x571e] = "\x91\x7c", [0x571f] = "\x4c\x68", [0x5720] = "\x69\x5a",
  [0x5722] = "\x69\x6f", [0x5723] = "\x69\x70", [0x5728] = "\x4d\xe2",
  [0x5729] = "\x4d\xe6", [0x572a] = "\x69\xa9", [0x572c] = "\x4d\xe4",
  [0x572d] = "\x4d\xe3", [0x572e] = "\x69\xa8", [0x572f] = "\x4d\xe5",
  [0x5730] = "\x4d\xe1", [0x5733] = "\x4d\xe0", [0x5734] = "\x69\xaa",
  [0x573b] = "\x4e\xe5", [0x573e] = "\x4e\xe2", [0x5740] = "\x4e\xde",
  [0x5741] = "\x6a\x6a", [0x5745] = "\x6a\x6b", [0x5747] = "\x4e\xe0",
  [0x5749] = "\x6a\x6d", [0x574a] = "\x4e\xdc", [0x574b] = "\x6a\x6e",
  [0x574c] = "\x6a\x6c", [0x574d] = "\x4e\xdf", [0x574e] = "\x4e\xe1",
  [0x574f] = "\x4e\xe4", [0x5750] = "\x4e\xe3", [0x5751] = "\x4e\xdd",
  [0x5752] = "\x6a\x6f", [0x5761] = "\x50\x7b", [0x5762] = "\x6b\xa0",
  [0x5764] = "\x50\x7d", [0x5766] = "\x50\x7c", [0x5768] = "\x6b\xa1",
  [0x5769] = "\x50\x7a", [0x576a] = "\x50\x79", [0x576b] = "\x6b\x97",
  [0x576d] = "\x6b\x96", [0x576f] = "\x6b\x94", [0x5770] = "\x6b\x99",
  [0x5771] = "\x6b\x98", [0x5772] = "\x6b\x95", [0x5773] = "\x6b\x9e",
  [0x5774] = "\x6b\x9f", [0x5775] = "\x6b\x9c", [0x5776] = "\x6b\x9a",
  [0x5777] = "\x50\x78", [0x577b] = "\x6b\x9d", [0x577c] = "\x50\x7e",
  [0x577d] = "\x6b\xa2", [0x5780] = "\x6b\x9b", [0x5782] = "\x52\x6d",
  [0x5783] = "\x50\x77", [0x578b] = "\x52\x6e", [0x578c] = "\x6d\x76",
  [0x578f] = "\x6d\x7c", [0x5793] = "\x52\x74", [0x5794] = "\x6d\x7a",
  [0x5795] = "\x6d\x81", [0x5797] = "\x6d\x77", [0x5798] = "\x6d\x7b",
  [0x5799] = "\x6d\x7d", [0x579a] = "\x6d\x7f", [0x579b] = "\x6d\x79",
  [0x579d] = "\x6d\x78", [0x579e] = "\x6d\x73", [0x579f] = "\x6d\x74",
  [0x57a0] = "\x52\x6f", [0x57a2] = "\x52\x71", [0x57a3] = "\x52\x70",
  [0x57a4] = "\x6d\x75", [0x57a5] = "\x6d\x7e", [0x57ae] = "\x52\x73",
  [0x57b5] = "\x6d\x72", [0x57b6] = "\x6f\xd5", [0x57b8] = "\x6f\xd4",
  [0x57b9] = "\x6f\xd9", [0x57ba] = "\x6f\xd0", [0x57bc] = "\x6f\xd3",
  [0x57bd] = "\x6f\xd2", [0x57bf] = "\x6f\xd6", [0x57c1] = "\x6f\xda",
  [0x57c2] = "\x54\x8b", [0x57c3] = "\x54\x8e", [0x57c6] = "\x6f\xd1",
  [0x57c7] = "\x6f\xd7", [0x57cb] = "\x54\x8d", [0x57cc] = "\x6f\xcc",
  [0x57ce] = "\x52\x72", [0x57cf] = "\x72\xbd", [0x57d0] = "\x6f\xd8",
  [0x57d2] = "\x6f\xcf", [0x57d4] = "\x54\x8c", [0x57d5] = "\x6f\xce",
  [0x57dc] = "\x72\xb4", [0x57df] = "\x56\xd0", [0x57e0] = "\x56\xd4",
  [0x57e1] = "\x72\xc4", [0x57e2] = "\x72\xb2", [0x57e3] = "\x72\xc0",
  [0x57e4] = "\x56\xd5", [0x57e5] = "\x72\xc2", [0x57e7] = "\x72\xc8",
  [0x57e9] = "\x72\xcc", [0x57ec] = "\x72\xc3", [0x57ed] = "\x72\xb7",
  [0x57ee] = "\x72\xbf", [0x57f0] = "\x72\xcd", [0x57f1] = "\x72\xcb",
  [0x57f2] = "\x72\xc1", [0x57f3] = "\x72\xbc", [0x57f4] = "\x72\xb5",
  [0x57f5] = "\x75\xe9", [0x57f6] = "\x72\xb3", [0x57f7] = "\x56\xd9",
  [0x57f8] = "\x72\xba", [0x57f9] = "\x56\xda", [0x57fa] = "\x56\xd6",
  [0x57fb] = "\x72\xb0", [0x57fc] = "\x72\xc6", [0x57fd] = "\x72\xb8",
  [0x5800] = "\x72\xb6", [0x5801] = "\x72\xc9", [0x5802] = "\x56\xd7",
  [0x5804] = "\x72\xcf", [0x5805] = "\x56\xd1", [0x5806] = "\x56\xd3",
  [0x5807] = "\x72\xbe", [0x5808] = "\x72\xb9", [0x5809] = "\x54\x8f",
  [0x580a] = "\x56\xd2", [0x580b] = "\x72\xbb", [0x580c] = "\x72\xca",
  [0x580d] = "\x72\xce", [0x580e] = "\x72\xc5", [0x5810] = "\x72\xc7",
  [0x5814] = "\x72\xb1", [0x5819] = "\x75\xe4", [0x581b] = "\x75\xed",
  [0x581c] = "\x75\xec", [0x581d] = "\x59\x81", [0x581e] = "\x75\xe5",
  [0x5820] = "\x59\x82", [0x5821] = "\x59\x7f", [0x5823] = "\x75\xe7",
  [0x5824] = "\x59\x7c", [0x5825] = "\x75\xeb", [0x5827] = "\x75\xe6",
  [0x5828] = "\x75\xe8", [0x5829] = "\x75\xe2", [0x582a] = "\x59\x7a",
  [0x582c] = "\x75\xf5", [0x582d] = "\x75\xf4", [0x582e] = "\x75\xf1",
  [0x582f] = "\x59\x79", [0x5830] = "\x59\x7d", [0x5831] = "\x59\x7e",
  [0x5832] = "\x6f\xcd", [0x5833] = "\x75\xee", [0x5834] = "\x59\x7b",
  [0x5835] = "\x56\xd8", [0x5836] = "\x75\xf0", [0x5837] = "\x75\xe3",
  [0x5838] = "\x75\xf3", [0x5839] = "\x75\xf2", [0x583b] = "\x75\xf6",
  [0x583d] = "\x79\xb6", [0x583f] = "\x75\xef", [0x5848] = "\x75\xea",
  [0x5849] = "\x79\xae", [0x584a] = "\x5b\xda", [0x584b] = "\x5b\xdd",
  [0x584c] = "\x5b\xd8", [0x584d] = "\x79\xad", [0x584e] = "\x79\xb1",
  [0x584f] = "\x79\xac", [0x5851] = "\x5b\xd2", [0x5852] = "\x5b\xdc",
  [0x5853] = "\x79\xa9", [0x5854] = "\x5b\xd6", [0x5855] = "\x79\xb0",
  [0x5857] = "\x5b\xd4", [0x5858] = "\x5b\xd3", [0x5859] = "\x79\xb3",
  [0x585a] = "\x5b\xd5", [0x585b] = "\x79\xb5", [0x585d] = "\x79\xb2",
  [0x585e] = "\x5b\xd1", [0x5862] = "\x5b\xdb", [0x5863] = "\x79\xb7",
  [0x5864] = "\x79\xab", [0x5865] = "\x79\xb4", [0x5868] = "\x79\xaa",
  [0x586b] = "\x5b\xd7", [0x586d] = "\x5b\xd9", [0x586f] = "\x79\xaf",
  [0x5871] = "\x79\xb8", [0x5874] = "\x7d\x66", [0x5875] = "\x5e\x58",
  [0x5876] = "\x7d\x6c", [0x5879] = "\x5e\x5d", [0x587a] = "\x7d\x68",
  [0x587b] = "\x7d\x6f", [0x587c] = "\x7d\x60", [0x587d] = "\x5e\x5f",
  [0x587e] = "\x5e\x59", [0x587f] = "\x7d\x65", [0x5880] = "\x60\x5e",
  [0x5881] = "\x7d\x64", [0x5882] = "\x7d\x6d", [0x5883] = "\x5e\x5a",
  [0x5885] = "\x5e\x5e", [0x5886] = "\x7d\x63", [0x5887] = "\x7d\x69",
  [0x5888] = "\x7d\x6e", [0x5889] = "\x7d\x5f", [0x588a] = "\x5e\x5c",
  [0x588b] = "\x7d\x67", [0x588e] = "\x7d\x6b", [0x588f] = "\x7d\x71",
  [0x5890] = "\x7d\x61", [0x5891] = "\x7d\x6a", [0x5893] = "\x5e\x5b",
  [0x5894] = "\x7d\x70", [0x5898] = "\x7d\x62", [0x589c] = "\x60\x62",
  [0x589d] = "\x80\x95", [0x589e] = "\x60\x60", [0x589f] = "\x60\x5f",
  [0x58a0] = "\x80\x97", [0x58a1] = "\x80\x9c", [0x58a3] = "\x80\x98",
  [0x58a5] = "\x80\x9b", [0x58a6] = "\x60\x65", [0x58a8] = "\x62\x4e",
  [0x58a9] = "\x60\x64", [0x58ab] = "\x80\x94", [0x58ac] = "\x80\x9a",
  [0x58ae] = "\x60\x63", [0x58af] = "\x80\x99", [0x58b1] = "\x80\x96",
  [0x58b3] = "\x60\x61", [0x58ba] = "\x83\xd7", [0x58bc] = "\x83\xd9",
  [0x58bd] = "\x83\xd4", [0x58be] = "\x62\x6a", [0x58bf] = "\x83\xd6",
  [0x58c1] = "\x62\x69", [0x58c2] = "\x83\xd8", [0x58c5] = "\x62\x6c",
  [0x58c6] = "\x83\xda", [0x58c7] = "\x62\x6b", [0x58c8] = "\x83\xd3",
  [0x58c9] = "\x83\xd5", [0x58ce] = "\x63\xcd", [0x58cf] = "\x86\xd7",
  [0x58d1] = "\x63\xcc", [0x58d2] = "\x86\xd8", [0x58d3] = "\x63\xcb",
  [0x58d4] = "\x86\xd6", [0x58d5] = "\x63\xca", [0x58d6] = "\x86\xd5",
  [0x58d8] = "\x65\x5e", [0x58d9] = "\x65\x5d", [0x58da] = "\x8b\x65",
  [0x58db] = "\x8b\x67", [0x58dd] = "\x8b\x66", [0x58de] = "\x66\x4d",
  [0x58df] = "\x66\x4e", [0x58e2] = "\x66\x4f", [0x58e3] = "\x8c\xef",
  [0x58e4] = "\x66\xe5", [0x58e7] = "\x90\x44", [0x58e8] = "\x90\x43",
  [0x58e9] = "\x68\x7e", [0x58eb] = "\x4c\x69", [0x58ec] = "\x4c\xb0",
  [0x58ef] = "\x4e\xe6", [0x58f4] = "\x6d\x82", [0x58f9] = "\x59\x83",
  [0x58fa] = "\x59\x84", [0x58fc] = "\x79\xb9", [0x58fd] = "\x5e\x60",
  [0x58fe] = "\x7d\x72", [0x58ff] = "\x80\x9d", [0x5903] = "\x69\x5b",
  [0x5906] = "\x6a\x70", [0x590a] = "\x48\x62", [0x590c] = "\x6b\xa3",
  [0x590d] = "\x6d\x83", [0x590e] = "\x6f\xdb", [0x590f] = "\x54\x90",
  [0x5912] = "\x8b\x68", [0x5914] = "\x67\x88", [0x5915] = "\x4c\x6a",
  [0x5916] = "\x4d\x60", [0x5917] = "\x69\x71", [0x5919] = "\x4d\xe7",
  [0x591a] = "\x4d\xe8", [0x591c] = "\x50\x7f", [0x5920] = "\x56\xdb",
  [0x5922] = "\x5e\x62", [0x5924] = "\x5e\x63", [0x5925] = "\x5e\x61",
  [0x5927] = "\x4c\x6b", [0x5929] = "\x4c\xb1", [0x592a] = "\x4c\xb3",
  [0x592b] = "\x4c\xb2", [0x592c] = "\x69\x5c", [0x592d] = "\x4c\xb4",
  [0x592e] = "\x4d\x61", [0x592f] = "\x69\x72", [0x5931] = "\x4d\x62",
  [0x5937] = "\x4d\xe9", [0x5938] = "\x4d\xea", [0x593c] = "\x69\xab",
  [0x593e] = "\x4e\xe7", [0x5940] = "\x6a\x71", [0x5944] = "\x50\x84",
  [0x5945] = "\x6b\xa4", [0x5947] = "\x50\x82", [0x5948] = "\x50\x83",
  [0x5949] = "\x50\x81", [0x594a] = "\x6f\xdc", [0x594e] = "\x52\x78",
  [0x594f] = "\x52\x77", [0x5950] = "\x52\x79", [0x5951] = "\x52\x76",
  [0x5953] = "\x6d\x84", [0x5954] = "\x50\x85", [0x5955] = "\x52\x75",
  [0x5957] = "\x54\x91", [0x5958] = "\x54\x92", [0x595a] = "\x54\x93",
  [0x595c] = "\x72\xd0", [0x5960] = "\x59\x85", [0x5961] = "\x75\xf7",
  [0x5962] = "\x56\xdc", [0x5967] = "\x5b\xde", [0x5969] = "\x5e\x65",
  [0x596a] = "\x5e\x64", [0x596b] = "\x7d\x73", [0x596d] = "\x60\x66",
  [0x596e] = "\x62\x6d", [0x5970] = "\x89\x6d", [0x5971] = "\x8f\x6a",
  [0x5972] = "\x90\x45", [0x5973] = "\x4c\x6c", [0x5974] = "\x4d\x63",
  [0x5976] = "\x4d\x64", [0x5977] = "\x69\xb1", [0x5978] = "\x4d\xec",
  [0x5979] = "\x4d\xef", [0x597b] = "\x69\xaf", [0x597c] = "\x69\xad",
  [0x597d] = "\x4d\xee", [0x597e] = "\x69\xb0", [0x597f] = "\x69\xb2",
  [0x5980] = "\x69\xac", [0x5981] = "\x4d\xf1", [0x5982] = "\x4d\xf0",
  [0x5983] = "\x4d\xed", [0x5984] = "\x4d\xeb", [0x5985] = "\x69\xae",
  [0x598a] = "\x4e\xf2", [0x598d] = "\x4e\xef", [0x598e] = "\x6a\x76",
  [0x598f] = "\x6a\x79", [0x5990] = "\x6a\x78", [0x5992] = "\x4e\xe9",
  [0x5993] = "\x4e\xf1", [0x5996] = "\x4e\xee", [0x5997] = "\x6a\x75",
  [0x5998] = "\x6a\x73", [0x5999] = "\x4e\xed", [0x599d] = "\x4e\xe8",
  [0x599e] = "\x4e\xeb", [0x59a0] = "\x6a\x74", [0x59a1] = "\x6a\x7b",
  [0x59a2] = "\x6a\x77", [0x59a3] = "\x4e\xec", [0x59a4] = "\x4e\xf0",
  [0x59a5] = "\x4e\xf3", [0x59a6] = "\x6a\x72", [0x59a7] = "\x6a\x7a",
  [0x59a8] = "\x4e\xea", [0x59ae] = "\x50\x8a", [0x59af] = "\x50\x92",
  [0x59b1] = "\x6b\xb0", [0x59b2] = "\x6b\xa9", [0x59b3] = "\x50\x93",
  [0x59b4] = "\x6b\xb4", [0x59b5] = "\x6b\xa5", [0x59b6] = "\x6b\xac",
  [0x59b9] = "\x50\x89", [0x59ba] = "\x6b\xa6", [0x59bb] = "\x50\x87",
  [0x59bc] = "\x6b\xad", [0x59bd] = "\x6b\xb1", [0x59be] = "\x50\x86",
  [0x59c0] = "\x6b\xb2", [0x59c1] = "\x6b\xab", [0x59c3] = "\x6b\xae",
  [0x59c5] = "\x50\x95", [0x59c6] = "\x50\x8c", [0x59c7] = "\x6b\xb5",
  [0x59c8] = "\x6b\xb3", [0x59ca] = "\x50\x91", [0x59cb] = "\x50\x8f",
  [0x59cc] = "\x6b\xaa", [0x59cd] = "\x50\x8e", [0x59ce] = "\x6b\xa8",
  [0x59cf] = "\x6b\xa7", [0x59d0] = "\x50\x8d", [0x59d1] = "\x50\x8b",
  [0x59d2] = "\x50\x94", [0x59d3] = "\x50\x90", [0x59d4] = "\x50\x88",
  [0x59d6] = "\x6b\xaf", [0x59d8] = "\x52\x7b", [0x59da] = "\x52\x83",
  [0x59db] = "\x6d\x92", [0x59dc] = "\x52\x7a", [0x59dd] = "\x6d\x8a",
  [0x59de] = "\x6d\x86", [0x59e0] = "\x6d\x96", [0x59e1] = "\x6d\x85",
  [0x59e3] = "\x52\x7d", [0x59e4] = "\x6d\x8f", [0x59e5] = "\x52\x81",
  [0x59e6] = "\x52\x84", [0x59e8] = "\x52\x7e", [0x59e9] = "\x6d\x93",
  [0x59ea] = "\x52\x82", [0x59ec] = "\x54\x9a", [0x59ed] = "\x6d\x99",
  [0x59ee] = "\x6d\x87", [0x59f1] = "\x6d\x89", [0x59f2] = "\x6d\x90",
  [0x59f3] = "\x6d\x94", [0x59f4] = "\x6d\x98", [0x59f5] = "\x6d\x95",
  [0x59f6] = "\x6d\x8e", [0x59f7] = "\x6d\x91", [0x59fa] = "\x6d\x8b",
  [0x59fb] = "\x52\x86", [0x59fc] = "\x6d\x8d", [0x59fd] = "\x6d\x8c",
  [0x59fe] = "\x6d\x97", [0x59ff] = "\x52\x7c", [0x5a00] = "\x6d\x88",
  [0x5a01] = "\x52\x85", [0x5a03] = "\x52\x7f", [0x5a09] = "\x54\xa0",
  [0x5a0a] = "\x6f\xe4", [0x5a0c] = "\x54\x9f", [0x5a0f] = "\x6f\xe2",
  [0x5a11] = "\x54\x94", [0x5a13] = "\x54\x99", [0x5a15] = "\x6f\xe1",
  [0x5a16] = "\x6f\xde", [0x5a17] = "\x6f\xe3", [0x5a18] = "\x54\x95",
  [0x5a19] = "\x6f\xdd", [0x5a1b] = "\x54\x98", [0x5a1c] = "\x54\x96",
  [0x5a1e] = "\x6f\xe5", [0x5a1f] = "\x54\x97", [0x5a20] = "\x54\x9b",
  [0x5a23] = "\x54\x9c", [0x5a25] = "\x54\x9e", [0x5a29] = "\x54\x9d",
  [0x5a2d] = "\x6f\xdf", [0x5a2e] = "\x6f\xe0", [0x5a33] = "\x6f\xe6",
  [0x5a35] = "\x72\xd7", [0x5a36] = "\x56\xdd", [0x5a37] = "\x76\x48",
  [0x5a38] = "\x72\xd6", [0x5a39] = "\x72\xe9", [0x5a3c] = "\x56\xe3",
  [0x5a3e] = "\x72\xe7", [0x5a40] = "\x56\xe2", [0x5a41] = "\x56\xde",
  [0x5a42] = "\x72\xf0", [0x5a43] = "\x72\xe0", [0x5a44] = "\x72\xe3",
  [0x5a46] = "\x56\xe6", [0x5a47] = "\x72\xed", [0x5a48] = "\x72\xe5",
  [0x5a49] = "\x56\xdf", [0x5a4a] = "\x56\xe7", [0x5a4c] = "\x72\xea",
  [0x5a4d] = "\x72\xe8", [0x5a50] = "\x72\xd9", [0x5a51] = "\x72\xee",
  [0x5a52] = "\x72\xe2", [0x5a53] = "\x72\xdd", [0x5a55] = "\x72\xd3",
  [0x5a56] = "\x72\xef", [0x5a57] = "\x72\xdf", [0x5a58] = "\x72\xd2",
  [0x5a5a] = "\x56\xe5", [0x5a5b] = "\x72\xe4", [0x5a5c] = "\x72\xf1",
  [0x5a5d] = "\x72\xe1", [0x5a5e] = "\x72\xd5", [0x5a5f] = "\x72\xda",
  [0x5a60] = "\x72\xd1", [0x5a62] = "\x56\xe4", [0x5a64] = "\x72\xde",
  [0x5a65] = "\x72\xdb", [0x5a66] = "\x56\xe0", [0x5a67] = "\x72\xd4",
  [0x5a69] = "\x72\xec", [0x5a6a] = "\x56\xe1", [0x5a6c] = "\x72\xdc",
  [0x5a6d] = "\x72\xd8", [0x5a70] = "\x72\xeb", [0x5a77] = "\x59\x86",
  [0x5a78] = "\x76\x41", [0x5a7a] = "\x75\xfb", [0x5a7b] = "\x76\x4f",
  [0x5a7c] = "\x76\x43", [0x5a7d] = "\x76\x50", [0x5a7f] = "\x59\x88",
  [0x5a83] = "\x76\x4c", [0x5a84] = "\x76\x49", [0x5a8a] = "\x76\x4a",
  [0x5a8b] = "\x76\x4d", [0x5a8c] = "\x76\x51", [0x5a8e] = "\x72\xe6",
  [0x5a8f] = "\x76\x53", [0x5a90] = "\x79\xcd", [0x5a92] = "\x59\x89",
  [0x5a93] = "\x76\x54", [0x5a94] = "\x75\xf9", [0x5a95] = "\x76\x46",
  [0x5a97] = "\x76\x4b", [0x5a9a] = "\x59\x87", [0x5a9b] = "\x59\x8a",
  [0x5a9c] = "\x76\x52", [0x5a9d] = "\x76\x55", [0x5a9e] = "\x75\xfd",
  [0x5a9f] = "\x75\xfa", [0x5aa2] = "\x75\xfc", [0x5aa5] = "\x76\x44",
  [0x5aa6] = "\x76\x42", [0x5aa7] = "\x59\x8b", [0x5aa9] = "\x76\x4e",
  [0x5aac] = "\x76\x45", [0x5aae] = "\x76\x47", [0x5aaf] = "\x75\xf8",
  [0x5ab0] = "\x79\xc1", [0x5ab1] = "\x79\xbf", [0x5ab2] = "\x5b\xe7",
  [0x5ab3] = "\x5b\xe5", [0x5ab4] = "\x79\xc9", [0x5ab5] = "\x79\xc0",
  [0x5ab6] = "\x79\xca", [0x5ab7] = "\x79\xc6", [0x5ab8] = "\x79\xbe",
  [0x5ab9] = "\x79\xcc", [0x5aba] = "\x79\xbd", [0x5abb] = "\x79\xc4",
  [0x5abc] = "\x5b\xe4", [0x5abd] = "\x5b\xe3", [0x5abe] = "\x5b\xe2",
  [0x5abf] = "\x79\xc2", [0x5ac0] = "\x79\xc7", [0x5ac1] = "\x5b\xdf",
  [0x5ac2] = "\x5b\xe6", [0x5ac4] = "\x79\xbb", [0x5ac6] = "\x79\xc5",
  [0x5ac7] = "\x79\xba", [0x5ac8] = "\x79\xc3", [0x5ac9] = "\x5b\xe0",
  [0x5aca] = "\x79\xc8", [0x5acb] = "\x79\xbc", [0x5acc] = "\x5b\xe1",
  [0x5acd] = "\x79\xcb", [0x5ad5] = "\x7d\x77", [0x5ad6] = "\x5e\x6a",
  [0x5ad7] = "\x5e\x69", [0x5ad8] = "\x5e\x6b", [0x5ad9] = "\x7d\x84",
  [0x5ada] = "\x7d\x79", [0x5adb] = "\x7d\x7f", [0x5adc] = "\x7d\x74",
  [0x5add] = "\x7d\x83", [0x5ade] = "\x7d\x82", [0x5adf] = "\x7d\x86",
  [0x5ae0] = "\x7d\x7e", [0x5ae1] = "\x5e\x66", [0x5ae2] = "\x7d\x7d",
  [0x5ae3] = "\x5e\x6c", [0x5ae5] = "\x7d\x76", [0x5ae6] = "\x5e\x67",
  [0x5ae8] = "\x7d\x85", [0x5ae9] = "\x5e\x68", [0x5aea] = "\x7d\x78",
  [0x5aeb] = "\x7d\x7b", [0x5aec] = "\x7d\x81", [0x5aed] = "\x7d\x7a",
  [0x5aee] = "\x7d\x75", [0x5af3] = "\x7d\x7c", [0x5af4] = "\x80\x9f",
  [0x5af5] = "\x60\x6a", [0x5af6] = "\x80\xa2", [0x5af7] = "\x80\xa1",
  [0x5af8] = "\x80\xa4", [0x5af9] = "\x80\xa6", [0x5afb] = "\x60\x68",
  [0x5afd] = "\x80\xa0", [0x5aff] = "\x80\x9e", [0x5b01] = "\x80\xa7",
  [0x5b02] = "\x80\xa5", [0x5b03] = "\x80\xa3", [0x5b05] = "\x80\xa9",
  [0x5b07] = "\x80\xa8", [0x5b08] = "\x60\x6c", [0x5b09] = "\x60\x67",
  [0x5b0b] = "\x60\x69", [0x5b0c] = "\x60\x6b", [0x5b0f] = "\x80\xaa",
  [0x5b10] = "\x83\xe1", [0x5b13] = "\x83\xe0", [0x5b14] = "\x83\xdf",
  [0x5b16] = "\x83\xe2", [0x5b17] = "\x83\xdb", [0x5b19] = "\x83\xdc",
  [0x5b1a] = "\x83\xe4", [0x5b1b] = "\x83\xdd", [0x5b1d] = "\x62\x6e",
  [0x5b1e] = "\x83\xe6", [0x5b20] = "\x83\xe5", [0x5b21] = "\x83\xde",
  [0x5b23] = "\x86\xdc", [0x5b24] = "\x63\xd0", [0x5b25] = "\x86\xda",
  [0x5b26] = "\x86\xdf", [0x5b27] = "\x86\xde", [0x5b28] = "\x83\xe3",
  [0x5b2a] = "\x63\xcf", [0x5b2c] = "\x86\xdd", [0x5b2d] = "\x86\xd9",
  [0x5b2e] = "\x86\xe1", [0x5b2f] = "\x86\xe0", [0x5b30] = "\x63\xce",
  [0x5b32] = "\x86\xdb", [0x5b34] = "\x62\x6f", [0x5b38] = "\x65\x5f",
  [0x5b3c] = "\x89\x6e", [0x5b3d] = "\x8b\x69", [0x5b3e] = "\x8b\x6a",
  [0x5b3f] = "\x8b\x6b", [0x5b40] = "\x66\xe6", [0x5b43] = "\x66\xe7",
  [0x5b45] = "\x8c\xf0", [0x5b47] = "\x8e\x77", [0x5b48] = "\x8e\x76",
  [0x5b4b] = "\x8f\x6b", [0x5b4c] = "\x8f\x6c", [0x5b4d] = "\x90\x46",
  [0x5b4e] = "\x90\xb6", [0x5b50] = "\x4c\x6d", [0x5b51] = "\x4c\x6e",
  [0x5b53] = "\x4c\x6f", [0x5b54] = "\x4c\xb5", [0x5b55] = "\x4d\x65",
  [0x5b56] = "\x69\xb3", [0x5b57] = "\x4d\xf2", [0x5b58] = "\x4d\xf3",
  [0x5b5a] = "\x4e\xf6", [0x5b5b] = "\x4e\xf7", [0x5b5c] = "\x4e\xf5",
  [0x5b5d] = "\x4e\xf4", [0x5b5f] = "\x50\x96", [0x5b62] = "\x6b\xb6",
  [0x5b63] = "\x50\x98", [0x5b64] = "\x50\x97", [0x5b65] = "\x6b\xb7",
  [0x5b69] = "\x52\x87", [0x5b6b] = "\x54\xa1", [0x5b6c] = "\x6f\xe7",
  [0x5b6e] = "\x72\xf3", [0x5b70] = "\x56\xe8", [0x5b71] = "\x59\x8d",
  [0x5b72] = "\x72\xf2", [0x5b73] = "\x59\x8c", [0x5b75] = "\x5e\x6d",
  [0x5b77] = "\x7d\x87", [0x5b78] = "\x62\x70", [0x5b7a] = "\x63\xd1",
  [0x5b7b] = "\x86\xe2", [0x5b7d] = "\x66\xe8", [0x5b7f] = "\x67\xdb",
  [0x5b80] = "\x48\x67", [0x5b81] = "\x69\x73", [0x5b83] = "\x4d\x66",
  [0x5b84] = "\x69\x74", [0x5b85] = "\x4d\xf6", [0x5b87] = "\x4d\xf4",
  [0x5b88] = "\x4d\xf5", [0x5b89] = "\x4d\xf7", [0x5b8b] = "\x4e\xf9",
  [0x5b8c] = "\x4e\xf8", [0x5b8e] = "\x6a\x7c", [0x5b8f] = "\x4e\xfa",
  [0x5b92] = "\x6a\x7d", [0x5b93] = "\x6b\xb8", [0x5b95] = "\x6b\xb9",
  [0x5b97] = "\x50\x99", [0x5b98] = "\x50\x9b", [0x5b99] = "\x50\x9d",
  [0x5b9a] = "\x50\x9a", [0x5b9b] = "\x50\x9e", [0x5b9c] = "\x50\x9c",
  [0x5ba2] = "\x52\x8b", [0x5ba3] = "\x52\x88", [0x5ba4] = "\x52\x8a",
  [0x5ba5] = "\x52\x8c", [0x5ba6] = "\x52\x89", [0x5ba7] = "\x6f\xe8",
  [0x5ba8] = "\x6d\x9a", [0x5bac] = "\x6f\xea", [0x5bad] = "\x6f\xe9",
  [0x5bae] = "\x54\xa7", [0x5bb0] = "\x54\xa3", [0x5bb3] = "\x54\xa4",
  [0x5bb4] = "\x54\xa6", [0x5bb5] = "\x54\xa8", [0x5bb6] = "\x54\xa5",
  [0x5bb8] = "\x54\xaa", [0x5bb9] = "\x54\xa9", [0x5bbf] = "\x56\xed",
  [0x5bc0] = "\x72\xf5", [0x5bc1] = "\x72\xf4", [0x5bc2] = "\x56\xec",
  [0x5bc4] = "\x56\xeb", [0x5bc5] = "\x56\xea", [0x5bc6] = "\x56\xee",
  [0x5bc7] = "\x56\xe9", [0x5bca] = "\x76\x5b", [0x5bcb] = "\x76\x58",
  [0x5bcc] = "\x59\x8f", [0x5bcd] = "\x76\x57", [0x5bce] = "\x76\x5c",
  [0x5bd0] = "\x59\x91", [0x5bd1] = "\x76\x5a", [0x5bd2] = "\x59\x8e",
  [0x5bd3] = "\x59\x90", [0x5bd4] = "\x76\x59", [0x5bd6] = "\x79\xce",
  [0x5bd8] = "\x79\xcf", [0x5bd9] = "\x79\xd0", [0x5bde] = "\x5e\x6e",
  [0x5bdf] = "\x5e\x76", [0x5be0] = "\x7d\x88", [0x5be1] = "\x5e\x70",
  [0x5be2] = "\x5e\x74", [0x5be3] = "\x7d\x89", [0x5be4] = "\x5e\x75",
  [0x5be5] = "\x5e\x71", [0x5be6] = "\x5e\x72", [0x5be7] = "\x5e\x6f",
  [0x5be8] = "\x5e\x73", [0x5be9] = "\x60\x6f", [0x5bea] = "\x76\x56",
  [0x5beb] = "\x60\x70", [0x5bec] = "\x60\x6e", [0x5bee] = "\x60\x6d",
  [0x5bef] = "\x83\xe7", [0x5bf0] = "\x62\x71", [0x5bf1] = "\x86\xe3",
  [0x5bf2] = "\x86\xe4", [0x5bf5] = "\x66\x50", [0x5bf6] = "\x66\xe9",
  [0x5bf8] = "\x4c\x70", [0x5bfa] = "\x4d\xf8", [0x5c01] = "\x52\x8d",
  [0x5c03] = "\x6f\xeb", [0x5c04] = "\x54\xab", [0x5c07] = "\x56\xf1",
  [0x5c08] = "\x56\xf0", [0x5c09] = "\x56\xef", [0x5c0a] = "\x59\x92",
  [0x5c0b] = "\x59\x93", [0x5c0c] = "\x76\x5d", [0x5c0d] = "\x5e\x77",
  [0x5c0e] = "\x62\x72", [0x5c0f] = "\x4c\x71", [0x5c10] = "\x69\x5d",
  [0x5c11] = "\x4c\xb6", [0x5c12] = "\x69\x75", [0x5c15] = "\x69\xb4",
  [0x5c16] = "\x4d\xf9", [0x5c1a] = "\x50\x9f", [0x5c1f] = "\x79\xd1",
  [0x5c22] = "\x4c\x72", [0x5c24] = "\x4c\xb7", [0x5c25] = "\x69\xb5",
  [0x5c28] = "\x6a\x7e", [0x5c2a] = "\x6a\x7f", [0x5c2c] = "\x4e\xfb",
  [0x5c30] = "\x76\x5e", [0x5c31] = "\x59\x94", [0x5c33] = "\x79\xd2",
  [0x5c37] = "\x63\xd2", [0x5c38] = "\x4c\x73", [0x5c39] = "\x4c\x88",
  [0x5c3a] = "\x4c\xb8", [0x5c3b] = "\x69\x76", [0x5c3c] = "\x4d\x67",
  [0x5c3e] = "\x4f\x42", [0x5c3f] = "\x4f\x41", [0x5c40] = "\x4e\xfc",
  [0x5c41] = "\x4e\xfd", [0x5c44] = "\x6b\xba", [0x5c45] = "\x50\xa1",
  [0x5c46] = "\x50\xa2", [0x5c47] = "\x6b\xbb", [0x5c48] = "\x50\xa0",
  [0x5c4b] = "\x52\x91", [0x5c4c] = "\x6d\x9b", [0x5c4d] = "\x52\x90",
  [0x5c4e] = "\x52\x8e", [0x5c4f] = "\x52\x8f", [0x5c50] = "\x54\xae",
  [0x5c51] = "\x54\xac", [0x5c54] = "\x6f\xed", [0x5c55] = "\x54\xad",
  [0x5c56] = "\x6f\xec", [0x5c58] = "\x54\xa2", [0x5c59] = "\x72\xf6",
  [0x5c5c] = "\x56\xf3", [0x5c5d] = "\x56\xf4", [0x5c60] = "\x56\xf2",
  [0x5c62] = "\x5e\x78", [0x5c63] = "\x7d\x8a", [0x5c64] = "\x60\x71",
  [0x5c65] = "\x60\x72", [0x5c67] = "\x80\xab", [0x5c68] = "\x63\xd3",
  [0x5c69] = "\x89\x6f", [0x5c6a] = "\x89\x70", [0x5c6c] = "\x67\x89",
  [0x5c6d] = "\x90\xb7", [0x5c6e] = "\x69\x4c", [0x5c6f] = "\x4c\xb9",
  [0x5c71] = "\x4c\x74", [0x5c73] = "\x69\x78", [0x5c74] = "\x69\x77",
  [0x5c79] = "\x4d\xfa", [0x5c7a] = "\x69\xb7", [0x5c7b] = "\x69\xb8",
  [0x5c7c] = "\x69\xb6", [0x5c7e] = "\x69\xb9", [0x5c86] = "\x6a\x88",
  [0x5c88] = "\x6a\x83", [0x5c89] = "\x6a\x85", [0x5c8a] = "\x6a\x87",
  [0x5c8b] = "\x6a\x84", [0x5c8c] = "\x4f\x46", [0x5c8d] = "\x6a\x81",
  [0x5c8f] = "\x6a\x82", [0x5c90] = "\x4f\x43", [0x5c91] = "\x4f\x44",
  [0x5c92] = "\x6a\x86", [0x5c93] = "\x6a\x89", [0x5c94] = "\x4f\x45",
  [0x5c95] = "\x6a\x8a", [0x5c9d] = "\x6b\xc9", [0x5c9f] = "\x6b\xc3",
  [0x5ca0] = "\x6b\xbe", [0x5ca1] = "\x50\xa4", [0x5ca2] = "\x6b\xc6",
  [0x5ca3] = "\x6b\xc4", [0x5ca4] = "\x6b\xbd", [0x5ca5] = "\x6b\xca",
  [0x5ca6] = "\x6b\xcd", [0x5ca7] = "\x6b\xc8", [0x5ca8] = "\x6b\xc1",
  [0x5ca9] = "\x50\xa6", [0x5caa] = "\x6b\xc7", [0x5cab] = "\x50\xa7",
  [0x5cac] = "\x6b\xc2", [0x5cad] = "\x6b\xc5", [0x5cae] = "\x6b\xbc",
  [0x5caf] = "\x6b\xc0", [0x5cb0] = "\x6b\xcc", [0x5cb1] = "\x50\xa8",
  [0x5cb3] = "\x50\xa9", [0x5cb5] = "\x6b\xbf", [0x5cb6] = "\x6b\xcb",
  [0x5cb7] = "\x50\xa3", [0x5cb8] = "\x50\xa5", [0x5cc6] = "\x6d\xac",
  [0x5cc7] = "\x6d\xa5", [0x5cc8] = "\x6d\xab", [0x5cc9] = "\x6d\xa4",
  [0x5cca] = "\x6d\xa6", [0x5ccb] = "\x6d\xa0", [0x5ccc] = "\x6d\x9e",
  [0x5cce] = "\x6d\xad", [0x5ccf] = "\x6d\xaa", [0x5cd0] = "\x6d\x9c",
  [0x5cd2] = "\x52\x93", [0x5cd3] = "\x6d\xa8", [0x5cd4] = "\x6d\xa9",
  [0x5cd6] = "\x6d\xa7", [0x5cd7] = "\x6d\x9f", [0x5cd8] = "\x6d\x9d",
  [0x5cd9] = "\x52\x92", [0x5cda] = "\x6d\xa3", [0x5cdb] = "\x6d\xa1",
  [0x5cde] = "\x6d\xa2", [0x5cdf] = "\x6d\xae", [0x5ce8] = "\x54\xb3",
  [0x5cea] = "\x54\xb2", [0x5cec] = "\x6f\xee", [0x5ced] = "\x54\xaf",
  [0x5cee] = "\x6f\xf0", [0x5cf0] = "\x54\xb4", [0x5cf1] = "\x6f\xf1",
  [0x5cf4] = "\x54\xb7", [0x5cf6] = "\x54\xb5", [0x5cf7] = "\x6f\xf2",
  [0x5cf8] = "\x6d\xaf", [0x5cf9] = "\x6f\xf4", [0x5cfb] = "\x54\xb1",
  [0x5cfd] = "\x54\xb0", [0x5cff] = "\x6f\xef", [0x5d00] = "\x6f\xf3",
  [0x5d01] = "\x54\xb6", [0x5d06] = "\x56\xf6", [0x5d07] = "\x56\xf5",
  [0x5d0b] = "\x72\xf8", [0x5d0c] = "\x72\xfc", [0x5d0d] = "\x73\x41",
  [0x5d0e] = "\x56\xf7", [0x5d0f] = "\x73\x44", [0x5d11] = "\x56\xfb",
  [0x5d12] = "\x73\x46", [0x5d14] = "\x56\xfd", [0x5d16] = "\x56\xf9",
  [0x5d17] = "\x57\x44", [0x5d19] = "\x57\x41", [0x5d1a] = "\x72\xfa",
  [0x5d1b] = "\x56\xf8", [0x5d1d] = "\x72\xf9", [0x5d1e] = "\x72\xf7",
  [0x5d1f] = "\x73\x48", [0x5d20] = "\x72\xfb", [0x5d22] = "\x56\xfa",
  [0x5d23] = "\x73\x47", [0x5d24] = "\x57\x42", [0x5d25] = "\x73\x43",
  [0x5d26] = "\x73\x42", [0x5d27] = "\x57\x43", [0x5d28] = "\x72\xfd",
  [0x5d29] = "\x56\xfc", [0x5d2e] = "\x73\x49", [0x5d30] = "\x73\x45",
  [0x5d31] = "\x76\x6d", [0x5d32] = "\x76\x74", [0x5d33] = "\x76\x69",
  [0x5d34] = "\x59\x97", [0x5d35] = "\x76\x65", [0x5d36] = "\x76\x75",
  [0x5d37] = "\x76\x5f", [0x5d38] = "\x76\x72", [0x5d39] = "\x76\x70",
  [0x5d3a] = "\x76\x6a", [0x5d3c] = "\x76\x73", [0x5d3d] = "\x76\x6c",
  [0x5d3f] = "\x76\x64", [0x5d40] = "\x76\x76", [0x5d41] = "\x76\x62",
  [0x5d42] = "\x76\x6f", [0x5d43] = "\x76\x60", [0x5d45] = "\x76\x77",
  [0x5d47] = "\x59\x98", [0x5d49] = "\x76\x71", [0x5d4a] = "\x79\xd5",
  [0x5d4b] = "\x76\x63", [0x5d4c] = "\x59\x95", [0x5d4e] = "\x76\x67",
  [0x5d50] = "\x59\x96", [0x5d51] = "\x76\x66", [0x5d52] = "\x76\x6b",
  [0x5d55] = "\x76\x68", [0x5d59] = "\x76\x6e", [0x5d5e] = "\x79\xd9",
  [0x5d62] = "\x79\xdc", [0x5d63] = "\x79\xd4", [0x5d65] = "\x79\xd6",
  [0x5d67] = "\x79\xdb", [0x5d68] = "\x79\xda", [0x5d69] = "\x5b\xe8",
  [0x5d6b] = "\x76\x61", [0x5d6c] = "\x79\xd8", [0x5d6f] = "\x5b\xe9",
  [0x5d71] = "\x79\xd3", [0x5d72] = "\x79\xd7", [0x5d77] = "\x7d\x91",
  [0x5d79] = "\x7d\x98", [0x5d7a] = "\x7d\x8f", [0x5d7c] = "\x7d\x96",
  [0x5d7d] = "\x7d\x8d", [0x5d7e] = "\x7d\x95", [0x5d7f] = "\x7d\x99",
  [0x5d80] = "\x7d\x8c", [0x5d81] = "\x7d\x90", [0x5d82] = "\x7d\x8b",
  [0x5d84] = "\x5e\x79", [0x5d86] = "\x7d\x8e", [0x5d87] = "\x5e\x7a",
  [0x5d88] = "\x7d\x94", [0x5d89] = "\x7d\x93", [0x5d8a] = "\x7d\x92",
  [0x5d8d] = "\x7d\x97", [0x5d92] = "\x80\xaf", [0x5d93] = "\x80\xb1",
  [0x5d94] = "\x60\x74", [0x5d95] = "\x80\xb2", [0x5d97] = "\x80\xad",
  [0x5d99] = "\x80\xac", [0x5d9a] = "\x80\xb6", [0x5d9c] = "\x80\xb4",
  [0x5d9d] = "\x60\x73", [0x5d9e] = "\x80\xb7", [0x5d9f] = "\x80\xae",
  [0x5da0] = "\x80\xb3", [0x5da1] = "\x80\xb5", [0x5da2] = "\x80\xb0",
  [0x5da7] = "\x83\xeb", [0x5da8] = "\x83\xf0", [0x5da9] = "\x83\xea",
  [0x5daa] = "\x83\xef", [0x5dac] = "\x83\xe8", [0x5dad] = "\x83\xf2",
  [0x5dae] = "\x83\xee", [0x5daf] = "\x83\xf3", [0x5db0] = "\x83\xed",
  [0x5db1] = "\x83\xe9", [0x5db2] = "\x83\xf1", [0x5db4] = "\x83\xf4",
  [0x5db5] = "\x83\xec", [0x5db7] = "\x86\xe5", [0x5db8] = "\x63\xd7",
  [0x5dba] = "\x63\xd5", [0x5dbc] = "\x63\xd4", [0x5dbd] = "\x63\xd6",
  [0x5dc0] = "\x89\x71", [0x5dc2] = "\x8a\xc0", [0x5dc3] = "\x8b\x6c",
  [0x5dc6] = "\x8c\xf1", [0x5dc7] = "\x8c\xf2", [0x5dc9] = "\x66\xea",
  [0x5dcb] = "\x8e\x78", [0x5dcd] = "\x67\x8a", [0x5dcf] = "\x8e\x79",
  [0x5dd1] = "\x8f\x6e", [0x5dd2] = "\x67\xdd", [0x5dd4] = "\x67\xdc",
  [0x5dd5] = "\x8f\x6d", [0x5dd6] = "\x68\x55", [0x5dd8] = "\x90\x47",
  [0x5ddb] = "\x48\x6e", [0x5ddd] = "\x4c\x75", [0x5dde] = "\x4d\xfb",
  [0x5ddf] = "\x69\xba", [0x5de0] = "\x6a\x8b", [0x5de1] = "\x4f\xd5",
  [0x5de2] = "\x57\x45", [0x5de5] = "\x4c\x76", [0x5de6] = "\x4d\x6a",
  [0x5de7] = "\x4d\x69", [0x5de8] = "\x4d\x68", [0x5deb] = "\x4f\x47",
  [0x5dee] = "\x54\xb8", [0x5df0] = "\x79\xdd", [0x5df1] = "\x4c\x77",
  [0x5df2] = "\x4c\x78", [0x5df3] = "\x4c\x79", [0x5df4] = "\x4c\xba",
  [0x5df7] = "\x52\x94", [0x5df9] = "\x6d\xb0", [0x5dfd] = "\x59\x99",
  [0x5dfe] = "\x4c\x7a", [0x5dff] = "\x69\x5e", [0x5e02] = "\x4d\x6b",
  [0x5e03] = "\x4d\x6c", [0x5e04] = "\x69\x79", [0x5e06] = "\x4d\xfc",
  [0x5e0a] = "\x6a\x8c", [0x5e0c] = "\x4f\x48", [0x5e0e] = "\x6a\x8d",
  [0x5e11] = "\x50\xaf", [0x5e14] = "\x6b\xcf", [0x5e15] = "\x50\xad",
  [0x5e16] = "\x50\xac", [0x5e17] = "\x6b\xce", [0x5e18] = "\x50\xaa",
  [0x5e19] = "\x6b\xd0", [0x5e1a] = "\x50\xab", [0x5e1b] = "\x50\xae",
  [0x5e1d] = "\x52\x95", [0x5e1f] = "\x52\x97", [0x5e20] = "\x6d\xb4",
  [0x5e21] = "\x6d\xb1", [0x5e22] = "\x6d\xb2", [0x5e23] = "\x6d\xb3",
  [0x5e24] = "\x6d\xb5", [0x5e25] = "\x52\x96", [0x5e28] = "\x6f\xf6",
  [0x5e29] = "\x6f\xf5", [0x5e2b] = "\x54\xba", [0x5e2d] = "\x54\xb9",
  [0x5e33] = "\x57\x48", [0x5e34] = "\x73\x4b", [0x5e36] = "\x57\x47",
  [0x5e37] = "\x57\x49", [0x5e38] = "\x57\x46", [0x5e3d] = "\x59\x9b",
  [0x5e3e] = "\x73\x4a", [0x5e40] = "\x59\x9c", [0x5e41] = "\x76\x79",
  [0x5e43] = "\x59\x9d", [0x5e44] = "\x76\x78", [0x5e45] = "\x59\x9a",
  [0x5e4a] = "\x79\xe0", [0x5e4b] = "\x79\xe2", [0x5e4c] = "\x5b\xea",
  [0x5e4d] = "\x79\xe1", [0x5e4e] = "\x79\xdf", [0x5e4f] = "\x79\xde",
  [0x5e53] = "\x7d\x9c", [0x5e54] = "\x5e\x7f", [0x5e55] = "\x5e\x7d",
  [0x5e57] = "\x5e\x7e", [0x5e58] = "\x7d\x9a", [0x5e59] = "\x7d\x9b",
  [0x5e5b] = "\x5e\x7b", [0x5e5c] = "\x80\xbb", [0x5e5d] = "\x80\xb9",
  [0x5e5f] = "\x60\x76", [0x5e60] = "\x80\xba", [0x5e61] = "\x60\x77",
  [0x5e62] = "\x60\x75", [0x5e63] = "\x5e\x7c", [0x5e66] = "\x83\xf7",
  [0x5e67] = "\x83\xf5", [0x5e68] = "\x83\xf6", [0x5e69] = "\x80\xb8",
  [0x5e6a] = "\x86\xe7", [0x5e6b] = "\x63\xd8", [0x5e6c] = "\x86\xe6",
  [0x5e6d] = "\x89\x72", [0x5e6e] = "\x89\x73", [0x5e6f] = "\x83\xf8",
  [0x5e70] = "\x8b\x6d", [0x5e72] = "\x4c\x7b", [0x5e73] = "\x4d\x6d",
  [0x5e74] = "\x4e\x41", [0x5e75] = "\x69\xbb", [0x5e76] = "\x4d\xfd",
  [0x5e78] = "\x50\xb0", [0x5e79] = "\x5b\xeb", [0x5e7a] = "\x48\x73",
  [0x5e7b] = "\x4c\xbb", [0x5e7c] = "\x4d\x6e", [0x5e7d] = "\x52\x98",
  [0x5e7e] = "\x59\x9e", [0x5e7f] = "\x48\x74", [0x5e80] = "\x69\x7a",
  [0x5e82] = "\x69\x7b", [0x5e84] = "\x69\xbc", [0x5e87] = "\x4f\x4a",
  [0x5e88] = "\x6a\x91", [0x5e89] = "\x6a\x8f", [0x5e8a] = "\x4f\x4b",
  [0x5e8b] = "\x6a\x8e", [0x5e8c] = "\x6a\x90", [0x5e8d] = "\x6a\x92",
  [0x5e8f] = "\x4f\x49", [0x5e95] = "\x50\xb4", [0x5e96] = "\x50\xb5",
  [0x5e97] = "\x50\xb2", [0x5e9a] = "\x50\xb1", [0x5e9b] = "\x6d\xb9",
  [0x5e9c] = "\x50\xb3", [0x5ea0] = "\x52\x99", [0x5ea2] = "\x6d\xb8",
  [0x5ea3] = "\x6d\xba", [0x5ea4] = "\x6d\xb7", [0x5ea5] = "\x6d\xbb",
  [0x5ea6] = "\x52\x9a", [0x5ea7] = "\x54\xbd", [0x5ea8] = "\x6f\xf7",
  [0x5eaa] = "\x6f\xf9", [0x5eab] = "\x54\xbb", [0x5eac] = "\x6f\xfa",
  [0x5ead] = "\x54\xbc", [0x5eae] = "\x6f\xf8", [0x5eb0] = "\x6d\xb6",
  [0x5eb1] = "\x73\x4c", [0x5eb2] = "\x73\x4f", [0x5eb3] = "\x73\x50",
  [0x5eb4] = "\x73\x4d", [0x5eb5] = "\x57\x4d", [0x5eb6] = "\x57\x4c",
  [0x5eb7] = "\x57\x4a", [0x5eb8] = "\x57\x4b", [0x5eb9] = "\x73\x4e",
  [0x5ebe] = "\x57\x4e", [0x5ec1] = "\x59\xa0", [0x5ec2] = "\x59\xa1",
  [0x5ec4] = "\x59\xa2", [0x5ec5] = "\x79\xe3", [0x5ec6] = "\x79\xe5",
  [0x5ec7] = "\x79\xe7", [0x5ec8] = "\x5b\xed", [0x5ec9] = "\x5b\xec",
  [0x5eca] = "\x59\x9f", [0x5ecb] = "\x79\xe6", [0x5ecc] = "\x79\xe4",
  [0x5ece] = "\x7d\xa0", [0x5ed1] = "\x7d\x9e", [0x5ed2] = "\x7d\xa4",
  [0x5ed3] = "\x5e\x81", [0x5ed4] = "\x7d\xa5", [0x5ed5] = "\x7d\xa2",
  [0x5ed6] = "\x5e\x82", [0x5ed7] = "\x7d\x9f", [0x5ed8] = "\x7d\x9d",
  [0x5ed9] = "\x7d\xa3", [0x5eda] = "\x60\x79", [0x5edb] = "\x80\xbd",
  [0x5edc] = "\x7d\xa1", [0x5edd] = "\x60\x7b", [0x5ede] = "\x80\xbe",
  [0x5edf] = "\x60\x7a", [0x5ee0] = "\x60\x7d", [0x5ee1] = "\x80\xbf",
  [0x5ee2] = "\x60\x78", [0x5ee3] = "\x60\x7c", [0x5ee5] = "\x83\xfd",
  [0x5ee6] = "\x83\xfb", [0x5ee7] = "\x83\xfa", [0x5ee8] = "\x83\xfc",
  [0x5ee9] = "\x83\xf9", [0x5eec] = "\x66\x52", [0x5eee] = "\x8c\xf3",
  [0x5eef] = "\x8c\xf4", [0x5ef1] = "\x8e\x7a", [0x5ef2] = "\x8f\x6f",
  [0x5ef3] = "\x68\xa1", [0x5ef4] = "\x48\x75", [0x5ef6] = "\x50\xb6",
  [0x5ef7] = "\x4f\x4c", [0x5efa] = "\x52\x9b", [0x5efe] = "\x4c\x7c",
  [0x5eff] = "\x4c\xbc", [0x5f01] = "\x4d\x6f", [0x5f02] = "\x69\xbd",
  [0x5f04] = "\x4f\x4d", [0x5f05] = "\x6a\x93", [0x5f07] = "\x6d\xbc",
  [0x5f08] = "\x52\x9c", [0x5f0a] = "\x5e\x83", [0x5f0b] = "\x4c\x7d",
  [0x5f0f] = "\x4e\x42", [0x5f12] = "\x5b\xee", [0x5f13] = "\x4c\x7e",
  [0x5f14] = "\x4c\xbd", [0x5f15] = "\x4c\xbe", [0x5f17] = "\x4d\x71",
  [0x5f18] = "\x4d\x70", [0x5f1a] = "\x69\xbe", [0x5f1b] = "\x4e\x43",
  [0x5f1d] = "\x6a\x94", [0x5f1f] = "\x4f\x4e", [0x5f22] = "\x6b\xd2",
  [0x5f23] = "\x6b\xd3", [0x5f24] = "\x6b\xd4", [0x5f26] = "\x50\xb7",
  [0x5f27] = "\x50\xb8", [0x5f28] = "\x6b\xd1", [0x5f29] = "\x50\xb9",
  [0x5f2d] = "\x52\x9d", [0x5f2e] = "\x6d\xbd", [0x5f30] = "\x6f\xfc",
  [0x5f31] = "\x54\xbe", [0x5f33] = "\x6f\xfb", [0x5f35] = "\x57\x4f",
  [0x5f36] = "\x73\x51", [0x5f37] = "\x57\x50", [0x5f38] = "\x73\x52",
  [0x5f3c] = "\x59\xa3", [0x5f40] = "\x79\xe8", [0x5f43] = "\x7d\xa7",
  [0x5f44] = "\x7d\xa6", [0x5f46] = "\x5e\x84", [0x5f48] = "\x60\x7e",
  [0x5f49] = "\x80\xc0", [0x5f4a] = "\x62\x73", [0x5f4b] = "\x84\x41",
  [0x5f4c] = "\x63\xd9", [0x5f4e] = "\x67\xde", [0x5f4f] = "\x90\x49",
  [0x5f50] = "\x48\x79", [0x5f54] = "\x6b\xd5", [0x5f56] = "\x6d\xbe",
  [0x5f57] = "\x57\x51", [0x5f58] = "\x76\x7a", [0x5f59] = "\x5b\xef",
  [0x5f5d] = "\x65\x60", [0x5f5e] = "\x65\x60", [0x5f61] = "\x48\x7a",
  [0x5f62] = "\x4f\x50", [0x5f64] = "\x4f\x4f", [0x5f65] = "\x52\x9e",
  [0x5f67] = "\x6f\xfd", [0x5f69] = "\x57\x53", [0x5f6a] = "\x58\xa8",
  [0x5f6b] = "\x57\x54", [0x5f6c] = "\x57\x52", [0x5f6d] = "\x59\xa4",
  [0x5f6f] = "\x7d\xa8", [0x5f70] = "\x5e\x85", [0x5f71] = "\x60\x7f",
  [0x5f73] = "\x69\x4d", [0x5f74] = "\x69\xbf", [0x5f76] = "\x6a\x96",
  [0x5f77] = "\x4f\x51", [0x5f78] = "\x6a\x95", [0x5f79] = "\x4f\x52",
  [0x5f7c] = "\x50\xbd", [0x5f7d] = "\x6b\xd8", [0x5f7e] = "\x6b\xd7",
  [0x5f7f] = "\x50\xbc", [0x5f80] = "\x50\xba", [0x5f81] = "\x50\xbb",
  [0x5f82] = "\x6b\xd6", [0x5f85] = "\x52\xa0", [0x5f86] = "\x6d\xbf",
  [0x5f87] = "\x52\xa3", [0x5f88] = "\x52\x9f", [0x5f89] = "\x52\xa5",
  [0x5f8a] = "\x52\xa1", [0x5f8b] = "\x52\xa2", [0x5f8c] = "\x52\xa4",
  [0x5f90] = "\x54\xc1", [0x5f91] = "\x54\xc0", [0x5f92] = "\x54\xbf",
  [0x5f96] = "\x73\x54", [0x5f97] = "\x57\x55", [0x5f98] = "\x57\x58",
  [0x5f99] = "\x57\x56", [0x5f9b] = "\x73\x53", [0x5f9c] = "\x57\x5b",
  [0x5f9e] = "\x57\x57", [0x5f9f] = "\x73\x55", [0x5fa0] = "\x57\x5a",
  [0x5fa1] = "\x57\x59", [0x5fa5] = "\x76\x7c", [0x5fa6] = "\x76\x7b",
  [0x5fa8] = "\x59\xa7", [0x5fa9] = "\x59\xa5", [0x5faa] = "\x59\xa6",
  [0x5fab] = "\x76\x7d", [0x5fac] = "\x5b\xf0", [0x5fad] = "\x79\xea",
  [0x5fae] = "\x5b\xf1", [0x5faf] = "\x79\xe9", [0x5fb2] = "\x80\xc1",
  [0x5fb5] = "\x60\x82", [0x5fb6] = "\x7d\xa9", [0x5fb7] = "\x60\x81",
  [0x5fb9] = "\x5e\x86", [0x5fbb] = "\x86\xe9", [0x5fbc] = "\x84\x42",
  [0x5fbd] = "\x63\xda", [0x5fbe] = "\x86\xe8", [0x5fbf] = "\x8b\x6e",
  [0x5fc0] = "\x8c\xf5", [0x5fc1] = "\x8c\xf6", [0x5fc3] = "\x4c\xbf",
  [0x5fc5] = "\x4d\x72", [0x5fc9] = "\x69\x7c", [0x5fcc] = "\x4f\x54",
  [0x5fcd] = "\x4f\x56", [0x5fcf] = "\x69\xc2", [0x5fd0] = "\x6a\x99",
  [0x5fd1] = "\x6a\x98", [0x5fd2] = "\x6a\x97", [0x5fd4] = "\x69\xc1",
  [0x5fd5] = "\x69\xc0", [0x5fd6] = "\x4e\x45", [0x5fd7] = "\x4f\x55",
  [0x5fd8] = "\x4f\x53", [0x5fd9] = "\x4e\x44", [0x5fdd] = "\x50\xbe",
  [0x5fde] = "\x6b\xd9", [0x5fe0] = "\x50\xbf", [0x5fe1] = "\x6a\x9e",
  [0x5fe3] = "\x6a\xa0", [0x5fe4] = "\x6a\x9f", [0x5fe5] = "\x6b\xda",
  [0x5fe8] = "\x6a\x9b", [0x5fea] = "\x4f\x5a", [0x5feb] = "\x4f\x58",
  [0x5fed] = "\x6a\x9a", [0x5fee] = "\x6a\x9c", [0x5fef] = "\x6a\xa2",
  [0x5ff1] = "\x4f\x57", [0x5ff3] = "\x6a\x9d", [0x5ff4] = "\x6a\xa6",
  [0x5ff5] = "\x50\xc1", [0x5ff7] = "\x6a\xa3", [0x5ff8] = "\x4f\x59",
  [0x5ffa] = "\x6a\xa1", [0x5ffb] = "\x6a\xa4", [0x5ffd] = "\x50\xc0",
  [0x5fff] = "\x50\xc2", [0x6000] = "\x6a\xa5", [0x6009] = "\x6b\xee",
  [0x600a] = "\x6b\xe1", [0x600b] = "\x6b\xdf", [0x600c] = "\x6b\xed",
  [0x600d] = "\x6b\xe8", [0x600e] = "\x52\xaa", [0x600f] = "\x50\xc3",
  [0x6010] = "\x6b\xe9", [0x6011] = "\x6b\xec", [0x6012] = "\x52\xa6",
  [0x6013] = "\x6b\xeb", [0x6014] = "\x50\xc4", [0x6015] = "\x50\xc9",
  [0x6016] = "\x50\xc7", [0x6017] = "\x6b\xe2", [0x6019] = "\x6b\xdd",
  [0x601a] = "\x6b\xe4", [0x601b] = "\x50\xce", [0x601c] = "\x6b\xef",
  [0x601d] = "\x52\xa7", [0x601e] = "\x6b\xe5", [0x6020] = "\x52\xa8",
  [0x6021] = "\x50\xca", [0x6022] = "\x6b\xe7", [0x6024] = "\x6d\xce",
  [0x6025] = "\x52\xa9", [0x6026] = "\x6b\xdc", [0x6027] = "\x50\xcb",
  [0x6028] = "\x52\xab", [0x6029] = "\x50\xcc", [0x602a] = "\x50\xc8",
  [0x602b] = "\x50\xcd", [0x602c] = "\x6b\xe6", [0x602d] = "\x6b\xdb",
  [0x602e] = "\x6b\xea", [0x602f] = "\x50\xc5", [0x6032] = "\x6b\xde",
  [0x6033] = "\x6b\xe3", [0x6034] = "\x6b\xe0", [0x6035] = "\x50\xc6",
  [0x6037] = "\x6d\xc0", [0x6039] = "\x6d\xc1", [0x6040] = "\x6d\xcb",
  [0x6041] = "\x70\x44", [0x6042] = "\x6d\xcc", [0x6043] = "\x52\xb1",
  [0x6044] = "\x6d\xcf", [0x6045] = "\x6d\xc5", [0x6046] = "\x52\xb0",
  [0x6047] = "\x6d\xc7", [0x6049] = "\x6d\xc8", [0x604c] = "\x6d\xca",
  [0x604d] = "\x52\xac", [0x6050] = "\x54\xc5", [0x6053] = "\x6d\xc6",
  [0x6054] = "\x6d\xc2", [0x6055] = "\x54\xc6", [0x6058] = "\x6d\xd0",
  [0x6059] = "\x54\xc2", [0x605a] = "\x70\x42", [0x605b] = "\x6d\xc9",
  [0x605d] = "\x70\x41", [0x605e] = "\x6d\xc4", [0x605f] = "\x6d\xcd",
  [0x6062] = "\x52\xaf", [0x6063] = "\x54\xc3", [0x6064] = "\x52\xb5",
  [0x6065] = "\x54\xc4", [0x6066] = "\x6d\xd1", [0x6067] = "\x70\x43",
  [0x6068] = "\x52\xae", [0x6069] = "\x54\xc8", [0x606a] = "\x52\xb4",
  [0x606b] = "\x52\xb3", [0x606c] = "\x52\xb2", [0x606d] = "\x54\xc7",
  [0x606e] = "\x6d\xd2", [0x606f] = "\x54\xc9", [0x6070] = "\x52\xad",
  [0x6072] = "\x6d\xc3", [0x607f] = "\x57\x5c", [0x6080] = "\x70\x47",
  [0x6081] = "\x70\x49", [0x6083] = "\x70\x4b", [0x6084] = "\x54\xca",
  [0x6085] = "\x54\xd0", [0x6086] = "\x73\x58", [0x6087] = "\x70\x4f",
  [0x6088] = "\x70\x46", [0x6089] = "\x57\x5e", [0x608a] = "\x73\x56",
  [0x608c] = "\x54\xcf", [0x608d] = "\x54\xcd", [0x608e] = "\x70\x51",
  [0x6090] = "\x73\x57", [0x6092] = "\x70\x48", [0x6094] = "\x54\xce",
  [0x6095] = "\x70\x4c", [0x6096] = "\x54\xd1", [0x6097] = "\x70\x4e",
  [0x609a] = "\x54\xcc", [0x609b] = "\x70\x4d", [0x609c] = "\x70\x50",
  [0x609d] = "\x70\x4a", [0x609f] = "\x54\xcb", [0x60a0] = "\x57\x5f",
  [0x60a2] = "\x70\x45", [0x60a3] = "\x57\x5d", [0x60a8] = "\x57\x60",
  [0x60b0] = "\x73\x5a", [0x60b1] = "\x73\x63", [0x60b2] = "\x59\xaa",
  [0x60b4] = "\x57\x62", [0x60b5] = "\x57\x67", [0x60b6] = "\x59\xab",
  [0x60b7] = "\x73\x65", [0x60b8] = "\x57\x6e", [0x60b9] = "\x76\x7f",
  [0x60ba] = "\x73\x5b", [0x60bb] = "\x57\x66", [0x60bc] = "\x57\x69",
  [0x60bd] = "\x57\x64", [0x60be] = "\x73\x59", [0x60bf] = "\x73\x67",
  [0x60c0] = "\x73\x6a", [0x60c1] = "\x76\x8f", [0x60c3] = "\x73\x68",
  [0x60c4] = "\x76\x84", [0x60c5] = "\x57\x65", [0x60c6] = "\x57\x6c",
  [0x60c7] = "\x57\x70", [0x60c8] = "\x73\x62", [0x60c9] = "\x76\x7e",
  [0x60ca] = "\x73\x66", [0x60cb] = "\x57\x61", [0x60cc] = "\x76\x81",
  [0x60cd] = "\x73\x69", [0x60ce] = "\x76\x83", [0x60cf] = "\x73\x5e",
  [0x60d1] = "\x59\xa8", [0x60d3] = "\x73\x5c", [0x60d4] = "\x73\x5d",
  [0x60d5] = "\x57\x6b", [0x60d8] = "\x57\x6a", [0x60d9] = "\x73\x60",
  [0x60da] = "\x57\x6f", [0x60db] = "\x73\x64", [0x60dc] = "\x57\x68",
  [0x60dd] = "\x73\x61", [0x60df] = "\x57\x6d", [0x60e0] = "\x59\xac",
  [0x60e1] = "\x59\xa9", [0x60e2] = "\x76\x82", [0x60e4] = "\x73\x5f",
  [0x60e6] = "\x57\x63", [0x60f0] = "\x59\xb1", [0x60f1] = "\x59\xb5",
  [0x60f2] = "\x76\x86", [0x60f3] = "\x5b\xf6", [0x60f4] = "\x59\xb3",
  [0x60f5] = "\x76\x8a", [0x60f6] = "\x59\xb7", [0x60f7] = "\x79\xeb",
  [0x60f8] = "\x76\x8c", [0x60f9] = "\x5b\xf8", [0x60fa] = "\x59\xaf",
  [0x60fb] = "\x59\xb2", [0x60fc] = "\x76\x8d", [0x60fe] = "\x76\x8e",
  [0x60ff] = "\x76\x94", [0x6100] = "\x59\xb9", [0x6101] = "\x5b\xf9",
  [0x6103] = "\x76\x90", [0x6104] = "\x76\x95", [0x6105] = "\x76\x89",
  [0x6106] = "\x5c\x46", [0x6108] = "\x5b\xfa", [0x6109] = "\x59\xb8",
  [0x610a] = "\x76\x87", [0x610b] = "\x76\x96", [0x610d] = "\x5c\x45",
  [0x610e] = "\x59\xb6", [0x610f] = "\x5b\xf3", [0x6110] = "\x76\x93",
  [0x6112] = "\x59\xba", [0x6113] = "\x76\x8b", [0x6114] = "\x76\x85",
  [0x6115] = "\x59\xb0", [0x6116] = "\x76\x88", [0x6118] = "\x76\x91",
  [0x611a] = "\x5b\xf2", [0x611b] = "\x5b\xf7", [0x611c] = "\x59\xad",
  [0x611d] = "\x76\x92", [0x611f] = "\x5b\xf5", [0x6123] = "\x59\xae",
  [0x6127] = "\x5c\x44", [0x6128] = "\x7d\xab", [0x6129] = "\x79\xf6",
  [0x612b] = "\x79\xee", [0x612c] = "\x7d\xaa", [0x612e] = "\x79\xf2",
  [0x612f] = "\x79\xf4", [0x6132] = "\x79\xf1", [0x6134] = "\x5c\x43",
  [0x6136] = "\x79\xf0", [0x6137] = "\x5c\x47", [0x613b] = "\x7d\xba",
  [0x613e] = "\x5c\x42", [0x613f] = "\x5e\x88", [0x6140] = "\x79\xf7",
  [0x6141] = "\x7d\xac", [0x6144] = "\x5b\xfd", [0x6145] = "\x79\xef",
  [0x6146] = "\x79\xf3", [0x6147] = "\x5e\x87", [0x6148] = "\x5b\xf4",
  [0x6149] = "\x79\xec", [0x614a] = "\x79\xed", [0x614b] = "\x5e\x89",
  [0x614c] = "\x5b\xfc", [0x614d] = "\x5c\x41", [0x614e] = "\x5b\xfb",
  [0x614f] = "\x79\xf5", [0x6152] = "\x7d\xb0", [0x6153] = "\x7d\xb1",
  [0x6154] = "\x7d\xb6", [0x6155] = "\x60\x87", [0x6156] = "\x7d\xbd",
  [0x6158] = "\x5e\x8f", [0x615a] = "\x5e\x8e", [0x615b] = "\x7d\xb8",
  [0x615d] = "\x60\x86", [0x615e] = "\x7d\xad", [0x615f] = "\x5e\x8d",
  [0x6161] = "\x7d\xbc", [0x6162] = "\x5e\x8b", [0x6163] = "\x5e\x8c",
  [0x6165] = "\x7d\xb9", [0x6166] = "\x80\xd2", [0x6167] = "\x60\x84",
  [0x6168] = "\x59\xb4", [0x616a] = "\x7d\xbb", [0x616b] = "\x60\x8b",
  [0x616c] = "\x7d\xb3", [0x616e] = "\x60\x85", [0x6170] = "\x60\x8a",
  [0x6171] = "\x7d\xae", [0x6172] = "\x7d\xb2", [0x6173] = "\x7d\xaf",
  [0x6174] = "\x7d\xb5", [0x6175] = "\x5e\x90", [0x6176] = "\x60\x83",
  [0x6177] = "\x5e\x8a", [0x6179] = "\x80\xc4", [0x617a] = "\x7d\xb7",
  [0x617c] = "\x60\x89", [0x617e] = "\x60\x8c", [0x6180] = "\x7d\xb4",
  [0x6182] = "\x60\x88", [0x6183] = "\x80\xc3", [0x6189] = "\x80\xc8",
  [0x618a] = "\x62\x77", [0x618b] = "\x80\xc2", [0x618c] = "\x84\x4e",
  [0x618d] = "\x80\xd1", [0x618e] = "\x60\x90", [0x6190] = "\x60\x8e",
  [0x6191] = "\x62\x75", [0x6192] = "\x80\xce", [0x6193] = "\x80\xca",
  [0x6194] = "\x60\x94", [0x6196] = "\x84\x45", [0x619a] = "\x60\x92",
  [0x619b] = "\x80\xc9", [0x619d] = "\x84\x43", [0x619f] = "\x80\xcd",
  [0x61a1] = "\x80\xd0", [0x61a2] = "\x80\xc7", [0x61a4] = "\x60\x93",
  [0x61a7] = "\x60\x8d", [0x61a8] = "\x84\x44", [0x61a9] = "\x62\x76",
  [0x61aa] = "\x80\xcf", [0x61ab] = "\x60\x8f", [0x61ac] = "\x60\x91",
  [0x61ad] = "\x80\xcc", [0x61ae] = "\x60\x95", [0x61af] = "\x80\xcb",
  [0x61b0] = "\x80\xc6", [0x61b1] = "\x80\xc5", [0x61b2] = "\x62\x74",
  [0x61b3] = "\x80\xd3", [0x61b4] = "\x84\x47", [0x61b5] = "\x86\xeb",
  [0x61b6] = "\x62\x79", [0x61b8] = "\x84\x4d", [0x61ba] = "\x84\x4b",
  [0x61bc] = "\x86\xec", [0x61be] = "\x62\x7a", [0x61bf] = "\x84\x4c",
  [0x61c1] = "\x84\x49", [0x61c2] = "\x63\xdc", [0x61c3] = "\x86\xea",
  [0x61c5] = "\x84\x46", [0x61c6] = "\x84\x48", [0x61c7] = "\x63\xdd",
  [0x61c8] = "\x62\x7c", [0x61c9] = "\x63\xdb", [0x61ca] = "\x62\x7b",
  [0x61cb] = "\x63\xdf", [0x61cc] = "\x84\x4a", [0x61cd] = "\x62\x78",
  [0x61d6] = "\x89\x7c", [0x61d8] = "\x89\x74", [0x61de] = "\x86\xf2",
  [0x61df] = "\x89\x75", [0x61e0] = "\x86\xee", [0x61e3] = "\x65\x61",
  [0x61e4] = "\x86\xf0", [0x61e5] = "\x86\xef", [0x61e6] = "\x63\xde",
  [0x61e7] = "\x86\xed", [0x61e8] = "\x86\xf1", [0x61e9] = "\x89\x7d",
  [0x61ea] = "\x89\x79", [0x61eb] = "\x89\x7b", [0x61ed] = "\x89\x76",
  [0x61ee] = "\x89\x77", [0x61f0] = "\x89\x7a", [0x61f1] = "\x89\x78",
  [0x61f2] = "\x66\x53", [0x61f5] = "\x66\x56", [0x61f6] = "\x66\x55",
  [0x61f7] = "\x66\x54", [0x61f8] = "\x66\xeb", [0x61f9] = "\x8c\xf7",
  [0x61fa] = "\x66\xec", [0x61fb] = "\x8b\x6f", [0x61fc] = "\x67\x8b",
  [0x61fd] = "\x8e\x7b", [0x61fe] = "\x67\x8c", [0x61ff] = "\x67\xdf",
  [0x6200] = "\x68\x56", [0x6201] = "\x90\x4a", [0x6203] = "\x90\x4b",
  [0x6204] = "\x90\x4c", [0x6207] = "\x91\xaa", [0x6208] = "\x4c\xc0",
  [0x6209] = "\x69\x7d", [0x620a] = "\x4d\x73", [0x620c] = "\x4e\x47",
  [0x620d] = "\x4e\x48", [0x620e] = "\x4e\x46", [0x6210] = "\x4e\x49",
  [0x6211] = "\x4f\x5c", [0x6212] = "\x4f\x5b", [0x6214] = "\x6b\xf0",
  [0x6215] = "\x50\xd0", [0x6216] = "\x50\xcf", [0x6219] = "\x70\x52",
  [0x621a] = "\x57\x71", [0x621b] = "\x57\x72", [0x621f] = "\x59\xbb",
  [0x6220] = "\x79\xf8", [0x6221] = "\x5c\x48", [0x6222] = "\x5c\x49",
  [0x6223] = "\x79\xfa", [0x6224] = "\x79\xfc", [0x6225] = "\x79\xfb",
  [0x6227] = "\x7d\xbf", [0x6229] = "\x7d\xbe", [0x622a] = "\x5e\x91",
  [0x622b] = "\x7d\xc0", [0x622d] = "\x80\xd4", [0x622e] = "\x60\x96",
  [0x6230] = "\x62\x7d", [0x6232] = "\x63\xe0", [0x6233] = "\x65\x62",
  [0x6234] = "\x63\xe1", [0x6236] = "\x4c\xc1", [0x623a] = "\x6a\xa7",
  [0x623d] = "\x6b\xf1", [0x623e] = "\x50\xd2", [0x623f] = "\x50\xd1",
  [0x6240] = "\x50\xd3", [0x6241] = "\x52\xb6", [0x6242] = "\x6d\xd3",
  [0x6243] = "\x6d\xd4", [0x6246] = "\x70\x53", [0x6247] = "\x54\xd2",
  [0x6248] = "\x57\x73", [0x6249] = "\x59\xbc", [0x624a] = "\x76\x97",
  [0x624b] = "\x4c\xc2", [0x624d] = "\x4c\x7f", [0x624e] = "\x4c\xc3",
  [0x6250] = "\x69\x7e", [0x6251] = "\x4d\x77", [0x6252] = "\x4d\x76",
  [0x6253] = "\x4d\x74", [0x6254] = "\x4d\x75", [0x6258] = "\x4e\x4c",
  [0x6259] = "\x69\xca", [0x625a] = "\x69\xcc", [0x625b] = "\x4e\x4b",
  [0x625c] = "\x69\xc4", [0x625e] = "\x69\xc5", [0x6260] = "\x69\xcb",
  [0x6261] = "\x69\xc7", [0x6262] = "\x69\xc9", [0x6263] = "\x4e\x4a",
  [0x6264] = "\x69\xc6", [0x6265] = "\x69\xc3", [0x6266] = "\x69\xc8",
  [0x626d] = "\x4f\x63", [0x626e] = "\x4f\x6c", [0x626f] = "\x4f\x6a",
  [0x6270] = "\x6a\xb1", [0x6271] = "\x6a\xae", [0x6272] = "\x6a\xb6",
  [0x6273] = "\x4f\x68", [0x6274] = "\x6a\xb7", [0x6276] = "\x4f\x61",
  [0x6277] = "\x6a\xb4", [0x6279] = "\x4f\x67", [0x627a] = "\x6a\xb0",
  [0x627b] = "\x6a\xaf", [0x627c] = "\x4f\x65", [0x627d] = "\x6a\xb5",
  [0x627e] = "\x4f\x66", [0x627f] = "\x50\xd4", [0x6280] = "\x4f\x60",
  [0x6281] = "\x6a\xb2", [0x6283] = "\x6a\xa8", [0x6284] = "\x4f\x5d",
  [0x6286] = "\x4f\x70", [0x6287] = "\x6a\xad", [0x6288] = "\x6a\xb3",
  [0x6289] = "\x4f\x62", [0x628a] = "\x4f\x64", [0x628c] = "\x6a\xa9",
  [0x628e] = "\x6a\xaa", [0x628f] = "\x6a\xab", [0x6291] = "\x4f\x6f",
  [0x6292] = "\x4f\x69", [0x6293] = "\x4f\x6e", [0x6294] = "\x6a\xac",
  [0x6295] = "\x4f\x6d", [0x6296] = "\x4f\x5f", [0x6297] = "\x4f\x5e",
  [0x6298] = "\x4f\x6b", [0x62a8] = "\x50\xe2", [0x62a9] = "\x6b\xfd",
  [0x62aa] = "\x6b\xf6", [0x62ab] = "\x50\xdd", [0x62ac] = "\x50\xf0",
  [0x62ad] = "\x6b\xf2", [0x62ae] = "\x6b\xf9", [0x62af] = "\x6b\xfb",
  [0x62b0] = "\x6c\x41", [0x62b1] = "\x50\xeb", [0x62b3] = "\x6b\xfa",
  [0x62b4] = "\x6b\xf3", [0x62b5] = "\x50\xe9", [0x62b6] = "\x6b\xf7",
  [0x62b8] = "\x6c\x42", [0x62b9] = "\x50\xda", [0x62bb] = "\x6b\xfc",
  [0x62bc] = "\x50\xe4", [0x62bd] = "\x50\xe3", [0x62be] = "\x6b\xf5",
  [0x62bf] = "\x50\xd8", [0x62c2] = "\x50\xd9", [0x62c4] = "\x50\xd7",
  [0x62c6] = "\x50\xef", [0x62c7] = "\x50\xe7", [0x62c8] = "\x50\xe1",
  [0x62c9] = "\x50\xd5", [0x62ca] = "\x6b\xf8", [0x62cb] = "\x50\xe0",
  [0x62cc] = "\x50\xd6", [0x62cd] = "\x50\xe8", [0x62ce] = "\x50\xf1",
  [0x62cf] = "\x6d\xd5", [0x62d0] = "\x50\xe5", [0x62d1] = "\x6b\xf4",
  [0x62d2] = "\x50\xdb", [0x62d3] = "\x50\xde", [0x62d4] = "\x50\xdf",
  [0x62d6] = "\x50\xed", [0x62d7] = "\x50\xee", [0x62d8] = "\x50\xec",
  [0x62d9] = "\x50\xe6", [0x62da] = "\x50\xea", [0x62db] = "\x50\xdc",
  [0x62dc] = "\x52\xb7", [0x62eb] = "\x6d\xdb", [0x62ec] = "\x52\xc3",
  [0x62ed] = "\x52\xbb", [0x62ee] = "\x52\xbd", [0x62ef] = "\x52\xc2",
  [0x62f0] = "\x6d\xe7", [0x62f1] = "\x52\xc0", [0x62f2] = "\x70\x54",
  [0x62f3] = "\x54\xd3", [0x62f4] = "\x52\xc5", [0x62f5] = "\x6d\xd8",
  [0x62f6] = "\x6d\xe0", [0x62f7] = "\x52\xc1", [0x62f8] = "\x6d\xdf",
  [0x62f9] = "\x6d\xdc", [0x62fa] = "\x6d\xe4", [0x62fb] = "\x6d\xe6",
  [0x62fc] = "\x52\xba", [0x62fd] = "\x52\xbe", [0x62fe] = "\x52\xc4",
  [0x62ff] = "\x54\xd5", [0x6300] = "\x6d\xe1", [0x6301] = "\x52\xbc",
  [0x6302] = "\x52\xc7", [0x6303] = "\x6d\xda", [0x6307] = "\x52\xbf",
  [0x6308] = "\x54\xd4", [0x6309] = "\x52\xb9", [0x630b] = "\x6d\xd7",
  [0x630c] = "\x6d\xde", [0x630d] = "\x6d\xd6", [0x630e] = "\x6d\xd9",
  [0x630f] = "\x6d\xdd", [0x6310] = "\x70\x55", [0x6311] = "\x52\xc6",
  [0x6313] = "\x6d\xe2", [0x6314] = "\x6d\xe3", [0x6315] = "\x6d\xe5",
  [0x6316] = "\x52\xb8", [0x6328] = "\x54\xe3", [0x6329] = "\x70\x61",
  [0x632a] = "\x54\xe1", [0x632b] = "\x54\xe2", [0x632c] = "\x70\x57",
  [0x632d] = "\x70\x67", [0x632f] = "\x54\xd8", [0x6332] = "\x73\x6b",
  [0x6333] = "\x70\x69", [0x6334] = "\x70\x63", [0x6336] = "\x70\x5a",
  [0x6338] = "\x70\x6c", [0x6339] = "\x70\x5d", [0x633a] = "\x54\xde",
  [0x633b] = "\x73\x83", [0x633c] = "\x70\x60", [0x633d] = "\x54\xe0",
  [0x633e] = "\x54\xd7", [0x6340] = "\x70\x6e", [0x6341] = "\x70\x62",
  [0x6342] = "\x54\xda", [0x6343] = "\x70\x5b", [0x6344] = "\x70\x58",
  [0x6345] = "\x70\x59", [0x6346] = "\x54\xdb", [0x6347] = "\x70\x68",
  [0x6348] = "\x70\x6f", [0x6349] = "\x54\xdd", [0x634a] = "\x70\x5f",
  [0x634b] = "\x70\x5e", [0x634c] = "\x54\xe5", [0x634d] = "\x54\xe4",
  [0x634e] = "\x54\xd6", [0x634f] = "\x54\xdc", [0x6350] = "\x54\xdf",
  [0x6351] = "\x70\x6b", [0x6354] = "\x70\x65", [0x6355] = "\x54\xd9",
  [0x6356] = "\x70\x56", [0x6357] = "\x70\x6d", [0x6358] = "\x70\x64",
  [0x6359] = "\x70\x66", [0x635a] = "\x70\x6a", [0x6365] = "\x73\x6c",
  [0x6367] = "\x57\x7b", [0x6368] = "\x57\x90", [0x6369] = "\x57\x8f",
  [0x636b] = "\x57\x84", [0x636d] = "\x73\x7e", [0x636e] = "\x73\x7a",
  [0x636f] = "\x73\x77", [0x6370] = "\x73\x8a", [0x6371] = "\x57\x7e",
  [0x6372] = "\x57\x76", [0x6375] = "\x73\x7c", [0x6376] = "\x59\xcc",
  [0x6377] = "\x57\x7a", [0x6378] = "\x73\x85", [0x637a] = "\x57\x91",
  [0x637b] = "\x57\x8e", [0x637c] = "\x73\x81", [0x637d] = "\x73\x6f",
  [0x6380] = "\x57\x8d", [0x6381] = "\x73\x87", [0x6382] = "\x73\x6e",
  [0x6383] = "\x57\x82", [0x6384] = "\x57\x86", [0x6385] = "\x73\x86",
  [0x6387] = "\x73\x78", [0x6388] = "\x57\x87", [0x6389] = "\x57\x81",
  [0x638a] = "\x73\x6d", [0x638c] = "\x59\xbe", [0x638d] = "\x73\x89",
  [0x638e] = "\x73\x76", [0x638f] = "\x57\x8c", [0x6390] = "\x73\x79",
  [0x6391] = "\x73\x88", [0x6392] = "\x57\x8b", [0x6394] = "\x76\x98",
  [0x6396] = "\x57\x77", [0x6397] = "\x73\x74", [0x6398] = "\x57\x7c",
  [0x6399] = "\x57\x88", [0x639b] = "\x57\x83", [0x639c] = "\x73\x7d",
  [0x639d] = "\x73\x73", [0x639e] = "\x73\x71", [0x639f] = "\x73\x84",
  [0x63a0] = "\x57\x74", [0x63a1] = "\x57\x89", [0x63a2] = "\x57\x78",
  [0x63a3] = "\x59\xbd", [0x63a4] = "\x73\x82", [0x63a5] = "\x57\x79",
  [0x63a7] = "\x57\x75", [0x63a8] = "\x57\x85", [0x63a9] = "\x57\x7f",
  [0x63aa] = "\x57\x7d", [0x63ab] = "\x73\x75", [0x63ac] = "\x57\x8a",
  [0x63ad] = "\x73\x72", [0x63ae] = "\x73\x7f", [0x63af] = "\x73\x7b",
  [0x63b0] = "\x76\x9a", [0x63b1] = "\x76\x99", [0x63bd] = "\x73\x70",
  [0x63be] = "\x76\xaa", [0x63c0] = "\x59\xc0", [0x63c2] = "\x76\xb0",
  [0x63c3] = "\x76\x9f", [0x63c4] = "\x76\xad", [0x63c5] = "\x79\xfd",
  [0x63c6] = "\x59\xc3", [0x63c7] = "\x76\xb1", [0x63c8] = "\x76\xb4",
  [0x63c9] = "\x59\xc2", [0x63ca] = "\x76\xa2", [0x63cb] = "\x76\xb3",
  [0x63cc] = "\x76\xb2", [0x63cd] = "\x59\xc4", [0x63ce] = "\x76\x9b",
  [0x63cf] = "\x59\xbf", [0x63d0] = "\x59\xc7", [0x63d2] = "\x59\xc5",
  [0x63d3] = "\x76\xaf", [0x63d5] = "\x76\xa5", [0x63d6] = "\x59\xc9",
  [0x63d7] = "\x76\xb6", [0x63d8] = "\x76\xae", [0x63d9] = "\x76\xb7",
  [0x63da] = "\x59\xd1", [0x63db] = "\x59\xcf", [0x63dc] = "\x76\xac",
  [0x63dd] = "\x76\xab", [0x63df] = "\x76\xa9", [0x63e0] = "\x76\xa3",
  [0x63e1] = "\x59\xc8", [0x63e3] = "\x59\xc6", [0x63e4] = "\x70\x5c",
  [0x63e5] = "\x76\x9c", [0x63e7] = "\x7a\x5e", [0x63e8] = "\x76\x9d",
  [0x63e9] = "\x59\xc1", [0x63ea] = "\x59\xce", [0x63eb] = "\x7a\x42",
  [0x63ed] = "\x59\xca", [0x63ee] = "\x59\xcb", [0x63ef] = "\x76\x9e",
  [0x63f0] = "\x76\xb5", [0x63f1] = "\x7a\x41", [0x63f2] = "\x76\xa6",
  [0x63f3] = "\x76\xa1", [0x63f4] = "\x59\xcd", [0x63f5] = "\x76\xa7",
  [0x63f6] = "\x76\xa4", [0x63f9] = "\x59\xd2", [0x6406] = "\x5c\x58",
  [0x6409] = "\x7a\x45", [0x640a] = "\x7a\x58", [0x640b] = "\x7a\x5d",
  [0x640c] = "\x7a\x51", [0x640d] = "\x5c\x54", [0x640e] = "\x7a\x62",
  [0x640f] = "\x5c\x51", [0x6410] = "\x7a\x43", [0x6412] = "\x7a\x44",
  [0x6413] = "\x5c\x4a", [0x6414] = "\x5c\x53", [0x6415] = "\x7a\x4b",
  [0x6416] = "\x5c\x56", [0x6417] = "\x5c\x57", [0x6418] = "\x7a\x4c",
  [0x641a] = "\x7a\x59", [0x641b] = "\x7a\x5f", [0x641c] = "\x5c\x52",
  [0x641e] = "\x5c\x4c", [0x641f] = "\x7a\x4a", [0x6420] = "\x7a\x46",
  [0x6421] = "\x7a\x61", [0x6422] = "\x7a\x4f", [0x6423] = "\x7a\x50",
  [0x6424] = "\x7a\x47", [0x6425] = "\x7a\x5b", [0x6426] = "\x7a\x52",
  [0x6427] = "\x7a\x5c", [0x6428] = "\x7a\x54", [0x642a] = "\x5c\x4d",
  [0x642b] = "\x7d\xc1", [0x642c] = "\x5c\x50", [0x642d] = "\x5c\x4e",
  [0x642e] = "\x7a\x60", [0x642f] = "\x7a\x57", [0x6430] = "\x7a\x53",
  [0x6433] = "\x7a\x48", [0x6434] = "\x5e\x9b", [0x6435] = "\x7a\x56",
  [0x6436] = "\x5c\x55", [0x6437] = "\x7a\x4e", [0x6439] = "\x7a\x4d",
  [0x643d] = "\x5c\x4f", [0x643e] = "\x5c\x4b", [0x643f] = "\x7d\xd6",
  [0x6440] = "\x7a\x5a", [0x6441] = "\x7a\x55", [0x6443] = "\x7a\x49",
  [0x644b] = "\x7d\xd1", [0x644d] = "\x7d\xc2", [0x644e] = "\x7d\xcd",
  [0x6450] = "\x7d\xd4", [0x6451] = "\x5e\x99", [0x6452] = "\x59\xd0",
  [0x6453] = "\x7d\xd2", [0x6454] = "\x5e\x94", [0x6458] = "\x5e\x93",
  [0x6459] = "\x7d\xd9", [0x645b] = "\x7d\xc3", [0x645c] = "\x7d\xd0",
  [0x645d] = "\x7d\xc4", [0x645e] = "\x7d\xcf", [0x645f] = "\x5e\x97",
  [0x6460] = "\x7d\xd3", [0x6461] = "\x76\xa8", [0x6465] = "\x7d\xda",
  [0x6466] = "\x7d\xcb", [0x6467] = "\x5e\x9a", [0x6468] = "\x80\xe2",
  [0x6469] = "\x60\x97", [0x646b] = "\x7d\xd8", [0x646c] = "\x7d\xd7",
  [0x646d] = "\x5e\x9c", [0x646e] = "\x80\xd5", [0x646f] = "\x60\x98",
  [0x6470] = "\x80\xd6", [0x6472] = "\x7d\xc7", [0x6473] = "\x7d\xc8",
  [0x6474] = "\x7d\xc5", [0x6475] = "\x7d\xca", [0x6476] = "\x7d\xc6",
  [0x6477] = "\x7d\xdb", [0x6478] = "\x5e\x96", [0x6479] = "\x60\x99",
  [0x647a] = "\x5e\x98", [0x647b] = "\x5e\x9d", [0x647d] = "\x7d\xc9",
  [0x647f] = "\x7d\xd5", [0x6482] = "\x7d\xce", [0x6485] = "\x80\xd9",
  [0x6487] = "\x5e\x92", [0x6488] = "\x60\x9c", [0x6489] = "\x84\x55",
  [0x648a] = "\x80\xde", [0x648b] = "\x80\xdd", [0x648c] = "\x80\xdf",
  [0x648f] = "\x80\xdc", [0x6490] = "\x60\x9d", [0x6491] = "\x68\xcb",
  [0x6492] = "\x60\xa3", [0x6493] = "\x60\xa0", [0x6495] = "\x60\xa1",
  [0x6496] = "\x80\xd7", [0x6497] = "\x80\xda", [0x6498] = "\x80\xe4",
  [0x6499] = "\x60\xa9", [0x649a] = "\x60\xa7", [0x649c] = "\x80\xdb",
  [0x649d] = "\x76\xa0", [0x649e] = "\x60\x9a", [0x649f] = "\x80\xe1",
  [0x64a0] = "\x80\xd8", [0x64a2] = "\x60\xaa", [0x64a3] = "\x80\xe0",
  [0x64a4] = "\x5e\x95", [0x64a5] = "\x60\x9f", [0x64a6] = "\x7d\xcc",
  [0x64a9] = "\x60\xa2", [0x64ab] = "\x60\xa6", [0x64ac] = "\x60\xa8",
  [0x64ad] = "\x60\xa5", [0x64ae] = "\x60\xa4", [0x64b0] = "\x60\x9e",
  [0x64b1] = "\x80\xe3", [0x64b2] = "\x60\x9b", [0x64b3] = "\x60\xab",
  [0x64bb] = "\x62\x82", [0x64bc] = "\x62\x83", [0x64bd] = "\x84\x54",
  [0x64be] = "\x62\x8c", [0x64bf] = "\x62\x89", [0x64c1] = "\x62\x7f",
  [0x64c2] = "\x62\x87", [0x64c3] = "\x84\x56", [0x64c4] = "\x62\x85",
  [0x64c5] = "\x62\x7e", [0x64c7] = "\x62\x86", [0x64c9] = "\x84\x53",
  [0x64ca] = "\x63\xe3", [0x64cb] = "\x62\x81", [0x64cd] = "\x62\x88",
  [0x64ce] = "\x63\xe2", [0x64cf] = "\x84\x52", [0x64d0] = "\x84\x51",
  [0x64d2] = "\x62\x8a", [0x64d4] = "\x62\x8b", [0x64d6] = "\x84\x50",
  [0x64d7] = "\x84\x4f", [0x64d8] = "\x63\xe4", [0x64d9] = "\x84\x59",
  [0x64da] = "\x62\x84", [0x64db] = "\x84\x57", [0x64e0] = "\x63\xe5",
  [0x64e2] = "\x63\xea", [0x64e3] = "\x86\xf5", [0x64e4] = "\x86\xf7",
  [0x64e6] = "\x63\xe7", [0x64e8] = "\x86\xf8", [0x64e9] = "\x86\xf4",
  [0x64eb] = "\x86\xf6", [0x64ec] = "\x63\xe8", [0x64ed] = "\x63\xeb",
  [0x64ef] = "\x86\xf3", [0x64f0] = "\x63\xe6", [0x64f1] = "\x63\xe9",
  [0x64f2] = "\x65\x64", [0x64f3] = "\x84\x58", [0x64f4] = "\x65\x63",
  [0x64f7] = "\x65\x69", [0x64f8] = "\x89\x82", [0x64fa] = "\x65\x67",
  [0x64fb] = "\x65\x68", [0x64fc] = "\x89\x85", [0x64fd] = "\x89\x81",
  [0x64fe] = "\x65\x65", [0x64ff] = "\x89\x7e", [0x6500] = "\x66\x57",
  [0x6501] = "\x89\x83", [0x6503] = "\x89\x84", [0x6504] = "\x89\x7f",
  [0x6506] = "\x65\x66", [0x6507] = "\x8b\x70", [0x6509] = "\x8b\x73",
  [0x650c] = "\x8b\x74", [0x650d] = "\x8b\x72", [0x650e] = "\x8b\x75",
  [0x650f] = "\x66\x58", [0x6510] = "\x8b\x71", [0x6513] = "\x8c\xfb",
  [0x6514] = "\x66\xee", [0x6515] = "\x8c\xfa", [0x6516] = "\x8c\xf9",
  [0x6517] = "\x8c\xf8", [0x6518] = "\x66\xed", [0x6519] = "\x66\xef",
  [0x651b] = "\x8e\x7c", [0x651c] = "\x67\x8e", [0x651d] = "\x67\x8d",
  [0x6520] = "\x8f\x71", [0x6521] = "\x8f\x70", [0x6522] = "\x8f\x73",
  [0x6523] = "\x68\x57", [0x6524] = "\x67\xe0", [0x6525] = "\x90\x4e",
  [0x6526] = "\x8f\x72", [0x6529] = "\x90\x4d", [0x652a] = "\x68\x59",
  [0x652b] = "\x68\x58", [0x652c] = "\x68\x7f", [0x652d] = "\x90\xb8",
  [0x652e] = "\x91\x41", [0x652f] = "\x4c\xc4", [0x6532] = "\x76\xb8",
  [0x6533] = "\x84\x5a", [0x6534] = "\x48\x82", [0x6536] = "\x4e\x4d",
  [0x6537] = "\x6a\xb8", [0x6538] = "\x4f\x73", [0x6539] = "\x4f\x71",
  [0x653b] = "\x4f\x72", [0x653d] = "\x6c\x43", [0x653e] = "\x50\xf2",
  [0x653f] = "\x52\xc8", [0x6541] = "\x6d\xe8", [0x6543] = "\x6d\xe9",
  [0x6545] = "\x52\xc9", [0x6546] = "\x70\x71", [0x6548] = "\x54\xe6",
  [0x6549] = "\x54\xe7", [0x654a] = "\x70\x70", [0x654f] = "\x57\x98",
  [0x6551] = "\x57\x94", [0x6553] = "\x73\x8b", [0x6554] = "\x57\x9b",
  [0x6555] = "\x57\x9a", [0x6556] = "\x57\x93", [0x6557] = "\x57\x96",
  [0x6558] = "\x57\x99", [0x6559] = "\x57\x95", [0x655c] = "\x76\xbc",
  [0x655d] = "\x57\x92", [0x655e] = "\x59\xd3", [0x6562] = "\x59\xd5",
  [0x6563] = "\x59\xd6", [0x6564] = "\x76\xbb", [0x6565] = "\x76\xbe",
  [0x6566] = "\x59\xd4", [0x6567] = "\x76\xb9", [0x6568] = "\x76\xbd",
  [0x656a] = "\x76\xba", [0x656c] = "\x5c\x59", [0x656f] = "\x7a\x63",
  [0x6572] = "\x5e\x9e", [0x6573] = "\x7d\xdc", [0x6574] = "\x62\x8d",
  [0x6575] = "\x60\xac", [0x6576] = "\x80\xe5", [0x6577] = "\x60\xad",
  [0x6578] = "\x60\xae", [0x6579] = "\x80\xe7", [0x657a] = "\x80\xe6",
  [0x657b] = "\x80\xe8", [0x657c] = "\x84\x5c", [0x657f] = "\x84\x5b",
  [0x6580] = "\x86\xfa", [0x6581] = "\x86\xf9", [0x6582] = "\x63\xec",
  [0x6583] = "\x63\xed", [0x6584] = "\x8b\x76", [0x6587] = "\x4c\xc5",
  [0x658c] = "\x76\xbf", [0x6590] = "\x59\xd8", [0x6591] = "\x59\xd7",
  [0x6592] = "\x7a\x64", [0x6594] = "\x89\x86", [0x6595] = "\x67\x8f",
  [0x6596] = "\x90\x4f", [0x6597] = "\x4c\xc6", [0x6599] = "\x54\xe8",
  [0x659b] = "\x57\x9d", [0x659c] = "\x57\x9c", [0x659d] = "\x76\xc0",
  [0x659e] = "\x76\xc1", [0x659f] = "\x5c\x5a", [0x65a0] = "\x7d\xdd",
  [0x65a1] = "\x5e\x9f", [0x65a2] = "\x84\x5d", [0x65a4] = "\x4c\xc7",
  [0x65a5] = "\x4d\x78", [0x65a7] = "\x50\xf3", [0x65a8] = "\x6c\x44",
  [0x65aa] = "\x6d\xea", [0x65ab] = "\x52\xca", [0x65ac] = "\x57\x9e",
  [0x65ae] = "\x76\xc2", [0x65af] = "\x59\xd9", [0x65b0] = "\x5c\x5b",
  [0x65b2] = "\x80\xe9", [0x65b3] = "\x80\xea", [0x65b6] = "\x86\xfb",
  [0x65b7] = "\x65\x6a", [0x65b8] = "\x91\x42", [0x65b9] = "\x4c\xc8",
  [0x65bb] = "\x6c\x45", [0x65bc] = "\x50\xf4", [0x65bd] = "\x52\xcb",
  [0x65bf] = "\x6d\xeb", [0x65c1] = "\x54\xe9", [0x65c2] = "\x70\x75",
  [0x65c3] = "\x70\x73", [0x65c4] = "\x70\x74", [0x65c5] = "\x54\xea",
  [0x65c6] = "\x70\x72", [0x65cb] = "\x57\xa0", [0x65cc] = "\x57\xa1",
  [0x65cd] = "\x73\x8c", [0x65ce] = "\x57\xa2", [0x65cf] = "\x57\x9f",
  [0x65d0] = "\x76\xc3", [0x65d2] = "\x76\xc4", [0x65d3] = "\x7a\x65",
  [0x65d6] = "\x5e\xa1", [0x65d7] = "\x5e\xa0", [0x65da] = "\x86\xfc",
  [0x65db] = "\x89\x87", [0x65dd] = "\x8b\x78", [0x65de] = "\x8b\x77",
  [0x65df] = "\x8c\xfc", [0x65e0] = "\x48\x87", [0x65e1] = "\x69\x5f",
  [0x65e2] = "\x52\xcc", [0x65e5] = "\x4c\xc9", [0x65e6] = "\x4d\x79",
  [0x65e8] = "\x4e\x4f", [0x65e9] = "\x4e\x4e", [0x65ec] = "\x4e\x50",
  [0x65ed] = "\x4e\x51", [0x65ee] = "\x69\xce", [0x65ef] = "\x69\xcd",
  [0x65f0] = "\x6a\xb9", [0x65f1] = "\x4f\x74", [0x65f2] = "\x6a\xbc",
  [0x65f3] = "\x6a\xbb", [0x65f4] = "\x6a\xba", [0x65f5] = "\x6a\xbd",
  [0x65fa] = "\x50\xf5", [0x65fb] = "\x6c\x4b", [0x65fc] = "\x6c\x47",
  [0x65fd] = "\x6c\x50", [0x6600] = "\x50\xfc", [0x6602] = "\x50\xfa",
  [0x6603] = "\x6c\x4c", [0x6604] = "\x6c\x48", [0x6605] = "\x6c\x4f",
  [0x6606] = "\x50\xf9", [0x6607] = "\x51\x43", [0x6608] = "\x6c\x4a",
  [0x6609] = "\x6c\x46", [0x660a] = "\x51\x42", [0x660b] = "\x6c\x4d",
  [0x660c] = "\x50\xf8", [0x660d] = "\x6c\x4e", [0x660e] = "\x50\xfb",
  [0x660f] = "\x50\xfd", [0x6610] = "\x6c\x52", [0x6611] = "\x6c\x51",
  [0x6612] = "\x6c\x49", [0x6613] = "\x50\xf7", [0x6614] = "\x50\xf6",
  [0x6615] = "\x51\x41", [0x661c] = "\x6d\xf0", [0x661d] = "\x6d\xf6",
  [0x661f] = "\x52\xd2", [0x6620] = "\x52\xcf", [0x6621] = "\x6d\xed",
  [0x6622] = "\x6d\xf2", [0x6624] = "\x52\xd5", [0x6625] = "\x52\xcd",
  [0x6626] = "\x6d\xf1", [0x6627] = "\x52\xd0", [0x6628] = "\x52\xd3",
  [0x662b] = "\x6d\xf4", [0x662d] = "\x52\xce", [0x662e] = "\x6d\xf9",
  [0x662f] = "\x52\xd1", [0x6631] = "\x52\xd4", [0x6632] = "\x6d\xee",
  [0x6633] = "\x6d\xf3", [0x6634] = "\x6d\xf7", [0x6635] = "\x6d\xef",
  [0x6636] = "\x6d\xec", [0x6639] = "\x6d\xf8", [0x663a] = "\x6d\xf5",
  [0x6641] = "\x54\xf2", [0x6642] = "\x54\xeb", [0x6643] = "\x54\xee",
  [0x6645] = "\x54\xf1", [0x6647] = "\x70\x78", [0x6649] = "\x54\xec",
  [0x664a] = "\x70\x76", [0x664c] = "\x54\xf0", [0x664f] = "\x54\xed",
  [0x6651] = "\x70\x79", [0x6652] = "\x54\xef", [0x6659] = "\x73\x90",
  [0x665a] = "\x57\xa4", [0x665b] = "\x73\x8f", [0x665c] = "\x73\x91",
  [0x665d] = "\x57\xa3", [0x665e] = "\x57\xa8", [0x665f] = "\x70\x77",
  [0x6661] = "\x73\x8e", [0x6662] = "\x73\x92", [0x6664] = "\x57\xa5",
  [0x6665] = "\x73\x8d", [0x6666] = "\x57\xa7", [0x6668] = "\x57\xa6",
  [0x666a] = "\x76\xcb", [0x666c] = "\x76\xc6", [0x666e] = "\x59\xda",
  [0x666f] = "\x59\xde", [0x6670] = "\x59\xdb", [0x6671] = "\x76\xc9",
  [0x6672] = "\x76\xcc", [0x6674] = "\x59\xdc", [0x6676] = "\x59\xdd",
  [0x6677] = "\x59\xe2", [0x6678] = "\x7a\x6e", [0x6679] = "\x76\xca",
  [0x667a] = "\x59\xe0", [0x667b] = "\x76\xc7", [0x667c] = "\x76\xc5",
  [0x667e] = "\x59\xe1", [0x6680] = "\x76\xc8", [0x6684] = "\x5c\x61",
  [0x6686] = "\x7a\x66", [0x6687] = "\x5c\x5e", [0x6688] = "\x5c\x5f",
  [0x6689] = "\x5c\x5d", [0x668a] = "\x7a\x6b", [0x668b] = "\x7a\x6a",
  [0x668c] = "\x7a\x67", [0x668d] = "\x5c\x63", [0x6690] = "\x7a\x69",
  [0x6691] = "\x59\xdf", [0x6694] = "\x7a\x6d", [0x6695] = "\x7a\x68",
  [0x6696] = "\x5c\x60", [0x6697] = "\x5c\x5c", [0x6698] = "\x5c\x62",
  [0x6699] = "\x7a\x6c", [0x669d] = "\x5e\xa4", [0x669f] = "\x7d\xe0",
  [0x66a0] = "\x7d\xdf", [0x66a1] = "\x7d\xde", [0x66a2] = "\x5e\xa2",
  [0x66a8] = "\x5e\xa3", [0x66a9] = "\x80\xed", [0x66aa] = "\x80\xf0",
  [0x66ab] = "\x60\xb0", [0x66ae] = "\x60\xaf", [0x66af] = "\x80\xf1",
  [0x66b0] = "\x80\xec", [0x66b1] = "\x60\xb2", [0x66b2] = "\x80\xee",
  [0x66b4] = "\x60\xb1", [0x66b5] = "\x80\xeb", [0x66b7] = "\x80\xef",
  [0x66b8] = "\x62\x93", [0x66b9] = "\x62\x90", [0x66ba] = "\x84\x66",
  [0x66bb] = "\x84\x65", [0x66bd] = "\x84\x64", [0x66be] = "\x84\x5f",
  [0x66c0] = "\x84\x60", [0x66c4] = "\x62\x91", [0x66c6] = "\x62\x8e",
  [0x66c7] = "\x62\x92", [0x66c8] = "\x84\x5e", [0x66c9] = "\x62\x8f",
  [0x66ca] = "\x84\x61", [0x66cb] = "\x84\x62", [0x66cc] = "\x84\x67",
  [0x66cf] = "\x84\x63", [0x66d2] = "\x86\xfd", [0x66d6] = "\x63\xef",
  [0x66d8] = "\x89\x8a", [0x66d9] = "\x63\xee", [0x66da] = "\x89\x88",
  [0x66db] = "\x89\x89", [0x66dc] = "\x65\x6b", [0x66dd] = "\x66\x5a",
  [0x66de] = "\x8b\x79", [0x66e0] = "\x66\x59", [0x66e3] = "\x8d\x41",
  [0x66e4] = "\x8d\x42", [0x66e6] = "\x66\xf0", [0x66e8] = "\x8c\xfd",
  [0x66e9] = "\x67\x90", [0x66eb] = "\x90\x50", [0x66ec] = "\x68\x5a",
  [0x66ed] = "\x90\xb9", [0x66ee] = "\x90\xba", [0x66f0] = "\x4c\xca",
  [0x66f2] = "\x4e\x52", [0x66f3] = "\x4e\x53", [0x66f4] = "\x4f\x75",
  [0x66f6] = "\x6c\x53", [0x66f7] = "\x52\xd6", [0x66f8] = "\x54\xf3",
  [0x66f9] = "\x57\xa9", [0x66fc] = "\x56\xb6", [0x66fe] = "\x59\xe3",
  [0x66ff] = "\x59\xe4", [0x6700] = "\x59\x52", [0x6701] = "\x76\xcd",
  [0x6703] = "\x5c\x64", [0x6704] = "\x7d\xe2", [0x6705] = "\x7d\xe1",
  [0x6708] = "\x4c\xcb", [0x6709] = "\x4e\x54", [0x670a] = "\x6c\x54",
  [0x670b] = "\x51\x45", [0x670d] = "\x51\x44", [0x670f] = "\x6d\xfa",
  [0x6710] = "\x6d\xfb", [0x6712] = "\x70\x7a", [0x6713] = "\x70\x7b",
  [0x6714] = "\x54\xf4", [0x6715] = "\x54\xf5", [0x6717] = "\x54\xf6",
  [0x6718] = "\x73\x93", [0x671b] = "\x57\xab", [0x671d] = "\x59\xe6",
  [0x671f] = "\x59\xe5", [0x6720] = "\x7a\x6f", [0x6721] = "\x7b\xc2",
  [0x6722] = "\x7d\xe3", [0x6723] = "\x84\x68", [0x6726] = "\x65\x6c",
  [0x6727] = "\x66\xf1", [0x6728] = "\x4c\xcc", [0x672a] = "\x4d\x7c",
  [0x672b] = "\x4d\x7d", [0x672c] = "\x4d\x7b", [0x672d] = "\x4d\x7e",
  [0x672e] = "\x4d\x7a", [0x6731] = "\x4e\x57", [0x6733] = "\x69\xd6",
  [0x6734] = "\x4e\x56", [0x6735] = "\x4e\x58", [0x6738] = "\x69\xd1",
  [0x6739] = "\x69\xd0", [0x673a] = "\x69\xd3", [0x673b] = "\x69\xd2",
  [0x673c] = "\x69\xd5", [0x673d] = "\x4e\x55", [0x673e] = "\x69\xcf",
  [0x673f] = "\x69\xd4", [0x6745] = "\x6a\xbe", [0x6746] = "\x4f\x7f",
  [0x6747] = "\x6a\xbf", [0x6748] = "\x6a\xc3", [0x6749] = "\x4f\x7e",
  [0x674b] = "\x6a\xc7", [0x674c] = "\x6a\xc2", [0x674d] = "\x6a\xc5",
  [0x674e] = "\x4f\x77", [0x674f] = "\x4f\x78", [0x6750] = "\x4f\x79",
  [0x6751] = "\x4f\x7a", [0x6753] = "\x4f\x82", [0x6755] = "\x6a\xc1",
  [0x6756] = "\x4f\x7c", [0x6757] = "\x4f\x83", [0x6759] = "\x6a\xc0",
  [0x675a] = "\x6a\xc6", [0x675c] = "\x4f\x7b", [0x675d] = "\x6a\xc4",
  [0x675e] = "\x4f\x7d", [0x675f] = "\x4f\x76", [0x6760] = "\x4f\x81",
  [0x676a] = "\x51\x5a", [0x676c] = "\x6c\x56", [0x676d] = "\x51\x46",
  [0x676f] = "\x51\x50", [0x6770] = "\x51\x51", [0x6771] = "\x51\x49",
  [0x6772] = "\x51\x5b", [0x6773] = "\x51\x4b", [0x6774] = "\x6c\x5e",
  [0x6775] = "\x51\x56", [0x6776] = "\x6c\x59", [0x6777] = "\x51\x4c",
  [0x6778] = "\x6c\x68", [0x6779] = "\x6c\x69", [0x677a] = "\x6c\x61",
  [0x677b] = "\x6c\x5a", [0x677c] = "\x51\x59", [0x677d] = "\x6c\x66",
  [0x677e] = "\x51\x54", [0x677f] = "\x51\x52", [0x6781] = "\x6c\x67",
  [0x6783] = "\x6c\x65", [0x6784] = "\x6c\x5d", [0x6785] = "\x6c\x55",
  [0x6786] = "\x6c\x5c", [0x6787] = "\x51\x4d", [0x6789] = "\x51\x53",
  [0x678b] = "\x51\x47", [0x678c] = "\x6c\x60", [0x678d] = "\x6c\x5f",
  [0x678e] = "\x6c\x57", [0x6790] = "\x51\x55", [0x6791] = "\x6c\x63",
  [0x6792] = "\x6c\x58", [0x6793] = "\x51\x58", [0x6794] = "\x6c\x6a",
  [0x6795] = "\x51\x48", [0x6797] = "\x51\x4f", [0x6798] = "\x6c\x5b",
  [0x6799] = "\x6c\x64", [0x679a] = "\x51\x57", [0x679c] = "\x51\x4a",
  [0x679d] = "\x51\x4e", [0x679f] = "\x6c\x62", [0x67ae] = "\x6e\x5e",
  [0x67af] = "\x52\xde", [0x67b0] = "\x52\xeb", [0x67b2] = "\x6e\x59",
  [0x67b3] = "\x6e\x4f", [0x67b4] = "\x52\xe4", [0x67b5] = "\x6e\x4d",
  [0x67b6] = "\x52\xdd", [0x67b7] = "\x6e\x48", [0x67b8] = "\x52\xe7",
  [0x67b9] = "\x6e\x55", [0x67ba] = "\x6e\x42", [0x67bb] = "\x6e\x44",
  [0x67c0] = "\x6e\x47", [0x67c1] = "\x6d\xfc", [0x67c2] = "\x6e\x54",
  [0x67c3] = "\x6e\x64", [0x67c4] = "\x52\xe2", [0x67c5] = "\x6e\x49",
  [0x67c6] = "\x6e\x5b", [0x67c8] = "\x6e\x41", [0x67c9] = "\x6e\x62",
  [0x67ca] = "\x6e\x63", [0x67cb] = "\x6e\x66", [0x67cc] = "\x6e\x5d",
  [0x67cd] = "\x6e\x4e", [0x67ce] = "\x6e\x56", [0x67cf] = "\x52\xe8",
  [0x67d0] = "\x52\xdb", [0x67d1] = "\x52\xe3", [0x67d2] = "\x52\xef",
  [0x67d3] = "\x52\xd8", [0x67d4] = "\x52\xda", [0x67d8] = "\x6e\x46",
  [0x67d9] = "\x52\xec", [0x67da] = "\x52\xe5", [0x67db] = "\x6e\x60",
  [0x67dc] = "\x6e\x43", [0x67dd] = "\x52\xee", [0x67de] = "\x52\xe9",
  [0x67df] = "\x6e\x4c", [0x67e2] = "\x52\xed", [0x67e3] = "\x6e\x53",
  [0x67e4] = "\x6e\x4b", [0x67e5] = "\x52\xe6", [0x67e6] = "\x6e\x5f",
  [0x67e7] = "\x6e\x57", [0x67e9] = "\x52\xe0", [0x67ea] = "\x6e\x65",
  [0x67eb] = "\x6e\x4a", [0x67ec] = "\x52\xdc", [0x67ed] = "\x6e\x5c",
  [0x67ee] = "\x6e\x52", [0x67ef] = "\x52\xe1", [0x67f0] = "\x6e\x58",
  [0x67f1] = "\x52\xd9", [0x67f2] = "\x6d\xfd", [0x67f3] = "\x52\xea",
  [0x67f4] = "\x55\x48", [0x67f5] = "\x52\xdf", [0x67f6] = "\x6e\x51",
  [0x67f7] = "\x6e\x50", [0x67f8] = "\x6e\x45", [0x67fa] = "\x6e\x61",
  [0x67fc] = "\x6e\x5a", [0x67ff] = "\x52\xd7", [0x6812] = "\x70\x90",
  [0x6813] = "\x55\x4f", [0x6814] = "\x70\x91", [0x6816] = "\x70\x85",
  [0x6817] = "\x55\x44", [0x6818] = "\x55\x50", [0x681a] = "\x70\x7d",
  [0x681c] = "\x70\x87", [0x681d] = "\x70\x8f", [0x681f] = "\x70\x7c",
  [0x6820] = "\x70\x98", [0x6821] = "\x54\xf7", [0x6825] = "\x70\x97",
  [0x6826] = "\x70\x92", [0x6828] = "\x70\x93", [0x6829] = "\x55\x42",
  [0x682a] = "\x55\x4d", [0x682b] = "\x70\x89", [0x682d] = "\x70\x8a",
  [0x682e] = "\x70\x94", [0x682f] = "\x70\x8b", [0x6831] = "\x70\x86",
  [0x6832] = "\x70\x7f", [0x6833] = "\x70\x81", [0x6834] = "\x70\x8e",
  [0x6835] = "\x70\x88", [0x6838] = "\x54\xf8", [0x6839] = "\x54\xfc",
  [0x683a] = "\x70\x96", [0x683b] = "\x70\x82", [0x683c] = "\x55\x4b",
  [0x683d] = "\x55\x47", [0x6840] = "\x55\x4a", [0x6841] = "\x55\x51",
  [0x6842] = "\x54\xfd", [0x6843] = "\x55\x4c", [0x6844] = "\x70\x8d",
  [0x6845] = "\x55\x4e", [0x6846] = "\x54\xfa", [0x6848] = "\x54\xf9",
  [0x6849] = "\x70\x7e", [0x684b] = "\x70\x83", [0x684c] = "\x55\x45",
  [0x684d] = "\x70\x95", [0x684e] = "\x70\x8c", [0x684f] = "\x70\x84",
  [0x6850] = "\x55\x49", [0x6851] = "\x55\x46", [0x6853] = "\x54\xfb",
  [0x6854] = "\x55\x41", [0x686b] = "\x73\xa8", [0x686d] = "\x73\x98",
  [0x686e] = "\x73\x99", [0x686f] = "\x73\x9d", [0x6871] = "\x73\xac",
  [0x6872] = "\x73\xa9", [0x6874] = "\x73\xa2", [0x6875] = "\x73\xa1",
  [0x6876] = "\x57\xb2", [0x6877] = "\x73\xa5", [0x6878] = "\x73\xb4",
  [0x6879] = "\x73\x94", [0x687b] = "\x73\xb5", [0x687c] = "\x73\xa7",
  [0x687d] = "\x73\xb9", [0x687e] = "\x73\xad", [0x687f] = "\x57\xb1",
  [0x6880] = "\x73\xab", [0x6881] = "\x57\xac", [0x6882] = "\x57\xc1",
  [0x6883] = "\x57\xb7", [0x6885] = "\x57\xbb", [0x6886] = "\x57\xba",
  [0x6887] = "\x73\x95", [0x6889] = "\x73\xb2", [0x688a] = "\x73\xb8",
  [0x688b] = "\x73\xb0", [0x688c] = "\x73\xb7", [0x688f] = "\x73\xa4",
  [0x6890] = "\x73\x96", [0x6891] = "\x73\xb6", [0x6892] = "\x73\xa6",
  [0x6893] = "\x57\xaf", [0x6894] = "\x57\xbc", [0x6896] = "\x73\xaf",
  [0x6897] = "\x57\xb5", [0x689b] = "\x73\xae", [0x689c] = "\x73\x97",
  [0x689d] = "\x57\xbd", [0x689f] = "\x57\xbf", [0x68a0] = "\x73\xb1",
  [0x68a1] = "\x57\xc0", [0x68a2] = "\x57\xae", [0x68a3] = "\x73\x9e",
  [0x68a4] = "\x73\xb3", [0x68a7] = "\x57\xb4", [0x68a8] = "\x57\xbe",
  [0x68a9] = "\x73\xa0", [0x68aa] = "\x73\xaa", [0x68ab] = "\x73\x9b",
  [0x68ac] = "\x73\x9f", [0x68ad] = "\x57\xb9", [0x68ae] = "\x73\x9a",
  [0x68af] = "\x57\xad", [0x68b0] = "\x57\xb6", [0x68b1] = "\x57\xb3",
  [0x68b2] = "\x73\xa3", [0x68b3] = "\x55\x43", [0x68b4] = "\x76\xe4",
  [0x68b5] = "\x57\xb0", [0x68c4] = "\x57\xb8", [0x68c6] = "\x76\xe7",
  [0x68c7] = "\x76\xfd", [0x68c8] = "\x76\xf2", [0x68c9] = "\x59\xfa",
  [0x68cb] = "\x59\xf5", [0x68cc] = "\x76\xe1", [0x68cd] = "\x59\xf6",
  [0x68ce] = "\x76\xf1", [0x68d0] = "\x76\xea", [0x68d1] = "\x76\xf7",
  [0x68d2] = "\x59\xf2", [0x68d3] = "\x76\xcf", [0x68d4] = "\x76\xf9",
  [0x68d5] = "\x59\xe8", [0x68d6] = "\x76\xd7", [0x68d7] = "\x59\xeb",
  [0x68d8] = "\x59\xea", [0x68da] = "\x59\xfb", [0x68dc] = "\x76\xd1",
  [0x68dd] = "\x76\xf3", [0x68de] = "\x76\xf4", [0x68df] = "\x59\xed",
  [0x68e0] = "\x59\xe9", [0x68e1] = "\x76\xdf", [0x68e3] = "\x59\xf4",
  [0x68e4] = "\x76\xda", [0x68e6] = "\x76\xf5", [0x68e7] = "\x59\xf0",
  [0x68e8] = "\x76\xed", [0x68e9] = "\x76\xfa", [0x68ea] = "\x76\xd4",
  [0x68eb] = "\x76\xd9", [0x68ec] = "\x76\xd3", [0x68ee] = "\x59\xef",
  [0x68ef] = "\x76\xe6", [0x68f0] = "\x7a\x86", [0x68f1] = "\x76\xd5",
  [0x68f2] = "\x59\xf3", [0x68f3] = "\x76\xde", [0x68f4] = "\x76\xf6",
  [0x68f5] = "\x59\xee", [0x68f6] = "\x76\xdb", [0x68f7] = "\x76\xd8",
  [0x68f8] = "\x76\xe9", [0x68f9] = "\x59\xf1", [0x68fa] = "\x59\xe7",
  [0x68fb] = "\x59\xfd", [0x68fc] = "\x76\xec", [0x68fd] = "\x76\xeb",
  [0x6904] = "\x76\xd0", [0x6905] = "\x59\xec", [0x6906] = "\x76\xf8",
  [0x6907] = "\x76\xe0", [0x6908] = "\x76\xe2", [0x690a] = "\x76\xef",
  [0x690b] = "\x76\xee", [0x690c] = "\x76\xce", [0x690d] = "\x59\xf7",
  [0x690e] = "\x59\xf9", [0x690f] = "\x76\xd6", [0x6910] = "\x76\xdd",
  [0x6911] = "\x76\xe5", [0x6912] = "\x59\xf8", [0x6913] = "\x76\xdc",
  [0x6914] = "\x76\xe8", [0x6915] = "\x76\xfb", [0x6917] = "\x76\xf0",
  [0x691e] = "\x91\xc6", [0x6925] = "\x76\xfc", [0x692a] = "\x76\xd2",
  [0x692f] = "\x7a\x9a", [0x6930] = "\x5c\x6c", [0x6932] = "\x7a\x98",
  [0x6933] = "\x7a\x83", [0x6934] = "\x7a\x88", [0x6935] = "\x7a\x81",
  [0x6937] = "\x7a\x94", [0x6938] = "\x7a\x72", [0x6939] = "\x7a\x79",
  [0x693b] = "\x7a\x92", [0x693c] = "\x7a\x9c", [0x693d] = "\x7a\x84",
  [0x693f] = "\x7a\x76", [0x6940] = "\x7a\x8a", [0x6941] = "\x7a\x8f",
  [0x6942] = "\x7a\x7a", [0x6944] = "\x7a\x8c", [0x6945] = "\x7a\x77",
  [0x6948] = "\x7a\x7e", [0x6949] = "\x7a\x7f", [0x694a] = "\x5c\x6e",
  [0x694b] = "\x7a\x93", [0x694c] = "\x7a\x91", [0x694e] = "\x7a\x73",
  [0x694f] = "\x7a\x96", [0x6951] = "\x7a\x97", [0x6952] = "\x7a\x99",
  [0x6953] = "\x5c\x72", [0x6954] = "\x5c\x6a", [0x6956] = "\x73\x9c",
  [0x6957] = "\x7a\x7b", [0x6958] = "\x7a\x8e", [0x6959] = "\x7a\x7c",
  [0x695a] = "\x5c\x67", [0x695b] = "\x5c\x77", [0x695c] = "\x7a\x95",
  [0x695d] = "\x5c\x75", [0x695e] = "\x5c\x71", [0x695f] = "\x7a\x71",
  [0x6960] = "\x5c\x69", [0x6962] = "\x7a\x74", [0x6963] = "\x5c\x76",
  [0x6965] = "\x7a\x85", [0x6966] = "\x7a\x70", [0x6968] = "\x5c\x6f",
  [0x6969] = "\x7a\x89", [0x696a] = "\x7a\x78", [0x696b] = "\x5c\x70",
  [0x696c] = "\x7a\x82", [0x696d] = "\x5c\x66", [0x696e] = "\x59\xfc",
  [0x696f] = "\x7a\x8b", [0x6970] = "\x76\xe3", [0x6971] = "\x7a\x75",
  [0x6974] = "\x7a\x90", [0x6975] = "\x5c\x6b", [0x6976] = "\x7a\x8d",
  [0x6977] = "\x5c\x68", [0x6978] = "\x7a\x87", [0x6979] = "\x5c\x73",
  [0x697a] = "\x7a\x7d", [0x697b] = "\x7a\x9b", [0x6982] = "\x5c\x6d",
  [0x6983] = "\x7b\x4e", [0x6986] = "\x5c\x74", [0x698d] = "\x7d\xf1",
  [0x698e] = "\x7d\xef", [0x6990] = "\x7e\x48", [0x6991] = "\x7d\xed",
  [0x6993] = "\x7e\x42", [0x6994] = "\x5c\x65", [0x6995] = "\x5e\xa7",
  [0x6996] = "\x7d\xe9", [0x6997] = "\x7e\x47", [0x6999] = "\x7d\xee",
  [0x699a] = "\x7d\xfc", [0x699b] = "\x5e\xac", [0x699c] = "\x5e\xa5",
  [0x699e] = "\x7e\x45", [0x69a0] = "\x7d\xe7", [0x69a1] = "\x7e\x44",
  [0x69a3] = "\x5e\xb7", [0x69a4] = "\x7d\xf8", [0x69a5] = "\x7e\x4b",
  [0x69a6] = "\x5e\xb5", [0x69a7] = "\x7d\xf0", [0x69a8] = "\x5e\xa6",
  [0x69a9] = "\x7d\xf2", [0x69aa] = "\x7e\x43", [0x69ab] = "\x5e\xaf",
  [0x69ac] = "\x7d\xeb", [0x69ad] = "\x5e\xb3", [0x69ae] = "\x5e\xa9",
  [0x69af] = "\x7d\xf4", [0x69b0] = "\x7d\xea", [0x69b1] = "\x7d\xe4",
  [0x69b3] = "\x7e\x41", [0x69b4] = "\x5e\xb0", [0x69b5] = "\x7e\x4a",
  [0x69b6] = "\x7d\xe5", [0x69b7] = "\x5e\xad", [0x69b9] = "\x7d\xfa",
  [0x69bb] = "\x5e\xae", [0x69bc] = "\x7d\xec", [0x69bd] = "\x7d\xf7",
  [0x69be] = "\x7d\xf3", [0x69bf] = "\x7d\xf5", [0x69c1] = "\x5e\xa8",
  [0x69c2] = "\x7e\x49", [0x69c3] = "\x5e\xb6", [0x69c4] = "\x7d\xf6",
  [0x69c6] = "\x7e\x4c", [0x69c9] = "\x7d\xe6", [0x69ca] = "\x7d\xfb",
  [0x69cb] = "\x5e\xab", [0x69cc] = "\x5e\xb4", [0x69cd] = "\x5e\xb2",
  [0x69ce] = "\x7d\xe8", [0x69cf] = "\x7d\xfd", [0x69d0] = "\x5e\xb1",
  [0x69d3] = "\x5e\xaa", [0x69d4] = "\x7d\xf9", [0x69d9] = "\x7e\x46",
  [0x69e2] = "\x80\xfd", [0x69e4] = "\x80\xf9", [0x69e5] = "\x80\xf5",
  [0x69e6] = "\x81\x4c", [0x69e7] = "\x81\x49", [0x69e8] = "\x60\xb5",
  [0x69eb] = "\x81\x50", [0x69ec] = "\x80\xfc", [0x69ed] = "\x60\xc0",
  [0x69ee] = "\x81\x46", [0x69f1] = "\x80\xf8", [0x69f2] = "\x81\x45",
  [0x69f3] = "\x60\xbd", [0x69f4] = "\x81\x59", [0x69f6] = "\x81\x56",
  [0x69f7] = "\x81\x48", [0x69f8] = "\x80\xf6", [0x69fb] = "\x81\x4d",
  [0x69fc] = "\x81\x4f", [0x69fd] = "\x60\xb9", [0x69fe] = "\x81\x43",
  [0x69ff] = "\x80\xfb", [0x6a00] = "\x80\xf2", [0x6a01] = "\x60\xb6",
  [0x6a02] = "\x60\xbe", [0x6a04] = "\x81\x52", [0x6a05] = "\x60\xbf",
  [0x6a06] = "\x80\xf3", [0x6a07] = "\x81\x58", [0x6a08] = "\x81\x4b",
  [0x6a09] = "\x81\x51", [0x6a0a] = "\x60\xbc", [0x6a0d] = "\x81\x4e",
  [0x6a0f] = "\x81\x55", [0x6a11] = "\x60\xc1", [0x6a13] = "\x60\xbb",
  [0x6a14] = "\x81\x47", [0x6a15] = "\x80\xf7", [0x6a16] = "\x81\x5a",
  [0x6a17] = "\x80\xf4", [0x6a18] = "\x81\x53", [0x6a19] = "\x60\xb8",
  [0x6a1b] = "\x81\x41", [0x6a1d] = "\x81\x42", [0x6a1e] = "\x60\xb7",
  [0x6a1f] = "\x60\xb4", [0x6a20] = "\x80\xfa", [0x6a21] = "\x60\xba",
  [0x6a23] = "\x60\xb3", [0x6a25] = "\x81\x54", [0x6a26] = "\x81\x57",
  [0x6a27] = "\x81\x44", [0x6a28] = "\x84\x75", [0x6a32] = "\x84\x6d",
  [0x6a34] = "\x84\x69", [0x6a35] = "\x62\xa0", [0x6a38] = "\x62\x95",
  [0x6a39] = "\x62\x9a", [0x6a3a] = "\x62\x96", [0x6a3b] = "\x84\x77",
  [0x6a3c] = "\x84\x83", [0x6a3d] = "\x62\x94", [0x6a3e] = "\x84\x6f",
  [0x6a3f] = "\x84\x78", [0x6a40] = "\x81\x4a", [0x6a41] = "\x84\x79",
  [0x6a44] = "\x62\x9b", [0x6a46] = "\x84\x89", [0x6a47] = "\x62\x9f",
  [0x6a48] = "\x62\xa2", [0x6a49] = "\x84\x6b", [0x6a4b] = "\x62\x9e",
  [0x6a4d] = "\x84\x87", [0x6a4e] = "\x84\x88", [0x6a4f] = "\x84\x7d",
  [0x6a50] = "\x84\x7c", [0x6a51] = "\x84\x74", [0x6a54] = "\x84\x7e",
  [0x6a55] = "\x84\x86", [0x6a56] = "\x84\x85", [0x6a58] = "\x62\x99",
  [0x6a59] = "\x62\x97", [0x6a5a] = "\x84\x76", [0x6a5b] = "\x84\x73",
  [0x6a5d] = "\x84\x70", [0x6a5e] = "\x84\x84", [0x6a5f] = "\x62\xa1",
  [0x6a60] = "\x84\x82", [0x6a61] = "\x62\x9d", [0x6a62] = "\x62\x9c",
  [0x6a64] = "\x84\x7b", [0x6a66] = "\x84\x6a", [0x6a67] = "\x84\x6c",
  [0x6a68] = "\x84\x6e", [0x6a69] = "\x84\x81", [0x6a6a] = "\x84\x7a",
  [0x6a6b] = "\x62\x98", [0x6a6d] = "\x84\x71", [0x6a6f] = "\x84\x7f",
  [0x6a76] = "\x84\x72", [0x6a7e] = "\x63\xf7", [0x6a7f] = "\x87\x52",
  [0x6a80] = "\x63\xf0", [0x6a81] = "\x87\x43", [0x6a83] = "\x87\x4e",
  [0x6a84] = "\x63\xf2", [0x6a85] = "\x87\x55", [0x6a87] = "\x87\x4a",
  [0x6a89] = "\x87\x45", [0x6a8c] = "\x87\x56", [0x6a8d] = "\x87\x41",
  [0x6a8e] = "\x87\x4c", [0x6a90] = "\x63\xf9", [0x6a91] = "\x87\x51",
  [0x6a92] = "\x87\x57", [0x6a93] = "\x87\x4b", [0x6a94] = "\x63\xf1",
  [0x6a95] = "\x87\x4d", [0x6a96] = "\x87\x42", [0x6a97] = "\x63\xf8",
  [0x6a9a] = "\x87\x54", [0x6a9b] = "\x87\x47", [0x6a9c] = "\x63\xf4",
  [0x6a9e] = "\x87\x49", [0x6a9f] = "\x87\x46", [0x6aa0] = "\x63\xfa",
  [0x6aa1] = "\x87\x48", [0x6aa2] = "\x63\xf3", [0x6aa3] = "\x63\xf6",
  [0x6aa4] = "\x87\x50", [0x6aa5] = "\x87\x44", [0x6aa6] = "\x87\x53",
  [0x6aa8] = "\x87\x4f", [0x6aac] = "\x65\x6e", [0x6aad] = "\x89\x95",
  [0x6aae] = "\x65\x73", [0x6aaf] = "\x65\x74", [0x6ab3] = "\x65\x6d",
  [0x6ab4] = "\x89\x94", [0x6ab6] = "\x89\x91", [0x6ab7] = "\x89\x92",
  [0x6ab8] = "\x65\x71", [0x6ab9] = "\x89\x8c", [0x6aba] = "\x89\x90",
  [0x6abb] = "\x65\x70", [0x6abd] = "\x89\x8d", [0x6ac2] = "\x65\x72",
  [0x6ac3] = "\x65\x6f", [0x6ac5] = "\x89\x8b", [0x6ac6] = "\x89\x8f",
  [0x6ac7] = "\x89\x93", [0x6acb] = "\x8b\x7f", [0x6acc] = "\x8b\x7c",
  [0x6acd] = "\x8b\x86", [0x6acf] = "\x8b\x85", [0x6ad0] = "\x8b\x83",
  [0x6ad1] = "\x8b\x7d", [0x6ad3] = "\x66\x5e", [0x6ad9] = "\x8b\x7e",
  [0x6ada] = "\x66\x5d", [0x6adb] = "\x63\xf5", [0x6adc] = "\x8b\x82",
  [0x6add] = "\x66\x5c", [0x6ade] = "\x8b\x87", [0x6adf] = "\x8b\x81",
  [0x6ae0] = "\x8b\x7b", [0x6ae1] = "\x89\x8e", [0x6ae5] = "\x66\x5b",
  [0x6ae7] = "\x8b\x7a", [0x6ae8] = "\x8d\x46", [0x6aea] = "\x8d\x45",
  [0x6aeb] = "\x8b\x84", [0x6aec] = "\x66\xf2", [0x6aee] = "\x8d\x49",
  [0x6aef] = "\x8d\x4a", [0x6af0] = "\x8d\x44", [0x6af1] = "\x8d\x48",
  [0x6af3] = "\x8d\x43", [0x6af8] = "\x8e\x81", [0x6af9] = "\x8d\x47",
  [0x6afa] = "\x67\x93", [0x6afb] = "\x67\x91", [0x6afc] = "\x8e\x7e",
  [0x6b00] = "\x8e\x82", [0x6b02] = "\x8e\x7d", [0x6b03] = "\x8e\x7f",
  [0x6b04] = "\x67\x92", [0x6b08] = "\x8f\x75", [0x6b09] = "\x8f\x76",
  [0x6b0a] = "\x67\xe1", [0x6b0b] = "\x8f\x74", [0x6b0f] = "\x90\x53",
  [0x6b10] = "\x68\x5b", [0x6b11] = "\x90\x51", [0x6b12] = "\x90\x52",
  [0x6b13] = "\x90\xbb", [0x6b16] = "\x68\xa2", [0x6b17] = "\x91\x45",
  [0x6b18] = "\x91\x43", [0x6b19] = "\x91\x44", [0x6b1a] = "\x91\x46",
  [0x6b1e] = "\x91\xab", [0x6b20] = "\x4c\xcd", [0x6b21] = "\x4e\x59",
  [0x6b23] = "\x51\x5c", [0x6b25] = "\x6c\x6b", [0x6b28] = "\x6e\x67",
  [0x6b2c] = "\x70\x99", [0x6b2d] = "\x70\x9b", [0x6b2f] = "\x70\x9a",
  [0x6b31] = "\x70\x9c", [0x6b32] = "\x57\xc2", [0x6b33] = "\x73\xbb",
  [0x6b34] = "\x70\x9d", [0x6b36] = "\x73\xba", [0x6b37] = "\x73\xbc",
  [0x6b38] = "\x73\xbd", [0x6b39] = "\x77\x41", [0x6b3a] = "\x5a\x42",
  [0x6b3b] = "\x77\x42", [0x6b3c] = "\x77\x44", [0x6b3d] = "\x5a\x43",
  [0x6b3e] = "\x5a\x41", [0x6b3f] = "\x77\x43", [0x6b41] = "\x7a\xa2",
  [0x6b42] = "\x7a\xa0", [0x6b43] = "\x7a\x9f", [0x6b45] = "\x7a\x9e",
  [0x6b46] = "\x7a\x9d", [0x6b47] = "\x5c\x78", [0x6b48] = "\x7a\xa1",
  [0x6b49] = "\x5e\xb8", [0x6b4a] = "\x7e\x4d", [0x6b4b] = "\x7e\x4f",
  [0x6b4c] = "\x5e\xb9", [0x6b4d] = "\x7e\x4e", [0x6b4e] = "\x60\xc3",
  [0x6b50] = "\x60\xc2", [0x6b51] = "\x81\x5b", [0x6b54] = "\x84\x8b",
  [0x6b55] = "\x84\x8a", [0x6b56] = "\x84\x8c", [0x6b59] = "\x62\xa3",
  [0x6b5b] = "\x87\x58", [0x6b5c] = "\x63\xfb", [0x6b5e] = "\x89\x96",
  [0x6b5f] = "\x65\x75", [0x6b60] = "\x8b\x88", [0x6b61] = "\x67\xe2",
  [0x6b62] = "\x4c\xce", [0x6b63] = "\x4d\x7f", [0x6b64] = "\x4e\x5a",
  [0x6b65] = "\x4f\x84", [0x6b66] = "\x51\x5d", [0x6b67] = "\x51\x5e",
  [0x6b6a] = "\x52\xf0", [0x6b6d] = "\x70\x9e", [0x6b72] = "\x5c\x79",
  [0x6b76] = "\x81\xda", [0x6b77] = "\x62\xa4", [0x6b78] = "\x65\x76",
  [0x6b79] = "\x4c\xcf", [0x6b7b] = "\x4e\x5b", [0x6b7e] = "\x6c\x6d",
  [0x6b7f] = "\x51\x5f", [0x6b80] = "\x6c\x6c", [0x6b82] = "\x6e\x68",
  [0x6b83] = "\x52\xf1", [0x6b84] = "\x6e\x69", [0x6b86] = "\x52\xf2",
  [0x6b88] = "\x70\xa0", [0x6b89] = "\x55\x53", [0x6b8a] = "\x55\x52",
  [0x6b8c] = "\x73\xc2", [0x6b8d] = "\x73\xc0", [0x6b8e] = "\x73\xc1",
  [0x6b8f] = "\x73\xbf", [0x6b91] = "\x73\xbe", [0x6b94] = "\x77\x45",
  [0x6b95] = "\x77\x48", [0x6b96] = "\x5a\x45", [0x6b97] = "\x77\x46",
  [0x6b98] = "\x5a\x44", [0x6b99] = "\x77\x47", [0x6b9b] = "\x7a\xa3",
  [0x6b9e] = "\x7e\x50", [0x6b9f] = "\x7e\x51", [0x6ba0] = "\x7e\x52",
  [0x6ba2] = "\x81\x5e", [0x6ba3] = "\x81\x5d", [0x6ba4] = "\x60\xc4",
  [0x6ba5] = "\x81\x5c", [0x6ba6] = "\x81\x5f", [0x6ba7] = "\x84\x8d",
  [0x6baa] = "\x84\x8e", [0x6bab] = "\x84\x8f", [0x6bad] = "\x87\x59",
  [0x6bae] = "\x63\xfc", [0x6baf] = "\x65\x77", [0x6bb0] = "\x8b\x89",
  [0x6bb2] = "\x67\x94", [0x6bb3] = "\x69\x60", [0x6bb5] = "\x52\xf3",
  [0x6bb6] = "\x6e\x6a", [0x6bb7] = "\x55\x54", [0x6bba] = "\x57\xc3",
  [0x6bbc] = "\x5a\x46", [0x6bbd] = "\x77\x49", [0x6bbf] = "\x5c\x7b",
  [0x6bc0] = "\x5c\x7a", [0x6bc3] = "\x7e\x53", [0x6bc4] = "\x7e\x54",
  [0x6bc5] = "\x60\xc5", [0x6bc6] = "\x60\xc6", [0x6bc7] = "\x84\x91",
  [0x6bc8] = "\x84\x90", [0x6bc9] = "\x89\x97", [0x6bca] = "\x90\x54",
  [0x6bcb] = "\x4c\xd0", [0x6bcc] = "\x69\x61", [0x6bcd] = "\x4d\x81",
  [0x6bcf] = "\x4f\x85", [0x6bd0] = "\x6a\xc8", [0x6bd2] = "\x52\xf4",
  [0x6bd3] = "\x5c\x7c", [0x6bd4] = "\x4c\xd1", [0x6bd6] = "\x6e\x6b",
  [0x6bd7] = "\x52\xf5", [0x6bd8] = "\x6e\x6c", [0x6bda] = "\x63\xfd",
  [0x6bdb] = "\x4c\xd2", [0x6bde] = "\x6c\x6e", [0x6be0] = "\x6e\x6d",
  [0x6be2] = "\x70\xa5", [0x6be3] = "\x70\xa4", [0x6be4] = "\x70\xa2",
  [0x6be6] = "\x70\xa1", [0x6be7] = "\x70\xa6", [0x6be8] = "\x70\xa3",
  [0x6beb] = "\x57\xc4", [0x6bec] = "\x57\xc5", [0x6bef] = "\x5a\x47",
  [0x6bf0] = "\x77\x4a", [0x6bf2] = "\x77\x4b", [0x6bf3] = "\x77\x4c",
  [0x6bf7] = "\x7a\xa8", [0x6bf8] = "\x7a\xa9", [0x6bf9] = "\x7a\xa7",
  [0x6bfb] = "\x7a\xa5", [0x6bfc] = "\x7a\xa6", [0x6bfd] = "\x5c\x7d",
  [0x6bfe] = "\x7e\x55", [0x6bff] = "\x81\x62", [0x6c00] = "\x81\x61",
  [0x6c01] = "\x81\x60", [0x6c02] = "\x81\x63", [0x6c03] = "\x84\x93",
  [0x6c04] = "\x84\x92", [0x6c05] = "\x62\xa5", [0x6c06] = "\x84\x94",
  [0x6c08] = "\x64\x41", [0x6c09] = "\x87\x5a", [0x6c0b] = "\x89\x98",
  [0x6c0c] = "\x8b\x8a", [0x6c0d] = "\x8f\x77", [0x6c0f] = "\x4c\xd3",
  [0x6c10] = "\x4d\x83", [0x6c11] = "\x4d\x82", [0x6c13] = "\x51\x60",
  [0x6c14] = "\x69\x62", [0x6c15] = "\x69\x7f", [0x6c16] = "\x4e\x5c",
  [0x6c18] = "\x69\xd7", [0x6c19] = "\x6a\xc9", [0x6c1a] = "\x6a\xca",
  [0x6c1b] = "\x51\x61", [0x6c1d] = "\x6c\x6f", [0x6c1f] = "\x52\xf6",
  [0x6c20] = "\x6e\x6e", [0x6c21] = "\x6e\x6f", [0x6c23] = "\x55\x55",
  [0x6c24] = "\x55\x59", [0x6c25] = "\x70\xa7", [0x6c26] = "\x55\x58",
  [0x6c27] = "\x55\x56", [0x6c28] = "\x55\x57", [0x6c2a] = "\x73\xc3",
  [0x6c2b] = "\x57\xc6", [0x6c2c] = "\x5a\x4a", [0x6c2e] = "\x5a\x48",
  [0x6c2f] = "\x5a\x49", [0x6c30] = "\x77\x4d", [0x6c33] = "\x5e\xba",
  [0x6c34] = "\x4c\xd4", [0x6c36] = "\x69\x81", [0x6c38] = "\x4d\x84",
  [0x6c3b] = "\x69\x84", [0x6c3e] = "\x4d\x87", [0x6c3f] = "\x69\x83",
  [0x6c40] = "\x4d\x86", [0x6c41] = "\x4d\x85", [0x6c42] = "\x4f\x86",
  [0x6c43] = "\x69\x82", [0x6c46] = "\x69\xd8", [0x6c4a] = "\x69\xdc",
  [0x6c4b] = "\x69\xde", [0x6c4c] = "\x69\xdf", [0x6c4d] = "\x4e\x66",
  [0x6c4e] = "\x4e\x67", [0x6c4f] = "\x69\xdb", [0x6c50] = "\x4e\x62",
  [0x6c52] = "\x69\xd9", [0x6c54] = "\x69\xdd", [0x6c55] = "\x4e\x63",
  [0x6c57] = "\x4e\x5e", [0x6c59] = "\x4e\x5f", [0x6c5b] = "\x4e\x65",
  [0x6c5c] = "\x69\xda", [0x6c5d] = "\x4e\x5d", [0x6c5e] = "\x4f\x87",
  [0x6c5f] = "\x4e\x60", [0x6c60] = "\x4e\x61", [0x6c61] = "\x4e\x64",
  [0x6c65] = "\x6a\xdb", [0x6c66] = "\x6a\xd9", [0x6c67] = "\x6a\xcc",
  [0x6c68] = "\x4f\x93", [0x6c69] = "\x6a\xd3", [0x6c6a] = "\x4f\x8e",
  [0x6c6b] = "\x6a\xcd", [0x6c6d] = "\x6a\xd5", [0x6c6f] = "\x6a\xd2",
  [0x6c70] = "\x4f\x91", [0x6c71] = "\x6a\xd1", [0x6c72] = "\x4f\x98",
  [0x6c73] = "\x6a\xda", [0x6c74] = "\x4f\x9a", [0x6c76] = "\x4f\x9c",
  [0x6c78] = "\x6a\xcb", [0x6c7a] = "\x4f\x8f", [0x6c7b] = "\x6a\xdc",
  [0x6c7d] = "\x4f\x96", [0x6c7e] = "\x4f\x99", [0x6c80] = "\x6c\x87",
  [0x6c81] = "\x4f\x89", [0x6c82] = "\x4f\xa0", [0x6c83] = "\x4f\x97",
  [0x6c84] = "\x6a\xce", [0x6c85] = "\x4f\x8c", [0x6c86] = "\x4f\x9b",
  [0x6c87] = "\x6a\xd6", [0x6c88] = "\x4f\x8a", [0x6c89] = "\x4f\x8b",
  [0x6c8a] = "\x6c\x85", [0x6c8b] = "\x6a\xcf", [0x6c8c] = "\x4f\x92",
  [0x6c8d] = "\x4f\x9d", [0x6c8e] = "\x6a\xdd", [0x6c8f] = "\x6a\xd0",
  [0x6c90] = "\x4f\x90", [0x6c92] = "\x4f\x95", [0x6c93] = "\x6c\x70",
  [0x6c94] = "\x4f\x9e", [0x6c95] = "\x6a\xd7", [0x6c96] = "\x4f\x94",
  [0x6c98] = "\x4f\x9f", [0x6c99] = "\x4f\x88", [0x6c9a] = "\x6a\xd4",
  [0x6c9b] = "\x4f\x8d", [0x6c9c] = "\x6a\xd8", [0x6c9d] = "\x6c\x86",
  [0x6cab] = "\x51\x6d", [0x6cac] = "\x51\x7d", [0x6cad] = "\x6c\x77",
  [0x6cae] = "\x51\x74", [0x6cb0] = "\x6c\x8d", [0x6cb1] = "\x51\x65",
  [0x6cb3] = "\x51\x68", [0x6cb4] = "\x6c\x84", [0x6cb6] = "\x6c\x75",
  [0x6cb7] = "\x6c\x79", [0x6cb8] = "\x51\x70", [0x6cb9] = "\x51\x72",
  [0x6cba] = "\x6c\x7c", [0x6cbb] = "\x51\x79", [0x6cbc] = "\x51\x6b",
  [0x6cbd] = "\x51\x69", [0x6cbe] = "\x51\x6a", [0x6cbf] = "\x51\x78",
  [0x6cc0] = "\x6c\x89", [0x6cc1] = "\x51\x73", [0x6cc2] = "\x6c\x7b",
  [0x6cc3] = "\x6c\x7d", [0x6cc4] = "\x51\x71", [0x6cc5] = "\x51\x76",
  [0x6cc6] = "\x6c\x7e", [0x6cc7] = "\x6c\x8c", [0x6cc9] = "\x52\xf7",
  [0x6cca] = "\x51\x7c", [0x6ccc] = "\x51\x66", [0x6ccd] = "\x6c\x8b",
  [0x6ccf] = "\x6c\x8f", [0x6cd0] = "\x6c\x7a", [0x6cd1] = "\x6c\x91",
  [0x6cd2] = "\x6c\x82", [0x6cd3] = "\x51\x6f", [0x6cd4] = "\x6c\x76",
  [0x6cd5] = "\x51\x6e", [0x6cd6] = "\x51\x81", [0x6cd7] = "\x51\x75",
  [0x6cd9] = "\x6c\x74", [0x6cda] = "\x6e\x78", [0x6cdb] = "\x51\x7b",
  [0x6cdc] = "\x51\x7f", [0x6cdd] = "\x6c\x83", [0x6cde] = "\x6c\x88",
  [0x6ce0] = "\x51\x82", [0x6ce1] = "\x51\x7a", [0x6ce2] = "\x51\x6c",
  [0x6ce3] = "\x51\x62", [0x6ce5] = "\x51\x67", [0x6ce7] = "\x6c\x78",
  [0x6ce8] = "\x51\x63", [0x6ce9] = "\x6c\x90", [0x6ceb] = "\x6c\x72",
  [0x6cec] = "\x6c\x71", [0x6ced] = "\x6c\x7f", [0x6cee] = "\x6c\x73",
  [0x6cef] = "\x51\x7e", [0x6cf0] = "\x55\x5a", [0x6cf1] = "\x51\x77",
  [0x6cf2] = "\x6c\x81", [0x6cf3] = "\x51\x64", [0x6cf5] = "\x53\x49",
  [0x6cf9] = "\x6c\x8e", [0x6d00] = "\x6e\x7f", [0x6d01] = "\x6e\x83",
  [0x6d03] = "\x6e\x86", [0x6d04] = "\x6e\x7a", [0x6d07] = "\x6e\x89",
  [0x6d08] = "\x6e\x8c", [0x6d09] = "\x6e\x8e", [0x6d0a] = "\x6e\x77",
  [0x6d0b] = "\x52\xf8", [0x6d0c] = "\x52\xfd", [0x6d0d] = "\x70\xac",
  [0x6d0e] = "\x53\x50", [0x6d0f] = "\x6e\x87", [0x6d10] = "\x6e\x8f",
  [0x6d11] = "\x6e\x7e", [0x6d12] = "\x6e\x76", [0x6d16] = "\x70\xc7",
  [0x6d17] = "\x53\x43", [0x6d18] = "\x6e\x84", [0x6d19] = "\x6e\x7b",
  [0x6d1a] = "\x6e\x7d", [0x6d1b] = "\x53\x48", [0x6d1d] = "\x6e\x81",
  [0x6d1e] = "\x53\x42", [0x6d1f] = "\x6e\x73", [0x6d20] = "\x6e\x8a",
  [0x6d22] = "\x6e\x8d", [0x6d25] = "\x52\xfc", [0x6d27] = "\x53\x4b",
  [0x6d28] = "\x6e\x70", [0x6d29] = "\x53\x4d", [0x6d2a] = "\x52\xfa",
  [0x6d2b] = "\x53\x51", [0x6d2c] = "\x6e\x8b", [0x6d2d] = "\x6e\x72",
  [0x6d2e] = "\x53\x4e", [0x6d2f] = "\x70\xc1", [0x6d30] = "\x6c\x8a",
  [0x6d31] = "\x53\x41", [0x6d32] = "\x52\xf9", [0x6d33] = "\x6e\x79",
  [0x6d34] = "\x6e\x71", [0x6d35] = "\x53\x4f", [0x6d36] = "\x53\x47",
  [0x6d37] = "\x6e\x85", [0x6d38] = "\x53\x4c", [0x6d39] = "\x53\x4a",
  [0x6d3a] = "\x6e\x7c", [0x6d3b] = "\x53\x44", [0x6d3c] = "\x6e\x74",
  [0x6d3d] = "\x53\x45", [0x6d3e] = "\x53\x46", [0x6d3f] = "\x6e\x75",
  [0x6d40] = "\x6e\x88", [0x6d41] = "\x52\xfb", [0x6d42] = "\x6e\x82",
  [0x6d58] = "\x70\xaf", [0x6d59] = "\x55\x62", [0x6d5a] = "\x55\x67",
  [0x6d5e] = "\x70\xb8", [0x6d5f] = "\x70\xbe", [0x6d60] = "\x70\xba",
  [0x6d61] = "\x70\xad", [0x6d62] = "\x70\xb0", [0x6d63] = "\x70\xa9",
  [0x6d64] = "\x70\xaa", [0x6d65] = "\x55\x6e", [0x6d66] = "\x55\x5f",
  [0x6d67] = "\x70\xb9", [0x6d68] = "\x70\xc2", [0x6d69] = "\x55\x69",
  [0x6d6a] = "\x55\x5b", [0x6d6c] = "\x55\x64", [0x6d6d] = "\x70\xb1",
  [0x6d6e] = "\x55\x66", [0x6d6f] = "\x70\xb2", [0x6d70] = "\x70\xbc",
  [0x6d74] = "\x55\x68", [0x6d75] = "\x70\xcb", [0x6d76] = "\x70\xab",
  [0x6d77] = "\x55\x61", [0x6d78] = "\x55\x60", [0x6d79] = "\x55\x6c",
  [0x6d7a] = "\x70\xa8", [0x6d7b] = "\x70\xc9", [0x6d7c] = "\x70\xbd",
  [0x6d7d] = "\x70\xca", [0x6d7e] = "\x70\xc4", [0x6d7f] = "\x70\xb6",
  [0x6d80] = "\x70\xc5", [0x6d82] = "\x70\xbf", [0x6d83] = "\x70\xc8",
  [0x6d84] = "\x70\xc6", [0x6d85] = "\x55\x6d", [0x6d86] = "\x70\xb7",
  [0x6d87] = "\x55\x5e", [0x6d88] = "\x55\x5d", [0x6d89] = "\x55\x65",
  [0x6d8a] = "\x55\x6b", [0x6d8b] = "\x70\xc3", [0x6d8c] = "\x55\x6a",
  [0x6d8d] = "\x70\xb4", [0x6d8e] = "\x57\xc7", [0x6d90] = "\x70\xcc",
  [0x6d91] = "\x70\xb3", [0x6d92] = "\x70\xae", [0x6d93] = "\x55\x63",
  [0x6d94] = "\x55\x6f", [0x6d95] = "\x55\x5c", [0x6d97] = "\x70\xbb",
  [0x6d98] = "\x70\xc0", [0x6daa] = "\x57\xe9", [0x6dab] = "\x73\xc5",
  [0x6dac] = "\x73\xc9", [0x6dae] = "\x57\xd6", [0x6daf] = "\x57\xd4",
  [0x6db2] = "\x57\xcb", [0x6db3] = "\x73\xc7", [0x6db4] = "\x73\xc6",
  [0x6db5] = "\x57\xdf", [0x6db7] = "\x73\xcc", [0x6db8] = "\x57\xd9",
  [0x6dba] = "\x73\xde", [0x6dbb] = "\x73\xea", [0x6dbc] = "\x57\xc8",
  [0x6dbd] = "\x73\xdb", [0x6dbe] = "\x73\xd4", [0x6dbf] = "\x57\xeb",
  [0x6dc0] = "\x73\xc4", [0x6dc2] = "\x73\xe0", [0x6dc4] = "\x57\xe8",
  [0x6dc5] = "\x57\xdc", [0x6dc6] = "\x57\xe7", [0x6dc7] = "\x57\xd2",
  [0x6dc8] = "\x73\xd0", [0x6dc9] = "\x73\xe2", [0x6dca] = "\x73\xda",
  [0x6dcb] = "\x57\xd3", [0x6dcc] = "\x57\xcd", [0x6dcd] = "\x73\xe8",
  [0x6dcf] = "\x73\xe1", [0x6dd0] = "\x73\xe3", [0x6dd1] = "\x57\xd5",
  [0x6dd2] = "\x57\xdd", [0x6dd3] = "\x73\xe5", [0x6dd4] = "\x73\xce",
  [0x6dd5] = "\x73\xdf", [0x6dd6] = "\x73\xd3", [0x6dd7] = "\x73\xe7",
  [0x6dd8] = "\x57\xe2", [0x6dd9] = "\x57\xca", [0x6dda] = "\x57\xe0",
  [0x6ddb] = "\x73\xd8", [0x6ddc] = "\x73\xd6", [0x6ddd] = "\x73\xd7",
  [0x6dde] = "\x57\xd7", [0x6ddf] = "\x73\xd2", [0x6de0] = "\x73\xd1",
  [0x6de1] = "\x57\xcc", [0x6de2] = "\x73\xcb", [0x6de3] = "\x73\xe9",
  [0x6de4] = "\x57\xce", [0x6de5] = "\x73\xd5", [0x6de6] = "\x57\xec",
  [0x6de8] = "\x57\xe6", [0x6de9] = "\x73\xca", [0x6dea] = "\x57\xe3",
  [0x6deb] = "\x57\xe1", [0x6dec] = "\x57\xea", [0x6ded] = "\x73\xdc",
  [0x6dee] = "\x57\xe5", [0x6def] = "\x70\xb5", [0x6df0] = "\x73\xdd",
  [0x6df1] = "\x57\xe4", [0x6df2] = "\x73\xe4", [0x6df3] = "\x57\xc9",
  [0x6df4] = "\x73\xd9", [0x6df5] = "\x57\xdb", [0x6df6] = "\x73\xcd",
  [0x6df7] = "\x57\xda", [0x6df9] = "\x57\xd8", [0x6dfa] = "\x57\xd0",
  [0x6dfb] = "\x57\xcf", [0x6dfc] = "\x77\x4e", [0x6dfd] = "\x73\xe6",
  [0x6e00] = "\x73\xcf", [0x6e03] = "\x77\x63", [0x6e05] = "\x57\xd1",
  [0x6e19] = "\x5a\x67", [0x6e1a] = "\x57\xde", [0x6e1b] = "\x5a\x55",
  [0x6e1c] = "\x77\x5d", [0x6e1d] = "\x5a\x63", [0x6e1f] = "\x77\x51",
  [0x6e20] = "\x5a\x52", [0x6e21] = "\x5a\x4e", [0x6e22] = "\x77\x6f",
  [0x6e23] = "\x5a\x54", [0x6e24] = "\x5a\x58", [0x6e25] = "\x5a\x53",
  [0x6e26] = "\x5a\x5c", [0x6e27] = "\x77\x73", [0x6e28] = "\x77\x6a",
  [0x6e2b] = "\x77\x58", [0x6e2c] = "\x5a\x61", [0x6e2d] = "\x5a\x5b",
  [0x6e2e] = "\x77\x64", [0x6e2f] = "\x5a\x4b", [0x6e30] = "\x77\x70",
  [0x6e31] = "\x77\x69", [0x6e32] = "\x5a\x4f", [0x6e33] = "\x77\x5e",
  [0x6e34] = "\x5a\x5e", [0x6e35] = "\x77\x7b", [0x6e36] = "\x77\x7c",
  [0x6e38] = "\x5a\x4c", [0x6e39] = "\x77\x6e", [0x6e3a] = "\x5a\x60",
  [0x6e3b] = "\x77\x62", [0x6e3c] = "\x77\x54", [0x6e3d] = "\x77\x55",
  [0x6e3e] = "\x5a\x64", [0x6e3f] = "\x77\x59", [0x6e40] = "\x77\x60",
  [0x6e41] = "\x77\x5a", [0x6e43] = "\x5a\x62", [0x6e44] = "\x5a\x6a",
  [0x6e45] = "\x77\x56", [0x6e46] = "\x77\x4f", [0x6e47] = "\x77\x50",
  [0x6e49] = "\x77\x52", [0x6e4a] = "\x5a\x51", [0x6e4b] = "\x77\x5f",
  [0x6e4d] = "\x5a\x5f", [0x6e4e] = "\x5a\x68", [0x6e51] = "\x77\x61",
  [0x6e52] = "\x77\x79", [0x6e53] = "\x77\x71", [0x6e54] = "\x5a\x4d",
  [0x6e55] = "\x77\x77", [0x6e56] = "\x5a\x59", [0x6e58] = "\x5a\x57",
  [0x6e5a] = "\x77\x7d", [0x6e5b] = "\x5a\x56", [0x6e5c] = "\x77\x67",
  [0x6e5d] = "\x77\x5b", [0x6e5e] = "\x77\x65", [0x6e5f] = "\x5a\x6d",
  [0x6e60] = "\x77\x6b", [0x6e61] = "\x77\x68", [0x6e62] = "\x77\x57",
  [0x6e63] = "\x5a\x69", [0x6e64] = "\x77\x75", [0x6e65] = "\x77\x72",
  [0x6e66] = "\x77\x7a", [0x6e67] = "\x5a\x50", [0x6e68] = "\x77\x66",
  [0x6e69] = "\x5a\x6c", [0x6e6b] = "\x77\x6d", [0x6e6e] = "\x5a\x5a",
  [0x6e6f] = "\x5a\x5d", [0x6e71] = "\x77\x6c", [0x6e72] = "\x5a\x6b",
  [0x6e73] = "\x77\x5c", [0x6e74] = "\x73\xc8", [0x6e77] = "\x77\x76",
  [0x6e78] = "\x77\x74", [0x6e79] = "\x77\x78", [0x6e88] = "\x77\x53",
  [0x6e89] = "\x5a\x66", [0x6e8d] = "\x7a\xc8", [0x6e8e] = "\x7a\xc7",
  [0x6e8f] = "\x7a\xad", [0x6e90] = "\x5c\x84", [0x6e92] = "\x7a\xc6",
  [0x6e93] = "\x7a\xb0", [0x6e94] = "\x7a\xb1", [0x6e96] = "\x5c\x8e",
  [0x6e97] = "\x7a\xcf", [0x6e98] = "\x5c\x89", [0x6e99] = "\x7a\xc5",
  [0x6e9b] = "\x7a\xaa", [0x6e9c] = "\x5c\x8f", [0x6e9d] = "\x5c\x85",
  [0x6e9e] = "\x7a\xb9", [0x6e9f] = "\x7a\xaf", [0x6ea0] = "\x7a\xb2",
  [0x6ea1] = "\x7a\xca", [0x6ea2] = "\x5c\x7e", [0x6ea3] = "\x7a\xd1",
  [0x6ea4] = "\x7a\xc9", [0x6ea5] = "\x5c\x88", [0x6ea6] = "\x7a\xbe",
  [0x6ea7] = "\x5c\x93", [0x6eaa] = "\x5c\x92", [0x6eab] = "\x5c\x8c",
  [0x6eae] = "\x7a\xd0", [0x6eaf] = "\x5c\x7f", [0x6eb0] = "\x7a\xbc",
  [0x6eb1] = "\x7a\xb3", [0x6eb2] = "\x7a\xc0", [0x6eb3] = "\x7a\xcc",
  [0x6eb4] = "\x5c\x94", [0x6eb6] = "\x5c\x82", [0x6eb7] = "\x7a\xbb",
  [0x6eb8] = "\x91\xc7", [0x6eb9] = "\x7a\xb4", [0x6eba] = "\x5c\x8b",
  [0x6ebc] = "\x5c\x8a", [0x6ebd] = "\x7a\xb7", [0x6ebe] = "\x7a\xc1",
  [0x6ebf] = "\x7a\xcb", [0x6ec0] = "\x7a\xae", [0x6ec1] = "\x7a\xb8",
  [0x6ec2] = "\x5c\x83", [0x6ec3] = "\x7a\xc2", [0x6ec4] = "\x5c\x90",
  [0x6ec5] = "\x5c\x87", [0x6ec6] = "\x7a\xb5", [0x6ec7] = "\x5c\x86",
  [0x6ec8] = "\x7a\xac", [0x6ec9] = "\x7a\xba", [0x6eca] = "\x7a\xce",
  [0x6ecb] = "\x5a\x65", [0x6ecc] = "\x5e\xd6", [0x6ecd] = "\x7a\xbd",
  [0x6ece] = "\x7e\x56", [0x6ecf] = "\x7a\xbf", [0x6ed0] = "\x7a\xcd",
  [0x6ed1] = "\x5c\x8d", [0x6ed2] = "\x7a\xb6", [0x6ed3] = "\x5c\x81",
  [0x6ed4] = "\x5c\x91", [0x6ed5] = "\x60\xd8", [0x6ed6] = "\x7a\xab",
  [0x6ed8] = "\x7a\xc4", [0x6edc] = "\x7a\xc3", [0x6eeb] = "\x7e\x72",
  [0x6eec] = "\x5e\xd3", [0x6eed] = "\x7e\x67", [0x6eee] = "\x7e\x6c",
  [0x6eef] = "\x5e\xc8", [0x6ef1] = "\x7e\x58", [0x6ef2] = "\x5e\xd5",
  [0x6ef4] = "\x5e\xbf", [0x6ef5] = "\x7e\x57", [0x6ef6] = "\x7e\x78",
  [0x6ef7] = "\x5e\xd7", [0x6ef8] = "\x7e\x5b", [0x6ef9] = "\x7e\x6b",
  [0x6efb] = "\x7e\x5d", [0x6efc] = "\x7e\x7b", [0x6efd] = "\x7e\x77",
  [0x6efe] = "\x5e\xbd", [0x6eff] = "\x5e\xc7", [0x6f00] = "\x81\x7d",
  [0x6f01] = "\x5e\xd4", [0x6f02] = "\x5e\xc5", [0x6f03] = "\x7e\x59",
  [0x6f05] = "\x7e\x76", [0x6f06] = "\x5e\xc9", [0x6f07] = "\x7e\x73",
  [0x6f08] = "\x7e\x81", [0x6f09] = "\x7e\x5f", [0x6f0a] = "\x7e\x68",
  [0x6f0d] = "\x7e\x7e", [0x6f0e] = "\x7e\x74", [0x6f0f] = "\x5e\xc4",
  [0x6f12] = "\x7e\x66", [0x6f13] = "\x5e\xbe", [0x6f14] = "\x5e\xbc",
  [0x6f15] = "\x5e\xce", [0x6f18] = "\x7e\x64", [0x6f19] = "\x7e\x61",
  [0x6f1a] = "\x7e\x62", [0x6f1c] = "\x7e\x7a", [0x6f1e] = "\x7e\x7f",
  [0x6f1f] = "\x7e\x7d", [0x6f20] = "\x5e\xc2", [0x6f21] = "\x7e\x82",
  [0x6f22] = "\x5e\xc6", [0x6f23] = "\x5e\xcd", [0x6f25] = "\x7e\x5a",
  [0x6f26] = "\x81\x65", [0x6f27] = "\x7e\x63", [0x6f29] = "\x5e\xc0",
  [0x6f2a] = "\x5e\xd2", [0x6f2b] = "\x5e\xcf", [0x6f2c] = "\x5e\xc3",
  [0x6f2d] = "\x7e\x6d", [0x6f2e] = "\x7e\x5e", [0x6f2f] = "\x5e\xd0",
  [0x6f30] = "\x7e\x6f", [0x6f31] = "\x5e\xca", [0x6f32] = "\x5e\xcc",
  [0x6f33] = "\x5e\xbb", [0x6f35] = "\x7e\x71", [0x6f36] = "\x7e\x69",
  [0x6f37] = "\x7e\x5c", [0x6f38] = "\x5e\xcb", [0x6f39] = "\x7e\x79",
  [0x6f3a] = "\x7e\x7c", [0x6f3b] = "\x7e\x65", [0x6f3c] = "\x7e\x70",
  [0x6f3e] = "\x5e\xc1", [0x6f3f] = "\x60\xc7", [0x6f40] = "\x7e\x6e",
  [0x6f41] = "\x81\x64", [0x6f43] = "\x7e\x75", [0x6f4e] = "\x7e\x60",
  [0x6f4f] = "\x81\x6e", [0x6f50] = "\x81\x78", [0x6f51] = "\x60\xca",
  [0x6f52] = "\x81\x77", [0x6f53] = "\x81\x84", [0x6f54] = "\x60\xcc",
  [0x6f55] = "\x81\x75", [0x6f57] = "\x81\x79", [0x6f58] = "\x60\xd7",
  [0x6f5a] = "\x81\x70", [0x6f5b] = "\x60\xcf", [0x6f5d] = "\x81\x7c",
  [0x6f5e] = "\x84\x9c", [0x6f5f] = "\x60\xdb", [0x6f60] = "\x60\xda",
  [0x6f61] = "\x81\x7e", [0x6f62] = "\x81\x6d", [0x6f63] = "\x81\x89",
  [0x6f64] = "\x60\xd5", [0x6f66] = "\x60\xcb", [0x6f67] = "\x81\x82",
  [0x6f69] = "\x81\x86", [0x6f6a] = "\x81\x8b", [0x6f6b] = "\x81\x7f",
  [0x6f6c] = "\x81\x73", [0x6f6d] = "\x60\xce", [0x6f6e] = "\x60\xd1",
  [0x6f6f] = "\x60\xd9", [0x6f70] = "\x60\xd4", [0x6f72] = "\x81\x76",
  [0x6f73] = "\x7e\x6a", [0x6f76] = "\x81\x72", [0x6f77] = "\x81\x8a",
  [0x6f78] = "\x60\xd0", [0x6f7a] = "\x60\xd3", [0x6f7b] = "\x81\x8c",
  [0x6f7c] = "\x60\xc8", [0x6f7d] = "\x81\x81", [0x6f7e] = "\x81\x66",
  [0x6f7f] = "\x81\x87", [0x6f80] = "\x64\x4a", [0x6f82] = "\x81\x74",
  [0x6f84] = "\x60\xc9", [0x6f85] = "\x81\x6f", [0x6f86] = "\x60\xcd",
  [0x6f87] = "\x81\x67", [0x6f88] = "\x5e\xd1", [0x6f89] = "\x81\x6b",
  [0x6f8b] = "\x81\x85", [0x6f8c] = "\x81\x6c", [0x6f8d] = "\x81\x6a",
  [0x6f8e] = "\x60\xd2", [0x6f90] = "\x81\x83", [0x6f92] = "\x81\x69",
  [0x6f93] = "\x81\x7b", [0x6f94] = "\x81\x7a", [0x6f95] = "\x81\x88",
  [0x6f96] = "\x81\x71", [0x6f97] = "\x60\xd6", [0x6f9e] = "\x84\x9f",
  [0x6fa0] = "\x62\xb2", [0x6fa1] = "\x62\xa8", [0x6fa2] = "\x84\xab",
  [0x6fa3] = "\x84\x97", [0x6fa4] = "\x62\xaa", [0x6fa5] = "\x84\xa3",
  [0x6fa6] = "\x62\xb1", [0x6fa7] = "\x62\xac", [0x6fa8] = "\x84\xa1",
  [0x6fa9] = "\x87\x5c", [0x6faa] = "\x84\xa7", [0x6fab] = "\x84\xad",
  [0x6fac] = "\x84\xa6", [0x6fad] = "\x84\x95", [0x6fae] = "\x84\xa4",
  [0x6faf] = "\x84\xaf", [0x6fb0] = "\x84\xb1", [0x6fb1] = "\x62\xa7",
  [0x6fb2] = "\x84\xb0", [0x6fb3] = "\x62\xad", [0x6fb4] = "\x62\xb3",
  [0x6fb6] = "\x62\xb0", [0x6fb8] = "\x84\xaa", [0x6fb9] = "\x62\xaf",
  [0x6fba] = "\x84\xa5", [0x6fbc] = "\x84\x99", [0x6fbd] = "\x84\x9e",
  [0x6fbf] = "\x84\xa9", [0x6fc0] = "\x62\xae", [0x6fc1] = "\x62\xab",
  [0x6fc2] = "\x62\xa6", [0x6fc3] = "\x62\xa9", [0x6fc4] = "\x84\x9d",
  [0x6fc6] = "\x81\x68", [0x6fc7] = "\x84\x98", [0x6fc8] = "\x84\x9b",
  [0x6fc9] = "\x84\xac", [0x6fca] = "\x84\xa0", [0x6fcb] = "\x84\x96",
  [0x6fcc] = "\x87\x5b", [0x6fcd] = "\x84\xae", [0x6fce] = "\x84\x9a",
  [0x6fcf] = "\x84\xa8", [0x6fd4] = "\x87\x5e", [0x6fd5] = "\x64\x4e",
  [0x6fd8] = "\x64\x42", [0x6fdb] = "\x64\x46", [0x6fdc] = "\x87\x60",
  [0x6fdd] = "\x87\x66", [0x6fde] = "\x87\x64", [0x6fdf] = "\x64\x44",
  [0x6fe0] = "\x64\x45", [0x6fe1] = "\x64\x4c", [0x6fe2] = "\x87\x67",
  [0x6fe3] = "\x87\x5f", [0x6fe4] = "\x64\x47", [0x6fe6] = "\x87\x63",
  [0x6fe7] = "\x87\x62", [0x6fe8] = "\x87\x68", [0x6fe9] = "\x64\x4d",
  [0x6feb] = "\x64\x48", [0x6fec] = "\x64\x4b", [0x6fed] = "\x87\x61",
  [0x6fee] = "\x64\x4f", [0x6fef] = "\x64\x49", [0x6ff0] = "\x64\x50",
  [0x6ff1] = "\x64\x43", [0x6ff2] = "\x87\x65", [0x6ff4] = "\x87\x5d",
  [0x6ff7] = "\x89\xa5", [0x6ffa] = "\x65\x7c", [0x6ffb] = "\x89\xa2",
  [0x6ffc] = "\x89\xa4", [0x6ffe] = "\x65\x7a", [0x6fff] = "\x89\xa0",
  [0x7000] = "\x89\xa1", [0x7001] = "\x89\x9c", [0x7004] = "\x84\xa2",
  [0x7005] = "\x89\x9d", [0x7006] = "\x65\x7b", [0x7007] = "\x89\x99",
  [0x7009] = "\x65\x78", [0x700a] = "\x89\xa6", [0x700b] = "\x65\x79",
  [0x700c] = "\x89\x9a", [0x700d] = "\x89\x9b", [0x700e] = "\x89\x9f",
  [0x700f] = "\x65\x7e", [0x7011] = "\x65\x7d", [0x7014] = "\x89\x9e",
  [0x7015] = "\x66\x64", [0x7016] = "\x8b\x8e", [0x7017] = "\x8b\x94",
  [0x7018] = "\x66\x65", [0x7019] = "\x8b\x8b", [0x701a] = "\x66\x62",
  [0x701b] = "\x66\x5f", [0x701c] = "\x8b\x96", [0x701d] = "\x66\x63",
  [0x701f] = "\x66\x60", [0x7020] = "\x8b\x8d", [0x7021] = "\x8b\x90",
  [0x7022] = "\x8b\x91", [0x7023] = "\x8b\x92", [0x7024] = "\x8b\x95",
  [0x7026] = "\x89\xa3", [0x7027] = "\x8b\x8c", [0x7028] = "\x66\x61",
  [0x7029] = "\x8b\x93", [0x702a] = "\x8b\x97", [0x702b] = "\x8b\x8f",
  [0x702f] = "\x8d\x4d", [0x7030] = "\x66\xf4", [0x7031] = "\x8d\x50",
  [0x7032] = "\x66\xf5", [0x7033] = "\x8d\x58", [0x7034] = "\x8d\x4f",
  [0x7035] = "\x8d\x4c", [0x7037] = "\x8d\x4e", [0x7038] = "\x8d\x52",
  [0x7039] = "\x8d\x55", [0x703a] = "\x8d\x54", [0x703b] = "\x8d\x57",
  [0x703c] = "\x8d\x4b", [0x703e] = "\x66\xf3", [0x703f] = "\x8d\x53",
  [0x7040] = "\x8d\x56", [0x7041] = "\x8d\x59", [0x7042] = "\x8d\x51",
  [0x7043] = "\x8e\x83", [0x7044] = "\x8e\x84", [0x7045] = "\x8e\x88",
  [0x7046] = "\x8e\x89", [0x7048] = "\x8e\x86", [0x7049] = "\x8e\x87",
  [0x704a] = "\x8e\x85", [0x704c] = "\x67\x95", [0x7051] = "\x67\xe3",
  [0x7052] = "\x8f\x7b", [0x7055] = "\x8f\x78", [0x7056] = "\x8f\x79",
  [0x7057] = "\x8f\x7a", [0x7058] = "\x67\xe4", [0x705a] = "\x90\x56",
  [0x705b] = "\x90\x55", [0x705d] = "\x90\xbe", [0x705e] = "\x68\x81",
  [0x705f] = "\x90\xbc", [0x7060] = "\x90\xbf", [0x7061] = "\x90\xbd",
  [0x7062] = "\x91\x47", [0x7063] = "\x68\xa3", [0x7064] = "\x68\xb1",
  [0x7065] = "\x91\x93", [0x7066] = "\x91\x7d", [0x7068] = "\x91\x92",
  [0x7069] = "\x91\xc0", [0x706a] = "\x91\xc1", [0x706b] = "\x4c\xd5",
  [0x7070] = "\x4e\x68", [0x7071] = "\x69\xe0", [0x7074] = "\x6a\xde",
  [0x7076] = "\x4f\xa1", [0x7078] = "\x4f\xa4", [0x707a] = "\x6a\xdf",
  [0x707c] = "\x4f\xa2", [0x707d] = "\x4f\xa3", [0x7082] = "\x6c\x9a",
  [0x7083] = "\x6c\x9c", [0x7084] = "\x6c\x97", [0x7085] = "\x6c\x94",
  [0x7086] = "\x6c\x96", [0x708a] = "\x51\x86", [0x708e] = "\x51\x84",
  [0x7091] = "\x6c\x98", [0x7092] = "\x51\x85", [0x7093] = "\x6c\x95",
  [0x7094] = "\x6c\x92", [0x7095] = "\x51\x83", [0x7096] = "\x6c\x99",
  [0x7098] = "\x6c\x93", [0x7099] = "\x51\x87", [0x709a] = "\x6c\x9b",
  [0x709f] = "\x6e\x91", [0x70a1] = "\x6e\x95", [0x70a4] = "\x53\x5a",
  [0x70a9] = "\x6e\x98", [0x70ab] = "\x53\x52", [0x70ac] = "\x53\x55",
  [0x70ad] = "\x53\x57", [0x70ae] = "\x53\x59", [0x70af] = "\x53\x56",
  [0x70b0] = "\x6e\x94", [0x70b1] = "\x6e\x93", [0x70b3] = "\x53\x54",
  [0x70b4] = "\x6e\x96", [0x70b5] = "\x6e\x97", [0x70b7] = "\x6e\x90",
  [0x70b8] = "\x53\x58", [0x70ba] = "\x53\x53", [0x70be] = "\x6e\x92",
  [0x70c5] = "\x70\xda", [0x70c6] = "\x70\xdb", [0x70c7] = "\x70\xdc",
  [0x70c8] = "\x55\x74", [0x70ca] = "\x55\x70", [0x70cb] = "\x70\xd1",
  [0x70cd] = "\x70\xd9", [0x70ce] = "\x70\xde", [0x70cf] = "\x55\x75",
  [0x70d1] = "\x70\xcf", [0x70d2] = "\x70\xd5", [0x70d3] = "\x70\xce",
  [0x70d4] = "\x70\xd8", [0x70d7] = "\x70\xd4", [0x70d8] = "\x55\x71",
  [0x70d9] = "\x55\x73", [0x70da] = "\x70\xdd", [0x70dc] = "\x70\xcd",
  [0x70dd] = "\x70\xd0", [0x70de] = "\x70\xd6", [0x70e0] = "\x70\xd7",
  [0x70e1] = "\x70\xdf", [0x70e2] = "\x70\xd3", [0x70e4] = "\x55\x72",
  [0x70ef] = "\x57\xf1", [0x70f0] = "\x73\xf1", [0x70f3] = "\x73\xf3",
  [0x70f4] = "\x73\xef", [0x70f6] = "\x73\xfb", [0x70f7] = "\x73\xed",
  [0x70f8] = "\x73\xfa", [0x70f9] = "\x57\xed", [0x70fa] = "\x73\xeb",
  [0x70fb] = "\x77\x82", [0x70fc] = "\x73\xf5", [0x70fd] = "\x57\xf0",
  [0x70ff] = "\x73\xf6", [0x7100] = "\x73\xf9", [0x7102] = "\x73\xfd",
  [0x7104] = "\x73\xf2", [0x7106] = "\x73\xf7", [0x7109] = "\x57\xee",
  [0x710a] = "\x57\xef", [0x710b] = "\x73\xfc", [0x710c] = "\x73\xf0",
  [0x710d] = "\x73\xec", [0x710e] = "\x74\x41", [0x7110] = "\x73\xf4",
  [0x7113] = "\x73\xf8", [0x7117] = "\x73\xee", [0x7119] = "\x5a\x6e",
  [0x711a] = "\x5a\x6f", [0x711b] = "\x77\x8c", [0x711c] = "\x5a\x75",
  [0x711e] = "\x77\x7f", [0x711f] = "\x77\x89", [0x7120] = "\x77\x7e",
  [0x7121] = "\x5a\x72", [0x7122] = "\x77\x87", [0x7123] = "\x77\x85",
  [0x7125] = "\x77\x86", [0x7126] = "\x5a\x70", [0x7128] = "\x77\x8a",
  [0x712e] = "\x77\x83", [0x712f] = "\x77\x81", [0x7130] = "\x5a\x71",
  [0x7131] = "\x77\x84", [0x7132] = "\x77\x88", [0x7136] = "\x5a\x73",
  [0x713a] = "\x77\x8b", [0x7141] = "\x7a\xd7", [0x7142] = "\x7a\xde",
  [0x7143] = "\x7a\xe0", [0x7144] = "\x7a\xe6", [0x7146] = "\x5c\xa1",
  [0x7147] = "\x7a\xd2", [0x7149] = "\x5c\x99", [0x714b] = "\x7a\xe1",
  [0x714c] = "\x5c\x9e", [0x714d] = "\x7a\xe7", [0x714e] = "\x5c\x95",
  [0x7150] = "\x7a\xe4", [0x7152] = "\x7a\xd4", [0x7153] = "\x7a\xe5",
  [0x7154] = "\x7a\xd3", [0x7156] = "\x5c\xa3", [0x7158] = "\x7a\xdf",
  [0x7159] = "\x5c\x96", [0x715a] = "\x7a\xe8", [0x715c] = "\x5c\x9b",
  [0x715d] = "\x7a\xd8", [0x715e] = "\x5c\xa0", [0x715f] = "\x7a\xe3",
  [0x7160] = "\x7a\xd6", [0x7161] = "\x7a\xdd", [0x7162] = "\x7a\xd9",
  [0x7163] = "\x7a\xd5", [0x7164] = "\x5c\x98", [0x7165] = "\x5c\x9f",
  [0x7166] = "\x5c\x9d", [0x7167] = "\x5c\x9a", [0x7168] = "\x5c\xa2",
  [0x7169] = "\x5c\x97", [0x716a] = "\x7a\xdc", [0x716c] = "\x5c\x9c",
  [0x716e] = "\x5a\x74", [0x7170] = "\x7a\xe2", [0x7172] = "\x7a\xda",
  [0x7178] = "\x7a\xdb", [0x717b] = "\x7e\x8a", [0x717d] = "\x5e\xda",
  [0x7180] = "\x7e\x86", [0x7181] = "\x7e\x8c", [0x7182] = "\x7e\x88",
  [0x7184] = "\x5e\xdc", [0x7185] = "\x7e\x87", [0x7186] = "\x7e\x8b",
  [0x7187] = "\x7e\x83", [0x7189] = "\x7e\x85", [0x718a] = "\x5e\xdb",
  [0x718f] = "\x7e\x89", [0x7190] = "\x7e\x84", [0x7192] = "\x5e\xdd",
  [0x7194] = "\x5e\xd8", [0x7197] = "\x7e\x8d", [0x7199] = "\x5e\xd9",
  [0x719a] = "\x81\x92", [0x719b] = "\x81\x8f", [0x719c] = "\x81\x9b",
  [0x719d] = "\x81\x95", [0x719e] = "\x81\x97", [0x719f] = "\x60\xdc",
  [0x71a0] = "\x81\x91", [0x71a1] = "\x81\x99", [0x71a4] = "\x81\x98",
  [0x71a5] = "\x81\x96", [0x71a7] = "\x81\x9c", [0x71a8] = "\x60\xdf",
  [0x71a9] = "\x81\x93", [0x71aa] = "\x81\x9a", [0x71ac] = "\x60\xdd",
  [0x71af] = "\x81\x8e", [0x71b0] = "\x81\x90", [0x71b1] = "\x60\xde",
  [0x71b2] = "\x81\x8d", [0x71b3] = "\x81\x9d", [0x71b5] = "\x81\x94",
  [0x71b8] = "\x84\xb5", [0x71b9] = "\x62\xba", [0x71bc] = "\x84\xc0",
  [0x71bd] = "\x84\xbe", [0x71be] = "\x62\xb4", [0x71bf] = "\x84\xb4",
  [0x71c0] = "\x84\xb7", [0x71c1] = "\x84\xb8", [0x71c2] = "\x84\xb3",
  [0x71c3] = "\x62\xbe", [0x71c4] = "\x62\xbf", [0x71c5] = "\x84\xb2",
  [0x71c6] = "\x84\xc1", [0x71c7] = "\x84\xbc", [0x71c8] = "\x62\xb8",
  [0x71c9] = "\x62\xb5", [0x71ca] = "\x84\xbb", [0x71cb] = "\x84\xb9",
  [0x71ce] = "\x62\xbb", [0x71cf] = "\x84\xbd", [0x71d0] = "\x62\xb6",
  [0x71d2] = "\x62\xb7", [0x71d4] = "\x84\xba", [0x71d5] = "\x62\xb9",
  [0x71d6] = "\x84\xb6", [0x71d8] = "\x84\xbf", [0x71d9] = "\x62\xbc",
  [0x71da] = "\x84\xc2", [0x71db] = "\x84\xc3", [0x71dc] = "\x62\xbd",
  [0x71df] = "\x64\x52", [0x71e0] = "\x64\x59", [0x71e1] = "\x87\x69",
  [0x71e2] = "\x87\x6f", [0x71e4] = "\x87\x6d", [0x71e5] = "\x64\x55",
  [0x71e6] = "\x64\x54", [0x71e7] = "\x64\x51", [0x71e8] = "\x87\x6b",
  [0x71ec] = "\x64\x57", [0x71ed] = "\x64\x56", [0x71ee] = "\x64\x53",
  [0x71f0] = "\x87\x6e", [0x71f1] = "\x87\x6a", [0x71f2] = "\x87\x6c",
  [0x71f4] = "\x64\x58", [0x71f8] = "\x65\x83", [0x71f9] = "\x89\xa9",
  [0x71fb] = "\x65\x7f", [0x71fc] = "\x65\x81", [0x71fd] = "\x89\xab",
  [0x71fe] = "\x65\x82", [0x71ff] = "\x89\xa8", [0x7201] = "\x89\xa7",
  [0x7202] = "\x8b\x9b", [0x7203] = "\x89\xaa", [0x7205] = "\x8b\x9c",
  [0x7206] = "\x66\x66", [0x7207] = "\x8b\x9a", [0x720a] = "\x8b\x99",
  [0x720c] = "\x8b\x98", [0x720d] = "\x66\x67", [0x7210] = "\x66\xf6",
  [0x7213] = "\x8d\x5a", [0x7214] = "\x8d\x5b", [0x7219] = "\x8e\x8c",
  [0x721a] = "\x8e\x8b", [0x721b] = "\x67\x96", [0x721d] = "\x8e\x8a",
  [0x721e] = "\x8f\x7c", [0x721f] = "\x8f\x7d", [0x7222] = "\x90\x57",
  [0x7223] = "\x90\xc0", [0x7226] = "\x91\x48", [0x7227] = "\x91\xac",
  [0x7228] = "\x68\xc5", [0x7229] = "\x91\xb6", [0x722a] = "\x4c\xd6",
  [0x722c] = "\x51\x88", [0x722d] = "\x51\x89", [0x7230] = "\x53\x5b",
  [0x7235] = "\x64\x5a", [0x7236] = "\x4c\xd7", [0x7238] = "\x51\x8a",
  [0x7239] = "\x55\x76", [0x723a] = "\x5c\xa4", [0x723b] = "\x4c\xd8",
  [0x723d] = "\x57\xf2", [0x723e] = "\x5e\xde", [0x723f] = "\x69\x63",
  [0x7241] = "\x6e\x99", [0x7242] = "\x70\xe0", [0x7244] = "\x7e\x8e",
  [0x7246] = "\x64\x5b", [0x7247] = "\x4c\xd9", [0x7248] = "\x51\x8b",
  [0x7249] = "\x6e\x9a", [0x724a] = "\x6e\x9b", [0x724b] = "\x77\x8d",
  [0x724c] = "\x5a\x76", [0x724f] = "\x7a\xe9", [0x7252] = "\x5c\xa5",
  [0x7253] = "\x7e\x8f", [0x7256] = "\x60\xe0", [0x7258] = "\x66\x68",
  [0x7259] = "\x4c\xda", [0x725a] = "\x77\x8e", [0x725b] = "\x4c\xdb",
  [0x725d] = "\x4e\x6a", [0x725e] = "\x69\xe1", [0x725f] = "\x4e\x69",
  [0x7260] = "\x4f\xa7", [0x7261] = "\x4f\xa6", [0x7262] = "\x4f\xa5",
  [0x7263] = "\x6a\xe0", [0x7267] = "\x51\x8c", [0x7269] = "\x51\x8d",
  [0x726a] = "\x6c\x9d", [0x726c] = "\x6e\x9c", [0x726e] = "\x6e\x9f",
  [0x726f] = "\x53\x5d", [0x7270] = "\x6e\x9d", [0x7272] = "\x53\x5c",
  [0x7273] = "\x6e\x9e", [0x7274] = "\x53\x5e", [0x7276] = "\x70\xe3",
  [0x7277] = "\x70\xe2", [0x7278] = "\x70\xe1", [0x7279] = "\x55\x77",
  [0x727b] = "\x74\x43", [0x727c] = "\x74\x44", [0x727d] = "\x57\xf3",
  [0x727e] = "\x74\x42", [0x727f] = "\x74\x45", [0x7280] = "\x5a\x78",
  [0x7281] = "\x57\xf4", [0x7284] = "\x5a\x77", [0x7285] = "\x77\x92",
  [0x7286] = "\x77\x91", [0x7288] = "\x77\x8f", [0x7289] = "\x77\x90",
  [0x728b] = "\x77\x93", [0x728c] = "\x7a\xeb", [0x728d] = "\x7a\xea",
  [0x728e] = "\x7a\xee", [0x7290] = "\x7a\xed", [0x7291] = "\x7a\xec",
  [0x7292] = "\x5e\xdf", [0x7293] = "\x7e\x92", [0x7295] = "\x7e\x91",
  [0x7296] = "\x5e\xe0", [0x7297] = "\x7e\x90", [0x7298] = "\x81\x9e",
  [0x729a] = "\x81\x9f", [0x729b] = "\x60\xe1", [0x729d] = "\x84\xc4",
  [0x729e] = "\x84\xc5", [0x72a1] = "\x8b\xa1", [0x72a2] = "\x66\x69",
  [0x72a3] = "\x8b\xa0", [0x72a4] = "\x8b\x9f", [0x72a5] = "\x8b\x9d",
  [0x72a6] = "\x8b\x9e", [0x72a7] = "\x67\x97", [0x72a8] = "\x8d\x5c",
  [0x72a9] = "\x8f\x7e", [0x72aa] = "\x91\x49", [0x72ac] = "\x4c\xdc",
  [0x72ae] = "\x69\x85", [0x72af] = "\x4d\x88", [0x72b0] = "\x69\x86",
  [0x72b4] = "\x69\xe2", [0x72b5] = "\x69\xe3", [0x72ba] = "\x6a\xe6",
  [0x72bd] = "\x6a\xe2", [0x72bf] = "\x6a\xe1", [0x72c0] = "\x51\x8e",
  [0x72c1] = "\x6a\xe5", [0x72c2] = "\x4f\xa9", [0x72c3] = "\x6a\xe3",
  [0x72c4] = "\x4f\xa8", [0x72c5] = "\x6a\xe7", [0x72c6] = "\x6a\xe4",
  [0x72c9] = "\x6c\xa1", [0x72ca] = "\x6e\xa0", [0x72cb] = "\x6c\x9f",
  [0x72cc] = "\x6c\xa6", [0x72ce] = "\x51\x8f", [0x72d0] = "\x51\x92",
  [0x72d1] = "\x6c\xa7", [0x72d2] = "\x6c\xa3", [0x72d4] = "\x6c\xa4",
  [0x72d6] = "\x6c\x9e", [0x72d7] = "\x51\x91", [0x72d8] = "\x6c\xa0",
  [0x72d9] = "\x51\x90", [0x72da] = "\x6c\xa5", [0x72dc] = "\x6c\xa2",
  [0x72df] = "\x6e\xa4", [0x72e0] = "\x53\x60", [0x72e1] = "\x53\x61",
  [0x72e3] = "\x6e\xa7", [0x72e4] = "\x6e\xa1", [0x72e6] = "\x6e\xa6",
  [0x72e8] = "\x6e\xa2", [0x72e9] = "\x53\x5f", [0x72ea] = "\x6e\xa5",
  [0x72eb] = "\x6e\xa3", [0x72f3] = "\x70\xe9", [0x72f4] = "\x70\xe6",
  [0x72f6] = "\x70\xe8", [0x72f7] = "\x55\x7c", [0x72f8] = "\x55\x7b",
  [0x72f9] = "\x55\x79", [0x72fa] = "\x70\xe5", [0x72fb] = "\x70\xea",
  [0x72fc] = "\x55\x78", [0x72fd] = "\x55\x7a", [0x72fe] = "\x70\xe7",
  [0x72ff] = "\x74\x4d", [0x7300] = "\x70\xe4", [0x7301] = "\x70\xeb",
  [0x7307] = "\x74\x48", [0x7308] = "\x74\x4c", [0x730a] = "\x74\x4b",
  [0x730b] = "\x77\x95", [0x730c] = "\x77\xa0", [0x730f] = "\x74\x4e",
  [0x7311] = "\x74\x49", [0x7312] = "\x77\x94", [0x7313] = "\x57\xf8",
  [0x7316] = "\x57\xf7", [0x7317] = "\x74\x47", [0x7318] = "\x74\x4a",
  [0x7319] = "\x57\xf9", [0x731b] = "\x57\xf6", [0x731c] = "\x57\xf5",
  [0x731d] = "\x74\x46", [0x731e] = "\x74\x4f", [0x7322] = "\x77\x97",
  [0x7323] = "\x77\x9e", [0x7325] = "\x5a\x7a", [0x7326] = "\x77\x9d",
  [0x7327] = "\x77\x9a", [0x7329] = "\x5a\x7c", [0x732d] = "\x77\x9c",
  [0x7330] = "\x77\x96", [0x7331] = "\x77\x98", [0x7332] = "\x77\x9b",
  [0x7333] = "\x77\x99", [0x7334] = "\x5a\x7b", [0x7335] = "\x77\x9f",
  [0x7336] = "\x5a\x79", [0x7337] = "\x5c\xa6", [0x733a] = "\x7a\xf2",
  [0x733b] = "\x7a\xf1", [0x733c] = "\x7a\xef", [0x733e] = "\x5c\xa9",
  [0x733f] = "\x5c\xa8", [0x7340] = "\x7a\xf3", [0x7342] = "\x7a\xf0",
  [0x7343] = "\x7e\x93", [0x7344] = "\x5e\xe1", [0x7345] = "\x5c\xa7",
  [0x7349] = "\x7a\xf5", [0x734a] = "\x7a\xf4", [0x734c] = "\x7e\x96",
  [0x734d] = "\x7e\x94", [0x734e] = "\x60\xe2", [0x7350] = "\x5e\xe2",
  [0x7351] = "\x7e\x95", [0x7352] = "\x81\xa1", [0x7357] = "\x60\xe3",
  [0x7358] = "\x81\xa0", [0x7359] = "\x81\xa9", [0x735a] = "\x81\xa8",
  [0x735b] = "\x81\xa6", [0x735d] = "\x81\xa5", [0x735e] = "\x81\xa2",
  [0x735f] = "\x81\xa3", [0x7360] = "\x81\xa4", [0x7361] = "\x81\xa7",
  [0x7362] = "\x81\xaa", [0x7365] = "\x84\xca", [0x7366] = "\x84\xc7",
  [0x7367] = "\x84\xc8", [0x7368] = "\x62\xc0", [0x7369] = "\x84\xc6",
  [0x736a] = "\x84\xcc", [0x736b] = "\x84\xcb", [0x736c] = "\x84\xc9",
  [0x736e] = "\x87\x71", [0x736f] = "\x87\x72", [0x7370] = "\x64\x5c",
  [0x7372] = "\x64\x5d", [0x7373] = "\x87\x70", [0x7375] = "\x65\x85",
  [0x7376] = "\x89\xac", [0x7377] = "\x65\x84", [0x7378] = "\x66\x6a",
  [0x737a] = "\x66\x6b", [0x737b] = "\x66\xf7", [0x737c] = "\x8d\x5e",
  [0x737d] = "\x8d\x5d", [0x737e] = "\x8e\x8d", [0x737f] = "\x8f\x7f",
  [0x7380] = "\x67\xe5", [0x7381] = "\x90\x59", [0x7382] = "\x90\x58",
  [0x7383] = "\x90\x5a", [0x7384] = "\x4d\x89", [0x7385] = "\x6e\xa8",
  [0x7386] = "\x55\x7d", [0x7387] = "\x57\xfa", [0x7388] = "\x74\x50",
  [0x7389] = "\x4d\x8a", [0x738a] = "\x69\x87", [0x738b] = "\x4c\xdd",
  [0x738e] = "\x69\xe4", [0x7392] = "\x6a\xec", [0x7393] = "\x6a\xea",
  [0x7394] = "\x6a\xeb", [0x7395] = "\x6a\xe8", [0x7396] = "\x4f\xaa",
  [0x7397] = "\x6a\xe9", [0x739d] = "\x6c\xaf", [0x739f] = "\x51\x95",
  [0x73a0] = "\x6c\xad", [0x73a1] = "\x6c\xa9", [0x73a2] = "\x6c\xac",
  [0x73a4] = "\x6c\xa8", [0x73a5] = "\x51\x97", [0x73a6] = "\x6c\xab",
  [0x73a8] = "\x51\x94", [0x73a9] = "\x51\x93", [0x73ab] = "\x51\x96",
  [0x73ac] = "\x6c\xae", [0x73ad] = "\x6c\xaa", [0x73b2] = "\x53\x65",
  [0x73b3] = "\x53\x68", [0x73b4] = "\x6e\xb0", [0x73b5] = "\x6e\xaf",
  [0x73b6] = "\x6e\xae", [0x73b7] = "\x53\x62", [0x73b8] = "\x6e\xb7",
  [0x73b9] = "\x6e\xad", [0x73bb] = "\x53\x64", [0x73bc] = "\x70\xf0",
  [0x73be] = "\x6e\xb4", [0x73bf] = "\x6e\xb2", [0x73c0] = "\x53\x67",
  [0x73c2] = "\x6e\xaa", [0x73c3] = "\x6e\xb5", [0x73c5] = "\x6e\xac",
  [0x73c6] = "\x6e\xb6", [0x73c7] = "\x6e\xb3", [0x73c8] = "\x6e\xab",
  [0x73ca] = "\x53\x63", [0x73cb] = "\x6e\xb8", [0x73cc] = "\x6e\xa9",
  [0x73cd] = "\x53\x66", [0x73d2] = "\x70\xf5", [0x73d3] = "\x70\xec",
  [0x73d4] = "\x70\xf7", [0x73d6] = "\x70\xef", [0x73d7] = "\x70\xfa",
  [0x73d8] = "\x70\xfb", [0x73d9] = "\x70\xed", [0x73da] = "\x70\xf9",
  [0x73db] = "\x70\xf6", [0x73dc] = "\x70\xf4", [0x73dd] = "\x70\xf8",
  [0x73de] = "\x55\x84", [0x73e0] = "\x55\x82", [0x73e3] = "\x70\xf2",
  [0x73e5] = "\x70\xee", [0x73e7] = "\x70\xf1", [0x73e8] = "\x70\xfc",
  [0x73e9] = "\x70\xf3", [0x73ea] = "\x55\x83", [0x73eb] = "\x6e\xb1",
  [0x73ed] = "\x55\x7e", [0x73ee] = "\x55\x81", [0x73f4] = "\x74\x5e",
  [0x73f5] = "\x74\x53", [0x73f6] = "\x74\x51", [0x73f8] = "\x74\x52",
  [0x73fa] = "\x74\x59", [0x73fc] = "\x74\x5a", [0x73fd] = "\x74\x56",
  [0x73fe] = "\x58\x42", [0x73ff] = "\x74\x5b", [0x7400] = "\x74\x58",
  [0x7401] = "\x74\x55", [0x7403] = "\x57\xfd", [0x7404] = "\x74\x54",
  [0x7405] = "\x57\xfb", [0x7406] = "\x58\x41", [0x7407] = "\x74\x57",
  [0x7408] = "\x74\x5f", [0x7409] = "\x55\x7f", [0x740a] = "\x57\xfc",
  [0x740b] = "\x74\x5d", [0x740c] = "\x74\x5c", [0x740d] = "\x58\x43",
  [0x7416] = "\x77\xa5", [0x741a] = "\x77\xa6", [0x741b] = "\x5a\x87",
  [0x741d] = "\x77\xac", [0x7420] = "\x77\xae", [0x7421] = "\x77\xa7",
  [0x7422] = "\x5a\x81", [0x7423] = "\x77\xab", [0x7424] = "\x77\xaa",
  [0x7425] = "\x5a\x82", [0x7426] = "\x5a\x88", [0x7428] = "\x5a\x89",
  [0x7429] = "\x77\xad", [0x742a] = "\x5a\x7e", [0x742b] = "\x77\xa4",
  [0x742c] = "\x77\xa2", [0x742d] = "\x77\xa8", [0x742e] = "\x77\xa1",
  [0x742f] = "\x5a\x86", [0x7430] = "\x77\xa3", [0x7431] = "\x77\xa9",
  [0x7432] = "\x77\xaf", [0x7433] = "\x5a\x7f", [0x7434] = "\x5a\x85",
  [0x7435] = "\x5a\x83", [0x7436] = "\x5a\x84", [0x743a] = "\x5a\x7d",
  [0x743f] = "\x5c\xb0", [0x7440] = "\x7a\xfc", [0x7441] = "\x5c\xaf",
  [0x7442] = "\x7b\x43", [0x7444] = "\x7a\xf6", [0x7446] = "\x7b\x44",
  [0x744a] = "\x7a\xf7", [0x744b] = "\x7a\xf8", [0x744d] = "\x7b\x45",
  [0x744e] = "\x7b\x42", [0x744f] = "\x7a\xfd", [0x7450] = "\x7b\x41",
  [0x7451] = "\x7a\xfa", [0x7452] = "\x7a\xf9", [0x7454] = "\x7b\x46",
  [0x7455] = "\x5c\xac", [0x7457] = "\x7a\xfb", [0x7459] = "\x5c\xb1",
  [0x745a] = "\x5c\xab", [0x745b] = "\x5c\xb2", [0x745c] = "\x5c\xb3",
  [0x745e] = "\x5c\xae", [0x745f] = "\x5c\xad", [0x7462] = "\x7e\x97",
  [0x7463] = "\x5e\xe4", [0x7464] = "\x5e\xe3", [0x7467] = "\x7e\x9c",
  [0x7469] = "\x60\xe4", [0x746a] = "\x5e\xe5", [0x746d] = "\x5e\xe7",
  [0x746e] = "\x7e\x9d", [0x746f] = "\x5c\xaa", [0x7470] = "\x5e\xe6",
  [0x7471] = "\x7e\x99", [0x7472] = "\x7e\x9b", [0x7473] = "\x7e\x98",
  [0x7475] = "\x7e\x9a", [0x7479] = "\x81\xb4", [0x747c] = "\x81\xb3",
  [0x747d] = "\x81\xb0", [0x747e] = "\x60\xe7", [0x747f] = "\x84\xcd",
  [0x7480] = "\x60\xe8", [0x7481] = "\x81\xaf", [0x7483] = "\x60\xe6",
  [0x7485] = "\x81\xb1", [0x7486] = "\x81\xae", [0x7487] = "\x81\xab",
  [0x7488] = "\x81\xb2", [0x7489] = "\x81\xac", [0x748a] = "\x81\xad",
  [0x748b] = "\x60\xe5", [0x7490] = "\x87\x76", [0x7492] = "\x84\xd1",
  [0x7494] = "\x84\xd0", [0x7495] = "\x84\xd2", [0x7497] = "\x87\x73",
  [0x7498] = "\x62\xc3", [0x749a] = "\x84\xce", [0x749c] = "\x62\xc1",
  [0x749e] = "\x62\xc5", [0x749f] = "\x62\xc4", [0x74a0] = "\x84\xcf",
  [0x74a1] = "\x84\xd3", [0x74a3] = "\x62\xc2", [0x74a5] = "\x87\x7a",
  [0x74a6] = "\x64\x60", [0x74a7] = "\x65\x86", [0x74a8] = "\x64\x61",
  [0x74a9] = "\x64\x5e", [0x74aa] = "\x87\x77", [0x74ab] = "\x87\x75",
  [0x74ad] = "\x87\x78", [0x74af] = "\x87\x7b", [0x74b0] = "\x64\x5f",
  [0x74b1] = "\x87\x79", [0x74b2] = "\x87\x74", [0x74b5] = "\x89\xaf",
  [0x74b6] = "\x89\xb2", [0x74b7] = "\x8b\xa4", [0x74b8] = "\x89\xad",
  [0x74ba] = "\x8d\x5f", [0x74bb] = "\x89\xb3", [0x74bd] = "\x66\x6c",
  [0x74be] = "\x89\xb1", [0x74bf] = "\x65\x87", [0x74c0] = "\x89\xae",
  [0x74c1] = "\x89\xb0", [0x74c2] = "\x89\xb4", [0x74c3] = "\x8b\xa5",
  [0x74c5] = "\x8b\xa3", [0x74ca] = "\x66\x6d", [0x74cb] = "\x8b\xa2",
  [0x74cf] = "\x66\xf8", [0x74d4] = "\x67\x99", [0x74d5] = "\x8f\x82",
  [0x74d6] = "\x67\x98", [0x74d7] = "\x8f\x84", [0x74d8] = "\x8f\x81",
  [0x74d9] = "\x8f\x83", [0x74da] = "\x68\x5c", [0x74db] = "\x90\xc1",
  [0x74dc] = "\x4d\x8b", [0x74dd] = "\x6c\xb0", [0x74de] = "\x70\xfd",
  [0x74df] = "\x71\x41", [0x74e0] = "\x58\x44", [0x74e1] = "\x7b\x47",
  [0x74e2] = "\x62\xc6", [0x74e3] = "\x66\x6e", [0x74e4] = "\x67\xe6",
  [0x74e5] = "\x90\xc2", [0x74e6] = "\x4d\x8c", [0x74e8] = "\x6c\xb1",
  [0x74e9] = "\x46\xf8", [0x74ec] = "\x6e\xb9", [0x74ee] = "\x6e\xba",
  [0x74f4] = "\x71\x42", [0x74f5] = "\x71\x43", [0x74f6] = "\x58\x45",
  [0x74f7] = "\x58\x46", [0x74fb] = "\x77\xb0", [0x74fd] = "\x7b\x4a",
  [0x74fe] = "\x7b\x49", [0x74ff] = "\x7b\x48", [0x7500] = "\x7e\x9e",
  [0x7502] = "\x7e\x9f", [0x7503] = "\x7e\xa0", [0x7504] = "\x5e\xe8",
  [0x7507] = "\x81\xb6", [0x7508] = "\x81\xb5", [0x750b] = "\x84\xd4",
  [0x750c] = "\x62\xc7", [0x750d] = "\x62\xc8", [0x750f] = "\x87\x7f",
  [0x7510] = "\x87\x7c", [0x7511] = "\x87\x7d", [0x7512] = "\x87\x7e",
  [0x7513] = "\x89\xb6", [0x7514] = "\x89\xb5", [0x7515] = "\x65\x88",
  [0x7516] = "\x8b\xa6", [0x7517] = "\x8e\x8e", [0x7518] = "\x4d\x8d",
  [0x751a] = "\x53\x69", [0x751c] = "\x58\x47", [0x751d] = "\x7b\x4b",
  [0x751f] = "\x4d\x8e", [0x7521] = "\x71\x44", [0x7522] = "\x58\x48",
  [0x7525] = "\x5a\x8a", [0x7526] = "\x5a\x8b", [0x7528] = "\x4d\x8f",
  [0x7529] = "\x4d\x90", [0x752a] = "\x69\xe5", [0x752b] = "\x4f\xac",
  [0x752c] = "\x4f\xab", [0x752d] = "\x53\x6a", [0x752e] = "\x6e\xbb",
  [0x752f] = "\x77\xb1", [0x7530] = "\x4d\x91", [0x7531] = "\x4d\x92",
  [0x7532] = "\x4d\x93", [0x7533] = "\x4d\x94", [0x7537] = "\x4f\xad",
  [0x7538] = "\x4f\xae", [0x7539] = "\x6a\xee", [0x753a] = "\x6a\xed",
  [0x753d] = "\x51\x98", [0x753e] = "\x6c\xb4", [0x753f] = "\x6c\xb2",
  [0x7540] = "\x6c\xb3", [0x7547] = "\x6e\xbc", [0x7548] = "\x6e\xbd",
  [0x754b] = "\x53\x6e", [0x754c] = "\x53\x6c", [0x754e] = "\x53\x6d",
  [0x754f] = "\x53\x6b", [0x7554] = "\x55\x85", [0x7559] = "\x55\x89",
  [0x755a] = "\x55\x88", [0x755b] = "\x71\x45", [0x755c] = "\x55\x87",
  [0x755d] = "\x55\x86", [0x755f] = "\x71\x46", [0x7562] = "\x58\x4b",
  [0x7563] = "\x74\x61", [0x7564] = "\x74\x60", [0x7565] = "\x58\x49",
  [0x7566] = "\x58\x4a", [0x756a] = "\x5a\x8d", [0x756b] = "\x5a\x8c",
  [0x756c] = "\x77\xb3", [0x756f] = "\x77\xb2", [0x7570] = "\x58\x4c",
  [0x7576] = "\x5c\xb4", [0x7577] = "\x7b\x4d", [0x7578] = "\x5c\xb5",
  [0x7579] = "\x7b\x4c", [0x757d] = "\x7e\xa1", [0x757e] = "\x81\xb7",
  [0x757f] = "\x60\xe9", [0x7580] = "\x84\xd5", [0x7584] = "\x87\x81",
  [0x7586] = "\x66\x70", [0x7587] = "\x66\x6f", [0x758a] = "\x67\xe7",
  [0x758b] = "\x4d\x95", [0x758c] = "\x6c\xb5", [0x758f] = "\x58\x4d",
  [0x7590] = "\x7e\xa2", [0x7591] = "\x5e\xe9", [0x7592] = "\x48\xa8",
  [0x7594] = "\x6a\xef", [0x7595] = "\x6a\xf0", [0x7598] = "\x6c\xb6",
  [0x7599] = "\x51\x9a", [0x759a] = "\x51\x9b", [0x759d] = "\x51\x99",
  [0x75a2] = "\x53\x72", [0x75a3] = "\x53\x73", [0x75a4] = "\x53\x70",
  [0x75a5] = "\x53\x71", [0x75a7] = "\x6e\xbe", [0x75aa] = "\x6e\xbf",
  [0x75ab] = "\x53\x6f", [0x75b0] = "\x71\x47", [0x75b2] = "\x55\x8d",
  [0x75b3] = "\x55\x8e", [0x75b5] = "\x58\x50", [0x75b6] = "\x71\x4d",
  [0x75b8] = "\x55\x93", [0x75b9] = "\x55\x91", [0x75ba] = "\x71\x4e",
  [0x75bb] = "\x71\x49", [0x75bc] = "\x55\x90", [0x75bd] = "\x55\x8f",
  [0x75be] = "\x55\x8a", [0x75bf] = "\x71\x4c", [0x75c0] = "\x71\x4b",
  [0x75c1] = "\x71\x48", [0x75c2] = "\x55\x92", [0x75c4] = "\x71\x4a",
  [0x75c5] = "\x55\x8b", [0x75c7] = "\x55\x8c", [0x75ca] = "\x58\x51",
  [0x75cb] = "\x74\x65", [0x75cc] = "\x74\x66", [0x75cd] = "\x58\x52",
  [0x75ce] = "\x74\x62", [0x75cf] = "\x74\x64", [0x75d0] = "\x74\x68",
  [0x75d1] = "\x74\x67", [0x75d2] = "\x74\x63", [0x75d4] = "\x58\x4e",
  [0x75d5] = "\x58\x4f", [0x75d7] = "\x77\xbb", [0x75d8] = "\x5a\x92",
  [0x75d9] = "\x5a\x91", [0x75da] = "\x77\xb5", [0x75db] = "\x5a\x8f",
  [0x75dd] = "\x77\xb8", [0x75de] = "\x5a\x93", [0x75df] = "\x77\xb9",
  [0x75e0] = "\x5a\x94", [0x75e1] = "\x77\xb6", [0x75e2] = "\x5a\x8e",
  [0x75e3] = "\x5a\x90", [0x75e4] = "\x77\xba", [0x75e6] = "\x77\xb7",
  [0x75e7] = "\x77\xb4", [0x75ed] = "\x7b\x5a", [0x75ef] = "\x7b\x4f",
  [0x75f0] = "\x5c\xb7", [0x75f1] = "\x5c\xba", [0x75f2] = "\x5c\xb9",
  [0x75f3] = "\x5c\xbe", [0x75f4] = "\x5c\xbd", [0x75f5] = "\x7b\x5b",
  [0x75f6] = "\x7b\x59", [0x75f7] = "\x7b\x52", [0x75f8] = "\x7b\x56",
  [0x75f9] = "\x7b\x55", [0x75fa] = "\x5c\xbb", [0x75fb] = "\x7b\x58",
  [0x75fc] = "\x7b\x54", [0x75fd] = "\x7b\x5c", [0x75fe] = "\x7b\x53",
  [0x75ff] = "\x5c\xbc", [0x7600] = "\x5c\xb6", [0x7601] = "\x5c\xb8",
  [0x7603] = "\x7b\x51", [0x7608] = "\x7e\xa4", [0x7609] = "\x5e\xed",
  [0x760a] = "\x7e\xa8", [0x760b] = "\x5e\xec", [0x760c] = "\x7e\xa5",
  [0x760d] = "\x5e\xeb", [0x760f] = "\x7b\x50", [0x7610] = "\x7b\x57",
  [0x7611] = "\x7e\xa7", [0x7613] = "\x5e\xee", [0x7614] = "\x7e\xa9",
  [0x7615] = "\x7e\xa6", [0x7616] = "\x7e\xa3", [0x7619] = "\x81\xba",
  [0x761a] = "\x81\xbe", [0x761b] = "\x81\xc0", [0x761c] = "\x81\xbc",
  [0x761d] = "\x81\xbb", [0x761e] = "\x81\xb9", [0x761f] = "\x60\xec",
  [0x7620] = "\x60\xea", [0x7621] = "\x60\xef", [0x7622] = "\x60\xf0",
  [0x7623] = "\x81\xbd", [0x7624] = "\x60\xed", [0x7625] = "\x81\xb8",
  [0x7626] = "\x60\xee", [0x7627] = "\x5e\xea", [0x7628] = "\x81\xbf",
  [0x7629] = "\x60\xeb", [0x762d] = "\x84\xd7", [0x762f] = "\x84\xd6",
  [0x7630] = "\x84\xde", [0x7631] = "\x84\xd8", [0x7632] = "\x84\xdd",
  [0x7633] = "\x84\xda", [0x7634] = "\x62\xc9", [0x7635] = "\x84\xdc",
  [0x7638] = "\x62\xca", [0x763a] = "\x62\xcb", [0x763c] = "\x84\xdb",
  [0x763d] = "\x84\xd9", [0x7642] = "\x64\x63", [0x7643] = "\x87\x82",
  [0x7646] = "\x64\x62", [0x7647] = "\x87\x85", [0x7648] = "\x87\x83",
  [0x7649] = "\x87\x84", [0x764c] = "\x64\x64", [0x7650] = "\x89\xba",
  [0x7652] = "\x65\x8b", [0x7653] = "\x89\xbb", [0x7656] = "\x65\x89",
  [0x7657] = "\x89\xbc", [0x7658] = "\x65\x8a", [0x7659] = "\x89\xb9",
  [0x765a] = "\x89\xbd", [0x765c] = "\x89\xb7", [0x765f] = "\x66\x71",
  [0x7660] = "\x8b\xa7", [0x7661] = "\x66\x72", [0x7662] = "\x66\xf9",
  [0x7664] = "\x89\xb8", [0x7665] = "\x66\xfa", [0x7669] = "\x67\x9a",
  [0x766a] = "\x8e\x8f", [0x766c] = "\x67\xe9", [0x766d] = "\x8f\x85",
  [0x766e] = "\x67\xe8", [0x7670] = "\x90\x5b", [0x7671] = "\x68\x82",
  [0x7672] = "\x68\x83", [0x7675] = "\x91\xbc", [0x7676] = "\x48\xa9",
  [0x7678] = "\x53\x74", [0x7679] = "\x6e\xc0", [0x767b] = "\x5a\x95",
  [0x767c] = "\x5a\x96", [0x767d] = "\x4d\x96", [0x767e] = "\x4e\x6b",
  [0x767f] = "\x69\xe6", [0x7681] = "\x6a\xf1", [0x7682] = "\x4f\xaf",
  [0x7684] = "\x51\x9c", [0x7686] = "\x53\x75", [0x7687] = "\x53\x76",
  [0x7688] = "\x53\x77", [0x7689] = "\x74\x6a", [0x768a] = "\x71\x4f",
  [0x768b] = "\x55\x94", [0x768e] = "\x58\x53", [0x768f] = "\x74\x69",
  [0x7692] = "\x77\xbd", [0x7693] = "\x5a\x98", [0x7695] = "\x77\xbc",
  [0x7696] = "\x5a\x97", [0x7699] = "\x7b\x5d", [0x769a] = "\x60\xf1",
  [0x769b] = "\x81\xc4", [0x769c] = "\x81\xc1", [0x769d] = "\x81\xc2",
  [0x769e] = "\x81\xc3", [0x76a4] = "\x87\x86", [0x76a6] = "\x89\xbe",
  [0x76aa] = "\x8d\x61", [0x76ab] = "\x8d\x60", [0x76ad] = "\x8f\x86",
  [0x76ae] = "\x4d\x97", [0x76af] = "\x6c\xb7", [0x76b0] = "\x55\x95",
  [0x76b4] = "\x5a\x99", [0x76b5] = "\x7b\x5e", [0x76b8] = "\x7e\xaa",
  [0x76ba] = "\x60\xf2", [0x76bb] = "\x84\xdf", [0x76bd] = "\x89\xbf",
  [0x76be] = "\x8d\x62", [0x76bf] = "\x4d\x98", [0x76c2] = "\x51\x9d",
  [0x76c3] = "\x53\x7a", [0x76c4] = "\x6e\xc1", [0x76c5] = "\x53\x7b",
  [0x76c6] = "\x53\x79", [0x76c8] = "\x53\x78", [0x76c9] = "\x71\x50",
  [0x76ca] = "\x55\x96", [0x76cd] = "\x55\x97", [0x76ce] = "\x55\x98",
  [0x76d2] = "\x58\x55", [0x76d3] = "\x74\x6b", [0x76d4] = "\x58\x54",
  [0x76da] = "\x77\xbe", [0x76db] = "\x58\x56", [0x76dc] = "\x5a\x9a",
  [0x76dd] = "\x7b\x5f", [0x76de] = "\x5c\xbf", [0x76df] = "\x5c\xc0",
  [0x76e1] = "\x5e\xef", [0x76e3] = "\x5e\xf0", [0x76e4] = "\x60\xf3",
  [0x76e5] = "\x62\xcd", [0x76e6] = "\x84\xe0", [0x76e7] = "\x62\xcc",
  [0x76e9] = "\x87\x87", [0x76ea] = "\x64\x65", [0x76ec] = "\x89\xc0",
  [0x76ed] = "\x8d\x63", [0x76ee] = "\x4d\x99", [0x76ef] = "\x4f\xb0",
  [0x76f0] = "\x6c\xba", [0x76f1] = "\x6c\xb9", [0x76f2] = "\x51\x9e",
  [0x76f3] = "\x6c\xb8", [0x76f4] = "\x51\x9f", [0x76f5] = "\x6c\xbb",
  [0x76f7] = "\x6e\xc7", [0x76f8] = "\x53\x7e", [0x76f9] = "\x53\x7d",
  [0x76fa] = "\x6e\xc9", [0x76fb] = "\x6e\xc8", [0x76fc] = "\x53\x83",
  [0x76fe] = "\x53\x82", [0x7701] = "\x53\x7c", [0x7703] = "\x6e\xc3",
  [0x7704] = "\x6e\xc4", [0x7705] = "\x6e\xc5", [0x7707] = "\x53\x84",
  [0x7708] = "\x6e\xc2", [0x7709] = "\x53\x7f", [0x770a] = "\x6e\xc6",
  [0x770b] = "\x53\x81", [0x7710] = "\x71\x53", [0x7711] = "\x71\x57",
  [0x7712] = "\x71\x55", [0x7713] = "\x71\x54", [0x7715] = "\x71\x58",
  [0x7719] = "\x71\x59", [0x771a] = "\x71\x5a", [0x771b] = "\x71\x52",
  [0x771d] = "\x71\x51", [0x771f] = "\x55\x9a", [0x7720] = "\x55\x9b",
  [0x7722] = "\x71\x5b", [0x7723] = "\x71\x56", [0x7725] = "\x74\x74",
  [0x7727] = "\x71\x5c", [0x7728] = "\x55\x9c", [0x7729] = "\x55\x99",
  [0x772d] = "\x74\x6e", [0x772f] = "\x74\x6d", [0x7731] = "\x74\x6f",
  [0x7732] = "\x74\x70", [0x7733] = "\x74\x72", [0x7734] = "\x74\x71",
  [0x7735] = "\x74\x76", [0x7736] = "\x58\x5a", [0x7737] = "\x58\x57",
  [0x7738] = "\x58\x5b", [0x7739] = "\x74\x6c", [0x773a] = "\x58\x5c",
  [0x773b] = "\x74\x75", [0x773c] = "\x58\x59", [0x773d] = "\x74\x73",
  [0x773e] = "\x58\x58", [0x7744] = "\x77\xc1", [0x7745] = "\x77\xc3",
  [0x7746] = "\x77\xbf", [0x7747] = "\x77\xc0", [0x774a] = "\x77\xc4",
  [0x774b] = "\x77\xc6", [0x774c] = "\x77\xc7", [0x774d] = "\x77\xc2",
  [0x774e] = "\x77\xc5", [0x774f] = "\x5a\x9b", [0x7752] = "\x7b\x63",
  [0x7754] = "\x7b\x68", [0x7755] = "\x7b\x60", [0x7756] = "\x7b\x64",
  [0x7759] = "\x7b\x69", [0x775a] = "\x7b\x65", [0x775b] = "\x5c\xc1",
  [0x775c] = "\x5c\xc9", [0x775e] = "\x5c\xc4", [0x775f] = "\x7b\x61",
  [0x7760] = "\x7b\x62", [0x7761] = "\x5e\xf4", [0x7762] = "\x5c\xcc",
  [0x7763] = "\x5c\xc5", [0x7765] = "\x5c\xca", [0x7766] = "\x5c\xc3",
  [0x7767] = "\x7b\x67", [0x7768] = "\x5c\xcb", [0x7769] = "\x7b\x66",
  [0x776a] = "\x5c\xc7", [0x776b] = "\x5c\xc2", [0x776c] = "\x5c\xc8",
  [0x776d] = "\x7b\x6a", [0x776e] = "\x7e\xaf", [0x776f] = "\x7e\xb1",
  [0x7779] = "\x5c\xc6", [0x777c] = "\x7e\xac", [0x777d] = "\x5e\xf2",
  [0x777e] = "\x7e\xb2", [0x777f] = "\x5e\xf3", [0x7780] = "\x7e\xb0",
  [0x7781] = "\x7e\xab", [0x7782] = "\x7e\xae", [0x7783] = "\x7e\xb3",
  [0x7784] = "\x5e\xf1", [0x7785] = "\x7e\xad", [0x7787] = "\x60\xf5",
  [0x7788] = "\x81\xc8", [0x7789] = "\x81\xc7", [0x778b] = "\x60\xf8",
  [0x778c] = "\x60\xf6", [0x778d] = "\x81\xc5", [0x778e] = "\x60\xf4",
  [0x778f] = "\x81\xc6", [0x7791] = "\x60\xf7", [0x7795] = "\x84\xe8",
  [0x7797] = "\x84\xea", [0x7799] = "\x84\xe9", [0x779a] = "\x84\xe1",
  [0x779b] = "\x84\xe5", [0x779c] = "\x84\xe4", [0x779d] = "\x84\xe2",
  [0x779e] = "\x62\xcf", [0x779f] = "\x62\xd0", [0x77a0] = "\x62\xce",
  [0x77a1] = "\x84\xe3", [0x77a2] = "\x84\xe6", [0x77a3] = "\x84\xe7",
  [0x77a5] = "\x62\xd1", [0x77a7] = "\x64\x6a", [0x77a8] = "\x87\x8f",
  [0x77aa] = "\x64\x67", [0x77ab] = "\x87\x89", [0x77ac] = "\x64\x69",
  [0x77ad] = "\x64\x6b", [0x77b0] = "\x64\x68", [0x77b1] = "\x87\x8e",
  [0x77b2] = "\x87\x8a", [0x77b3] = "\x64\x66", [0x77b4] = "\x87\x8d",
  [0x77b5] = "\x87\x88", [0x77b6] = "\x87\x8c", [0x77b7] = "\x87\x8b",
  [0x77ba] = "\x89\xc2", [0x77bb] = "\x65\x8e", [0x77bc] = "\x65\x8f",
  [0x77bd] = "\x65\x8c", [0x77bf] = "\x65\x8d", [0x77c2] = "\x89\xc1",
  [0x77c4] = "\x8b\xaa", [0x77c7] = "\x66\x73", [0x77c9] = "\x8b\xa8",
  [0x77ca] = "\x8b\xa9", [0x77cc] = "\x8d\x64", [0x77cd] = "\x8d\x67",
  [0x77ce] = "\x8d\x65", [0x77cf] = "\x8d\x66", [0x77d0] = "\x8e\x90",
  [0x77d3] = "\x67\x9b", [0x77d4] = "\x90\x5c", [0x77d5] = "\x90\xc3",
  [0x77d7] = "\x68\x84", [0x77d8] = "\x91\x4a", [0x77d9] = "\x91\x4b",
  [0x77da] = "\x68\xb2", [0x77db] = "\x4d\x9a", [0x77dc] = "\x53\x85",
  [0x77de] = "\x77\xc8", [0x77e0] = "\x7b\x6b", [0x77e2] = "\x4d\x9b",
  [0x77e3] = "\x4f\xb1", [0x77e5] = "\x51\xa0", [0x77e7] = "\x6e\xca",
  [0x77e8] = "\x6e\xcb", [0x77e9] = "\x55\x9d", [0x77ec] = "\x77\xc9",
  [0x77ed] = "\x5a\x9c", [0x77ee] = "\x5c\xcd", [0x77ef] = "\x64\x6c",
  [0x77f0] = "\x87\x90", [0x77f1] = "\x8b\xab", [0x77f2] = "\x8d\x68",
  [0x77f3] = "\x4d\x9c", [0x77f7] = "\x6c\xc1", [0x77f8] = "\x6c\xbc",
  [0x77f9] = "\x6c\xbe", [0x77fa] = "\x6c\xc0", [0x77fb] = "\x6c\xbf",
  [0x77fc] = "\x6c\xbd", [0x77fd] = "\x51\xa1", [0x7802] = "\x53\x86",
  [0x7803] = "\x6e\xd4", [0x7805] = "\x6e\xcf", [0x7806] = "\x6e\xcc",
  [0x7809] = "\x6e\xd3", [0x780c] = "\x53\x88", [0x780d] = "\x53\x89",
  [0x780e] = "\x6e\xd2", [0x780f] = "\x6e\xd1", [0x7810] = "\x6e\xd0",
  [0x7811] = "\x6e\xcd", [0x7812] = "\x6e\xce", [0x7813] = "\x6e\xd5",
  [0x7814] = "\x53\x87", [0x781d] = "\x55\xa1", [0x781f] = "\x55\xa7",
  [0x7820] = "\x55\xa6", [0x7821] = "\x71\x65", [0x7822] = "\x71\x5f",
  [0x7823] = "\x71\x5d", [0x7825] = "\x55\xa4", [0x7826] = "\x74\x7d",
  [0x7827] = "\x55\x9f", [0x7828] = "\x71\x62", [0x7829] = "\x71\x66",
  [0x782a] = "\x71\x68", [0x782b] = "\x71\x64", [0x782c] = "\x71\x5e",
  [0x782d] = "\x55\xa5", [0x782e] = "\x71\x63", [0x782f] = "\x71\x61",
  [0x7830] = "\x55\x9e", [0x7831] = "\x71\x69", [0x7832] = "\x55\xa8",
  [0x7833] = "\x71\x67", [0x7834] = "\x55\xa2", [0x7835] = "\x71\x60",
  [0x7837] = "\x55\xa3", [0x7838] = "\x55\xa0", [0x7843] = "\x58\x5e",
  [0x7845] = "\x74\x7e", [0x7848] = "\x74\x77", [0x7849] = "\x74\x79",
  [0x784a] = "\x74\x7b", [0x784c] = "\x74\x7c", [0x784d] = "\x74\x7a",
  [0x784e] = "\x58\x5f", [0x7850] = "\x74\x7f", [0x7852] = "\x74\x78",
  [0x785c] = "\x77\xcd", [0x785d] = "\x5a\x9d", [0x785e] = "\x77\xd5",
  [0x7860] = "\x77\xca", [0x7862] = "\x77\xd6", [0x7864] = "\x77\xcb",
  [0x7865] = "\x77\xcc", [0x7868] = "\x77\xd4", [0x7869] = "\x77\xd3",
  [0x786a] = "\x77\xd0", [0x786b] = "\x58\x5d", [0x786c] = "\x5a\x9e",
  [0x786d] = "\x77\xce", [0x786e] = "\x77\xd1", [0x786f] = "\x5a\x9f",
  [0x7870] = "\x77\xd2", [0x7871] = "\x77\xcf", [0x7879] = "\x7b\x76",
  [0x787b] = "\x7b\x7a", [0x787c] = "\x5c\xd4", [0x787e] = "\x7e\xb9",
  [0x787f] = "\x5c\xd7", [0x7880] = "\x7b\x78", [0x7883] = "\x7b\x75",
  [0x7884] = "\x7b\x70", [0x7885] = "\x7b\x72", [0x7886] = "\x7b\x73",
  [0x7887] = "\x7b\x6c", [0x7889] = "\x5c\xd3", [0x788c] = "\x5c\xd2",
  [0x788e] = "\x5c\xce", [0x788f] = "\x7b\x6f", [0x7891] = "\x5c\xd5",
  [0x7893] = "\x5c\xd6", [0x7894] = "\x7b\x6e", [0x7895] = "\x7b\x71",
  [0x7896] = "\x7b\x79", [0x7897] = "\x5c\xd0", [0x7898] = "\x5c\xd1",
  [0x7899] = "\x7b\x77", [0x789a] = "\x7b\x6d", [0x789e] = "\x7e\xbb",
  [0x789f] = "\x5e\xf6", [0x78a0] = "\x7e\xbd", [0x78a1] = "\x7b\x74",
  [0x78a2] = "\x7e\xbf", [0x78a3] = "\x5e\xfa", [0x78a4] = "\x7e\xc0",
  [0x78a5] = "\x7e\xbc", [0x78a7] = "\x5e\xf7", [0x78a8] = "\x7e\xb8",
  [0x78a9] = "\x5e\xf9", [0x78aa] = "\x7e\xb5", [0x78ab] = "\x7e\xba",
  [0x78ac] = "\x7e\xbe", [0x78ad] = "\x7e\xb7", [0x78b0] = "\x5c\xcf",
  [0x78b2] = "\x7e\xb4", [0x78b3] = "\x5e\xf8", [0x78b4] = "\x7e\xb6",
  [0x78ba] = "\x60\xfb", [0x78bb] = "\x81\xca", [0x78bc] = "\x61\x42",
  [0x78be] = "\x60\xfd", [0x78c1] = "\x5e\xf5", [0x78c3] = "\x81\xd1",
  [0x78c4] = "\x81\xd2", [0x78c5] = "\x60\xfa", [0x78c8] = "\x81\xd0",
  [0x78c9] = "\x81\xd3", [0x78ca] = "\x60\xfc", [0x78cb] = "\x60\xf9",
  [0x78cc] = "\x81\xcc", [0x78cd] = "\x81\xc9", [0x78ce] = "\x81\xce",
  [0x78cf] = "\x81\xcb", [0x78d0] = "\x61\x43", [0x78d1] = "\x81\xcd",
  [0x78d4] = "\x81\xcf", [0x78d5] = "\x61\x41", [0x78da] = "\x62\xd3",
  [0x78db] = "\x84\xf1", [0x78dd] = "\x84\xeb", [0x78de] = "\x84\xef",
  [0x78df] = "\x84\xf5", [0x78e0] = "\x84\xf6", [0x78e1] = "\x84\xf2",
  [0x78e2] = "\x84\xf3", [0x78e3] = "\x84\xf0", [0x78e5] = "\x84\xed",
  [0x78e7] = "\x62\xd5", [0x78e8] = "\x62\xd2", [0x78e9] = "\x84\xec",
  [0x78ea] = "\x84\xee", [0x78ec] = "\x62\xd4", [0x78ed] = "\x84\xf4",
  [0x78ef] = "\x64\x70", [0x78f2] = "\x87\x96", [0x78f3] = "\x87\x91",
  [0x78f4] = "\x64\x6f", [0x78f7] = "\x64\x6d", [0x78f9] = "\x87\x98",
  [0x78fa] = "\x64\x6e", [0x78fb] = "\x87\x94", [0x78fc] = "\x87\x95",
  [0x78fd] = "\x87\x92", [0x78fe] = "\x87\x99", [0x78ff] = "\x89\xc3",
  [0x7901] = "\x64\x71", [0x7902] = "\x87\x93", [0x7904] = "\x87\x9a",
  [0x7905] = "\x87\x97", [0x7909] = "\x89\xc7", [0x790c] = "\x89\xc4",
  [0x790e] = "\x65\x90", [0x7910] = "\x89\xc8", [0x7911] = "\x89\xca",
  [0x7912] = "\x89\xc9", [0x7913] = "\x89\xc5", [0x7914] = "\x89\xc6",
  [0x7917] = "\x8b\xb0", [0x7919] = "\x66\x74", [0x791b] = "\x8b\xad",
  [0x791c] = "\x8b\xaf", [0x791d] = "\x8b\xac", [0x791e] = "\x8b\xb1",
  [0x7921] = "\x8b\xae", [0x7923] = "\x8d\x6a", [0x7924] = "\x8d\x6d",
  [0x7925] = "\x8d\x69", [0x7926] = "\x66\xfb", [0x7927] = "\x8d\x6b",
  [0x7928] = "\x8d\x6c", [0x7929] = "\x8d\x6e", [0x792a] = "\x66\xfc",
  [0x792b] = "\x67\x41", [0x792c] = "\x66\xfd", [0x792d] = "\x8e\x91",
  [0x792f] = "\x8e\x93", [0x7931] = "\x8e\x92", [0x7935] = "\x8f\x87",
  [0x7938] = "\x90\xc4", [0x7939] = "\x91\x4c", [0x793a] = "\x4d\x9d",
  [0x793d] = "\x6a\xf2", [0x793e] = "\x51\xa2", [0x793f] = "\x6c\xc3",
  [0x7940] = "\x51\xa3", [0x7941] = "\x51\xa4", [0x7942] = "\x6c\xc2",
  [0x7944] = "\x6e\xda", [0x7945] = "\x6e\xd9", [0x7946] = "\x53\x8a",
  [0x7947] = "\x53\x8d", [0x7948] = "\x53\x8c", [0x7949] = "\x53\x8b",
  [0x794a] = "\x6e\xd6", [0x794b] = "\x6e\xd8", [0x794c] = "\x6e\xd7",
  [0x794f] = "\x71\x6c", [0x7950] = "\x55\xaa", [0x7951] = "\x71\x70",
  [0x7952] = "\x71\x6f", [0x7953] = "\x71\x6e", [0x7954] = "\x71\x6a",
  [0x7955] = "\x55\xa9", [0x7956] = "\x55\xad", [0x7957] = "\x55\xb0",
  [0x795a] = "\x55\xb1", [0x795b] = "\x71\x6b", [0x795c] = "\x71\x6d",
  [0x795d] = "\x55\xaf", [0x795e] = "\x55\xae", [0x795f] = "\x55\xac",
  [0x7960] = "\x55\xab", [0x7961] = "\x74\x87", [0x7963] = "\x74\x85",
  [0x7964] = "\x74\x81", [0x7965] = "\x58\x60", [0x7967] = "\x74\x82",
  [0x7968] = "\x58\x61", [0x7969] = "\x74\x83", [0x796a] = "\x74\x84",
  [0x796b] = "\x74\x86", [0x796d] = "\x58\x62", [0x7970] = "\x77\xda",
  [0x7972] = "\x77\xd9", [0x7973] = "\x77\xd8", [0x7974] = "\x77\xd7",
  [0x7979] = "\x7b\x7e", [0x797a] = "\x5c\xd8", [0x797c] = "\x7b\x7b",
  [0x797d] = "\x7b\x7d", [0x797f] = "\x5c\xd9", [0x7981] = "\x5c\xda",
  [0x7982] = "\x7b\x7c", [0x7988] = "\x7e\xc9", [0x798a] = "\x7e\xc2",
  [0x798b] = "\x7e\xc3", [0x798d] = "\x5e\xfd", [0x798e] = "\x5e\xfb",
  [0x798f] = "\x5e\xfc", [0x7990] = "\x7e\xcb", [0x7992] = "\x7e\xca",
  [0x7993] = "\x7e\xc7", [0x7994] = "\x7e\xc6", [0x7995] = "\x7e\xc5",
  [0x7996] = "\x7e\xc4", [0x7997] = "\x7e\xc8", [0x7998] = "\x7e\xc1",
  [0x799a] = "\x81\xd4", [0x799b] = "\x81\xd9", [0x799c] = "\x81\xd7",
  [0x79a0] = "\x81\xd6", [0x79a1] = "\x81\xd5", [0x79a2] = "\x81\xd8",
  [0x79a4] = "\x84\xf7", [0x79a6] = "\x62\xd6", [0x79a7] = "\x64\x72",
  [0x79a8] = "\x87\x9c", [0x79aa] = "\x64\x73", [0x79ab] = "\x87\x9b",
  [0x79ac] = "\x89\xcc", [0x79ad] = "\x89\xcb", [0x79ae] = "\x65\x91",
  [0x79b0] = "\x8b\xb2", [0x79b1] = "\x66\x75", [0x79b2] = "\x8d\x6f",
  [0x79b3] = "\x67\xea", [0x79b4] = "\x8f\x88", [0x79b6] = "\x90\xc6",
  [0x79b7] = "\x90\xc5", [0x79b8] = "\x69\x88", [0x79b9] = "\x53\x8e",
  [0x79ba] = "\x53\x8f", [0x79bb] = "\x74\x88", [0x79bd] = "\x5c\xdc",
  [0x79be] = "\x4d\x9e", [0x79bf] = "\x4f\xb4", [0x79c0] = "\x4f\xb3",
  [0x79c1] = "\x4f\xb2", [0x79c5] = "\x6c\xc4", [0x79c8] = "\x51\xa6",
  [0x79c9] = "\x51\xa5", [0x79cb] = "\x53\x92", [0x79cd] = "\x6e\xdc",
  [0x79ce] = "\x6e\xdf", [0x79cf] = "\x6e\xdd", [0x79d1] = "\x53\x90",
  [0x79d2] = "\x53\x91", [0x79d5] = "\x6e\xdb", [0x79d6] = "\x6e\xde",
  [0x79d8] = "\x55\xb8", [0x79dc] = "\x71\x77", [0x79dd] = "\x71\x79",
  [0x79de] = "\x71\x78", [0x79df] = "\x55\xb5", [0x79e0] = "\x71\x73",
  [0x79e3] = "\x55\xb3", [0x79e4] = "\x55\xb2", [0x79e6] = "\x55\xb6",
  [0x79e7] = "\x55\xb4", [0x79e9] = "\x55\xb7", [0x79ea] = "\x71\x76",
  [0x79eb] = "\x71\x71", [0x79ec] = "\x71\x72", [0x79ed] = "\x71\x75",
  [0x79ee] = "\x71\x74", [0x79f6] = "\x74\x8b", [0x79f7] = "\x74\x8c",
  [0x79f8] = "\x74\x8a", [0x79fa] = "\x74\x89", [0x79fb] = "\x58\x63",
  [0x7a00] = "\x5a\xa4", [0x7a02] = "\x77\xdb", [0x7a03] = "\x77\xdd",
  [0x7a04] = "\x77\xdf", [0x7a05] = "\x5a\xa3", [0x7a08] = "\x5a\xa1",
  [0x7a0a] = "\x77\xdc", [0x7a0b] = "\x5a\xa2", [0x7a0c] = "\x77\xde",
  [0x7a0d] = "\x5a\xa0", [0x7a10] = "\x7b\x89", [0x7a11] = "\x7b\x7f",
  [0x7a12] = "\x7b\x83", [0x7a13] = "\x7b\x87", [0x7a14] = "\x5c\xe0",
  [0x7a15] = "\x7b\x85", [0x7a17] = "\x7b\x84", [0x7a18] = "\x7b\x81",
  [0x7a19] = "\x7b\x82", [0x7a1a] = "\x5c\xde", [0x7a1b] = "\x7b\x88",
  [0x7a1c] = "\x5c\xdd", [0x7a1e] = "\x5c\xe2", [0x7a1f] = "\x5c\xe1",
  [0x7a20] = "\x5c\xdf", [0x7a22] = "\x7b\x86", [0x7a26] = "\x7e\xd1",
  [0x7a28] = "\x7e\xd0", [0x7a2b] = "\x7e\xcc", [0x7a2e] = "\x5f\x41",
  [0x7a2f] = "\x7e\xcf", [0x7a30] = "\x7e\xce", [0x7a31] = "\x5f\x42",
  [0x7a37] = "\x61\x48", [0x7a39] = "\x81\xdb", [0x7a3b] = "\x61\x49",
  [0x7a3c] = "\x61\x45", [0x7a3d] = "\x61\x47", [0x7a3f] = "\x61\x44",
  [0x7a40] = "\x61\x46", [0x7a44] = "\x84\xf8", [0x7a46] = "\x62\xd9",
  [0x7a47] = "\x84\xfa", [0x7a48] = "\x84\xf9", [0x7a4a] = "\x7e\xcd",
  [0x7a4b] = "\x62\xdb", [0x7a4c] = "\x62\xda", [0x7a4d] = "\x62\xd7",
  [0x7a4e] = "\x62\xd8", [0x7a54] = "\x87\xa1", [0x7a56] = "\x87\x9f",
  [0x7a57] = "\x64\x74", [0x7a58] = "\x87\xa0", [0x7a5a] = "\x87\xa2",
  [0x7a5b] = "\x87\x9e", [0x7a5c] = "\x87\x9d", [0x7a5f] = "\x89\xcd",
  [0x7a60] = "\x65\x94", [0x7a61] = "\x65\x92", [0x7a62] = "\x65\x93",
  [0x7a67] = "\x8b\xb3", [0x7a68] = "\x8b\xb4", [0x7a69] = "\x66\x77",
  [0x7a6b] = "\x66\x76", [0x7a6c] = "\x8d\x71", [0x7a6d] = "\x8d\x72",
  [0x7a6e] = "\x8d\x70", [0x7a70] = "\x8f\x89", [0x7a71] = "\x8f\x8a",
  [0x7a74] = "\x4d\x9f", [0x7a75] = "\x69\xe7", [0x7a76] = "\x4f\xb5",
  [0x7a78] = "\x6c\xc5", [0x7a79] = "\x51\xa8", [0x7a7a] = "\x51\xa7",
  [0x7a7b] = "\x6c\xc6", [0x7a7e] = "\x6e\xe1", [0x7a7f] = "\x53\x93",
  [0x7a80] = "\x6e\xe0", [0x7a81] = "\x53\x94", [0x7a84] = "\x55\xb9",
  [0x7a85] = "\x71\x7c", [0x7a86] = "\x71\x7a", [0x7a87] = "\x71\x81",
  [0x7a88] = "\x55\xba", [0x7a89] = "\x71\x7b", [0x7a8a] = "\x71\x7f",
  [0x7a8b] = "\x71\x7d", [0x7a8c] = "\x71\x7e", [0x7a8f] = "\x74\x8d",
  [0x7a90] = "\x74\x8f", [0x7a92] = "\x58\x64", [0x7a94] = "\x74\x8e",
  [0x7a95] = "\x58\x65", [0x7a96] = "\x5a\xa7", [0x7a97] = "\x5a\xa6",
  [0x7a98] = "\x5a\xa5", [0x7a99] = "\x77\xe0", [0x7a9e] = "\x7b\x8c",
  [0x7a9f] = "\x5c\xe3", [0x7aa0] = "\x5c\xe4", [0x7aa2] = "\x7b\x8b",
  [0x7aa3] = "\x7b\x8a", [0x7aa8] = "\x7e\xd2", [0x7aa9] = "\x5f\x44",
  [0x7aaa] = "\x5f\x43", [0x7aab] = "\x7e\xd3", [0x7aac] = "\x7e\xd4",
  [0x7aae] = "\x61\x4b", [0x7aaf] = "\x61\x4a", [0x7ab1] = "\x85\x41",
  [0x7ab2] = "\x81\xdc", [0x7ab3] = "\x81\xde", [0x7ab4] = "\x81\xdd",
  [0x7ab5] = "\x84\xfd", [0x7ab6] = "\x84\xfb", [0x7ab7] = "\x85\x42",
  [0x7ab8] = "\x84\xfc", [0x7aba] = "\x62\xdc", [0x7abe] = "\x87\xa3",
  [0x7abf] = "\x64\x75", [0x7ac0] = "\x87\xa4", [0x7ac1] = "\x87\xa5",
  [0x7ac4] = "\x65\x95", [0x7ac5] = "\x65\x96", [0x7ac7] = "\x67\x42",
  [0x7aca] = "\x68\x5d", [0x7acb] = "\x4d\xa0", [0x7ad1] = "\x6e\xe2",
  [0x7ad8] = "\x71\x82", [0x7ad9] = "\x55\xbb", [0x7adf] = "\x58\xfd",
  [0x7ae0] = "\x58\xfc", [0x7ae3] = "\x5a\xa9", [0x7ae4] = "\x77\xe2",
  [0x7ae5] = "\x5a\xa8", [0x7ae6] = "\x77\xe1", [0x7aeb] = "\x7b\x8d",
  [0x7aed] = "\x5f\x45", [0x7aee] = "\x7e\xd5", [0x7aef] = "\x5f\x46",
  [0x7af6] = "\x67\x43", [0x7af7] = "\x8d\x73", [0x7af9] = "\x4e\x6c",
  [0x7afa] = "\x51\xa9", [0x7afb] = "\x6c\xc7", [0x7afd] = "\x53\x96",
  [0x7aff] = "\x53\x95", [0x7b00] = "\x6e\xe3", [0x7b01] = "\x6e\xe4",
  [0x7b04] = "\x71\x84", [0x7b05] = "\x71\x86", [0x7b06] = "\x55\xbc",
  [0x7b08] = "\x71\x88", [0x7b09] = "\x71\x8b", [0x7b0a] = "\x71\x89",
  [0x7b0e] = "\x71\x8a", [0x7b0f] = "\x71\x87", [0x7b10] = "\x71\x83",
  [0x7b11] = "\x55\xbd", [0x7b12] = "\x71\x8c", [0x7b13] = "\x71\x85",
  [0x7b18] = "\x74\x98", [0x7b19] = "\x58\x6b", [0x7b1a] = "\x74\xa1",
  [0x7b1b] = "\x58\x68", [0x7b1d] = "\x74\x9a", [0x7b1e] = "\x58\x6c",
  [0x7b20] = "\x58\x66", [0x7b22] = "\x74\x95", [0x7b23] = "\x74\xa2",
  [0x7b24] = "\x74\x96", [0x7b25] = "\x74\x93", [0x7b26] = "\x58\x6a",
  [0x7b28] = "\x58\x67", [0x7b2a] = "\x74\x99", [0x7b2b] = "\x74\x9c",
  [0x7b2c] = "\x58\x69", [0x7b2d] = "\x74\x9d", [0x7b2e] = "\x58\x6d",
  [0x7b2f] = "\x74\x9e", [0x7b30] = "\x74\x94", [0x7b31] = "\x74\x9b",
  [0x7b32] = "\x74\x9f", [0x7b33] = "\x74\x97", [0x7b34] = "\x74\x92",
  [0x7b35] = "\x74\x90", [0x7b38] = "\x74\xa0", [0x7b3b] = "\x77\xe4",
  [0x7b40] = "\x77\xe9", [0x7b44] = "\x77\xe5", [0x7b45] = "\x77\xeb",
  [0x7b46] = "\x5a\xac", [0x7b47] = "\x74\x91", [0x7b48] = "\x77\xe6",
  [0x7b49] = "\x5a\xaa", [0x7b4a] = "\x77\xe3", [0x7b4b] = "\x5a\xb1",
  [0x7b4c] = "\x77\xe7", [0x7b4d] = "\x5a\xb0", [0x7b4e] = "\x77\xe8",
  [0x7b4f] = "\x5a\xb2", [0x7b50] = "\x5a\xad", [0x7b51] = "\x5a\xb3",
  [0x7b52] = "\x5a\xae", [0x7b54] = "\x5a\xaf", [0x7b56] = "\x5a\xab",
  [0x7b58] = "\x77\xea", [0x7b60] = "\x5c\xe7", [0x7b61] = "\x7b\x98",
  [0x7b63] = "\x7b\x9b", [0x7b64] = "\x7b\x8f", [0x7b65] = "\x7b\x94",
  [0x7b66] = "\x7b\x8e", [0x7b67] = "\x5c\xe9", [0x7b69] = "\x7b\x92",
  [0x7b6d] = "\x7b\x90", [0x7b6e] = "\x5c\xe8", [0x7b70] = "\x7b\x97",
  [0x7b71] = "\x7b\x96", [0x7b72] = "\x7b\x93", [0x7b73] = "\x7b\x95",
  [0x7b74] = "\x7b\x91", [0x7b75] = "\x5f\x4a", [0x7b76] = "\x7b\x9a",
  [0x7b77] = "\x5c\xe5", [0x7b78] = "\x7b\x99", [0x7b82] = "\x7e\xe5",
  [0x7b84] = "\x5f\x51", [0x7b85] = "\x7e\xe0", [0x7b87] = "\x5f\x50",
  [0x7b88] = "\x7e\xd6", [0x7b8a] = "\x7e\xd8", [0x7b8b] = "\x5f\x49",
  [0x7b8c] = "\x7e\xdd", [0x7b8d] = "\x7e\xdc", [0x7b8e] = "\x7e\xdf",
  [0x7b8f] = "\x5f\x4e", [0x7b90] = "\x7e\xda", [0x7b91] = "\x7e\xd9",
  [0x7b94] = "\x5f\x4d", [0x7b95] = "\x5f\x48", [0x7b96] = "\x7e\xdb",
  [0x7b97] = "\x5f\x4b", [0x7b98] = "\x7e\xe1", [0x7b99] = "\x7e\xe3",
  [0x7b9b] = "\x7e\xde", [0x7b9c] = "\x7e\xd7", [0x7b9d] = "\x5f\x4c",
  [0x7ba0] = "\x61\x53", [0x7ba1] = "\x5f\x47", [0x7ba4] = "\x7e\xe4",
  [0x7bac] = "\x81\xe2", [0x7bad] = "\x61\x4c", [0x7baf] = "\x81\xe4",
  [0x7bb1] = "\x61\x4d", [0x7bb4] = "\x61\x4f", [0x7bb5] = "\x81\xe7",
  [0x7bb7] = "\x81\xdf", [0x7bb8] = "\x5f\x4f", [0x7bb9] = "\x81\xe5",
  [0x7bbe] = "\x81\xe1", [0x7bc0] = "\x5c\xe6", [0x7bc1] = "\x61\x52",
  [0x7bc4] = "\x61\x4e", [0x7bc6] = "\x61\x50", [0x7bc7] = "\x61\x51",
  [0x7bc9] = "\x62\xdf", [0x7bca] = "\x81\xe6", [0x7bcb] = "\x81\xe0",
  [0x7bcc] = "\x61\x54", [0x7bce] = "\x81\xe3", [0x7bd4] = "\x85\x4c",
  [0x7bd5] = "\x85\x47", [0x7bd8] = "\x85\x51", [0x7bd9] = "\x62\xdd",
  [0x7bda] = "\x85\x49", [0x7bdb] = "\x62\xe1", [0x7bdc] = "\x85\x4f",
  [0x7bdd] = "\x85\x46", [0x7bde] = "\x85\x43", [0x7bdf] = "\x85\x52",
  [0x7be0] = "\x64\x7b", [0x7be1] = "\x62\xe2", [0x7be2] = "\x85\x4e",
  [0x7be3] = "\x85\x44", [0x7be4] = "\x62\xe0", [0x7be5] = "\x85\x48",
  [0x7be6] = "\x62\xe4", [0x7be7] = "\x85\x45", [0x7be8] = "\x85\x4a",
  [0x7be9] = "\x62\xe3", [0x7bea] = "\x85\x4d", [0x7beb] = "\x85\x50",
  [0x7bf0] = "\x87\xb7", [0x7bf1] = "\x87\xb8", [0x7bf2] = "\x87\xa8",
  [0x7bf3] = "\x87\xaf", [0x7bf4] = "\x87\xad", [0x7bf7] = "\x64\x79",
  [0x7bf8] = "\x87\xb4", [0x7bf9] = "\x85\x4b", [0x7bfb] = "\x87\xab",
  [0x7bfd] = "\x87\xb5", [0x7bfe] = "\x64\x78", [0x7bff] = "\x87\xaa",
  [0x7c00] = "\x87\xa9", [0x7c01] = "\x87\xb3", [0x7c02] = "\x87\xb0",
  [0x7c03] = "\x87\xb2", [0x7c05] = "\x87\xa6", [0x7c06] = "\x87\xb6",
  [0x7c07] = "\x64\x76", [0x7c09] = "\x87\xb1", [0x7c0a] = "\x87\xba",
  [0x7c0b] = "\x87\xae", [0x7c0c] = "\x64\x7a", [0x7c0d] = "\x64\x77",
  [0x7c0e] = "\x87\xac", [0x7c0f] = "\x87\xa7", [0x7c10] = "\x87\xb9",
  [0x7c11] = "\x62\xde", [0x7c19] = "\x89\xd0", [0x7c1c] = "\x89\xce",
  [0x7c1d] = "\x89\xd4", [0x7c1e] = "\x65\x9a", [0x7c1f] = "\x89\xd2",
  [0x7c20] = "\x89\xd1", [0x7c21] = "\x65\x9c", [0x7c22] = "\x89\xd7",
  [0x7c23] = "\x65\x9b", [0x7c25] = "\x89\xd8", [0x7c26] = "\x89\xd5",
  [0x7c27] = "\x65\x98", [0x7c28] = "\x89\xd6", [0x7c29] = "\x89\xcf",
  [0x7c2a] = "\x65\x99", [0x7c2b] = "\x65\x97", [0x7c2c] = "\x8b\xb8",
  [0x7c2d] = "\x89\xd3", [0x7c30] = "\x89\xd9", [0x7c33] = "\x8b\xb5",
  [0x7c37] = "\x66\x7c", [0x7c38] = "\x66\x7a", [0x7c39] = "\x8b\xb7",
  [0x7c3b] = "\x8b\xb9", [0x7c3c] = "\x8b\xb6", [0x7c3d] = "\x66\x7b",
  [0x7c3e] = "\x66\x78", [0x7c3f] = "\x66\x79", [0x7c40] = "\x66\x7d",
  [0x7c43] = "\x67\x45", [0x7c45] = "\x8d\x78", [0x7c47] = "\x8d\x77",
  [0x7c48] = "\x8d\x75", [0x7c49] = "\x8d\x74", [0x7c4a] = "\x8d\x76",
  [0x7c4c] = "\x67\x44", [0x7c4d] = "\x67\x46", [0x7c50] = "\x67\x9c",
  [0x7c53] = "\x8e\x95", [0x7c54] = "\x8e\x94", [0x7c57] = "\x8f\x8b",
  [0x7c59] = "\x8f\x8d", [0x7c5a] = "\x8f\x8f", [0x7c5b] = "\x8f\x8e",
  [0x7c5c] = "\x8f\x8c", [0x7c5f] = "\x67\xec", [0x7c60] = "\x67\xeb",
  [0x7c63] = "\x68\x5f", [0x7c64] = "\x68\x5e", [0x7c65] = "\x68\x60",
  [0x7c66] = "\x90\x5e", [0x7c67] = "\x90\x5d", [0x7c69] = "\x91\x4d",
  [0x7c6a] = "\x90\xc7", [0x7c6b] = "\x91\x4e", [0x7c6c] = "\x68\xa4",
  [0x7c6e] = "\x68\xa5", [0x7c6f] = "\x91\x7e", [0x7c72] = "\x68\xca",
  [0x7c73] = "\x4e\x6d", [0x7c75] = "\x6c\xc8", [0x7c78] = "\x6e\xe6",
  [0x7c79] = "\x6e\xe7", [0x7c7a] = "\x6e\xe5", [0x7c7d] = "\x53\x97",
  [0x7c7f] = "\x6e\xe8", [0x7c80] = "\x6e\xe9", [0x7c81] = "\x6e\xea",
  [0x7c84] = "\x71\x8d", [0x7c85] = "\x71\x93", [0x7c88] = "\x71\x91",
  [0x7c89] = "\x55\xbe", [0x7c8a] = "\x71\x8f", [0x7c8c] = "\x71\x90",
  [0x7c8d] = "\x71\x92", [0x7c91] = "\x71\x8e", [0x7c92] = "\x58\x6e",
  [0x7c94] = "\x74\xa3", [0x7c95] = "\x58\x70", [0x7c96] = "\x74\xa5",
  [0x7c97] = "\x58\x6f", [0x7c98] = "\x74\xa4", [0x7c9e] = "\x77\xed",
  [0x7c9f] = "\x5a\xb4", [0x7ca1] = "\x77\xef", [0x7ca2] = "\x77\xec",
  [0x7ca3] = "\x74\xa6", [0x7ca5] = "\x5a\xb5", [0x7ca8] = "\x77\xee",
  [0x7caf] = "\x7b\x9e", [0x7cb1] = "\x5c\xea", [0x7cb2] = "\x7b\x9c",
  [0x7cb3] = "\x5c\xeb", [0x7cb4] = "\x7b\x9d", [0x7cb5] = "\x5c\xec",
  [0x7cb9] = "\x5f\x52", [0x7cba] = "\x7e\xe9", [0x7cbb] = "\x7e\xe6",
  [0x7cbc] = "\x7e\xe8", [0x7cbd] = "\x5f\x53", [0x7cbe] = "\x5f\x54",
  [0x7cbf] = "\x7e\xe7", [0x7cc5] = "\x81\xe8", [0x7cc8] = "\x81\xe9",
  [0x7cca] = "\x61\x55", [0x7ccb] = "\x81\xeb", [0x7ccc] = "\x81\xea",
  [0x7cce] = "\x46\xf9", [0x7cd0] = "\x85\x56", [0x7cd1] = "\x85\x57",
  [0x7cd2] = "\x85\x53", [0x7cd4] = "\x85\x54", [0x7cd5] = "\x62\xe5",
  [0x7cd6] = "\x62\xe6", [0x7cd7] = "\x85\x55", [0x7cd9] = "\x64\x82",
  [0x7cdc] = "\x64\x7d", [0x7cdd] = "\x64\x83", [0x7cde] = "\x64\x7e",
  [0x7cdf] = "\x64\x81", [0x7ce0] = "\x64\x7c", [0x7ce2] = "\x64\x7f",
  [0x7ce7] = "\x65\x9d", [0x7ce8] = "\x87\xbb", [0x7cea] = "\x8b\xbb",
  [0x7cec] = "\x8b\xba", [0x7cee] = "\x8d\x79", [0x7cef] = "\x67\x47",
  [0x7cf0] = "\x67\x48", [0x7cf1] = "\x8f\x91", [0x7cf2] = "\x8e\x96",
  [0x7cf4] = "\x8f\x90", [0x7cf6] = "\x91\x4f", [0x7cf7] = "\x91\x94",
  [0x7cf8] = "\x4e\x6e", [0x7cfb] = "\x4f\xb6", [0x7cfd] = "\x6c\xc9",
  [0x7cfe] = "\x51\xaa", [0x7d00] = "\x53\x9a", [0x7d01] = "\x6e\xed",
  [0x7d02] = "\x53\x98", [0x7d03] = "\x6e\xeb", [0x7d04] = "\x53\x9d",
  [0x7d05] = "\x53\x99", [0x7d06] = "\x53\x9e", [0x7d07] = "\x53\x9c",
  [0x7d08] = "\x6e\xec", [0x7d09] = "\x53\x9b", [0x7d0a] = "\x55\xc2",
  [0x7d0b] = "\x55\xc1", [0x7d0c] = "\x71\x9e", [0x7d0d] = "\x55\xca",
  [0x7d0e] = "\x71\x97", [0x7d0f] = "\x71\x9d", [0x7d10] = "\x55\xc6",
  [0x7d11] = "\x71\x96", [0x7d12] = "\x71\x9c", [0x7d13] = "\x71\x9a",
  [0x7d14] = "\x55\xc5", [0x7d15] = "\x55\xc7", [0x7d16] = "\x71\x99",
  [0x7d17] = "\x55\xc0", [0x7d18] = "\x71\x98", [0x7d19] = "\x55\xcb",
  [0x7d1a] = "\x55\xc8", [0x7d1b] = "\x55\xcc", [0x7d1c] = "\x55\xc9",
  [0x7d1d] = "\x71\x95", [0x7d1e] = "\x71\x94", [0x7d1f] = "\x71\x9b",
  [0x7d20] = "\x55\xc3", [0x7d21] = "\x55\xbf", [0x7d22] = "\x55\xc4",
  [0x7d28] = "\x74\xb5", [0x7d29] = "\x74\xae", [0x7d2b] = "\x5a\xba",
  [0x7d2c] = "\x74\xad", [0x7d2e] = "\x58\x74", [0x7d2f] = "\x58\x7b",
  [0x7d30] = "\x58\x78", [0x7d31] = "\x58\x7e", [0x7d32] = "\x58\x7d",
  [0x7d33] = "\x58\x79", [0x7d35] = "\x74\xa7", [0x7d36] = "\x74\xaa",
  [0x7d38] = "\x74\xa9", [0x7d39] = "\x58\x75", [0x7d3a] = "\x74\xab",
  [0x7d3b] = "\x74\xb4", [0x7d3c] = "\x58\x76", [0x7d3d] = "\x74\xa8",
  [0x7d3e] = "\x74\xb1", [0x7d3f] = "\x74\xb2", [0x7d40] = "\x58\x77",
  [0x7d41] = "\x74\xaf", [0x7d42] = "\x58\x7c", [0x7d43] = "\x58\x72",
  [0x7d44] = "\x58\x7a", [0x7d45] = "\x74\xac", [0x7d46] = "\x58\x71",
  [0x7d47] = "\x74\xb0", [0x7d4a] = "\x74\xb3", [0x7d4e] = "\x78\x43",
  [0x7d4f] = "\x77\xf7", [0x7d50] = "\x5a\xb7", [0x7d51] = "\x78\x41",
  [0x7d52] = "\x77\xfb", [0x7d53] = "\x77\xf3", [0x7d54] = "\x77\xfc",
  [0x7d55] = "\x5a\xb9", [0x7d56] = "\x77\xf4", [0x7d58] = "\x77\xf0",
  [0x7d5b] = "\x5c\xf2", [0x7d5c] = "\x77\xf9", [0x7d5e] = "\x5a\xb6",
  [0x7d5f] = "\x78\x42", [0x7d61] = "\x5a\xbd", [0x7d62] = "\x5a\xbf",
  [0x7d63] = "\x77\xf2", [0x7d66] = "\x5a\xbe", [0x7d67] = "\x77\xf5",
  [0x7d68] = "\x5a\xb8", [0x7d69] = "\x77\xfd", [0x7d6a] = "\x77\xf6",
  [0x7d6b] = "\x77\xfa", [0x7d6d] = "\x77\xf8", [0x7d6e] = "\x5a\xbb",
  [0x7d6f] = "\x77\xf1", [0x7d70] = "\x5a\xc0", [0x7d71] = "\x58\x73",
  [0x7d72] = "\x5a\xbc", [0x7d73] = "\x5a\xc1", [0x7d79] = "\x5c\xee",
  [0x7d7a] = "\x7b\xa5", [0x7d7b] = "\x7b\xa7", [0x7d7c] = "\x7b\xa9",
  [0x7d7d] = "\x7b\xad", [0x7d7f] = "\x7b\xa3", [0x7d80] = "\x7b\xa1",
  [0x7d81] = "\x5c\xf0", [0x7d83] = "\x7b\xa8", [0x7d84] = "\x7b\xac",
  [0x7d85] = "\x7b\xa4", [0x7d86] = "\x7b\xa0", [0x7d88] = "\x7b\x9f",
  [0x7d8c] = "\x7b\xaa", [0x7d8d] = "\x7b\xa2", [0x7d8e] = "\x7b\xa6",
  [0x7d8f] = "\x5c\xf1", [0x7d91] = "\x5c\xef", [0x7d92] = "\x7b\xae",
  [0x7d93] = "\x5c\xed", [0x7d94] = "\x7b\xab", [0x7d96] = "\x7e\xfa",
  [0x7d9c] = "\x5f\x57", [0x7d9d] = "\x7e\xf2", [0x7d9e] = "\x61\x62",
  [0x7d9f] = "\x7e\xfc", [0x7da0] = "\x5f\x5a", [0x7da1] = "\x7f\x43",
  [0x7da2] = "\x5f\x60", [0x7da3] = "\x7e\xed", [0x7da6] = "\x7e\xfd",
  [0x7da7] = "\x7e\xea", [0x7da9] = "\x7f\x42", [0x7daa] = "\x7e\xee",
  [0x7dac] = "\x5f\x67", [0x7dad] = "\x5f\x64", [0x7dae] = "\x7f\x41",
  [0x7daf] = "\x7e\xf8", [0x7db0] = "\x5f\x56", [0x7db1] = "\x5f\x5e",
  [0x7db2] = "\x5f\x5d", [0x7db4] = "\x5f\x5c", [0x7db5] = "\x5f\x62",
  [0x7db7] = "\x7e\xeb", [0x7db8] = "\x5f\x63", [0x7db9] = "\x7e\xf9",
  [0x7dba] = "\x5f\x5f", [0x7dbb] = "\x5f\x55", [0x7dbc] = "\x7e\xfb",
  [0x7dbd] = "\x5f\x58", [0x7dbe] = "\x5f\x59", [0x7dbf] = "\x5f\x61",
  [0x7dc0] = "\x7e\xf0", [0x7dc1] = "\x7e\xef", [0x7dc2] = "\x7e\xec",
  [0x7dc4] = "\x7e\xf4", [0x7dc5] = "\x7e\xf1", [0x7dc6] = "\x7e\xf5",
  [0x7dc7] = "\x5f\x66", [0x7dc9] = "\x7f\x44", [0x7dca] = "\x5f\x5b",
  [0x7dcb] = "\x7e\xf6", [0x7dcc] = "\x7e\xf7", [0x7dce] = "\x7e\xf3",
  [0x7dd2] = "\x5f\x65", [0x7dd7] = "\x81\xf0", [0x7dd8] = "\x61\x5a",
  [0x7dd9] = "\x61\x63", [0x7dda] = "\x61\x5f", [0x7ddb] = "\x81\xed",
  [0x7ddd] = "\x61\x5c", [0x7dde] = "\x61\x60", [0x7ddf] = "\x81\xf9",
  [0x7de0] = "\x61\x56", [0x7de1] = "\x81\xf1", [0x7de3] = "\x61\x5e",
  [0x7de6] = "\x81\xf4", [0x7de7] = "\x81\xef", [0x7de8] = "\x61\x5d",
  [0x7de9] = "\x61\x61", [0x7dea] = "\x81\xee", [0x7dec] = "\x61\x5b",
  [0x7dee] = "\x81\xf8", [0x7def] = "\x61\x58", [0x7df0] = "\x81\xf7",
  [0x7df1] = "\x81\xf6", [0x7df2] = "\x61\x64", [0x7df3] = "\x80\xbc",
  [0x7df4] = "\x61\x57", [0x7df6] = "\x81\xf5", [0x7df7] = "\x81\xec",
  [0x7df9] = "\x61\x65", [0x7dfa] = "\x81\xf3", [0x7dfb] = "\x61\x59",
  [0x7e03] = "\x81\xf2", [0x7e08] = "\x62\xe9", [0x7e09] = "\x62\xee",
  [0x7e0a] = "\x62\xe7", [0x7e0b] = "\x85\x64", [0x7e0c] = "\x85\x5b",
  [0x7e0d] = "\x85\x67", [0x7e0e] = "\x85\x5f", [0x7e0f] = "\x85\x65",
  [0x7e10] = "\x62\xef", [0x7e11] = "\x62\xe8", [0x7e12] = "\x85\x58",
  [0x7e13] = "\x85\x5e", [0x7e14] = "\x85\x68", [0x7e15] = "\x85\x61",
  [0x7e16] = "\x85\x66", [0x7e17] = "\x85\x5a", [0x7e1a] = "\x85\x62",
  [0x7e1b] = "\x62\xea", [0x7e1c] = "\x85\x60", [0x7e1d] = "\x62\xed",
  [0x7e1e] = "\x62\xec", [0x7e1f] = "\x85\x5c", [0x7e20] = "\x85\x5d",
  [0x7e21] = "\x85\x59", [0x7e22] = "\x85\x63", [0x7e23] = "\x62\xeb",
  [0x7e24] = "\x85\x6a", [0x7e25] = "\x85\x69", [0x7e29] = "\x87\xc6",
  [0x7e2a] = "\x87\xc2", [0x7e2b] = "\x64\x8a", [0x7e2d] = "\x87\xbc",
  [0x7e2e] = "\x64\x84", [0x7e2f] = "\x64\x94", [0x7e30] = "\x87\xc8",
  [0x7e31] = "\x64\x8c", [0x7e32] = "\x64\x88", [0x7e33] = "\x87\xbf",
  [0x7e34] = "\x64\x8f", [0x7e35] = "\x64\x92", [0x7e36] = "\x87\xca",
  [0x7e37] = "\x64\x87", [0x7e38] = "\x87\xc1", [0x7e39] = "\x64\x90",
  [0x7e3a] = "\x87\xcc", [0x7e3b] = "\x87\xc9", [0x7e3c] = "\x87\xbd",
  [0x7e3d] = "\x64\x8b", [0x7e3e] = "\x64\x85", [0x7e3f] = "\x64\x93",
  [0x7e40] = "\x87\xc4", [0x7e41] = "\x64\x8e", [0x7e42] = "\x87\xbe",
  [0x7e43] = "\x64\x89", [0x7e44] = "\x87\xcb", [0x7e45] = "\x64\x8d",
  [0x7e46] = "\x64\x86", [0x7e47] = "\x87\xc5", [0x7e48] = "\x64\x91",
  [0x7e49] = "\x87\xc3", [0x7e4c] = "\x87\xc7", [0x7e50] = "\x89\xdb",
  [0x7e51] = "\x89\xe1", [0x7e52] = "\x65\xa3", [0x7e53] = "\x89\xe4",
  [0x7e54] = "\x65\x9e", [0x7e55] = "\x65\x9f", [0x7e56] = "\x89\xdc",
  [0x7e57] = "\x89\xe3", [0x7e58] = "\x89\xde", [0x7e59] = "\x65\xa4",
  [0x7e5a] = "\x65\xa1", [0x7e5c] = "\x89\xda", [0x7e5e] = "\x65\xa0",
  [0x7e5f] = "\x89\xe0", [0x7e60] = "\x89\xe2", [0x7e61] = "\x65\xa2",
  [0x7e62] = "\x89\xdf", [0x7e63] = "\x89\xdd", [0x7e68] = "\x8b\xc5",
  [0x7e69] = "\x66\x82", [0x7e6a] = "\x66\x83", [0x7e6b] = "\x66\x7e",
  [0x7e6d] = "\x66\x7f", [0x7e6f] = "\x8b\xc1", [0x7e70] = "\x8b\xbf",
  [0x7e72] = "\x8b\xc3", [0x7e73] = "\x66\x85", [0x7e74] = "\x8b\xc4",
  [0x7e75] = "\x8b\xbd", [0x7e76] = "\x8b\xbc", [0x7e77] = "\x8b\xc0",
  [0x7e78] = "\x8b\xbe", [0x7e79] = "\x66\x81", [0x7e7a] = "\x8b\xc2",
  [0x7e7b] = "\x8d\x7a", [0x7e7c] = "\x67\x4b", [0x7e7d] = "\x67\x4a",
  [0x7e7e] = "\x8d\x7b", [0x7e80] = "\x8d\x7d", [0x7e81] = "\x8d\x7c",
  [0x7e82] = "\x67\x4c", [0x7e86] = "\x8e\x9b", [0x7e87] = "\x8e\x98",
  [0x7e88] = "\x8e\x99", [0x7e8a] = "\x8e\x97", [0x7e8b] = "\x8e\x9a",
  [0x7e8c] = "\x67\x9e", [0x7e8d] = "\x8e\x9c", [0x7e8f] = "\x67\x9d",
  [0x7e91] = "\x8f\x92", [0x7e93] = "\x68\x61", [0x7e94] = "\x68\x63",
  [0x7e95] = "\x90\x5f", [0x7e96] = "\x68\x62", [0x7e97] = "\x90\xc8",
  [0x7e98] = "\x91\x51", [0x7e99] = "\x91\x53", [0x7e9a] = "\x91\x50",
  [0x7e9b] = "\x91\x52", [0x7e9c] = "\x68\xb8", [0x7f36] = "\x4e\x6f",
  [0x7f38] = "\x53\x9f", [0x7f39] = "\x70\xd2", [0x7f3a] = "\x55\xcd",
  [0x7f3d] = "\x58\x7f", [0x7f3e] = "\x78\x44", [0x7f3f] = "\x78\x45",
  [0x7f43] = "\x85\x6b", [0x7f44] = "\x64\x95", [0x7f45] = "\x87\xcd",
  [0x7f48] = "\x65\xa5", [0x7f4a] = "\x8b\xc7", [0x7f4b] = "\x8b\xc6",
  [0x7f4c] = "\x67\x4d", [0x7f4d] = "\x8e\x9d", [0x7f4f] = "\x8f\x93",
  [0x7f50] = "\x68\x85", [0x7f51] = "\x69\xe8", [0x7f54] = "\x51\xab",
  [0x7f55] = "\x4f\xb7", [0x7f58] = "\x6e\xee", [0x7f5b] = "\x71\xa4",
  [0x7f5c] = "\x71\x9f", [0x7f5d] = "\x71\xa3", [0x7f5e] = "\x71\xa1",
  [0x7f5f] = "\x55\xce", [0x7f60] = "\x71\xa2", [0x7f61] = "\x71\xa0",
  [0x7f63] = "\x74\xb6", [0x7f65] = "\x78\x46", [0x7f66] = "\x78\x47",
  [0x7f67] = "\x7b\xb1", [0x7f68] = "\x7b\xb2", [0x7f69] = "\x5c\xf4",
  [0x7f6a] = "\x5c\xf5", [0x7f6b] = "\x7b\xb0", [0x7f6c] = "\x7b\xb3",
  [0x7f6d] = "\x7b\xaf", [0x7f6e] = "\x5c\xf3", [0x7f70] = "\x5f\x68",
  [0x7f72] = "\x5c\xf6", [0x7f73] = "\x7f\x45", [0x7f75] = "\x61\x66",
  [0x7f76] = "\x81\xfa", [0x7f77] = "\x61\x67", [0x7f79] = "\x62\xf0",
  [0x7f7a] = "\x85\x6e", [0x7f7b] = "\x85\x6c", [0x7f7c] = "\x85\x6d",
  [0x7f7d] = "\x87\xd0", [0x7f7e] = "\x87\xcf", [0x7f7f] = "\x87\xce",
  [0x7f83] = "\x8b\xc8", [0x7f85] = "\x66\x84", [0x7f86] = "\x8b\xc9",
  [0x7f87] = "\x8f\x94", [0x7f88] = "\x68\x86", [0x7f89] = "\x90\xc9",
  [0x7f8a] = "\x4e\x70", [0x7f8b] = "\x51\xad", [0x7f8c] = "\x51\xac",
  [0x7f8d] = "\x6e\xf0", [0x7f8e] = "\x53\xa0", [0x7f91] = "\x6e\xef",
  [0x7f92] = "\x71\xa6", [0x7f94] = "\x55\xcf", [0x7f95] = "\x74\xb7",
  [0x7f96] = "\x71\xa5", [0x7f9a] = "\x58\x82", [0x7f9b] = "\x74\xba",
  [0x7f9c] = "\x74\xb8", [0x7f9d] = "\x74\xb9", [0x7f9e] = "\x58\x81",
  [0x7fa0] = "\x78\x49", [0x7fa1] = "\x78\x4a", [0x7fa2] = "\x78\x48",
  [0x7fa4] = "\x5c\xf9", [0x7fa5] = "\x7b\xb5", [0x7fa6] = "\x7b\xb4",
  [0x7fa7] = "\x7b\xb6", [0x7fa8] = "\x5c\xf8", [0x7fa9] = "\x5c\xf7",
  [0x7fac] = "\x81\xfb", [0x7fad] = "\x81\xfd", [0x7faf] = "\x61\x68",
  [0x7fb0] = "\x81\xfc", [0x7fb1] = "\x85\x6f", [0x7fb2] = "\x62\xf1",
  [0x7fb3] = "\x89\xe6", [0x7fb5] = "\x89\xe5", [0x7fb6] = "\x66\x86",
  [0x7fb7] = "\x8b\xca", [0x7fb8] = "\x66\x88", [0x7fb9] = "\x66\x87",
  [0x7fba] = "\x8d\x7e", [0x7fbb] = "\x8e\x9e", [0x7fbc] = "\x67\x9f",
  [0x7fbd] = "\x4e\x71", [0x7fbe] = "\x6e\xf1", [0x7fbf] = "\x53\xa1",
  [0x7fc0] = "\x71\xa9", [0x7fc1] = "\x55\xd1", [0x7fc2] = "\x71\xa8",
  [0x7fc3] = "\x71\xa7", [0x7fc5] = "\x55\xd0", [0x7fc7] = "\x74\xc0",
  [0x7fc9] = "\x74\xc2", [0x7fca] = "\x74\xbb", [0x7fcb] = "\x74\xbc",
  [0x7fcc] = "\x58\x83", [0x7fcd] = "\x74\xbd", [0x7fce] = "\x58\x84",
  [0x7fcf] = "\x74\xc1", [0x7fd0] = "\x74\xbe", [0x7fd1] = "\x74\xbf",
  [0x7fd2] = "\x58\x85", [0x7fd4] = "\x5a\xc3", [0x7fd5] = "\x5a\xc4",
  [0x7fd7] = "\x78\x4b", [0x7fdb] = "\x7b\xb7", [0x7fdc] = "\x7b\xb8",
  [0x7fde] = "\x7f\x49", [0x7fdf] = "\x5f\x6b", [0x7fe0] = "\x5f\x69",
  [0x7fe1] = "\x5f\x6a", [0x7fe2] = "\x7f\x46", [0x7fe3] = "\x7f\x47",
  [0x7fe5] = "\x7f\x48", [0x7fe6] = "\x82\x45", [0x7fe8] = "\x82\x46",
  [0x7fe9] = "\x61\x69", [0x7fea] = "\x82\x43", [0x7feb] = "\x82\x42",
  [0x7fec] = "\x82\x44", [0x7fed] = "\x82\x41", [0x7fee] = "\x62\xf4",
  [0x7fef] = "\x85\x70", [0x7ff0] = "\x62\xf2", [0x7ff1] = "\x62\xf3",
  [0x7ff2] = "\x87\xd2", [0x7ff3] = "\x64\x96", [0x7ff4] = "\x87\xd1",
  [0x7ff5] = "\x89\x55", [0x7ff7] = "\x89\xe7", [0x7ff8] = "\x89\xe8",
  [0x7ff9] = "\x65\xa6", [0x7ffb] = "\x65\xa7", [0x7ffc] = "\x64\x97",
  [0x7ffd] = "\x8b\xcb", [0x7ffe] = "\x8b\xcc", [0x7fff] = "\x8d\x7f",
  [0x8000] = "\x67\x4e", [0x8001] = "\x4e\x72", [0x8003] = "\x4e\x73",
  [0x8004] = "\x53\xa2", [0x8005] = "\x51\xae", [0x8006] = "\x55\xd2",
  [0x8007] = "\x6e\xf2", [0x800b] = "\x5a\xc5", [0x800c] = "\x4e\x74",
  [0x800d] = "\x53\xa4", [0x800e] = "\x6e\xf3", [0x800f] = "\x6e\xf4",
  [0x8010] = "\x53\xa3", [0x8011] = "\x53\xa5", [0x8012] = "\x4e\x75",
  [0x8014] = "\x6e\xf5", [0x8015] = "\x55\xd4", [0x8016] = "\x71\xaa",
  [0x8017] = "\x55\xd6", [0x8018] = "\x55\xd3", [0x8019] = "\x55\xd5",
  [0x801b] = "\x74\xc5", [0x801c] = "\x58\x86", [0x801e] = "\x74\xc4",
  [0x801f] = "\x74\xc3", [0x8021] = "\x7b\xb9", [0x8024] = "\x7f\x4a",
  [0x8026] = "\x61\x6a", [0x8028] = "\x62\xf5", [0x8029] = "\x85\x72",
  [0x802a] = "\x85\x71", [0x802c] = "\x87\xd3", [0x8030] = "\x8e\x9f",
  [0x8033] = "\x4e\x76", [0x8034] = "\x6a\xf3", [0x8035] = "\x6c\xca",
  [0x8036] = "\x53\xa6", [0x8037] = "\x6e\xf6", [0x8039] = "\x71\xac",
  [0x803d] = "\x55\xd7", [0x803e] = "\x71\xab", [0x803f] = "\x55\xd8",
  [0x8043] = "\x74\xc7", [0x8046] = "\x58\x88", [0x8047] = "\x74\xc6",
  [0x8048] = "\x74\xc8", [0x804a] = "\x58\x87", [0x804f] = "\x78\x4d",
  [0x8050] = "\x78\x4e", [0x8051] = "\x78\x4c", [0x8052] = "\x5a\xc6",
  [0x8056] = "\x5c\xfa", [0x8058] = "\x5c\xfb", [0x805a] = "\x5f\x6d",
  [0x805c] = "\x7f\x4c", [0x805d] = "\x7f\x4b", [0x805e] = "\x5f\x6c",
  [0x8064] = "\x82\x47", [0x8067] = "\x82\x48", [0x806c] = "\x85\x73",
  [0x806f] = "\x64\x9b", [0x8070] = "\x64\x9a", [0x8071] = "\x64\x98",
  [0x8072] = "\x64\x99", [0x8073] = "\x64\x9c", [0x8075] = "\x89\xe9",
  [0x8076] = "\x65\xa9", [0x8077] = "\x65\xa8", [0x8078] = "\x8b\xcd",
  [0x8079] = "\x8d\x81", [0x807d] = "\x67\xee", [0x807e] = "\x67\xed",
  [0x807f] = "\x4e\x77", [0x8082] = "\x70\x9f", [0x8084] = "\x5c\xfd",
  [0x8085] = "\x5a\xc7", [0x8086] = "\x5c\xfc", [0x8087] = "\x5f\x6e",
  [0x8089] = "\x4e\x78", [0x808a] = "\x69\x89", [0x808b] = "\x4e\x79",
  [0x808c] = "\x4e\x7a", [0x808f] = "\x6c\xcb", [0x8090] = "\x6a\xf6",
  [0x8092] = "\x6a\xf7", [0x8093] = "\x4f\xb9", [0x8095] = "\x6a\xf4",
  [0x8096] = "\x4f\xb8", [0x8098] = "\x4f\xbb", [0x8099] = "\x6a\xf5",
  [0x809a] = "\x4f\xbd", [0x809b] = "\x4f\xbc", [0x809c] = "\x6a\xf8",
  [0x809d] = "\x4f\xba", [0x80a1] = "\x51\xb3", [0x80a2] = "\x51\xb1",
  [0x80a3] = "\x6c\xcd", [0x80a5] = "\x51\xb0", [0x80a9] = "\x51\xb5",
  [0x80aa] = "\x51\xb7", [0x80ab] = "\x51\xb4", [0x80ad] = "\x6c\xd0",
  [0x80ae] = "\x6c\xcc", [0x80af] = "\x51\xb8", [0x80b1] = "\x51\xb2",
  [0x80b2] = "\x4f\xbe", [0x80b4] = "\x51\xb6", [0x80b5] = "\x6c\xcf",
  [0x80b8] = "\x6c\xce", [0x80ba] = "\x51\xaf", [0x80c2] = "\x6e\xfc",
  [0x80c3] = "\x53\xaa", [0x80c4] = "\x53\xab", [0x80c5] = "\x6f\x41",
  [0x80c7] = "\x6e\xf8", [0x80c8] = "\x6e\xfb", [0x80c9] = "\x6f\x47",
  [0x80ca] = "\x6f\x45", [0x80cc] = "\x53\xac", [0x80cd] = "\x6f\x4b",
  [0x80ce] = "\x53\xaf", [0x80cf] = "\x6f\x48", [0x80d0] = "\x6e\xfd",
  [0x80d1] = "\x6e\xfa", [0x80d4] = "\x78\x50", [0x80d5] = "\x6f\x46",
  [0x80d6] = "\x53\xa7", [0x80d7] = "\x6f\x49", [0x80d8] = "\x6e\xf7",
  [0x80d9] = "\x6f\x43", [0x80da] = "\x53\xa9", [0x80db] = "\x53\xae",
  [0x80dc] = "\x6f\x44", [0x80dd] = "\x53\xb2", [0x80de] = "\x53\xb0",
  [0x80e0] = "\x6e\xf9", [0x80e1] = "\x53\xad", [0x80e3] = "\x6f\x42",
  [0x80e4] = "\x53\xb1", [0x80e5] = "\x53\xa8", [0x80e6] = "\x6f\x4a",
  [0x80ed] = "\x55\xdd", [0x80ef] = "\x55\xe6", [0x80f0] = "\x55\xdb",
  [0x80f1] = "\x55\xd9", [0x80f2] = "\x71\xae", [0x80f3] = "\x55\xe1",
  [0x80f4] = "\x55\xde", [0x80f5] = "\x71\xb0", [0x80f8] = "\x55\xe0",
  [0x80f9] = "\x71\xaf", [0x80fa] = "\x71\xad", [0x80fb] = "\x71\xb2",
  [0x80fc] = "\x55\xe5", [0x80fd] = "\x55\xe3", [0x80fe] = "\x78\x4f",
  [0x8100] = "\x71\xb3", [0x8101] = "\x71\xb1", [0x8102] = "\x55\xda",
  [0x8105] = "\x55\xdc", [0x8106] = "\x55\xdf", [0x8108] = "\x55\xe2",
  [0x810a] = "\x55\xe4", [0x8115] = "\x74\xd2", [0x8116] = "\x58\x8a",
  [0x8118] = "\x74\xc9", [0x8119] = "\x74\xcb", [0x811b] = "\x74\xcc",
  [0x811d] = "\x74\xd4", [0x811e] = "\x74\xd0", [0x811f] = "\x74\xce",
  [0x8121] = "\x74\xd1", [0x8122] = "\x74\xd5", [0x8123] = "\x58\x8b",
  [0x8124] = "\x58\x8f", [0x8125] = "\x74\xca", [0x8127] = "\x74\xd3",
  [0x8129] = "\x58\x8d", [0x812b] = "\x58\x8c", [0x812c] = "\x74\xcf",
  [0x812d] = "\x74\xcd", [0x812f] = "\x58\x89", [0x8130] = "\x58\x8e",
  [0x8139] = "\x5a\xcd", [0x813a] = "\x78\x58", [0x813d] = "\x78\x56",
  [0x813e] = "\x5a\xcf", [0x8143] = "\x78\x51", [0x8144] = "\x7b\xc7",
  [0x8146] = "\x5a\xce", [0x8147] = "\x78\x55", [0x814a] = "\x78\x52",
  [0x814b] = "\x5a\xca", [0x814c] = "\x5a\xd0", [0x814d] = "\x78\x57",
  [0x814e] = "\x5a\xcc", [0x814f] = "\x78\x54", [0x8150] = "\x5f\x6f",
  [0x8151] = "\x5a\xcb", [0x8152] = "\x78\x53", [0x8153] = "\x5a\xd1",
  [0x8154] = "\x5a\xc9", [0x8155] = "\x5a\xc8", [0x815b] = "\x7b\xbf",
  [0x815c] = "\x7b\xbd", [0x815e] = "\x7b\xc3", [0x8160] = "\x7b\xbb",
  [0x8161] = "\x7b\xc8", [0x8162] = "\x7b\xc0", [0x8164] = "\x7b\xba",
  [0x8165] = "\x5d\x44", [0x8166] = "\x5d\x4a", [0x8167] = "\x7b\xc5",
  [0x8169] = "\x7b\xbe", [0x816b] = "\x5d\x47", [0x816e] = "\x5d\x45",
  [0x816f] = "\x7b\xc6", [0x8170] = "\x5d\x42", [0x8171] = "\x5d\x41",
  [0x8172] = "\x7b\xc1", [0x8173] = "\x5d\x46", [0x8174] = "\x5a\xd2",
  [0x8176] = "\x7b\xc4", [0x8177] = "\x7b\xbc", [0x8178] = "\x5d\x43",
  [0x8179] = "\x5d\x48", [0x817a] = "\x5d\x49", [0x817f] = "\x5f\x74",
  [0x8180] = "\x5f\x70", [0x8182] = "\x5f\x75", [0x8183] = "\x7f\x4f",
  [0x8186] = "\x7f\x4e", [0x8187] = "\x7f\x50", [0x8188] = "\x5f\x72",
  [0x8189] = "\x7f\x4d", [0x818a] = "\x5f\x73", [0x818b] = "\x7f\x53",
  [0x818c] = "\x7f\x52", [0x818d] = "\x7f\x51", [0x818f] = "\x5f\x71",
  [0x8195] = "\x82\x4c", [0x8197] = "\x82\x4f", [0x8198] = "\x61\x70",
  [0x8199] = "\x82\x4e", [0x819a] = "\x61\x6f", [0x819b] = "\x61\x6b",
  [0x819c] = "\x61\x6c", [0x819d] = "\x61\x6d", [0x819e] = "\x82\x4b",
  [0x819f] = "\x82\x4a", [0x81a0] = "\x61\x6e", [0x81a2] = "\x82\x4d",
  [0x81a3] = "\x82\x49", [0x81a6] = "\x85\x75", [0x81a7] = "\x85\x7f",
  [0x81a8] = "\x62\xf8", [0x81a9] = "\x62\xf7", [0x81ab] = "\x85\x79",
  [0x81ac] = "\x85\x7b", [0x81ae] = "\x85\x76", [0x81b0] = "\x85\x7a",
  [0x81b1] = "\x85\x74", [0x81b2] = "\x85\x7d", [0x81b3] = "\x62\xf6",
  [0x81b4] = "\x85\x7c", [0x81b5] = "\x85\x78", [0x81b7] = "\x85\x7e",
  [0x81b9] = "\x85\x77", [0x81ba] = "\x64\x9f", [0x81bb] = "\x87\xd4",
  [0x81bc] = "\x87\xda", [0x81bd] = "\x64\xa3", [0x81be] = "\x64\xa5",
  [0x81bf] = "\x64\xa2", [0x81c0] = "\x64\xa1", [0x81c2] = "\x64\xa0",
  [0x81c3] = "\x64\x9e", [0x81c4] = "\x87\xd5", [0x81c5] = "\x87\xd8",
  [0x81c6] = "\x64\x9d", [0x81c7] = "\x87\xd9", [0x81c9] = "\x64\xa4",
  [0x81ca] = "\x87\xd7", [0x81cc] = "\x87\xd6", [0x81cd] = "\x65\xaa",
  [0x81cf] = "\x65\xab", [0x81d0] = "\x89\xec", [0x81d1] = "\x89\xea",
  [0x81d2] = "\x89\xeb", [0x81d5] = "\x8b\xcf", [0x81d7] = "\x8b\xce",
  [0x81d8] = "\x66\x89", [0x81d9] = "\x8d\x83", [0x81da] = "\x67\x4f",
  [0x81db] = "\x8d\x82", [0x81dd] = "\x8e\xa0", [0x81de] = "\x8f\x95",
  [0x81df] = "\x67\xef", [0x81e0] = "\x91\x54", [0x81e1] = "\x91\x55",
  [0x81e2] = "\x68\x64", [0x81e3] = "\x4e\x7b", [0x81e5] = "\x51\xb9",
  [0x81e6] = "\x78\x59", [0x81e7] = "\x5f\x76", [0x81e8] = "\x64\xa6",
  [0x81e9] = "\x87\xdb", [0x81ea] = "\x4e\x7c", [0x81ec] = "\x55\xe8",
  [0x81ed] = "\x55\xe7", [0x81ee] = "\x78\x5a", [0x81f2] = "\x85\x81",
  [0x81f3] = "\x4e\x7d", [0x81f4] = "\x53\xb3", [0x81f7] = "\x78\x5b",
  [0x81f8] = "\x78\x5c", [0x81f9] = "\x78\x5d", [0x81fa] = "\x5f\x77",
  [0x81fb] = "\x62\xf9", [0x81fc] = "\x4e\x7e", [0x81fe] = "\x51\xba",
  [0x81ff] = "\x6f\x4c", [0x8200] = "\x55\xe9", [0x8201] = "\x71\xb4",
  [0x8202] = "\x58\x90", [0x8204] = "\x78\x5e", [0x8205] = "\x5d\x4b",
  [0x8207] = "\x5f\x78", [0x8208] = "\x62\xfa", [0x8209] = "\x64\xa7",
  [0x820a] = "\x65\xac", [0x820b] = "\x8d\x84", [0x820c] = "\x4e\x7f",
  [0x820d] = "\x51\xbb", [0x8210] = "\x55\xea", [0x8211] = "\x74\xd6",
  [0x8212] = "\x5a\xd3", [0x8214] = "\x5f\x79", [0x8215] = "\x7f\x54",
  [0x8216] = "\x82\x50", [0x821b] = "\x4e\x81", [0x821c] = "\x5a\xd4",
  [0x821d] = "\x7b\xc9", [0x821e] = "\x5f\x7a", [0x821f] = "\x4e\x82",
  [0x8220] = "\x6c\xd1", [0x8221] = "\x6f\x4d", [0x8222] = "\x53\xb4",
  [0x8225] = "\x71\xb6", [0x8228] = "\x55\xed", [0x822a] = "\x55\xeb",
  [0x822b] = "\x55\xec", [0x822c] = "\x55\xee", [0x822f] = "\x71\xb5",
  [0x8232] = "\x74\xdb", [0x8233] = "\x74\xd8", [0x8234] = "\x74\xda",
  [0x8235] = "\x58\x91", [0x8236] = "\x58\x93", [0x8237] = "\x58\x92",
  [0x8238] = "\x74\xd7", [0x8239] = "\x58\x94", [0x823a] = "\x74\xd9",
  [0x823c] = "\x78\x5f", [0x823d] = "\x78\x60", [0x823f] = "\x78\x61",
  [0x8240] = "\x7b\xcc", [0x8242] = "\x7b\xcd", [0x8244] = "\x7b\xcb",
  [0x8245] = "\x7b\xce", [0x8247] = "\x5d\x4c", [0x8249] = "\x7b\xca",
  [0x824b] = "\x5f\x7b", [0x824e] = "\x82\x55", [0x824f] = "\x82\x51",
  [0x8250] = "\x82\x54", [0x8251] = "\x82\x56", [0x8252] = "\x82\x53",
  [0x8253] = "\x82\x52", [0x8255] = "\x85\x82", [0x8256] = "\x85\x83",
  [0x8257] = "\x85\x84", [0x8258] = "\x62\xfb", [0x8259] = "\x62\xfc",
  [0x825a] = "\x87\xdd", [0x825b] = "\x87\xdc", [0x825c] = "\x87\xde",
  [0x825e] = "\x89\xee", [0x825f] = "\x89\xed", [0x8261] = "\x8b\xd1",
  [0x8263] = "\x8b\xd2", [0x8264] = "\x8b\xd0", [0x8266] = "\x67\x50",
  [0x8268] = "\x8d\x85", [0x8269] = "\x8d\x86", [0x826b] = "\x8f\x96",
  [0x826c] = "\x90\x60", [0x826d] = "\x90\xca", [0x826e] = "\x4e\x83",
  [0x826f] = "\x4f\xbf", [0x8271] = "\x64\xa8", [0x8272] = "\x4e\x84",
  [0x8274] = "\x74\xdc", [0x8275] = "\x78\x62", [0x8277] = "\x68\x8d",
  [0x8278] = "\x69\xe9", [0x827c] = "\x69\xea", [0x827d] = "\x69\xec",
  [0x827e] = "\x4e\x85", [0x827f] = "\x69\xed", [0x8280] = "\x69\xeb",
  [0x8283] = "\x6b\x43", [0x8284] = "\x6b\x44", [0x8285] = "\x6a\xfb",
  [0x828a] = "\x6b\x42", [0x828b] = "\x4f\xc1", [0x828d] = "\x4f\xc2",
  [0x828e] = "\x6a\xfc", [0x828f] = "\x6a\xfa", [0x8290] = "\x6a\xf9",
  [0x8291] = "\x6a\xfd", [0x8292] = "\x4f\xc0", [0x8293] = "\x6b\x41",
  [0x8294] = "\x6f\x4e", [0x8298] = "\x6c\xd6", [0x8299] = "\x51\xbe",
  [0x829a] = "\x6c\xd5", [0x829b] = "\x6c\xd7", [0x829d] = "\x51\xbd",
  [0x829e] = "\x6c\xdc", [0x829f] = "\x51\xc1", [0x82a0] = "\x6c\xd2",
  [0x82a1] = "\x6c\xe0", [0x82a2] = "\x6c\xe6", [0x82a3] = "\x51\xc8",
  [0x82a4] = "\x6c\xe3", [0x82a5] = "\x51\xc5", [0x82a7] = "\x6c\xd9",
  [0x82a8] = "\x6c\xdf", [0x82a9] = "\x6c\xe1", [0x82ab] = "\x6c\xd4",
  [0x82ac] = "\x51\xc4", [0x82ad] = "\x51\xbf", [0x82ae] = "\x6c\xda",
  [0x82af] = "\x51\xc6", [0x82b0] = "\x51\xc9", [0x82b1] = "\x51\xc3",
  [0x82b3] = "\x51\xbc", [0x82b4] = "\x6c\xde", [0x82b5] = "\x6c\xd8",
  [0x82b6] = "\x6c\xe5", [0x82b7] = "\x51\xcb", [0x82b8] = "\x51\xc7",
  [0x82b9] = "\x51\xc2", [0x82ba] = "\x6c\xdd", [0x82bb] = "\x55\xef",
  [0x82bc] = "\x6c\xdb", [0x82bd] = "\x51\xc0", [0x82be] = "\x51\xca",
  [0x82c0] = "\x6c\xd3", [0x82c2] = "\x6c\xe2", [0x82c3] = "\x6c\xe4",
  [0x82d1] = "\x53\xc5", [0x82d2] = "\x53\xbf", [0x82d3] = "\x53\xc7",
  [0x82d4] = "\x53\xc4", [0x82d5] = "\x6f\x55", [0x82d6] = "\x6f\x58",
  [0x82d7] = "\x53\xc0", [0x82d9] = "\x6f\x4f", [0x82db] = "\x53\xb9",
  [0x82dc] = "\x53\xc3", [0x82de] = "\x53\xc6", [0x82df] = "\x53\xc8",
  [0x82e0] = "\x6f\x64", [0x82e1] = "\x6f\x5b", [0x82e3] = "\x53\xb8",
  [0x82e4] = "\x6f\x63", [0x82e5] = "\x53\xbc", [0x82e6] = "\x53\xba",
  [0x82e7] = "\x53\xb5", [0x82e8] = "\x6f\x53", [0x82ea] = "\x6f\x62",
  [0x82eb] = "\x6f\x57", [0x82ec] = "\x6f\x5a", [0x82ed] = "\x6f\x67",
  [0x82ef] = "\x53\xc9", [0x82f0] = "\x6f\x61", [0x82f1] = "\x53\xc1",
  [0x82f2] = "\x6f\x5c", [0x82f3] = "\x6f\x66", [0x82f4] = "\x6f\x59",
  [0x82f5] = "\x6f\x5d", [0x82f6] = "\x6f\x60", [0x82f9] = "\x6f\x51",
  [0x82fa] = "\x6f\x65", [0x82fb] = "\x6f\x5f", [0x82fe] = "\x6f\x50",
  [0x8300] = "\x6f\x54", [0x8301] = "\x53\xc2", [0x8302] = "\x53\xbd",
  [0x8303] = "\x53\xb6", [0x8304] = "\x53\xbb", [0x8305] = "\x53\xb7",
  [0x8306] = "\x53\xca", [0x8307] = "\x6f\x52", [0x8308] = "\x71\xc7",
  [0x8309] = "\x53\xbe", [0x830c] = "\x6f\x5e", [0x830d] = "\x6d\x63",
  [0x8316] = "\x71\xca", [0x8317] = "\x55\xfd", [0x8319] = "\x71\xba",
  [0x831b] = "\x71\xc5", [0x831c] = "\x71\xc1", [0x831e] = "\x71\xd4",
  [0x8320] = "\x71\xcc", [0x8322] = "\x71\xc2", [0x8324] = "\x71\xcb",
  [0x8325] = "\x71\xbc", [0x8326] = "\x71\xc0", [0x8327] = "\x71\xd7",
  [0x8328] = "\x56\x43", [0x8329] = "\x71\xcf", [0x832a] = "\x71\xc6",
  [0x832b] = "\x55\xf0", [0x832c] = "\x71\xd5", [0x832d] = "\x71\xb8",
  [0x832f] = "\x71\xce", [0x8331] = "\x56\x42", [0x8332] = "\x55\xfa",
  [0x8333] = "\x71\xb7", [0x8334] = "\x55\xf8", [0x8335] = "\x55\xf7",
  [0x8336] = "\x55\xfc", [0x8337] = "\x71\xcd", [0x8338] = "\x55\xf4",
  [0x8339] = "\x55\xfb", [0x833a] = "\x6f\x56", [0x833b] = "\x78\x63",
  [0x833c] = "\x71\xc8", [0x833f] = "\x71\xbe", [0x8340] = "\x56\x41",
  [0x8341] = "\x71\xbf", [0x8342] = "\x71\xc3", [0x8343] = "\x56\x44",
  [0x8344] = "\x71\xb9", [0x8345] = "\x71\xd1", [0x8347] = "\x71\xd0",
  [0x8348] = "\x71\xd8", [0x8349] = "\x55\xf6", [0x834a] = "\x55\xf3",
  [0x834b] = "\x71\xd6", [0x834c] = "\x71\xd2", [0x834d] = "\x71\xc9",
  [0x834e] = "\x71\xc4", [0x834f] = "\x55\xf9", [0x8350] = "\x55\xf5",
  [0x8351] = "\x71\xbb", [0x8352] = "\x55\xf1", [0x8353] = "\x71\xd3",
  [0x8354] = "\x55\xf2", [0x8356] = "\x71\xbd", [0x8373] = "\x74\xe2",
  [0x8374] = "\x74\xe4", [0x8375] = "\x74\xe9", [0x8376] = "\x74\xfd",
  [0x8377] = "\x58\xa2", [0x8378] = "\x58\x98", [0x837a] = "\x74\xe1",
  [0x837b] = "\x58\xa3", [0x837c] = "\x58\xa4", [0x837d] = "\x74\xec",
  [0x837e] = "\x74\xf3", [0x837f] = "\x74\xf9", [0x8381] = "\x74\xe6",
  [0x8383] = "\x74\xed", [0x8386] = "\x58\xa5", [0x8387] = "\x74\xfb",
  [0x8388] = "\x74\xf6", [0x8389] = "\x58\xa0", [0x838a] = "\x58\x9e",
  [0x838b] = "\x74\xf2", [0x838c] = "\x74\xee", [0x838d] = "\x74\xe0",
  [0x838e] = "\x58\x95", [0x838f] = "\x74\xe5", [0x8390] = "\x74\xdd",
  [0x8392] = "\x58\x9d", [0x8393] = "\x58\x9f", [0x8394] = "\x74\xea",
  [0x8395] = "\x74\xe7", [0x8396] = "\x58\x9a", [0x8397] = "\x74\xf7",
  [0x8398] = "\x58\x97", [0x8399] = "\x74\xe8", [0x839a] = "\x75\x41",
  [0x839b] = "\x74\xf0", [0x839d] = "\x74\xef", [0x839e] = "\x58\x96",
  [0x83a0] = "\x58\xa1", [0x83a2] = "\x58\x99", [0x83a3] = "\x74\xde",
  [0x83a4] = "\x74\xe3", [0x83a5] = "\x74\xf4", [0x83a6] = "\x74\xfa",
  [0x83a7] = "\x58\xa6", [0x83a8] = "\x74\xdf", [0x83a9] = "\x74\xeb",
  [0x83aa] = "\x74\xf1", [0x83ab] = "\x58\x9c", [0x83ae] = "\x74\xfc",
  [0x83af] = "\x74\xf5", [0x83b0] = "\x74\xf8", [0x83bd] = "\x58\x9b",
  [0x83bf] = "\x78\x73", [0x83c0] = "\x78\x67", [0x83c1] = "\x5a\xdc",
  [0x83c2] = "\x78\x85", [0x83c3] = "\x78\x8d", [0x83c4] = "\x78\x90",
  [0x83c5] = "\x5a\xda", [0x83c6] = "\x78\x6f", [0x83c7] = "\x78\x89",
  [0x83c8] = "\x78\x70", [0x83c9] = "\x78\x7e", [0x83ca] = "\x5a\xe7",
  [0x83cb] = "\x78\x7a", [0x83cc] = "\x5a\xe4", [0x83ce] = "\x78\x7b",
  [0x83cf] = "\x78\x64", [0x83d1] = "\x78\x8a", [0x83d4] = "\x5a\xed",
  [0x83d5] = "\x78\x87", [0x83d6] = "\x78\x7c", [0x83d7] = "\x78\x92",
  [0x83d8] = "\x78\x77", [0x83d9] = "\x7b\xee", [0x83db] = "\x78\x95",
  [0x83dc] = "\x5a\xeb", [0x83dd] = "\x78\x75", [0x83de] = "\x78\x82",
  [0x83df] = "\x5a\xee", [0x83e0] = "\x5a\xd9", [0x83e1] = "\x78\x79",
  [0x83e2] = "\x78\x93", [0x83e3] = "\x78\x72", [0x83e4] = "\x78\x6b",
  [0x83e5] = "\x78\x76", [0x83e7] = "\x78\x6a", [0x83e8] = "\x78\x68",
  [0x83e9] = "\x5a\xd5", [0x83ea] = "\x78\x8b", [0x83eb] = "\x78\x71",
  [0x83ec] = "\x78\x8e", [0x83ee] = "\x78\x8f", [0x83ef] = "\x5a\xdd",
  [0x83f0] = "\x5a\xe2", [0x83f1] = "\x5a\xde", [0x83f2] = "\x5a\xe6",
  [0x83f3] = "\x78\x86", [0x83f4] = "\x5a\xdf", [0x83f5] = "\x78\x7d",
  [0x83f6] = "\x78\x6d", [0x83f8] = "\x5a\xd7", [0x83f9] = "\x78\x65",
  [0x83fa] = "\x78\x88", [0x83fb] = "\x78\x91", [0x83fc] = "\x78\x6c",
  [0x83fd] = "\x5a\xe5", [0x83fe] = "\x78\x96", [0x83ff] = "\x78\x78",
  [0x8401] = "\x78\x74", [0x8403] = "\x5a\xd6", [0x8404] = "\x5a\xea",
  [0x8406] = "\x78\x84", [0x8407] = "\x5a\xec", [0x8409] = "\x78\x7f",
  [0x840a] = "\x5a\xe1", [0x840b] = "\x5a\xdb", [0x840c] = "\x5a\xe3",
  [0x840d] = "\x5a\xd8", [0x840e] = "\x5a\xe9", [0x840f] = "\x78\x81",
  [0x8410] = "\x78\x6e", [0x8411] = "\x78\x83", [0x8412] = "\x78\x69",
  [0x8413] = "\x78\x8c", [0x841b] = "\x78\x94", [0x8423] = "\x78\x66",
  [0x8429] = "\x7b\xed", [0x842b] = "\x7c\x46", [0x842c] = "\x5c\xdb",
  [0x842d] = "\x7b\xf2", [0x842f] = "\x7b\xf0", [0x8430] = "\x7b\xdb",
  [0x8431] = "\x5d\x50", [0x8432] = "\x7b\xeb", [0x8433] = "\x7c\x42",
  [0x8434] = "\x7b\xe7", [0x8435] = "\x5d\x58", [0x8436] = "\x7c\x41",
  [0x8437] = "\x7b\xe5", [0x8438] = "\x5a\xe8", [0x8439] = "\x7b\xf5",
  [0x843a] = "\x7b\xe6", [0x843b] = "\x7b\xfc", [0x843c] = "\x5d\x57",
  [0x843d] = "\x5d\x4f", [0x843f] = "\x7b\xd0", [0x8440] = "\x7b\xd8",
  [0x8442] = "\x7b\xf1", [0x8443] = "\x7b\xe9", [0x8444] = "\x7c\x45",
  [0x8445] = "\x7b\xec", [0x8446] = "\x5d\x5d", [0x8447] = "\x7b\xfd",
  [0x8449] = "\x5d\x54", [0x844b] = "\x7b\xef", [0x844c] = "\x7b\xf7",
  [0x844d] = "\x7b\xdc", [0x844e] = "\x7b\xf6", [0x8450] = "\x7c\x4a",
  [0x8451] = "\x7b\xd7", [0x8452] = "\x7b\xf8", [0x8454] = "\x7c\x48",
  [0x8456] = "\x7b\xd1", [0x8457] = "\x5a\xe0", [0x8459] = "\x7b\xdf",
  [0x845a] = "\x7b\xde", [0x845b] = "\x5d\x56", [0x845d] = "\x7b\xe2",
  [0x845e] = "\x7b\xe4", [0x845f] = "\x7b\xf3", [0x8460] = "\x7c\x47",
  [0x8461] = "\x5d\x59", [0x8463] = "\x5d\x5a", [0x8465] = "\x7b\xd6",
  [0x8466] = "\x5d\x52", [0x8467] = "\x7b\xda", [0x8468] = "\x7c\x43",
  [0x8469] = "\x5d\x5b", [0x846b] = "\x5d\x53", [0x846c] = "\x5d\x55",
  [0x846d] = "\x5d\x5c", [0x846e] = "\x7c\x49", [0x846f] = "\x7b\xf9",
  [0x8470] = "\x7b\xf4", [0x8473] = "\x7b\xe1", [0x8474] = "\x7b\xe0",
  [0x8475] = "\x5d\x51", [0x8476] = "\x7b\xd2", [0x8477] = "\x5d\x4e",
  [0x8478] = "\x7b\xea", [0x8479] = "\x7b\xd3", [0x847a] = "\x7b\xe8",
  [0x847d] = "\x7b\xdd", [0x847e] = "\x7c\x44", [0x8482] = "\x5d\x4d",
  [0x8486] = "\x7b\xd9", [0x848d] = "\x7b\xd5", [0x848e] = "\x7b\xfb",
  [0x848f] = "\x7b\xd4", [0x8490] = "\x5f\x89", [0x8491] = "\x7f\x7c",
  [0x8494] = "\x7f\x6b", [0x8497] = "\x7f\x55", [0x8498] = "\x7f\x73",
  [0x8499] = "\x5f\x81", [0x849a] = "\x7f\x64", [0x849b] = "\x7f\x6e",
  [0x849c] = "\x5f\x84", [0x849d] = "\x7f\x67", [0x849e] = "\x5f\x82",
  [0x849f] = "\x7f\x58", [0x84a0] = "\x7f\x76", [0x84a1] = "\x7f\x57",
  [0x84a2] = "\x7f\x6a", [0x84a4] = "\x7f\x56", [0x84a7] = "\x7f\x68",
  [0x84a8] = "\x7f\x71", [0x84a9] = "\x7f\x6f", [0x84aa] = "\x7f\x63",
  [0x84ab] = "\x7f\x5e", [0x84ac] = "\x7f\x5c", [0x84ae] = "\x7f\x5d",
  [0x84af] = "\x7f\x70", [0x84b0] = "\x7f\x7b", [0x84b1] = "\x7f\x65",
  [0x84b2] = "\x5f\x83", [0x84b4] = "\x7f\x60", [0x84b6] = "\x7f\x74",
  [0x84b8] = "\x5f\x86", [0x84b9] = "\x7f\x5f", [0x84ba] = "\x7f\x59",
  [0x84bb] = "\x7f\x69", [0x84bc] = "\x5f\x8a", [0x84bf] = "\x5f\x7d",
  [0x84c0] = "\x5f\x87", [0x84c1] = "\x7f\x61", [0x84c2] = "\x7f\x5b",
  [0x84c4] = "\x5f\x7f", [0x84c5] = "\x7b\xfa", [0x84c6] = "\x5f\x7e",
  [0x84c7] = "\x7f\x6c", [0x84c9] = "\x5f\x7c", [0x84ca] = "\x5f\x8c",
  [0x84cb] = "\x5f\x85", [0x84cc] = "\x7f\x6d", [0x84cd] = "\x7f\x62",
  [0x84ce] = "\x7f\x5a", [0x84cf] = "\x7f\x75", [0x84d0] = "\x7f\x66",
  [0x84d1] = "\x5f\x8b", [0x84d2] = "\x7f\x79", [0x84d3] = "\x5f\x88",
  [0x84d4] = "\x7f\x78", [0x84d6] = "\x7f\x72", [0x84d7] = "\x7f\x77",
  [0x84db] = "\x7f\x7a", [0x84e7] = "\x82\x7e", [0x84e8] = "\x82\x7f",
  [0x84e9] = "\x82\x72", [0x84ea] = "\x82\x71", [0x84eb] = "\x82\x6d",
  [0x84ec] = "\x61\x7c", [0x84ee] = "\x61\x74", [0x84ef] = "\x82\x82",
  [0x84f0] = "\x82\x81", [0x84f1] = "\x7b\xcf", [0x84f2] = "\x82\x6a",
  [0x84f3] = "\x82\x6e", [0x84f4] = "\x82\x68", [0x84f6] = "\x82\x7b",
  [0x84f7] = "\x82\x6c", [0x84f9] = "\x82\x83", [0x84fa] = "\x82\x65",
  [0x84fb] = "\x82\x63", [0x84fc] = "\x82\x6f", [0x84fd] = "\x82\x79",
  [0x84fe] = "\x82\x74", [0x84ff] = "\x61\x7e", [0x8500] = "\x82\x5a",
  [0x8502] = "\x82\x78", [0x8506] = "\x61\x7f", [0x8507] = "\x7b\xe3",
  [0x8508] = "\x82\x66", [0x8509] = "\x82\x5d", [0x850a] = "\x82\x60",
  [0x850b] = "\x82\x87", [0x850c] = "\x82\x67", [0x850d] = "\x82\x5e",
  [0x850e] = "\x82\x5c", [0x850f] = "\x82\x59", [0x8511] = "\x61\x78",
  [0x8512] = "\x82\x70", [0x8513] = "\x61\x77", [0x8514] = "\x61\x7b",
  [0x8515] = "\x82\x6b", [0x8516] = "\x82\x73", [0x8517] = "\x61\x71",
  [0x8518] = "\x82\x84", [0x8519] = "\x82\x88", [0x851a] = "\x61\x73",
  [0x851c] = "\x82\x62", [0x851d] = "\x82\x76", [0x851e] = "\x82\x7a",
  [0x851f] = "\x82\x5f", [0x8520] = "\x82\x85", [0x8521] = "\x61\x7a",
  [0x8523] = "\x61\x79", [0x8524] = "\x82\x57", [0x8525] = "\x61\x7d",
  [0x8526] = "\x82\x7d", [0x8527] = "\x82\x61", [0x8528] = "\x82\x75",
  [0x8529] = "\x82\x5b", [0x852a] = "\x82\x69", [0x852b] = "\x82\x64",
  [0x852c] = "\x61\x75", [0x852d] = "\x61\x76", [0x852e] = "\x82\x77",
  [0x852f] = "\x82\x89", [0x8530] = "\x82\x86", [0x8531] = "\x82\x7c",
  [0x853b] = "\x82\x58", [0x853d] = "\x61\x72", [0x853e] = "\x85\x95",
  [0x8540] = "\x85\x8c", [0x8541] = "\x85\x8f", [0x8543] = "\x63\x45",
  [0x8544] = "\x85\x91", [0x8545] = "\x85\x86", [0x8546] = "\x85\x8d",
  [0x8547] = "\x85\x93", [0x8548] = "\x63\x42", [0x8549] = "\x63\x46",
  [0x854a] = "\x62\xfd", [0x854d] = "\x85\x88", [0x854e] = "\x85\x98",
  [0x8551] = "\x85\x92", [0x8553] = "\x85\x89", [0x8554] = "\x85\xa1",
  [0x8555] = "\x85\x9b", [0x8556] = "\x85\x85", [0x8557] = "\x87\xf1",
  [0x8558] = "\x85\x8b", [0x8559] = "\x63\x41", [0x855b] = "\x85\x96",
  [0x855d] = "\x85\xa0", [0x855e] = "\x63\x49", [0x8560] = "\x85\x9d",
  [0x8561] = "\x85\x8a", [0x8562] = "\x85\x90", [0x8563] = "\x85\x94",
  [0x8564] = "\x85\x8e", [0x8565] = "\x85\xa2", [0x8566] = "\x85\x9f",
  [0x8567] = "\x85\x9c", [0x8568] = "\x63\x43", [0x8569] = "\x63\x44",
  [0x856a] = "\x63\x48", [0x856b] = "\x85\x87", [0x856c] = "\x85\xa3",
  [0x856d] = "\x63\x47", [0x856e] = "\x85\x99", [0x8571] = "\x85\x97",
  [0x8575] = "\x85\x9a", [0x8576] = "\x88\x41", [0x8577] = "\x87\xeb",
  [0x8578] = "\x87\xf0", [0x8579] = "\x87\xfd", [0x857a] = "\x87\xef",
  [0x857b] = "\x87\xe7", [0x857c] = "\x87\xec", [0x857e] = "\x64\xab",
  [0x8580] = "\x87\xe0", [0x8581] = "\x87\xf8", [0x8582] = "\x87\xfa",
  [0x8583] = "\x87\xdf", [0x8584] = "\x64\xaa", [0x8585] = "\x87\xfc",
  [0x8586] = "\x87\xf4", [0x8587] = "\x64\xb1", [0x8588] = "\x87\xfb",
  [0x8589] = "\x87\xed", [0x858a] = "\x64\xb3", [0x858b] = "\x87\xe5",
  [0x858c] = "\x85\x9e", [0x858d] = "\x87\xf5", [0x858e] = "\x87\xf2",
  [0x858f] = "\x87\xe1", [0x8590] = "\x88\x43", [0x8591] = "\x64\xad",
  [0x8594] = "\x64\xae", [0x8595] = "\x87\xe3", [0x8596] = "\x87\xf3",
  [0x8598] = "\x88\x42", [0x8599] = "\x87\xf6", [0x859a] = "\x87\xe9",
  [0x859b] = "\x64\xb0", [0x859c] = "\x64\xac", [0x859d] = "\x87\xf7",
  [0x859e] = "\x87\xea", [0x859f] = "\x88\x44", [0x85a0] = "\x87\xe4",
  [0x85a1] = "\x87\xee", [0x85a2] = "\x87\xf9", [0x85a3] = "\x87\xe6",
  [0x85a4] = "\x87\xe8", [0x85a6] = "\x65\xb5", [0x85a7] = "\x87\xe2",
  [0x85a8] = "\x64\xb2", [0x85a9] = "\x65\xae", [0x85aa] = "\x64\xa9",
  [0x85af] = "\x64\xaf", [0x85b0] = "\x65\xb2", [0x85b1] = "\x8a\x41",
  [0x85b3] = "\x89\xf4", [0x85b4] = "\x89\xef", [0x85b5] = "\x89\xf5",
  [0x85b6] = "\x8a\x42", [0x85b7] = "\x8a\x46", [0x85b8] = "\x8a\x45",
  [0x85b9] = "\x65\xb4", [0x85ba] = "\x65\xb3", [0x85bd] = "\x89\xf6",
  [0x85be] = "\x8a\x47", [0x85bf] = "\x89\xf9", [0x85c0] = "\x89\xf1",
  [0x85c2] = "\x89\xf3", [0x85c3] = "\x89\xf2", [0x85c4] = "\x89\xf8",
  [0x85c5] = "\x89\xfd", [0x85c6] = "\x89\xf0", [0x85c7] = "\x89\xf7",
  [0x85c8] = "\x89\xfc", [0x85c9] = "\x65\xb1", [0x85cb] = "\x89\xfa",
  [0x85cd] = "\x65\xaf", [0x85ce] = "\x89\xfb", [0x85cf] = "\x65\xad",
  [0x85d0] = "\x65\xb0", [0x85d1] = "\x8b\xe2", [0x85d2] = "\x8a\x43",
  [0x85d5] = "\x66\x8d", [0x85d7] = "\x8b\xda", [0x85d8] = "\x8b\xde",
  [0x85d9] = "\x8b\xd6", [0x85da] = "\x8b\xd9", [0x85dc] = "\x8b\xe1",
  [0x85dd] = "\x66\x8b", [0x85de] = "\x8b\xe6", [0x85df] = "\x8b\xdf",
  [0x85e1] = "\x8b\xd7", [0x85e2] = "\x8b\xe7", [0x85e3] = "\x8b\xe0",
  [0x85e4] = "\x66\x8e", [0x85e5] = "\x66\x8f", [0x85e6] = "\x8b\xe4",
  [0x85e8] = "\x8b\xd8", [0x85e9] = "\x66\x8a", [0x85ea] = "\x66\x8c",
  [0x85eb] = "\x8b\xd3", [0x85ec] = "\x8b\xdb", [0x85ed] = "\x8b\xd5",
  [0x85ef] = "\x8b\xe5", [0x85f0] = "\x8b\xe3", [0x85f1] = "\x8b\xd4",
  [0x85f2] = "\x8b\xdc", [0x85f6] = "\x8d\x8d", [0x85f7] = "\x66\x90",
  [0x85f8] = "\x8b\xdd", [0x85f9] = "\x67\x52", [0x85fa] = "\x67\x54",
  [0x85fb] = "\x67\x51", [0x85fd] = "\x8d\x92", [0x85fe] = "\x8d\x8a",
  [0x85ff] = "\x8d\x88", [0x8600] = "\x8d\x8c", [0x8601] = "\x8d\x89",
  [0x8604] = "\x8d\x8e", [0x8605] = "\x8d\x90", [0x8606] = "\x67\x55",
  [0x8607] = "\x67\x57", [0x8609] = "\x8d\x8f", [0x860a] = "\x67\x58",
  [0x860b] = "\x67\x56", [0x860c] = "\x8d\x91", [0x8611] = "\x67\x53",
  [0x8617] = "\x67\xa0", [0x8618] = "\x8e\xa1", [0x8619] = "\x8e\xa7",
  [0x861a] = "\x67\xa2", [0x861b] = "\x8d\x8b", [0x861c] = "\x8e\xa6",
  [0x861e] = "\x8e\xad", [0x861f] = "\x8e\xa4", [0x8620] = "\x8e\xab",
  [0x8621] = "\x8e\xaa", [0x8622] = "\x8d\x87", [0x8623] = "\x8e\xa5",
  [0x8624] = "\x8a\x44", [0x8625] = "\x8e\xae", [0x8626] = "\x8e\xa3",
  [0x8627] = "\x8e\xa8", [0x8629] = "\x8e\xac", [0x862a] = "\x8e\xa2",
  [0x862c] = "\x8f\x9a", [0x862d] = "\x67\xa1", [0x862e] = "\x8e\xa9",
  [0x8631] = "\x90\x65", [0x8632] = "\x8f\x9b", [0x8633] = "\x8f\x99",
  [0x8634] = "\x8f\x97", [0x8635] = "\x8f\x98", [0x8636] = "\x8f\x9c",
  [0x8638] = "\x68\x65", [0x8639] = "\x90\x63", [0x863a] = "\x90\x61",
  [0x863b] = "\x90\x66", [0x863c] = "\x90\x64", [0x863e] = "\x90\x67",
  [0x863f] = "\x68\x66", [0x8640] = "\x90\x62", [0x8643] = "\x90\xcb",
  [0x8646] = "\x91\x56", [0x8647] = "\x91\x57", [0x8648] = "\x91\x58",
  [0x864b] = "\x91\xb7", [0x864c] = "\x91\xad", [0x864d] = "\x69\xee",
  [0x864e] = "\x51\xcc", [0x8650] = "\x53\xcb", [0x8652] = "\x71\xda",
  [0x8653] = "\x71\xd9", [0x8654] = "\x56\x45", [0x8655] = "\x58\xa7",
  [0x8656] = "\x75\x43", [0x8659] = "\x75\x42", [0x865b] = "\x5a\xef",
  [0x865c] = "\x5d\x5f", [0x865e] = "\x5d\x5e", [0x865f] = "\x5d\x60",
  [0x8661] = "\x7f\x7d", [0x8662] = "\x82\x8a", [0x8663] = "\x85\xa4",
  [0x8664] = "\x85\xa6", [0x8665] = "\x85\xa5", [0x8667] = "\x64\xb4",
  [0x8668] = "\x88\x45", [0x8669] = "\x8a\x48", [0x866a] = "\x91\x95",
  [0x866b] = "\x4e\x86", [0x866d] = "\x6c\xe9", [0x866e] = "\x6c\xea",
  [0x866f] = "\x6c\xe8", [0x8670] = "\x6c\xe7", [0x8671] = "\x51\xcd",
  [0x8673] = "\x6f\x6b", [0x8674] = "\x6f\x69", [0x8677] = "\x6f\x68",
  [0x8679] = "\x53\xcc", [0x867a] = "\x53\xce", [0x867b] = "\x53\xcd",
  [0x867c] = "\x6f\x6a", [0x8685] = "\x71\xe6", [0x8686] = "\x71\xe3",
  [0x8687] = "\x71\xe1", [0x868a] = "\x56\x46", [0x868b] = "\x71\xe4",
  [0x868c] = "\x56\x4b", [0x868d] = "\x71\xde", [0x868e] = "\x71\xed",
  [0x8690] = "\x71\xef", [0x8691] = "\x71\xdf", [0x8693] = "\x56\x48",
  [0x8694] = "\x71\xf0", [0x8695] = "\x71\xeb", [0x8696] = "\x71\xdd",
  [0x8697] = "\x71\xe2", [0x8698] = "\x71\xec", [0x8699] = "\x71\xe8",
  [0x869a] = "\x71\xe5", [0x869c] = "\x56\x4d", [0x869d] = "\x71\xee",
  [0x869e] = "\x71\xe0", [0x86a1] = "\x71\xe9", [0x86a2] = "\x71\xdb",
  [0x86a3] = "\x56\x4c", [0x86a4] = "\x56\x49", [0x86a5] = "\x71\xe7",
  [0x86a7] = "\x71\xea", [0x86a8] = "\x71\xdc", [0x86a9] = "\x56\x4a",
  [0x86aa] = "\x56\x47", [0x86af] = "\x58\xb1", [0x86b0] = "\x75\x4a",
  [0x86b1] = "\x58\xb0", [0x86b3] = "\x75\x4d", [0x86b4] = "\x75\x50",
  [0x86b5] = "\x58\xad", [0x86b6] = "\x58\xab", [0x86b7] = "\x75\x45",
  [0x86b8] = "\x75\x4e", [0x86b9] = "\x75\x4c", [0x86ba] = "\x75\x49",
  [0x86bb] = "\x75\x51", [0x86bc] = "\x75\x52", [0x86bd] = "\x75\x54",
  [0x86be] = "\x75\x55", [0x86bf] = "\x75\x44", [0x86c0] = "\x58\xaa",
  [0x86c1] = "\x75\x47", [0x86c2] = "\x75\x46", [0x86c3] = "\x75\x53",
  [0x86c4] = "\x58\xac", [0x86c5] = "\x75\x48", [0x86c6] = "\x58\xae",
  [0x86c7] = "\x58\xa9", [0x86c8] = "\x75\x4b", [0x86c9] = "\x58\xb2",
  [0x86cb] = "\x58\xaf", [0x86cc] = "\x75\x4f", [0x86d0] = "\x5a\xf6",
  [0x86d1] = "\x78\xa5", [0x86d3] = "\x78\x9a", [0x86d4] = "\x5a\xf3",
  [0x86d6] = "\x7c\x50", [0x86d7] = "\x78\xa3", [0x86d8] = "\x78\x97",
  [0x86d9] = "\x5a\xf1", [0x86da] = "\x78\x9c", [0x86db] = "\x5a\xf4",
  [0x86dc] = "\x78\xa0", [0x86dd] = "\x78\x9e", [0x86de] = "\x5a\xf7",
  [0x86df] = "\x5a\xf0", [0x86e2] = "\x78\x98", [0x86e3] = "\x78\x9b",
  [0x86e4] = "\x5a\xf5", [0x86e6] = "\x78\x99", [0x86e8] = "\x78\xa4",
  [0x86e9] = "\x78\xa2", [0x86ea] = "\x78\x9d", [0x86eb] = "\x78\x9f",
  [0x86ec] = "\x78\xa1", [0x86ed] = "\x5a\xf2", [0x86f5] = "\x7c\x51",
  [0x86f6] = "\x7c\x57", [0x86f7] = "\x7c\x4d", [0x86f8] = "\x7c\x53",
  [0x86f9] = "\x5d\x61", [0x86fa] = "\x7c\x4f", [0x86fb] = "\x5d\x67",
  [0x86fe] = "\x5d\x66", [0x8700] = "\x5d\x65", [0x8701] = "\x7c\x56",
  [0x8702] = "\x5d\x68", [0x8703] = "\x5d\x69", [0x8704] = "\x7c\x4c",
  [0x8705] = "\x7c\x59", [0x8706] = "\x5d\x6a", [0x8707] = "\x5d\x64",
  [0x8708] = "\x5d\x63", [0x8709] = "\x7c\x55", [0x870a] = "\x5d\x6b",
  [0x870b] = "\x7c\x4b", [0x870c] = "\x7c\x4e", [0x870d] = "\x7c\x58",
  [0x870e] = "\x7c\x54", [0x8711] = "\x7f\x9e", [0x8712] = "\x7f\x93",
  [0x8713] = "\x5d\x62", [0x8718] = "\x5f\x93", [0x8719] = "\x7f\x87",
  [0x871a] = "\x7f\x9c", [0x871b] = "\x7f\x88", [0x871c] = "\x5f\x8e",
  [0x871e] = "\x7f\x85", [0x8720] = "\x7f\x8e", [0x8721] = "\x7f\x86",
  [0x8722] = "\x5f\x90", [0x8723] = "\x7f\x7f", [0x8724] = "\x7f\x9b",
  [0x8725] = "\x5f\x91", [0x8726] = "\x7f\x98", [0x8727] = "\x7f\x99",
  [0x8728] = "\x7f\x81", [0x8729] = "\x5f\x96", [0x872a] = "\x7f\x90",
  [0x872c] = "\x7f\x8a", [0x872d] = "\x7f\x91", [0x872e] = "\x7f\x84",
  [0x8730] = "\x7f\x9d", [0x8731] = "\x7f\x95", [0x8732] = "\x7f\x8f",
  [0x8733] = "\x7f\x7e", [0x8734] = "\x5f\x92", [0x8735] = "\x7f\x96",
  [0x8737] = "\x5f\x95", [0x8738] = "\x7f\x9a", [0x873a] = "\x7f\x94",
  [0x873b] = "\x5f\x8f", [0x873c] = "\x7f\x92", [0x873e] = "\x7f\x8c",
  [0x873f] = "\x5f\x8d", [0x8740] = "\x7f\x83", [0x8741] = "\x7f\x8b",
  [0x8742] = "\x7f\x97", [0x8743] = "\x7f\x89", [0x8746] = "\x7f\x8d",
  [0x874c] = "\x61\x8a", [0x874d] = "\x7c\x52", [0x874e] = "\x82\x9c",
  [0x874f] = "\x82\xa5", [0x8750] = "\x82\x9b", [0x8751] = "\x82\x97",
  [0x8752] = "\x82\x94", [0x8753] = "\x61\x8b", [0x8754] = "\x82\x92",
  [0x8755] = "\x5f\x94", [0x8756] = "\x82\x8b", [0x8757] = "\x61\x89",
  [0x8758] = "\x82\x91", [0x8759] = "\x61\x88", [0x875a] = "\x82\x96",
  [0x875b] = "\x82\x93", [0x875c] = "\x82\xa3", [0x875d] = "\x82\x9e",
  [0x875e] = "\x82\x98", [0x875f] = "\x82\x9d", [0x8760] = "\x61\x84",
  [0x8761] = "\x82\x95", [0x8762] = "\x82\xa8", [0x8763] = "\x82\x8c",
  [0x8764] = "\x82\x8d", [0x8765] = "\x82\xa4", [0x8766] = "\x61\x85",
  [0x8767] = "\x82\xa9", [0x8768] = "\x61\x87", [0x8769] = "\x82\xaa",
  [0x876a] = "\x82\x9a", [0x876b] = "\x7f\x82", [0x876c] = "\x82\xa0",
  [0x876d] = "\x82\x99", [0x876e] = "\x82\xa2", [0x876f] = "\x82\x9f",
  [0x8773] = "\x82\x90", [0x8774] = "\x61\x82", [0x8775] = "\x82\xa7",
  [0x8776] = "\x61\x83", [0x8777] = "\x82\x8e", [0x8778] = "\x61\x86",
  [0x8779] = "\x85\xb0", [0x877a] = "\x82\xa1", [0x877b] = "\x82\xa6",
  [0x8781] = "\x85\xad", [0x8782] = "\x61\x81", [0x8783] = "\x63\x4a",
  [0x8784] = "\x85\xb7", [0x8785] = "\x85\xb3", [0x8787] = "\x85\xb1",
  [0x8788] = "\x85\xac", [0x8789] = "\x85\xbb", [0x878d] = "\x63\x4e",
  [0x878f] = "\x85\xa8", [0x8790] = "\x85\xb4", [0x8791] = "\x85\xb5",
  [0x8792] = "\x85\xab", [0x8793] = "\x85\xaa", [0x8794] = "\x85\xb8",
  [0x8796] = "\x85\xae", [0x8797] = "\x85\xa9", [0x8798] = "\x85\xaf",
  [0x879a] = "\x85\xba", [0x879b] = "\x85\xa7", [0x879c] = "\x85\xb9",
  [0x879d] = "\x85\xb6", [0x879e] = "\x63\x4c", [0x879f] = "\x63\x4b",
  [0x87a2] = "\x63\x4d", [0x87a3] = "\x85\xb2", [0x87a4] = "\x8a\x59",
  [0x87aa] = "\x88\x47", [0x87ab] = "\x64\xba", [0x87ac] = "\x88\x4b",
  [0x87ad] = "\x88\x48", [0x87ae] = "\x88\x4f", [0x87af] = "\x88\x55",
  [0x87b0] = "\x88\x4a", [0x87b2] = "\x88\x5e", [0x87b3] = "\x64\xb7",
  [0x87b4] = "\x88\x58", [0x87b5] = "\x88\x4d", [0x87b6] = "\x88\x59",
  [0x87b7] = "\x88\x54", [0x87b8] = "\x88\x5b", [0x87b9] = "\x88\x4c",
  [0x87ba] = "\x64\xbc", [0x87bb] = "\x64\xbb", [0x87bc] = "\x88\x4e",
  [0x87bd] = "\x88\x5c", [0x87be] = "\x88\x46", [0x87bf] = "\x88\x5a",
  [0x87c0] = "\x64\xb5", [0x87c2] = "\x88\x52", [0x87c3] = "\x88\x51",
  [0x87c4] = "\x88\x56", [0x87c5] = "\x88\x49", [0x87c6] = "\x64\xb9",
  [0x87c8] = "\x64\xbd", [0x87c9] = "\x88\x50", [0x87ca] = "\x88\x57",
  [0x87cb] = "\x64\xbe", [0x87cc] = "\x88\x53", [0x87d1] = "\x64\xb6",
  [0x87d2] = "\x64\xb8", [0x87d3] = "\x8a\x55", [0x87d4] = "\x8a\x53",
  [0x87d7] = "\x8a\x5a", [0x87d8] = "\x8a\x57", [0x87d9] = "\x8a\x5b",
  [0x87db] = "\x8a\x4c", [0x87dc] = "\x8a\x54", [0x87dd] = "\x8a\x5f",
  [0x87de] = "\x88\x5d", [0x87df] = "\x8a\x50", [0x87e0] = "\x65\xb9",
  [0x87e1] = "\x82\x8f", [0x87e2] = "\x8a\x4b", [0x87e3] = "\x8a\x58",
  [0x87e4] = "\x8a\x52", [0x87e5] = "\x8a\x4f", [0x87e6] = "\x8a\x4a",
  [0x87e7] = "\x8a\x49", [0x87e8] = "\x8a\x5e", [0x87ea] = "\x8a\x4e",
  [0x87eb] = "\x8a\x4d", [0x87ec] = "\x65\xb7", [0x87ed] = "\x8a\x56",
  [0x87ef] = "\x65\xb6", [0x87f2] = "\x65\xb8", [0x87f3] = "\x8a\x51",
  [0x87f4] = "\x8a\x5d", [0x87f6] = "\x8b\xeb", [0x87f7] = "\x8b\xec",
  [0x87f9] = "\x66\x94", [0x87fa] = "\x8b\xe9", [0x87fb] = "\x66\x91",
  [0x87fc] = "\x8b\xf1", [0x87fe] = "\x66\x95", [0x87ff] = "\x8b\xf3",
  [0x8800] = "\x8b\xe8", [0x8801] = "\x8a\x5c", [0x8802] = "\x8b\xf5",
  [0x8803] = "\x8b\xea", [0x8805] = "\x66\x92", [0x8806] = "\x8b\xf0",
  [0x8808] = "\x8b\xf2", [0x8809] = "\x8b\xed", [0x880a] = "\x8b\xf4",
  [0x880b] = "\x8b\xef", [0x880c] = "\x8b\xee", [0x880d] = "\x66\x93",
  [0x8810] = "\x8d\x94", [0x8811] = "\x8d\x95", [0x8813] = "\x8d\x97",
  [0x8814] = "\x67\x59", [0x8815] = "\x67\x5a", [0x8816] = "\x8d\x98",
  [0x8817] = "\x8d\x96", [0x8819] = "\x8d\x93", [0x881b] = "\x8e\xb1",
  [0x881c] = "\x8e\xb4", [0x881d] = "\x8e\xb0", [0x881f] = "\x67\xa6",
  [0x8820] = "\x8e\xb2", [0x8821] = "\x67\xa5", [0x8822] = "\x67\xa4",
  [0x8823] = "\x67\xa3", [0x8824] = "\x8e\xb3", [0x8825] = "\x8f\xa1",
  [0x8826] = "\x8f\x9f", [0x8828] = "\x8f\x9e", [0x8829] = "\x8e\xaf",
  [0x882a] = "\x8f\xa0", [0x882b] = "\x8e\xb5", [0x882c] = "\x8f\x9d",
  [0x882e] = "\x90\x6a", [0x882f] = "\x90\x48", [0x8830] = "\x90\x68",
  [0x8831] = "\x68\x67", [0x8832] = "\x90\x69", [0x8833] = "\x90\x6b",
  [0x8835] = "\x90\xce", [0x8836] = "\x68\x87", [0x8837] = "\x90\xcd",
  [0x8838] = "\x90\xcc", [0x8839] = "\x68\x88", [0x883b] = "\x68\xa6",
  [0x883c] = "\x91\x7f", [0x883d] = "\x91\x97", [0x883e] = "\x91\x96",
  [0x883f] = "\x91\x98", [0x8840] = "\x4e\x87", [0x8841] = "\x6f\x6c",
  [0x8843] = "\x71\xf1", [0x8844] = "\x71\xf2", [0x8848] = "\x78\xa6",
  [0x884a] = "\x8e\xb6", [0x884b] = "\x90\xcf", [0x884c] = "\x4e\x88",
  [0x884d] = "\x53\xcf", [0x884e] = "\x6f\x6d", [0x8852] = "\x75\x56",
  [0x8853] = "\x58\xb3", [0x8855] = "\x78\xa8", [0x8856] = "\x78\xa7",
  [0x8857] = "\x5a\xf8", [0x8859] = "\x5d\x6c", [0x885a] = "\x82\xab",
  [0x885b] = "\x61\x8c", [0x885d] = "\x61\x8d", [0x8861] = "\x63\x4f",
  [0x8862] = "\x68\x89", [0x8863] = "\x4e\x89", [0x8867] = "\x6f\x6e",
  [0x8868] = "\x51\xcf", [0x8869] = "\x6f\x70", [0x886a] = "\x6f\x6f",
  [0x886b] = "\x53\xd0", [0x886d] = "\x71\xf3", [0x886f] = "\x71\xfa",
  [0x8870] = "\x56\x4e", [0x8871] = "\x71\xf8", [0x8872] = "\x71\xf6",
  [0x8874] = "\x71\xfd", [0x8875] = "\x71\xf4", [0x8876] = "\x71\xf5",
  [0x8877] = "\x56\x4f", [0x8879] = "\x56\x53", [0x887c] = "\x72\x41",
  [0x887d] = "\x56\x52", [0x887e] = "\x71\xfc", [0x887f] = "\x71\xf9",
  [0x8880] = "\x71\xf7", [0x8881] = "\x56\x50", [0x8882] = "\x56\x51",
  [0x8883] = "\x71\xfb", [0x8888] = "\x58\xb5", [0x8889] = "\x75\x57",
  [0x888b] = "\x58\xba", [0x888c] = "\x75\x67", [0x888d] = "\x58\xb9",
  [0x888e] = "\x75\x69", [0x8891] = "\x75\x5d", [0x8892] = "\x58\xb7",
  [0x8893] = "\x75\x68", [0x8895] = "\x75\x58", [0x8896] = "\x58\xb8",
  [0x8897] = "\x75\x64", [0x8898] = "\x75\x60", [0x8899] = "\x75\x62",
  [0x889a] = "\x75\x5c", [0x889b] = "\x75\x63", [0x889e] = "\x58\xb4",
  [0x889f] = "\x75\x5f", [0x88a1] = "\x75\x5e", [0x88a2] = "\x75\x5a",
  [0x88a4] = "\x75\x65", [0x88a7] = "\x75\x61", [0x88a8] = "\x75\x59",
  [0x88aa] = "\x75\x5b", [0x88ab] = "\x58\xb6", [0x88ac] = "\x75\x66",
  [0x88b1] = "\x5a\xfb", [0x88b2] = "\x78\xb3", [0x88b6] = "\x78\xaf",
  [0x88b7] = "\x78\xb1", [0x88b8] = "\x78\xac", [0x88b9] = "\x78\xab",
  [0x88ba] = "\x78\xa9", [0x88bc] = "\x78\xb0", [0x88bd] = "\x78\xb2",
  [0x88be] = "\x78\xae", [0x88c0] = "\x78\xad", [0x88c1] = "\x5a\xf9",
  [0x88c2] = "\x5a\xfa", [0x88c9] = "\x78\xb5", [0x88ca] = "\x5d\x74",
  [0x88cb] = "\x7c\x5b", [0x88cc] = "\x7c\x61", [0x88cd] = "\x7c\x5c",
  [0x88ce] = "\x7c\x5d", [0x88d0] = "\x7c\x62", [0x88d2] = "\x5d\x76",
  [0x88d4] = "\x5d\x6e", [0x88d5] = "\x5d\x75", [0x88d6] = "\x7c\x5a",
  [0x88d7] = "\x78\xaa", [0x88d8] = "\x5d\x71", [0x88d9] = "\x5d\x6f",
  [0x88da] = "\x7c\x60", [0x88db] = "\x7c\x5f", [0x88dc] = "\x5d\x70",
  [0x88dd] = "\x5d\x72", [0x88de] = "\x7c\x5e", [0x88df] = "\x5d\x6d",
  [0x88e1] = "\x5d\x73", [0x88e7] = "\x7f\xa0", [0x88e8] = "\x5f\x9d",
  [0x88eb] = "\x7f\xab", [0x88ec] = "\x7f\xaa", [0x88ee] = "\x7f\xa5",
  [0x88ef] = "\x5f\x9f", [0x88f0] = "\x7f\xa9", [0x88f1] = "\x7f\xa1",
  [0x88f2] = "\x7f\xa2", [0x88f3] = "\x5f\x97", [0x88f4] = "\x5f\x99",
  [0x88f6] = "\x7f\xa7", [0x88f7] = "\x7f\x9f", [0x88f8] = "\x5f\x9b",
  [0x88f9] = "\x5f\x9a", [0x88fa] = "\x7f\xa3", [0x88fb] = "\x7f\xa8",
  [0x88fc] = "\x7f\xa6", [0x88fd] = "\x5f\x9c", [0x88fe] = "\x7f\xa4",
  [0x8901] = "\x78\xb4", [0x8902] = "\x5f\x98", [0x8905] = "\x82\xac",
  [0x8906] = "\x82\xb3", [0x8907] = "\x61\x8f", [0x8909] = "\x82\xb7",
  [0x890a] = "\x61\x93", [0x890b] = "\x82\xaf", [0x890c] = "\x82\xad",
  [0x890e] = "\x82\xb6", [0x8910] = "\x61\x8e", [0x8911] = "\x82\xb5",
  [0x8912] = "\x61\x90", [0x8913] = "\x61\x91", [0x8914] = "\x82\xae",
  [0x8915] = "\x61\x92", [0x8916] = "\x82\xb4", [0x8917] = "\x82\xb0",
  [0x8918] = "\x82\xb1", [0x8919] = "\x82\xb2", [0x891a] = "\x5f\x9e",
  [0x891e] = "\x85\xbc", [0x891f] = "\x85\xc8", [0x8921] = "\x63\x54",
  [0x8922] = "\x85\xc3", [0x8923] = "\x85\xc5", [0x8925] = "\x63\x52",
  [0x8926] = "\x85\xbd", [0x8927] = "\x85\xc1", [0x8929] = "\x85\xc4",
  [0x892a] = "\x63\x50", [0x892b] = "\x63\x53", [0x892c] = "\x85\xc7",
  [0x892d] = "\x85\xbf", [0x892e] = "\x85\xc0", [0x892f] = "\x85\xc6",
  [0x8930] = "\x85\xbe", [0x8931] = "\x85\xc2", [0x8932] = "\x63\x51",
  [0x8933] = "\x88\x60", [0x8935] = "\x88\x5f", [0x8936] = "\x64\xc0",
  [0x8937] = "\x88\x65", [0x8938] = "\x64\xc2", [0x893b] = "\x64\xbf",
  [0x893c] = "\x88\x61", [0x893d] = "\x64\xc3", [0x893e] = "\x88\x62",
  [0x8941] = "\x88\x63", [0x8942] = "\x88\x66", [0x8944] = "\x64\xc1",
  [0x8946] = "\x8a\x64", [0x8949] = "\x8a\x67", [0x894b] = "\x8a\x61",
  [0x894c] = "\x8a\x63", [0x894f] = "\x8a\x62", [0x8950] = "\x8a\x65",
  [0x8951] = "\x8a\x66", [0x8952] = "\x88\x64", [0x8953] = "\x8a\x60",
  [0x8956] = "\x66\x98", [0x8957] = "\x8b\xf9", [0x8958] = "\x8b\xfc",
  [0x8959] = "\x8c\x41", [0x895a] = "\x8b\xf7", [0x895b] = "\x8b\xf8",
  [0x895c] = "\x8b\xfb", [0x895d] = "\x8b\xfd", [0x895e] = "\x66\x99",
  [0x895f] = "\x66\x97", [0x8960] = "\x66\x96", [0x8961] = "\x8b\xfa",
  [0x8962] = "\x8b\xf6", [0x8963] = "\x8d\x99", [0x8964] = "\x67\x5b",
  [0x8966] = "\x8d\x9a", [0x8969] = "\x8e\xb8", [0x896a] = "\x67\xa7",
  [0x896b] = "\x8e\xba", [0x896c] = "\x67\xa8", [0x896d] = "\x8e\xb7",
  [0x896e] = "\x8e\xb9", [0x896f] = "\x67\xf1", [0x8971] = "\x8f\xa2",
  [0x8972] = "\x67\xf0", [0x8973] = "\x90\x6e", [0x8974] = "\x90\x6d",
  [0x8976] = "\x90\x6c", [0x8979] = "\x91\x59", [0x897a] = "\x91\x5a",
  [0x897b] = "\x91\x5c", [0x897c] = "\x91\x5b", [0x897e] = "\x69\xef",
  [0x897f] = "\x4e\x8a", [0x8981] = "\x53\xd1", [0x8982] = "\x75\x6a",
  [0x8983] = "\x5a\xfc", [0x8985] = "\x7c\x63", [0x8986] = "\x65\xba",
  [0x8988] = "\x8c\x42", [0x898b] = "\x4f\xc3", [0x898f] = "\x58\xbc",
  [0x8993] = "\x58\xbb", [0x8995] = "\x78\xb6", [0x8996] = "\x5a\xfd",
  [0x8997] = "\x78\xb8", [0x8998] = "\x78\xb7", [0x899b] = "\x7c\x64",
  [0x899c] = "\x5d\x77", [0x899d] = "\x7f\xac", [0x899e] = "\x7f\xaf",
  [0x899f] = "\x7f\xae", [0x89a1] = "\x7f\xad", [0x89a2] = "\x82\xb8",
  [0x89a3] = "\x82\xba", [0x89a4] = "\x82\xb9", [0x89a6] = "\x63\x56",
  [0x89aa] = "\x63\x55", [0x89ac] = "\x64\xc4", [0x89ad] = "\x88\x67",
  [0x89ae] = "\x88\x69", [0x89af] = "\x88\x68", [0x89b2] = "\x65\xbb",
  [0x89b6] = "\x8c\x44", [0x89b7] = "\x8c\x43", [0x89b9] = "\x8d\x9b",
  [0x89ba] = "\x67\x5c", [0x89bd] = "\x67\xa9", [0x89be] = "\x8f\xa4",
  [0x89bf] = "\x8f\xa3", [0x89c0] = "\x68\xa7", [0x89d2] = "\x4f\xc4",
  [0x89d3] = "\x6f\x71", [0x89d4] = "\x53\xd2", [0x89d5] = "\x75\x6d",
  [0x89d6] = "\x75\x6b", [0x89d9] = "\x75\x6c", [0x89da] = "\x78\xba",
  [0x89db] = "\x78\xbb", [0x89dc] = "\x7c\x6b", [0x89dd] = "\x78\xb9",
  [0x89df] = "\x7c\x65", [0x89e0] = "\x7c\x69", [0x89e1] = "\x7c\x68",
  [0x89e2] = "\x7c\x6a", [0x89e3] = "\x5d\x78", [0x89e4] = "\x7c\x67",
  [0x89e5] = "\x7c\x66", [0x89e6] = "\x7c\x6c", [0x89e8] = "\x7f\xb2",
  [0x89e9] = "\x7f\xb0", [0x89eb] = "\x7f\xb1", [0x89ec] = "\x82\xbd",
  [0x89ed] = "\x82\xbb", [0x89f0] = "\x82\xbc", [0x89f1] = "\x85\xc9",
  [0x89f2] = "\x88\x6a", [0x89f3] = "\x88\x6b", [0x89f4] = "\x65\xbc",
  [0x89f6] = "\x8c\x45", [0x89f7] = "\x8d\x9c", [0x89f8] = "\x67\x5d",
  [0x89fa] = "\x8e\xbb", [0x89fb] = "\x8f\xa5", [0x89fc] = "\x67\xf2",
  [0x89fe] = "\x90\x6f", [0x89ff] = "\x91\x5d", [0x8a00] = "\x4f\xc5",
  [0x8a02] = "\x53\xd4", [0x8a03] = "\x53\xd5", [0x8a04] = "\x6f\x72",
  [0x8a07] = "\x6f\x73", [0x8a08] = "\x53\xd3", [0x8a0a] = "\x56\x59",
  [0x8a0c] = "\x56\x57", [0x8a0e] = "\x56\x56", [0x8a0f] = "\x56\x5d",
  [0x8a10] = "\x56\x55", [0x8a11] = "\x56\x5e", [0x8a12] = "\x72\x42",
  [0x8a13] = "\x56\x5b", [0x8a15] = "\x56\x58", [0x8a16] = "\x56\x5c",
  [0x8a17] = "\x56\x5a", [0x8a18] = "\x56\x54", [0x8a1b] = "\x58\xc4",
  [0x8a1d] = "\x58\xbe", [0x8a1e] = "\x75\x71", [0x8a1f] = "\x58\xc3",
  [0x8a22] = "\x58\xc5", [0x8a23] = "\x58\xbf", [0x8a25] = "\x58\xc0",
  [0x8a27] = "\x75\x6f", [0x8a2a] = "\x58\xbd", [0x8a2c] = "\x75\x70",
  [0x8a2d] = "\x58\xc2", [0x8a30] = "\x75\x6e", [0x8a31] = "\x58\xc1",
  [0x8a34] = "\x5b\x4b", [0x8a36] = "\x5b\x4d", [0x8a39] = "\x78\xbe",
  [0x8a3a] = "\x5b\x4c", [0x8a3b] = "\x5b\x41", [0x8a3c] = "\x5b\x45",
  [0x8a3e] = "\x5d\x8c", [0x8a3f] = "\x7c\x71", [0x8a40] = "\x78\xc0",
  [0x8a41] = "\x5b\x46", [0x8a44] = "\x78\xc3", [0x8a45] = "\x78\xc4",
  [0x8a46] = "\x5b\x4a", [0x8a48] = "\x78\xc6", [0x8a4a] = "\x78\xc8",
  [0x8a4c] = "\x78\xc9", [0x8a4d] = "\x78\xbd", [0x8a4e] = "\x78\xbc",
  [0x8a4f] = "\x78\xca", [0x8a50] = "\x5b\x49", [0x8a51] = "\x78\xc7",
  [0x8a52] = "\x78\xc5", [0x8a54] = "\x5b\x47", [0x8a55] = "\x5b\x43",
  [0x8a56] = "\x5b\x4e", [0x8a57] = "\x78\xc1", [0x8a58] = "\x78\xc2",
  [0x8a59] = "\x78\xbf", [0x8a5b] = "\x5b\x48", [0x8a5e] = "\x5b\x44",
  [0x8a60] = "\x5b\x42", [0x8a61] = "\x7c\x70", [0x8a62] = "\x5d\x87",
  [0x8a63] = "\x5d\x82", [0x8a66] = "\x5d\x7c", [0x8a68] = "\x5d\x8d",
  [0x8a69] = "\x5d\x7d", [0x8a6b] = "\x5d\x79", [0x8a6c] = "\x5d\x89",
  [0x8a6d] = "\x5d\x86", [0x8a6e] = "\x5d\x88", [0x8a70] = "\x5d\x7e",
  [0x8a71] = "\x5d\x84", [0x8a72] = "\x5d\x7a", [0x8a73] = "\x5d\x7b",
  [0x8a74] = "\x7c\x78", [0x8a75] = "\x7c\x75", [0x8a76] = "\x7c\x6d",
  [0x8a77] = "\x7c\x72", [0x8a79] = "\x5d\x8a", [0x8a7a] = "\x7c\x79",
  [0x8a7b] = "\x5d\x8b", [0x8a7c] = "\x5d\x81", [0x8a7f] = "\x7c\x6f",
  [0x8a81] = "\x7c\x77", [0x8a82] = "\x7c\x73", [0x8a83] = "\x7c\x76",
  [0x8a84] = "\x7c\x74", [0x8a85] = "\x5d\x85", [0x8a86] = "\x7c\x6e",
  [0x8a87] = "\x5d\x7f", [0x8a8b] = "\x7f\xb5", [0x8a8c] = "\x5f\xa1",
  [0x8a8d] = "\x5f\xa4", [0x8a8f] = "\x7f\xb7", [0x8a91] = "\x5f\xac",
  [0x8a92] = "\x7f\xb6", [0x8a93] = "\x5f\xa6", [0x8a95] = "\x61\x98",
  [0x8a96] = "\x7f\xb8", [0x8a98] = "\x5f\xab", [0x8a99] = "\x7f\xb4",
  [0x8a9a] = "\x5f\xad", [0x8a9e] = "\x5f\xa2", [0x8aa0] = "\x5d\x83",
  [0x8aa1] = "\x5f\xa5", [0x8aa3] = "\x5f\xa3", [0x8aa4] = "\x5f\xa7",
  [0x8aa5] = "\x5f\xa9", [0x8aa6] = "\x5f\xa0", [0x8aa7] = "\x5f\xae",
  [0x8aa8] = "\x5f\xaa", [0x8aaa] = "\x5f\xa8", [0x8aab] = "\x7f\xb3",
  [0x8ab0] = "\x61\x9f", [0x8ab2] = "\x61\x9b", [0x8ab6] = "\x61\xa2",
  [0x8ab8] = "\x82\xc0", [0x8ab9] = "\x61\xa3", [0x8aba] = "\x82\xcc",
  [0x8abb] = "\x82\xc5", [0x8abc] = "\x61\x94", [0x8abd] = "\x82\xcd",
  [0x8abe] = "\x82\xc7", [0x8abf] = "\x61\x9e", [0x8ac0] = "\x82\xc8",
  [0x8ac2] = "\x61\x9d", [0x8ac3] = "\x82\xcb", [0x8ac4] = "\x61\x97",
  [0x8ac5] = "\x82\xc9", [0x8ac6] = "\x82\xbf", [0x8ac7] = "\x61\x96",
  [0x8ac8] = "\x85\xd4", [0x8ac9] = "\x61\x9c", [0x8acb] = "\x61\x99",
  [0x8acd] = "\x61\xa1", [0x8acf] = "\x82\xbe", [0x8ad1] = "\x82\xc2",
  [0x8ad2] = "\x61\x95", [0x8ad3] = "\x82\xc1", [0x8ad4] = "\x82\xc3",
  [0x8ad5] = "\x82\xc4", [0x8ad6] = "\x61\xa0", [0x8ad7] = "\x82\xc6",
  [0x8ad8] = "\x82\xca", [0x8ad9] = "\x82\xce", [0x8adb] = "\x61\xa4",
  [0x8adc] = "\x63\x5c", [0x8add] = "\x85\xcf", [0x8ade] = "\x85\xd5",
  [0x8adf] = "\x85\xd2", [0x8ae0] = "\x85\xca", [0x8ae1] = "\x85\xd6",
  [0x8ae2] = "\x85\xcb", [0x8ae4] = "\x85\xd1", [0x8ae6] = "\x63\x57",
  [0x8ae7] = "\x63\x5d", [0x8ae8] = "\x85\xd7", [0x8aeb] = "\x63\x59",
  [0x8aed] = "\x63\x63", [0x8aee] = "\x63\x5e", [0x8aef] = "\x85\xd9",
  [0x8af0] = "\x85\xd3", [0x8af1] = "\x63\x5a", [0x8af2] = "\x85\xcc",
  [0x8af3] = "\x63\x64", [0x8af4] = "\x85\xcd", [0x8af5] = "\x85\xce",
  [0x8af6] = "\x63\x65", [0x8af7] = "\x63\x62", [0x8af8] = "\x61\x9a",
  [0x8afa] = "\x63\x58", [0x8afb] = "\x85\xda", [0x8afc] = "\x63\x66",
  [0x8afe] = "\x63\x5f", [0x8aff] = "\x85\xd8", [0x8b00] = "\x63\x5b",
  [0x8b01] = "\x63\x60", [0x8b02] = "\x63\x61", [0x8b04] = "\x64\xcc",
  [0x8b05] = "\x88\x70", [0x8b06] = "\x88\x79", [0x8b07] = "\x88\x76",
  [0x8b08] = "\x88\x78", [0x8b0a] = "\x64\xc9", [0x8b0b] = "\x88\x71",
  [0x8b0d] = "\x88\x77", [0x8b0e] = "\x64\xc5", [0x8b0f] = "\x88\x73",
  [0x8b10] = "\x64\xcd", [0x8b11] = "\x88\x6f", [0x8b12] = "\x88\x74",
  [0x8b13] = "\x88\x7b", [0x8b14] = "\x85\xd0", [0x8b15] = "\x88\x75",
  [0x8b16] = "\x88\x6e", [0x8b17] = "\x64\xc6", [0x8b18] = "\x88\x6d",
  [0x8b19] = "\x64\xc7", [0x8b1a] = "\x88\x7c", [0x8b1b] = "\x64\xc8",
  [0x8b1c] = "\x88\x7a", [0x8b1d] = "\x64\xcb", [0x8b1e] = "\x88\x6c",
  [0x8b20] = "\x64\xca", [0x8b22] = "\x88\x72", [0x8b23] = "\x8a\x6a",
  [0x8b24] = "\x8a\x78", [0x8b25] = "\x8a\x73", [0x8b26] = "\x8a\x75",
  [0x8b27] = "\x8a\x69", [0x8b28] = "\x65\xbd", [0x8b2a] = "\x8a\x68",
  [0x8b2b] = "\x65\xc0", [0x8b2c] = "\x65\xbf", [0x8b2e] = "\x8a\x77",
  [0x8b2f] = "\x8a\x6f", [0x8b30] = "\x8a\x6c", [0x8b31] = "\x8a\x72",
  [0x8b33] = "\x8a\x6b", [0x8b35] = "\x8a\x6d", [0x8b36] = "\x8a\x76",
  [0x8b37] = "\x8a\x74", [0x8b39] = "\x65\xbe", [0x8b3a] = "\x8a\x7b",
  [0x8b3b] = "\x8a\x79", [0x8b3c] = "\x8a\x70", [0x8b3d] = "\x8a\x7a",
  [0x8b3e] = "\x8a\x71", [0x8b40] = "\x8c\x49", [0x8b41] = "\x66\x9a",
  [0x8b42] = "\x8c\x50", [0x8b45] = "\x8e\xbe", [0x8b46] = "\x66\xa1",
  [0x8b47] = "\x8a\x6e", [0x8b48] = "\x8c\x47", [0x8b49] = "\x66\x9d",
  [0x8b4a] = "\x8c\x48", [0x8b4b] = "\x8c\x4d", [0x8b4e] = "\x66\x9f",
  [0x8b4f] = "\x66\xa0", [0x8b50] = "\x8c\x46", [0x8b51] = "\x8c\x4f",
  [0x8b52] = "\x8c\x51", [0x8b53] = "\x8c\x4a", [0x8b54] = "\x8c\x4c",
  [0x8b55] = "\x8c\x4e", [0x8b56] = "\x8c\x4b", [0x8b57] = "\x8c\x52",
  [0x8b58] = "\x66\x9c", [0x8b59] = "\x66\xa2", [0x8b5a] = "\x66\x9e",
  [0x8b5c] = "\x66\x9b", [0x8b5d] = "\x8d\x9f", [0x8b5f] = "\x67\x62",
  [0x8b60] = "\x8d\x9d", [0x8b63] = "\x8d\xa1", [0x8b65] = "\x8d\xa2",
  [0x8b66] = "\x67\x60", [0x8b67] = "\x8d\xa3", [0x8b68] = "\x8d\xa0",
  [0x8b6a] = "\x8d\x9e", [0x8b6b] = "\x67\x63", [0x8b6c] = "\x67\x5f",
  [0x8b6d] = "\x8d\xa4", [0x8b6f] = "\x67\x61", [0x8b70] = "\x67\x5e",
  [0x8b74] = "\x67\xaa", [0x8b77] = "\x67\xab", [0x8b78] = "\x8e\xbd",
  [0x8b79] = "\x8e\xbc", [0x8b7a] = "\x8e\xbf", [0x8b7b] = "\x8e\xc0",
  [0x8b7d] = "\x67\xac", [0x8b7e] = "\x8f\xa6", [0x8b7f] = "\x8f\xab",
  [0x8b80] = "\x67\xf3", [0x8b82] = "\x8f\xa8", [0x8b84] = "\x8f\xa7",
  [0x8b85] = "\x8f\xaa", [0x8b86] = "\x8f\xa9", [0x8b88] = "\x90\x73",
  [0x8b8a] = "\x68\x68", [0x8b8b] = "\x90\x72", [0x8b8c] = "\x90\x70",
  [0x8b8e] = "\x90\x71", [0x8b92] = "\x68\x8b", [0x8b93] = "\x68\x8a",
  [0x8b94] = "\x90\xd0", [0x8b95] = "\x90\xd1", [0x8b96] = "\x68\x8c",
  [0x8b98] = "\x91\x5e", [0x8b99] = "\x91\x5f", [0x8b9a] = "\x68\xb3",
  [0x8b9c] = "\x68\xb9", [0x8b9e] = "\x91\x99", [0x8b9f] = "\x91\xb8",
  [0x8c37] = "\x4f\xc6", [0x8c39] = "\x75\x72", [0x8c3b] = "\x75\x73",
  [0x8c3c] = "\x7c\x7a", [0x8c3d] = "\x7f\xb9", [0x8c3e] = "\x82\xcf",
  [0x8c3f] = "\x64\xcf", [0x8c41] = "\x64\xce", [0x8c42] = "\x8a\x7c",
  [0x8c43] = "\x8c\x53", [0x8c45] = "\x90\x74", [0x8c46] = "\x4f\xc7",
  [0x8c47] = "\x72\x43", [0x8c48] = "\x56\x5f", [0x8c49] = "\x58\xc6",
  [0x8c4a] = "\x7c\x7c", [0x8c4b] = "\x7c\x7b", [0x8c4c] = "\x61\xa5",
  [0x8c4d] = "\x82\xd0", [0x8c4e] = "\x61\xa6", [0x8c4f] = "\x88\x7d",
  [0x8c50] = "\x65\xc1", [0x8c54] = "\x68\xc2", [0x8c55] = "\x4f\xc8",
  [0x8c56] = "\x6c\xeb", [0x8c57] = "\x72\x44", [0x8c5a] = "\x58\xc7",
  [0x8c5c] = "\x75\x74", [0x8c5d] = "\x75\x75", [0x8c5f] = "\x78\xcb",
  [0x8c61] = "\x5b\x4f", [0x8c62] = "\x5d\x8e", [0x8c64] = "\x7c\x7e",
  [0x8c65] = "\x7c\x7d", [0x8c66] = "\x7c\x7f", [0x8c68] = "\x7f\xba",
  [0x8c69] = "\x7f\xbb", [0x8c6a] = "\x5f\xaf", [0x8c6b] = "\x63\x67",
  [0x8c6c] = "\x61\xa7", [0x8c6d] = "\x63\x68", [0x8c6f] = "\x88\x82",
  [0x8c70] = "\x88\x7e", [0x8c71] = "\x88\x81", [0x8c72] = "\x88\x7f",
  [0x8c73] = "\x64\xd0", [0x8c75] = "\x8a\x7d", [0x8c76] = "\x8c\x55",
  [0x8c77] = "\x8c\x54", [0x8c78] = "\x6b\x45", [0x8c79] = "\x56\x61",
  [0x8c7a] = "\x56\x60", [0x8c7b] = "\x72\x45", [0x8c7d] = "\x75\x76",
  [0x8c80] = "\x78\xcd", [0x8c81] = "\x78\xcc", [0x8c82] = "\x5b\x50",
  [0x8c84] = "\x7c\x82", [0x8c85] = "\x7c\x83", [0x8c86] = "\x7c\x81",
  [0x8c89] = "\x5d\x90", [0x8c8a] = "\x5d\x8f", [0x8c8c] = "\x5f\xb1",
  [0x8c8d] = "\x5f\xb0", [0x8c8f] = "\x82\xd1", [0x8c90] = "\x85\xdd",
  [0x8c91] = "\x85\xdb", [0x8c92] = "\x85\xdc", [0x8c93] = "\x63\x69",
  [0x8c94] = "\x88\x84", [0x8c95] = "\x88\x83", [0x8c97] = "\x8a\x81",
  [0x8c98] = "\x8a\x7f", [0x8c99] = "\x8a\x7e", [0x8c9a] = "\x8c\x56",
  [0x8c9c] = "\x91\x9a", [0x8c9d] = "\x4f\xc9", [0x8c9e] = "\x53\xd6",
  [0x8ca0] = "\x53\xd7", [0x8ca1] = "\x56\x62", [0x8ca2] = "\x56\x63",
  [0x8ca3] = "\x72\x47", [0x8ca4] = "\x72\x46", [0x8ca5] = "\x75\x77",
  [0x8ca7] = "\x58\xcd", [0x8ca8] = "\x58\xcb", [0x8ca9] = "\x58\xc8",
  [0x8caa] = "\x58\xcc", [0x8cab] = "\x58\xca", [0x8cac] = "\x58\xc9",
  [0x8caf] = "\x5b\x51", [0x8cb0] = "\x78\xd0", [0x8cb2] = "\x5d\x95",
  [0x8cb3] = "\x5b\x53", [0x8cb4] = "\x5b\x58", [0x8cb5] = "\x78\xd2",
  [0x8cb6] = "\x5b\x5a", [0x8cb7] = "\x5b\x59", [0x8cb8] = "\x5b\x5c",
  [0x8cb9] = "\x78\xd1", [0x8cba] = "\x78\xce", [0x8cbb] = "\x5b\x56",
  [0x8cbc] = "\x5b\x52", [0x8cbd] = "\x5b\x54", [0x8cbe] = "\x78\xcf",
  [0x8cbf] = "\x5b\x5b", [0x8cc0] = "\x5b\x57", [0x8cc1] = "\x5b\x55",
  [0x8cc2] = "\x5d\x97", [0x8cc3] = "\x5d\x96", [0x8cc4] = "\x5d\x94",
  [0x8cc5] = "\x5d\x98", [0x8cc7] = "\x5d\x92", [0x8cc8] = "\x5d\x93",
  [0x8cca] = "\x5d\x91", [0x8ccc] = "\x7c\x84", [0x8ccf] = "\x7f\xbd",
  [0x8cd1] = "\x5f\xb3", [0x8cd2] = "\x5f\xb4", [0x8cd3] = "\x5f\xb2",
  [0x8cd5] = "\x7f\xbc", [0x8cd7] = "\x7f\xbe", [0x8cd9] = "\x82\xd4",
  [0x8cda] = "\x82\xd6", [0x8cdc] = "\x61\xb0", [0x8cdd] = "\x82\xd7",
  [0x8cde] = "\x61\xa9", [0x8cdf] = "\x82\xd3", [0x8ce0] = "\x61\xa8",
  [0x8ce1] = "\x61\xb2", [0x8ce2] = "\x61\xae", [0x8ce3] = "\x61\xaf",
  [0x8ce4] = "\x61\xab", [0x8ce5] = "\x82\xd2", [0x8ce6] = "\x61\xaa",
  [0x8ce7] = "\x82\xd8", [0x8ce8] = "\x82\xd5", [0x8cea] = "\x61\xb1",
  [0x8cec] = "\x61\xac", [0x8ced] = "\x61\xad", [0x8cee] = "\x85\xdf",
  [0x8cf0] = "\x85\xe1", [0x8cf1] = "\x85\xe0", [0x8cf3] = "\x85\xe2",
  [0x8cf4] = "\x63\x6a", [0x8cf5] = "\x85\xde", [0x8cf8] = "\x64\xd4",
  [0x8cf9] = "\x88\x85", [0x8cfa] = "\x64\xd1", [0x8cfb] = "\x64\xd5",
  [0x8cfc] = "\x64\xd3", [0x8cfd] = "\x64\xd2", [0x8cfe] = "\x8a\x82",
  [0x8d00] = "\x8a\x85", [0x8d02] = "\x8a\x84", [0x8d04] = "\x8a\x83",
  [0x8d05] = "\x65\xc2", [0x8d06] = "\x8c\x57", [0x8d07] = "\x8c\x58",
  [0x8d08] = "\x66\xa3", [0x8d09] = "\x8c\x59", [0x8d0a] = "\x66\xa4",
  [0x8d0d] = "\x67\x65", [0x8d0f] = "\x67\x64", [0x8d10] = "\x8e\xc1",
  [0x8d13] = "\x67\xad", [0x8d14] = "\x8e\xc2", [0x8d15] = "\x8f\xac",
  [0x8d16] = "\x67\xf4", [0x8d17] = "\x67\xf5", [0x8d19] = "\x90\x75",
  [0x8d1b] = "\x68\x8e", [0x8d64] = "\x4f\xca", [0x8d66] = "\x58\xcf",
  [0x8d67] = "\x58\xce", [0x8d68] = "\x7c\x85", [0x8d69] = "\x7c\x86",
  [0x8d6b] = "\x5f\xb5", [0x8d6c] = "\x85\xe3", [0x8d6d] = "\x61\xb3",
  [0x8d6e] = "\x85\xe4", [0x8d6f] = "\x88\x86", [0x8d70] = "\x4f\xcb",
  [0x8d72] = "\x6f\x74", [0x8d73] = "\x53\xd9", [0x8d74] = "\x53\xd8",
  [0x8d76] = "\x72\x48", [0x8d77] = "\x56\x64", [0x8d78] = "\x72\x49",
  [0x8d79] = "\x75\x7a", [0x8d7b] = "\x75\x79", [0x8d7d] = "\x75\x78",
  [0x8d80] = "\x78\xd4", [0x8d81] = "\x5b\x5f", [0x8d84] = "\x78\xd3",
  [0x8d85] = "\x5b\x5e", [0x8d89] = "\x78\xd5", [0x8d8a] = "\x5b\x5d",
  [0x8d8c] = "\x7c\x88", [0x8d8d] = "\x7c\x8b", [0x8d8e] = "\x7c\x89",
  [0x8d8f] = "\x7c\x8a", [0x8d90] = "\x7c\x8e", [0x8d91] = "\x7c\x87",
  [0x8d92] = "\x7c\x8f", [0x8d93] = "\x7c\x8c", [0x8d94] = "\x7c\x8d",
  [0x8d95] = "\x5f\xb7", [0x8d96] = "\x7f\xbf", [0x8d99] = "\x5f\xb6",
  [0x8d9b] = "\x82\xdc", [0x8d9c] = "\x82\xda", [0x8d9f] = "\x61\xb4",
  [0x8da0] = "\x82\xd9", [0x8da1] = "\x82\xdb", [0x8da3] = "\x61\xb5",
  [0x8da5] = "\x85\xe5", [0x8da7] = "\x85\xe6", [0x8da8] = "\x64\xd6",
  [0x8daa] = "\x8c\x5b", [0x8dab] = "\x8c\x5d", [0x8dac] = "\x8c\x5a",
  [0x8dad] = "\x8c\x5c", [0x8dae] = "\x8d\xa5", [0x8daf] = "\x8e\xc3",
  [0x8db2] = "\x91\x81", [0x8db3] = "\x4f\xcc", [0x8db4] = "\x53\xda",
  [0x8db5] = "\x72\x4a", [0x8db6] = "\x72\x4c", [0x8db7] = "\x72\x4b",
  [0x8db9] = "\x75\x7d", [0x8dba] = "\x58\xd1", [0x8dbc] = "\x75\x7b",
  [0x8dbe] = "\x58\xd0", [0x8dbf] = "\x75\x7e", [0x8dc1] = "\x75\x7f",
  [0x8dc2] = "\x75\x7c", [0x8dc5] = "\x78\xe1", [0x8dc6] = "\x5b\x67",
  [0x8dc7] = "\x78\xd9", [0x8dc8] = "\x78\xdf", [0x8dcb] = "\x5b\x62",
  [0x8dcc] = "\x5b\x65", [0x8dcd] = "\x78\xd8", [0x8dce] = "\x5b\x60",
  [0x8dcf] = "\x78\xdc", [0x8dd0] = "\x7c\x95", [0x8dd1] = "\x5b\x64",
  [0x8dd3] = "\x78\xd7", [0x8dd5] = "\x78\xdd", [0x8dd6] = "\x78\xda",
  [0x8dd7] = "\x78\xe0", [0x8dd8] = "\x78\xd6", [0x8dd9] = "\x78\xde",
  [0x8dda] = "\x5b\x63", [0x8ddb] = "\x5b\x66", [0x8ddc] = "\x78\xdb",
  [0x8ddd] = "\x5b\x61", [0x8ddf] = "\x5d\x9a", [0x8de0] = "\x7c\x91",
  [0x8de1] = "\x5d\x99", [0x8de2] = "\x7c\x98", [0x8de3] = "\x7c\x97",
  [0x8de4] = "\x5d\xa0", [0x8de6] = "\x5d\xa1", [0x8de7] = "\x7c\x99",
  [0x8de8] = "\x5d\x9b", [0x8de9] = "\x7c\x96", [0x8dea] = "\x5d\x9f",
  [0x8deb] = "\x7c\x9b", [0x8dec] = "\x7c\x92", [0x8dee] = "\x7c\x94",
  [0x8def] = "\x5d\x9c", [0x8df0] = "\x7c\x90", [0x8df1] = "\x7c\x93",
  [0x8df2] = "\x7c\x9a", [0x8df3] = "\x5d\x9d", [0x8df4] = "\x7c\x9c",
  [0x8dfa] = "\x5d\x9e", [0x8dfc] = "\x5f\xb8", [0x8dfd] = "\x7f\xc4",
  [0x8dfe] = "\x7f\xca", [0x8dff] = "\x7f\xc2", [0x8e00] = "\x7f\xcb",
  [0x8e02] = "\x7f\xc1", [0x8e03] = "\x7f\xc6", [0x8e04] = "\x7f\xcc",
  [0x8e05] = "\x7f\xc9", [0x8e06] = "\x7f\xc8", [0x8e07] = "\x7f\xc7",
  [0x8e09] = "\x7f\xc0", [0x8e0a] = "\x7f\xc5", [0x8e0d] = "\x7f\xc3",
  [0x8e0f] = "\x61\xba", [0x8e10] = "\x61\xb7", [0x8e11] = "\x82\xe5",
  [0x8e12] = "\x82\xea", [0x8e13] = "\x82\xec", [0x8e14] = "\x82\xe9",
  [0x8e15] = "\x82\xe2", [0x8e16] = "\x82\xe4", [0x8e17] = "\x82\xee",
  [0x8e18] = "\x82\xeb", [0x8e19] = "\x82\xe6", [0x8e1a] = "\x82\xef",
  [0x8e1b] = "\x82\xe3", [0x8e1c] = "\x82\xed", [0x8e1d] = "\x61\xb8",
  [0x8e1e] = "\x61\xbe", [0x8e1f] = "\x61\xbc", [0x8e20] = "\x82\xdd",
  [0x8e21] = "\x61\xbd", [0x8e22] = "\x61\xb9", [0x8e23] = "\x82\xde",
  [0x8e24] = "\x82\xe0", [0x8e25] = "\x82\xdf", [0x8e26] = "\x82\xe7",
  [0x8e27] = "\x82\xe8", [0x8e29] = "\x61\xbb", [0x8e2b] = "\x61\xb6",
  [0x8e2e] = "\x82\xe1", [0x8e30] = "\x85\xf0", [0x8e31] = "\x63\x6c",
  [0x8e33] = "\x85\xe7", [0x8e34] = "\x63\x6d", [0x8e35] = "\x63\x70",
  [0x8e36] = "\x85\xec", [0x8e38] = "\x85\xe9", [0x8e39] = "\x63\x6f",
  [0x8e3c] = "\x85\xed", [0x8e3d] = "\x85\xee", [0x8e3e] = "\x85\xe8",
  [0x8e3f] = "\x85\xf1", [0x8e40] = "\x85\xea", [0x8e41] = "\x85\xef",
  [0x8e42] = "\x63\x6e", [0x8e44] = "\x63\x6b", [0x8e45] = "\x85\xeb",
  [0x8e47] = "\x88\x8c", [0x8e48] = "\x64\xd9", [0x8e49] = "\x64\xd7",
  [0x8e4a] = "\x64\xda", [0x8e4b] = "\x64\xd8", [0x8e4c] = "\x88\x8b",
  [0x8e4d] = "\x88\x88", [0x8e4e] = "\x88\x87", [0x8e50] = "\x88\x8a",
  [0x8e53] = "\x88\x89", [0x8e54] = "\x8a\x93", [0x8e55] = "\x65\xc8",
  [0x8e56] = "\x8a\x8a", [0x8e57] = "\x8a\x89", [0x8e59] = "\x65\xc3",
  [0x8e5a] = "\x8a\x8f", [0x8e5b] = "\x8a\x8e", [0x8e5c] = "\x8a\x86",
  [0x8e5d] = "\x8a\x91", [0x8e5e] = "\x8a\x8b", [0x8e5f] = "\x65\xc7",
  [0x8e60] = "\x8a\x88", [0x8e61] = "\x8a\x90", [0x8e62] = "\x8a\x87",
  [0x8e63] = "\x65\xc4", [0x8e64] = "\x65\xc6", [0x8e65] = "\x8a\x8c",
  [0x8e66] = "\x65\xc5", [0x8e67] = "\x8a\x8d", [0x8e69] = "\x8a\x92",
  [0x8e6a] = "\x8c\x61", [0x8e6c] = "\x66\xa9", [0x8e6d] = "\x8c\x5e",
  [0x8e6f] = "\x8c\x62", [0x8e72] = "\x66\xa6", [0x8e73] = "\x8c\x60",
  [0x8e74] = "\x66\xab", [0x8e76] = "\x66\xa8", [0x8e78] = "\x8c\x5f",
  [0x8e7a] = "\x66\xaa", [0x8e7b] = "\x8c\x63", [0x8e7c] = "\x66\xa5",
  [0x8e81] = "\x67\x67", [0x8e82] = "\x67\x69", [0x8e84] = "\x8d\xa8",
  [0x8e85] = "\x67\x68", [0x8e86] = "\x8d\xa6", [0x8e87] = "\x66\xa7",
  [0x8e88] = "\x8d\xa7", [0x8e89] = "\x67\x66", [0x8e8a] = "\x67\xae",
  [0x8e8b] = "\x67\xb0", [0x8e8c] = "\x8e\xc5", [0x8e8d] = "\x67\xaf",
  [0x8e8e] = "\x8e\xc4", [0x8e90] = "\x8f\xb1", [0x8e91] = "\x67\xf6",
  [0x8e92] = "\x8f\xb0", [0x8e93] = "\x67\xf7", [0x8e94] = "\x8f\xae",
  [0x8e95] = "\x8f\xad", [0x8e96] = "\x8f\xb2", [0x8e97] = "\x8f\xb3",
  [0x8e98] = "\x90\x76", [0x8e9a] = "\x8f\xaf", [0x8e9d] = "\x90\xd5",
  [0x8e9e] = "\x90\xd2", [0x8e9f] = "\x90\xd3", [0x8ea0] = "\x90\xd4",
  [0x8ea1] = "\x68\xa8", [0x8ea3] = "\x91\x62", [0x8ea4] = "\x91\x61",
  [0x8ea5] = "\x91\x60", [0x8ea6] = "\x91\x82", [0x8ea8] = "\x91\xae",
  [0x8ea9] = "\x91\x9b", [0x8eaa] = "\x68\xba", [0x8eab] = "\x4f\xcd",
  [0x8eac] = "\x56\x65", [0x8eb2] = "\x5d\xa2", [0x8eba] = "\x61\xbf",
  [0x8ebd] = "\x85\xf2", [0x8ec0] = "\x65\xc9", [0x8ec2] = "\x8c\x64",
  [0x8ec9] = "\x91\x9c", [0x8eca] = "\x4f\xce", [0x8ecb] = "\x51\xd0",
  [0x8ecc] = "\x53\xdc", [0x8ecd] = "\x53\xdb", [0x8ecf] = "\x56\x68",
  [0x8ed1] = "\x72\x4d", [0x8ed2] = "\x56\x66", [0x8ed3] = "\x72\x4e",
  [0x8ed4] = "\x56\x67", [0x8ed7] = "\x75\x85", [0x8ed8] = "\x75\x81",
  [0x8edb] = "\x58\xd2", [0x8edc] = "\x75\x84", [0x8edd] = "\x75\x83",
  [0x8ede] = "\x75\x82", [0x8edf] = "\x58\xd3", [0x8ee0] = "\x75\x86",
  [0x8ee1] = "\x75\x87", [0x8ee5] = "\x78\xe8", [0x8ee6] = "\x78\xe6",
  [0x8ee7] = "\x78\xea", [0x8ee8] = "\x78\xeb", [0x8ee9] = "\x78\xf1",
  [0x8eeb] = "\x78\xed", [0x8eec] = "\x78\xef", [0x8eee] = "\x78\xe7",
  [0x8eef] = "\x78\xe2", [0x8ef1] = "\x78\xee", [0x8ef4] = "\x78\xf0",
  [0x8ef5] = "\x78\xe9", [0x8ef6] = "\x78\xec", [0x8ef7] = "\x78\xe3",
  [0x8ef8] = "\x5b\x69", [0x8ef9] = "\x78\xe5", [0x8efa] = "\x78\xe4",
  [0x8efb] = "\x5b\x68", [0x8efc] = "\x5b\x6a", [0x8efe] = "\x5d\xa5",
  [0x8eff] = "\x7c\x9e", [0x8f00] = "\x7c\xa0", [0x8f01] = "\x7c\x9f",
  [0x8f02] = "\x7c\xa4", [0x8f03] = "\x5d\xa3", [0x8f05] = "\x7c\xa1",
  [0x8f06] = "\x7c\x9d", [0x8f07] = "\x7c\xa2", [0x8f08] = "\x7c\xa3",
  [0x8f09] = "\x5d\xa4", [0x8f0a] = "\x5d\xa6", [0x8f0b] = "\x7c\xa5",
  [0x8f0d] = "\x7f\xd0", [0x8f0e] = "\x7f\xcf", [0x8f10] = "\x7f\xcd",
  [0x8f11] = "\x7f\xce", [0x8f12] = "\x5f\xba", [0x8f13] = "\x5f\xbc",
  [0x8f14] = "\x5f\xb9", [0x8f15] = "\x5f\xbb", [0x8f16] = "\x82\xf6",
  [0x8f17] = "\x82\xf7", [0x8f18] = "\x82\xf2", [0x8f1a] = "\x82\xf3",
  [0x8f1b] = "\x61\xc1", [0x8f1c] = "\x61\xc6", [0x8f1d] = "\x61\xc0",
  [0x8f1e] = "\x61\xc7", [0x8f1f] = "\x61\xc2", [0x8f20] = "\x82\xf4",
  [0x8f23] = "\x82\xf5", [0x8f24] = "\x82\xf1", [0x8f25] = "\x61\xc8",
  [0x8f26] = "\x61\xc4", [0x8f29] = "\x61\xc3", [0x8f2a] = "\x61\xc5",
  [0x8f2c] = "\x82\xf0", [0x8f2e] = "\x85\xf4", [0x8f2f] = "\x63\x72",
  [0x8f32] = "\x85\xf6", [0x8f33] = "\x63\x74", [0x8f34] = "\x85\xf9",
  [0x8f35] = "\x85\xf5", [0x8f36] = "\x85\xf3", [0x8f37] = "\x85\xf8",
  [0x8f38] = "\x63\x73", [0x8f39] = "\x85\xf7", [0x8f3b] = "\x63\x71",
  [0x8f3e] = "\x64\xdc", [0x8f3f] = "\x64\xdf", [0x8f40] = "\x88\x8e",
  [0x8f42] = "\x64\xdd", [0x8f43] = "\x88\x8d", [0x8f44] = "\x64\xdb",
  [0x8f45] = "\x64\xde", [0x8f46] = "\x8a\x94", [0x8f47] = "\x8a\x95",
  [0x8f48] = "\x8a\x96", [0x8f49] = "\x65\xca", [0x8f4b] = "\x8a\x97",
  [0x8f4d] = "\x65\xcb", [0x8f4e] = "\x66\xad", [0x8f4f] = "\x8c\x67",
  [0x8f50] = "\x8c\x68", [0x8f51] = "\x8c\x66", [0x8f52] = "\x8c\x65",
  [0x8f53] = "\x8c\x69", [0x8f54] = "\x66\xac", [0x8f55] = "\x8d\xac",
  [0x8f56] = "\x8d\xaa", [0x8f57] = "\x8d\xab", [0x8f58] = "\x8d\xad",
  [0x8f59] = "\x8d\xa9", [0x8f5a] = "\x8d\xae", [0x8f5b] = "\x8e\xc7",
  [0x8f5d] = "\x8e\xc8", [0x8f5e] = "\x8e\xc6", [0x8f5f] = "\x67\xb1",
  [0x8f60] = "\x8f\xb4", [0x8f61] = "\x67\xf8", [0x8f62] = "\x8f\xb5",
  [0x8f63] = "\x90\x78", [0x8f64] = "\x90\x77", [0x8f9b] = "\x4f\xcf",
  [0x8f9c] = "\x5b\x6b", [0x8f9f] = "\x5d\xa7", [0x8fa3] = "\x5f\xbd",
  [0x8fa6] = "\x63\x76", [0x8fa8] = "\x63\x75", [0x8fad] = "\x66\xae",
  [0x8fae] = "\x67\x49", [0x8faf] = "\x67\xb2", [0x8fb0] = "\x4f\xd0",
  [0x8fb1] = "\x56\x69", [0x8fb2] = "\x5d\xa8", [0x8fb4] = "\x8c\x6a",
  [0x8fb5] = "\x48\xe2", [0x8fbf] = "\x6b\x47", [0x8fc2] = "\x4f\xd1",
  [0x8fc4] = "\x4f\xd4", [0x8fc5] = "\x4f\xd3", [0x8fc6] = "\x4f\xd2",
  [0x8fc9] = "\x6b\x46", [0x8fcb] = "\x6c\xed", [0x8fcd] = "\x6c\xef",
  [0x8fce] = "\x51\xd1", [0x8fd1] = "\x51\xd3", [0x8fd2] = "\x6c\xec",
  [0x8fd3] = "\x6c\xee", [0x8fd4] = "\x51\xd2", [0x8fd5] = "\x6c\xf1",
  [0x8fd6] = "\x6c\xf0", [0x8fd7] = "\x6c\xf2", [0x8fe0] = "\x6f\x78",
  [0x8fe1] = "\x6f\x76", [0x8fe2] = "\x53\xdf", [0x8fe3] = "\x6f\x75",
  [0x8fe4] = "\x53\xe4", [0x8fe5] = "\x53\xe1", [0x8fe6] = "\x53\xde",
  [0x8fe8] = "\x53\xe5", [0x8fea] = "\x53\xe0", [0x8feb] = "\x53\xe3",
  [0x8fed] = "\x53\xe2", [0x8fee] = "\x6f\x77", [0x8ff0] = "\x53\xdd",
  [0x8ff4] = "\x56\x6f", [0x8ff5] = "\x72\x50", [0x8ff6] = "\x72\x56",
  [0x8ff7] = "\x56\x6c", [0x8ff8] = "\x56\x73", [0x8ffa] = "\x56\x6e",
  [0x8ffb] = "\x72\x53", [0x8ffc] = "\x72\x55", [0x8ffd] = "\x56\x71",
  [0x8ffe] = "\x72\x4f", [0x8fff] = "\x72\x52", [0x9000] = "\x56\x6d",
  [0x9001] = "\x56\x6a", [0x9002] = "\x72\x51", [0x9003] = "\x56\x70",
  [0x9004] = "\x72\x54", [0x9005] = "\x56\x72", [0x9006] = "\x56\x6b",
  [0x900b] = "\x75\x89", [0x900c] = "\x75\x8c", [0x900d] = "\x58\xd5",
  [0x900f] = "\x58\xdf", [0x9010] = "\x58\xdb", [0x9011] = "\x75\x8a",
  [0x9014] = "\x58\xe3", [0x9015] = "\x58\xdc", [0x9016] = "\x58\xe1",
  [0x9017] = "\x58\xd7", [0x9019] = "\x58\xd4", [0x901a] = "\x58\xd6",
  [0x901b] = "\x58\xe2", [0x901c] = "\x75\x8b", [0x901d] = "\x58\xda",
  [0x901e] = "\x58\xdd", [0x901f] = "\x58\xd9", [0x9020] = "\x58\xde",
  [0x9021] = "\x75\x8d", [0x9022] = "\x58\xe0", [0x9023] = "\x58\xd8",
  [0x9024] = "\x75\x88", [0x902d] = "\x78\xf2", [0x902e] = "\x5b\x6c",
  [0x902f] = "\x78\xf4", [0x9031] = "\x5b\x6e", [0x9032] = "\x5b\x70",
  [0x9034] = "\x78\xf3", [0x9035] = "\x5b\x6d", [0x9036] = "\x5b\x71",
  [0x9038] = "\x5b\x6f", [0x903c] = "\x5d\xae", [0x903d] = "\x7c\xaa",
  [0x903e] = "\x5d\xb6", [0x903f] = "\x7c\xa7", [0x9041] = "\x5d\xb7",
  [0x9042] = "\x5d\xac", [0x9044] = "\x7c\xa8", [0x9047] = "\x5d\xb1",
  [0x9049] = "\x7c\xa9", [0x904a] = "\x5d\xaa", [0x904b] = "\x5d\xa9",
  [0x904d] = "\x5d\xb4", [0x904e] = "\x5d\xb3", [0x904f] = "\x5d\xb2",
  [0x9050] = "\x5d\xb0", [0x9051] = "\x5d\xb5", [0x9052] = "\x7c\xa6",
  [0x9053] = "\x5d\xab", [0x9054] = "\x5d\xad", [0x9055] = "\x5d\xaf",
  [0x9058] = "\x5f\xbf", [0x9059] = "\x5f\xc2", [0x905b] = "\x5f\xc6",
  [0x905c] = "\x5f\xc0", [0x905d] = "\x5f\xc5", [0x905e] = "\x5f\xc3",
  [0x9060] = "\x5f\xbe", [0x9062] = "\x5f\xc4", [0x9063] = "\x5f\xc1",
  [0x9067] = "\x82\xfb", [0x9068] = "\x61\xcb", [0x9069] = "\x61\xc9",
  [0x906b] = "\x82\xfc", [0x906d] = "\x61\xcc", [0x906e] = "\x61\xca",
  [0x906f] = "\x82\xfa", [0x9070] = "\x82\xf9", [0x9072] = "\x63\x7a",
  [0x9073] = "\x82\xf8", [0x9074] = "\x63\x78", [0x9075] = "\x63\x77",
  [0x9076] = "\x85\xfa", [0x9077] = "\x61\xcd", [0x9078] = "\x63\x79",
  [0x9079] = "\x85\xfb", [0x907a] = "\x63\x7c", [0x907b] = "\x85\xfc",
  [0x907c] = "\x63\x7b", [0x907d] = "\x64\xe1", [0x907e] = "\x88\x90",
  [0x907f] = "\x64\xe0", [0x9080] = "\x64\xe5", [0x9081] = "\x64\xe3",
  [0x9082] = "\x64\xe4", [0x9083] = "\x65\xcd", [0x9084] = "\x64\xe2",
  [0x9085] = "\x88\x8f", [0x9086] = "\x85\xfd", [0x9087] = "\x65\xcc",
  [0x9088] = "\x65\xce", [0x908a] = "\x66\xaf", [0x908b] = "\x66\xb0",
  [0x908d] = "\x8d\xaf", [0x908f] = "\x68\x6a", [0x9090] = "\x68\x69",
  [0x9091] = "\x4f\xd6", [0x9094] = "\x69\xf4", [0x9095] = "\x56\x74",
  [0x9097] = "\x69\xf1", [0x9098] = "\x69\xf2", [0x9099] = "\x69\xf0",
  [0x909b] = "\x69\xf3", [0x909e] = "\x6b\x4b", [0x909f] = "\x6b\x48",
  [0x90a0] = "\x6b\x4d", [0x90a1] = "\x6b\x49", [0x90a2] = "\x4f\xd7",
  [0x90a3] = "\x4f\xda", [0x90a5] = "\x6b\x4a", [0x90a6] = "\x4f\xd9",
  [0x90a7] = "\x6b\x4c", [0x90aa] = "\x4f\xd8", [0x90af] = "\x6c\xf5",
  [0x90b0] = "\x6c\xf7", [0x90b1] = "\x51\xd6", [0x90b2] = "\x6c\xf3",
  [0x90b3] = "\x6c\xf6", [0x90b4] = "\x6c\xf4", [0x90b5] = "\x51\xd4",
  [0x90b6] = "\x51\xd7", [0x90b8] = "\x51\xd5", [0x90bd] = "\x6f\x7a",
  [0x90be] = "\x6f\x7e", [0x90bf] = "\x6f\x7b", [0x90c1] = "\x53\xe8",
  [0x90c3] = "\x53\xe9", [0x90c5] = "\x6f\x7d", [0x90c7] = "\x6f\x7f",
  [0x90c8] = "\x6f\x82", [0x90ca] = "\x53\xe6", [0x90cb] = "\x6f\x81",
  [0x90ce] = "\x53\xe7", [0x90d4] = "\x75\x94", [0x90d5] = "\x6f\x7c",
  [0x90d6] = "\x72\x57", [0x90d7] = "\x72\x60", [0x90d8] = "\x72\x5e",
  [0x90d9] = "\x72\x59", [0x90da] = "\x72\x5a", [0x90db] = "\x72\x5f",
  [0x90dc] = "\x72\x61", [0x90dd] = "\x56\x76", [0x90df] = "\x72\x5c",
  [0x90e0] = "\x72\x58", [0x90e1] = "\x56\x75", [0x90e2] = "\x56\x77",
  [0x90e3] = "\x72\x5b", [0x90e4] = "\x72\x62", [0x90e5] = "\x72\x5d",
  [0x90e8] = "\x58\xe4", [0x90e9] = "\x75\x97", [0x90ea] = "\x75\x8f",
  [0x90eb] = "\x75\x95", [0x90ec] = "\x75\x96", [0x90ed] = "\x58\xe5",
  [0x90ef] = "\x75\x8e", [0x90f0] = "\x75\x90", [0x90f1] = "\x6f\x79",
  [0x90f2] = "\x75\x92", [0x90f3] = "\x75\x93", [0x90f4] = "\x75\x91",
  [0x90f5] = "\x5b\x73", [0x90f9] = "\x78\xfb", [0x90fa] = "\x86\x41",
  [0x90fb] = "\x78\xfc", [0x90fc] = "\x78\xf9", [0x90fd] = "\x58\xe6",
  [0x90fe] = "\x5b\x75", [0x90ff] = "\x78\xf8", [0x9100] = "\x79\x41",
  [0x9101] = "\x78\xfd", [0x9102] = "\x5b\x72", [0x9103] = "\x79\x44",
  [0x9104] = "\x78\xf7", [0x9105] = "\x79\x43", [0x9106] = "\x78\xf5",
  [0x9107] = "\x79\x42", [0x9108] = "\x78\xfa", [0x9109] = "\x5b\x74",
  [0x910b] = "\x7c\xb1", [0x910d] = "\x7c\xac", [0x910e] = "\x7c\xb2",
  [0x910f] = "\x7c\xad", [0x9110] = "\x7c\xab", [0x9111] = "\x7c\xae",
  [0x9112] = "\x5d\xb8", [0x9114] = "\x7c\xb0", [0x9116] = "\x7c\xaf",
  [0x9117] = "\x5d\xb9", [0x9118] = "\x5f\xc8", [0x9119] = "\x5f\xc7",
  [0x911a] = "\x7f\xd7", [0x911b] = "\x7f\xda", [0x911c] = "\x7f\xd2",
  [0x911d] = "\x7f\xd6", [0x911e] = "\x5f\xc9", [0x911f] = "\x7f\xd5",
  [0x9120] = "\x7f\xd3", [0x9121] = "\x7f\xd9", [0x9122] = "\x7f\xd4",
  [0x9123] = "\x7f\xd1", [0x9124] = "\x7f\xd8", [0x9126] = "\x83\x45",
  [0x9127] = "\x61\xd0", [0x9128] = "\x8a\x98", [0x9129] = "\x83\x42",
  [0x912a] = "\x83\x43", [0x912b] = "\x83\x41", [0x912c] = "\x78\xf6",
  [0x912d] = "\x61\xcf", [0x912e] = "\x83\x46", [0x912f] = "\x82\xfd",
  [0x9130] = "\x61\xce", [0x9131] = "\x61\xd1", [0x9132] = "\x83\x44",
  [0x9133] = "\x86\x42", [0x9134] = "\x63\x7d", [0x9135] = "\x86\x43",
  [0x9136] = "\x86\x44", [0x9138] = "\x88\x91", [0x9139] = "\x64\xe6",
  [0x913a] = "\x8a\x99", [0x913b] = "\x8a\x9a", [0x913e] = "\x8a\x9b",
  [0x913f] = "\x8c\x6c", [0x9140] = "\x8c\x6b", [0x9141] = "\x8d\xb1",
  [0x9143] = "\x8d\xb0", [0x9144] = "\x8e\xca", [0x9145] = "\x8e\xcb",
  [0x9146] = "\x8e\xc9", [0x9147] = "\x8f\xb6", [0x9148] = "\x67\xf9",
  [0x9149] = "\x4f\xdb", [0x914a] = "\x53\xeb", [0x914b] = "\x53\xea",
  [0x914c] = "\x56\x7a", [0x914d] = "\x56\x79", [0x914e] = "\x72\x64",
  [0x914f] = "\x72\x65", [0x9150] = "\x72\x63", [0x9152] = "\x56\x78",
  [0x9153] = "\x75\x9b", [0x9155] = "\x75\x9c", [0x9156] = "\x75\x98",
  [0x9157] = "\x58\xe7", [0x9158] = "\x75\x99", [0x915a] = "\x75\x9a",
  [0x915f] = "\x79\x47", [0x9160] = "\x79\x49", [0x9161] = "\x79\x45",
  [0x9162] = "\x79\x48", [0x9163] = "\x5b\x76", [0x9164] = "\x79\x46",
  [0x9165] = "\x5b\x77", [0x9168] = "\x79\xf9", [0x9169] = "\x5d\xbc",
  [0x916a] = "\x5d\xbb", [0x916c] = "\x5d\xba", [0x916e] = "\x7c\xb3",
  [0x916f] = "\x7c\xb4", [0x9172] = "\x7f\xdc", [0x9173] = "\x7f\xde",
  [0x9174] = "\x5f\xcd", [0x9175] = "\x5f\xca", [0x9177] = "\x5f\xcc",
  [0x9178] = "\x5f\xcb", [0x9179] = "\x7f\xdd", [0x917a] = "\x7f\xdb",
  [0x9180] = "\x83\x4d", [0x9181] = "\x83\x4a", [0x9182] = "\x83\x4b",
  [0x9183] = "\x61\xd5", [0x9184] = "\x83\x4c", [0x9185] = "\x83\x47",
  [0x9186] = "\x83\x48", [0x9187] = "\x61\xd2", [0x9189] = "\x61\xd3",
  [0x918a] = "\x83\x49", [0x918b] = "\x61\xd4", [0x918d] = "\x86\x48",
  [0x918f] = "\x86\x49", [0x9190] = "\x86\x46", [0x9191] = "\x86\x47",
  [0x9192] = "\x63\x7e", [0x9193] = "\x86\x45", [0x9199] = "\x88\x95",
  [0x919a] = "\x88\x92", [0x919b] = "\x88\x94", [0x919c] = "\x64\xe9",
  [0x919d] = "\x88\x98", [0x919e] = "\x64\xe8", [0x919f] = "\x88\x96",
  [0x91a0] = "\x88\x99", [0x91a1] = "\x88\x97", [0x91a2] = "\x88\x93",
  [0x91a3] = "\x64\xe7", [0x91a5] = "\x8a\x9d", [0x91a7] = "\x8a\x9e",
  [0x91a8] = "\x8a\x9c", [0x91aa] = "\x8a\xa0", [0x91ab] = "\x65\xcf",
  [0x91ac] = "\x65\xd0", [0x91ad] = "\x8c\x6e", [0x91ae] = "\x66\xb2",
  [0x91af] = "\x8a\x9f", [0x91b0] = "\x8c\x6d", [0x91b1] = "\x66\xb1",
  [0x91b2] = "\x8d\xb4", [0x91b3] = "\x8d\xb5", [0x91b4] = "\x67\x6a",
  [0x91b5] = "\x8d\xb3", [0x91b7] = "\x8d\xb2", [0x91b9] = "\x8e\xcc",
  [0x91ba] = "\x67\xb3", [0x91bc] = "\x90\x79", [0x91bd] = "\x90\xd7",
  [0x91be] = "\x90\xd6", [0x91c0] = "\x68\x8f", [0x91c1] = "\x68\xa9",
  [0x91c2] = "\x90\xd8", [0x91c3] = "\x91\x83", [0x91c5] = "\x68\xbb",
  [0x91c6] = "\x4f\xdc", [0x91c7] = "\x51\xd8", [0x91c9] = "\x5d\xbd",
  [0x91cb] = "\x67\x6b", [0x91cc] = "\x4f\xdd", [0x91cd] = "\x53\xec",
  [0x91ce] = "\x58\xe8", [0x91cf] = "\x5b\x78", [0x91d0] = "\x65\xd1",
  [0x91d1] = "\x51\xd9", [0x91d3] = "\x6f\x84", [0x91d4] = "\x6f\x83",
  [0x91d5] = "\x72\x66", [0x91d7] = "\x56\x7d", [0x91d8] = "\x56\x7b",
  [0x91d9] = "\x56\x7f", [0x91da] = "\x72\x68", [0x91dc] = "\x56\x7e",
  [0x91dd] = "\x56\x7c", [0x91e2] = "\x72\x67", [0x91e3] = "\x58\xeb",
  [0x91e4] = "\x75\xa2", [0x91e6] = "\x58\xea", [0x91e7] = "\x58\xec",
  [0x91e8] = "\x75\xa7", [0x91e9] = "\x58\xee", [0x91ea] = "\x75\xa4",
  [0x91eb] = "\x75\xa5", [0x91ec] = "\x75\x9d", [0x91ed] = "\x58\xed",
  [0x91ee] = "\x75\xa8", [0x91f1] = "\x75\x9f", [0x91f3] = "\x75\xa0",
  [0x91f4] = "\x75\x9e", [0x91f5] = "\x58\xe9", [0x91f7] = "\x75\xa6",
  [0x91f8] = "\x75\xa1", [0x91f9] = "\x75\xa3", [0x91fd] = "\x79\x55",
  [0x91ff] = "\x79\x54", [0x9200] = "\x79\x52", [0x9201] = "\x79\x4a",
  [0x9202] = "\x79\x59", [0x9203] = "\x79\x4d", [0x9204] = "\x79\x57",
  [0x9205] = "\x79\x5e", [0x9206] = "\x79\x56", [0x9207] = "\x5b\x81",
  [0x9209] = "\x5b\x7c", [0x920a] = "\x79\x4b", [0x920c] = "\x79\x51",
  [0x920d] = "\x5b\x7e", [0x920f] = "\x79\x50", [0x9210] = "\x5b\x7f",
  [0x9211] = "\x5b\x82", [0x9212] = "\x79\x53", [0x9214] = "\x5b\x79",
  [0x9215] = "\x5b\x7a", [0x9216] = "\x79\x5f", [0x9217] = "\x79\x5d",
  [0x9219] = "\x79\x5c", [0x921a] = "\x79\x4e", [0x921c] = "\x79\x5a",
  [0x921e] = "\x5b\x7d", [0x9223] = "\x5b\x7b", [0x9224] = "\x79\x5b",
  [0x9225] = "\x79\x4c", [0x9226] = "\x79\x4f", [0x9227] = "\x79\x58",
  [0x922d] = "\x80\x44", [0x922e] = "\x7c\xbe", [0x9230] = "\x7c\xb7",
  [0x9231] = "\x7c\xca", [0x9232] = "\x7c\xd3", [0x9233] = "\x7c\xba",
  [0x9234] = "\x5d\xc8", [0x9236] = "\x7c\xc7", [0x9237] = "\x5d\xbe",
  [0x9238] = "\x5d\xc0", [0x9239] = "\x5d\xcc", [0x923a] = "\x7c\xb8",
  [0x923d] = "\x5d\xc1", [0x923e] = "\x5d\xc3", [0x923f] = "\x5d\xcd",
  [0x9240] = "\x5d\xc2", [0x9245] = "\x5d\xcb", [0x9246] = "\x7c\xc0",
  [0x9248] = "\x7c\xb5", [0x9249] = "\x5d\xc9", [0x924a] = "\x7c\xbf",
  [0x924b] = "\x5d\xc5", [0x924c] = "\x7c\xd1", [0x924d] = "\x5d\xca",
  [0x924e] = "\x7c\xcf", [0x924f] = "\x7c\xc3", [0x9250] = "\x7c\xcd",
  [0x9251] = "\x5d\xc7", [0x9252] = "\x7c\xb6", [0x9253] = "\x7c\xd0",
  [0x9254] = "\x7c\xcb", [0x9256] = "\x7c\xd2", [0x9257] = "\x5d\xbf",
  [0x925a] = "\x5d\xce", [0x925b] = "\x5d\xc4", [0x925e] = "\x7c\xbc",
  [0x9260] = "\x7c\xc4", [0x9261] = "\x7c\xc8", [0x9263] = "\x7c\xcc",
  [0x9264] = "\x5d\xc6", [0x9265] = "\x7c\xbb", [0x9266] = "\x7c\xb9",
  [0x9267] = "\x7c\xc5", [0x926c] = "\x7c\xc2", [0x926d] = "\x7c\xc1",
  [0x926f] = "\x7c\xc6", [0x9270] = "\x7c\xc9", [0x9272] = "\x7c\xce",
  [0x9276] = "\x7f\xe1", [0x9278] = "\x5f\xce", [0x9279] = "\x7f\xeb",
  [0x927a] = "\x7f\xe3", [0x927b] = "\x5f\xd3", [0x927c] = "\x5f\xd7",
  [0x927d] = "\x7f\xf4", [0x927e] = "\x7f\xfc", [0x927f] = "\x7f\xed",
  [0x9280] = "\x5f\xcf", [0x9282] = "\x7f\xf1", [0x9283] = "\x7c\xbd",
  [0x9285] = "\x5f\xd0", [0x9286] = "\x7f\xf8", [0x9287] = "\x7f\xfd",
  [0x9288] = "\x7f\xf5", [0x928a] = "\x7f\xf7", [0x928b] = "\x80\x43",
  [0x928c] = "\x7f\xf9", [0x928d] = "\x7f\xe7", [0x928e] = "\x7f\xf0",
  [0x9291] = "\x5f\xd8", [0x9293] = "\x5f\xd4", [0x9294] = "\x7f\xe5",
  [0x9295] = "\x7f\xf2", [0x9296] = "\x5f\xd2", [0x9297] = "\x7f\xec",
  [0x9298] = "\x5f\xd1", [0x9299] = "\x7f\xfa", [0x929a] = "\x7f\xe9",
  [0x929b] = "\x7f\xe2", [0x929c] = "\x5f\xd5", [0x929d] = "\x80\x42",
  [0x92a0] = "\x7f\xe4", [0x92a1] = "\x7f\xf6", [0x92a2] = "\x7f\xf3",
  [0x92a3] = "\x7f\xee", [0x92a4] = "\x7f\xe0", [0x92a5] = "\x7f\xdf",
  [0x92a6] = "\x7f\xe8", [0x92a7] = "\x7f\xfb", [0x92a8] = "\x5f\xd6",
  [0x92a9] = "\x80\x41", [0x92aa] = "\x7f\xe6", [0x92ab] = "\x7f\xea",
  [0x92ac] = "\x61\xda", [0x92b2] = "\x61\xe2", [0x92b3] = "\x61\xdd",
  [0x92b4] = "\x83\x6e", [0x92b5] = "\x83\x6b", [0x92b6] = "\x83\x53",
  [0x92b7] = "\x61\xd8", [0x92bb] = "\x61\xd7", [0x92bc] = "\x61\xde",
  [0x92c0] = "\x83\x51", [0x92c1] = "\x61\xdc", [0x92c2] = "\x83\x5d",
  [0x92c3] = "\x83\x4f", [0x92c4] = "\x83\x50", [0x92c5] = "\x61\xd6",
  [0x92c6] = "\x83\x6d", [0x92c7] = "\x61\xe0", [0x92c8] = "\x83\x60",
  [0x92c9] = "\x83\x65", [0x92ca] = "\x83\x5f", [0x92cb] = "\x86\x5b",
  [0x92cc] = "\x83\x5b", [0x92cd] = "\x83\x63", [0x92ce] = "\x83\x61",
  [0x92cf] = "\x83\x54", [0x92d0] = "\x83\x4e", [0x92d1] = "\x83\x69",
  [0x92d2] = "\x61\xdf", [0x92d3] = "\x83\x6a", [0x92d5] = "\x83\x64",
  [0x92d7] = "\x83\x59", [0x92d8] = "\x83\x57", [0x92d9] = "\x83\x52",
  [0x92dd] = "\x83\x5a", [0x92de] = "\x83\x67", [0x92df] = "\x83\x56",
  [0x92e0] = "\x83\x66", [0x92e1] = "\x83\x6c", [0x92e4] = "\x61\xdb",
  [0x92e6] = "\x83\x62", [0x92e7] = "\x83\x68", [0x92e8] = "\x83\x5e",
  [0x92e9] = "\x83\x58", [0x92ea] = "\x61\xd9", [0x92ee] = "\x7f\xef",
  [0x92ef] = "\x83\x5c", [0x92f0] = "\x61\xe1", [0x92f1] = "\x83\x55",
  [0x92f7] = "\x86\x61", [0x92f8] = "\x63\x82", [0x92f9] = "\x86\x60",
  [0x92fa] = "\x86\x5d", [0x92fb] = "\x86\x70", [0x92fc] = "\x63\x86",
  [0x92fe] = "\x86\x6d", [0x92ff] = "\x86\x65", [0x9300] = "\x86\x6f",
  [0x9301] = "\x86\x56", [0x9302] = "\x86\x63", [0x9304] = "\x63\x88",
  [0x9306] = "\x86\x4e", [0x9308] = "\x86\x4c", [0x9309] = "\x86\x6e",
  [0x930b] = "\x86\x6c", [0x930c] = "\x86\x6b", [0x930d] = "\x86\x5a",
  [0x930e] = "\x86\x59", [0x930f] = "\x86\x4f", [0x9310] = "\x63\x8a",
  [0x9312] = "\x86\x55", [0x9313] = "\x86\x5f", [0x9314] = "\x86\x6a",
  [0x9315] = "\x63\x8d", [0x9316] = "\x86\x71", [0x9318] = "\x64\xf1",
  [0x9319] = "\x63\x8f", [0x931a] = "\x63\x89", [0x931b] = "\x86\x53",
  [0x931d] = "\x86\x5c", [0x931e] = "\x86\x4b", [0x931f] = "\x86\x4d",
  [0x9320] = "\x63\x7f", [0x9321] = "\x63\x8c", [0x9322] = "\x63\x85",
  [0x9323] = "\x86\x54", [0x9324] = "\x86\x64", [0x9325] = "\x86\x5e",
  [0x9326] = "\x63\x8b", [0x9327] = "\x86\x4a", [0x9328] = "\x64\xec",
  [0x9329] = "\x86\x66", [0x932a] = "\x86\x69", [0x932b] = "\x63\x87",
  [0x932d] = "\x86\x58", [0x932e] = "\x63\x8e", [0x932f] = "\x63\x84",
  [0x9333] = "\x63\x83", [0x9334] = "\x86\x62", [0x9335] = "\x86\x68",
  [0x9336] = "\x63\x81", [0x9338] = "\x86\x51", [0x9339] = "\x86\x67",
  [0x933c] = "\x86\x52", [0x9346] = "\x86\x57", [0x9347] = "\x88\x9f",
  [0x9349] = "\x88\xa4", [0x934a] = "\x64\xee", [0x934b] = "\x64\xf0",
  [0x934c] = "\x88\xaa", [0x934d] = "\x64\xea", [0x934e] = "\x88\xb9",
  [0x934f] = "\x88\xb0", [0x9350] = "\x88\xa5", [0x9351] = "\x88\xa6",
  [0x9352] = "\x88\xaf", [0x9354] = "\x64\xf7", [0x9355] = "\x88\xae",
  [0x9356] = "\x88\x9e", [0x9357] = "\x88\xad", [0x9358] = "\x88\xa1",
  [0x9359] = "\x88\xba", [0x935a] = "\x64\xf6", [0x935b] = "\x64\xf4",
  [0x935c] = "\x88\xa2", [0x935e] = "\x88\xb5", [0x9360] = "\x88\xa7",
  [0x9361] = "\x88\xb4", [0x9363] = "\x88\xb6", [0x9364] = "\x88\x9d",
  [0x9365] = "\x64\xef", [0x9367] = "\x88\xb7", [0x936a] = "\x88\xab",
  [0x936c] = "\x64\xf3", [0x936d] = "\x88\xa8", [0x9370] = "\x64\xf5",
  [0x9371] = "\x88\xb1", [0x9375] = "\x64\xed", [0x9376] = "\x88\xa3",
  [0x9377] = "\x88\xb2", [0x9379] = "\x88\xac", [0x937a] = "\x86\x50",
  [0x937b] = "\x88\xb3", [0x937c] = "\x88\xa0", [0x937e] = "\x64\xf2",
  [0x9380] = "\x88\xb8", [0x9382] = "\x64\xeb", [0x9383] = "\x88\x9b",
  [0x9388] = "\x8a\xae", [0x9389] = "\x8a\xa7", [0x938a] = "\x65\xd3",
  [0x938c] = "\x8a\xa2", [0x938d] = "\x8a\xb1", [0x938e] = "\x8a\xa9",
  [0x938f] = "\x88\xa9", [0x9391] = "\x8a\xb3", [0x9392] = "\x8a\xa3",
  [0x9394] = "\x65\xd2", [0x9395] = "\x8a\xad", [0x9396] = "\x65\xd4",
  [0x9397] = "\x65\xdc", [0x9398] = "\x65\xda", [0x9399] = "\x8a\xaf",
  [0x939a] = "\x65\xdb", [0x939b] = "\x8a\xa5", [0x939d] = "\x8a\xa6",
  [0x939e] = "\x8a\xab", [0x939f] = "\x8a\xb0", [0x93a1] = "\x88\x9a",
  [0x93a2] = "\x65\xd5", [0x93a3] = "\x8a\xb8", [0x93a4] = "\x8a\xb5",
  [0x93a5] = "\x8a\xb9", [0x93a6] = "\x8a\xac", [0x93a7] = "\x8a\xa8",
  [0x93a8] = "\x8a\xb6", [0x93a9] = "\x8c\x79", [0x93aa] = "\x8a\xaa",
  [0x93ac] = "\x65\xd8", [0x93ae] = "\x65\xd7", [0x93af] = "\x88\x9c",
  [0x93b0] = "\x65\xd9", [0x93b1] = "\x8a\xb2", [0x93b2] = "\x8a\xb4",
  [0x93b3] = "\x65\xd6", [0x93b4] = "\x8a\xb7", [0x93b5] = "\x8a\xa1",
  [0x93b7] = "\x8a\xa4", [0x93c0] = "\x8c\x83", [0x93c2] = "\x8c\x72",
  [0x93c3] = "\x66\xb6", [0x93c4] = "\x8c\x81", [0x93c7] = "\x8c\x70",
  [0x93c8] = "\x66\xb7", [0x93ca] = "\x8c\x7b", [0x93cc] = "\x8c\x77",
  [0x93cd] = "\x66\xbc", [0x93ce] = "\x8c\x82", [0x93cf] = "\x8c\x71",
  [0x93d0] = "\x8c\x74", [0x93d1] = "\x66\xb4", [0x93d2] = "\x8c\x84",
  [0x93d4] = "\x8c\x7c", [0x93d5] = "\x8c\x7f", [0x93d6] = "\x66\xba",
  [0x93d7] = "\x66\xbf", [0x93d8] = "\x66\xbd", [0x93d9] = "\x8c\x78",
  [0x93da] = "\x8c\x73", [0x93dc] = "\x66\xb8", [0x93dd] = "\x66\xb9",
  [0x93de] = "\x8c\x6f", [0x93df] = "\x66\xb5", [0x93e1] = "\x66\xb3",
  [0x93e2] = "\x66\xbb", [0x93e3] = "\x8c\x7e", [0x93e4] = "\x66\xbe",
  [0x93e6] = "\x8c\x7a", [0x93e7] = "\x8c\x85", [0x93e8] = "\x66\xc0",
  [0x93ec] = "\x8c\x76", [0x93ee] = "\x8c\x7d", [0x93f5] = "\x8d\xc2",
  [0x93f6] = "\x8d\xd0", [0x93f7] = "\x8d\xc4", [0x93f8] = "\x8d\xcb",
  [0x93f9] = "\x8c\x75", [0x93fa] = "\x8d\xc9", [0x93fb] = "\x8d\xb8",
  [0x93fc] = "\x8d\xce", [0x93fd] = "\x67\x6e", [0x93fe] = "\x8d\xbc",
  [0x93ff] = "\x8d\xcd", [0x9400] = "\x8d\xc3", [0x9403] = "\x67\x6d",
  [0x9406] = "\x8d\xd2", [0x9407] = "\x8d\xc5", [0x9409] = "\x8d\xca",
  [0x940a] = "\x8d\xcc", [0x940b] = "\x8d\xb6", [0x940c] = "\x8d\xcf",
  [0x940d] = "\x8d\xc1", [0x940e] = "\x8d\xc6", [0x940f] = "\x8d\xba",
  [0x9410] = "\x8d\xbe", [0x9411] = "\x8d\xd1", [0x9412] = "\x8d\xc8",
  [0x9413] = "\x8d\xb7", [0x9414] = "\x8d\xbb", [0x9415] = "\x8d\xbd",
  [0x9416] = "\x8d\xc7", [0x9418] = "\x67\x6c", [0x9419] = "\x8d\xc0",
  [0x9420] = "\x8d\xb9", [0x9428] = "\x8d\xbf", [0x9429] = "\x8e\xd0",
  [0x942a] = "\x8e\xd5", [0x942b] = "\x67\xba", [0x942c] = "\x8e\xd7",
  [0x942e] = "\x67\xb4", [0x9430] = "\x8e\xd3", [0x9431] = "\x8e\xd9",
  [0x9432] = "\x67\xb9", [0x9433] = "\x67\xb5", [0x9435] = "\x67\xb6",
  [0x9436] = "\x8e\xcf", [0x9437] = "\x8e\xd6", [0x9438] = "\x67\xb8",
  [0x9439] = "\x8e\xd4", [0x943a] = "\x67\xb7", [0x943b] = "\x8e\xce",
  [0x943c] = "\x8e\xd2", [0x943d] = "\x8e\xd1", [0x943f] = "\x8e\xcd",
  [0x9440] = "\x8e\xd8", [0x9444] = "\x67\xfa", [0x9445] = "\x8f\xbd",
  [0x9446] = "\x8f\xc0", [0x9447] = "\x8f\xbc", [0x9448] = "\x8f\xbe",
  [0x9449] = "\x8f\xbf", [0x944a] = "\x8f\xb9", [0x944b] = "\x8f\xba",
  [0x944c] = "\x8f\xb7", [0x944f] = "\x8f\xbb", [0x9450] = "\x8f\xb8",
  [0x9451] = "\x67\xfb", [0x9452] = "\x67\xfc", [0x9455] = "\x90\x7b",
  [0x9457] = "\x90\x7d", [0x945d] = "\x90\x7c", [0x945e] = "\x90\x7e",
  [0x9460] = "\x68\x6c", [0x9462] = "\x90\x7a", [0x9463] = "\x68\x6b",
  [0x9464] = "\x68\x6d", [0x9468] = "\x90\xda", [0x9469] = "\x90\xdb",
  [0x946a] = "\x68\x90", [0x946b] = "\x90\xd9", [0x946d] = "\x91\x64",
  [0x946e] = "\x91\x63", [0x946f] = "\x91\x65", [0x9470] = "\x68\xab",
  [0x9471] = "\x91\x66", [0x9472] = "\x68\xaa", [0x9473] = "\x91\x67",
  [0x9474] = "\x91\x84", [0x9475] = "\x91\x87", [0x9476] = "\x91\x86",
  [0x9477] = "\x68\xb4", [0x9478] = "\x91\x85", [0x947c] = "\x68\xbe",
  [0x947d] = "\x68\xbc", [0x947e] = "\x68\xbd", [0x947f] = "\x68\xc3",
  [0x9480] = "\x91\xb0", [0x9481] = "\x91\xb1", [0x9482] = "\x91\xaf",
  [0x9483] = "\x91\xb9", [0x9577] = "\x51\xda", [0x957a] = "\x75\xa9",
  [0x957b] = "\x79\x60", [0x957c] = "\x83\x6f", [0x957d] = "\x8c\x86",
  [0x9580] = "\x51\xdb", [0x9582] = "\x53\xed", [0x9583] = "\x56\x81",
  [0x9586] = "\x75\xaa", [0x9588] = "\x75\xab", [0x9589] = "\x58\xef",
  [0x958b] = "\x5b\x85", [0x958c] = "\x79\x62", [0x958d] = "\x79\x61",
  [0x958e] = "\x5b\x89", [0x958f] = "\x5b\x84", [0x9590] = "\x79\x63",
  [0x9591] = "\x5b\x86", [0x9592] = "\x5b\x88", [0x9593] = "\x5b\x87",
  [0x9594] = "\x5b\x83", [0x9598] = "\x5d\xcf", [0x959b] = "\x7c\xd7",
  [0x959c] = "\x7c\xd5", [0x959e] = "\x7c\xd6", [0x959f] = "\x7c\xd4",
  [0x95a1] = "\x5f\xd9", [0x95a3] = "\x5f\xdc", [0x95a4] = "\x5f\xde",
  [0x95a5] = "\x5f\xdd", [0x95a8] = "\x5f\xda", [0x95a9] = "\x5f\xdb",
  [0x95ab] = "\x83\x71", [0x95ac] = "\x83\x70", [0x95ad] = "\x61\xe3",
  [0x95ae] = "\x83\x72", [0x95b0] = "\x83\x73", [0x95b1] = "\x61\xe4",
  [0x95b5] = "\x86\x79", [0x95b6] = "\x86\x77", [0x95b7] = "\x88\xc0",
  [0x95b9] = "\x86\x75", [0x95ba] = "\x86\x76", [0x95bb] = "\x63\x90",
  [0x95bc] = "\x86\x72", [0x95bd] = "\x86\x7a", [0x95be] = "\x86\x74",
  [0x95bf] = "\x86\x78", [0x95c0] = "\x88\xbc", [0x95c3] = "\x88\xbe",
  [0x95c5] = "\x88\xbf", [0x95c6] = "\x64\xfc", [0x95c7] = "\x88\xbb",
  [0x95c8] = "\x64\xfb", [0x95c9] = "\x88\xbd", [0x95ca] = "\x64\xf8",
  [0x95cb] = "\x64\xf9", [0x95cc] = "\x64\xfa", [0x95cd] = "\x86\x73",
  [0x95d0] = "\x65\xdf", [0x95d1] = "\x8a\xbc", [0x95d2] = "\x8a\xba",
  [0x95d3] = "\x8a\xbb", [0x95d4] = "\x65\xdd", [0x95d5] = "\x65\xe0",
  [0x95d6] = "\x65\xde", [0x95da] = "\x8c\x87", [0x95db] = "\x8c\x88",
  [0x95dc] = "\x66\xc1", [0x95de] = "\x8d\xd3", [0x95df] = "\x8d\xd5",
  [0x95e0] = "\x8d\xd4", [0x95e1] = "\x67\x6f", [0x95e2] = "\x67\xbb",
  [0x95e3] = "\x8e\xdc", [0x95e4] = "\x8e\xdb", [0x95e5] = "\x8e\xda",
  [0x961c] = "\x51\xdc", [0x961e] = "\x69\x8a", [0x9620] = "\x69\xf7",
  [0x9621] = "\x4e\x8b", [0x9622] = "\x69\xf5", [0x9623] = "\x69\xf8",
  [0x9624] = "\x69\xf6", [0x9628] = "\x6b\x4f", [0x962a] = "\x4f\xe1",
  [0x962c] = "\x4f\xe2", [0x962d] = "\x6b\x51", [0x962e] = "\x4f\xdf",
  [0x962f] = "\x6b\x50", [0x9630] = "\x6b\x4e", [0x9631] = "\x4f\xe0",
  [0x9632] = "\x4f\xde", [0x9639] = "\x6c\xf8", [0x963a] = "\x6c\xfb",
  [0x963b] = "\x51\xdf", [0x963c] = "\x6c\xfa", [0x963d] = "\x6c\xf9",
  [0x963f] = "\x51\xde", [0x9640] = "\x51\xdd", [0x9642] = "\x51\xe1",
  [0x9643] = "\x6c\xfc", [0x9644] = "\x51\xe0", [0x964a] = "\x6f\x89",
  [0x964b] = "\x53\xef", [0x964c] = "\x53\xf0", [0x964d] = "\x53\xf1",
  [0x964e] = "\x6f\x8a", [0x964f] = "\x6f\x86", [0x9650] = "\x53\xee",
  [0x9651] = "\x6f\x87", [0x9653] = "\x6f\x88", [0x9654] = "\x6f\x85",
  [0x9658] = "\x56\x88", [0x965b] = "\x56\x85", [0x965c] = "\x72\x69",
  [0x965d] = "\x56\x86", [0x965e] = "\x56\x89", [0x965f] = "\x72\x6a",
  [0x9661] = "\x56\x84", [0x9662] = "\x56\x82", [0x9663] = "\x56\x83",
  [0x9664] = "\x56\x87", [0x966a] = "\x58\xf0", [0x966b] = "\x75\xae",
  [0x966c] = "\x58\xf8", [0x966d] = "\x75\xad", [0x966f] = "\x75\xb0",
  [0x9670] = "\x58\xf4", [0x9671] = "\x75\xaf", [0x9672] = "\x5b\x91",
  [0x9673] = "\x58\xf2", [0x9674] = "\x58\xf5", [0x9675] = "\x58\xf1",
  [0x9676] = "\x58\xf6", [0x9677] = "\x58\xf7", [0x9678] = "\x58\xf3",
  [0x967c] = "\x75\xac", [0x967d] = "\x5b\x8d", [0x967e] = "\x79\x65",
  [0x9680] = "\x79\x69", [0x9683] = "\x79\x68", [0x9684] = "\x5b\x92",
  [0x9685] = "\x5b\x8e", [0x9686] = "\x5b\x8f", [0x9687] = "\x79\x64",
  [0x9688] = "\x79\x66", [0x9689] = "\x79\x67", [0x968a] = "\x5b\x8a",
  [0x968b] = "\x5b\x8c", [0x968d] = "\x5b\x90", [0x968e] = "\x5b\x8b",
  [0x9691] = "\x7c\xda", [0x9692] = "\x7c\xd8", [0x9693] = "\x7c\xd9",
  [0x9694] = "\x5d\xd1", [0x9695] = "\x5d\xd2", [0x9697] = "\x7c\xdb",
  [0x9698] = "\x5d\xd0", [0x9699] = "\x5f\xdf", [0x969b] = "\x5f\xe1",
  [0x969c] = "\x5f\xe0", [0x969e] = "\x80\x45", [0x96a1] = "\x80\x46",
  [0x96a2] = "\x83\x75", [0x96a4] = "\x83\x74", [0x96a7] = "\x63\x91",
  [0x96a8] = "\x63\x92", [0x96a9] = "\x86\x7b", [0x96aa] = "\x63\x93",
  [0x96ac] = "\x88\xc3", [0x96ae] = "\x88\xc1", [0x96b0] = "\x88\xc2",
  [0x96b1] = "\x64\xfd", [0x96b3] = "\x8a\xbd", [0x96b4] = "\x66\xc2",
  [0x96b6] = "\x48\xeb", [0x96b8] = "\x65\x41", [0x96b9] = "\x51\xe2",
  [0x96bb] = "\x56\x8a", [0x96bc] = "\x72\x6b", [0x96bf] = "\x75\xb1",
  [0x96c0] = "\x58\xf9", [0x96c1] = "\x5b\x93", [0x96c2] = "\x79\x6a",
  [0x96c3] = "\x79\x6c", [0x96c4] = "\x5b\x95", [0x96c5] = "\x5b\x94",
  [0x96c6] = "\x5b\x96", [0x96c7] = "\x5b\x97", [0x96c8] = "\x79\x6b",
  [0x96c9] = "\x5d\xd5", [0x96ca] = "\x5d\xd6", [0x96cb] = "\x5d\xd4",
  [0x96cc] = "\x5f\xe2", [0x96cd] = "\x5d\xd3", [0x96ce] = "\x7c\xdc",
  [0x96d2] = "\x5f\xe3", [0x96d3] = "\x83\x76", [0x96d4] = "\x86\x7c",
  [0x96d5] = "\x63\x94", [0x96d6] = "\x65\x42", [0x96d7] = "\x8a\xbe",
  [0x96d8] = "\x8a\xc2", [0x96d9] = "\x65\xe3", [0x96da] = "\x8a\xbf",
  [0x96db] = "\x65\xe4", [0x96dc] = "\x65\xe2", [0x96dd] = "\x8a\xc3",
  [0x96de] = "\x65\xe5", [0x96df] = "\x8a\xc1", [0x96e1] = "\x8c\x89",
  [0x96e2] = "\x65\xe1", [0x96e3] = "\x66\xc3", [0x96e5] = "\x90\xdc",
  [0x96e8] = "\x51\xe3", [0x96e9] = "\x58\xfb", [0x96ea] = "\x58\xfa",
  [0x96ef] = "\x5b\x98", [0x96f0] = "\x79\x6e", [0x96f1] = "\x79\x6d",
  [0x96f2] = "\x5b\x99", [0x96f5] = "\x7c\xe0", [0x96f6] = "\x5d\xda",
  [0x96f7] = "\x5d\xd7", [0x96f8] = "\x7c\xdf", [0x96f9] = "\x5d\xd9",
  [0x96fa] = "\x7c\xdd", [0x96fb] = "\x5d\xd8", [0x96fd] = "\x7c\xde",
  [0x96ff] = "\x80\x47", [0x9700] = "\x5f\xe4", [0x9702] = "\x83\x79",
  [0x9704] = "\x61\xe5", [0x9705] = "\x83\x77", [0x9706] = "\x61\xe6",
  [0x9707] = "\x61\xe7", [0x9708] = "\x83\x78", [0x9709] = "\x61\xe8",
  [0x970b] = "\x86\x7d", [0x970d] = "\x63\x98", [0x970e] = "\x63\x95",
  [0x970f] = "\x63\x9a", [0x9710] = "\x86\x7f", [0x9711] = "\x63\x96",
  [0x9712] = "\x86\x7e", [0x9713] = "\x63\x99", [0x9716] = "\x63\x97",
  [0x9718] = "\x88\xc6", [0x9719] = "\x88\xc8", [0x971c] = "\x65\x43",
  [0x971d] = "\x88\xc7", [0x971e] = "\x65\x44", [0x971f] = "\x88\xc5",
  [0x9720] = "\x88\xc4", [0x9722] = "\x8a\xc5", [0x9723] = "\x8a\xc4",
  [0x9724] = "\x65\xe6", [0x9725] = "\x8a\xc6", [0x9726] = "\x8c\x8e",
  [0x9727] = "\x66\xc5", [0x9728] = "\x8c\x8d", [0x9729] = "\x8c\x8a",
  [0x972a] = "\x66\xc4", [0x972b] = "\x8c\x8b", [0x972c] = "\x8c\x8c",
  [0x972e] = "\x8d\xd6", [0x972f] = "\x8d\xd7", [0x9730] = "\x67\x70",
  [0x9732] = "\x67\xbe", [0x9735] = "\x8e\xdd", [0x9738] = "\x67\xbc",
  [0x9739] = "\x67\xbd", [0x973a] = "\x8e\xde", [0x973d] = "\x67\xfd",
  [0x973e] = "\x68\x41", [0x973f] = "\x8f\xc1", [0x9742] = "\x68\x91",
  [0x9743] = "\x90\xde", [0x9744] = "\x68\x93", [0x9746] = "\x90\xdd",
  [0x9747] = "\x90\xdf", [0x9748] = "\x68\x92", [0x9749] = "\x91\x68",
  [0x974b] = "\x91\x9d", [0x9752] = "\x51\xe4", [0x9756] = "\x5d\xdb",
  [0x9758] = "\x80\x48", [0x975a] = "\x83\x7a", [0x975b] = "\x63\x9b",
  [0x975c] = "\x63\x9c", [0x975e] = "\x51\xe5", [0x9760] = "\x61\xe9",
  [0x9761] = "\x66\xc6", [0x9762] = "\x53\xf2", [0x9766] = "\x63\x9d",
  [0x9768] = "\x68\x6e", [0x9769] = "\x53\xf3", [0x976a] = "\x75\xb2",
  [0x976c] = "\x79\x6f", [0x976e] = "\x79\x71", [0x9770] = "\x79\x70",
  [0x9772] = "\x7c\xe4", [0x9773] = "\x7c\xe1", [0x9774] = "\x5d\xdc",
  [0x9776] = "\x5d\xdd", [0x9777] = "\x7c\xe2", [0x9778] = "\x7c\xe3",
  [0x977a] = "\x80\x4a", [0x977b] = "\x80\x4f", [0x977c] = "\x5f\xe5",
  [0x977d] = "\x80\x49", [0x977e] = "\x80\x4b", [0x977f] = "\x80\x52",
  [0x9780] = "\x80\x4d", [0x9781] = "\x80\x51", [0x9782] = "\x80\x4e",
  [0x9783] = "\x80\x4c", [0x9784] = "\x80\x50", [0x9785] = "\x5f\xe6",
  [0x9788] = "\x83\x7d", [0x978a] = "\x83\x7b", [0x978b] = "\x61\xeb",
  [0x978d] = "\x61\xea", [0x978e] = "\x83\x7c", [0x978f] = "\x61\xec",
  [0x9794] = "\x86\x83", [0x9797] = "\x86\x82", [0x9798] = "\x63\x9e",
  [0x9799] = "\x86\x81", [0x979a] = "\x88\xc9", [0x979c] = "\x88\xcb",
  [0x979d] = "\x88\xcd", [0x979e] = "\x88\xcc", [0x97a0] = "\x65\x45",
  [0x97a1] = "\x88\xca", [0x97a2] = "\x8a\xcd", [0x97a3] = "\x65\xe7",
  [0x97a4] = "\x8a\xcb", [0x97a5] = "\x8a\xce", [0x97a6] = "\x65\xe8",
  [0x97a8] = "\x8a\xc9", [0x97aa] = "\x8a\xcc", [0x97ab] = "\x8a\xca",
  [0x97ac] = "\x8a\xc7", [0x97ad] = "\x65\xe9", [0x97ae] = "\x8a\xc8",
  [0x97b3] = "\x8c\x8f", [0x97b6] = "\x8c\x91", [0x97b7] = "\x8c\x90",
  [0x97b9] = "\x8d\xd8", [0x97bb] = "\x8d\xd9", [0x97bf] = "\x8e\xdf",
  [0x97c1] = "\x68\x43", [0x97c3] = "\x68\x42", [0x97c4] = "\x90\x7f",
  [0x97c5] = "\x90\x81", [0x97c6] = "\x68\x94", [0x97c7] = "\x90\xe0",
  [0x97c9] = "\x68\xb5", [0x97cb] = "\x53\xf4", [0x97cc] = "\x5b\x9a",
  [0x97cd] = "\x80\x54", [0x97ce] = "\x80\x53", [0x97cf] = "\x83\x7f",
  [0x97d0] = "\x83\x7e", [0x97d3] = "\x65\x46", [0x97d4] = "\x88\xcf",
  [0x97d5] = "\x88\xce", [0x97d6] = "\x8a\xd1", [0x97d7] = "\x8a\xcf",
  [0x97d8] = "\x8a\xd2", [0x97d9] = "\x8a\xd0", [0x97dc] = "\x66\xc7",
  [0x97dd] = "\x8c\x92", [0x97de] = "\x8c\x93", [0x97df] = "\x8c\x94",
  [0x97e1] = "\x8e\xe0", [0x97e3] = "\x8f\xc2", [0x97e5] = "\x90\xe1",
  [0x97ed] = "\x53\xf5", [0x97f0] = "\x86\x84", [0x97f1] = "\x88\xd0",
  [0x97f3] = "\x53\xf6", [0x97f6] = "\x5f\xe7", [0x97f8] = "\x86\x85",
  [0x97f9] = "\x65\xea", [0x97fa] = "\x8a\xd3", [0x97fb] = "\x66\xc8",
  [0x97fd] = "\x8d\xda", [0x97fe] = "\x8d\xdb", [0x97ff] = "\x67\xbf",
  [0x9800] = "\x90\x82", [0x9801] = "\x53\xf7", [0x9802] = "\x59\x41",
  [0x9803] = "\x59\x42", [0x9804] = "\x75\xb3", [0x9805] = "\x5b\x9b",
  [0x9806] = "\x5b\x9c", [0x9807] = "\x79\x72", [0x9808] = "\x5b\x9d",
  [0x980a] = "\x5d\xe1", [0x980c] = "\x5d\xe3", [0x980d] = "\x7c\xe6",
  [0x980e] = "\x7c\xe7", [0x980f] = "\x7c\xe5", [0x9810] = "\x5d\xde",
  [0x9811] = "\x5d\xdf", [0x9812] = "\x5d\xe2", [0x9813] = "\x5d\xe0",
  [0x9816] = "\x80\x55", [0x9817] = "\x5f\xe8", [0x9818] = "\x5f\xe9",
  [0x981b] = "\x83\x87", [0x981c] = "\x61\xef", [0x981d] = "\x83\x82",
  [0x981e] = "\x83\x81", [0x9820] = "\x83\x86", [0x9821] = "\x61\xed",
  [0x9824] = "\x63\xa5", [0x9826] = "\x83\x83", [0x9827] = "\x83\x88",
  [0x9828] = "\x83\x85", [0x9829] = "\x83\x84", [0x982b] = "\x61\xee",
  [0x982d] = "\x63\xa3", [0x982f] = "\x86\x87", [0x9830] = "\x63\x9f",
  [0x9832] = "\x86\x88", [0x9835] = "\x86\x86", [0x9837] = "\x63\xa2",
  [0x9838] = "\x63\xa0", [0x9839] = "\x63\xa4", [0x983b] = "\x63\xa1",
  [0x9841] = "\x88\xd1", [0x9843] = "\x88\xd6", [0x9844] = "\x88\xd2",
  [0x9845] = "\x88\xd5", [0x9846] = "\x65\x47", [0x9848] = "\x87\xc0",
  [0x9849] = "\x88\xd4", [0x984a] = "\x88\xd3", [0x984c] = "\x65\xed",
  [0x984d] = "\x65\xeb", [0x984e] = "\x65\xee", [0x984f] = "\x65\xec",
  [0x9850] = "\x8a\xd4", [0x9851] = "\x8a\xd5", [0x9852] = "\x8a\xd6",
  [0x9853] = "\x65\xef", [0x9857] = "\x8c\x98", [0x9858] = "\x66\xca",
  [0x9859] = "\x8c\x96", [0x985b] = "\x66\xcb", [0x985c] = "\x8c\x95",
  [0x985d] = "\x8c\x97", [0x985e] = "\x66\xc9", [0x985f] = "\x8d\xdf",
  [0x9860] = "\x8d\xdc", [0x9862] = "\x8d\xdd", [0x9863] = "\x8d\xde",
  [0x9864] = "\x8e\xe1", [0x9865] = "\x67\xc1", [0x9867] = "\x67\xc0",
  [0x9869] = "\x8f\xc4", [0x986a] = "\x8f\xc3", [0x986b] = "\x68\x44",
  [0x986f] = "\x68\x6f", [0x9870] = "\x68\x95", [0x9871] = "\x68\xac",
  [0x9872] = "\x91\x69", [0x9873] = "\x91\x9e", [0x9874] = "\x91\x9f",
  [0x98a8] = "\x53\xf8", [0x98a9] = "\x79\x73", [0x98ac] = "\x7c\xe8",
  [0x98ad] = "\x80\x56", [0x98ae] = "\x80\x57", [0x98af] = "\x5f\xea",
  [0x98b1] = "\x5f\xeb", [0x98b2] = "\x83\x89", [0x98b3] = "\x61\xf0",
  [0x98b6] = "\x65\x48", [0x98b8] = "\x8a\xd7", [0x98ba] = "\x65\xf0",
  [0x98bb] = "\x8c\x9b", [0x98bc] = "\x66\xcc", [0x98bd] = "\x8c\x9a",
  [0x98be] = "\x8c\x9c", [0x98bf] = "\x8c\x99", [0x98c0] = "\x8e\xe4",
  [0x98c1] = "\x8d\xe0", [0x98c2] = "\x8d\xe1", [0x98c4] = "\x67\x71",
  [0x98c6] = "\x8e\xe3", [0x98c9] = "\x8e\xe2", [0x98cb] = "\x8f\xc5",
  [0x98cc] = "\x91\xa0", [0x98db] = "\x53\xf9", [0x98df] = "\x53\xfa",
  [0x98e2] = "\x56\x8b", [0x98e3] = "\x72\x6c", [0x98e5] = "\x75\xb4",
  [0x98e7] = "\x5b\x9e", [0x98e9] = "\x5b\xa1", [0x98ea] = "\x5b\x9f",
  [0x98eb] = "\x79\x74", [0x98ed] = "\x5b\xa3", [0x98ef] = "\x5b\xa0",
  [0x98f2] = "\x5b\xa2", [0x98f4] = "\x5d\xe5", [0x98f6] = "\x7c\xe9",
  [0x98f9] = "\x7c\xea", [0x98fa] = "\x83\x8b", [0x98fc] = "\x5d\xe4",
  [0x98fd] = "\x5d\xe6", [0x98fe] = "\x5d\xe7", [0x9900] = "\x80\x59",
  [0x9902] = "\x80\x58", [0x9903] = "\x5f\xec", [0x9905] = "\x5f\xed",
  [0x9907] = "\x80\x5a", [0x9908] = "\x83\x8a", [0x9909] = "\x5f\xef",
  [0x990a] = "\x61\xf1", [0x990c] = "\x5f\xee", [0x9910] = "\x63\xa6",
  [0x9911] = "\x83\x8c", [0x9912] = "\x61\xf3", [0x9913] = "\x61\xf2",
  [0x9914] = "\x83\x8d", [0x9915] = "\x83\x90", [0x9916] = "\x83\x8e",
  [0x9917] = "\x83\x8f", [0x9918] = "\x61\xf4", [0x991a] = "\x63\xab",
  [0x991b] = "\x63\xa9", [0x991e] = "\x63\xa8", [0x991f] = "\x86\x8a",
  [0x9921] = "\x63\xaa", [0x9924] = "\x86\x89", [0x9925] = "\x88\xd7",
  [0x9927] = "\x86\x8b", [0x9928] = "\x63\xa7", [0x9929] = "\x86\x8c",
  [0x992a] = "\x88\xda", [0x992b] = "\x88\xd8", [0x992c] = "\x88\xd9",
  [0x992d] = "\x88\xde", [0x992e] = "\x65\xf4", [0x992f] = "\x88\xdd",
  [0x9930] = "\x88\xe0", [0x9931] = "\x88\xdf", [0x9932] = "\x88\xdc",
  [0x9933] = "\x88\xdb", [0x9935] = "\x65\x49", [0x993a] = "\x8a\xda",
  [0x993c] = "\x8a\xd9", [0x993d] = "\x65\xf3", [0x993e] = "\x65\xf1",
  [0x993f] = "\x65\xf2", [0x9941] = "\x8a\xd8", [0x9943] = "\x8c\x9f",
  [0x9945] = "\x66\xcd", [0x9947] = "\x8c\x9e", [0x9948] = "\x8c\x9d",
  [0x9949] = "\x66\xce", [0x994b] = "\x8d\xe6", [0x994c] = "\x8d\xe5",
  [0x994e] = "\x8d\xe3", [0x9950] = "\x8d\xe2", [0x9951] = "\x67\x73",
  [0x9952] = "\x67\x72", [0x9953] = "\x8d\xe7", [0x9954] = "\x8f\xc6",
  [0x9955] = "\x68\x45", [0x9956] = "\x8e\xe6", [0x9957] = "\x67\xc2",
  [0x9958] = "\x8e\xe5", [0x9959] = "\x8d\xe4", [0x995b] = "\x8f\xc7",
  [0x995c] = "\x68\x70", [0x995e] = "\x68\xad", [0x995f] = "\x91\x6a",
  [0x9961] = "\x91\xa1", [0x9996] = "\x53\xfb", [0x9997] = "\x75\xb5",
  [0x9998] = "\x88\xe1", [0x9999] = "\x53\xfc", [0x999c] = "\x80\x5c",
  [0x999d] = "\x80\x5b", [0x999e] = "\x86\x8d", [0x99a1] = "\x88\xe3",
  [0x99a3] = "\x88\xe2", [0x99a5] = "\x65\xf5", [0x99a6] = "\x8c\xa0",
  [0x99a7] = "\x8c\xa1", [0x99a8] = "\x67\x74", [0x99ab] = "\x91\xa2",
  [0x99ac] = "\x56\x8c", [0x99ad] = "\x5b\xa5", [0x99ae] = "\x5b\xa4",
  [0x99af] = "\x7c\xeb", [0x99b0] = "\x7c\xed", [0x99b1] = "\x5d\xe9",
  [0x99b2] = "\x7c\xec", [0x99b3] = "\x5d\xe8", [0x99b4] = "\x5d\xea",
  [0x99b5] = "\x7c\xee", [0x99b9] = "\x80\x5e", [0x99ba] = "\x80\x60",
  [0x99bb] = "\x80\x5f", [0x99bd] = "\x80\x62", [0x99c1] = "\x5f\xf0",
  [0x99c2] = "\x80\x61", [0x99c3] = "\x80\x5d", [0x99c7] = "\x80\x63",
  [0x99c9] = "\x83\x97", [0x99cb] = "\x83\x9a", [0x99cc] = "\x83\x9c",
  [0x99cd] = "\x83\x92", [0x99ce] = "\x83\x96", [0x99cf] = "\x83\x93",
  [0x99d0] = "\x61\xf6", [0x99d1] = "\x61\xf9", [0x99d2] = "\x61\xfb",
  [0x99d3] = "\x83\x94", [0x99d4] = "\x83\x95", [0x99d5] = "\x61\xfa",
  [0x99d6] = "\x83\x98", [0x99d7] = "\x83\x9b", [0x99d8] = "\x83\x99",
  [0x99d9] = "\x61\xfc", [0x99db] = "\x61\xf8", [0x99dc] = "\x83\x91",
  [0x99dd] = "\x61\xf5", [0x99df] = "\x61\xf7", [0x99e2] = "\x63\xad",
  [0x99e3] = "\x86\x93", [0x99e4] = "\x86\x91", [0x99e5] = "\x86\x90",
  [0x99e7] = "\x86\x96", [0x99e9] = "\x86\x95", [0x99ea] = "\x86\x94",
  [0x99ec] = "\x86\x8f", [0x99ed] = "\x63\xac", [0x99ee] = "\x86\x8e",
  [0x99f0] = "\x86\x92", [0x99f1] = "\x63\xae", [0x99f4] = "\x88\xe6",
  [0x99f6] = "\x88\xea", [0x99f7] = "\x88\xe7", [0x99f8] = "\x88\xe9",
  [0x99f9] = "\x88\xe8", [0x99fa] = "\x88\xe5", [0x99fb] = "\x88\xeb",
  [0x99fc] = "\x88\xee", [0x99fd] = "\x88\xec", [0x99fe] = "\x88\xed",
  [0x99ff] = "\x65\x4b", [0x9a01] = "\x65\x4a", [0x9a02] = "\x88\xe4",
  [0x9a03] = "\x88\xef", [0x9a04] = "\x8a\xdf", [0x9a05] = "\x8a\xe2",
  [0x9a06] = "\x8a\xe4", [0x9a07] = "\x8a\xe3", [0x9a09] = "\x8a\xdd",
  [0x9a0a] = "\x8a\xe1", [0x9a0b] = "\x8a\xdc", [0x9a0d] = "\x8a\xde",
  [0x9a0e] = "\x65\xf6", [0x9a0f] = "\x8a\xdb", [0x9a11] = "\x8a\xe0",
  [0x9a14] = "\x8c\xae", [0x9a15] = "\x8c\xa3", [0x9a16] = "\x66\xcf",
  [0x9a19] = "\x66\xd0", [0x9a1a] = "\x8c\xa2", [0x9a1b] = "\x8c\xa7",
  [0x9a1c] = "\x8c\xad", [0x9a1d] = "\x8c\xa5", [0x9a1e] = "\x8c\xac",
  [0x9a20] = "\x8c\xa9", [0x9a22] = "\x8c\xa8", [0x9a23] = "\x8c\xab",
  [0x9a24] = "\x8c\xa6", [0x9a25] = "\x8c\xa4", [0x9a27] = "\x8c\xaa",
  [0x9a29] = "\x8d\xee", [0x9a2a] = "\x8d\xec", [0x9a2b] = "\x67\x75",
  [0x9a2c] = "\x8d\xeb", [0x9a2d] = "\x8d\xf1", [0x9a2e] = "\x8d\xef",
  [0x9a30] = "\x67\x76", [0x9a31] = "\x8d\xea", [0x9a32] = "\x8d\xe8",
  [0x9a34] = "\x8d\xe9", [0x9a35] = "\x67\x78", [0x9a36] = "\x8d\xed",
  [0x9a37] = "\x67\x77", [0x9a38] = "\x8d\xf0", [0x9a39] = "\x8e\xe7",
  [0x9a3a] = "\x8e\xed", [0x9a3d] = "\x8e\xe8", [0x9a3e] = "\x67\xc6",
  [0x9a3f] = "\x8e\xee", [0x9a40] = "\x67\xc5", [0x9a41] = "\x8e\xec",
  [0x9a42] = "\x8e\xeb", [0x9a43] = "\x67\xc4", [0x9a44] = "\x8e\xea",
  [0x9a45] = "\x67\xc3", [0x9a46] = "\x8e\xe9", [0x9a48] = "\x8f\xcd",
  [0x9a49] = "\x8f\xcf", [0x9a4a] = "\x8f\xce", [0x9a4c] = "\x8f\xcb",
  [0x9a4d] = "\x68\x47", [0x9a4e] = "\x8f\xc8", [0x9a4f] = "\x8f\xcc",
  [0x9a50] = "\x8f\xd1", [0x9a52] = "\x8f\xd0", [0x9a53] = "\x8f\xc9",
  [0x9a54] = "\x8f\xca", [0x9a55] = "\x68\x46", [0x9a56] = "\x90\x83",
  [0x9a57] = "\x68\x73", [0x9a59] = "\x90\x84", [0x9a5a] = "\x68\x71",
  [0x9a5b] = "\x68\x72", [0x9a5e] = "\x90\xe2", [0x9a5f] = "\x68\x96",
  [0x9a60] = "\x91\x88", [0x9a62] = "\x68\xb6", [0x9a64] = "\x91\xa3",
  [0x9a65] = "\x68\xb7", [0x9a66] = "\x91\xa4", [0x9a67] = "\x91\xa5",
  [0x9a68] = "\x91\xb3", [0x9a69] = "\x91\xb2", [0x9a6a] = "\x68\xc6",
  [0x9a6b] = "\x91\xbd", [0x9aa8] = "\x56\x8d", [0x9aab] = "\x7c\xf0",
  [0x9aad] = "\x7c\xef", [0x9aaf] = "\x5f\xf1", [0x9ab0] = "\x5f\xf2",
  [0x9ab1] = "\x80\x64", [0x9ab3] = "\x83\x9d", [0x9ab4] = "\x86\x99",
  [0x9ab7] = "\x61\xfd", [0x9ab8] = "\x63\xaf", [0x9ab9] = "\x86\x97",
  [0x9abb] = "\x86\x9a", [0x9abc] = "\x63\xb0", [0x9abe] = "\x88\xf0",
  [0x9abf] = "\x86\x98", [0x9ac0] = "\x8a\xe5", [0x9ac1] = "\x65\xf7",
  [0x9ac2] = "\x8c\xaf", [0x9ac6] = "\x8d\xf4", [0x9ac7] = "\x8d\xf2",
  [0x9aca] = "\x8d\xf3", [0x9acd] = "\x8e\xef", [0x9acf] = "\x67\xc7",
  [0x9ad0] = "\x8f\xd2", [0x9ad1] = "\x68\x76", [0x9ad2] = "\x68\x48",
  [0x9ad3] = "\x68\x74", [0x9ad4] = "\x68\x75", [0x9ad5] = "\x90\xe3",
  [0x9ad6] = "\x68\xae", [0x9ad8] = "\x56\x8e", [0x9adc] = "\x8a\xe6",
  [0x9adf] = "\x72\x6d", [0x9ae1] = "\x5d\xeb", [0x9ae3] = "\x80\x65",
  [0x9ae6] = "\x5f\xf3", [0x9ae7] = "\x80\x66", [0x9aeb] = "\x83\x9f",
  [0x9aec] = "\x83\x9e", [0x9aed] = "\x63\xb2", [0x9aee] = "\x62\x41",
  [0x9aef] = "\x62\x42", [0x9af1] = "\x83\xa2", [0x9af2] = "\x83\xa1",
  [0x9af3] = "\x83\xa0", [0x9af6] = "\x86\x9b", [0x9af7] = "\x86\x9e",
  [0x9af9] = "\x86\x9d", [0x9afa] = "\x86\x9c", [0x9afb] = "\x63\xb1",
  [0x9afc] = "\x88\xf4", [0x9afd] = "\x88\xf2", [0x9afe] = "\x88\xf1",
  [0x9b01] = "\x88\xf3", [0x9b03] = "\x65\xf8", [0x9b04] = "\x8a\xe8",
  [0x9b05] = "\x8a\xe9", [0x9b06] = "\x65\xf9", [0x9b08] = "\x8a\xe7",
  [0x9b0a] = "\x8c\xb1", [0x9b0b] = "\x8c\xb0", [0x9b0c] = "\x8c\xb3",
  [0x9b0d] = "\x66\xd1", [0x9b0e] = "\x8c\xb2", [0x9b10] = "\x8d\xf5",
  [0x9b11] = "\x8d\xf7", [0x9b12] = "\x8d\xf6", [0x9b15] = "\x8e\xf0",
  [0x9b16] = "\x8e\xf3", [0x9b17] = "\x8e\xf1", [0x9b18] = "\x8e\xf2",
  [0x9b19] = "\x8f\xd3", [0x9b1a] = "\x68\x49", [0x9b1e] = "\x90\x85",
  [0x9b1f] = "\x90\x86", [0x9b20] = "\x90\x87", [0x9b22] = "\x68\x97",
  [0x9b23] = "\x68\xaf", [0x9b24] = "\x91\xa6", [0x9b25] = "\x56\x8f",
  [0x9b27] = "\x62\x43", [0x9b28] = "\x63\xb3", [0x9b29] = "\x8a\xea",
  [0x9b2b] = "\x8f\xd4", [0x9b2e] = "\x91\xb4", [0x9b2f] = "\x72\x6e",
  [0x9b31] = "\x68\xc7", [0x9b32] = "\x56\x90", [0x9b33] = "\x86\x9f",
  [0x9b35] = "\x8a\xeb", [0x9b37] = "\x8c\xb4", [0x9b3a] = "\x8e\xf4",
  [0x9b3b] = "\x8f\xd5", [0x9b3c] = "\x56\x91", [0x9b3e] = "\x80\x67",
  [0x9b3f] = "\x80\x68", [0x9b41] = "\x5f\xf4", [0x9b42] = "\x5f\xf5",
  [0x9b43] = "\x83\xa4", [0x9b44] = "\x62\x45", [0x9b45] = "\x62\x44",
  [0x9b46] = "\x83\xa3", [0x9b48] = "\x88\xf5", [0x9b4a] = "\x8a\xec",
  [0x9b4b] = "\x8a\xee", [0x9b4c] = "\x8a\xed", [0x9b4d] = "\x65\xfc",
  [0x9b4e] = "\x65\xfb", [0x9b4f] = "\x65\xfa", [0x9b51] = "\x67\xc9",
  [0x9b52] = "\x8e\xf5", [0x9b54] = "\x67\xc8", [0x9b55] = "\x8f\xd7",
  [0x9b56] = "\x8f\xd6", [0x9b58] = "\x68\x98", [0x9b59] = "\x90\xe4",
  [0x9b5a] = "\x59\x43", [0x9b5b] = "\x7c\xf1", [0x9b5f] = "\x80\x6b",
  [0x9b60] = "\x80\x69", [0x9b61] = "\x80\x6a", [0x9b64] = "\x83\xad",
  [0x9b66] = "\x83\xa8", [0x9b67] = "\x83\xa5", [0x9b68] = "\x83\xac",
  [0x9b6c] = "\x83\xae", [0x9b6f] = "\x62\x47", [0x9b70] = "\x83\xab",
  [0x9b71] = "\x83\xa7", [0x9b74] = "\x83\xa6", [0x9b75] = "\x83\xaa",
  [0x9b76] = "\x83\xa9", [0x9b77] = "\x62\x46", [0x9b7a] = "\x86\xaa",
  [0x9b7b] = "\x86\xa5", [0x9b7c] = "\x86\xa3", [0x9b7d] = "\x86\xac",
  [0x9b7e] = "\x86\xa4", [0x9b80] = "\x86\xa0", [0x9b82] = "\x86\xa6",
  [0x9b85] = "\x86\xa1", [0x9b86] = "\x89\x41", [0x9b87] = "\x86\xa2",
  [0x9b88] = "\x86\xad", [0x9b90] = "\x86\xa9", [0x9b91] = "\x63\xb4",
  [0x9b92] = "\x86\xa8", [0x9b93] = "\x86\xa7", [0x9b95] = "\x86\xab",
  [0x9b9a] = "\x88\xf6", [0x9b9b] = "\x88\xf9", [0x9b9e] = "\x88\xf8",
  [0x9ba0] = "\x89\x43", [0x9ba1] = "\x88\xfb", [0x9ba2] = "\x89\x42",
  [0x9ba4] = "\x88\xfd", [0x9ba5] = "\x88\xfc", [0x9ba6] = "\x88\xfa",
  [0x9ba8] = "\x88\xf7", [0x9baa] = "\x65\x4e", [0x9bab] = "\x65\x4d",
  [0x9bad] = "\x65\x4f", [0x9bae] = "\x65\x4c", [0x9baf] = "\x89\x44",
  [0x9bb5] = "\x8a\xf4", [0x9bb6] = "\x8a\xf7", [0x9bb8] = "\x8a\xf5",
  [0x9bb9] = "\x8a\xf9", [0x9bbd] = "\x8a\xfa", [0x9bbf] = "\x8a\xf2",
  [0x9bc0] = "\x66\x44", [0x9bc1] = "\x8a\xf3", [0x9bc3] = "\x8a\xf1",
  [0x9bc4] = "\x8a\xf8", [0x9bc6] = "\x8a\xf0", [0x9bc7] = "\x8a\xef",
  [0x9bc8] = "\x66\x43", [0x9bc9] = "\x66\x41", [0x9bca] = "\x65\xfd",
  [0x9bd3] = "\x8a\xf6", [0x9bd4] = "\x8c\xbd", [0x9bd5] = "\x8c\xc3",
  [0x9bd6] = "\x66\xd4", [0x9bd7] = "\x8c\xbe", [0x9bd9] = "\x8c\xc1",
  [0x9bda] = "\x8c\xc5", [0x9bdb] = "\x66\xd5", [0x9bdc] = "\x8c\xc0",
  [0x9bde] = "\x8c\xb8", [0x9be0] = "\x8c\xb7", [0x9be1] = "\x8c\xc4",
  [0x9be2] = "\x8c\xbb", [0x9be4] = "\x8c\xb9", [0x9be5] = "\x8c\xc2",
  [0x9be6] = "\x8c\xba", [0x9be7] = "\x66\xd3", [0x9be8] = "\x66\xd2",
  [0x9bea] = "\x8c\xb5", [0x9beb] = "\x8c\xb6", [0x9bec] = "\x8c\xbf",
  [0x9bf0] = "\x8c\xbc", [0x9bf7] = "\x8d\xfa", [0x9bf8] = "\x8d\xfd",
  [0x9bfd] = "\x66\x42", [0x9c05] = "\x8d\xfb", [0x9c06] = "\x8e\x44",
  [0x9c07] = "\x8e\x42", [0x9c08] = "\x8d\xf9", [0x9c09] = "\x8e\x47",
  [0x9c0b] = "\x8d\xf8", [0x9c0d] = "\x67\x7a", [0x9c0e] = "\x8e\x43",
  [0x9c12] = "\x8d\xfc", [0x9c13] = "\x67\x79", [0x9c14] = "\x8e\x46",
  [0x9c17] = "\x8e\x45", [0x9c1c] = "\x8e\xf8", [0x9c1d] = "\x8e\xf7",
  [0x9c21] = "\x8f\x41", [0x9c23] = "\x8e\xfa", [0x9c24] = "\x8e\xfd",
  [0x9c25] = "\x67\xcb", [0x9c28] = "\x8e\xfb", [0x9c29] = "\x8e\xfc",
  [0x9c2b] = "\x8e\xf6", [0x9c2c] = "\x8e\xf9", [0x9c2d] = "\x67\xca",
  [0x9c31] = "\x68\x4b", [0x9c32] = "\x8f\xe2", [0x9c33] = "\x8f\xdd",
  [0x9c34] = "\x8f\xe1", [0x9c36] = "\x8f\xe4", [0x9c37] = "\x8f\xe0",
  [0x9c39] = "\x8f\xdc", [0x9c3b] = "\x68\x4d", [0x9c3c] = "\x8f\xdf",
  [0x9c3d] = "\x8f\xe3", [0x9c3e] = "\x68\x4c", [0x9c3f] = "\x8f\xda",
  [0x9c40] = "\x8e\x41", [0x9c41] = "\x8f\xde", [0x9c44] = "\x8f\xdb",
  [0x9c46] = "\x8f\xd8", [0x9c48] = "\x8f\xd9", [0x9c49] = "\x68\x4a",
  [0x9c4a] = "\x90\x8b", [0x9c4b] = "\x90\x8d", [0x9c4c] = "\x90\x90",
  [0x9c4d] = "\x90\x8c", [0x9c4e] = "\x90\x91", [0x9c50] = "\x90\x8a",
  [0x9c52] = "\x90\x88", [0x9c54] = "\x68\x77", [0x9c55] = "\x90\x8e",
  [0x9c56] = "\x68\x79", [0x9c57] = "\x68\x78", [0x9c58] = "\x90\x89",
  [0x9c59] = "\x90\x8f", [0x9c5e] = "\x90\xe9", [0x9c5f] = "\x68\x99",
  [0x9c60] = "\x90\xea", [0x9c62] = "\x90\xe8", [0x9c63] = "\x90\xe5",
  [0x9c66] = "\x90\xe7", [0x9c67] = "\x90\xe6", [0x9c68] = "\x91\x6b",
  [0x9c6d] = "\x91\x6d", [0x9c6e] = "\x91\x6c", [0x9c71] = "\x91\x8b",
  [0x9c73] = "\x91\x8a", [0x9c74] = "\x91\x89", [0x9c75] = "\x91\x8c",
  [0x9c77] = "\x68\xbf", [0x9c78] = "\x68\xc0", [0x9c79] = "\x91\xba",
  [0x9c7a] = "\x91\xbe", [0x9ce5] = "\x59\x44", [0x9ce6] = "\x79\x75",
  [0x9ce7] = "\x7c\xf4", [0x9ce9] = "\x5d\xec", [0x9cea] = "\x7c\xf2",
  [0x9ced] = "\x7c\xf3", [0x9cf1] = "\x80\x6c", [0x9cf2] = "\x80\x6d",
  [0x9cf3] = "\x5f\xf8", [0x9cf4] = "\x5f\xf6", [0x9cf5] = "\x80\x6e",
  [0x9cf6] = "\x5f\xf7", [0x9cf7] = "\x83\xb3", [0x9cf9] = "\x83\xb6",
  [0x9cfa] = "\x83\xb0", [0x9cfb] = "\x83\xb7", [0x9cfc] = "\x83\xaf",
  [0x9cfd] = "\x83\xb1", [0x9cff] = "\x83\xb2", [0x9d00] = "\x83\xb5",
  [0x9d03] = "\x62\x4a", [0x9d04] = "\x83\xba", [0x9d05] = "\x83\xb9",
  [0x9d06] = "\x62\x48", [0x9d07] = "\x83\xb4", [0x9d08] = "\x83\xb8",
  [0x9d09] = "\x62\x49", [0x9d10] = "\x86\xb7", [0x9d12] = "\x63\xb9",
  [0x9d14] = "\x86\xb2", [0x9d15] = "\x63\xb5", [0x9d17] = "\x86\xaf",
  [0x9d18] = "\x86\xb5", [0x9d19] = "\x86\xb8", [0x9d1b] = "\x63\xba",
  [0x9d1d] = "\x86\xb4", [0x9d1e] = "\x86\xb1", [0x9d1f] = "\x86\xb9",
  [0x9d20] = "\x86\xb0", [0x9d22] = "\x86\xb6", [0x9d23] = "\x63\xb6",
  [0x9d25] = "\x86\xae", [0x9d26] = "\x63\xb7", [0x9d28] = "\x63\xb8",
  [0x9d29] = "\x86\xb3", [0x9d2d] = "\x89\x56", [0x9d2e] = "\x89\x49",
  [0x9d2f] = "\x89\x4a", [0x9d30] = "\x89\x4d", [0x9d31] = "\x89\x4b",
  [0x9d33] = "\x89\x45", [0x9d36] = "\x89\x48", [0x9d37] = "\x89\x52",
  [0x9d38] = "\x89\x4c", [0x9d3b] = "\x65\x50", [0x9d3d] = "\x89\x54",
  [0x9d3e] = "\x89\x51", [0x9d3f] = "\x65\x51", [0x9d40] = "\x89\x53",
  [0x9d41] = "\x89\x46", [0x9d42] = "\x89\x4f", [0x9d43] = "\x89\x50",
  [0x9d45] = "\x89\x4e", [0x9d4a] = "\x8b\x41", [0x9d4b] = "\x8b\x43",
  [0x9d4c] = "\x8b\x46", [0x9d4f] = "\x8a\xfd", [0x9d51] = "\x66\x45",
  [0x9d52] = "\x8b\x48", [0x9d53] = "\x8a\xfc", [0x9d54] = "\x8b\x49",
  [0x9d56] = "\x8b\x45", [0x9d57] = "\x8b\x47", [0x9d58] = "\x8b\x4b",
  [0x9d59] = "\x8b\x44", [0x9d5a] = "\x8b\x4c", [0x9d5b] = "\x8b\x42",
  [0x9d5c] = "\x8a\xfb", [0x9d5d] = "\x66\x46", [0x9d5f] = "\x8b\x4a",
  [0x9d60] = "\x66\x47", [0x9d61] = "\x66\xd7", [0x9d67] = "\x89\x47",
  [0x9d68] = "\x8c\xdf", [0x9d69] = "\x8c\xd6", [0x9d6a] = "\x66\xd9",
  [0x9d6b] = "\x8c\xd2", [0x9d6c] = "\x66\xda", [0x9d6f] = "\x8c\xdb",
  [0x9d70] = "\x8c\xd5", [0x9d71] = "\x8c\xcb", [0x9d72] = "\x66\xd8",
  [0x9d73] = "\x8c\xd8", [0x9d74] = "\x8c\xd3", [0x9d75] = "\x8c\xd4",
  [0x9d77] = "\x8c\xc6", [0x9d78] = "\x8c\xcd", [0x9d79] = "\x8c\xdc",
  [0x9d7b] = "\x8c\xd9", [0x9d7d] = "\x8c\xd1", [0x9d7f] = "\x8c\xdd",
  [0x9d80] = "\x8c\xcc", [0x9d81] = "\x8c\xc7", [0x9d82] = "\x8c\xda",
  [0x9d84] = "\x8c\xc9", [0x9d85] = "\x8c\xd7", [0x9d86] = "\x8c\xce",
  [0x9d87] = "\x8c\xde", [0x9d88] = "\x8c\xca", [0x9d89] = "\x66\xd6",
  [0x9d8a] = "\x8c\xc8", [0x9d8b] = "\x8c\xcf", [0x9d8c] = "\x8c\xd0",
  [0x9d90] = "\x8e\x4e", [0x9d92] = "\x8e\x4c", [0x9d94] = "\x8e\x51",
  [0x9d96] = "\x8e\x5d", [0x9d97] = "\x8e\x54", [0x9d98] = "\x8e\x4d",
  [0x9d99] = "\x8e\x49", [0x9d9a] = "\x8e\x56", [0x9d9b] = "\x8e\x4f",
  [0x9d9c] = "\x8e\x52", [0x9d9d] = "\x8e\x4b", [0x9d9e] = "\x8e\x59",
  [0x9d9f] = "\x8e\x48", [0x9da0] = "\x8e\x50", [0x9da1] = "\x8e\x55",
  [0x9da2] = "\x8e\x57", [0x9da3] = "\x8e\x5a", [0x9da4] = "\x8e\x4a",
  [0x9da6] = "\x8e\x5e", [0x9da7] = "\x8e\x5f", [0x9da8] = "\x8e\x58",
  [0x9da9] = "\x8e\x5c", [0x9daa] = "\x8e\x53", [0x9dac] = "\x8f\x51",
  [0x9dad] = "\x8f\x54", [0x9daf] = "\x67\xcc", [0x9db1] = "\x8f\x53",
  [0x9db2] = "\x8f\x58", [0x9db3] = "\x8f\x56", [0x9db4] = "\x67\xcd",
  [0x9db5] = "\x8f\x4d", [0x9db6] = "\x8f\x43", [0x9db7] = "\x8f\x42",
  [0x9db8] = "\x67\xcf", [0x9db9] = "\x8f\x4f", [0x9dba] = "\x8f\x50",
  [0x9dbb] = "\x8f\x4c", [0x9dbc] = "\x8f\x44", [0x9dbe] = "\x8f\x49",
  [0x9dbf] = "\x8e\x5b", [0x9dc1] = "\x8f\x45", [0x9dc2] = "\x67\xce",
  [0x9dc3] = "\x8f\x4b", [0x9dc5] = "\x8f\x4a", [0x9dc7] = "\x8f\x46",
  [0x9dc8] = "\x8f\x52", [0x9dca] = "\x8f\x47", [0x9dcb] = "\x8f\xe9",
  [0x9dcc] = "\x8f\x55", [0x9dcd] = "\x8f\x57", [0x9dce] = "\x8f\x4e",
  [0x9dcf] = "\x8f\x48", [0x9dd0] = "\x8f\xea", [0x9dd1] = "\x8f\xec",
  [0x9dd2] = "\x8f\xe6", [0x9dd3] = "\x68\x4e", [0x9dd5] = "\x8f\xf3",
  [0x9dd6] = "\x8f\xf1", [0x9dd7] = "\x68\x4f", [0x9dd8] = "\x8f\xf0",
  [0x9dd9] = "\x8f\xef", [0x9dda] = "\x8f\xe8", [0x9ddb] = "\x8f\xe5",
  [0x9ddc] = "\x8f\xeb", [0x9ddd] = "\x8f\xf4", [0x9dde] = "\x8f\xe7",
  [0x9ddf] = "\x8f\xed", [0x9de1] = "\x90\x9a", [0x9de2] = "\x90\x9f",
  [0x9de3] = "\x90\x95", [0x9de4] = "\x90\x98", [0x9de5] = "\x68\x7a",
  [0x9de6] = "\x90\x9c", [0x9de8] = "\x90\xa3", [0x9de9] = "\x8f\xee",
  [0x9deb] = "\x90\x96", [0x9dec] = "\x90\xa0", [0x9ded] = "\x90\xa4",
  [0x9dee] = "\x90\x9b", [0x9def] = "\x90\x94", [0x9df0] = "\x90\x9e",
  [0x9df2] = "\x90\x9d", [0x9df3] = "\x90\xa2", [0x9df4] = "\x90\xa1",
  [0x9df5] = "\x8f\xf2", [0x9df6] = "\x90\x99", [0x9df7] = "\x90\x93",
  [0x9df8] = "\x90\x97", [0x9df9] = "\x68\x9a", [0x9dfa] = "\x68\x9b",
  [0x9dfb] = "\x90\x92", [0x9dfd] = "\x90\xf5", [0x9dfe] = "\x90\xec",
  [0x9dff] = "\x90\xf4", [0x9e00] = "\x90\xf1", [0x9e01] = "\x90\xf2",
  [0x9e02] = "\x90\xeb", [0x9e03] = "\x90\xee", [0x9e04] = "\x90\xf6",
  [0x9e05] = "\x90\xf0", [0x9e06] = "\x90\xef", [0x9e07] = "\x90\xed",
  [0x9e09] = "\x90\xf3", [0x9e0b] = "\x91\x6e", [0x9e0d] = "\x91\x6f",
  [0x9e0f] = "\x91\x71", [0x9e10] = "\x91\x70", [0x9e11] = "\x91\x73",
  [0x9e12] = "\x91\x72", [0x9e13] = "\x91\x8e", [0x9e14] = "\x91\x8d",
  [0x9e15] = "\x91\xa7", [0x9e17] = "\x91\xa8", [0x9e19] = "\x91\xb5",
  [0x9e1a] = "\x68\xc4", [0x9e1b] = "\x68\xc8", [0x9e1d] = "\x91\xbf",
  [0x9e1e] = "\x68\xc9", [0x9e75] = "\x59\x45", [0x9e79] = "\x67\x7b",
  [0x9e7a] = "\x8f\x59", [0x9e7c] = "\x68\x9c", [0x9e7d] = "\x68\x9d",
  [0x9e7f] = "\x59\x46", [0x9e80] = "\x7c\xf5", [0x9e82] = "\x5d\xed",
  [0x9e83] = "\x83\xbb", [0x9e86] = "\x86\xbb", [0x9e87] = "\x86\xbc",
  [0x9e88] = "\x86\xba", [0x9e89] = "\x89\x58", [0x9e8a] = "\x89\x57",
  [0x9e8b] = "\x65\x52", [0x9e8c] = "\x8b\x4e", [0x9e8d] = "\x89\x59",
  [0x9e8e] = "\x8b\x4d", [0x9e91] = "\x8c\xe1", [0x9e92] = "\x66\xdb",
  [0x9e93] = "\x66\xdd", [0x9e94] = "\x8c\xe0", [0x9e97] = "\x66\xdc",
  [0x9e99] = "\x8e\x60", [0x9e9a] = "\x8e\x62", [0x9e9b] = "\x8e\x61",
  [0x9e9c] = "\x8f\x5a", [0x9e9d] = "\x67\xd0", [0x9e9f] = "\x68\x7b",
  [0x9ea0] = "\x90\xf7", [0x9ea1] = "\x91\x74", [0x9ea4] = "\x91\xc2",
  [0x9ea5] = "\x59\x47", [0x9ea7] = "\x80\x6f", [0x9ea9] = "\x62\x4b",
  [0x9ead] = "\x86\xbe", [0x9eae] = "\x86\xbd", [0x9eb0] = "\x89\x5a",
  [0x9eb4] = "\x66\xde", [0x9eb5] = "\x67\x7c", [0x9eb6] = "\x8f\xf5",
  [0x9eb7] = "\x91\xbb", [0x9ebb] = "\x59\x48", [0x9ebc] = "\x5f\xf9",
  [0x9ebe] = "\x62\x4c", [0x9ec0] = "\x8c\xe2", [0x9ec2] = "\x90\xa5",
  [0x9ec3] = "\x5b\xa6", [0x9ec8] = "\x89\x5b", [0x9ecc] = "\x68\xb0",
  [0x9ecd] = "\x5b\xa7", [0x9ece] = "\x62\x4d", [0x9ecf] = "\x65\x53",
  [0x9ed0] = "\x90\xa6", [0x9ed1] = "\x5b\xa8", [0x9ed3] = "\x83\xbc",
  [0x9ed4] = "\x63\xbc", [0x9ed5] = "\x86\xbf", [0x9ed6] = "\x86\xc0",
  [0x9ed8] = "\x63\xbb", [0x9eda] = "\x89\x5c", [0x9edb] = "\x65\x57",
  [0x9edc] = "\x65\x55", [0x9edd] = "\x65\x56", [0x9ede] = "\x65\x54",
  [0x9edf] = "\x8b\x4f", [0x9ee0] = "\x66\x48", [0x9ee4] = "\x8e\x64",
  [0x9ee5] = "\x8e\x63", [0x9ee6] = "\x8e\x66", [0x9ee7] = "\x8e\x65",
  [0x9ee8] = "\x67\x7d", [0x9eeb] = "\x8f\x5b", [0x9eed] = "\x8f\x5d",
  [0x9eee] = "\x8f\x5c", [0x9eef] = "\x67\xd1", [0x9ef0] = "\x8f\xf6",
  [0x9ef2] = "\x90\xa7", [0x9ef3] = "\x90\xa8", [0x9ef4] = "\x68\x7c",
  [0x9ef5] = "\x91\x75", [0x9ef6] = "\x91\x8f", [0x9ef7] = "\x68\xc1",
  [0x9ef9] = "\x79\x76", [0x9efa] = "\x86\xc1", [0x9efb] = "\x89\x5d",
  [0x9efc] = "\x8c\xe3", [0x9efd] = "\x7c\xf6", [0x9eff] = "\x89\x5e",
  [0x9f00] = "\x8b\x51", [0x9f01] = "\x8b\x50", [0x9f06] = "\x90\xa9",
  [0x9f07] = "\x68\x9e", [0x9f09] = "\x91\x76", [0x9f0a] = "\x91\x90",
  [0x9f0e] = "\x5d\xee", [0x9f0f] = "\x83\xbd", [0x9f10] = "\x83\xbe",
  [0x9f12] = "\x86\xc2", [0x9f13] = "\x5d\xef", [0x9f15] = "\x66\x49",
  [0x9f16] = "\x8b\x52", [0x9f18] = "\x8f\x5f", [0x9f19] = "\x67\xd2",
  [0x9f1a] = "\x8f\x60", [0x9f1b] = "\x8f\x5e", [0x9f1c] = "\x90\xaa",
  [0x9f1e] = "\x90\xf8", [0x9f20] = "\x5d\xf0", [0x9f22] = "\x89\x61",
  [0x9f23] = "\x89\x60", [0x9f24] = "\x89\x5f", [0x9f25] = "\x8b\x53",
  [0x9f28] = "\x8b\x57", [0x9f29] = "\x8b\x56", [0x9f2a] = "\x8b\x55",
  [0x9f2b] = "\x8b\x54", [0x9f2c] = "\x66\x4a", [0x9f2d] = "\x8c\xe4",
  [0x9f2e] = "\x8e\x68", [0x9f2f] = "\x67\x7e", [0x9f30] = "\x8e\x67",
  [0x9f31] = "\x8f\x61", [0x9f32] = "\x8f\xf9", [0x9f33] = "\x8f\xf8",
  [0x9f34] = "\x68\x50", [0x9f35] = "\x8f\xf7", [0x9f36] = "\x90\xad",
  [0x9f37] = "\x90\xac", [0x9f38] = "\x90\xab", [0x9f3b] = "\x5f\xfa",
  [0x9f3d] = "\x86\xc3", [0x9f3e] = "\x65\x58", [0x9f40] = "\x8c\xe5",
  [0x9f41] = "\x8c\xe6", [0x9f42] = "\x8f\xfa", [0x9f43] = "\x90\xae",
  [0x9f46] = "\x90\xf9", [0x9f47] = "\x91\x77", [0x9f48] = "\x91\xa9",
  [0x9f49] = "\x91\xc4", [0x9f4a] = "\x5f\xfb", [0x9f4b] = "\x65\x59",
  [0x9f4c] = "\x8b\x58", [0x9f4d] = "\x8c\xe7", [0x9f4e] = "\x8f\x62",
  [0x9f4f] = "\x90\xaf", [0x9f52] = "\x62\x4f", [0x9f54] = "\x89\x62",
  [0x9f55] = "\x8b\x59", [0x9f56] = "\x8c\xe8", [0x9f57] = "\x8c\xe9",
  [0x9f58] = "\x8c\xea", [0x9f59] = "\x8e\x6d", [0x9f5b] = "\x8e\x69",
  [0x9f5c] = "\x67\xd3", [0x9f5d] = "\x8e\x6c", [0x9f5e] = "\x8e\x6b",
  [0x9f5f] = "\x67\x7f", [0x9f60] = "\x8e\x6a", [0x9f61] = "\x67\x82",
  [0x9f63] = "\x67\x81", [0x9f64] = "\x8f\x64", [0x9f65] = "\x8f\x63",
  [0x9f66] = "\x67\xd4", [0x9f67] = "\x67\xd5", [0x9f6a] = "\x68\x52",
  [0x9f6b] = "\x8f\xfb", [0x9f6c] = "\x68\x51", [0x9f6e] = "\x90\xb2",
  [0x9f6f] = "\x90\xb3", [0x9f70] = "\x90\xb1", [0x9f71] = "\x90\xb0",
  [0x9f72] = "\x68\xa0", [0x9f74] = "\x90\xfa", [0x9f75] = "\x90\xfb",
  [0x9f76] = "\x90\xfc", [0x9f77] = "\x68\x9f", [0x9f78] = "\x91\x78",
  [0x9f79] = "\x91\x7b", [0x9f7a] = "\x91\x7a", [0x9f7b] = "\x91\x79",
  [0x9f7e] = "\x91\xc3", [0x9f8d] = "\x63\xbd", [0x9f90] = "\x66\x51",
  [0x9f91] = "\x8e\x6e", [0x9f92] = "\x8f\x65", [0x9f94] = "\x68\x53",
  [0x9f95] = "\x8f\xfc", [0x9f98] = "\x91\xc5", [0x9f9c] = "\x63\xbe",
  [0x9fa0] = "\x89\x63", [0x9fa2] = "\x8f\xfd", [0x9fa4] = "\x91\x91",
  [0xe000] = "\xc2\x41", [0xe001] = "\xc2\x42", [0xe002] = "\xc2\x43",
  [0xe003] = "\xc2\x44", [0xe004] = "\xc2\x45", [0xe005] = "\xc2\x46",
  [0xe006] = "\xc2\x47", [0xe007] = "\xc2\x48", [0xe008] = "\xc2\x49",
  [0xe009] = "\xc2\x4a", [0xe00a] = "\xc2\x4b", [0xe00b] = "\xc2\x4c",
  [0xe00c] = "\xc2\x4d", [0xe00d] = "\xc2\x4e", [0xe00e] = "\xc2\x4f",
  [0xe00f] = "\xc2\x50", [0xe010] = "\xc2\x51", [0xe011] = "\xc2\x52",
  [0xe012] = "\xc2\x53", [0xe013] = "\xc2\x54", [0xe014] = "\xc2\x55",
  [0xe015] = "\xc2\x56", [0xe016] = "\xc2\x57", [0xe017] = "\xc2\x58",
  [0xe018] = "\xc2\x59", [0xe019] = "\xc2\x5a", [0xe01a] = "\xc2\x5b",
  [0xe01b] = "\xc2\x5c", [0xe01c] = "\xc2\x5d", [0xe01d] = "\xc2\x5e",
  [0xe01e] = "\xc2\x5f", [0xe01f] = "\xc2\x60", [0xe020] = "\xc2\x61",
  [0xe021] = "\xc2\x62", [0xe022] = "\xc2\x63", [0xe023] = "\xc2\x64",
  [0xe024] = "\xc2\x65", [0xe025] = "\xc2\x66", [0xe026] = "\xc2\x67",
  [0xe027] = "\xc2\x68", [0xe028] = "\xc2\x69", [0xe029] = "\xc2\x6a",
  [0xe02a] = "\xc2\x6b", [0xe02b] = "\xc2\x6c", [0xe02c] = "\xc2\x6d",
  [0xe02d] = "\xc2\x6e", [0xe02e] = "\xc2\x6f", [0xe02f] = "\xc2\x70",
  [0xe030] = "\xc2\x71", [0xe031] = "\xc2\x72", [0xe032] = "\xc2\x73",
  [0xe033] = "\xc2\x74", [0xe034] = "\xc2\x75", [0xe035] = "\xc2\x76",
  [0xe036] = "\xc2\x77", [0xe037] = "\xc2\x78", [0xe038] = "\xc2\x79",
  [0xe039] = "\xc2\x7a", [0xe03a] = "\xc2\x7b", [0xe03b] = "\xc2\x7c",
  [0xe03c] = "\xc2\x7d", [0xe03d] = "\xc2\x7e", [0xe03e] = "\xc2\x7f",
  [0xe03f] = "\xc2\x81", [0xe040] = "\xc2\x82", [0xe041] = "\xc2\x83",
  [0xe042] = "\xc2\x84", [0xe043] = "\xc2\x85", [0xe044] = "\xc2\x86",
  [0xe045] = "\xc2\x87", [0xe046] = "\xc2\x88", [0xe047] = "\xc2\x89",
  [0xe048] = "\xc2\x8a", [0xe049] = "\xc2\x8b", [0xe04a] = "\xc2\x8c",
  [0xe04b] = "\xc2\x8d", [0xe04c] = "\xc2\x8e", [0xe04d] = "\xc2\x8f",
  [0xe04e] = "\xc2\x90", [0xe04f] = "\xc2\x91", [0xe050] = "\xc2\x92",
  [0xe051] = "\xc2\x93", [0xe052] = "\xc2\x94", [0xe053] = "\xc2\x95",
  [0xe054] = "\xc2\x96", [0xe055] = "\xc2\x97", [0xe056] = "\xc2\x98",
  [0xe057] = "\xc2\x99", [0xe058] = "\xc2\x9a", [0xe059] = "\xc2\x9b",
  [0xe05a] = "\xc2\x9c", [0xe05b] = "\xc2\x9d", [0xe05c] = "\xc2\x9e",
  [0xe05d] = "\xc2\x9f", [0xe05e] = "\xc2\xa0", [0xe05f] = "\xc2\xa1",
  [0xe060] = "\xc2\xa2", [0xe061] = "\xc2\xa3", [0xe062] = "\xc2\xa4",
  [0xe063] = "\xc2\xa5", [0xe064] = "\xc2\xa6", [0xe065] = "\xc2\xa7",
  [0xe066] = "\xc2\xa8", [0xe067] = "\xc2\xa9", [0xe068] = "\xc2\xaa",
  [0xe069] = "\xc2\xab", [0xe06a] = "\xc2\xac", [0xe06b] = "\xc2\xad",
  [0xe06c] = "\xc2\xae", [0xe06d] = "\xc2\xaf", [0xe06e] = "\xc2\xb0",
  [0xe06f] = "\xc2\xb1", [0xe070] = "\xc2\xb2", [0xe071] = "\xc2\xb3",
  [0xe072] = "\xc2\xb4", [0xe073] = "\xc2\xb5", [0xe074] = "\xc2\xb6",
  [0xe075] = "\xc2\xb7", [0xe076] = "\xc2\xb8", [0xe077] = "\xc2\xb9",
  [0xe078] = "\xc2\xba", [0xe079] = "\xc2\xbb", [0xe07a] = "\xc2\xbc",
  [0xe07b] = "\xc2\xbd", [0xe07c] = "\xc2\xbe", [0xe07d] = "\xc2\xbf",
  [0xe07e] = "\xc2\xc0", [0xe07f] = "\xc2\xc1", [0xe080] = "\xc2\xc2",
  [0xe081] = "\xc2\xc3", [0xe082] = "\xc2\xc4", [0xe083] = "\xc2\xc5",
  [0xe084] = "\xc2\xc6", [0xe085] = "\xc2\xc7", [0xe086] = "\xc2\xc8",
  [0xe087] = "\xc2\xc9", [0xe088] = "\xc2\xca", [0xe089] = "\xc2\xcb",
  [0xe08a] = "\xc2\xcc", [0xe08b] = "\xc2\xcd", [0xe08c] = "\xc2\xce",
  [0xe08d] = "\xc2\xcf", [0xe08e] = "\xc2\xd0", [0xe08f] = "\xc2\xd1",
  [0xe090] = "\xc2\xd2", [0xe091] = "\xc2\xd3", [0xe092] = "\xc2\xd4",
  [0xe093] = "\xc2\xd5", [0xe094] = "\xc2\xd6", [0xe095] = "\xc2\xd7",
  [0xe096] = "\xc2\xd8", [0xe097] = "\xc2\xd9", [0xe098] = "\xc2\xda",
  [0xe099] = "\xc2\xdb", [0xe09a] = "\xc2\xdc", [0xe09b] = "\xc2\xdd",
  [0xe09c] = "\xc2\xde", [0xe09d] = "\xc2\xdf", [0xe09e] = "\xc2\xe0",
  [0xe09f] = "\xc2\xe1", [0xe0a0] = "\xc2\xe2", [0xe0a1] = "\xc2\xe3",
  [0xe0a2] = "\xc2\xe4", [0xe0a3] = "\xc2\xe5", [0xe0a4] = "\xc2\xe6",
  [0xe0a5] = "\xc2\xe7", [0xe0a6] = "\xc2\xe8", [0xe0a7] = "\xc2\xe9",
  [0xe0a8] = "\xc2\xea", [0xe0a9] = "\xc2\xeb", [0xe0aa] = "\xc2\xec",
  [0xe0ab] = "\xc2\xed", [0xe0ac] = "\xc2\xee", [0xe0ad] = "\xc2\xef",
  [0xe0ae] = "\xc2\xf0", [0xe0af] = "\xc2\xf1", [0xe0b0] = "\xc2\xf2",
  [0xe0b1] = "\xc2\xf3", [0xe0b2] = "\xc2\xf4", [0xe0b3] = "\xc2\xf5",
  [0xe0b4] = "\xc2\xf6", [0xe0b5] = "\xc2\xf7", [0xe0b6] = "\xc2\xf8",
  [0xe0b7] = "\xc2\xf9", [0xe0b8] = "\xc2\xfa", [0xe0b9] = "\xc2\xfb",
  [0xe0ba] = "\xc2\xfc", [0xe0bb] = "\xc2\xfd", [0xe0bc] = "\xc3\x41",
  [0xe0bd] = "\xc3\x42", [0xe0be] = "\xc3\x43", [0xe0bf] = "\xc3\x44",
  [0xe0c0] = "\xc3\x45", [0xe0c1] = "\xc3\x46", [0xe0c2] = "\xc3\x47",
  [0xe0c3] = "\xc3\x48", [0xe0c4] = "\xc3\x49", [0xe0c5] = "\xc3\x4a",
  [0xe0c6] = "\xc3\x4b", [0xe0c7] = "\xc3\x4c", [0xe0c8] = "\xc3\x4d",
  [0xe0c9] = "\xc3\x4e", [0xe0ca] = "\xc3\x4f", [0xe0cb] = "\xc3\x50",
  [0xe0cc] = "\xc3\x51", [0xe0cd] = "\xc3\x52", [0xe0ce] = "\xc3\x53",
  [0xe0cf] = "\xc3\x54", [0xe0d0] = "\xc3\x55", [0xe0d1] = "\xc3\x56",
  [0xe0d2] = "\xc3\x57", [0xe0d3] = "\xc3\x58", [0xe0d4] = "\xc3\x59",
  [0xe0d5] = "\xc3\x5a", [0xe0d6] = "\xc3\x5b", [0xe0d7] = "\xc3\x5c",
  [0xe0d8] = "\xc3\x5d", [0xe0d9] = "\xc3\x5e", [0xe0da] = "\xc3\x5f",
  [0xe0db] = "\xc3\x60", [0xe0dc] = "\xc3\x61", [0xe0dd] = "\xc3\x62",
  [0xe0de] = "\xc3\x63", [0xe0df] = "\xc3\x64", [0xe0e0] = "\xc3\x65",
  [0xe0e1] = "\xc3\x66", [0xe0e2] = "\xc3\x67", [0xe0e3] = "\xc3\x68",
  [0xe0e4] = "\xc3\x69", [0xe0e5] = "\xc3\x6a", [0xe0e6] = "\xc3\x6b",
  [0xe0e7] = "\xc3\x6c", [0xe0e8] = "\xc3\x6d", [0xe0e9] = "\xc3\x6e",
  [0xe0ea] = "\xc3\x6f", [0xe0eb] = "\xc3\x70", [0xe0ec] = "\xc3\x71",
  [0xe0ed] = "\xc3\x72", [0xe0ee] = "\xc3\x73", [0xe0ef] = "\xc3\x74",
  [0xe0f0] = "\xc3\x75", [0xe0f1] = "\xc3\x76", [0xe0f2] = "\xc3\x77",
  [0xe0f3] = "\xc3\x78", [0xe0f4] = "\xc3\x79", [0xe0f5] = "\xc3\x7a",
  [0xe0f6] = "\xc3\x7b", [0xe0f7] = "\xc3\x7c", [0xe0f8] = "\xc3\x7d",
  [0xe0f9] = "\xc3\x7e", [0xe0fa] = "\xc3\x7f", [0xe0fb] = "\xc3\x81",
  [0xe0fc] = "\xc3\x82", [0xe0fd] = "\xc3\x83", [0xe0fe] = "\xc3\x84",
  [0xe0ff] = "\xc3\x85", [0xe100] = "\xc3\x86", [0xe101] = "\xc3\x87",
  [0xe102] = "\xc3\x88", [0xe103] = "\xc3\x89", [0xe104] = "\xc3\x8a",
  [0xe105] = "\xc3\x8b", [0xe106] = "\xc3\x8c", [0xe107] = "\xc3\x8d",
  [0xe108] = "\xc3\x8e", [0xe109] = "\xc3\x8f", [0xe10a] = "\xc3\x90",
  [0xe10b] = "\xc3\x91", [0xe10c] = "\xc3\x92", [0xe10d] = "\xc3\x93",
  [0xe10e] = "\xc3\x94", [0xe10f] = "\xc3\x95", [0xe110] = "\xc3\x96",
  [0xe111] = "\xc3\x97", [0xe112] = "\xc3\x98", [0xe113] = "\xc3\x99",
  [0xe114] = "\xc3\x9a", [0xe115] = "\xc3\x9b", [0xe116] = "\xc3\x9c",
  [0xe117] = "\xc3\x9d", [0xe118] = "\xc3\x9e", [0xe119] = "\xc3\x9f",
  [0xe11a] = "\xc3\xa0", [0xe11b] = "\xc3\xa1", [0xe11c] = "\xc3\xa2",
  [0xe11d] = "\xc3\xa3", [0xe11e] = "\xc3\xa4", [0xe11f] = "\xc3\xa5",
  [0xe120] = "\xc3\xa6", [0xe121] = "\xc3\xa7", [0xe122] = "\xc3\xa8",
  [0xe123] = "\xc3\xa9", [0xe124] = "\xc3\xaa", [0xe125] = "\xc3\xab",
  [0xe126] = "\xc3\xac", [0xe127] = "\xc3\xad", [0xe128] = "\xc3\xae",
  [0xe129] = "\xc3\xaf", [0xe12a] = "\xc3\xb0", [0xe12b] = "\xc3\xb1",
  [0xe12c] = "\xc3\xb2", [0xe12d] = "\xc3\xb3", [0xe12e] = "\xc3\xb4",
  [0xe12f] = "\xc3\xb5", [0xe130] = "\xc3\xb6", [0xe131] = "\xc3\xb7",
  [0xe132] = "\xc3\xb8", [0xe133] = "\xc3\xb9", [0xe134] = "\xc3\xba",
  [0xe135] = "\xc3\xbb", [0xe136] = "\xc3\xbc", [0xe137] = "\xc3\xbd",
  [0xe138] = "\xc3\xbe", [0xe139] = "\xc3\xbf", [0xe13a] = "\xc3\xc0",
  [0xe13b] = "\xc3\xc1", [0xe13c] = "\xc3\xc2", [0xe13d] = "\xc3\xc3",
  [0xe13e] = "\xc3\xc4", [0xe13f] = "\xc3\xc5", [0xe140] = "\xc3\xc6",
  [0xe141] = "\xc3\xc7", [0xe142] = "\xc3\xc8", [0xe143] = "\xc3\xc9",
  [0xe144] = "\xc3\xca", [0xe145] = "\xc3\xcb", [0xe146] = "\xc3\xcc",
  [0xe147] = "\xc3\xcd", [0xe148] = "\xc3\xce", [0xe149] = "\xc3\xcf",
  [0xe14a] = "\xc3\xd0", [0xe14b] = "\xc3\xd1", [0xe14c] = "\xc3\xd2",
  [0xe14d] = "\xc3\xd3", [0xe14e] = "\xc3\xd4", [0xe14f] = "\xc3\xd5",
  [0xe150] = "\xc3\xd6", [0xe151] = "\xc3\xd7", [0xe152] = "\xc3\xd8",
  [0xe153] = "\xc3\xd9", [0xe154] = "\xc3\xda", [0xe155] = "\xc3\xdb",
  [0xe156] = "\xc3\xdc", [0xe157] = "\xc3\xdd", [0xe158] = "\xc3\xde",
  [0xe159] = "\xc3\xdf", [0xe15a] = "\xc3\xe0", [0xe15b] = "\xc3\xe1",
  [0xe15c] = "\xc3\xe2", [0xe15d] = "\xc3\xe3", [0xe15e] = "\xc3\xe4",
  [0xe15f] = "\xc3\xe5", [0xe160] = "\xc3\xe6", [0xe161] = "\xc3\xe7",
  [0xe162] = "\xc3\xe8", [0xe163] = "\xc3\xe9", [0xe164] = "\xc3\xea",
  [0xe165] = "\xc3\xeb", [0xe166] = "\xc3\xec", [0xe167] = "\xc3\xed",
  [0xe168] = "\xc3\xee", [0xe169] = "\xc3\xef", [0xe16a] = "\xc3\xf0",
  [0xe16b] = "\xc3\xf1", [0xe16c] = "\xc3\xf2", [0xe16d] = "\xc3\xf3",
  [0xe16e] = "\xc3\xf4", [0xe16f] = "\xc3\xf5", [0xe170] = "\xc3\xf6",
  [0xe171] = "\xc3\xf7", [0xe172] = "\xc3\xf8", [0xe173] = "\xc3\xf9",
  [0xe174] = "\xc3\xfa", [0xe175] = "\xc3\xfb", [0xe176] = "\xc3\xfc",
  [0xe177] = "\xc3\xfd", [0xe178] = "\xc4\x41", [0xe179] = "\xc4\x42",
  [0xe17a] = "\xc4\x43", [0xe17b] = "\xc4\x44", [0xe17c] = "\xc4\x45",
  [0xe17d] = "\xc4\x46", [0xe17e] = "\xc4\x47", [0xe17f] = "\xc4\x48",
  [0xe180] = "\xc4\x49", [0xe181] = "\xc4\x4a", [0xe182] = "\xc4\x4b",
  [0xe183] = "\xc4\x4c", [0xe184] = "\xc4\x4d", [0xe185] = "\xc4\x4e",
  [0xe186] = "\xc4\x4f", [0xe187] = "\xc4\x50", [0xe188] = "\xc4\x51",
  [0xe189] = "\xc4\x52", [0xe18a] = "\xc4\x53", [0xe18b] = "\xc4\x54",
  [0xe18c] = "\xc4\x55", [0xe18d] = "\xc4\x56", [0xe18e] = "\xc4\x57",
  [0xe18f] = "\xc4\x58", [0xe190] = "\xc4\x59", [0xe191] = "\xc4\x5a",
  [0xe192] = "\xc4\x5b", [0xe193] = "\xc4\x5c", [0xe194] = "\xc4\x5d",
  [0xe195] = "\xc4\x5e", [0xe196] = "\xc4\x5f", [0xe197] = "\xc4\x60",
  [0xe198] = "\xc4\x61", [0xe199] = "\xc4\x62", [0xe19a] = "\xc4\x63",
  [0xe19b] = "\xc4\x64", [0xe19c] = "\xc4\x65", [0xe19d] = "\xc4\x66",
  [0xe19e] = "\xc4\x67", [0xe19f] = "\xc4\x68", [0xe1a0] = "\xc4\x69",
  [0xe1a1] = "\xc4\x6a", [0xe1a2] = "\xc4\x6b", [0xe1a3] = "\xc4\x6c",
  [0xe1a4] = "\xc4\x6d", [0xe1a5] = "\xc4\x6e", [0xe1a6] = "\xc4\x6f",
  [0xe1a7] = "\xc4\x70", [0xe1a8] = "\xc4\x71", [0xe1a9] = "\xc4\x72",
  [0xe1aa] = "\xc4\x73", [0xe1ab] = "\xc4\x74", [0xe1ac] = "\xc4\x75",
  [0xe1ad] = "\xc4\x76", [0xe1ae] = "\xc4\x77", [0xe1af] = "\xc4\x78",
  [0xe1b0] = "\xc4\x79", [0xe1b1] = "\xc4\x7a", [0xe1b2] = "\xc4\x7b",
  [0xe1b3] = "\xc4\x7c", [0xe1b4] = "\xc4\x7d", [0xe1b5] = "\xc4\x7e",
  [0xe1b6] = "\xc4\x7f", [0xe1b7] = "\xc4\x81", [0xe1b8] = "\xc4\x82",
  [0xe1b9] = "\xc4\x83", [0xe1ba] = "\xc4\x84", [0xe1bb] = "\xc4\x85",
  [0xe1bc] = "\xc4\x86", [0xe1bd] = "\xc4\x87", [0xe1be] = "\xc4\x88",
  [0xe1bf] = "\xc4\x89", [0xe1c0] = "\xc4\x8a", [0xe1c1] = "\xc4\x8b",
  [0xe1c2] = "\xc4\x8c", [0xe1c3] = "\xc4\x8d", [0xe1c4] = "\xc4\x8e",
  [0xe1c5] = "\xc4\x8f", [0xe1c6] = "\xc4\x90", [0xe1c7] = "\xc4\x91",
  [0xe1c8] = "\xc4\x92", [0xe1c9] = "\xc4\x93", [0xe1ca] = "\xc4\x94",
  [0xe1cb] = "\xc4\x95", [0xe1cc] = "\xc4\x96", [0xe1cd] = "\xc4\x97",
  [0xe1ce] = "\xc4\x98", [0xe1cf] = "\xc4\x99", [0xe1d0] = "\xc4\x9a",
  [0xe1d1] = "\xc4\x9b", [0xe1d2] = "\xc4\x9c", [0xe1d3] = "\xc4\x9d",
  [0xe1d4] = "\xc4\x9e", [0xe1d5] = "\xc4\x9f", [0xe1d6] = "\xc4\xa0",
  [0xe1d7] = "\xc4\xa1", [0xe1d8] = "\xc4\xa2", [0xe1d9] = "\xc4\xa3",
  [0xe1da] = "\xc4\xa4", [0xe1db] = "\xc4\xa5", [0xe1dc] = "\xc4\xa6",
  [0xe1dd] = "\xc4\xa7", [0xe1de] = "\xc4\xa8", [0xe1df] = "\xc4\xa9",
  [0xe1e0] = "\xc4\xaa", [0xe1e1] = "\xc4\xab", [0xe1e2] = "\xc4\xac",
  [0xe1e3] = "\xc4\xad", [0xe1e4] = "\xc4\xae", [0xe1e5] = "\xc4\xaf",
  [0xe1e6] = "\xc4\xb0", [0xe1e7] = "\xc4\xb1", [0xe1e8] = "\xc4\xb2",
  [0xe1e9] = "\xc4\xb3", [0xe1ea] = "\xc4\xb4", [0xe1eb] = "\xc4\xb5",
  [0xe1ec] = "\xc4\xb6", [0xe1ed] = "\xc4\xb7", [0xe1ee] = "\xc4\xb8",
  [0xe1ef] = "\xc4\xb9", [0xe1f0] = "\xc4\xba", [0xe1f1] = "\xc4\xbb",
  [0xe1f2] = "\xc4\xbc", [0xe1f3] = "\xc4\xbd", [0xe1f4] = "\xc4\xbe",
  [0xe1f5] = "\xc4\xbf", [0xe1f6] = "\xc4\xc0", [0xe1f7] = "\xc4\xc1",
  [0xe1f8] = "\xc4\xc2", [0xe1f9] = "\xc4\xc3", [0xe1fa] = "\xc4\xc4",
  [0xe1fb] = "\xc4\xc5", [0xe1fc] = "\xc4\xc6", [0xe1fd] = "\xc4\xc7",
  [0xe1fe] = "\xc4\xc8", [0xe1ff] = "\xc4\xc9", [0xe200] = "\xc4\xca",
  [0xe201] = "\xc4\xcb", [0xe202] = "\xc4\xcc", [0xe203] = "\xc4\xcd",
  [0xe204] = "\xc4\xce", [0xe205] = "\xc4\xcf", [0xe206] = "\xc4\xd0",
  [0xe207] = "\xc4\xd1", [0xe208] = "\xc4\xd2", [0xe209] = "\xc4\xd3",
  [0xe20a] = "\xc4\xd4", [0xe20b] = "\xc4\xd5", [0xe20c] = "\xc4\xd6",
  [0xe20d] = "\xc4\xd7", [0xe20e] = "\xc4\xd8", [0xe20f] = "\xc4\xd9",
  [0xe210] = "\xc4\xda", [0xe211] = "\xc4\xdb", [0xe212] = "\xc4\xdc",
  [0xe213] = "\xc4\xdd", [0xe214] = "\xc4\xde", [0xe215] = "\xc4\xdf",
  [0xe216] = "\xc4\xe0", [0xe217] = "\xc4\xe1", [0xe218] = "\xc4\xe2",
  [0xe219] = "\xc4\xe3", [0xe21a] = "\xc4\xe4", [0xe21b] = "\xc4\xe5",
  [0xe21c] = "\xc4\xe6", [0xe21d] = "\xc4\xe7", [0xe21e] = "\xc4\xe8",
  [0xe21f] = "\xc4\xe9", [0xe220] = "\xc4\xea", [0xe221] = "\xc4\xeb",
  [0xe222] = "\xc4\xec", [0xe223] = "\xc4\xed", [0xe224] = "\xc4\xee",
  [0xe225] = "\xc4\xef", [0xe226] = "\xc4\xf0", [0xe227] = "\xc4\xf1",
  [0xe228] = "\xc4\xf2", [0xe229] = "\xc4\xf3", [0xe22a] = "\xc4\xf4",
  [0xe22b] = "\xc4\xf5", [0xe22c] = "\xc4\xf6", [0xe22d] = "\xc4\xf7",
  [0xe22e] = "\xc4\xf8", [0xe22f] = "\xc4\xf9", [0xe230] = "\xc4\xfa",
  [0xe231] = "\xc4\xfb", [0xe232] = "\xc4\xfc", [0xe233] = "\xc4\xfd",
  [0xe234] = "\xc5\x41", [0xe235] = "\xc5\x42", [0xe236] = "\xc5\x43",
  [0xe237] = "\xc5\x44", [0xe238] = "\xc5\x45", [0xe239] = "\xc5\x46",
  [0xe23a] = "\xc5\x47", [0xe23b] = "\xc5\x48", [0xe23c] = "\xc5\x49",
  [0xe23d] = "\xc5\x4a", [0xe23e] = "\xc5\x4b", [0xe23f] = "\xc5\x4c",
  [0xe240] = "\xc5\x4d", [0xe241] = "\xc5\x4e", [0xe242] = "\xc5\x4f",
  [0xe243] = "\xc5\x50", [0xe244] = "\xc5\x51", [0xe245] = "\xc5\x52",
  [0xe246] = "\xc5\x53", [0xe247] = "\xc5\x54", [0xe248] = "\xc5\x55",
  [0xe249] = "\xc5\x56", [0xe24a] = "\xc5\x57", [0xe24b] = "\xc5\x58",
  [0xe24c] = "\xc5\x59", [0xe24d] = "\xc5\x5a", [0xe24e] = "\xc5\x5b",
  [0xe24f] = "\xc5\x5c", [0xe250] = "\xc5\x5d", [0xe251] = "\xc5\x5e",
  [0xe252] = "\xc5\x5f", [0xe253] = "\xc5\x60", [0xe254] = "\xc5\x61",
  [0xe255] = "\xc5\x62", [0xe256] = "\xc5\x63", [0xe257] = "\xc5\x64",
  [0xe258] = "\xc5\x65", [0xe259] = "\xc5\x66", [0xe25a] = "\xc5\x67",
  [0xe25b] = "\xc5\x68", [0xe25c] = "\xc5\x69", [0xe25d] = "\xc5\x6a",
  [0xe25e] = "\xc5\x6b", [0xe25f] = "\xc5\x6c", [0xe260] = "\xc5\x6d",
  [0xe261] = "\xc5\x6e", [0xe262] = "\xc5\x6f", [0xe263] = "\xc5\x70",
  [0xe264] = "\xc5\x71", [0xe265] = "\xc5\x72", [0xe266] = "\xc5\x73",
  [0xe267] = "\xc5\x74", [0xe268] = "\xc5\x75", [0xe269] = "\xc5\x76",
  [0xe26a] = "\xc5\x77", [0xe26b] = "\xc5\x78", [0xe26c] = "\xc5\x79",
  [0xe26d] = "\xc5\x7a", [0xe26e] = "\xc5\x7b", [0xe26f] = "\xc5\x7c",
  [0xe270] = "\xc5\x7d", [0xe271] = "\xc5\x7e", [0xe272] = "\xc5\x7f",
  [0xe273] = "\xc5\x81", [0xe274] = "\xc5\x82", [0xe275] = "\xc5\x83",
  [0xe276] = "\xc5\x84", [0xe277] = "\xc5\x85", [0xe278] = "\xc5\x86",
  [0xe279] = "\xc5\x87", [0xe27a] = "\xc5\x88", [0xe27b] = "\xc5\x89",
  [0xe27c] = "\xc5\x8a", [0xe27d] = "\xc5\x8b", [0xe27e] = "\xc5\x8c",
  [0xe27f] = "\xc5\x8d", [0xe280] = "\xc5\x8e", [0xe281] = "\xc5\x8f",
  [0xe282] = "\xc5\x90", [0xe283] = "\xc5\x91", [0xe284] = "\xc5\x92",
  [0xe285] = "\xc5\x93", [0xe286] = "\xc5\x94", [0xe287] = "\xc5\x95",
  [0xe288] = "\xc5\x96", [0xe289] = "\xc5\x97", [0xe28a] = "\xc5\x98",
  [0xe28b] = "\xc5\x99", [0xe28c] = "\xc5\x9a", [0xe28d] = "\xc5\x9b",
  [0xe28e] = "\xc5\x9c", [0xe28f] = "\xc5\x9d", [0xe290] = "\xc5\x9e",
  [0xe291] = "\xc5\x9f", [0xe292] = "\xc5\xa0", [0xe293] = "\xc5\xa1",
  [0xe294] = "\xc5\xa2", [0xe295] = "\xc5\xa3", [0xe296] = "\xc5\xa4",
  [0xe297] = "\xc5\xa5", [0xe298] = "\xc5\xa6", [0xe299] = "\xc5\xa7",
  [0xe29a] = "\xc5\xa8", [0xe29b] = "\xc5\xa9", [0xe29c] = "\xc5\xaa",
  [0xe29d] = "\xc5\xab", [0xe29e] = "\xc5\xac", [0xe29f] = "\xc5\xad",
  [0xe2a0] = "\xc5\xae", [0xe2a1] = "\xc5\xaf", [0xe2a2] = "\xc5\xb0",
  [0xe2a3] = "\xc5\xb1", [0xe2a4] = "\xc5\xb2", [0xe2a5] = "\xc5\xb3",
  [0xe2a6] = "\xc5\xb4", [0xe2a7] = "\xc5\xb5", [0xe2a8] = "\xc5\xb6",
  [0xe2a9] = "\xc5\xb7", [0xe2aa] = "\xc5\xb8", [0xe2ab] = "\xc5\xb9",
  [0xe2ac] = "\xc5\xba", [0xe2ad] = "\xc5\xbb", [0xe2ae] = "\xc5\xbc",
  [0xe2af] = "\xc5\xbd", [0xe2b0] = "\xc5\xbe", [0xe2b1] = "\xc5\xbf",
  [0xe2b2] = "\xc5\xc0", [0xe2b3] = "\xc5\xc1", [0xe2b4] = "\xc5\xc2",
  [0xe2b5] = "\xc5\xc3", [0xe2b6] = "\xc5\xc4", [0xe2b7] = "\xc5\xc5",
  [0xe2b8] = "\xc5\xc6", [0xe2b9] = "\xc5\xc7", [0xe2ba] = "\xc5\xc8",
  [0xe2bb] = "\xc5\xc9", [0xe2bc] = "\xc5\xca", [0xe2bd] = "\xc5\xcb",
  [0xe2be] = "\xc5\xcc", [0xe2bf] = "\xc5\xcd", [0xe2c0] = "\xc5\xce",
  [0xe2c1] = "\xc5\xcf", [0xe2c2] = "\xc5\xd0", [0xe2c3] = "\xc5\xd1",
  [0xe2c4] = "\xc5\xd2", [0xe2c5] = "\xc5\xd3", [0xe2c6] = "\xc5\xd4",
  [0xe2c7] = "\xc5\xd5", [0xe2c8] = "\xc5\xd6", [0xe2c9] = "\xc5\xd7",
  [0xe2ca] = "\xc5\xd8", [0xe2cb] = "\xc5\xd9", [0xe2cc] = "\xc5\xda",
  [0xe2cd] = "\xc5\xdb", [0xe2ce] = "\xc5\xdc", [0xe2cf] = "\xc5\xdd",
  [0xe2d0] = "\xc5\xde", [0xe2d1] = "\xc5\xdf", [0xe2d2] = "\xc5\xe0",
  [0xe2d3] = "\xc5\xe1", [0xe2d4] = "\xc5\xe2", [0xe2d5] = "\xc5\xe3",
  [0xe2d6] = "\xc5\xe4", [0xe2d7] = "\xc5\xe5", [0xe2d8] = "\xc5\xe6",
  [0xe2d9] = "\xc5\xe7", [0xe2da] = "\xc5\xe8", [0xe2db] = "\xc5\xe9",
  [0xe2dc] = "\xc5\xea", [0xe2dd] = "\xc5\xeb", [0xe2de] = "\xc5\xec",
  [0xe2df] = "\xc5\xed", [0xe2e0] = "\xc5\xee", [0xe2e1] = "\xc5\xef",
  [0xe2e2] = "\xc5\xf0", [0xe2e3] = "\xc5\xf1", [0xe2e4] = "\xc5\xf2",
  [0xe2e5] = "\xc5\xf3", [0xe2e6] = "\xc5\xf4", [0xe2e7] = "\xc5\xf5",
  [0xe2e8] = "\xc5\xf6", [0xe2e9] = "\xc5\xf7", [0xe2ea] = "\xc5\xf8",
  [0xe2eb] = "\xc5\xf9", [0xe2ec] = "\xc5\xfa", [0xe2ed] = "\xc5\xfb",
  [0xe2ee] = "\xc5\xfc", [0xe2ef] = "\xc5\xfd", [0xe2f0] = "\xc6\x41",
  [0xe2f1] = "\xc6\x42", [0xe2f2] = "\xc6\x43", [0xe2f3] = "\xc6\x44",
  [0xe2f4] = "\xc6\x45", [0xe2f5] = "\xc6\x46", [0xe2f6] = "\xc6\x47",
  [0xe2f7] = "\xc6\x48", [0xe2f8] = "\xc6\x49", [0xe2f9] = "\xc6\x4a",
  [0xe2fa] = "\xc6\x4b", [0xe2fb] = "\xc6\x4c", [0xe2fc] = "\xc6\x4d",
  [0xe2fd] = "\xc6\x4e", [0xe2fe] = "\xc6\x4f", [0xe2ff] = "\xc6\x50",
  [0xe300] = "\xc6\x51", [0xe301] = "\xc6\x52", [0xe302] = "\xc6\x53",
  [0xe303] = "\xc6\x54", [0xe304] = "\xc6\x55", [0xe305] = "\xc6\x56",
  [0xe306] = "\xc6\x57", [0xe307] = "\xc6\x58", [0xe308] = "\xc6\x59",
  [0xe309] = "\xc6\x5a", [0xe30a] = "\xc6\x5b", [0xe30b] = "\xc6\x5c",
  [0xe30c] = "\xc6\x5d", [0xe30d] = "\xc6\x5e", [0xe30e] = "\xc6\x5f",
  [0xe30f] = "\xc6\x60", [0xe310] = "\xc6\x61", [0xe311] = "\xc6\x62",
  [0xe312] = "\xc6\x63", [0xe313] = "\xc6\x64", [0xe314] = "\xc6\x65",
  [0xe315] = "\xc6\x66", [0xe316] = "\xc6\x67", [0xe317] = "\xc6\x68",
  [0xe318] = "\xc6\x69", [0xe319] = "\xc6\x6a", [0xe31a] = "\xc6\x6b",
  [0xe31b] = "\xc6\x6c", [0xe31c] = "\xc6\x6d", [0xe31d] = "\xc6\x6e",
  [0xe31e] = "\xc6\x6f", [0xe31f] = "\xc6\x70", [0xe320] = "\xc6\x71",
  [0xe321] = "\xc6\x72", [0xe322] = "\xc6\x73", [0xe323] = "\xc6\x74",
  [0xe324] = "\xc6\x75", [0xe325] = "\xc6\x76", [0xe326] = "\xc6\x77",
  [0xe327] = "\xc6\x78", [0xe328] = "\xc6\x79", [0xe329] = "\xc6\x7a",
  [0xe32a] = "\xc6\x7b", [0xe32b] = "\xc6\x7c", [0xe32c] = "\xc6\x7d",
  [0xe32d] = "\xc6\x7e", [0xe32e] = "\xc6\x7f", [0xe32f] = "\xc6\x81",
  [0xe330] = "\xc6\x82", [0xe331] = "\xc6\x83", [0xe332] = "\xc6\x84",
  [0xe333] = "\xc6\x85", [0xe334] = "\xc6\x86", [0xe335] = "\xc6\x87",
  [0xe336] = "\xc6\x88", [0xe337] = "\xc6\x89", [0xe338] = "\xc6\x8a",
  [0xe339] = "\xc6\x8b", [0xe33a] = "\xc6\x8c", [0xe33b] = "\xc6\x8d",
  [0xe33c] = "\xc6\x8e", [0xe33d] = "\xc6\x8f", [0xe33e] = "\xc6\x90",
  [0xe33f] = "\xc6\x91", [0xe340] = "\xc6\x92", [0xe341] = "\xc6\x93",
  [0xe342] = "\xc6\x94", [0xe343] = "\xc6\x95", [0xe344] = "\xc6\x96",
  [0xe345] = "\xc6\x97", [0xe346] = "\xc6\x98", [0xe347] = "\xc6\x99",
  [0xe348] = "\xc6\x9a", [0xe349] = "\xc6\x9b", [0xe34a] = "\xc6\x9c",
  [0xe34b] = "\xc6\x9d", [0xe34c] = "\xc6\x9e", [0xe34d] = "\xc6\x9f",
  [0xe34e] = "\xc6\xa0", [0xe34f] = "\xc6\xa1", [0xe350] = "\xc6\xa2",
  [0xe351] = "\xc6\xa3", [0xe352] = "\xc6\xa4", [0xe353] = "\xc6\xa5",
  [0xe354] = "\xc6\xa6", [0xe355] = "\xc6\xa7", [0xe356] = "\xc6\xa8",
  [0xe357] = "\xc6\xa9", [0xe358] = "\xc6\xaa", [0xe359] = "\xc6\xab",
  [0xe35a] = "\xc6\xac", [0xe35b] = "\xc6\xad", [0xe35c] = "\xc6\xae",
  [0xe35d] = "\xc6\xaf", [0xe35e] = "\xc6\xb0", [0xe35f] = "\xc6\xb1",
  [0xe360] = "\xc6\xb2", [0xe361] = "\xc6\xb3", [0xe362] = "\xc6\xb4",
  [0xe363] = "\xc6\xb5", [0xe364] = "\xc6\xb6", [0xe365] = "\xc6\xb7",
  [0xe366] = "\xc6\xb8", [0xe367] = "\xc6\xb9", [0xe368] = "\xc6\xba",
  [0xe369] = "\xc6\xbb", [0xe36a] = "\xc6\xbc", [0xe36b] = "\xc6\xbd",
  [0xe36c] = "\xc6\xbe", [0xe36d] = "\xc6\xbf", [0xe36e] = "\xc6\xc0",
  [0xe36f] = "\xc6\xc1", [0xe370] = "\xc6\xc2", [0xe371] = "\xc6\xc3",
  [0xe372] = "\xc6\xc4", [0xe373] = "\xc6\xc5", [0xe374] = "\xc6\xc6",
  [0xe375] = "\xc6\xc7", [0xe376] = "\xc6\xc8", [0xe377] = "\xc6\xc9",
  [0xe378] = "\xc6\xca", [0xe379] = "\xc6\xcb", [0xe37a] = "\xc6\xcc",
  [0xe37b] = "\xc6\xcd", [0xe37c] = "\xc6\xce", [0xe37d] = "\xc6\xcf",
  [0xe37e] = "\xc6\xd0", [0xe37f] = "\xc6\xd1", [0xe380] = "\xc6\xd2",
  [0xe381] = "\xc6\xd3", [0xe382] = "\xc6\xd4", [0xe383] = "\xc6\xd5",
  [0xe384] = "\xc6\xd6", [0xe385] = "\xc6\xd7", [0xe386] = "\xc6\xd8",
  [0xe387] = "\xc6\xd9", [0xe388] = "\xc6\xda", [0xe389] = "\xc6\xdb",
  [0xe38a] = "\xc6\xdc", [0xe38b] = "\xc6\xdd", [0xe38c] = "\xc6\xde",
  [0xe38d] = "\xc6\xdf", [0xe38e] = "\xc6\xe0", [0xe38f] = "\xc6\xe1",
  [0xe390] = "\xc6\xe2", [0xe391] = "\xc6\xe3", [0xe392] = "\xc6\xe4",
  [0xe393] = "\xc6\xe5", [0xe394] = "\xc6\xe6", [0xe395] = "\xc6\xe7",
  [0xe396] = "\xc6\xe8", [0xe397] = "\xc6\xe9", [0xe398] = "\xc6\xea",
  [0xe399] = "\xc6\xeb", [0xe39a] = "\xc6\xec", [0xe39b] = "\xc6\xed",
  [0xe39c] = "\xc6\xee", [0xe39d] = "\xc6\xef", [0xe39e] = "\xc6\xf0",
  [0xe39f] = "\xc6\xf1", [0xe3a0] = "\xc6\xf2", [0xe3a1] = "\xc6\xf3",
  [0xe3a2] = "\xc6\xf4", [0xe3a3] = "\xc6\xf5", [0xe3a4] = "\xc6\xf6",
  [0xe3a5] = "\xc6\xf7", [0xe3a6] = "\xc6\xf8", [0xe3a7] = "\xc6\xf9",
  [0xe3a8] = "\xc6\xfa", [0xe3a9] = "\xc6\xfb", [0xe3aa] = "\xc6\xfc",
  [0xe3ab] = "\xc6\xfd", [0xe3ac] = "\xc7\x41", [0xe3ad] = "\xc7\x42",
  [0xe3ae] = "\xc7\x43", [0xe3af] = "\xc7\x44", [0xe3b0] = "\xc7\x45",
  [0xe3b1] = "\xc7\x46", [0xe3b2] = "\xc7\x47", [0xe3b3] = "\xc7\x48",
  [0xe3b4] = "\xc7\x49", [0xe3b5] = "\xc7\x4a", [0xe3b6] = "\xc7\x4b",
  [0xe3b7] = "\xc7\x4c", [0xe3b8] = "\xc7\x4d", [0xe3b9] = "\xc7\x4e",
  [0xe3ba] = "\xc7\x4f", [0xe3bb] = "\xc7\x50", [0xe3bc] = "\xc7\x51",
  [0xe3bd] = "\xc7\x52", [0xe3be] = "\xc7\x53", [0xe3bf] = "\xc7\x54",
  [0xe3c0] = "\xc7\x55", [0xe3c1] = "\xc7\x56", [0xe3c2] = "\xc7\x57",
  [0xe3c3] = "\xc7\x58", [0xe3c4] = "\xc7\x59", [0xe3c5] = "\xc7\x5a",
  [0xe3c6] = "\xc7\x5b", [0xe3c7] = "\xc7\x5c", [0xe3c8] = "\xc7\x5d",
  [0xe3c9] = "\xc7\x5e", [0xe3ca] = "\xc7\x5f", [0xe3cb] = "\xc7\x60",
  [0xe3cc] = "\xc7\x61", [0xe3cd] = "\xc7\x62", [0xe3ce] = "\xc7\x63",
  [0xe3cf] = "\xc7\x64", [0xe3d0] = "\xc7\x65", [0xe3d1] = "\xc7\x66",
  [0xe3d2] = "\xc7\x67", [0xe3d3] = "\xc7\x68", [0xe3d4] = "\xc7\x69",
  [0xe3d5] = "\xc7\x6a", [0xe3d6] = "\xc7\x6b", [0xe3d7] = "\xc7\x6c",
  [0xe3d8] = "\xc7\x6d", [0xe3d9] = "\xc7\x6e", [0xe3da] = "\xc7\x6f",
  [0xe3db] = "\xc7\x70", [0xe3dc] = "\xc7\x71", [0xe3dd] = "\xc7\x72",
  [0xe3de] = "\xc7\x73", [0xe3df] = "\xc7\x74", [0xe3e0] = "\xc7\x75",
  [0xe3e1] = "\xc7\x76", [0xe3e2] = "\xc7\x77", [0xe3e3] = "\xc7\x78",
  [0xe3e4] = "\xc7\x79", [0xe3e5] = "\xc7\x7a", [0xe3e6] = "\xc7\x7b",
  [0xe3e7] = "\xc7\x7c", [0xe3e8] = "\xc7\x7d", [0xe3e9] = "\xc7\x7e",
  [0xe3ea] = "\xc7\x7f", [0xe3eb] = "\xc7\x81", [0xe3ec] = "\xc7\x82",
  [0xe3ed] = "\xc7\x83", [0xe3ee] = "\xc7\x84", [0xe3ef] = "\xc7\x85",
  [0xe3f0] = "\xc7\x86", [0xe3f1] = "\xc7\x87", [0xe3f2] = "\xc7\x88",
  [0xe3f3] = "\xc7\x89", [0xe3f4] = "\xc7\x8a", [0xe3f5] = "\xc7\x8b",
  [0xe3f6] = "\xc7\x8c", [0xe3f7] = "\xc7\x8d", [0xe3f8] = "\xc7\x8e",
  [0xe3f9] = "\xc7\x8f", [0xe3fa] = "\xc7\x90", [0xe3fb] = "\xc7\x91",
  [0xe3fc] = "\xc7\x92", [0xe3fd] = "\xc7\x93", [0xe3fe] = "\xc7\x94",
  [0xe3ff] = "\xc7\x95", [0xe400] = "\xc7\x96", [0xe401] = "\xc7\x97",
  [0xe402] = "\xc7\x98", [0xe403] = "\xc7\x99", [0xe404] = "\xc7\x9a",
  [0xe405] = "\xc7\x9b", [0xe406] = "\xc7\x9c", [0xe407] = "\xc7\x9d",
  [0xe408] = "\xc7\x9e", [0xe409] = "\xc7\x9f", [0xe40a] = "\xc7\xa0",
  [0xe40b] = "\xc7\xa1", [0xe40c] = "\xc7\xa2", [0xe40d] = "\xc7\xa3",
  [0xe40e] = "\xc7\xa4", [0xe40f] = "\xc7\xa5", [0xe410] = "\xc7\xa6",
  [0xe411] = "\xc7\xa7", [0xe412] = "\xc7\xa8", [0xe413] = "\xc7\xa9",
  [0xe414] = "\xc7\xaa", [0xe415] = "\xc7\xab", [0xe416] = "\xc7\xac",
  [0xe417] = "\xc7\xad", [0xe418] = "\xc7\xae", [0xe419] = "\xc7\xaf",
  [0xe41a] = "\xc7\xb0", [0xe41b] = "\xc7\xb1", [0xe41c] = "\xc7\xb2",
  [0xe41d] = "\xc7\xb3", [0xe41e] = "\xc7\xb4", [0xe41f] = "\xc7\xb5",
  [0xe420] = "\xc7\xb6", [0xe421] = "\xc7\xb7", [0xe422] = "\xc7\xb8",
  [0xe423] = "\xc7\xb9", [0xe424] = "\xc7\xba", [0xe425] = "\xc7\xbb",
  [0xe426] = "\xc7\xbc", [0xe427] = "\xc7\xbd", [0xe428] = "\xc7\xbe",
  [0xe429] = "\xc7\xbf", [0xe42a] = "\xc7\xc0", [0xe42b] = "\xc7\xc1",
  [0xe42c] = "\xc7\xc2", [0xe42d] = "\xc7\xc3", [0xe42e] = "\xc7\xc4",
  [0xe42f] = "\xc7\xc5", [0xe430] = "\xc7\xc6", [0xe431] = "\xc7\xc7",
  [0xe432] = "\xc7\xc8", [0xe433] = "\xc7\xc9", [0xe434] = "\xc7\xca",
  [0xe435] = "\xc7\xcb", [0xe436] = "\xc7\xcc", [0xe437] = "\xc7\xcd",
  [0xe438] = "\xc7\xce", [0xe439] = "\xc7\xcf", [0xe43a] = "\xc7\xd0",
  [0xe43b] = "\xc7\xd1", [0xe43c] = "\xc7\xd2", [0xe43d] = "\xc7\xd3",
  [0xe43e] = "\xc7\xd4", [0xe43f] = "\xc7\xd5", [0xe440] = "\xc7\xd6",
  [0xe441] = "\xc7\xd7", [0xe442] = "\xc7\xd8", [0xe443] = "\xc7\xd9",
  [0xe444] = "\xc7\xda", [0xe445] = "\xc7\xdb", [0xe446] = "\xc7\xdc",
  [0xe447] = "\xc7\xdd", [0xe448] = "\xc7\xde", [0xe449] = "\xc7\xdf",
  [0xe44a] = "\xc7\xe0", [0xe44b] = "\xc7\xe1", [0xe44c] = "\xc7\xe2",
  [0xe44d] = "\xc7\xe3", [0xe44e] = "\xc7\xe4", [0xe44f] = "\xc7\xe5",
  [0xe450] = "\xc7\xe6", [0xe451] = "\xc7\xe7", [0xe452] = "\xc7\xe8",
  [0xe453] = "\xc7\xe9", [0xe454] = "\xc7\xea", [0xe455] = "\xc7\xeb",
  [0xe456] = "\xc7\xec", [0xe457] = "\xc7\xed", [0xe458] = "\xc7\xee",
  [0xe459] = "\xc7\xef", [0xe45a] = "\xc7\xf0", [0xe45b] = "\xc7\xf1",
  [0xe45c] = "\xc7\xf2", [0xe45d] = "\xc7\xf3", [0xe45e] = "\xc7\xf4",
  [0xe45f] = "\xc7\xf5", [0xe460] = "\xc7\xf6", [0xe461] = "\xc7\xf7",
  [0xe462] = "\xc7\xf8", [0xe463] = "\xc7\xf9", [0xe464] = "\xc7\xfa",
  [0xe465] = "\xc7\xfb", [0xe466] = "\xc7\xfc", [0xe467] = "\xc7\xfd",
  [0xe468] = "\xc8\x41", [0xe469] = "\xc8\x42", [0xe46a] = "\xc8\x43",
  [0xe46b] = "\xc8\x44", [0xe46c] = "\xc8\x45", [0xe46d] = "\xc8\x46",
  [0xe46e] = "\xc8\x47", [0xe46f] = "\xc8\x48", [0xe470] = "\xc8\x49",
  [0xe471] = "\xc8\x4a", [0xe472] = "\xc8\x4b", [0xe473] = "\xc8\x4c",
  [0xe474] = "\xc8\x4d", [0xe475] = "\xc8\x4e", [0xe476] = "\xc8\x4f",
  [0xe477] = "\xc8\x50", [0xe478] = "\xc8\x51", [0xe479] = "\xc8\x52",
  [0xe47a] = "\xc8\x53", [0xe47b] = "\xc8\x54", [0xe47c] = "\xc8\x55",
  [0xe47d] = "\xc8\x56", [0xe47e] = "\xc8\x57", [0xe47f] = "\xc8\x58",
  [0xe480] = "\xc8\x59", [0xe481] = "\xc8\x5a", [0xe482] = "\xc8\x5b",
  [0xe483] = "\xc8\x5c", [0xe484] = "\xc8\x5d", [0xe485] = "\xc8\x5e",
  [0xe486] = "\xc8\x5f", [0xe487] = "\xc8\x60", [0xe488] = "\xc8\x61",
  [0xe489] = "\xc8\x62", [0xe48a] = "\xc8\x63", [0xe48b] = "\xc8\x64",
  [0xe48c] = "\xc8\x65", [0xe48d] = "\xc8\x66", [0xe48e] = "\xc8\x67",
  [0xe48f] = "\xc8\x68", [0xe490] = "\xc8\x69", [0xe491] = "\xc8\x6a",
  [0xe492] = "\xc8\x6b", [0xe493] = "\xc8\x6c", [0xe494] = "\xc8\x6d",
  [0xe495] = "\xc8\x6e", [0xe496] = "\xc8\x6f", [0xe497] = "\xc8\x70",
  [0xe498] = "\xc8\x71", [0xe499] = "\xc8\x72", [0xe49a] = "\xc8\x73",
  [0xe49b] = "\xc8\x74", [0xe49c] = "\xc8\x75", [0xe49d] = "\xc8\x76",
  [0xe49e] = "\xc8\x77", [0xe49f] = "\xc8\x78", [0xe4a0] = "\xc8\x79",
  [0xe4a1] = "\xc8\x7a", [0xe4a2] = "\xc8\x7b", [0xe4a3] = "\xc8\x7c",
  [0xe4a4] = "\xc8\x7d", [0xe4a5] = "\xc8\x7e", [0xe4a6] = "\xc8\x7f",
  [0xe4a7] = "\xc8\x81", [0xe4a8] = "\xc8\x82", [0xe4a9] = "\xc8\x83",
  [0xe4aa] = "\xc8\x84", [0xe4ab] = "\xc8\x85", [0xe4ac] = "\xc8\x86",
  [0xe4ad] = "\xc8\x87", [0xe4ae] = "\xc8\x88", [0xe4af] = "\xc8\x89",
  [0xe4b0] = "\xc8\x8a", [0xe4b1] = "\xc8\x8b", [0xe4b2] = "\xc8\x8c",
  [0xe4b3] = "\xc8\x8d", [0xe4b4] = "\xc8\x8e", [0xe4b5] = "\xc8\x8f",
  [0xe4b6] = "\xc8\x90", [0xe4b7] = "\xc8\x91", [0xe4b8] = "\xc8\x92",
  [0xe4b9] = "\xc8\x93", [0xe4ba] = "\xc8\x94", [0xe4bb] = "\xc8\x95",
  [0xe4bc] = "\xc8\x96", [0xe4bd] = "\xc8\x97", [0xe4be] = "\xc8\x98",
  [0xe4bf] = "\xc8\x99", [0xe4c0] = "\xc8\x9a", [0xe4c1] = "\xc8\x9b",
  [0xe4c2] = "\xc8\x9c", [0xe4c3] = "\xc8\x9d", [0xe4c4] = "\xc8\x9e",
  [0xe4c5] = "\xc8\x9f", [0xe4c6] = "\xc8\xa0", [0xe4c7] = "\xc8\xa1",
  [0xe4c8] = "\xc8\xa2", [0xe4c9] = "\xc8\xa3", [0xe4ca] = "\xc8\xa4",
  [0xe4cb] = "\xc8\xa5", [0xe4cc] = "\xc8\xa6", [0xe4cd] = "\xc8\xa7",
  [0xe4ce] = "\xc8\xa8", [0xe4cf] = "\xc8\xa9", [0xe4d0] = "\xc8\xaa",
  [0xe4d1] = "\xc8\xab", [0xe4d2] = "\xc8\xac", [0xe4d3] = "\xc8\xad",
  [0xe4d4] = "\xc8\xae", [0xe4d5] = "\xc8\xaf", [0xe4d6] = "\xc8\xb0",
  [0xe4d7] = "\xc8\xb1", [0xe4d8] = "\xc8\xb2", [0xe4d9] = "\xc8\xb3",
  [0xe4da] = "\xc8\xb4", [0xe4db] = "\xc8\xb5", [0xe4dc] = "\xc8\xb6",
  [0xe4dd] = "\xc8\xb7", [0xe4de] = "\xc8\xb8", [0xe4df] = "\xc8\xb9",
  [0xe4e0] = "\xc8\xba", [0xe4e1] = "\xc8\xbb", [0xe4e2] = "\xc8\xbc",
  [0xe4e3] = "\xc8\xbd", [0xe4e4] = "\xc8\xbe", [0xe4e5] = "\xc8\xbf",
  [0xe4e6] = "\xc8\xc0", [0xe4e7] = "\xc8\xc1", [0xe4e8] = "\xc8\xc2",
  [0xe4e9] = "\xc8\xc3", [0xe4ea] = "\xc8\xc4", [0xe4eb] = "\xc8\xc5",
  [0xe4ec] = "\xc8\xc6", [0xe4ed] = "\xc8\xc7", [0xe4ee] = "\xc8\xc8",
  [0xe4ef] = "\xc8\xc9", [0xe4f0] = "\xc8\xca", [0xe4f1] = "\xc8\xcb",
  [0xe4f2] = "\xc8\xcc", [0xe4f3] = "\xc8\xcd", [0xe4f4] = "\xc8\xce",
  [0xe4f5] = "\xc8\xcf", [0xe4f6] = "\xc8\xd0", [0xe4f7] = "\xc8\xd1",
  [0xe4f8] = "\xc8\xd2", [0xe4f9] = "\xc8\xd3", [0xe4fa] = "\xc8\xd4",
  [0xe4fb] = "\xc8\xd5", [0xe4fc] = "\xc8\xd6", [0xe4fd] = "\xc8\xd7",
  [0xe4fe] = "\xc8\xd8", [0xe4ff] = "\xc8\xd9", [0xe500] = "\xc8\xda",
  [0xe501] = "\xc8\xdb", [0xe502] = "\xc8\xdc", [0xe503] = "\xc8\xdd",
  [0xe504] = "\xc8\xde", [0xe505] = "\xc8\xdf", [0xe506] = "\xc8\xe0",
  [0xe507] = "\xc8\xe1", [0xe508] = "\xc8\xe2", [0xe509] = "\xc8\xe3",
  [0xe50a] = "\xc8\xe4", [0xe50b] = "\xc8\xe5", [0xe50c] = "\xc8\xe6",
  [0xe50d] = "\xc8\xe7", [0xe50e] = "\xc8\xe8", [0xe50f] = "\xc8\xe9",
  [0xe510] = "\xc8\xea", [0xe511] = "\xc8\xeb", [0xe512] = "\xc8\xec",
  [0xe513] = "\xc8\xed", [0xe514] = "\xc8\xee", [0xe515] = "\xc8\xef",
  [0xe516] = "\xc8\xf0", [0xe517] = "\xc8\xf1", [0xe518] = "\xc8\xf2",
  [0xe519] = "\xc8\xf3", [0xe51a] = "\xc8\xf4", [0xe51b] = "\xc8\xf5",
  [0xe51c] = "\xc8\xf6", [0xe51d] = "\xc8\xf7", [0xe51e] = "\xc8\xf8",
  [0xe51f] = "\xc8\xf9", [0xe520] = "\xc8\xfa", [0xe521] = "\xc8\xfb",
  [0xe522] = "\xc8\xfc", [0xe523] = "\xc8\xfd", [0xe524] = "\xc9\x41",
  [0xe525] = "\xc9\x42", [0xe526] = "\xc9\x43", [0xe527] = "\xc9\x44",
  [0xe528] = "\xc9\x45", [0xe529] = "\xc9\x46", [0xe52a] = "\xc9\x47",
  [0xe52b] = "\xc9\x48", [0xe52c] = "\xc9\x49", [0xe52d] = "\xc9\x4a",
  [0xe52e] = "\xc9\x4b", [0xe52f] = "\xc9\x4c", [0xe530] = "\xc9\x4d",
  [0xe531] = "\xc9\x4e", [0xe532] = "\xc9\x4f", [0xe533] = "\xc9\x50",
  [0xe534] = "\xc9\x51", [0xe535] = "\xc9\x52", [0xe536] = "\xc9\x53",
  [0xe537] = "\xc9\x54", [0xe538] = "\xc9\x55", [0xe539] = "\xc9\x56",
  [0xe53a] = "\xc9\x57", [0xe53b] = "\xc9\x58", [0xe53c] = "\xc9\x59",
  [0xe53d] = "\xc9\x5a", [0xe53e] = "\xc9\x5b", [0xe53f] = "\xc9\x5c",
  [0xe540] = "\xc9\x5d", [0xe541] = "\xc9\x5e", [0xe542] = "\xc9\x5f",
  [0xe543] = "\xc9\x60", [0xe544] = "\xc9\x61", [0xe545] = "\xc9\x62",
  [0xe546] = "\xc9\x63", [0xe547] = "\xc9\x64", [0xe548] = "\xc9\x65",
  [0xe549] = "\xc9\x66", [0xe54a] = "\xc9\x67", [0xe54b] = "\xc9\x68",
  [0xe54c] = "\xc9\x69", [0xe54d] = "\xc9\x6a", [0xe54e] = "\xc9\x6b",
  [0xe54f] = "\xc9\x6c", [0xe550] = "\xc9\x6d", [0xe551] = "\xc9\x6e",
  [0xe552] = "\xc9\x6f", [0xe553] = "\xc9\x70", [0xe554] = "\xc9\x71",
  [0xe555] = "\xc9\x72", [0xe556] = "\xc9\x73", [0xe557] = "\xc9\x74",
  [0xe558] = "\xc9\x75", [0xe559] = "\xc9\x76", [0xe55a] = "\xc9\x77",
  [0xe55b] = "\xc9\x78", [0xe55c] = "\xc9\x79", [0xe55d] = "\xc9\x7a",
  [0xe55e] = "\xc9\x7b", [0xe55f] = "\xc9\x7c", [0xe560] = "\xc9\x7d",
  [0xe561] = "\xc9\x7e", [0xe562] = "\xc9\x7f", [0xe563] = "\xc9\x81",
  [0xe564] = "\xc9\x82", [0xe565] = "\xc9\x83", [0xe566] = "\xc9\x84",
  [0xe567] = "\xc9\x85", [0xe568] = "\xc9\x86", [0xe569] = "\xc9\x87",
  [0xe56a] = "\xc9\x88", [0xe56b] = "\xc9\x89", [0xe56c] = "\xc9\x8a",
  [0xe56d] = "\xc9\x8b", [0xe56e] = "\xc9\x8c", [0xe56f] = "\xc9\x8d",
  [0xe570] = "\xc9\x8e", [0xe571] = "\xc9\x8f", [0xe572] = "\xc9\x90",
  [0xe573] = "\xc9\x91", [0xe574] = "\xc9\x92", [0xe575] = "\xc9\x93",
  [0xe576] = "\xc9\x94", [0xe577] = "\xc9\x95", [0xe578] = "\xc9\x96",
  [0xe579] = "\xc9\x97", [0xe57a] = "\xc9\x98", [0xe57b] = "\xc9\x99",
  [0xe57c] = "\xc9\x9a", [0xe57d] = "\xc9\x9b", [0xe57e] = "\xc9\x9c",
  [0xe57f] = "\xc9\x9d", [0xe580] = "\xc9\x9e", [0xe581] = "\xc9\x9f",
  [0xe582] = "\xc9\xa0", [0xe583] = "\xc9\xa1", [0xe584] = "\xc9\xa2",
  [0xe585] = "\xc9\xa3", [0xe586] = "\xc9\xa4", [0xe587] = "\xc9\xa5",
  [0xe588] = "\xc9\xa6", [0xe589] = "\xc9\xa7", [0xe58a] = "\xc9\xa8",
  [0xe58b] = "\xc9\xa9", [0xe58c] = "\xc9\xaa", [0xe58d] = "\xc9\xab",
  [0xe58e] = "\xc9\xac", [0xe58f] = "\xc9\xad", [0xe590] = "\xc9\xae",
  [0xe591] = "\xc9\xaf", [0xe592] = "\xc9\xb0", [0xe593] = "\xc9\xb1",
  [0xe594] = "\xc9\xb2", [0xe595] = "\xc9\xb3", [0xe596] = "\xc9\xb4",
  [0xe597] = "\xc9\xb5", [0xe598] = "\xc9\xb6", [0xe599] = "\xc9\xb7",
  [0xe59a] = "\xc9\xb8", [0xe59b] = "\xc9\xb9", [0xe59c] = "\xc9\xba",
  [0xe59d] = "\xc9\xbb", [0xe59e] = "\xc9\xbc", [0xe59f] = "\xc9\xbd",
  [0xe5a0] = "\xc9\xbe", [0xe5a1] = "\xc9\xbf", [0xe5a2] = "\xc9\xc0",
  [0xe5a3] = "\xc9\xc1", [0xe5a4] = "\xc9\xc2", [0xe5a5] = "\xc9\xc3",
  [0xe5a6] = "\xc9\xc4", [0xe5a7] = "\xc9\xc5", [0xe5a8] = "\xc9\xc6",
  [0xe5a9] = "\xc9\xc7", [0xe5aa] = "\xc9\xc8", [0xe5ab] = "\xc9\xc9",
  [0xe5ac] = "\xc9\xca", [0xe5ad] = "\xc9\xcb", [0xe5ae] = "\xc9\xcc",
  [0xe5af] = "\xc9\xcd", [0xe5b0] = "\xc9\xce", [0xe5b1] = "\xc9\xcf",
  [0xe5b2] = "\xc9\xd0", [0xe5b3] = "\xc9\xd1", [0xe5b4] = "\xc9\xd2",
  [0xe5b5] = "\xc9\xd3", [0xe5b6] = "\xc9\xd4", [0xe5b7] = "\xc9\xd5",
  [0xe5b8] = "\xc9\xd6", [0xe5b9] = "\xc9\xd7", [0xe5ba] = "\xc9\xd8",
  [0xe5bb] = "\xc9\xd9", [0xe5bc] = "\xc9\xda", [0xe5bd] = "\xc9\xdb",
  [0xe5be] = "\xc9\xdc", [0xe5bf] = "\xc9\xdd", [0xe5c0] = "\xc9\xde",
  [0xe5c1] = "\xc9\xdf", [0xe5c2] = "\xc9\xe0", [0xe5c3] = "\xc9\xe1",
  [0xe5c4] = "\xc9\xe2", [0xe5c5] = "\xc9\xe3", [0xe5c6] = "\xc9\xe4",
  [0xe5c7] = "\xc9\xe5", [0xe5c8] = "\xc9\xe6", [0xe5c9] = "\xc9\xe7",
  [0xe5ca] = "\xc9\xe8", [0xe5cb] = "\xc9\xe9", [0xe5cc] = "\xc9\xea",
  [0xe5cd] = "\xc9\xeb", [0xe5ce] = "\xc9\xec", [0xe5cf] = "\xc9\xed",
  [0xe5d0] = "\xc9\xee", [0xe5d1] = "\xc9\xef", [0xe5d2] = "\xc9\xf0",
  [0xe5d3] = "\xc9\xf1", [0xe5d4] = "\xc9\xf2", [0xe5d5] = "\xc9\xf3",
  [0xe5d6] = "\xc9\xf4", [0xe5d7] = "\xc9\xf5", [0xe5d8] = "\xc9\xf6",
  [0xe5d9] = "\xc9\xf7", [0xe5da] = "\xc9\xf8", [0xe5db] = "\xc9\xf9",
  [0xe5dc] = "\xc9\xfa", [0xe5dd] = "\xc9\xfb", [0xe5de] = "\xc9\xfc",
  [0xe5df] = "\xc9\xfd", [0xe5e0] = "\xca\x41", [0xe5e1] = "\xca\x42",
  [0xe5e2] = "\xca\x43", [0xe5e3] = "\xca\x44", [0xe5e4] = "\xca\x45",
  [0xe5e5] = "\xca\x46", [0xe5e6] = "\xca\x47", [0xe5e7] = "\xca\x48",
  [0xe5e8] = "\xca\x49", [0xe5e9] = "\xca\x4a", [0xe5ea] = "\xca\x4b",
  [0xe5eb] = "\xca\x4c", [0xe5ec] = "\xca\x4d", [0xe5ed] = "\xca\x4e",
  [0xe5ee] = "\xca\x4f", [0xe5ef] = "\xca\x50", [0xe5f0] = "\xca\x51",
  [0xe5f1] = "\xca\x52", [0xe5f2] = "\xca\x53", [0xe5f3] = "\xca\x54",
  [0xe5f4] = "\xca\x55", [0xe5f5] = "\xca\x56", [0xe5f6] = "\xca\x57",
  [0xe5f7] = "\xca\x58", [0xe5f8] = "\xca\x59", [0xe5f9] = "\xca\x5a",
  [0xe5fa] = "\xca\x5b", [0xe5fb] = "\xca\x5c", [0xe5fc] = "\xca\x5d",
  [0xe5fd] = "\xca\x5e", [0xe5fe] = "\xca\x5f", [0xe5ff] = "\xca\x60",
  [0xe600] = "\xca\x61", [0xe601] = "\xca\x62", [0xe602] = "\xca\x63",
  [0xe603] = "\xca\x64", [0xe604] = "\xca\x65", [0xe605] = "\xca\x66",
  [0xe606] = "\xca\x67", [0xe607] = "\xca\x68", [0xe608] = "\xca\x69",
  [0xe609] = "\xca\x6a", [0xe60a] = "\xca\x6b", [0xe60b] = "\xca\x6c",
  [0xe60c] = "\xca\x6d", [0xe60d] = "\xca\x6e", [0xe60e] = "\xca\x6f",
  [0xe60f] = "\xca\x70", [0xe610] = "\xca\x71", [0xe611] = "\xca\x72",
  [0xe612] = "\xca\x73", [0xe613] = "\xca\x74", [0xe614] = "\xca\x75",
  [0xe615] = "\xca\x76", [0xe616] = "\xca\x77", [0xe617] = "\xca\x78",
  [0xe618] = "\xca\x79", [0xe619] = "\xca\x7a", [0xe61a] = "\xca\x7b",
  [0xe61b] = "\xca\x7c", [0xe61c] = "\xca\x7d", [0xe61d] = "\xca\x7e",
  [0xe61e] = "\xca\x7f", [0xe61f] = "\xca\x81", [0xe620] = "\xca\x82",
  [0xe621] = "\xca\x83", [0xe622] = "\xca\x84", [0xe623] = "\xca\x85",
  [0xe624] = "\xca\x86", [0xe625] = "\xca\x87", [0xe626] = "\xca\x88",
  [0xe627] = "\xca\x89", [0xe628] = "\xca\x8a", [0xe629] = "\xca\x8b",
  [0xe62a] = "\xca\x8c", [0xe62b] = "\xca\x8d", [0xe62c] = "\xca\x8e",
  [0xe62d] = "\xca\x8f", [0xe62e] = "\xca\x90", [0xe62f] = "\xca\x91",
  [0xe630] = "\xca\x92", [0xe631] = "\xca\x93", [0xe632] = "\xca\x94",
  [0xe633] = "\xca\x95", [0xe634] = "\xca\x96", [0xe635] = "\xca\x97",
  [0xe636] = "\xca\x98", [0xe637] = "\xca\x99", [0xe638] = "\xca\x9a",
  [0xe639] = "\xca\x9b", [0xe63a] = "\xca\x9c", [0xe63b] = "\xca\x9d",
  [0xe63c] = "\xca\x9e", [0xe63d] = "\xca\x9f", [0xe63e] = "\xca\xa0",
  [0xe63f] = "\xca\xa1", [0xe640] = "\xca\xa2", [0xe641] = "\xca\xa3",
  [0xe642] = "\xca\xa4", [0xe643] = "\xca\xa5", [0xe644] = "\xca\xa6",
  [0xe645] = "\xca\xa7", [0xe646] = "\xca\xa8", [0xe647] = "\xca\xa9",
  [0xe648] = "\xca\xaa", [0xe649] = "\xca\xab", [0xe64a] = "\xca\xac",
  [0xe64b] = "\xca\xad", [0xe64c] = "\xca\xae", [0xe64d] = "\xca\xaf",
  [0xe64e] = "\xca\xb0", [0xe64f] = "\xca\xb1", [0xe650] = "\xca\xb2",
  [0xe651] = "\xca\xb3", [0xe652] = "\xca\xb4", [0xe653] = "\xca\xb5",
  [0xe654] = "\xca\xb6", [0xe655] = "\xca\xb7", [0xe656] = "\xca\xb8",
  [0xe657] = "\xca\xb9", [0xe658] = "\xca\xba", [0xe659] = "\xca\xbb",
  [0xe65a] = "\xca\xbc", [0xe65b] = "\xca\xbd", [0xe65c] = "\xca\xbe",
  [0xe65d] = "\xca\xbf", [0xe65e] = "\xca\xc0", [0xe65f] = "\xca\xc1",
  [0xe660] = "\xca\xc2", [0xe661] = "\xca\xc3", [0xe662] = "\xca\xc4",
  [0xe663] = "\xca\xc5", [0xe664] = "\xca\xc6", [0xe665] = "\xca\xc7",
  [0xe666] = "\xca\xc8", [0xe667] = "\xca\xc9", [0xe668] = "\xca\xca",
  [0xe669] = "\xca\xcb", [0xe66a] = "\xca\xcc", [0xe66b] = "\xca\xcd",
  [0xe66c] = "\xca\xce", [0xe66d] = "\xca\xcf", [0xe66e] = "\xca\xd0",
  [0xe66f] = "\xca\xd1", [0xe670] = "\xca\xd2", [0xe671] = "\xca\xd3",
  [0xe672] = "\xca\xd4", [0xe673] = "\xca\xd5", [0xe674] = "\xca\xd6",
  [0xe675] = "\xca\xd7", [0xe676] = "\xca\xd8", [0xe677] = "\xca\xd9",
  [0xe678] = "\xca\xda", [0xe679] = "\xca\xdb", [0xe67a] = "\xca\xdc",
  [0xe67b] = "\xca\xdd", [0xe67c] = "\xca\xde", [0xe67d] = "\xca\xdf",
  [0xe67e] = "\xca\xe0", [0xe67f] = "\xca\xe1", [0xe680] = "\xca\xe2",
  [0xe681] = "\xca\xe3", [0xe682] = "\xca\xe4", [0xe683] = "\xca\xe5",
  [0xe684] = "\xca\xe6", [0xe685] = "\xca\xe7", [0xe686] = "\xca\xe8",
  [0xe687] = "\xca\xe9", [0xe688] = "\xca\xea", [0xe689] = "\xca\xeb",
  [0xe68a] = "\xca\xec", [0xe68b] = "\xca\xed", [0xe68c] = "\xca\xee",
  [0xe68d] = "\xca\xef", [0xe68e] = "\xca\xf0", [0xe68f] = "\xca\xf1",
  [0xe690] = "\xca\xf2", [0xe691] = "\xca\xf3", [0xe692] = "\xca\xf4",
  [0xe693] = "\xca\xf5", [0xe694] = "\xca\xf6", [0xe695] = "\xca\xf7",
  [0xe696] = "\xca\xf8", [0xe697] = "\xca\xf9", [0xe698] = "\xca\xfa",
  [0xe699] = "\xca\xfb", [0xe69a] = "\xca\xfc", [0xe69b] = "\xca\xfd",
  [0xe69c] = "\xcb\x41", [0xe69d] = "\xcb\x42", [0xe69e] = "\xcb\x43",
  [0xe69f] = "\xcb\x44", [0xe6a0] = "\xcb\x45", [0xe6a1] = "\xcb\x46",
  [0xe6a2] = "\xcb\x47", [0xe6a3] = "\xcb\x48", [0xe6a4] = "\xcb\x49",
  [0xe6a5] = "\xcb\x4a", [0xe6a6] = "\xcb\x4b", [0xe6a7] = "\xcb\x4c",
  [0xe6a8] = "\xcb\x4d", [0xe6a9] = "\xcb\x4e", [0xe6aa] = "\xcb\x4f",
  [0xe6ab] = "\xcb\x50", [0xe6ac] = "\xcb\x51", [0xe6ad] = "\xcb\x52",
  [0xe6ae] = "\xcb\x53", [0xe6af] = "\xcb\x54", [0xe6b0] = "\xcb\x55",
  [0xe6b1] = "\xcb\x56", [0xe6b2] = "\xcb\x57", [0xe6b3] = "\xcb\x58",
  [0xe6b4] = "\xcb\x59", [0xe6b5] = "\xcb\x5a", [0xe6b6] = "\xcb\x5b",
  [0xe6b7] = "\xcb\x5c", [0xe6b8] = "\xcb\x5d", [0xe6b9] = "\xcb\x5e",
  [0xe6ba] = "\xcb\x5f", [0xe6bb] = "\xcb\x60", [0xe6bc] = "\xcb\x61",
  [0xe6bd] = "\xcb\x62", [0xe6be] = "\xcb\x63", [0xe6bf] = "\xcb\x64",
  [0xe6c0] = "\xcb\x65", [0xe6c1] = "\xcb\x66", [0xe6c2] = "\xcb\x67",
  [0xe6c3] = "\xcb\x68", [0xe6c4] = "\xcb\x69", [0xe6c5] = "\xcb\x6a",
  [0xe6c6] = "\xcb\x6b", [0xe6c7] = "\xcb\x6c", [0xe6c8] = "\xcb\x6d",
  [0xe6c9] = "\xcb\x6e", [0xe6ca] = "\xcb\x6f", [0xe6cb] = "\xcb\x70",
  [0xe6cc] = "\xcb\x71", [0xe6cd] = "\xcb\x72", [0xe6ce] = "\xcb\x73",
  [0xe6cf] = "\xcb\x74", [0xe6d0] = "\xcb\x75", [0xe6d1] = "\xcb\x76",
  [0xe6d2] = "\xcb\x77", [0xe6d3] = "\xcb\x78", [0xe6d4] = "\xcb\x79",
  [0xe6d5] = "\xcb\x7a", [0xe6d6] = "\xcb\x7b", [0xe6d7] = "\xcb\x7c",
  [0xe6d8] = "\xcb\x7d", [0xe6d9] = "\xcb\x7e", [0xe6da] = "\xcb\x7f",
  [0xe6db] = "\xcb\x81", [0xe6dc] = "\xcb\x82", [0xe6dd] = "\xcb\x83",
  [0xe6de] = "\xcb\x84", [0xe6df] = "\xcb\x85", [0xe6e0] = "\xcb\x86",
  [0xe6e1] = "\xcb\x87", [0xe6e2] = "\xcb\x88", [0xe6e3] = "\xcb\x89",
  [0xe6e4] = "\xcb\x8a", [0xe6e5] = "\xcb\x8b", [0xe6e6] = "\xcb\x8c",
  [0xe6e7] = "\xcb\x8d", [0xe6e8] = "\xcb\x8e", [0xe6e9] = "\xcb\x8f",
  [0xe6ea] = "\xcb\x90", [0xe6eb] = "\xcb\x91", [0xe6ec] = "\xcb\x92",
  [0xe6ed] = "\xcb\x93", [0xe6ee] = "\xcb\x94", [0xe6ef] = "\xcb\x95",
  [0xe6f0] = "\xcb\x96", [0xe6f1] = "\xcb\x97", [0xe6f2] = "\xcb\x98",
  [0xe6f3] = "\xcb\x99", [0xe6f4] = "\xcb\x9a", [0xe6f5] = "\xcb\x9b",
  [0xe6f6] = "\xcb\x9c", [0xe6f7] = "\xcb\x9d", [0xe6f8] = "\xcb\x9e",
  [0xe6f9] = "\xcb\x9f", [0xe6fa] = "\xcb\xa0", [0xe6fb] = "\xcb\xa1",
  [0xe6fc] = "\xcb\xa2", [0xe6fd] = "\xcb\xa3", [0xe6fe] = "\xcb\xa4",
  [0xe6ff] = "\xcb\xa5", [0xe700] = "\xcb\xa6", [0xe701] = "\xcb\xa7",
  [0xe702] = "\xcb\xa8", [0xe703] = "\xcb\xa9", [0xe704] = "\xcb\xaa",
  [0xe705] = "\xcb\xab", [0xe706] = "\xcb\xac", [0xe707] = "\xcb\xad",
  [0xe708] = "\xcb\xae", [0xe709] = "\xcb\xaf", [0xe70a] = "\xcb\xb0",
  [0xe70b] = "\xcb\xb1", [0xe70c] = "\xcb\xb2", [0xe70d] = "\xcb\xb3",
  [0xe70e] = "\xcb\xb4", [0xe70f] = "\xcb\xb5", [0xe710] = "\xcb\xb6",
  [0xe711] = "\xcb\xb7", [0xe712] = "\xcb\xb8", [0xe713] = "\xcb\xb9",
  [0xe714] = "\xcb\xba", [0xe715] = "\xcb\xbb", [0xe716] = "\xcb\xbc",
  [0xe717] = "\xcb\xbd", [0xe718] = "\xcb\xbe", [0xe719] = "\xcb\xbf",
  [0xe71a] = "\xcb\xc0", [0xe71b] = "\xcb\xc1", [0xe71c] = "\xcb\xc2",
  [0xe71d] = "\xcb\xc3", [0xe71e] = "\xcb\xc4", [0xe71f] = "\xcb\xc5",
  [0xe720] = "\xcb\xc6", [0xe721] = "\xcb\xc7", [0xe722] = "\xcb\xc8",
  [0xe723] = "\xcb\xc9", [0xe724] = "\xcb\xca", [0xe725] = "\xcb\xcb",
  [0xe726] = "\xcb\xcc", [0xe727] = "\xcb\xcd", [0xe728] = "\xcb\xce",
  [0xe729] = "\xcb\xcf", [0xe72a] = "\xcb\xd0", [0xe72b] = "\xcb\xd1",
  [0xe72c] = "\xcb\xd2", [0xe72d] = "\xcb\xd3", [0xe72e] = "\xcb\xd4",
  [0xe72f] = "\xcb\xd5", [0xe730] = "\xcb\xd6", [0xe731] = "\xcb\xd7",
  [0xe732] = "\xcb\xd8", [0xe733] = "\xcb\xd9", [0xe734] = "\xcb\xda",
  [0xe735] = "\xcb\xdb", [0xe736] = "\xcb\xdc", [0xe737] = "\xcb\xdd",
  [0xe738] = "\xcb\xde", [0xe739] = "\xcb\xdf", [0xe73a] = "\xcb\xe0",
  [0xe73b] = "\xcb\xe1", [0xe73c] = "\xcb\xe2", [0xe73d] = "\xcb\xe3",
  [0xe73e] = "\xcb\xe4", [0xe73f] = "\xcb\xe5", [0xe740] = "\xcb\xe6",
  [0xe741] = "\xcb\xe7", [0xe742] = "\xcb\xe8", [0xe743] = "\xcb\xe9",
  [0xe744] = "\xcb\xea", [0xe745] = "\xcb\xeb", [0xe746] = "\xcb\xec",
  [0xe747] = "\xcb\xed", [0xe748] = "\xcb\xee", [0xe749] = "\xcb\xef",
  [0xe74a] = "\xcb\xf0", [0xe74b] = "\xcb\xf1", [0xe74c] = "\xcb\xf2",
  [0xe74d] = "\xcb\xf3", [0xe74e] = "\xcb\xf4", [0xe74f] = "\xcb\xf5",
  [0xe750] = "\xcb\xf6", [0xe751] = "\xcb\xf7", [0xe752] = "\xcb\xf8",
  [0xe753] = "\xcb\xf9", [0xe754] = "\xcb\xfa", [0xe755] = "\xcb\xfb",
  [0xe756] = "\xcb\xfc", [0xe757] = "\xcb\xfd", [0xe758] = "\xcc\x41",
  [0xe759] = "\xcc\x42", [0xe75a] = "\xcc\x43", [0xe75b] = "\xcc\x44",
  [0xe75c] = "\xcc\x45", [0xe75d] = "\xcc\x46", [0xe75e] = "\xcc\x47",
  [0xe75f] = "\xcc\x48", [0xe760] = "\xcc\x49", [0xe761] = "\xcc\x4a",
  [0xe762] = "\xcc\x4b", [0xe763] = "\xcc\x4c", [0xe764] = "\xcc\x4d",
  [0xe765] = "\xcc\x4e", [0xe766] = "\xcc\x4f", [0xe767] = "\xcc\x50",
  [0xe768] = "\xcc\x51", [0xe769] = "\xcc\x52", [0xe76a] = "\xcc\x53",
  [0xe76b] = "\xcc\x54", [0xe76c] = "\xcc\x55", [0xe76d] = "\xcc\x56",
  [0xe76e] = "\xcc\x57", [0xe76f] = "\xcc\x58", [0xe770] = "\xcc\x59",
  [0xe771] = "\xcc\x5a", [0xe772] = "\xcc\x5b", [0xe773] = "\xcc\x5c",
  [0xe774] = "\xcc\x5d", [0xe775] = "\xcc\x5e", [0xe776] = "\xcc\x5f",
  [0xe777] = "\xcc\x60", [0xe778] = "\xcc\x61", [0xe779] = "\xcc\x62",
  [0xe77a] = "\xcc\x63", [0xe77b] = "\xcc\x64", [0xe77c] = "\xcc\x65",
  [0xe77d] = "\xcc\x66", [0xe77e] = "\xcc\x67", [0xe77f] = "\xcc\x68",
  [0xe780] = "\xcc\x69", [0xe781] = "\xcc\x6a", [0xe782] = "\xcc\x6b",
  [0xe783] = "\xcc\x6c", [0xe784] = "\xcc\x6d", [0xe785] = "\xcc\x6e",
  [0xe786] = "\xcc\x6f", [0xe787] = "\xcc\x70", [0xe788] = "\xcc\x71",
  [0xe789] = "\xcc\x72", [0xe78a] = "\xcc\x73", [0xe78b] = "\xcc\x74",
  [0xe78c] = "\xcc\x75", [0xe78d] = "\xcc\x76", [0xe78e] = "\xcc\x77",
  [0xe78f] = "\xcc\x78", [0xe790] = "\xcc\x79", [0xe791] = "\xcc\x7a",
  [0xe792] = "\xcc\x7b", [0xe793] = "\xcc\x7c", [0xe794] = "\xcc\x7d",
  [0xe795] = "\xcc\x7e", [0xe796] = "\xcc\x7f", [0xe797] = "\xcc\x81",
  [0xe798] = "\xcc\x82", [0xe799] = "\xcc\x83", [0xe79a] = "\xcc\x84",
  [0xe79b] = "\xcc\x85", [0xe79c] = "\xcc\x86", [0xe79d] = "\xcc\x87",
  [0xe79e] = "\xcc\x88", [0xe79f] = "\xcc\x89", [0xe7a0] = "\xcc\x8a",
  [0xe7a1] = "\xcc\x8b", [0xe7a2] = "\xcc\x8c", [0xe7a3] = "\xcc\x8d",
  [0xe7a4] = "\xcc\x8e", [0xe7a5] = "\xcc\x8f", [0xe7a6] = "\xcc\x90",
  [0xe7a7] = "\xcc\x91", [0xe7a8] = "\xcc\x92", [0xe7a9] = "\xcc\x93",
  [0xe7aa] = "\xcc\x94", [0xe7ab] = "\xcc\x95", [0xe7ac] = "\xcc\x96",
  [0xe7ad] = "\xcc\x97", [0xe7ae] = "\xcc\x98", [0xe7af] = "\xcc\x99",
  [0xe7b0] = "\xcc\x9a", [0xe7b1] = "\xcc\x9b", [0xe7b2] = "\xcc\x9c",
  [0xe7b3] = "\xcc\x9d", [0xe7b4] = "\xcc\x9e", [0xe7b5] = "\xcc\x9f",
  [0xe7b6] = "\xcc\xa0", [0xe7b7] = "\xcc\xa1", [0xe7b8] = "\xcc\xa2",
  [0xe7b9] = "\xcc\xa3", [0xe7ba] = "\xcc\xa4", [0xe7bb] = "\xcc\xa5",
  [0xe7bc] = "\xcc\xa6", [0xe7bd] = "\xcc\xa7", [0xe7be] = "\xcc\xa8",
  [0xe7bf] = "\xcc\xa9", [0xe7c0] = "\xcc\xaa", [0xe7c1] = "\xcc\xab",
  [0xe7c2] = "\xcc\xac", [0xe7c3] = "\xcc\xad", [0xe7c4] = "\xcc\xae",
  [0xe7c5] = "\xcc\xaf", [0xe7c6] = "\xcc\xb0", [0xe7c7] = "\xcc\xb1",
  [0xe7c8] = "\xcc\xb2", [0xe7c9] = "\xcc\xb3", [0xe7ca] = "\xcc\xb4",
  [0xe7cb] = "\xcc\xb5", [0xe7cc] = "\xcc\xb6", [0xe7cd] = "\xcc\xb7",
  [0xe7ce] = "\xcc\xb8", [0xe7cf] = "\xcc\xb9", [0xe7d0] = "\xcc\xba",
  [0xe7d1] = "\xcc\xbb", [0xe7d2] = "\xcc\xbc", [0xe7d3] = "\xcc\xbd",
  [0xe7d4] = "\xcc\xbe", [0xe7d5] = "\xcc\xbf", [0xe7d6] = "\xcc\xc0",
  [0xe7d7] = "\xcc\xc1", [0xe7d8] = "\xcc\xc2", [0xe7d9] = "\xcc\xc3",
  [0xe7da] = "\xcc\xc4", [0xe7db] = "\xcc\xc5", [0xe7dc] = "\xcc\xc6",
  [0xe7dd] = "\xcc\xc7", [0xe7de] = "\xcc\xc8", [0xe7df] = "\xcc\xc9",
  [0xe7e0] = "\xcc\xca", [0xe7e1] = "\xcc\xcb", [0xe7e2] = "\xcc\xcc",
  [0xe7e3] = "\xcc\xcd", [0xe7e4] = "\xcc\xce", [0xe7e5] = "\xcc\xcf",
  [0xe7e6] = "\xcc\xd0", [0xe7e7] = "\xcc\xd1", [0xe7e8] = "\xcc\xd2",
  [0xe7e9] = "\xcc\xd3", [0xe7ea] = "\xcc\xd4", [0xe7eb] = "\xcc\xd5",
  [0xe7ec] = "\xcc\xd6", [0xe7ed] = "\xcc\xd7", [0xe7ee] = "\xcc\xd8",
  [0xe7ef] = "\xcc\xd9", [0xe7f0] = "\xcc\xda", [0xe7f1] = "\xcc\xdb",
  [0xe7f2] = "\xcc\xdc", [0xe7f3] = "\xcc\xdd", [0xe7f4] = "\xcc\xde",
  [0xe7f5] = "\xcc\xdf", [0xe7f6] = "\xcc\xe0", [0xe7f7] = "\xcc\xe1",
  [0xe7f8] = "\xcc\xe2", [0xe7f9] = "\xcc\xe3", [0xe7fa] = "\xcc\xe4",
  [0xe7fb] = "\xcc\xe5", [0xe7fc] = "\xcc\xe6", [0xe7fd] = "\xcc\xe7",
  [0xe7fe] = "\xcc\xe8", [0xe7ff] = "\xcc\xe9", [0xe800] = "\xcc\xea",
  [0xe801] = "\xcc\xeb", [0xe802] = "\xcc\xec", [0xe803] = "\xcc\xed",
  [0xe804] = "\xcc\xee", [0xe805] = "\xcc\xef", [0xe806] = "\xcc\xf0",
  [0xe807] = "\xcc\xf1", [0xe808] = "\xcc\xf2", [0xe809] = "\xcc\xf3",
  [0xe80a] = "\xcc\xf4", [0xe80b] = "\xcc\xf5", [0xe80c] = "\xcc\xf6",
  [0xe80d] = "\xcc\xf7", [0xe80e] = "\xcc\xf8", [0xe80f] = "\xcc\xf9",
  [0xe810] = "\xcc\xfa", [0xe811] = "\xcc\xfb", [0xe812] = "\xcc\xfc",
  [0xe813] = "\xcc\xfd", [0xe814] = "\xcd\x41", [0xe815] = "\xcd\x42",
  [0xe816] = "\xcd\x43", [0xe817] = "\xcd\x44", [0xe818] = "\xcd\x45",
  [0xe819] = "\xcd\x46", [0xe81a] = "\xcd\x47", [0xe81b] = "\xcd\x48",
  [0xe81c] = "\xcd\x49", [0xe81d] = "\xcd\x4a", [0xe81e] = "\xcd\x4b",
  [0xe81f] = "\xcd\x4c", [0xe820] = "\xcd\x4d", [0xe821] = "\xcd\x4e",
  [0xe822] = "\xcd\x4f", [0xe823] = "\xcd\x50", [0xe824] = "\xcd\x51",
  [0xe825] = "\xcd\x52", [0xe826] = "\xcd\x53", [0xe827] = "\xcd\x54",
  [0xe828] = "\xcd\x55", [0xe829] = "\xcd\x56", [0xe82a] = "\xcd\x57",
  [0xe82b] = "\xcd\x58", [0xe82c] = "\xcd\x59", [0xe82d] = "\xcd\x5a",
  [0xe82e] = "\xcd\x5b", [0xe82f] = "\xcd\x5c", [0xe830] = "\xcd\x5d",
  [0xe831] = "\xcd\x5e", [0xe832] = "\xcd\x5f", [0xe833] = "\xcd\x60",
  [0xe834] = "\xcd\x61", [0xe835] = "\xcd\x62", [0xe836] = "\xcd\x63",
  [0xe837] = "\xcd\x64", [0xe838] = "\xcd\x65", [0xe839] = "\xcd\x66",
  [0xe83a] = "\xcd\x67", [0xe83b] = "\xcd\x68", [0xe83c] = "\xcd\x69",
  [0xe83d] = "\xcd\x6a", [0xe83e] = "\xcd\x6b", [0xe83f] = "\xcd\x6c",
  [0xe840] = "\xcd\x6d", [0xe841] = "\xcd\x6e", [0xe842] = "\xcd\x6f",
  [0xe843] = "\xcd\x70", [0xe844] = "\xcd\x71", [0xe845] = "\xcd\x72",
  [0xe846] = "\xcd\x73", [0xe847] = "\xcd\x74", [0xe848] = "\xcd\x75",
  [0xe849] = "\xcd\x76", [0xe84a] = "\xcd\x77", [0xe84b] = "\xcd\x78",
  [0xe84c] = "\xcd\x79", [0xe84d] = "\xcd\x7a", [0xe84e] = "\xcd\x7b",
  [0xe84f] = "\xcd\x7c", [0xe850] = "\xcd\x7d", [0xe851] = "\xcd\x7e",
  [0xe852] = "\xcd\x7f", [0xe853] = "\xcd\x81", [0xe854] = "\xcd\x82",
  [0xe855] = "\xcd\x83", [0xe856] = "\xcd\x84", [0xe857] = "\xcd\x85",
  [0xe858] = "\xcd\x86", [0xe859] = "\xcd\x87", [0xe85a] = "\xcd\x88",
  [0xe85b] = "\xcd\x89", [0xe85c] = "\xcd\x8a", [0xe85d] = "\xcd\x8b",
  [0xe85e] = "\xcd\x8c", [0xe85f] = "\xcd\x8d", [0xe860] = "\xcd\x8e",
  [0xe861] = "\xcd\x8f", [0xe862] = "\xcd\x90", [0xe863] = "\xcd\x91",
  [0xe864] = "\xcd\x92", [0xe865] = "\xcd\x93", [0xe866] = "\xcd\x94",
  [0xe867] = "\xcd\x95", [0xe868] = "\xcd\x96", [0xe869] = "\xcd\x97",
  [0xe86a] = "\xcd\x98", [0xe86b] = "\xcd\x99", [0xe86c] = "\xcd\x9a",
  [0xe86d] = "\xcd\x9b", [0xe86e] = "\xcd\x9c", [0xe86f] = "\xcd\x9d",
  [0xe870] = "\xcd\x9e", [0xe871] = "\xcd\x9f", [0xe872] = "\xcd\xa0",
  [0xe873] = "\xcd\xa1", [0xe874] = "\xcd\xa2", [0xe875] = "\xcd\xa3",
  [0xe876] = "\xcd\xa4", [0xe877] = "\xcd\xa5", [0xe878] = "\xcd\xa6",
  [0xe879] = "\xcd\xa7", [0xe87a] = "\xcd\xa8", [0xe87b] = "\xcd\xa9",
  [0xe87c] = "\xcd\xaa", [0xe87d] = "\xcd\xab", [0xe87e] = "\xcd\xac",
  [0xe87f] = "\xcd\xad", [0xe880] = "\xcd\xae", [0xe881] = "\xcd\xaf",
  [0xe882] = "\xcd\xb0", [0xe883] = "\xcd\xb1", [0xe884] = "\xcd\xb2",
  [0xe885] = "\xcd\xb3", [0xe886] = "\xcd\xb4", [0xe887] = "\xcd\xb5",
  [0xe888] = "\xcd\xb6", [0xe889] = "\xcd\xb7", [0xe88a] = "\xcd\xb8",
  [0xe88b] = "\xcd\xb9", [0xe88c] = "\xcd\xba", [0xe88d] = "\xcd\xbb",
  [0xe88e] = "\xcd\xbc", [0xe88f] = "\xcd\xbd", [0xe890] = "\xcd\xbe",
  [0xe891] = "\xcd\xbf", [0xe892] = "\xcd\xc0", [0xe893] = "\xcd\xc1",
  [0xe894] = "\xcd\xc2", [0xe895] = "\xcd\xc3", [0xe896] = "\xcd\xc4",
  [0xe897] = "\xcd\xc5", [0xe898] = "\xcd\xc6", [0xe899] = "\xcd\xc7",
  [0xe89a] = "\xcd\xc8", [0xe89b] = "\xcd\xc9", [0xe89c] = "\xcd\xca",
  [0xe89d] = "\xcd\xcb", [0xe89e] = "\xcd\xcc", [0xe89f] = "\xcd\xcd",
  [0xe8a0] = "\xcd\xce", [0xe8a1] = "\xcd\xcf", [0xe8a2] = "\xcd\xd0",
  [0xe8a3] = "\xcd\xd1", [0xe8a4] = "\xcd\xd2", [0xe8a5] = "\xcd\xd3",
  [0xe8a6] = "\xcd\xd4", [0xe8a7] = "\xcd\xd5", [0xe8a8] = "\xcd\xd6",
  [0xe8a9] = "\xcd\xd7", [0xe8aa] = "\xcd\xd8", [0xe8ab] = "\xcd\xd9",
  [0xe8ac] = "\xcd\xda", [0xe8ad] = "\xcd\xdb", [0xe8ae] = "\xcd\xdc",
  [0xe8af] = "\xcd\xdd", [0xe8b0] = "\xcd\xde", [0xe8b1] = "\xcd\xdf",
  [0xe8b2] = "\xcd\xe0", [0xe8b3] = "\xcd\xe1", [0xe8b4] = "\xcd\xe2",
  [0xe8b5] = "\xcd\xe3", [0xe8b6] = "\xcd\xe4", [0xe8b7] = "\xcd\xe5",
  [0xe8b8] = "\xcd\xe6", [0xe8b9] = "\xcd\xe7", [0xe8ba] = "\xcd\xe8",
  [0xe8bb] = "\xcd\xe9", [0xe8bc] = "\xcd\xea", [0xe8bd] = "\xcd\xeb",
  [0xe8be] = "\xcd\xec", [0xe8bf] = "\xcd\xed", [0xe8c0] = "\xcd\xee",
  [0xe8c1] = "\xcd\xef", [0xe8c2] = "\xcd\xf0", [0xe8c3] = "\xcd\xf1",
  [0xe8c4] = "\xcd\xf2", [0xe8c5] = "\xcd\xf3", [0xe8c6] = "\xcd\xf4",
  [0xe8c7] = "\xcd\xf5", [0xe8c8] = "\xcd\xf6", [0xe8c9] = "\xcd\xf7",
  [0xe8ca] = "\xcd\xf8", [0xe8cb] = "\xcd\xf9", [0xe8cc] = "\xcd\xfa",
  [0xe8cd] = "\xcd\xfb", [0xe8ce] = "\xcd\xfc", [0xe8cf] = "\xcd\xfd",
  [0xe8d0] = "\xce\x41", [0xe8d1] = "\xce\x42", [0xe8d2] = "\xce\x43",
  [0xe8d3] = "\xce\x44", [0xe8d4] = "\xce\x45", [0xe8d5] = "\xce\x46",
  [0xe8d6] = "\xce\x47", [0xe8d7] = "\xce\x48", [0xe8d8] = "\xce\x49",
  [0xe8d9] = "\xce\x4a", [0xe8da] = "\xce\x4b", [0xe8db] = "\xce\x4c",
  [0xe8dc] = "\xce\x4d", [0xe8dd] = "\xce\x4e", [0xe8de] = "\xce\x4f",
  [0xe8df] = "\xce\x50", [0xe8e0] = "\xce\x51", [0xe8e1] = "\xce\x52",
  [0xe8e2] = "\xce\x53", [0xe8e3] = "\xce\x54", [0xe8e4] = "\xce\x55",
  [0xe8e5] = "\xce\x56", [0xe8e6] = "\xce\x57", [0xe8e7] = "\xce\x58",
  [0xe8e8] = "\xce\x59", [0xe8e9] = "\xce\x5a", [0xe8ea] = "\xce\x5b",
  [0xe8eb] = "\xce\x5c", [0xe8ec] = "\xce\x5d", [0xe8ed] = "\xce\x5e",
  [0xe8ee] = "\xce\x5f", [0xe8ef] = "\xce\x60", [0xe8f0] = "\xce\x61",
  [0xe8f1] = "\xce\x62", [0xe8f2] = "\xce\x63", [0xe8f3] = "\xce\x64",
  [0xe8f4] = "\xce\x65", [0xe8f5] = "\xce\x66", [0xe8f6] = "\xce\x67",
  [0xe8f7] = "\xce\x68", [0xe8f8] = "\xce\x69", [0xe8f9] = "\xce\x6a",
  [0xe8fa] = "\xce\x6b", [0xe8fb] = "\xce\x6c", [0xe8fc] = "\xce\x6d",
  [0xe8fd] = "\xce\x6e", [0xe8fe] = "\xce\x6f", [0xe8ff] = "\xce\x70",
  [0xe900] = "\xce\x71", [0xe901] = "\xce\x72", [0xe902] = "\xce\x73",
  [0xe903] = "\xce\x74", [0xe904] = "\xce\x75", [0xe905] = "\xce\x76",
  [0xe906] = "\xce\x77", [0xe907] = "\xce\x78", [0xe908] = "\xce\x79",
  [0xe909] = "\xce\x7a", [0xe90a] = "\xce\x7b", [0xe90b] = "\xce\x7c",
  [0xe90c] = "\xce\x7d", [0xe90d] = "\xce\x7e", [0xe90e] = "\xce\x7f",
  [0xe90f] = "\xce\x81", [0xe910] = "\xce\x82", [0xe911] = "\xce\x83",
  [0xe912] = "\xce\x84", [0xe913] = "\xce\x85", [0xe914] = "\xce\x86",
  [0xe915] = "\xce\x87", [0xe916] = "\xce\x88", [0xe917] = "\xce\x89",
  [0xe918] = "\xce\x8a", [0xe919] = "\xce\x8b", [0xe91a] = "\xce\x8c",
  [0xe91b] = "\xce\x8d", [0xe91c] = "\xce\x8e", [0xe91d] = "\xce\x8f",
  [0xe91e] = "\xce\x90", [0xe91f] = "\xce\x91", [0xe920] = "\xce\x92",
  [0xe921] = "\xce\x93", [0xe922] = "\xce\x94", [0xe923] = "\xce\x95",
  [0xe924] = "\xce\x96", [0xe925] = "\xce\x97", [0xe926] = "\xce\x98",
  [0xe927] = "\xce\x99", [0xe928] = "\xce\x9a", [0xe929] = "\xce\x9b",
  [0xe92a] = "\xce\x9c", [0xe92b] = "\xce\x9d", [0xe92c] = "\xce\x9e",
  [0xe92d] = "\xce\x9f", [0xe92e] = "\xce\xa0", [0xe92f] = "\xce\xa1",
  [0xe930] = "\xce\xa2", [0xe931] = "\xce\xa3", [0xe932] = "\xce\xa4",
  [0xe933] = "\xce\xa5", [0xe934] = "\xce\xa6", [0xe935] = "\xce\xa7",
  [0xe936] = "\xce\xa8", [0xe937] = "\xce\xa9", [0xe938] = "\xce\xaa",
  [0xe939] = "\xce\xab", [0xe93a] = "\xce\xac", [0xe93b] = "\xce\xad",
  [0xe93c] = "\xce\xae", [0xe93d] = "\xce\xaf", [0xe93e] = "\xce\xb0",
  [0xe93f] = "\xce\xb1", [0xe940] = "\xce\xb2", [0xe941] = "\xce\xb3",
  [0xe942] = "\xce\xb4", [0xe943] = "\xce\xb5", [0xe944] = "\xce\xb6",
  [0xe945] = "\xce\xb7", [0xe946] = "\xce\xb8", [0xe947] = "\xce\xb9",
  [0xe948] = "\xce\xba", [0xe949] = "\xce\xbb", [0xe94a] = "\xce\xbc",
  [0xe94b] = "\xce\xbd", [0xe94c] = "\xce\xbe", [0xe94d] = "\xce\xbf",
  [0xe94e] = "\xce\xc0", [0xe94f] = "\xce\xc1", [0xe950] = "\xce\xc2",
  [0xe951] = "\xce\xc3", [0xe952] = "\xce\xc4", [0xe953] = "\xce\xc5",
  [0xe954] = "\xce\xc6", [0xe955] = "\xce\xc7", [0xe956] = "\xce\xc8",
  [0xe957] = "\xce\xc9", [0xe958] = "\xce\xca", [0xe959] = "\xce\xcb",
  [0xe95a] = "\xce\xcc", [0xe95b] = "\xce\xcd", [0xe95c] = "\xce\xce",
  [0xe95d] = "\xce\xcf", [0xe95e] = "\xce\xd0", [0xe95f] = "\xce\xd1",
  [0xe960] = "\xce\xd2", [0xe961] = "\xce\xd3", [0xe962] = "\xce\xd4",
  [0xe963] = "\xce\xd5", [0xe964] = "\xce\xd6", [0xe965] = "\xce\xd7",
  [0xe966] = "\xce\xd8", [0xe967] = "\xce\xd9", [0xe968] = "\xce\xda",
  [0xe969] = "\xce\xdb", [0xe96a] = "\xce\xdc", [0xe96b] = "\xce\xdd",
  [0xe96c] = "\xce\xde", [0xe96d] = "\xce\xdf", [0xe96e] = "\xce\xe0",
  [0xe96f] = "\xce\xe1", [0xe970] = "\xce\xe2", [0xe971] = "\xce\xe3",
  [0xe972] = "\xce\xe4", [0xe973] = "\xce\xe5", [0xe974] = "\xce\xe6",
  [0xe975] = "\xce\xe7", [0xe976] = "\xce\xe8", [0xe977] = "\xce\xe9",
  [0xe978] = "\xce\xea", [0xe979] = "\xce\xeb", [0xe97a] = "\xce\xec",
  [0xe97b] = "\xce\xed", [0xe97c] = "\xce\xee", [0xe97d] = "\xce\xef",
  [0xe97e] = "\xce\xf0", [0xe97f] = "\xce\xf1", [0xe980] = "\xce\xf2",
  [0xe981] = "\xce\xf3", [0xe982] = "\xce\xf4", [0xe983] = "\xce\xf5",
  [0xe984] = "\xce\xf6", [0xe985] = "\xce\xf7", [0xe986] = "\xce\xf8",
  [0xe987] = "\xce\xf9", [0xe988] = "\xce\xfa", [0xe989] = "\xce\xfb",
  [0xe98a] = "\xce\xfc", [0xe98b] = "\xce\xfd", [0xe98c] = "\xcf\x41",
  [0xe98d] = "\xcf\x42", [0xe98e] = "\xcf\x43", [0xe98f] = "\xcf\x44",
  [0xe990] = "\xcf\x45", [0xe991] = "\xcf\x46", [0xe992] = "\xcf\x47",
  [0xe993] = "\xcf\x48", [0xe994] = "\xcf\x49", [0xe995] = "\xcf\x4a",
  [0xe996] = "\xcf\x4b", [0xe997] = "\xcf\x4c", [0xe998] = "\xcf\x4d",
  [0xe999] = "\xcf\x4e", [0xe99a] = "\xcf\x4f", [0xe99b] = "\xcf\x50",
  [0xe99c] = "\xcf\x51", [0xe99d] = "\xcf\x52", [0xe99e] = "\xcf\x53",
  [0xe99f] = "\xcf\x54", [0xe9a0] = "\xcf\x55", [0xe9a1] = "\xcf\x56",
  [0xe9a2] = "\xcf\x57", [0xe9a3] = "\xcf\x58", [0xe9a4] = "\xcf\x59",
  [0xe9a5] = "\xcf\x5a", [0xe9a6] = "\xcf\x5b", [0xe9a7] = "\xcf\x5c",
  [0xe9a8] = "\xcf\x5d", [0xe9a9] = "\xcf\x5e", [0xe9aa] = "\xcf\x5f",
  [0xe9ab] = "\xcf\x60", [0xe9ac] = "\xcf\x61", [0xe9ad] = "\xcf\x62",
  [0xe9ae] = "\xcf\x63", [0xe9af] = "\xcf\x64", [0xe9b0] = "\xcf\x65",
  [0xe9b1] = "\xcf\x66", [0xe9b2] = "\xcf\x67", [0xe9b3] = "\xcf\x68",
  [0xe9b4] = "\xcf\x69", [0xe9b5] = "\xcf\x6a", [0xe9b6] = "\xcf\x6b",
  [0xe9b7] = "\xcf\x6c", [0xe9b8] = "\xcf\x6d", [0xe9b9] = "\xcf\x6e",
  [0xe9ba] = "\xcf\x6f", [0xe9bb] = "\xcf\x70", [0xe9bc] = "\xcf\x71",
  [0xe9bd] = "\xcf\x72", [0xe9be] = "\xcf\x73", [0xe9bf] = "\xcf\x74",
  [0xe9c0] = "\xcf\x75", [0xe9c1] = "\xcf\x76", [0xe9c2] = "\xcf\x77",
  [0xe9c3] = "\xcf\x78", [0xe9c4] = "\xcf\x79", [0xe9c5] = "\xcf\x7a",
  [0xe9c6] = "\xcf\x7b", [0xe9c7] = "\xcf\x7c", [0xe9c8] = "\xcf\x7d",
  [0xe9c9] = "\xcf\x7e", [0xe9ca] = "\xcf\x7f", [0xe9cb] = "\xcf\x81",
  [0xe9cc] = "\xcf\x82", [0xe9cd] = "\xcf\x83", [0xe9ce] = "\xcf\x84",
  [0xe9cf] = "\xcf\x85", [0xe9d0] = "\xcf\x86", [0xe9d1] = "\xcf\x87",
  [0xe9d2] = "\xcf\x88", [0xe9d3] = "\xcf\x89", [0xe9d4] = "\xcf\x8a",
  [0xe9d5] = "\xcf\x8b", [0xe9d6] = "\xcf\x8c", [0xe9d7] = "\xcf\x8d",
  [0xe9d8] = "\xcf\x8e", [0xe9d9] = "\xcf\x8f", [0xe9da] = "\xcf\x90",
  [0xe9db] = "\xcf\x91", [0xe9dc] = "\xcf\x92", [0xe9dd] = "\xcf\x93",
  [0xe9de] = "\xcf\x94", [0xe9df] = "\xcf\x95", [0xe9e0] = "\xcf\x96",
  [0xe9e1] = "\xcf\x97", [0xe9e2] = "\xcf\x98", [0xe9e3] = "\xcf\x99",
  [0xe9e4] = "\xcf\x9a", [0xe9e5] = "\xcf\x9b", [0xe9e6] = "\xcf\x9c",
  [0xe9e7] = "\xcf\x9d", [0xe9e8] = "\xcf\x9e", [0xe9e9] = "\xcf\x9f",
  [0xe9ea] = "\xcf\xa0", [0xe9eb] = "\xcf\xa1", [0xe9ec] = "\xcf\xa2",
  [0xe9ed] = "\xcf\xa3", [0xe9ee] = "\xcf\xa4", [0xe9ef] = "\xcf\xa5",
  [0xe9f0] = "\xcf\xa6", [0xe9f1] = "\xcf\xa7", [0xe9f2] = "\xcf\xa8",
  [0xe9f3] = "\xcf\xa9", [0xe9f4] = "\xcf\xaa", [0xe9f5] = "\xcf\xab",
  [0xe9f6] = "\xcf\xac", [0xe9f7] = "\xcf\xad", [0xe9f8] = "\xcf\xae",
  [0xe9f9] = "\xcf\xaf", [0xe9fa] = "\xcf\xb0", [0xe9fb] = "\xcf\xb1",
  [0xe9fc] = "\xcf\xb2", [0xe9fd] = "\xcf\xb3", [0xe9fe] = "\xcf\xb4",
  [0xe9ff] = "\xcf\xb5", [0xea00] = "\xcf\xb6", [0xea01] = "\xcf\xb7",
  [0xea02] = "\xcf\xb8", [0xea03] = "\xcf\xb9", [0xea04] = "\xcf\xba",
  [0xea05] = "\xcf\xbb", [0xea06] = "\xcf\xbc", [0xea07] = "\xcf\xbd",
  [0xea08] = "\xcf\xbe", [0xea09] = "\xcf\xbf", [0xea0a] = "\xcf\xc0",
  [0xea0b] = "\xcf\xc1", [0xea0c] = "\xcf\xc2", [0xea0d] = "\xcf\xc3",
  [0xea0e] = "\xcf\xc4", [0xea0f] = "\xcf\xc5", [0xea10] = "\xcf\xc6",
  [0xea11] = "\xcf\xc7", [0xea12] = "\xcf\xc8", [0xea13] = "\xcf\xc9",
  [0xea14] = "\xcf\xca", [0xea15] = "\xcf\xcb", [0xea16] = "\xcf\xcc",
  [0xea17] = "\xcf\xcd", [0xea18] = "\xcf\xce", [0xea19] = "\xcf\xcf",
  [0xea1a] = "\xcf\xd0", [0xea1b] = "\xcf\xd1", [0xea1c] = "\xcf\xd2",
  [0xea1d] = "\xcf\xd3", [0xea1e] = "\xcf\xd4", [0xea1f] = "\xcf\xd5",
  [0xea20] = "\xcf\xd6", [0xea21] = "\xcf\xd7", [0xea22] = "\xcf\xd8",
  [0xea23] = "\xcf\xd9", [0xea24] = "\xcf\xda", [0xea25] = "\xcf\xdb",
  [0xea26] = "\xcf\xdc", [0xea27] = "\xcf\xdd", [0xea28] = "\xcf\xde",
  [0xea29] = "\xcf\xdf", [0xea2a] = "\xcf\xe0", [0xea2b] = "\xcf\xe1",
  [0xea2c] = "\xcf\xe2", [0xea2d] = "\xcf\xe3", [0xea2e] = "\xcf\xe4",
  [0xea2f] = "\xcf\xe5", [0xea30] = "\xcf\xe6", [0xea31] = "\xcf\xe7",
  [0xea32] = "\xcf\xe8", [0xea33] = "\xcf\xe9", [0xea34] = "\xcf\xea",
  [0xea35] = "\xcf\xeb", [0xea36] = "\xcf\xec", [0xea37] = "\xcf\xed",
  [0xea38] = "\xcf\xee", [0xea39] = "\xcf\xef", [0xea3a] = "\xcf\xf0",
  [0xea3b] = "\xcf\xf1", [0xea3c] = "\xcf\xf2", [0xea3d] = "\xcf\xf3",
  [0xea3e] = "\xcf\xf4", [0xea3f] = "\xcf\xf5", [0xea40] = "\xcf\xf6",
  [0xea41] = "\xcf\xf7", [0xea42] = "\xcf\xf8", [0xea43] = "\xcf\xf9",
  [0xea44] = "\xcf\xfa", [0xea45] = "\xcf\xfb", [0xea46] = "\xcf\xfc",
  [0xea47] = "\xcf\xfd", [0xea48] = "\xd0\x41", [0xea49] = "\xd0\x42",
  [0xea4a] = "\xd0\x43", [0xea4b] = "\xd0\x44", [0xea4c] = "\xd0\x45",
  [0xea4d] = "\xd0\x46", [0xea4e] = "\xd0\x47", [0xea4f] = "\xd0\x48",
  [0xea50] = "\xd0\x49", [0xea51] = "\xd0\x4a", [0xea52] = "\xd0\x4b",
  [0xea53] = "\xd0\x4c", [0xea54] = "\xd0\x4d", [0xea55] = "\xd0\x4e",
  [0xea56] = "\xd0\x4f", [0xea57] = "\xd0\x50", [0xea58] = "\xd0\x51",
  [0xea59] = "\xd0\x52", [0xea5a] = "\xd0\x53", [0xea5b] = "\xd0\x54",
  [0xea5c] = "\xd0\x55", [0xea5d] = "\xd0\x56", [0xea5e] = "\xd0\x57",
  [0xea5f] = "\xd0\x58", [0xea60] = "\xd0\x59", [0xea61] = "\xd0\x5a",
  [0xea62] = "\xd0\x5b", [0xea63] = "\xd0\x5c", [0xea64] = "\xd0\x5d",
  [0xea65] = "\xd0\x5e", [0xea66] = "\xd0\x5f", [0xea67] = "\xd0\x60",
  [0xea68] = "\xd0\x61", [0xea69] = "\xd0\x62", [0xea6a] = "\xd0\x63",
  [0xea6b] = "\xd0\x64", [0xea6c] = "\xd0\x65", [0xea6d] = "\xd0\x66",
  [0xea6e] = "\xd0\x67", [0xea6f] = "\xd0\x68", [0xea70] = "\xd0\x69",
  [0xea71] = "\xd0\x6a", [0xea72] = "\xd0\x6b", [0xea73] = "\xd0\x6c",
  [0xea74] = "\xd0\x6d", [0xea75] = "\xd0\x6e", [0xea76] = "\xd0\x6f",
  [0xea77] = "\xd0\x70", [0xea78] = "\xd0\x71", [0xea79] = "\xd0\x72",
  [0xea7a] = "\xd0\x73", [0xea7b] = "\xd0\x74", [0xea7c] = "\xd0\x75",
  [0xea7d] = "\xd0\x76", [0xea7e] = "\xd0\x77", [0xea7f] = "\xd0\x78",
  [0xea80] = "\xd0\x79", [0xea81] = "\xd0\x7a", [0xea82] = "\xd0\x7b",
  [0xea83] = "\xd0\x7c", [0xea84] = "\xd0\x7d", [0xea85] = "\xd0\x7e",
  [0xea86] = "\xd0\x7f", [0xea87] = "\xd0\x81", [0xea88] = "\xd0\x82",
  [0xea89] = "\xd0\x83", [0xea8a] = "\xd0\x84", [0xea8b] = "\xd0\x85",
  [0xea8c] = "\xd0\x86", [0xea8d] = "\xd0\x87", [0xea8e] = "\xd0\x88",
  [0xea8f] = "\xd0\x89", [0xea90] = "\xd0\x8a", [0xea91] = "\xd0\x8b",
  [0xea92] = "\xd0\x8c", [0xea93] = "\xd0\x8d", [0xea94] = "\xd0\x8e",
  [0xea95] = "\xd0\x8f", [0xea96] = "\xd0\x90", [0xea97] = "\xd0\x91",
  [0xea98] = "\xd0\x92", [0xea99] = "\xd0\x93", [0xea9a] = "\xd0\x94",
  [0xea9b] = "\xd0\x95", [0xea9c] = "\xd0\x96", [0xea9d] = "\xd0\x97",
  [0xea9e] = "\xd0\x98", [0xea9f] = "\xd0\x99", [0xeaa0] = "\xd0\x9a",
  [0xeaa1] = "\xd0\x9b", [0xeaa2] = "\xd0\x9c", [0xeaa3] = "\xd0\x9d",
  [0xeaa4] = "\xd0\x9e", [0xeaa5] = "\xd0\x9f", [0xeaa6] = "\xd0\xa0",
  [0xeaa7] = "\xd0\xa1", [0xeaa8] = "\xd0\xa2", [0xeaa9] = "\xd0\xa3",
  [0xeaaa] = "\xd0\xa4", [0xeaab] = "\xd0\xa5", [0xeaac] = "\xd0\xa6",
  [0xeaad] = "\xd0\xa7", [0xeaae] = "\xd0\xa8", [0xeaaf] = "\xd0\xa9",
  [0xeab0] = "\xd0\xaa", [0xeab1] = "\xd0\xab", [0xeab2] = "\xd0\xac",
  [0xeab3] = "\xd0\xad", [0xeab4] = "\xd0\xae", [0xeab5] = "\xd0\xaf",
  [0xeab6] = "\xd0\xb0", [0xeab7] = "\xd0\xb1", [0xeab8] = "\xd0\xb2",
  [0xeab9] = "\xd0\xb3", [0xeaba] = "\xd0\xb4", [0xeabb] = "\xd0\xb5",
  [0xeabc] = "\xd0\xb6", [0xeabd] = "\xd0\xb7", [0xeabe] = "\xd0\xb8",
  [0xeabf] = "\xd0\xb9", [0xeac0] = "\xd0\xba", [0xeac1] = "\xd0\xbb",
  [0xeac2] = "\xd0\xbc", [0xeac3] = "\xd0\xbd", [0xeac4] = "\xd0\xbe",
  [0xeac5] = "\xd0\xbf", [0xeac6] = "\xd0\xc0", [0xeac7] = "\xd0\xc1",
  [0xeac8] = "\xd0\xc2", [0xeac9] = "\xd0\xc3", [0xeaca] = "\xd0\xc4",
  [0xeacb] = "\xd0\xc5", [0xeacc] = "\xd0\xc6", [0xeacd] = "\xd0\xc7",
  [0xeace] = "\xd0\xc8", [0xeacf] = "\xd0\xc9", [0xead0] = "\xd0\xca",
  [0xead1] = "\xd0\xcb", [0xead2] = "\xd0\xcc", [0xead3] = "\xd0\xcd",
  [0xead4] = "\xd0\xce", [0xead5] = "\xd0\xcf", [0xead6] = "\xd0\xd0",
  [0xead7] = "\xd0\xd1", [0xead8] = "\xd0\xd2", [0xead9] = "\xd0\xd3",
  [0xeada] = "\xd0\xd4", [0xeadb] = "\xd0\xd5", [0xeadc] = "\xd0\xd6",
  [0xeadd] = "\xd0\xd7", [0xeade] = "\xd0\xd8", [0xeadf] = "\xd0\xd9",
  [0xeae0] = "\xd0\xda", [0xeae1] = "\xd0\xdb", [0xeae2] = "\xd0\xdc",
  [0xeae3] = "\xd0\xdd", [0xeae4] = "\xd0\xde", [0xeae5] = "\xd0\xdf",
  [0xeae6] = "\xd0\xe0", [0xeae7] = "\xd0\xe1", [0xeae8] = "\xd0\xe2",
  [0xeae9] = "\xd0\xe3", [0xeaea] = "\xd0\xe4", [0xeaeb] = "\xd0\xe5",
  [0xeaec] = "\xd0\xe6", [0xeaed] = "\xd0\xe7", [0xeaee] = "\xd0\xe8",
  [0xeaef] = "\xd0\xe9", [0xeaf0] = "\xd0\xea", [0xeaf1] = "\xd0\xeb",
  [0xeaf2] = "\xd0\xec", [0xeaf3] = "\xd0\xed", [0xeaf4] = "\xd0\xee",
  [0xeaf5] = "\xd0\xef", [0xeaf6] = "\xd0\xf0", [0xeaf7] = "\xd0\xf1",
  [0xeaf8] = "\xd0\xf2", [0xeaf9] = "\xd0\xf3", [0xeafa] = "\xd0\xf4",
  [0xeafb] = "\xd0\xf5", [0xeafc] = "\xd0\xf6", [0xeafd] = "\xd0\xf7",
  [0xeafe] = "\xd0\xf8", [0xeaff] = "\xd0\xf9", [0xeb00] = "\xd0\xfa",
  [0xeb01] = "\xd0\xfb", [0xeb02] = "\xd0\xfc", [0xeb03] = "\xd0\xfd",
  [0xeb04] = "\xd1\x41", [0xeb05] = "\xd1\x42", [0xeb06] = "\xd1\x43",
  [0xeb07] = "\xd1\x44", [0xeb08] = "\xd1\x45", [0xeb09] = "\xd1\x46",
  [0xeb0a] = "\xd1\x47", [0xeb0b] = "\xd1\x48", [0xeb0c] = "\xd1\x49",
  [0xeb0d] = "\xd1\x4a", [0xeb0e] = "\xd1\x4b", [0xeb0f] = "\xd1\x4c",
  [0xeb10] = "\xd1\x4d", [0xeb11] = "\xd1\x4e", [0xeb12] = "\xd1\x4f",
  [0xeb13] = "\xd1\x50", [0xeb14] = "\xd1\x51", [0xeb15] = "\xd1\x52",
  [0xeb16] = "\xd1\x53", [0xeb17] = "\xd1\x54", [0xeb18] = "\xd1\x55",
  [0xeb19] = "\xd1\x56", [0xeb1a] = "\xd1\x57", [0xeb1b] = "\xd1\x58",
  [0xeb1c] = "\xd1\x59", [0xeb1d] = "\xd1\x5a", [0xeb1e] = "\xd1\x5b",
  [0xeb1f] = "\xd1\x5c", [0xeb20] = "\xd1\x5d", [0xeb21] = "\xd1\x5e",
  [0xeb22] = "\xd1\x5f", [0xeb23] = "\xd1\x60", [0xeb24] = "\xd1\x61",
  [0xeb25] = "\xd1\x62", [0xeb26] = "\xd1\x63", [0xeb27] = "\xd1\x64",
  [0xeb28] = "\xd1\x65", [0xeb29] = "\xd1\x66", [0xeb2a] = "\xd1\x67",
  [0xeb2b] = "\xd1\x68", [0xeb2c] = "\xd1\x69", [0xeb2d] = "\xd1\x6a",
  [0xeb2e] = "\xd1\x6b", [0xeb2f] = "\xd1\x6c", [0xeb30] = "\xd1\x6d",
  [0xeb31] = "\xd1\x6e", [0xeb32] = "\xd1\x6f", [0xeb33] = "\xd1\x70",
  [0xeb34] = "\xd1\x71", [0xeb35] = "\xd1\x72", [0xeb36] = "\xd1\x73",
  [0xeb37] = "\xd1\x74", [0xeb38] = "\xd1\x75", [0xeb39] = "\xd1\x76",
  [0xeb3a] = "\xd1\x77", [0xeb3b] = "\xd1\x78", [0xeb3c] = "\xd1\x79",
  [0xeb3d] = "\xd1\x7a", [0xeb3e] = "\xd1\x7b", [0xeb3f] = "\xd1\x7c",
  [0xeb40] = "\xd1\x7d", [0xeb41] = "\xd1\x7e", [0xeb42] = "\xd1\x7f",
  [0xeb43] = "\xd1\x81", [0xeb44] = "\xd1\x82", [0xeb45] = "\xd1\x83",
  [0xeb46] = "\xd1\x84", [0xeb47] = "\xd1\x85", [0xeb48] = "\xd1\x86",
  [0xeb49] = "\xd1\x87", [0xeb4a] = "\xd1\x88", [0xeb4b] = "\xd1\x89",
  [0xeb4c] = "\xd1\x8a", [0xeb4d] = "\xd1\x8b", [0xeb4e] = "\xd1\x8c",
  [0xeb4f] = "\xd1\x8d", [0xeb50] = "\xd1\x8e", [0xeb51] = "\xd1\x8f",
  [0xeb52] = "\xd1\x90", [0xeb53] = "\xd1\x91", [0xeb54] = "\xd1\x92",
  [0xeb55] = "\xd1\x93", [0xeb56] = "\xd1\x94", [0xeb57] = "\xd1\x95",
  [0xeb58] = "\xd1\x96", [0xeb59] = "\xd1\x97", [0xeb5a] = "\xd1\x98",
  [0xeb5b] = "\xd1\x99", [0xeb5c] = "\xd1\x9a", [0xeb5d] = "\xd1\x9b",
  [0xeb5e] = "\xd1\x9c", [0xeb5f] = "\xd1\x9d", [0xeb60] = "\xd1\x9e",
  [0xeb61] = "\xd1\x9f", [0xeb62] = "\xd1\xa0", [0xeb63] = "\xd1\xa1",
  [0xeb64] = "\xd1\xa2", [0xeb65] = "\xd1\xa3", [0xeb66] = "\xd1\xa4",
  [0xeb67] = "\xd1\xa5", [0xeb68] = "\xd1\xa6", [0xeb69] = "\xd1\xa7",
  [0xeb6a] = "\xd1\xa8", [0xeb6b] = "\xd1\xa9", [0xeb6c] = "\xd1\xaa",
  [0xeb6d] = "\xd1\xab", [0xeb6e] = "\xd1\xac", [0xeb6f] = "\xd1\xad",
  [0xeb70] = "\xd1\xae", [0xeb71] = "\xd1\xaf", [0xeb72] = "\xd1\xb0",
  [0xeb73] = "\xd1\xb1", [0xeb74] = "\xd1\xb2", [0xeb75] = "\xd1\xb3",
  [0xeb76] = "\xd1\xb4", [0xeb77] = "\xd1\xb5", [0xeb78] = "\xd1\xb6",
  [0xeb79] = "\xd1\xb7", [0xeb7a] = "\xd1\xb8", [0xeb7b] = "\xd1\xb9",
  [0xeb7c] = "\xd1\xba", [0xeb7d] = "\xd1\xbb", [0xeb7e] = "\xd1\xbc",
  [0xeb7f] = "\xd1\xbd", [0xeb80] = "\xd1\xbe", [0xeb81] = "\xd1\xbf",
  [0xeb82] = "\xd1\xc0", [0xeb83] = "\xd1\xc1", [0xeb84] = "\xd1\xc2",
  [0xeb85] = "\xd1\xc3", [0xeb86] = "\xd1\xc4", [0xeb87] = "\xd1\xc5",
  [0xeb88] = "\xd1\xc6", [0xeb89] = "\xd1\xc7", [0xeb8a] = "\xd1\xc8",
  [0xeb8b] = "\xd1\xc9", [0xeb8c] = "\xd1\xca", [0xeb8d] = "\xd1\xcb",
  [0xeb8e] = "\xd1\xcc", [0xeb8f] = "\xd1\xcd", [0xeb90] = "\xd1\xce",
  [0xeb91] = "\xd1\xcf", [0xeb92] = "\xd1\xd0", [0xeb93] = "\xd1\xd1",
  [0xeb94] = "\xd1\xd2", [0xeb95] = "\xd1\xd3", [0xeb96] = "\xd1\xd4",
  [0xeb97] = "\xd1\xd5", [0xeb98] = "\xd1\xd6", [0xeb99] = "\xd1\xd7",
  [0xeb9a] = "\xd1\xd8", [0xeb9b] = "\xd1\xd9", [0xeb9c] = "\xd1\xda",
  [0xeb9d] = "\xd1\xdb", [0xeb9e] = "\xd1\xdc", [0xeb9f] = "\xd1\xdd",
  [0xeba0] = "\xd1\xde", [0xeba1] = "\xd1\xdf", [0xeba2] = "\xd1\xe0",
  [0xeba3] = "\xd1\xe1", [0xeba4] = "\xd1\xe2", [0xeba5] = "\xd1\xe3",
  [0xeba6] = "\xd1\xe4", [0xeba7] = "\xd1\xe5", [0xeba8] = "\xd1\xe6",
  [0xeba9] = "\xd1\xe7", [0xebaa] = "\xd1\xe8", [0xebab] = "\xd1\xe9",
  [0xebac] = "\xd1\xea", [0xebad] = "\xd1\xeb", [0xebae] = "\xd1\xec",
  [0xebaf] = "\xd1\xed", [0xebb0] = "\xd1\xee", [0xebb1] = "\xd1\xef",
  [0xebb2] = "\xd1\xf0", [0xebb3] = "\xd1\xf1", [0xebb4] = "\xd1\xf2",
  [0xebb5] = "\xd1\xf3", [0xebb6] = "\xd1\xf4", [0xebb7] = "\xd1\xf5",
  [0xebb8] = "\xd1\xf6", [0xebb9] = "\xd1\xf7", [0xebba] = "\xd1\xf8",
  [0xebbb] = "\xd1\xf9", [0xebbc] = "\xd1\xfa", [0xebbd] = "\xd1\xfb",
  [0xebbe] = "\xd1\xfc", [0xebbf] = "\xd1\xfd", [0xebc0] = "\xd2\x41",
  [0xebc1] = "\xd2\x42", [0xebc2] = "\xd2\x43", [0xebc3] = "\xd2\x44",
  [0xebc4] = "\xd2\x45", [0xebc5] = "\xd2\x46", [0xebc6] = "\xd2\x47",
  [0xebc7] = "\xd2\x48", [0xebc8] = "\xd2\x49", [0xebc9] = "\xd2\x4a",
  [0xebca] = "\xd2\x4b", [0xebcb] = "\xd2\x4c", [0xebcc] = "\xd2\x4d",
  [0xebcd] = "\xd2\x4e", [0xebce] = "\xd2\x4f", [0xebcf] = "\xd2\x50",
  [0xebd0] = "\xd2\x51", [0xebd1] = "\xd2\x52", [0xebd2] = "\xd2\x53",
  [0xebd3] = "\xd2\x54", [0xebd4] = "\xd2\x55", [0xebd5] = "\xd2\x56",
  [0xebd6] = "\xd2\x57", [0xebd7] = "\xd2\x58", [0xebd8] = "\xd2\x59",
  [0xebd9] = "\xd2\x5a", [0xebda] = "\xd2\x5b", [0xebdb] = "\xd2\x5c",
  [0xebdc] = "\xd2\x5d", [0xebdd] = "\xd2\x5e", [0xebde] = "\xd2\x5f",
  [0xebdf] = "\xd2\x60", [0xebe0] = "\xd2\x61", [0xebe1] = "\xd2\x62",
  [0xebe2] = "\xd2\x63", [0xebe3] = "\xd2\x64", [0xebe4] = "\xd2\x65",
  [0xebe5] = "\xd2\x66", [0xebe6] = "\xd2\x67", [0xebe7] = "\xd2\x68",
  [0xebe8] = "\xd2\x69", [0xebe9] = "\xd2\x6a", [0xebea] = "\xd2\x6b",
  [0xebeb] = "\xd2\x6c", [0xebec] = "\xd2\x6d", [0xebed] = "\xd2\x6e",
  [0xebee] = "\xd2\x6f", [0xebef] = "\xd2\x70", [0xebf0] = "\xd2\x71",
  [0xebf1] = "\xd2\x72", [0xebf2] = "\xd2\x73", [0xebf3] = "\xd2\x74",
  [0xebf4] = "\xd2\x75", [0xebf5] = "\xd2\x76", [0xebf6] = "\xd2\x77",
  [0xebf7] = "\xd2\x78", [0xebf8] = "\xd2\x79", [0xebf9] = "\xd2\x7a",
  [0xebfa] = "\xd2\x7b", [0xebfb] = "\xd2\x7c", [0xebfc] = "\xd2\x7d",
  [0xebfd] = "\xd2\x7e", [0xebfe] = "\xd2\x7f", [0xebff] = "\xd2\x81",
  [0xec00] = "\xd2\x82", [0xec01] = "\xd2\x83", [0xec02] = "\xd2\x84",
  [0xec03] = "\xd2\x85", [0xec04] = "\xd2\x86", [0xec05] = "\xd2\x87",
  [0xec06] = "\xd2\x88", [0xec07] = "\xd2\x89", [0xec08] = "\xd2\x8a",
  [0xec09] = "\xd2\x8b", [0xec0a] = "\xd2\x8c", [0xec0b] = "\xd2\x8d",
  [0xec0c] = "\xd2\x8e", [0xec0d] = "\xd2\x8f", [0xec0e] = "\xd2\x90",
  [0xec0f] = "\xd2\x91", [0xec10] = "\xd2\x92", [0xec11] = "\xd2\x93",
  [0xec12] = "\xd2\x94", [0xec13] = "\xd2\x95", [0xec14] = "\xd2\x96",
  [0xec15] = "\xd2\x97", [0xec16] = "\xd2\x98", [0xec17] = "\xd2\x99",
  [0xec18] = "\xd2\x9a", [0xec19] = "\xd2\x9b", [0xec1a] = "\xd2\x9c",
  [0xec1b] = "\xd2\x9d", [0xec1c] = "\xd2\x9e", [0xec1d] = "\xd2\x9f",
  [0xec1e] = "\xd2\xa0", [0xec1f] = "\xd2\xa1", [0xec20] = "\xd2\xa2",
  [0xec21] = "\xd2\xa3", [0xec22] = "\xd2\xa4", [0xec23] = "\xd2\xa5",
  [0xec24] = "\xd2\xa6", [0xec25] = "\xd2\xa7", [0xec26] = "\xd2\xa8",
  [0xec27] = "\xd2\xa9", [0xec28] = "\xd2\xaa", [0xec29] = "\xd2\xab",
  [0xec2a] = "\xd2\xac", [0xec2b] = "\xd2\xad", [0xec2c] = "\xd2\xae",
  [0xec2d] = "\xd2\xaf", [0xec2e] = "\xd2\xb0", [0xec2f] = "\xd2\xb1",
  [0xec30] = "\xd2\xb2", [0xec31] = "\xd2\xb3", [0xec32] = "\xd2\xb4",
  [0xec33] = "\xd2\xb5", [0xec34] = "\xd2\xb6", [0xec35] = "\xd2\xb7",
  [0xec36] = "\xd2\xb8", [0xec37] = "\xd2\xb9", [0xec38] = "\xd2\xba",
  [0xec39] = "\xd2\xbb", [0xec3a] = "\xd2\xbc", [0xec3b] = "\xd2\xbd",
  [0xec3c] = "\xd2\xbe", [0xec3d] = "\xd2\xbf", [0xec3e] = "\xd2\xc0",
  [0xec3f] = "\xd2\xc1", [0xec40] = "\xd2\xc2", [0xec41] = "\xd2\xc3",
  [0xec42] = "\xd2\xc4", [0xec43] = "\xd2\xc5", [0xec44] = "\xd2\xc6",
  [0xec45] = "\xd2\xc7", [0xec46] = "\xd2\xc8", [0xec47] = "\xd2\xc9",
  [0xec48] = "\xd2\xca", [0xec49] = "\xd2\xcb", [0xec4a] = "\xd2\xcc",
  [0xec4b] = "\xd2\xcd", [0xec4c] = "\xd2\xce", [0xec4d] = "\xd2\xcf",
  [0xec4e] = "\xd2\xd0", [0xec4f] = "\xd2\xd1", [0xec50] = "\xd2\xd2",
  [0xec51] = "\xd2\xd3", [0xec52] = "\xd2\xd4", [0xec53] = "\xd2\xd5",
  [0xec54] = "\xd2\xd6", [0xec55] = "\xd2\xd7", [0xec56] = "\xd2\xd8",
  [0xec57] = "\xd2\xd9", [0xec58] = "\xd2\xda", [0xec59] = "\xd2\xdb",
  [0xec5a] = "\xd2\xdc", [0xec5b] = "\xd2\xdd", [0xec5c] = "\xd2\xde",
  [0xec5d] = "\xd2\xdf", [0xec5e] = "\xd2\xe0", [0xec5f] = "\xd2\xe1",
  [0xec60] = "\xd2\xe2", [0xec61] = "\xd2\xe3", [0xec62] = "\xd2\xe4",
  [0xec63] = "\xd2\xe5", [0xec64] = "\xd2\xe6", [0xec65] = "\xd2\xe7",
  [0xec66] = "\xd2\xe8", [0xec67] = "\xd2\xe9", [0xec68] = "\xd2\xea",
  [0xec69] = "\xd2\xeb", [0xec6a] = "\xd2\xec", [0xec6b] = "\xd2\xed",
  [0xec6c] = "\xd2\xee", [0xec6d] = "\xd2\xef", [0xec6e] = "\xd2\xf0",
  [0xec6f] = "\xd2\xf1", [0xec70] = "\xd2\xf2", [0xec71] = "\xd2\xf3",
  [0xec72] = "\xd2\xf4", [0xec73] = "\xd2\xf5", [0xec74] = "\xd2\xf6",
  [0xec75] = "\xd2\xf7", [0xec76] = "\xd2\xf8", [0xec77] = "\xd2\xf9",
  [0xec78] = "\xd2\xfa", [0xec79] = "\xd2\xfb", [0xec7a] = "\xd2\xfc",
  [0xec7b] = "\xd2\xfd", [0xec7c] = "\xd3\x41", [0xec7d] = "\xd3\x42",
  [0xec7e] = "\xd3\x43", [0xec7f] = "\xd3\x44", [0xec80] = "\xd3\x45",
  [0xec81] = "\xd3\x46", [0xec82] = "\xd3\x47", [0xec83] = "\xd3\x48",
  [0xec84] = "\xd3\x49", [0xec85] = "\xd3\x4a", [0xec86] = "\xd3\x4b",
  [0xec87] = "\xd3\x4c", [0xec88] = "\xd3\x4d", [0xec89] = "\xd3\x4e",
  [0xec8a] = "\xd3\x4f", [0xec8b] = "\xd3\x50", [0xec8c] = "\xd3\x51",
  [0xec8d] = "\xd3\x52", [0xec8e] = "\xd3\x53", [0xec8f] = "\xd3\x54",
  [0xec90] = "\xd3\x55", [0xec91] = "\xd3\x56", [0xec92] = "\xd3\x57",
  [0xec93] = "\xd3\x58", [0xec94] = "\xd3\x59", [0xec95] = "\xd3\x5a",
  [0xec96] = "\xd3\x5b", [0xec97] = "\xd3\x5c", [0xec98] = "\xd3\x5d",
  [0xec99] = "\xd3\x5e", [0xec9a] = "\xd3\x5f", [0xec9b] = "\xd3\x60",
  [0xec9c] = "\xd3\x61", [0xec9d] = "\xd3\x62", [0xec9e] = "\xd3\x63",
  [0xec9f] = "\xd3\x64", [0xeca0] = "\xd3\x65", [0xeca1] = "\xd3\x66",
  [0xeca2] = "\xd3\x67", [0xeca3] = "\xd3\x68", [0xeca4] = "\xd3\x69",
  [0xeca5] = "\xd3\x6a", [0xeca6] = "\xd3\x6b", [0xeca7] = "\xd3\x6c",
  [0xeca8] = "\xd3\x6d", [0xeca9] = "\xd3\x6e", [0xecaa] = "\xd3\x6f",
  [0xecab] = "\xd3\x70", [0xecac] = "\xd3\x71", [0xecad] = "\xd3\x72",
  [0xecae] = "\xd3\x73", [0xecaf] = "\xd3\x74", [0xecb0] = "\xd3\x75",
  [0xecb1] = "\xd3\x76", [0xecb2] = "\xd3\x77", [0xecb3] = "\xd3\x78",
  [0xecb4] = "\xd3\x79", [0xecb5] = "\xd3\x7a", [0xecb6] = "\xd3\x7b",
  [0xecb7] = "\xd3\x7c", [0xecb8] = "\xd3\x7d", [0xecb9] = "\xd3\x7e",
  [0xecba] = "\xd3\x7f", [0xecbb] = "\xd3\x81", [0xecbc] = "\xd3\x82",
  [0xecbd] = "\xd3\x83", [0xecbe] = "\xd3\x84", [0xecbf] = "\xd3\x85",
  [0xecc0] = "\xd3\x86", [0xecc1] = "\xd3\x87", [0xecc2] = "\xd3\x88",
  [0xecc3] = "\xd3\x89", [0xecc4] = "\xd3\x8a", [0xecc5] = "\xd3\x8b",
  [0xecc6] = "\xd3\x8c", [0xecc7] = "\xd3\x8d", [0xecc8] = "\xd3\x8e",
  [0xecc9] = "\xd3\x8f", [0xecca] = "\xd3\x90", [0xeccb] = "\xd3\x91",
  [0xeccc] = "\xd3\x92", [0xeccd] = "\xd3\x93", [0xecce] = "\xd3\x94",
  [0xeccf] = "\xd3\x95", [0xecd0] = "\xd3\x96", [0xecd1] = "\xd3\x97",
  [0xecd2] = "\xd3\x98", [0xecd3] = "\xd3\x99", [0xecd4] = "\xd3\x9a",
  [0xecd5] = "\xd3\x9b", [0xecd6] = "\xd3\x9c", [0xecd7] = "\xd3\x9d",
  [0xecd8] = "\xd3\x9e", [0xecd9] = "\xd3\x9f", [0xecda] = "\xd3\xa0",
  [0xecdb] = "\xd3\xa1", [0xecdc] = "\xd3\xa2", [0xecdd] = "\xd3\xa3",
  [0xecde] = "\xd3\xa4", [0xecdf] = "\xd3\xa5", [0xece0] = "\xd3\xa6",
  [0xece1] = "\xd3\xa7", [0xece2] = "\xd3\xa8", [0xece3] = "\xd3\xa9",
  [0xece4] = "\xd3\xaa", [0xece5] = "\xd3\xab", [0xece6] = "\xd3\xac",
  [0xece7] = "\xd3\xad", [0xece8] = "\xd3\xae", [0xece9] = "\xd3\xaf",
  [0xecea] = "\xd3\xb0", [0xeceb] = "\xd3\xb1", [0xecec] = "\xd3\xb2",
  [0xeced] = "\xd3\xb3", [0xecee] = "\xd3\xb4", [0xecef] = "\xd3\xb5",
  [0xecf0] = "\xd3\xb6", [0xecf1] = "\xd3\xb7", [0xecf2] = "\xd3\xb8",
  [0xecf3] = "\xd3\xb9", [0xecf4] = "\xd3\xba", [0xecf5] = "\xd3\xbb",
  [0xecf6] = "\xd3\xbc", [0xecf7] = "\xd3\xbd", [0xecf8] = "\xd3\xbe",
  [0xecf9] = "\xd3\xbf", [0xecfa] = "\xd3\xc0", [0xecfb] = "\xd3\xc1",
  [0xecfc] = "\xd3\xc2", [0xecfd] = "\xd3\xc3", [0xecfe] = "\xd3\xc4",
  [0xecff] = "\xd3\xc5", [0xed00] = "\xd3\xc6", [0xed01] = "\xd3\xc7",
  [0xed02] = "\xd3\xc8", [0xed03] = "\xd3\xc9", [0xed04] = "\xd3\xca",
  [0xed05] = "\xd3\xcb", [0xed06] = "\xd3\xcc", [0xed07] = "\xd3\xcd",
  [0xed08] = "\xd3\xce", [0xed09] = "\xd3\xcf", [0xed0a] = "\xd3\xd0",
  [0xed0b] = "\xd3\xd1", [0xed0c] = "\xd3\xd2", [0xed0d] = "\xd3\xd3",
  [0xed0e] = "\xd3\xd4", [0xed0f] = "\xd3\xd5", [0xed10] = "\xd3\xd6",
  [0xed11] = "\xd3\xd7", [0xed12] = "\xd3\xd8", [0xed13] = "\xd3\xd9",
  [0xed14] = "\xd3\xda", [0xed15] = "\xd3\xdb", [0xed16] = "\xd3\xdc",
  [0xed17] = "\xd3\xdd", [0xed18] = "\xd3\xde", [0xed19] = "\xd3\xdf",
  [0xed1a] = "\xd3\xe0", [0xed1b] = "\xd3\xe1", [0xed1c] = "\xd3\xe2",
  [0xed1d] = "\xd3\xe3", [0xed1e] = "\xd3\xe4", [0xed1f] = "\xd3\xe5",
  [0xed20] = "\xd3\xe6", [0xed21] = "\xd3\xe7", [0xed22] = "\xd3\xe8",
  [0xed23] = "\xd3\xe9", [0xed24] = "\xd3\xea", [0xed25] = "\xd3\xeb",
  [0xed26] = "\xd3\xec", [0xed27] = "\xd3\xed", [0xed28] = "\xd3\xee",
  [0xed29] = "\xd3\xef", [0xed2a] = "\xd3\xf0", [0xed2b] = "\xd3\xf1",
  [0xed2c] = "\xd3\xf2", [0xed2d] = "\xd3\xf3", [0xed2e] = "\xd3\xf4",
  [0xed2f] = "\xd3\xf5", [0xed30] = "\xd3\xf6", [0xed31] = "\xd3\xf7",
  [0xed32] = "\xd3\xf8", [0xed33] = "\xd3\xf9", [0xed34] = "\xd3\xfa",
  [0xed35] = "\xd3\xfb", [0xed36] = "\xd3\xfc", [0xed37] = "\xd3\xfd",
  [0xed38] = "\xd4\x41", [0xed39] = "\xd4\x42", [0xed3a] = "\xd4\x43",
  [0xed3b] = "\xd4\x44", [0xed3c] = "\xd4\x45", [0xed3d] = "\xd4\x46",
  [0xed3e] = "\xd4\x47", [0xed3f] = "\xd4\x48", [0xed40] = "\xd4\x49",
  [0xed41] = "\xd4\x4a", [0xed42] = "\xd4\x4b", [0xed43] = "\xd4\x4c",
  [0xed44] = "\xd4\x4d", [0xed45] = "\xd4\x4e", [0xed46] = "\xd4\x4f",
  [0xed47] = "\xd4\x50", [0xed48] = "\xd4\x51", [0xed49] = "\xd4\x52",
  [0xed4a] = "\xd4\x53", [0xed4b] = "\xd4\x54", [0xed4c] = "\xd4\x55",
  [0xed4d] = "\xd4\x56", [0xed4e] = "\xd4\x57", [0xed4f] = "\xd4\x58",
  [0xed50] = "\xd4\x59", [0xed51] = "\xd4\x5a", [0xed52] = "\xd4\x5b",
  [0xed53] = "\xd4\x5c", [0xed54] = "\xd4\x5d", [0xed55] = "\xd4\x5e",
  [0xed56] = "\xd4\x5f", [0xed57] = "\xd4\x60", [0xed58] = "\xd4\x61",
  [0xed59] = "\xd4\x62", [0xed5a] = "\xd4\x63", [0xed5b] = "\xd4\x64",
  [0xed5c] = "\xd4\x65", [0xed5d] = "\xd4\x66", [0xed5e] = "\xd4\x67",
  [0xed5f] = "\xd4\x68", [0xed60] = "\xd4\x69", [0xed61] = "\xd4\x6a",
  [0xed62] = "\xd4\x6b", [0xed63] = "\xd4\x6c", [0xed64] = "\xd4\x6d",
  [0xed65] = "\xd4\x6e", [0xed66] = "\xd4\x6f", [0xed67] = "\xd4\x70",
  [0xed68] = "\xd4\x71", [0xed69] = "\xd4\x72", [0xed6a] = "\xd4\x73",
  [0xed6b] = "\xd4\x74", [0xed6c] = "\xd4\x75", [0xed6d] = "\xd4\x76",
  [0xed6e] = "\xd4\x77", [0xed6f] = "\xd4\x78", [0xed70] = "\xd4\x79",
  [0xed71] = "\xd4\x7a", [0xed72] = "\xd4\x7b", [0xed73] = "\xd4\x7c",
  [0xed74] = "\xd4\x7d", [0xed75] = "\xd4\x7e", [0xed76] = "\xd4\x7f",
  [0xed77] = "\xd4\x81", [0xed78] = "\xd4\x82", [0xed79] = "\xd4\x83",
  [0xed7a] = "\xd4\x84", [0xed7b] = "\xd4\x85", [0xed7c] = "\xd4\x86",
  [0xed7d] = "\xd4\x87", [0xed7e] = "\xd4\x88", [0xed7f] = "\xd4\x89",
  [0xed80] = "\xd4\x8a", [0xed81] = "\xd4\x8b", [0xed82] = "\xd4\x8c",
  [0xed83] = "\xd4\x8d", [0xed84] = "\xd4\x8e", [0xed85] = "\xd4\x8f",
  [0xed86] = "\xd4\x90", [0xed87] = "\xd4\x91", [0xed88] = "\xd4\x92",
  [0xed89] = "\xd4\x93", [0xed8a] = "\xd4\x94", [0xed8b] = "\xd4\x95",
  [0xed8c] = "\xd4\x96", [0xed8d] = "\xd4\x97", [0xed8e] = "\xd4\x98",
  [0xed8f] = "\xd4\x99", [0xed90] = "\xd4\x9a", [0xed91] = "\xd4\x9b",
  [0xed92] = "\xd4\x9c", [0xed93] = "\xd4\x9d", [0xed94] = "\xd4\x9e",
  [0xed95] = "\xd4\x9f", [0xed96] = "\xd4\xa0", [0xed97] = "\xd4\xa1",
  [0xed98] = "\xd4\xa2", [0xed99] = "\xd4\xa3", [0xed9a] = "\xd4\xa4",
  [0xed9b] = "\xd4\xa5", [0xed9c] = "\xd4\xa6", [0xed9d] = "\xd4\xa7",
  [0xed9e] = "\xd4\xa8", [0xed9f] = "\xd4\xa9", [0xeda0] = "\xd4\xaa",
  [0xeda1] = "\xd4\xab", [0xeda2] = "\xd4\xac", [0xeda3] = "\xd4\xad",
  [0xeda4] = "\xd4\xae", [0xeda5] = "\xd4\xaf", [0xeda6] = "\xd4\xb0",
  [0xeda7] = "\xd4\xb1", [0xeda8] = "\xd4\xb2", [0xeda9] = "\xd4\xb3",
  [0xedaa] = "\xd4\xb4", [0xedab] = "\xd4\xb5", [0xedac] = "\xd4\xb6",
  [0xedad] = "\xd4\xb7", [0xedae] = "\xd4\xb8", [0xedaf] = "\xd4\xb9",
  [0xedb0] = "\xd4\xba", [0xedb1] = "\xd4\xbb", [0xedb2] = "\xd4\xbc",
  [0xedb3] = "\xd4\xbd", [0xedb4] = "\xd4\xbe", [0xedb5] = "\xd4\xbf",
  [0xedb6] = "\xd4\xc0", [0xedb7] = "\xd4\xc1", [0xedb8] = "\xd4\xc2",
  [0xedb9] = "\xd4\xc3", [0xedba] = "\xd4\xc4", [0xedbb] = "\xd4\xc5",
  [0xedbc] = "\xd4\xc6", [0xedbd] = "\xd4\xc7", [0xedbe] = "\xd4\xc8",
  [0xedbf] = "\xd4\xc9", [0xedc0] = "\xd4\xca", [0xedc1] = "\xd4\xcb",
  [0xedc2] = "\xd4\xcc", [0xedc3] = "\xd4\xcd", [0xedc4] = "\xd4\xce",
  [0xedc5] = "\xd4\xcf", [0xedc6] = "\xd4\xd0", [0xedc7] = "\xd4\xd1",
  [0xedc8] = "\xd4\xd2", [0xedc9] = "\xd4\xd3", [0xedca] = "\xd4\xd4",
  [0xedcb] = "\xd4\xd5", [0xedcc] = "\xd4\xd6", [0xedcd] = "\xd4\xd7",
  [0xedce] = "\xd4\xd8", [0xedcf] = "\xd4\xd9", [0xedd0] = "\xd4\xda",
  [0xedd1] = "\xd4\xdb", [0xedd2] = "\xd4\xdc", [0xedd3] = "\xd4\xdd",
  [0xedd4] = "\xd4\xde", [0xedd5] = "\xd4\xdf", [0xedd6] = "\xd4\xe0",
  [0xedd7] = "\xd4\xe1", [0xedd8] = "\xd4\xe2", [0xedd9] = "\xd4\xe3",
  [0xedda] = "\xd4\xe4", [0xeddb] = "\xd4\xe5", [0xeddc] = "\xd4\xe6",
  [0xeddd] = "\xd4\xe7", [0xedde] = "\xd4\xe8", [0xeddf] = "\xd4\xe9",
  [0xede0] = "\xd4\xea", [0xede1] = "\xd4\xeb", [0xede2] = "\xd4\xec",
  [0xede3] = "\xd4\xed", [0xede4] = "\xd4\xee", [0xede5] = "\xd4\xef",
  [0xede6] = "\xd4\xf0", [0xede7] = "\xd4\xf1", [0xede8] = "\xd4\xf2",
  [0xede9] = "\xd4\xf3", [0xedea] = "\xd4\xf4", [0xedeb] = "\xd4\xf5",
  [0xedec] = "\xd4\xf6", [0xeded] = "\xd4\xf7", [0xedee] = "\xd4\xf8",
  [0xedef] = "\xd4\xf9", [0xedf0] = "\xd4\xfa", [0xedf1] = "\xd4\xfb",
  [0xedf2] = "\xd4\xfc", [0xedf3] = "\xd4\xfd", [0xedf4] = "\xd5\x41",
  [0xedf5] = "\xd5\x42", [0xedf6] = "\xd5\x43", [0xedf7] = "\xd5\x44",
  [0xedf8] = "\xd5\x45", [0xedf9] = "\xd5\x46", [0xedfa] = "\xd5\x47",
  [0xedfb] = "\xd5\x48", [0xedfc] = "\xd5\x49", [0xedfd] = "\xd5\x4a",
  [0xedfe] = "\xd5\x4b", [0xedff] = "\xd5\x4c", [0xee00] = "\xd5\x4d",
  [0xee01] = "\xd5\x4e", [0xee02] = "\xd5\x4f", [0xee03] = "\xd5\x50",
  [0xee04] = "\xd5\x51", [0xee05] = "\xd5\x52", [0xee06] = "\xd5\x53",
  [0xee07] = "\xd5\x54", [0xee08] = "\xd5\x55", [0xee09] = "\xd5\x56",
  [0xee0a] = "\xd5\x57", [0xee0b] = "\xd5\x58", [0xee0c] = "\xd5\x59",
  [0xee0d] = "\xd5\x5a", [0xee0e] = "\xd5\x5b", [0xee0f] = "\xd5\x5c",
  [0xee10] = "\xd5\x5d", [0xee11] = "\xd5\x5e", [0xee12] = "\xd5\x5f",
  [0xee13] = "\xd5\x60", [0xee14] = "\xd5\x61", [0xee15] = "\xd5\x62",
  [0xee16] = "\xd5\x63", [0xee17] = "\xd5\x64", [0xee18] = "\xd5\x65",
  [0xee19] = "\xd5\x66", [0xee1a] = "\xd5\x67", [0xee1b] = "\xd5\x68",
  [0xee1c] = "\xd5\x69", [0xee1d] = "\xd5\x6a", [0xee1e] = "\xd5\x6b",
  [0xee1f] = "\xd5\x6c", [0xee20] = "\xd5\x6d", [0xee21] = "\xd5\x6e",
  [0xee22] = "\xd5\x6f", [0xee23] = "\xd5\x70", [0xee24] = "\xd5\x71",
  [0xee25] = "\xd5\x72", [0xee26] = "\xd5\x73", [0xee27] = "\xd5\x74",
  [0xee28] = "\xd5\x75", [0xee29] = "\xd5\x76", [0xee2a] = "\xd5\x77",
  [0xee2b] = "\xd5\x78", [0xee2c] = "\xd5\x79", [0xee2d] = "\xd5\x7a",
  [0xee2e] = "\xd5\x7b", [0xee2f] = "\xd5\x7c", [0xee30] = "\xd5\x7d",
  [0xee31] = "\xd5\x7e", [0xee32] = "\xd5\x7f", [0xee33] = "\xd5\x81",
  [0xee34] = "\xd5\x82", [0xee35] = "\xd5\x83", [0xee36] = "\xd5\x84",
  [0xee37] = "\xd5\x85", [0xee38] = "\xd5\x86", [0xee39] = "\xd5\x87",
  [0xee3a] = "\xd5\x88", [0xee3b] = "\xd5\x89", [0xee3c] = "\xd5\x8a",
  [0xee3d] = "\xd5\x8b", [0xee3e] = "\xd5\x8c", [0xee3f] = "\xd5\x8d",
  [0xee40] = "\xd5\x8e", [0xee41] = "\xd5\x8f", [0xee42] = "\xd5\x90",
  [0xee43] = "\xd5\x91", [0xee44] = "\xd5\x92", [0xee45] = "\xd5\x93",
  [0xee46] = "\xd5\x94", [0xee47] = "\xd5\x95", [0xee48] = "\xd5\x96",
  [0xee49] = "\xd5\x97", [0xee4a] = "\xd5\x98", [0xee4b] = "\xd5\x99",
  [0xee4c] = "\xd5\x9a", [0xee4d] = "\xd5\x9b", [0xee4e] = "\xd5\x9c",
  [0xee4f] = "\xd5\x9d", [0xee50] = "\xd5\x9e", [0xee51] = "\xd5\x9f",
  [0xee52] = "\xd5\xa0", [0xee53] = "\xd5\xa1", [0xee54] = "\xd5\xa2",
  [0xee55] = "\xd5\xa3", [0xee56] = "\xd5\xa4", [0xee57] = "\xd5\xa5",
  [0xee58] = "\xd5\xa6", [0xee59] = "\xd5\xa7", [0xee5a] = "\xd5\xa8",
  [0xee5b] = "\xd5\xa9", [0xee5c] = "\xd5\xaa", [0xee5d] = "\xd5\xab",
  [0xee5e] = "\xd5\xac", [0xee5f] = "\xd5\xad", [0xee60] = "\xd5\xae",
  [0xee61] = "\xd5\xaf", [0xee62] = "\xd5\xb0", [0xee63] = "\xd5\xb1",
  [0xee64] = "\xd5\xb2", [0xee65] = "\xd5\xb3", [0xee66] = "\xd5\xb4",
  [0xee67] = "\xd5\xb5", [0xee68] = "\xd5\xb6", [0xee69] = "\xd5\xb7",
  [0xee6a] = "\xd5\xb8", [0xee6b] = "\xd5\xb9", [0xee6c] = "\xd5\xba",
  [0xee6d] = "\xd5\xbb", [0xee6e] = "\xd5\xbc", [0xee6f] = "\xd5\xbd",
  [0xee70] = "\xd5\xbe", [0xee71] = "\xd5\xbf", [0xee72] = "\xd5\xc0",
  [0xee73] = "\xd5\xc1", [0xee74] = "\xd5\xc2", [0xee75] = "\xd5\xc3",
  [0xee76] = "\xd5\xc4", [0xee77] = "\xd5\xc5", [0xee78] = "\xd5\xc6",
  [0xee79] = "\xd5\xc7", [0xee7a] = "\xd5\xc8", [0xee7b] = "\xd5\xc9",
  [0xee7c] = "\xd5\xca", [0xee7d] = "\xd5\xcb", [0xee7e] = "\xd5\xcc",
  [0xee7f] = "\xd5\xcd", [0xee80] = "\xd5\xce", [0xee81] = "\xd5\xcf",
  [0xee82] = "\xd5\xd0", [0xee83] = "\xd5\xd1", [0xee84] = "\xd5\xd2",
  [0xee85] = "\xd5\xd3", [0xee86] = "\xd5\xd4", [0xee87] = "\xd5\xd5",
  [0xee88] = "\xd5\xd6", [0xee89] = "\xd5\xd7", [0xee8a] = "\xd5\xd8",
  [0xee8b] = "\xd5\xd9", [0xee8c] = "\xd5\xda", [0xee8d] = "\xd5\xdb",
  [0xee8e] = "\xd5\xdc", [0xee8f] = "\xd5\xdd", [0xee90] = "\xd5\xde",
  [0xee91] = "\xd5\xdf", [0xee92] = "\xd5\xe0", [0xee93] = "\xd5\xe1",
  [0xee94] = "\xd5\xe2", [0xee95] = "\xd5\xe3", [0xee96] = "\xd5\xe4",
  [0xee97] = "\xd5\xe5", [0xee98] = "\xd5\xe6", [0xee99] = "\xd5\xe7",
  [0xee9a] = "\xd5\xe8", [0xee9b] = "\xd5\xe9", [0xee9c] = "\xd5\xea",
  [0xee9d] = "\xd5\xeb", [0xee9e] = "\xd5\xec", [0xee9f] = "\xd5\xed",
  [0xeea0] = "\xd5\xee", [0xeea1] = "\xd5\xef", [0xeea2] = "\xd5\xf0",
  [0xeea3] = "\xd5\xf1", [0xeea4] = "\xd5\xf2", [0xeea5] = "\xd5\xf3",
  [0xeea6] = "\xd5\xf4", [0xeea7] = "\xd5\xf5", [0xeea8] = "\xd5\xf6",
  [0xeea9] = "\xd5\xf7", [0xeeaa] = "\xd5\xf8", [0xeeab] = "\xd5\xf9",
  [0xeeac] = "\xd5\xfa", [0xeead] = "\xd5\xfb", [0xeeae] = "\xd5\xfc",
  [0xeeaf] = "\xd5\xfd", [0xeeb0] = "\xd6\x41", [0xeeb1] = "\xd6\x42",
  [0xeeb2] = "\xd6\x43", [0xeeb3] = "\xd6\x44", [0xeeb4] = "\xd6\x45",
  [0xeeb5] = "\xd6\x46", [0xeeb6] = "\xd6\x47", [0xeeb7] = "\xd6\x48",
  [0xeeb8] = "\xd6\x49", [0xeeb9] = "\xd6\x4a", [0xeeba] = "\xd6\x4b",
  [0xeebb] = "\xd6\x4c", [0xeebc] = "\xd6\x4d", [0xeebd] = "\xd6\x4e",
  [0xeebe] = "\xd6\x4f", [0xeebf] = "\xd6\x50", [0xeec0] = "\xd6\x51",
  [0xeec1] = "\xd6\x52", [0xeec2] = "\xd6\x53", [0xeec3] = "\xd6\x54",
  [0xeec4] = "\xd6\x55", [0xeec5] = "\xd6\x56", [0xeec6] = "\xd6\x57",
  [0xeec7] = "\xd6\x58", [0xeec8] = "\xd6\x59", [0xeec9] = "\xd6\x5a",
  [0xeeca] = "\xd6\x5b", [0xeecb] = "\xd6\x5c", [0xeecc] = "\xd6\x5d",
  [0xeecd] = "\xd6\x5e", [0xeece] = "\xd6\x5f", [0xeecf] = "\xd6\x60",
  [0xeed0] = "\xd6\x61", [0xeed1] = "\xd6\x62", [0xeed2] = "\xd6\x63",
  [0xeed3] = "\xd6\x64", [0xeed4] = "\xd6\x65", [0xeed5] = "\xd6\x66",
  [0xeed6] = "\xd6\x67", [0xeed7] = "\xd6\x68", [0xeed8] = "\xd6\x69",
  [0xeed9] = "\xd6\x6a", [0xeeda] = "\xd6\x6b", [0xeedb] = "\xd6\x6c",
  [0xeedc] = "\xd6\x6d", [0xeedd] = "\xd6\x6e", [0xeede] = "\xd6\x6f",
  [0xeedf] = "\xd6\x70", [0xeee0] = "\xd6\x71", [0xeee1] = "\xd6\x72",
  [0xeee2] = "\xd6\x73", [0xeee3] = "\xd6\x74", [0xeee4] = "\xd6\x75",
  [0xeee5] = "\xd6\x76", [0xeee6] = "\xd6\x77", [0xeee7] = "\xd6\x78",
  [0xeee8] = "\xd6\x79", [0xeee9] = "\xd6\x7a", [0xeeea] = "\xd6\x7b",
  [0xeeeb] = "\xd6\x7c", [0xeeec] = "\xd6\x7d", [0xeeed] = "\xd6\x7e",
  [0xeeee] = "\xd6\x7f", [0xeeef] = "\xd6\x81", [0xeef0] = "\xd6\x82",
  [0xeef1] = "\xd6\x83", [0xeef2] = "\xd6\x84", [0xeef3] = "\xd6\x85",
  [0xeef4] = "\xd6\x86", [0xeef5] = "\xd6\x87", [0xeef6] = "\xd6\x88",
  [0xeef7] = "\xd6\x89", [0xeef8] = "\xd6\x8a", [0xeef9] = "\xd6\x8b",
  [0xeefa] = "\xd6\x8c", [0xeefb] = "\xd6\x8d", [0xeefc] = "\xd6\x8e",
  [0xeefd] = "\xd6\x8f", [0xeefe] = "\xd6\x90", [0xeeff] = "\xd6\x91",
  [0xef00] = "\xd6\x92", [0xef01] = "\xd6\x93", [0xef02] = "\xd6\x94",
  [0xef03] = "\xd6\x95", [0xef04] = "\xd6\x96", [0xef05] = "\xd6\x97",
  [0xef06] = "\xd6\x98", [0xef07] = "\xd6\x99", [0xef08] = "\xd6\x9a",
  [0xef09] = "\xd6\x9b", [0xef0a] = "\xd6\x9c", [0xef0b] = "\xd6\x9d",
  [0xef0c] = "\xd6\x9e", [0xef0d] = "\xd6\x9f", [0xef0e] = "\xd6\xa0",
  [0xef0f] = "\xd6\xa1", [0xef10] = "\xd6\xa2", [0xef11] = "\xd6\xa3",
  [0xef12] = "\xd6\xa4", [0xef13] = "\xd6\xa5", [0xef14] = "\xd6\xa6",
  [0xef15] = "\xd6\xa7", [0xef16] = "\xd6\xa8", [0xef17] = "\xd6\xa9",
  [0xef18] = "\xd6\xaa", [0xef19] = "\xd6\xab", [0xef1a] = "\xd6\xac",
  [0xef1b] = "\xd6\xad", [0xef1c] = "\xd6\xae", [0xef1d] = "\xd6\xaf",
  [0xef1e] = "\xd6\xb0", [0xef1f] = "\xd6\xb1", [0xef20] = "\xd6\xb2",
  [0xef21] = "\xd6\xb3", [0xef22] = "\xd6\xb4", [0xef23] = "\xd6\xb5",
  [0xef24] = "\xd6\xb6", [0xef25] = "\xd6\xb7", [0xef26] = "\xd6\xb8",
  [0xef27] = "\xd6\xb9", [0xef28] = "\xd6\xba", [0xef29] = "\xd6\xbb",
  [0xef2a] = "\xd6\xbc", [0xef2b] = "\xd6\xbd", [0xef2c] = "\xd6\xbe",
  [0xef2d] = "\xd6\xbf", [0xef2e] = "\xd6\xc0", [0xef2f] = "\xd6\xc1",
  [0xef30] = "\xd6\xc2", [0xef31] = "\xd6\xc3", [0xef32] = "\xd6\xc4",
  [0xef33] = "\xd6\xc5", [0xef34] = "\xd6\xc6", [0xef35] = "\xd6\xc7",
  [0xef36] = "\xd6\xc8", [0xef37] = "\xd6\xc9", [0xef38] = "\xd6\xca",
  [0xef39] = "\xd6\xcb", [0xef3a] = "\xd6\xcc", [0xef3b] = "\xd6\xcd",
  [0xef3c] = "\xd6\xce", [0xef3d] = "\xd6\xcf", [0xef3e] = "\xd6\xd0",
  [0xef3f] = "\xd6\xd1", [0xef40] = "\xd6\xd2", [0xef41] = "\xd6\xd3",
  [0xef42] = "\xd6\xd4", [0xef43] = "\xd6\xd5", [0xef44] = "\xd6\xd6",
  [0xef45] = "\xd6\xd7", [0xef46] = "\xd6\xd8", [0xef47] = "\xd6\xd9",
  [0xef48] = "\xd6\xda", [0xef49] = "\xd6\xdb", [0xef4a] = "\xd6\xdc",
  [0xef4b] = "\xd6\xdd", [0xef4c] = "\xd6\xde", [0xef4d] = "\xd6\xdf",
  [0xef4e] = "\xd6\xe0", [0xef4f] = "\xd6\xe1", [0xef50] = "\xd6\xe2",
  [0xef51] = "\xd6\xe3", [0xef52] = "\xd6\xe4", [0xef53] = "\xd6\xe5",
  [0xef54] = "\xd6\xe6", [0xef55] = "\xd6\xe7", [0xef56] = "\xd6\xe8",
  [0xef57] = "\xd6\xe9", [0xef58] = "\xd6\xea", [0xef59] = "\xd6\xeb",
  [0xef5a] = "\xd6\xec", [0xef5b] = "\xd6\xed", [0xef5c] = "\xd6\xee",
  [0xef5d] = "\xd6\xef", [0xef5e] = "\xd6\xf0", [0xef5f] = "\xd6\xf1",
  [0xef60] = "\xd6\xf2", [0xef61] = "\xd6\xf3", [0xef62] = "\xd6\xf4",
  [0xef63] = "\xd6\xf5", [0xef64] = "\xd6\xf6", [0xef65] = "\xd6\xf7",
  [0xef66] = "\xd6\xf8", [0xef67] = "\xd6\xf9", [0xef68] = "\xd6\xfa",
  [0xef69] = "\xd6\xfb", [0xef6a] = "\xd6\xfc", [0xef6b] = "\xd6\xfd",
  [0xef6c] = "\xd7\x41", [0xef6d] = "\xd7\x42", [0xef6e] = "\xd7\x43",
  [0xef6f] = "\xd7\x44", [0xef70] = "\xd7\x45", [0xef71] = "\xd7\x46",
  [0xef72] = "\xd7\x47", [0xef73] = "\xd7\x48", [0xef74] = "\xd7\x49",
  [0xef75] = "\xd7\x4a", [0xef76] = "\xd7\x4b", [0xef77] = "\xd7\x4c",
  [0xef78] = "\xd7\x4d", [0xef79] = "\xd7\x4e", [0xef7a] = "\xd7\x4f",
  [0xef7b] = "\xd7\x50", [0xef7c] = "\xd7\x51", [0xef7d] = "\xd7\x52",
  [0xef7e] = "\xd7\x53", [0xef7f] = "\xd7\x54", [0xef80] = "\xd7\x55",
  [0xef81] = "\xd7\x56", [0xef82] = "\xd7\x57", [0xef83] = "\xd7\x58",
  [0xef84] = "\xd7\x59", [0xef85] = "\xd7\x5a", [0xef86] = "\xd7\x5b",
  [0xef87] = "\xd7\x5c", [0xef88] = "\xd7\x5d", [0xef89] = "\xd7\x5e",
  [0xef8a] = "\xd7\x5f", [0xef8b] = "\xd7\x60", [0xef8c] = "\xd7\x61",
  [0xef8d] = "\xd7\x62", [0xef8e] = "\xd7\x63", [0xef8f] = "\xd7\x64",
  [0xef90] = "\xd7\x65", [0xef91] = "\xd7\x66", [0xef92] = "\xd7\x67",
  [0xef93] = "\xd7\x68", [0xef94] = "\xd7\x69", [0xef95] = "\xd7\x6a",
  [0xef96] = "\xd7\x6b", [0xef97] = "\xd7\x6c", [0xef98] = "\xd7\x6d",
  [0xef99] = "\xd7\x6e", [0xef9a] = "\xd7\x6f", [0xef9b] = "\xd7\x70",
  [0xef9c] = "\xd7\x71", [0xef9d] = "\xd7\x72", [0xef9e] = "\xd7\x73",
  [0xef9f] = "\xd7\x74", [0xefa0] = "\xd7\x75", [0xefa1] = "\xd7\x76",
  [0xefa2] = "\xd7\x77", [0xefa3] = "\xd7\x78", [0xefa4] = "\xd7\x79",
  [0xefa5] = "\xd7\x7a", [0xefa6] = "\xd7\x7b", [0xefa7] = "\xd7\x7c",
  [0xefa8] = "\xd7\x7d", [0xefa9] = "\xd7\x7e", [0xefaa] = "\xd7\x7f",
  [0xefab] = "\xd7\x81", [0xefac] = "\xd7\x82", [0xefad] = "\xd7\x83",
  [0xefae] = "\xd7\x84", [0xefaf] = "\xd7\x85", [0xefb0] = "\xd7\x86",
  [0xefb1] = "\xd7\x87", [0xefb2] = "\xd7\x88", [0xefb3] = "\xd7\x89",
  [0xefb4] = "\xd7\x8a", [0xefb5] = "\xd7\x8b", [0xefb6] = "\xd7\x8c",
  [0xefb7] = "\xd7\x8d", [0xefb8] = "\xd7\x8e", [0xefb9] = "\xd7\x8f",
  [0xefba] = "\xd7\x90", [0xefbb] = "\xd7\x91", [0xefbc] = "\xd7\x92",
  [0xefbd] = "\xd7\x93", [0xefbe] = "\xd7\x94", [0xefbf] = "\xd7\x95",
  [0xefc0] = "\xd7\x96", [0xefc1] = "\xd7\x97", [0xefc2] = "\xd7\x98",
  [0xefc3] = "\xd7\x99", [0xefc4] = "\xd7\x9a", [0xefc5] = "\xd7\x9b",
  [0xefc6] = "\xd7\x9c", [0xefc7] = "\xd7\x9d", [0xefc8] = "\xd7\x9e",
  [0xefc9] = "\xd7\x9f", [0xefca] = "\xd7\xa0", [0xefcb] = "\xd7\xa1",
  [0xefcc] = "\xd7\xa2", [0xefcd] = "\xd7\xa3", [0xefce] = "\xd7\xa4",
  [0xefcf] = "\xd7\xa5", [0xefd0] = "\xd7\xa6", [0xefd1] = "\xd7\xa7",
  [0xefd2] = "\xd7\xa8", [0xefd3] = "\xd7\xa9", [0xefd4] = "\xd7\xaa",
  [0xefd5] = "\xd7\xab", [0xefd6] = "\xd7\xac", [0xefd7] = "\xd7\xad",
  [0xefd8] = "\xd7\xae", [0xefd9] = "\xd7\xaf", [0xefda] = "\xd7\xb0",
  [0xefdb] = "\xd7\xb1", [0xefdc] = "\xd7\xb2", [0xefdd] = "\xd7\xb3",
  [0xefde] = "\xd7\xb4", [0xefdf] = "\xd7\xb5", [0xefe0] = "\xd7\xb6",
  [0xefe1] = "\xd7\xb7", [0xefe2] = "\xd7\xb8", [0xefe3] = "\xd7\xb9",
  [0xefe4] = "\xd7\xba", [0xefe5] = "\xd7\xbb", [0xefe6] = "\xd7\xbc",
  [0xefe7] = "\xd7\xbd", [0xefe8] = "\xd7\xbe", [0xefe9] = "\xd7\xbf",
  [0xefea] = "\xd7\xc0", [0xefeb] = "\xd7\xc1", [0xefec] = "\xd7\xc2",
  [0xefed] = "\xd7\xc3", [0xefee] = "\xd7\xc4", [0xefef] = "\xd7\xc5",
  [0xeff0] = "\xd7\xc6", [0xeff1] = "\xd7\xc7", [0xeff2] = "\xd7\xc8",
  [0xeff3] = "\xd7\xc9", [0xeff4] = "\xd7\xca", [0xeff5] = "\xd7\xcb",
  [0xeff6] = "\xd7\xcc", [0xeff7] = "\xd7\xcd", [0xeff8] = "\xd7\xce",
  [0xeff9] = "\xd7\xcf", [0xeffa] = "\xd7\xd0", [0xeffb] = "\xd7\xd1",
  [0xeffc] = "\xd7\xd2", [0xeffd] = "\xd7\xd3", [0xeffe] = "\xd7\xd4",
  [0xefff] = "\xd7\xd5", [0xf000] = "\xd7\xd6", [0xf001] = "\xd7\xd7",
  [0xf002] = "\xd7\xd8", [0xf003] = "\xd7\xd9", [0xf004] = "\xd7\xda",
  [0xf005] = "\xd7\xdb", [0xf006] = "\xd7\xdc", [0xf007] = "\xd7\xdd",
  [0xf008] = "\xd7\xde", [0xf009] = "\xd7\xdf", [0xf00a] = "\xd7\xe0",
  [0xf00b] = "\xd7\xe1", [0xf00c] = "\xd7\xe2", [0xf00d] = "\xd7\xe3",
  [0xf00e] = "\xd7\xe4", [0xf00f] = "\xd7\xe5", [0xf010] = "\xd7\xe6",
  [0xf011] = "\xd7\xe7", [0xf012] = "\xd7\xe8", [0xf013] = "\xd7\xe9",
  [0xf014] = "\xd7\xea", [0xf015] = "\xd7\xeb", [0xf016] = "\xd7\xec",
  [0xf017] = "\xd7\xed", [0xf018] = "\xd7\xee", [0xf019] = "\xd7\xef",
  [0xf01a] = "\xd7\xf0", [0xf01b] = "\xd7\xf1", [0xf01c] = "\xd7\xf2",
  [0xf01d] = "\xd7\xf3", [0xf01e] = "\xd7\xf4", [0xf01f] = "\xd7\xf5",
  [0xf020] = "\xd7\xf6", [0xf021] = "\xd7\xf7", [0xf022] = "\xd7\xf8",
  [0xf023] = "\xd7\xf9", [0xf024] = "\xd7\xfa", [0xf025] = "\xd7\xfb",
  [0xf026] = "\xd7\xfc", [0xf027] = "\xd7\xfd", [0xf028] = "\xd8\x41",
  [0xf029] = "\xd8\x42", [0xf02a] = "\xd8\x43", [0xf02b] = "\xd8\x44",
  [0xf02c] = "\xd8\x45", [0xf02d] = "\xd8\x46", [0xf02e] = "\xd8\x47",
  [0xf02f] = "\xd8\x48", [0xf030] = "\xd8\x49", [0xf031] = "\xd8\x4a",
  [0xf032] = "\xd8\x4b", [0xf033] = "\xd8\x4c", [0xf034] = "\xd8\x4d",
  [0xf035] = "\xd8\x4e", [0xf036] = "\xd8\x4f", [0xf037] = "\xd8\x50",
  [0xf038] = "\xd8\x51", [0xf039] = "\xd8\x52", [0xf03a] = "\xd8\x53",
  [0xf03b] = "\xd8\x54", [0xf03c] = "\xd8\x55", [0xf03d] = "\xd8\x56",
  [0xf03e] = "\xd8\x57", [0xf03f] = "\xd8\x58", [0xf040] = "\xd8\x59",
  [0xf041] = "\xd8\x5a", [0xf042] = "\xd8\x5b", [0xf043] = "\xd8\x5c",
  [0xf044] = "\xd8\x5d", [0xf045] = "\xd8\x5e", [0xf046] = "\xd8\x5f",
  [0xf047] = "\xd8\x60", [0xf048] = "\xd8\x61", [0xf049] = "\xd8\x62",
  [0xf04a] = "\xd8\x63", [0xf04b] = "\xd8\x64", [0xf04c] = "\xd8\x65",
  [0xf04d] = "\xd8\x66", [0xf04e] = "\xd8\x67", [0xf04f] = "\xd8\x68",
  [0xf050] = "\xd8\x69", [0xf051] = "\xd8\x6a", [0xf052] = "\xd8\x6b",
  [0xf053] = "\xd8\x6c", [0xf054] = "\xd8\x6d", [0xf055] = "\xd8\x6e",
  [0xf056] = "\xd8\x6f", [0xf057] = "\xd8\x70", [0xf058] = "\xd8\x71",
  [0xf059] = "\xd8\x72", [0xf05a] = "\xd8\x73", [0xf05b] = "\xd8\x74",
  [0xf05c] = "\xd8\x75", [0xf05d] = "\xd8\x76", [0xf05e] = "\xd8\x77",
  [0xf05f] = "\xd8\x78", [0xf060] = "\xd8\x79", [0xf061] = "\xd8\x7a",
  [0xf062] = "\xd8\x7b", [0xf063] = "\xd8\x7c", [0xf064] = "\xd8\x7d",
  [0xf065] = "\xd8\x7e", [0xf066] = "\xd8\x7f", [0xf067] = "\xd8\x81",
  [0xf068] = "\xd8\x82", [0xf069] = "\xd8\x83", [0xf06a] = "\xd8\x84",
  [0xf06b] = "\xd8\x85", [0xf06c] = "\xd8\x86", [0xf06d] = "\xd8\x87",
  [0xf06e] = "\xd8\x88", [0xf06f] = "\xd8\x89", [0xf070] = "\xd8\x8a",
  [0xf071] = "\xd8\x8b", [0xf072] = "\xd8\x8c", [0xf073] = "\xd8\x8d",
  [0xf074] = "\xd8\x8e", [0xf075] = "\xd8\x8f", [0xf076] = "\xd8\x90",
  [0xf077] = "\xd8\x91", [0xf078] = "\xd8\x92", [0xf079] = "\xd8\x93",
  [0xf07a] = "\xd8\x94", [0xf07b] = "\xd8\x95", [0xf07c] = "\xd8\x96",
  [0xf07d] = "\xd8\x97", [0xf07e] = "\xd8\x98", [0xf07f] = "\xd8\x99",
  [0xf080] = "\xd8\x9a", [0xf081] = "\xd8\x9b", [0xf082] = "\xd8\x9c",
  [0xf083] = "\xd8\x9d", [0xf084] = "\xd8\x9e", [0xf085] = "\xd8\x9f",
  [0xf086] = "\xd8\xa0", [0xf087] = "\xd8\xa1", [0xf088] = "\xd8\xa2",
  [0xf089] = "\xd8\xa3", [0xf08a] = "\xd8\xa4", [0xf08b] = "\xd8\xa5",
  [0xf08c] = "\xd8\xa6", [0xf08d] = "\xd8\xa7", [0xf08e] = "\xd8\xa8",
  [0xf08f] = "\xd8\xa9", [0xf090] = "\xd8\xaa", [0xf091] = "\xd8\xab",
  [0xf092] = "\xd8\xac", [0xf093] = "\xd8\xad", [0xf094] = "\xd8\xae",
  [0xf095] = "\xd8\xaf", [0xf096] = "\xd8\xb0", [0xf097] = "\xd8\xb1",
  [0xf098] = "\xd8\xb2", [0xf099] = "\xd8\xb3", [0xf09a] = "\xd8\xb4",
  [0xf09b] = "\xd8\xb5", [0xf09c] = "\xd8\xb6", [0xf09d] = "\xd8\xb7",
  [0xf09e] = "\xd8\xb8", [0xf09f] = "\xd8\xb9", [0xf0a0] = "\xd8\xba",
  [0xf0a1] = "\xd8\xbb", [0xf0a2] = "\xd8\xbc", [0xf0a3] = "\xd8\xbd",
  [0xf0a4] = "\xd8\xbe", [0xf0a5] = "\xd8\xbf", [0xf0a6] = "\xd8\xc0",
  [0xf0a7] = "\xd8\xc1", [0xf0a8] = "\xd8\xc2", [0xf0a9] = "\xd8\xc3",
  [0xf0aa] = "\xd8\xc4", [0xf0ab] = "\xd8\xc5", [0xf0ac] = "\xd8\xc6",
  [0xf0ad] = "\xd8\xc7", [0xf0ae] = "\xd8\xc8", [0xf0af] = "\xd8\xc9",
  [0xf0b0] = "\xd8\xca", [0xf0b1] = "\xd8\xcb", [0xf0b2] = "\xd8\xcc",
  [0xf0b3] = "\xd8\xcd", [0xf0b4] = "\xd8\xce", [0xf0b5] = "\xd8\xcf",
  [0xf0b6] = "\xd8\xd0", [0xf0b7] = "\xd8\xd1", [0xf0b8] = "\xd8\xd2",
  [0xf0b9] = "\xd8\xd3", [0xf0ba] = "\xd8\xd4", [0xf0bb] = "\xd8\xd5",
  [0xf0bc] = "\xd8\xd6", [0xf0bd] = "\xd8\xd7", [0xf0be] = "\xd8\xd8",
  [0xf0bf] = "\xd8\xd9", [0xf0c0] = "\xd8\xda", [0xf0c1] = "\xd8\xdb",
  [0xf0c2] = "\xd8\xdc", [0xf0c3] = "\xd8\xdd", [0xf0c4] = "\xd8\xde",
  [0xf0c5] = "\xd8\xdf", [0xf0c6] = "\xd8\xe0", [0xf0c7] = "\xd8\xe1",
  [0xf0c8] = "\xd8\xe2", [0xf0c9] = "\xd8\xe3", [0xf0ca] = "\xd8\xe4",
  [0xf0cb] = "\xd8\xe5", [0xf0cc] = "\xd8\xe6", [0xf0cd] = "\xd8\xe7",
  [0xf0ce] = "\xd8\xe8", [0xf0cf] = "\xd8\xe9", [0xf0d0] = "\xd8\xea",
  [0xf0d1] = "\xd8\xeb", [0xf0d2] = "\xd8\xec", [0xf0d3] = "\xd8\xed",
  [0xf0d4] = "\xd8\xee", [0xf0d5] = "\xd8\xef", [0xf0d6] = "\xd8\xf0",
  [0xf0d7] = "\xd8\xf1", [0xf0d8] = "\xd8\xf2", [0xf0d9] = "\xd8\xf3",
  [0xf0da] = "\xd8\xf4", [0xf0db] = "\xd8\xf5", [0xf0dc] = "\xd8\xf6",
  [0xf0dd] = "\xd8\xf7", [0xf0de] = "\xd8\xf8", [0xf0df] = "\xd8\xf9",
  [0xf0e0] = "\xd8\xfa", [0xf0e1] = "\xd8\xfb", [0xf0e2] = "\xd8\xfc",
  [0xf0e3] = "\xd8\xfd", [0xf0e4] = "\xd9\x41", [0xf0e5] = "\xd9\x42",
  [0xf0e6] = "\xd9\x43", [0xf0e7] = "\xd9\x44", [0xf0e8] = "\xd9\x45",
  [0xf0e9] = "\xd9\x46", [0xf0ea] = "\xd9\x47", [0xf0eb] = "\xd9\x48",
  [0xf0ec] = "\xd9\x49", [0xf0ed] = "\xd9\x4a", [0xf0ee] = "\xd9\x4b",
  [0xf0ef] = "\xd9\x4c", [0xf0f0] = "\xd9\x4d", [0xf0f1] = "\xd9\x4e",
  [0xf0f2] = "\xd9\x4f", [0xf0f3] = "\xd9\x50", [0xf0f4] = "\xd9\x51",
  [0xf0f5] = "\xd9\x52", [0xf0f6] = "\xd9\x53", [0xf0f7] = "\xd9\x54",
  [0xf0f8] = "\xd9\x55", [0xf0f9] = "\xd9\x56", [0xf0fa] = "\xd9\x57",
  [0xf0fb] = "\xd9\x58", [0xf0fc] = "\xd9\x59", [0xf0fd] = "\xd9\x5a",
  [0xf0fe] = "\xd9\x5b", [0xf0ff] = "\xd9\x5c", [0xf100] = "\xd9\x5d",
  [0xf101] = "\xd9\x5e", [0xf102] = "\xd9\x5f", [0xf103] = "\xd9\x60",
  [0xf104] = "\xd9\x61", [0xf105] = "\xd9\x62", [0xf106] = "\xd9\x63",
  [0xf107] = "\xd9\x64", [0xf108] = "\xd9\x65", [0xf109] = "\xd9\x66",
  [0xf10a] = "\xd9\x67", [0xf10b] = "\xd9\x68", [0xf10c] = "\xd9\x69",
  [0xf10d] = "\xd9\x6a", [0xf10e] = "\xd9\x6b", [0xf10f] = "\xd9\x6c",
  [0xf110] = "\xd9\x6d", [0xf111] = "\xd9\x6e", [0xf112] = "\xd9\x6f",
  [0xf113] = "\xd9\x70", [0xf114] = "\xd9\x71", [0xf115] = "\xd9\x72",
  [0xf116] = "\xd9\x73", [0xf117] = "\xd9\x74", [0xf118] = "\xd9\x75",
  [0xf119] = "\xd9\x76", [0xf11a] = "\xd9\x77", [0xf11b] = "\xd9\x78",
  [0xf11c] = "\xd9\x79", [0xf11d] = "\xd9\x7a", [0xf11e] = "\xd9\x7b",
  [0xf11f] = "\xd9\x7c", [0xf120] = "\xd9\x7d", [0xf121] = "\xd9\x7e",
  [0xf122] = "\xd9\x7f", [0xf123] = "\xd9\x81", [0xf124] = "\xd9\x82",
  [0xf125] = "\xd9\x83", [0xf126] = "\xd9\x84", [0xf127] = "\xd9\x85",
  [0xf128] = "\xd9\x86", [0xf129] = "\xd9\x87", [0xf12a] = "\xd9\x88",
  [0xf12b] = "\xd9\x89", [0xf12c] = "\xd9\x8a", [0xf12d] = "\xd9\x8b",
  [0xf12e] = "\xd9\x8c", [0xf12f] = "\xd9\x8d", [0xf130] = "\xd9\x8e",
  [0xf131] = "\xd9\x8f", [0xf132] = "\xd9\x90", [0xf133] = "\xd9\x91",
  [0xf134] = "\xd9\x92", [0xf135] = "\xd9\x93", [0xf136] = "\xd9\x94",
  [0xf137] = "\xd9\x95", [0xf138] = "\xd9\x96", [0xf139] = "\xd9\x97",
  [0xf13a] = "\xd9\x98", [0xf13b] = "\xd9\x99", [0xf13c] = "\xd9\x9a",
  [0xf13d] = "\xd9\x9b", [0xf13e] = "\xd9\x9c", [0xf13f] = "\xd9\x9d",
  [0xf140] = "\xd9\x9e", [0xf141] = "\xd9\x9f", [0xf142] = "\xd9\xa0",
  [0xf143] = "\xd9\xa1", [0xf144] = "\xd9\xa2", [0xf145] = "\xd9\xa3",
  [0xf146] = "\xd9\xa4", [0xf147] = "\xd9\xa5", [0xf148] = "\xd9\xa6",
  [0xf149] = "\xd9\xa7", [0xf14a] = "\xd9\xa8", [0xf14b] = "\xd9\xa9",
  [0xf14c] = "\xd9\xaa", [0xf14d] = "\xd9\xab", [0xf14e] = "\xd9\xac",
  [0xf14f] = "\xd9\xad", [0xf150] = "\xd9\xae", [0xf151] = "\xd9\xaf",
  [0xf152] = "\xd9\xb0", [0xf153] = "\xd9\xb1", [0xf154] = "\xd9\xb2",
  [0xf155] = "\xd9\xb3", [0xf156] = "\xd9\xb4", [0xf157] = "\xd9\xb5",
  [0xf158] = "\xd9\xb6", [0xf159] = "\xd9\xb7", [0xf15a] = "\xd9\xb8",
  [0xf15b] = "\xd9\xb9", [0xf15c] = "\xd9\xba", [0xf15d] = "\xd9\xbb",
  [0xf15e] = "\xd9\xbc", [0xf15f] = "\xd9\xbd", [0xf160] = "\xd9\xbe",
  [0xf161] = "\xd9\xbf", [0xf162] = "\xd9\xc0", [0xf163] = "\xd9\xc1",
  [0xf164] = "\xd9\xc2", [0xf165] = "\xd9\xc3", [0xf166] = "\xd9\xc4",
  [0xf167] = "\xd9\xc5", [0xf168] = "\xd9\xc6", [0xf169] = "\xd9\xc7",
  [0xf16a] = "\xd9\xc8", [0xf16b] = "\xd9\xc9", [0xf16c] = "\xd9\xca",
  [0xf16d] = "\xd9\xcb", [0xf16e] = "\xd9\xcc", [0xf16f] = "\xd9\xcd",
  [0xf170] = "\xd9\xce", [0xf171] = "\xd9\xcf", [0xf172] = "\xd9\xd0",
  [0xf173] = "\xd9\xd1", [0xf174] = "\xd9\xd2", [0xf175] = "\xd9\xd3",
  [0xf176] = "\xd9\xd4", [0xf177] = "\xd9\xd5", [0xf178] = "\xd9\xd6",
  [0xf179] = "\xd9\xd7", [0xf17a] = "\xd9\xd8", [0xf17b] = "\xd9\xd9",
  [0xf17c] = "\xd9\xda", [0xf17d] = "\xd9\xdb", [0xf17e] = "\xd9\xdc",
  [0xf17f] = "\xd9\xdd", [0xf180] = "\xd9\xde", [0xf181] = "\xd9\xdf",
  [0xf182] = "\xd9\xe0", [0xf183] = "\xd9\xe1", [0xf184] = "\xd9\xe2",
  [0xf185] = "\xd9\xe3", [0xf186] = "\xd9\xe4", [0xf187] = "\xd9\xe5",
  [0xf188] = "\xd9\xe6", [0xf189] = "\xd9\xe7", [0xf18a] = "\xd9\xe8",
  [0xf18b] = "\xd9\xe9", [0xf18c] = "\xd9\xea", [0xf18d] = "\xd9\xeb",
  [0xf18e] = "\xd9\xec", [0xf18f] = "\xd9\xed", [0xf190] = "\xd9\xee",
  [0xf191] = "\xd9\xef", [0xf192] = "\xd9\xf0", [0xf193] = "\xd9\xf1",
  [0xf194] = "\xd9\xf2", [0xf195] = "\xd9\xf3", [0xf196] = "\xd9\xf4",
  [0xf197] = "\xd9\xf5", [0xf198] = "\xd9\xf6", [0xf199] = "\xd9\xf7",
  [0xf19a] = "\xd9\xf8", [0xf19b] = "\xd9\xf9", [0xf19c] = "\xd9\xfa",
  [0xf19d] = "\xd9\xfb", [0xf19e] = "\xd9\xfc", [0xf19f] = "\xd9\xfd",
  [0xf1a0] = "\xda\x41", [0xf1a1] = "\xda\x42", [0xf1a2] = "\xda\x43",
  [0xf1a3] = "\xda\x44", [0xf1a4] = "\xda\x45", [0xf1a5] = "\xda\x46",
  [0xf1a6] = "\xda\x47", [0xf1a7] = "\xda\x48", [0xf1a8] = "\xda\x49",
  [0xf1a9] = "\xda\x4a", [0xf1aa] = "\xda\x4b", [0xf1ab] = "\xda\x4c",
  [0xf1ac] = "\xda\x4d", [0xf1ad] = "\xda\x4e", [0xf1ae] = "\xda\x4f",
  [0xf1af] = "\xda\x50", [0xf1b0] = "\xda\x51", [0xf1b1] = "\xda\x52",
  [0xf1b2] = "\xda\x53", [0xf1b3] = "\xda\x54", [0xf1b4] = "\xda\x55",
  [0xf1b5] = "\xda\x56", [0xf1b6] = "\xda\x57", [0xf1b7] = "\xda\x58",
  [0xf1b8] = "\xda\x59", [0xf1b9] = "\xda\x5a", [0xf1ba] = "\xda\x5b",
  [0xf1bb] = "\xda\x5c", [0xf1bc] = "\xda\x5d", [0xf1bd] = "\xda\x5e",
  [0xf1be] = "\xda\x5f", [0xf1bf] = "\xda\x60", [0xf1c0] = "\xda\x61",
  [0xf1c1] = "\xda\x62", [0xf1c2] = "\xda\x63", [0xf1c3] = "\xda\x64",
  [0xf1c4] = "\xda\x65", [0xf1c5] = "\xda\x66", [0xf1c6] = "\xda\x67",
  [0xf1c7] = "\xda\x68", [0xf1c8] = "\xda\x69", [0xf1c9] = "\xda\x6a",
  [0xf1ca] = "\xda\x6b", [0xf1cb] = "\xda\x6c", [0xf1cc] = "\xda\x6d",
  [0xf1cd] = "\xda\x6e", [0xf1ce] = "\xda\x6f", [0xf1cf] = "\xda\x70",
  [0xf1d0] = "\xda\x71", [0xf1d1] = "\xda\x72", [0xf1d2] = "\xda\x73",
  [0xf1d3] = "\xda\x74", [0xf1d4] = "\xda\x75", [0xf1d5] = "\xda\x76",
  [0xf1d6] = "\xda\x77", [0xf1d7] = "\xda\x78", [0xf1d8] = "\xda\x79",
  [0xf1d9] = "\xda\x7a", [0xf1da] = "\xda\x7b", [0xf1db] = "\xda\x7c",
  [0xf1dc] = "\xda\x7d", [0xf1dd] = "\xda\x7e", [0xf1de] = "\xda\x7f",
  [0xf1df] = "\xda\x81", [0xf1e0] = "\xda\x82", [0xf1e1] = "\xda\x83",
  [0xf1e2] = "\xda\x84", [0xf1e3] = "\xda\x85", [0xf1e4] = "\xda\x86",
  [0xf1e5] = "\xda\x87", [0xf1e6] = "\xda\x88", [0xf1e7] = "\xda\x89",
  [0xf1e8] = "\xda\x8a", [0xf1e9] = "\xda\x8b", [0xf1ea] = "\xda\x8c",
  [0xf1eb] = "\xda\x8d", [0xf1ec] = "\xda\x8e", [0xf1ed] = "\xda\x8f",
  [0xf1ee] = "\xda\x90", [0xf1ef] = "\xda\x91", [0xf1f0] = "\xda\x92",
  [0xf1f1] = "\xda\x93", [0xf1f2] = "\xda\x94", [0xf1f3] = "\xda\x95",
  [0xf1f4] = "\xda\x96", [0xf1f5] = "\xda\x97", [0xf1f6] = "\xda\x98",
  [0xf1f7] = "\xda\x99", [0xf1f8] = "\xda\x9a", [0xf1f9] = "\xda\x9b",
  [0xf1fa] = "\xda\x9c", [0xf1fb] = "\xda\x9d", [0xf1fc] = "\xda\x9e",
  [0xf1fd] = "\xda\x9f", [0xf1fe] = "\xda\xa0", [0xf1ff] = "\xda\xa1",
  [0xf200] = "\xda\xa2", [0xf201] = "\xda\xa3", [0xf202] = "\xda\xa4",
  [0xf203] = "\xda\xa5", [0xf204] = "\xda\xa6", [0xf205] = "\xda\xa7",
  [0xf206] = "\xda\xa8", [0xf207] = "\xda\xa9", [0xf208] = "\xda\xaa",
  [0xf209] = "\xda\xab", [0xf20a] = "\xda\xac", [0xf20b] = "\xda\xad",
  [0xf20c] = "\xda\xae", [0xf20d] = "\xda\xaf", [0xf20e] = "\xda\xb0",
  [0xf20f] = "\xda\xb1", [0xf210] = "\xda\xb2", [0xf211] = "\xda\xb3",
  [0xf212] = "\xda\xb4", [0xf213] = "\xda\xb5", [0xf214] = "\xda\xb6",
  [0xf215] = "\xda\xb7", [0xf216] = "\xda\xb8", [0xf217] = "\xda\xb9",
  [0xf218] = "\xda\xba", [0xf219] = "\xda\xbb", [0xf21a] = "\xda\xbc",
  [0xf21b] = "\xda\xbd", [0xf21c] = "\xda\xbe", [0xf21d] = "\xda\xbf",
  [0xf21e] = "\xda\xc0", [0xf21f] = "\xda\xc1", [0xf220] = "\xda\xc2",
  [0xf221] = "\xda\xc3", [0xf222] = "\xda\xc4", [0xf223] = "\xda\xc5",
  [0xf224] = "\xda\xc6", [0xf225] = "\xda\xc7", [0xf226] = "\xda\xc8",
  [0xf227] = "\xda\xc9", [0xf228] = "\xda\xca", [0xf229] = "\xda\xcb",
  [0xf22a] = "\xda\xcc", [0xf22b] = "\xda\xcd", [0xf22c] = "\xda\xce",
  [0xf22d] = "\xda\xcf", [0xf22e] = "\xda\xd0", [0xf22f] = "\xda\xd1",
  [0xf230] = "\xda\xd2", [0xf231] = "\xda\xd3", [0xf232] = "\xda\xd4",
  [0xf233] = "\xda\xd5", [0xf234] = "\xda\xd6", [0xf235] = "\xda\xd7",
  [0xf236] = "\xda\xd8", [0xf237] = "\xda\xd9", [0xf238] = "\xda\xda",
  [0xf239] = "\xda\xdb", [0xf23a] = "\xda\xdc", [0xf23b] = "\xda\xdd",
  [0xf23c] = "\xda\xde", [0xf23d] = "\xda\xdf", [0xf23e] = "\xda\xe0",
  [0xf23f] = "\xda\xe1", [0xf240] = "\xda\xe2", [0xf241] = "\xda\xe3",
  [0xf242] = "\xda\xe4", [0xf243] = "\xda\xe5", [0xf244] = "\xda\xe6",
  [0xf245] = "\xda\xe7", [0xf246] = "\xda\xe8", [0xf247] = "\xda\xe9",
  [0xf248] = "\xda\xea", [0xf249] = "\xda\xeb", [0xf24a] = "\xda\xec",
  [0xf24b] = "\xda\xed", [0xf24c] = "\xda\xee", [0xf24d] = "\xda\xef",
  [0xf24e] = "\xda\xf0", [0xf24f] = "\xda\xf1", [0xf250] = "\xda\xf2",
  [0xf251] = "\xda\xf3", [0xf252] = "\xda\xf4", [0xf253] = "\xda\xf5",
  [0xf254] = "\xda\xf6", [0xf255] = "\xda\xf7", [0xf256] = "\xda\xf8",
  [0xf257] = "\xda\xf9", [0xf258] = "\xda\xfa", [0xf259] = "\xda\xfb",
  [0xf25a] = "\xda\xfc", [0xf25b] = "\xda\xfd", [0xf25c] = "\xdb\x41",
  [0xf25d] = "\xdb\x42", [0xf25e] = "\xdb\x43", [0xf25f] = "\xdb\x44",
  [0xf260] = "\xdb\x45", [0xf261] = "\xdb\x46", [0xf262] = "\xdb\x47",
  [0xf263] = "\xdb\x48", [0xf264] = "\xdb\x49", [0xf265] = "\xdb\x4a",
  [0xf266] = "\xdb\x4b", [0xf267] = "\xdb\x4c", [0xf268] = "\xdb\x4d",
  [0xf269] = "\xdb\x4e", [0xf26a] = "\xdb\x4f", [0xf26b] = "\xdb\x50",
  [0xf26c] = "\xdb\x51", [0xf26d] = "\xdb\x52", [0xf26e] = "\xdb\x53",
  [0xf26f] = "\xdb\x54", [0xf270] = "\xdb\x55", [0xf271] = "\xdb\x56",
  [0xf272] = "\xdb\x57", [0xf273] = "\xdb\x58", [0xf274] = "\xdb\x59",
  [0xf275] = "\xdb\x5a", [0xf276] = "\xdb\x5b", [0xf277] = "\xdb\x5c",
  [0xf278] = "\xdb\x5d", [0xf279] = "\xdb\x5e", [0xf27a] = "\xdb\x5f",
  [0xf27b] = "\xdb\x60", [0xf27c] = "\xdb\x61", [0xf27d] = "\xdb\x62",
  [0xf27e] = "\xdb\x63", [0xf27f] = "\xdb\x64", [0xf280] = "\xdb\x65",
  [0xf281] = "\xdb\x66", [0xf282] = "\xdb\x67", [0xf283] = "\xdb\x68",
  [0xf284] = "\xdb\x69", [0xf285] = "\xdb\x6a", [0xf286] = "\xdb\x6b",
  [0xf287] = "\xdb\x6c", [0xf288] = "\xdb\x6d", [0xf289] = "\xdb\x6e",
  [0xf28a] = "\xdb\x6f", [0xf28b] = "\xdb\x70", [0xf28c] = "\xdb\x71",
  [0xf28d] = "\xdb\x72", [0xf28e] = "\xdb\x73", [0xf28f] = "\xdb\x74",
  [0xf290] = "\xdb\x75", [0xf291] = "\xdb\x76", [0xf292] = "\xdb\x77",
  [0xf293] = "\xdb\x78", [0xf294] = "\xdb\x79", [0xf295] = "\xdb\x7a",
  [0xf296] = "\xdb\x7b", [0xf297] = "\xdb\x7c", [0xf298] = "\xdb\x7d",
  [0xf299] = "\xdb\x7e", [0xf29a] = "\xdb\x7f", [0xf29b] = "\xdb\x81",
  [0xf29c] = "\xdb\x82", [0xf29d] = "\xdb\x83", [0xf29e] = "\xdb\x84",
  [0xf29f] = "\xdb\x85", [0xf2a0] = "\xdb\x86", [0xf2a1] = "\xdb\x87",
  [0xf2a2] = "\xdb\x88", [0xf2a3] = "\xdb\x89", [0xf2a4] = "\xdb\x8a",
  [0xf2a5] = "\xdb\x8b", [0xf2a6] = "\xdb\x8c", [0xf2a7] = "\xdb\x8d",
  [0xf2a8] = "\xdb\x8e", [0xf2a9] = "\xdb\x8f", [0xf2aa] = "\xdb\x90",
  [0xf2ab] = "\xdb\x91", [0xf2ac] = "\xdb\x92", [0xf2ad] = "\xdb\x93",
  [0xf2ae] = "\xdb\x94", [0xf2af] = "\xdb\x95", [0xf2b0] = "\xdb\x96",
  [0xf2b1] = "\xdb\x97", [0xf2b2] = "\xdb\x98", [0xf2b3] = "\xdb\x99",
  [0xf2b4] = "\xdb\x9a", [0xf2b5] = "\xdb\x9b", [0xf2b6] = "\xdb\x9c",
  [0xf2b7] = "\xdb\x9d", [0xf2b8] = "\xdb\x9e", [0xf2b9] = "\xdb\x9f",
  [0xf2ba] = "\xdb\xa0", [0xf2bb] = "\xdb\xa1", [0xf2bc] = "\xdb\xa2",
  [0xf2bd] = "\xdb\xa3", [0xf2be] = "\xdb\xa4", [0xf2bf] = "\xdb\xa5",
  [0xf2c0] = "\xdb\xa6", [0xf2c1] = "\xdb\xa7", [0xf2c2] = "\xdb\xa8",
  [0xf2c3] = "\xdb\xa9", [0xf2c4] = "\xdb\xaa", [0xf2c5] = "\xdb\xab",
  [0xf2c6] = "\xdb\xac", [0xf2c7] = "\xdb\xad", [0xf2c8] = "\xdb\xae",
  [0xf2c9] = "\xdb\xaf", [0xf2ca] = "\xdb\xb0", [0xf2cb] = "\xdb\xb1",
  [0xf2cc] = "\xdb\xb2", [0xf2cd] = "\xdb\xb3", [0xf2ce] = "\xdb\xb4",
  [0xf2cf] = "\xdb\xb5", [0xf2d0] = "\xdb\xb6", [0xf2d1] = "\xdb\xb7",
  [0xf2d2] = "\xdb\xb8", [0xf2d3] = "\xdb\xb9", [0xf2d4] = "\xdb\xba",
  [0xf2d5] = "\xdb\xbb", [0xf2d6] = "\xdb\xbc", [0xf2d7] = "\xdb\xbd",
  [0xf2d8] = "\xdb\xbe", [0xf2d9] = "\xdb\xbf", [0xf2da] = "\xdb\xc0",
  [0xf2db] = "\xdb\xc1", [0xf2dc] = "\xdb\xc2", [0xf2dd] = "\xdb\xc3",
  [0xf2de] = "\xdb\xc4", [0xf2df] = "\xdb\xc5", [0xf2e0] = "\xdb\xc6",
  [0xf2e1] = "\xdb\xc7", [0xf2e2] = "\xdb\xc8", [0xf2e3] = "\xdb\xc9",
  [0xf2e4] = "\xdb\xca", [0xf2e5] = "\xdb\xcb", [0xf2e6] = "\xdb\xcc",
  [0xf2e7] = "\xdb\xcd", [0xf2e8] = "\xdb\xce", [0xf2e9] = "\xdb\xcf",
  [0xf2ea] = "\xdb\xd0", [0xf2eb] = "\xdb\xd1", [0xf2ec] = "\xdb\xd2",
  [0xf2ed] = "\xdb\xd3", [0xf2ee] = "\xdb\xd4", [0xf2ef] = "\xdb\xd5",
  [0xf2f0] = "\xdb\xd6", [0xf2f1] = "\xdb\xd7", [0xf2f2] = "\xdb\xd8",
  [0xf2f3] = "\xdb\xd9", [0xf2f4] = "\xdb\xda", [0xf2f5] = "\xdb\xdb",
  [0xf2f6] = "\xdb\xdc", [0xf2f7] = "\xdb\xdd", [0xf2f8] = "\xdb\xde",
  [0xf2f9] = "\xdb\xdf", [0xf2fa] = "\xdb\xe0", [0xf2fb] = "\xdb\xe1",
  [0xf2fc] = "\xdb\xe2", [0xf2fd] = "\xdb\xe3", [0xf2fe] = "\xdb\xe4",
  [0xf2ff] = "\xdb\xe5", [0xf300] = "\xdb\xe6", [0xf301] = "\xdb\xe7",
  [0xf302] = "\xdb\xe8", [0xf303] = "\xdb\xe9", [0xf304] = "\xdb\xea",
  [0xf305] = "\xdb\xeb", [0xf306] = "\xdb\xec", [0xf307] = "\xdb\xed",
  [0xf308] = "\xdb\xee", [0xf309] = "\xdb\xef", [0xf30a] = "\xdb\xf0",
  [0xf30b] = "\xdb\xf1", [0xf30c] = "\xdb\xf2", [0xf30d] = "\xdb\xf3",
  [0xf30e] = "\xdb\xf4", [0xf30f] = "\xdb\xf5", [0xf310] = "\xdb\xf6",
  [0xf311] = "\xdb\xf7", [0xf312] = "\xdb\xf8", [0xf313] = "\xdb\xf9",
  [0xf314] = "\xdb\xfa", [0xf315] = "\xdb\xfb", [0xf316] = "\xdb\xfc",
  [0xf317] = "\xdb\xfd", [0xf318] = "\xdc\x41", [0xf319] = "\xdc\x42",
  [0xf31a] = "\xdc\x43", [0xf31b] = "\xdc\x44", [0xf31c] = "\xdc\x45",
  [0xf31d] = "\xdc\x46", [0xf31e] = "\xdc\x47", [0xf31f] = "\xdc\x48",
  [0xf320] = "\xdc\x49", [0xf321] = "\xdc\x4a", [0xf322] = "\xdc\x4b",
  [0xf323] = "\xdc\x4c", [0xf324] = "\xdc\x4d", [0xf325] = "\xdc\x4e",
  [0xf326] = "\xdc\x4f", [0xf327] = "\xdc\x50", [0xf328] = "\xdc\x51",
  [0xf329] = "\xdc\x52", [0xf32a] = "\xdc\x53", [0xf32b] = "\xdc\x54",
  [0xf32c] = "\xdc\x55", [0xf32d] = "\xdc\x56", [0xf32e] = "\xdc\x57",
  [0xf32f] = "\xdc\x58", [0xf330] = "\xdc\x59", [0xf331] = "\xdc\x5a",
  [0xf332] = "\xdc\x5b", [0xf333] = "\xdc\x5c", [0xf334] = "\xdc\x5d",
  [0xf335] = "\xdc\x5e", [0xf336] = "\xdc\x5f", [0xf337] = "\xdc\x60",
  [0xf338] = "\xdc\x61", [0xf339] = "\xdc\x62", [0xf33a] = "\xdc\x63",
  [0xf33b] = "\xdc\x64", [0xf33c] = "\xdc\x65", [0xf33d] = "\xdc\x66",
  [0xf33e] = "\xdc\x67", [0xf33f] = "\xdc\x68", [0xf340] = "\xdc\x69",
  [0xf341] = "\xdc\x6a", [0xf342] = "\xdc\x6b", [0xf343] = "\xdc\x6c",
  [0xf344] = "\xdc\x6d", [0xf345] = "\xdc\x6e", [0xf346] = "\xdc\x6f",
  [0xf347] = "\xdc\x70", [0xf348] = "\xdc\x71", [0xf349] = "\xdc\x72",
  [0xf34a] = "\xdc\x73", [0xf34b] = "\xdc\x74", [0xf34c] = "\xdc\x75",
  [0xf34d] = "\xdc\x76", [0xf34e] = "\xdc\x77", [0xf34f] = "\xdc\x78",
  [0xf350] = "\xdc\x79", [0xf351] = "\xdc\x7a", [0xf352] = "\xdc\x7b",
  [0xf353] = "\xdc\x7c", [0xf354] = "\xdc\x7d", [0xf355] = "\xdc\x7e",
  [0xf356] = "\xdc\x7f", [0xf357] = "\xdc\x81", [0xf358] = "\xdc\x82",
  [0xf359] = "\xdc\x83", [0xf35a] = "\xdc\x84", [0xf35b] = "\xdc\x85",
  [0xf35c] = "\xdc\x86", [0xf35d] = "\xdc\x87", [0xf35e] = "\xdc\x88",
  [0xf35f] = "\xdc\x89", [0xf360] = "\xdc\x8a", [0xf361] = "\xdc\x8b",
  [0xf362] = "\xdc\x8c", [0xf363] = "\xdc\x8d", [0xf364] = "\xdc\x8e",
  [0xf365] = "\xdc\x8f", [0xf366] = "\xdc\x90", [0xf367] = "\xdc\x91",
  [0xf368] = "\xdc\x92", [0xf369] = "\xdc\x93", [0xf36a] = "\xdc\x94",
  [0xf36b] = "\xdc\x95", [0xf36c] = "\xdc\x96", [0xf36d] = "\xdc\x97",
  [0xf36e] = "\xdc\x98", [0xf36f] = "\xdc\x99", [0xf370] = "\xdc\x9a",
  [0xf371] = "\xdc\x9b", [0xf372] = "\xdc\x9c", [0xf373] = "\xdc\x9d",
  [0xf374] = "\xdc\x9e", [0xf375] = "\xdc\x9f", [0xf376] = "\xdc\xa0",
  [0xf377] = "\xdc\xa1", [0xf378] = "\xdc\xa2", [0xf379] = "\xdc\xa3",
  [0xf37a] = "\xdc\xa4", [0xf37b] = "\xdc\xa5", [0xf37c] = "\xdc\xa6",
  [0xf37d] = "\xdc\xa7", [0xf37e] = "\xdc\xa8", [0xf37f] = "\xdc\xa9",
  [0xf380] = "\xdc\xaa", [0xf381] = "\xdc\xab", [0xf382] = "\xdc\xac",
  [0xf383] = "\xdc\xad", [0xf384] = "\xdc\xae", [0xf385] = "\xdc\xaf",
  [0xf386] = "\xdc\xb0", [0xf387] = "\xdc\xb1", [0xf388] = "\xdc\xb2",
  [0xf389] = "\xdc\xb3", [0xf38a] = "\xdc\xb4", [0xf38b] = "\xdc\xb5",
  [0xf38c] = "\xdc\xb6", [0xf38d] = "\xdc\xb7", [0xf38e] = "\xdc\xb8",
  [0xf38f] = "\xdc\xb9", [0xf390] = "\xdc\xba", [0xf391] = "\xdc\xbb",
  [0xf392] = "\xdc\xbc", [0xf393] = "\xdc\xbd", [0xf394] = "\xdc\xbe",
  [0xf395] = "\xdc\xbf", [0xf396] = "\xdc\xc0", [0xf397] = "\xdc\xc1",
  [0xf398] = "\xdc\xc2", [0xf399] = "\xdc\xc3", [0xf39a] = "\xdc\xc4",
  [0xf39b] = "\xdc\xc5", [0xf39c] = "\xdc\xc6", [0xf39d] = "\xdc\xc7",
  [0xf39e] = "\xdc\xc8", [0xf39f] = "\xdc\xc9", [0xf3a0] = "\xdc\xca",
  [0xf3a1] = "\xdc\xcb", [0xf3a2] = "\xdc\xcc", [0xf3a3] = "\xdc\xcd",
  [0xf3a4] = "\xdc\xce", [0xf3a5] = "\xdc\xcf", [0xf3a6] = "\xdc\xd0",
  [0xf3a7] = "\xdc\xd1", [0xf3a8] = "\xdc\xd2", [0xf3a9] = "\xdc\xd3",
  [0xf3aa] = "\xdc\xd4", [0xf3ab] = "\xdc\xd5", [0xf3ac] = "\xdc\xd6",
  [0xf3ad] = "\xdc\xd7", [0xf3ae] = "\xdc\xd8", [0xf3af] = "\xdc\xd9",
  [0xf3b0] = "\xdc\xda", [0xf3b1] = "\xdc\xdb", [0xf3b2] = "\xdc\xdc",
  [0xf3b3] = "\xdc\xdd", [0xf3b4] = "\xdc\xde", [0xf3b5] = "\xdc\xdf",
  [0xf3b6] = "\xdc\xe0", [0xf3b7] = "\xdc\xe1", [0xf3b8] = "\xdc\xe2",
  [0xf3b9] = "\xdc\xe3", [0xf3ba] = "\xdc\xe4", [0xf3bb] = "\xdc\xe5",
  [0xf3bc] = "\xdc\xe6", [0xf3bd] = "\xdc\xe7", [0xf3be] = "\xdc\xe8",
  [0xf3bf] = "\xdc\xe9", [0xf3c0] = "\xdc\xea", [0xf3c1] = "\xdc\xeb",
  [0xf3c2] = "\xdc\xec", [0xf3c3] = "\xdc\xed", [0xf3c4] = "\xdc\xee",
  [0xf3c5] = "\xdc\xef", [0xf3c6] = "\xdc\xf0", [0xf3c7] = "\xdc\xf1",
  [0xf3c8] = "\xdc\xf2", [0xf3c9] = "\xdc\xf3", [0xf3ca] = "\xdc\xf4",
  [0xf3cb] = "\xdc\xf5", [0xf3cc] = "\xdc\xf6", [0xf3cd] = "\xdc\xf7",
  [0xf3ce] = "\xdc\xf8", [0xf3cf] = "\xdc\xf9", [0xf3d0] = "\xdc\xfa",
  [0xf3d1] = "\xdc\xfb", [0xf3d2] = "\xdc\xfc", [0xf3d3] = "\xdc\xfd",
  [0xf3d4] = "\xdd\x41", [0xf3d5] = "\xdd\x42", [0xf3d6] = "\xdd\x43",
  [0xf3d7] = "\xdd\x44", [0xf3d8] = "\xdd\x45", [0xf3d9] = "\xdd\x46",
  [0xf3da] = "\xdd\x47", [0xf3db] = "\xdd\x48", [0xf3dc] = "\xdd\x49",
  [0xf3dd] = "\xdd\x4a", [0xf3de] = "\xdd\x4b", [0xf3df] = "\xdd\x4c",
  [0xf3e0] = "\xdd\x4d", [0xf3e1] = "\xdd\x4e", [0xf3e2] = "\xdd\x4f",
  [0xf3e3] = "\xdd\x50", [0xf3e4] = "\xdd\x51", [0xf3e5] = "\xdd\x52",
  [0xf3e6] = "\xdd\x53", [0xf3e7] = "\xdd\x54", [0xf3e8] = "\xdd\x55",
  [0xf3e9] = "\xdd\x56", [0xf3ea] = "\xdd\x57", [0xf3eb] = "\xdd\x58",
  [0xf3ec] = "\xdd\x59", [0xf3ed] = "\xdd\x5a", [0xf3ee] = "\xdd\x5b",
  [0xf3ef] = "\xdd\x5c", [0xf3f0] = "\xdd\x5d", [0xf3f1] = "\xdd\x5e",
  [0xf3f2] = "\xdd\x5f", [0xf3f3] = "\xdd\x60", [0xf3f4] = "\xdd\x61",
  [0xf3f5] = "\xdd\x62", [0xf3f6] = "\xdd\x63", [0xf3f7] = "\xdd\x64",
  [0xf3f8] = "\xdd\x65", [0xf3f9] = "\xdd\x66", [0xf3fa] = "\xdd\x67",
  [0xf3fb] = "\xdd\x68", [0xf3fc] = "\xdd\x69", [0xf3fd] = "\xdd\x6a",
  [0xf3fe] = "\xdd\x6b", [0xf3ff] = "\xdd\x6c", [0xf400] = "\xdd\x6d",
  [0xf401] = "\xdd\x6e", [0xf402] = "\xdd\x6f", [0xf403] = "\xdd\x70",
  [0xf404] = "\xdd\x71", [0xf405] = "\xdd\x72", [0xf406] = "\xdd\x73",
  [0xf407] = "\xdd\x74", [0xf408] = "\xdd\x75", [0xf409] = "\xdd\x76",
  [0xf40a] = "\xdd\x77", [0xf40b] = "\xdd\x78", [0xf40c] = "\xdd\x79",
  [0xf40d] = "\xdd\x7a", [0xf40e] = "\xdd\x7b", [0xf40f] = "\xdd\x7c",
  [0xf410] = "\xdd\x7d", [0xf411] = "\xdd\x7e", [0xf412] = "\xdd\x7f",
  [0xf413] = "\xdd\x81", [0xf414] = "\xdd\x82", [0xf415] = "\xdd\x83",
  [0xf416] = "\xdd\x84", [0xf417] = "\xdd\x85", [0xf418] = "\xdd\x86",
  [0xf419] = "\xdd\x87", [0xf41a] = "\xdd\x88", [0xf41b] = "\xdd\x89",
  [0xf41c] = "\xdd\x8a", [0xf41d] = "\xdd\x8b", [0xf41e] = "\xdd\x8c",
  [0xf41f] = "\xdd\x8d", [0xf420] = "\xdd\x8e", [0xf421] = "\xdd\x8f",
  [0xf422] = "\xdd\x90", [0xf423] = "\xdd\x91", [0xf424] = "\xdd\x92",
  [0xf425] = "\xdd\x93", [0xf426] = "\xdd\x94", [0xf427] = "\xdd\x95",
  [0xf428] = "\xdd\x96", [0xf429] = "\xdd\x97", [0xf42a] = "\xdd\x98",
  [0xf42b] = "\xdd\x99", [0xf42c] = "\xdd\x9a", [0xf42d] = "\xdd\x9b",
  [0xf42e] = "\xdd\x9c", [0xf42f] = "\xdd\x9d", [0xf430] = "\xdd\x9e",
  [0xf431] = "\xdd\x9f", [0xf432] = "\xdd\xa0", [0xf433] = "\xdd\xa1",
  [0xf434] = "\xdd\xa2", [0xf435] = "\xdd\xa3", [0xf436] = "\xdd\xa4",
  [0xf437] = "\xdd\xa5", [0xf438] = "\xdd\xa6", [0xf439] = "\xdd\xa7",
  [0xf43a] = "\xdd\xa8", [0xf43b] = "\xdd\xa9", [0xf43c] = "\xdd\xaa",
  [0xf43d] = "\xdd\xab", [0xf43e] = "\xdd\xac", [0xf43f] = "\xdd\xad",
  [0xf440] = "\xdd\xae", [0xf441] = "\xdd\xaf", [0xf442] = "\xdd\xb0",
  [0xf443] = "\xdd\xb1", [0xf444] = "\xdd\xb2", [0xf445] = "\xdd\xb3",
  [0xf446] = "\xdd\xb4", [0xf447] = "\xdd\xb5", [0xf448] = "\xdd\xb6",
  [0xf449] = "\xdd\xb7", [0xf44a] = "\xdd\xb8", [0xf44b] = "\xdd\xb9",
  [0xf44c] = "\xdd\xba", [0xf44d] = "\xdd\xbb", [0xf44e] = "\xdd\xbc",
  [0xf44f] = "\xdd\xbd", [0xf450] = "\xdd\xbe", [0xf451] = "\xdd\xbf",
  [0xf452] = "\xdd\xc0", [0xf453] = "\xdd\xc1", [0xf454] = "\xdd\xc2",
  [0xf455] = "\xdd\xc3", [0xf456] = "\xdd\xc4", [0xf457] = "\xdd\xc5",
  [0xf458] = "\xdd\xc6", [0xf459] = "\xdd\xc7", [0xf45a] = "\xdd\xc8",
  [0xf45b] = "\xdd\xc9", [0xf45c] = "\xdd\xca", [0xf45d] = "\xdd\xcb",
  [0xf45e] = "\xdd\xcc", [0xf45f] = "\xdd\xcd", [0xf460] = "\xdd\xce",
  [0xf461] = "\xdd\xcf", [0xf462] = "\xdd\xd0", [0xf463] = "\xdd\xd1",
  [0xf464] = "\xdd\xd2", [0xf465] = "\xdd\xd3", [0xf466] = "\xdd\xd4",
  [0xf467] = "\xdd\xd5", [0xf468] = "\xdd\xd6", [0xf469] = "\xdd\xd7",
  [0xf46a] = "\xdd\xd8", [0xf46b] = "\xdd\xd9", [0xf46c] = "\xdd\xda",
  [0xf46d] = "\xdd\xdb", [0xf46e] = "\xdd\xdc", [0xf46f] = "\xdd\xdd",
  [0xf470] = "\xdd\xde", [0xf471] = "\xdd\xdf", [0xf472] = "\xdd\xe0",
  [0xf473] = "\xdd\xe1", [0xf474] = "\xdd\xe2", [0xf475] = "\xdd\xe3",
  [0xf476] = "\xdd\xe4", [0xf477] = "\xdd\xe5", [0xf478] = "\xdd\xe6",
  [0xf479] = "\xdd\xe7", [0xf47a] = "\xdd\xe8", [0xf47b] = "\xdd\xe9",
  [0xf47c] = "\xdd\xea", [0xf47d] = "\xdd\xeb", [0xf47e] = "\xdd\xec",
  [0xf47f] = "\xdd\xed", [0xf480] = "\xdd\xee", [0xf481] = "\xdd\xef",
  [0xf482] = "\xdd\xf0", [0xf483] = "\xdd\xf1", [0xf484] = "\xdd\xf2",
  [0xf485] = "\xdd\xf3", [0xf486] = "\xdd\xf4", [0xf487] = "\xdd\xf5",
  [0xf488] = "\xdd\xf6", [0xf489] = "\xdd\xf7", [0xf48a] = "\xdd\xf8",
  [0xf48b] = "\xdd\xf9", [0xf48c] = "\xdd\xfa", [0xf48d] = "\xdd\xfb",
  [0xf48e] = "\xdd\xfc", [0xf48f] = "\xdd\xfd", [0xf490] = "\xde\x41",
  [0xf491] = "\xde\x42", [0xf492] = "\xde\x43", [0xf493] = "\xde\x44",
  [0xf494] = "\xde\x45", [0xf495] = "\xde\x46", [0xf496] = "\xde\x47",
  [0xf497] = "\xde\x48", [0xf498] = "\xde\x49", [0xf499] = "\xde\x4a",
  [0xf49a] = "\xde\x4b", [0xf49b] = "\xde\x4c", [0xf49c] = "\xde\x4d",
  [0xf49d] = "\xde\x4e", [0xf49e] = "\xde\x4f", [0xf49f] = "\xde\x50",
  [0xf4a0] = "\xde\x51", [0xf4a1] = "\xde\x52", [0xf4a2] = "\xde\x53",
  [0xf4a3] = "\xde\x54", [0xf4a4] = "\xde\x55", [0xf4a5] = "\xde\x56",
  [0xf4a6] = "\xde\x57", [0xf4a7] = "\xde\x58", [0xf4a8] = "\xde\x59",
  [0xf4a9] = "\xde\x5a", [0xf4aa] = "\xde\x5b", [0xf4ab] = "\xde\x5c",
  [0xf4ac] = "\xde\x5d", [0xf4ad] = "\xde\x5e", [0xf4ae] = "\xde\x5f",
  [0xf4af] = "\xde\x60", [0xf4b0] = "\xde\x61", [0xf4b1] = "\xde\x62",
  [0xf4b2] = "\xde\x63", [0xf4b3] = "\xde\x64", [0xf4b4] = "\xde\x65",
  [0xf4b5] = "\xde\x66", [0xf4b6] = "\xde\x67", [0xf4b7] = "\xde\x68",
  [0xf4b8] = "\xde\x69", [0xf4b9] = "\xde\x6a", [0xf4ba] = "\xde\x6b",
  [0xf4bb] = "\xde\x6c", [0xf4bc] = "\xde\x6d", [0xf4bd] = "\xde\x6e",
  [0xf4be] = "\xde\x6f", [0xf4bf] = "\xde\x70", [0xf4c0] = "\xde\x71",
  [0xf4c1] = "\xde\x72", [0xf4c2] = "\xde\x73", [0xf4c3] = "\xde\x74",
  [0xf4c4] = "\xde\x75", [0xf4c5] = "\xde\x76", [0xf4c6] = "\xde\x77",
  [0xf4c7] = "\xde\x78", [0xf4c8] = "\xde\x79", [0xf4c9] = "\xde\x7a",
  [0xf4ca] = "\xde\x7b", [0xf4cb] = "\xde\x7c", [0xf4cc] = "\xde\x7d",
  [0xf4cd] = "\xde\x7e", [0xf4ce] = "\xde\x7f", [0xf4cf] = "\xde\x81",
  [0xf4d0] = "\xde\x82", [0xf4d1] = "\xde\x83", [0xf4d2] = "\xde\x84",
  [0xf4d3] = "\xde\x85", [0xf4d4] = "\xde\x86", [0xf4d5] = "\xde\x87",
  [0xf4d6] = "\xde\x88", [0xf4d7] = "\xde\x89", [0xf4d8] = "\xde\x8a",
  [0xf4d9] = "\xde\x8b", [0xf4da] = "\xde\x8c", [0xf4db] = "\xde\x8d",
  [0xf4dc] = "\xde\x8e", [0xf4dd] = "\xde\x8f", [0xf4de] = "\xde\x90",
  [0xf4df] = "\xde\x91", [0xf4e0] = "\xde\x92", [0xf4e1] = "\xde\x93",
  [0xf4e2] = "\xde\x94", [0xf4e3] = "\xde\x95", [0xf4e4] = "\xde\x96",
  [0xf4e5] = "\xde\x97", [0xf4e6] = "\xde\x98", [0xf4e7] = "\xde\x99",
  [0xf4e8] = "\xde\x9a", [0xf4e9] = "\xde\x9b", [0xf4ea] = "\xde\x9c",
  [0xf4eb] = "\xde\x9d", [0xf4ec] = "\xde\x9e", [0xf4ed] = "\xde\x9f",
  [0xf4ee] = "\xde\xa0", [0xf4ef] = "\xde\xa1", [0xf4f0] = "\xde\xa2",
  [0xf4f1] = "\xde\xa3", [0xf4f2] = "\xde\xa4", [0xf4f3] = "\xde\xa5",
  [0xf4f4] = "\xde\xa6", [0xf4f5] = "\xde\xa7", [0xf4f6] = "\xde\xa8",
  [0xf4f7] = "\xde\xa9", [0xf4f8] = "\xde\xaa", [0xf4f9] = "\xde\xab",
  [0xf4fa] = "\xde\xac", [0xf4fb] = "\xde\xad", [0xf4fc] = "\xde\xae",
  [0xf4fd] = "\xde\xaf", [0xf4fe] = "\xde\xb0", [0xf4ff] = "\xde\xb1",
  [0xf500] = "\xde\xb2", [0xf501] = "\xde\xb3", [0xf502] = "\xde\xb4",
  [0xf503] = "\xde\xb5", [0xf504] = "\xde\xb6", [0xf505] = "\xde\xb7",
  [0xf506] = "\xde\xb8", [0xf507] = "\xde\xb9", [0xf508] = "\xde\xba",
  [0xf509] = "\xde\xbb", [0xf50a] = "\xde\xbc", [0xf50b] = "\xde\xbd",
  [0xf50c] = "\xde\xbe", [0xf50d] = "\xde\xbf", [0xf50e] = "\xde\xc0",
  [0xf50f] = "\xde\xc1", [0xf510] = "\xde\xc2", [0xf511] = "\xde\xc3",
  [0xf512] = "\xde\xc4", [0xf513] = "\xde\xc5", [0xf514] = "\xde\xc6",
  [0xf515] = "\xde\xc7", [0xf516] = "\xde\xc8", [0xf517] = "\xde\xc9",
  [0xf518] = "\xde\xca", [0xf519] = "\xde\xcb", [0xf51a] = "\xde\xcc",
  [0xf51b] = "\xde\xcd", [0xf51c] = "\xde\xce", [0xf51d] = "\xde\xcf",
  [0xf51e] = "\xde\xd0", [0xf51f] = "\xde\xd1", [0xf520] = "\xde\xd2",
  [0xf521] = "\xde\xd3", [0xf522] = "\xde\xd4", [0xf523] = "\xde\xd5",
  [0xf524] = "\xde\xd6", [0xf525] = "\xde\xd7", [0xf526] = "\xde\xd8",
  [0xf527] = "\xde\xd9", [0xf528] = "\xde\xda", [0xf529] = "\xde\xdb",
  [0xf52a] = "\xde\xdc", [0xf52b] = "\xde\xdd", [0xf52c] = "\xde\xde",
  [0xf52d] = "\xde\xdf", [0xf52e] = "\xde\xe0", [0xf52f] = "\xde\xe1",
  [0xf530] = "\xde\xe2", [0xf531] = "\xde\xe3", [0xf532] = "\xde\xe4",
  [0xf533] = "\xde\xe5", [0xf534] = "\xde\xe6", [0xf535] = "\xde\xe7",
  [0xf536] = "\xde\xe8", [0xf537] = "\xde\xe9", [0xf538] = "\xde\xea",
  [0xf539] = "\xde\xeb", [0xf53a] = "\xde\xec", [0xf53b] = "\xde\xed",
  [0xf53c] = "\xde\xee", [0xf53d] = "\xde\xef", [0xf53e] = "\xde\xf0",
  [0xf53f] = "\xde\xf1", [0xf540] = "\xde\xf2", [0xf541] = "\xde\xf3",
  [0xf542] = "\xde\xf4", [0xf543] = "\xde\xf5", [0xf544] = "\xde\xf6",
  [0xf545] = "\xde\xf7", [0xf546] = "\xde\xf8", [0xf547] = "\xde\xf9",
  [0xf548] = "\xde\xfa", [0xf549] = "\xde\xfb", [0xf54a] = "\xde\xfc",
  [0xf54b] = "\xde\xfd", [0xf54c] = "\xdf\x41", [0xf54d] = "\xdf\x42",
  [0xf54e] = "\xdf\x43", [0xf54f] = "\xdf\x44", [0xf550] = "\xdf\x45",
  [0xf551] = "\xdf\x46", [0xf552] = "\xdf\x47", [0xf553] = "\xdf\x48",
  [0xf554] = "\xdf\x49", [0xf555] = "\xdf\x4a", [0xf556] = "\xdf\x4b",
  [0xf557] = "\xdf\x4c", [0xf558] = "\xdf\x4d", [0xf559] = "\xdf\x4e",
  [0xf55a] = "\xdf\x4f", [0xf55b] = "\xdf\x50", [0xf55c] = "\xdf\x51",
  [0xf55d] = "\xdf\x52", [0xf55e] = "\xdf\x53", [0xf55f] = "\xdf\x54",
  [0xf560] = "\xdf\x55", [0xf561] = "\xdf\x56", [0xf562] = "\xdf\x57",
  [0xf563] = "\xdf\x58", [0xf564] = "\xdf\x59", [0xf565] = "\xdf\x5a",
  [0xf566] = "\xdf\x5b", [0xf567] = "\xdf\x5c", [0xf568] = "\xdf\x5d",
  [0xf569] = "\xdf\x5e", [0xf56a] = "\xdf\x5f", [0xf56b] = "\xdf\x60",
  [0xf56c] = "\xdf\x61", [0xf56d] = "\xdf\x62", [0xf56e] = "\xdf\x63",
  [0xf56f] = "\xdf\x64", [0xf570] = "\xdf\x65", [0xf571] = "\xdf\x66",
  [0xf572] = "\xdf\x67", [0xf573] = "\xdf\x68", [0xf574] = "\xdf\x69",
  [0xf575] = "\xdf\x6a", [0xf576] = "\xdf\x6b", [0xf577] = "\xdf\x6c",
  [0xf578] = "\xdf\x6d", [0xf579] = "\xdf\x6e", [0xf57a] = "\xdf\x6f",
  [0xf57b] = "\xdf\x70", [0xf57c] = "\xdf\x71", [0xf57d] = "\xdf\x72",
  [0xf57e] = "\xdf\x73", [0xf57f] = "\xdf\x74", [0xf580] = "\xdf\x75",
  [0xf581] = "\xdf\x76", [0xf582] = "\xdf\x77", [0xf583] = "\xdf\x78",
  [0xf584] = "\xdf\x79", [0xf585] = "\xdf\x7a", [0xf586] = "\xdf\x7b",
  [0xf587] = "\xdf\x7c", [0xf588] = "\xdf\x7d", [0xf589] = "\xdf\x7e",
  [0xf58a] = "\xdf\x7f", [0xf58b] = "\xdf\x81", [0xf58c] = "\xdf\x82",
  [0xf58d] = "\xdf\x83", [0xf58e] = "\xdf\x84", [0xf58f] = "\xdf\x85",
  [0xf590] = "\xdf\x86", [0xf591] = "\xdf\x87", [0xf592] = "\xdf\x88",
  [0xf593] = "\xdf\x89", [0xf594] = "\xdf\x8a", [0xf595] = "\xdf\x8b",
  [0xf596] = "\xdf\x8c", [0xf597] = "\xdf\x8d", [0xf598] = "\xdf\x8e",
  [0xf599] = "\xdf\x8f", [0xf59a] = "\xdf\x90", [0xf59b] = "\xdf\x91",
  [0xf59c] = "\xdf\x92", [0xf59d] = "\xdf\x93", [0xf59e] = "\xdf\x94",
  [0xf59f] = "\xdf\x95", [0xf5a0] = "\xdf\x96", [0xf5a1] = "\xdf\x97",
  [0xf5a2] = "\xdf\x98", [0xf5a3] = "\xdf\x99", [0xf5a4] = "\xdf\x9a",
  [0xf5a5] = "\xdf\x9b", [0xf5a6] = "\xdf\x9c", [0xf5a7] = "\xdf\x9d",
  [0xf5a8] = "\xdf\x9e", [0xf5a9] = "\xdf\x9f", [0xf5aa] = "\xdf\xa0",
  [0xf5ab] = "\xdf\xa1", [0xf5ac] = "\xdf\xa2", [0xf5ad] = "\xdf\xa3",
  [0xf5ae] = "\xdf\xa4", [0xf5af] = "\xdf\xa5", [0xf5b0] = "\xdf\xa6",
  [0xf5b1] = "\xdf\xa7", [0xf5b2] = "\xdf\xa8", [0xf5b3] = "\xdf\xa9",
  [0xf5b4] = "\xdf\xaa", [0xf5b5] = "\xdf\xab", [0xf5b6] = "\xdf\xac",
  [0xf5b7] = "\xdf\xad", [0xf5b8] = "\xdf\xae", [0xf5b9] = "\xdf\xaf",
  [0xf5ba] = "\xdf\xb0", [0xf5bb] = "\xdf\xb1", [0xf5bc] = "\xdf\xb2",
  [0xf5bd] = "\xdf\xb3", [0xf5be] = "\xdf\xb4", [0xf5bf] = "\xdf\xb5",
  [0xf5c0] = "\xdf\xb6", [0xf5c1] = "\xdf\xb7", [0xf5c2] = "\xdf\xb8",
  [0xf5c3] = "\xdf\xb9", [0xf5c4] = "\xdf\xba", [0xf5c5] = "\xdf\xbb",
  [0xf5c6] = "\xdf\xbc", [0xf5c7] = "\xdf\xbd", [0xf5c8] = "\xdf\xbe",
  [0xf5c9] = "\xdf\xbf", [0xf5ca] = "\xdf\xc0", [0xf5cb] = "\xdf\xc1",
  [0xf5cc] = "\xdf\xc2", [0xf5cd] = "\xdf\xc3", [0xf5ce] = "\xdf\xc4",
  [0xf5cf] = "\xdf\xc5", [0xf5d0] = "\xdf\xc6", [0xf5d1] = "\xdf\xc7",
  [0xf5d2] = "\xdf\xc8", [0xf5d3] = "\xdf\xc9", [0xf5d4] = "\xdf\xca",
  [0xf5d5] = "\xdf\xcb", [0xf5d6] = "\xdf\xcc", [0xf5d7] = "\xdf\xcd",
  [0xf5d8] = "\xdf\xce", [0xf5d9] = "\xdf\xcf", [0xf5da] = "\xdf\xd0",
  [0xf5db] = "\xdf\xd1", [0xf5dc] = "\xdf\xd2", [0xf5dd] = "\xdf\xd3",
  [0xf5de] = "\xdf\xd4", [0xf5df] = "\xdf\xd5", [0xf5e0] = "\xdf\xd6",
  [0xf5e1] = "\xdf\xd7", [0xf5e2] = "\xdf\xd8", [0xf5e3] = "\xdf\xd9",
  [0xf5e4] = "\xdf\xda", [0xf5e5] = "\xdf\xdb", [0xf5e6] = "\xdf\xdc",
  [0xf5e7] = "\xdf\xdd", [0xf5e8] = "\xdf\xde", [0xf5e9] = "\xdf\xdf",
  [0xf5ea] = "\xdf\xe0", [0xf5eb] = "\xdf\xe1", [0xf5ec] = "\xdf\xe2",
  [0xf5ed] = "\xdf\xe3", [0xf5ee] = "\xdf\xe4", [0xf5ef] = "\xdf\xe5",
  [0xf5f0] = "\xdf\xe6", [0xf5f1] = "\xdf\xe7", [0xf5f2] = "\xdf\xe8",
  [0xf5f3] = "\xdf\xe9", [0xf5f4] = "\xdf\xea", [0xf5f5] = "\xdf\xeb",
  [0xf5f6] = "\xdf\xec", [0xf5f7] = "\xdf\xed", [0xf5f8] = "\xdf\xee",
  [0xf5f9] = "\xdf\xef", [0xf5fa] = "\xdf\xf0", [0xf5fb] = "\xdf\xf1",
  [0xf5fc] = "\xdf\xf2", [0xf5fd] = "\xdf\xf3", [0xf5fe] = "\xdf\xf4",
  [0xf5ff] = "\xdf\xf5", [0xf600] = "\xdf\xf6", [0xf601] = "\xdf\xf7",
  [0xf602] = "\xdf\xf8", [0xf603] = "\xdf\xf9", [0xf604] = "\xdf\xfa",
  [0xf605] = "\xdf\xfb", [0xf606] = "\xdf\xfc", [0xf607] = "\xdf\xfd",
  [0xf608] = "\xe0\x41", [0xf609] = "\xe0\x42", [0xf60a] = "\xe0\x43",
  [0xf60b] = "\xe0\x44", [0xf60c] = "\xe0\x45", [0xf60d] = "\xe0\x46",
  [0xf60e] = "\xe0\x47", [0xf60f] = "\xe0\x48", [0xf610] = "\xe0\x49",
  [0xf611] = "\xe0\x4a", [0xf612] = "\xe0\x4b", [0xf613] = "\xe0\x4c",
  [0xf614] = "\xe0\x4d", [0xf615] = "\xe0\x4e", [0xf616] = "\xe0\x4f",
  [0xf617] = "\xe0\x50", [0xf618] = "\xe0\x51", [0xf619] = "\xe0\x52",
  [0xf61a] = "\xe0\x53", [0xf61b] = "\xe0\x54", [0xf61c] = "\xe0\x55",
  [0xf61d] = "\xe0\x56", [0xf61e] = "\xe0\x57", [0xf61f] = "\xe0\x58",
  [0xf620] = "\xe0\x59", [0xf621] = "\xe0\x5a", [0xf622] = "\xe0\x5b",
  [0xf623] = "\xe0\x5c", [0xf624] = "\xe0\x5d", [0xf625] = "\xe0\x5e",
  [0xf626] = "\xe0\x5f", [0xf627] = "\xe0\x60", [0xf628] = "\xe0\x61",
  [0xf629] = "\xe0\x62", [0xf62a] = "\xe0\x63", [0xf62b] = "\xe0\x64",
  [0xf62c] = "\xe0\x65", [0xf62d] = "\xe0\x66", [0xf62e] = "\xe0\x67",
  [0xf62f] = "\xe0\x68", [0xf630] = "\xe0\x69", [0xf631] = "\xe0\x6a",
  [0xf632] = "\xe0\x6b", [0xf633] = "\xe0\x6c", [0xf634] = "\xe0\x6d",
  [0xf635] = "\xe0\x6e", [0xf636] = "\xe0\x6f", [0xf637] = "\xe0\x70",
  [0xf638] = "\xe0\x71", [0xf639] = "\xe0\x72", [0xf63a] = "\xe0\x73",
  [0xf63b] = "\xe0\x74", [0xf63c] = "\xe0\x75", [0xf63d] = "\xe0\x76",
  [0xf63e] = "\xe0\x77", [0xf63f] = "\xe0\x78", [0xf640] = "\xe0\x79",
  [0xf641] = "\xe0\x7a", [0xf642] = "\xe0\x7b", [0xf643] = "\xe0\x7c",
  [0xf644] = "\xe0\x7d", [0xf645] = "\xe0\x7e", [0xf646] = "\xe0\x7f",
  [0xf647] = "\xe0\x81", [0xf648] = "\xe0\x82", [0xf649] = "\xe0\x83",
  [0xf64a] = "\xe0\x84", [0xf64b] = "\xe0\x85", [0xf64c] = "\xe0\x86",
  [0xf64d] = "\xe0\x87", [0xf64e] = "\xe0\x88", [0xf64f] = "\xe0\x89",
  [0xf650] = "\xe0\x8a", [0xf651] = "\xe0\x8b", [0xf652] = "\xe0\x8c",
  [0xf653] = "\xe0\x8d", [0xf654] = "\xe0\x8e", [0xf655] = "\xe0\x8f",
  [0xf656] = "\xe0\x90", [0xf657] = "\xe0\x91", [0xf658] = "\xe0\x92",
  [0xf659] = "\xe0\x93", [0xf65a] = "\xe0\x94", [0xf65b] = "\xe0\x95",
  [0xf65c] = "\xe0\x96", [0xf65d] = "\xe0\x97", [0xf65e] = "\xe0\x98",
  [0xf65f] = "\xe0\x99", [0xf660] = "\xe0\x9a", [0xf661] = "\xe0\x9b",
  [0xf662] = "\xe0\x9c", [0xf663] = "\xe0\x9d", [0xf664] = "\xe0\x9e",
  [0xf665] = "\xe0\x9f", [0xf666] = "\xe0\xa0", [0xf667] = "\xe0\xa1",
  [0xf668] = "\xe0\xa2", [0xf669] = "\xe0\xa3", [0xf66a] = "\xe0\xa4",
  [0xf66b] = "\xe0\xa5", [0xf66c] = "\xe0\xa6", [0xf66d] = "\xe0\xa7",
  [0xf66e] = "\xe0\xa8", [0xf66f] = "\xe0\xa9", [0xf670] = "\xe0\xaa",
  [0xf671] = "\xe0\xab", [0xf672] = "\xe0\xac", [0xf673] = "\xe0\xad",
  [0xf674] = "\xe0\xae", [0xf675] = "\xe0\xaf", [0xf676] = "\xe0\xb0",
  [0xf677] = "\xe0\xb1", [0xf678] = "\xe0\xb2", [0xf679] = "\xe0\xb3",
  [0xf67a] = "\xe0\xb4", [0xf67b] = "\xe0\xb5", [0xf67c] = "\xe0\xb6",
  [0xf67d] = "\xe0\xb7", [0xf67e] = "\xe0\xb8", [0xf67f] = "\xe0\xb9",
  [0xf680] = "\xe0\xba", [0xf681] = "\xe0\xbb", [0xf682] = "\xe0\xbc",
  [0xf683] = "\xe0\xbd", [0xf684] = "\xe0\xbe", [0xf685] = "\xe0\xbf",
  [0xf686] = "\xe0\xc0", [0xf687] = "\xe0\xc1", [0xf688] = "\xe0\xc2",
  [0xf689] = "\xe0\xc3", [0xf68a] = "\xe0\xc4", [0xf68b] = "\xe0\xc5",
  [0xf68c] = "\xe0\xc6", [0xf68d] = "\xe0\xc7", [0xf68e] = "\xe0\xc8",
  [0xf68f] = "\xe0\xc9", [0xf690] = "\xe0\xca", [0xf691] = "\xe0\xcb",
  [0xf692] = "\xe0\xcc", [0xf693] = "\xe0\xcd", [0xf694] = "\xe0\xce",
  [0xf695] = "\xe0\xcf", [0xf696] = "\xe0\xd0", [0xf697] = "\xe0\xd1",
  [0xf698] = "\xe0\xd2", [0xf699] = "\xe0\xd3", [0xf69a] = "\xe0\xd4",
  [0xf69b] = "\xe0\xd5", [0xf69c] = "\xe0\xd6", [0xf69d] = "\xe0\xd7",
  [0xf69e] = "\xe0\xd8", [0xf69f] = "\xe0\xd9", [0xf6a0] = "\xe0\xda",
  [0xf6a1] = "\xe0\xdb", [0xf6a2] = "\xe0\xdc", [0xf6a3] = "\xe0\xdd",
  [0xf6a4] = "\xe0\xde", [0xf6a5] = "\xe0\xdf", [0xf6a6] = "\xe0\xe0",
  [0xf6a7] = "\xe0\xe1", [0xf6a8] = "\xe0\xe2", [0xf6a9] = "\xe0\xe3",
  [0xf6aa] = "\xe0\xe4", [0xf6ab] = "\xe0\xe5", [0xf6ac] = "\xe0\xe6",
  [0xf6ad] = "\xe0\xe7", [0xf6ae] = "\xe0\xe8", [0xf6af] = "\xe0\xe9",
  [0xf6b0] = "\xe0\xea", [0xf6b1] = "\xe0\xeb", [0xf6b2] = "\xe0\xec",
  [0xf6b3] = "\xe0\xed", [0xf6b4] = "\xe0\xee", [0xf6b5] = "\xe0\xef",
  [0xf6b6] = "\xe0\xf0", [0xf6b7] = "\xe0\xf1", [0xf6b8] = "\xe0\xf2",
  [0xf6b9] = "\xe0\xf3", [0xf6ba] = "\xe0\xf4", [0xf6bb] = "\xe0\xf5",
  [0xf6bc] = "\xe0\xf6", [0xf6bd] = "\xe0\xf7", [0xf6be] = "\xe0\xf8",
  [0xf6bf] = "\xe0\xf9", [0xf6c0] = "\xe0\xfa", [0xf6c1] = "\xe0\xfb",
  [0xf6c2] = "\xe0\xfc", [0xf6c3] = "\xe0\xfd", [0xf6c4] = "\xe1\x41",
  [0xf6c5] = "\xe1\x42", [0xf6c6] = "\xe1\x43", [0xf6c7] = "\xe1\x44",
  [0xf6c8] = "\xe1\x45", [0xf6c9] = "\xe1\x46", [0xf6ca] = "\xe1\x47",
  [0xf6cb] = "\xe1\x48", [0xf6cc] = "\xe1\x49", [0xf6cd] = "\xe1\x4a",
  [0xf6ce] = "\xe1\x4b", [0xf6cf] = "\xe1\x4c", [0xf6d0] = "\xe1\x4d",
  [0xf6d1] = "\xe1\x4e", [0xf6d2] = "\xe1\x4f", [0xf6d3] = "\xe1\x50",
  [0xf6d4] = "\xe1\x51", [0xf6d5] = "\xe1\x52", [0xf6d6] = "\xe1\x53",
  [0xf6d7] = "\xe1\x54", [0xf6d8] = "\xe1\x55", [0xf6d9] = "\xe1\x56",
  [0xf6da] = "\xe1\x57", [0xf6db] = "\xe1\x58", [0xf6dc] = "\xe1\x59",
  [0xf6dd] = "\xe1\x5a", [0xf6de] = "\xe1\x5b", [0xf6df] = "\xe1\x5c",
  [0xf6e0] = "\xe1\x5d", [0xf6e1] = "\xe1\x5e", [0xf6e2] = "\xe1\x5f",
  [0xf6e3] = "\xe1\x60", [0xf6e4] = "\xe1\x61", [0xf6e5] = "\xe1\x62",
  [0xf6e6] = "\xe1\x63", [0xf6e7] = "\xe1\x64", [0xf6e8] = "\xe1\x65",
  [0xf6e9] = "\xe1\x66", [0xf6ea] = "\xe1\x67", [0xf6eb] = "\xe1\x68",
  [0xf6ec] = "\xe1\x69", [0xf6ed] = "\xe1\x6a", [0xf6ee] = "\xe1\x6b",
  [0xf6ef] = "\xe1\x6c", [0xf6f0] = "\xe1\x6d", [0xf6f1] = "\xe1\x6e",
  [0xf6f2] = "\xe1\x6f", [0xf6f3] = "\xe1\x70", [0xf6f4] = "\xe1\x71",
  [0xf6f5] = "\xe1\x72", [0xf6f6] = "\xe1\x73", [0xf6f7] = "\xe1\x74",
  [0xf6f8] = "\xe1\x75", [0xf6f9] = "\xe1\x76", [0xf6fa] = "\xe1\x77",
  [0xf6fb] = "\xe1\x78", [0xf6fc] = "\xe1\x79", [0xf6fd] = "\xe1\x7a",
  [0xf6fe] = "\xe1\x7b", [0xf6ff] = "\xe1\x7c", [0xf700] = "\xe1\x7d",
  [0xf701] = "\xe1\x7e", [0xf702] = "\xe1\x7f", [0xf703] = "\xe1\x81",
  [0xf704] = "\xe1\x82", [0xf705] = "\xe1\x83", [0xf706] = "\xe1\x84",
  [0xf707] = "\xe1\x85", [0xf708] = "\xe1\x86", [0xf709] = "\xe1\x87",
  [0xf70a] = "\xe1\x88", [0xf70b] = "\xe1\x89", [0xf70c] = "\xe1\x8a",
  [0xf70d] = "\xe1\x8b", [0xf70e] = "\xe1\x8c", [0xf70f] = "\xe1\x8d",
  [0xf710] = "\xe1\x8e", [0xf711] = "\xe1\x8f", [0xf712] = "\xe1\x90",
  [0xf713] = "\xe1\x91", [0xf714] = "\xe1\x92", [0xf715] = "\xe1\x93",
  [0xf716] = "\xe1\x94", [0xf717] = "\xe1\x95", [0xf718] = "\xe1\x96",
  [0xf719] = "\xe1\x97", [0xf71a] = "\xe1\x98", [0xf71b] = "\xe1\x99",
  [0xf71c] = "\xe1\x9a", [0xf71d] = "\xe1\x9b", [0xf71e] = "\xe1\x9c",
  [0xf71f] = "\xe1\x9d", [0xf720] = "\xe1\x9e", [0xf721] = "\xe1\x9f",
  [0xf722] = "\xe1\xa0", [0xf723] = "\xe1\xa1", [0xf724] = "\xe1\xa2",
  [0xf725] = "\xe1\xa3", [0xf726] = "\xe1\xa4", [0xf727] = "\xe1\xa5",
  [0xf728] = "\xe1\xa6", [0xf729] = "\xe1\xa7", [0xf72a] = "\xe1\xa8",
  [0xf72b] = "\xe1\xa9", [0xf72c] = "\xe1\xaa", [0xf72d] = "\xe1\xab",
  [0xf72e] = "\xe1\xac", [0xf72f] = "\xe1\xad", [0xf730] = "\xe1\xae",
  [0xf731] = "\xe1\xaf", [0xf732] = "\xe1\xb0", [0xf733] = "\xe1\xb1",
  [0xf734] = "\xe1\xb2", [0xf735] = "\xe1\xb3", [0xf736] = "\xe1\xb4",
  [0xf737] = "\xe1\xb5", [0xf738] = "\xe1\xb6", [0xf739] = "\xe1\xb7",
  [0xf73a] = "\xe1\xb8", [0xf73b] = "\xe1\xb9", [0xf73c] = "\xe1\xba",
  [0xf73d] = "\xe1\xbb", [0xf73e] = "\xe1\xbc", [0xf73f] = "\xe1\xbd",
  [0xf740] = "\xe1\xbe", [0xf741] = "\xe1\xbf", [0xf742] = "\xe1\xc0",
  [0xf743] = "\xe1\xc1", [0xf744] = "\xe1\xc2", [0xf745] = "\xe1\xc3",
  [0xf746] = "\xe1\xc4", [0xf747] = "\xe1\xc5", [0xf748] = "\xe1\xc6",
  [0xf749] = "\xe1\xc7", [0xf74a] = "\xe1\xc8", [0xf74b] = "\xe1\xc9",
  [0xf74c] = "\xe1\xca", [0xf74d] = "\xe1\xcb", [0xf74e] = "\xe1\xcc",
  [0xf74f] = "\xe1\xcd", [0xf750] = "\xe1\xce", [0xf751] = "\xe1\xcf",
  [0xf752] = "\xe1\xd0", [0xf753] = "\xe1\xd1", [0xf754] = "\xe1\xd2",
  [0xf755] = "\xe1\xd3", [0xf756] = "\xe1\xd4", [0xf757] = "\xe1\xd5",
  [0xf758] = "\xe1\xd6", [0xf759] = "\xe1\xd7", [0xf75a] = "\xe1\xd8",
  [0xf75b] = "\xe1\xd9", [0xf75c] = "\xe1\xda", [0xf75d] = "\xe1\xdb",
  [0xf75e] = "\xe1\xdc", [0xf75f] = "\xe1\xdd", [0xf760] = "\xe1\xde",
  [0xf761] = "\xe1\xdf", [0xf762] = "\xe1\xe0", [0xf763] = "\xe1\xe1",
  [0xf764] = "\xe1\xe2", [0xf765] = "\xe1\xe3", [0xf766] = "\xe1\xe4",
  [0xf767] = "\xe1\xe5", [0xf768] = "\xe1\xe6", [0xf769] = "\xe1\xe7",
  [0xf76a] = "\xe1\xe8", [0xf76b] = "\xe1\xe9", [0xf76c] = "\xe1\xea",
  [0xf76d] = "\xe1\xeb", [0xf76e] = "\xe1\xec", [0xf76f] = "\xe1\xed",
  [0xf770] = "\xe1\xee", [0xf771] = "\xe1\xef", [0xf772] = "\xe1\xf0",
  [0xf773] = "\xe1\xf1", [0xf774] = "\xe1\xf2", [0xf775] = "\xe1\xf3",
  [0xf776] = "\xe1\xf4", [0xf777] = "\xe1\xf5", [0xf778] = "\xe1\xf6",
  [0xf779] = "\xe1\xf7", [0xf77a] = "\xe1\xf8", [0xf77b] = "\xe1\xf9",
  [0xf77c] = "\xe1\xfa", [0xf77d] = "\xe1\xfb", [0xf77e] = "\xe1\xfc",
  [0xf77f] = "\xe1\xfd", [0xf780] = "\xe2\x41", [0xf781] = "\xe2\x42",
  [0xf782] = "\xe2\x43", [0xf783] = "\xe2\x44", [0xf784] = "\xe2\x45",
  [0xf785] = "\xe2\x46", [0xf786] = "\xe2\x47", [0xf787] = "\xe2\x48",
  [0xf788] = "\xe2\x49", [0xf789] = "\xe2\x4a", [0xf78a] = "\xe2\x4b",
  [0xf78b] = "\xe2\x4c", [0xf78c] = "\xe2\x4d", [0xf78d] = "\xe2\x4e",
  [0xf78e] = "\xe2\x4f", [0xf78f] = "\xe2\x50", [0xf790] = "\xe2\x51",
  [0xf791] = "\xe2\x52", [0xf792] = "\xe2\x53", [0xf793] = "\xe2\x54",
  [0xf794] = "\xe2\x55", [0xf795] = "\xe2\x56", [0xf796] = "\xe2\x57",
  [0xf797] = "\xe2\x58", [0xf798] = "\xe2\x59", [0xf799] = "\xe2\x5a",
  [0xf79a] = "\xe2\x5b", [0xf79b] = "\xe2\x5c", [0xf79c] = "\xe2\x5d",
  [0xf79d] = "\xe2\x5e", [0xf79e] = "\xe2\x5f", [0xf79f] = "\xe2\x60",
  [0xf7a0] = "\xe2\x61", [0xf7a1] = "\xe2\x62", [0xf7a2] = "\xe2\x63",
  [0xf7a3] = "\xe2\x64", [0xf7a4] = "\xe2\x65", [0xf7a5] = "\xe2\x66",
  [0xf7a6] = "\xe2\x67", [0xf7a7] = "\xe2\x68", [0xf7a8] = "\xe2\x69",
  [0xf7a9] = "\xe2\x6a", [0xf7aa] = "\xe2\x6b", [0xf7ab] = "\xe2\x6c",
  [0xf7ac] = "\xe2\x6d", [0xf7ad] = "\xe2\x6e", [0xf7ae] = "\xe2\x6f",
  [0xf7af] = "\xe2\x70", [0xf7b0] = "\xe2\x71", [0xf7b1] = "\xe2\x72",
  [0xf7b2] = "\xe2\x73", [0xf7b3] = "\xe2\x74", [0xf7b4] = "\xe2\x75",
  [0xf7b5] = "\xe2\x76", [0xf7b6] = "\xe2\x77", [0xf7b7] = "\xe2\x78",
  [0xf7b8] = "\xe2\x79", [0xf7b9] = "\xe2\x7a", [0xf7ba] = "\xe2\x7b",
  [0xf7bb] = "\xe2\x7c", [0xf7bc] = "\xe2\x7d", [0xf7bd] = "\xe2\x7e",
  [0xf7be] = "\xe2\x7f", [0xf7bf] = "\xe2\x81", [0xf7c0] = "\xe2\x82",
  [0xf7c1] = "\xe2\x83", [0xf7c2] = "\xe2\x84", [0xf7c3] = "\xe2\x85",
  [0xf7c4] = "\xe2\x86", [0xf7c5] = "\xe2\x87", [0xf7c6] = "\xe2\x88",
  [0xf7c7] = "\xe2\x89", [0xf7c8] = "\xe2\x8a", [0xf7c9] = "\xe2\x8b",
  [0xf7ca] = "\xe2\x8c", [0xf7cb] = "\xe2\x8d", [0xf7cc] = "\xe2\x8e",
  [0xf7cd] = "\xe2\x8f", [0xf7ce] = "\xe2\x90", [0xf7cf] = "\xe2\x91",
  [0xf7d0] = "\xe2\x92", [0xf7d1] = "\xe2\x93", [0xf7d2] = "\xe2\x94",
  [0xf7d3] = "\xe2\x95", [0xf7d4] = "\xe2\x96", [0xf7d5] = "\xe2\x97",
  [0xf7d6] = "\xe2\x98", [0xf7d7] = "\xe2\x99", [0xf7d8] = "\xe2\x9a",
  [0xf7d9] = "\xe2\x9b", [0xf7da] = "\xe2\x9c", [0xf7db] = "\xe2\x9d",
  [0xf7dc] = "\xe2\x9e", [0xf7dd] = "\xe2\x9f", [0xf7de] = "\xe2\xa0",
  [0xf7df] = "\xe2\xa1", [0xf7e0] = "\xe2\xa2", [0xf7e1] = "\xe2\xa3",
  [0xf7e2] = "\xe2\xa4", [0xf7e3] = "\xe2\xa5", [0xf7e4] = "\xe2\xa6",
  [0xf7e5] = "\xe2\xa7", [0xf7e6] = "\xe2\xa8", [0xf7e7] = "\xe2\xa9",
  [0xf7e8] = "\xe2\xaa", [0xf7e9] = "\xe2\xab", [0xf7ea] = "\xe2\xac",
  [0xf7eb] = "\xe2\xad", [0xf7ec] = "\xe2\xae", [0xf7ed] = "\xe2\xaf",
  [0xf7ee] = "\xe2\xb0", [0xf7ef] = "\xe2\xb1", [0xf7f0] = "\xe2\xb2",
  [0xf7f1] = "\xe2\xb3", [0xf7f2] = "\xe2\xb4", [0xf7f3] = "\xe2\xb5",
  [0xf7f4] = "\xe2\xb6", [0xf7f5] = "\xe2\xb7", [0xf7f6] = "\xe2\xb8",
  [0xf7f7] = "\xe2\xb9", [0xf7f8] = "\xe2\xba", [0xf7f9] = "\xe2\xbb",
  [0xf7fa] = "\xe2\xbc", [0xf7fb] = "\xe2\xbd", [0xf7fc] = "\xe2\xbe",
  [0xf7fd] = "\xe2\xbf", [0xf7fe] = "\xe2\xc0", [0xf7ff] = "\xe2\xc1",
  [0xf800] = "\xe2\xc2", [0xf801] = "\xe2\xc3", [0xf802] = "\xe2\xc4",
  [0xf803] = "\xe2\xc5", [0xf804] = "\xe2\xc6", [0xf805] = "\xe2\xc7",
  [0xf806] = "\xe2\xc8", [0xf807] = "\xe2\xc9", [0xf808] = "\xe2\xca",
  [0xf809] = "\xe2\xcb", [0xf80a] = "\xe2\xcc", [0xf80b] = "\xe2\xcd",
  [0xf80c] = "\xe2\xce", [0xf80d] = "\xe2\xcf", [0xf80e] = "\xe2\xd0",
  [0xf80f] = "\xe2\xd1", [0xf810] = "\xe2\xd2", [0xf811] = "\xe2\xd3",
  [0xf812] = "\xe2\xd4", [0xf813] = "\xe2\xd5", [0xf814] = "\xe2\xd6",
  [0xf815] = "\xe2\xd7", [0xf816] = "\xe2\xd8", [0xf817] = "\xe2\xd9",
  [0xf818] = "\xe2\xda", [0xf819] = "\xe2\xdb", [0xf81a] = "\xe2\xdc",
  [0xf81b] = "\xe2\xdd", [0xf81c] = "\xe2\xde", [0xf81d] = "\xe2\xdf",
  [0xf81e] = "\xe2\xe0", [0xf81f] = "\xe2\xe1", [0xf820] = "\xe2\xe2",
  [0xf821] = "\xe2\xe3", [0xf822] = "\xe2\xe4", [0xf823] = "\xe2\xe5",
  [0xf824] = "\xe2\xe6", [0xf825] = "\xe2\xe7", [0xf826] = "\xe2\xe8",
  [0xf827] = "\xe2\xe9", [0xf828] = "\xe2\xea", [0xf829] = "\xe2\xeb",
  [0xf82a] = "\xe2\xec", [0xf82b] = "\xe2\xed", [0xf82c] = "\xe2\xee",
  [0xf82d] = "\xe2\xef", [0xf82e] = "\xe2\xf0", [0xf82f] = "\xe2\xf1",
  [0xf830] = "\xe2\xf2", [0xf831] = "\xe2\xf3", [0xf832] = "\xe2\xf4",
  [0xf833] = "\xe2\xf5", [0xf834] = "\xe2\xf6", [0xf835] = "\xe2\xf7",
  [0xf836] = "\xe2\xf8", [0xf837] = "\xe2\xf9", [0xf838] = "\xe2\xfa",
  [0xf839] = "\xe2\xfb", [0xf83a] = "\xe2\xfc", [0xf83b] = "\xe2\xfd",
  [0xf83e] = "\x44\x5c", [0xf83f] = "\x46\xa8", [0xf840] = "\x46\xa9",
  [0xf841] = "\x46\xaa", [0xf842] = "\x46\xab", [0xfa0c] = "\x69\x4b",
  [0xfa0d] = "\x7a\xa4", [0xfe30] = "\x47\x41", [0xfe31] = "\x46\xa7",
  [0xfe32] = "\x47\x49", [0xfe33] = "\x46\xb6", [0xfe34] = "\x46\xbc",
  [0xfe35] = "\x46\xac", [0xfe36] = "\x46\xad", [0xfe37] = "\x46\xae",
  [0xfe38] = "\x46\xaf", [0xfe39] = "\x46\xb0", [0xfe3a] = "\x46\xb1",
  [0xfe3b] = "\x46\xa4", [0xfe3c] = "\x46\xa5", [0xfe3d] = "\x46\xb2",
  [0xfe3e] = "\x46\xb3", [0xfe3f] = "\x46\xb4", [0xfe40] = "\x46\xb5",
  [0xfe41] = "\x46\xa0", [0xfe42] = "\x46\xa1", [0xfe43] = "\x46\xa2",
  [0xfe44] = "\x46\xa3", [0xfe49] = "\x46\xbe", [0xfe4a] = "\x46\xbf",
  [0xfe4b] = "\x46\xc2", [0xfe4c] = "\x46\xc3", [0xfe4d] = "\x46\xc0",
  [0xfe4e] = "\x46\xc1", [0xfe4f] = "\x46\xbd", [0xfe50] = "\x47\x42",
  [0xfe51] = "\x47\x43", [0xfe52] = "\x47\x44", [0xfe54] = "\x47\x45",
  [0xfe55] = "\x47\x46", [0xfe56] = "\x47\x47", [0xfe57] = "\x47\x48",
  [0xfe58] = "\x47\x4a", [0xfe59] = "\x47\x4b", [0xfe5a] = "\x47\x4c",
  [0xfe5b] = "\x47\x4d", [0xfe5c] = "\x47\x4e", [0xfe5d] = "\x47\x4f",
  [0xfe5e] = "\x47\x50", [0xfe5f] = "\x47\x53", [0xfe60] = "\x47\x54",
  [0xfe61] = "\x46\xc4", [0xfe62] = "\x47\x55", [0xfe63] = "\x47\x56",
  [0xfe64] = "\x47\x57", [0xfe65] = "\x47\x58", [0xfe66] = "\x47\x59",
  [0xfe68] = "\x47\x5a", [0xfe69] = "\x47\x5b", [0xfe6a] = "\x47\x5c",
  [0xfe6b] = "\x47\x5d", [0xff01] = "\x42\x5a", [0xff02] = "\x42\x7f",
  [0xff03] = "\x42\x7b", [0xff04] = "\x42\xe0", [0xff05] = "\x42\x6c",
  [0xff06] = "\x42\x50", [0xff07] = "\x42\x7d", [0xff08] = "\x42\x4d",
  [0xff09] = "\x42\x5d", [0xff0a] = "\x46\xb8", [0xff0b] = "\x42\x4e",
  [0xff0c] = "\x42\x6b", [0xff0d] = "\x42\x60", [0xff0e] = "\x42\x4b",
  [0xff0f] = "\x42\x61", [0xff10] = "\x42\xf0", [0xff11] = "\x42\xf1",
  [0xff12] = "\x42\xf2", [0xff13] = "\x42\xf3", [0xff14] = "\x42\xf4",
  [0xff15] = "\x42\xf5", [0xff16] = "\x42\xf6", [0xff17] = "\x42\xf7",
  [0xff18] = "\x42\xf8", [0xff19] = "\x42\xf9", [0xff1a] = "\x42\x7a",
  [0xff1b] = "\x42\x5e", [0xff1c] = "\x42\x4c", [0xff1d] = "\x42\x7e",
  [0xff1e] = "\x42\x6e", [0xff1f] = "\x42\x6f", [0xff20] = "\x42\x7c",
  [0xff21] = "\x42\xc1", [0xff22] = "\x42\xc2", [0xff23] = "\x42\xc3",
  [0xff24] = "\x42\xc4", [0xff25] = "\x42\xc5", [0xff26] = "\x42\xc6",
  [0xff27] = "\x42\xc7", [0xff28] = "\x42\xc8", [0xff29] = "\x42\xc9",
  [0xff2a] = "\x42\xd1", [0xff2b] = "\x42\xd2", [0xff2c] = "\x42\xd3",
  [0xff2d] = "\x42\xd4", [0xff2e] = "\x42\xd5", [0xff2f] = "\x42\xd6",
  [0xff30] = "\x42\xd7", [0xff31] = "\x42\xd8", [0xff32] = "\x42\xd9",
  [0xff33] = "\x42\xe2", [0xff34] = "\x42\xe3", [0xff35] = "\x42\xe4",
  [0xff36] = "\x42\xe5", [0xff37] = "\x42\xe6", [0xff38] = "\x42\xe7",
  [0xff39] = "\x42\xe8", [0xff3a] = "\x42\xe9", [0xff3b] = "\x44\x44",
  [0xff3c] = "\x43\xe0", [0xff3d] = "\x44\x45", [0xff3e] = "\x44\x70",
  [0xff3f] = "\x42\x6d", [0xff41] = "\x42\x81", [0xff42] = "\x42\x82",
  [0xff43] = "\x42\x83", [0xff44] = "\x42\x84", [0xff45] = "\x42\x85",
  [0xff46] = "\x42\x86", [0xff47] = "\x42\x87", [0xff48] = "\x42\x88",
  [0xff49] = "\x42\x89", [0xff4a] = "\x42\x91", [0xff4b] = "\x42\x92",
  [0xff4c] = "\x42\x93", [0xff4d] = "\x42\x94", [0xff4e] = "\x42\x95",
  [0xff4f] = "\x42\x96", [0xff50] = "\x42\x97", [0xff51] = "\x42\x98",
  [0xff52] = "\x42\x99", [0xff53] = "\x42\xa2", [0xff54] = "\x42\xa3",
  [0xff55] = "\x42\xa4", [0xff56] = "\x42\xa5", [0xff57] = "\x42\xa6",
  [0xff58] = "\x42\xa7", [0xff59] = "\x42\xa8", [0xff5a] = "\x42\xa9",
  [0xff5b] = "\x42\xc0", [0xff5c] = "\x42\x4f", [0xff5d] = "\x42\xd0",
  [0xff5e] = "\x43\xa1", [0xffe0] = "\x43\x4a", [0xffe1] = "\x42\x4a",
  [0xffe2] = "\x42\x5f", [0xffe3] = "\x47\x51", [0xffe4] = "\x42\x6a",
  [0xffe5] = "\x42\x5b"
};

static inline uint32_t
ibm937db_to_ucs4 (unsigned char ch1, unsigned char ch2)
{
  int idx;
  idx = ch1 * 0x100 + ch2;
  return __ibm937db_to_ucs4[idx];
}

#endif /* ibm937.h */
