
// This file generated by compiling the following source (runtime.c) as follows:
//    clang -S -emit-llvm -target nvptr runtime.c
//    opt -S -mem2reg runtime.ll -o runtime.opt.ll
// The resulting LLVM-IR is stripped of its datalayout and replaced with one
// compatible with DXIL.

// runtime.c
#if 0
#include <stddef.h>

static const int STACK_SIZE_IN_BYTES = 1024;

typedef float float3 __attribute__((vector_size(3*sizeof(float))));
typedef float float4 __attribute__((vector_size(4*sizeof(float))));
typedef float float12 __attribute__((vector_size(12*sizeof(float))));
typedef float (M3x4)[12];
typedef int   (StackType)[STACK_SIZE_IN_BYTES/sizeof(int)];
typedef unsigned char byte;


typedef struct RuntimeDataStruct
{
  int DispatchRaysIndex[2];
  int DispatchRaysDimensions[2];

  float RayTMin;
  float RayTCurrent;
  unsigned RayFlags;
  float WorldRayOrigin[3];
  float WorldRayDirection[3];
  float ObjectRayOrigin[3];
  float ObjectRayDirection[3];
  M3x4 ObjectToWorld;
  M3x4 WorldToObject;

  unsigned PrimitiveIndex;
  unsigned InstanceIndex;
  unsigned InstanceID;
  unsigned HitKind;
  unsigned ShaderRecordOffset;


  // Pending hit values - accessed in anyHit and intersection shaders before a hit has been committed
  float PendingRayTCurrent;
  unsigned PendingPrimitiveIndex;
  unsigned PendingInstanceIndex;
  unsigned PendingInstanceID;
  unsigned PendingHitKind;
  unsigned PendingShaderRecordOffset; 

  int GroupIndex; 
  int AnyHitResult;
  int AnyHitStateId;  // Originally temporary. We needed to avoid resource usage
                      // in ReportHit() because of linking issues so weset the value here first. 
                      // May be worth retaining to cache the value when fetching the intersection 
                      // stateId (fetch them both at once). 

  int PayloadOffset;            
  int CommittedAttrOffset;      
  int PendingAttrOffset;        
  
  int StackOffset; // offset from the start of the stack
  StackType* Stack;
} RuntimeData;

typedef RuntimeData* RuntimeDataType;

typedef struct TraceRaySpills_ClosestHit
{
  float RayTMin;                 
  float RayTCurrent;             
  unsigned RayFlags;             
  float WorldRayOrigin[3];       
  float WorldRayDirection[3];    
  float ObjectRayOrigin[3];      
  float ObjectRayDirection[3];   

  unsigned PrimitiveIndex;       
  unsigned InstanceIndex;        
  unsigned InstanceID;           
  unsigned HitKind;              
  unsigned ShaderRecordOffset;
} TraceRaySpills_ClosestHit;

typedef struct TraceRaySpills_Miss
{
  float RayTMin;                 
  float RayTCurrent;             
  unsigned RayFlags;             
  float WorldRayOrigin[3];       
  float WorldRayDirection[3];    
            
  unsigned ShaderRecordOffset;
} TraceRaySpills_Miss;

#define REF(x) (runtimeData->x)
#define REF_FLT(x) (runtimeData->x)
#define REF_STACK(offset)                                                      \
  ((*runtimeData->Stack)[runtimeData->StackOffset + offset])
#define REF_FLT_OFS(x, offset) (runtimeData->x[offset])

// Return next stateID
int rewrite_dispatch(RuntimeDataType runtimeData, int stateID);
void* rewrite_setLaunchParams(RuntimeDataType runtimeData, unsigned dimx, unsigned dimy);
unsigned rewrite_getStackSize(void);
StackType* rewrite_createStack(void);

void stackInit(RuntimeDataType runtimeData, StackType* theStack, unsigned stackSize)
{
  REF(Stack) = theStack;
  REF(StackOffset) = stackSize/sizeof(int) - 1;
  REF(PayloadOffset)       = 1111; // recognizable bogus values
  REF(CommittedAttrOffset) = 2222;
  REF(PendingAttrOffset)   = 3333;
}

void stackFramePush(RuntimeDataType runtimeData, int size)
{
  REF(StackOffset) -= size;
}

void stackFramePop(RuntimeDataType runtimeData, int size)
{ 
  REF(StackOffset) += size;
}

int stackFrameOffset(RuntimeDataType runtimeData)
{
  return REF(StackOffset);
}

int payloadOffset(RuntimeDataType runtimeData)
{
  return REF(PayloadOffset);
}

int committedAttrOffset(RuntimeDataType runtimeData)
{
  return REF(CommittedAttrOffset);
}

int pendingAttrOffset(RuntimeDataType runtimeData)
{
  return REF(PendingAttrOffset);
}

int* stackIntPtr(RuntimeDataType runtimeData, int baseOffset, int offset)
{
  return &(*runtimeData->Stack)[baseOffset + offset];
}


void traceFramePush(RuntimeDataType runtimeData, int attrSize)
{
  // Save the old payload and attribute offsets
  REF_STACK(-1) = REF(CommittedAttrOffset);
  REF_STACK(-2) = REF(PendingAttrOffset);

  // Set new offsets
  REF(CommittedAttrOffset) = REF(StackOffset) - 2 - attrSize; 
  REF(PendingAttrOffset)   = REF(StackOffset) - 2 - 2 * attrSize; 
}

void traceFramePop(RuntimeDataType runtimeData)
{
  // Restore the old attribute offsets
  REF(CommittedAttrOffset) = REF_STACK(-1); 
  REF(PendingAttrOffset) = REF_STACK(-2);
}

void traceRaySave_ClosestHit(RuntimeDataType runtimeData, TraceRaySpills_ClosestHit* spills)
{
  spills->RayFlags              = REF(RayFlags);
  spills->RayTCurrent           = REF_FLT(RayTCurrent);
  spills->RayTMin               = REF_FLT(RayTMin);
  spills->WorldRayOrigin[0]     = REF_FLT(WorldRayOrigin[0]);
  spills->WorldRayOrigin[1]     = REF_FLT(WorldRayOrigin[1]);
  spills->WorldRayOrigin[2]     = REF_FLT(WorldRayOrigin[2]);
  spills->WorldRayDirection[0]  = REF_FLT(WorldRayDirection[0]);
  spills->WorldRayDirection[1]  = REF_FLT(WorldRayDirection[1]);
  spills->WorldRayDirection[2]  = REF_FLT(WorldRayDirection[2]);
  spills->ObjectRayOrigin[0]    = REF_FLT(ObjectRayOrigin[0]);
  spills->ObjectRayOrigin[1]    = REF_FLT(ObjectRayOrigin[1]);
  spills->ObjectRayOrigin[2]    = REF_FLT(ObjectRayOrigin[2]);
  spills->ObjectRayDirection[0] = REF_FLT(ObjectRayDirection[0]);
  spills->ObjectRayDirection[1] = REF_FLT(ObjectRayDirection[1]);
  spills->ObjectRayDirection[2] = REF_FLT(ObjectRayDirection[2]);

  spills->PrimitiveIndex      = REF(PrimitiveIndex);       
  spills->InstanceIndex       = REF(InstanceIndex);        
  spills->InstanceID          = REF(InstanceID);           
  spills->HitKind             = REF(HitKind);              
  spills->ShaderRecordOffset  = REF(ShaderRecordOffset);  
}

void traceRayRestore_ClosestHit(RuntimeDataType runtimeData, TraceRaySpills_ClosestHit* spills)
{
  REF(RayFlags)                  = spills->RayFlags;               
  REF_FLT(RayTCurrent)           = spills->RayTCurrent;            
  REF_FLT(RayTMin)               = spills->RayTMin;                
  REF_FLT(WorldRayOrigin[0])     = spills->WorldRayOrigin[0];      
  REF_FLT(WorldRayOrigin[1])     = spills->WorldRayOrigin[1];      
  REF_FLT(WorldRayOrigin[2])     = spills->WorldRayOrigin[2];      
  REF_FLT(WorldRayDirection[0])  = spills->WorldRayDirection[0];   
  REF_FLT(WorldRayDirection[1])  = spills->WorldRayDirection[1];   
  REF_FLT(WorldRayDirection[2])  = spills->WorldRayDirection[2];   
  REF_FLT(ObjectRayOrigin[0])    = spills->ObjectRayOrigin[0];     
  REF_FLT(ObjectRayOrigin[1])    = spills->ObjectRayOrigin[1];     
  REF_FLT(ObjectRayOrigin[2])    = spills->ObjectRayOrigin[2];     
  REF_FLT(ObjectRayDirection[0]) = spills->ObjectRayDirection[0];  
  REF_FLT(ObjectRayDirection[1]) = spills->ObjectRayDirection[1];  
  REF_FLT(ObjectRayDirection[2]) = spills->ObjectRayDirection[2];  

  REF(PrimitiveIndex)     = spills->PrimitiveIndex;          
  REF(InstanceIndex)      = spills->InstanceIndex;           
  REF(InstanceID)         = spills->InstanceID;              
  REF(HitKind)            = spills->HitKind;                 
  REF(ShaderRecordOffset) = spills->ShaderRecordOffset;    
}

void traceRaySave_Miss(RuntimeDataType runtimeData, TraceRaySpills_Miss* spills)
{
  spills->RayFlags              = REF(RayFlags);
  spills->RayTCurrent           = REF_FLT(RayTCurrent);
  spills->RayTMin               = REF_FLT(RayTMin);
  spills->WorldRayOrigin[0]     = REF_FLT(WorldRayOrigin[0]);
  spills->WorldRayOrigin[1]     = REF_FLT(WorldRayOrigin[1]);
  spills->WorldRayOrigin[2]     = REF_FLT(WorldRayOrigin[2]);
  spills->WorldRayDirection[0]  = REF_FLT(WorldRayDirection[0]);
  spills->WorldRayDirection[1]  = REF_FLT(WorldRayDirection[1]);
  spills->WorldRayDirection[2]  = REF_FLT(WorldRayDirection[2]);

  spills->ShaderRecordOffset    = REF(ShaderRecordOffset);  
}

void traceRayRestore_Miss(RuntimeDataType runtimeData, TraceRaySpills_Miss* spills)
{
  REF(RayFlags)                  = spills->RayFlags;               
  REF_FLT(RayTCurrent)           = spills->RayTCurrent;            
  REF_FLT(RayTMin)               = spills->RayTMin;                
  REF_FLT(WorldRayOrigin[0])     = spills->WorldRayOrigin[0];      
  REF_FLT(WorldRayOrigin[1])     = spills->WorldRayOrigin[1];      
  REF_FLT(WorldRayOrigin[2])     = spills->WorldRayOrigin[2];      
  REF_FLT(WorldRayDirection[0])  = spills->WorldRayDirection[0];   
  REF_FLT(WorldRayDirection[1])  = spills->WorldRayDirection[1];   
  REF_FLT(WorldRayDirection[2])  = spills->WorldRayDirection[2];   

  REF(ShaderRecordOffset) = spills->ShaderRecordOffset;    
}





//////////////////////////////////////////////////////////////////////////
//
// Intrinsics for the fallback layer
//
//////////////////////////////////////////////////////////////////////////

void fb_Fallback_Scheduler(int initialStateId, unsigned dimx, unsigned dimy)
{
  StackType* theStack = rewrite_createStack();
  RuntimeData theRuntimeData;
  RuntimeDataType runtimeData = &theRuntimeData;

  rewrite_setLaunchParams(runtimeData, dimx, dimy);
  if(REF(DispatchRaysIndex[0]) >= REF(DispatchRaysDimensions[0]) ||
     REF(DispatchRaysIndex[1]) >= REF(DispatchRaysDimensions[1]))
  { 
    return;
  }


  // Set final return stateID into reserved area at stack top
  unsigned stackSize = rewrite_getStackSize();
  stackInit(runtimeData, theStack, stackSize);
  int stackFrameOffs = stackFrameOffset(runtimeData);
  *stackIntPtr(runtimeData, stackFrameOffs, 0) = -1;

  int stateId = initialStateId;
  int count = 0;
  while( stateId >= 0 )
  {
    stateId = rewrite_dispatch(runtimeData, stateId);
  }
}

void fb_Fallback_SetLaunchParams(RuntimeDataType runtimeData, unsigned DTidx, unsigned DTidy, unsigned dimx, unsigned dimy, unsigned groupIndex)
{ 
  REF(DispatchRaysIndex[0]) = DTidx;
  REF(DispatchRaysIndex[1]) = DTidy;
  REF(DispatchRaysDimensions[0]) = dimx;
  REF(DispatchRaysDimensions[1]) = dimy;

  REF(GroupIndex) = groupIndex;
}

int fb_Fallback_TraceRayBegin(RuntimeDataType runtimeData, unsigned rayFlags, float ox, float oy, float oz, float tmin, float dx, float dy, float dz, float tmax, int newPayloadOffset)
{ 
  REF(RayFlags) = rayFlags;
  REF_FLT(WorldRayOrigin[0]) = ox;
  REF_FLT(WorldRayOrigin[1]) = oy;
  REF_FLT(WorldRayOrigin[2]) = oz;
  REF_FLT(WorldRayDirection[0]) = dx;
  REF_FLT(WorldRayDirection[1]) = dy;
  REF_FLT(WorldRayDirection[2]) = dz;
  REF_FLT(RayTCurrent) = tmax;
  REF_FLT(RayTMin) = tmin;

  int oldOffset = REF(PayloadOffset);
  REF(PayloadOffset) = newPayloadOffset;
  return oldOffset;
}

void fb_Fallback_TraceRayEnd(RuntimeDataType runtimeData, int oldPayloadOffset)
{
  REF(PayloadOffset) = oldPayloadOffset;
}

void fb_Fallback_SetPendingTriVals(RuntimeDataType runtimeData, unsigned shaderRecordOffset, unsigned primitiveIndex, unsigned instanceIndex, unsigned instanceID, float t, unsigned hitKind)
{
  REF(PendingShaderRecordOffset) = shaderRecordOffset;
  REF(PendingPrimitiveIndex) = primitiveIndex;
  REF(PendingInstanceIndex) = instanceIndex;
  REF(PendingInstanceID) = instanceID;
  REF_FLT(PendingRayTCurrent) = t;
  REF(PendingHitKind) = hitKind;
}

void fb_Fallback_SetPendingCustomVals(RuntimeDataType runtimeData, unsigned shaderRecordOffset, unsigned primitiveIndex, unsigned instanceIndex, unsigned instanceID)
{
  REF(PendingShaderRecordOffset) = shaderRecordOffset;
  REF(PendingPrimitiveIndex) = primitiveIndex;
  REF(PendingInstanceIndex) = instanceIndex;
  REF(PendingInstanceID) = instanceID;
}

void fb_Fallback_CommitHit(RuntimeDataType runtimeData)
{
  REF_FLT(RayTCurrent)    = REF_FLT(PendingRayTCurrent);
  REF(ShaderRecordOffset) = REF(PendingShaderRecordOffset);
  REF(PrimitiveIndex)     = REF(PendingPrimitiveIndex);
  REF(InstanceIndex)      = REF(PendingInstanceIndex);
  REF(InstanceID)         = REF(PendingInstanceID);
  REF(HitKind)            = REF(PendingHitKind);  

  int PendingAttrOffset = REF(PendingAttrOffset);
  REF(PendingAttrOffset) = REF(CommittedAttrOffset);
  REF(CommittedAttrOffset) = PendingAttrOffset;
}


int fb_Fallback_RuntimeDataLoadInt(RuntimeDataType runtimeData, int offset)
{
  return (*runtimeData->Stack)[offset];
}

void fb_Fallback_RuntimeDataStoreInt(RuntimeDataType runtimeData, int offset, int val)
{
  (*runtimeData->Stack)[offset] = val;
}

unsigned fb_dxop_dispatchRaysIndex(RuntimeDataType runtimeData, byte i)
{  
  return REF(DispatchRaysIndex[i]);
}

unsigned fb_dxop_dispatchRaysDimensions(RuntimeDataType runtimeData, byte i)
{  
  return REF(DispatchRaysDimensions[i]);
}

float fb_dxop_rayTMin(RuntimeDataType runtimeData)
{
  return REF_FLT(RayTMin);
}

float fb_Fallback_RayTMin(RuntimeDataType runtimeData)
{
  return REF_FLT(RayTMin);
}

void fb_Fallback_SetRayTMin(RuntimeDataType runtimeData, float t)
{
  REF_FLT(RayTMin) = t;
}

float fb_dxop_rayTCurrent(RuntimeDataType runtimeData)
{
  return REF_FLT(RayTCurrent);
}

float fb_Fallback_RayTCurrent(RuntimeDataType runtimeData)
{
  return REF_FLT(RayTCurrent);
}

void fb_Fallback_SetRayTCurrent(RuntimeDataType runtimeData, float t)
{
  REF_FLT(RayTCurrent) = t;
}

unsigned fb_dxop_rayFlags(RuntimeDataType runtimeData)
{
  return REF(RayFlags);
}

unsigned fb_Fallback_RayFlags(RuntimeDataType runtimeData)
{
  return REF(RayFlags);
}

void fb_Fallback_SetRayFlags(RuntimeDataType runtimeData, unsigned flags)
{
  REF(RayFlags) = flags;
}

float fb_dxop_worldRayOrigin(RuntimeDataType runtimeData, byte i)
{ 
  return REF_FLT(WorldRayOrigin[i]);
}

float fb_Fallback_WorldRayOrigin(RuntimeDataType runtimeData, byte i)
{ 
  return REF_FLT(WorldRayOrigin[i]);
}

void fb_Fallback_SetWorldRayOrigin(RuntimeDataType runtimeData, float x, float y, float z)
{ 
  REF_FLT(WorldRayOrigin[0]) = x;
  REF_FLT(WorldRayOrigin[1]) = y;
  REF_FLT(WorldRayOrigin[2]) = z;
}

float fb_dxop_worldRayDirection(RuntimeDataType runtimeData, byte i)
{  
  return REF_FLT(WorldRayDirection[i]);
}

float fb_Fallback_WorldRayDirection(RuntimeDataType runtimeData, byte i)
{  
  return REF_FLT(WorldRayDirection[i]);
}

void fb_Fallback_SetWorldRayDirection(RuntimeDataType runtimeData, float x, float y, float z)
{ 
  REF_FLT(WorldRayDirection[0]) = x;
  REF_FLT(WorldRayDirection[1]) = y;
  REF_FLT(WorldRayDirection[2]) = z;
}

float fb_dxop_objectRayOrigin(RuntimeDataType runtimeData, byte i)
{ 
  return REF_FLT(ObjectRayOrigin[i]);
}

float fb_Fallback_ObjectRayOrigin(RuntimeDataType runtimeData, byte i)
{ 
  return REF_FLT(ObjectRayOrigin[i]);
}

void fb_Fallback_SetObjectRayOrigin(RuntimeDataType runtimeData, float x, float y, float z)
{ 
  REF_FLT(ObjectRayOrigin[0]) = x;
  REF_FLT(ObjectRayOrigin[1]) = y;
  REF_FLT(ObjectRayOrigin[2]) = z;
}

float fb_dxop_objectRayDirection(RuntimeDataType runtimeData, byte i)
{  
  return REF_FLT(ObjectRayDirection[i]);
}

float fb_Fallback_ObjectRayDirection(RuntimeDataType runtimeData, byte i)
{  
  return REF_FLT(ObjectRayDirection[i]);
}

void fb_Fallback_SetObjectRayDirection(RuntimeDataType runtimeData, float x, float y, float z)
{ 
  REF_FLT(ObjectRayDirection[0]) = x;
  REF_FLT(ObjectRayDirection[1]) = y;
  REF_FLT(ObjectRayDirection[2]) = z;
}

float fb_dxop_objectToWorld(RuntimeDataType runtimeData, int r, byte c)
{
  int i = r * 4 + c;
  return REF_FLT_OFS(ObjectToWorld, i);
}

void fb_Fallback_SetObjectToWorld(RuntimeDataType runtimeData, float12 M)
{
  REF_FLT_OFS(ObjectToWorld, 0)  = M[0]; 
  REF_FLT_OFS(ObjectToWorld, 1)  = M[1]; 
  REF_FLT_OFS(ObjectToWorld, 2)  = M[2]; 
  REF_FLT_OFS(ObjectToWorld, 3)  = M[3]; 
  REF_FLT_OFS(ObjectToWorld, 4)  = M[4]; 
  REF_FLT_OFS(ObjectToWorld, 5)  = M[5]; 
  REF_FLT_OFS(ObjectToWorld, 6)  = M[6]; 
  REF_FLT_OFS(ObjectToWorld, 7)  = M[7]; 
  REF_FLT_OFS(ObjectToWorld, 8)  = M[8]; 
  REF_FLT_OFS(ObjectToWorld, 9)  = M[9]; 
  REF_FLT_OFS(ObjectToWorld, 10) = M[10];
  REF_FLT_OFS(ObjectToWorld, 11) = M[11];
}

float fb_dxop_worldToObject(RuntimeDataType runtimeData, int r, byte c)
{
  int i = r * 4 + c;
  return REF_FLT_OFS(WorldToObject, i);
}

void fb_Fallback_SetWorldToObject(RuntimeDataType runtimeData, float12 M)
{
  REF_FLT_OFS(WorldToObject, 0)  = M[0]; 
  REF_FLT_OFS(WorldToObject, 1)  = M[1]; 
  REF_FLT_OFS(WorldToObject, 2)  = M[2]; 
  REF_FLT_OFS(WorldToObject, 3)  = M[3]; 
  REF_FLT_OFS(WorldToObject, 4)  = M[4]; 
  REF_FLT_OFS(WorldToObject, 5)  = M[5]; 
  REF_FLT_OFS(WorldToObject, 6)  = M[6]; 
  REF_FLT_OFS(WorldToObject, 7)  = M[7]; 
  REF_FLT_OFS(WorldToObject, 8)  = M[8]; 
  REF_FLT_OFS(WorldToObject, 9)  = M[9]; 
  REF_FLT_OFS(WorldToObject, 10) = M[10];
  REF_FLT_OFS(WorldToObject, 11) = M[11];
}

unsigned fb_dxop_primitiveIndex(RuntimeDataType runtimeData)
{
  return REF(PrimitiveIndex);
}

unsigned fb_Fallback_PrimitiveIndex(RuntimeDataType runtimeData)
{
  return REF(PrimitiveIndex);
}

void fb_Fallback_SetPrimitiveIndex(RuntimeDataType runtimeData, unsigned i)
{
  REF(PrimitiveIndex) = i;
}

unsigned fb_Fallback_ShaderRecordOffset(RuntimeDataType runtimeData)
{
  return REF(ShaderRecordOffset);
}

void fb_Fallback_SetShaderRecordOffset(RuntimeDataType runtimeData, unsigned shaderRecordOffset)
{
  REF(ShaderRecordOffset) = shaderRecordOffset;
}

unsigned fb_dxop_instanceIndex(RuntimeDataType runtimeData)
{
  return REF(InstanceIndex);
}

unsigned fb_Fallback_InstanceIndex(RuntimeDataType runtimeData)
{
  return REF(InstanceIndex);
}

void fb_Fallback_SetInstanceIndex(RuntimeDataType runtimeData, unsigned i)
{
  REF(InstanceIndex) = i;
}

unsigned fb_dxop_instanceID(RuntimeDataType runtimeData)
{
  return REF(InstanceID);
}

unsigned fb_Fallback_InstanceID(RuntimeDataType runtimeData)
{
  return REF(InstanceID);
}

void fb_Fallback_SetInstanceID(RuntimeDataType runtimeData, unsigned i)
{
  REF(InstanceID) = i;
}

unsigned fb_dxop_hitKind(RuntimeDataType runtimeData)
{
  return REF(HitKind);
}

unsigned fb_Fallback_HitKind(RuntimeDataType runtimeData)
{
  return REF(HitKind);
}

void fb_Fallback_SetHitKind(RuntimeDataType runtimeData, unsigned i)
{
  REF(HitKind) = i;
}

float fb_dxop_pending_rayTCurrent(RuntimeDataType runtimeData)
{
  return REF_FLT(PendingRayTCurrent);
}

void fb_Fallback_SetPendingRayTCurrent(RuntimeDataType runtimeData, float t)
{
  REF_FLT(PendingRayTCurrent) = t;
}

unsigned fb_dxop_pending_primitiveID(RuntimeDataType runtimeData)
//unsigned fb_dxop_pending_primitiveIndex(RuntimeDataType runtimeData)
{
  return REF(PendingPrimitiveIndex);
}

unsigned fb_Fallback_PendingShaderRecordOffset(RuntimeDataType runtimeData)
{
  return REF(PendingShaderRecordOffset);
}

unsigned fb_dxop_pending_instanceIndex(RuntimeDataType runtimeData)
{
  return REF(PendingInstanceIndex);
}

unsigned fb_dxop_pending_instanceID(RuntimeDataType runtimeData)
{
  return REF(PendingInstanceID);
}

unsigned fb_dxop_pending_hitKind(RuntimeDataType runtimeData)
{
  return REF(PendingHitKind);
}

void fb_Fallback_SetPendingHitKind(RuntimeDataType runtimeData, unsigned i)
{
  REF(PendingHitKind) = i;
}

unsigned fb_Fallback_GroupIndex(RuntimeDataType runtimeData)
{ 
  return REF(GroupIndex);
}

int fb_Fallback_AnyHitResult(RuntimeDataType runtimeData)
{
  return REF(AnyHitResult);
}

void fb_Fallback_SetAnyHitResult(RuntimeDataType runtimeData, int result)
{
  REF(AnyHitResult) = result;
}

int fb_Fallback_AnyHitStateId(RuntimeDataType runtimeData)
{
  return REF(AnyHitStateId);
}

void fb_Fallback_SetAnyHitStateId(RuntimeDataType runtimeData, int id)
{
  REF(AnyHitStateId) = id;
}

#endif

static const char *runtimeString[] = {R"AAA(
target datalayout = "e-m:e-p:32:32-i1:32-i8:32-i16:32-i32:32-i64:64-f16:32-f32:32-f:64:64-n8:16:32:64"
target triple = "dxil-ms-dx"



%struct.RuntimeDataStruct = type { [2 x i32], [2 x i32], float, float, i32, [3 x float], [3 x float], [3 x float], [3 x float], [12 x float], [12 x float], i32, i32, i32, i32, i32, float, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, [256 x i32]* }
%struct.TraceRaySpills_ClosestHit = type { float, float, i32, [3 x float], [3 x float], [3 x float], [3 x float], i32, i32, i32, i32, i32 }
%struct.TraceRaySpills_Miss = type { float, float, i32, [3 x float], [3 x float], i32 }

; Function Attrs: nounwind
define void @stackInit(%struct.RuntimeDataStruct* %runtimeData, [256 x i32]* %theStack, i32 %stackSize) #0 {
entry:
  %Stack = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 29
  store [256 x i32]* %theStack, [256 x i32]** %Stack, align 4
  %div = udiv i32 %stackSize, 4
  %sub = sub i32 %div, 1
  %StackOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  store i32 %sub, i32* %StackOffset, align 4
  %PayloadOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 25
  store i32 1111, i32* %PayloadOffset, align 4
  %CommittedAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 26
  store i32 2222, i32* %CommittedAttrOffset, align 4
  %PendingAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 27
  store i32 3333, i32* %PendingAttrOffset, align 4
  ret void
}

; Function Attrs: nounwind
define void @stackFramePush(%struct.RuntimeDataStruct* %runtimeData, i32 %size) #0 {
entry:
  %StackOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %0 = load i32, i32* %StackOffset, align 4
  %sub = sub nsw i32 %0, %size
  store i32 %sub, i32* %StackOffset, align 4
  ret void
}

; Function Attrs: nounwind
define void @stackFramePop(%struct.RuntimeDataStruct* %runtimeData, i32 %size) #0 {
entry:
  %StackOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %0 = load i32, i32* %StackOffset, align 4
  %add = add nsw i32 %0, %size
  store i32 %add, i32* %StackOffset, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @stackFrameOffset(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %StackOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %0 = load i32, i32* %StackOffset, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @payloadOffset(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PayloadOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 25
  %0 = load i32, i32* %PayloadOffset, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @committedAttrOffset(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %CommittedAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 26
  %0 = load i32, i32* %CommittedAttrOffset, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @pendingAttrOffset(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PendingAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 27
  %0 = load i32, i32* %PendingAttrOffset, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32* @stackIntPtr(%struct.RuntimeDataStruct* %runtimeData, i32 %baseOffset, i32 %offset) #0 {
entry:
  %add = add nsw i32 %baseOffset, %offset
  %Stack = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 29
  %0 = load [256 x i32]*, [256 x i32]** %Stack, align 4
  %arrayidx = getelementptr inbounds [256 x i32], [256 x i32]* %0, i32 0, i32 %add
  ret i32* %arrayidx
}

; Function Attrs: nounwind
define void @traceFramePush(%struct.RuntimeDataStruct* %runtimeData, i32 %attrSize) #0 {
entry:
  %CommittedAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 26
  %0 = load i32, i32* %CommittedAttrOffset, align 4
  %StackOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %1 = load i32, i32* %StackOffset, align 4
  %add = add nsw i32 %1, -1
  %Stack = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 29
  %2 = load [256 x i32]*, [256 x i32]** %Stack, align 4
  %arrayidx = getelementptr inbounds [256 x i32], [256 x i32]* %2, i32 0, i32 %add
  store i32 %0, i32* %arrayidx, align 4
  %PendingAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 27
  %3 = load i32, i32* %PendingAttrOffset, align 4
  %StackOffset1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %4 = load i32, i32* %StackOffset1, align 4
  %add2 = add nsw i32 %4, -2
  %Stack3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 29
  %5 = load [256 x i32]*, [256 x i32]** %Stack3, align 4
  %arrayidx4 = getelementptr inbounds [256 x i32], [256 x i32]* %5, i32 0, i32 %add2
  store i32 %3, i32* %arrayidx4, align 4
  %StackOffset5 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %6 = load i32, i32* %StackOffset5, align 4
  %sub = sub nsw i32 %6, 2
  %sub6 = sub nsw i32 %sub, %attrSize
  %CommittedAttrOffset7 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 26
  store i32 %sub6, i32* %CommittedAttrOffset7, align 4
  %StackOffset8 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %7 = load i32, i32* %StackOffset8, align 4
  %sub9 = sub nsw i32 %7, 2
  %mul = mul nsw i32 2, %attrSize
  %sub10 = sub nsw i32 %sub9, %mul
  %PendingAttrOffset11 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 27
  store i32 %sub10, i32* %PendingAttrOffset11, align 4
  ret void
}

; Function Attrs: nounwind
define void @traceFramePop(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %StackOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %0 = load i32, i32* %StackOffset, align 4
  %add = add nsw i32 %0, -1
  %Stack = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 29
  %1 = load [256 x i32]*, [256 x i32]** %Stack, align 4
  %arrayidx = getelementptr inbounds [256 x i32], [256 x i32]* %1, i32 0, i32 %add
  %2 = load i32, i32* %arrayidx, align 4
  %CommittedAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 26
  store i32 %2, i32* %CommittedAttrOffset, align 4
  %StackOffset1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 28
  %3 = load i32, i32* %StackOffset1, align 4
  %add2 = add nsw i32 %3, -2
  %Stack3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 29
  %4 = load [256 x i32]*, [256 x i32]** %Stack3, align 4
  %arrayidx4 = getelementptr inbounds [256 x i32], [256 x i32]* %4, i32 0, i32 %add2
  %5 = load i32, i32* %arrayidx4, align 4
  %PendingAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 27
  store i32 %5, i32* %PendingAttrOffset, align 4
  ret void
}

; Function Attrs: nounwind
define void @traceRaySave_ClosestHit(%struct.RuntimeDataStruct* %runtimeData, %struct.TraceRaySpills_ClosestHit* %spills) #0 {
entry:
  %RayFlags = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 4
  %0 = load i32, i32* %RayFlags, align 4
  %RayFlags1 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 2
  store i32 %0, i32* %RayFlags1, align 4
  %RayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  %1 = load float, float* %RayTCurrent, align 4
  %RayTCurrent2 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 1
  store float %1, float* %RayTCurrent2, align 4
  %RayTMin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 2
  %2 = load float, float* %RayTMin, align 4
  %RayTMin3 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 0
  store float %2, float* %RayTMin3, align 4
  %WorldRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin, i32 0, i32 0
  %3 = load float, float* %arrayidx, align 4
  %WorldRayOrigin4 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 3
  %arrayidx5 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin4, i32 0, i32 0
  store float %3, float* %arrayidx5, align 4
  %WorldRayOrigin6 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx7 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin6, i32 0, i32 1
  %4 = load float, float* %arrayidx7, align 4
  %WorldRayOrigin8 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 3
  %arrayidx9 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin8, i32 0, i32 1
  store float %4, float* %arrayidx9, align 4
  %WorldRayOrigin10 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
)AAA",
                                      R"AAA(
  %arrayidx11 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin10, i32 0, i32 2
  %5 = load float, float* %arrayidx11, align 4
  %WorldRayOrigin12 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 3
  %arrayidx13 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin12, i32 0, i32 2
  store float %5, float* %arrayidx13, align 4
  %WorldRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx14 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection, i32 0, i32 0
  %6 = load float, float* %arrayidx14, align 4
  %WorldRayDirection15 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 4
  %arrayidx16 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection15, i32 0, i32 0
  store float %6, float* %arrayidx16, align 4
  %WorldRayDirection17 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx18 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection17, i32 0, i32 1
  %7 = load float, float* %arrayidx18, align 4
  %WorldRayDirection19 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 4
  %arrayidx20 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection19, i32 0, i32 1
  store float %7, float* %arrayidx20, align 4
  %WorldRayDirection21 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx22 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection21, i32 0, i32 2
  %8 = load float, float* %arrayidx22, align 4
  %WorldRayDirection23 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 4
  %arrayidx24 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection23, i32 0, i32 2
  store float %8, float* %arrayidx24, align 4
  %ObjectRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx25 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin, i32 0, i32 0
  %9 = load float, float* %arrayidx25, align 4
  %ObjectRayOrigin26 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 5
  %arrayidx27 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin26, i32 0, i32 0
  store float %9, float* %arrayidx27, align 4
  %ObjectRayOrigin28 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx29 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin28, i32 0, i32 1
  %10 = load float, float* %arrayidx29, align 4
  %ObjectRayOrigin30 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 5
  %arrayidx31 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin30, i32 0, i32 1
  store float %10, float* %arrayidx31, align 4
  %ObjectRayOrigin32 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx33 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin32, i32 0, i32 2
  %11 = load float, float* %arrayidx33, align 4
  %ObjectRayOrigin34 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 5
  %arrayidx35 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin34, i32 0, i32 2
  store float %11, float* %arrayidx35, align 4
  %ObjectRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx36 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection, i32 0, i32 0
  %12 = load float, float* %arrayidx36, align 4
  %ObjectRayDirection37 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 6
  %arrayidx38 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection37, i32 0, i32 0
  store float %12, float* %arrayidx38, align 4
  %ObjectRayDirection39 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx40 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection39, i32 0, i32 1
  %13 = load float, float* %arrayidx40, align 4
  %ObjectRayDirection41 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 6
  %arrayidx42 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection41, i32 0, i32 1
  store float %13, float* %arrayidx42, align 4
  %ObjectRayDirection43 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx44 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection43, i32 0, i32 2
  %14 = load float, float* %arrayidx44, align 4
  %ObjectRayDirection45 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 6
  %arrayidx46 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection45, i32 0, i32 2
  store float %14, float* %arrayidx46, align 4
  %PrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 11
  %15 = load i32, i32* %PrimitiveIndex, align 4
  %PrimitiveIndex47 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 7
  store i32 %15, i32* %PrimitiveIndex47, align 4
  %InstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 12
  %16 = load i32, i32* %InstanceIndex, align 4
  %InstanceIndex48 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 8
  store i32 %16, i32* %InstanceIndex48, align 4
  %InstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 13
  %17 = load i32, i32* %InstanceID, align 4
  %InstanceID49 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 9
  store i32 %17, i32* %InstanceID49, align 4
  %HitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 14
  %18 = load i32, i32* %HitKind, align 4
  %HitKind50 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 10
  store i32 %18, i32* %HitKind50, align 4
  %ShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 15
  %19 = load i32, i32* %ShaderRecordOffset, align 4
  %ShaderRecordOffset51 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 11
  store i32 %19, i32* %ShaderRecordOffset51, align 4
  ret void
}

; Function Attrs: nounwind
define void @traceRayRestore_ClosestHit(%struct.RuntimeDataStruct* %runtimeData, %struct.TraceRaySpills_ClosestHit* %spills) #0 {
entry:
  %RayFlags = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 2
  %0 = load i32, i32* %RayFlags, align 4
  %RayFlags1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 4
  store i32 %0, i32* %RayFlags1, align 4
  %RayTCurrent = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 1
  %1 = load float, float* %RayTCurrent, align 4
  %RayTCurrent2 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  store float %1, float* %RayTCurrent2, align 4
  %RayTMin = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 0
  %2 = load float, float* %RayTMin, align 4
  %RayTMin3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 2
  store float %2, float* %RayTMin3, align 4
  %WorldRayOrigin = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 3
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin, i32 0, i32 0
  %3 = load float, float* %arrayidx, align 4
  %WorldRayOrigin4 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx5 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin4, i32 0, i32 0
  store float %3, float* %arrayidx5, align 4
  %WorldRayOrigin6 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 3
  %arrayidx7 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin6, i32 0, i32 1
  %4 = load float, float* %arrayidx7, align 4
  %WorldRayOrigin8 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx9 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin8, i32 0, i32 1
  store float %4, float* %arrayidx9, align 4
  %WorldRayOrigin10 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 3
  %arrayidx11 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin10, i32 0, i32 2
  %5 = load float, float* %arrayidx11, align 4
  %WorldRayOrigin12 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx13 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin12, i32 0, i32 2
  store float %5, float* %arrayidx13, align 4
  %WorldRayDirection = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 4
)AAA",
                                      R"AAA(
  %arrayidx14 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection, i32 0, i32 0
  %6 = load float, float* %arrayidx14, align 4
  %WorldRayDirection15 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx16 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection15, i32 0, i32 0
  store float %6, float* %arrayidx16, align 4
  %WorldRayDirection17 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 4
  %arrayidx18 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection17, i32 0, i32 1
  %7 = load float, float* %arrayidx18, align 4
  %WorldRayDirection19 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx20 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection19, i32 0, i32 1
  store float %7, float* %arrayidx20, align 4
  %WorldRayDirection21 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 4
  %arrayidx22 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection21, i32 0, i32 2
  %8 = load float, float* %arrayidx22, align 4
  %WorldRayDirection23 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx24 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection23, i32 0, i32 2
  store float %8, float* %arrayidx24, align 4
  %ObjectRayOrigin = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 5
  %arrayidx25 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin, i32 0, i32 0
  %9 = load float, float* %arrayidx25, align 4
  %ObjectRayOrigin26 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx27 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin26, i32 0, i32 0
  store float %9, float* %arrayidx27, align 4
  %ObjectRayOrigin28 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 5
  %arrayidx29 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin28, i32 0, i32 1
  %10 = load float, float* %arrayidx29, align 4
  %ObjectRayOrigin30 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx31 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin30, i32 0, i32 1
  store float %10, float* %arrayidx31, align 4
  %ObjectRayOrigin32 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 5
  %arrayidx33 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin32, i32 0, i32 2
  %11 = load float, float* %arrayidx33, align 4
  %ObjectRayOrigin34 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx35 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin34, i32 0, i32 2
  store float %11, float* %arrayidx35, align 4
  %ObjectRayDirection = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 6
  %arrayidx36 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection, i32 0, i32 0
  %12 = load float, float* %arrayidx36, align 4
  %ObjectRayDirection37 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx38 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection37, i32 0, i32 0
  store float %12, float* %arrayidx38, align 4
  %ObjectRayDirection39 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 6
  %arrayidx40 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection39, i32 0, i32 1
  %13 = load float, float* %arrayidx40, align 4
  %ObjectRayDirection41 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx42 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection41, i32 0, i32 1
  store float %13, float* %arrayidx42, align 4
  %ObjectRayDirection43 = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 6
  %arrayidx44 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection43, i32 0, i32 2
  %14 = load float, float* %arrayidx44, align 4
  %ObjectRayDirection45 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx46 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection45, i32 0, i32 2
  store float %14, float* %arrayidx46, align 4
  %PrimitiveIndex = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 7
  %15 = load i32, i32* %PrimitiveIndex, align 4
  %PrimitiveIndex47 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 11
  store i32 %15, i32* %PrimitiveIndex47, align 4
  %InstanceIndex = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 8
  %16 = load i32, i32* %InstanceIndex, align 4
  %InstanceIndex48 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 12
  store i32 %16, i32* %InstanceIndex48, align 4
  %InstanceID = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 9
  %17 = load i32, i32* %InstanceID, align 4
  %InstanceID49 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 13
  store i32 %17, i32* %InstanceID49, align 4
  %HitKind = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 10
  %18 = load i32, i32* %HitKind, align 4
  %HitKind50 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 14
  store i32 %18, i32* %HitKind50, align 4
  %ShaderRecordOffset = getelementptr inbounds %struct.TraceRaySpills_ClosestHit, %struct.TraceRaySpills_ClosestHit* %spills, i32 0, i32 11
  %19 = load i32, i32* %ShaderRecordOffset, align 4
  %ShaderRecordOffset51 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 15
  store i32 %19, i32* %ShaderRecordOffset51, align 4
  ret void
}

; Function Attrs: nounwind
define void @traceRaySave_Miss(%struct.RuntimeDataStruct* %runtimeData, %struct.TraceRaySpills_Miss* %spills) #0 {
entry:
  %RayFlags = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 4
  %0 = load i32, i32* %RayFlags, align 4
  %RayFlags1 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 2
  store i32 %0, i32* %RayFlags1, align 4
  %RayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  %1 = load float, float* %RayTCurrent, align 4
  %RayTCurrent2 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 1
  store float %1, float* %RayTCurrent2, align 4
  %RayTMin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 2
  %2 = load float, float* %RayTMin, align 4
  %RayTMin3 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 0
  store float %2, float* %RayTMin3, align 4
  %WorldRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin, i32 0, i32 0
  %3 = load float, float* %arrayidx, align 4
  %WorldRayOrigin4 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 3
  %arrayidx5 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin4, i32 0, i32 0
  store float %3, float* %arrayidx5, align 4
  %WorldRayOrigin6 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx7 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin6, i32 0, i32 1
  %4 = load float, float* %arrayidx7, align 4
  %WorldRayOrigin8 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 3
  %arrayidx9 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin8, i32 0, i32 1
  store float %4, float* %arrayidx9, align 4
  %WorldRayOrigin10 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx11 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin10, i32 0, i32 2
  %5 = load float, float* %arrayidx11, align 4
  %WorldRayOrigin12 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 3
  %arrayidx13 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin12, i32 0, i32 2
  store float %5, float* %arrayidx13, align 4
  %WorldRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx14 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection, i32 0, i32 0
  %6 = load float, float* %arrayidx14, align 4
  %WorldRayDirection15 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 4
  %arrayidx16 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection15, i32 0, i32 0
  store float %6, float* %arrayidx16, align 4
  %WorldRayDirection17 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx18 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection17, i32 0, i32 1
)AAA",
                                      R"AAA(
  %7 = load float, float* %arrayidx18, align 4
  %WorldRayDirection19 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 4
  %arrayidx20 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection19, i32 0, i32 1
  store float %7, float* %arrayidx20, align 4
  %WorldRayDirection21 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx22 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection21, i32 0, i32 2
  %8 = load float, float* %arrayidx22, align 4
  %WorldRayDirection23 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 4
  %arrayidx24 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection23, i32 0, i32 2
  store float %8, float* %arrayidx24, align 4
  %ShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 15
  %9 = load i32, i32* %ShaderRecordOffset, align 4
  %ShaderRecordOffset25 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 5
  store i32 %9, i32* %ShaderRecordOffset25, align 4
  ret void
}

; Function Attrs: nounwind
define void @traceRayRestore_Miss(%struct.RuntimeDataStruct* %runtimeData, %struct.TraceRaySpills_Miss* %spills) #0 {
entry:
  %RayFlags = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 2
  %0 = load i32, i32* %RayFlags, align 4
  %RayFlags1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 4
  store i32 %0, i32* %RayFlags1, align 4
  %RayTCurrent = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 1
  %1 = load float, float* %RayTCurrent, align 4
  %RayTCurrent2 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  store float %1, float* %RayTCurrent2, align 4
  %RayTMin = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 0
  %2 = load float, float* %RayTMin, align 4
  %RayTMin3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 2
  store float %2, float* %RayTMin3, align 4
  %WorldRayOrigin = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 3
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin, i32 0, i32 0
  %3 = load float, float* %arrayidx, align 4
  %WorldRayOrigin4 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx5 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin4, i32 0, i32 0
  store float %3, float* %arrayidx5, align 4
  %WorldRayOrigin6 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 3
  %arrayidx7 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin6, i32 0, i32 1
  %4 = load float, float* %arrayidx7, align 4
  %WorldRayOrigin8 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx9 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin8, i32 0, i32 1
  store float %4, float* %arrayidx9, align 4
  %WorldRayOrigin10 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 3
  %arrayidx11 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin10, i32 0, i32 2
  %5 = load float, float* %arrayidx11, align 4
  %WorldRayOrigin12 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx13 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin12, i32 0, i32 2
  store float %5, float* %arrayidx13, align 4
  %WorldRayDirection = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 4
  %arrayidx14 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection, i32 0, i32 0
  %6 = load float, float* %arrayidx14, align 4
  %WorldRayDirection15 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx16 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection15, i32 0, i32 0
  store float %6, float* %arrayidx16, align 4
  %WorldRayDirection17 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 4
  %arrayidx18 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection17, i32 0, i32 1
  %7 = load float, float* %arrayidx18, align 4
  %WorldRayDirection19 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx20 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection19, i32 0, i32 1
  store float %7, float* %arrayidx20, align 4
  %WorldRayDirection21 = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 4
  %arrayidx22 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection21, i32 0, i32 2
  %8 = load float, float* %arrayidx22, align 4
  %WorldRayDirection23 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx24 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection23, i32 0, i32 2
  store float %8, float* %arrayidx24, align 4
  %ShaderRecordOffset = getelementptr inbounds %struct.TraceRaySpills_Miss, %struct.TraceRaySpills_Miss* %spills, i32 0, i32 5
  %9 = load i32, i32* %ShaderRecordOffset, align 4
  %ShaderRecordOffset25 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 15
  store i32 %9, i32* %ShaderRecordOffset25, align 4
  ret void
}

; Function Attrs: nounwind
define void @fb_Fallback_Scheduler(i32 %initialStateId, i32 %dimx, i32 %dimy) #0 {
entry:
  %theRuntimeData = alloca %struct.RuntimeDataStruct, align 4
  %call = call [256 x i32]* @rewrite_createStack()
  %call1 = call i8* @rewrite_setLaunchParams(%struct.RuntimeDataStruct* %theRuntimeData, i32 %dimx, i32 %dimy)
  %DispatchRaysIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %theRuntimeData, i32 0, i32 0
  %arrayidx = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysIndex, i32 0, i32 0
  %0 = load i32, i32* %arrayidx, align 4
  %DispatchRaysDimensions = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %theRuntimeData, i32 0, i32 1
  %arrayidx2 = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysDimensions, i32 0, i32 0
  %1 = load i32, i32* %arrayidx2, align 4
  %cmp = icmp sge i32 %0, %1
  br i1 %cmp, label %if.then, label %lor.lhs.false

lor.lhs.false:                                    ; preds = %entry
  %DispatchRaysIndex3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %theRuntimeData, i32 0, i32 0
  %arrayidx4 = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysIndex3, i32 0, i32 1
  %2 = load i32, i32* %arrayidx4, align 4
  %DispatchRaysDimensions5 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %theRuntimeData, i32 0, i32 1
  %arrayidx6 = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysDimensions5, i32 0, i32 1
  %3 = load i32, i32* %arrayidx6, align 4
  %cmp7 = icmp sge i32 %2, %3
  br i1 %cmp7, label %if.then, label %if.end

if.then:                                          ; preds = %lor.lhs.false, %entry
  br label %while.end

if.end:                                           ; preds = %lor.lhs.false
  %call8 = call i32 @rewrite_getStackSize()
  call void @stackInit(%struct.RuntimeDataStruct* %theRuntimeData, [256 x i32]* %call, i32 %call8)
  %call9 = call i32 @stackFrameOffset(%struct.RuntimeDataStruct* %theRuntimeData)
  %call10 = call i32* @stackIntPtr(%struct.RuntimeDataStruct* %theRuntimeData, i32 %call9, i32 0)
  store i32 -1, i32* %call10, align 4
  br label %while.cond

while.cond:                                       ; preds = %while.body, %if.end
  %stateId.0 = phi i32 [ %initialStateId, %if.end ], [ %call12, %while.body ]
  %cmp11 = icmp sge i32 %stateId.0, 0
  br i1 %cmp11, label %while.body, label %while.end

while.body:                                       ; preds = %while.cond
  %call12 = call i32 @rewrite_dispatch(%struct.RuntimeDataStruct* %theRuntimeData, i32 %stateId.0)
  br label %while.cond

while.end:                                        ; preds = %while.cond, %if.then
  ret void
}

declare [256 x i32]* @rewrite_createStack() #1

declare i8* @rewrite_setLaunchParams(%struct.RuntimeDataStruct*, i32, i32) #1

declare i32 @rewrite_getStackSize() #1

declare i32 @rewrite_dispatch(%struct.RuntimeDataStruct*, i32) #1

; Function Attrs: nounwind
define void @fb_Fallback_SetLaunchParams(%struct.RuntimeDataStruct* %runtimeData, i32 %DTidx, i32 %DTidy, i32 %dimx, i32 %dimy, i32 %groupIndex) #0 {
entry:
  %DispatchRaysIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 0
  %arrayidx = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysIndex, i32 0, i32 0
  store i32 %DTidx, i32* %arrayidx, align 4
  %DispatchRaysIndex1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 0
  %arrayidx2 = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysIndex1, i32 0, i32 1
  store i32 %DTidy, i32* %arrayidx2, align 4
  %DispatchRaysDimensions = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 1
  %arrayidx3 = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysDimensions, i32 0, i32 0
  store i32 %dimx, i32* %arrayidx3, align 4
  %DispatchRaysDimensions4 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 1
  %arrayidx5 = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysDimensions4, i32 0, i32 1
)AAA",
                                      R"AAA(
  store i32 %dimy, i32* %arrayidx5, align 4
  %GroupIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 22
  store i32 %groupIndex, i32* %GroupIndex, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_Fallback_TraceRayBegin(%struct.RuntimeDataStruct* %runtimeData, i32 %rayFlags, float %ox, float %oy, float %oz, float %tmin, float %dx, float %dy, float %dz, float %tmax, i32 %newPayloadOffset) #0 {
entry:
  %RayFlags = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 4
  store i32 %rayFlags, i32* %RayFlags, align 4
  %WorldRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin, i32 0, i32 0
  store float %ox, float* %arrayidx, align 4
  %WorldRayOrigin1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx2 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin1, i32 0, i32 1
  store float %oy, float* %arrayidx2, align 4
  %WorldRayOrigin3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx4 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin3, i32 0, i32 2
  store float %oz, float* %arrayidx4, align 4
  %WorldRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx5 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection, i32 0, i32 0
  store float %dx, float* %arrayidx5, align 4
  %WorldRayDirection6 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx7 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection6, i32 0, i32 1
  store float %dy, float* %arrayidx7, align 4
  %WorldRayDirection8 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx9 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection8, i32 0, i32 2
  store float %dz, float* %arrayidx9, align 4
  %RayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  store float %tmax, float* %RayTCurrent, align 4
  %RayTMin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 2
  store float %tmin, float* %RayTMin, align 4
  %PayloadOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 25
  %0 = load i32, i32* %PayloadOffset, align 4
  %PayloadOffset10 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 25
  store i32 %newPayloadOffset, i32* %PayloadOffset10, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_TraceRayEnd(%struct.RuntimeDataStruct* %runtimeData, i32 %oldPayloadOffset) #0 {
entry:
  %PayloadOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 25
  store i32 %oldPayloadOffset, i32* %PayloadOffset, align 4
  ret void
}

; Function Attrs: nounwind
define void @fb_Fallback_SetPendingTriVals(%struct.RuntimeDataStruct* %runtimeData, i32 %shaderRecordOffset, i32 %primitiveIndex, i32 %instanceIndex, i32 %instanceID, float %t, i32 %hitKind) #0 {
entry:
  %PendingShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 21
  store i32 %shaderRecordOffset, i32* %PendingShaderRecordOffset, align 4
  %PendingPrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 17
  store i32 %primitiveIndex, i32* %PendingPrimitiveIndex, align 4
  %PendingInstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 18
  store i32 %instanceIndex, i32* %PendingInstanceIndex, align 4
  %PendingInstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 19
  store i32 %instanceID, i32* %PendingInstanceID, align 4
  %PendingRayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 16
  store float %t, float* %PendingRayTCurrent, align 4
  %PendingHitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 20
  store i32 %hitKind, i32* %PendingHitKind, align 4
  ret void
}

; Function Attrs: nounwind
define void @fb_Fallback_SetPendingCustomVals(%struct.RuntimeDataStruct* %runtimeData, i32 %shaderRecordOffset, i32 %primitiveIndex, i32 %instanceIndex, i32 %instanceID) #0 {
entry:
  %PendingShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 21
  store i32 %shaderRecordOffset, i32* %PendingShaderRecordOffset, align 4
  %PendingPrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 17
  store i32 %primitiveIndex, i32* %PendingPrimitiveIndex, align 4
  %PendingInstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 18
  store i32 %instanceIndex, i32* %PendingInstanceIndex, align 4
  %PendingInstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 19
  store i32 %instanceID, i32* %PendingInstanceID, align 4
  ret void
}

; Function Attrs: nounwind
define void @fb_Fallback_CommitHit(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PendingRayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 16
  %0 = load float, float* %PendingRayTCurrent, align 4
  %RayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  store float %0, float* %RayTCurrent, align 4
  %PendingShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 21
  %1 = load i32, i32* %PendingShaderRecordOffset, align 4
  %ShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 15
  store i32 %1, i32* %ShaderRecordOffset, align 4
  %PendingPrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 17
  %2 = load i32, i32* %PendingPrimitiveIndex, align 4
  %PrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 11
  store i32 %2, i32* %PrimitiveIndex, align 4
  %PendingInstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 18
  %3 = load i32, i32* %PendingInstanceIndex, align 4
  %InstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 12
  store i32 %3, i32* %InstanceIndex, align 4
  %PendingInstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 19
  %4 = load i32, i32* %PendingInstanceID, align 4
  %InstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 13
  store i32 %4, i32* %InstanceID, align 4
  %PendingHitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 20
  %5 = load i32, i32* %PendingHitKind, align 4
  %HitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 14
  store i32 %5, i32* %HitKind, align 4
  %PendingAttrOffset1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 27
  %6 = load i32, i32* %PendingAttrOffset1, align 4
  %CommittedAttrOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 26
  %7 = load i32, i32* %CommittedAttrOffset, align 4
  %PendingAttrOffset2 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 27
  store i32 %7, i32* %PendingAttrOffset2, align 4
  %CommittedAttrOffset3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 26
  store i32 %6, i32* %CommittedAttrOffset3, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_Fallback_RuntimeDataLoadInt(%struct.RuntimeDataStruct* %runtimeData, i32 %offset) #0 {
entry:
  %Stack = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 29
  %0 = load [256 x i32]*, [256 x i32]** %Stack, align 4
  %arrayidx = getelementptr inbounds [256 x i32], [256 x i32]* %0, i32 0, i32 %offset
  %1 = load i32, i32* %arrayidx, align 4
  ret i32 %1
}

; Function Attrs: nounwind
define void @fb_Fallback_RuntimeDataStoreInt(%struct.RuntimeDataStruct* %runtimeData, i32 %offset, i32 %val) #0 {
entry:
  %Stack = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 29
  %0 = load [256 x i32]*, [256 x i32]** %Stack, align 4
  %arrayidx = getelementptr inbounds [256 x i32], [256 x i32]* %0, i32 0, i32 %offset
  store i32 %val, i32* %arrayidx, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_dxop_dispatchRaysIndex(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %DispatchRaysIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 0
  %arrayidx = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysIndex, i32 0, i32 %idxprom
  %0 = load i32, i32* %arrayidx, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_dxop_dispatchRaysDimensions(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
)AAA",
                                      R"AAA(
entry:
  %idxprom = zext i8 %i to i32
  %DispatchRaysDimensions = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 1
  %arrayidx = getelementptr inbounds [2 x i32], [2 x i32]* %DispatchRaysDimensions, i32 0, i32 %idxprom
  %0 = load i32, i32* %arrayidx, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define float @fb_dxop_rayTMin(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %RayTMin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 2
  %0 = load float, float* %RayTMin, align 4
  ret float %0
}

; Function Attrs: nounwind
define float @fb_Fallback_RayTMin(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %RayTMin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 2
  %0 = load float, float* %RayTMin, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetRayTMin(%struct.RuntimeDataStruct* %runtimeData, float %t) #0 {
entry:
  %RayTMin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 2
  store float %t, float* %RayTMin, align 4
  ret void
}

; Function Attrs: nounwind
define float @fb_dxop_rayTCurrent(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %RayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  %0 = load float, float* %RayTCurrent, align 4
  ret float %0
}

; Function Attrs: nounwind
define float @fb_Fallback_RayTCurrent(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %RayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  %0 = load float, float* %RayTCurrent, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetRayTCurrent(%struct.RuntimeDataStruct* %runtimeData, float %t) #0 {
entry:
  %RayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 3
  store float %t, float* %RayTCurrent, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_dxop_rayFlags(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %RayFlags = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 4
  %0 = load i32, i32* %RayFlags, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_Fallback_RayFlags(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %RayFlags = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 4
  %0 = load i32, i32* %RayFlags, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetRayFlags(%struct.RuntimeDataStruct* %runtimeData, i32 %flags) #0 {
entry:
  %RayFlags = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 4
  store i32 %flags, i32* %RayFlags, align 4
  ret void
}

; Function Attrs: nounwind
define float @fb_dxop_worldRayOrigin(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %WorldRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin, i32 0, i32 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define float @fb_Fallback_WorldRayOrigin(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %WorldRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin, i32 0, i32 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetWorldRayOrigin(%struct.RuntimeDataStruct* %runtimeData, float %x, float %y, float %z) #0 {
entry:
  %WorldRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin, i32 0, i32 0
  store float %x, float* %arrayidx, align 4
  %WorldRayOrigin1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx2 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin1, i32 0, i32 1
  store float %y, float* %arrayidx2, align 4
  %WorldRayOrigin3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 5
  %arrayidx4 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayOrigin3, i32 0, i32 2
  store float %z, float* %arrayidx4, align 4
  ret void
}

; Function Attrs: nounwind
define float @fb_dxop_worldRayDirection(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %WorldRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection, i32 0, i32 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define float @fb_Fallback_WorldRayDirection(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %WorldRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection, i32 0, i32 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetWorldRayDirection(%struct.RuntimeDataStruct* %runtimeData, float %x, float %y, float %z) #0 {
entry:
  %WorldRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection, i32 0, i32 0
  store float %x, float* %arrayidx, align 4
  %WorldRayDirection1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx2 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection1, i32 0, i32 1
  store float %y, float* %arrayidx2, align 4
  %WorldRayDirection3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 6
  %arrayidx4 = getelementptr inbounds [3 x float], [3 x float]* %WorldRayDirection3, i32 0, i32 2
  store float %z, float* %arrayidx4, align 4
  ret void
}

; Function Attrs: nounwind
define float @fb_dxop_objectRayOrigin(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %ObjectRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin, i32 0, i32 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define float @fb_Fallback_ObjectRayOrigin(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %ObjectRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin, i32 0, i32 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetObjectRayOrigin(%struct.RuntimeDataStruct* %runtimeData, float %x, float %y, float %z) #0 {
entry:
  %ObjectRayOrigin = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin, i32 0, i32 0
  store float %x, float* %arrayidx, align 4
  %ObjectRayOrigin1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx2 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin1, i32 0, i32 1
  store float %y, float* %arrayidx2, align 4
  %ObjectRayOrigin3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 7
  %arrayidx4 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayOrigin3, i32 0, i32 2
  store float %z, float* %arrayidx4, align 4
  ret void
}

; Function Attrs: nounwind
define float @fb_dxop_objectRayDirection(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %ObjectRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection, i32 0, i32 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define float @fb_Fallback_ObjectRayDirection(%struct.RuntimeDataStruct* %runtimeData, i8 zeroext %i) #0 {
entry:
  %idxprom = zext i8 %i to i32
  %ObjectRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection, i32 0, i32 %idxprom
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetObjectRayDirection(%struct.RuntimeDataStruct* %runtimeData, float %x, float %y, float %z) #0 {
entry:
  %ObjectRayDirection = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection, i32 0, i32 0
  store float %x, float* %arrayidx, align 4
  %ObjectRayDirection1 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx2 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection1, i32 0, i32 1
)AAA",
                                      R"AAA(
  store float %y, float* %arrayidx2, align 4
  %ObjectRayDirection3 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 8
  %arrayidx4 = getelementptr inbounds [3 x float], [3 x float]* %ObjectRayDirection3, i32 0, i32 2
  store float %z, float* %arrayidx4, align 4
  ret void
}

; Function Attrs: nounwind
define float @fb_dxop_objectToWorld(%struct.RuntimeDataStruct* %runtimeData, i32 %r, i8 zeroext %c) #0 {
entry:
  %mul = mul nsw i32 %r, 4
  %conv = zext i8 %c to i32
  %add = add nsw i32 %mul, %conv
  %ObjectToWorld = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld, i32 0, i32 %add
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetObjectToWorld(%struct.RuntimeDataStruct* %runtimeData, <12 x float> %M) #0 {
entry:
  %vecext = extractelement <12 x float> %M, i32 0
  %ObjectToWorld = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld, i32 0, i32 0
  store float %vecext, float* %arrayidx, align 4
  %vecext1 = extractelement <12 x float> %M, i32 1
  %ObjectToWorld2 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx3 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld2, i32 0, i32 1
  store float %vecext1, float* %arrayidx3, align 4
  %vecext4 = extractelement <12 x float> %M, i32 2
  %ObjectToWorld5 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx6 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld5, i32 0, i32 2
  store float %vecext4, float* %arrayidx6, align 4
  %vecext7 = extractelement <12 x float> %M, i32 3
  %ObjectToWorld8 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx9 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld8, i32 0, i32 3
  store float %vecext7, float* %arrayidx9, align 4
  %vecext10 = extractelement <12 x float> %M, i32 4
  %ObjectToWorld11 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx12 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld11, i32 0, i32 4
  store float %vecext10, float* %arrayidx12, align 4
  %vecext13 = extractelement <12 x float> %M, i32 5
  %ObjectToWorld14 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx15 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld14, i32 0, i32 5
  store float %vecext13, float* %arrayidx15, align 4
  %vecext16 = extractelement <12 x float> %M, i32 6
  %ObjectToWorld17 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx18 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld17, i32 0, i32 6
  store float %vecext16, float* %arrayidx18, align 4
  %vecext19 = extractelement <12 x float> %M, i32 7
  %ObjectToWorld20 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx21 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld20, i32 0, i32 7
  store float %vecext19, float* %arrayidx21, align 4
  %vecext22 = extractelement <12 x float> %M, i32 8
  %ObjectToWorld23 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx24 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld23, i32 0, i32 8
  store float %vecext22, float* %arrayidx24, align 4
  %vecext25 = extractelement <12 x float> %M, i32 9
  %ObjectToWorld26 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx27 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld26, i32 0, i32 9
  store float %vecext25, float* %arrayidx27, align 4
  %vecext28 = extractelement <12 x float> %M, i32 10
  %ObjectToWorld29 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx30 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld29, i32 0, i32 10
  store float %vecext28, float* %arrayidx30, align 4
  %vecext31 = extractelement <12 x float> %M, i32 11
  %ObjectToWorld32 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 9
  %arrayidx33 = getelementptr inbounds [12 x float], [12 x float]* %ObjectToWorld32, i32 0, i32 11
  store float %vecext31, float* %arrayidx33, align 4
  ret void
}

; Function Attrs: nounwind
define float @fb_dxop_worldToObject(%struct.RuntimeDataStruct* %runtimeData, i32 %r, i8 zeroext %c) #0 {
entry:
  %mul = mul nsw i32 %r, 4
  %conv = zext i8 %c to i32
  %add = add nsw i32 %mul, %conv
  %WorldToObject = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject, i32 0, i32 %add
  %0 = load float, float* %arrayidx, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetWorldToObject(%struct.RuntimeDataStruct* %runtimeData, <12 x float> %M) #0 {
entry:
  %vecext = extractelement <12 x float> %M, i32 0
  %WorldToObject = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject, i32 0, i32 0
  store float %vecext, float* %arrayidx, align 4
  %vecext1 = extractelement <12 x float> %M, i32 1
  %WorldToObject2 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx3 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject2, i32 0, i32 1
  store float %vecext1, float* %arrayidx3, align 4
  %vecext4 = extractelement <12 x float> %M, i32 2
  %WorldToObject5 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx6 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject5, i32 0, i32 2
  store float %vecext4, float* %arrayidx6, align 4
  %vecext7 = extractelement <12 x float> %M, i32 3
  %WorldToObject8 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx9 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject8, i32 0, i32 3
  store float %vecext7, float* %arrayidx9, align 4
  %vecext10 = extractelement <12 x float> %M, i32 4
  %WorldToObject11 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx12 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject11, i32 0, i32 4
  store float %vecext10, float* %arrayidx12, align 4
  %vecext13 = extractelement <12 x float> %M, i32 5
  %WorldToObject14 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx15 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject14, i32 0, i32 5
  store float %vecext13, float* %arrayidx15, align 4
  %vecext16 = extractelement <12 x float> %M, i32 6
  %WorldToObject17 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx18 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject17, i32 0, i32 6
  store float %vecext16, float* %arrayidx18, align 4
  %vecext19 = extractelement <12 x float> %M, i32 7
  %WorldToObject20 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx21 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject20, i32 0, i32 7
  store float %vecext19, float* %arrayidx21, align 4
  %vecext22 = extractelement <12 x float> %M, i32 8
  %WorldToObject23 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx24 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject23, i32 0, i32 8
  store float %vecext22, float* %arrayidx24, align 4
  %vecext25 = extractelement <12 x float> %M, i32 9
  %WorldToObject26 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx27 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject26, i32 0, i32 9
  store float %vecext25, float* %arrayidx27, align 4
  %vecext28 = extractelement <12 x float> %M, i32 10
  %WorldToObject29 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx30 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject29, i32 0, i32 10
  store float %vecext28, float* %arrayidx30, align 4
  %vecext31 = extractelement <12 x float> %M, i32 11
  %WorldToObject32 = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 10
  %arrayidx33 = getelementptr inbounds [12 x float], [12 x float]* %WorldToObject32, i32 0, i32 11
  store float %vecext31, float* %arrayidx33, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_dxop_primitiveIndex(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 11
  %0 = load i32, i32* %PrimitiveIndex, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_Fallback_PrimitiveIndex(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 11
  %0 = load i32, i32* %PrimitiveIndex, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetPrimitiveIndex(%struct.RuntimeDataStruct* %runtimeData, i32 %i) #0 {
)AAA",
                                      R"AAA(
entry:
  %PrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 11
  store i32 %i, i32* %PrimitiveIndex, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_Fallback_ShaderRecordOffset(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %ShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 15
  %0 = load i32, i32* %ShaderRecordOffset, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetShaderRecordOffset(%struct.RuntimeDataStruct* %runtimeData, i32 %shaderRecordOffset) #0 {
entry:
  %ShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 15
  store i32 %shaderRecordOffset, i32* %ShaderRecordOffset, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_dxop_instanceIndex(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %InstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 12
  %0 = load i32, i32* %InstanceIndex, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_Fallback_InstanceIndex(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %InstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 12
  %0 = load i32, i32* %InstanceIndex, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetInstanceIndex(%struct.RuntimeDataStruct* %runtimeData, i32 %i) #0 {
entry:
  %InstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 12
  store i32 %i, i32* %InstanceIndex, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_dxop_instanceID(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %InstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 13
  %0 = load i32, i32* %InstanceID, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_Fallback_InstanceID(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %InstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 13
  %0 = load i32, i32* %InstanceID, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetInstanceID(%struct.RuntimeDataStruct* %runtimeData, i32 %i) #0 {
entry:
  %InstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 13
  store i32 %i, i32* %InstanceID, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_dxop_hitKind(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %HitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 14
  %0 = load i32, i32* %HitKind, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_Fallback_HitKind(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %HitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 14
  %0 = load i32, i32* %HitKind, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetHitKind(%struct.RuntimeDataStruct* %runtimeData, i32 %i) #0 {
entry:
  %HitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 14
  store i32 %i, i32* %HitKind, align 4
  ret void
}

; Function Attrs: nounwind
define float @fb_dxop_pending_rayTCurrent(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PendingRayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 16
  %0 = load float, float* %PendingRayTCurrent, align 4
  ret float %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetPendingRayTCurrent(%struct.RuntimeDataStruct* %runtimeData, float %t) #0 {
entry:
  %PendingRayTCurrent = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 16
  store float %t, float* %PendingRayTCurrent, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_dxop_pending_primitiveID(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PendingPrimitiveIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 17
  %0 = load i32, i32* %PendingPrimitiveIndex, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_Fallback_PendingShaderRecordOffset(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PendingShaderRecordOffset = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 21
  %0 = load i32, i32* %PendingShaderRecordOffset, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_dxop_pending_instanceIndex(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PendingInstanceIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 18
  %0 = load i32, i32* %PendingInstanceIndex, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_dxop_pending_instanceID(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PendingInstanceID = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 19
  %0 = load i32, i32* %PendingInstanceID, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_dxop_pending_hitKind(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %PendingHitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 20
  %0 = load i32, i32* %PendingHitKind, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetPendingHitKind(%struct.RuntimeDataStruct* %runtimeData, i32 %i) #0 {
entry:
  %PendingHitKind = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 20
  store i32 %i, i32* %PendingHitKind, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_Fallback_GroupIndex(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %GroupIndex = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 22
  %0 = load i32, i32* %GroupIndex, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define i32 @fb_Fallback_AnyHitResult(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %AnyHitResult = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 23
  %0 = load i32, i32* %AnyHitResult, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetAnyHitResult(%struct.RuntimeDataStruct* %runtimeData, i32 %result) #0 {
entry:
  %AnyHitResult = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 23
  store i32 %result, i32* %AnyHitResult, align 4
  ret void
}

; Function Attrs: nounwind
define i32 @fb_Fallback_AnyHitStateId(%struct.RuntimeDataStruct* %runtimeData) #0 {
entry:
  %AnyHitStateId = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 24
  %0 = load i32, i32* %AnyHitStateId, align 4
  ret i32 %0
}

; Function Attrs: nounwind
define void @fb_Fallback_SetAnyHitStateId(%struct.RuntimeDataStruct* %runtimeData, i32 %id) #0 {
entry:
  %AnyHitStateId = getelementptr inbounds %struct.RuntimeDataStruct, %struct.RuntimeDataStruct* %runtimeData, i32 0, i32 24
  store i32 %id, i32* %AnyHitStateId, align 4
  ret void
}


attributes #0 = { nounwind }
attributes #1 = { nounwind }
)AAA"};

#include <sstream>
static std::string getRuntimeString() {
  std::ostringstream out;
  for (size_t i = 0; i < _countof(runtimeString); ++i)
    out << runtimeString[i];

  return out.str();
}
