#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv)
{
FILE *f1 = NULL, *f2 = NULL, *fo = NULL;
char *ptr, *ptrp, **list = NULL;
char buf[512];
char *language, *lang_abbrev;
int num, max, i, j, l, done, question = 1, error = -1;
 int ne1 = 0, ne2 = 0, nl1 = 0, nl2 = 0;
static char i18n_version_string[] = "# XPaint Messages version ";
static char i18n_file[] = "share/messages/Messages";
char i18n_local[256];
char *i18n_out;

    if (argc <= 2) {
       fprintf(stderr, "Usage: ./msgedit <language> <LANG abbreviation>\n");
       fprintf(stderr, "Language incorrectly specified. Aborting !!\n");
       exit(-1);
    }
    /* get version string from first line */

    if (argc >= 3 && !strncmp(argv[2], "-noq", 4))
        question = 0;
    language = argv[1];
    lang_abbrev = argv[2];
    lang_abbrev[2] = '\0';
    for (i=0; i<=1; i++) lang_abbrev[i] = tolower(lang_abbrev[i]);

    sprintf(i18n_local, "%s_%s", i18n_file, lang_abbrev);
    i18n_out = strrchr(i18n_local, '/') + 1;

    f1 = fopen(i18n_file, "r");
    if (!f1) {
       fprintf(stderr, "Cannot open language file %s !!\n", i18n_file);
    error:
       if (f1) fclose(f1);
       if (f2) fclose(f2);
       if (fo) fclose(fo);
       if (list) {
           for(l=0; l<=max; l++) free(list[l]);
           free(list);
       }
       exit(error);
    }

    f2 = fopen(i18n_local, "r");
    if (!f2) {
       fprintf(stdout, "Cannot find language file %s,\n", i18n_local);
       fprintf(stdout, "Creating new language file %s.\n", i18n_out);
    }

    fo = fopen(i18n_out, "wb");
    if (!fo) {
       fprintf(stderr, "Cannot create new language file %s !!\n", i18n_out);
       goto error;
    }
    
    num = 0;
    if (!f2) {
       list = malloc(sizeof(char *));
    } else
    while ((ptrp = fgets(buf, 510, f2))) {
       l = strlen(ptrp)-1;
       if (ptrp[l]=='\n') {
          ptrp[l] = '\0';
	  --l;
       }      
       while(l>=0 && isspace(ptrp[l])) {
	  ptrp[l] = '\0';
	  --l;
       }
       if (!*ptrp) continue;
       list = (char **) realloc(list, (num+2)*sizeof(char *));
       list[num] = strdup(ptrp);
       ++num;
    }
    list[num] = strdup("");
    max = num;

    ptr = fgets(buf, 510, f1);
    l = strlen(i18n_version_string);
    if (strncmp(ptr, i18n_version_string, l)) {
        fprintf(stderr, "Language file %s does not begin with required version "
                "string !!\n", i18n_file);
        goto error;
    }
    ptr += l;
    l = strlen(ptr)-1;
    if (ptr[l]=='\n') {
       ptr[l] = '\0';
       --l;
    }
    while(l>=0 && isspace(ptr[l])) {
       ptr[l] = '\0';
       --l;
    }

    fprintf(fo, "# XPaint Messages version %s, %s\n", ptr, language);

    num = 0;
    while ((ptr = fgets(buf, 510, f1))) {
       l = strlen(ptr)-1;
       if (ptr[l]=='\n') {
          ptr[l] = '\0';
	  --l;
       }
       while(l>=0 && isspace(ptr[l])) {
	  ptr[l] = '\0';
	  --l;
       }
       if (l<0) continue;
       if (*ptr!='#') {
	   ++ne2;
	   if (!done) {
               fprintf(fo, "%s%s\n", ((question)?"????|":""), ptr);
               ++nl2;
               
	   }
           continue;
       }
       if (*ptr=='#') {
	  ++ne1;
          for (i=0; i<=l; i++) {
	      if (isspace(ptr[i])) {
		 ptr[i] = '\0';
		 break;
	      }
	  }
          ++nl1;
          fprintf(fo, "%s\n", ptr);
          done  = 0;
          for (i=0; i<max-1; i++) {
	      if (!strcmp(ptr, list[i])) {
		  j = i+1;
		  while (list[j][0] != '#') {
                      fprintf(fo, "%s\n", list[j++]);
                      ++nl2;
		  }
                  done = 1;
                  break;
	      }
	  }
       }
    }

    error = 0;
    fprintf(stdout, "Language file %s generated.\n", i18n_out);
    fprintf(stdout, "Read : en #%d, %d lines | written: %s #%d, %d lines.\n", 
            ne1, ne2, lang_abbrev, nl1, nl2);
    goto error;
}
