.TH xinput 1 __xorgversion__

.SH NAME
xinput - utility to configure and test X input devices

.SH SYNOPSIS
.B xinput [OPTIONS] [DEVICE]

.SH DESCRIPTION
xinput is a utility to list available input devices, query information about
a device and change input device settings.
.SH OPTIONS
.TP 8
.B --version
Test if the X Input extension is available and return the version number
of the program and the version supported by the server. This option does not
require a device name.
.PP
.TP 8
.B --list [--short || --long || --name-only || --id-only] [\fIdevice\fP]
If no argument is given list all the input devices. If an argument is given,
show all the features of \fIdevice\fP.
If --long is provided, the output includes detailed information about the
capabilities of each devices. Otherwise, or if --short is provided, only the
device names and some minimal information is listed.
If --name-only is provided, the output is limited to the device names. One
device name is listed per line. Note that the order the devices are listed
is undefined.
If --id-only is provided, the output is limited to the device IDs. One
device ID is listed per line. Note that the order the devices are listed is
undefined.
.PP
.TP 8
.B --get-feedbacks \fIdevice\fP
Display the feedbacks of \fIdevice\fP.
.PP
.TP 8
.B --set-pointer \fIdevice\fP
Switch \fIdevice\fP in core pointer.
This option does nothing on X servers 1.5 and later.
.PP
.TP 8
.B --set-mode \fIdevice\fP \fIABSOLUTE|RELATIVE\fP
Change the mode of \fIdevice\fP.
.PP
.TP 8
.B --set-ptr-feedback \fIdevice\fP \fIthreshold\fP \fInum\fP \fIdenom\fP
Change the pointer acceleration (or feedback) parameters of \fIdevice\fP.
The xset(__appmansuffix__) man page has more details. For X.Org Server 1.7
and above, there are additional device properties pertaining to pointer
acceleration. These do not replace, but complement the pointer feedback
setting.
.PP
.TP 8
.B --set-integer-feedback \fIdevice\fP \fIindex\fP \fIvalue\fP
Change the value of an integer feedback of \fIdevice\fP.
.PP
.TP 8
.B --set-button-map \fIdevice\fP \fImap_button_1\fP [\fImap_button_2\fP [\fI...\fP]]
Change the button mapping of \fIdevice\fP. The buttons are specified in
physical order (starting with button 1) and are mapped to the logical button
provided. 0 disables a button. The default button mapping for a device is 1
2 3 4 5 6 etc.
.PP
.TP 8
.B --query-state \fIdevice\fP
Query the device state.
.PP
.TP 8
.B --list-props \fIdevice\fP [\fIdevice\fP [\fI...\fP]]
Lists properties that can be set for the given device(s).
.PP
.TP 8
.B --set-int-prop \fIdevice\fP \fIproperty\fP \fIformat\fP \fIvalue\fP
Sets an integer property for the device.  Appropriate values for \fIformat\fP
are 8, 16, or 32, depending on the property. Deprecated, use
.B --set-prop
instead.
.PP
.TP 8
.B --set-float-prop \fIdevice\fP \fIproperty\fP \fIvalue\fP
Sets a float property for the device. Deprecated, use
.B --set-prop
instead.
.PP
.TP 8
.B --set\-prop [\-\-type=\fIatom|float|int\fP] [\-\-format=\fI8|16|32\fP] \fIdevice\fP \fIproperty\fP \fIvalue\fP [...]
Set the property to the given value(s).  If not specified, the format and type
of the property are left as-is.  The arguments are interpreted according to the
property type.
.PP
.TP 8
.B --watch-props \fIdevice\fP
Prints to standard out when property changes occur.
.PP
.TP 8
.B --delete-prop \fIdevice\fP \fIproperty\fP
Delete the property from the device.
.PP
.TP 8
.B --test [-proximity] \fIdevice\fP
Register all extended events from \fIdevice\fP and enter an endless
loop displaying events received. If the -proximity is given, ProximityIn
and ProximityOut are registered.
.PP
.TP 8
.B --test-xi2 [\fIdevice\fP]
Register for a number of XI2 events and display them. If a device is given,
only events on this device are displayed.
.PP
.TP 8
.B --create-master \fIprefix\fP [sendCore] [enable]
Create a new pair of master devices on an XI2-enabled server with the given
\fIprefix\fP. The server will create one master pointer named "\fIprefix\fP
pointer" and one master keyboard named "\fIprefix\fP keyboard".  If
\fIsendCore\fP is 1, this pair of master devices is set to send core events
(default).  If \fIenable\fP is 1, this master device pair will be enabled
immediately (default).
.PP
.TP 8
.B --remove-master \fImaster\fP [Floating|AttachToMaster] [returnPointer] [returnKeyboard]
Remove \fImaster\fP  and its paired master device. Attached slave devices
are set floating if \fIFloating\fP is specified or the argument is omitted.
If the second argument is \fIAttachToMaster\fP, \fIreturnPointer\fP
specifies the master pointer to attach all slave pointers to and
\fIreturnKeyboard\fP specifies the master keyboard to attach all slave
keyboards to.
.PP
.TP 8
.B --reattach \fIslave\fP \fImaster\fP
Reattach \fIslave\fP to \fImaster\fP.
.PP
.TP 8
.B --float \fIslave\fP
Remove \fIslave\fP from its current master device.
.PP
.TP 8
.B --set-cp \fIwindow\fP \fImaster\fP
Set the ClientPointer for the client owning \fIwindow\fP to \fImaster\fP.
\fImaster\fP must specify a master pointer.
.PP
.TP 8
.B --map-to-output \fIdevice\fP \fIcrtc\fP
Restricts the movements of the absolute \fIdevice\fP to the RandR
\fIcrtc\fP. The output name must match a currently connected output (see
\fIxrandr(__appmansuffix__)\fP). If the NVIDIA binary driver is
detected or RandR 1.2 or later is not available, a Xinerama output may be
specified as "HEAD-N", with N being the Xinerama screen number. This option
has no effect on relative devices.
.PP
\fIdevice\fP can be the device name as a string or the XID of the
device.
.PP
\fIslave\fP can be the device name as a string or the XID of a slave
device.
.PP
\fImaster\fP can be the device name as a string or the XID of a master
device.
.PP
\fIproperty\fP can be the property as a string or the Atom value.
.PP
.SH "SEE ALSO"
X(__miscmansuffix__), xset(__appmansuffix__), xrandr(__appmansuffix__)
.SH COPYRIGHT
Copyright 1996,1997, Frederic Lepied.
.PP
Copyright 2007, Peter Hutterer.
.PP
Copyright 2008, Philip Langdale.
.PP
Copyright 2009-2011, Red Hat, Inc.

.SH AUTHORS

.nf
Peter Hutterer <peter.hutterer@who-t.net>
Philip Langdale, <philipl@alumni.utexas.net>
Frederic Lepied, France <Frederic.Lepied@sugix.frmug.org>
Julien Cristau <jcristau@debian.org>
Thomas Jaeger <ThJaeger@gmail.com>
and more.
.fi
