.TH XSCOPE 1 __xorgversion__
.SH NAME
xscope - X Window Protocol Viewer
.SH SYNOPSIS
.B xscope
[\fB-i\fP\fI<in-port>\fP] [\fB-o\fP\fI<out-port>\fP]
[\fB-h\fP\fI<server-host>\fP] [\fB-d\fP\fI<display-number>\fP]
[\fB-q\fP] [\fB-v\fP\fI<n>\fP] [\fB-r\fP]
[\fB-D\fP\fI<debug-level>\fP] [-I] [\fB-S\fP\fI<n>\fP] [\fB-t\fP]
.SH DESCRIPTION
.I Xscope
sits in-between an X11 client and an X11 server and prints the contents
of each request, reply, error, or event that is communicated between them.
.I Xscope
can decode the core X11 protocol and several extensions, including
BIG-REQUESTS, LBX, MIT-SHM, NCD-WinCenterPro, RANDR, and RENDER.
This information can be useful in debugging and performance
tuning of X11 servers and clients.
.PP
To operate, \fIxscope\fP must know the host, port, and display to use
to connect to the X11 server.  In addition, it must know the port on
which it should listen for X11 clients.  Two cases are common:
.PP
.TP 5
(1) The X11 server is on the same host as \fIxscope\fP.
In this case, the input port for \fIxscope\fP should be selected as an
X11 server on a different display, and the client DISPLAY argument
adjusted to select \fIxscope\fP .  For example, if the X11 server is
on port 6001, display 1, then \fIxscope\fP can use port 6002 as its
input port.  The client can use display 1 for direct access to X11 or
display 2 for access to \fIxscope\fP.
.PP
.TP 5
(2) The X11 server is on a different host than \fIxscope\fP.
In this case the same input and output ports can be used, and the host
component of the DISPLAY is used to select \fIxscope\fP or X11.
.SH ARGUMENTS
.PP
.TP 10
.BI \-i <input-port>
Specify the port that \fIxscope\fP will use to take requests from clients
(defaults to 1).
For X11, this port is automatically biased by 6000.
.PP
.TP 10
.BI \-o <output-port>
Determines the port that
\fIxscope\fP will use to connect to X11 (defaults to 0).
For X11, this port is automatically biased by 6000.
.PP
.TP 10
.BI \-h <host>
Determines the host that  \fIxscope\fP will use to find its X11 server.
.PP
.TP 10
.BI \-d <display>
Defines the display number.  The display number is added to the input
and output port to give the actual ports which are used by  \fIxscope\fP.
.PP
.TP 10
.BI \-f <filename>
Instead of decoding a live session, reads previously captured raw data
from a file to decode.
.PP
.TP 10
.B \-q
Quiet output mode.  Gives only the names of requests, replies, errors, and
events, but does not indicate contents.
.PP
.TP 10
.BI \-v <print-level>
Determines the level of printing which \fIxscope\fP will provide.  The
print-level can be 0 (same as quiet mode), 1, 2, 3, 4.  The larger
numbers give more and more output.  For example, a successful setup
returns a string which is the name of the vendor of the X11 server.
At level 1, the explicit field giving the length of the string is
suppressed since it can be inferred from the string.  At level 2 and
above the length is explicitly printed.
.PP
.TP 10
.B -r
Print only raw data without decoding it.
.PP
.TP 10
.BI -D <debug-level>
Print debugging information at the specified level.
.PP
.TP 10
.BI -I
Enter interactive mode at startup.
.PP
.TP 10
.BI -S <n>
Toggle output on or off when SIGUSR1 is received.  If \fIn\fP is 0,
the initial state is off.  If \fIn\fP is 1, the initial state is on.
.PP
.TP 10
.B -t
Terminate \fIxscope\fP when all clients close.
.SH INTERACTIVE MODE
.PP
When \fBxscope\fP receives an interrupt signal (normally generated by
Control-C) or is started with the -I flag, it enters an interactive mode
in which it prompts for commands.
Available commands in this mode are:
.TP 10
.B audio, a
Show current verbosity level for NAS protocol packets.
.TP 10
\fBaudio\fP \fIn\fP, \fBa\fP \fIn\fP
Set current verbosity level for NAS protocol packets to \fIn\fP.
.TP 10
.B break, b
List currently defined breakpoints.
.TP 10
\fBbreak\fP \fIrequest...\fP, \fBb\fP \fIrequest...\fP
Create a breakpoint for the specified protocol requests.  The breakpoint
will be enabled by default.   When the breakpoint is enabled, \fBxscope\fP
will stop for interactive commands after processing a request of the
specified type.   Requests and extensions may be specified by name or number.
If an extension is followed by a ":" and a number, it will only
break for the specified minor opcode for that extension.   Note that since
extension opcodes are not known until the extension is first seen, breakpoints
cannot currently be set on extensions until after a QueryExtension request
and reply are processed for that extension, so users may need to initially
set a breakpoint on QueryExtension, and after processing that set the
breakpoint for the target extension.
.TP 10
.B cont, c
Resume processing of data passing between server and clients.
.TP 10
.B delete, del
Delete all breakpoints.
.TP 10
\fBdelete\fP \fIbreakpoint...\fP, \fBdel\fP \fIbreakpoint...\fP
Delete listed breakpoints, specified by number.
.TP 10
.B disable, d
Disable all breakpoints.
.TP 10
\fBdisable\fP \fIbreakpoint...\fP, \fBd\fP \fIbreakpoint...\fP
Disable listed breakpoints, specified by number.
.TP 10
.B enable, e
Enable all breakpoints.
.TP 10
\fBenable\fP \fIbreakpoint...\fP, \fBe\fP \fIbreakpoint...\fP
Enable listed breakpoints, specified by number.
.TP 10
.B help, ?
Print list of available commands.
.TP 10
\fBhelp\fP \fIcommand...\fP, \fB?\fP \fIcommand...\fP
Describe specified command or commands.
.TP 10
.B level, l
Show current verbosity level for X11 protocol packets.
.TP 10
\fBlevel\fP \fIn\fP, \fBl\fP \fIn\fP
Set current verbosity level for X11 protocol packets to \fIn\fP.
.TP 10
.B quit, q
Quit \fBxscope\fP.
.TP 10
.B step, s
Process one request, then prompt for another command.
.SH EXAMPLES
.LP
xscope -v4 -hcleo -d0 -o0 -i1
.PP
This command would have xscope communicate with an X11 server on host
``cleo'', display 0;  xscope itself would be available on the current
host as display 1 (display of 0 plus the 1 of -i1). Verbose level 4.
.LP
xscope -q -d1 -o1 -o3
.PP
The X11 server for the current host, display 2 (1 for -d1 plus 1 for -o1)
would be used by xscope which would run as display 4 (1 for -d1 plus 3 for
-o3). Quiet mode (verbose level 0).
.SH SEE ALSO
.BR X (__miscmansuffix__),
.BR Xsecurity (__miscmansuffix__),
X11 Protocol and extension protocol documents
.SH AUTHOR
.PP
James L. Peterson (MCC)
.PP
Copyright (C) 1988 MCC
.PP
Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of MCC not be used in
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  MCC makes no
representations about the suitability of this software for any purpose.  It
is provided "as is" without express or implied warranty.
.PP
MCC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL MCC BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

