.\" Copyright 1999 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbFreeGeomProperties __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbFreeGeomProperties \- Free geometry properties
.SH SYNOPSIS
.HP
.B void XkbFreeGeomProperties
.BI "(\^XkbGeometryPtr " "geom" "\^,"
.BI "int " "first" "\^,"
.BI "int " "count" "\^,"
.BI "Bool *" "free_all" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- geom
geometry in which properties should be freed
.TP
.I \- first
first property to be freed 
.TP
.I \- count
number of properties to be freed 
.TP
.I \- free_all
True => all properties are freed
.SH DESCRIPTION
.LP
Xkb provides a number of functions to allocate and free subcomponents of a 
keyboard geometry. Use these functions to create or modify keyboard geometries. 
Note that these functions merely allocate space for the new element(s), and it 
is up to you to fill in the values explicitly in your code. These allocation 
functions increase 
.I sz_* 
but never touch 
.I num_* 
(unless there is an allocation failure, in which case they reset both 
.I sz_* 
and 
.I num_* 
to zero). These functions return Success if they succeed, BadAlloc if they are 
not able to allocate space, or BadValue if a parameter is not as expected.

If 
.I free_all 
is True, all properties are freed regardless of the value of 
.I first 
or 
.I count. 
Otherwise, 
.I count 
properties are freed beginning with the one specified by 
.I first.
.SH "RETURN VALUES"
.TP 15
Success
The XkbFreeGeomProperties function returns Success when there are no allocation 
or argument errors.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadValue
An argument is out of range
