'\" t
.\"     Title: xgrabdevicebutton
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.77.1 <http://docbook.sf.net/>
.\"      Date: 03/09/2013
.\"    Manual: \ \&
.\"    Source: \ \&
.\"  Language: English
.\"
.TH "XGRABDEVICEBUTTON" "libmansuffix" "03/09/2013" "\ \&" "\ \&"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XGrabDeviceButton, XUngrabDeviceButton \- grab/ungrab extension input device buttons
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
int XGrabDeviceButton( Display *display,
                       XDevice *device,
                       unsigned int button,
                       unsigned int modifiers,
                       XDevice* modifier_device,
                       Window grab_window,
                       Bool owner_events,
                       unsigned int event_count,
                       XEventClass *event_list,
                       int this_device_mode,
                       int other_devices_mode);
.fi
.sp
.nf
int XUngrabDeviceButton( Display *display,
                         XDevice *device,
                         unsigned int button,
                         unsigned int modifiers,
                         XDevice* modifier_device,
                         Window grab_window);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       Specifies the device that is to be grabbed or released
.fi
.sp
.nf
button
       Specifies the device button that is to be grabbed or
       released or AnyButton\&.
.fi
.sp
.nf
modifiers
       Specifies the set of keymasks or AnyModifier\&.The mask is
       the bitwise inclusive OR of the valid keymask bits\&.
       Valid bits are: Shiftmask, LockMask, ControlMask,
       Mod1Mask, Mod2Mask,Mod3Mask, Mod4Mask, Mod5Mask\&.
.fi
.sp
.nf
modifier_device
       specifies the device whose modifiers are to be used\&. If
       the modifier_devicespecified is NULL, the X keyboard
       will be used as the modifier_device\&.
.fi
.sp
.nf
grab_window
       Specifies the grab window\&.
.fi
.sp
.nf
owner_events
       Specifies a Boolean value that indicates whether the
       deviceevents are to be reported as usual or reported
       with respect to the grab windowif selected by the event
       list\&.
.fi
.sp
.nf
event_count
       Specifies the number of event classes in the event list\&.
.fi
.sp
.nf
event_list
       Specifies which events are reported to the client\&.
.fi
.sp
.nf
this_device_mode
       Specifies further processing of events from this
       device\&.You can pass GrabModeSync or GrabModeAsync\&.
.fi
.sp
.nf
other_devices_mode
       Specifies further processing of events from all other
       devices\&.You can pass GrabModeSync or GrabModeAsync\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The XGrabDeviceButton request establishes a passive grab\&. In
the future, the device is actively grabbed (as for XGrabDevice,
the last\-grab time is set to the time at which the button was
pressed (as transmitted in the DeviceButtonPress event), and
the DeviceButtonPress event is reported if all of the following
conditions are true:
  * The device is not grabbed, and the specified button is
    logically pressed when the specified modifier keys are
    logically down on the specified modifier device and no
    other buttons or modifier keys are logically down\&.
  * Either the grab window is an ancestor of (or is) the focus
    window, OR the grab window is a descendent of the focus
    window and contains the device\&.
  * A passive grab on the same button/modifier combination does
    not exist on any ancestor of grab_window\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The interpretation of the remaining arguments is as for
XGrabDevice\&. The active grab is terminated automatically when
the logical state of the device has all buttons released
(independent of the logical state of the modifier keys)\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
Note that the logical state of a device (as seen by client
applications) may lag the physical state if device event
processing is frozen\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
This request overrides all previous grabs by the same client on
the same button/modifier combinations on the same window\&. A
modifiers of AnyModifier is equivalent to issuing the grab
request for all possible modifier combinations (including the
combination of no modifiers)\&. It is not required that all
modifiers specified have currently assigned KeyCodes\&. A button
of AnyButton is equivalent to issuing the request for all
possible buttons\&. Otherwise, it is not required that the
specified button currently be assigned to a physical button\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
A modifier_device of NULL indicates that the X keyboard is to
be used as the modifier_device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If some other client has already issued a XGrabDeviceButton
with the same button/modifier combination on the same window, a
BadAccess error results\&. When using AnyModifier or AnyButton ,
the request fails completely, and a BadAccess error results (no
grabs are established) if there is a conflicting grab for any
combination\&. XGrabDeviceButton has no effect on an active grab\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XGrabDeviceButton can generate BadClass, BadDevice, BadMatch,
BadValue, and BadWindow errors\&.\&.P The XUngrabDeviceButton
request releases the passive grab for a button/modifier
combination on the specified window if it was grabbed by this
client\&. A modifier of AnyModifier is equivalent to issuing the
ungrab request for all possible modifier combinations,
including the combination of no modifiers\&. A button of
AnyButton is equivalent to issuing the request for all possible
buttons\&. XUngrabDeviceButton has no effect on an active grab\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
A modifier_device of NULL indicates that the X keyboard should
be used as the modifier_device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XUngrabDeviceButton can generate BadDevice, BadMatch, BadValue
and BadWindow errors\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The specified device
       does not exist or has not been opened by this client via
       XOpenInputDevice\&. This error may also occur if the
       specified device is the X keyboard or X pointer device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       This error may occur if an XGrabDeviceButton request was
       made specifying a device that has no buttons, or
       specifying a modifier device that has no keys\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       Some numeric value falls outside the range of values
       accepted by the request\&. Unless a specific range is
       specified for an argument, the full range defined by the
       argument\*(Aqs type is accepted\&. Any argument defined as a
       set of alternatives can generate this error\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadWindow
       A value for a Window argument does not name a defined
       Window\&.
.fi
.if n \{\
.RE
.\}
.SH "SEE ALSO"
.sp
.if n \{\
.RS 4
.\}
.nf
XAllowDeviceEvents(libmansuffix), XGrabDevice(libmansuffix), XGrabDeviceKey(libmansuffix)
.fi
.if n \{\
.RE
.\}
