---
title: Flashing the Dell Latitude E6400
x-toc-enable: true
...

Introduction
============

Initial flashing instructions for the E6400. DO NOT flash the Nvidia GPU
variant. This page pertains only to the Intel GPU variant.

This guide is for those who want Canoeboot on their Latitude E6400 while
they still have the original Dell BIOS present. This guide can also be
followed (adapted) if you brick your E6400, and you want to recover it.

This board can boot entirely blob-free in the flash. The hardware is similar
to that of ThinkPad X200, T400 etc where no-ME setup is possible.

A note about GPUs
-----------------

Models with Intel graphics are GM45, and fully supported in Canoeboot
with native initialisation; ROM images are available since.
**The Intel video initialisation is libre, implemented with publicly available
source code via libgfxinit, from the coreboot project.**

Flash chip size {#flashchips}
===============

Use this to find out:

	flashrom -p internal

We believe most/all are 4MB (32Mb) flash sizes, but larger ROM images are
provided for people who wish to upgrade.

MAC address {#macaddress}
===========

The MAC address is part of the ROM image that you're flashing. You can change
it at any time, before or after you've flashed Canoeboot; you can also change
it in the *Dell* BIOS, if you really want to. This is for the onboard gigabit
ethernet device.

Refer to [mac\_address.md](../hardware/mac_address.md).

It is recommended that you run *nvmutil*. See:

[nvmutil usage manual](nvmutil.md)

The `nvmutil` software is specifically designed for changing MAC addresses,
and it implements a few more safeguards (e.g. prevents multicast/all-zero
MAC addresses) and features (MAC address randomisation, ability to correct or
intententionally corrupt(disable) GbE sections if you wish, swap GbE parts,
etc). You can *also* run ich9gen, if you wish:

[ich9gen usage manual](ich9utils.md)

Intel GPU: libre video initialisation available
===============================================

Canoeboot uses coreboot's native `libgfxinit` on this platform, for
variants with Intel graphics.

How to flash internally (no diassembly)
=======================================

Warning for BSD users
---------------------

+**NOTE: The util is now called `dell-flash-unlock`, but it
+was previously called `e6400-flash-unlock`. Links have been updated.**

BSD *boots* and works properly on these machines, but take note:

Nicholas's [dell-flash-unlock](https://browse.libreboot.org/lbmk.git/plain/util/dell-flash-unlock/dell_flash_unlock.c)
utility has been ported to OpenBSD, but *other* BSDs are assumed unsupported for
now. The `flashrom` software is available on BSD systems. Canoeboot's build
system has *itself* not yet been ported to the BSDs, but you can use the
flash unlock utility.

NOTE: BSD is mentioned above, but the only BSD tested for `dell-flash-unlock`
is OpenBSD, as of 15 October 2023.

Flashing from GNU+Linux
-------------------

MAKE SURE you boot with this GNU+Linux kernel parameter: `iomem=relaxed` - this
disables memory protections, permitting `/dev/mem` access needed by flashrom.
The flash is memory mapped and flashrom accesses it via `/dev/mem`.

You can flash Canoeboot directly from the vendor (Dell) BIOS, without taking
the machine apart. It can be done entirely from GNU+Linux. It will probably also
work on BSD systems, but it has only been testing on GNU+Linux thus far.

**NOTE: The util is now called `dell-flash-unlock`, but it
was previously called `e6400-flash-unlock`. Links have been updated.**

Check `util/dell-flash-unlock` in the `cbmk.git` repository, or in release
archives for Canoeboot releases from 20231026 onward.

Go in there:

	cd util/dell-flash-unlock
	make

With this program, you can unlock the flash in such a way where everything
is writeable. Information about how to use it is in the `README.md` file which
is included in that program's directory, or you can read it online here:

<https://browse.libreboot.org/lbmk.git/plain/util/dell-flash-unlock/README.md>

Literally just run that program, and do what it says. You run it once, and shut
down, and when you do, the system brings itself back up automatically.  Then
you run it and flash it unlocked. Then you run it again. The source code is
intuitive enough that you can easily get the gist of it; it's writing some EC
commands and changing some chipset config bits. The EC on this machine is
hooked up to the `GPIO33` signal, sometimes called `HDA_DOCK_EN`, which sets
the flash descriptor override thus disabling any flash protection by the IFD.
It also bypasses the SMM BIOS lock protection by disabling SMIs, and Dell's
BIOS doesn't set any other type of protection either such as writing to
Protected Range registers.

When you flash it, you can use this command:

	flashrom -p internal -w canoeboot.rom

Where `canoeboot.rom` is your E6400 ROM. *Make sure* it's the right one.
If flashrom complains about multiple flash chips detected, just pick one of
them (doesn't matter which one). On *most* Dell machines, the most correct
would probably be this option in flashrom: `-c MX25L3205D/MX25L3208D`.

So:

	flashrom -p internal -w canoeboot.rom -c MX25L3205D/MX25L3208D

When you see flashrom say `VERIFIED` at the end, that means the flash was
successful. If you don't see that, or you're unsure, please [contact the
Canoeboot project via IRC](../../contact.md).

BACK UP THE FACTORY BIOS
========================

The `-w` option flashes `canoeboot.rom`. You may consider *backing up* the
original Dell BIOS first, using the -r option:

	flashrom -p internal -r backup.rom -c MX25L3205D/MX25L3208D

Do this while in a flashable state, after the 2nd run of `dell-flash-unlock`.

Make sure the `backup.rom` file gets backed up to an external storage media,
not the E6400 itself.

With this method, you can probably flash it within 5 minutes. Again, zero
disassembly required!

How to flash externally
=========================

Refer to [spi.md](spi.md) as a guide for external re-flashing.

The SPI flash chip shares a voltage rail with the ICH9 southbridge, which is
not isolated using a diode. As a result, powering the flash chip externally
causes the ICH9 to partially power up and attempt to drive the SPI clock pin
low, which can interfere with programmers such as the Raspberry Pi. See
[RPi Drive Strength](spi.md#rpi-drive-strength) for a workaround.

Have a look online for videos showing how to disassemble, if you wish to
externally re-flash.

