---
title: ThinkPad T500 external flashing
x-toc-enable: true
...

<div class="specs">
<center>
<img tabindex=1 alt="ThinkPad T500" class="p" src="https://av.libreboot.org/t500/0062.jpg" /><span class="f"><img src="https://av.libreboot.org/t500/0062.jpg" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | Lenovo                                         |
| **Name**                   | ThinkPad T500                                  |
| **Released**               | 2009                                           |
| **Chipset**                | Intel Cantiga GM45                             |
| **CPU**                    | Intel Core 2 Duo (Penryn family). A Quad-core 
                        mod exists, replacing the Core 2 Duo with a Core Quad |
| **Graphics**               | Intel GMA 4500MHD (and ATI Mobility Radeon HD 
                                                         3650 on some models) |
| **Display**                | 1280x800/1680x1050/1920x1200 TFT               |
| **Memory**                 | 2 or 4GB (Upgradable to 8GB)                   |
| **Architecture**           | x86_64                                         |
| **EC**                     | Proprietary                                    |
| **Original boot firmware** | LenovoBIOS                                     |
| **Intel ME/AMD PSP**       | Present. Can be completly disabled.            |
| **Flash chip**             | SOIC-8/SOIC-16/WSON-8 4MiB/8MiB (Upgradable 
                                                                    to 16MiB) |
```
W+: Works without blobs; 
N: Doesn't work; 
W*: Works with blobs; 
U: Untested; 
P+: Partially works; 
P*: Partially works with blobs
```

| ***Features*** |                                       |
|----------------|---------------------------------------|
| **Internal flashing with original boot firmware** | N  |
| **Display**                                       | W+ |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |
| **External output**                               | W+ |
| **Display brightness**                            | P+ |

| ***Payloads supported***  |           |
|---------------------------|-----------|
| **GRUB**              | Works     |
| **SeaBIOS**               | Works     |
| **SeaBIOS with GRUB** | Works     |
</div>

Dell Latitude E6400
===================

**If you haven't bought an T500 yet: the [Dell Latitude
E6400](../install/latitude.md) is much easier to flash; no disassembly required,
it can be flashed entirely in software from Dell BIOS to Canoeboot. It is the
same hardware generation (GM45), with same CPUs, video processor, etc.**

Introduction
============

It is believed that all or most T500 laptops are compatible. See notes
about [CPU
compatibility](#cpu_compatibility) for
potential incompatibilities.

W500 is also compatible, and mostly the same design as T500.

There are two possible flash chip sizes for the T500: 4MiB (32Mbit) or
8MiB (64Mbit). This can be identified by the type of flash chip below
the palmrest: 4MiB is SOIC-8, 8MiB is SOIC-16.

*The T500 laptops come with the ME (and sometimes AMT in addition)
before flashing canoeboot. Canoeboot disables and removes it by using a
modified descriptor: see [../install/ich9utils.md](../install/ich9utils.md)*
(contains notes, plus instructions)

Flashing instructions can be found at
[../install/\#flashprog](../install/#flashprog)

NOTE: Canoeboot standardises on [flashprog](https://flashprog.org/wiki/Flashprog)
now, as of 27 January 2024, which is a fork of flashrom.

EC update {#ecupdate}
=========

It is recommended that you update to the latest EC firmware version. The
[EC firmware](../../faq.md#ec-embedded-controller-firmware) is separate from
Canoeboot, so we don't actually provide that, but if you still have
Lenovo BIOS then you can just run the Lenovo BIOS update utility, which
will update both the BIOS and EC version. See:

-   [../install/#flashprog](../install/#flashprog)
-   <http://www.thinkwiki.org/wiki/BIOS_update_without_optical_disk>

NOTE: this can only be done when you are using Lenovo BIOS. How to
update the EC firmware while running Canoeboot is unknown. Canoeboot
only replaces the BIOS firmware, not EC.

Updated EC firmware has several advantages e.g. bettery battery
handling.

The T500 is almost identical to the X200, code-wise. See
[x200.md](x200.md).

Installation notes
==================

[External flashing](spi.md) required, if Lenovo BIOS is running.

This guide is for those who want Canoeboot on their ThinkPad T500 while
they still have the original Lenovo BIOS present. This guide can also be
followed (adapted) if you brick your T500, to know how to recover.

W500 is also mostly compatible with this guide.

Serial port {#serial_port}
-----------

EHCI debug might not be needed. It has been reported that the docking
station for this laptop has a serial port, so it might be possible to
use that instead.

A note about CPUs
=================

[ThinkWiki](http://www.thinkwiki.org/wiki/Category:T500) has a list of
CPUs for this system. The Core 2 Duo P8400, P8600 and P8700 are believed
to work with Canoeboot. The T9600 was also tested on the T400 and
confirmed working.

T9550 and T9900 was tested by a user, and is compatible as reported in the IRC channel.
T9500 and T9400 may also work, but YMMV.

Quad-core CPUs
--------------
Very likely to be compatible, but requires hardware modification.
Based on info from German forum post about installing Core Quad CPU on T500 found in coreboot mailing list. Currently work in progress and no guide available.

Q9100 is compatible and confirmed working (after hw mod), as reported by users in the IRC
channel

- [Coreboot mailing list post](https://mail.coreboot.org/pipermail/coreboot/2016-November/082463.html)
- [German forum post about install Core Quad on T500](https://thinkpad-forum.de/threads/199129)

This video from FrostKiwi (Libera IRC) does a nice illustration and explains
everything nicely:

<https://yewtu.be/watch?v=Fs4GjDiOie8>

A note about GPUs
=================

Some models have an Intel GPU, while others have both an ATI and an
Intel GPU; this is referred to as "switchable graphics". In the *BIOS
setup* program for lenovobios, you can specify that the system will use
one or the other (but not both).

Canoeboot is known to work on systems with only the Intel GPU, using
native graphics initialization. On systems with switchable graphics, the
Intel GPU is used and the ATI GPU is disabled, so native graphics
initialization works all the same.

CPU paste required
==================

See [\#paste](#paste).

Flash chip size {#flashchips}
===============

Use this to find out:

	flashprog -p internal

MAC address {#macaddress}
===========

Refer to [mac\_address.md](mac_address.md).

Clip wiring
===========

Refer to [spi.md](spi.md) as a guide for external re-flashing.

The procedure
-------------

Remove all screws:\
![](https://av.canoeboot.org/t500/0000.jpg)\
It is also advisable to, throughout the disassembly, place any screws
and/or components that you removed in the same layout or arrangement.
The follow photos demonstrate this:\
![](https://av.canoeboot.org/t500/0001.jpg) ![](https://av.canoeboot.org/t500/0002.jpg)

Remove the HDD/SSD and optical drive:\
![](https://av.canoeboot.org/t500/0003.jpg) ![](https://av.canoeboot.org/t500/0004.jpg)

Remove the palm rest:\
![](https://av.canoeboot.org/t500/0005.jpg) ![](https://av.canoeboot.org/t500/0006.jpg)

Remove the keyboard and rear bezel:\
![](https://av.canoeboot.org/t500/0007.jpg) ![](https://av.canoeboot.org/t500/0008.jpg)
![](https://av.canoeboot.org/t500/0009.jpg) ![](https://av.canoeboot.org/t500/0010.jpg)
![](https://av.canoeboot.org/t500/0011.jpg) ![](https://av.canoeboot.org/t500/0012.jpg)

If you have a WWAN/3G card and/or sim card reader, remove them
permanently. The WWAN-3G card has proprietary firmware inside; the
technology is identical to what is used in mobile phones, so it can also
track your movements:\
![](https://av.canoeboot.org/t500/0013.jpg) ![](https://av.canoeboot.org/t500/0017.jpg)
![](https://av.canoeboot.org/t500/0018.jpg)

Remove this frame, and then remove the wifi chip:\
![](https://av.canoeboot.org/t500/0014.jpg) ![](https://av.canoeboot.org/t500/0015.jpg)
![](https://av.canoeboot.org/t500/0016.jpg)

Remove the speakers:\
![](https://av.canoeboot.org/t500/0019.jpg) ![](https://av.canoeboot.org/t500/0020.jpg)
![](https://av.canoeboot.org/t500/0021.jpg) ![](https://av.canoeboot.org/t500/0022.jpg)
![](https://av.canoeboot.org/t500/0023.jpg) ![](https://av.canoeboot.org/t500/0024.jpg)
![](https://av.canoeboot.org/t500/0025.jpg)

Remove the NVRAM battery (already removed in this photo):\
![](https://av.canoeboot.org/t500/0026.jpg)

When you re-assemble, you will be replacing the wifi chip with another.
These two screws don't hold anything together, but they are included in
your system because the screw holes for half-height cards are a
different size, so use these if you will be installing a half-height
card:\
![](https://av.canoeboot.org/t500/0027.jpg)

Unroute the antenna wires:\
![](https://av.canoeboot.org/t500/0028.jpg) ![](https://av.canoeboot.org/t500/0029.jpg)
![](https://av.canoeboot.org/t500/0030.jpg) ![](https://av.canoeboot.org/t500/0031.jpg)

Disconnect the LCD cable from the motherboard:\
![](https://av.canoeboot.org/t500/0032.jpg) ![](https://av.canoeboot.org/t500/0033.jpg)

Remove the LCD assembly hinge screws, and then remove the LCD assembly:\
![](https://av.canoeboot.org/t500/0034.jpg) ![](https://av.canoeboot.org/t500/0035.jpg)
![](https://av.canoeboot.org/t500/0036.jpg)

Remove the fan and heatsink:\
![](https://av.canoeboot.org/t500/0037.jpg) ![](https://av.canoeboot.org/t500/0038.jpg)
![](https://av.canoeboot.org/t500/0039.jpg)

Remove this screw:\
![](https://av.canoeboot.org/t500/0040.jpg)

Remove these cables, keeping note of how and in what arrangement they
are connected:\
![](https://av.canoeboot.org/t500/0041.jpg) ![](https://av.canoeboot.org/t500/0042.jpg)
![](https://av.canoeboot.org/t500/0043.jpg) ![](https://av.canoeboot.org/t500/0044.jpg)
![](https://av.canoeboot.org/t500/0045.jpg) ![](https://av.canoeboot.org/t500/0046.jpg)
![](https://av.canoeboot.org/t500/0047.jpg) ![](https://av.canoeboot.org/t500/0048.jpg)
![](https://av.canoeboot.org/t500/0049.jpg)

Disconnect the power jack:\
![](https://av.canoeboot.org/t500/0050.jpg) ![](https://av.canoeboot.org/t500/0051.jpg)

Remove the motherboard and cage from the base (the marked hole is where
those cables were routed through):\
![](https://av.canoeboot.org/t500/0052.jpg) ![](https://av.canoeboot.org/t500/0053.jpg)

Remove all screws, arranging them in the same layout when placing the
screws on a surface and marking each screw hole (this is to reduce the
possibility of putting them back in the wrong holes):\
![](https://av.canoeboot.org/t500/0054.jpg) ![](https://av.canoeboot.org/t500/0055.jpg)

Also remove this:\
![](https://av.canoeboot.org/t500/0056.jpg) ![](https://av.canoeboot.org/t500/0057.jpg)

Separate the motherboard from the cage:\
![](https://av.canoeboot.org/t500/0058.jpg) ![](https://av.canoeboot.org/t500/0059.jpg)

The flash chip is next to the memory slots. On this system, it was a
SOIC-8 (4MiB or 32Mb) flash chip:\
![](https://av.canoeboot.org/t500/0060.jpg)

Connect your programmer, then connect GND and 3.3V\
![](https://av.canoeboot.org/t500/0061.jpg)\
![](https://av.canoeboot.org/t400/0067.jpg) ![](https://av.canoeboot.org/t400/0069.jpg)
![](https://av.canoeboot.org/t400/0070.jpg) ![](https://av.canoeboot.org/t400/0071.jpg)

Now flash Canoeboot.

Thermal paste (IMPORTANT)
=========================

Because part of this procedure involved removing the heatsink, you will
need to apply new paste. Arctic MX-4 is ok. You will also need isopropyl
alcohol and an anti-static cloth to clean with.

When re-installing the heatsink, you must first clean off all old paste
with the alcohol/cloth. Then apply new paste. Arctic MX-4 is also much
better than the default paste used on these systems.

![](https://av.canoeboot.org/t400/paste.jpg)

NOTE: the photo above is for illustration purposes only, and does not
show how to properly apply the thermal paste. Other guides online detail
the proper application procedure.

Wifi
====

It is recommended that you install a new wifi chipset. This can only be
done after installing Canoeboot, because the original firmware has a
whitelist of approved chips, and it will refuse to boot if you use an
'unauthorized' wifi card.

The following photos show an Atheros AR5B95 being installed, to replace
the Intel chip that this T500 came with:\
![](https://av.canoeboot.org/t400/0012.jpg) ![](https://av.canoeboot.org/t400/ar5b95.jpg)

WWAN
====

If you have a WWAN/3G card and/or sim card reader, remove them
permanently. The WWAN-3G card has DMA, and proprietary firmware inside;
the technology is identical to what is used in mobile phones, so it can
also track your movements.

Not to be confused with wifi (wifi is fine).

Memory
======

In DDR3 machines with Cantiga (GM45/GS45/PM45), northbridge requires sticks
that will work as PC3-8500 (faster PC3/PC3L sticks can work as PC3-8500).
Non-matching pairs may not work. Single module (meaning, one of the slots
will be empty) will currently only work in slot 0.

NOTE: according to users reports, non matching pairs (e.g. 1+2 GiB) might
work in some cases.

Make sure that the RAM you buy is the 2Rx8 configuration when buying 4GiB sticks
(In other words: maximum of 2GiB per rank, 2 ranks per card).

[This page](http://www.forum.thinkpads.com/viewtopic.php?p=760721) might
be useful for RAM compatibility info (note: coreboot raminit is
different, so this page might be BS)

The following photo shows 8GiB (2x4GiB) of RAM installed:\
![](https://av.canoeboot.org/t400/memory.jpg)

Boot it!
--------

You should see something like this:

![](https://av.canoeboot.org/t500/0062.jpg)

Now [install GNU+Linux](../gnulinux/).
