/*
 * Some or all of this work - Copyright (c) 2006 - 2013, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Resource Descriptor macros
 *
 * Word Space Resource Descriptor Macro
 */

Name (p430, Package() {

	// Byte 4 (General Flags) of Word Address Space Descriptor

	ResourceTemplate () {
		WordSpace (0xc0, ResourceProducer, PosDecode, MinNotFixed, MaxNotFixed, 0x0a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc1, ResourceProducer, PosDecode, MinNotFixed, MaxFixed, 0x1a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc2, ResourceProducer, PosDecode, MinFixed, MaxNotFixed, 0x2a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc3, ResourceProducer, PosDecode, MinFixed, MaxFixed, 0x3a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc4, ResourceProducer, SubDecode, MinNotFixed, MaxNotFixed, 0x4a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc5, ResourceProducer, SubDecode, MinNotFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc6, ResourceProducer, SubDecode, MinFixed, MaxNotFixed, 0x6a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc7, ResourceProducer, SubDecode, MinFixed, MaxFixed, 0x7a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc8, ResourceConsumer, PosDecode, MinNotFixed, MaxNotFixed, 0x8a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc9, ResourceConsumer, PosDecode, MinNotFixed, MaxFixed, 0x9a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xca, ResourceConsumer, PosDecode, MinFixed, MaxNotFixed, 0xaa,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xcb, ResourceConsumer, PosDecode, MinFixed, MaxFixed, 0xba,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xcc, ResourceConsumer, SubDecode, MinNotFixed, MaxNotFixed, 0xca,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xcd, ResourceConsumer, SubDecode, MinNotFixed, MaxFixed, 0xda,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xce, ResourceConsumer, SubDecode, MinFixed, MaxNotFixed, 0xea,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xff, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0xfa,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},

	// Byte 5 (Type Specific Flags) of Word Address Space Descriptor

	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0x00,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},
	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0xff,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff)
	},

	// Particular cases

	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			 , )
	},
	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			 , , )
	},

	// Resource Source

	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0x01, "")
	},
	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0x0f, "P")
	},
	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xf0, "PATH")
	},
	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff,
			"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !\"#$%&'()*",
			)
	},

	// Particular cases

	ResourceTemplate () {
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0xff, "PATHPATHPATH", WSP0)
	},
	ResourceTemplate () {
		WordSpace (0xc0, ResourceConsumer, SubDecode, MinFixed, MaxFixed, 0,
			0, 0, 0, 0, 0,
			0xff, "PATHPATHPATH", )
	},

	// 20051021, relaxation for omitted ResourceSource (bug-fix 70 rejection)
	ResourceTemplate () {
		WordSpace (0xc0, , , , , 0x5a,
			0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff,
			0x0f)
	},
})

/*
ACPI Specification, Revision 3.0, September 2, 2004
6.4.3.5.3   Word Address Space Descriptor

Memory Word Address Space Descriptor layout:

Byte 0 (Tag Bits): Value=10001000B (0x88) (Type = 1, Large item name = 0x8)
Byte 1 (Length, bits[7:0]): Variable: Value = 13 (minimum)
Byte 2 (Length, bits[15:8]): Variable: Value = 0 (minimum)
Byte 3 (Resource Type):
	192-255	Hardware Vendor Defined
Byte 4 (General Flags):
	Bits[7:4] 	Reserved (must be 0)
	Bit[3] 		Min Address Fixed, _MAF:
			1	The specified maximum address is fixed
			0	The specified maximum address is not fixed
				and can be changed
	Bit[2] 		Max Address Fixed,_MIF:
			1	The specified minimum address is fixed
			0	The specified minimum address is not fixed
				and can be changed
	Bit[1] 		Decode Type, _DEC:
			1	This bridge subtractively decodes this address
	 	 	 	(top level bridges only)
			0	This bridge positively decodes this address
	Bit[0] 		Consumer/Producer:
			1-This device consumes this resource
			0-This device produces and consumes this resource
Byte 5 (Type Specific Flags):
		Flags that are specific to each resource type. The meaning of the flags
		in this field depends on the value of the Resource Type field (see above)
Byte 6 (Address space granularity, _GRA bits[7:0]):
	A set bit in this mask means that this bit is decoded. All bits less
	significant than the most significant set bit must be set. (in other
	words, the value of the full Address Space Granularity field (all 16
	bits) must be a number (2**n-1).
Byte 7 (Address space granularity, _GRA bits[15:8])
Byte 8 (Address range minimum, _MIN bits [7:0]):
	For bridges that translate addresses, this is the address space
	on the secondary side of the bridge
Byte 9 (Address range minimum, _MIN bits[15:8])
Byte 10 (Address range maximum, _MAX bits [7:0]): See comment for _MIN
Byte 11 (Address range maximum, _MAX bits[15:8])
Byte 12 (Address Translation offset, _TRA bits [7:0]):
	For bridges that translate addresses across the bridge, this is the
	offset that must be added to the address on the secondary side to obtain
	the address on the primary side. Non-bridge devices must list 0 for all
	Address Translation offset bits
Byte 13 (Address Translation offset, _TRA bits[15:8])
Byte 14 (Address Length, _LEN bits [7:0])
Byte 15 (Address Length, _LEN bits[15:8])
Byte 16 (Resource Source Index):
	(Optional) Only present if Resource Source (below) is present. This
	field gives an index to the specific resource descriptor that this
	device consumes from in the current resource template for the device
	object pointed to in Resource Source
String (Resource Source):
	(Optional) If present, the device that uses this descriptor consumes
	its resources from the resources produced by the named device object.
	If not present, the device consumes its resources out of a global pool.
	If not present, the device consumes this resource from its hierarchical
	parent.
*/

Name (p431, Package() {

	// Byte 4 (General Flags) of Word Address Space Descriptor

	Buffer () {0x88, 0x0d, 0x00, 0xc0, 0x00, 0x0a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc1, 0x08, 0x1a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc2, 0x04, 0x2a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc3, 0x0c, 0x3a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc4, 0x02, 0x4a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc5, 0x0a, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc6, 0x06, 0x6a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc7, 0x0e, 0x7a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc8, 0x01, 0x8a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc9, 0x09, 0x9a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xca, 0x05, 0xaa,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xcb, 0x0d, 0xba,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xcc, 0x03, 0xca,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xcd, 0x0b, 0xda,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xce, 0x07, 0xea,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xff, 0x0f, 0xfa,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},

	// Byte 5 (Type Specific Flags) of Word Address Space Descriptor

	Buffer () {0x88, 0x0d, 0x00, 0xc0, 0x01, 0x00,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc0, 0x01, 0xff,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},

	// Particular cases

	Buffer () {0x88, 0x0d, 0x00, 0xc0, 0x01, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},
	Buffer () {0x88, 0x0d, 0x00, 0xc0, 0x01, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe, 0x79, 0x00},

	// Resource Source

	Buffer () {0x88, 0x0f, 0x00, 0xc0, 0x01, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
		0x01, 0x00, 0x79, 0x00},
	Buffer () {0x88, 0x10, 0x00, 0xc0, 0x01, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
		0x0f, 0x50, 0x00, 0x79, 0x00},
	Buffer () {0x88, 0x13, 0x00, 0xc0, 0x01, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
		0xf0, 0x50, 0x41, 0x54, 0x48, 0x00, 0x79, 0x00},
	Buffer () {0x88, 0xd7, 0x00, 0xc0, 0x01, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
		0xff,
		0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
		0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
		0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
		0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
		0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
		0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
		0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
		0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
		0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
		0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
		0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
		0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21,
		0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
		0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
		0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
		0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
		0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
		0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
		0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
		0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
		0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
		0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
		0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
		0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x20, 0x21, 0x22,
		0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
		0x00, 0x79, 0x00},

	// Particular cases

	Buffer () {0x88, 0x1b, 0x00, 0xc0, 0x0f, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
		0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
		0x48, 0x50, 0x41, 0x54, 0x48, 0x00, 0x79, 0x00},
	Buffer () {0x88, 0x1b, 0x00, 0xc0, 0x0f, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0xff, 0x50, 0x41, 0x54, 0x48, 0x50, 0x41, 0x54,
		0x48, 0x50, 0x41, 0x54, 0x48, 0x00, 0x79, 0x00},

	// 20051021, relaxation for omitted ResourceSource (bug-fix 70 rejection)
	Buffer () {0x88, 0x0e, 0x00, 0xc0, 0x01, 0x5a,
		0xf7, 0xf6, 0xf9, 0xf8, 0xfb, 0xfa, 0xfd, 0xfc, 0xff, 0xfe,
		0x0f, 0x79, 0x00},
})

Method(RT16)
{
	Name(ts, "RT16")

	// Emit test header, set the filename

	THDR (ts, "WordSpace Resource Descriptor Macro", __FILE__)

    // Main test case for packages above

	m330(ts, 27, "p430", p430, p431)

    // Check resource descriptor tag offsets

	Store (
		ResourceTemplate () {
			WordSpace (0xc0, ResourceProducer, PosDecode, MinNotFixed, MaxNotFixed, 0x5a,
				0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff, , , WSP0)
			WordSpace (0xc0, ResourceConsumer, PosDecode, MinNotFixed, MaxNotFixed, 0x5a,
				0xf6f7, 0xf8f9, 0xfafb, 0xfcfd, 0xfeff, , , WSP1)
		}, Local0)

	m331(ts, 1,  WSP0._DEC, 0x21, WSP1._DEC, 0xa1, "_DEC")
	m331(ts, 2,  WSP0._MIF, 0x22, WSP1._MIF, 0xa2, "_MIF")
	m331(ts, 3,  WSP0._MAF, 0x23, WSP1._MAF, 0xa3, "_MAF")
	m331(ts, 7,  WSP0._GRA, 0x30, WSP1._GRA, 0xB0, "_GRA")
	m331(ts, 8,  WSP0._MIN, 0x40, WSP1._MIN, 0xC0, "_MIN")
	m331(ts, 9,  WSP0._MAX, 0x50, WSP1._MAX, 0xD0, "_MAX")
	m331(ts, 10, WSP0._TRA, 0x60, WSP1._TRA, 0xE0, "_TRA")
	m331(ts, 11, WSP0._LEN, 0x70, WSP1._LEN, 0xF0, "_LEN")
}
