/*
 * Some or all of this work - Copyright (c) 2006 - 2017, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Resource Descriptor macros
 *
 * PinGroup Resource Descriptor Macro
 */

Name (P460, Package() {
    ResourceTemplate () {
        PinGroup ("group1", ResourceProducer, GRP1,
                  RawDataBuffer () {0xaa, 0xbb, 0xcc}) {1, 2, 3, 4}
    },
    ResourceTemplate () {
        PinGroup ("group2", ResourceProducer, GRP2) {1, 2, 3, 4}
    },
    ResourceTemplate () {
        PinGroup ("group3", ResourceProducer) {1, 2, 3, 4}
    },
    ResourceTemplate () {
        PinGroup ("group4") {1, 2, 3, 4}
    },
    ResourceTemplate () {
        PinGroup ("group5",, GRP3) {1, 2, 3, 4}
    },
    ResourceTemplate () {
        PinGroup ("group6",,, RawDataBuffer () {0xaa, 0xbb, 0xcc}) {1, 2, 3, 4}
    },
    ResourceTemplate () {
        PinGroup ("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
                  ,, RawDataBuffer () {0xaa, 0xbb, 0xcc}) {1, 2, 3, 4}
    },
    // Minimal
    ResourceTemplate () {
        PinGroup ("a") {1, 2, 3, 4}
    },
})

Name (P461, Package () {
    Buffer (0x22)
    {
        /* 0000 */  0x90, 0x1D, 0x00, 0x01, 0x00, 0x00, 0x0E, 0x00,  /* ........ */
        /* 0008 */  0x16, 0x00, 0x1D, 0x00, 0x03, 0x00, 0x01, 0x00,  /* ........ */
        /* 0010 */  0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x67, 0x72,  /* ......gr */
        /* 0018 */  0x6F, 0x75, 0x70, 0x31, 0x00, 0xAA, 0xBB, 0xCC,  /* oup1.... */
        /* 0020 */  0x79, 0x00                                       /* y. */
    },
    Buffer (0x1F)
    {
        /* 0000 */  0x90, 0x1A, 0x00, 0x01, 0x00, 0x00, 0x0E, 0x00,  /* ........ */
        /* 0008 */  0x16, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x01, 0x00,  /* ........ */
        /* 0010 */  0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x67, 0x72,  /* ......gr */
        /* 0018 */  0x6F, 0x75, 0x70, 0x32, 0x00, 0x79, 0x00         /* oup2.y. */
    },
    Buffer (0x1F)
    {
        /* 0000 */  0x90, 0x1A, 0x00, 0x01, 0x00, 0x00, 0x0E, 0x00,  /* ........ */
        /* 0008 */  0x16, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x01, 0x00,  /* ........ */
        /* 0010 */  0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x67, 0x72,  /* ......gr */
        /* 0018 */  0x6F, 0x75, 0x70, 0x33, 0x00, 0x79, 0x00         /* oup3.y. */
    },
    Buffer (0x1F)
    {
        /* 0000 */  0x90, 0x1A, 0x00, 0x01, 0x00, 0x00, 0x0E, 0x00,  /* ........ */
        /* 0008 */  0x16, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x01, 0x00,  /* ........ */
        /* 0010 */  0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x67, 0x72,  /* ......gr */
        /* 0018 */  0x6F, 0x75, 0x70, 0x34, 0x00, 0x79, 0x00         /* oup4.y. */
    },
    Buffer (0x1F)
    {
        /* 0000 */  0x90, 0x1A, 0x00, 0x01, 0x00, 0x00, 0x0E, 0x00,  /* ........ */
        /* 0008 */  0x16, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x01, 0x00,  /* ........ */
        /* 0010 */  0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x67, 0x72,  /* ......gr */
        /* 0018 */  0x6F, 0x75, 0x70, 0x35, 0x00, 0x79, 0x00         /* oup5.y. */
    },
    Buffer (0x22)
    {
        /* 0000 */  0x90, 0x1D, 0x00, 0x01, 0x00, 0x00, 0x0E, 0x00,  /* ........ */
        /* 0008 */  0x16, 0x00, 0x1D, 0x00, 0x03, 0x00, 0x01, 0x00,  /* ........ */
        /* 0010 */  0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x67, 0x72,  /* ......gr */
        /* 0018 */  0x6F, 0x75, 0x70, 0x36, 0x00, 0xAA, 0xBB, 0xCC,  /* oup6.... */
        /* 0020 */  0x79, 0x00                                       /* y. */
    },
    Buffer (0x011C)
    {
        /* 0000 */  0x90, 0x17, 0x01, 0x01, 0x00, 0x00, 0x0E, 0x00,  /* ........ */
        /* 0008 */  0x16, 0x00, 0x17, 0x01, 0x03, 0x00, 0x01, 0x00,  /* ........ */
        /* 0010 */  0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x41, 0x41,  /* ......AA */
        /* 0018 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0020 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0028 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0030 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0038 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0040 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0048 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0050 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0058 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0060 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0068 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0070 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0078 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0080 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0088 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0090 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0098 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00A0 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00A8 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00B0 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00B8 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00C0 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00C8 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00D0 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00D8 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00E0 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00E8 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00F0 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 00F8 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0100 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0108 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,  /* AAAAAAAA */
        /* 0110 */  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x00, 0xAA,  /* AAAAAA.. */
        /* 0118 */  0xBB, 0xCC, 0x79, 0x00                           /* ..y. */
    },
    Buffer (0x1A)
    {
        /* 0000 */  0x90, 0x15, 0x00, 0x01, 0x00, 0x00, 0x0E, 0x00,  /* ........ */
        /* 0008 */  0x16, 0x00, 0x18, 0x00, 0x00, 0x00, 0x01, 0x00,  /* ........ */
        /* 0010 */  0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x61, 0x00,  /* ......a. */
        /* 0018 */  0x79, 0x00                                       /* y. */
    }
})

Method(RT28,, Serialized)
{
    Name(TS, "RT28")

    // Emit test header, set the filename

    THDR (TS, "PinGroup Resource Descriptor Macro", __FILE__)

    // The main test packages must have the same number of entries

    If (LNotEqual (SizeOf (P460), SizeOf (P461)))
    {
        Err (TS, 179, 0, 0, 0, 0, "Incorrect package length")
        Return ()
    }

    // Main test case for packages above

    m330(TS, SizeOf (P460), "P460", P460, P461)

    // Check resource descriptor tag offsets
    Local0 = ResourceTemplate () {
        PinGroup ("group0", ResourceProducer, GRP0, RawDataBuffer () {0xaa, 0xbb, 0xcc})
            {1, 2, 3, 4}
        PinGroup ("group1", ResourceProducer, GRP1, RawDataBuffer () {0xaa, 0xbb, 0xcc})
            {1, 2, 3, 4}
    }

    m331(TS, 1, GRP0._VEN, 0xE8, GRP1._VEN, 0x1E8, "_VEN")
    m331(TS, 1, GRP0._PIN, 0x70, GRP1._PIN, 0x170, "_PIN")
}
