DefinitionBlock(
	"tblm0047.aml",   // Output filename
	"DSDT",     // Signature
	0x02,       // DSDT Revision
	"Intel",    // OEMID
	"Many",     // TABLE ID
	0x00000001  // OEM Revision
	) {

	/*
	 * ACPICA API Test Suite.
	 * Support Table Management test 0047.
	 * Implements the following functional ASL Methods:
	 * INIT - preparing for emulation of a SSDT in an OpRegion,
	 * LD - loading the SSDT by Load ASL operator,
	 * UNLD - unloading the SSDT  by UnLoad ASL operator,
	 * _PPC - a Method for evaluation in the SSDT.
	 */


	Name (SMIF, 0x00)
	Name (TRP0, 0x00)
	Name (DTSE, 0x00)

	Name (PPCS, "PPCS")

    Method (TRAP, 1, Serialized)
    {
        Store (Arg0, SMIF)
        Store (Zero, TRP0)
        Return (SMIF)
    }

    Scope (_PR)
    {
        Processor (CPU0, 0x00, 0x00001010, 0x06) {}
        Processor (CPU1, 0x01, 0x00001010, 0x06)
        {
            Method (_INI, 0, NotSerialized)
            {
                If (DTSE)
                {
                    TRAP (0x46)
                }
            }
        }
    }

	// SSDT
	Name(BUF0, Buffer() {
		0x53, 0x53, 0x44, 0x54, 0xfa, 0x01, 0x00, 0x00, 0x01, 0xf8, 0x50, 0x6d, 0x52, 0x65, 0x66, 0x00,
		0x43, 0x70, 0x75, 0x30, 0x49, 0x73, 0x74, 0x00, 0x00, 0x30, 0x00, 0x00, 0x49, 0x4e, 0x54, 0x4c,
		0x24, 0x06, 0x05, 0x20, 0x10, 0x45, 0x1d, 0x5c, 0x2e, 0x5f, 0x50, 0x52, 0x5f, 0x43, 0x50, 0x55,
		0x30, 0x14, 0x0b, 0x5f, 0x50, 0x50, 0x43, 0x00, 0xa4, 0x50, 0x50, 0x43, 0x53, 0x14, 0x47, 0x07,
		0x5f, 0x50, 0x43, 0x54, 0x00, 0xa0, 0x41, 0x04, 0x90, 0x7b, 0x43, 0x46, 0x47, 0x44, 0x0a, 0x01,
		0x00, 0x7b, 0x50, 0x44, 0x43, 0x30, 0x0a, 0x01, 0x00, 0xa4, 0x12, 0x2c, 0x02, 0x11, 0x14, 0x0a,
		0x11, 0x82, 0x0c, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x79, 0x00, 0x11, 0x14, 0x0a, 0x11, 0x82, 0x0c, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0x00, 0xa4, 0x12, 0x2c, 0x02, 0x11, 0x14, 0x0a, 0x11, 0x82,
		0x0c, 0x00, 0x01, 0x10, 0x00, 0x00, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0x00,
		0x11, 0x14, 0x0a, 0x11, 0x82, 0x0c, 0x00, 0x01, 0x08, 0x00, 0x00, 0xb3, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x79, 0x00, 0x14, 0x1a, 0x58, 0x50, 0x53, 0x53, 0x00, 0xa0, 0x0e, 0x7b, 0x50,
		0x44, 0x43, 0x30, 0x0a, 0x01, 0x00, 0xa4, 0x4e, 0x50, 0x53, 0x53, 0xa4, 0x53, 0x50, 0x53, 0x53,
		0x08, 0x53, 0x50, 0x53, 0x53, 0x12, 0x46, 0x06, 0x03, 0x12, 0x20, 0x06, 0x0c, 0x29, 0x07, 0x00,
		0x00, 0x0c, 0x78, 0x69, 0x00, 0x00, 0x0c, 0x6e, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x00, 0x00, 0x00,
		0x0c, 0x83, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x12, 0x20, 0x06, 0x0c, 0x35, 0x05,
		0x00, 0x00, 0x0c, 0x38, 0x4a, 0x00, 0x00, 0x0c, 0x6e, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x00, 0x00,
		0x00, 0x0c, 0x83, 0x01, 0x00, 0x00, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x12, 0x20, 0x06, 0x0c, 0xe8,
		0x03, 0x00, 0x00, 0x0c, 0xc8, 0x32, 0x00, 0x00, 0x0c, 0x6e, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x00,
		0x00, 0x00, 0x0c, 0x83, 0x02, 0x00, 0x00, 0x0c, 0x02, 0x00, 0x00, 0x00, 0x08, 0x5f, 0x50, 0x53,
		0x53, 0x12, 0x46, 0x06, 0x03, 0x12, 0x20, 0x06, 0x0c, 0x29, 0x07, 0x00, 0x00, 0x0c, 0x78, 0x69,
		0x00, 0x00, 0x0c, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0x2c, 0x0b, 0x00,
		0x00, 0x0c, 0x2c, 0x0b, 0x00, 0x00, 0x12, 0x20, 0x06, 0x0c, 0x35, 0x05, 0x00, 0x00, 0x0c, 0x38,
		0x4a, 0x00, 0x00, 0x0c, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0x20, 0x08,
		0x00, 0x00, 0x0c, 0x20, 0x08, 0x00, 0x00, 0x12, 0x20, 0x06, 0x0c, 0xe8, 0x03, 0x00, 0x00, 0x0c,
		0xc8, 0x32, 0x00, 0x00, 0x0c, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0x17,
		0x06, 0x00, 0x00, 0x0c, 0x17, 0x06, 0x00, 0x00, 0x14, 0x41, 0x05, 0x5f, 0x50, 0x53, 0x44, 0x00,
		0xa0, 0x38, 0x7b, 0x43, 0x46, 0x47, 0x44, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x00, 0xa0, 0x1a, 0x7b,
		0x50, 0x44, 0x43, 0x30, 0x0a, 0x20, 0x00, 0xa4, 0x12, 0x0f, 0x01, 0x12, 0x0c, 0x05, 0x0a, 0x05,
		0x0a, 0x00, 0x0a, 0x00, 0x0a, 0xfd, 0x0a, 0x02, 0xa4, 0x12, 0x0f, 0x01, 0x12, 0x0c, 0x05, 0x0a,
		0x05, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0xfe, 0x0a, 0x02, 0xa4, 0x12, 0x0f, 0x01, 0x12, 0x0c, 0x05,
		0x0a, 0x05, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0xfc, 0x0a, 0x02,
	})

	External (\_PR_.CPU0._PPC, MethodObj)

	Name (HI0, 0x00)
	Name (HI0F, 0x00)
	Name (INIF, 0x00)

	OperationRegion (IST0, SystemMemory, 0, 0x1FA)
	Field(IST0, ByteAcc, NoLock, Preserve) {
		RFU0, 0xFD0,
	}

	Method(INIT)
	{
		if (INIF) {
			Store("INIT: OpRegion has been initialized previously", Debug)
			Return (1)
		}
		Store(BUF0, RFU0)
		Store(1, INIF)
		Store("INIT: OpRegion initialized with SSDT", Debug)

		Return (0)
	}

	Method(LD)
	{
		if (HI0F) {
			Store("LD: SSDT has been loaded previously", Debug)
			Return (1)
		}

//		Load(IST0, HI0)
		Load(RFU0, HI0)
		Store(1, HI0F)
		Store("LD: SSDT Loaded", Debug)
		Return (0)
	}

	Method(UNLD)
	{
		if (LNotEqual(HI0F, 1)) {
			Store("UNLD: SSDT has not been loaded ", Debug)
			Return (1)
		}

		UnLoad(HI0)
		Store("UNLD: SSDT UnLoaded", Debug)
		Store(0, HI0)
		Store(0, HI0F)

		Return (0)
	}

	Method(MAIN)
	{
		INIT()
		INIT()

		LD()
		LD()

		Store("1: Try _PPC", Debug)
		Store(\_PR_.CPU0._PPC(), Debug)

		UNLD()
		UNLD()

		Store("2: Try _PPC", Debug)
		Store(\_PR_.CPU0._PPC(), Debug)
	}
}
