/*
 * Some or all of this work - Copyright (c) 2006 - 2017, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Resource Descriptor macros
 *
 * PinFunction Resource Descriptor Macro
 */

Name (P45C, Package() {
    ResourceTemplate () {
        PinFunction(Exclusive, PullDefault, 0x1000, "\\_SB.GPO1", 0x0,
            ResourceConsumer,, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    },
    ResourceTemplate () {
        PinFunction(Exclusive, PullDown, 0x2000, "\\_SB.GPO1", 0x0,
            ResourceConsumer,, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    },
    ResourceTemplate () {
        PinFunction(Exclusive, PullUp, 0x3000, "\\_SB.GPO1", 0x0,
            ResourceConsumer,, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    },
    ResourceTemplate () {
        PinFunction(Exclusive, PullNone, 0x4000, "\\_SB.GPO1", 0x0,
            ResourceConsumer,, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    },
    ResourceTemplate () {
        PinFunction(Shared, PullDefault, 0x1000, "\\_SB.GPO1", 0x0,
            ResourceConsumer,, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    },
    ResourceTemplate () {
        PinFunction(Shared, PullDown, 0x2000, "\\_SB.GPO1", 0x0,
            ResourceConsumer,, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    },
    ResourceTemplate () {
        PinFunction(Shared, PullUp, 0x3000, "\\_SB.GPO1", 0x0,
            ResourceConsumer,, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    },
    ResourceTemplate () {
        PinFunction(Shared, PullNone, 0x4000, "\\_SB.GPO1", 0x0,
            ResourceConsumer,, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    },
    ResourceTemplate () {
        PinFunction(, PullNone, 0xabcd, "\\_SB.GPO1",,)
            {0x11}
    },
})

Name (P45D, Package() {
    Buffer (0x28)
    {
        /* 0000 */  0x8D, 0x23, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,  /* .#...... */
        /* 0008 */  0x10, 0x12, 0x00, 0x00, 0x18, 0x00, 0x22, 0x00,  /* ......". */
        /* 0010 */  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,  /* ........ */
        /* 0018 */  0x5C, 0x5F, 0x53, 0x42, 0x2E, 0x47, 0x50, 0x4F,  /* \_SB.GPO */
        /* 0020 */  0x31, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x79, 0x00   /* 1.....y. */
    },
    Buffer (0x28)
    {
        /* 0000 */  0x8D, 0x23, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00,  /* .#...... */
        /* 0008 */  0x20, 0x12, 0x00, 0x00, 0x18, 0x00, 0x22, 0x00,  /*  .....". */
        /* 0010 */  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,  /* ........ */
        /* 0018 */  0x5C, 0x5F, 0x53, 0x42, 0x2E, 0x47, 0x50, 0x4F,  /* \_SB.GPO */
        /* 0020 */  0x31, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x79, 0x00   /* 1.....y. */
    },
    Buffer (0x28)
    {
        /* 0000 */  0x8D, 0x23, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,  /* .#...... */
        /* 0008 */  0x30, 0x12, 0x00, 0x00, 0x18, 0x00, 0x22, 0x00,  /* 0.....". */
        /* 0010 */  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,  /* ........ */
        /* 0018 */  0x5C, 0x5F, 0x53, 0x42, 0x2E, 0x47, 0x50, 0x4F,  /* \_SB.GPO */
        /* 0020 */  0x31, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x79, 0x00   /* 1.....y. */
    },
    Buffer (0x28)
    {
        /* 0000 */  0x8D, 0x23, 0x00, 0x01, 0x00, 0x00, 0x03, 0x00,  /* .#...... */
        /* 0008 */  0x40, 0x12, 0x00, 0x00, 0x18, 0x00, 0x22, 0x00,  /* @.....". */
        /* 0010 */  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,  /* ........ */
        /* 0018 */  0x5C, 0x5F, 0x53, 0x42, 0x2E, 0x47, 0x50, 0x4F,  /* \_SB.GPO */
        /* 0020 */  0x31, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x79, 0x00   /* 1.....y. */
    },
    Buffer (0x28)
    {
        /* 0000 */  0x8D, 0x23, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,  /* .#...... */
        /* 0008 */  0x10, 0x12, 0x00, 0x00, 0x18, 0x00, 0x22, 0x00,  /* ......". */
        /* 0010 */  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,  /* ........ */
        /* 0018 */  0x5C, 0x5F, 0x53, 0x42, 0x2E, 0x47, 0x50, 0x4F,  /* \_SB.GPO */
        /* 0020 */  0x31, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x79, 0x00   /* 1.....y. */
    },
    Buffer (0x28)
    {
        /* 0000 */  0x8D, 0x23, 0x00, 0x01, 0x01, 0x00, 0x02, 0x00,  /* .#...... */
        /* 0008 */  0x20, 0x12, 0x00, 0x00, 0x18, 0x00, 0x22, 0x00,  /*  .....". */
        /* 0010 */  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,  /* ........ */
        /* 0018 */  0x5C, 0x5F, 0x53, 0x42, 0x2E, 0x47, 0x50, 0x4F,  /* \_SB.GPO */
        /* 0020 */  0x31, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x79, 0x00   /* 1.....y. */
    },
    Buffer (0x28)
    {
        /* 0000 */  0x8D, 0x23, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00,  /* .#...... */
        /* 0008 */  0x30, 0x12, 0x00, 0x00, 0x18, 0x00, 0x22, 0x00,  /* 0.....". */
        /* 0010 */  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,  /* ........ */
        /* 0018 */  0x5C, 0x5F, 0x53, 0x42, 0x2E, 0x47, 0x50, 0x4F,  /* \_SB.GPO */
        /* 0020 */  0x31, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x79, 0x00   /* 1.....y. */
    },
    Buffer (0x28)
    {
        /* 0000 */  0x8D, 0x23, 0x00, 0x01, 0x01, 0x00, 0x03, 0x00,  /* .#...... */
        /* 0008 */  0x40, 0x12, 0x00, 0x00, 0x18, 0x00, 0x22, 0x00,  /* @.....". */
        /* 0010 */  0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,  /* ........ */
        /* 0018 */  0x5C, 0x5F, 0x53, 0x42, 0x2E, 0x47, 0x50, 0x4F,  /* \_SB.GPO */
        /* 0020 */  0x31, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x79, 0x00   /* 1.....y. */
    },
    Buffer (0x20)
    {
        /* 0000 */  0x8D, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x03, 0xCD,  /* ........ */
        /* 0008 */  0xAB, 0x12, 0x00, 0x00, 0x14, 0x00, 0x1E, 0x00,  /* ........ */
        /* 0010 */  0x00, 0x00, 0x11, 0x00, 0x5C, 0x5F, 0x53, 0x42,  /* ....\_SB */
        /* 0018 */  0x2E, 0x47, 0x50, 0x4F, 0x31, 0x00, 0x79, 0x00   /* .GPO1.y. */
    }
})

Method(RT26,, Serialized)
{
    Name(TS, "RT26")

    // Emit test header, set the filename

    THDR (TS, "PinFunction Resource Descriptor Macro", __FILE__)

    // The main test packages must have the same number of entries

    If (LNotEqual (SizeOf (P45C), SizeOf (P45D)))
    {
        Err (TS, 179, 0, 0, 0, 0, "Incorrect package length")
        Return ()
    }

    // Main test case for packages above

    m330(TS, SizeOf (P45C), "P45C", P45C, P45D)

    // Check resource descriptor tag offsets

	Local0 = ResourceTemplate () {
        PinFunction(Exclusive, PullDefault, 0x1234, "\\_SB.GPO1", 0x0,
            ResourceConsumer, F0, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
        PinFunction(Exclusive, PullDefault, 0x1234, "\\_SB.GPO1", 0x0,
            ResourceConsumer, F1, RawDataBuffer() {0xa, 0xb, 0xc, 0xd})
            {0x1, 0x2, 0x3}
    }

    m331(TS, 1, F0._SHR, 0x20, F1._SHR, 0x150, "_SHR")
    m331(TS, 2, F0._PPI, 0x30, F1._PPI, 0x160, "_PPI")
    m331(TS, 3, F0._FUN, 0x38, F1._FUN, 0x168, "_FUN")
    m331(TS, 4, F0._VEN, 0x110, F1._VEN, 0x240, "_VEN")
}
