#
# This file is part of the coreboot project.
#
# Copyright (C) 2012 Advanced Micro Devices, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#

## ABSOLUTE AGESA V5 ROOT PATH ##
AGESA_ROOT ?= $(PWD)

AGESA_INC ?= -I$(src)/mainboard/$(MAINBOARDDIR)
AGESA_INC += -I$(AGESA_ROOT)
AGESA_INC += -I$(AGESA_ROOT)/Include
AGESA_INC += -I$(AGESA_ROOT)/Lib
AGESA_INC += -I$(AGESA_ROOT)/Legacy
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Family
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Family/0x10
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Family/0x15
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Family/0x15/OR
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Feature
AGESA_INC += -I$(AGESA_ROOT)/Proc/Common
AGESA_INC += -I$(AGESA_ROOT)/Proc/HT
AGESA_INC += -I$(AGESA_ROOT)/Proc/HT/Fam10
AGESA_INC += -I$(AGESA_ROOT)/Proc/HT/Fam15
AGESA_INC += -I$(AGESA_ROOT)/Proc/HT/Fam15Mod1x
AGESA_INC += -I$(AGESA_ROOT)/Proc/HT/Features
AGESA_INC += -I$(AGESA_ROOT)/Proc/HT/NbCommon
AGESA_INC += -I$(AGESA_ROOT)/Proc/HT/htGraph
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Control
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Debug/
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Internal
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Family
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Family/0x10
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Family/0x10/HY
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Family/0x15
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Family/0x15/OR
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Internal/Family/
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Internal/Family/0x10
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Internal/Family/0x15/
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Internal/Family/0x15/OR/

AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/NB
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/NB/OR
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/NB/C32
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/NB/HY
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/NB/DA
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/NB/PH
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/NB/RB
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/Feat/IDENDIMM/
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/Main
AGESA_INC += -I$(AGESA_ROOT)/Proc/Recovery/CPU
AGESA_INC += -I$(AGESA_ROOT)/Proc/Recovery/Mem



agesa_lib_src  += ./Legacy/Proc/agesaCallouts.c
agesa_lib_src  += ./Legacy/Proc/Dispatcher.c
agesa_lib_src  += ./Legacy/Proc/hobTransfer.c
agesa_lib_src  += ./Lib/amdlib.c
agesa_lib_src  += ./Lib/helper.c
agesa_lib_src  += ./Proc/Common/AmdInitEarly.c
agesa_lib_src  += ./Proc/Common/AmdInitEnv.c
agesa_lib_src  += ./Proc/Common/AmdInitLate.c
agesa_lib_src  += ./Proc/Common/AmdInitMid.c
agesa_lib_src  += ./Proc/Common/AmdInitPost.c
agesa_lib_src  += ./Proc/Common/AmdInitReset.c
agesa_lib_src  += ./Proc/Common/AmdInitResume.c
agesa_lib_src  += ./Proc/Common/AmdLateRunApTask.c
agesa_lib_src  += ./Proc/Common/AmdS3LateRestore.c
agesa_lib_src  += ./Proc/Common/AmdS3Save.c
agesa_lib_src  += ./Proc/Common/CommonInits.c
agesa_lib_src  += ./Proc/Common/CommonReturns.c
agesa_lib_src  += ./Proc/Common/CreateStruct.c
agesa_lib_src  += ./Proc/Common/S3RestoreState.c
agesa_lib_src  += ./Proc/Common/S3SaveState.c
agesa_lib_src  += ./Proc/CPU/cahaltasm.S
agesa_lib_src  += ./Proc/CPU/cahalt.c
agesa_lib_src  += ./Proc/CPU/cpuApicUtilities.c
agesa_lib_src  += ./Proc/CPU/cpuBist.c
agesa_lib_src  += ./Proc/CPU/cpuBrandId.c
agesa_lib_src  += ./Proc/CPU/cpuEarlyInit.c
agesa_lib_src  += ./Proc/CPU/cpuEventLog.c
agesa_lib_src  += ./Proc/CPU/cpuFamilyTranslation.c
agesa_lib_src  += ./Proc/CPU/cpuGeneralServices.c
agesa_lib_src  += ./Proc/CPU/cpuInitEarlyTable.c
agesa_lib_src  += ./Proc/CPU/cpuLateInit.c
agesa_lib_src  += ./Proc/CPU/cpuMicrocodePatch.c
agesa_lib_src  += ./Proc/CPU/cpuPostInit.c
agesa_lib_src  += ./Proc/CPU/cpuPowerMgmt.c
agesa_lib_src  += ./Proc/CPU/cpuPowerMgmtMultiSocket.c
agesa_lib_src  += ./Proc/CPU/cpuPowerMgmtSingleSocket.c
agesa_lib_src  += ./Proc/CPU/cpuWarmReset.c
agesa_lib_src  += ./Proc/CPU/heapManager.c
agesa_lib_src  += ./Proc/CPU/S3.c
agesa_lib_src  += ./Proc/CPU/Table.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuCommonF10Utilities.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10BrandId.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10BrandIdAm3.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10BrandIdAsb2.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10BrandIdC32.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10BrandIdFr1207.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10BrandIdG34.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10BrandIdS1g3.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10BrandIdS1g4.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10CacheDefaults.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10CacheFlushOnHalt.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10Cpb.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10Dmi.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10EarlyInit.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10FeatureLeveling.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10HtPhyTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10MsrTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10PciTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10PowerCheck.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10PowerMgmtSystemTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10PowerPlane.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10Pstate.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10SoftwareThermal.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10Utilities.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10WheaInitDataTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/cpuF10WorkaroundsTable.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/F10InitEarlyTable.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/F10IoCstate.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/F10MultiLinkPciTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/F10PmAsymBoostInit.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/F10PmDualPlaneOnlySupport.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/F10PmNbCofVidInit.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/F10PmNbPstateInit.c
agesa_lib_src  += ./Proc/CPU/Family/0x10/F10SingleLinkPciTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuCommonF15Utilities.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15Apm.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15BrandId.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15CacheDefaults.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15Dmi.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15MsrTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15PciTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15PowerCheck.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15Utilities.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/cpuF15WheaInitDataTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/F15PstateHpcMode.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/cpuF15OrCacheFlushOnHalt.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/cpuF15OrCoreAfterReset.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/cpuF15OrDmi.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/cpuF15OrFeatureLeveling.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/cpuF15OrNbAfterReset.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/cpuF15OrPstate.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/cpuF15OrSoftwareThermal.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrC6State.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrCpb.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrEarlySamples.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrEquivalenceTable.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrHtPhyTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrInitEarlyTable.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrIoCstate.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrL3Features.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrLogicalIdTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrLowPwrPstate.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrMicrocodePatch06000425.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrMicrocodePatch0600050D_Enc.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrMicrocodePatch06000624_Enc.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrMicrocodePatchTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrMsgBasedC1e.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrMsrTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrMultiLinkPciTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrPciTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrPmNbCofVidInit.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrPowerMgmtSystemTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrPowerPlane.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrSharedMsrTable.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrSingleLinkPciTables.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrUtilities.c
agesa_lib_src  += ./Proc/CPU/Family/0x15/OR/F15OrWorkaroundsTable.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuApm.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuC6State.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuCacheFlushOnHalt.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuCacheInit.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuCoreLeveling.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuCpb.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuDmi.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuFeatureLeveling.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuFeatures.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuHwC1e.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuIoCstate.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuL3Features.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuLowPwrPstate.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuMsgBasedC1e.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuPstateGather.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuPstateHpcMode.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuPstateLeveling.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuPstateTables.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuSlit.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuSrat.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuSwC1e.c
agesa_lib_src  += ./Proc/CPU/Feature/cpuWhea.c
agesa_lib_src  += ./Proc/CPU/Feature/PreserveMailbox.c
agesa_lib_src  += ./Proc/HT/htFeat.c
agesa_lib_src  += ./Proc/HT/htInterface.c
agesa_lib_src  += ./Proc/HT/htInterfaceCoherent.c
agesa_lib_src  += ./Proc/HT/htInterfaceGeneral.c
agesa_lib_src  += ./Proc/HT/htInterfaceNonCoherent.c
agesa_lib_src  += ./Proc/HT/htMain.c
agesa_lib_src  += ./Proc/HT/htNb.c
agesa_lib_src  += ./Proc/HT/htNotify.c
agesa_lib_src  += ./Proc/HT/Fam10/htNbCoherentFam10.c
agesa_lib_src  += ./Proc/HT/Fam10/htNbFam10.c
agesa_lib_src  += ./Proc/HT/Fam10/htNbNonCoherentFam10.c
agesa_lib_src  += ./Proc/HT/Fam10/htNbOptimizationFam10.c
agesa_lib_src  += ./Proc/HT/Fam10/htNbSystemFam10.c
agesa_lib_src  += ./Proc/HT/Fam10/htNbUtilitiesFam10.c
agesa_lib_src  += ./Proc/HT/Fam15/htNbCoherentFam15.c
agesa_lib_src  += ./Proc/HT/Fam15/htNbFam15.c
agesa_lib_src  += ./Proc/HT/Fam15/htNbNonCoherentFam15.c
agesa_lib_src  += ./Proc/HT/Fam15/htNbOptimizationFam15.c
agesa_lib_src  += ./Proc/HT/Fam15/htNbSystemFam15.c
agesa_lib_src  += ./Proc/HT/Fam15/htNbUtilitiesFam15.c
agesa_lib_src  += ./Proc/HT/Features/htFeatDynamicDiscovery.c
agesa_lib_src  += ./Proc/HT/Features/htFeatGanging.c
agesa_lib_src  += ./Proc/HT/Features/htFeatNoncoherent.c
agesa_lib_src  += ./Proc/HT/Features/htFeatOptimization.c
agesa_lib_src  += ./Proc/HT/Features/htFeatRouting.c
agesa_lib_src  += ./Proc/HT/Features/htFeatSets.c
agesa_lib_src  += ./Proc/HT/Features/htFeatSublinks.c
agesa_lib_src  += ./Proc/HT/Features/htFeatTrafficDistribution.c
agesa_lib_src  += ./Proc/HT/Features/htIds.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph1.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph2.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph3Line.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph3Triangle.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph4Degenerate.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph4FullyConnected.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph4Kite.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph4Line.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph4Square.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph4Star.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph5FullyConnected.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph5TwistedLadder.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph6DoubloonLower.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph6DoubloonUpper.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph6FullyConnected.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph6TwinTriangles.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph6TwistedLadder.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph7FullyConnected.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph7TwistedLadder.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph8DoubloonM.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph8FullyConnected.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph8Ladder.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph8TwinFullyFourWays.c
agesa_lib_src  += ./Proc/HT/htGraph/htGraph8TwistedLadder.c
agesa_lib_src  += ./Proc/HT/NbCommon/htNbCoherent.c
agesa_lib_src  += ./Proc/HT/NbCommon/htNbNonCoherent.c
agesa_lib_src  += ./Proc/HT/NbCommon/htNbOptimization.c
agesa_lib_src  += ./Proc/HT/NbCommon/htNbUtilities.c
agesa_lib_src  += ./Proc/Mem/Ardk/ma.c
agesa_lib_src  += ./Proc/Mem/Ardk/C32/marc32_3.c
agesa_lib_src  += ./Proc/Mem/Ardk/C32/mauc32_3.c
agesa_lib_src  += ./Proc/Mem/Ardk/HY/marhy3.c
agesa_lib_src  += ./Proc/Mem/Ardk/HY/mauhy3.c
agesa_lib_src  += ./Proc/Mem/Ardk/OR/maror3.c
agesa_lib_src  += ./Proc/Mem/Ardk/OR/mauor3.c
agesa_lib_src  += ./Proc/Mem/Feat/CHINTLV/mfchi.c
agesa_lib_src  += ./Proc/Mem/Feat/CSINTLV/mfcsi.c
agesa_lib_src  += ./Proc/Mem/Feat/DMI/mfDMI.c
agesa_lib_src  += ./Proc/Mem/Feat/ECC/mfecc.c
agesa_lib_src  += ./Proc/Mem/Feat/ECC/mfemp.c
agesa_lib_src  += ./Proc/Mem/Feat/EXCLUDIMM/mfdimmexclud.c
agesa_lib_src  += ./Proc/Mem/Feat/IDENDIMM/mfidendimm.c
agesa_lib_src  += ./Proc/Mem/Feat/INTLVRN/mfintlvrn.c
agesa_lib_src  += ./Proc/Mem/Feat/LVDDR3/mflvddr3.c
agesa_lib_src  += ./Proc/Mem/Feat/MEMCLR/mfmemclr.c
agesa_lib_src  += ./Proc/Mem/Feat/NDINTLV/mfndi.c
agesa_lib_src  += ./Proc/Mem/Feat/ODTHERMAL/mfodthermal.c
agesa_lib_src  += ./Proc/Mem/Feat/OLSPARE/mfspr.c
agesa_lib_src  += ./Proc/Mem/Feat/PARTRN/mfParallelTraining.c
agesa_lib_src  += ./Proc/Mem/Feat/PARTRN/mfStandardTraining.c
agesa_lib_src  += ./Proc/Mem/Feat/S3/mfs3.c
agesa_lib_src  += ./Proc/Mem/Feat/TABLE/mftds.c
agesa_lib_src  += ./Proc/Mem/Main/mdef.c
agesa_lib_src  += ./Proc/Mem/Main/merrhdl.c
agesa_lib_src  += ./Proc/Mem/Main/minit.c
agesa_lib_src  += ./Proc/Mem/Main/mm.c
agesa_lib_src  += ./Proc/Mem/Main/mmConditionalPso.c
agesa_lib_src  += ./Proc/Mem/Main/mmEcc.c
agesa_lib_src  += ./Proc/Mem/Main/mmExcludeDimm.c
agesa_lib_src  += ./Proc/Mem/Main/mmLvDdr3.c
agesa_lib_src  += ./Proc/Mem/Main/mmMemClr.c
agesa_lib_src  += ./Proc/Mem/Main/mmMemRestore.c
agesa_lib_src  += ./Proc/Mem/Main/mmNodeInterleave.c
agesa_lib_src  += ./Proc/Mem/Main/mmOnlineSpare.c
agesa_lib_src  += ./Proc/Mem/Main/mmParallelTraining.c
agesa_lib_src  += ./Proc/Mem/Main/mmStandardTraining.c
agesa_lib_src  += ./Proc/Mem/Main/mmUmaAlloc.c
agesa_lib_src  += ./Proc/Mem/Main/mu.c
agesa_lib_src  += ./Proc/Mem/Main/muc.c
agesa_lib_src  += ./Proc/Mem/NB/mn.c
agesa_lib_src  += ./Proc/Mem/NB/mndct.c
agesa_lib_src  += ./Proc/Mem/NB/mnfeat.c
agesa_lib_src  += ./Proc/Mem/NB/mnflow.c
agesa_lib_src  += ./Proc/Mem/NB/mnmct.c
agesa_lib_src  += ./Proc/Mem/NB/mnphy.c
agesa_lib_src  += ./Proc/Mem/NB/mnreg.c
agesa_lib_src  += ./Proc/Mem/NB/mnS3.c
agesa_lib_src  += ./Proc/Mem/NB/mntrain3.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mndctc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnflowc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnidendimmc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnmctc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnotc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnParTrainc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnphyc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnprotoc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnregc32.c
agesa_lib_src  += ./Proc/Mem/NB/C32/mnS3c32.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mndcthy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnflowhy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnhy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnidendimmhy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnmcthy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnothy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnParTrainHy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnphyhy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnprotohy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnreghy.c
agesa_lib_src  += ./Proc/Mem/NB/HY/mnS3hy.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mndctor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnflowor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnidendimmor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnmctor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnotor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnpartrainor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnphyor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnprotoor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mnregor.c
agesa_lib_src  += ./Proc/Mem/NB/OR/mns3or.c
agesa_lib_src  += ./Proc/Mem/Ps/mp.c
agesa_lib_src  += ./Proc/Mem/Ps/mplribt.c
agesa_lib_src  += ./Proc/Mem/Ps/mplrnlr.c
agesa_lib_src  += ./Proc/Mem/Ps/mplrnpr.c
agesa_lib_src  += ./Proc/Mem/Ps/mpmaxfreq.c
agesa_lib_src  += ./Proc/Mem/Ps/mpmr0.c
agesa_lib_src  += ./Proc/Mem/Ps/mpodtpat.c
agesa_lib_src  += ./Proc/Mem/Ps/mprc10opspd.c
agesa_lib_src  += ./Proc/Mem/Ps/mprc2ibt.c
agesa_lib_src  += ./Proc/Mem/Ps/mprtt.c
agesa_lib_src  += ./Proc/Mem/Ps/mps2d.c
agesa_lib_src  += ./Proc/Mem/Ps/mpsao.c
agesa_lib_src  += ./Proc/Mem/Ps/mpseeds.c
agesa_lib_src  += ./Proc/Mem/Ps/C32/mprc32_3.c
agesa_lib_src  += ./Proc/Mem/Ps/C32/mpuc32_3.c
agesa_lib_src  += ./Proc/Mem/Ps/HY/mprhy3.c
agesa_lib_src  += ./Proc/Mem/Ps/HY/mpshy3.c
agesa_lib_src  += ./Proc/Mem/Ps/HY/mpuhy3.c
agesa_lib_src  += ./Proc/Mem/Tech/mt.c
agesa_lib_src  += ./Proc/Mem/Tech/mthdi.c
agesa_lib_src  += ./Proc/Mem/Tech/mttdimbt.c
agesa_lib_src  += ./Proc/Mem/Tech/mttecc.c
agesa_lib_src  += ./Proc/Mem/Tech/mttEdgeDetect.c
agesa_lib_src  += ./Proc/Mem/Tech/mtthrc.c
agesa_lib_src  += ./Proc/Mem/Tech/mtthrcSeedTrain.c
agesa_lib_src  += ./Proc/Mem/Tech/mttml.c
agesa_lib_src  += ./Proc/Mem/Tech/mttoptsrc.c
agesa_lib_src  += ./Proc/Mem/Tech/mttsrc.c
agesa_lib_src  += ./Proc/Mem/Tech/DDR3/mt3.c
agesa_lib_src  += ./Proc/Mem/Tech/DDR3/mtlrdimm3.c
agesa_lib_src  += ./Proc/Mem/Tech/DDR3/mtot3.c
agesa_lib_src  += ./Proc/Mem/Tech/DDR3/mtrci3.c
agesa_lib_src  += ./Proc/Mem/Tech/DDR3/mtsdi3.c
agesa_lib_src  += ./Proc/Mem/Tech/DDR3/mtspd3.c
agesa_lib_src  += ./Proc/Mem/Tech/DDR3/mttecc3.c
agesa_lib_src  += ./Proc/Mem/Tech/DDR3/mttwl3.c
agesa_lib_src  += ./Proc/Recovery/HT/htInitRecovery.c
agesa_lib_src  += ./Proc/Recovery/HT/htInitReset.c

agesa_lib_src  += ./Proc/Mem/Main/mmflow.c
agesa_lib_src  += ./Proc/Mem/Main/OR/mmflowor.c
agesa_lib_src  += ./Proc/Mem/Ps/OR/mpor3.c
ifeq ($(CONFIG_CPU_AMD_SOCKET_C32), y)
	agesa_lib_src  += ./Proc/Mem/Main/C32/mmflowC32.c
	agesa_lib_src  += ./Proc/Mem/Ps/OR/C32/mpLorC3.c
	agesa_lib_src  += ./Proc/Mem/Ps/OR/C32/mpRorC3.c
	agesa_lib_src  += ./Proc/Mem/Ps/OR/C32/mpUorC3.c

#	agesa_lib_src  += ./Proc/Mem/Main/HY/mmflowhy.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10MicrocodePatch010000c5.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10MicrocodePatch010000d9.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10RevDL3Features.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10RevDMsgBasedC1e.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10RevDUtilities.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyEquivalenceTable.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyHtPhyTables.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyInitEarlyTable.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyLogicalIdTables.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyMicrocodePatchTables.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyMsrTables.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyPciTables.c
endif
ifeq ($(CONFIG_CPU_AMD_SOCKET_G34), y)
	agesa_lib_src  += ./Proc/Mem/Main/HY/mmflowhy.c
	agesa_lib_src  += ./Proc/Mem/Ps/OR/G34/mpLorG3.c
	agesa_lib_src  += ./Proc/Mem/Ps/OR/G34/mpRorG3.c
	agesa_lib_src  += ./Proc/Mem/Ps/OR/G34/mpUorG3.c

	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10MicrocodePatch010000c5.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10MicrocodePatch010000d9.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10RevDL3Features.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10RevDMsgBasedC1e.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/F10RevDUtilities.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyEquivalenceTable.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyHtPhyTables.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyInitEarlyTable.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyLogicalIdTables.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyMicrocodePatchTables.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyMsrTables.c
	agesa_lib_src  += ./Proc/CPU/Family/0x10/RevD/HY/F10HyPciTables.c
endif

ifeq ($(CONFIG_CPU_AMD_SOCKET_AM3R2), y)
	agesa_lib_src += ./Proc/Mem/Main/DA/mmflowda.c
	agesa_lib_src += ./Proc/Mem/Main/RB/mmflowRb.c
	agesa_lib_src += ./Proc/Mem/Main/PH/mmflowPh.c

	agesa_lib_src  += ./Proc/Mem/Ps/OR/AM3/mpUorA3.c
	agesa_lib_src  += ./Proc/Mem/Ps/OR/AM3/mpSorA3.c

	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10MicrocodePatch010000c6.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/RB/F10RbMsrTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/RB/F10RbLogicalIdTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/RB/F10RbHtPhyTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/RB/F10RbMicrocodePatchTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/RB/F10RbEquivalenceTable.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/RB/F10RbPciTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/BL/F10BlHtPhyTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/BL/F10BlEquivalenceTable.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/BL/F10BlPciTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/BL/F10BlLogicalIdTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/BL/F10BlMsrTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/BL/F10BlCacheFlushOnHalt.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/BL/F10BlMicrocodePatchTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10RevCUtilities.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10RevCMsrTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10MicrocodePatch010000c7.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/DA/F10DaHtPhyTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/DA/F10DaMsrTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/DA/F10DaMicrocodePatchTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/DA/F10DaCacheFlushOnHalt.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/DA/F10DaPciTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/DA/F10DaEquivalenceTable.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/DA/F10DaLogicalIdTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10MicrocodePatch01000085.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10RevCHwC1e.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10RevCPciTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10RevCHtPhyTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10RevCSwC1e.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevC/F10MicrocodePatch010000c8.c

	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/PH/F10PhMicrocodePatchTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/PH/F10PhHtPhyTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/PH/F10PhEquivalenceTable.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/PH/F10PhLogicalIdTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/F10MicrocodePatch010000bf.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/F10RevEUtilities.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/F10RevEPciTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/F10RevEMsrTables.c
	agesa_lib_src += ./Proc/CPU/Family/0x10/RevE/F10RevEHtPhyTables.c

	agesa_lib_src += ./Proc/Mem/NB/DA/mnidendimmda.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mnregda.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mnS3da.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mnprotoda.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mnda.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mndctda.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mnmctda.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mnflowda.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mnParTrainDa.c
	agesa_lib_src += ./Proc/Mem/NB/DA/mnotda.c
	agesa_lib_src += ./Proc/Mem/NB/PH/mnS3Ph.c
	agesa_lib_src += ./Proc/Mem/NB/PH/mnflowPh.c
	agesa_lib_src += ./Proc/Mem/NB/PH/mnidendimmPh.c
	agesa_lib_src += ./Proc/Mem/NB/PH/mnmctPh.c
	agesa_lib_src += ./Proc/Mem/NB/PH/mnPh.c
	agesa_lib_src += ./Proc/Mem/NB/PH/mnmctPh.c
	agesa_lib_src += ./Proc/Mem/NB/PH/mnflowPh.c
	agesa_lib_src += ./Proc/Mem/NB/PH/mnidendimmPh.c
	agesa_lib_src += ./Proc/Mem/NB/RB/mnidendimmRb.c
	agesa_lib_src += ./Proc/Mem/NB/RB/mnRb.c
	agesa_lib_src += ./Proc/Mem/NB/RB/mnflowRb.c
	agesa_lib_src += ./Proc/Mem/NB/RB/mnS3Rb.c

	agesa_lib_src += ./Proc/Mem/Ardk/DA/masda2.c
	agesa_lib_src += ./Proc/Mem/Ardk/DA/masda3.c
	agesa_lib_src += ./Proc/Mem/Ardk/DA/mauda3.c
	agesa_lib_src += ./Proc/Mem/Ardk/PH/mauPh3.c
	agesa_lib_src += ./Proc/Mem/Ardk/PH/masph3.c
	agesa_lib_src += ./Proc/Mem/Ardk/RB/mauRb3.c
	agesa_lib_src += ./Proc/Mem/Ardk/RB/masRb3.c

	agesa_lib_src += ./Proc/Mem/Ps/DA/mpuda3.c
	agesa_lib_src += ./Proc/Mem/Ps/DA/mpsda3.c
	agesa_lib_src += ./Proc/Mem/Ps/DA/mpsda2.c
	agesa_lib_src += ./Proc/Mem/Ps/PH/mpuph3.c
	agesa_lib_src += ./Proc/Mem/Ps/PH/mpsph3.c
	agesa_lib_src += ./Proc/Mem/Ps/RB/mpuRb3.c
	agesa_lib_src += ./Proc/Mem/Ps/RB/mpsRb3.c
endif

romstage-y += $(agesa_lib_src)
ramstage-y += $(agesa_lib_src)

## AGESA need sse feature ##
AGESA_CFLAGS = -msse3 -fno-zero-initialized-in-bss -fno-strict-aliasing

export AGESA_ROOT
export AGESA_INC
export AGESA_CFLAGS
CC := $(CC) $(AGESA_INC) $(AGESA_CFLAGS)

