# Mainboard-specific documentation

This section contains documentation about coreboot on specific mainboards.

## AMD
- [padmelon](amd/padmelon/padmelon.md)

## ASRock

- [H81M-HDS](asrock/h81m-hds.md)
- [H110M-DVS](asrock/h110m-dvs.md)

## ASUS

- [F2A85-M](asus/f2a85-m.md)
- [P8H61-M LX](asus/p8h61-m_lx.md)
- [P8H61-M Pro](asus/p8h61-m_pro.md)
- [P8Z77-M Pro](asus/p8z77-m_pro.md)

## Cavium

- [CN81XX EVB SFF](cavium/cn8100_sff_evb.md)

## Emulation

The boards in this section are not real mainboards, but emulators.

- [Spike RISC-V emulator](emulation/spike-riscv.md)
- [Qemu RISC-V emulator](emulation/qemu-riscv.md)
- [Qemu AArch64 emulator](emulation/qemu-aarch64.md)

## Facebook

- [FBG-1701](facebook/fbg1701.md)

## Foxconn

- [D41S](foxconn/d41s.md)

## Gigabyte

- [GA-H61M-S2PV](gigabyte/ga-h61m-s2pv.md)

## Google

- [Dragonegg](google/dragonegg.md)

## HP

- [Compaq 8200 Elite SFF](hp/compaq_8200_sff.md)
- [Z220 Workstation SFF](hp/z220_sff.md)

### EliteBook series

- [EliteBook common](hp/elitebook_series.md)
- [EliteBook 8760w](hp/8760w.md)

## Intel

- [DG43GT](intel/dg43gt.md)
- [IceLake RVP](intel/icelake_rvp.md)
- [KBLRVP11](intel/kblrvp11.md)

## Lenovo

- [Mainboard codenames](lenovo/codenames.md)
- [Hardware Maintenance Manual of ThinkPads](lenovo/thinkpad_hmm.md)
- [R60](lenovo/r60.md)
- [T4xx common](lenovo/t4xx_series.md)
- [X2xx common](lenovo/x2xx_series.md)

### Nehalem series

- [T410](lenovo/t410.md)

### GM45 series

- [X301](lenovo/x301.md)

### Sandy Bridge series

- [T420](lenovo/t420.md)
- [T420 / T520 / X220 / T420s / W520 common](lenovo/xx20_series.md)
- [x1](lenovo/x1.md)

### Ivy Bridge series

- [T430](lenovo/t430.md)
- [T530](lenovo/w530.md)
- [W530](lenovo/w530.md)
- [T430 / T530 / X230 / W530 common](lenovo/xx30_series.md)
- [T431s](lenovo/t431s.md)

### Haswell series

- [T440p](lenovo/t440p.md)

## MSI

- [MS-7707](msi/ms7707/ms7707.md)

## Open Cellular

- [Elgon](opencellular/elgon.md)
- [Rotundu](opencellular/rotundu.md)

## PC Engines

- [APU1](pcengines/apu1.md)
- [APU2](pcengines/apu2.md)

## Portwell

- [PQ7-M107](portwell/pq7-m107.md)

## Roda

- [RK9 Flash Header](roda/rk9/flash_header.md)

## SiFive

- [SiFive HiFive Unleashed](sifive/hifive-unleashed.md)

## Supermicro

- [X10SLM+-F](supermicro/x10slm-f.md)
- [X11 LGA1151 series](supermicro/x11-lga1151-series/x11-lga1151-series.md)

## UP

- [Squared](up/squared/index.md)
