---
title: Учасники проекту
x-toc-enable: true
...

У цьому списку не обов'язково вказується, хто зараз працює над проектом,
але в ньому вказано людей, які зробили значний внесок у проект.

Якщо ми забули вас тут згадати, повідомте нам, і ми вас додамо. (або якщо
ви не хочете, щоб вас згадували, повідомте нас, і ми видалимо ваш
запис)

Інформацію про те, хто працює над libreboot і як працює проект, можна
знайти на цій сторінці: [who.md](who.md)

Ви можете дізнатися історію проекту libreboot, просто прочитавши цю сторінку.
Тут докладно розповідається про всі основні внески в проект і
загалом про те, як створювався проект (і хто допоміг його створити).

Лія Роу
---------

**Засновник проекту Libreboot, а зараз провідний розробник** Лія
працює над усіма аспектами libreboot, такими як:

* Загальне керівництво. Лія обробляє всі зовнішні внески до libreboot,
  переглядає пул реквести, має справу із звітами про помилки, делегує завдання, коли це необхідно
  або бажано. Лія контролює серверну інфраструктуру libreboot.org, розміщену
  в її лабораторії.
* Лія має останнє слово щодо всіх рішень, беручи внесок через обговорення з
  представниками громадськості, переважно на IRC. Лія контролює випуски libreboot
  і загалом підтримує проект. Без Лії не було би Libreboot!
* Система збірки (lbmk, скорочення від libreboot Make). Це автоматизована
  система збирання, яка лежить в серці libreboot; він завантажує, патчить, налаштовує
  та компілює відповідні компоненти, такі як coreboot, GRUB, і генерує образи ROM
  libreboot, які ви можете знайти в архівах випусків.
* Апстрім робота над coreboot, коли необхідно (та іншими проектами, які libreboot
  використовує). Це також означає роботу з людьми поза межами проекту libreboot,
  щоб об'єднати виправлення (між іншим) в апстрім проектах,
  які libreboot використовує
* Надання підтримки користувачів на IRC

Калеб Ла Гранж
---------------

**Вторинний розробник, номер два для Лії.** Калеб - розробник libreboot на повний робочий день
з вузьким фокусом. Калеб зосереджується на кількох напрямках розвитку:

* Система побудови. Калеб відповідає за вдосконалення та виправлення системи побудови libreboot Make.
Зокрема, управління бінарними блобами, автоматизація та відтворюваність. 
* Апаратна модифікація. Калеб має пристрасть до переробки апаратного забезпечення; паяння,
розпаювання, та тестування libreboot на отриманому обладнанні.
* Перенесення плати. Все, що підтримується в Coreboot, можна перенести на libreboot, Калеб
перевірить і перенесе будь-яку плату, до якої зможе потрапити. Крім того, будь-хто може
зв'язатись з Калебом, щоб створити образи libreboot для тестування на своїй платі.
* Документація. Калеб активно веде документацію щодо зазначених вище сфер
інтересу. Додатково, Калеб відповідає за посібники з розбирання з власними
малюнками та діаграмами для кількох плат.
* Підтримка користувачів. Калеб активний в irc і готовий допомогти будь-якому користувачеві, який зацікавлений в
використанні libreboot або потребує допомоги.
* Цілі проекту. Калеб співпрацює з Лією над визначенням цілей проекту.
Лія має останнє слово в кожному рішенні.

Зовнішні проекти
================

Проект Coreboot
----------------

Без coreboot проект libreboot був би просто неможливий.

Людей і компаній, які працюють над coreboot, багато, і вони роблять
проект libreboot таким, яким він є. Проект libreboot активно використовує coreboot
для ініціалізації обладнання.

GRUB
--------

GRUB - це завантажувач, який використовується libreboot. Само собою зрозуміло, що
розробники GRUB стимулюють libreboot своєю роботою.

SeaBIOS
-------

Прошивка libreboot надає SeaBIOS як опцію корисного навантаження. SeaBIOS забезпечує
застарілу реалізацію BIOS x86.

U-Boot
------

Libreboot використовує U-Boot як корисне навантаження coreboot на ноутбуках
ARM Chromebook з підтримкою coreboot.

Внески в алфавітному порядку
============================

Алісса Розенцвейг
-----------------

Переключила веб-сайт на використання розмітки замість рукописного HTML та користувацького
PHP. **Колишній супроводжувач проекту libreboot (системний адміністратор libreboot.org).**

Алісса написала оригінальний генератор статичних сайтів (скрипти `sh`, що перетворюють
markdown в html, через pandoc) для libreboot.org. Цей генератор статичних сайтів
був значно змінений і відгалужений Лією Роу у формальний проект:

<https://untitled.vimuser.org/> (untitled - це робота Лії, а не Алісси, але вона базується на
оригінальній роботі Аліси над генератором статичних сайтів, який раніше використовував Libreboot;
веб-сайт Libreboot тепер створено за допомогою Untitled)

Альпер Небі Ясак
----------------

Надав інтеграцію системи збірки та документацію для використання
U-Boot в якості корисного навантаження, та початкові порти Libreboot деяких ARM Chromebook
виходячи з того.

Альпер також займається розробкою на U-Boot, напр. продовжив майже завершений
порт плати `gru-kevin` і об'єднав його з апстрімом.

Артур Хейманс
--------------

Об'єднав патч із coreboot у libreboot, дозволяючи режимам живлення C3 та C4
правильно працювати на ноутбуках GM45. Це була давня проблема до внеску
Артура. Артур також виправив розмір відеопам'яті на i945 на системах
GM45, що дозволило максимально розподілити VRAM для вбудованих графічних процесорів
у цих системах, ще одна давня проблема в libreboot.

Артур також працював над системою збірки Libreboot, коли він був учасником
проекту. Він досі працює над coreboot, і Libreboot отримує велику
користь від його роботи. Його внесок у проект coreboot і Libreboot
неоціненний.

Володимир Сербіненко
-------------------

Перенес багато thinkpad, які підтримуються в libreboot, на coreboot, а
також зробив багато виправлень у coreboot, які принесли користь проекту libreboot.

Володимир написав багато вихідного коду ініціалізації відео, який використовується різними
платформами Intel у Libreboot, під час прошивки (зараз переписаний
іншими в Ada, для libgfxinit в coreboot, але спочатку він був написаний на
C і включений безпосередньо в coreboot; libgfxinit є субмодуль третьої сторони).

Демієн Замміт
-------------

Підтримує порт coreboot Gigabyte GA-G41M-ES2L, інтегрований у
libreboot. Також працює над іншим апаратним забезпеченням на користь
проекту libreboot.

Демієн не працював безпосередньо над самим Libreboot, але він багато працював з
Лією Роу, інтегруючи патчі та нові порти плати в Libreboot на основі
попередньої роботи Демієна над coreboot.

Денис Каріклі
-------------

На основі роботи, виконаної Пітером Стюджем, Володимиром Сербіненко та іншими
в проекті coreboot, вдалось налагодити нативну ініціалізацію графіки для роботи
на ThinkPad X60, що дозволяє підтримувати її в libreboot. Денис дав
багато порад і допоміг створити проект libreboot.

Денис був наставником Лії Роу в ранні дні, коли вона заснувала проект
Libreboot. Багато прийнятих рішень, особливо щодо системи збірки
Libreboot (lbmk), були натхненні розмовами з Денисом.

Денис навчив Лію про регістри, які використовуються графічним процесором Intel для керування підсвічуванням.
В ранні дні, ноутбуки ThinkPad X60 та T60 в Libreboot не мали працюючого
контроля підсвічуванням, тому яскравість завжди була 100%. За допомогою Дениса,
Лія змогла налаштувати керування підсвічуванням шляхом зворотньої розробки
правильних значень для запису в ці регістри. На основі цього в coreboot
було написано просте виправлення; однак виправлення перезаписувало безпосередньо регістр
і не працювало з елементами керування яскравістю на основі ACPI. Інші в coreboot
пізніше вдосконалили його, змусивши елементи керування підсвічуванням на основі ACPI працювати належним чином, на основі цієї
попередньої роботи.

Джерун Квінт
------------

Додав кілька виправлень до документації libreboot, пов'язаної зі
встановленням Arch з повним дисковим шифруванням у системах libreboot.

Джошуа Гей
----------

Джошуа колишній співробітник FSF.

Джошуа допоміг із раннім заснуванням проекту Libreboot, будучи
(на той час) менеджером з ліцензування та відповідності FSF. Його роботою було
переглядати продукти, надіслані до FSF для перевірки; FSF має програму
сертифікації, під назвою *Поважає Вашу Свободу* (Respects Your Freedom), за якою FSF рекламуватиме
продукти вашої компанії, якщо вони постачаються з усім вільним програмним
забезпеченням.

Я, Лія Роу, спочатку просто продавала ноутбуки ThinkPad X60 із звичайним
coreboot, і це включало оновлення мікрокоду ЦП. У той час
я не дуже про це думала. Джошуа зв'язався зі мною, в своїх повноваженнях FSF, і спитав,
чи зацікавить мене програма RYF FSF; Я була дуже здивована, що FSF
сприйме мене серйозно, і я сказала так. Саме з цього почалася рання робота
над Libreboot. Джошуа показав мені всі проблеми з моїми продуктами, і з
цього, рішення було очевидним:

Необхідно, щоб існував проект із повністю вільною версією coreboot без будь-яких
бінарних блобів. У той час (і це актуально й сьогодні) coreboot не був
повністю вільним програмним забезпеченням і за замовчуванням постачався з двійковими блобами. Зокрема,
оновлення мікрокоду ЦП включено за замовчуванням на всіх машинах x86. Працюючи
з Джошуа, я створила повністю вільну версію coreboot.
Спочатку він не називався Libreboot, і робота була призначена виключно для моєї
компанії (на той час вона називалася Gluglug), яку просувала FSF.

Джошуа використовував свої медійні зв'язки в FSF, щоб активно рекламувати мою роботу, і
13 грудня 2013 року народився проект Libreboot (але не названий так).
Джошуа переконався, щоб всі знали, що я роблю!

Через кілька місяців було створено назву *Libreboot* і зареєстровано доменне ім'я
*libreboot.org*. У цей момент офіційно народився проект Libreboot (на початку
2014 року). Знову Джошуа надав всю можливу допомогу,
активно просуваючи проект, і навіть написав цю статтю на веб-сайті FSF
оголосивши про це:

<https://web.archive.org/web/20171222063358/https://www.fsf.org/blogs/licensing/replace-your-proprietary-bios-with-libreboot>

Ендрю Роббінс
--------------

Працював над великими частинами старої системи збірки Libreboot і пов'язаною документацією.
Ендрю приєднався до проекту Libreboot як штатний розробник у червні 2017,
до моменту свого відходу в березні 2021 року.

Я, Лія Роу, дуже вдячна Ендрю Роббінсу за його численні внески
протягом багатьох років.

Клеменс Нанні
-------------

Внесено багато виправлень і покращень у конфігурацію GRUB, яка використовується в
libreboot, а також кілька змін у системі збірки.

Ліза Марі Магінніс
-------------------

Ліза - колишній системний адміністратор Free Software Foundation. На перших днях
проекту вона давала Лії багато технічних порад. Спочатку вона створила
IRC-канал Libreboot, коли Лія не знала, як користуватися
IRC, а також передала +F статус засновника для каналу. Як системний
адміністратор FSF, роботою Лізи було підтримувати велику частину інфраструктури,
яку використовує Libreboot; на той час списки розсилки на веб-сайті Savannah
використовувалися проектом Libreboot. Коли Пол Коціалковскі був
учасником проекту в 2016 році, вона допомогла йому отримати допомогу від FSF; на той час він був
керівником проекту Replicant, який фінансував FSF, і FSF дозволив
йому використати частину цього фінансування для його роботи над Libreboot, завдяки Лізи
підтримці, коли вона працювала у FSF.

Ліза також втрутилася, коли Лія Роу пропустила виступ на LibrePlanet 2016. Лія мала
виступити з доповіддю про Libreboot, але не з'явилася вчасно. Ліза разом
із Патріком Макдермоттом (колишнім розробником Libreboot, який був присутній
на тій конференції) виступили замість Лії. Розмова ніколи не була записана, але
Фонд вільного програмного забезпечення має ці фотографії цієї розмови на веб-сайті LibrePlanet
(жінка з блакитним волоссям - Ліза, а довговолосий хлопець із вусами -
Патрік):

<http://web.archive.org/web/20170319043913/https://media.libreplanet.org/u/libreplanet/m/session-02-c-mws-png-libreplanet-2016-sessions/>

<http://web.archive.org/web/20170319043915/https://media.libreplanet.org/u/libreplanet/m/session-02-c-wide-png-libreplanet-2016-sessions/>

Цікавий факт: Патрік також є провідним розробником ProteanOS, проекту вбудованої
ОС, схваленого FSF: <http://proteanos.com/> (використовує BusyBox і Linux-libre)

Лія Роу провела *2* семінари LibrePlanet; один у 2015 році та інший у 2016 році,
відвідуючи Бостон, Массачусетс, США в обох випадках для участі в цих конференціях. Ці
семінари стосувалися встановлення Libreboot. Люди приходили на обидва семінари, щоб
встановити Libreboot на свої комп'ютери. Як системний адміністратор FSF, на той час,
Ліза забезпечила всю інфраструктуру та обладнання, яке використовувалося на цих семінарах.
Без її допомоги ці майстер-класи були б неможливими.

Коли материнська плата ASUS KGPE-D16 (серверна плата високого класу) була перенесена на Libreboot,
Лія, працюючи з Тімоті Пірсоном (той, хто її переніс),
приблизно в середині 2016 року поділилася з Лізою виправленнями, в основному виправленнями raminit, щоб отримати плату, яка працює в офісах FSF. Ця робота
зрештою призвела до чудового досягнення:

Веб-сайти FSF і GNU тепер працюють на, з встановленим Libreboot,
заснованих на ASUS KGPE-D16 серверах, на повністю вільному GNU+Linux дистрибутиві. Це
означає, що FSF тепер має повну свободу програмного забезпечення для своєї
інфраструктури хостингу.

FSF також надає доступ до цієї інфраструктури для багатьох інших проектів
(крім проектів GNU).

Ліза була сильною прихильницею Libreboot на перших днях проекту,
і її внесок був неоціненним. Я, Лія Роу, у боргу перед нею.

Маркус Мьоллер
--------------

Зробив логотип libreboot.

Nicholas Chin
-------------

[Ported Dell Latitude E6400 to Libreboot](news/e6400.md).

Патрік "П. Дж." Макдермотт
---------------------------

Патрік також провів багато досліджень і написав розділ поширених запитань libreboot,
пов'язаний із [Intel Management Engine](../faq.md#intelme), а також зробив кілька покращень у
системі збірки libreboot. **Колишній супроводжувач проекту
libreboot.**

У 2016 році Лія Роу провела семінар зі встановлення Libreboot на конференції FSF
LibrePlanet. Працюючи разом з Лією, Патрік допомагав вести семінар
та допомагав установлювати Libreboot на комп'ютери людей.

Пітер Стюдж
-----------

Допоміг написати [розділ поширених запитань про DMA](../faq.md#hddssd-firmware), та надав
загальні поради на перших днях проекту. У той час Пітер був розробником coreboot
і головним розробником проекту *libusb* (який flashrom
активно використовує).

Пітер також написав утиліту *bucts*, яка використовується для встановлення біта Top Swap
(TS) для керування резервним копіюванням (BUC) на ноутбуках i945, таких як ThinkPad X60/T60, яка є корисною для
обхідного шляху для прошивки Libreboot без використання зовнішнього обладнання; на цій машині,
з Lenovo BIOS, можна перепрошити все, крім головного завантажувального
блоку, але платформи Intel мають 2 завантажувальні блоки, і ви вказуєте, який із них
використовувати, встановленням біта TS. Потім ви завантажуєтеся лише з одним прошитим завантажувальним блоком
(завантажувальним блоком проекту coreboot на цій машині), а потім скидаєте
bucts перед повторною прошивкою ROM, щоб прошити основний завантажувальний блок. Libreboot
розміщує копію його роботи, оскільки його веб-сайт, на якому розміщено bucts,
більше не відповідає.

Пол Коціалковський
-----------------

Переніс ноутбуки Chromebook на основі ARM (Rockchip RK3288 SoC) до
libreboot. Також один із головних розробників [Replicant](http://www.replicant.us/).

Пол Менцель
-----------

Дослідив та виправив помилку в coreboot на ThinkPad X60/T60, яку виявляло
ядро Linux 3.12 і новіших версій, через яку прискорення 3D не
працювало, а відео загалом ставало нестабільним. Проблема полягала в тому, що
coreboot під час ініціалізації відеочіпсета Intel, відображав *GTT Stolen Memory* в
не тому місці, оскільки код базувався на коді ядра, а в ядрі Linux
була така сама помилка. Коли Linux це виправив, він виявив ту саму помилку в coreboot.

Пол працював над цим із Libreboot,
періодично надсилаючи патчі для тестування, доки помилку не було виправлено
в coreboot, а потім допоміг ій інтегрувати виправлення в libreboot.

Riku Viitanen
-------------

Added support for HP Elite 8200 SFF desktop PC to Libreboot. You can read
about this in the hardware page:

[HP Elite 8200 SFF](docs/hardware/hp8200sff.md)

Стів Шентон
-------------

Стів виконав першу роботу зі зворотньої розробки Intel Flash Descriptor, який використовується
на машинах ICH9M, таких як ThinkPad X200. Він створив структуру C, що визначає (використовуючи
бітові поля в C) цю область дескриптора. За допомогою деяких хитрих трюків він зміг
виявити існування біта в дескрипторі для *вимкнення* Intel ME
(management engine) на цих платформах.

Його початкове підтвердження концепції визначило лише дескриптор, і зробило би це:

* Читання дескриптора за замовчуванням і регіонів GbE з ROM Lenovo X200 (прошивка
  за замовчуванням, не coreboot)
* Вимкнення ME, встановивши 2 біти в дескрипторі
* Вимкнення регіона ME
* Переміщення дескриптора+GbE (загалом 12КБ) поруч
* Виділення решти флеш-пам'яті для регіону BIOS
* На основі цього створено 12КБ регіон дескриптор+область GBE для вставки
  в образ ROM coreboot.

У перші дні, до того, як Libreboot підтримував платформи GM45+ICH9M, такі як
ThinkPad X200/T400, ви могли використовувати ці машини, але щоб уникнути
Intel ME, вам доводилося виконувати прошивку без області дескриптора. У ті часи це працювало нормально,
тому що ME обробляв лише TPM та AMT на цих машинах, і система
працювала нормально, але Intel Flash Descriptor також обробляє область Intel GbE NVM
у флеш-пам'яті, яка використовується для інтерфейсу Intel Gigabit Ethernet.

Отже, ви або мали Intel ME, або не підтримували ethernet. Стів зрозумів, як
вимкнути Intel ME за допомогою 2 бітів перемикання в дескрипторі, а також як видалити область
Intel ME з флеш-пам'яті.

Ґрунтуючись на його дослідженні, я, Лія Роу, працюючи разом зі Стівом, також виконала зворотню розробку
області Intel GbE NVM (енергонезалежна пам'ять) у
завантажувальній флеш-пам'яті. Цей регіон визначає параметри конфігурації для вбудованої мережевої карти Intel
GbE, якщо присутня.

На основі цього я змогла взяти початкове підтвердження концепції та написати
утиліту `ich9gen`, яка генерує Intel Flash Descriptor та регіон GbE NVM,
з нуля, без визначення регіону Intel ME. Саме цей інструмент,
інструмент `ich9gen`, використовує Libreboot для надання образів ROM для GM45+ICH9M
платформ (таких як ThinkPad X200/T400/T500/W500), із повнофункціональним
дескриптором та функціональним Gigabit Ethernet, але *без* необхідності мікропрограми Intel
Management Engine (ME), що робить ці машини *вільними* (ME
повністю вимкнено, коли ви використовуєте образ дескриптора+gbe, створене `ich9gen`).

З *моїм* інструментом `ich9gen` (інструмент Стіва називався `ich9deblob`), вам більше
не потрібен був дамп оригінальної мікропрограми Lenovo BIOS! Я не могла би написати цей інструмент
без первинного підтвердження концепції Стіва. Я працювала з ним
протягом багатьох місяців. Вся GM45+ICH9M підтримка (X200, T400 і так далі) в
Libreboot стала можливою завдяки його роботі у 2014 році.

Тімоті Пірсон
---------------

Перенес плату ASUS KGPE-D16 до coreboot для компанії Raptor
Engineering, генеральним директором якої є Тімоті.
Тімоті підтримує цей код у coreboot, допомогаючи проекту,
з його інтеграцією з libreboot. Контактні
дані цієї людини є на сайті raptor.

**Підтримку D16 було припинено 19 листопада 2022 року. Ви все ще можете використовувати
старіші версії Libreboot, і старіші випуски.**

Swift Geek
----------

Додав патч для ich9gen для створення дескрипторів розміром 16MiB.

Після цього Swift Geek повільно почав долучатися, поки не став розробником на повний
робочий день. Внески Swift Geek насправді ніколи не були у формі *коду*,
але те, що йому не вистачало в коді, він компенсував чудовою підтримкою як для користувачів,
так і для інших розробників, допомагаючи іншим дізнатися більше про технології на
низькому рівні.

Коли Swift Geek був учасником проекту, його роль здебільшого полягала в
наданні підтримки користувачам (на каналі IRC) і проведенні досліджень. Swift Geek знає
багато про апаратне забезпечення. Swift Geek також зробив деяку апстрім розробку GRUB.

Swift Geek неодноразово надавав технічні поради Лії Роу
та допоміг їй покращити її навички паяння, а також навчив її
деяким навичкам ремонту, до того моменту, коли вона тепер може виправляти більшість несправностей
на материнських платах ThinkPad (під час перегляду схем та бордв'ю).

Swiftgeek залишив проект у березні 2021 року. Я, Лія Роу, бажаю його всього найкращого в його
починаннях і дуже вдячна за його численні внески протягом багатьох
років.

vitali64
--------

Додав підтримку cstate 3 на macbook21, що забезпечує тривалий термін служби батареї
та нижчу температуру процесора під час простою. vitali64 на irc
