---
title: Статус свободи програмного та апаратного забезпечення для кожної плати, яка підтримується Libreboot
x-toc-enable: true
...

Вступ
============

Коротка версія історії: *всі* плати, які наразі підтримуються Libreboot
можна ініціалізувати в coreboot з *вільним*, *поважаючим свободу* або *з відкритим джерелом* кодом, який
користувач може вивчати глибинно та адаптувати для своїх потреб, але існують
деякі застереження та підводні камні, які користувач повинен знати, для деяких машин.

Як багато користувачів може знати, coreboot (який Libreboot використовує для апаратної
ініціалізації) номінально *Вільне від слова Воля*, *вільне* або *з відкритим джерелом*
програмне забезпечення; хоча, coreboot намагається надати вільний код для ініціалізації кожної
машини. Розробники coreboot працюють дуже потужно для зворотньої розробки якомога більшої
кількості можливого функціоналу, для надання джерельного кода під вільною ліцензією.
Цих людей варто відзначити, оскільки Libreboot не міг би існувати без таких
зусиль з їх боку.

На *деяких* платах, які coreboot підтримує, деякі двійкові блоби вимагаються.
Це може бути для речей подібних ініціалізації кадрового буфера відео, налаштування
контролерів пам'яті і так далі. Двійковий блоб це, в цьому контексті, будь-яке програмне забезпечення,
яке тільки іде в формі виконуваного двійкового коду *з джерельним кодом недоступним*. Це
робить складнішим (але не неможливим) вивчення того, як програми працюють, і ці
блоби часто ідуть з обмеженням або на їх використання та/або розповсюдження.

Мета цього документа - чітко описати наявність (або відсутність)
двійкових блобів на кожній даній апаратній платформі або, у межах кожної платформи,
на певних варіантах материнської плати. На веб-сайті Libreboot подібна інформація була
відсутня або викладена погано, тому було вирішено написати офіційну
документацію. Причиною такої відсутності було те, що Libreboot раніше
давав підтримку *лише* для тих плат, які *не* потребують двійкових блобів
у головній флеш-схемі для завантажувального мікропрограмного забезпечення, тому така документація не була потрібна.

Більш *прагматична* політика була опублікована протягом листопада 2022 року, з поглядом
на допомогу настільки багатьом людям, наскільки можливо, у встановленні coreboot, навіть на менш-ніж-ідеальному
апаратному забезпеченні (продовжуючи також підтримувати більше дружнє до свободи апаратне забезпечення).
Libreboot досі має суворі стандарти про те, *які* точно блоби дозволені,
які ви можете прочитати в наступному документі, так:

[Політика зменшення бінарних блобів](news/policy.uk.md)

В цій статті ви вивчите всі шляхи (на практиці), якими Libreboot
реалізовує цю *політику зменшення блобів*, особливо в тому рядку в ній, який каже,
цитата, "якщо блоб можна уникнути, його необхідно уникнути".

Чому це має значення?
---------------------

*Практичною метою* проекта Libreboot є підтримка якомога більшої кількості апаратного забезпечення
підтримки coreboot, повністю протестованого з попередньо зібраними образами ROM
та легкими інструкціями прошивки, направленими на нетехнічних користувачів, щоб привнести
якомога більше користувачів в спільноту coreboot. З більшою кількістю користувачів, набагато
більше людей відкриються coreboot і це неминуче призведе до більшої кількості
людей, які розробляють coreboot, що є критичним проектом руху за вільне
програмне забезпечення. З більшою кількістю розробників, більше *користувачів* матимуть змогу досягти рівень
свободи або *суверенітету* в їх обчисленнях та, тому, цикл має продовжитись.

Ця мета існує, тому що *ідеологічною метою* Libreboot є поширення
свободи програмного забезпечення будь-якими необхідними засобами, настільки багатьом людям, наскільки можливо.
Універсальний доступ до джерельного кода, здатність вивчати та змінювати код або
перерозповсюджувати його, та виконувати його нескінченно з будь-якою метою надзвичайно важлива.
Таким свободам варто бути *за замовчуванням* для всього програмного забезпечення. Це робить coreboot
надзвичайно корисним, навіть у випадках, де двійковий блоб є необхідним для певної
функціональності. Свободі варто бути *за замовчуванням* для всього програмного забезпечення, і це є
метою *Libreboot* допомогти продемонструвати це реальністю.

*Політика* проекта Libreboot, в межах цієї мети, надання такої
підтримки апаратного забезпечення з якомога *меншою* можливою кількостю двійкових блобів, в ідеалі *відсутньою*, як
у випадку з багатьма конфігураціями, які підтримує Libreboot. Libreboot *спробує*
підтримувати будь-яку дану одиницю апаратного забезпечення, навіть у випадках, де *повна*
свобода програмного забезпечення не є можливою; наприклад, якщо coreboot вимагає блоб для
raminit на даній платі, блоб було би надано Libreboot.

*Ви можете прочитати політику зменшення/мінімалізації блобів Libreboot в більших подробицях.
Будь ласка, прочитайте документ, названий: [Політика зменшення бінарних
блобів](news/policy.uk.md).*

Архітектура Coreboot
---------------------

Хоча не *суворо* необхідно для не-розробників, Ви можете знайти корисним
набуття розуміння на високому рівні того, *як* працює coreboot, для набуття
деякого контексту про деякі із тем, які обговорено в цій статті. Дивіться:

<https://doc.coreboot.org/getting_started/architecture.html>

100% вільна ініціалізація coreboot
===========================

*Всі* плати, які наразі підтримуються Libreboot можуть мати 100%
вільну ініціалізацію *зі сторони coreboot*. В цьому контексті, це має на увазі
будь-яку ініціалізацію, яка виконується головним процесором, для підняття машини для
виконання кода.

Завантажувальна прошивка не є *єдиним* програмним забезпеченням, присутнім в будь-якій машині, та існують
деякі контексти, які потрібно зрозуміти, щоб побачити більшу картину.

Причина, чому ця різниця має значення (посилаючись конкретно на сторону
ініціалізації coreboot), стане зрозуміліше, в наступних секціях:

Універсальний захист зроблено в Libreboot, дозволяючи (читайте: вимагаючи, згідно з
політикою проекту) включення оновлень мікрокоду ЦП, якщо доступно. Ви можете
прочитати більше про це і причини *чому*, прочитавши наступну статтю:

[Оновлення мікрокоду ЦП
є **нормальним**](news/policy.uk.md#більш-детальна-інформація-про-мікрокод)

[Releases after Libreboot 20230423 will provide separate ROMs with microcode
excluded, alongside default ones with microcode included.](news/microcode.md)

Платформи Intel
===============

Дескрипторне проти бездескрипторного налаштування
----------------------------------

Libreboot підтримує декілька материнських плат, які використовують платформи Intel. Серед них існує
суттєво два класи машин (для цілей цієї статті):

* Бездескрипторне налаштування
* Дескрипторне налаштування

Що означає *дескриптор*? Гаразд, традиційно, основна флеш інтегральна мікросхема (яка містить
завантажувальну прошивку, зазвичай на яку посилаються як на *BIOS*) на машинах Intel,
містила тільки виконуваний код *x86*, який відповідає за ініціалізацію всього
апаратного забезпечення, такого як ЦП, контролер пам'яті та периферія. Це те, що
ми будемо називати *бездескрипторне* налаштування; в таких конфігураціях,
прошивка Intel ME є відсутньою за замовчуванням.

В *дескрипторному* налаштуванні, флеш поділений на регіони, такі як:

* Intel flash descriptor: завжди перші 4Кбайт флеш. Закодовані двійково
  конфігураційні дані для машини, та регіони (такі як цей, або
  інші нижче) оголошено тут. Деяким чином, ви можете думати про це
  аналогічно до *Master Boot Record* на жорсткому диску.
* Intel GbE NVM (неволатильна пам'ять gigabit ethernet): закодовані двійково
  конфігураційні дані, для пристроя Intel gigabit ethernet на платі, якщо такий
  є присутнім. Вона містить багато налаштувань, таких як MAC-адреса, на якій швидкості мережева карта
  має працювати, PCI ID, *швидкість мерехтіння LED* та більше.
  Якщо використовується мережева карта не Intel, цей флеш-регіон не буде присутнім.
* ME (Intel Management Engine): *брудний* недолік безпеки в своєму стані
  за замовчуванням, ME надає багато функцій, таких як віддалене керування, з повним
  мережевим функціоналом, ME є виділеним сопроцесором, окремим від головного ЦП, та
  прошивка ініціалізації плюс операційна система для нього завантажується з
  цього виділеного регіона в основній завантажувальній флеш-пам'яті. Більше інформації доступно [в
  частих запитаннях](faq.uk.md#intelme) - там де в іншому випадку прошивка ME є присутньою, Libreboot
  або видаляє її, або (за допомогою програми `me_cleaner`) переналаштовує її таким
  чином, що його вимкнено в процесі ініціалізації машини.
* Регіон платформи: непрограмні дані, зазвичай просто купа рядків розміщена тут
  продавцем апаратного забезпечення.
* Регіон BIOS: цей містить основну завантажувальну прошивку, відповідальну за
  ініціалізацію ЦП, контролера пам'яті та периферії, призводячи
  машину в стан, де вона може виконувати програми (скоріше за все, що завантажувач,
  а потім операційну систему). Код coreboot (наданий Libreboot) іде
  тут.

*По суті*, ви можете думати про такі "регіони" за аналогією до *розділів* на
жорсткому диску. Що важливо так це те, що інтегральна мікросхема флеш-пам'яті *розділена* на такі
регіони, де кожний регіон призначено для конкретної мети.

На деяких новіших дескрипторних платформах Intel, існує більше регіонів, ніж
ці. В деяких випадках, *[вбудований
контролер](faq.uk.md#прошивка-ec-вбудований-контролер)* (EC) може також
бути в своєму власному регіоні на завантажувальній флеш-пам'яті; щонайменш, наразі, це не є
актуальним ні на якому апаратному забезпеченні, яке підтримує Libreboot (натомість, це зберігається
на окремій інтегральній мікросхемі).

Вміст регіонів *дескриптора* та *GbE* описано в даташітах Intel,
але ті даташіти часто містять *зарезервовані* секції, де
частини залишені незадокументованими. Зусилля зворотної розробки протягом років
задокументували деякі з цих прогалин.

Libreboot *не* розповсюджує образи Intel ME
-----------------------------------------------

ME містить багато модулів в собі, і один з цих модулів це
код BringUp. Цей код BringUp є *власною* прошивкою ініціалізації ME,
подібною coreboot. Згідно з тією самою аналогією, інші модулі
Intel ME (такі як: ядро ME) є подібними (концептуально) до
*корисного навантаження coreboot*.

Так, налаштування *нейтралізованого ME* є, на сопроцесорі intel ME, аналогічним до
виконання coreboot без корисного навантаження. В цьому стані, ME ініціалізує себе
готовим до виконання коду, але потім *насправді не виконує код*. Він таким чином не шкідливий,
обидва з точки зору безпеки- та точки зору свободи. Іншими словами, ME
є *вимкненим*.

Libreboot *не* розповсюджує прошивку Intel ME жодним чином, ні в сховищі
Git, ні в випусках. Де необхідно, Libreboot надає
сценарії, які автоматично отримують та встановлюють її, в *нейтралізованому* стані, за
допомогою виконання програми `me_cleaner`, про яку ви можете почитати тут:

<https://github.com/corna/me_cleaner/wiki/How-does-it-work%3F>

Це повністю автоматизовано. Якщо ви будуєте образи ROM з `lbmk.git`,
автоматизованої системи побудови libreboot, прошивка ME буде завантажена,
нейтралізована за допомогою `me_cleaner` та вставлена в фінальний образ ROM автоматично.

*Випущені* образи ROM, надані попередньо зібраними, упускають прошивку Intel ME. На
платформах, які вимагають її, *ті самі* сценарії, які вставляють її в процесі
побудови, можуть *також* виконувати після-побудову, перевставляючи Intel ME в завантажувальну ROM. Це в
зв'язку з проблемними питаннями ліцензіювання, оточуючими розповсюдження образів Intel ME.

Система побудови Libreboot отримує її напряму від продавця для даної
машини або набору машин (в якості приклада, Lenovo надає образи для декількох
машин ThinkPad). Це гарантує, що кожен користувач отримує точно таку саму
конфігурацію (іншою альтернативою є витаскування прошивки Intel ME з
оригінального образа продавця, в регіоні ME інтегральної схеми флеш-пам'яті).

Ви можете дізнатись про це більше на наступній сторінці:
[docs/install/ivy_has_common.uk.md](docs/install/ivy_has_common.uk.md)

Прошивка ME є *обов'язковою* на майже всіх платформах Intel, або машина
*вимкнеться* після 30 хвилин. В нейтралізованому налаштуванні, код BringUp
Intel ME вимкне той час скидання в 30 хвилин, дозволяючи вам використовувати ваш
комп'ютер нормально, навіть незважаючи на те, що ME *не* виконує нічого після цього.

Нейтралізований ME дійсно є вимкненим
------------------------------

Зважайте на це: якщо ME тільки робить свій власний BringUp, але потім не
виконує нічого, чи це дійсно щось більше ніж незначний відтік часу життя вашої
батареї? В нейтралізованому стані, Intel ME є лише неактивним комп'ютером
на вашій материнській платі, таким, що нічого не робить, який вам не потрібен і який ви
ніколи не будете використовувати. Таким чином, його можна розцінювати нешкідливим з обох перспективи свободи
програмного забезпечення та перспективи безпеки, і це є поглядом, який взято
проектом Libreboot.

Якщо триматись цих припущень, і ви погодились зі статтею Libreboot про
мікрокод, на яку наведено посилання зверху, і зважаєте *факт*, що (щонайменш, станом на
зараз) Libreboot є здатним на повністю вільну ініціалізацію в межах coreboot, тоді
ми можемо не без причини бути впевненими, що Libreboot надає гарний рівень свободи
програмного забезпечення. Так, незважаючи на те, як дехто може інакше почувати, якщо вони *не* мають
такої перспективи.

Тобто, хоча код BringUp, який залишається для Intel ME *є* пропрієтарним,
та не може бути модифікованим, в зв'язку з перевіркою криптографічного підпису
апаратним забезпечення, це є програмним забезпеченням для пристрою, який ви ніколи не захочете насправді
використовувати в реальному світі, тобто якщо він *не робить нічого* в нейтралізованому стані, тоді
його може бути проігноровано на практиці. Це залежить від вашої точки зору, і деякі
люди можуть займати більш догматичний підхід, ніж цей. Проект Libreboot
зважає нейтралізовані налаштування ME прийнятними, обидва з перспективи безпеки
та перспективи свободи програмного забезпечення.

Більше про видалення/вимкнення Intel ME
----------------------------------

*Libreboot* надає шлях повністю видалити прошивку ME, зберігаючи
повне використання машини, на платформах GM45 з південним мостом ICH9M. Це 
ноутбуки: ThinkPad X200/T400/T500/W500 і так далі з того покоління. Дивіться:
[docs/install/ich9utils.md](docs/install/ich9utils.md)

На новіших платформах використовується `me_cleaner`. Ви можете прочитати про це тут:

<https://github.com/corna/me_cleaner/wiki/How-does-it-work%3F>

Option ROM VGA
============

*Нативна* ініціалізація відео підтримується та *увімкнена*, для всіх платформ
Intel, які підтримуються, що мають її. Джерельний код надано coreboot, під
вільною ліцензією.

На *деяких* машинах, подвійна графіка є можливою. Наприклад, конкретні материнські плати ThinkPad
T440p ідуть з обома графічними картками Intel та Nvidia, де ви можете
або використовувати *обидві*, або тільки Intel; для використання графічної картки Nvidia, двійковий блоб
вимагається, який Libreboot не надає (і не захоче надавати), натомість вибираючи
увімкнення тільки графічної карти *Intel* (де вільний код ініціалізації є доступним
в coreboot). В більшості материнських плат T440p, *тільки* графічна картка Intel є фізично
присутньою.

На деяких материнських платах ThinkPad T400, W500 та T500, графічні карти ATI та Intel є
присутніми, і ви можете використовувати або одну, або обидві. Ще раз, Libreboot *тільки* підтримує
графічну картку Intel, де coreboot має вільний код ініціалізації.

Це є прикладом нюансованого характеру в політиці Libreboot. Libreboot
*міг би* надавати подібні блоби, з судженням, що *необхідно*
використовувати ці додаткові процесори. Однак, на практиці, ці машини є повністю придатними
для використання лише з графікою Intel, для якої джерельний код є доступним.

За замовчуванням Libreboot є *завжди* свобода, коли можливо на практиці. Користувачі, які
бажають мати використання додаткових графічних процесорів, на такому апаратному забезпеченні, мають взяти до уваги
наступний параграф у політиці Libreboot:

*"Принципам зверху варто бути застосованими до конфігурацій за замовчування. Однак,	
libreboot є налаштовуваним, дозволяючи користувачу робити все, що заманеться."* -
налаштовуваний, напевно! Дивіться: [docs/maintain/](docs/maintain/)

Ініціалізація контролера пам'яті
--------------------------------

Libreboot має *повністю вільну* ініціалізацію, доступну для всіх контролерів пам'яті Intel
на платформах, які підтримуються. Це *включає* Haswell (ThinkPad T440p
та W541), станом на Libreboot 20230319 та пізніші.

Платформи ARM (chromebook)
=============

В більшості без блобів, за вийнятком вимоги на материнських платах `daisy` та `peach`
включати блоби завантажувача BL1. Це:

* HP Chromebook 11 G1 (daisy-spring)
* Samsung Chromebook XE303 (daisy-snow)
* Samsung Chromebook 2 13” (peach-pi)
* Samsung Chromebook 2 11” (peach-pit)

Libreboot *наразі* не розміщує ці блоби взагалі, і це
вважається *помилкою*; це задокументовано на сторінці сумісності
апаратного забезпечення. Їх можна додати вручну користувачем, але документації для цього
наразі бракує на веб-сайті Libreboot.

Список необхідних блобів, конкретно для кожної плати
=================================================

Ця стаття ретельно пояснила, в деталізованому огляді, точний
характер того, *які* бінарні блоби розміщуються в Libreboot. Знову,
повністю вільна ініціалізація з coreboot є доступною *на всіх наразі підтримуваних платах*.

*З coreboot* є критичним аспектом цього, але повні межі Libreboot це
основна завантажувальна інтегральна схема, яка (в деяких випадках) містить програмне забезпечення не з coreboot.

Ось список, *для кожної* плати, цих блобів:

Intel/x86
---------

### Intel ME:

Нейтралізований ME потрібен на цих цілях: `t420_8mb`, `t420s_8mb`, `t430_12mb`,
`t440p_12mb`, `t440pmrc_12mb`, `t520_8mb`, `t530_12mb`, `w530_12mb`,
`w541_12mb`, `w541mrc_12mb`, `x220_8mb`, `x230_12mb`, `x230_16mb`,
`x230edp_12mb`, `x230t_12mb`, `x230t_16mb`, `hp8200sff_8mb`, `hp2560p_8mb`,
`hp2570p_16mb`, `hp2170p_16mb`, `hp9470m_16mb`, `hp820g2_12mb` та `t1650_12mb`.

Як заявлено, Libreboot надає це в стані, де ME більше не є
загрозою для безпеки. Він ініціалізує себе, але потім нічого не робить, тому його
вимкнено. Це зроблено використовуючи `me_cleaner`. Дивіться:
<https://github.com/corna/me_cleaner/wiki/How-does-it-work%3F>

### KBC1126 EC firmware (HP laptops):

This applies to the following targets: `hp2170p_16mb`, `hp2560p_8mb`,
`hp2570p_16mb`, `hp8470pintel_16mb`, `hp9470m_16mb`.

[EC firmware](faq.md#ec-embedded-controller-firmware)
is inserted into main boot flash, rather than being on a separate
IC. This is *better* because libre replacements would be more easy to install in
the future, and reverse engineering is made much easier by it. Libreboot's
build system handles such firmware with scripts, automatically downloading
it during the build process. Libreboot 20230423 onwards does scrub EC firmware
and provide functionality in a special script, to insert them with `cbfstool`
at the correct offset as defined by coreboot config for each board.

### SMSC SCH5545 Environmental Control

This is a tiny firmware required for fan control, on Dell Precision T1650.

### CPU microcode:

Оновлення [*мікрокоду*](faq.uk.md#microcode)
для ЦП надано на *всіх* платформах x86, за замовчуванням. Не
вимагається технічно, але надзвичайно рекомендовано. Виконайте для видалення:

	cbfstool filename.rom remove -n cpu_microcode_blob.bin

[Releases after Libreboot 20230423 will provide separate ROMs with microcode
excluded, alongside default ones with microcode included.](news/microcode.md)

Видалення оновлень мікрокоду вплине на стабільність системи негативно,
впроваджуючи нестандартну поламану поведінку і його результатом може бути
неможливість машини правильно завантажуватись. В інших випадках, видалення його може поламати такі функції,
як S3 suspend/resume.

Блоби мікрокоду ЦП включено за замовчуванням, на всіх платах x86. В той час як не потрібні
в більшості випадків, їх використання надзвичайно рекомендовано. Дивіться для причин чому:
[news/policy.uk.md#більш-детальна-інформація-про-мікрокод](news/policy.uk.md#більш-детальна-інформація-про-мікрокод)

### Intel Flash Descriptor (IFD):

Intel Flash Descriptor надано в якості блобів на деяких платах, але це не є
блобами *програмного забезпечення*. Це конфігурації, які надано в двійковому форматі,
повністю придатному для читання вільним програмним забезпеченням. Наприклад:

* Програма Libreboot `ich9gen` створює флеш-дескриптори ICH9M з нуля.
* Програма Coreboot `ifdtool` має обширні функції для маніпуляції Intel
  flash descriptor.
* Програма Coreboot `bincfg` створює будь-який вид бінарних з файлу `.spec`,
  який може описувати будь-який бінарний формат в форматі, який можна прочитати людині. Вона містить
  декілька Intel flash descriptor для декількох платформ, але Libreboot не використовує
  їх.

Конфігурація Intel GbE NVM (конфігураційні дані, закодовані двійково, для гігабітної мережевої картки):

* Програма Libreboot `ich9gen` *також* створює образи GbE NVM, конкретно
  для мережевих карток Intel, які використані в Thinkpad GM45.
* Програма Libreboot `nvmutil` може маніпулювати образами GbE NVM

ARM/chromebook
---------------

### BL1 bootloader (peach/daisy):

BL1 завантажувач потрібен на: `daisy_snow`, `daisy_spring` та `peach_pit`.

Висновки
==========

З вищезазначеного, ви можете бачити, що Libreboot в дійсності *надає* *політику зменшення
бінарних блобів*, з наголошенням на *зменшенні*, що є найбільш критичним.

Libreboot *міг би* додати багато блобів для різних платформ, для увімкнення різноманітних
додаткових функцій, які натомість він уникати додавати, в точності тому, що *метою*
проекта Libreboot є поширення *вільного* програмного забезпечення та *мінімізація* сили,
яку розробники пропрієтарного програмного забезпечення мають над користувачами.

Я сподіваюсь, що ця стаття надала їжу для роздумів.

Відступ: свобода обладнання
--------------------------

Жодна з машин, які наразі підтримуються Libreboot не має вільного *апаратного забезпечення*, в тому
сенсі, що інтегральні схеми не ідуть з публічно доступними файлами *verilog* та
подібним. Ви не змогли би виготовити власну заміну цих машин.

Деякі схеми та файли бордв'ю описують друковані плати окремих
машин, які доступні онлайн, через різноманітні канали. Ви маєте знайти їх
власноруч; одного дня, рух Право на ремонт, сподіваюся, принесе
універсальний доступ до таких документів спільноті.

Для подальшого читання
===============

В цій статті описано код, який міститься в *основній завантажувальній флеш-пам'яті*, але
будь-який комп'ютер, який ви придбаєте, матиме *тони* мікропрограм в інших частинах системи. Деякі
відомості доступні на сторінці частих запитань Libreboot. Дивіться:

* [faq.uk.md#який-рівень-програмної-свободи-дає-мені-libreboot](faq.uk.md#який-рівень-програмної-свободи-дає-мені-libreboot)
* [faq.uk.md#яке-ще-мікропрограмне-забезпечення-існує-за-межами-libreboot](faq.uk.md#яке-ще-мікропрограмне-забезпечення-існує-за-межами-libreboot)

З них найбільш критичним є прошивка жорстких дисків/твердотілих накопичувачів та прошивка EC. Проблема описана
в цих двох посиланнях застосовується до багатьох різних комп'ютерів, включаючи
Libreboot, та практично кожний інший комп'ютер в світі.
