/** @file

Copyright (c) 2015, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSP_VPD_H__
#define __FSP_VPD_H__

#pragma pack(1)


#define MAX_CH 2            /* Maximum Number of Memory Channels */
#define MAX_DIMM 2          /* Maximum Number of DIMMs PER Memory Channel */

typedef enum {
  MEMORY_ABSENT     = 0, /* No memory down and no physical memory slot. */
  MEMORY_DOWN_ONLY  = 1, /* Memory down and not a physical memory slot. */
  MEMORY_SLOT_ONLY  = 2, /* No memory down and a physical memory slot.  */
} MemorySlotStatus;

typedef struct {
  MemorySlotStatus SlotStatus[MAX_CH][MAX_DIMM];  /* Memory Down, Absent or Slot status of each DIMM in each Channel */
  UINT16           SpdDataLen;                    /* Length in Bytes of a single DIMM's SPD Data */
  UINT8            *SpdDataPtr[MAX_CH][MAX_DIMM]; /* Array of Pointers to SPD Data for each DIMM in each Channel */
} MEMORY_DOWN_DATA;

typedef struct {
  UINT32 VendorDeviceId;     /* Vendor ID/Device ID */
  UINT16 SubSystemId;        /* SubSystem ID */
  UINT8  RevisionId;         /* Revision ID. 0xFF applies to all steppings */
  UINT8  FrontPanelSupport;  /* Front panel support (1=yes, 2=no) */
  UINT16 NumberOfRearJacks;  /* Number of Rear Jacks */
  UINT16 NumberOfFrontJacks; /* Number of Front Jacks */
} SA_HDA_HEADER;

typedef struct {
  UINT16 VendorId;          /* Codec Vendor ID */
  UINT16 DeviceId;          /* Codec Device ID */
  UINT8  RevisionId;        /* Revision ID of the codec. 0xFF matches any revision. */
  UINT8  SdiNo;             /* SDI number, 0xFF matches any SDI. */
  UINT16 DataDwords;        /* Number of data DWORDs pointed by the codec data buffer. */
  UINT32 Reserved;          /* Reserved for future use. Must be set to 0. */
} AZALIA_HEADER;

typedef struct {
  SA_HDA_HEADER Header;     /* SA HDA header */
  UINT32        *Data;      /* Pointer to the data buffer. Its length is determined by the header */
} AUDIO_SA_VERB_TABLE;

typedef struct {
  AZALIA_HEADER Header;     /* AZALIA PCH header */
  UINT32        *Data;      /* Pointer to the data buffer. Its length is specified in the header */
} AUDIO_AZALIA_VERB_TABLE;



typedef struct _UPD_DATA_REGION {
/**Offset 0x0000 
**/
  UINT64                      Signature;                     
/**Offset 0x0008 
**/
  UINT64                      Reserved;                      
/**Offset 0x0010 
**/
  UINT8                       UnusedUpdSpace0[16];           
/**Offset 0x0020 
   SPD Address of DIMM. 
**/
  UINT8                       PcdSpdBaseAddress_0_0;         
/**Offset 0x0021 
   SPD Address of DIMM. 
**/
  UINT8                       PcdSpdBaseAddress_0_1;         
/**Offset 0x0022 
   SPD Address of DIMM. 
**/
  UINT8                       PcdSpdBaseAddress_1_0;         
/**Offset 0x0023 
   SPD Address of DIMM. 
**/
  UINT8                       PcdSpdBaseAddress_1_1;         
/**Offset 0x0024 
   Size of SMRAM memory reserved. 
**/
  UINT8                       PcdTsegSize;                   
/**Offset 0x0025 
**/
  UINT32                      UnusedUpdSpace1;               
/**Offset 0x0029 
   Size of memory preallocated for internal graphics. 
**/
  UINT8                       PcdIgdDvmt50PreAlloc;          
/**Offset 0x002A 
   Select which of IGFX/PEG/PCI Graphics device should be Primary Display. 
**/
  UINT8                       PcdPrimaryDisplay;             
/**Offset 0x002B 
   Enable/disable internal graphics. 
**/
  UINT8                       PcdInternalGfx;                
/**Offset 0x002C 
   Size of memory address space reserved for MMIO (Memory Mapped I/O). 
**/
  UINT8                       PcdMmioSize;                   
/**Offset 0x002D 
**/
  UINT8                       UnusedUpdSpace2;               
/**Offset 0x002E 
   Select the Aperture Size. 
**/
  UINT8                       PcdApertureSize;               
/**Offset 0x0030 
**/
  UINT8                       ReservedUpdSpace0[80];         
/**Offset 0x002F 
**/
  UINT8                       UnusedUpdSpace3;               
/**Offset 0x0080 
   Enable/disable LAN controller. 
**/
  UINT8                       PcdEnableLan;                  
/**Offset 0x0081 
   Enable/disable SATA controller. 
**/
  UINT8                       PcdEnableSata;                 
/**Offset 0x0082 
   Select SATA controller working mode. 
**/
  UINT8                       PcdSataMode;                   
/**Offset 0x0083 
   Enable/disable Azalia controller. 
**/
  UINT8                       PcdEnableAzalia;               
/**Offset 0x0084 
   Enable/disable XHCI controller. 
**/
  UINT8                       PcdEnableXhci;                 
/**Offset 0x0085 
   Enable/disable EHCI controller #1. 
**/
  UINT8                       PcdEnableEhci1;                
/**Offset 0x0086 
   Enable/disable EHCI controller #2. Note this option is only applicable to SKUs with two EHCI controllers. 
**/
  UINT8                       PcdEnableEhci2;                
/**Offset 0x0087 
   Enable/disable SMBus 
**/
  UINT8                       PcdEnableSmbus;                
/**Offset 0x0088 
   Enable/disable PCH Audio DSP controller. Note: if enabled Azalia must be disabled. 
**/
  UINT8                       PcdEnableAudioDsp;             
/**Offset 0x0089 
**/
  UINT64                      ReservedUpdSpace1;             
/**Offset 0x0091 
   Power Management Base Address 
**/
  UINT16                      PcdPmBase;                     
/**Offset 0x0093 
   Pch PCIe Root Port Enable. The bit 0 is mapped to port 1, bit 1 is mapped to port 2, and so on. 
**/
  UINT16                      PcdPchPcieRootPortEnable;      
/**Offset 0x0095 
   Pch PCIe Slot Implemented. The bit 0 is mapped to port 1, bit 1 is mapped to port 2, and so on. 
**/
  UINT16                      PcdPchPcieSlotImplemented;     
/**Offset 0x0097 
   Pch PCIe Root Port Function Swapping Enable 
**/
  UINT8                       PcdPchPcieRootPortFunctionSwappingEnable; 
/**Offset 0x0098 
   GPIO Base Address 
**/
  UINT16                      PcdGpioBase;                   
/**Offset 0x009A 
   Pch SATA Port Enable. The bit 0 is mapped to port 1, bit 1 is mapped to port 2, and so on. 
**/
  UINT16                      PcdPchSataPortEnable;          
/**Offset 0x009C 
   SATA Drive Type. 0: HDD, 1: SDD. The bit 0 is mapped to port 1, bit 1 is mapped to port 2, and so on. 
**/
  UINT16                      PcdPchSataSolidStateDrive;     
/**Offset 0x009E 
   SATA Mechanical Presence Switch. 0: No, 1: Yes. The bit 0 is mapped to port 1, bit 1 is mapped to port 2, and so on. 
**/
  UINT16                      PcdPchSataInterlockSw;         
/**Offset 0x00A0 
   If enabled for any of ports Staggered Spin Up will be performed and only the drives which have this option enabled will spin up at boot. Otherwise all drives spin up at boot. 0: No, 1: Yes. The bit 0 is mapped to port 1, bit 1 is mapped to port 2, and so on. 
**/
  UINT16                      PcdPchSataSpinUp;              
/**Offset 0x00A2 
   Designates port as Hot Pluggable. 0: No, 1: Yes. The bit 0 is mapped to port 1, bit 1 is mapped to port 2, and so on. 
**/
  UINT16                      PcdPchSataHotPlug;             
/**Offset 0x00A4 
**/
  UINT8                       UnusedUpdSpace5[92];           
/**Offset 0x0100 
   Enable/disable Fast Boot function. Once enabled, all following boots will use the presaved MRC data to improve the boot performance. 
**/
  UINT8                       PcdFastBoot;                   
/**Offset 0x0101 
   Specify the closest CRB board type to the platform. 
**/
  UINT8                       PcdUserCrbBoardType;           
/**Offset 0x0102 
**/
  UINT8                       UnusedUpdSpace6[130];          
/**Offset 0x0184 
**/
  AUDIO_AZALIA_VERB_TABLE*    AzaliaVerbTablePtr;            
/**Offset 0x0188 
**/
  UINT64                      UnusedUpdSpace7;               
/**Offset 0x0190 
   Indicate whether it comes with effective Dq/Dqs mapping data  
**/
  UINT8                       DqDqsDataEffective;            
/**Offset 0x0191 
**/
  UINT8                       UnusedUpdSpace8[11];           
/**Offset 0x019C 
   Dq byte mapping between CPU and DRAM 
**/
  UINT8                       DqByteMap[24];                 
/**Offset 0x01B4 
**/
  UINT8                       UnusedUpdSpace9[76];           
/**Offset 0x0200 
   Set Dqs mapping relationship between CPU and DRAM 
**/
  UINT8                       DqsMapCpu2Dram[16];            
/**Offset 0x0210 
**/
  UINT32                      SpdDataBuffer_0_0;             
/**Offset 0x0214 
**/
  UINT32                      SpdDataBuffer_0_1;             
/**Offset 0x0218 
**/
  UINT32                      SpdDataBuffer_1_0;             
/**Offset 0x021C 
**/
  UINT32                      SpdDataBuffer_1_1;             
/**Offset 0x0220 
**/
  UINT8                       UnusedUpdSpace10[240];         
/**Offset 0x0310 
**/
  UINT16                      PcdRegionTerminator;           
} UPD_DATA_REGION;

#define FSP_IMAGE_ID    0x2450534657444224        /* '$BDWFSP$' */
#define FSP_IMAGE_REV   0x02090000 

typedef struct _VPD_DATA_REGION {
/**Offset 0x0000 
**/
  UINT64                      PcdVpdRegionSign;              
/**Offset 0x0008 
**/
  UINT32                      PcdImageRevision;              
/**Offset 0x000C 
**/
  UINT32                      PcdUpdRegionOffset;            
/**Offset 0x0010 
**/
  UINT8                       UnusedVpdSpace0[16];           
/**Offset 0x0020 
**/
  UINT32                      PcdFspReservedMemoryLength;    
/**Offset 0x0024 
   Control where the Port 80h cycles are sent, 0: LPC; 1: PCI. 
**/
  UINT8                       PcdPort80Route;                
} VPD_DATA_REGION;

#pragma pack()

#endif
