# x86 architecture documentation

This section contains documentation about coreboot on x86 architecture.

* [x86 PAE support](pae.md)

## State of x86_64 support
At the moment there's only experimental x86_64 support.
The `emulation/qemu-i440fx` and `emulation/qemu-q35` boards do support
*ARCH_RAMSTAGE_X86_64* , *ARCH_POSTCAR_X86_64* and *ARCH_ROMSTAGE_X86_64*.

In order to add support for x86_64 the following assumptions were made:
* The CPU supports long mode
* All memory returned by malloc must be below 4GiB in physical memory
* All code that is to be run must be below 4GiB in physical memory
* The high dword of pointers is always zero
* The reference implementation is qemu
* The CPU supports 1GiB hugepages
* x86 payloads are loaded below 4GiB in physical memory and are jumped
  to in *protected mode*

## Assumptions for all stages using the reference implementation
* 0-4GiB are identity mapped using 2MiB-pages as WB
* Memory above 4GiB isn't accessible
* page tables reside in memory mapped ROM
* A stage can install new page tables in RAM

## Page tables
Page tables are generated by a tool in `util/pgtblgen/pgtblgen`. It writes
the page tables to a file which is then included into the CBFS as file called
`pagetables`.

To generate the static page tables it must know the physical address where to
place the file.

The page tables contains the following structure:
* PML4E pointing to PDPE
* PDPE with *$n* entries each pointing to PDE
* *$n* PDEs with 512 entries each

At the moment *$n* is 4, which results in identity mapping the lower 4 GiB.

## Basic x86_64 support
Basic support for x86_64 has been implemented for QEMU mainboard target.

## Reference implementation
The reference implementation is
* [QEMU i440fx](../../mainboard/emulation/qemu-i440fx.md)
* [QEMU Q35](../../mainboard/emulation/qemu-q35.md)

## TODO
* Identity map memory above 4GiB in ramstage

## Future work

1. Fine grained page tables for SMM:
   * Must not have execute and write permissions for the same page.
   * Must allow only that TSEG pages can be marked executable
   * Must reside in SMRAM
2. Support 64bit PCI BARs above 4GiB
3. Place and run code above 4GiB

## Porting other boards
* Fix compilation errors
* Test how well CAR works with x86_64 and paging
* Improve mode switches
* Test libgfxinit / VGA Option ROMs / FSP
