/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __SOC_MEDIATEK_MT8192_INCLUDE_SOC_ADDRESSMAP_H__
#define __SOC_MEDIATEK_MT8192_INCLUDE_SOC_ADDRESSMAP_H__

enum {
	MCUSYS_BASE	= 0x0C530000,
	IO_PHYS		= 0x10000000,
};

enum {
	MCUCFG_BASE		= MCUSYS_BASE + 0x00008000,
};

enum {
	CKSYS_BASE		= IO_PHYS,
	INFRACFG_AO_BASE	= IO_PHYS + 0x00001000,
	GPIO_BASE		= IO_PHYS + 0x00005000,
	SPM_BASE		= IO_PHYS + 0x00006000,
	RGU_BASE		= IO_PHYS + 0x00007000,
	GPT_BASE		= IO_PHYS + 0x00008000,
	EINT_BASE		= IO_PHYS + 0x0000B000,
	APMIXED_BASE		= IO_PHYS + 0x0000C000,
	PMIF_SPI_BASE		= IO_PHYS + 0x00026000,
	PMIF_SPMI_BASE		= IO_PHYS + 0x00027000,
	PMICSPI_MST_BASE	= IO_PHYS + 0x00028000,
	SPMI_MST_BASE		= IO_PHYS + 0x00029000,
	AUXADC_BASE		= IO_PHYS + 0x01001000,
	UART0_BASE		= IO_PHYS + 0x01002000,
	SPI0_BASE		= IO_PHYS + 0x0100A000,
	SPI1_BASE		= IO_PHYS + 0x01010000,
	SPI2_BASE		= IO_PHYS + 0x01012000,
	SPI3_BASE		= IO_PHYS + 0x01013000,
	SPI4_BASE		= IO_PHYS + 0x01018000,
	SPI5_BASE		= IO_PHYS + 0x01019000,
	SPI6_BASE		= IO_PHYS + 0x0101D000,
	SPI7_BASE		= IO_PHYS + 0x0101E000,
	SSUSB_IPPC_BASE		= IO_PHYS + 0x01203e00,
	SFLASH_REG_BASE		= IO_PHYS + 0x01234000,
	EFUSEC_BASE		= IO_PHYS + 0x01C10000,
	IOCFG_RM_BASE		= IO_PHYS + 0x01C20000,
	IOCFG_BM_BASE		= IO_PHYS + 0x01D10000,
	IOCFG_BL_BASE		= IO_PHYS + 0x01D30000,
	IOCFG_BR_BASE		= IO_PHYS + 0x01D40000,
	IOCFG_LM_BASE		= IO_PHYS + 0x01E20000,
	SSUSB_SIF_BASE		= IO_PHYS + 0x01E40300,
	IOCFG_LB_BASE		= IO_PHYS + 0x01E70000,
	IOCFG_RT_BASE		= IO_PHYS + 0x01EA0000,
	IOCFG_LT_BASE		= IO_PHYS + 0x01F20000,
	IOCFG_TL_BASE		= IO_PHYS + 0x01F30000,
	MSDC0_TOP_BASE		= IO_PHYS + 0x01F50000,
	MSDC0_BASE		= IO_PHYS + 0x01F60000,
};

#endif
