---
title: Dell OptiPlex 3050 Micro
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../../news/safety.md),
OR YOU MIGHT BRICK YOUR MACHINE: [SAFETY PRECAUTIONS](../../news/safety.md)**

<div class="specs">
<center>
<img tabindex=1 alt="Dell OptiPlex 3050 Micro" class="p" src="https://av.libreboot.org/3050micro/3050micro.jpg" /><span class="f"><img src="https://av.libreboot.org/3050micro/3050micro.jpg" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | Dell                                           |
| **Name**                   | OptiPlex 3050 Micro                                |
| **Variants**               | OptiPlex 3050 Micro                                |
| **Released**               | 2017                                           |
| **Chipset**                | Intel Kaby Lake                                     |
| **CPU**                    | Intel Kaby Lake                               |
| **Graphics**               | Intel HD graphics |
| **Memory**                 | DDR4 SODIMMs (max 32GB, 2x16GB)    |
| **Architecture**           | x86\_64                                         |
| **Original boot firmware** | Dell UEFI firmware                             |
| **Intel ME/AMD PSP**       | Present. Can be disabled with me\_cleaner.      |
| **Flash chip**             | SOIC-16 and/or SOIC-8 12MiB (96Mbit)           |


```
W+: Works without blobs; 
N: Doesn't work; 
W*: Works with blobs; 
U: Untested; 
P+: Partially works; 
P*: Partially works with blobs
?: UNKNOWN AT THIS TIME
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | W+ |
| **Display (if Intel GPU)**                        | W+ |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |

| ***Payloads supported***   |           |
|----------------------------|-----------|
| **GRUB (libgfxinit only)** | Works     |
| **SeaBIOS**                | Broken    |
</div>
Introduction
============

**Unavailable in Libreboot 20240612 or earlier. You must [compile from
source](../build/), or use a version newer than Libreboot 20240612.**

Official information about the computer can be found here:
<https://www.dell.com/support/manuals/en-uk/optiplex-3050-micro/optiplex_3050-mff_om/processor-specifications?guid=guid-8ca53ab2-a85d-42d5-9106-5214220306aa&lang=en-us>

Build ROM image from source
---------------------------

The build target, when building from source, is thus:

	./mk -b coreboot dell3050micro_fsp_16mb

Mate Kukri's *deguard* utility disables the Intel Boot Guard on this
machine. Libreboot uses this by default, along with `me_cleaner` to provide
a neutered ME setup; unlike on other platforms, arbitrary code execution is also
possible inside the ME on this mainboard, giving it much higher potential for
software freedom in the future.

Issues
======

Before flashing, you must know that this board is still a work-in-progress. It
is using this patchset from the author, Mate Kukri:

<https://review.coreboot.org/c/coreboot/+/82053> (libreboot uses patch set 14)

Issues, as per Libreboot's testing, are as follows:

* Although USB ports seem to work, the Gerrit page linked above says that the
  config is incorrect; need to investigate.
* HDA Verb: Libreboot patches the board to support this, which fixes the
  headphone jack among other things.
* VBT: Libreboot patches the board to support this, though it's largely
  optional on Linux/BSD.
* ACPI-based shutdown seems to falter a lot; sometimes the board will not turn
  off after shut down, so you have hold the button down. Also, the button does
  not seem to signal the OS that a shutdown must occur.
* PWM fan controls broken, so the system always run in a low-rpm state, even
  under stress conditions, which could lead to overheating under stress.

To mitigate the PWM bug, simply cut the blue wire on the fan connector, and
cut the red wire but jump the cut (on red) with a 10ohm resistor or so; cutting
the blue one bypasses PWM, so the fan runs at full speed (very loud), and the
red wire powers it, so the resistor on the red wire will slow the fan down, but
leave it running faster than on idle. You can also cap the CPU speed however you
wish, via the `intel_pstate` driver.

If you're using a 10ohm resistor on the fan power, make sure it's at least a 2W
one.

Note that HDMI audio *does* work, but you have to select it in your audio
server e.g. pipewire. The `pavucontrol` utility in Linux (with pipewire) lets
you have a lot of control over audio I/O. Libreboot patches the board to add
a verb, so headphones should work.

Installation
============

Insert binary files
-------------------

If you're using a release ROM, please ensure that you've inserted extra firmware
required refer to the [guide](../install/ivy_has_common.md) for that. (failure
to adhere to this advice will result in a bricked machine)

Libreboot's build system automatically downloads and processes these files if
you build Libreboot from source, but the same logic that it uses must be re-run
if you're using a release image.

MAC address
-----------

This has a realtek NIC inside, instead of Intel, so the MAC address will not
change. This means: there is no GbE region in the flash.

You can still use something like GNU MAC Changer to change your MAC address
from Linux if you want to.

Flash a ROM image (software)
-----------------

If you're already running Libreboot, and you don't have flash protection
turned on, [internal flashing](../install/) is possible.

<img tabindex=1 alt="Dell OptiPlex 3050 Micro service jumper" class="p" src="https://av.libreboot.org/3050micro/fdo.jpg" /><span class="f"><img src="https://av.libreboot.org/3050micro/fdo.jpg" /></span>

If you have factory firmware (Dell), you can short the service jumper. It's
near the RAM, under where the HDD goes (click the photos shown above).
Just put a short on it when booting,
and all flash protection is disabled; the factory firmware write might EFI
variables to flash during shutdown sequence, so you should *pull the plug* to
shut it down (remove the power by pulling the plug) after flashprog
says `VERIFIED`.

Flash a ROM image (hardware)
-----------------

For general information, please refer to [25xx NOR flash
instructions](../install/spi.md) - that page refers to use of socketed flash.

The side cover comes off easily, and you can find the flash ICs next to the RAM.
Simply remove the screw at the back. The top panel then slides forward, and you
can remove the SSD caddy; from then on, the flash is accossible.

Observe the following photo of the flash (SOIC-8):

<img tabindex=1 alt="Dell OptiPlex 3050 Micro flash IC" class="p" src="https://av.libreboot.org/3050micro/flash.jpg" /><span class="f"><img src="https://av.libreboot.org/3050micro/flash.jpg" /></span>

You can otherwise flash internally, including from factory firmware(if the
service jumper is set).
