---
title: HP EliteBook 2170p
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../../news/safety.md),
OR YOU MIGHT BRICK YOUR MACHINE: [SAFETY PRECAUTIONS](../../news/safety.md)**

<div class="specs">
<center>
<img tabindex=1 alt="HP EliteBook 2170p" class="p" src="https://av.libreboot.org/hp2170p/hp2170p.jpg" /><span class="f"><img src="https://av.libreboot.org/hp2170p/hp2170p.jpg" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | HP                                             |
| **Name**                   | EliteBook 2170p                                |
| **Variants**               | EliteBook 2170p                                |
| **Released**               | 2012                                           |
| **Chipset**                | Intel QM77                                     |
| **CPU**                    | Intel Ivy Bridge ULV                           |
| **Graphics**               | Intel HD Graphics 4000                         | 
| **Display**                | 1366x768 11.6" TFT                             |
| **Memory**                 | Two slots, max 8GB/slot (2x16GB), DDR3/sodimm  |
| **Architecture**           | x86_64                                         |
| **EC**                     | SMSC KBC1126, proprietary (in main boot flash) |
| **Original boot firmware** | HP UEFI firmware                               |
| **Intel ME/AMD PSP**       | Present. Can be disabled with me_cleaner.      |
| **Flash chip**             | SOIC-8 16MiB (128Mbit), in a socket            |


```
W+: Works without blobs; 
N: Doesn't work; 
W*: Works with blobs; 
U: Untested; 
P+: Partially works; 
P*: Partially works with blobs
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | N  |
| **Display (if Intel GPU)**                        | W+ |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |
| **External output**                               | W+ |
| **Display brightness**                            | W+ | 

| ***Payloads supported***  |           |
|---------------------------|-----------|
| **GRUB**                  | Works     |
| **SeaBIOS**               | Works     |
| **SeaBIOS with GRUB**     | Works     |
</div>
Introduction
============

This is a portable, 11.6" Ivy Bridge platform from HP. More information is
available on the [coreboot
documentation](https://doc.coreboot.org/mainboard/hp/2170p.html) - that page
said (on 16 August 2023) that GRUB hangs due to the `at_keyboard` module, but
this is no longer true; it's
[fixed](https://git.savannah.gnu.org/cgit/grub.git/commit/?id=830456a6e3b6ac92d10f9261177722a308652a1a)
in the latest GRUB revisions, and Libreboot's version of GRUB contains this fix.

**Unavailable in Libreboot 20230625 or earlier. You must [compile from
source](../build/), or use at least Libreboot 20231021.**

Build ROM image from source
---------------------------

The build target, when building from source, is thus:

	./mk -b coreboot hp2170p_16mb

Installation
============

Insert binary files
-------------------

If you're using a release ROM, please ensure that you've inserted extra firmware
required refer to the [guide](../install/ivy_has_common.md) for that. (failure
to adhere to this advice will result in a bricked machine)

Set MAC address
---------------

This platform uses an Intel Flash Descriptor, and defines an Intel GbE NVM
region. As such, release/build ROMs will contain the same MAC address. To
change the MAC address, please read [nvmutil documentation](../install/nvmutil.md).

Flash a ROM image (software)
-----------------

If you're already running Libreboot, and you don't have flash protection
turned on, [internal flashing](../install/) is possible.

Flash a ROM image (hardware)
-----------------

**REMOVE all power sources like battery, charger and so on, before doing this.
This is to prevent short circuiting and power surges while flashing; although
the flash is socketed, hot-swapping is generally a bad practise and must be
avoided.**

Otherwise, external flashing is simple, but *quite different* from most
laptops! The flash is a SOIC8 IC like you'd expect, but it's *in a socket*.

Remove those two screws and cover on the underside, and then the flash is in
this socket which you can open:

<img tabindex=1 class="l" src="https://av.libreboot.org/hp2170p/hp2170p_cover.jpg" /><span class="f"><img src="https://av.libreboot.org/hp2170p/hp2170p_cover.jpg" /></span>
<img tabindex=1 class="l" src="https://av.libreboot.org/hp2170p/hp2170p_socket.jpg" /><span class="f"><img src="https://av.libreboot.org/hp2170p/hp2170p_socket.jpg" /></span>

For general information, please refer to [25xx NOR flash
instructions](../install/spi.md) - that page refers to use of socketed flash.

For this board, you can use a Raspberry Pi or similar flasher if you wish, wired
to a spring socket adapter (SOP to DIP adapter) in a breadboard. In my case, I
opted for use of a 3.3v-modded CH341A device.

<img tabindex=1 class="l" style="clear:left;" src="https://av.libreboot.org/hp2170p/ch341a_socket_soic8.jpg" /><span class="f"><img src="https://av.libreboot.org/hp2170p/ch341a_socket_soic8.jpg" /></span>

Here, the flash is inserted into the SOP to DIP adapter, which is then put into
the ZIF socket on the CH341a device. This is the black version which has 5V
logic levels, but it can (read: MUST) be modified for correct 3.3v logic levels.
The [main 25xx flashing guide](../install/spi.md) documents this; some other
models may already be 3.3v, or have switchable logic levels like on some newer
revisions of CH341A. Please ensure that you run it at the correct voltage.

![HP EliteBook 2170p success](https://av.libreboot.org/hp2170p/hp2170p.jpg)
