/** @file

  @copyright
  Copyright (C) 2023 Intel Corporation

  SPDX-License-Identifier: BSD-2-Clause-Patent

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPTUPD_H__
#define __FSPTUPD_H__

#include <FspUpd.h>

#pragma pack(1)


/** FSP-T Core UPD
**/
typedef struct {

/** Offset 0x0020
**/
  UINT32                      MicrocodeRegionBase;

/** Offset 0x0024
**/
  UINT32                      MicrocodeRegionLength;

/** Offset 0x0028
**/
  UINT32                      CodeRegionBase;

/** Offset 0x002C
**/
  UINT32                      CodeRegionLength;

/** Offset 0x0030
**/
  UINT8                       Reserved1[16];
} FSPT_CORE_UPD;

/** FSP-T Configuration
**/
typedef struct {

/** Offset 0x0040 - Disable Port80 output in FSP-T
  Select Port80 Control in FSP-T - 0:VPD-Style, <b>1:Enable Port80 Output (Default)</b>,
  2:Disable Port80 Output, refer to FSP Integration Guide for details.
  0:VPD-Style, 1:Enable Port80 Output[Default], 2:Disable Port80 Output
**/
  UINT8                       FsptPort80RouteDisable;

/** Offset 0x0041
**/
  UINT8                       ReservedTempRamInitUpd[31];
} FSPT_CONFIG;

/** Fsp T UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPT_CORE_UPD               FsptCoreUpd;

/** Offset 0x0040
**/
  FSPT_CONFIG                 FsptConfig;

/** Offset 0x0060
**/
  UINT8                       UnusedUpdSpace0[6];

/** Offset 0x0066
**/
  UINT16                      UpdTerminator;
} FSPT_UPD;

#pragma pack()

#endif
